.TH ZABBIX_SENDER 8 "16 October 2015"
.if n .ad l
.SH NAME
zabbix_sender \- Zabbix sender utility.
.SH SYNOPSIS
.B zabbix_sender [-hpzvIV] {-kso | [-T] -i \fI<inputfile>\fB} [-c \fI<config-file>\fB]
.SH DESCRIPTION
.B zabbix_sender
is a command line utility for sending performance data to a remote Zabbix server. On the Zabbix server an item of type \fBZabbix trapper\fR should be created with corresponding key. Note that incoming values will only be accepted from hosts specified in \fBAllowed hosts\fR field for this item.

.SS Options
.IP "-c, --config \fI<config-file>\fR"
Use \fIconfig-file\fR. Zabbix sender reads server details from the agent configuration file. By default Zabbix sender does not read any configuration file.
Absolute path should be specified. Only parameters \fBHostname\fR, \fBServerActive\fR and \fBSourceIP\fR are supported. First entry from the \fBServerActive\fR parameter is used.
.IP "-z, --zabbix-server \fI<server>\fR"
Hostname or IP address of Zabbix server. If a host is monitored by a proxy, proxy hostname or IP address should be used instead.
.IP "-p, --port \fI<port>\fR"
Specify port number of server trapper running on the server. Default is 10051.
.IP "-s, --host \fI<host>\fR"
Specify agent hostname as registered in Zabbix frontend. Host IP address and DNS name will not work.
.IP "-I, --source-address \fI<IP>\fR"
Specify source IP address.
.IP "-k, --key \fI<key>\fR"
Specify item key to send value to.
.IP "-o, --value \fI<value>\fR"
Specify value.
.IP "-i, --input-file \fI<inputfile>\fR"

Load values from input file. Specify \fB-\fR as <inputfile> to read values from standard input.

Each value must be specified on its own line. Each line must contain 3 whitespace delimited entries: \fB<hostname> <key> <value>\fR, where "hostname" is the name of monitored host as registered in Zabbix frontend, "key" is target item key and "value" - the value to send. Specify \fB-\fR as \fB<hostname>\fR to use hostname from agent configuration file or from \fB--host\fR argument.

An example of a line of an input file:

\fB "Linux DB3" db.connections 43\fR

The value type must be correctly set in item configuration of Zabbix frontend. Zabbix sender will send up to 250 values in one connection. Contents of the input file must be in the UTF-8 encoding. All values from the input file are sent in a sequential order top-down. Entries must be formatted using the following rules:

.RS
.RS
.IP \[bu] 2
Quoted and non-quoted entries are supported.
.IP \[bu]
Double-quote is the quoting character.
.IP \[bu]
Entries with whitespace must be quoted.
.IP \[bu]
Double-quote and backslash characters inside quoted entry must be escaped with a backslash.
.IP \[bu]
Escaping is not supported in non-quoted entries.
.IP \[bu]
Linefeed escape sequences (\\n) are supported in quoted strings.
.IP \[bu]
Linefeed escape sequences are trimmed from the end of an entry.
.RE

.RE

.IP "-T, --with-timestamps"

This option can be only used with \fB--input-file\fR option.

Each line of the input file must contain 4 whitespace delimited entries: \fB<hostname> <key> <timestamp> <value>\fR. Timestamp should be specified in Unix timestamp format. If target item has triggers referencing it, all timestamps must be in an increasing order, otherwise event calculation will not be correct.

An example of a line of the input file:

\fB "Linux DB3" db.connections 1429533600 43\fR

For more details please see option \fB--input-file\fR.

.IP "-r, --real-time"
Send values one by one as soon as they are received. This can be used when reading from standard input.
.IP "-v, --verbose"
Verbose mode, -vv for more details.
.IP "-h, --help"
Display this help and exit.
.IP "-V, --version"
Output version information and exit.

.SH "EXIT STATUS"
The exit status is 0 if the values were sent and all of them were successfully processed by server.
If data was sent, but processing of at least one of the values failed, the exit status is 2.
If data sending failed, the exit status is 1.

.SH "EXAMPLES"
.B zabbix_sender -c /etc/zabbix/zabbix_agentd.conf -s """Monitored Host""" -k mysql.queries -o 342.45

Send \fB342.45\fR as the value for \fBmysql.queries\fR key in \fBMonitored Host\fR host using Zabbix server defined in agent daemon configuration file.

.B zabbix_sender -z 192.168.1.113 -i data_values.txt

Send values from file \fBdata_values.txt\fR to server with IP \fB192.168.1.113\fR. Host names and keys are defined in the file.

.B echo """- hw.serial.number 1287872261 SQ4321ASDF""" | zabbix_sender -c /usr/local/etc/zabbix_agentd.conf -T -i -

Send a timestamped value from the commandline to Zabbix server, specified in the agent daemon configuration file. Dash in the input data indicates that hostname also should be used from the same configuration file.

.B echo '"Zabbix server" trapper.item \&"\&"' | zabbix_sender -z 192.168.1.113 -p 10000 -i -

Send empty value of an item to the Zabbix server with IP address \fB192.168.1.113\fR on port \fB10000\fR from the commandline. Empty values must be indicated by empty double quotes.

.SH "SEE ALSO"
.BR zabbix_agentd (8),
.BR zabbix_get (8),
.BR zabbix_proxy (8),
.BR zabbix_server (8)
.SH AUTHOR
Alexei Vladishev <alex@zabbix.com>
