/*------------------------------------------------------------------------------
*
* Copyright (c) 2011-2017, EURid. All rights reserved.
* The YADIFA TM software product is provided under the BSD 3-clause license:
* 
* Redistribution and use in source and binary forms, with or without 
* modification, are permitted provided that the following conditions
* are met:
*
*        * Redistributions of source code must retain the above copyright 
*          notice, this list of conditions and the following disclaimer.
*        * Redistributions in binary form must reproduce the above copyright 
*          notice, this list of conditions and the following disclaimer in the 
*          documentation and/or other materials provided with the distribution.
*        * Neither the name of EURid nor the names of its contributors may be 
*          used to endorse or promote products derived from this software 
*          without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
*
*------------------------------------------------------------------------------
*
*/
/** @defgroup 
 *  @ingroup yadifad
 *  @brief 
 *
 *  
 *
 * @{
 *
 *----------------------------------------------------------------------------*/
#ifndef _NOTIFY_H
#define _NOTIFY_H

#include "server-config.h"

#if HAS_CTRL
#include "ctrl.h"
#endif

#include <dnscore/message.h>
#include "database.h"
#include <dnscore/host_address.h>

/**
 *  @brief Handle a notify from the master (or another slave)
 *
 *  @param database : the database
 *  @param mesg     : the input message
 *
 *  @retval OK
 *  @retval NOK
 */

ya_result notify_process(message_data *msg);

/**
 * Sends a notify to all the slave for a given domain name
 * 
 * @param origin
 */

void notify_slaves(const u8 *origin);

/**
 * Stops all notification for zone with origin
 * 
 * @param origin
 */

void notify_clear(const u8 *origin);

/**
 * Sends a notify to all the slave in the list for the specified zone and class
 * 
 * @param zone_desc the zone descriptor
 * @param hosts the host list that will be destroyed by the callee
 * @param zclass the class for the query
 */

void notify_host_list(zone_desc_s *zone_desc, host_address *hosts, u16 zclass);

ya_result notify_service_init();

/**
 * Starts the notify service thread
 */

ya_result notify_service_start();

/**
 * Stops the notify service thread
 */

ya_result notify_service_stop();

ya_result notify_service_finalise();

#endif /* _NOTIFY_H */

/*    ------------------------------------------------------------    */

/** @} */

/*----------------------------------------------------------------------------*/

