/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.office.OfficeReader;
import writer2latex.office.PropertySet;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.NoteConverter;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.XhtmlConfig;

class FootnoteConverter
extends NoteConverter {
    private boolean bFootnotesAtPage = true;

    FootnoteConverter(OfficeReader ofr, XhtmlConfig config, Converter converter) {
        super(ofr, config, converter, ofr.getFootnotesConfiguration());
        PropertySet configuration = ofr.getFootnotesConfiguration();
        if (configuration != null) {
            this.bFootnotesAtPage = !"document".equals(configuration.getProperty("text:footnotes-position"));
        }
    }

    void insertFootnotes(Node hnode, boolean bFinal) {
        if (this.hasNotes()) {
            if (this.bFootnotesAtPage) {
                Element section = this.createNoteSection(hnode, "footnotes");
                Element rule = this.converter.createElement("hr");
                StyleInfo info = new StyleInfo();
                this.getPageSc().applyFootnoteRuleStyle(info);
                this.getPageSc().applyStyle(info, rule);
                section.appendChild(rule);
                this.flushNotes(section, "footnote");
            } else if (bFinal) {
                if (this.config.getXhtmlSplitLevel() > 0) {
                    hnode = this.converter.nextOutFile();
                }
                Element section = this.createNoteSection(hnode, "footnotes");
                this.insertNoteHeading(section, this.config.getFootnotesHeading(), "footnotes");
                this.flushNotes(section, "footnote");
            }
        }
    }
}

