#ifndef DYNAMITEproteindbHEADERFILE
#define DYNAMITEproteindbHEADERFILE
#ifdef _cplusplus
extern "C" {
#endif
#include "sequencedb.h"
#include "hscore.h"
#include "complexsequence.h"
#include "complexevalset.h"
#include "randommodel.h"
#include "randomdb.h"
#include "protein.h"

/* Object ProteinDB
 *
 * Descrip: A database of proteins. This takes
 *        either a single sequence or a 
 *        sequence database and allows a
 *        method expecting protein complexsequences
 *        to loop over it.
 *
 *        It also provides generic database indexing
 *        for this
 *
 *
 *        Horrible physical dependency in this
 *        generated by the random protein db
 *        requiring histogram and randommodel
 *        stuff. Yuk!
 *
 *
 */
struct Wise2_ProteinDB {  
    int dynamite_hard_link;  
#ifdef PTHREAD   
    pthread_mutex_t dynamite_mutex;  
#endif   
    boolean is_single_seq;   
    boolean is_random_db;    
    ComplexSequence * single;    
    SequenceDB * sdb;    
    ComplexSequenceEvalSet * cses;   
    RandomProteinDB * rnd;   
    boolean test_dna;    
    } ;  
/* ProteinDB defined */ 
#ifndef DYNAMITE_DEFINED_ProteinDB
typedef struct Wise2_ProteinDB Wise2_ProteinDB;
#define ProteinDB Wise2_ProteinDB
#define DYNAMITE_DEFINED_ProteinDB
#endif




    /***************************************************/
    /* Callable functions                              */
    /* These are the functions you are expected to use */
    /***************************************************/



/* Function:  show_Hscore_ProteinDB(hs,ofp)
 *
 * Descrip:    shows the Hscore by the ProteinDB information
 *
 *
 *
 * Arg:         hs [UNKN ] High Score structure [Hscore *]
 * Arg:        ofp [UNKN ] output file [FILE *]
 *
 */
void Wise2_show_Hscore_ProteinDB(Hscore * hs,FILE * ofp);
#define show_Hscore_ProteinDB Wise2_show_Hscore_ProteinDB


/* Function:  get_Protein_from_ProteinDB(prodb,de)
 *
 * Descrip:    Gets Protein sequence out from
 *             the proteindb using the information stored in
 *             dataentry
 *
 *
 * Arg:        prodb [READ ] ProteinDB database [ProteinDB *]
 * Arg:           de [READ ] DataEntry information  [DataEntry *]
 *
 * Return [UNKN ]  Undocumented return value [Protein *]
 *
 */
Protein * Wise2_get_Protein_from_ProteinDB(ProteinDB * prodb,DataEntry * de);
#define get_Protein_from_ProteinDB Wise2_get_Protein_from_ProteinDB


/* Function:  dataentry_add_ProteinDB(de,cs,prodb)
 *
 * Descrip:    adds information to dataentry from ProteinDB
 *
 *             This information is the necessary information for
 *             the proteindb to find this sequence later
 *
 *
 * Arg:           de [UNKN ] Undocumented argument [DataEntry *]
 * Arg:           cs [UNKN ] Undocumented argument [ComplexSequence *]
 * Arg:        prodb [UNKN ] Undocumented argument [ProteinDB *]
 *
 * Return [UNKN ]  Undocumented return value [boolean]
 *
 */
boolean Wise2_dataentry_add_ProteinDB(DataEntry * de,ComplexSequence * cs,ProteinDB * prodb);
#define dataentry_add_ProteinDB Wise2_dataentry_add_ProteinDB


/* Function:  init_ProteinDB(prodb,return_status)
 *
 * Descrip:    top level function which opens the protein database
 *
 *
 * Arg:                prodb [UNKN ] protein database [ProteinDB *]
 * Arg:        return_status [WRITE] the status of the open from database.h [int *]
 *
 * Return [UNKN ]  Undocumented return value [ComplexSequence *]
 *
 */
ComplexSequence * Wise2_init_ProteinDB(ProteinDB * prodb,int * return_status);
#define init_ProteinDB Wise2_init_ProteinDB


/* Function:  reload_ProteinDB(last,prodb,return_status)
 *
 * Descrip:    function which reloads the database
 *
 *
 * Arg:                 last [UNKN ] previous complex sequence, will be freed [ComplexSequence *]
 * Arg:                prodb [UNKN ] Undocumented argument [ProteinDB *]
 * Arg:        return_status [WRITE] return_status of the load [int *]
 *
 * Return [UNKN ]  Undocumented return value [ComplexSequence *]
 *
 */
ComplexSequence * Wise2_reload_ProteinDB(ComplexSequence * last,ProteinDB * prodb,int * return_status);
#define reload_ProteinDB Wise2_reload_ProteinDB


/* Function:  close_ProteinDB(cs,prodb)
 *
 * Descrip:    top level function which closes the protein database
 *
 *
 * Arg:           cs [UNKN ] last complex sequence  [ComplexSequence *]
 * Arg:        prodb [UNKN ] protein database [ProteinDB *]
 *
 * Return [UNKN ]  Undocumented return value [boolean]
 *
 */
boolean Wise2_close_ProteinDB(ComplexSequence * cs,ProteinDB * prodb) ;
#define close_ProteinDB Wise2_close_ProteinDB


/* Function:  new_ProteinDB_from_single_seq(seq)
 *
 * Descrip:    To make a new protein database
 *             from a single Sequence with default amino acid mapping
 *
 *
 * Arg:        seq [UNKN ] sequence which as placed into ProteinDB structure. [Sequence *]
 *
 * Return [UNKN ]  Undocumented return value [ProteinDB *]
 *
 */
ProteinDB * Wise2_new_ProteinDB_from_single_seq(Sequence * seq);
#define new_ProteinDB_from_single_seq Wise2_new_ProteinDB_from_single_seq


/* Function:  new_ProteinDB_from_single_cseq(cs)
 *
 * Descrip:    To make a new protein database
 *             from a single ComplexSequence
 *
 *
 * Arg:        cs [UNKN ] complex sequence which is held. [ComplexSequence *]
 *
 * Return [UNKN ]  Undocumented return value [ProteinDB *]
 *
 */
ProteinDB * Wise2_new_ProteinDB_from_single_cseq(ComplexSequence * cs);
#define new_ProteinDB_from_single_cseq Wise2_new_ProteinDB_from_single_cseq


/* Function:  single_fasta_ProteinDB(filename)
 *
 * Descrip:    pre-packed single fasta protein database
 *
 *
 *
 * Arg:        filename [UNKN ] name of fasta file [char *]
 *
 * Return [UNKN ]  Undocumented return value [ProteinDB *]
 *
 */
ProteinDB * Wise2_single_fasta_ProteinDB(char * filename);
#define single_fasta_ProteinDB Wise2_single_fasta_ProteinDB


/* Function:  new_ProteinDB(seqdb,cses)
 *
 * Descrip:    To make a new protein database
 *
 *
 * Arg:        seqdb [UNKN ] sequence database [SequenceDB *]
 * Arg:         cses [UNKN ] protein evaluation set [ComplexSequenceEvalSet *]
 *
 * Return [UNKN ]  Undocumented return value [ProteinDB *]
 *
 */
ProteinDB * Wise2_new_ProteinDB(SequenceDB * seqdb,ComplexSequenceEvalSet * cses);
#define new_ProteinDB Wise2_new_ProteinDB


/* Function:  hard_link_ProteinDB(obj)
 *
 * Descrip:    Bumps up the reference count of the object
 *             Meaning that multiple pointers can 'own' it
 *
 *
 * Arg:        obj [UNKN ] Object to be hard linked [ProteinDB *]
 *
 * Return [UNKN ]  Undocumented return value [ProteinDB *]
 *
 */
ProteinDB * Wise2_hard_link_ProteinDB(ProteinDB * obj);
#define hard_link_ProteinDB Wise2_hard_link_ProteinDB


/* Function:  ProteinDB_alloc(void)
 *
 * Descrip:    Allocates structure: assigns defaults if given 
 *
 *
 *
 * Return [UNKN ]  Undocumented return value [ProteinDB *]
 *
 */
ProteinDB * Wise2_ProteinDB_alloc(void);
#define ProteinDB_alloc Wise2_ProteinDB_alloc


/* Function:  free_ProteinDB(obj)
 *
 * Descrip:    Free Function: removes the memory held by obj
 *             Will chain up to owned members and clear all lists
 *
 *
 * Arg:        obj [UNKN ] Object that is free'd [ProteinDB *]
 *
 * Return [UNKN ]  Undocumented return value [ProteinDB *]
 *
 */
ProteinDB * Wise2_free_ProteinDB(ProteinDB * obj);
#define free_ProteinDB Wise2_free_ProteinDB


  /* Unplaced functions */
  /* There has been no indication of the use of these functions */


    /***************************************************/
    /* Internal functions                              */
    /* you are not expected to have to call these      */
    /***************************************************/
boolean Wise2_replace_is_single_seq_ProteinDB(ProteinDB * obj,boolean is_single_seq);
#define replace_is_single_seq_ProteinDB Wise2_replace_is_single_seq_ProteinDB
SequenceDB * Wise2_access_sdb_ProteinDB(ProteinDB * obj);
#define access_sdb_ProteinDB Wise2_access_sdb_ProteinDB
boolean Wise2_access_is_single_seq_ProteinDB(ProteinDB * obj);
#define access_is_single_seq_ProteinDB Wise2_access_is_single_seq_ProteinDB
boolean Wise2_replace_cses_ProteinDB(ProteinDB * obj,ComplexSequenceEvalSet * cses);
#define replace_cses_ProteinDB Wise2_replace_cses_ProteinDB
boolean Wise2_access_is_random_db_ProteinDB(ProteinDB * obj);
#define access_is_random_db_ProteinDB Wise2_access_is_random_db_ProteinDB
ComplexSequenceEvalSet * Wise2_access_cses_ProteinDB(ProteinDB * obj);
#define access_cses_ProteinDB Wise2_access_cses_ProteinDB
ComplexSequence * Wise2_access_single_ProteinDB(ProteinDB * obj);
#define access_single_ProteinDB Wise2_access_single_ProteinDB
boolean Wise2_replace_rnd_ProteinDB(ProteinDB * obj,RandomProteinDB * rnd);
#define replace_rnd_ProteinDB Wise2_replace_rnd_ProteinDB
boolean Wise2_replace_is_random_db_ProteinDB(ProteinDB * obj,boolean is_random_db);
#define replace_is_random_db_ProteinDB Wise2_replace_is_random_db_ProteinDB
RandomProteinDB * Wise2_access_rnd_ProteinDB(ProteinDB * obj);
#define access_rnd_ProteinDB Wise2_access_rnd_ProteinDB
boolean Wise2_replace_sdb_ProteinDB(ProteinDB * obj,SequenceDB * sdb);
#define replace_sdb_ProteinDB Wise2_replace_sdb_ProteinDB
boolean Wise2_replace_test_dna_ProteinDB(ProteinDB * obj,boolean test_dna);
#define replace_test_dna_ProteinDB Wise2_replace_test_dna_ProteinDB
boolean Wise2_replace_single_ProteinDB(ProteinDB * obj,ComplexSequence * single);
#define replace_single_ProteinDB Wise2_replace_single_ProteinDB
boolean Wise2_access_test_dna_ProteinDB(ProteinDB * obj);
#define access_test_dna_ProteinDB Wise2_access_test_dna_ProteinDB

#ifdef _cplusplus
}
#endif

#endif
