(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import ZArith.
Require Import Rbase.
Definition unit  := unit.

Parameter mark : Type.

Parameter at1: forall (a:Type), a -> mark  -> a.

Implicit Arguments at1.

Parameter old: forall (a:Type), a  -> a.

Implicit Arguments old.

Parameter t : Type.

Parameter f: t  -> t.


Parameter x0:  t.


Parameter iter: Z -> t  -> t.


Axiom iter_0 : forall (x:t), ((iter 0%Z x) = x).

Axiom iter_s : forall (k:Z) (x:t), (0%Z <  k)%Z -> ((iter k
  x) = (iter (k - 1%Z)%Z (f x))).

Axiom iter_1 : forall (x:t), ((iter 1%Z x) = (f x)).

Axiom iter_s2 : forall (k:Z) (x:t), (0%Z <  k)%Z -> ((iter k
  x) = (f (iter (k - 1%Z)%Z x))).

Parameter mu:  Z.


Parameter lambda:  Z.


Axiom mu_range : (0%Z <= (mu ))%Z.

Axiom lambda_range : (1%Z <= (lambda ))%Z.

Axiom distinct : forall (i:Z) (j:Z), ((0%Z <= i)%Z /\
  (i <  ((mu ) + (lambda ))%Z)%Z) -> (((0%Z <= j)%Z /\
  (j <  ((mu ) + (lambda ))%Z)%Z) -> ((~ (i = j)) -> ~ ((iter i
  (x0 )) = (iter j (x0 ))))).

Axiom cycle : forall (n:Z), ((mu ) <= n)%Z -> ((iter (n + (lambda ))%Z
  (x0 )) = (iter n (x0 ))).

Theorem cycle_induction : forall (n:Z), ((mu ) <= n)%Z -> forall (k:Z),
  (0%Z <= k)%Z -> ((iter (n + ((lambda ) * k)%Z)%Z (x0 )) = (iter n (x0 ))).
(* YOU MAY EDIT THE PROOF BELOW *)
intros n hn.
apply natlike_ind.
ring_simplify (n + lambda * 0)%Z; auto.
intros.
unfold Zsucc.
replace (n + lambda * (x + 1))%Z with ((n+lambda*x)+lambda)%Z by ring.
rewrite cycle; auto.
assert (0 <= lambda * x)%Z.
apply Zmult_le_0_compat; (generalize lambda_range; omega).
omega.
Qed.
(* DO NOT EDIT BELOW *)


