(* This file is generated by Why3's Coq 8.4 driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require map.Map.

(* Why3 assumption *)
Definition unit := unit.

(* Why3 assumption *)
Inductive ref (a:Type) {a_WT:WhyType a} :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a] [a_WT]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a} (v:(@ref a a_WT)): a :=
  match v with
  | (mk_ref x) => x
  end.

(* Why3 assumption *)
Inductive array
  (a:Type) {a_WT:WhyType a} :=
  | mk_array : Z -> (@map.Map.map Z _ a a_WT) -> array a.
Axiom array_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (array a).
Existing Instance array_WhyType.
Implicit Arguments mk_array [[a] [a_WT]].

(* Why3 assumption *)
Definition elts {a:Type} {a_WT:WhyType a} (v:(@array a a_WT)): (@map.Map.map
  Z _ a a_WT) := match v with
  | (mk_array x x1) => x1
  end.

(* Why3 assumption *)
Definition length {a:Type} {a_WT:WhyType a} (v:(@array a a_WT)): Z :=
  match v with
  | (mk_array x x1) => x
  end.

(* Why3 assumption *)
Definition get {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT)) (i:Z): a :=
  (map.Map.get (elts a1) i).

(* Why3 assumption *)
Definition set {a:Type} {a_WT:WhyType a} (a1:(@array a a_WT)) (i:Z)
  (v:a): (@array a a_WT) := (mk_array (length a1) (map.Map.set (elts a1) i
  v)).

(* Why3 assumption *)
Definition make {a:Type} {a_WT:WhyType a} (n:Z) (v:a): (@array a a_WT) :=
  (mk_array n (map.Map.const v:(@map.Map.map Z _ a a_WT))).

(* Why3 assumption *)
Definition decrease1 (a:(@array Z _)): Prop := forall (i:Z), ((0%Z <= i)%Z /\
  (i < ((length a) - 1%Z)%Z)%Z) -> (((get a i) - 1%Z)%Z <= (get a
  (i + 1%Z)%Z))%Z.

(* Why3 goal *)
Theorem decrease1_induction : forall (a:(@array Z _)), (decrease1 a) ->
  forall (i:Z) (j:Z), ((0%Z <= i)%Z /\ ((i <= j)%Z /\ (j < (length a))%Z)) ->
  ((((get a i) + i)%Z - j)%Z <= (get a j))%Z.
(* Why3 intros a h1 i j (h2,(h3,h4)). *)
(* YOU MAY EDIT THE PROOF BELOW *)
unfold decrease1.
intros a Ha i j Hij.
generalize Hij; pattern j.
apply (Zlt_lower_bound_ind _ i).
2: omega.
intuition.
assert (x = i \/ i < x)%Z by omega.
destruct H5.
subst x.
ring_simplify.
omega.
apply Zle_trans with (get a (x-1) - 1)%Z.
assert (i <= x-1 < x)%Z by omega.
assert (0 <= i /\ i <= x-1 < length a)%Z by omega.
generalize (H0 (x-1)%Z H8 H9); clear H0; intuition.
apply Zle_trans with (get a (x-1+1))%Z.
apply (Ha (x-1)%Z); omega.
ring_simplify (x-1+1)%Z.
omega.
Qed.

