/*
 * StartWithApp.h
 *
 * Copyright (C) 2007 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _START_WITH_APP_H
#define _START_WITH_APP_H

class StartWithApp {
public:
                        StartWithApp();

    char               *GetStartVariant()
                           { return _startVariant;}
    void                SetStartVariant(const char *variant)
                           {
                           if (_startVariant != NULL)
                               free(_startVariant);
                           _startVariant = strdup(variant);
                           }

    char               *GetStartLanguage()
                           { return _startLanguage;}
    void                SetStartLanguage(const char *language)
                           {
                           if (_startLanguage != NULL)
                               free(_startLanguage);
                           _startLanguage = strdup(language);
                           }

    void                StartWithSetDefaults();

    void                StartWithLoadPreferences();
    void                StartWithSavePreferences();

private:
    char               *_startVariant;
    char               *_startLanguage;
};

#endif

