// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See generate_spec_error_message.py for modifications
// Based on Vulkan specification version: 1.4.321

/***************************************************************************
 *
 * Copyright (c) 2016-2025 Google Inc.
 * Copyright (c) 2016-2025 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ****************************************************************************/
#pragma once

// clang-format off

// Mapping from VUID string to the corresponding spec text
typedef struct _vuid_spec_text_pair {
    const char * vuid;
    const char * spec_text;
    const char * url_id;
} vuid_spec_text_pair;

static const vuid_spec_text_pair vuid_spec_text[] = {
    {"VUID-BaryCoordKHR-BaryCoordKHR-04154", "The BaryCoordKHR decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-BaryCoordKHR-BaryCoordKHR-04155", "The variable decorated with BaryCoordKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-BaryCoordKHR-BaryCoordKHR-04156", "The variable decorated with BaryCoordKHR must be declared as a three-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-BaryCoordNoPerspAMD-BaryCoordNoPerspAMD-04157", "The BaryCoordNoPerspAMD decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-BaryCoordNoPerspAMD-BaryCoordNoPerspAMD-04158", "The variable decorated with BaryCoordNoPerspAMD must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-BaryCoordNoPerspAMD-BaryCoordNoPerspAMD-04159", "The variable decorated with BaryCoordNoPerspAMD must be declared as a two-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-BaryCoordNoPerspCentroidAMD-BaryCoordNoPerspCentroidAMD-04163", "The BaryCoordNoPerspCentroidAMD decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-BaryCoordNoPerspCentroidAMD-BaryCoordNoPerspCentroidAMD-04164", "The variable decorated with BaryCoordNoPerspCentroidAMD must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-BaryCoordNoPerspCentroidAMD-BaryCoordNoPerspCentroidAMD-04165", "The variable decorated with BaryCoordNoPerspCentroidAMD must be declared as a three-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-BaryCoordNoPerspKHR-BaryCoordNoPerspKHR-04160", "The BaryCoordNoPerspKHR decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-BaryCoordNoPerspKHR-BaryCoordNoPerspKHR-04161", "The variable decorated with BaryCoordNoPerspKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-BaryCoordNoPerspKHR-BaryCoordNoPerspKHR-04162", "The variable decorated with BaryCoordNoPerspKHR must be declared as a three-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-BaryCoordNoPerspSampleAMD-BaryCoordNoPerspSampleAMD-04166", "The BaryCoordNoPerspSampleAMD decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-BaryCoordNoPerspSampleAMD-BaryCoordNoPerspSampleAMD-04167", "The variable decorated with BaryCoordNoPerspSampleAMD must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-BaryCoordNoPerspSampleAMD-BaryCoordNoPerspSampleAMD-04168", "The variable decorated with BaryCoordNoPerspSampleAMD must be declared as a two-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-BaryCoordPullModelAMD-BaryCoordPullModelAMD-04169", "The BaryCoordPullModelAMD decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-BaryCoordPullModelAMD-BaryCoordPullModelAMD-04170", "The variable decorated with BaryCoordPullModelAMD must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-BaryCoordPullModelAMD-BaryCoordPullModelAMD-04171", "The variable decorated with BaryCoordPullModelAMD must be declared as a three-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-BaryCoordSmoothAMD-BaryCoordSmoothAMD-04172", "The BaryCoordSmoothAMD decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-BaryCoordSmoothAMD-BaryCoordSmoothAMD-04173", "The variable decorated with BaryCoordSmoothAMD must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-BaryCoordSmoothAMD-BaryCoordSmoothAMD-04174", "The variable decorated with BaryCoordSmoothAMD must be declared as a two-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-BaryCoordSmoothCentroidAMD-BaryCoordSmoothCentroidAMD-04175", "The BaryCoordSmoothCentroidAMD decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-BaryCoordSmoothCentroidAMD-BaryCoordSmoothCentroidAMD-04176", "The variable decorated with BaryCoordSmoothCentroidAMD must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-BaryCoordSmoothCentroidAMD-BaryCoordSmoothCentroidAMD-04177", "The variable decorated with BaryCoordSmoothCentroidAMD must be declared as a two-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-BaryCoordSmoothSampleAMD-BaryCoordSmoothSampleAMD-04178", "The BaryCoordSmoothSampleAMD decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-BaryCoordSmoothSampleAMD-BaryCoordSmoothSampleAMD-04179", "The variable decorated with BaryCoordSmoothSampleAMD must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-BaryCoordSmoothSampleAMD-BaryCoordSmoothSampleAMD-04180", "The variable decorated with BaryCoordSmoothSampleAMD must be declared as a two-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-BaseInstance-BaseInstance-04181", "The BaseInstance decoration must be used only within the Vertex Execution Model", "chapters/interfaces.html"},
    {"VUID-BaseInstance-BaseInstance-04182", "The variable decorated with BaseInstance must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-BaseInstance-BaseInstance-04183", "The variable decorated with BaseInstance must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-BaseVertex-BaseVertex-04184", "The BaseVertex decoration must be used only within the Vertex Execution Model", "chapters/interfaces.html"},
    {"VUID-BaseVertex-BaseVertex-04185", "The variable decorated with BaseVertex must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-BaseVertex-BaseVertex-04186", "The variable decorated with BaseVertex must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-ClipDistance-ClipDistance-04187", "The ClipDistance decoration must be used only within the MeshEXT, MeshNV, Vertex, Fragment, TessellationControl, TessellationEvaluation, or Geometry Execution Model", "chapters/interfaces.html"},
    {"VUID-ClipDistance-ClipDistance-04188", "The variable decorated with ClipDistance within the MeshEXT, MeshNV, or Vertex Execution Model must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-ClipDistance-ClipDistance-04189", "The variable decorated with ClipDistance within the Fragment Execution Model must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-ClipDistance-ClipDistance-04190", "The variable decorated with ClipDistance within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared in a Storage Class other than Input or Output", "chapters/interfaces.html"},
    {"VUID-ClipDistance-ClipDistance-04191", "The variable decorated with ClipDistance must be declared as an array of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04192", "The ClipDistancePerViewNV decoration must be used only within the MeshNV Execution Model", "chapters/interfaces.html"},
    {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04193", "The variable decorated with ClipDistancePerViewNV must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04194", "The variable decorated with ClipDistancePerViewNV must also be decorated with the PerViewNV decoration", "chapters/interfaces.html"},
    {"VUID-ClipDistancePerViewNV-ClipDistancePerViewNV-04195", "The variable decorated with ClipDistancePerViewNV must be declared as a two-dimensional array of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-ClusterIDHUAWEI-ClusterIDHUAWEI-07797", "The ClusterIDHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "chapters/interfaces.html"},
    {"VUID-ClusterIDHUAWEI-ClusterIDHUAWEI-07798", "The variable decorated with ClusterIDHUAWEI must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-ClusterIDNV-ClusterIDNV-10531", "The ClusterIDNV decoration must be used only within the AnyHitKHR, or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-ClusterIDNV-ClusterIDNV-10532", "The variable decorated with ClusterIDNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-ClusterIDNV-ClusterIDNV-10533", "The variable decorated with ClusterIDNV must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-ClusterShadingRateHUAWEI-ClusterShadingRateHUAWEI-09448", "The ClusterShadingRateHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "chapters/interfaces.html"},
    {"VUID-ClusterShadingRateHUAWEI-ClusterShadingRateHUAWEI-09449", "The variable decorated with ClusterShadingRateHUAWEI must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-CoalescedInputCountAMDX-CoalescedInputCountAMDX-09172", "The variable decorated with CoalescedInputCountAMDX must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-CoalescedInputCountAMDX-CoalescedInputCountAMDX-09173", "If a variable is decorated with CoalescedInputCountAMDX, the CoalescingAMDX execution mode must be declared", "chapters/interfaces.html"},
    {"VUID-CoalescedInputCountAMDX-CoalescedInputCountAMDX-09174", "The variable decorated with CoalescedInputCountAMDX must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-CoreCountARM-CoreCountARM-07595", "The variable decorated with CoreCountARM must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-CoreCountARM-CoreCountARM-07596", "The variable decorated with CoreCountARM must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-CoreIDARM-CoreIDARM-07599", "The variable decorated with CoreIDARM must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-CoreIDARM-CoreIDARM-07600", "The variable decorated with CoreIDARM must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-CoreMaxIDARM-CoreMaxIDARM-07597", "The variable decorated with CoreMaxIDARM must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-CoreMaxIDARM-CoreMaxIDARM-07598", "The variable decorated with CoreMaxIDARM must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-CullDistance-CullDistance-04196", "The CullDistance decoration must be used only within the MeshEXT, MeshNV, Vertex, Fragment, TessellationControl, TessellationEvaluation, or Geometry Execution Model", "chapters/interfaces.html"},
    {"VUID-CullDistance-CullDistance-04197", "The variable decorated with CullDistance within the MeshEXT, MeshNV or Vertex Execution Model must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-CullDistance-CullDistance-04198", "The variable decorated with CullDistance within the Fragment Execution Model must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-CullDistance-CullDistance-04199", "The variable decorated with CullDistance within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared using a Storage Class other than Input or Output", "chapters/interfaces.html"},
    {"VUID-CullDistance-CullDistance-04200", "The variable decorated with CullDistance must be declared as an array of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04201", "The CullDistancePerViewNV decoration must be used only within the MeshNV Execution Model", "chapters/interfaces.html"},
    {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04202", "The variable decorated with CullDistancePerViewNV must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04203", "The variable decorated with CullDistancePerViewNV must also be decorated with the PerViewNV decoration", "chapters/interfaces.html"},
    {"VUID-CullDistancePerViewNV-CullDistancePerViewNV-04204", "The variable decorated with CullDistancePerViewNV must be declared as a two-dimensional array of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-CullMaskKHR-CullMaskKHR-06735", "The CullMaskKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-CullMaskKHR-CullMaskKHR-06736", "The variable decorated with CullMaskKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-CullMaskKHR-CullMaskKHR-06737", "The variable decorated with CullMaskKHR must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-07034", "The CullPrimitiveEXT decoration must be used only within the MeshEXT Execution Model", "chapters/interfaces.html"},
    {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-07035", "The variable decorated with CullPrimitiveEXT must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-07036", "CullPrimitiveEXT must decorate a scalar boolean member of a structure decorated as Block, or decorate a variable of type OpTypeArray of boolean values", "chapters/interfaces.html"},
    {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-07038", "The variable decorated with CullPrimitiveEXT within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", "chapters/interfaces.html"},
    {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-10589", "If CullPrimitiveEXT is declared as an array of boolean values, the size of the array must match the value specified by OutputPrimitivesEXT", "chapters/interfaces.html"},
    {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-10590", "If CullPrimitiveEXT decorates a member of a structure, the variable declaration of the containing Block type must have an array size that matches the value specified by OutputPrimitivesEXT", "chapters/interfaces.html"},
    {"VUID-CullPrimitiveEXT-CullPrimitiveEXT-10591", "There must be only one declaration of the CullPrimitiveEXT associated with a entry point's interface", "chapters/interfaces.html"},
    {"VUID-CurrentRayTimeNV-CurrentRayTimeNV-04942", "The CurrentRayTimeNV decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-CurrentRayTimeNV-CurrentRayTimeNV-04943", "The variable decorated with CurrentRayTimeNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-CurrentRayTimeNV-CurrentRayTimeNV-04944", "The variable decorated with CurrentRayTimeNV must be declared as a scalar 32-bit floating-point value", "chapters/interfaces.html"},
    {"VUID-DeviceIndex-DeviceIndex-04205", "The variable decorated with DeviceIndex must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-DeviceIndex-DeviceIndex-04206", "The variable decorated with DeviceIndex must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-DrawIndex-DrawIndex-04207", "The DrawIndex decoration must be used only within the Vertex, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", "chapters/interfaces.html"},
    {"VUID-DrawIndex-DrawIndex-04208", "The variable decorated with DrawIndex must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-DrawIndex-DrawIndex-04209", "The variable decorated with DrawIndex must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-FirstIndexHUAWEI-FirstIndexHUAWEI-07799", "The FirstIndexHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "chapters/interfaces.html"},
    {"VUID-FirstIndexHUAWEI-FirstIndexHUAWEI-07800", "The variable decorated with FirstIndexHUAWEI must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-FirstInstanceHUAWEI-FirstInstanceHUAWEI-07801", "The FirstInstanceHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "chapters/interfaces.html"},
    {"VUID-FirstInstanceHUAWEI-FirstInstanceHUAWEI-07802", "The variable decorated with FirstInstanceHUAWEI must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-FirstVertexHUAWEI-FirstVertexHUAWEI-07803", "The FirstVertexHUAWEI decoration must be used only within the FirstVertexHUAWEI Execution Model", "chapters/interfaces.html"},
    {"VUID-FirstVertexHUAWEI-FirstVertexHUAWEI-07804", "The variable decorated with FirstVertexHUAWEI must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-FragCoord-FragCoord-04210", "The FragCoord decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-FragCoord-FragCoord-04211", "The variable decorated with FragCoord must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-FragCoord-FragCoord-04212", "The variable decorated with FragCoord must be declared as a four-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-FragDepth-FragDepth-04213", "The FragDepth decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-FragDepth-FragDepth-04214", "The variable decorated with FragDepth must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-FragDepth-FragDepth-04215", "The variable decorated with FragDepth must be declared as a scalar 32-bit floating-point value", "chapters/interfaces.html"},
    {"VUID-FragDepth-FragDepth-04216", "If the shader dynamically writes to the variable decorated with FragDepth, the DepthReplacing Execution Mode must be declared", "chapters/interfaces.html"},
    {"VUID-FragInvocationCountEXT-FragInvocationCountEXT-04217", "The FragInvocationCountEXT decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-FragInvocationCountEXT-FragInvocationCountEXT-04218", "The variable decorated with FragInvocationCountEXT must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-FragInvocationCountEXT-FragInvocationCountEXT-04219", "The variable decorated with FragInvocationCountEXT must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-FragSizeEXT-FragSizeEXT-04220", "The FragSizeEXT decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-FragSizeEXT-FragSizeEXT-04221", "The variable decorated with FragSizeEXT must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-FragSizeEXT-FragSizeEXT-04222", "The variable decorated with FragSizeEXT must be declared as a two-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-FragStencilRefEXT-FragStencilRefEXT-04223", "The FragStencilRefEXT decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-FragStencilRefEXT-FragStencilRefEXT-04224", "The variable decorated with FragStencilRefEXT must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-FragStencilRefEXT-FragStencilRefEXT-04225", "The variable decorated with FragStencilRefEXT must be declared as a scalar integer value", "chapters/interfaces.html"},
    {"VUID-FragmentSizeNV-FragmentSizeNV-04226", "The FragmentSizeNV decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-FragmentSizeNV-FragmentSizeNV-04227", "The variable decorated with FragmentSizeNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-FragmentSizeNV-FragmentSizeNV-04228", "The variable decorated with FragmentSizeNV must be declared as a two-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-FrontFacing-FrontFacing-04229", "The FrontFacing decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-FrontFacing-FrontFacing-04230", "The variable decorated with FrontFacing must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-FrontFacing-FrontFacing-04231", "The variable decorated with FrontFacing must be declared as a boolean value", "chapters/interfaces.html"},
    {"VUID-FullyCoveredEXT-FullyCoveredEXT-04232", "The FullyCoveredEXT decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-FullyCoveredEXT-FullyCoveredEXT-04233", "The variable decorated with FullyCoveredEXT must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-FullyCoveredEXT-FullyCoveredEXT-04234", "The variable decorated with FullyCoveredEXT must be declared as a boolean value", "chapters/interfaces.html"},
    {"VUID-FullyCoveredEXT-conservativeRasterizationPostDepthCoverage-04235", "If VkPhysicalDeviceConservativeRasterizationPropertiesEXT::conservativeRasterizationPostDepthCoverage is not supported the PostDepthCoverage Execution Mode must not be declared, when a variable with the FullyCoveredEXT decoration is declared", "chapters/interfaces.html"},
    {"VUID-GlobalInvocationId-GlobalInvocationId-04236", "The GlobalInvocationId decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", "chapters/interfaces.html"},
    {"VUID-GlobalInvocationId-GlobalInvocationId-04237", "The variable decorated with GlobalInvocationId must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-GlobalInvocationId-GlobalInvocationId-04238", "The variable decorated with GlobalInvocationId must be declared as a three-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-HelperInvocation-HelperInvocation-04239", "The HelperInvocation decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-HelperInvocation-HelperInvocation-04240", "The variable decorated with HelperInvocation must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-HelperInvocation-HelperInvocation-04241", "The variable decorated with HelperInvocation must be declared as a boolean value", "chapters/interfaces.html"},
    {"VUID-HitIsLSSNV-HitIsLSSNV-10516", "The HitIsLSSNV decoration must be used only within the AnyHitKHR, or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-HitIsLSSNV-HitIsLSSNV-10517", "The variable decorated with HitIsLSSNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-HitIsLSSNV-HitIsLSSNV-10518", "The variable decorated with HitIsLSSNV must be declared as a boolean value", "chapters/interfaces.html"},
    {"VUID-HitIsSphereNV-HitIsSphereNV-10513", "The HitIsSphereNV decoration must be used only within the AnyHitKHR, or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-HitIsSphereNV-HitIsSphereNV-10514", "The variable decorated with HitIsSphereNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-HitIsSphereNV-HitIsSphereNV-10515", "The variable decorated with HitIsSphereNV must be declared as a boolean value", "chapters/interfaces.html"},
    {"VUID-HitKindKHR-HitKindKHR-04242", "The HitKindKHR decoration must be used only within the AnyHitKHR or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-HitKindKHR-HitKindKHR-04243", "The variable decorated with HitKindKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-HitKindKHR-HitKindKHR-04244", "The variable decorated with HitKindKHR must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-HitLSSPositionsNV-HitLSSPositionsNV-10525", "The HitLSSPositionsNV decoration must be used only within the AnyHitKHR, or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-HitLSSPositionsNV-HitLSSPositionsNV-10526", "The variable decorated with HitLSSPositionsNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-HitLSSPositionsNV-HitLSSPositionsNV-10527", "The variable decorated with HitLSSPositionsNV must be declared as an array of size two, containing three-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-HitLSSRadiiNV-HitLSSRadiiNV-10528", "The HitLSSRadiiNV decoration must be used only within the AnyHitKHR, or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-HitLSSRadiiNV-HitLSSRadiiNV-10529", "The variable decorated with HitLSSRadiiNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-HitLSSRadiiNV-HitLSSRadiiNV-10530", "The variable decorated with HitLSSRadiiNV must be declared as an array of size two, containing 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-HitSpherePositionNV-HitSpherePositionNV-10519", "The HitSpherePositionNV decoration must be used only within the AnyHitKHR, or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-HitSpherePositionNV-HitSpherePositionNV-10520", "The variable decorated with HitSpherePositionNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-HitSpherePositionNV-HitSpherePositionNV-10521", "The variable decorated with HitSpherePositionNV must be declared as a three-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-HitSphereRadiusNV-HitSphereRadiusNV-10522", "The HitSphereRadiusNV decoration must be used only within the AnyHitKHR, or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-HitSphereRadiusNV-HitSphereRadiusNV-10523", "The variable decorated with HitSphereRadiusNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-HitSphereRadiusNV-HitSphereRadiusNV-10524", "The variable decorated with HitSphereRadiusNV must be declared as a scalar 32-bit floating-point value", "chapters/interfaces.html"},
    {"VUID-HitTNV-HitTNV-04245", "The HitTNV decoration must be used only within the AnyHitNV or ClosestHitNV Execution Model", "chapters/interfaces.html"},
    {"VUID-HitTNV-HitTNV-04246", "The variable decorated with HitTNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-HitTNV-HitTNV-04247", "The variable decorated with HitTNV must be declared as a scalar 32-bit floating-point value", "chapters/interfaces.html"},
    {"VUID-HitTriangleVertexPositionsKHR-HitTriangleVertexPositionsKHR-08747", "The HitTriangleVertexPositionsKHR decoration must be used only within the AnyHitKHR or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-HitTriangleVertexPositionsKHR-HitTriangleVertexPositionsKHR-08748", "The variable decorated with HitTriangleVertexPositionsKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-HitTriangleVertexPositionsKHR-HitTriangleVertexPositionsKHR-08749", "The variable decorated with HitTriangleVertexPositionsKHR must be declared as an array of three vectors of three 32-bit float values", "chapters/interfaces.html"},
    {"VUID-HitTriangleVertexPositionsKHR-HitTriangleVertexPositionsKHR-08750", "The variable decorated with HitTriangleVertexPositionsKHR must be used only if the value of HitKindKHR is HitKindFrontFacingTriangleKHR or HitKindBackFacingTriangleKHR", "chapters/interfaces.html"},
    {"VUID-HitTriangleVertexPositionsKHR-None-08751", "The acceleration structure corresponding to the current intersection must have been built with VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DATA_ACCESS_BIT_KHR", "chapters/interfaces.html"},
    {"VUID-IncomingRayFlagsKHR-IncomingRayFlagsKHR-04248", "The IncomingRayFlagsKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-IncomingRayFlagsKHR-IncomingRayFlagsKHR-04249", "The variable decorated with IncomingRayFlagsKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-IncomingRayFlagsKHR-IncomingRayFlagsKHR-04250", "The variable decorated with IncomingRayFlagsKHR must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-IndexCountHUAWEI-IndexCountHUAWEI-07805", "The IndexCountHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "chapters/interfaces.html"},
    {"VUID-IndexCountHUAWEI-IndexCountHUAWEI-07806", "The variable decorated with IndexCountHUAWEI must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-InstanceCountHUAWEI-InstanceCountHUAWEI-07807", "The InstanceCountHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "chapters/interfaces.html"},
    {"VUID-InstanceCountHUAWEI-InstanceCountHUAWEI-07808", "The variable decorated with InstanceCountHUAWEI must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-InstanceCustomIndexKHR-InstanceCustomIndexKHR-04251", "The InstanceCustomIndexKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-InstanceCustomIndexKHR-InstanceCustomIndexKHR-04252", "The variable decorated with InstanceCustomIndexKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-InstanceCustomIndexKHR-InstanceCustomIndexKHR-04253", "The variable decorated with InstanceCustomIndexKHR must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-InstanceId-InstanceId-04254", "The InstanceId decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-InstanceId-InstanceId-04255", "The variable decorated with InstanceId must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-InstanceId-InstanceId-04256", "The variable decorated with InstanceId must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-InstanceIndex-InstanceIndex-04263", "The InstanceIndex decoration must be used only within the Vertex Execution Model", "chapters/interfaces.html"},
    {"VUID-InstanceIndex-InstanceIndex-04264", "The variable decorated with InstanceIndex must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-InstanceIndex-InstanceIndex-04265", "The variable decorated with InstanceIndex must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-InvocationId-InvocationId-04257", "The InvocationId decoration must be used only within the TessellationControl or Geometry Execution Model", "chapters/interfaces.html"},
    {"VUID-InvocationId-InvocationId-04258", "The variable decorated with InvocationId must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-InvocationId-InvocationId-04259", "The variable decorated with InvocationId must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-InvocationsPerPixelNV-InvocationsPerPixelNV-04260", "The InvocationsPerPixelNV decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-InvocationsPerPixelNV-InvocationsPerPixelNV-04261", "The variable decorated with InvocationsPerPixelNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-InvocationsPerPixelNV-InvocationsPerPixelNV-04262", "The variable decorated with InvocationsPerPixelNV must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-LaunchIdKHR-LaunchIdKHR-04266", "The LaunchIdKHR decoration must be used only within the RayGenerationKHR, IntersectionKHR, AnyHitKHR, ClosestHitKHR, MissKHR, or CallableKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-LaunchIdKHR-LaunchIdKHR-04267", "The variable decorated with LaunchIdKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-LaunchIdKHR-LaunchIdKHR-04268", "The variable decorated with LaunchIdKHR must be declared as a three-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-LaunchSizeKHR-LaunchSizeKHR-04269", "The LaunchSizeKHR decoration must be used only within the RayGenerationKHR, IntersectionKHR, AnyHitKHR, ClosestHitKHR, MissKHR, or CallableKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-LaunchSizeKHR-LaunchSizeKHR-04270", "The variable decorated with LaunchSizeKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-LaunchSizeKHR-LaunchSizeKHR-04271", "The variable decorated with LaunchSizeKHR must be declared as a three-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-Layer-Layer-04272", "The Layer decoration must be used only within the MeshEXT, MeshNV, Vertex, TessellationEvaluation, Geometry, or Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-Layer-Layer-04273", "If the shaderOutputLayer feature is not enabled then the Layer decoration must be used only within the Geometry or Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-Layer-Layer-04274", "The variable decorated with Layer within the MeshEXT, MeshNV, Vertex, TessellationEvaluation, or Geometry Execution Model must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-Layer-Layer-04275", "The variable decorated with Layer within the Fragment Execution Model must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-Layer-Layer-04276", "The variable decorated with Layer must be declared as a scalar 32-bit integer value for all supported execution models except MeshEXT", "chapters/interfaces.html"},
    {"VUID-Layer-Layer-07039", "The variable decorated with Layer within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", "chapters/interfaces.html"},
    {"VUID-Layer-Layer-10592", "Layer within the MeshEXT Execution Model must decorate a scalar 32-bit integer member of a structure decorated as Block, or decorate a variable of type OpTypeArray of scalar 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-Layer-Layer-10593", "If Layer is declared as an array of boolean values, the size of the array must match the value specified by OutputPrimitivesEXT", "chapters/interfaces.html"},
    {"VUID-Layer-Layer-10594", "If Layer decorates a member of a structure, the variable declaration of the containing Block type must have an array size that matches the value specified by OutputPrimitivesEXT", "chapters/interfaces.html"},
    {"VUID-LayerPerViewNV-LayerPerViewNV-04277", "The LayerPerViewNV decoration must be used only within the MeshNV Execution Model", "chapters/interfaces.html"},
    {"VUID-LayerPerViewNV-LayerPerViewNV-04278", "The variable decorated with LayerPerViewNV must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-LayerPerViewNV-LayerPerViewNV-04279", "The variable decorated with LayerPerViewNV must also be decorated with the PerViewNV decoration", "chapters/interfaces.html"},
    {"VUID-LayerPerViewNV-LayerPerViewNV-04280", "The variable decorated with LayerPerViewNV must be declared as an array of scalar 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-LocalInvocationId-LocalInvocationId-04281", "The LocalInvocationId decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", "chapters/interfaces.html"},
    {"VUID-LocalInvocationId-LocalInvocationId-04282", "The variable decorated with LocalInvocationId must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-LocalInvocationId-LocalInvocationId-04283", "The variable decorated with LocalInvocationId must be declared as a three-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-LocalInvocationIndex-LocalInvocationIndex-04284", "The LocalInvocationIndex decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", "chapters/interfaces.html"},
    {"VUID-LocalInvocationIndex-LocalInvocationIndex-04285", "The variable decorated with LocalInvocationIndex must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-LocalInvocationIndex-LocalInvocationIndex-04286", "The variable decorated with LocalInvocationIndex must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-MeshViewCountNV-MeshViewCountNV-04287", "The MeshViewCountNV decoration must be used only within the MeshNV or TaskNV Execution Model", "chapters/interfaces.html"},
    {"VUID-MeshViewCountNV-MeshViewCountNV-04288", "The variable decorated with MeshViewCountNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-MeshViewCountNV-MeshViewCountNV-04289", "The variable decorated with MeshViewCountNV must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-MeshViewIndicesNV-MeshViewIndicesNV-04290", "The MeshViewIndicesNV decoration must be used only within the MeshNV or TaskNV Execution Model", "chapters/interfaces.html"},
    {"VUID-MeshViewIndicesNV-MeshViewIndicesNV-04291", "The variable decorated with MeshViewIndicesNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-MeshViewIndicesNV-MeshViewIndicesNV-04292", "The variable decorated with MeshViewIndicesNV must be declared as an array of scalar 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-NumSubgroups-NumSubgroups-04293", "The NumSubgroups decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", "chapters/interfaces.html"},
    {"VUID-NumSubgroups-NumSubgroups-04294", "The variable decorated with NumSubgroups must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-NumSubgroups-NumSubgroups-04295", "The variable decorated with NumSubgroups must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-NumWorkgroups-NumWorkgroups-04296", "The NumWorkgroups decoration must be used only within the GLCompute, MeshEXT, or TaskEXT Execution Model", "chapters/interfaces.html"},
    {"VUID-NumWorkgroups-NumWorkgroups-04297", "The variable decorated with NumWorkgroups must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-NumWorkgroups-NumWorkgroups-04298", "The variable decorated with NumWorkgroups must be declared as a three-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-ObjectRayDirectionKHR-ObjectRayDirectionKHR-04299", "The ObjectRayDirectionKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-ObjectRayDirectionKHR-ObjectRayDirectionKHR-04300", "The variable decorated with ObjectRayDirectionKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-ObjectRayDirectionKHR-ObjectRayDirectionKHR-04301", "The variable decorated with ObjectRayDirectionKHR must be declared as a three-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-ObjectRayOriginKHR-ObjectRayOriginKHR-04302", "The ObjectRayOriginKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-ObjectRayOriginKHR-ObjectRayOriginKHR-04303", "The variable decorated with ObjectRayOriginKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-ObjectRayOriginKHR-ObjectRayOriginKHR-04304", "The variable decorated with ObjectRayOriginKHR must be declared as a three-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-ObjectToWorldKHR-ObjectToWorldKHR-04305", "The ObjectToWorldKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-ObjectToWorldKHR-ObjectToWorldKHR-04306", "The variable decorated with ObjectToWorldKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-ObjectToWorldKHR-ObjectToWorldKHR-04307", "The variable decorated with ObjectToWorldKHR must be declared as a matrix with four columns of three-component vectors of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-PFN_vkDebugUtilsMessengerCallbackEXT-None-04769", "The callback must not make calls to any Vulkan commands", "chapters/debugging.html"},
    {"VUID-PatchVertices-PatchVertices-04308", "The PatchVertices decoration must be used only within the TessellationControl or TessellationEvaluation Execution Model", "chapters/interfaces.html"},
    {"VUID-PatchVertices-PatchVertices-04309", "The variable decorated with PatchVertices must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-PatchVertices-PatchVertices-04310", "The variable decorated with PatchVertices must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-PointCoord-PointCoord-04311", "The PointCoord decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-PointCoord-PointCoord-04312", "The variable decorated with PointCoord must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-PointCoord-PointCoord-04313", "The variable decorated with PointCoord must be declared as a two-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-PointSize-PointSize-04314", "The PointSize decoration must be used only within the MeshEXT, MeshNV, Vertex, TessellationControl, TessellationEvaluation, or Geometry Execution Model", "chapters/interfaces.html"},
    {"VUID-PointSize-PointSize-04315", "The variable decorated with PointSize within the MeshEXT, MeshNV, or Vertex Execution Model must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-PointSize-PointSize-04316", "The variable decorated with PointSize within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared using a Storage Class other than Input or Output", "chapters/interfaces.html"},
    {"VUID-PointSize-PointSize-04317", "The variable decorated with PointSize must be declared as a scalar 32-bit floating-point value", "chapters/interfaces.html"},
    {"VUID-Position-Position-04318", "The Position decoration must be used only within the MeshEXT, MeshNV, Vertex, TessellationControl, TessellationEvaluation, or Geometry Execution Model", "chapters/interfaces.html"},
    {"VUID-Position-Position-04319", "The variable decorated with Position within the MeshEXT, MeshNV, or Vertex Execution Model must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-Position-Position-04320", "The variable decorated with Position within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared using a Storage Class other than Input or Output", "chapters/interfaces.html"},
    {"VUID-Position-Position-04321", "The variable decorated with Position must be declared as a four-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04322", "The PositionPerViewNV decoration must be used only within the MeshNV, Vertex, TessellationControl, TessellationEvaluation, or Geometry Execution Model", "chapters/interfaces.html"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04323", "The variable decorated with PositionPerViewNV within the Vertex, or MeshNV Execution Model must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04324", "The variable decorated with PositionPerViewNV within the TessellationControl, TessellationEvaluation, or Geometry Execution Model must not be declared using a Storage Class other than Input or Output", "chapters/interfaces.html"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04325", "The variable decorated with PositionPerViewNV must be declared as an array of four-component vector of 32-bit floating-point values with at least as many elements as the maximum view in the subpass's view mask plus one", "chapters/interfaces.html"},
    {"VUID-PositionPerViewNV-PositionPerViewNV-04326", "The array variable decorated with PositionPerViewNV must only be indexed by a constant or specialization constant", "chapters/interfaces.html"},
    {"VUID-PrimitiveCountNV-PrimitiveCountNV-04327", "The PrimitiveCountNV decoration must be used only within the MeshNV Execution Model", "chapters/interfaces.html"},
    {"VUID-PrimitiveCountNV-PrimitiveCountNV-04328", "The variable decorated with PrimitiveCountNV must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-PrimitiveCountNV-PrimitiveCountNV-04329", "The variable decorated with PrimitiveCountNV must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-PrimitiveId-Fragment-04331", "If pipeline contains both the Fragment and Geometry Execution Model and a variable decorated with PrimitiveId is read from Fragment shader, then the Geometry shader must write to the output variables decorated with PrimitiveId in all execution paths", "chapters/interfaces.html"},
    {"VUID-PrimitiveId-Fragment-04332", "If pipeline contains both the Fragment and MeshEXT or MeshNV Execution Model and a variable decorated with PrimitiveId is read from Fragment shader, then the MeshEXT or MeshNV shader must write to the output variables decorated with PrimitiveId in all execution paths", "chapters/interfaces.html"},
    {"VUID-PrimitiveId-Fragment-04333", "If Fragment Execution Model contains a variable decorated with PrimitiveId, then either the MeshShadingEXT, MeshShadingNV, Geometry or Tessellation capability must also be declared", "chapters/interfaces.html"},
    {"VUID-PrimitiveId-PrimitiveId-04330", "The PrimitiveId decoration must be used only within the MeshEXT, MeshNV, IntersectionKHR, AnyHitKHR, ClosestHitKHR, TessellationControl, TessellationEvaluation, Geometry, or Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-PrimitiveId-PrimitiveId-04334", "The variable decorated with PrimitiveId within the TessellationControl, TessellationEvaluation, Fragment, IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-PrimitiveId-PrimitiveId-04335", "The variable decorated with PrimitiveId within the Geometry Execution Model must be declared using the Input or Output Storage Class", "chapters/interfaces.html"},
    {"VUID-PrimitiveId-PrimitiveId-04336", "The variable decorated with PrimitiveId within the MeshEXT or MeshNV Execution Model must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-PrimitiveId-PrimitiveId-04337", "The variable decorated with PrimitiveId must be declared as a scalar 32-bit integer value for all supported execution models except MeshEXT", "chapters/interfaces.html"},
    {"VUID-PrimitiveId-PrimitiveId-07040", "The variable decorated with PrimitiveId within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", "chapters/interfaces.html"},
    {"VUID-PrimitiveId-PrimitiveId-10595", "PrimitiveId within the MeshEXT Execution Model must decorate a scalar 32-bit integer member of a structure decorated as Block, or decorate a variable of type OpTypeArray of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-PrimitiveId-PrimitiveId-10596", "If PrimitiveId is declared as an array of 32-bit integer values, within the MeshEXT Execution Model, size of the array must match the value specified by OutputPrimitivesEXT", "chapters/interfaces.html"},
    {"VUID-PrimitiveId-PrimitiveId-10597", "If PrimitiveId decorates a member of a structure, the variable declaration of the containing Block type must have an array size that matches the value specified by OutputPrimitivesEXT", "chapters/interfaces.html"},
    {"VUID-PrimitiveIndicesNV-OutputLinesNV-04343", "If the Execution Mode is OutputLinesNV, then the array decorated with PrimitiveIndicesNV must be the size of two times the value specified by OutputPrimitivesNV", "chapters/interfaces.html"},
    {"VUID-PrimitiveIndicesNV-OutputPoints-04342", "If the Execution Mode is OutputPoints, then the array decorated with PrimitiveIndicesNV must be the size of the value specified by OutputPrimitivesNV", "chapters/interfaces.html"},
    {"VUID-PrimitiveIndicesNV-OutputTrianglesNV-04344", "If the Execution Mode is OutputTrianglesNV, then the array decorated with PrimitiveIndicesNV must be the size of three times the value specified by OutputPrimitivesNV", "chapters/interfaces.html"},
    {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04338", "The PrimitiveIndicesNV decoration must be used only within the MeshNV Execution Model", "chapters/interfaces.html"},
    {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04339", "The variable decorated with PrimitiveIndicesNV must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04340", "The variable decorated with PrimitiveIndicesNV must be declared as an array of scalar 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-PrimitiveIndicesNV-PrimitiveIndicesNV-04341", "All index values of the array decorated with PrimitiveIndicesNV must be in the range [0, N-1], where N is the value specified by the OutputVertices Execution Mode", "chapters/interfaces.html"},
    {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07047", "The PrimitiveLineIndicesEXT decoration must be used only within the MeshEXT Execution Model", "chapters/interfaces.html"},
    {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07048", "The PrimitiveLineIndicesEXT decoration must be used with the OutputLinesEXT Execution Mode", "chapters/interfaces.html"},
    {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07049", "The variable decorated with PrimitiveLineIndicesEXT must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07050", "The variable decorated with PrimitiveLineIndicesEXT must be declared as an array of two component vector 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07051", "All index values of the array decorated with PrimitiveLineIndicesEXT must be in the range [0, N-1], where N is the value specified by the OutputVertices Execution Mode", "chapters/interfaces.html"},
    {"VUID-PrimitiveLineIndicesEXT-PrimitiveLineIndicesEXT-07052", "The size of the array decorated with PrimitiveLineIndicesEXT must match the value specified by OutputPrimitivesEXT", "chapters/interfaces.html"},
    {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07041", "The PrimitivePointIndicesEXT decoration must be used only within the MeshEXT Execution Model", "chapters/interfaces.html"},
    {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07042", "The PrimitivePointIndicesEXT decoration must be used with the OutputPoints Execution Mode", "chapters/interfaces.html"},
    {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07043", "The variable decorated with PrimitivePointIndicesEXT must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07044", "The variable decorated with PrimitivePointIndicesEXT must be declared as an array of scalar 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07045", "All index values of the array decorated with PrimitivePointIndicesEXT must be in the range [0, N-1], where N is the value specified by the OutputVertices Execution Mode", "chapters/interfaces.html"},
    {"VUID-PrimitivePointIndicesEXT-PrimitivePointIndicesEXT-07046", "The size of the array decorated with PrimitivePointIndicesEXT must match the value specified by OutputPrimitivesEXT", "chapters/interfaces.html"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04484", "The PrimitiveShadingRateKHR decoration must be used only within the MeshEXT, MeshNV, Vertex, or Geometry Execution Model", "chapters/interfaces.html"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04485", "The variable decorated with PrimitiveShadingRateKHR must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04486", "The variable decorated with PrimitiveShadingRateKHR must be declared as a scalar 32-bit integer value for all supported execution models except MeshEXT", "chapters/interfaces.html"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04487", "The value written to PrimitiveShadingRateKHR must include no more than one of Vertical2Pixels and Vertical4Pixels", "chapters/interfaces.html"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04488", "The value written to PrimitiveShadingRateKHR must include no more than one of Horizontal2Pixels and Horizontal4Pixels", "chapters/interfaces.html"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-04489", "The value written to PrimitiveShadingRateKHR must not have any bits set other than those defined by Fragment Shading Rate Flags enumerants in the SPIR-V specification", "chapters/interfaces.html"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-07059", "The variable decorated with PrimitiveShadingRateKHR within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", "chapters/interfaces.html"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-10598", "PrimitiveShadingRateKHR within the MeshEXT Execution Model must decorate a scalar 32-bit integer member of a structure decorated as Block, or decorate a variable of type OpTypeArray of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-10599", "If PrimitiveShadingRateKHR is declared as an array of boolean values, the size of the array must match the value specified by OutputPrimitivesEXT", "chapters/interfaces.html"},
    {"VUID-PrimitiveShadingRateKHR-PrimitiveShadingRateKHR-10600", "If PrimitiveShadingRateKHR decorates a member of a structure, the variable declaration of the containing Block type must have an array size that matches the value specified by OutputPrimitivesEXT", "chapters/interfaces.html"},
    {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07053", "The PrimitiveTriangleIndicesEXT decoration must be used only within the MeshEXT Execution Model", "chapters/interfaces.html"},
    {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07054", "The PrimitiveTriangleIndicesEXT decoration must be used with the OutputTrianglesEXT Execution Mode", "chapters/interfaces.html"},
    {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07055", "The variable decorated with PrimitiveTriangleIndicesEXT must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07056", "The variable decorated with PrimitiveTriangleIndicesEXT must be declared as an array of three component vector 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07057", "All index values of the array decorated with PrimitiveTriangleIndicesEXT must be in the range [0, N-1], where N is the value specified by the OutputVertices Execution Mode", "chapters/interfaces.html"},
    {"VUID-PrimitiveTriangleIndicesEXT-PrimitiveTriangleIndicesEXT-07058", "The size of the array decorated with PrimitiveTriangleIndicesEXT must match the value specified by OutputPrimitivesEXT", "chapters/interfaces.html"},
    {"VUID-RayGeometryIndexKHR-RayGeometryIndexKHR-04345", "The RayGeometryIndexKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, or ClosestHitKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-RayGeometryIndexKHR-RayGeometryIndexKHR-04346", "The variable decorated with RayGeometryIndexKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-RayGeometryIndexKHR-RayGeometryIndexKHR-04347", "The variable decorated with RayGeometryIndexKHR must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-RayTmaxKHR-RayTmaxKHR-04348", "The RayTmaxKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-RayTmaxKHR-RayTmaxKHR-04349", "The variable decorated with RayTmaxKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-RayTmaxKHR-RayTmaxKHR-04350", "The variable decorated with RayTmaxKHR must be declared as a scalar 32-bit floating-point value", "chapters/interfaces.html"},
    {"VUID-RayTminKHR-RayTminKHR-04351", "The RayTminKHR decoration must be used only within the IntersectionKHR, AnyHitKHR, ClosestHitKHR, or MissKHR Execution Model", "chapters/interfaces.html"},
    {"VUID-RayTminKHR-RayTminKHR-04352", "The variable decorated with RayTminKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-RayTminKHR-RayTminKHR-04353", "The variable decorated with RayTminKHR must be declared as a scalar 32-bit floating-point value", "chapters/interfaces.html"},
    {"VUID-RuntimeSpirv-ConstOffset-10718", "If a VkSampler object that enables sampler Y'CBCR conversion is statically used, it must not use the ConstOffset or Offset operands", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-Coordinate-10713", "The Coordinate operand of any OpImageRead, OpImageSparseRead, OpImageWrite, or OpImageTexelPointer instruction that consumes an OpTypeImage with an image Storage Class TileAttachmentQCOM must not result in any texels accessed outside the boundaries of the current tile, computed as described in Tile Attachments", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-Coordinate-10714", "The Coordinate operand(s) of any of the following instructions that consumes an OpTypeSampledImage with an image of Storage Class TileAttachmentQCOM must not result in any texels accessed outside boundaries of the current tile, computed as described in Tile Attachments: OpImageSample* OpImageSparseSample* OpImageFetch OpImageSparseFetch OpImage*Gather OpImageSparse*Gather OpImageSampleWeightedQCOM OpImageBoxFilterQCOM OpImageBlockMatch*QCOM", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-GraphARM-09922", "The GraphARM capability must not be declared in modules used to create a shader stage", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-InputAttachmentArrayNonUniformIndexing-10138", "If the InputAttachmentArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through an input attachment, the input attachment through which that memory is accessed must be dynamically uniform within the invocation group or subgroup", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-LocalSizeId-06434", "If Execution Mode LocalSizeId is used, maintenance4 must be enabled", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-Location-06272", "The sum of Location and the number of locations the variable it decorates consumes must be less than or equal to the value for the matching Execution Model defined in Shader Input and Output Locations", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-Location-06428", "The maximum number of storage buffers, storage images, and output Location decorated color attachments written to in the Fragment Execution Model must be less than or equal to maxFragmentCombinedOutputResources", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-MaximallyReconvergesKHR-09565", "The execution mode MaximallyReconvergesKHR must not be applied to an entry point unless the entry point does not execute any invocation repack instructions", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-MeshEXT-07115", "For mesh shaders using the MeshEXT Execution Model the OutputVertices OpExecutionMode must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshOutputVertices", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-MeshEXT-07116", "For mesh shaders using the MeshEXT Execution Model the OutputPrimitivesEXT OpExecutionMode must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshOutputPrimitives", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-MeshEXT-07118", "In mesh shaders using the MeshEXT Execution Model OpSetMeshOutputsEXT must be called at most once under dynamically uniform conditions", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-MeshEXT-07295", "For mesh shaders using the MeshEXT Execution Model the x size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupSize[0]", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-MeshEXT-07296", "For mesh shaders using the MeshEXT Execution Model the y size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupSize[1]", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-MeshEXT-07297", "For mesh shaders using the MeshEXT Execution Model the z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupSize[2]", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-MeshEXT-07298", "For mesh shaders using the MeshEXT Execution Model the product of x size, y size, and z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupInvocations", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-MeshEXT-07332", "For mesh shaders using the MeshEXT Execution Model the \"Vertex Count\" operand of OpSetMeshOutputsEXT must be less than or equal to OutputVertices OpExecutionMode", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-MeshEXT-07333", "For mesh shaders using the MeshEXT Execution Model the \"Primitive Count\" operand of OpSetMeshOutputsEXT must be less than or equal to OutputPrimitivesEXT OpExecutionMode", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-MeshEXT-09218", "In mesh shaders using the MeshEXT or MeshNV Execution Model and the OutputPoints Execution Mode, if the maintenance5 feature is not enabled, and if the number of output points is greater than 0, a PointSize decorated variable must be written to for each output point", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-MeshNV-07113", "For mesh shaders using the MeshNV Execution Model the OutputVertices OpExecutionMode must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxMeshOutputVertices", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-MeshNV-07114", "For mesh shaders using the MeshNV Execution Model the OutputPrimitivesNV OpExecutionMode must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxMeshOutputPrimitives", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-NodePayloadAMDX-09192", "Variables in the NodePayloadAMDX storage class must only be declared in the GLCompute or MeshEXT execution model", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-NonWritable-06340", "If the fragmentStoresAndAtomics feature is not enabled, then all storage image, storage texel buffer, and storage buffer variables in the fragment stage must be decorated with the NonWritable decoration", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-NonWritable-06341", "If the vertexPipelineStoresAndAtomics feature is not enabled, then all storage image, storage texel buffer, and storage buffer variables in the vertex, tessellation, and geometry stages must be decorated with the NonWritable decoration", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-06275", "shaderSubgroupExtendedTypes must be enabled for group operations to use 8-bit integer, 16-bit integer, 64-bit integer, 16-bit floating-point, and vectors of these types", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-06278", "shaderBufferInt64Atomics must be enabled for 64-bit integer atomic operations to be supported on a Pointer with a Storage Class of StorageBuffer or Uniform", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-06279", "shaderSharedInt64Atomics must be enabled for 64-bit integer atomic operations to be supported on a Pointer with a Storage Class of Workgroup", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-06284", "shaderBufferFloat32Atomics, or shaderBufferFloat32AtomicAdd, or shaderBufferFloat64Atomics, or shaderBufferFloat64AtomicAdd, or shaderBufferFloat16Atomics, or shaderBufferFloat16AtomicAdd, or shaderBufferFloat16AtomicMinMax, or shaderBufferFloat32AtomicMinMax, or shaderBufferFloat64AtomicMinMax, or shaderFloat16VectorAtomics must be enabled for floating-point atomic operations to be supported on a Pointer with a Storage Class of StorageBuffer", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-06285", "shaderSharedFloat32Atomics, or shaderSharedFloat32AtomicAdd, or shaderSharedFloat64Atomics, or shaderSharedFloat64AtomicAdd, or shaderSharedFloat16Atomics, or shaderSharedFloat16AtomicAdd, or shaderSharedFloat16AtomicMinMax, or shaderSharedFloat32AtomicMinMax, or shaderSharedFloat64AtomicMinMax, or shaderFloat16VectorAtomics, must be enabled for floating-point atomic operations to be supported on a Pointer with a Storage Class of Workgroup", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-06286", "shaderImageFloat32Atomics, or shaderImageFloat32AtomicAdd, or shaderImageFloat32AtomicMinMax, must be enabled for 32-bit floating-point atomic operations to be supported on a Pointer with a Storage Class of Image", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-06287", "sparseImageFloat32Atomics, or sparseImageFloat32AtomicAdd, or sparseImageFloat32AtomicMinMax, must be enabled for 32-bit floating-point atomics to be supported on sparse images", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-06288", "shaderImageInt64Atomics must be enabled for 64-bit integer atomic operations to be supported on a Pointer with a Storage Class of Image", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-06337", "shaderBufferFloat16Atomics, or shaderBufferFloat16AtomicAdd, or shaderBufferFloat16AtomicMinMax, or shaderSharedFloat16Atomics, or shaderSharedFloat16AtomicAdd, or shaderSharedFloat16AtomicMinMax must be enabled for 16-bit floating-point atomic operations", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-06338", "shaderBufferFloat32Atomics, or shaderBufferFloat32AtomicAdd, or shaderSharedFloat32Atomics, or shaderSharedFloat32AtomicAdd, or shaderImageFloat32Atomics, or shaderImageFloat32AtomicAdd or shaderBufferFloat32AtomicMinMax, or shaderSharedFloat32AtomicMinMax, or shaderImageFloat32AtomicMinMax must be enabled for 32-bit floating-point atomic operations", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-06339", "shaderBufferFloat64Atomics, or shaderBufferFloat64AtomicAdd, or shaderSharedFloat64Atomics, or shaderSharedFloat64AtomicAdd, or shaderBufferFloat64AtomicMinMax, or shaderSharedFloat64AtomicMinMax, must be enabled for 64-bit floating-point atomic operations", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-06342", "If subgroupQuadOperationsInAllStages is VK_FALSE, then quad subgroup operations must not be used except for in fragment and compute stages", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-06343", "Group operations with subgroup scope must not be used if the shader stage is not in subgroupSupportedStages", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-09558", "If the dynamicRenderingLocalRead feature is not enabled, any variable created with a \"Type\" of OpTypeImage that has a \"Dim\" operand of SubpassData must be decorated with InputAttachmentIndex", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-10148", "If an instruction accesses memory through any resource, the effective subgroup size is 1, and the resource through which that memory is accessed is not uniform within the invocation group, then the operand corresponding to that resource (e.g. the pointer or sampled image operand) must be decorated with NonUniform", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-10715", "If a VkSampler object that enables sampler Y'CBCR conversion is accessed in a shader, both the sampler and image accessed must be determined by constant integral expressions", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-10716", "If a VkSampler object that enables sampler Y'CBCR conversion is statically used, it must only be used with OpImageSample* or OpImageSparseSample* instructions", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-10824", "If the maintenance9 feature is not enabled, the Base operand of any OpBitCount, OpBitReverse, OpBitFieldInsert, OpBitFieldSExtract, or OpBitFieldUExtract instruction must be a 32-bit integer scalar or a vector of 32-bit integers", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-None-10834", "Buffer indexing calculations must not wrap 32 bits", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-Offset-06308", "The Offset plus size of the type of each variable, in the output interface of the entry point being compiled, decorated with XfbBuffer must not be greater than VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackBufferDataSize", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-Offset-06344", "The first element of the Offset operand of InterpolateAtOffset must be greater than or equal to: fragwidth x minInterpolationOffset where fragwidth is the width of the current fragment in pixels", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-Offset-06345", "The first element of the Offset operand of InterpolateAtOffset must be less than or equal to fragwidth x (maxInterpolationOffset + ULP ) - ULP where fragwidth is the width of the current fragment in pixels and ULP = 1 / 2^subPixelInterpolationOffsetBits^", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-Offset-06346", "The second element of the Offset operand of InterpolateAtOffset must be greater than or equal to fragheight x minInterpolationOffset where fragheight is the height of the current fragment in pixels", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-Offset-06347", "The second element of the Offset operand of InterpolateAtOffset must be less than or equal to fragheight x (maxInterpolationOffset + ULP ) - ULP where fragheight is the height of the current fragment in pixels and ULP = 1 / 2^subPixelInterpolationOffsetBits^", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-Offset-10213", "If the maintenance8 feature is not enabled, image operand Offset must only be used with OpImage*Gather instructions", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpCooperativeMatrixLoadKHR-08986", "For OpCooperativeMatrixLoadKHR and OpCooperativeMatrixStoreKHR instructions, the Pointer and Stride operands must be aligned to at least the lesser of 16 bytes or the natural alignment of a row or column (depending on ColumnMajor) of the matrix (where the natural alignment is the number of columns/rows multiplied by the component size)", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpCooperativeMatrixLoadNV-06324", "For OpCooperativeMatrixLoadNV and OpCooperativeMatrixStoreNV instructions, the Pointer and Stride operands must be aligned to at least the lesser of 16 bytes or the natural alignment of a row or column (depending on ColumnMajor) of the matrix (where the natural alignment is the number of columns/rows multiplied by the component size)", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpCooperativeMatrixMulAddKHR-10060", "For OpCooperativeMatrixMulAddKHR, the operands must match a supported VkCooperativeMatrixPropertiesKHR", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpCooperativeVectorLoadNV-10099", "For OpCooperativeVectorLoadNV and OpCooperativeVectorStoreNV instructions, the Pointer and Offset must be aligned to 16 bytes", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpCooperativeVectorMatrixMulAddNV-10098", "For OpCooperativeVectorMatrixMulAddNV instructions, the Bias and BiasOffset must be aligned to 16 bytes", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpCooperativeVectorMatrixMulNV-10089", "For OpCooperativeVectorMatrixMulNV and OpCooperativeVectorMatrixMulAddNV, the following must be satisfied by the same entry in the VkCooperativeVectorPropertiesNV array returned by vkGetPhysicalDeviceCooperativeVectorPropertiesNV: The component type of Input must match VkCooperativeVectorPropertiesNV::inputType The InputInterpretation must match VkCooperativeVectorPropertiesNV::inputInterpretation The MatrixInterpretation must match VkCooperativeVectorPropertiesNV::matrixInterpretation For OpCooperativeVectorMatrixMulAddNV, the BiasInterpretation must match VkCooperativeVectorPropertiesNV::biasInterpretation The Result Type must match VkCooperativeVectorPropertiesNV::resultType If Transpose is true, VkCooperativeVectorPropertiesNV::transpose must be VK_TRUE", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpCooperativeVectorMatrixMulNV-10090", "For OpCooperativeVectorMatrixMulNV and OpCooperativeVectorMatrixMulAddNV, if MatrixInterpretation is either VK_COMPONENT_TYPE_FLOAT_E4M3_NV or VK_COMPONENT_TYPE_FLOAT_E5M2_NV then MemoryLayout must be either VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_INFERENCING_OPTIMAL_NV or VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_TRAINING_OPTIMAL_NV", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpCooperativeVectorMatrixMulNV-10096", "For OpCooperativeVectorMatrixMulNV and OpCooperativeVectorMatrixMulAddNV instructions using non-optimal layouts, the Stride operand must be aligned to 16 bytes", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpCooperativeVectorMatrixMulNV-10097", "For OpCooperativeVectorMatrixMulNV and OpCooperativeVectorMatrixMulAddNV instructions, the Matrix and MatrixOffset must be aligned to 64 bytes", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpCooperativeVectorOuterProductAccumulateNV-10093", "For OpCooperativeVectorOuterProductAccumulateNV: MatrixInterpretation must be VK_COMPONENT_TYPE_FLOAT16_KHR or VK_COMPONENT_TYPE_FLOAT32_KHR If MatrixInterpretation is VK_COMPONENT_TYPE_FLOAT16_KHR, cooperativeVectorTrainingFloat16Accumulation must be supported If MatrixInterpretation is VK_COMPONENT_TYPE_FLOAT32_KHR, cooperativeVectorTrainingFloat32Accumulation must be supported The component types of A and B must be 16-bit floating-point The matrix layout must be training-optimal The pointer's storage class must be StorageBuffer or PhysicalStorageBuffer", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpCooperativeVectorOuterProductAccumulateNV-10101", "For OpCooperativeVectorOuterProductAccumulateNV instructions, the Pointer and Offset must be aligned to 64 bytes", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpCooperativeVectorReduceSumAccumulateNV-10092", "For OpCooperativeVectorReduceSumAccumulateNV: The component type of V must be either 16- or 32-bit floating-point If the component type of V is 16-bit floating-point, cooperativeVectorTrainingFloat16Accumulation must be supported If the component type of V is 32-bit floating-point, cooperativeVectorTrainingFloat32Accumulation must be supported The pointer's storage class must be StorageBuffer or PhysicalStorageBuffer", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpCooperativeVectorReduceSumAccumulateNV-10100", "For OpCooperativeVectorReduceSumAccumulateNV instructions, the Pointer and Offset must be aligned to 16 bytes", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpEmitStreamVertex-06310", "The Stream value to OpEmitStreamVertex and OpEndStreamPrimitive must be less than VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackStreams", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpEntryPoint-07754", "Any user-defined variables between the OpEntryPoint of two shader stages must have the same type and width for each Component", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpEntryPoint-08727", "Each OpEntryPoint must not have more than one variable decorated with InputAttachmentIndex per image aspect of the attachment image bound to it, either explicitly or implicitly as described by input attachment interface", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpEntryPoint-08743", "Any user-defined variables shared between the OpEntryPoint of two shader stages, and declared with Input as its Storage Class for the subsequent shader stage, must have all Location slots and Component words declared in the preceding shader stage's OpEntryPoint with Output as the Storage Class", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayMotionNV-07704", "For OpHitObjectTraceRayMotionNV instructions, if Acceleration Structure was built with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags, the pipeline must have been created with VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV set", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayMotionNV-07709", "For OpHitObjectTraceRayMotionNV instructions, Acceleration Structure must be an acceleration structure built as a top-level acceleration structure with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayMotionNV-07711", "For OpHitObjectTraceRayMotionNV instructions the pipeline must have been created with VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV set", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07705", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, all components of the RayOrigin and RayDirection operands must be finite floating-point values", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07706", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the RayTmin and RayTmax operands must be non-negative floating-point values", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07707", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the RayTmin operand must be less than or equal to the RayTmax operand", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07708", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, RayOrigin, RayDirection, RayTmin, and RayTmax operands must not contain NaNs", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07710", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions the time operand must be between 0.0 and 1.0", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07712", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the Rayflags operand must not contain both SkipTrianglesKHR and SkipAABBsKHR", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07713", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the Rayflags operand must not contain more than one of SkipTrianglesKHR, CullBackFacingTrianglesKHR, and CullFrontFacingTrianglesKHR", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07714", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, the Rayflags operand must not contain more than one of OpaqueKHR, NoOpaqueKHR, CullOpaqueKHR, and CullNoOpaqueKHR", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07715", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, if the Rayflags operand contains SkipTrianglesKHR, the pipeline must not have been created with VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR set", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpHitObjectTraceRayNV-07716", "For OpHitObjectTraceRayNV and OpHitObjectTraceRayMotionNV instructions, if the Rayflags operand contains SkipAABBsKHR, the pipeline must not have been created with VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR set", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImage-06376", "If an OpImage*Gather operation has an image operand of Offset, ConstOffset, or ConstOffsets the offset value must be greater than or equal to minTexelGatherOffset", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImage-06377", "If an OpImage*Gather operation has an image operand of Offset, ConstOffset, or ConstOffsets the offset value must be less than or equal to maxTexelGatherOffset", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImage-10706", "An OpImage with Storage Class TileAttachmentQCOM must not be consumed by OpImageTexelPointer unless the tileShadingAtomicOps feature is enabled", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImage-10717", "An OpImage instruction must not be used on a VkSampler object that enables sampler Y'CBCR conversion", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchSADQCOM-06982", "If an OpImageBlockMatchSADQCOM or OpImageBlockMatchSSDQCOM operation is used, then the target sampled image, reference sampled image, and Block Size parameters must both be dynamically uniform for the quad", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06983", "If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then target sampled image and reference sampled image parameters must be of storage class UniformConstant and type OpTypeImage with Depth=0, Dim=2D, Arrayed=0, MS=0, and Sampled=1", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06984", "If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then the target sampled image and reference sampled image parameters must be decorated with BlockMatchTextureQCOM", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06985", "If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then target sampled image and reference sampled image parameters must have been created using an identical sampler object", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06986", "If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then target sampled image and reference sampled image parameters must have been created with a sampler object with unnormalizedCoordinates equal to VK_TRUE", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06987", "If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then target sampled image and reference sampled image parameters must have been created with a sampler object with unnormalizedCoordinates equal to VK_TRUE", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchSSDQCOM-06988", "If an OpImageBlockMatchSSDQCOM or OpImageBlockMatchSADQCOM operation is used, then Block Size less than or equal to maxBlockMatchRegion", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09219", "If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then the target sampled image, reference sampled image, and Block Size parameters must both be dynamically uniform for the quad", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09220", "If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then target sampled image and reference sampled image parameters must be of storage class UniformConstant and type OpTypeImage with Depth=0, Dim=2D, Arrayed=0, MS=0, and Sampled=1", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09221", "If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then the target sampled image and reference sampled image parameters must be decorated with BlockMatchTextureQCOM", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09222", "If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then target sampled image and reference sampled image parameters must have been created using an identical sampler object", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09223", "If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then target sampled image and reference sampled image parameters must have been created with a sampler object with unnormalizedCoordinates equal to VK_TRUE", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBlockMatchWindow-09224", "If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then target sampled image and reference sampled image parameters must have been created with sampler object with unnormalizedCoordinates equal to VK_TRUE", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBoxFilterQCOM-06989", "If an OpImageBoxFilterQCOM operation is used, then Box Size.y must be equal to or greater than 1.0 and less than or equal to maxBoxFilterBlockSize.height", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageBoxFilterQCOM-06990", "If an OpImageBoxFilterQCOM operation is used, then Sampled Texture Image and Box Size parameters must be dynamically uniform", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageSample-06435", "If an OpImageSample* or OpImageFetch* operation has an image operand of Offset or ConstOffset then the offset value must be greater than or equal to minTexelOffset", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageSample-06436", "If an OpImageSample* or OpImageFetch* operation has an image operand of Offset or ConstOffset then the offset value must be less than or equal to maxTexelOffset", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageWeightedSampleQCOM-06979", "If an OpImageWeightedSampleQCOM operation is used, then the Texture Sampled Image and Weight Image parameters must both be dynamically uniform for the quad", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageWeightedSampleQCOM-06980", "If an OpImageWeightedSampleQCOM operation is used, then the Weight Image parameter must be of Storage Class UniformConstant and type OpTypeImage with Depth=0, Dim=2D, Arrayed=1, MS=0, and Sampled=1", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageWeightedSampleQCOM-06981", "If an OpImageWeightedSampleQCOM operation is used, then the Weight Image parameter must be decorated with WeightTextureQCOM", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpImageWrite-07112", "OpImageWrite to any Image whose Image Format is not Unknown must have the Texel operand contain at least as many components as the corresponding VkFormat as given in the SPIR-V Image Format compatibility table", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpRayQueryGenerateIntersectionKHR-06353", "For OpRayQueryGenerateIntersectionKHR instructions, Hit T must satisfy the condition RayTmin <= Hit T <= RayTmax, where RayTmin is equal to the value returned by OpRayQueryGetRayTMinKHR with the same ray query object, and RayTmax is equal to the value of OpRayQueryGetIntersectionTKHR for the current committed intersection with the same ray query object", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpRayQueryGenerateIntersectionKHR-06354", "For OpRayQueryGenerateIntersectionKHR instructions, Acceleration Structure must not be built with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06348", "For OpRayQueryInitializeKHR instructions, all components of the RayOrigin and RayDirection operands must be finite floating-point values", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06349", "For OpRayQueryInitializeKHR instructions, the RayTmin and RayTmax operands must be non-negative floating-point values", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06350", "For OpRayQueryInitializeKHR instructions, the RayTmin operand must be less than or equal to the RayTmax operand", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06351", "For OpRayQueryInitializeKHR instructions, RayOrigin, RayDirection, RayTmin, and RayTmax operands must not contain NaNs", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06352", "For OpRayQueryInitializeKHR instructions, Acceleration Structure must be an acceleration structure built as a top-level acceleration structure", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06889", "For OpRayQueryInitializeKHR instructions, the Rayflags operand must not contain both SkipTrianglesKHR and SkipAABBsKHR", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06890", "For OpRayQueryInitializeKHR instructions, the Rayflags operand must not contain more than one of SkipTrianglesKHR, CullBackFacingTrianglesKHR, and CullFrontFacingTrianglesKHR", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpRayQueryInitializeKHR-06891", "For OpRayQueryInitializeKHR instructions, the Rayflags operand must not contain more than one of OpaqueKHR, NoOpaqueKHR, CullOpaqueKHR, and CullNoOpaqueKHR", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpReportIntersectionKHR-06998", "The value of the \"Hit Kind\" operand of OpReportIntersectionKHR must be in the range [0,127]", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06355", "For OpTraceRayKHR instructions, all components of the RayOrigin and RayDirection operands must be finite floating-point values", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06356", "For OpTraceRayKHR instructions, the RayTmin and RayTmax operands must be non-negative floating-point values", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06357", "For OpTraceRayKHR instructions, the RayTmin operand must be less than or equal to the RayTmax operand", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06358", "For OpTraceRayKHR instructions, RayOrigin, RayDirection, RayTmin, and RayTmax operands must not contain NaNs", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06359", "For OpTraceRayKHR instructions, Acceleration Structure must be an acceleration structure built as a top-level acceleration structure", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06360", "For OpTraceRayKHR instructions, if Acceleration Structure was built with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags, the pipeline must have been created with VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV set", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06552", "For OpTraceRayKHR instructions, the Rayflags operand must not contain both SkipTrianglesKHR and SkipAABBsKHR", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06553", "For OpTraceRayKHR instructions, if the Rayflags operand contains SkipTrianglesKHR, the pipeline must not have been created with VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR set", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06554", "For OpTraceRayKHR instructions, if the Rayflags operand contains SkipAABBsKHR, the pipeline must not have been created with VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR set", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06892", "For OpTraceRayKHR instructions, the Rayflags operand must not contain more than one of SkipTrianglesKHR, CullBackFacingTrianglesKHR, and CullFrontFacingTrianglesKHR", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayKHR-06893", "For OpTraceRayKHR instructions, the Rayflags operand must not contain more than one of OpaqueKHR, NoOpaqueKHR, CullOpaqueKHR, and CullNoOpaqueKHR", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06361", "For OpTraceRayMotionNV instructions, all components of the RayOrigin and RayDirection operands must be finite floating-point values", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06362", "For OpTraceRayMotionNV instructions, the RayTmin and RayTmax operands must be non-negative floating-point values", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06363", "For OpTraceRayMotionNV instructions, the RayTmin operand must be less than or equal to the RayTmax operand", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06364", "For OpTraceRayMotionNV instructions, RayOrigin, RayDirection, RayTmin, and RayTmax operands must not contain NaNs", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06365", "For OpTraceRayMotionNV instructions, Acceleration Structure must be an acceleration structure built as a top-level acceleration structure with VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV in flags", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06366", "For OpTraceRayMotionNV instructions the time operand must be between 0.0 and 1.0", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTraceRayMotionNV-06367", "For OpTraceRayMotionNV instructions the pipeline must have been created with VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV set", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixKHR-10163", "For OpTypeCooperativeMatrixKHR, if the cooperativeMatrixFlexibleDimensions feature is not enabled, the component type, scope, number of rows, and number of columns must match one of the matrices in any of the supported VkCooperativeMatrixPropertiesKHR, where for Use of MatrixA, the number of rows must match VkCooperativeMatrixPropertiesKHR::MSize and the number of columns must match VkCooperativeMatrixPropertiesKHR::KSize and the type must match VkCooperativeMatrixPropertiesKHR::AType for Use of MatrixB, the number of rows must match VkCooperativeMatrixPropertiesKHR::KSize and the number of columns must match VkCooperativeMatrixPropertiesKHR::NSize and the type must match VkCooperativeMatrixPropertiesKHR::BType for Use of MatrixAccumulator, the number of rows must match VkCooperativeMatrixPropertiesKHR::MSize and the number of columns must match VkCooperativeMatrixPropertiesKHR::NSize and the type must match VkCooperativeMatrixPropertiesKHR::CType or VkCooperativeMatrixPropertiesKHR::ResultType", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixKHR-10770", "Any pipeline containing a shader with OpTypeCooperativeMatrixKHR or OpCooperativeMatrix*KHR instructions must be created with the VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT flag or the shader module must be version 1.6 or greater", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixKHR-10771", "Any shader object containing OpTypeCooperativeMatrixKHR or OpCooperativeMatrix*KHR instructions must be created with the VK_SHADER_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT flag or the shader module must be version 1.6 or greater", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixMulAddNV-10059", "For OpTypeCooperativeMatrixMulAddNV, the operands must match a supported VkCooperativeMatrixPropertiesNV, such that: The type of A must have Rows match VkCooperativeMatrixPropertiesNV::MSize, Columns match VkCooperativeMatrixPropertiesNV::KSize, and ComponentType match VkCooperativeMatrixPropertiesNV::AType. The type of B must have Rows match VkCooperativeMatrixPropertiesNV::KSize, Columns match VkCooperativeMatrixPropertiesNV::NSize, and ComponentType match VkCooperativeMatrixPropertiesNV::BType. The type of C must have Rows match VkCooperativeMatrixPropertiesNV::MSize, Columns match VkCooperativeMatrixPropertiesNV::NSize, and ComponentType match VkCooperativeMatrixPropertiesNV::CType. The type of Result must have Rows match VkCooperativeMatrixPropertiesNV::MSize, Columns match VkCooperativeMatrixPropertiesNV::NSize, and ComponentType match VkCooperativeMatrixPropertiesNV::DType. The scope of all cooperative matrix operands must be VkScopeNV::VK_SCOPE_SUBGROUP_NV. If ComponentType of A, B, C, or Result is a signed integral type, the Signedness operand of the OpTypeInt must be 1. If ComponentType of A, B, C, or Result is an unsigned integral type, the Signedness operand of the OpTypeInt must be 0", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixNV-06316", "For OpTypeCooperativeMatrixNV, the component type, scope, number of rows, and number of columns must match one of the matrices in any of the supported VkCooperativeMatrixPropertiesNV", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeCooperativeMatrixNV-06322", "OpTypeCooperativeMatrixNV and OpCooperativeMatrix* instructions must not be used in shader stages not included in VkPhysicalDeviceCooperativeMatrixPropertiesNV::cooperativeMatrixSupportedStages", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeCooperativeVector-10095", "OpTypeCooperativeVector instructions must have Component Type that is any supported type reported by vkGetPhysicalDeviceCooperativeVectorPropertiesNV", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeImage-09644", "Any variable declared as an OpTypeArray where the Element Type is an OpTypeImage with a \"Dim\" operand of SubpassData must be decorated with InputAttachmentIndex", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeImage-10707", "An OpTypeImage with Storage Class TileAttachmentQCOM must not be backed by a view equivalent to the color attachment of the current subpass instance unless the tileShadingColorAttachments feature is enabled", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeImage-10708", "An OpTypeImage with Storage Class TileAttachmentQCOM must not be backed by a view equivalent to the depth aspect of the depth/stencil attachment of the current subpass instance unless the tileShadingDepthAttachments", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeImage-10709", "An OpTypeImage with Storage Class TileAttachmentQCOM must not be backed by a view equivalent to the stencil aspect of the depth/stencil attachment of the current subpass instance unless the tileShadingStencilAttachments feature is enabled", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeImage-10710", "An OpTypeImage with Storage Class TileAttachmentQCOM must not be backed by a view equivalent to the input attachment of the current subpass instance unless the tileShadingInputAttachments feature is enabled", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeSampledImage-10711", "An OpTypeSampledImage with Storage Class TileAttachmentQCOM must not be backed by a view equivalent to an attachment of the current subpass instance unless the tileShadingSampledAttachments feature is enabled", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeTensorARM-09902", "OpTypeTensorARM with a Shape must not be used in shader stages", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpTypeTensorARM-09907", "OpTypeTensorARM without a Rank must not be used in shader stages", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-OpVariable-08746", "Any OpVariable, Block-decorated OpTypeStruct, or Block-decorated OpTypeStruct members shared between the OpEntryPoint of two shader stages must have matching decorations as defined in interface matching", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-PhysicalStorageBuffer64-06314", "If the PhysicalStorageBuffer64 addressing model is enabled any load or store through a physical pointer type must be aligned to a multiple of the size of the largest scalar type in the pointed-to type", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-PhysicalStorageBuffer64-06315", "If the PhysicalStorageBuffer64 addressing model is enabled the pointer value of a memory access instruction must be at least as aligned as specified by the Aligned memory access operand", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-SampleRateShading-06378", "If the subpass description contains VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM, then the SPIR-V fragment shader Capability SampleRateShading must not be enabled", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-SampledImageArrayNonUniformIndexing-10135", "If the SampledImageArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a sampled image or sampler, the sampled image or sampler through which that memory is accessed must be dynamically uniform within the invocation group or subgroup", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-ShaderEnqueueAMDX-09191", "The ShaderEnqueueAMDX capability must only be used in shaders with the GLCompute or MeshEXT execution model", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-StorageBufferArrayNonUniformIndexing-10136", "If the StorageBufferArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a storage buffer, the storage buffer through which that memory is accessed must be dynamically uniform within the invocation group or subgroup", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-StorageImageArrayNonUniformIndexing-10137", "If the StorageImageArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a storage image, the storage image through which that memory is accessed must be dynamically uniform within the invocation group or subgroup", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-StorageTexelBufferArrayNonUniformIndexing-10140", "If the StorageTexelBufferArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a storage texel buffer, the storage texel buffer through which that memory is accessed must be dynamically uniform within the invocation group or subgroup", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-Stream-06312", "The stream number value to Stream must be less than VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackStreams", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-SubgroupUniformControlFlowKHR-06379", "The Execution Mode SubgroupUniformControlFlowKHR must not be applied to an entry point unless the shaderSubgroupUniformControlFlow feature is enabled, the corresponding shader stage bit is set in subgroupSupportedStages, and the entry point does not execute any invocation repack instructions", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-TaskEXT-07117", "In task shaders using the TaskEXT Execution Model OpEmitMeshTasksEXT must be called exactly once under dynamically uniform conditions", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-TaskEXT-07291", "In task shaders using the TaskEXT Execution Model the x size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupSize[0]", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-TaskEXT-07292", "In task shaders using the TaskEXT Execution Model the y size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupSize[1]", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-TaskEXT-07293", "In task shaders using the TaskEXT Execution Model the z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupSize[2]", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-TaskEXT-07294", "In task shaders using the TaskEXT Execution Model the product of x size, y size, and z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupInvocations", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-TaskEXT-07299", "In task shaders using the TaskEXT Execution Model the value of the \"Group Count X\" operand of OpEmitMeshTasksEXT must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[0]", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-TaskEXT-07300", "In task shaders using the TaskEXT Execution Model the value of the \"Group Count Y\" operand of OpEmitMeshTasksEXT must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[1]", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-TaskEXT-07301", "In task shaders using the TaskEXT Execution Model the value of the \"Group Count Z\" operand of OpEmitMeshTasksEXT must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[2]", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-TaskEXT-07302", "In task shaders using the TaskEXT Execution Model the product of the \"Group Count\" operands of OpEmitMeshTasksEXT must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupTotalCount", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-TileShadingQCOM-10698", "TileShadingQCOM capability must not be declared in the compute stage unless the tileShading feature is enabled", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-TileShadingQCOM-10699", "The TileShadingQCOM capability must not be declared in the fragment stage unless the tileShadingFragmentStage feature is enabled", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-TileShadingQCOM-10700", "A shader that enables SPIR-V capability TileShadingQCOM must not be invoked outside a tile shading render pass", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-TileShadingQCOM-10701", "A compute shader that enables SPIR-V capability TileShadingQCOM must only be invoked inside those portions of a command buffer where per-tile execution model is enabled", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-UniformBufferArrayNonUniformIndexing-10134", "If the UniformBufferArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a uniform buffer, the uniform buffer through which that memory is accessed must be dynamically uniform within the invocation group or subgroup", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-UniformTexelBufferArrayNonUniformIndexing-10139", "If the UniformTexelBufferArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a uniform texel buffer, the uniform texel buffer through which that memory is accessed must be dynamically uniform within the invocation group or subgroup", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-Workgroup-06530", "The sum of size in bytes for variables and padding in the Workgroup Storage Class in the GLCompute Execution Model must be less than or equal to maxComputeSharedMemorySize", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-XfbBuffer-06309", "For any given XfbBuffer value, define the buffer data size to be smallest number of bytes such that, for all outputs decorated with the same XfbBuffer value, the size of the output interface variable plus the Offset is less than or equal to the buffer data size. For a given Stream, the sum of all the buffer data sizes for all buffers writing to that stream the must not exceed VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackStreamDataSize", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-XfbStride-06313", "The XFB Stride value to XfbStride must be less than or equal to VkPhysicalDeviceTransformFeedbackPropertiesEXT::maxTransformFeedbackBufferDataStride", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-apiVersion-07954", "If VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.3, the VK_KHR_format_feature_flags2 extension is not supported, and the shaderStorageImageWriteWithoutFormat feature is not enabled, any variable created with a \"Type\" of OpTypeImage that has a \"Sampled\" operand of 2 and an \"Image Format\" operand of Unknown must be decorated with NonWritable", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-apiVersion-07955", "If VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.3, the VK_KHR_format_feature_flags2 extension is not supported, and the shaderStorageImageReadWithoutFormat feature is not enabled, any variable created with a \"Type\" of OpTypeImage that has a \"Sampled\" operand of 2 and an \"Image Format\" operand of Unknown must be decorated with NonReadable", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-cooperativeMatrixFlexibleDimensions-10165", "For OpTypeCooperativeMatrixKHR, if the cooperativeMatrixFlexibleDimensions feature is enabled, the component type, scope, number of rows, and number of columns must match either one of the matrices in one of the supported VkCooperativeMatrixPropertiesKHR as described above, or one of the supported VkCooperativeMatrixFlexibleDimensionsPropertiesNV, where for MatrixA, the number of rows must be a multiple of VkCooperativeMatrixFlexibleDimensionsPropertiesNV::MGranularity and the number of columns must be a multiple of VkCooperativeMatrixFlexibleDimensionsPropertiesNV::KGranularity and the type must match VkCooperativeMatrixFlexibleDimensionsPropertiesNV::AType for MatrixB, the number of rows must be a multiple of VkCooperativeMatrixFlexibleDimensionsPropertiesNV::KGranularity and the number of columns must be a multiple of VkCooperativeMatrixFlexibleDimensionsPropertiesNV::NGranularity and the type must match VkCooperativeMatrixFlexibleDimensionsPropertiesNV::BType for MatrixAccumulator, the number of rows must be a multiple of VkCooperativeMatrixFlexibleDimensionsPropertiesNV::MGranularity and the number of columns must be a multiple of VkCooperativeMatrixFlexibleDimensionsPropertiesNV::NGranularity and the type must match VkCooperativeMatrixFlexibleDimensionsPropertiesNV::CType or VkCooperativeMatrixFlexibleDimensionsPropertiesNV::ResultType if the scope is VK_SCOPE_WORKGROUP_KHR, the number of invocations in the local workgroup must match VkCooperativeMatrixFlexibleDimensionsPropertiesNV::workgroupInvocations", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-cooperativeMatrixFlexibleDimensions-10166", "For OpCooperativeMatrixMulAddKHR, if the cooperativeMatrixFlexibleDimensions feature is enabled, the operands must match either one of the supported VkCooperativeMatrixPropertiesKHR as described above, or one of the supported VkCooperativeMatrixFlexibleDimensionsPropertiesNV, such that: The type of A must have Rows be a multiple of VkCooperativeMatrixFlexibleDimensionsPropertiesNV::MGranularity, Columns be a multiple of VkCooperativeMatrixFlexibleDimensionsPropertiesNV::KGranularity, Use be MatrixAKHR, and ComponentType match VkCooperativeMatrixFlexibleDimensionsPropertiesNV::AType. The type of B must have Rows be a multiple of VkCooperativeMatrixFlexibleDimensionsPropertiesNV::KGranularity, Columns be a multiple of VkCooperativeMatrixFlexibleDimensionsPropertiesNV::NGranularity, Use be MatrixBKHR, and ComponentType match VkCooperativeMatrixFlexibleDimensionsPropertiesNV::BType. The type of C must have Rows be a multiple of VkCooperativeMatrixFlexibleDimensionsPropertiesNV::MGranularity, Columns be a multiple of VkCooperativeMatrixFlexibleDimensionsPropertiesNV::NGranularity, Use be MatrixAccumulatorKHR, and ComponentType match VkCooperativeMatrixFlexibleDimensionsPropertiesNV::CType. The type of Result must have Rows be a multiple of VkCooperativeMatrixFlexibleDimensionsPropertiesNV::MGranularity, Columns be a multiple of VkCooperativeMatrixFlexibleDimensionsPropertiesNV::NGranularity, Use be MatrixAccumulatorKHR, and ComponentType match VkCooperativeMatrixFlexibleDimensionsPropertiesNV::ResultType. If and only if VkCooperativeMatrixFlexibleDimensionsPropertiesNV::AType is a signed integer type, MatrixASignedComponents must be used. If and only if VkCooperativeMatrixFlexibleDimensionsPropertiesNV::BType is a signed integer type, MatrixBSignedComponents must be used. If and only if VkCooperativeMatrixFlexibleDimensionsPropertiesNV::CType is a signed integer type, MatrixCSignedComponents must be used. If and only if VkCooperativeMatrixFlexibleDimensionsPropertiesNV::ResultType is a signed integer type, MatrixResultSignedComponents must be used. If and only if VkCooperativeMatrixFlexibleDimensionsPropertiesNV::saturatingAccumulation is VK_TRUE, SaturatingAccumulationKHR must be used. If and only if VkCooperativeMatrixFlexibleDimensionsPropertiesNV::saturatingAccumulation is VK_FALSE, SaturatingAccumulationKHR must not be used. The scope of all cooperative matrix operands must match VkCooperativeMatrixFlexibleDimensionsPropertiesNV::scope. If the scope is VK_SCOPE_WORKGROUP_KHR, the number of invocations in the local workgroup must match VkCooperativeMatrixFlexibleDimensionsPropertiesNV::workgroupInvocations", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-cooperativeMatrixFlexibleDimensionsMaxDimension-10167", "All OpTypeCooperativeMatrixKHR dimensions must be less than or equal to cooperativeMatrixFlexibleDimensionsMaxDimension", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-cooperativeMatrixSupportedStages-08985", "OpTypeCooperativeMatrixKHR and OpCooperativeMatrix* instructions must not be used in shader stages not included in VkPhysicalDeviceCooperativeMatrixPropertiesKHR::cooperativeMatrixSupportedStages", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-cooperativeMatrixWorkgroupScope-10164", "If the cooperativeMatrixWorkgroupScope feature is not enabled, the scope of all OpTypeCooperativeMatrixKHR must not be VkScopeKHR::VK_SCOPE_WORKGROUP_KHR", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-cooperativeVectorSupportedStages-10091", "OpTypeCooperativeVectorNV and OpCooperativeVector* instructions must not be used in shader stages not included in VkPhysicalDeviceCooperativeVectorPropertiesNV::cooperativeVectorSupportedStages", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-denormBehaviorIndependence-06289", "If denormBehaviorIndependence is VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY, then the entry point must use the same denormals Execution Mode for both 16-bit and 64-bit floating-point types", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-denormBehaviorIndependence-06290", "If denormBehaviorIndependence is VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE, then the entry point must use the same denormals Execution Mode for all floating-point types", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-flags-08761", "For OpRayQueryGetIntersectionTriangleVertexPositionsKHR instructions, Acceleration Structure must have been built with VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_DATA_ACCESS_BIT_KHR in flags", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maintenance4-06817", "If the maintenance4 feature is not enabled, any OpTypeVector output interface variables must not have a higher Component Count than a matching OpTypeVector input interface variable", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maintenance5-09190", "If the maintenance5 feature is enabled and a PointSize decorated variable is written to, all execution paths must write to a PointSize decorated variable", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxBlockMatchRegion-09225", "If a OpImageBlockMatchWindow*QCOM or OpImageBlockMatchGather*QCOM operation is used, then Block Size less than or equal to maxBlockMatchRegion", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxComputeSharedMemorySize-10168", "If the module uses OpTypeCooperativeMatrixKHR with Scope equal to Workgroup, the sum of size in bytes for variables and padding in the Workgroup Storage Class in the GLCompute Execution Model must be less than or equal to maxComputeSharedMemorySize minus cooperativeMatrixWorkgroupScopeReservedSharedMemory", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxCooperativeVectorComponents-10094", "OpTypeCooperativeVector instructions must have Component Count less than or equal to maxCooperativeVectorComponents", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxExecutionGraphShaderOutputNodes-09197", "Shaders must not include more than maxExecutionGraphShaderOutputNodes instances of OpInitializeNodePayloadsAMDX", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxExecutionGraphShaderPayloadCount-09196", "Shaders must not statically initialize more than maxExecutionGraphShaderPayloadCount variables in the NodeOutputPayloadAMDX storage class", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxExecutionGraphShaderPayloadSize-09193", "Variables declared in the NodePayloadAMDX storage class must not be larger than the maxExecutionGraphShaderPayloadSize limit", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxExecutionGraphShaderPayloadSize-09194", "Variables declared in the NodeOutputPayloadAMDX storage class must not be larger than the maxExecutionGraphShaderPayloadSize limit", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxExecutionGraphShaderPayloadSize-09195", "For a given entry point, the sum of the size of any variable in the NodePayloadAMDX storage class, and the combined size of all statically initialized variables in the NodeOutputPayloadAMDX storage class must not be greater than maxExecutionGraphShaderPayloadSize", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxMeshOutputMemorySize-08756", "The sum of size in bytes for variables in the Output Storage Class in the MeshEXT Execution Model must be less than or equal to maxMeshOutputMemorySize according to the formula in Mesh Shader Output", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxMeshPayloadAndOutputMemorySize-08757", "The sum of size in bytes for variables and in the TaskPayloadWorkgroupEXT or Output Storage Class in the MeshEXT Execution Model must be less than or equal to maxMeshPayloadAndOutputMemorySize according to the formula in Mesh Shader Output", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxMeshPayloadAndSharedMemorySize-08755", "The sum of size in bytes for variables and padding in the TaskPayloadWorkgroupEXT or Workgroup Storage Class in the MeshEXT Execution Model must be less than or equal to maxMeshPayloadAndSharedMemorySize", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxMeshSharedMemorySize-08754", "The sum of size in bytes for variables and padding in the Workgroup Storage Class in the MeshEXT Execution Model must be less than or equal to maxMeshSharedMemorySize", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxTaskPayloadAndSharedMemorySize-08760", "The sum of size in bytes for variables and padding in the TaskPayloadWorkgroupEXT or Workgroup Storage Class in the TaskEXT Execution Model must be less than or equal to maxTaskPayloadAndSharedMemorySize", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxTaskPayloadSize-08758", "The sum of size in bytes for variables and in the TaskPayloadWorkgroupEXT Storage Class in the TaskEXT Execution Model must be less than or equal to maxTaskPayloadSize", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxTaskSharedMemorySize-08759", "The sum of size in bytes for variables and padding in the Workgroup Storage Class in the TaskEXT Execution Model must be less than or equal to maxTaskSharedMemorySize", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxTensorShaderAccessArrayLength-09903", "The length of an array returned by OpTensorReadARM or passed as the Object operand to OpTensorWriteARM must be less than or equal to maxTensorShaderAccessArrayLength", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-maxTensorShaderAccessSize-09904", "The total size of the data (number of tensor elements x size of an element) read or written by one OpTensorReadARM, or OpTensorWriteARM instruction, respectively, must be less than or equal to maxTensorShaderAccessSize", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-meshAndTaskShaderDerivatives-10153", "If meshAndTaskShaderDerivatives is VK_FALSE, the DerivativeGroupLinearKHR and DerivativeGroupQuadsKHR execution modes must not be used in the MeshEXT, MeshNV, TaskEXT, or TaskNV Execution Model", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-minSampleShading-08731", "If sample shading is enabled and minSampleShading is 1.0, the sample operand of any OpColorAttachmentReadEXT, OpDepthAttachmentReadEXT, or OpStencilAttachmentReadEXT operation must evaluate to the value of the coverage index for any given fragment invocation", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-minSampleShading-08732", "If sample shading is enabled and any of the OpColorAttachmentReadEXT, OpDepthAttachmentReadEXT, or OpStencilAttachmentReadEXT operations are used, then minSampleShading must be 1.0", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-pNext-09226", "If a OpImageBlockMatchWindow*QCOM operation is used, then target sampled image must have been created using asampler object that included VkSamplerBlockMatchWindowCreateInfoQCOM in the pNext chain", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-pNext-09919", "For each data graph pipeline created with a VkDataGraphPipelineShaderModuleCreateInfoARM structure included in the pNext chain of VkDataGraphPipelineCreateInfoARM, the OpGraph that is used by the OpGraphEntryPointARM the pipeline is being created for must have an OpTypeGraphARM that only uses OpTypeTensorARM with Shape present", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-pNext-09920", "For each data graph pipeline created with a VkDataGraphPipelineShaderModuleCreateInfoARM structure included in the pNext chain of VkDataGraphPipelineCreateInfoARM, all the OpGraphConstantARM with OpTypeTensorARM type used by the OpGraph that is used by the OpGraphEntryPointARM the pipeline is being created for must have an OpTypeTensorARM with Shape present", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-pNext-09921", "For each data graph pipeline created with a VkDataGraphPipelineShaderModuleCreateInfoARM structure included in the pNext chain of VkDataGraphPipelineCreateInfoARM, one and only one VkDataGraphPipelineConstantARM structure that satisfies all the following constraints must be present in VkDataGraphPipelineShaderModuleCreateInfoARM::pConstants for each OpGraphConstantARM used by the OpGraph that has a OpTypeTensorARM type and is used by the OpGraphEntryPointARM the pipeline is being created for: its id member must match the GraphConstantID of the OpGraphConstantARM its pNext chain must include a VkTensorDescriptionARM structure whose dimensionCount is equal to the Rank of the OpTypeTensorARM of the OpGraphConstantARM whose pDimensions array elements are individually and in order equal to the elements of the array that defines the Shape of the OpTypeTensorARM of the OpGraphConstantARM whose format is compatible with the ElementType of the OpTypeTensorARM of the OpGraphConstantARM", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-pNext-09923", "For each data graph pipeline created with a VkDataGraphPipelineShaderModuleCreateInfoARM structure included in the pNext chain of VkDataGraphPipelineCreateInfoARM, one and only one VkDataGraphPipelineResourceInfoARM structure that satisfies all the following constraints must be present in VkDataGraphPipelineCreateInfoARM::pResourceInfos for each OpVariable with a OpTypeTensorARM type that is part of the Interface of the OpGraphEntryPointARM the pipeline is being created for: its descriptorSet member must match the DescriptorSet decoration applied to the OpVariable its binding member must match the Binding decoration applied to the OpVariable its arrayElement member must be zero if OpVariable is not a OpTypeArray or if OpVariable is a OpTypeArray of OpTypeTensorARM with Shape present its pNext chain must include a VkTensorDescriptionARM structure whose dimensionCount is equal to the Rank of the OpTypeTensorARM of the OpVariable or its elements whose pDimensions array elements are individually and in order equal to the elements of the array that defines the Shape of the OpTypeTensorARM of the OpVariable or its elements whose format is compatible with the ElementType of the OpTypeTensorARM of the OpVariable", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-protectedNoFault-09645", "If protectedNoFault is not supported, the Storage Class of the PhysicalStorageBuffer must not be used if the buffer being accessed is protected", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-roundingModeIndependence-06291", "If roundingModeIndependence is VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY, then the entry point must use the same rounding Execution Mode for both 16-bit and 64-bit floating-point types", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-roundingModeIndependence-06292", "If roundingModeIndependence is VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE, then the entry point must use the same rounding Execution Mode for all floating-point types", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-samples-08725", "If an OpTypeImage has an MS operand 0, its bound image must have been created with VkImageCreateInfo::samples as VK_SAMPLE_COUNT_1_BIT", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-samples-08726", "If an OpTypeImage has an MS operand 1, its bound image must not have been created with VkImageCreateInfo::samples as VK_SAMPLE_COUNT_1_BIT", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderDenormFlushToZeroFloat16-06299", "If shaderDenormFlushToZeroFloat16 is VK_FALSE, then DenormFlushToZero for 16-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderDenormFlushToZeroFloat32-06300", "If shaderDenormFlushToZeroFloat32 is VK_FALSE, then DenormFlushToZero for 32-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderDenormFlushToZeroFloat64-06301", "If shaderDenormFlushToZeroFloat64 is VK_FALSE, then DenormFlushToZero for 64-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderDenormPreserveFloat16-06296", "If shaderDenormPreserveFloat16 is VK_FALSE, then DenormPreserve for 16-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderDenormPreserveFloat32-06297", "If shaderDenormPreserveFloat32 is VK_FALSE, then DenormPreserve for 32-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderDenormPreserveFloat64-06298", "If shaderDenormPreserveFloat64 is VK_FALSE, then DenormPreserve for 64-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderDeviceClock-06268", "If the shaderDeviceClock feature is not enabled, the Device scope must not be used for OpReadClockKHR", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06767", "If the shaderEarlyAndLateFragmentTests feature is not enabled, the EarlyAndLateFragmentTestsEXT Execution Mode must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06768", "If the shaderEarlyAndLateFragmentTests feature is not enabled, the StencilRefUnchangedFrontEXT Execution Mode must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06769", "If the shaderEarlyAndLateFragmentTests feature is not enabled, the StencilRefUnchangedBackEXT Execution Mode must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06770", "If the shaderEarlyAndLateFragmentTests feature is not enabled, the StencilRefGreaterFrontEXT Execution Mode must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06771", "If the shaderEarlyAndLateFragmentTests feature is not enabled, the StencilRefGreaterBackEXT Execution Mode must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06772", "If the shaderEarlyAndLateFragmentTests feature is not enabled, the StencilRefLessFrontEXT Execution Mode must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderEarlyAndLateFragmentTests-06773", "If the shaderEarlyAndLateFragmentTests feature is not enabled, the StencilRefLessBackEXT Execution Mode must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderFloat16VectorAtomics-09581", "shaderFloat16VectorAtomics, must be enabled for 16-bit floating-point, 2- and 4-component vector atomic operations to be supported", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderRelaxedExtendedInstruction-10773", "If the shaderRelaxedExtendedInstruction feature is not enabled, the OpExtInstWithForwardRefsKHR must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderRoundingModeRTEFloat16-06302", "If shaderRoundingModeRTEFloat16 is VK_FALSE, then RoundingModeRTE for 16-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderRoundingModeRTEFloat32-06303", "If shaderRoundingModeRTEFloat32 is VK_FALSE, then RoundingModeRTE for 32-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderRoundingModeRTEFloat64-06304", "If shaderRoundingModeRTEFloat64 is VK_FALSE, then RoundingModeRTE for 64-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderRoundingModeRTZFloat16-06305", "If shaderRoundingModeRTZFloat16 is VK_FALSE, then RoundingModeRTZ for 16-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderRoundingModeRTZFloat32-06306", "If shaderRoundingModeRTZFloat32 is VK_FALSE, then RoundingModeRTZ for 32-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderRoundingModeRTZFloat64-06307", "If shaderRoundingModeRTZFloat64 is VK_FALSE, then RoundingModeRTZ for 64-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderSampleRateInterpolationFunctions-06325", "If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::shaderSampleRateInterpolationFunctions is VK_FALSE, then GLSL.std.450 fragment interpolation functions are not supported by the implementation and OpCapability must not be InterpolationFunction", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat16-06293", "If shaderSignedZeroInfNanPreserveFloat16 is VK_FALSE, then SignedZeroInfNanPreserve for 16-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat16-09559", "If shaderSignedZeroInfNanPreserveFloat16 is VK_FALSE then any FPFastMathDefault execution mode with a type of 16-bit float must include the NSZ, NotInf, and NotNaN flags", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat16-09560", "If shaderSignedZeroInfNanPreserveFloat16 is VK_FALSE then any FPFastMathMode decoration on an instruction with result type or any operand type that includes a 16-bit float must include the NSZ, NotInf, and NotNaN flags", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat32-06294", "If shaderSignedZeroInfNanPreserveFloat32 is VK_FALSE, then SignedZeroInfNanPreserve for 32-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat32-09561", "If shaderSignedZeroInfNanPreserveFloat32 is VK_FALSE then any FPFastMathDefault execution mode with a type of 32-bit float must include the NSZ, NotInf, and NotNaN flags", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat32-09562", "If shaderSignedZeroInfNanPreserveFloat32 is VK_FALSE then any FPFastMathMode decoration on an instruction with result type or any operand type that includes a 32-bit float must include the NSZ, NotInf, and NotNaN flags", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat64-06295", "If shaderSignedZeroInfNanPreserveFloat64 is VK_FALSE, then SignedZeroInfNanPreserve for 64-bit floating-point type must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat64-09563", "If shaderSignedZeroInfNanPreserveFloat64 is VK_FALSE then any FPFastMathDefault execution mode with a type of 64-bit float must include the NSZ, NotInf, and NotNaN flags", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderSignedZeroInfNanPreserveFloat64-09564", "If shaderSignedZeroInfNanPreserveFloat64 is VK_FALSE then any FPFastMathMode decoration on an instruction with result type or any operand type that includes a 64-bit float must include the NSZ, NotInf, and NotNaN flags", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderSubgroupClock-06267", "If the shaderSubgroupClock feature is not enabled, the Subgroup scope must not be used for OpReadClockKHR", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderSubgroupRotateClustered-09566", "If shaderSubgroupRotateClustered is VK_FALSE, then the ClusterSize operand to OpGroupNonUniformRotateKHR must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderTensorSupportedStages-09901", "OpTypeTensorARM, OpTensorReadARM, OpTensorWriteARM, or OpTensorQuerySizeARM must not be used in shader stages not in shaderTensorSupportedStages", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-shaderZeroInitializeWorkgroupMemory-06372", "If the shaderZeroInitializeWorkgroupMemory feature is not enabled, any OpVariable with Workgroup as its Storage Class must not have an Initializer operand", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-storageBuffer16BitAccess-06331", "If storageBuffer16BitAccess is VK_FALSE, then objects containing 16-bit integer or 16-bit floating-point elements must not have Storage Class of StorageBuffer, ShaderRecordBufferKHR, or PhysicalStorageBuffer", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-storageBuffer8BitAccess-06328", "If storageBuffer8BitAccess is VK_FALSE, then objects containing an 8-bit integer element must not have Storage Class of StorageBuffer, ShaderRecordBufferKHR, or PhysicalStorageBuffer", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-storageInputOutput16-06334", "If storageInputOutput16 is VK_FALSE, then objects containing 16-bit integer or 16-bit floating-point elements must not have Storage Class of Input or Output", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-storagePushConstant16-06333", "If storagePushConstant16 is VK_FALSE, then objects containing 16-bit integer or 16-bit floating-point elements must not have Storage Class of PushConstant", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-storagePushConstant8-06330", "If storagePushConstant8 is VK_FALSE, then objects containing an 8-bit integer element must not have Storage Class of PushConstant", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-subgroupBroadcastDynamicId-06276", "If subgroupBroadcastDynamicId is VK_TRUE, and the shader module version is 1.5 or higher, the \"Index\" for OpGroupNonUniformQuadBroadcast must be dynamically uniform within the derivative group. Otherwise, \"Index\" must be a constant", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-subgroupBroadcastDynamicId-06277", "If subgroupBroadcastDynamicId is VK_TRUE, and the shader module version is 1.5 or higher, the \"Id\" for OpGroupNonUniformBroadcast must be dynamically uniform within the subgroup. Otherwise, \"Id\" must be a constant", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-subgroupSize-10141", "If the effective subgroup size is 1, the UniformBufferArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a uniform buffer, the uniform buffer through which that memory is accessed must be dynamically uniform within the invocation group", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-subgroupSize-10142", "If the effective subgroup size is 1, the SampledImageArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a sampled image or sampler, the sampled image or sampler through which that memory is accessed must be dynamically uniform within the invocation group", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-subgroupSize-10143", "If the effective subgroup size is 1, the StorageBufferArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a storage buffer, the storage buffer through which that memory is accessed must be dynamically uniform within the invocation group", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-subgroupSize-10144", "If the effective subgroup size is 1, the StorageImageArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a storage image, the storage image through which that memory is accessed must be dynamically uniform within the invocation group", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-subgroupSize-10145", "If the effective subgroup size is 1, the InputAttachmentArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through an input attachment, the input attachment through which that memory is accessed must be dynamically uniform within the invocation group", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-subgroupSize-10146", "If the effective subgroup size is 1, the UniformTexelBufferArrayNonUniformIndexing capability is not declared, and an instruction accesses memory through a uniform texel buffer, the uniform texel buffer through which that memory is accessed must be dynamically uniform within the invocation group", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-subgroupSize-10147", "If the effective subgroup size is 1, the StorageTexelBufferArrayNonUniformIndexing capability is not is not declared, and an instruction accesses memory through a storage texel buffer, the storage texel buffer through which that memory is accessed must be dynamically uniform within the invocation group", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-subgroupSize-10149", "If an instruction accesses memory through any resource, the effective subgroup size is greater than 1, and the resource through which that memory is accessed is not uniform within the invocation group, and not uniform within the subgroup, then the operand corresponding to that resource (e.g. the pointer or sampled image operand) must be decorated with NonUniform", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-tessellationShader-06326", "If the tessellationShader feature is enabled, and the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::tessellationIsolines is VK_FALSE, then OpExecutionMode must not be IsoLines", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-tessellationShader-06327", "If the tessellationShader feature is enabled, and the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::tessellationPointMode is VK_FALSE, then OpExecutionMode must not be PointMode", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-tileShadingImageProcessing-10712", "If an OpTypeSampledImage with Storage Class TileAttachmentQCOM is consumed by any argument of the following operations, tileShadingImageProcessing must be enabled: OpImageSampleWeightedQCOM OpImageBoxFilterQCOM OpImageBlockMatch*QCOM", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-tileSize-10705", "In compute shaders that enables SPIR-V capability TileShadingQCOM, VkTilePropertiesQCOM::tileSize::z % TileShadingRateQCOM::z must equal 0", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-transformFeedbackStreamsLinesTriangles-06311", "If the geometry shader emits to more than one vertex stream and VkPhysicalDeviceTransformFeedbackPropertiesEXT::transformFeedbackStreamsLinesTriangles is VK_FALSE, then Execution Mode must be OutputPoints", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-uniformAndStorageBuffer16BitAccess-06332", "If uniformAndStorageBuffer16BitAccess is VK_FALSE, then objects in the Uniform Storage Class with the Block decoration must not have 16-bit integer or 16-bit floating-point members", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-uniformAndStorageBuffer8BitAccess-06329", "If uniformAndStorageBuffer8BitAccess is VK_FALSE, then objects in the Uniform Storage Class with the Block decoration must not have an 8-bit integer member", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-vulkanMemoryModel-06265", "If the vulkanMemoryModel feature is enabled and the vulkanMemoryModelDeviceScope feature is not enabled, Device memory scope must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-vulkanMemoryModel-06266", "If the vulkanMemoryModel feature is not enabled, QueueFamily memory scope must not be used", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-workgroupMemoryExplicitLayout16BitAccess-10757", "If workgroupMemoryExplicitLayout16BitAccess is VK_FALSE, then objects in the Workgroup Storage Class with the Block decoration must not have an 16-bit integer or 16-bit floating-point elements.", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-workgroupMemoryExplicitLayout8BitAccess-10756", "If workgroupMemoryExplicitLayout8BitAccess is VK_FALSE, then objects in the Workgroup Storage Class with the Block decoration must not have an 8-bit integer element.", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-x-06429", "In compute shaders using the GLCompute Execution Model the x size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupSize[0]", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-x-06432", "In compute shaders using the GLCompute Execution Model the product of x size, y size, and z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupInvocations", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-x-10702", "In compute shaders that enables SPIR-V capability TileShadingQCOM, the x size in TileShadingRateQCOM must be less than or equal to VkPhysicalDeviceTileShadingPropertiesQCOM::maxTileShadingRate::x", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-y-06430", "In compute shaders using the GLCompute Execution Model the y size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupSize[1]", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-y-10703", "In compute shaders that enables SPIR-V capability TileShadingQCOM, the y size in TileShadingRateQCOM must be less than or equal to VkPhysicalDeviceTileShadingPropertiesQCOM::maxTileShadingRate::y", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-z-06431", "In compute shaders using the GLCompute Execution Model the z size in LocalSize or LocalSizeId must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupSize[2]", "appendices/spirvenv.html"},
    {"VUID-RuntimeSpirv-z-10704", "In compute shaders that enables SPIR-V capability TileShadingQCOM, the z size in TileShadingRateQCOM must be less than or equal to VkTilePropertiesQCOM::tileSize::z", "appendices/spirvenv.html"},
    {"VUID-SMCountNV-SMCountNV-04363", "The variable decorated with SMCountNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-SMCountNV-SMCountNV-04364", "The variable decorated with SMCountNV must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-SMIDNV-SMIDNV-04365", "The variable decorated with SMIDNV must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-SMIDNV-SMIDNV-04366", "The variable decorated with SMIDNV must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-SampleId-SampleId-04354", "The SampleId decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-SampleId-SampleId-04355", "The variable decorated with SampleId must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-SampleId-SampleId-04356", "The variable decorated with SampleId must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-SampleMask-SampleMask-04357", "The SampleMask decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-SampleMask-SampleMask-04358", "The variable decorated with SampleMask must be declared using the Input or Output Storage Class", "chapters/interfaces.html"},
    {"VUID-SampleMask-SampleMask-04359", "The variable decorated with SampleMask must be declared as an array of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-SamplePosition-SamplePosition-04360", "The SamplePosition decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-SamplePosition-SamplePosition-04361", "The variable decorated with SamplePosition must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-SamplePosition-SamplePosition-04362", "The variable decorated with SamplePosition must be declared as a two-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-ShaderIndexAMDX-ShaderIndexAMDX-09175", "The variable decorated with ShaderIndexAMDX must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-ShaderIndexAMDX-ShaderIndexAMDX-09176", "The variable decorated with ShaderIndexAMDX must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-ShadingRateKHR-ShadingRateKHR-04490", "The ShadingRateKHR decoration must be used only within the Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-ShadingRateKHR-ShadingRateKHR-04491", "The variable decorated with ShadingRateKHR must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-ShadingRateKHR-ShadingRateKHR-04492", "The variable decorated with ShadingRateKHR must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-StandaloneSpirv-Base-07650", "The Base operand of OpPtrAccessChain must have a storage class of Workgroup, StorageBuffer, or PhysicalStorageBuffer", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Base-07651", "If the Base operand of OpPtrAccessChain has a Workgroup Storage Class, then the VariablePointers capability must be declared", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Base-07652", "If the Base operand of OpPtrAccessChain has a StorageBuffer Storage Class, then the VariablePointers or VariablePointersStorageBuffer capability must be declared", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-BuiltIn-04668", "Any BuiltIn decoration not listed in Built-In Variables must not be used", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-CallableDataKHR-04704", "CallableDataKHR Storage Class must only be used in ray generation, closest hit, miss, and callable shaders", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Component-04920", "The Component decoration value must not be greater than 3", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Component-04921", "If the Component decoration is used on an OpVariable that has a OpTypeVector type with a Component Type with a Width that is less than or equal to 32, the sum of its Component Count and the Component decoration value must be less than or equal to 4", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Component-04922", "If the Component decoration is used on an OpVariable that has a OpTypeVector type with a Component Type with a Width that is equal to 64, the sum of two times its Component Count and the Component decoration value must be less than or equal to 4", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Component-04923", "The Component decorations value must not be 1 or 3 for scalar or two-component 64-bit data types", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Component-07703", "The Component decorations must not be used for a 64-bit vector type with more than two components", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Component-10583", "The Component decorations must not be used with any type that is not a scalar, vector, array of scalars or vectors, or an array of arrays of scalars or vectors", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-DerivativeGroupLinearKHR-10152", "For compute, mesh, or task shaders using the DerivativeGroupLinearKHR execution mode, the product of the dimensions of the local workgroup size must be a multiple of four", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-DerivativeGroupLinearNV-04778", "For compute shaders using the DerivativeGroupLinearNV execution mode, the product of the dimensions of the local workgroup size must be a multiple of four", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-DerivativeGroupQuadsKHR-10151", "For compute, mesh, or task shaders using the DerivativeGroupQuadsKHR execution mode, the first two dimensions of the local workgroup size must be a multiple of two", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-DerivativeGroupQuadsNV-04684", "For compute shaders using the DerivativeGroupQuadsNV execution mode, the first two dimensions of the local workgroup size must be a multiple of two", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-DescriptorSet-06491", "If a variable is decorated by DescriptorSet or Binding, the Storage Class must correspond to an entry in Shader Resource and Storage Class Correspondence", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Execution-10584", "If the Execution Model of an entry point is not TessellationControl or Geometry, its interface definition must not include any variables in the Input storage class decorated with Component that are arrays of arrays of scalars or vectors", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Execution-10585", "If the Execution Model of an entry point is not MeshNV, its interface definition must not include any variables in the Output storage class decorated with Component that are arrays of arrays of scalars or vectors", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Execution-10687", "Execution Mode NonCoherentTileAttachmentReadQCOM must not be used in any stage other than fragment", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Execution-10688", "Execution Mode TileShadingRateQCOM must not be used in any stage other than compute", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-ExecutionModel-07320", "If the Execution Model is TessellationControl, and the MemoryModel is GLSL450, the Scope for memory must not be Workgroup", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-FPRoundingMode-04675", "Rounding modes other than round-to-nearest-even and round-towards-zero must not be used for the FPRoundingMode decoration", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Flat-04670", "The Flat, NoPerspective, Sample, and Centroid decorations must only be used on variables with the Output or Input Storage Class", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Flat-04744", "Any variable with integer or double-precision floating-point type and with Input Storage Class in a fragment shader, must be decorated Flat", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Flat-06201", "The Flat, NoPerspective, Sample, and Centroid decorations must not be used on variables with the Output storage class in a fragment shader", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Flat-06202", "The Flat, NoPerspective, Sample, and Centroid decorations must not be used on variables with the Input storage class in a vertex shader", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Function-04681", "A type T that is an array sized with a specialization constant must neither be, nor be contained in, the type T2 of a variable V, unless either: a) T is equal to T2, b) V is declared in the Function, or Private Storage Class, c) V is a non-Block variable in the Workgroup Storage Class, or d) V is an interface variable with an additional level of arrayness, as described in interface matching, and T is the member type of the array type T2", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-GLSLShared-04669", "The GLSLShared and GLSLPacked decorations must not be used", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-HitAttributeKHR-04701", "HitAttributeKHR Storage Class must only be used in intersection, any-hit, or closest hit shaders", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-HitAttributeKHR-04702", "There must be at most one variable with the HitAttributeKHR Storage Class in the input interface of an entry point", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-HitAttributeKHR-04703", "A variable with HitAttributeKHR Storage Class must only be written to in an intersection shader", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Image-04965", "The SPIR-V Type of the Image Format operand of an OpTypeImage must match the Sampled Type, as defined in Image Format and Type Matching", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-IncomingCallableDataKHR-04705", "IncomingCallableDataKHR Storage Class must only be used in callable shaders", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-IncomingCallableDataKHR-04706", "There must be at most one variable with the IncomingCallableDataKHR Storage Class in the input interface of an entry point", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-IncomingRayPayloadKHR-04699", "IncomingRayPayloadKHR Storage Class must only be used in closest hit, any-hit, or miss shaders", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-IncomingRayPayloadKHR-04700", "There must be at most one variable with the IncomingRayPayloadKHR Storage Class in the input interface of an entry point", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Input-06778", "Variables with a Storage Class of Input in a fragment shader stage that are decorated with PerVertexKHR must be declared as arrays", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Input-07290", "Variables with a Storage Class of Input or Output and a type of OpTypeBool must be decorated with the BuiltIn decoration", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Input-09557", "The pointers of any Input or Output Interface user-defined variables must not contain any PhysicalStorageBuffer Storage Class pointers", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Input-10588", "Variables in the Input storage class in the TessellationControl, TessellationEvaluation, Geometry, or Fragment execution model must not have overlapping Component and Location decorations as defined by Location and Component Assignment", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Input-10604", "Any variable in the Input storage class in the Fragment execution model must not have an assigned Location shared with another variable with different decorations for PerVertexKHR, Flat, NoPerspective, Sample, or Centroid", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-InputAttachmentArrayDynamicIndexing-10131", "If the InputAttachmentArrayDynamicIndexing capability is not declared, and an instruction accesses memory through an input attachment, the input attachmnet through which that memory is accessed must be determined by constant integral expressions", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-InputAttachmentIndex-06678", "Variables decorated with InputAttachmentIndex must be in the UniformConstant Storage Class", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Invariant-04677", "Variables decorated with Invariant and variables with structure types that have any members decorated with Invariant must be in the Output or Input Storage Class, Invariant used on an Input Storage Class variable or structure member has no effect", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Location-04915", "The Location or Component decorations must not be used with BuiltIn", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Location-04916", "The Location decorations must be used on user-defined variables", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Location-04917", "If a user-defined variable is not a pointer to a Block decorated OpTypeStruct, then the OpVariable must have a Location decoration", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Location-04918", "If a user-defined variable has a Location decoration, and the variable is a pointer to a OpTypeStruct, then the members of that structure must not have Location decorations", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Location-04919", "If a user-defined variable does not have a Location decoration, and the variable is a pointer to a Block decorated OpTypeStruct, then each member of the struct must have a Location decoration", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Location-06672", "The Location or Component decorations must only be used with the Input, Output, RayPayloadKHR, IncomingRayPayloadKHR, HitAttributeKHR, HitObjectAttributeNV, CallableDataKHR, IncomingCallableDataKHR, or ShaderRecordBufferKHR storage classes", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-MeshEXT-07102", "The module must not contain both an entry point that uses the TaskEXT or MeshEXT Execution Model and an entry point that uses the TaskNV or MeshNV Execution Model", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-MeshEXT-07106", "In mesh shaders using the MeshEXT Execution Model OpSetMeshOutputsEXT must be called before any outputs are written", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-MeshEXT-07107", "In mesh shaders using the MeshEXT Execution Model all variables declared as output must not be read from", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-MeshEXT-07108", "In mesh shaders using the MeshEXT Execution Model for OpSetMeshOutputsEXT instructions, the \"Vertex Count\" and \"Primitive Count\" operands must not depend on ViewIndex", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-MeshEXT-07109", "In mesh shaders using the MeshEXT Execution Model variables decorated with PrimitivePointIndicesEXT, PrimitiveLineIndicesEXT, or PrimitiveTriangleIndicesEXT declared as an array must not be accessed by indices that depend on ViewIndex", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-MeshEXT-07110", "In mesh shaders using the MeshEXT Execution Model any values stored in variables decorated with PrimitivePointIndicesEXT, PrimitiveLineIndicesEXT, or PrimitiveTriangleIndicesEXT must not depend on ViewIndex", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-MeshEXT-07111", "In mesh shaders using the MeshEXT Execution Model variables in workgroup or private Storage Class declared as or containing a composite type must not be accessed by indices that depend on ViewIndex", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-MeshEXT-07330", "In mesh shaders using the MeshEXT Execution Model the OutputVertices Execution Mode must be greater than 0", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-MeshEXT-07331", "In mesh shaders using the MeshEXT Execution Model the OutputPrimitivesEXT Execution Mode must be greater than 0", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-NonCoherentTileAttachmentReadQCOM-10690", "If the NonCoherentTileAttachmentReadQCOM Execution Mode is used, the TileShadingQCOM capability must be enabled", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04633", "Every entry point must have no return value and accept no arguments", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04634", "The static function-call graph for an entry point must not contain cycles; that is, static recursion is not allowed", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04635", "The Logical or PhysicalStorageBuffer64 addressing model must be selected", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04636", "Scope for execution must be limited to Workgroup or Subgroup", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04637", "If the Scope for execution is Workgroup, then it must only be used in the task, mesh, tessellation control, or compute Execution Model", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04638", "Scope for memory must be limited to Device, QueueFamily, Workgroup, ShaderCallKHR, Subgroup, or Invocation", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04640", "If the Scope for memory is ShaderCallKHR, then it must only be used in ray generation, intersection, closest hit, any-hit, miss, and callable Execution Model", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04641", "If the Scope for memory is Invocation, then memory semantics must be None", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04642", "Scope for group operations must be limited to Subgroup", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04643", "Storage Class must be limited to UniformConstant, Input, Uniform, Output, Workgroup, Private, Function, PushConstant, Image, StorageBuffer, RayPayloadKHR, IncomingRayPayloadKHR, HitAttributeKHR, CallableDataKHR, IncomingCallableDataKHR, ShaderRecordBufferKHR, PhysicalStorageBuffer, or TileImageEXT", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04644", "If the Storage Class is Output, then it must not be used in the GlCompute, RayGenerationKHR, IntersectionKHR, AnyHitKHR, ClosestHitKHR, MissKHR, or CallableKHR Execution Model", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04645", "If the Storage Class is Workgroup, then it must only be used in the task, mesh, or compute Execution Model", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04667", "Structure types must not contain opaque types", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04686", "The Pointer operand of all atomic instructions must have a Storage Class limited to Uniform, Workgroup, Image, StorageBuffer, PhysicalStorageBuffer, or TaskPayloadWorkgroupEXT", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-04745", "All block members in a variable with a Storage Class of PushConstant declared as an array must only be accessed by dynamically uniform indices", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-07321", "If the Scope for memory is Workgroup, then it must only be used in the task, mesh, tessellation control, or compute Execution Model", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-08720", "If the Storage Class is TileImageEXT, then it must only be used in the fragment execution model", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-08724", "The TileImageEXT Storage Class must only be used for declaring tile image variables", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-10684", "All variables must have valid explicit layout decorations as described in Shader Interfaces", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-None-10685", "For each compute shader entry point, either a TileShadingRateQCOM, LocalSize, or LocalSizeId Execution Mode, or an object decorated with the WorkgroupSize decoration must be specified", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Offset-04687", "Output variables or block members decorated with Offset that have a 64-bit type, or a composite type containing a 64-bit type, must specify an Offset value aligned to a 8 byte boundary", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Offset-04689", "The size of any output block containing any member decorated with Offset that is a 64-bit type must be a multiple of 8", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Offset-04690", "The first member of an output block specifying a Offset decoration must specify a Offset value that is aligned to an 8 byte boundary if that block contains any member decorated with Offset and is a 64-bit type", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Offset-04691", "Output variables or block members decorated with Offset that have a 32-bit type, or a composite type contains a 32-bit type, must specify an Offset value aligned to a 4 byte boundary", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Offset-04692", "Output variables, blocks or block members decorated with Offset must only contain base types that have components that are either 32-bit or 64-bit in size", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Offset-04716", "Only variables or block members in the output interface decorated with Offset can be captured for transform feedback, and those variables or block members must also be decorated with XfbBuffer and XfbStride, or inherit XfbBuffer and XfbStride decorations from a block containing them", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Offset-04865", "Any image instruction which uses an Offset, ConstOffset, or ConstOffsets image operand, must only consume a \"Sampled Image\" operand whose type has its \"Sampled\" operand set to 1", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpAtomicLoad-04731", "OpAtomicLoad must not use Release, AcquireRelease, or SequentiallyConsistent memory semantics", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpAtomicStore-04730", "OpAtomicStore must not use Acquire, AcquireRelease, or SequentiallyConsistent memory semantics", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpControlBarrier-04650", "If the semantics for OpControlBarrier includes one of Acquire, Release, AcquireRelease, or SequentiallyConsistent memory semantics, then it must include at least one Storage Class", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpControlBarrier-04682", "If OpControlBarrier is used in ray generation, intersection, any-hit, closest hit, miss, fragment, vertex, tessellation evaluation, or geometry shaders, the execution Scope must be Subgroup", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpControlBarrier-10609", "If the semantics for OpControlBarrier includes at least one Storage Class, then it must include one of Acquire, Release, AcquireRelease, or SequentiallyConsistent memory semantics", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpEntryPoint-06674", "Each OpEntryPoint must not statically use more than one OpVariable in the PushConstant Storage Class", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpEntryPoint-08721", "Each OpEntryPoint must not have more than one Input variable assigned the same Component word inside a Location slot, either explicitly or implicitly", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpEntryPoint-08722", "Each OpEntryPoint must not have more than one Output variable assigned the same Component word inside a Location slot, either explicitly or implicitly", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpEntryPoint-09658", "For a given OpEntryPoint, any BuiltIn decoration must not be used more than once by the Input interface", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpEntryPoint-09659", "For a given OpEntryPoint, any BuiltIn decoration must not be used more than once by the Output interface", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpGraphInputARM-09931", "The InputIndex and ElementIndex operands to OpGraphInputARM must be the of a constant instruction", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpGraphSetOutputARM-09932", "The OutputIndex and ElementIndex operands to OpGraphSetOutputARM must be the of a constant instruction", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpGroupNonUniformBallotBitCount-04685", "If OpGroupNonUniformBallotBitCount is used, the group operation must be limited to Reduce, InclusiveScan, or ExclusiveScan", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpImage-04777", "OpImage*Dref* instructions must not consume an image whose Dim is 3D", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpImageGather-04664", "The \"Component\" operand of OpImageGather, and OpImageSparseGather must be the of a constant instruction", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpImageQuerySizeLod-04659", "OpImageQuerySizeLod, OpImageQueryLod, and OpImageQueryLevels must only consume an \"Image\" operand whose type has its \"Sampled\" operand set to 1", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpImageTexelPointer-04658", "If an OpImageTexelPointer is used in an atomic operation, the image type of the image parameter to OpImageTexelPointer must have an image format of R64i, R64ui, R32f, R32i, or R32ui", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpMemoryBarrier-04732", "OpMemoryBarrier must use one of Acquire, Release, AcquireRelease, or SequentiallyConsistent memory semantics", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpMemoryBarrier-04733", "OpMemoryBarrier must include at least one Storage Class", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpReadClockKHR-04652", "Scope for OpReadClockKHR must be limited to Subgroup or Device", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpTypeFloat-10370", "Variables with a type of OpTypeFloat and an encoding of BFloat16KHR must not be declared with a Storage Class of Input or Output", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpTypeFloat-10823", "Variables with a type of OpTypeFloat and an encoding of Float8E4M3EXT or Float8E5M2EXT must not be declared with a Storage Class of Input or Output", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpTypeForwardPointer-04711", "OpTypeForwardPointer must have a Storage Class of PhysicalStorageBuffer", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpTypeImage-04656", "OpTypeImage must declare a scalar 32-bit float, 64-bit integer, or 32-bit integer type for the \"Sampled Type\" (RelaxedPrecision can be applied to a sampling instruction and to the variable holding the result of a sampling instruction)", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpTypeImage-04657", "OpTypeImage must have a \"Sampled\" operand of 1 (sampled image) or 2 (storage image)", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpTypeImage-06214", "An OpTypeImage with a \"Dim\" operand of SubpassData must have an \"Arrayed\" operand of 0 (non-arrayed) and a \"Sampled\" operand of 2 (storage image)", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpTypeImage-06924", "Objects of types OpTypeImage, OpTypeSampler, OpTypeSampledImage, OpTypeAccelerationStructureKHR, OpTypeTensorARM, and arrays of these types must not be stored to or modified", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpTypeImage-09638", "An OpTypeImage must not have a \"Dim\" operand of Rect", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpTypeImage-10693", "OpTypeImage variables in the TileAttachmentQCOM Storage Class must have Dim equal to 2D", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpTypeImage-10694", "OpTypeImage variables in the TileAttachmentQCOM Storage Class must Sampled equal to 1 or 2", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpTypeRuntimeArray-04680", "OpTypeRuntimeArray must only be used for: the last member of a Block-decorated OpTypeStruct in StorageBuffer or PhysicalStorageBuffer storage Storage Class BufferBlock-decorated OpTypeStruct in the Uniform storage Storage Class the outermost dimension of an arrayed variable in the StorageBuffer, Uniform, or UniformConstant storage Storage Class variables in the NodePayloadAMDX storage Storage Class when the CoalescingAMDX Execution Mode is specified", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpTypeSampledImage-06671", "OpTypeSampledImage must have a OpTypeImage with a \"Sampled\" operand of 1 (sampled image)", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpVariable-04651", "Any OpVariable with an Initializer operand must have Output, Private, Function, or Workgroup as its Storage Class operand", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpVariable-04734", "Any OpVariable with an Initializer operand and Workgroup as its Storage Class operand must use OpConstantNull as the initializer", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OpVariable-06673", "There must not be more than one OpVariable in the PushConstant Storage Class listed in the Interface for each OpEntryPoint", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-OriginLowerLeft-04653", "The OriginLowerLeft Execution Mode must not be used; fragment entry points must declare OriginUpperLeft", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Output-10586", "Variables in the Output storage class in the Vertex, TessellationControl, TessellationEvaluation, or Geometry execution model must not have overlapping Component and Location decorations as defined by Location and Component Assignment", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Output-10587", "Variables in the Output storage class in the Fragment execution model must not have both identical Index decorations and overlapping Component and Location decorations as defined by Location and Component Assignment", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-PerVertexKHR-06777", "The PerVertexKHR decoration must only be used on variables with the Input Storage Class in a fragment shader", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-PhysicalStorageBuffer64-04708", "If the PhysicalStorageBuffer64 addressing model is enabled, all instructions that support memory access operands and that use a physical pointer must include the Aligned operand", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-PhysicalStorageBuffer64-04709", "If the PhysicalStorageBuffer64 addressing model is enabled, any access chain instruction that accesses into a RowMajor matrix must only be used as the Pointer operand to OpLoad or OpStore", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-PhysicalStorageBuffer64-04710", "If the PhysicalStorageBuffer64 addressing model is enabled, OpConvertUToPtr and OpConvertPtrToU must use an integer type whose Width is 64", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-PixelCenterInteger-04654", "The PixelCenterInteger Execution Mode must not be used (pixels are always centered at half-integer coordinates)", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Pointer-08973", "The Storage Class of the Pointer operand to OpCooperativeMatrixLoadKHR or OpCooperativeMatrixStoreKHR must be limited to Workgroup, StorageBuffer, or PhysicalStorageBuffer", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-PushConstant-06675", "Any variable in the PushConstant or StorageBuffer storage class must be decorated as Block", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-PushConstant-06808", "Any variable in the PushConstant Storage Class must be typed as OpTypeStruct", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-RayPayloadKHR-04698", "RayPayloadKHR Storage Class must only be used in ray generation, closest hit or miss shaders", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Result-04780", "The Result Type operand of any OpImageRead or OpImageSparseRead instruction must be a vector of four components", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-SampledImageArrayDynamicIndexing-10128", "If the SampledImageArrayDynamicIndexing capability is not declared, and an instruction accesses memory through a sampled image or sampler, the sampled image or sampler through which that memory is accessed must be determined by constant integral expressions", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-ShaderRecordBufferKHR-07119", "ShaderRecordBufferKHR Storage Class must only be used in ray generation, intersection, any-hit, closest hit, callable, or miss shaders", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-StorageBufferArrayDynamicIndexing-10129", "If the StorageBufferArrayDynamicIndexing capability is not declared, and an instruction accesses memory through a storage buffer, the storage buffer through which that memory is accessed must be determined by constant integral expressions", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-StorageImageArrayDynamicIndexing-10130", "If the StorageImageArrayDynamicIndexing capability is not declared, and an instruction accesses memory through a storage image, the storage image through which that memory is accessed must be determined by constant integral expressions", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-StorageTexelBufferArrayDynamicIndexing-10133", "If the StorageTexelBufferArrayDynamicIndexing capability is not declared, and an instruction accesses memory through a storage texel buffer, the storage texel buffer through which that memory is accessed must be determined by constant integral expressions", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Stream-04694", "If any variables or block members in the output interface of the entry point being compiled are decorated with Stream, then all variables belonging to the same XfbBuffer must specify the same Stream value", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-SubgroupVoteKHR-07951", "If none of the SubgroupVoteKHR, GroupNonUniform, or SubgroupBallotKHR capabilities are declared, Scope for memory must not be Subgroup", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-SubpassData-04660", "The (u,v) coordinates used for a SubpassData must be the of a constant vector (0,0)", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-TileAttachmentQCOM-10689", "If the TileAttachmentQCOM Storage Class is used, the TileShadingQCOM capability must be enabled", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-TileAttachmentQCOM-10695", "Any variable in the TileAttachmentQCOM Storage Class must be decorated with DescriptorSet and Binding", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-TileAttachmentQCOM-10696", "Any variable in the TileAttachmentQCOM Storage Class must not be decorated with Component decoration", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-TileAttachmentQCOM-10697", "An OpTypeImage variables in the TileAttachmentQCOM Storage Class must not be consumed by an OpImageQuery* instruction", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-TileImageEXT-08723", "The tile image variable declarations must obey the constraints on the TileImageEXT Storage Class and the Location decoration described in Fragment Tile Image Interface", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-TileShadingQCOM-10686", "TileShadingQCOM capability must not be enabled in any stage other than compute or fragment", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-TileShadingRateQCOM-10691", "If the TileShadingRateQCOM Execution Mode is used, the TileShadingQCOM capability must be enabled", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-TileShadingRateQCOM-10692", "If the TileShadingRateQCOM Execution Mode is used, LocalSize and LocalSizeId Execution Mode must not be specified", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Uniform-06676", "Any variable in the Uniform Storage Class must be decorated as Block or BufferBlock", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Uniform-06807", "Any variable in the Uniform or StorageBuffer Storage Class must be typed as OpTypeStruct or an array of this type", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-Uniform-06925", "Any variable in the Uniform Storage Class decorated as Block must not be stored to or modified", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-UniformBufferArrayDynamicIndexing-10127", "If the UniformBufferArrayDynamicIndexing capability is not declared, and an instruction accesses memory through a uniform buffer, the uniform buffer through which that memory is accessed must be determined by constant integral expressions", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-UniformConstant-04655", "Any variable in the UniformConstant Storage Class must be typed as either OpTypeImage, OpTypeSampler, OpTypeSampledImage, OpTypeAccelerationStructureKHR, OpTypeTensorARM or an array of one of these types", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-UniformConstant-06677", "Any variable in the UniformConstant, StorageBuffer, or Uniform Storage Class must be decorated with DescriptorSet and Binding", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-UniformTexelBufferArrayDynamicIndexing-10132", "If the UniformTexelBufferArrayDynamicIndexing capability is not declared, and an instruction accesses memory through a uniform texel buffer, the uniform texel buffer through which that memory is accessed must be determined by constant integral expressions", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-ViewportMaskNV-04674", "The ViewportMaskNV and ViewportIndex decorations must not both be statically used by one or more OpEntryPoint's that form the pre-rasterization shader stages of a graphics pipeline", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-ViewportRelativeNV-04672", "The ViewportRelativeNV decoration must only be used on a variable decorated with Layer in the vertex, tessellation evaluation, or geometry shader stages", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-ViewportRelativeNV-04673", "The ViewportRelativeNV decoration must not be used unless a variable decorated with one of ViewportIndex or ViewportMaskNV is also statically used by the same OpEntryPoint", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-VulkanMemoryModel-04678", "If the VulkanMemoryModel capability is not declared, the Volatile decoration must be used on any variable declaration that includes one of the SMIDNV, WarpIDNV, SubgroupSize, SubgroupLocalInvocationId, SubgroupEqMask, SubgroupGeMask, SubgroupGtMask, SubgroupLeMask, or SubgroupLtMask BuiltIn decorations when used in the ray generation, closest hit, miss, intersection, or callable shaders, or with the RayTmaxKHR Builtin decoration when used in an intersection shader", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-VulkanMemoryModel-04679", "If the VulkanMemoryModel capability is declared, the OpLoad instruction must use the Volatile memory semantics when it accesses into any variable that includes one of the SMIDNV, WarpIDNV, SubgroupSize, SubgroupLocalInvocationId, SubgroupEqMask, SubgroupGeMask, SubgroupGtMask, SubgroupLeMask, or SubgroupLtMask BuiltIn decorations when used in the ray generation, closest hit, miss, intersection, or callable shaders, or with the RayTmaxKHR Builtin decoration when used in an intersection shader", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-XfbBuffer-04693", "All variables or block members in the output interface of the entry point being compiled decorated with a specific XfbBuffer value must all be decorated with identical XfbStride values", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-XfbBuffer-04696", "For any two variables or block members in the output interface of the entry point being compiled with the same XfbBuffer value, the ranges determined by the Offset decoration and the size of the type must not overlap", "appendices/spirvenv.html"},
    {"VUID-StandaloneSpirv-XfbBuffer-04697", "All block members in the output interface of the entry point being compiled that are in the same block and have a declared or inherited XfbBuffer decoration must specify the same XfbBuffer value", "appendices/spirvenv.html"},
    {"VUID-SubgroupEqMask-SubgroupEqMask-04370", "The variable decorated with SubgroupEqMask must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-SubgroupEqMask-SubgroupEqMask-04371", "The variable decorated with SubgroupEqMask must be declared as a four-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-SubgroupGeMask-SubgroupGeMask-04372", "The variable decorated with SubgroupGeMask must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-SubgroupGeMask-SubgroupGeMask-04373", "The variable decorated with SubgroupGeMask must be declared as a four-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-SubgroupGtMask-SubgroupGtMask-04374", "The variable decorated with SubgroupGtMask must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-SubgroupGtMask-SubgroupGtMask-04375", "The variable decorated with SubgroupGtMask must be declared as a four-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-SubgroupId-SubgroupId-04367", "The SubgroupId decoration must be used only within the GLCompute, MeshEXT, TaskEXT, MeshNV, or TaskNV Execution Model", "chapters/interfaces.html"},
    {"VUID-SubgroupId-SubgroupId-04368", "The variable decorated with SubgroupId must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-SubgroupId-SubgroupId-04369", "The variable decorated with SubgroupId must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-SubgroupLeMask-SubgroupLeMask-04376", "The variable decorated with SubgroupLeMask must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-SubgroupLeMask-SubgroupLeMask-04377", "The variable decorated with SubgroupLeMask must be declared as a four-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-SubgroupLocalInvocationId-SubgroupLocalInvocationId-04380", "The variable decorated with SubgroupLocalInvocationId must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-SubgroupLocalInvocationId-SubgroupLocalInvocationId-04381", "The variable decorated with SubgroupLocalInvocationId must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-SubgroupLtMask-SubgroupLtMask-04378", "The variable decorated with SubgroupLtMask must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-SubgroupLtMask-SubgroupLtMask-04379", "The variable decorated with SubgroupLtMask must be declared as a four-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-SubgroupSize-SubgroupSize-04382", "The variable decorated with SubgroupSize must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-SubgroupSize-SubgroupSize-04383", "The variable decorated with SubgroupSize must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-TaskCountNV-TaskCountNV-04384", "The TaskCountNV decoration must be used only within the TaskNV Execution Model", "chapters/interfaces.html"},
    {"VUID-TaskCountNV-TaskCountNV-04385", "The variable decorated with TaskCountNV must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-TaskCountNV-TaskCountNV-04386", "The variable decorated with TaskCountNV must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-TessCoord-TessCoord-04387", "The TessCoord decoration must be used only within the TessellationEvaluation Execution Model", "chapters/interfaces.html"},
    {"VUID-TessCoord-TessCoord-04388", "The variable decorated with TessCoord must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-TessCoord-TessCoord-04389", "The variable decorated with TessCoord must be declared as a three-component vector of 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-TessLevelInner-TessLevelInner-04394", "The TessLevelInner decoration must be used only within the TessellationControl or TessellationEvaluation Execution Model", "chapters/interfaces.html"},
    {"VUID-TessLevelInner-TessLevelInner-04395", "The variable decorated with TessLevelInner within the TessellationControl Execution Model must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-TessLevelInner-TessLevelInner-04396", "The variable decorated with TessLevelInner within the TessellationEvaluation Execution Model must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-TessLevelInner-TessLevelInner-04397", "The variable decorated with TessLevelInner must be declared as an array of size two, containing 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-TessLevelOuter-TessLevelOuter-04390", "The TessLevelOuter decoration must be used only within the TessellationControl or TessellationEvaluation Execution Model", "chapters/interfaces.html"},
    {"VUID-TessLevelOuter-TessLevelOuter-04391", "The variable decorated with TessLevelOuter within the TessellationControl Execution Model must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-TessLevelOuter-TessLevelOuter-04392", "The variable decorated with TessLevelOuter within the TessellationEvaluation Execution Model must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-TessLevelOuter-TessLevelOuter-04393", "The variable decorated with TessLevelOuter must be declared as an array of size four, containing 32-bit floating-point values", "chapters/interfaces.html"},
    {"VUID-TileApronSizeQCOM-TileApronSizeQCOM-10632", "The TileApronSizeQCOM decoration must be used only within the Fragment Execution Model or GLCompute Execution Model", "chapters/interfaces.html"},
    {"VUID-TileApronSizeQCOM-TileApronSizeQCOM-10633", "The variable decorated with TileApronSizeQCOM must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-TileApronSizeQCOM-TileApronSizeQCOM-10634", "The variable decorated with TileApronSizeQCOM must be declared as a two-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-TileDimensionQCOM-TileDimensionQCOM-10629", "The TileDimensionQCOM decoration must be used only within the Fragment Execution Model or GLCompute Execution Model", "chapters/interfaces.html"},
    {"VUID-TileDimensionQCOM-TileDimensionQCOM-10630", "The variable decorated with TileDimensionQCOM must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-TileDimensionQCOM-TileDimensionQCOM-10631", "The variable decorated with TileDimensionQCOM must be declared as a two-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-TileOffsetQCOM-TileOffsetQCOM-10626", "The TileOffsetQCOM decoration must be used only within the Fragment Execution Model or GLCompute Execution Model", "chapters/interfaces.html"},
    {"VUID-TileOffsetQCOM-TileOffsetQCOM-10627", "The variable decorated with TileOffsetQCOM must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-TileOffsetQCOM-TileOffsetQCOM-10628", "The variable decorated with TileOffsetQCOM must be declared as a two-component vector of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-VertexCountHUAWEI-VertexCountHUAWEI-07809", "The VertexCountHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "chapters/interfaces.html"},
    {"VUID-VertexCountHUAWEI-VertexCountHUAWEI-07810", "The variable decorated with VertexCountHUAWEI must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-VertexIndex-VertexIndex-04398", "The VertexIndex decoration must be used only within the Vertex Execution Model", "chapters/interfaces.html"},
    {"VUID-VertexIndex-VertexIndex-04399", "The variable decorated with VertexIndex must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-VertexIndex-VertexIndex-04400", "The variable decorated with VertexIndex must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-VertexOffsetHUAWEI-VertexOffsetHUAWEI-07811", "The VertexOffsetHUAWEI decoration must be used only within the ClusterCullingHUAWEI Execution Model", "chapters/interfaces.html"},
    {"VUID-VertexOffsetHUAWEI-VertexOffsetHUAWEI-07812", "The variable decorated with VertexOffsetHUAWEI must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-ViewIndex-ViewIndex-04401", "The ViewIndex decoration must be used only within the MeshEXT, Vertex, Geometry, TessellationControl, TessellationEvaluation or Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-ViewIndex-ViewIndex-04402", "The variable decorated with ViewIndex must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-ViewIndex-ViewIndex-04403", "The variable decorated with ViewIndex must be declared as a scalar 32-bit integer value", "chapters/interfaces.html"},
    {"VUID-ViewportIndex-ViewportIndex-04404", "The ViewportIndex decoration must be used only within the MeshEXT, MeshNV, Vertex, TessellationEvaluation, Geometry, or Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-ViewportIndex-ViewportIndex-04405", "If the shaderOutputViewportIndex feature is not enabled then the ViewportIndex decoration must be used only within the Geometry or Fragment Execution Model", "chapters/interfaces.html"},
    {"VUID-ViewportIndex-ViewportIndex-04406", "The variable decorated with ViewportIndex within the MeshEXT, MeshNV, Vertex, TessellationEvaluation, or Geometry Execution Model must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-ViewportIndex-ViewportIndex-04407", "The variable decorated with ViewportIndex within the Fragment Execution Model must be declared using the Input Storage Class", "chapters/interfaces.html"},
    {"VUID-ViewportIndex-ViewportIndex-04408", "The variable decorated with ViewportIndex must be declared as a scalar 32-bit integer value for all supported execution models except MeshEXT", "chapters/interfaces.html"},
    {"VUID-ViewportIndex-ViewportIndex-07060", "The variable decorated with ViewportIndex within the MeshEXT Execution Model must also be decorated with the PerPrimitiveEXT decoration", "chapters/interfaces.html"},
    {"VUID-ViewportIndex-ViewportIndex-10601", "ViewportIndex within the MeshEXT Execution Model must decorate a scalar boolean member of a structure decorated as Block, or decorate a variable of type OpTypeArray of boolean values", "chapters/interfaces.html"},
    {"VUID-ViewportIndex-ViewportIndex-10602", "If ViewportIndex is declared as an array of boolean values, the size of the array must match the value specified by OutputPrimitivesEXT", "chapters/interfaces.html"},
    {"VUID-ViewportIndex-ViewportIndex-10603", "If ViewportIndex decorates a member of a structure, the variable declaration of the containing Block type must have an array size that matches the value specified by OutputPrimitivesEXT", "chapters/interfaces.html"},
    {"VUID-ViewportMaskNV-ViewportMaskNV-04409", "The ViewportMaskNV decoration must be used only within the Vertex, MeshNV, TessellationEvaluation, or Geometry Execution Model", "chapters/interfaces.html"},
    {"VUID-ViewportMaskNV-ViewportMaskNV-04410", "The variable decorated with ViewportMaskNV must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-ViewportMaskNV-ViewportMaskNV-04411", "The variable decorated with ViewportMaskNV must be declared as an array of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04412", "The ViewportMaskPerViewNV decoration must be used only within the Vertex, MeshNV, TessellationControl, TessellationEvaluation, or Geometry Execution Model", "chapters/interfaces.html"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04413", "The variable decorated with ViewportMaskPerViewNV must be declared using the Output Storage Class", "chapters/interfaces.html"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04414", "The variable decorated with ViewportMaskPerViewNV must be declared as an array of 32-bit integer values", "chapters/interfaces.html"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04415", "The array decorated with ViewportMaskPerViewNV must be a size less than or equal to 32", "chapters/interfaces.html"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04416", "The array decorated with ViewportMaskPerViewNV must be a size greater than the maximum view in the subpass's view mask", "chapters/interfaces.html"},
    {"VUID-ViewportMaskPerViewNV-ViewportMaskPerViewNV-04417", "The array variable decorated with ViewportMaskPerViewNV must only be indexed by a constant or specialization constant", "chapters/interfaces.html"},
    {"VUID-VkAabbPositionsKHR-minX-03546", "minX must be less than or equal to maxX", "chapters/accelstructures.html"},
    {"VUID-VkAabbPositionsKHR-minY-03547", "minY must be less than or equal to maxY", "chapters/accelstructures.html"},
    {"VUID-VkAabbPositionsKHR-minZ-03548", "minZ must be less than or equal to maxZ", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-commonparent", "Both of dstAccelerationStructure, and srcAccelerationStructure that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-dstAccelerationStructure-04927", "If dstAccelerationStructure was created with VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV set in VkAccelerationStructureCreateInfoKHR::createFlags, VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV must be set in flags", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-03796", "If flags has the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR bit set, then it must not have the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR bit set", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-04928", "If VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV is set in flags, dstAccelerationStructure must have been created with VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV set in VkAccelerationStructureCreateInfoKHR::createFlags", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-04929", "If VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV is set in flags, type must not be VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-07334", "If flags has the VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_UPDATE_BIT_EXT bit set then it must not have the VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_OPACITY_MICROMAP_DATA_UPDATE_BIT_EXT bit set", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-flags-parameter", "flags must be a valid combination of VkBuildAccelerationStructureFlagBitsKHR values", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-pGeometries-03788", "If geometryCount is not 0, exactly one of pGeometries or ppGeometries must be a valid pointer, the other must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-pGeometries-parameter", "If geometryCount is not 0, and pGeometries is not NULL, pGeometries must be a valid pointer to an array of geometryCount valid VkAccelerationStructureGeometryKHR structures", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-ppGeometries-parameter", "If geometryCount is not 0, and ppGeometries is not NULL, ppGeometries must be a valid pointer to an array of geometryCount valid pointers to valid VkAccelerationStructureGeometryKHR structures", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03654", "type must not be VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03789", "If type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, the geometryType member of elements of either pGeometries or ppGeometries must be VK_GEOMETRY_TYPE_INSTANCES_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03790", "If type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, geometryCount must be 1", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03791", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR the geometryType member of elements of either pGeometries or ppGeometries must not be VK_GEOMETRY_TYPE_INSTANCES_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03792", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR then the geometryType member of each geometry in either pGeometries or ppGeometries must be the same", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03793", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR then geometryCount must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxGeometryCount", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03794", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR and the geometryType member of either pGeometries or ppGeometries is VK_GEOMETRY_TYPE_AABBS_KHR, the total number of AABBs in all geometries must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxPrimitiveCount", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-03795", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR and the geometryType member of either pGeometries or ppGeometries is VK_GEOMETRY_TYPE_TRIANGLES_KHR, the total number of triangles in all geometries must be less than or equal to VkPhysicalDeviceAccelerationStructurePropertiesKHR::maxPrimitiveCount", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildGeometryInfoKHR-type-parameter", "type must be a valid VkAccelerationStructureTypeKHR value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-None-10775", "For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, if the geometry does not use indices, then VkAccelerationStructureGeometryTrianglesDataKHR::maxVertex must be greater than or equal to firstVertex + primitiveCount x 3 - 1", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-maxVertex-10774", "For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, if the geometry uses indices, then VkAccelerationStructureGeometryTrianglesDataKHR::maxVertex must be greater than or equal to firstVertex plus the maximum index value found in the VkAccelerationStructureGeometryTrianglesDataKHR::indexData in the range [primitiveOffset, primitiveOffset primitiveCount x 3]", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03656", "For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, if the geometry uses indices, the offset primitiveOffset from VkAccelerationStructureGeometryTrianglesDataKHR::indexData must be a multiple of the element size of VkAccelerationStructureGeometryTrianglesDataKHR::indexType", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03657", "For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, if the geometry does not use indices, the offset primitiveOffset from VkAccelerationStructureGeometryTrianglesDataKHR::vertexData must be a multiple of: the size of the format specified in VkAccelerationStructureGeometryTrianglesDataKHR::vertexFormat, if that format is a packed format the component size of the VkAccelerationStructureGeometryTrianglesDataKHR::vertexFormat, if that format is not a packed format", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03659", "For geometries of type VK_GEOMETRY_TYPE_AABBS_KHR, the offset primitiveOffset from VkAccelerationStructureGeometryAabbsDataKHR::data must be a multiple of 8", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-primitiveOffset-03660", "For geometries of type VK_GEOMETRY_TYPE_INSTANCES_KHR, the offset primitiveOffset from VkAccelerationStructureGeometryInstancesDataKHR::data must be a multiple of 16", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-transformOffset-03658", "For geometries of type VK_GEOMETRY_TYPE_TRIANGLES_KHR, the offset transformOffset from VkAccelerationStructureGeometryTrianglesDataKHR::transformData must be a multiple of 16", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildRangeInfoKHR-vertexData-10418", "The number of vertices consumed from VkAccelerationStructureGeometryTrianglesDataKHR::vertexData must be less than or equal to VkAccelerationStructureGeometryTrianglesDataKHR::maxVertex + 1", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureBuildSizesInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureBuildSizesInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructure-08091", "If accelerationStructure is not VK_NULL_HANDLE then accelerationStructure must have been created with VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT set in VkAccelerationStructureCreateInfoKHR::createFlags", "chapters/descriptorsets.html"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructure-08093", "If accelerationStructure is not VK_NULL_HANDLE then accelerationStructureNV must be VK_NULL_HANDLE", "chapters/descriptorsets.html"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructure-parameter", "If accelerationStructure is not VK_NULL_HANDLE, accelerationStructure must be a valid VkAccelerationStructureKHR handle", "chapters/descriptorsets.html"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructureNV-08092", "If accelerationStructureNV is not VK_NULL_HANDLE then accelerationStructureNV must have been created with VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT set in VkAccelerationStructureCreateInfoNV::info.flags", "chapters/descriptorsets.html"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructureNV-08094", "If accelerationStructureNV is not VK_NULL_HANDLE then accelerationStructure must be VK_NULL_HANDLE", "chapters/descriptorsets.html"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-accelerationStructureNV-parameter", "If accelerationStructureNV is not VK_NULL_HANDLE, accelerationStructureNV must be a valid VkAccelerationStructureNV handle", "chapters/descriptorsets.html"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-commonparent", "Both of accelerationStructure, and accelerationStructureNV that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/descriptorsets.html"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/descriptorsets.html"},
    {"VUID-VkAccelerationStructureCaptureDescriptorDataInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-buffer-03614", "buffer must have been created with a usage value containing VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-buffer-03615", "buffer must not have been created with VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-buffer-parameter", "buffer must be a valid VkBuffer handle", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-03613", "If createFlags includes VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR, VkPhysicalDeviceAccelerationStructureFeaturesKHR::accelerationStructureCaptureReplay must be VK_TRUE", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-04954", "If VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV is set in createFlags and type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR, one member of the pNext chain must be a pointer to a valid instance of VkAccelerationStructureMotionInfoNV", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-04955", "If any geometry includes VkAccelerationStructureGeometryMotionTrianglesDataNV then createFlags must contain VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-08108", "If createFlags includes VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT, the descriptorBufferCaptureReplay feature must be enabled", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-createFlags-parameter", "createFlags must be a valid combination of VkAccelerationStructureCreateFlagBitsKHR values", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-03612", "If deviceAddress is not zero, createFlags must include VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-09488", "If deviceAddress is not zero, it must have been retrieved from an identically created acceleration structure, except for buffer and deviceAddress", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-09489", "If deviceAddress is not zero, buffer must have been created identically to the buffer used to create the acceleration structure from which deviceAddress was retrieved, except for VkBufferOpaqueCaptureAddressCreateInfo::opaqueCaptureAddress", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-09490", "If deviceAddress is not zero, buffer must have been created with a VkBufferOpaqueCaptureAddressCreateInfo::opaqueCaptureAddress that was retrieved from vkGetBufferOpaqueCaptureAddress for the buffer that was used to create the acceleration structure from which deviceAddress was retrieved", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-deviceAddress-10393", "If deviceAddress is not zero, it must be a valid device address obtained from vkGetAccelerationStructureDeviceAddressKHR", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-offset-03616", "The sum of offset and size must be less than or equal to the size of buffer", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-offset-03734", "offset must be a multiple of 256 bytes", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-pNext-08109", "If the pNext chain includes a VkOpaqueCaptureDescriptorDataCreateInfoEXT structure, createFlags must contain VK_ACCELERATION_STRUCTURE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAccelerationStructureMotionInfoNV or VkOpaqueCaptureDescriptorDataCreateInfoEXT", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoKHR-type-parameter", "type must be a valid VkAccelerationStructureTypeKHR value", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoNV-compactedSize-02421", "If compactedSize is not 0 then both info.geometryCount and info.instanceCount must be 0", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoNV-info-parameter", "info must be a valid VkAccelerationStructureInfoNV structure", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoNV-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkOpaqueCaptureDescriptorDataCreateInfoEXT", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureCreateInfoNV-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureDeviceAddressInfoKHR-accelerationStructure-parameter", "accelerationStructure must be a valid VkAccelerationStructureKHR handle", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureDeviceAddressInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureDeviceAddressInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-pNext-pNext", "pNext must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-stride-03545", "stride must be a multiple of 8", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryAabbsDataKHR-stride-03820", "stride must be less than or equal to 232-1", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryInstancesDataKHR-pNext-pNext", "pNext must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryInstancesDataKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryKHR-aabbs-parameter", "If geometryType is VK_GEOMETRY_TYPE_AABBS_KHR, the aabbs member of geometry must be a valid VkAccelerationStructureGeometryAabbsDataKHR structure", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryKHR-flags-parameter", "flags must be a valid combination of VkGeometryFlagBitsKHR values", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryKHR-geometryType-parameter", "geometryType must be a valid VkGeometryTypeKHR value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryKHR-instances-parameter", "If geometryType is VK_GEOMETRY_TYPE_INSTANCES_KHR, the instances member of geometry must be a valid VkAccelerationStructureGeometryInstancesDataKHR structure", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAccelerationStructureGeometryLinearSweptSpheresDataNV or VkAccelerationStructureGeometrySpheresDataNV", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryKHR-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryKHR-triangles-parameter", "If geometryType is VK_GEOMETRY_TYPE_TRIANGLES_KHR, the triangles member of geometry must be a valid VkAccelerationStructureGeometryTrianglesDataKHR structure", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-None-10419", "The linearSweptSpheres feature must be enabled", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-endCapsMode-parameter", "endCapsMode must be a valid VkRayTracingLssPrimitiveEndCapsModeNV value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-indexData-10428", "If indexData is not NULL, indexType must be one of VK_INDEX_TYPE_UINT16 or VK_INDEX_TYPE_UINT32", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-indexData-parameter", "indexData must be a valid VkDeviceOrHostAddressConstKHR union", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-indexType-parameter", "indexType must be a valid VkIndexType value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-indexingMode-10427", "If indexingMode is VK_RAY_TRACING_LSS_INDEXING_MODE_SUCCESSIVE_NV, indexData must not be NULL", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-indexingMode-parameter", "indexingMode must be a valid VkRayTracingLssIndexingModeNV value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-radiusData-10425", "The memory address in radiusData must not be 0 or `NULL'", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-radiusData-10426", "All values referenced in radiusData must be greater than or equal to 0", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-radiusData-parameter", "radiusData must be a valid VkDeviceOrHostAddressConstKHR union", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-radiusFormat-10424", "The format features of radiusFormat must contain VK_FORMAT_FEATURE_2_ACCELERATION_STRUCTURE_RADIUS_BUFFER_BIT_NV", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-radiusFormat-parameter", "radiusFormat must be a valid VkFormat value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_LINEAR_SWEPT_SPHERES_DATA_NV", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-vertexData-10420", "The memory address in vertexData must not be 0 or `NULL'", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-vertexData-parameter", "vertexData must be a valid VkDeviceOrHostAddressConstKHR union", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-vertexFormat-10423", "The format features of vertexFormat must contain VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-vertexFormat-parameter", "vertexFormat must be a valid VkFormat value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-vertexStride-10421", "vertexStride must be a multiple of: the size of the format specified in vertexFormat if that format is a packed format the component size specified in vertexFormat if that format is not a packed format", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryLinearSweptSpheresDataNV-vertexStride-10422", "vertexStride and radiusStride must be less than or equal to 232-1", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryMotionTrianglesDataNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-None-10429", "The spheres feature must be enabled", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-indexData-10437", "If indexData is not NULL, indexType must be one of VK_INDEX_TYPE_UINT16 or VK_INDEX_TYPE_UINT32", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-indexData-parameter", "indexData must be a valid VkDeviceOrHostAddressConstKHR union", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-indexType-parameter", "indexType must be a valid VkIndexType value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-radiusData-10433", "The memory address in radiusData must not be 0 or `NULL'", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-radiusData-10436", "All values referenced in radiusData must be greater than or equal to 0", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-radiusData-parameter", "radiusData must be a valid VkDeviceOrHostAddressConstKHR union", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-radiusFormat-10435", "The format features of radiusFormat must contain VK_FORMAT_FEATURE_2_ACCELERATION_STRUCTURE_RADIUS_BUFFER_BIT_NV", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-radiusFormat-parameter", "radiusFormat must be a valid VkFormat value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_SPHERES_DATA_NV", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-vertexData-10430", "The memory address in vertexData must not be 0 or `NULL'", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-vertexData-parameter", "vertexData must be a valid VkDeviceOrHostAddressConstKHR union", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-vertexFormat-10434", "The format features of vertexFormat must contain VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-vertexFormat-parameter", "vertexFormat must be a valid VkFormat value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-vertexStride-10431", "vertexStride must be a multiple of: the size of the format specified in vertexFormat if that format is a packed format the smallest component size specified in vertexFormat if that format is not a packed format", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometrySpheresDataNV-vertexStride-10432", "vertexStride and radiusStride must be less than or equal to 232-1", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-indexType-03798", "indexType must be VK_INDEX_TYPE_UINT16, VK_INDEX_TYPE_UINT32, or VK_INDEX_TYPE_NONE_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-indexType-parameter", "indexType must be a valid VkIndexType value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAccelerationStructureGeometryMotionTrianglesDataNV, VkAccelerationStructureTrianglesDisplacementMicromapNV, or VkAccelerationStructureTrianglesOpacityMicromapEXT", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexFormat-03797", "The format features of vertexFormat must contain VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexFormat-parameter", "vertexFormat must be a valid VkFormat value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexStride-03735", "vertexStride must be a multiple of the size in bytes of the smallest component of vertexFormat", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureGeometryTrianglesDataKHR-vertexStride-03819", "vertexStride must be less than or equal to 232-1", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureInfoNV-flags-02592", "If flags has the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_NV bit set, then it must not have the VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_NV bit set", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInfoNV-flags-parameter", "flags must be a valid combination of VkBuildAccelerationStructureFlagBitsNV values", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInfoNV-geometryCount-02422", "geometryCount must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxGeometryCount", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInfoNV-instanceCount-02423", "instanceCount must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxInstanceCount", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInfoNV-instanceData-02782", "If instanceData is not VK_NULL_HANDLE, instanceData must have been created with VK_BUFFER_USAGE_RAY_TRACING_BIT_NV usage flag", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInfoNV-maxTriangleCount-02424", "The total number of triangles in all geometries must be less than or equal to VkPhysicalDeviceRayTracingPropertiesNV::maxTriangleCount", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInfoNV-pGeometries-parameter", "If geometryCount is not 0, pGeometries must be a valid pointer to an array of geometryCount valid VkGeometryNV structures", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInfoNV-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInfoNV-scratch-02781", "scratch must have been created with VK_BUFFER_USAGE_RAY_TRACING_BIT_NV usage flag", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInfoNV-type-02425", "If type is VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_NV then geometryCount must be 0", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInfoNV-type-02426", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV then instanceCount must be 0", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInfoNV-type-02786", "If type is VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV then the geometryType member of each geometry in pGeometries must be the same", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInfoNV-type-04623", "type must not be VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInfoNV-type-parameter", "type must be a valid VkAccelerationStructureTypeNV value", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureInstanceKHR-flags-parameter", "flags must be a valid combination of VkGeometryInstanceFlagBitsKHR values", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureMatrixMotionInstanceNV-flags-parameter", "flags must be a valid combination of VkGeometryInstanceFlagBitsKHR values", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-accelerationStructure-parameter", "accelerationStructure must be a valid VkAccelerationStructureNV handle", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureMemoryRequirementsInfoNV-type-parameter", "type must be a valid VkAccelerationStructureMemoryRequirementsTypeNV value", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureMotionInfoNV-flags-zerobitmask", "flags must be 0", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureMotionInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV", "chapters/resources.html"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-flags-zerobitmask", "flags must be 0", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-matrixMotionInstance-parameter", "If type is VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MATRIX_MOTION_NV, the matrixMotionInstance member of data must be a valid VkAccelerationStructureMatrixMotionInstanceNV structure", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-srtMotionInstance-parameter", "If type is VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_SRT_MOTION_NV, the srtMotionInstance member of data must be a valid VkAccelerationStructureSRTMotionInstanceNV structure", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-staticInstance-parameter", "If type is VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_STATIC_NV, the staticInstance member of data must be a valid VkAccelerationStructureInstanceKHR structure", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureMotionInstanceNV-type-parameter", "type must be a valid VkAccelerationStructureMotionInstanceTypeNV value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureSRTMotionInstanceNV-flags-parameter", "flags must be a valid combination of VkGeometryInstanceFlagBitsKHR values", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-displacementBiasAndScaleFormat-09501", "displacementBiasAndScaleFormat must not be VK_FORMAT_UNDEFINED", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-displacementBiasAndScaleFormat-parameter", "displacementBiasAndScaleFormat must be a valid VkFormat value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-displacementVectorFormat-09502", "displacementVectorFormat must not be VK_FORMAT_UNDEFINED", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-displacementVectorFormat-parameter", "displacementVectorFormat must be a valid VkFormat value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-indexType-parameter", "indexType must be a valid VkIndexType value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-micromap-parameter", "If micromap is not VK_NULL_HANDLE, micromap must be a valid VkMicromapEXT handle", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-pUsageCounts-07992", "Only one of pUsageCounts or ppUsageCounts can be a valid pointer, the other must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-pUsageCounts-parameter", "If usageCountsCount is not 0, and pUsageCounts is not NULL, pUsageCounts must be a valid pointer to an array of usageCountsCount VkMicromapUsageEXT structures", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-ppUsageCounts-parameter", "If usageCountsCount is not 0, and ppUsageCounts is not NULL, ppUsageCounts must be a valid pointer to an array of usageCountsCount valid pointers to VkMicromapUsageEXT structures", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesDisplacementMicromapNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_DISPLACEMENT_MICROMAP_NV", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-indexType-10719", "indexType must be VK_INDEX_TYPE_UINT16, VK_INDEX_TYPE_UINT32, or VK_INDEX_TYPE_NONE_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-indexType-10720", "If indexType is VK_INDEX_TYPE_NONE_KHR, then indexBuffer must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-indexType-10721", "If indexType is not VK_INDEX_TYPE_NONE_KHR, then indexBuffer must be a valid device address obtained from vkGetBufferDeviceAddress", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-indexType-10722", "If indexType is not VK_INDEX_TYPE_NONE_KHR, then indexStride must be a multiple of the size in bytes of indexType", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-indexType-10723", "If indexType is not VK_INDEX_TYPE_NONE_KHR, then indexStride must be less than or equal to 232-1", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-indexType-parameter", "indexType must be a valid VkIndexType value", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-micromap-parameter", "If micromap is not VK_NULL_HANDLE, micromap must be a valid VkMicromapEXT handle", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-pUsageCounts-07335", "Only one of pUsageCounts or ppUsageCounts can be a valid pointer, the other must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-pUsageCounts-parameter", "If usageCountsCount is not 0, and pUsageCounts is not NULL, pUsageCounts must be a valid pointer to an array of usageCountsCount VkMicromapUsageEXT structures", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-ppUsageCounts-parameter", "If usageCountsCount is not 0, and ppUsageCounts is not NULL, ppUsageCounts must be a valid pointer to an array of usageCountsCount valid pointers to VkMicromapUsageEXT structures", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureTrianglesOpacityMicromapEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_OPACITY_MICROMAP_EXT", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureVersionInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureVersionInfoKHR-pVersionData-parameter", "pVersionData must be a valid pointer to an array of \\(2 \\times \\mathtt{VK\\_UUID\\_SIZE}\\) uint8_t values", "chapters/accelstructures.html"},
    {"VUID-VkAccelerationStructureVersionInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR", "chapters/accelstructures.html"},
    {"VUID-VkAcquireNextImageInfoKHR-commonparent", "Each of fence, semaphore, and swapchain that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireNextImageInfoKHR-deviceMask-01290", "deviceMask must be a valid device mask", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireNextImageInfoKHR-deviceMask-01291", "deviceMask must not be zero", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireNextImageInfoKHR-fence-01289", "If fence is not VK_NULL_HANDLE, fence must be unsignaled", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireNextImageInfoKHR-fence-10067", "If fence is not VK_NULL_HANDLE, fence must not be associated with any other queue command that has not yet completed execution on that queue", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireNextImageInfoKHR-fence-parameter", "If fence is not VK_NULL_HANDLE, fence must be a valid VkFence handle", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireNextImageInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireNextImageInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-01288", "If semaphore is not VK_NULL_HANDLE, it must be unsignaled", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-01781", "If semaphore is not VK_NULL_HANDLE, it must not have any uncompleted signal or wait operations pending", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-01782", "semaphore and fence must not both be equal to VK_NULL_HANDLE", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-03266", "semaphore must have a VkSemaphoreType of VK_SEMAPHORE_TYPE_BINARY", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireNextImageInfoKHR-semaphore-parameter", "If semaphore is not VK_NULL_HANDLE, semaphore must be a valid VkSemaphore handle", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireNextImageInfoKHR-swapchain-01675", "swapchain must not be in the retired state", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireNextImageInfoKHR-swapchain-parameter", "swapchain must be a valid VkSwapchainKHR handle", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAcquireProfilingLockInfoKHR-flags-zerobitmask", "flags must be 0", "chapters/queries.html"},
    {"VUID-VkAcquireProfilingLockInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/queries.html"},
    {"VUID-VkAcquireProfilingLockInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR", "chapters/queries.html"},
    {"VUID-VkAllocationCallbacks-pfnAllocation-00632", "pfnAllocation must be a valid pointer to a valid application-defined PFN_vkAllocationFunction", "chapters/memory.html"},
    {"VUID-VkAllocationCallbacks-pfnFree-00634", "pfnFree must be a valid pointer to a valid application-defined PFN_vkFreeFunction", "chapters/memory.html"},
    {"VUID-VkAllocationCallbacks-pfnInternalAllocation-00635", "If either of pfnInternalAllocation or pfnInternalFree is not NULL, both must be valid callbacks", "chapters/memory.html"},
    {"VUID-VkAllocationCallbacks-pfnReallocation-00633", "pfnReallocation must be a valid pointer to a valid application-defined PFN_vkReallocationFunction", "chapters/memory.html"},
    {"VUID-VkAmigoProfilingSubmitInfoSEC-sType-sType", "sType must be VK_STRUCTURE_TYPE_AMIGO_PROFILING_SUBMIT_INFO_SEC", "appendices/extensions.html"},
    {"VUID-VkAndroidHardwareBufferFormatProperties2ANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID", "chapters/memory.html"},
    {"VUID-VkAndroidHardwareBufferFormatPropertiesANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID", "chapters/memory.html"},
    {"VUID-VkAndroidHardwareBufferFormatResolvePropertiesANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_RESOLVE_PROPERTIES_ANDROID", "chapters/memory.html"},
    {"VUID-VkAndroidHardwareBufferPropertiesANDROID-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAndroidHardwareBufferFormatProperties2ANDROID, VkAndroidHardwareBufferFormatPropertiesANDROID, or VkAndroidHardwareBufferFormatResolvePropertiesANDROID", "chapters/memory.html"},
    {"VUID-VkAndroidHardwareBufferPropertiesANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID", "chapters/memory.html"},
    {"VUID-VkAndroidHardwareBufferPropertiesANDROID-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/memory.html"},
    {"VUID-VkAndroidHardwareBufferUsageANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID", "chapters/capabilities.html"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAndroidSurfaceCreateInfoKHR-window-01248", "window must point to a valid Android ANativeWindow", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAntiLagDataAMD-mode-parameter", "mode must be a valid VkAntiLagModeAMD value", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAntiLagDataAMD-pPresentationInfo-parameter", "If pPresentationInfo is not NULL, pPresentationInfo must be a valid pointer to a valid VkAntiLagPresentationInfoAMD structure", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAntiLagDataAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANTI_LAG_DATA_AMD", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAntiLagPresentationInfoAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_ANTI_LAG_PRESENTATION_INFO_AMD", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkAntiLagPresentationInfoAMD-stage-parameter", "stage must be a valid VkAntiLagStageAMD value", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkApplicationInfo-apiVersion-04010", "If apiVersion is not 0, then it must be greater than or equal to VK_API_VERSION_1_0", "chapters/initialization.html"},
    {"VUID-VkApplicationInfo-pApplicationName-parameter", "If pApplicationName is not NULL, pApplicationName must be a null-terminated UTF-8 string", "chapters/initialization.html"},
    {"VUID-VkApplicationInfo-pEngineName-parameter", "If pEngineName is not NULL, pEngineName must be a null-terminated UTF-8 string", "chapters/initialization.html"},
    {"VUID-VkApplicationInfo-pNext-pNext", "pNext must be NULL", "chapters/initialization.html"},
    {"VUID-VkApplicationInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_APPLICATION_INFO", "chapters/initialization.html"},
    {"VUID-VkAttachmentDescription-attachmentFeedbackLoopLayout-07309", "If the attachmentFeedbackLoopLayout feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-attachmentFeedbackLoopLayout-07310", "If the attachmentFeedbackLoopLayout feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-dynamicRenderingLocalRead-09544", "If the dynamicRenderingLocalRead feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-dynamicRenderingLocalRead-09545", "If the dynamicRenderingLocalRead feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-finalLayout-00843", "finalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT or VK_IMAGE_LAYOUT_PREINITIALIZED", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-finalLayout-parameter", "finalLayout must be a valid VkImageLayout value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-flags-parameter", "flags must be a valid combination of VkAttachmentDescriptionFlagBits values", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-03280", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-03281", "If format is a depth/stencil format, initialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-03282", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-03283", "If format is a depth/stencil format, finalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-03286", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-03287", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-03290", "If format is a depth/stencil format which includes only the depth component, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-03291", "If format is a depth/stencil format which includes only the depth component, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-03292", "If format is a depth/stencil format which includes only the stencil component, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-03293", "If format is a depth/stencil format which includes only the stencil component, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-06242", "If format is a depth/stencil format which includes both depth and stencil components, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-06243", "If format is a depth/stencil format which includes both depth and stencil components, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-06487", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-06488", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-06698", "format must not be VK_FORMAT_UNDEFINED", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-06699", "If format includes a color or depth component and loadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then initialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-06700", "If format includes a stencil component and stencilLoadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then initialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-06906", "If format is a depth/stencil format which includes both depth and stencil components, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-06907", "If format is a depth/stencil format which includes both depth and stencil components, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-format-parameter", "format must be a valid VkFormat value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-initialLayout-parameter", "initialLayout must be a valid VkImageLayout value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-loadOp-parameter", "loadOp must be a valid VkAttachmentLoadOp value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-samples-08745", "samples must be a valid VkSampleCountFlagBits value that is set in imageCreateSampleCounts (as defined in Image Creation Limits) for the given format", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-samples-parameter", "samples must be a valid VkSampleCountFlagBits value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-separateDepthStencilLayouts-03284", "If the separateDepthStencilLayouts feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-separateDepthStencilLayouts-03285", "If the separateDepthStencilLayouts feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-stencilLoadOp-parameter", "stencilLoadOp must be a valid VkAttachmentLoadOp value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-stencilStoreOp-parameter", "stencilStoreOp must be a valid VkAttachmentStoreOp value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-storeOp-parameter", "storeOp must be a valid VkAttachmentStoreOp value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-synchronization2-06908", "If the synchronization2 feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription-synchronization2-06909", "If the synchronization2 feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-attachmentFeedbackLoopLayout-07309", "If the attachmentFeedbackLoopLayout feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-attachmentFeedbackLoopLayout-07310", "If the attachmentFeedbackLoopLayout feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-dynamicRenderingLocalRead-09544", "If the dynamicRenderingLocalRead feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-dynamicRenderingLocalRead-09545", "If the dynamicRenderingLocalRead feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-finalLayout-00843", "finalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT or VK_IMAGE_LAYOUT_PREINITIALIZED", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-finalLayout-parameter", "finalLayout must be a valid VkImageLayout value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-flags-parameter", "flags must be a valid combination of VkAttachmentDescriptionFlagBits values", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-03280", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-03281", "If format is a depth/stencil format, initialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-03282", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-03283", "If format is a depth/stencil format, finalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-03286", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-03287", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-03290", "If format is a depth/stencil format which includes only the depth component, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-03291", "If format is a depth/stencil format which includes only the depth component, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-06247", "If the pNext chain does not include a VkAttachmentDescriptionStencilLayout structure and format only includes a stencil component, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-06248", "If the pNext chain does not include a VkAttachmentDescriptionStencilLayout structure and format only includes a stencil component, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-06249", "If format is a depth/stencil format which includes both depth and stencil components, and initialLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, the pNext chain must include a VkAttachmentDescriptionStencilLayout structure", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-06250", "If format is a depth/stencil format which includes both depth and stencil components, and finalLayout is VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, the pNext chain must include a VkAttachmentDescriptionStencilLayout structure", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-06487", "If format is a color format, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-06488", "If format is a color format, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-06699", "If format includes a color or depth component and loadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then initialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-06906", "If format is a depth/stencil format which includes both depth and stencil components, initialLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-06907", "If format is a depth/stencil format which includes both depth and stencil components, finalLayout must not be VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-09332", "If the externalFormatResolve feature is not enabled, format must not be VK_FORMAT_UNDEFINED", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-09334", "If format is VK_FORMAT_UNDEFINED, there must be a VkExternalFormatANDROID structure in the pNext chain with a externalFormat that is not equal to 0", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-format-parameter", "format must be a valid VkFormat value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-initialLayout-parameter", "initialLayout must be a valid VkImageLayout value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-loadOp-parameter", "loadOp must be a valid VkAttachmentLoadOp value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-pNext-06704", "If the pNext chain does not include a VkAttachmentDescriptionStencilLayout structure, format includes a stencil component, and stencilLoadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then initialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-pNext-06705", "If the pNext chain includes a VkAttachmentDescriptionStencilLayout structure, format includes a stencil component, and stencilLoadOp is VK_ATTACHMENT_LOAD_OP_LOAD, then VkAttachmentDescriptionStencilLayout::stencilInitialLayout must not be VK_IMAGE_LAYOUT_UNDEFINED", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAttachmentDescriptionStencilLayout or VkExternalFormatANDROID", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-samples-08745", "samples must be a valid VkSampleCountFlagBits value that is set in imageCreateSampleCounts (as defined in Image Creation Limits) for the given format", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-samples-parameter", "samples must be a valid VkSampleCountFlagBits value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-separateDepthStencilLayouts-03284", "If the separateDepthStencilLayouts feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-separateDepthStencilLayouts-03285", "If the separateDepthStencilLayouts feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-stencilLoadOp-parameter", "stencilLoadOp must be a valid VkAttachmentLoadOp value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-stencilStoreOp-parameter", "stencilStoreOp must be a valid VkAttachmentStoreOp value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-storeOp-parameter", "storeOp must be a valid VkAttachmentStoreOp value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-synchronization2-06908", "If the synchronization2 feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescription2-synchronization2-06909", "If the synchronization2 feature is not enabled, finalLayout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescriptionStencilLayout-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-03309", "stencilFinalLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-03310", "stencilFinalLayout must not be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT or VK_IMAGE_LAYOUT_PREINITIALIZED", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilFinalLayout-parameter", "stencilFinalLayout must be a valid VkImageLayout value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilInitialLayout-03308", "stencilInitialLayout must not be VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL", "chapters/renderpass.html"},
    {"VUID-VkAttachmentDescriptionStencilLayout-stencilInitialLayout-parameter", "stencilInitialLayout must be a valid VkImageLayout value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentFeedbackLoopInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_FEEDBACK_LOOP_INFO_EXT", "chapters/renderpass.html"},
    {"VUID-VkAttachmentFeedbackLoopInfoEXT-unifiedImageLayouts-10782", "If the unifiedImageLayouts feature is not enabled, feedbackLoopEnable must be VK_FALSE", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference-attachmentFeedbackLoopLayout-07311", "If the attachmentFeedbackLoopLayout feature is not enabled, layout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference-dynamicRenderingLocalRead-09546", "If the dynamicRenderingLocalRead feature is not enabled, layout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference-layout-03077", "If attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT, VK_IMAGE_LAYOUT_PREINITIALIZED, or VK_IMAGE_LAYOUT_PRESENT_SRC_KHR", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference-layout-parameter", "layout must be a valid VkImageLayout value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference-separateDepthStencilLayouts-03313", "If the separateDepthStencilLayouts feature is not enabled, and attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference-synchronization2-06910", "If the synchronization2 feature is not enabled, layout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference2-attachmentFeedbackLoopLayout-07311", "If the attachmentFeedbackLoopLayout feature is not enabled, layout must not be VK_IMAGE_LAYOUT_ATTACHMENT_FEEDBACK_LOOP_OPTIMAL_EXT", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference2-dynamicRenderingLocalRead-09546", "If the dynamicRenderingLocalRead feature is not enabled, layout must not be VK_IMAGE_LAYOUT_RENDERING_LOCAL_READ", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference2-layout-03077", "If attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT, VK_IMAGE_LAYOUT_PREINITIALIZED, or VK_IMAGE_LAYOUT_PRESENT_SRC_KHR", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference2-layout-parameter", "layout must be a valid VkImageLayout value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkAttachmentReferenceStencilLayout", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference2-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference2-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference2-separateDepthStencilLayouts-03313", "If the separateDepthStencilLayouts feature is not enabled, and attachment is not VK_ATTACHMENT_UNUSED, layout must not be VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL,", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReference2-synchronization2-06910", "If the synchronization2 feature is not enabled, layout must not be VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR or VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReferenceStencilLayout-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReferenceStencilLayout-stencilLayout-03318", "stencilLayout must not be VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_PREINITIALIZED, VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL, or VK_IMAGE_LAYOUT_PRESENT_SRC_KHR", "chapters/renderpass.html"},
    {"VUID-VkAttachmentReferenceStencilLayout-stencilLayout-parameter", "stencilLayout must be a valid VkImageLayout value", "chapters/renderpass.html"},
    {"VUID-VkAttachmentSampleCountInfoAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD", "chapters/cmdbuffers.html"},
    {"VUID-VkAttachmentSampleLocationsEXT-attachmentIndex-01531", "attachmentIndex must be less than the attachmentCount specified in VkRenderPassCreateInfo the render pass specified by VkRenderPassBeginInfo::renderPass was created with", "chapters/renderpass.html"},
    {"VUID-VkAttachmentSampleLocationsEXT-sampleLocationsInfo-parameter", "sampleLocationsInfo must be a valid VkSampleLocationsInfoEXT structure", "chapters/renderpass.html"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-accelerationStructure-03620", "accelerationStructure must not already be backed by a memory object", "chapters/resources.html"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-accelerationStructure-parameter", "accelerationStructure must be a valid VkAccelerationStructureNV handle", "chapters/resources.html"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-commonparent", "Both of accelerationStructure, and memory must have been created, allocated, or retrieved from the same VkDevice", "chapters/resources.html"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memory-03622", "memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV", "chapters/resources.html"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memory-parameter", "memory must be a valid VkDeviceMemory handle", "chapters/resources.html"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memoryOffset-03621", "memoryOffset must be less than the size of memory", "chapters/resources.html"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-memoryOffset-03623", "memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV", "chapters/resources.html"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-pDeviceIndices-parameter", "If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values", "chapters/resources.html"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV", "chapters/resources.html"},
    {"VUID-VkBindAccelerationStructureMemoryInfoNV-size-03624", "The size member of the VkMemoryRequirements structure returned from a call to vkGetAccelerationStructureMemoryRequirementsNV with accelerationStructure and type of VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV must be less than or equal to the size of memory minus memoryOffset", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-deviceIndexCount-01606", "deviceIndexCount must either be zero or equal to the number of physical devices in the logical device", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices-01607", "All elements of pDeviceIndices must be valid device indices", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-pDeviceIndices-parameter", "If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryDeviceGroupInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-None-01898", "If buffer was created with the VK_BUFFER_CREATE_PROTECTED_BIT bit set, the buffer must be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-None-01899", "If buffer was created with the VK_BUFFER_CREATE_PROTECTED_BIT bit not set, the buffer must not be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-None-10739", "If memory was not allocated from a memory heap with the VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM property set, memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-None-10741", "If memory was not allocated from a memory heap with the VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM property set, size member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer must be less than or equal to the size of memory minus memoryOffset", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-apiVersion-07920", "If the VK_KHR_dedicated_allocation extension is not enabled, VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, and buffer was not created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must not have been allocated dedicated for a specific buffer or image", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01030", "buffer must not have been created with any sparse memory binding flags", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01038", "If buffer was created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must have been allocated with VkDedicatedAllocationMemoryAllocateInfoNV::buffer equal to a buffer handle created with identical creation parameters to buffer and memoryOffset must be zero", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-buffer-01444", "If buffer requires a dedicated allocation (as reported by vkGetBufferMemoryRequirements2 in VkMemoryDedicatedRequirements::requiresDedicatedAllocation for buffer), memory must have been allocated with VkMemoryDedicatedAllocateInfo::buffer equal to buffer", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-buffer-06408", "If buffer was created with VkBufferCollectionBufferCreateInfoFUCHSIA chained to VkBufferCreateInfo::pNext, memory must be allocated with a VkImportMemoryBufferCollectionFUCHSIA chained to VkMemoryAllocateInfo::pNext", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-buffer-07459", "buffer must not have been bound to a memory object", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-buffer-09201", "If the buffer was created with the VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-buffer-parameter", "buffer must be a valid VkBuffer handle", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-bufferDeviceAddress-03339", "If the VkPhysicalDeviceBufferDeviceAddressFeatures::bufferDeviceAddress feature is enabled and buffer was created with the VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-bufferDeviceAddressCaptureReplay-09200", "If the VkPhysicalDeviceBufferDeviceAddressFeatures::bufferDeviceAddressCaptureReplay feature is enabled and buffer was created with the VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-commonparent", "Both of buffer, and memory must have been created, allocated, or retrieved from the same VkDevice", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-descriptorBufferCaptureReplay-08112", "If the buffer was created with the VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-memory-01035", "memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetBufferMemoryRequirements with buffer", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-memory-01508", "If the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::buffer was not VK_NULL_HANDLE, then buffer must equal VkMemoryDedicatedAllocateInfo::buffer, and memoryOffset must be zero", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-memory-02726", "If the value of VkExportMemoryAllocateInfo::handleTypes used to allocate memory is not 0, it must include at least one of the handles set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-memory-02985", "If memory was allocated by a memory import operation, that is not VkImportAndroidHardwareBufferInfoANDROID with a non-NULL buffer value, the external handle type of the imported memory must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-memory-02986", "If memory was allocated with the VkImportAndroidHardwareBufferInfoANDROID memory import operation with a non-NULL buffer value, VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID must also have been set in VkExternalMemoryBufferCreateInfo::handleTypes when buffer was created", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-memory-10740", "If memory was allocated from a memory heap with the VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM property set, memoryOffset must be an integer multiple of the alignment member of the VkTileMemoryRequirementsQCOM structure returned from a call to vkGetBufferMemoryRequirements with buffer", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-memory-10742", "If memory was allocated from a memory heap with the VK_MEMORY_HEAP_TILE_MEMORY_BIT_QCOM property set, size member of the VkTileMemoryRequirementsQCOM structure returned from a call to vkGetBufferMemoryRequirements with buffer must be less than or equal to the size of memory minus memoryOffset", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-memory-parameter", "memory must be a valid VkDeviceMemory handle", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-memoryOffset-01031", "memoryOffset must be less than the size of memory", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-pNext-01605", "If the pNext chain includes a VkBindBufferMemoryDeviceGroupInfo structure, all instances of memory specified by VkBindBufferMemoryDeviceGroupInfo::pDeviceIndices must have been allocated", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBindBufferMemoryDeviceGroupInfo or VkBindMemoryStatus", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO", "chapters/resources.html"},
    {"VUID-VkBindBufferMemoryInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/resources.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-bindPoint-09786", "bindPoint must have been returned as part of a VkDataGraphPipelineSessionBindPointRequirementARM whose bindPointType member is VK_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_TYPE_MEMORY_ARM by a prior call to vkGetDataGraphPipelineSessionMemoryRequirementsARM for session", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-bindPoint-parameter", "bindPoint must be a valid VkDataGraphPipelineSessionBindPointARM value", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-commonparent", "Both of memory, and session must have been created, allocated, or retrieved from the same VkDevice", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-memory-09788", "memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetDataGraphPipelineSessionMemoryRequirementsARM with session", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-memory-parameter", "memory must be a valid VkDeviceMemory handle", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-memoryOffset-09787", "memoryOffset must be less than the size of memory", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-memoryOffset-09789", "memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetDataGraphPipelineSessionMemoryRequirementsARM with session", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-objectIndex-09805", "objectIndex must be less than the value of numObjects returned by vkGetDataGraphPipelineSessionBindPointRequirementsARM for bindPoint", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-pNext-pNext", "pNext must be NULL", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_DATA_GRAPH_PIPELINE_SESSION_MEMORY_INFO_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-session-09785", "session must not have been bound to a memory object for bindPoint", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-session-09791", "If session was created with the VK_DATA_GRAPH_PIPELINE_SESSION_CREATE_PROTECTED_BIT_ARM bit set, the session must be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-session-09792", "If session was created with the VK_DATA_GRAPH_PIPELINE_SESSION_CREATE_PROTECTED_BIT_ARM bit not set, the session must not be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-session-parameter", "session must be a valid VkDataGraphPipelineSessionARM handle", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDataGraphPipelineSessionMemoryInfoARM-size-09790", "The size member of the VkMemoryRequirements structure returned from a call to vkGetDataGraphPipelineSessionMemoryRequirementsARM with session must be less than or equal to the size of memory minus memoryOffset", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-None-09495", "If the dynamicPipelineLayout feature is not enabled, layout must be a valid VkPipelineLayout handle", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-layout-09496", "If layout is VK_NULL_HANDLE, the pNext chain must include a valid VkPipelineLayoutCreateInfo structure", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-layout-parameter", "If layout is not VK_NULL_HANDLE, layout must be a valid VkPipelineLayout handle", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPipelineLayoutCreateInfo", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_BUFFER_EMBEDDED_SAMPLERS_INFO_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-set-08070", "The VkDescriptorSetLayout at index set when layout was created must have been created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT bit set", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-set-08071", "set must be less than or equal to VkPipelineLayoutCreateInfo::setLayoutCount provided when layout was created", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-stageFlags-parameter", "stageFlags must be a valid combination of VkShaderStageFlagBits values", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorBufferEmbeddedSamplersInfoEXT-stageFlags-requiredbitmask", "stageFlags must not be 0", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-None-09495", "If the dynamicPipelineLayout feature is not enabled, layout must be a valid VkPipelineLayout handle", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-commonparent", "Both of layout, and the elements of pDescriptorSets that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-descriptorSetCount-arraylength", "descriptorSetCount must be greater than 0", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-dynamicOffsetCount-00359", "dynamicOffsetCount must be equal to the total number of dynamic descriptors in pDescriptorSets", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-firstSet-00360", "The sum of firstSet and descriptorSetCount must be less than or equal to VkPipelineLayoutCreateInfo::setLayoutCount provided when layout was created", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-layout-09496", "If layout is VK_NULL_HANDLE, the pNext chain must include a valid VkPipelineLayoutCreateInfo structure", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-layout-parameter", "If layout is not VK_NULL_HANDLE, layout must be a valid VkPipelineLayout handle", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-00358", "Each element of pDescriptorSets that is not VK_NULL_HANDLE must have been allocated with a VkDescriptorSetLayout that matches (is the same as, or identically defined as) the VkDescriptorSetLayout at set n in layout, where n is the sum of firstSet and the index into pDescriptorSets", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-01979", "For each dynamic uniform or storage buffer binding in pDescriptorSets, the sum of the effective offset and the range of the binding must be less than or equal to the size of the buffer", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-04616", "Each element of pDescriptorSets must not have been allocated from a VkDescriptorPool with the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT flag set", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-06563", "If the graphicsPipelineLibrary feature is not enabled, each element of pDescriptorSets must be a valid VkDescriptorSet", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-06715", "For each dynamic uniform or storage buffer binding in pDescriptorSets, if the range was set with VK_WHOLE_SIZE then pDynamicOffsets which corresponds to the descriptor binding must be 0", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-08010", "Each element of pDescriptorSets must have been allocated with a VkDescriptorSetLayout which was not created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-09914", "If any element of pDescriptorSets was allocated from a descriptor pool created with a VkDescriptorPoolCreateInfo structure that had a VkDataGraphProcessingEngineCreateInfoARM structure specifying foreign data processing engines in its pNext chain, then the command pool from which commandBuffer was allocated must have been created with a VkCommandPoolCreateInfo structure that had a VkDataGraphProcessingEngineCreateInfoARM structure in its pNext chain specifying a superset of all the foreign data processing engines specified when creating the descriptor pools from which the elements of pDescriptorSets were allocated", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-09915", "If none of the elements of pDescriptorSets were allocated from a descriptor pool created with a VkDescriptorPoolCreateInfo structure that had a VkDataGraphProcessingEngineCreateInfoARM structure specifying foreign data processing engines in its pNext chain, then the command pool from which commandBuffer was allocated must not have been created with a VkCommandPoolCreateInfo structure that had a VkDataGraphProcessingEngineCreateInfoARM structure in its pNext chain", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-pDescriptorSets-parameter", "pDescriptorSets must be a valid pointer to an array of descriptorSetCount valid VkDescriptorSet handles", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-pDynamicOffsets-01971", "Each element of pDynamicOffsets which corresponds to a descriptor binding with type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC must be a multiple of VkPhysicalDeviceLimits::minUniformBufferOffsetAlignment", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-pDynamicOffsets-01972", "Each element of pDynamicOffsets which corresponds to a descriptor binding with type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC must be a multiple of VkPhysicalDeviceLimits::minStorageBufferOffsetAlignment", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-pDynamicOffsets-parameter", "If dynamicOffsetCount is not 0, and pDynamicOffsets is not NULL, pDynamicOffsets must be a valid pointer to an array of dynamicOffsetCount or VK_NULL_HANDLE uint32_t values", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkPipelineLayoutCreateInfo", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_SETS_INFO", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-stageFlags-parameter", "stageFlags must be a valid combination of VkShaderStageFlagBits values", "chapters/descriptorsets.html"},
    {"VUID-VkBindDescriptorSetsInfo-stageFlags-requiredbitmask", "stageFlags must not be 0", "chapters/descriptorsets.html"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-deviceIndexCount-01633", "At least one of deviceIndexCount and splitInstanceBindRegionCount must be zero", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-deviceIndexCount-01634", "deviceIndexCount must either be zero or equal to the number of physical devices in the logical device", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-extent-01640", "The extent.width member of any element of pSplitInstanceBindRegions must either be a multiple of the sparse image block width of all non-metadata aspects of the image, or else extent.width + offset.x must equal the width of the image subresource", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-extent-01641", "The extent.height member of any element of pSplitInstanceBindRegions must either be a multiple of the sparse image block height of all non-metadata aspects of the image, or else extent.height + offset.y must equal the height of the image subresource", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-offset-01638", "The offset.x member of any element of pSplitInstanceBindRegions must be a multiple of the sparse image block width (VkSparseImageFormatProperties::imageGranularity.width) of all non-metadata aspects of the image", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-offset-01639", "The offset.y member of any element of pSplitInstanceBindRegions must be a multiple of the sparse image block height (VkSparseImageFormatProperties::imageGranularity.height) of all non-metadata aspects of the image", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pDeviceIndices-01635", "All elements of pDeviceIndices must be valid device indices", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pDeviceIndices-parameter", "If deviceIndexCount is not 0, pDeviceIndices must be a valid pointer to an array of deviceIndexCount uint32_t values", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions-01637", "Elements of pSplitInstanceBindRegions that correspond to the same instance of an image must not overlap", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-pSplitInstanceBindRegions-parameter", "If splitInstanceBindRegionCount is not 0, pSplitInstanceBindRegions must be a valid pointer to an array of splitInstanceBindRegionCount VkRect2D structures", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryDeviceGroupInfo-splitInstanceBindRegionCount-01636", "splitInstanceBindRegionCount must either be zero or equal to the number of physical devices in the logical device squared", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-None-01901", "If image was created with the VK_IMAGE_CREATE_PROTECTED_BIT bit set, the image must be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-None-01902", "If image was created with the VK_IMAGE_CREATE_PROTECTED_BIT bit not set, the image must not be bound to a memory object created with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-apiVersion-07921", "If the VK_KHR_dedicated_allocation extension is not enabled, VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, and image was not created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must not have been allocated dedicated for a specific buffer or image", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-commonparent", "Both of image, and memory that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-descriptorBufferCaptureReplay-08113", "If the image was created with the VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT bit set", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-image-01045", "image must not have been created with any sparse memory binding flags", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-image-01050", "If image was created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE, memory must have been created with VkDedicatedAllocationMemoryAllocateInfoNV::image equal to an image handle created with identical creation parameters to image and memoryOffset must be zero", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-image-01445", "If image requires a dedicated allocation (as reported by vkGetImageMemoryRequirements2 in VkMemoryDedicatedRequirements::requiresDedicatedAllocation for image), memory must have been created with VkMemoryDedicatedAllocateInfo::image equal to image", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-image-01630", "If image was created with a valid swapchain handle in VkImageSwapchainCreateInfoKHR::swapchain, then the pNext chain must include a VkBindImageMemorySwapchainInfoKHR structure containing the same swapchain handle", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-image-07460", "image must not have been bound to a memory object", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-image-07736", "If image was created with the VK_IMAGE_CREATE_DISJOINT_BIT bit set, then the pNext chain must include a VkBindImagePlaneMemoryInfo structure", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-image-09202", "If the image was created with the VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT bit set, memory must have been allocated with the VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT bit set", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-image-parameter", "image must be a valid VkImage handle", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-memory-02628", "If the dedicatedAllocationImageAliasing feature is not enabled, and the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then image must equal VkMemoryDedicatedAllocateInfo::image and memoryOffset must be zero", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-memory-02629", "If the dedicatedAllocationImageAliasing feature is enabled, and the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfo structure in its pNext chain, and VkMemoryDedicatedAllocateInfo::image was not VK_NULL_HANDLE, then memoryOffset must be zero, and image must be either equal to VkMemoryDedicatedAllocateInfo::image or an image that was created using the same parameters in VkImageCreateInfo, with the exception that extent and arrayLayers may differ subject to the following restrictions: every dimension in the extent parameter of the image being bound must be equal to or smaller than the original image for which the allocation was created; and the arrayLayers parameter of the image being bound must be equal to or smaller than the original image for which the allocation was created", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-memory-02728", "If the value of VkExportMemoryAllocateInfo::handleTypes used to allocate memory is not 0, it must include at least one of the handles set in VkExternalMemoryImageCreateInfo::handleTypes when image was created", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-memory-02989", "If memory was created by a memory import operation, that is not VkImportAndroidHardwareBufferInfoANDROID with a non-NULL buffer value, the external handle type of the imported memory must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when image was created", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-memory-02990", "If memory was created with the VkImportAndroidHardwareBufferInfoANDROID memory import operation with a non-NULL buffer value, VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID must also have been set in VkExternalMemoryImageCreateInfo::handleTypes when image was created", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-memoryOffset-01046", "memoryOffset must be less than the size of memory", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-pNext-01615", "If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-pNext-01616", "If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-pNext-01617", "If the pNext chain does not include a VkBindImagePlaneMemoryInfo structure, the difference of the size of memory and memoryOffset must be greater than or equal to the size member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with the same image", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-pNext-01618", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, image must have been created with the VK_IMAGE_CREATE_DISJOINT_BIT bit set", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-pNext-01619", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image and where VkBindImagePlaneMemoryInfo::planeAspect corresponds to the VkImagePlaneMemoryRequirementsInfo::planeAspect in the VkImageMemoryRequirementsInfo2 structure's pNext chain", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-pNext-01620", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with image and where VkBindImagePlaneMemoryInfo::planeAspect corresponds to the VkImagePlaneMemoryRequirementsInfo::planeAspect in the VkImageMemoryRequirementsInfo2 structure's pNext chain", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-pNext-01621", "If the pNext chain includes a VkBindImagePlaneMemoryInfo structure, the difference of the size of memory and memoryOffset must be greater than or equal to the size member of the VkMemoryRequirements structure returned from a call to vkGetImageMemoryRequirements2 with the same image and where VkBindImagePlaneMemoryInfo::planeAspect corresponds to the VkImagePlaneMemoryRequirementsInfo::planeAspect in the VkImageMemoryRequirementsInfo2 structure's pNext chain", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-pNext-01626", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, all instances of memory specified by VkBindImageMemoryDeviceGroupInfo::pDeviceIndices must have been allocated", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-pNext-01627", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, and VkBindImageMemoryDeviceGroupInfo::splitInstanceBindRegionCount is not zero, then image must have been created with the VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT bit set", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-pNext-01628", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, all elements of VkBindImageMemoryDeviceGroupInfo::pSplitInstanceBindRegions must be valid rectangles contained within the dimensions of image", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-pNext-01629", "If the pNext chain includes a VkBindImageMemoryDeviceGroupInfo structure, the union of the areas of all elements of VkBindImageMemoryDeviceGroupInfo::pSplitInstanceBindRegions that correspond to the same instance of image must cover the entire image", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-pNext-01631", "If the pNext chain includes a VkBindImageMemorySwapchainInfoKHR structure, memory must be VK_NULL_HANDLE", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-pNext-01632", "If the pNext chain does not include a VkBindImageMemorySwapchainInfoKHR structure, memory must be a valid VkDeviceMemory handle", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBindImageMemoryDeviceGroupInfo, VkBindImageMemorySwapchainInfoKHR, VkBindImagePlaneMemoryInfo, or VkBindMemoryStatus", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO", "chapters/resources.html"},
    {"VUID-VkBindImageMemoryInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/resources.html"},
    {"VUID-VkBindImageMemorySwapchainInfoKHR-imageIndex-01644", "imageIndex must be less than the number of images in swapchain", "chapters/resources.html"},
    {"VUID-VkBindImageMemorySwapchainInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR", "chapters/resources.html"},
    {"VUID-VkBindImageMemorySwapchainInfoKHR-swapchain-07756", "If the swapchain has been created with VK_SWAPCHAIN_CREATE_DEFERRED_MEMORY_ALLOCATION_BIT_KHR, imageIndex must be one that has previously been returned by vkAcquireNextImageKHR or vkAcquireNextImage2KHR", "chapters/resources.html"},
    {"VUID-VkBindImageMemorySwapchainInfoKHR-swapchain-parameter", "swapchain must be a valid VkSwapchainKHR handle", "chapters/resources.html"},
    {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-02283", "If the image's tiling is VK_IMAGE_TILING_LINEAR or VK_IMAGE_TILING_OPTIMAL, then planeAspect must be a single valid multi-planar aspect mask bit", "chapters/resources.html"},
    {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-02284", "If the image's tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then planeAspect must be a single valid memory plane for the image (that is, aspectMask must specify a plane index that is less than the VkDrmFormatModifierPropertiesEXT::drmFormatModifierPlaneCount associated with the image's format and VkImageDrmFormatModifierPropertiesEXT::drmFormatModifier)", "chapters/resources.html"},
    {"VUID-VkBindImagePlaneMemoryInfo-planeAspect-parameter", "planeAspect must be a valid VkImageAspectFlagBits value", "chapters/resources.html"},
    {"VUID-VkBindImagePlaneMemoryInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO", "chapters/resources.html"},
    {"VUID-VkBindIndexBufferIndirectCommandEXT-None-11117", "The buffer's usage flags from which the address was acquired must have the VK_BUFFER_USAGE_INDEX_BUFFER_BIT bit set", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindIndexBufferIndirectCommandEXT-None-11119", "Each element of the buffer from which the address was acquired and that is non-sparse must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindIndexBufferIndirectCommandEXT-bufferAddress-11118", "The bufferAddress must be aligned to the VkIndexType of the indexType used", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindIndexBufferIndirectCommandEXT-indexType-parameter", "indexType must be a valid VkIndexType value", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindIndexBufferIndirectCommandNV-None-02946", "The buffer's usage flag from which the address was acquired must have the VK_BUFFER_USAGE_INDEX_BUFFER_BIT bit set", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindIndexBufferIndirectCommandNV-None-02948", "Each element of the buffer from which the address was acquired and that is non-sparse must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindIndexBufferIndirectCommandNV-bufferAddress-02947", "The bufferAddress must be aligned to the indexType used", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindIndexBufferIndirectCommandNV-indexType-parameter", "indexType must be a valid VkIndexType value", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindMemoryStatus-pResult-parameter", "pResult must be a valid pointer to a VkResult value", "chapters/resources.html"},
    {"VUID-VkBindMemoryStatus-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS", "chapters/resources.html"},
    {"VUID-VkBindPipelineIndirectCommandNV-None-09092", "The referenced pipeline must have been created with VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindPipelineIndirectCommandNV-None-09093", "The referenced pipeline must have been updated with vkCmdUpdatePipelineIndirectBufferNV", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindPipelineIndirectCommandNV-None-09094", "The referenced pipeline's address must have been queried with vkGetPipelineIndirectDeviceAddressNV", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindPipelineIndirectCommandNV-deviceGeneratedComputePipelines-09091", "The VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputePipelines feature must be enabled", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindShaderGroupIndirectCommandNV-None-02944", "The current bound graphics pipeline, as well as the pipelines it may reference, must have been created with VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindShaderGroupIndirectCommandNV-index-02945", "The index must be within range of the accessible shader groups of the current bound graphics pipeline. See vkCmdBindPipelineShaderGroupNV for further details", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindSparseInfo-commonparent", "Both of the elements of pSignalSemaphores, and the elements of pWaitSemaphores that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-pBufferBinds-parameter", "If bufferBindCount is not 0, pBufferBinds must be a valid pointer to an array of bufferBindCount valid VkSparseBufferMemoryBindInfo structures", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-pImageBinds-parameter", "If imageBindCount is not 0, pImageBinds must be a valid pointer to an array of imageBindCount valid VkSparseImageMemoryBindInfo structures", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-pImageOpaqueBinds-parameter", "If imageOpaqueBindCount is not 0, pImageOpaqueBinds must be a valid pointer to an array of imageOpaqueBindCount valid VkSparseImageOpaqueMemoryBindInfo structures", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-pNext-03247", "If the pNext chain of this structure includes a VkTimelineSemaphoreSubmitInfo structure and any element of pWaitSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then its waitSemaphoreValueCount member must equal waitSemaphoreCount", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-pNext-03248", "If the pNext chain of this structure includes a VkTimelineSemaphoreSubmitInfo structure and any element of pSignalSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then its signalSemaphoreValueCount member must equal signalSemaphoreCount", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-pNext-09753", "If the pNext chain of this structure includes a VkFrameBoundaryTensorsARM structure then it must also include a VkFrameBoundaryEXT structure.", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceGroupBindSparseInfo, VkFrameBoundaryEXT, VkFrameBoundaryTensorsARM, or VkTimelineSemaphoreSubmitInfo", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-pSignalSemaphores-03249", "For each element of pSignalSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pSignalSemaphoreValues must have a value greater than the current value of the semaphore when the semaphore signal operation is executed", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-pSignalSemaphores-03251", "For each element of pSignalSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pSignalSemaphoreValues must have a value which does not differ from the current value of the semaphore or from the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-pSignalSemaphores-parameter", "If signalSemaphoreCount is not 0, pSignalSemaphores must be a valid pointer to an array of signalSemaphoreCount valid VkSemaphore handles", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-pWaitSemaphores-03246", "If any element of pWaitSemaphores or pSignalSemaphores was created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE then the pNext chain must include a VkTimelineSemaphoreSubmitInfo structure", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-pWaitSemaphores-03250", "For each element of pWaitSemaphores created with a VkSemaphoreType of VK_SEMAPHORE_TYPE_TIMELINE the corresponding element of VkTimelineSemaphoreSubmitInfo::pWaitSemaphoreValues must have a value which does not differ from the current value of the semaphore or from the value of any outstanding semaphore wait or signal operation on that semaphore by more than maxTimelineSemaphoreValueDifference", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-pWaitSemaphores-parameter", "If waitSemaphoreCount is not 0, pWaitSemaphores must be a valid pointer to an array of waitSemaphoreCount valid VkSemaphore handles", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_SPARSE_INFO", "chapters/sparsemem.html"},
    {"VUID-VkBindSparseInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/sparsemem.html"},
    {"VUID-VkBindTensorMemoryInfoARM-commonparent", "Both of memory, and tensor must have been created, allocated, or retrieved from the same VkDevice", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-memory-09714", "memory must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned from a call to vkGetTensorMemoryRequirementsARM with tensor", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-memory-09806", "If the VkMemoryAllocateInfo provided when memory was allocated included a VkMemoryDedicatedAllocateInfoTensorARM structure in its pNext chain, and VkMemoryDedicatedAllocateInfoTensorARM::tensor was not VK_NULL_HANDLE, then tensor must equal VkMemoryDedicatedAllocateInfoTensorARM::tensor, and memoryOffset must be zero", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-memory-09895", "If the value of VkExportMemoryAllocateInfo::handleTypes used to allocate memory is not 0, it must include at least one of the handles set in VkExternalMemoryTensorCreateInfoARM::handleTypes when tensor was created", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-memory-09896", "If memory was allocated by a memory import operation, that is not VkImportAndroidHardwareBufferInfoANDROID with a non-NULL buffer value, the external handle type of the imported memory must also have been set in VkExternalMemoryTensorCreateInfoARM::handleTypes when tensor was created", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-memory-09897", "If memory was allocated with the VkImportAndroidHardwareBufferInfoANDROID memory import operation with a non-NULL buffer value, VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID must also have been set in VkExternalMemoryTensorCreateInfoARM::handleTypes when tensor was created", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-memory-parameter", "memory must be a valid VkDeviceMemory handle", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-memoryOffset-09713", "memoryOffset must be less than the size of memory", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-memoryOffset-09715", "memoryOffset must be an integer multiple of the alignment member of the VkMemoryRequirements structure returned from a call to vkGetTensorMemoryRequirementsARM with tensor", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_TENSOR_MEMORY_INFO_ARM", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-size-09716", "The size member of the VkMemoryRequirements structure returned from a call to vkGetTensorMemoryRequirementsARM with tensor must be less than or equal to the size of memory minus memoryOffset", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-tensor-09712", "tensor must not already be backed by a memory object", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-tensor-09717", "If tensor requires a dedicated allocation (as reported by vkGetTensorMemoryRequirementsARM in VkMemoryDedicatedRequirements::requiresDedicatedAllocation for tensor), memory must have been created with VkMemoryDedicatedAllocateInfoTensorARM::tensor equal to tensor", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-tensor-09718", "If tensor was created with the VK_TENSOR_CREATE_PROTECTED_BIT_ARM bit set, the tensor must be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-tensor-09719", "If tensor was created with the VK_TENSOR_CREATE_PROTECTED_BIT_ARM bit not set, the tensor must not be bound to a memory object allocated with a memory type that reports VK_MEMORY_PROPERTY_PROTECTED_BIT", "chapters/resources.html"},
    {"VUID-VkBindTensorMemoryInfoARM-tensor-parameter", "tensor must be a valid VkTensorARM handle", "chapters/resources.html"},
    {"VUID-VkBindVertexBufferIndirectCommandEXT-None-11120", "The buffer's usage flag from which the address was acquired must have the VK_BUFFER_USAGE_VERTEX_BUFFER_BIT bit set", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindVertexBufferIndirectCommandEXT-None-11121", "Each element of the buffer from which the address was acquired and that is non-sparse must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindVertexBufferIndirectCommandNV-None-02949", "The buffer's usage flag from which the address was acquired must have the VK_BUFFER_USAGE_VERTEX_BUFFER_BIT bit set", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindVertexBufferIndirectCommandNV-None-02950", "Each element of the buffer from which the address was acquired and that is non-sparse must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkBindVideoSessionMemoryInfoKHR-memory-parameter", "memory must be a valid VkDeviceMemory handle", "chapters/videocoding.html"},
    {"VUID-VkBindVideoSessionMemoryInfoKHR-memoryOffset-07201", "memoryOffset must be less than the size of memory", "chapters/videocoding.html"},
    {"VUID-VkBindVideoSessionMemoryInfoKHR-memorySize-07202", "memorySize must be less than or equal to the size of memory minus memoryOffset", "chapters/videocoding.html"},
    {"VUID-VkBindVideoSessionMemoryInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/videocoding.html"},
    {"VUID-VkBindVideoSessionMemoryInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR", "chapters/videocoding.html"},
    {"VUID-VkBlitImageCubicWeightsInfoQCOM-cubicWeights-parameter", "cubicWeights must be a valid VkCubicFilterWeightsQCOM value", "chapters/copies.html"},
    {"VUID-VkBlitImageCubicWeightsInfoQCOM-sType-sType", "sType must be VK_STRUCTURE_TYPE_BLIT_IMAGE_CUBIC_WEIGHTS_INFO_QCOM", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-aspectMask-00241", "For each element of pRegions, srcSubresource.aspectMask must specify aspects present in srcImage", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-aspectMask-00242", "For each element of pRegions, dstSubresource.aspectMask must specify aspects present in dstImage", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-commonparent", "Both of dstImage, and srcImage must have been created, allocated, or retrieved from the same VkDevice", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstImage-00224", "dstImage must have been created with VK_IMAGE_USAGE_TRANSFER_DST_BIT usage flag", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstImage-00225", "If dstImage is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstImage-00234", "dstImage must have been created with a samples value of VK_SAMPLE_COUNT_1_BIT", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstImage-00250", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffsets[0].y must be 0 and dstOffsets[1].y must be 1", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstImage-00252", "If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, dstOffsets[0].z must be 0 and dstOffsets[1].z must be 1", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstImage-02000", "The format features of dstImage must contain VK_FORMAT_FEATURE_BLIT_DST_BIT", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstImage-02545", "dstImage and srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstImage-06422", "dstImage must not use a format that requires a sampler Y'CBCR conversion", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstImage-parameter", "dstImage must be a valid VkImage handle", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstImageLayout-00226", "dstImageLayout must specify the layout of the image subresources of dstImage specified in pRegions at the time this command is executed on a VkDevice", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstImageLayout-01399", "dstImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstImageLayout-parameter", "dstImageLayout must be a valid VkImageLayout value", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstOffset-00248", "For each element of pRegions, dstOffsets[0].x and dstOffsets[1].x must both be greater than or equal to 0 and less than or equal to the width of the specified dstSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstOffset-00249", "For each element of pRegions, dstOffsets[0].y and dstOffsets[1].y must both be greater than or equal to 0 and less than or equal to the height of the specified dstSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstOffset-00251", "For each element of pRegions, dstOffsets[0].z and dstOffsets[1].z must both be greater than or equal to 0 and less than or equal to the depth of the specified dstSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstSubresource-01706", "The dstSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-dstSubresource-01708", "If dstSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, dstSubresource.baseArrayLayer + dstSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-filter-00237", "If filter is VK_FILTER_CUBIC_EXT, srcImage must be of type VK_IMAGE_TYPE_2D", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-filter-02001", "If filter is VK_FILTER_LINEAR, then the format features of srcImage must contain VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-filter-02002", "If filter is VK_FILTER_CUBIC_EXT, then the format features of srcImage must contain VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-filter-09204", "If filter is VK_FILTER_CUBIC_EXT and if the selectableCubicWeights feature is not enabled then the cubic weights must be VK_CUBIC_FILTER_WEIGHTS_CATMULL_ROM_QCOM", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-filter-parameter", "filter must be a valid VkFilter value", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-maintenance8-10207", "If the maintenance8 feature is enabled and srcImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer must be 0, and srcSubresource.layerCount and dstSubresource.layerCount must each be 1", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-maintenance8-10208", "If the maintenance8 feature is enabled and dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, dstSubresource.baseArrayLayer must be 0, and srcSubresource.layerCount and dstSubresource.layerCount must each be 1", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-maintenance8-10579", "If the maintenance8 feature is enabled, dstImage is VK_IMAGE_TYPE_3D, and srcImage is not of type VK_IMAGE_TYPE_3D, then for each element of pRegions, the absolute difference of the z member of each member of dstOffsets must equal srcSubresource.layerCount", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-maintenance8-10580", "If the maintenance8 feature is enabled, srcImage is VK_IMAGE_TYPE_3D, and dstImage is not of type VK_IMAGE_TYPE_3D, then for each element of pRegions, the absolute difference of the z member of each member of srcOffsets must equal dstSubresource.layerCount", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkBlitImageCubicWeightsInfoQCOM", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-pRegions-00217", "The union of all destination regions, specified by the elements of pRegions, must not overlap in memory with any texel that may be sampled during the blit operation", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-pRegions-04561", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage and dstImage must not be block-compressed images", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkImageBlit2 structures", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-regionCount-arraylength", "regionCount must be greater than 0", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImage-00219", "srcImage must have been created with VK_IMAGE_USAGE_TRANSFER_SRC_BIT usage flag", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImage-00220", "If srcImage is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImage-00229", "If either of srcImage or dstImage was created with a signed integer VkFormat, the other must also have been created with a signed integer VkFormat", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImage-00230", "If either of srcImage or dstImage was created with an unsigned integer VkFormat, the other must also have been created with an unsigned integer VkFormat", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImage-00231", "If either of srcImage or dstImage was created with a depth/stencil format, the other must have exactly the same format", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImage-00232", "If srcImage was created with a depth/stencil format, filter must be VK_FILTER_NEAREST", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImage-00233", "srcImage must have been created with a samples value of VK_SAMPLE_COUNT_1_BIT", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImage-00240", "If the maintenance8 feature is not enabled and either srcImage or dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer and dstSubresource.baseArrayLayer must each be 0, and srcSubresource.layerCount and dstSubresource.layerCount must each be 1", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImage-00245", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffsets[0].y must be 0 and srcOffsets[1].y must be 1", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImage-00247", "If srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, srcOffsets[0].z must be 0 and srcOffsets[1].z must be 1", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImage-01999", "The format features of srcImage must contain VK_FORMAT_FEATURE_BLIT_SRC_BIT", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImage-06421", "srcImage must not use a format that requires a sampler Y'CBCR conversion", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImage-09459", "If srcImage and dstImage are the same, and an elements of pRegions contains the srcSubresource and dstSubresource with matching mipLevel and overlapping array layers, then the srcImageLayout and dstImageLayout must be VK_IMAGE_LAYOUT_GENERAL or VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImage-parameter", "srcImage must be a valid VkImage handle", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImageLayout-00221", "srcImageLayout must specify the layout of the image subresources of srcImage specified in pRegions at the time this command is executed on a VkDevice", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImageLayout-01398", "srcImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL or VK_IMAGE_LAYOUT_GENERAL", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcImageLayout-parameter", "srcImageLayout must be a valid VkImageLayout value", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcOffset-00243", "For each element of pRegions, srcOffsets[0].x and srcOffsets[1].x must both be greater than or equal to 0 and less than or equal to the width of the specified srcSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcOffset-00244", "For each element of pRegions, srcOffsets[0].y and srcOffsets[1].y must both be greater than or equal to 0 and less than or equal to the height of the specified srcSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcOffset-00246", "For each element of pRegions, srcOffsets[0].z and srcOffsets[1].z must both be greater than or equal to 0 and less than or equal to the depth of the specified srcSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcSubresource-01705", "The srcSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2-srcSubresource-01707", "If srcSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, srcSubresource.baseArrayLayer + srcSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2KHR-pRegions-06207", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must be of type VK_IMAGE_TYPE_2D", "chapters/copies.html"},
    {"VUID-VkBlitImageInfo2KHR-pRegions-06208", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must not have a multi-planar format", "chapters/copies.html"},
    {"VUID-VkBufferCaptureDescriptorDataInfoEXT-buffer-08075", "buffer must have been created with VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT set in VkBufferCreateInfo::flags", "chapters/descriptorsets.html"},
    {"VUID-VkBufferCaptureDescriptorDataInfoEXT-buffer-parameter", "buffer must be a valid VkBuffer handle", "chapters/descriptorsets.html"},
    {"VUID-VkBufferCaptureDescriptorDataInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/descriptorsets.html"},
    {"VUID-VkBufferCaptureDescriptorDataInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkBufferCollectionBufferCreateInfoFUCHSIA-collection-parameter", "collection must be a valid VkBufferCollectionFUCHSIA handle", "chapters/resources.html"},
    {"VUID-VkBufferCollectionBufferCreateInfoFUCHSIA-index-06388", "index must be less than VkBufferCollectionPropertiesFUCHSIA::bufferCount", "chapters/resources.html"},
    {"VUID-VkBufferCollectionBufferCreateInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA", "chapters/resources.html"},
    {"VUID-VkBufferCollectionConstraintsInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkBufferCollectionConstraintsInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA", "chapters/resources.html"},
    {"VUID-VkBufferCollectionCreateInfoFUCHSIA-collectionToken-06393", "collectionToken must be a valid zx_handle_t to a Zircon channel allocated from Sysmem (fuchsia.sysmem.Allocator/AllocateSharedCollection) with ZX_DEFAULT_CHANNEL_RIGHTS rights", "chapters/resources.html"},
    {"VUID-VkBufferCollectionCreateInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkBufferCollectionCreateInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CREATE_INFO_FUCHSIA", "chapters/resources.html"},
    {"VUID-VkBufferCollectionImageCreateInfoFUCHSIA-collection-parameter", "collection must be a valid VkBufferCollectionFUCHSIA handle", "chapters/resources.html"},
    {"VUID-VkBufferCollectionImageCreateInfoFUCHSIA-index-06391", "index must be less than VkBufferCollectionPropertiesFUCHSIA::bufferCount", "chapters/resources.html"},
    {"VUID-VkBufferCollectionImageCreateInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA", "chapters/resources.html"},
    {"VUID-VkBufferCollectionPropertiesFUCHSIA-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkBufferCollectionPropertiesFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_COLLECTION_PROPERTIES_FUCHSIA", "chapters/resources.html"},
    {"VUID-VkBufferConstraintsInfoFUCHSIA-bufferCollectionConstraints-parameter", "bufferCollectionConstraints must be a valid VkBufferCollectionConstraintsInfoFUCHSIA structure", "chapters/resources.html"},
    {"VUID-VkBufferConstraintsInfoFUCHSIA-createInfo-parameter", "createInfo must be a valid VkBufferCreateInfo structure", "chapters/resources.html"},
    {"VUID-VkBufferConstraintsInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkBufferConstraintsInfoFUCHSIA-requiredFormatFeatures-06404", "The requiredFormatFeatures bitmask of VkFormatFeatureFlagBits must be chosen from among the buffer compatible format features listed in buffer compatible format features", "chapters/resources.html"},
    {"VUID-VkBufferConstraintsInfoFUCHSIA-requiredFormatFeatures-parameter", "requiredFormatFeatures must be a valid combination of VkFormatFeatureFlagBits values", "chapters/resources.html"},
    {"VUID-VkBufferConstraintsInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_CONSTRAINTS_INFO_FUCHSIA", "chapters/resources.html"},
    {"VUID-VkBufferCopy-size-01988", "The size must be greater than 0", "chapters/copies.html"},
    {"VUID-VkBufferCopy2-pNext-pNext", "pNext must be NULL", "chapters/copies.html"},
    {"VUID-VkBufferCopy2-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_COPY_2", "chapters/copies.html"},
    {"VUID-VkBufferCopy2-size-01988", "The size must be greater than 0", "chapters/copies.html"},
    {"VUID-VkBufferCreateInfo-None-01888", "If any of the bits VK_BUFFER_CREATE_SPARSE_BINDING_BIT, VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT, or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT are set, VK_BUFFER_CREATE_PROTECTED_BIT must not also be set", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-None-09499", "If the pNext chain does not include a VkBufferUsageFlags2CreateInfo structure, usage must be a valid combination of VkBufferUsageFlagBits values", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-None-09500", "If the pNext chain does not include a VkBufferUsageFlags2CreateInfo structure, usage must not be 0", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-deviceAddress-02604", "If VkBufferDeviceAddressCreateInfoEXT::deviceAddress is not zero, flags must include VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-flags-00915", "If the sparseBinding feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_BINDING_BIT", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-flags-00916", "If the sparseResidencyBuffer feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-flags-00917", "If the sparseResidencyAliased feature is not enabled, flags must not contain VK_BUFFER_CREATE_SPARSE_ALIASED_BIT", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-flags-00918", "If flags contains VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT, it must also contain VK_BUFFER_CREATE_SPARSE_BINDING_BIT", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-flags-01887", "If the protectedMemory feature is not enabled, flags must not contain VK_BUFFER_CREATE_PROTECTED_BIT", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-flags-03338", "If flags includes VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT, the VkPhysicalDeviceBufferDeviceAddressFeaturesEXT:bufferDeviceAddressCaptureReplay feature or the bufferDeviceAddressCaptureReplay feature must be enabled", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-flags-08099", "If flags includes VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT, the descriptorBufferCaptureReplay feature must be enabled", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-flags-08325", "If flags includes VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then videoMaintenance1 must be enabled", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-flags-09641", "If flags includes VK_BUFFER_CREATE_PROTECTED_BIT, then usage must not contain any of the following bits VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR VK_BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT VK_BUFFER_USAGE_MICROMAP_BUILD_INPUT_READ_ONLY_BIT_EXT VK_BUFFER_USAGE_MICROMAP_STORAGE_BIT_EXT", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-flags-parameter", "flags must be a valid combination of VkBufferCreateFlagBits values", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-opaqueCaptureAddress-03337", "If VkBufferOpaqueCaptureAddressCreateInfo::opaqueCaptureAddress is not zero, flags must include VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-pNext-00920", "If the pNext chain includes a VkExternalMemoryBufferCreateInfo structure, its handleTypes member must only contain bits that are also in VkExternalBufferProperties::externalMemoryProperties.compatibleHandleTypes, as returned by vkGetPhysicalDeviceExternalBufferProperties with pExternalBufferInfo->handleType equal to any one of the handle types specified in VkExternalMemoryBufferCreateInfo::handleTypes", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-pNext-01571", "If the pNext chain includes a VkDedicatedAllocationBufferCreateInfoNV structure, and the dedicatedAllocation member of the chained structure is VK_TRUE, then flags must not include VK_BUFFER_CREATE_SPARSE_BINDING_BIT, VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT, or VK_BUFFER_CREATE_SPARSE_ALIASED_BIT", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-pNext-08100", "If the pNext chain includes a VkOpaqueCaptureDescriptorDataCreateInfoEXT structure, flags must contain VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-pNext-10249", "If the pNext chain includes a VkVideoProfileListInfoKHR structure and for any element of its pProfiles member videoCodecOperation is VK_VIDEO_CODEC_OPERATION_ENCODE_AV1_BIT_KHR, then the videoEncodeAV1 feature must be enabled", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-pNext-10783", "If the pNext chain includes a VkVideoProfileListInfoKHR structure and for any element of its pProfiles member videoCodecOperation is VK_VIDEO_CODEC_OPERATION_DECODE_VP9_BIT_KHR, then the videoDecodeVP9 feature must be enabled", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBufferCollectionBufferCreateInfoFUCHSIA, VkBufferDeviceAddressCreateInfoEXT, VkBufferOpaqueCaptureAddressCreateInfo, VkBufferUsageFlags2CreateInfo, VkDedicatedAllocationBufferCreateInfoNV, VkExternalMemoryBufferCreateInfo, VkOpaqueCaptureDescriptorDataCreateInfoEXT, or VkVideoProfileListInfoKHR", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-sharingMode-00913", "If sharingMode is VK_SHARING_MODE_CONCURRENT, pQueueFamilyIndices must be a valid pointer to an array of queueFamilyIndexCount uint32_t values", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-sharingMode-00914", "If sharingMode is VK_SHARING_MODE_CONCURRENT, queueFamilyIndexCount must be greater than 1", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-sharingMode-01419", "If sharingMode is VK_SHARING_MODE_CONCURRENT, each element of pQueueFamilyIndices must be unique and must be less than pQueueFamilyPropertyCount returned by either vkGetPhysicalDeviceQueueFamilyProperties2 or vkGetPhysicalDeviceQueueFamilyProperties for the physicalDevice that was used to create device", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-sharingMode-parameter", "sharingMode must be a valid VkSharingMode value", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-size-00912", "size must be greater than 0", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-size-06409", "size must be less than or equal to VkPhysicalDeviceMaintenance4Properties::maxBufferSize", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-tileMemoryHeap-10762", "If the tileMemoryHeap feature is not enabled, usage must not include VK_BUFFER_USAGE_TILE_MEMORY_BIT_QCOM", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-usage-04813", "If usage includes VK_BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR or VK_BUFFER_USAGE_VIDEO_DECODE_DST_BIT_KHR, and flags does not include VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then the pNext chain must include a VkVideoProfileListInfoKHR structure with profileCount greater than 0 and pProfiles including at least one VkVideoProfileInfoKHR structure with a videoCodecOperation member specifying a decode operation", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-usage-04814", "If usage includes VK_BUFFER_USAGE_VIDEO_ENCODE_SRC_BIT_KHR or VK_BUFFER_USAGE_VIDEO_ENCODE_DST_BIT_KHR, and flags does not include VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then the pNext chain must include a VkVideoProfileListInfoKHR structure with profileCount greater than 0 and pProfiles including at least one VkVideoProfileInfoKHR structure with a videoCodecOperation member specifying an encode operation", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-usage-08097", "If usage includes VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT, creating this VkBuffer must not cause the total required space for all currently valid buffers using this flag on the device to exceed VkPhysicalDeviceDescriptorBufferPropertiesEXT::samplerDescriptorBufferAddressSpaceSize or VkPhysicalDeviceDescriptorBufferPropertiesEXT::descriptorBufferAddressSpaceSize", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-usage-08098", "If usage includes VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT, creating this VkBuffer must not cause the total required space for all currently valid buffers using this flag on the device to exceed VkPhysicalDeviceDescriptorBufferPropertiesEXT::resourceDescriptorBufferAddressSpaceSize or VkPhysicalDeviceDescriptorBufferPropertiesEXT::descriptorBufferAddressSpaceSize", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-usage-08101", "If usage includes VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT, the descriptorBufferPushDescriptors feature must be enabled", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-usage-08102", "If usage includes VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT VkPhysicalDeviceDescriptorBufferPropertiesEXT::bufferlessPushDescriptors must be VK_FALSE", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-usage-08103", "If usage includes VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT, usage must contain at least one of VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT or VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-usage-10763", "If usage includes VK_BUFFER_USAGE_TILE_MEMORY_BIT_QCOM, then flags must not contain any of the following bits VK_BUFFER_CREATE_SPARSE_BINDING_BIT VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT VK_BUFFER_CREATE_SPARSE_ALIASED_BIT VK_BUFFER_CREATE_PROTECTED_BIT VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT VK_BUFFER_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT VK_BUFFER_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR", "chapters/resources.html"},
    {"VUID-VkBufferCreateInfo-usage-10764", "If usage includes VK_BUFFER_USAGE_TILE_MEMORY_BIT_QCOM, then only the following usages may be set: VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT VK_BUFFER_USAGE_STORAGE_BUFFER_BIT VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT and if VkPhysicalDeviceTileMemoryHeapPropertiesQCOM::tileBufferTransfers is VK_TRUE then additionally VK_BUFFER_USAGE_TRANSFER_SRC_BIT or VK_BUFFER_USAGE_TRANSFER_DST_BIT", "chapters/resources.html"},
    {"VUID-VkBufferDeviceAddressCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT", "chapters/resources.html"},
    {"VUID-VkBufferDeviceAddressInfo-buffer-02601", "buffer must have been created with VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT", "chapters/resources.html"},
    {"VUID-VkBufferDeviceAddressInfo-buffer-parameter", "buffer must be a valid VkBuffer handle", "chapters/resources.html"},
    {"VUID-VkBufferDeviceAddressInfo-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkBufferDeviceAddressInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO", "chapters/resources.html"},
    {"VUID-VkBufferImageCopy-aspectMask-09103", "The aspectMask member of imageSubresource must only have a single bit set", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy-bufferImageHeight-09102", "bufferImageHeight must be 0, or greater than or equal to the height member of imageExtent", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy-bufferRowLength-09101", "bufferRowLength must be 0, or greater than or equal to the width member of imageExtent", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy-imageExtent-06659", "imageExtent.width must not be 0", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy-imageExtent-06660", "imageExtent.height must not be 0", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy-imageExtent-06661", "imageExtent.depth must not be 0", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy-imageSubresource-parameter", "imageSubresource must be a valid VkImageSubresourceLayers structure", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy2-aspectMask-09103", "The aspectMask member of imageSubresource must only have a single bit set", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy2-bufferImageHeight-09102", "bufferImageHeight must be 0, or greater than or equal to the height member of imageExtent", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy2-bufferRowLength-09101", "bufferRowLength must be 0, or greater than or equal to the width member of imageExtent", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy2-imageExtent-06659", "imageExtent.width must not be 0", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy2-imageExtent-06660", "imageExtent.height must not be 0", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy2-imageExtent-06661", "imageExtent.depth must not be 0", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy2-imageSubresource-parameter", "imageSubresource must be a valid VkImageSubresourceLayers structure", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkCopyCommandTransformInfoQCOM", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy2-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2", "chapters/copies.html"},
    {"VUID-VkBufferImageCopy2-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/copies.html"},
    {"VUID-VkBufferMemoryBarrier-None-09049", "If the synchronization2 feature is not enabled, and buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, at least one of srcQueueFamilyIndex and dstQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-None-09050", "If the synchronization2 feature is not enabled, and buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, srcQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED or VK_QUEUE_FAMILY_EXTERNAL", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-None-09051", "If the synchronization2 feature is not enabled, and buffer was created with a sharing mode of VK_SHARING_MODE_CONCURRENT, dstQueueFamilyIndex must be VK_QUEUE_FAMILY_IGNORED or VK_QUEUE_FAMILY_EXTERNAL", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-None-09097", "If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-None-09098", "If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-buffer-01931", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-buffer-09095", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-buffer-09096", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, dstQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-buffer-parameter", "buffer must be a valid VkBuffer handle", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-dstQueueFamilyIndex-09100", "If the VK_EXT_queue_family_foreign extension is not enabled dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-offset-01187", "offset must be less than the size of buffer", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkExternalMemoryAcquireUnmodifiedEXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-size-01188", "If size is not equal to VK_WHOLE_SIZE, size must be greater than 0", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-size-01189", "If size is not equal to VK_WHOLE_SIZE, size must be less than or equal to than the size of buffer minus offset", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier-srcQueueFamilyIndex-09099", "If the VK_EXT_queue_family_foreign extension is not enabled srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-None-09097", "If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-None-09098", "If the VK_KHR_external_memory extension is not enabled, and the value of VkApplicationInfo::apiVersion used to create the VkInstance is not greater than or equal to Version 1.1, dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_EXTERNAL", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-buffer-01931", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-buffer-09095", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, srcQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-buffer-09096", "If buffer was created with a sharing mode of VK_SHARING_MODE_EXCLUSIVE, and srcQueueFamilyIndex and dstQueueFamilyIndex are not equal, dstQueueFamilyIndex must be VK_QUEUE_FAMILY_EXTERNAL, VK_QUEUE_FAMILY_FOREIGN_EXT, or a valid queue family", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-buffer-parameter", "buffer must be a valid VkBuffer handle", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03900", "If dstAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03901", "If dstAccessMask includes VK_ACCESS_2_INDEX_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03902", "If dstAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03903", "If dstAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03904", "If dstAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03905", "If dstAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03906", "If dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03907", "If dstAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03909", "If dstAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03910", "If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03911", "If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03912", "If dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03913", "If dstAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03914", "If dstAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_CONVERT_COOPERATIVE_VECTOR_MATRIX_BIT_NV, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03915", "If dstAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_CLEAR_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_CONVERT_COOPERATIVE_VECTOR_MATRIX_BIT_NV, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03916", "If dstAccessMask includes VK_ACCESS_2_HOST_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03917", "If dstAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03918", "If dstAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03919", "If dstAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03920", "If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03922", "If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03923", "If dstAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03924", "If dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03925", "If dstAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03926", "If dstAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03927", "If dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-03928", "If dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04747", "If dstAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04858", "If dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04859", "If dstAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04860", "If dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04861", "If dstAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-04994", "If dstAccessMask includes VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI, dstStageMask must include VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-06256", "If the rayQuery feature is not enabled and dstAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, dstStageMask must not include any of the VK_PIPELINE_STAGE_*_SHADER_BIT stages except VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07272", "If dstAccessMask includes VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT or VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07454", "If dstAccessMask includes VK_ACCESS_2_SHADER_READ_BIT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07455", "If dstAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07456", "If dstAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV, dstStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07457", "If dstAccessMask includes VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-07458", "If dstAccessMask includes VK_ACCESS_2_MICROMAP_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT or VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-08118", "If dstAccessMask includes VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT, dstStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-10670", "If dstAccessMask includes VK_ACCESS_2_SHADER_TILE_ATTACHMENT_READ_BIT_QCOM, dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT or VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-10671", "If dstAccessMask includes VK_ACCESS_2_SHADER_TILE_ATTACHMENT_WRITE_BIT_QCOM, dstStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT or VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstAccessMask-parameter", "dstAccessMask must be a valid combination of VkAccessFlagBits2 values", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstQueueFamilyIndex-09100", "If the VK_EXT_queue_family_foreign extension is not enabled dstQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-03929", "If the geometryShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-03930", "If the tessellationShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-03931", "If the conditionalRendering feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-03932", "If the fragmentDensityMap feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-03933", "If the transformFeedback feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-03934", "If the meshShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-03935", "If the taskShader feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-04957", "If the subpassShading feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-04995", "If the invocationMask feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-07316", "If neither of the shadingRateImage or the attachmentFragmentShadingRate features are enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-07946", "If neither the VK_NV_ray_tracing extension or the rayTracingPipeline feature are enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-10751", "If the accelerationStructure feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-10752", "If the rayTracingMaintenance1 feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-10753", "If the micromap feature is not enabled, dstStageMask must not contain VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-dstStageMask-parameter", "dstStageMask must be a valid combination of VkPipelineStageFlagBits2 values", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-offset-01187", "offset must be less than the size of buffer", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExternalMemoryAcquireUnmodifiedEXT or VkMemoryBarrierAccessFlags3KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-size-01188", "If size is not equal to VK_WHOLE_SIZE, size must be greater than 0", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-size-01189", "If size is not equal to VK_WHOLE_SIZE, size must be less than or equal to than the size of buffer minus offset", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03900", "If srcAccessMask includes VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03901", "If srcAccessMask includes VK_ACCESS_2_INDEX_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03902", "If srcAccessMask includes VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT, VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03903", "If srcAccessMask includes VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT, VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03904", "If srcAccessMask includes VK_ACCESS_2_UNIFORM_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03905", "If srcAccessMask includes VK_ACCESS_2_SHADER_SAMPLED_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03906", "If srcAccessMask includes VK_ACCESS_2_SHADER_STORAGE_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03907", "If srcAccessMask includes VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03909", "If srcAccessMask includes VK_ACCESS_2_SHADER_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03910", "If srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03911", "If srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03912", "If srcAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03913", "If srcAccessMask includes VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03914", "If srcAccessMask includes VK_ACCESS_2_TRANSFER_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_CONVERT_COOPERATIVE_VECTOR_MATRIX_BIT_NV, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03915", "If srcAccessMask includes VK_ACCESS_2_TRANSFER_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_COPY_BIT, VK_PIPELINE_STAGE_2_BLIT_BIT, VK_PIPELINE_STAGE_2_RESOLVE_BIT, VK_PIPELINE_STAGE_2_CLEAR_BIT, VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_CONVERT_COOPERATIVE_VECTOR_MATRIX_BIT_NV, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03916", "If srcAccessMask includes VK_ACCESS_2_HOST_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03917", "If srcAccessMask includes VK_ACCESS_2_HOST_WRITE_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_HOST_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03918", "If srcAccessMask includes VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03919", "If srcAccessMask includes VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03920", "If srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03922", "If srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03923", "If srcAccessMask includes VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03924", "If srcAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03925", "If srcAccessMask includes VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03926", "If srcAccessMask includes VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03927", "If srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-03928", "If srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04747", "If srcAccessMask includes VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT, VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT, VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, or VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04858", "If srcAccessMask includes VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04859", "If srcAccessMask includes VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04860", "If srcAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04861", "If srcAccessMask includes VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-04994", "If srcAccessMask includes VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI, srcStageMask must include VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-06256", "If the rayQuery feature is not enabled and srcAccessMask includes VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR, srcStageMask must not include any of the VK_PIPELINE_STAGE_*_SHADER_BIT stages except VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07272", "If srcAccessMask includes VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT or VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07454", "If srcAccessMask includes VK_ACCESS_2_SHADER_READ_BIT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR, VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT, or one of the VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07455", "If srcAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_READ_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07456", "If srcAccessMask includes VK_ACCESS_2_OPTICAL_FLOW_WRITE_BIT_NV, srcStageMask must include VK_PIPELINE_STAGE_2_OPTICAL_FLOW_BIT_NV", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07457", "If srcAccessMask includes VK_ACCESS_2_MICROMAP_WRITE_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-07458", "If srcAccessMask includes VK_ACCESS_2_MICROMAP_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT or VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-08118", "If srcAccessMask includes VK_ACCESS_2_DESCRIPTOR_BUFFER_READ_BIT_EXT, srcStageMask must include VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT, VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT, or one of VK_PIPELINE_STAGE_*_SHADER_BIT stages", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-10670", "If srcAccessMask includes VK_ACCESS_2_SHADER_TILE_ATTACHMENT_READ_BIT_QCOM, srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT or VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-10671", "If srcAccessMask includes VK_ACCESS_2_SHADER_TILE_ATTACHMENT_WRITE_BIT_QCOM, srcStageMask must include VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT or VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcAccessMask-parameter", "srcAccessMask must be a valid combination of VkAccessFlagBits2 values", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcQueueFamilyIndex-09099", "If the VK_EXT_queue_family_foreign extension is not enabled srcQueueFamilyIndex must not be VK_QUEUE_FAMILY_FOREIGN_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03851", "If either srcStageMask or dstStageMask includes VK_PIPELINE_STAGE_2_HOST_BIT, srcQueueFamilyIndex and dstQueueFamilyIndex must be equal", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03929", "If the geometryShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03930", "If the tessellationShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT or VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03931", "If the conditionalRendering feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03932", "If the fragmentDensityMap feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03933", "If the transformFeedback feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03934", "If the meshShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-03935", "If the taskShader feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-04957", "If the subpassShading feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_SUBPASS_SHADER_BIT_HUAWEI", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-04995", "If the invocationMask feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-07316", "If neither of the shadingRateImage or the attachmentFragmentShadingRate features are enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-07946", "If neither the VK_NV_ray_tracing extension or the rayTracingPipeline feature are enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-10751", "If the accelerationStructure feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-10752", "If the rayTracingMaintenance1 feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-10753", "If the micromap feature is not enabled, srcStageMask must not contain VK_PIPELINE_STAGE_2_MICROMAP_BUILD_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryBarrier2-srcStageMask-parameter", "srcStageMask must be a valid combination of VkPipelineStageFlagBits2 values", "chapters/synchronization.html"},
    {"VUID-VkBufferMemoryRequirementsInfo2-buffer-parameter", "buffer must be a valid VkBuffer handle", "chapters/resources.html"},
    {"VUID-VkBufferMemoryRequirementsInfo2-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkBufferMemoryRequirementsInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2", "chapters/resources.html"},
    {"VUID-VkBufferOpaqueCaptureAddressCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO", "chapters/resources.html"},
    {"VUID-VkBufferUsageFlags2CreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO", "chapters/resources.html"},
    {"VUID-VkBufferUsageFlags2CreateInfo-usage-parameter", "usage must be a valid combination of VkBufferUsageFlagBits2 values", "chapters/resources.html"},
    {"VUID-VkBufferUsageFlags2CreateInfo-usage-requiredbitmask", "usage must not be 0", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-buffer-00932", "buffer must have been created with a usage value containing at least one of VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT or VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-buffer-00935", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-buffer-02750", "If the texelBufferAlignment feature is enabled and if buffer was created with usage containing VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT, offset must be a multiple of the lesser of VkPhysicalDeviceTexelBufferAlignmentProperties::storageTexelBufferOffsetAlignmentBytes or, if VkPhysicalDeviceTexelBufferAlignmentProperties::storageTexelBufferOffsetSingleTexelAlignment is VK_TRUE, the size of a texel of the requested format. If the size of a texel is a multiple of three bytes, then the size of a single component of format is used instead", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-buffer-02751", "If the texelBufferAlignment feature is enabled and if buffer was created with usage containing VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT, offset must be a multiple of the lesser of VkPhysicalDeviceTexelBufferAlignmentProperties::uniformTexelBufferOffsetAlignmentBytes or, if VkPhysicalDeviceTexelBufferAlignmentProperties::uniformTexelBufferOffsetSingleTexelAlignment is VK_TRUE, the size of a texel of the requested format. If the size of a texel is a multiple of three bytes, then the size of a single component of format is used instead", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-buffer-parameter", "buffer must be a valid VkBuffer handle", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-flags-zerobitmask", "flags must be 0", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-format-08778", "If the buffer view usage contains VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT, then format features of format must contain VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-format-08779", "If the buffer view usage contains VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT, then format features of format must contain VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-format-parameter", "format must be a valid VkFormat value", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-offset-00925", "offset must be less than the size of buffer", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-offset-00931", "If range is not equal to VK_WHOLE_SIZE, the sum of offset and range must be less than or equal to the size of buffer", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-offset-02749", "If the texelBufferAlignment feature is not enabled, offset must be a multiple of VkPhysicalDeviceLimits::minTexelBufferOffsetAlignment", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-pNext-06782", "If the pNext chain includes a VkExportMetalObjectCreateInfoEXT structure, its exportObjectType member must be VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-pNext-08780", "If the pNext chain includes a VkBufferUsageFlags2CreateInfo, its usage must not contain any other bit than VK_BUFFER_USAGE_2_UNIFORM_TEXEL_BUFFER_BIT or VK_BUFFER_USAGE_2_STORAGE_TEXEL_BUFFER_BIT", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-pNext-08781", "If the pNext chain includes a VkBufferUsageFlags2CreateInfo, its usage must be a subset of the VkBufferCreateInfo::usage specified or VkBufferUsageFlags2CreateInfo::usage from VkBufferCreateInfo::pNext when creating buffer", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBufferUsageFlags2CreateInfo or VkExportMetalObjectCreateInfoEXT", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-range-00928", "If range is not equal to VK_WHOLE_SIZE, range must be greater than 0", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-range-00929", "If range is not equal to VK_WHOLE_SIZE, range must be an integer multiple of the texel block size of format", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-range-00930", "If range is not equal to VK_WHOLE_SIZE, the number of texel buffer elements given by (floor(range / (texel block size)) x (texels per block)) where texel block size and texels per block are as defined in the Compatible Formats table for format, must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-range-04059", "If range is equal to VK_WHOLE_SIZE, the number of texel buffer elements given by (floor((size - offset) / (texel block size)) x (texels per block)) where size is the size of buffer, and texel block size and texels per block are as defined in the Compatible Formats table for format, must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO", "chapters/resources.html"},
    {"VUID-VkBufferViewCreateInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique, with the exception of structures of type VkExportMetalObjectCreateInfoEXT", "chapters/resources.html"},
    {"VUID-VkBuildPartitionedAccelerationStructureIndirectCommandNV-argData-10565", "An instance index must not be referenced by more than one structure in argData", "chapters/accelstructures.html"},
    {"VUID-VkBuildPartitionedAccelerationStructureIndirectCommandNV-opType-parameter", "opType must be a valid VkPartitionedAccelerationStructureOpTypeNV value", "chapters/accelstructures.html"},
    {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-dstAccelerationStructureData-10561", "dstAccelerationStructureData must not be NULL", "chapters/accelstructures.html"},
    {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-dstAccelerationStructureData-10562", "Memory at dstAccelerationStructureData must be equal or larger than the VkAccelerationStructureBuildSizesInfoKHR::accelerationStructureSize value returned from vkGetPartitionedAccelerationStructuresBuildSizesNV with the same build parameters", "chapters/accelstructures.html"},
    {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-input-parameter", "input must be a valid VkPartitionedAccelerationStructureInstancesInputNV structure", "chapters/accelstructures.html"},
    {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-pNext-pNext", "pNext must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_BUILD_PARTITIONED_ACCELERATION_STRUCTURE_INFO_NV", "chapters/accelstructures.html"},
    {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-scratchData-10558", "scratchData must not be NULL", "chapters/accelstructures.html"},
    {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-scratchData-10559", "Memory at scratchData must be equal or larger than the VkAccelerationStructureBuildSizesInfoKHR::buildScratchSize value returned from vkGetPartitionedAccelerationStructuresBuildSizesNV with the same build parameters", "chapters/accelstructures.html"},
    {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-srcAccelerationStructureData-10560", "If srcAccelerationStructureData is not NULL, it must have previously been built as a PTLAS", "chapters/accelstructures.html"},
    {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-srcInfos-10564", "Each element of srcInfos array must have a unique VkBuildPartitionedAccelerationStructureIndirectCommandNV::opType", "chapters/accelstructures.html"},
    {"VUID-VkBuildPartitionedAccelerationStructureInfoNV-srcInfosCount-10563", "srcInfosCount must be 4-byte aligned", "chapters/accelstructures.html"},
    {"VUID-VkCalibratedTimestampInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/synchronization.html"},
    {"VUID-VkCalibratedTimestampInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_KHR", "chapters/synchronization.html"},
    {"VUID-VkCalibratedTimestampInfoKHR-timeDomain-02354", "timeDomain must be one of the VkTimeDomainKHR values returned by vkGetPhysicalDeviceCalibrateableTimeDomainsKHR", "chapters/synchronization.html"},
    {"VUID-VkCalibratedTimestampInfoKHR-timeDomain-parameter", "timeDomain must be a valid VkTimeDomainKHR value", "chapters/synchronization.html"},
    {"VUID-VkCheckpointData2NV-pNext-pNext", "pNext must be NULL", "chapters/debugging.html"},
    {"VUID-VkCheckpointData2NV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV", "chapters/debugging.html"},
    {"VUID-VkCheckpointDataNV-pNext-pNext", "pNext must be NULL", "chapters/debugging.html"},
    {"VUID-VkCheckpointDataNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV", "chapters/debugging.html"},
    {"VUID-VkClearAttachment-aspectMask-00019", "If aspectMask includes VK_IMAGE_ASPECT_COLOR_BIT, it must not include VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT", "chapters/clears.html"},
    {"VUID-VkClearAttachment-aspectMask-00020", "aspectMask must not include VK_IMAGE_ASPECT_METADATA_BIT", "chapters/clears.html"},
    {"VUID-VkClearAttachment-aspectMask-02246", "aspectMask must not include VK_IMAGE_ASPECT_MEMORY_PLANE_i_BIT_EXT for any index i", "chapters/clears.html"},
    {"VUID-VkClearAttachment-aspectMask-parameter", "aspectMask must be a valid combination of VkImageAspectFlagBits values", "chapters/clears.html"},
    {"VUID-VkClearAttachment-aspectMask-requiredbitmask", "aspectMask must not be 0", "chapters/clears.html"},
    {"VUID-VkClearDepthStencilValue-depth-00022", "Unless the VK_EXT_depth_range_unrestricted extension is enabled depth must be between 0.0 and 1.0, inclusive", "chapters/clears.html"},
    {"VUID-VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV-clusterReferences-10484", "All cluster references in clusterReferences must be unique", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV-clusterReferences-10485", "clusterReferences must have at least clusterReferencesCount values", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildClustersBottomLevelInfoNV-clusterReferencesStride-10486", "clusterReferencesStride must be greater than or equal to 8", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-baseGeometryIndex-10496", "The maximum geometry index after using the values in baseGeometryIndex and geometryIndexBuffer must be less than VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxClusterGeometryIndex", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-clusterFlags-parameter", "clusterFlags must be a valid combination of VkClusterAccelerationStructureClusterFlagBitsNV values", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-clusterID-10488", "clusterID must not be 0xFFFFFFFF", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-indexBufferStride-10494", "indexBufferStride must be 0 or a multiple of indexType", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-indexType-10491", "indexType must only have a single bit set", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-opacityMicromapIndexType-10492", "opacityMicromapIndexType must only have a single bit set", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-positionTruncateBitCount-10493", "positionTruncateBitCount must be greater than or equal to VkClusterAccelerationStructureTriangleClusterInputNV::minPositionTruncateBitCount and less than or equal to 32", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-triangleCount-10489", "triangleCount must be less than or equal to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxTrianglesPerCluster", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-vertexBufferStride-10495", "vertexBufferStride must be 0 or a multiple of value specified in VkClusterAccelerationStructureTriangleClusterInputNV::vertexFormat", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterInfoNV-vertexCount-10490", "vertexCount must be less than or equal to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxVerticesPerCluster", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-baseGeometryIndex-10506", "The maximum geometry index after using the values in baseGeometryIndex and geometryIndexBuffer must be less than VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxClusterGeometryIndex", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-clusterFlags-parameter", "clusterFlags must be a valid combination of VkClusterAccelerationStructureClusterFlagBitsNV values", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-clusterID-10497", "clusterID must not be 0xFFFFFFFF", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-indexBufferStride-10503", "indexBufferStride must be 0 or a multiple of indexType", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-indexType-10500", "indexType must only have a single bit set", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-instantiationBoundingBoxLimit-10505", "instantiationBoundingBoxLimit must be aligned to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::clusterTemplateBoundsByteAlignment", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-opacityMicromapIndexType-10501", "opacityMicromapIndexType must only have a single bit set", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-positionTruncateBitCount-10502", "positionTruncateBitCount must be greater than or equal to VkClusterAccelerationStructureTriangleClusterInputNV::minPositionTruncateBitCount and less than or equal to 32", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-triangleCount-10498", "triangleCount must be less than or equal to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxTrianglesPerCluster", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-vertexBufferStride-10504", "vertexBufferStride must be 0 or a multiple of value specified in VkClusterAccelerationStructureTriangleClusterInputNV::vertexFormat", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureBuildTriangleClusterTemplateInfoNV-vertexCount-10499", "vertexCount must be less than or equal to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxVerticesPerCluster", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureClustersBottomLevelInputNV-pNext-pNext", "pNext must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureClustersBottomLevelInputNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_CLUSTERS_BOTTOM_LEVEL_INPUT_NV", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-addressResolutionFlags-parameter", "addressResolutionFlags must be a valid combination of VkClusterAccelerationStructureAddressResolutionFlagBitsNV values", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-dstAddressesArray-10474", "The stride in dstAddressesArray must be greater than or equal to 8", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-dstSizesArray-10475", "The stride in dstSizesArray must be greater than or equal to 4", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-input-10469", "If input::opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_MOVE_OBJECTS_NV, the total memory moved must not be larger than the size provided in VkClusterAccelerationStructureMoveObjectsInputNV::maxMovedBytes", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-input-10477", "If input::opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_TRIANGLE_CLUSTER_NV, then depending on the VkClusterAccelerationStructureInputInfoNV::opMode, dstImplicitData or addresses specified in dstAddressesArray must be aligned to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::clusterByteAlignment", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-input-10478", "If input::opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_TRIANGLE_CLUSTER_TEMPLATE_NV, then depending on the VkClusterAccelerationStructureInputInfoNV::opMode, dstImplicitData or addresses specified in dstAddressesArray must be aligned to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::clusterTemplateByteAlignment", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-input-10479", "If input::opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_INSTANTIATE_TRIANGLE_CLUSTER_NV, then depending on the VkClusterAccelerationStructureInputInfoNV::opMode, dstImplicitData or addresses specified in dstAddressesArray must be aligned to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::clusterByteAlignment", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-input-10482", "If input::opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_CLUSTERS_BOTTOM_LEVEL_NV, the total and per argument number of cluster acceleration structures referenced in srcInfosArray must be equal or less than the maximum values with which memory requirements were queried in vkGetClusterAccelerationStructureBuildSizesNV with VkClusterAccelerationStructureOpInputNV::pClustersBottomLevel", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-input-parameter", "input must be a valid VkClusterAccelerationStructureInputInfoNV structure", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-10466", "If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_IMPLICIT_DESTINATIONS_NV, dstImplicitData must be a valid address", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-10467", "If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_IMPLICIT_DESTINATIONS_NV and input::opType is not VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_MOVE_OBJECTS_NV, the memory in dstImplicitData must be equal to or larger than the VkAccelerationStructureBuildSizesInfoKHR::accelerationStructureSize value returned from vkGetClusterAccelerationStructureBuildSizesNV with same input parameters", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-10468", "If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_IMPLICIT_DESTINATIONS_NV and input::opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_MOVE_OBJECTS_NV, the memory in dstImplicitData must be equal to or larger than the sum of all the built acceleration structures that are being moved", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-10470", "If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_COMPUTE_SIZES_NV, dstSizesArray must be a valid address", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-10471", "If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_EXPLICIT_DESTINATIONS_NV, the address in dstAddressesArray must be a valid address with sizes of individual buffers large enough to accommodate built or moved clusters", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-10472", "If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_EXPLICIT_DESTINATIONS_NV, the buffers in dstAddressesArray must not overlap", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-opMode-10473", "If VkClusterAccelerationStructureInputInfoNV::opMode is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_MODE_EXPLICIT_DESTINATIONS_NV, the addresses in dstAddressesArray must be aligned based on the cluster acceleration structure type and its alignment properties as described in VkPhysicalDeviceClusterAccelerationStructurePropertiesNV", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-pNext-pNext", "pNext must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_COMMANDS_INFO_NV", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-scratchData-10480", "scratchData must be aligned to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::clusterScratchByteAlignment", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-srcInfosArray-10476", "The stride in srcInfosArray must be greater than the type of structure the address is describing", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureCommandsInfoNV-srcInfosCount-10481", "srcInfosCount must be 4-byte aligned", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureGeometryIndexAndGeometryFlagsNV-reserved-10487", "reserved must be 0", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureGetTemplateIndicesInfoNV-clusterTemplateAddress-10833", "clusterTemplateAddress must be a template cluster acceleration structure", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureInputInfoNV-flags-parameter", "flags must be a valid combination of VkBuildAccelerationStructureFlagBitsKHR values", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureInputInfoNV-opMode-parameter", "opMode must be a valid VkClusterAccelerationStructureOpModeNV value", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureInputInfoNV-opType-parameter", "opType must be a valid VkClusterAccelerationStructureOpTypeNV value", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureInputInfoNV-pClustersBottomLevel-parameter", "If opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_CLUSTERS_BOTTOM_LEVEL_NV, the pClustersBottomLevel member of opInput must be a valid pointer to a VkClusterAccelerationStructureClustersBottomLevelInputNV structure", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureInputInfoNV-pMoveObjects-parameter", "If opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_MOVE_OBJECTS_NV, the pMoveObjects member of opInput must be a valid pointer to a VkClusterAccelerationStructureMoveObjectsInputNV structure", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureInputInfoNV-pNext-pNext", "pNext must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureInputInfoNV-pTriangleClusters-parameter", "If opType is VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_TRIANGLE_CLUSTER_NV, VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_BUILD_TRIANGLE_CLUSTER_TEMPLATE_NV, VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_INSTANTIATE_TRIANGLE_CLUSTER_NV, or VK_CLUSTER_ACCELERATION_STRUCTURE_OP_TYPE_GET_CLUSTER_TEMPLATE_INDICES_NV, the pTriangleClusters member of opInput must be a valid pointer to a VkClusterAccelerationStructureTriangleClusterInputNV structure", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureInputInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_INPUT_INFO_NV", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureInstantiateClusterInfoNV-geometryIndexOffset-10510", "The maximum geometry index after using the value in geometryIndexOffset must be less than VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxClusterGeometryIndex", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureInstantiateClusterInfoNV-reserved-10509", "reserved must be 0", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureInstantiateClusterInfoNV-vertexBuffer-10507", "vertexBuffer must not be NULL if the template was built without vertex data", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureInstantiateClusterInfoNV-vertexBuffer-10508", "The format in vertexBuffer must match the original format specified in VkClusterAccelerationStructureTriangleClusterInputNV", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureMoveObjectsInfoNV-srcAccelerationStructure-10483", "srcAccelerationStructure must be a type of cluster acceleration structure", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureMoveObjectsInputNV-pNext-pNext", "pNext must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureMoveObjectsInputNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_MOVE_OBJECTS_INPUT_NV", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureMoveObjectsInputNV-type-parameter", "type must be a valid VkClusterAccelerationStructureTypeNV value", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureTriangleClusterInputNV-maxClusterTriangleCount-10440", "maxClusterTriangleCount must be less than or equal to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxTrianglesPerCluster", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureTriangleClusterInputNV-maxClusterVertexCount-10441", "maxClusterVertexCount must be less than or equal to VkPhysicalDeviceClusterAccelerationStructurePropertiesNV::maxVerticesPerCluster", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureTriangleClusterInputNV-minPositionTruncateBitCount-10442", "minPositionTruncateBitCount must be less than or equal to 32", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureTriangleClusterInputNV-pNext-pNext", "pNext must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureTriangleClusterInputNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_TRIANGLE_CLUSTER_INPUT_NV", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureTriangleClusterInputNV-vertexFormat-10439", "The format features of vertexFormat must contain VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR", "chapters/accelstructures.html"},
    {"VUID-VkClusterAccelerationStructureTriangleClusterInputNV-vertexFormat-parameter", "vertexFormat must be a valid VkFormat value", "chapters/accelstructures.html"},
    {"VUID-VkCoarseSampleLocationNV-pixelX-02078", "pixelX must be less than the width (in pixels) of the fragment", "chapters/primsrast.html"},
    {"VUID-VkCoarseSampleLocationNV-pixelY-02079", "pixelY must be less than the height (in pixels) of the fragment", "chapters/primsrast.html"},
    {"VUID-VkCoarseSampleLocationNV-sample-02080", "sample must be less than the number of coverage samples in each pixel belonging to the fragment", "chapters/primsrast.html"},
    {"VUID-VkCoarseSampleOrderCustomNV-pSampleLocations-02077", "The array pSampleLocations must contain exactly one entry for every combination of valid values for pixelX, pixelY, and sample in the structure VkCoarseSampleOrderCustomNV", "chapters/primsrast.html"},
    {"VUID-VkCoarseSampleOrderCustomNV-pSampleLocations-parameter", "pSampleLocations must be a valid pointer to an array of sampleLocationCount VkCoarseSampleLocationNV structures", "chapters/primsrast.html"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleCount-02074", "sampleCount must correspond to a sample count enumerated in VkSampleCountFlags whose corresponding bit is set in VkPhysicalDeviceLimits::framebufferNoAttachmentsSampleCounts", "chapters/primsrast.html"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-02075", "sampleLocationCount must be equal to the product of sampleCount, the fragment width for shadingRate, and the fragment height for shadingRate", "chapters/primsrast.html"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-02076", "sampleLocationCount must be less than or equal to the value of VkPhysicalDeviceShadingRateImagePropertiesNV::shadingRateMaxCoarseSamples", "chapters/primsrast.html"},
    {"VUID-VkCoarseSampleOrderCustomNV-sampleLocationCount-arraylength", "sampleLocationCount must be greater than 0", "chapters/primsrast.html"},
    {"VUID-VkCoarseSampleOrderCustomNV-shadingRate-02073", "shadingRate must be a shading rate that generates fragments with more than one pixel", "chapters/primsrast.html"},
    {"VUID-VkCoarseSampleOrderCustomNV-shadingRate-parameter", "shadingRate must be a valid VkShadingRatePaletteEntryNV value", "chapters/primsrast.html"},
    {"VUID-VkColorBlendAdvancedEXT-advancedBlendOp-parameter", "advancedBlendOp must be a valid VkBlendOp value", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendAdvancedEXT-blendOverlap-07507", "If the correlated overlap property is not supported, blendOverlap must be VK_BLEND_OVERLAP_UNCORRELATED_EXT", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendAdvancedEXT-blendOverlap-parameter", "blendOverlap must be a valid VkBlendOverlapEXT value", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendAdvancedEXT-dstPremultiplied-07506", "If the non-premultiplied destination color property is not supported, dstPremultiplied must be VK_TRUE", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendAdvancedEXT-srcPremultiplied-07505", "If the non-premultiplied source color property is not supported, srcPremultiplied must be VK_TRUE", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendEquationEXT-alphaBlendOp-parameter", "alphaBlendOp must be a valid VkBlendOp value", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendEquationEXT-colorBlendOp-07361", "colorBlendOp and alphaBlendOp must not be a VkBlendOp from VK_EXT_blend_operation_advanced", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendEquationEXT-colorBlendOp-parameter", "colorBlendOp must be a valid VkBlendOp value", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendEquationEXT-constantAlphaColorBlendFactors-07362", "If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::constantAlphaColorBlendFactors is VK_FALSE, srcColorBlendFactor must not be VK_BLEND_FACTOR_CONSTANT_ALPHA or VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendEquationEXT-constantAlphaColorBlendFactors-07363", "If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::constantAlphaColorBlendFactors is VK_FALSE, dstColorBlendFactor must not be VK_BLEND_FACTOR_CONSTANT_ALPHA or VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendEquationEXT-dstAlphaBlendFactor-parameter", "dstAlphaBlendFactor must be a valid VkBlendFactor value", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendEquationEXT-dstColorBlendFactor-parameter", "dstColorBlendFactor must be a valid VkBlendFactor value", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendEquationEXT-dualSrcBlend-07357", "If the dualSrcBlend feature is not enabled, srcColorBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendEquationEXT-dualSrcBlend-07358", "If the dualSrcBlend feature is not enabled, dstColorBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendEquationEXT-dualSrcBlend-07359", "If the dualSrcBlend feature is not enabled, srcAlphaBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendEquationEXT-dualSrcBlend-07360", "If the dualSrcBlend feature is not enabled, dstAlphaBlendFactor must not be VK_BLEND_FACTOR_SRC1_COLOR, VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR, VK_BLEND_FACTOR_SRC1_ALPHA, or VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendEquationEXT-srcAlphaBlendFactor-parameter", "srcAlphaBlendFactor must be a valid VkBlendFactor value", "chapters/framebuffer.html"},
    {"VUID-VkColorBlendEquationEXT-srcColorBlendFactor-parameter", "srcColorBlendFactor must be a valid VkBlendFactor value", "chapters/framebuffer.html"},
    {"VUID-VkCommandBufferAllocateInfo-commandPool-parameter", "commandPool must be a valid VkCommandPool handle", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferAllocateInfo-level-parameter", "level must be a valid VkCommandBufferLevel value", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferAllocateInfo-pNext-pNext", "pNext must be NULL", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferBeginInfo-flags-00055", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the framebuffer member of pInheritanceInfo must be either VK_NULL_HANDLE, or a valid VkFramebuffer that is compatible with the renderPass member of pInheritanceInfo", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferBeginInfo-flags-06000", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the renderPass member of pInheritanceInfo is not VK_NULL_HANDLE, the renderPass member of pInheritanceInfo must be a valid VkRenderPass", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferBeginInfo-flags-06001", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the renderPass member of pInheritanceInfo is not VK_NULL_HANDLE, the subpass member of pInheritanceInfo must be a valid subpass index within the renderPass member of pInheritanceInfo", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferBeginInfo-flags-06002", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the renderPass member of pInheritanceInfo is VK_NULL_HANDLE, the pNext chain of pInheritanceInfo must include a VkCommandBufferInheritanceRenderingInfo structure", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferBeginInfo-flags-06003", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the renderPass member of pInheritanceInfo is VK_NULL_HANDLE, and the pNext chain of pInheritanceInfo includes a VkAttachmentSampleCountInfoAMD or VkAttachmentSampleCountInfoNV structure, the colorAttachmentCount member of that structure must be equal to the value of VkCommandBufferInheritanceRenderingInfo::colorAttachmentCount", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferBeginInfo-flags-09123", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT, the VkCommandPool that commandBuffer was allocated from must support graphics operations", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferBeginInfo-flags-09240", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT and the dynamicRendering feature is not enabled, the renderPass member of pInheritanceInfo must not be VK_NULL_HANDLE", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferBeginInfo-flags-10617", "If flags contains VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT , the renderPass member of pInheritanceInfo is not VK_NULL_HANDLE, and renderPass was created with tile shading enabled, VK_TILE_SHADING_RENDER_PASS_ENABLE_BIT_QCOM must be included in VkRenderPassTileShadingCreateInfoQCOM::flags", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferBeginInfo-flags-10618", "If flags does not contain VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT , the renderPass member of pInheritanceInfo is VK_NULL_HANDLE, or renderPass was not created with tile shading enabled, VK_TILE_SHADING_RENDER_PASS_ENABLE_BIT_QCOM must not be included in VkRenderPassTileShadingCreateInfoQCOM::flags", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferBeginInfo-flags-10619", "If VK_TILE_SHADING_RENDER_PASS_ENABLE_BIT_QCOM is included in VkRenderPassTileShadingCreateInfoQCOM::flags, VkRenderPassTileShadingCreateInfoQCOM::tileApronSize must be equal to the tileApronSize used to create renderPass", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferBeginInfo-flags-parameter", "flags must be a valid combination of VkCommandBufferUsageFlagBits values", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferBeginInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDeviceGroupCommandBufferBeginInfo", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferBeginInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceConditionalRenderingInfoEXT-conditionalRenderingEnable-01977", "If the inheritedConditionalRendering feature is not enabled, conditionalRenderingEnable must be VK_FALSE", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceConditionalRenderingInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceInfo-commonparent", "Both of framebuffer, and renderPass that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceInfo-occlusionQueryEnable-00056", "If the inheritedQueries feature is not enabled, occlusionQueryEnable must be VK_FALSE", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAttachmentSampleCountInfoAMD, VkCommandBufferInheritanceConditionalRenderingInfoEXT, VkCommandBufferInheritanceRenderPassTransformInfoQCOM, VkCommandBufferInheritanceRenderingInfo, VkCommandBufferInheritanceViewportScissorInfoNV, VkExternalFormatANDROID, VkMultiviewPerViewAttributesInfoNVX, VkRenderPassTileShadingCreateInfoQCOM, VkRenderingAttachmentLocationInfo, VkRenderingInputAttachmentIndexInfo, or VkTileMemoryBindInfoQCOM", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceInfo-pipelineStatistics-00058", "If the pipelineStatisticsQuery feature is not enabled, pipelineStatistics must be 0", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceInfo-pipelineStatistics-02789", "If the pipelineStatisticsQuery feature is enabled, pipelineStatistics must be a valid combination of VkQueryPipelineStatisticFlagBits values", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceInfo-queryFlags-00057", "If the inheritedQueries feature is enabled, queryFlags must be a valid combination of VkQueryControlFlagBits values", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceInfo-queryFlags-02788", "If the inheritedQueries feature is not enabled, queryFlags must be 0", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderPassTransformInfoQCOM-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderPassTransformInfoQCOM-transform-02864", "transform must be VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-colorAttachmentCount-06004", "If colorAttachmentCount is not 0, rasterizationSamples must be a valid VkSampleCountFlagBits value", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-depthAttachmentFormat-06007", "If depthAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-depthAttachmentFormat-06200", "If depthAttachmentFormat is not VK_FORMAT_UNDEFINED and stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, depthAttachmentFormat must equal stencilAttachmentFormat", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-depthAttachmentFormat-06540", "If depthAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format that includes a depth component", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-depthAttachmentFormat-parameter", "depthAttachmentFormat must be a valid VkFormat value", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-flags-parameter", "flags must be a valid combination of VkRenderingFlagBits values", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-multiview-06008", "If the multiview feature is not enabled, viewMask must be 0", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-pColorAttachmentFormats-06492", "If any element of pColorAttachmentFormats is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT , or VK_FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV if the linearColorAttachment feature is enabled", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-pColorAttachmentFormats-parameter", "If colorAttachmentCount is not 0, pColorAttachmentFormats must be a valid pointer to an array of colorAttachmentCount valid VkFormat values", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-rasterizationSamples-parameter", "If rasterizationSamples is not 0, rasterizationSamples must be a valid VkSampleCountFlagBits value", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-stencilAttachmentFormat-06199", "If stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-stencilAttachmentFormat-06541", "If stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format that includes a stencil aspect", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-stencilAttachmentFormat-parameter", "stencilAttachmentFormat must be a valid VkFormat value", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-variableMultisampleRate-06005", "If the variableMultisampleRate feature is not enabled, rasterizationSamples must be a valid VkSampleCountFlagBits value", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceRenderingInfo-viewMask-06009", "The index of the most significant bit in viewMask must be less than maxMultiviewViewCount", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04782", "If the inheritedViewportScissor2D feature is not enabled, viewportScissor2D must be VK_FALSE", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04783", "If the multiViewport feature is not enabled and viewportScissor2D is VK_TRUE, then viewportDepthCount must be 1", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04784", "If viewportScissor2D is VK_TRUE, then viewportDepthCount must be greater than 0", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04785", "If viewportScissor2D is VK_TRUE, then pViewportDepths must be a valid pointer to an array of viewportDepthCount valid VkViewport structures, except any requirements on x, y, width, and height do not apply", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferInheritanceViewportScissorInfoNV-viewportScissor2D-04786", "If viewportScissor2D is VK_TRUE, then the command buffer must be recorded with the VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferSubmitInfo-commandBuffer-03890", "commandBuffer must not have been allocated with VK_COMMAND_BUFFER_LEVEL_SECONDARY", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferSubmitInfo-commandBuffer-09445", "If any render pass instance in commandBuffer was recorded with a VkRenderPassStripeBeginInfoARM structure in its pNext chain and did not specify the VK_RENDERING_RESUMING_BIT flag, a VkRenderPassStripeSubmitInfoARM must be included in the pNext chain", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferSubmitInfo-commandBuffer-parameter", "commandBuffer must be a valid VkCommandBuffer handle", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferSubmitInfo-deviceMask-03891", "If deviceMask is not 0, it must be a valid device mask", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferSubmitInfo-pNext-09446", "If a VkRenderPassStripeSubmitInfoARM is included in the pNext chain, the value of VkRenderPassStripeSubmitInfoARM::stripeSemaphoreInfoCount must be equal to the sum of the VkRenderPassStripeBeginInfoARM::stripeInfoCount parameters provided to render pass instances recorded in commandBuffer that did not specify the VK_RENDERING_RESUMING_BIT flag", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferSubmitInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkRenderPassStripeSubmitInfoARM", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferSubmitInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandBufferSubmitInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandPoolCreateInfo-flags-02860", "If the protectedMemory feature is not enabled, the VK_COMMAND_POOL_CREATE_PROTECTED_BIT bit of flags must not be set", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandPoolCreateInfo-flags-parameter", "flags must be a valid combination of VkCommandPoolCreateFlagBits values", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandPoolCreateInfo-pNext-09908", "If the pNext chain includes a VkDataGraphProcessingEngineCreateInfoARM structure, then queueFamilyIndex must designate a queue family that supports VK_QUEUE_DATA_GRAPH_BIT_ARM", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandPoolCreateInfo-pNext-09909", "If the pNext chain includes a VkDataGraphProcessingEngineCreateInfoARM structure, then the queue family designated by queueFamilyIndex must support the data graph processing engines specified in the VkDataGraphProcessingEngineCreateInfoARM structure", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandPoolCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDataGraphProcessingEngineCreateInfoARM", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandPoolCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO", "chapters/cmdbuffers.html"},
    {"VUID-VkCommandPoolCreateInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/cmdbuffers.html"},
    {"VUID-VkComponentMapping-a-parameter", "a must be a valid VkComponentSwizzle value", "chapters/resources.html"},
    {"VUID-VkComponentMapping-b-parameter", "b must be a valid VkComponentSwizzle value", "chapters/resources.html"},
    {"VUID-VkComponentMapping-g-parameter", "g must be a valid VkComponentSwizzle value", "chapters/resources.html"},
    {"VUID-VkComponentMapping-r-parameter", "r must be a valid VkComponentSwizzle value", "chapters/resources.html"},
    {"VUID-VkComputePipelineCreateInfo-None-09497", "If the pNext chain does not include a VkPipelineCreateFlags2CreateInfo structure, flags must be a valid combination of VkPipelineCreateFlagBits values", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-None-10391", "If a resource variables is declared in a shader as an array of descriptors, then the descriptor type of that variable must not be VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-commonparent", "Both of basePipelineHandle, and layout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-03365", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-03366", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-03367", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-03368", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-03369", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-03370", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-03576", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-04945", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-07367", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-07984", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid compute VkPipeline handle", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-07985", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-07986", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, basePipelineIndex must be -1 or basePipelineHandle must be VK_NULL_HANDLE", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-07996", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-09007", "If the VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputePipelines feature is not enabled, flags must not include VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-09008", "If flags includes VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then the pNext chain must include a pointer to a valid instance of VkComputePipelineIndirectBufferInfoNV specifying the address where the pipeline's metadata will be saved", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-09178", "If flags does not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, the shader specified by stage must not declare the ShaderEnqueueAMDX capability", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-flags-11007", "If flags includes VK_PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_EXT, then the VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT::deviceGeneratedCommands feature must be enabled", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-layout-01687", "The number of resources in layout accessible to the compute shader stage must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-layout-07987", "If a push constant block is declared in a shader, a push constant range in layout must match the shader stage", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-layout-07988", "If a resource variable is declared in a shader, the corresponding descriptor set in layout must match the shader stage", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-layout-07990", "If a resource variable is declared in a shader, and the descriptor type is not VK_DESCRIPTOR_TYPE_MUTABLE_EXT, the corresponding descriptor set in layout must match the descriptor type", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-layout-07991", "If a resource variable is declared in a shader as an array, the corresponding descriptor set in layout must match the descriptor count", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-layout-10069", "If a push constant block is declared in a shader, the block must be contained inside the push constant range in layout that matches the stage", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-layout-parameter", "layout must be a valid VkPipelineLayout handle", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkComputePipelineIndirectBufferInfoNV, VkPipelineBinaryInfoKHR, VkPipelineCompilerControlCreateInfoAMD, VkPipelineCreateFlags2CreateInfo, VkPipelineCreationFeedbackCreateInfo, VkPipelineRobustnessCreateInfo, or VkSubpassShadingPipelineCreateInfoHUAWEI", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-pipelineCreationCacheControl-02875", "If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT or VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-pipelineStageCreationFeedbackCount-06566", "If VkPipelineCreationFeedbackCreateInfo::pipelineStageCreationFeedbackCount is not 0, it must be 1", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-shaderEnqueue-09177", "If the shaderEnqueue feature is not enabled, flags must not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-stage-00701", "The stage member of stage must be VK_SHADER_STAGE_COMPUTE_BIT", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-stage-00702", "The shader code for the entry point identified by stage and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineCreateInfo-stage-parameter", "stage must be a valid VkPipelineShaderStageCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-deviceAddress-09011", "deviceAddress must be aligned to the VkMemoryRequirements2::memoryRequirements.alignment, as returned by vkGetPipelineIndirectMemoryRequirementsNV", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-deviceAddress-09012", "deviceAddress must have been allocated from a buffer that was created with usage VK_BUFFER_USAGE_TRANSFER_DST_BIT and VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-deviceGeneratedComputePipelines-09009", "The VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputePipelines feature must be enabled", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-flags-09010", "The pipeline creation flags in VkComputePipelineCreateInfo::flags must include VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-pipelineDeviceAddressCaptureReplay-09014", "If pipelineDeviceAddressCaptureReplay is non-zero then the VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputeCaptureReplay feature must be enabled", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-pipelineDeviceAddressCaptureReplay-09015", "If pipelineDeviceAddressCaptureReplay is non-zero then that address must have been allocated with flag VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT set", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-pipelineDeviceAddressCaptureReplay-09016", "If pipelineDeviceAddressCaptureReplay is non-zero, the pipeline must have been recreated for replay", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-pipelineDeviceAddressCaptureReplay-09017", "pipelineDeviceAddressCaptureReplay must satisfy the alignment and size requirements similar to deviceAddress", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_INDIRECT_BUFFER_INFO_NV", "chapters/pipelines.html"},
    {"VUID-VkComputePipelineIndirectBufferInfoNV-size-09013", "size must be greater than or equal to the VkMemoryRequirements2::memoryRequirements.size, as returned by vkGetPipelineIndirectMemoryRequirementsNV", "chapters/pipelines.html"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-01981", "If buffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/drawing.html"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-01982", "buffer must have been created with the VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT bit set", "chapters/drawing.html"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-buffer-parameter", "buffer must be a valid VkBuffer handle", "chapters/drawing.html"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-flags-parameter", "flags must be a valid combination of VkConditionalRenderingFlagBitsEXT values", "chapters/drawing.html"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-offset-01983", "offset must be less than the size of buffer by at least 32 bits", "chapters/drawing.html"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-offset-01984", "offset must be a multiple of 4", "chapters/drawing.html"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/drawing.html"},
    {"VUID-VkConditionalRenderingBeginInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT", "chapters/drawing.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-dstComponentType-10080", "If dstComponentType is not a supported VkCooperativeVectorPropertiesNV::matrixInterpretation value as reported by vkGetPhysicalDeviceCooperativeVectorPropertiesNV, then dstComponentType must be VK_COMPONENT_TYPE_FLOAT32_KHR", "chapters/shaders.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-dstComponentType-10082", "If dstComponentType is VK_COMPONENT_TYPE_FLOAT_E4M3_NV or VK_COMPONENT_TYPE_FLOAT_E5M2_NV, then dstLayout must be VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_INFERENCING_OPTIMAL_NV or VK_COOPERATIVE_VECTOR_MATRIX_LAYOUT_TRAINING_OPTIMAL_NV", "chapters/shaders.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-dstComponentType-parameter", "dstComponentType must be a valid VkComponentTypeKHR value", "chapters/shaders.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-dstData-parameter", "dstData must be a valid VkDeviceOrHostAddressKHR union", "chapters/shaders.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-dstLayout-10078", "If dstLayout is row-major or column-major, then dstStride must be greater than the length of a row/column, and a multiple of the element size", "chapters/shaders.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-dstLayout-parameter", "dstLayout must be a valid VkCooperativeVectorMatrixLayoutNV value", "chapters/shaders.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-pDstSize-parameter", "pDstSize must be a valid pointer to a size_t value", "chapters/shaders.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-pNext-pNext", "pNext must be NULL", "chapters/shaders.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CONVERT_COOPERATIVE_VECTOR_MATRIX_INFO_NV", "chapters/shaders.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-srcComponentType-10079", "If srcComponentType is not a supported VkCooperativeVectorPropertiesNV::matrixInterpretation value as reported by vkGetPhysicalDeviceCooperativeVectorPropertiesNV, then srcComponentType must be VK_COMPONENT_TYPE_FLOAT32_KHR", "chapters/shaders.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-srcComponentType-10081", "If srcComponentType and dstComponentType are not equal, then one must be VK_COMPONENT_TYPE_FLOAT32_KHR or VK_COMPONENT_TYPE_FLOAT16_KHR and the other must be a lower-precision floating-point type", "chapters/shaders.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-srcComponentType-parameter", "srcComponentType must be a valid VkComponentTypeKHR value", "chapters/shaders.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-srcData-parameter", "srcData must be a valid VkDeviceOrHostAddressConstKHR union", "chapters/shaders.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-srcLayout-10077", "If srcLayout is row-major or column-major, then srcStride must be greater than the length of a row/column, and a multiple of the element size", "chapters/shaders.html"},
    {"VUID-VkConvertCooperativeVectorMatrixInfoNV-srcLayout-parameter", "srcLayout must be a valid VkCooperativeVectorMatrixLayoutNV value", "chapters/shaders.html"},
    {"VUID-VkCooperativeMatrixFlexibleDimensionsPropertiesNV-pNext-pNext", "pNext must be NULL", "chapters/shaders.html"},
    {"VUID-VkCooperativeMatrixFlexibleDimensionsPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_FLEXIBLE_DIMENSIONS_PROPERTIES_NV", "chapters/shaders.html"},
    {"VUID-VkCooperativeMatrixPropertiesKHR-pNext-pNext", "pNext must be NULL", "chapters/shaders.html"},
    {"VUID-VkCooperativeMatrixPropertiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_KHR", "chapters/shaders.html"},
    {"VUID-VkCooperativeMatrixPropertiesNV-pNext-pNext", "pNext must be NULL", "chapters/shaders.html"},
    {"VUID-VkCooperativeMatrixPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV", "chapters/shaders.html"},
    {"VUID-VkCooperativeVectorPropertiesNV-biasInterpretation-parameter", "biasInterpretation must be a valid VkComponentTypeKHR value", "chapters/shaders.html"},
    {"VUID-VkCooperativeVectorPropertiesNV-inputInterpretation-parameter", "inputInterpretation must be a valid VkComponentTypeKHR value", "chapters/shaders.html"},
    {"VUID-VkCooperativeVectorPropertiesNV-inputType-parameter", "inputType must be a valid VkComponentTypeKHR value", "chapters/shaders.html"},
    {"VUID-VkCooperativeVectorPropertiesNV-matrixInterpretation-parameter", "matrixInterpretation must be a valid VkComponentTypeKHR value", "chapters/shaders.html"},
    {"VUID-VkCooperativeVectorPropertiesNV-pNext-pNext", "pNext must be NULL", "chapters/shaders.html"},
    {"VUID-VkCooperativeVectorPropertiesNV-resultType-parameter", "resultType must be a valid VkComponentTypeKHR value", "chapters/shaders.html"},
    {"VUID-VkCooperativeVectorPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_COOPERATIVE_VECTOR_PROPERTIES_NV", "chapters/shaders.html"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-buffer-03718", "The buffer used to create src must be bound to device memory", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-buffer-03719", "The buffer used to create dst must be bound to device memory", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-commonparent", "Both of dst, and src must have been created, allocated, or retrieved from the same VkDevice", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-dst-07791", "The range of memory backing dst that is accessed by this command must not overlap the memory backing src that is accessed by this command", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-dst-parameter", "dst must be a valid VkAccelerationStructureKHR handle", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-mode-03410", "mode must be VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR or VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-mode-parameter", "mode must be a valid VkCopyAccelerationStructureModeKHR value", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-src-03411", "If mode is VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR, src must have been constructed with VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR in the build", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-src-04963", "The source acceleration structure src must have been constructed prior to the execution of this command", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureInfoKHR-src-parameter", "src must be a valid VkAccelerationStructureKHR handle", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-dst-03561", "The memory pointed to by dst must be at least as large as the serialization size of src, as reported by vkWriteAccelerationStructuresPropertiesKHR or vkCmdWriteAccelerationStructuresPropertiesKHR with a query type of VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-mode-03412", "mode must be VK_COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-mode-parameter", "mode must be a valid VkCopyAccelerationStructureModeKHR value", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-src-04959", "The source acceleration structure src must have been constructed prior to the execution of this command", "chapters/accelstructures.html"},
    {"VUID-VkCopyAccelerationStructureToMemoryInfoKHR-src-parameter", "src must be a valid VkAccelerationStructureKHR handle", "chapters/accelstructures.html"},
    {"VUID-VkCopyBufferInfo2-commonparent", "Both of dstBuffer, and srcBuffer must have been created, allocated, or retrieved from the same VkDevice", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-dstBuffer-00120", "dstBuffer must have been created with VK_BUFFER_USAGE_TRANSFER_DST_BIT usage flag", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-dstBuffer-00121", "If dstBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-dstBuffer-parameter", "dstBuffer must be a valid VkBuffer handle", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-dstOffset-00114", "The dstOffset member of each element of pRegions must be less than the size of dstBuffer", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-pNext-pNext", "pNext must be NULL", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-pRegions-00117", "The union of the source regions, and the union of the destination regions, specified by the elements of pRegions, must not overlap in memory", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkBufferCopy2 structures", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-regionCount-arraylength", "regionCount must be greater than 0", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-size-00115", "The size member of each element of pRegions must be less than or equal to the size of srcBuffer minus srcOffset", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-size-00116", "The size member of each element of pRegions must be less than or equal to the size of dstBuffer minus dstOffset", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-srcBuffer-00118", "srcBuffer must have been created with VK_BUFFER_USAGE_TRANSFER_SRC_BIT usage flag", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-srcBuffer-00119", "If srcBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-srcBuffer-parameter", "srcBuffer must be a valid VkBuffer handle", "chapters/copies.html"},
    {"VUID-VkCopyBufferInfo2-srcOffset-00113", "The srcOffset member of each element of pRegions must be less than the size of srcBuffer", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-bufferImageHeight-09107", "For each element of pRegions, bufferImageHeight must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-bufferRowLength-09106", "For each element of pRegions, bufferRowLength must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-bufferRowLength-09108", "For each element of pRegions, bufferRowLength divided by the texel block extent width and then multiplied by the texel block size of dstImage must be less than or equal to 231-1", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-commonparent", "Both of dstImage, and srcBuffer must have been created, allocated, or retrieved from the same VkDevice", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-00177", "dstImage must have been created with VK_IMAGE_USAGE_TRANSFER_DST_BIT usage flag", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-00207", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of imageOffset.x and extent.width does not equal the width of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-00208", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of imageOffset.y and extent.height does not equal the height of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-00209", "For each element of pRegions, if the sum of imageOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-01997", "The format features of dstImage must contain VK_FORMAT_FEATURE_TRANSFER_DST_BIT", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07274", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07275", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07276", "For each element of pRegions, imageOffset.z must be a multiple of the texel block extent depth of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07966", "If dstImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07969", "dstImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07973", "dstImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07975", "If dstImage does not have either a depth/stencil format or a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the texel block size", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07976", "If dstImage has a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the element size of the compatible format for the format and the aspectMask of the imageSubresource as defined in Compatible Formats of Planes of Multi-Planar Formats", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07978", "If dstImage has a depth/stencil format, the bufferOffset member of any element of pRegions must be a multiple of 4", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07979", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, imageOffset.y must be 0 and imageExtent.height must be 1", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07980", "If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, imageOffset.z must be 0 and imageExtent.depth must be 1", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07981", "If dstImage has a multi-planar format, then for each element of pRegions, imageSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-07983", "If dstImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, imageSubresource.baseArrayLayer must be 0 and imageSubresource.layerCount must be 1", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImage-parameter", "dstImage must be a valid VkImage handle", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImageLayout-00180", "dstImageLayout must specify the layout of the image subresources of dstImage specified in pRegions at the time this command is executed on a VkDevice", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImageLayout-01396", "dstImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL, or VK_IMAGE_LAYOUT_GENERAL", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-dstImageLayout-parameter", "dstImageLayout must be a valid VkImageLayout value", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-09104", "For each element of pRegions, imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified imageSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10051", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and imageOffset.x does not equal the width of the subresource specified by imageSubresource, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10052", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and imageOffset.y does not equal the height of the subresource specified by imageSubresource, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10053", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of imageOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10054", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10055", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of imageOffset.x and extent.height does not equal the width of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10056", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of imageOffset.y and extent.width does not equal the height of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10057", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-imageOffset-10058", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of imageOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-imageSubresource-07967", "The imageSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-imageSubresource-07968", "If imageSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, imageSubresource.baseArrayLayer + imageSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-imageSubresource-09105", "For each element of pRegions, imageSubresource.aspectMask must specify aspects present in dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-pNext-pNext", "pNext must be NULL", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-pRegions-00171", "srcBuffer must be large enough to contain all buffer locations that are accessed according to Buffer and Image Addressing, for each element of pRegions", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-pRegions-00173", "The union of all source regions, and the union of all destination regions, specified by the elements of pRegions, must not overlap in memory", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-pRegions-04565", "The image region specified by each element of pRegions that does not contain VkCopyCommandTransformInfoQCOM in its pNext chain must be contained within the specified imageSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-pRegions-06223", "For each element of pRegions not containing VkCopyCommandTransformInfoQCOM in its pNext chain, imageOffset.x and (imageExtent.width + imageOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified imageSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-pRegions-06224", "For each element of pRegions not containing VkCopyCommandTransformInfoQCOM in its pNext chain, imageOffset.y and (imageExtent.height + imageOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified imageSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-pRegions-07931", "If VK_EXT_depth_range_unrestricted is not enabled, for each element of pRegions whose imageSubresource contains a depth aspect, the data in srcBuffer must be in the range [0,1]", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkBufferImageCopy2 structures", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-regionCount-arraylength", "regionCount must be greater than 0", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-srcBuffer-00174", "srcBuffer must have been created with VK_BUFFER_USAGE_TRANSFER_SRC_BIT usage flag", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-srcBuffer-00176", "If srcBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2-srcBuffer-parameter", "srcBuffer must be a valid VkBuffer handle", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-04554", "If the image region specified by each element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, the rotated destination region must be contained within dstImage", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-04555", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then dstImage must have a 1x1x1 texel block extent", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-06203", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then dstImage must be of type VK_IMAGE_TYPE_2D", "chapters/copies.html"},
    {"VUID-VkCopyBufferToImageInfo2KHR-pRegions-06204", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then dstImage must not have a multi-planar format", "chapters/copies.html"},
    {"VUID-VkCopyCommandTransformInfoQCOM-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM", "chapters/copies.html"},
    {"VUID-VkCopyCommandTransformInfoQCOM-transform-04560", "transform must be VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR", "chapters/copies.html"},
    {"VUID-VkCopyDescriptorSet-commonparent", "Both of dstSet, and srcSet must have been created, allocated, or retrieved from the same VkDevice", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-dstArrayElement-00348", "The sum of dstArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding specified by dstBinding, and all applicable consecutive bindings", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-dstBinding-00347", "dstBinding must be a valid binding within dstSet", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-dstBinding-02224", "If the descriptor type of the descriptor set binding specified by dstBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, dstArrayElement must be an integer multiple of 4", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-dstBinding-02632", "The type of dstBinding within dstSet must be equal to the type of srcBinding within srcSet", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-dstBinding-02753", "If the descriptor type of the descriptor set binding specified by dstBinding is VK_DESCRIPTOR_TYPE_SAMPLER, then dstSet must not have been allocated with a layout that included immutable samplers for dstBinding", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-dstSet-04612", "If VkDescriptorSetLayoutBinding for dstSet at dstBinding is VK_DESCRIPTOR_TYPE_MUTABLE_EXT, the new active descriptor type must exist in the corresponding pMutableDescriptorTypeLists list for dstBinding if the new active descriptor type is not VK_DESCRIPTOR_TYPE_MUTABLE_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-dstSet-04614", "If VkDescriptorSetLayoutBinding for dstSet at dstBinding is VK_DESCRIPTOR_TYPE_MUTABLE_EXT, and the new active descriptor type is VK_DESCRIPTOR_TYPE_MUTABLE_EXT, the pMutableDescriptorTypeLists for srcBinding and dstBinding must match exactly", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-dstSet-parameter", "dstSet must be a valid VkDescriptorSet handle", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-pNext-pNext", "pNext must be NULL", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-srcArrayElement-00346", "The sum of srcArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding specified by srcBinding, and all applicable consecutive bindings", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-srcBinding-00345", "srcBinding must be a valid binding within srcSet", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-srcBinding-02223", "If the descriptor type of the descriptor set binding specified by srcBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, srcArrayElement must be an integer multiple of 4", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-srcBinding-02225", "If the descriptor type of the descriptor set binding specified by either srcBinding or dstBinding is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, descriptorCount must be an integer multiple of 4", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-srcSet-00349", "If srcSet is equal to dstSet, then the source and destination ranges of descriptors must not overlap, where the ranges may include array elements from consecutive bindings", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-srcSet-01918", "If srcSet's layout was created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set, then dstSet's layout must also have been created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-srcSet-01920", "If the descriptor pool from which srcSet was allocated was created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set, then the descriptor pool from which dstSet was allocated must also have been created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-srcSet-04613", "If VkDescriptorSetLayoutBinding for srcSet at srcBinding is VK_DESCRIPTOR_TYPE_MUTABLE_EXT and the VkDescriptorSetLayoutBinding for dstSet at dstBinding is not VK_DESCRIPTOR_TYPE_MUTABLE_EXT, the active descriptor type for the source descriptor must match the descriptor type of dstBinding", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-srcSet-04885", "If srcSet's layout was created without either the VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT flag or the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set, then dstSet's layout must have been created without the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT flag set", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-srcSet-04887", "If the descriptor pool from which srcSet was allocated was created without either the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT flag or the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set, then the descriptor pool from which dstSet was allocated must have been created without the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set", "chapters/descriptorsets.html"},
    {"VUID-VkCopyDescriptorSet-srcSet-parameter", "srcSet must be a valid VkDescriptorSet handle", "chapters/descriptorsets.html"},
    {"VUID-VkCopyImageInfo2-None-01549", "In a copy to or from a plane of a multi-planar image, the VkFormat of the image and plane must be compatible according to the description of compatible planes for the plane being copied", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-apiVersion-07932", "If the VK_KHR_maintenance1 extension is not enabled, or VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, and either srcImage or dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer and dstSubresource.baseArrayLayer must both be 0, and srcSubresource.layerCount and dstSubresource.layerCount must both be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-apiVersion-07933", "If the VK_KHR_maintenance1 extension is not enabled, and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, srcImage and dstImage must have the same VkImageType", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-apiVersion-08969", "If the VK_KHR_maintenance1 extension is not enabled, and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, srcImage or dstImage is of type VK_IMAGE_TYPE_2D, then for each element of pRegions, extent.depth must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-aspect-06662", "If the aspect member of any element of pRegions includes any flag other than VK_IMAGE_ASPECT_STENCIL_BIT or srcImage was not created with separate stencil usage, VK_IMAGE_USAGE_TRANSFER_SRC_BIT must have been included in the VkImageCreateInfo::usage used to create srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-aspect-06663", "If the aspect member of any element of pRegions includes any flag other than VK_IMAGE_ASPECT_STENCIL_BIT or dstImage was not created with separate stencil usage, VK_IMAGE_USAGE_TRANSFER_DST_BIT must have been included in the VkImageCreateInfo::usage used to create dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-aspect-06664", "If the aspect member of any element of pRegions includes VK_IMAGE_ASPECT_STENCIL_BIT, and srcImage was created with separate stencil usage, VK_IMAGE_USAGE_TRANSFER_SRC_BIT must have been included in the VkImageStencilUsageCreateInfo::stencilUsage used to create srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-aspect-06665", "If the aspect member of any element of pRegions includes VK_IMAGE_ASPECT_STENCIL_BIT, and dstImage was created with separate stencil usage, VK_IMAGE_USAGE_TRANSFER_DST_BIT must have been included in the VkImageStencilUsageCreateInfo::stencilUsage used to create dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-aspectMask-00142", "For each element of pRegions, srcSubresource.aspectMask must specify aspects present in srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-aspectMask-00143", "For each element of pRegions, dstSubresource.aspectMask must specify aspects present in dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-commonparent", "Both of dstImage, and srcImage must have been created, allocated, or retrieved from the same VkDevice", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstImage-00152", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffset.y must be 0 and extent.height must be 1, where extent is adjusted for size-compatibility", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstImage-01557", "If dstImage has a multi-planar format and the srcImage does not have a multi-planar image format, then for each element of pRegions, srcSubresource.aspectMask must be VK_IMAGE_ASPECT_COLOR_BIT", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstImage-01786", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffset.z must be 0 and extent.depth must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstImage-01788", "If dstImage is of type VK_IMAGE_TYPE_2D, then for each element of pRegions, dstOffset.z must be 0", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstImage-01792", "If dstImage is of type VK_IMAGE_TYPE_2D, and srcImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, extent.depth must equal dstSubresource.layerCount", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstImage-01996", "The format features of dstImage must contain VK_FORMAT_FEATURE_TRANSFER_DST_BIT", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstImage-04444", "If dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, dstSubresource.baseArrayLayer must be 0 and dstSubresource.layerCount must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstImage-07966", "If dstImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstImage-07969", "dstImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstImage-08714", "If dstImage has a multi-planar format, then for each element of pRegions, dstSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstImage-parameter", "dstImage must be a valid VkImage handle", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstImageLayout-00133", "dstImageLayout must specify the layout of the image subresources of dstImage specified in pRegions at the time this command is executed on a VkDevice", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstImageLayout-01395", "dstImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL, or VK_IMAGE_LAYOUT_GENERAL", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstImageLayout-parameter", "dstImageLayout must be a valid VkImageLayout value", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstOffset-00150", "For each element of pRegions, dstOffset.x and (extent.width + dstOffset.x), where extent is adjusted for size-compatibility, must both be greater than or equal to 0 and less than or equal to the width of the specified dstSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstOffset-00151", "For each element of pRegions, dstOffset.y and (extent.height + dstOffset.y), where extent is adjusted for size-compatibility, must both be greater than or equal to 0 and less than or equal to the height of the specified dstSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstOffset-00153", "If dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, dstOffset.z and (extent.depth + dstOffset.z), where extent is adjusted for size-compatibility, must both be greater than or equal to 0 and less than or equal to the depth of the specified dstSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstOffset-01784", "The dstOffset and extent members of each element of pRegions must respect the image transfer granularity requirements of commandBuffer's command pool's queue family, as described in VkQueueFamilyProperties", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstSubresource-07967", "The dstSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstSubresource-07968", "If dstSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, dstSubresource.baseArrayLayer + dstSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-dstSubresource-10215", "If dstSubresource.aspectMask is VK_IMAGE_ASPECT_COLOR_BIT, then srSubresource.aspectMask must not contain both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-pNext-pNext", "pNext must be NULL", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-pRegions-00124", "The union of all source regions, and the union of all destination regions, specified by the elements of pRegions, must not overlap in memory", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-pRegions-07278", "For each element of pRegions, srcOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-pRegions-07279", "For each element of pRegions, srcOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-pRegions-07280", "For each element of pRegions, srcOffset.z must be a multiple of the texel block extent depth of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-pRegions-07281", "For each element of pRegions, dstOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-pRegions-07282", "For each element of pRegions, dstOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-pRegions-07283", "For each element of pRegions, dstOffset.z must be a multiple of the texel block extent depth of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkImageCopy2 structures", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-regionCount-arraylength", "regionCount must be greater than 0", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-00136", "The sample count of srcImage and dstImage must match", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-00146", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffset.y must be 0 and extent.height must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-01548", "If the VkFormat of each of srcImage and dstImage is not a multi-planar format, the VkFormat of each of srcImage and dstImage must be size-compatible", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-01551", "If neither srcImage nor dstImage has a multi-planar format and the maintenance8 feature is not enabled then for each element of pRegions, srcSubresource.aspectMask and dstSubresource.aspectMask must match", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-01556", "If srcImage has a multi-planar format and the dstImage does not have a multi-planar image format, then for each element of pRegions, dstSubresource.aspectMask must be VK_IMAGE_ASPECT_COLOR_BIT", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-01728", "For each element of pRegions, if the sum of srcOffset.x and extent.width does not equal the width of the subresource specified by srcSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-01729", "For each element of pRegions, if the sum of srcOffset.y and extent.height does not equal the height of the subresource specified by srcSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-01730", "For each element of pRegions, if the sum of srcOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-01785", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffset.z must be 0 and extent.depth must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-01787", "If srcImage is of type VK_IMAGE_TYPE_2D, then for each element of pRegions, srcOffset.z must be 0", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-01790", "If srcImage and dstImage are both of type VK_IMAGE_TYPE_2D, then for each element of pRegions, extent.depth must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-01791", "If srcImage is of type VK_IMAGE_TYPE_2D, and dstImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, extent.depth must equal srcSubresource.layerCount", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-01995", "The format features of srcImage must contain VK_FORMAT_FEATURE_TRANSFER_SRC_BIT", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-04443", "If srcImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcSubresource.baseArrayLayer must be 0 and srcSubresource.layerCount must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-07743", "If srcImage and dstImage have a different VkImageType, and the maintenance5 feature is not enabled, one must be VK_IMAGE_TYPE_3D and the other must be VK_IMAGE_TYPE_2D", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-07966", "If srcImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-07969", "srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-08713", "If srcImage has a multi-planar format, then for each element of pRegions, srcSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-08793", "If srcImage and dstImage have the same VkImageType, for each element of pRegions, if neither of the layerCount members of srcSubresource or dstSubresource are VK_REMAINING_ARRAY_LAYERS, the layerCount members of srcSubresource or dstSubresource must match", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-08794", "If srcImage and dstImage have the same VkImageType, and one of the layerCount members of srcSubresource or dstSubresource is VK_REMAINING_ARRAY_LAYERS, the other member must be either VK_REMAINING_ARRAY_LAYERS or equal to the arrayLayers member of the VkImageCreateInfo used to create the image minus baseArrayLayer", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-09247", "If the VkFormat of each of srcImage and dstImage is a compressed image format, the formats must have the same texel block extent", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-09460", "If srcImage and dstImage are the same, and any elements of pRegions contains the srcSubresource and dstSubresource with matching mipLevel and overlapping array layers, then the srcImageLayout and dstImageLayout must be VK_IMAGE_LAYOUT_GENERAL or VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImage-parameter", "srcImage must be a valid VkImage handle", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImageLayout-00128", "srcImageLayout must specify the layout of the image subresources of srcImage specified in pRegions at the time this command is executed on a VkDevice", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImageLayout-01917", "srcImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL, or VK_IMAGE_LAYOUT_GENERAL", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcImageLayout-parameter", "srcImageLayout must be a valid VkImageLayout value", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcOffset-00144", "For each element of pRegions, srcOffset.x and (extent.width + srcOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified srcSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcOffset-00145", "For each element of pRegions, srcOffset.y and (extent.height + srcOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified srcSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcOffset-00147", "If srcImage is of type VK_IMAGE_TYPE_3D, then for each element of pRegions, srcOffset.z and (extent.depth + srcOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified srcSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcOffset-01783", "The srcOffset and extent members of each element of pRegions must respect the image transfer granularity requirements of commandBuffer's command pool's queue family, as described in VkQueueFamilyProperties", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcSubresource-07967", "The srcSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcSubresource-07968", "If srcSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, srcSubresource.baseArrayLayer + srcSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcSubresource-10211", "If srcSubresource.aspectMask is VK_IMAGE_ASPECT_COLOR_BIT and dstSubresource.aspectMask is VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT, then the VkFormat values of srcImage and dstImage must be compatible according to the list of compatible depth-stencil and color formats", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcSubresource-10212", "If srcSubresource.aspectMask is VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT and dstSubresource.aspectMask is VK_IMAGE_ASPECT_COLOR_BIT, then the VkFormat values of srcImage and dstImage must be compatible according to the list of compatible depth-stencil and color formats", "chapters/copies.html"},
    {"VUID-VkCopyImageInfo2-srcSubresource-10214", "If srcSubresource.aspectMask is VK_IMAGE_ASPECT_COLOR_BIT, then dstSubresource.aspectMask must not contain both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-bufferImageHeight-09107", "For each element of pRegions, bufferImageHeight must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-bufferRowLength-09106", "For each element of pRegions, bufferRowLength must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-bufferRowLength-09108", "For each element of pRegions, bufferRowLength divided by the texel block extent width and then multiplied by the texel block size of srcImage must be less than or equal to 231-1", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-commonparent", "Both of dstBuffer, and srcImage must have been created, allocated, or retrieved from the same VkDevice", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-dstBuffer-00191", "dstBuffer must have been created with VK_BUFFER_USAGE_TRANSFER_DST_BIT usage flag", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-dstBuffer-00192", "If dstBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-dstBuffer-parameter", "dstBuffer must be a valid VkBuffer handle", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-00197", "For each element of pRegions not containing VkCopyCommandTransformInfoQCOM in its pNext chain, imageOffset.x and (imageExtent.width + imageOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified imageSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-00198", "For each element of pRegions not containing VkCopyCommandTransformInfoQCOM in its pNext chain, imageOffset.y and (imageExtent.height + imageOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified imageSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-09104", "For each element of pRegions, imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified imageSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10051", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and imageOffset.x does not equal the width of the subresource specified by imageSubresource, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10052", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and imageOffset.y does not equal the height of the subresource specified by imageSubresource, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10053", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of imageOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10054", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10055", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of imageOffset.x and extent.height does not equal the width of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10056", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of imageOffset.y and extent.width does not equal the height of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10057", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-imageOffset-10058", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of imageOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-imageSubresource-07967", "The imageSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-imageSubresource-07968", "If imageSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, imageSubresource.baseArrayLayer + imageSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-imageSubresource-09105", "For each element of pRegions, imageSubresource.aspectMask must specify aspects present in srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-pNext-pNext", "pNext must be NULL", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-pRegions-00183", "dstBuffer must be large enough to contain all buffer locations that are accessed according to Buffer and Image Addressing, for each element of pRegions", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-pRegions-00184", "The union of all source regions, and the union of all destination regions, specified by the elements of pRegions, must not overlap in memory", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-pRegions-04566", "The image region specified by each element of pRegions that does not contain VkCopyCommandTransformInfoQCOM in its pNext chain must be contained within the specified imageSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkBufferImageCopy2 structures", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-regionCount-arraylength", "regionCount must be greater than 0", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-00186", "srcImage must have been created with VK_IMAGE_USAGE_TRANSFER_SRC_BIT usage flag", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-00207", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of imageOffset.x and extent.width does not equal the width of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-00208", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of imageOffset.y and extent.height does not equal the height of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-00209", "For each element of pRegions, if the sum of imageOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-01998", "The format features of srcImage must contain VK_FORMAT_FEATURE_TRANSFER_SRC_BIT", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07274", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07275", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07276", "For each element of pRegions, imageOffset.z must be a multiple of the texel block extent depth of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07966", "If srcImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07969", "srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07973", "srcImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07975", "If srcImage does not have either a depth/stencil format or a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the texel block size", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07976", "If srcImage has a multi-planar format, then for each element of pRegions, bufferOffset must be a multiple of the element size of the compatible format for the format and the aspectMask of the imageSubresource as defined in Compatible Formats of Planes of Multi-Planar Formats", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07978", "If srcImage has a depth/stencil format, the bufferOffset member of any element of pRegions must be a multiple of 4", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07979", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, imageOffset.y must be 0 and imageExtent.height must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07980", "If srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, imageOffset.z must be 0 and imageExtent.depth must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07981", "If srcImage has a multi-planar format, then for each element of pRegions, imageSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-07983", "If srcImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, imageSubresource.baseArrayLayer must be 0 and imageSubresource.layerCount must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImage-parameter", "srcImage must be a valid VkImage handle", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImageLayout-00189", "srcImageLayout must specify the layout of the image subresources of srcImage specified in pRegions at the time this command is executed on a VkDevice", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImageLayout-01397", "srcImageLayout must be VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR, VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL, or VK_IMAGE_LAYOUT_GENERAL", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2-srcImageLayout-parameter", "srcImageLayout must be a valid VkImageLayout value", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-04557", "If the image region specified by each element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, the rotated source region must be contained within srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-04558", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must have a 1x1x1 texel block extent", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-06205", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must be of type VK_IMAGE_TYPE_2D", "chapters/copies.html"},
    {"VUID-VkCopyImageToBufferInfo2KHR-pRegions-06206", "If any element of pRegions contains VkCopyCommandTransformInfoQCOM in its pNext chain, then srcImage must not have a multi-planar format", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-commonparent", "Both of dstImage, and srcImage must have been created, allocated, or retrieved from the same VkDevice", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-00207", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of dstOffset.x and extent.width does not equal the width of the subresource specified by dstSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-00208", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of dstOffset.y and extent.height does not equal the height of the subresource specified by dstSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-00209", "For each element of pRegions, if the sum of dstOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-07274", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, dstOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-07275", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, dstOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-07276", "For each element of pRegions, dstOffset.z must be a multiple of the texel block extent depth of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-07966", "If dstImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-07969", "dstImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-07979", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, dstOffset.y must be 0 and extent.height must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-07980", "If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, dstOffset.z must be 0 and extent.depth must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-07981", "If dstImage has a multi-planar format, then for each element of pRegions, dstSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-07983", "If dstImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, dstSubresource.baseArrayLayer must be 0 and dstSubresource.layerCount must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-09109", "If dstImage is sparse then all memory ranges accessed by the copy command must be bound as described in Binding Resource Memory", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-09111", "If the stencil aspect of dstImage is accessed, and dstImage was not created with separate stencil usage, dstImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT set in VkImageCreateInfo::usage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-09112", "If the stencil aspect of dstImage is accessed, and dstImage was created with separate stencil usage, dstImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT set in VkImageStencilUsageCreateInfo::stencilUsage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-09113", "If non-stencil aspects of dstImage are accessed, dstImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT set in VkImageCreateInfo::usage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-09115", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the extent member of each element of pRegions must equal the extents of dstImage identified by dstSubresource", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImage-parameter", "dstImage must be a valid VkImage handle", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImageLayout-09071", "dstImageLayout must specify the current layout of the image subresources of dstImage specified in pRegions", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImageLayout-09073", "dstImageLayout must be one of the image layouts returned in VkPhysicalDeviceHostImageCopyProperties::pCopyDstLayouts", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstImageLayout-parameter", "dstImageLayout must be a valid VkImageLayout value", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstOffset-09104", "For each element of pRegions, dstOffset.z and (extent.depth + dstOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified dstSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstOffset-09114", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the x, y, and z members of the dstOffset member of each element of pRegions must be 0", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstOffset-10051", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and dstOffset.x does not equal the width of the subresource specified by dstSubresource, dstOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstOffset-10052", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and dstOffset.y does not equal the height of the subresource specified by dstSubresource, dstOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstOffset-10053", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of dstOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstOffset-10054", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of dstOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstOffset-10055", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of dstOffset.x and extent.height does not equal the width of the subresource specified by dstSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstOffset-10056", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of dstOffset.y and extent.width does not equal the height of the subresource specified by dstSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstOffset-10057", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of dstOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstOffset-10058", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of dstOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstSubresource-07967", "The dstSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstSubresource-07968", "If dstSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, dstSubresource.baseArrayLayer + dstSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstSubresource-07971", "For each element of pRegions, dstOffset.x and (extent.width + dstOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified dstSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstSubresource-07972", "For each element of pRegions, dstOffset.y and (extent.height + dstOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified dstSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-dstSubresource-09105", "For each element of pRegions, dstSubresource.aspectMask must specify aspects present in dstImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-flags-parameter", "flags must be a valid combination of VkHostImageCopyFlagBits values", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-pNext-pNext", "pNext must be NULL", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkImageCopy2 structures", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-regionCount-arraylength", "regionCount must be greater than 0", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-00207", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of srcOffset.x and extent.width does not equal the width of the subresource specified by srcSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-00208", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of srcOffset.y and extent.height does not equal the height of the subresource specified by srcSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-00209", "For each element of pRegions, if the sum of srcOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-07274", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, srcOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-07275", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, srcOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-07276", "For each element of pRegions, srcOffset.z must be a multiple of the texel block extent depth of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-07966", "If srcImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-07969", "srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-07979", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, srcOffset.y must be 0 and extent.height must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-07980", "If srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, srcOffset.z must be 0 and extent.depth must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-07981", "If srcImage has a multi-planar format, then for each element of pRegions, srcSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-07983", "If srcImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, srcSubresource.baseArrayLayer must be 0 and srcSubresource.layerCount must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-09069", "srcImage and dstImage must have been created with identical image creation parameters", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-09109", "If srcImage is sparse then all memory ranges accessed by the copy command must be bound as described in Binding Resource Memory", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-09111", "If the stencil aspect of srcImage is accessed, and srcImage was not created with separate stencil usage, srcImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT set in VkImageCreateInfo::usage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-09112", "If the stencil aspect of srcImage is accessed, and srcImage was created with separate stencil usage, srcImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT set in VkImageStencilUsageCreateInfo::stencilUsage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-09113", "If non-stencil aspects of srcImage are accessed, srcImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT set in VkImageCreateInfo::usage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-09115", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the extent member of each element of pRegions must equal the extents of srcImage identified by srcSubresource", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImage-parameter", "srcImage must be a valid VkImage handle", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImageLayout-09070", "srcImageLayout must specify the current layout of the image subresources of srcImage specified in pRegions", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImageLayout-09072", "srcImageLayout must be one of the image layouts returned in VkPhysicalDeviceHostImageCopyProperties::pCopySrcLayouts", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcImageLayout-parameter", "srcImageLayout must be a valid VkImageLayout value", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcOffset-09104", "For each element of pRegions, srcOffset.z and (extent.depth + srcOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified srcSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcOffset-09114", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the x, y, and z members of the srcOffset member of each element of pRegions must be 0", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcOffset-10051", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and srcOffset.x does not equal the width of the subresource specified by srcSubresource, srcOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcOffset-10052", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and srcOffset.y does not equal the height of the subresource specified by srcSubresource, srcOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcOffset-10053", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of srcOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcOffset-10054", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of srcOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcOffset-10055", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of srcOffset.x and extent.height does not equal the width of the subresource specified by srcSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcOffset-10056", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of srcOffset.y and extent.width does not equal the height of the subresource specified by srcSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcOffset-10057", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of srcOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcOffset-10058", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of srcOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcSubresource-07967", "The srcSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcSubresource-07968", "If srcSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, srcSubresource.baseArrayLayer + srcSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcSubresource-07971", "For each element of pRegions, srcOffset.x and (extent.width + srcOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified srcSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcSubresource-07972", "For each element of pRegions, srcOffset.y and (extent.height + srcOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified srcSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToImageInfo-srcSubresource-09105", "For each element of pRegions, srcSubresource.aspectMask must specify aspects present in srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-flags-09394", "If flags includes VK_HOST_IMAGE_COPY_MEMCPY_BIT, for each region in pRegions, memoryRowLength and memoryImageHeight must both be 0", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-flags-parameter", "flags must be a valid combination of VkHostImageCopyFlagBits values", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageOffset-09104", "For each element of pRegions, imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified imageSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageOffset-09114", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the x, y, and z members of the imageOffset member of each element of pRegions must be 0", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageOffset-10051", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and imageOffset.x does not equal the width of the subresource specified by imageSubresource, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageOffset-10052", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and imageOffset.y does not equal the height of the subresource specified by imageSubresource, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageOffset-10053", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of imageOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageOffset-10054", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageOffset-10055", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of imageOffset.x and extent.height does not equal the width of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageOffset-10056", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of imageOffset.y and extent.width does not equal the height of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageOffset-10057", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageOffset-10058", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of imageOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageSubresource-07967", "The imageSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when srcImage was created", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageSubresource-07968", "If imageSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, imageSubresource.baseArrayLayer + imageSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when srcImage was created", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageSubresource-07971", "For each element of pRegions, imageOffset.x and (imageExtent.width + imageOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified imageSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageSubresource-07972", "For each element of pRegions, imageOffset.y and (imageExtent.height + imageOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified imageSubresource of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-imageSubresource-09105", "For each element of pRegions, imageSubresource.aspectMask must specify aspects present in srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-memoryImageHeight-09107", "For each element of pRegions, memoryImageHeight must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-memoryRowLength-09106", "For each element of pRegions, memoryRowLength must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-memoryRowLength-09108", "For each element of pRegions, memoryRowLength divided by the texel block extent width and then multiplied by the texel block size of srcImage must be less than or equal to 231-1", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-pNext-pNext", "pNext must be NULL", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkImageToMemoryCopy structures", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-regionCount-arraylength", "regionCount must be greater than 0", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-00207", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of imageOffset.x and extent.width does not equal the width of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-00208", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of imageOffset.y and extent.height does not equal the height of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-00209", "For each element of pRegions, if the sum of imageOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-07274", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-07275", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-07276", "For each element of pRegions, imageOffset.z must be a multiple of the texel block extent depth of the VkFormat of srcImage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-07966", "If srcImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-07969", "srcImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-07973", "srcImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-07979", "If srcImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, imageOffset.y must be 0 and imageExtent.height must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-07980", "If srcImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, imageOffset.z must be 0 and imageExtent.depth must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-07981", "If srcImage has a multi-planar format, then for each element of pRegions, imageSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-07983", "If srcImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, imageSubresource.baseArrayLayer must be 0 and imageSubresource.layerCount must be 1", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-09109", "If srcImage is sparse then all memory ranges accessed by the copy command must be bound as described in Binding Resource Memory", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-09111", "If the stencil aspect of srcImage is accessed, and srcImage was not created with separate stencil usage, srcImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT set in VkImageCreateInfo::usage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-09112", "If the stencil aspect of srcImage is accessed, and srcImage was created with separate stencil usage, srcImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT set in VkImageStencilUsageCreateInfo::stencilUsage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-09113", "If non-stencil aspects of srcImage are accessed, srcImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT set in VkImageCreateInfo::usage", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-09115", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the imageExtent member of each element of pRegions must equal the extents of srcImage identified by imageSubresource", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImage-parameter", "srcImage must be a valid VkImage handle", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImageLayout-09064", "srcImageLayout must specify the current layout of the image subresources of srcImage specified in pRegions", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImageLayout-09065", "srcImageLayout must be one of the image layouts returned in VkPhysicalDeviceHostImageCopyProperties::pCopySrcLayouts", "chapters/copies.html"},
    {"VUID-VkCopyImageToMemoryInfo-srcImageLayout-parameter", "srcImageLayout must be a valid VkImageLayout value", "chapters/copies.html"},
    {"VUID-VkCopyMemoryIndirectCommandNV-dstAddress-07658", "The dstAddress must be 4 byte aligned", "chapters/copies.html"},
    {"VUID-VkCopyMemoryIndirectCommandNV-size-07659", "The size must be 4 byte aligned", "chapters/copies.html"},
    {"VUID-VkCopyMemoryIndirectCommandNV-srcAddress-07657", "The srcAddress must be 4 byte aligned", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-dst-03746", "dst must have been created with a size greater than or equal to that used to serialize the data in src", "chapters/accelstructures.html"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-dst-parameter", "dst must be a valid VkAccelerationStructureKHR handle", "chapters/accelstructures.html"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-mode-03413", "mode must be VK_COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR", "chapters/accelstructures.html"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-mode-parameter", "mode must be a valid VkCopyAccelerationStructureModeKHR value", "chapters/accelstructures.html"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-pInfo-03414", "The data in src must have a format compatible with the destination physical device as returned by vkGetDeviceAccelerationStructureCompatibilityKHR", "chapters/accelstructures.html"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/accelstructures.html"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR", "chapters/accelstructures.html"},
    {"VUID-VkCopyMemoryToAccelerationStructureInfoKHR-src-04960", "The source memory pointed to by src must contain data previously serialized using vkCmdCopyAccelerationStructureToMemoryKHR, potentially modified to relocate acceleration structure references as described in that command", "chapters/accelstructures.html"},
    {"VUID-VkCopyMemoryToImageIndirectCommandNV-bufferImageHeight-07680", "bufferImageHeight must be 0, or greater than or equal to the height member of imageExtent", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageIndirectCommandNV-bufferRowLength-07679", "bufferRowLength must be 0, or greater than or equal to the width member of imageExtent", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageIndirectCommandNV-imageExtent-07682", "imageExtent must specify a valid region in the destination image and can be 0", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageIndirectCommandNV-imageOffset-07681", "imageOffset must specify a valid offset in the destination image", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageIndirectCommandNV-imageSubresource-parameter", "imageSubresource must be a valid VkImageSubresourceLayers structure", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageIndirectCommandNV-srcAddress-07678", "The srcAddress must be 4 byte aligned", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-00207", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, the sum of imageOffset.x and extent.width does not equal the width of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-00208", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR, and the sum of imageOffset.y and extent.height does not equal the height of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-00209", "For each element of pRegions, if the sum of imageOffset.z and extent.depth does not equal the depth of the subresource specified by srcSubresource, extent.depth must be a multiple of the texel block extent depth of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-07274", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-07275", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-07276", "For each element of pRegions, imageOffset.z must be a multiple of the texel block extent depth of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-07966", "If dstImage is non-sparse then the image or the specified disjoint plane must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-07969", "dstImage must not have been created with flags containing VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-07973", "dstImage must have a sample count equal to VK_SAMPLE_COUNT_1_BIT", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-07979", "If dstImage is of type VK_IMAGE_TYPE_1D, then for each element of pRegions, imageOffset.y must be 0 and imageExtent.height must be 1", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-07980", "If dstImage is of type VK_IMAGE_TYPE_1D or VK_IMAGE_TYPE_2D, then for each element of pRegions, imageOffset.z must be 0 and imageExtent.depth must be 1", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-07981", "If dstImage has a multi-planar format, then for each element of pRegions, imageSubresource.aspectMask must be a single valid multi-planar aspect mask bit", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-07983", "If dstImage is of type VK_IMAGE_TYPE_3D, for each element of pRegions, imageSubresource.baseArrayLayer must be 0 and imageSubresource.layerCount must be 1", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-09109", "If dstImage is sparse then all memory ranges accessed by the copy command must be bound as described in Binding Resource Memory", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-09111", "If the stencil aspect of dstImage is accessed, and dstImage was not created with separate stencil usage, dstImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT set in VkImageCreateInfo::usage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-09112", "If the stencil aspect of dstImage is accessed, and dstImage was created with separate stencil usage, dstImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT set in VkImageStencilUsageCreateInfo::stencilUsage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-09113", "If non-stencil aspects of dstImage are accessed, dstImage must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT set in VkImageCreateInfo::usage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-09115", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the imageExtent member of each element of pRegions must equal the extents of dstImage identified by imageSubresource", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImage-parameter", "dstImage must be a valid VkImage handle", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImageLayout-09059", "dstImageLayout must specify the current layout of the image subresources of dstImage specified in pRegions", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImageLayout-09060", "dstImageLayout must be one of the image layouts returned in VkPhysicalDeviceHostImageCopyProperties::pCopyDstLayouts", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-dstImageLayout-parameter", "dstImageLayout must be a valid VkImageLayout value", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-flags-09393", "If flags includes VK_HOST_IMAGE_COPY_MEMCPY_BIT, for each region in pRegions, memoryRowLength and memoryImageHeight must both be 0", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-flags-parameter", "flags must be a valid combination of VkHostImageCopyFlagBits values", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageOffset-09104", "For each element of pRegions, imageOffset.z and (imageExtent.depth + imageOffset.z) must both be greater than or equal to 0 and less than or equal to the depth of the specified imageSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageOffset-09114", "If flags contains VK_HOST_IMAGE_COPY_MEMCPY_BIT, the x, y, and z members of the imageOffset member of each element of pRegions must be 0", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageOffset-10051", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, and imageOffset.x does not equal the width of the subresource specified by imageSubresource, imageOffset.x must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageOffset-10052", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR or VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, and imageOffset.y does not equal the height of the subresource specified by imageSubresource, imageOffset.y must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageOffset-10053", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the difference of imageOffset.x and extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageOffset-10054", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.x and extent.width must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageOffset-10055", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the sum of imageOffset.x and extent.height does not equal the width of the subresource specified by imageSubresource, extent.height must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageOffset-10056", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR, the sum of imageOffset.y and extent.width does not equal the height of the subresource specified by imageSubresource, extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageOffset-10057", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR, the difference of imageOffset.y and extent.height must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageOffset-10058", "For each element of pRegions, if VkCopyCommandTransformInfoQCOM::transform is equal to VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR, the difference of imageOffset.y and extent.width must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageSubresource-07967", "The imageSubresource.mipLevel member of each element of pRegions must be less than the mipLevels specified in VkImageCreateInfo when dstImage was created", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageSubresource-07968", "If imageSubresource.layerCount is not VK_REMAINING_ARRAY_LAYERS, imageSubresource.baseArrayLayer + imageSubresource.layerCount of each element of pRegions must be less than or equal to the arrayLayers specified in VkImageCreateInfo when dstImage was created", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageSubresource-07971", "For each element of pRegions, imageOffset.x and (imageExtent.width + imageOffset.x) must both be greater than or equal to 0 and less than or equal to the width of the specified imageSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageSubresource-07972", "For each element of pRegions, imageOffset.y and (imageExtent.height + imageOffset.y) must both be greater than or equal to 0 and less than or equal to the height of the specified imageSubresource of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-imageSubresource-09105", "For each element of pRegions, imageSubresource.aspectMask must specify aspects present in dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-memoryImageHeight-09107", "For each element of pRegions, memoryImageHeight must be a multiple of the texel block extent height of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-memoryRowLength-09106", "For each element of pRegions, memoryRowLength must be a multiple of the texel block extent width of the VkFormat of dstImage", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-memoryRowLength-09108", "For each element of pRegions, memoryRowLength divided by the texel block extent width and then multiplied by the texel block size of dstImage must be less than or equal to 231-1", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-pNext-pNext", "pNext must be NULL", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkMemoryToImageCopy structures", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-regionCount-arraylength", "regionCount must be greater than 0", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToImageInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO", "chapters/copies.html"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-dst-07550", "dst must have been created with a size greater than or equal to that used to serialize the data in src", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-dst-parameter", "dst must be a valid VkMicromapEXT handle", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-mode-07548", "mode must be VK_COPY_MICROMAP_MODE_DESERIALIZE_EXT", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-mode-parameter", "mode must be a valid VkCopyMicromapModeEXT value", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_MEMORY_TO_MICROMAP_INFO_EXT", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-src-07547", "The source memory pointed to by src must contain data previously serialized using vkCmdCopyMicromapToMemoryEXT", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMemoryToMicromapInfoEXT-src-07549", "The data in src must have a format compatible with the destination physical device as returned by vkGetDeviceMicromapCompatibilityEXT", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapInfoEXT-buffer-07534", "The buffer used to create src must be bound to device memory", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapInfoEXT-buffer-07535", "The buffer used to create dst must be bound to device memory", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapInfoEXT-commonparent", "Both of dst, and src must have been created, allocated, or retrieved from the same VkDevice", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapInfoEXT-dst-parameter", "dst must be a valid VkMicromapEXT handle", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapInfoEXT-mode-07531", "mode must be VK_COPY_MICROMAP_MODE_COMPACT_EXT or VK_COPY_MICROMAP_MODE_CLONE_EXT", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapInfoEXT-mode-07533", "If mode is VK_COPY_MICROMAP_MODE_COMPACT_EXT, src must have been constructed with VK_BUILD_MICROMAP_ALLOW_COMPACTION_BIT_EXT in the build", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapInfoEXT-mode-parameter", "mode must be a valid VkCopyMicromapModeEXT value", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_MICROMAP_INFO_EXT", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapInfoEXT-src-07532", "The source acceleration structure src must have been constructed prior to the execution of this command", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapInfoEXT-src-parameter", "src must be a valid VkMicromapEXT handle", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapToMemoryInfoEXT-dst-07541", "The memory pointed to by dst must be at least as large as the serialization size of src, as reported by vkWriteMicromapsPropertiesEXT or vkCmdWriteMicromapsPropertiesEXT with a query type of VK_QUERY_TYPE_MICROMAP_SERIALIZATION_SIZE_EXT", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapToMemoryInfoEXT-mode-07542", "mode must be VK_COPY_MICROMAP_MODE_SERIALIZE_EXT", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapToMemoryInfoEXT-mode-parameter", "mode must be a valid VkCopyMicromapModeEXT value", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapToMemoryInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapToMemoryInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_MICROMAP_TO_MEMORY_INFO_EXT", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapToMemoryInfoEXT-src-07540", "The source micromap src must have been constructed prior to the execution of this command", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyMicromapToMemoryInfoEXT-src-parameter", "src must be a valid VkMicromapEXT handle", "chapters/VK_EXT_opacity_micromap/micromaps.html"},
    {"VUID-VkCopyTensorInfoARM-commonparent", "Both of dstTensor, and srcTensor must have been created, allocated, or retrieved from the same VkDevice", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-dstTensor-09692", "The format features of dstTensor must contain VK_FORMAT_FEATURE_2_TRANSFER_DST_BIT", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-dstTensor-09693", "dstTensor must have been created with VK_TENSOR_USAGE_TRANSFER_DST_BIT_ARM usage flag", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-dstTensor-09695", "If dstTensor is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-dstTensor-parameter", "dstTensor must be a valid VkTensorARM handle", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-pDimensions-09685", "For each of the elements of VkTensorDescriptionARM::pDimensions, srcTensor and dstTensor must be the same size", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-pDstOffset-09688", "pRegions must point to a VkTensorCopyARM structure whose pDstOffset, is NULL or whose elements are all 0", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-pExtent-09689", "pRegions must point to a VkTensorCopyARM structure whose pExtent is NULL or equal to the VkTensorDescriptionARM::pDimensions array specified when srcTensor and dstTensor were created", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-pNext-pNext", "pNext must be NULL", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-pRegions-parameter", "pRegions must be a valid pointer to an array of regionCount valid VkTensorCopyARM structures", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-pSrcOffset-09687", "pRegions must point to a VkTensorCopyARM structure whose pSrcOffset is NULL or whose elements are all 0", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-regionCount-09686", "regionCount must be equal to 1", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-regionCount-arraylength", "regionCount must be greater than 0", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_COPY_TENSOR_INFO_ARM", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-srcTensor-09684", "srcTensor and dstTensor must have been created with equal values for VkTensorDescriptionARM::dimensionCount", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-srcTensor-09690", "The format features of srcTensor must contain VK_FORMAT_FEATURE_2_TRANSFER_SRC_BIT", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-srcTensor-09691", "srcTensor must have been created with VK_TENSOR_USAGE_TRANSFER_SRC_BIT_ARM usage flag", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-srcTensor-09694", "If srcTensor is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/copies.html"},
    {"VUID-VkCopyTensorInfoARM-srcTensor-parameter", "srcTensor must be a valid VkTensorARM handle", "chapters/copies.html"},
    {"VUID-VkCuFunctionCreateInfoNVX-module-parameter", "module must be a valid VkCuModuleNVX handle", "appendices/extensions.html"},
    {"VUID-VkCuFunctionCreateInfoNVX-pName-parameter", "pName must be a null-terminated UTF-8 string", "appendices/extensions.html"},
    {"VUID-VkCuFunctionCreateInfoNVX-pNext-pNext", "pNext must be NULL", "appendices/extensions.html"},
    {"VUID-VkCuFunctionCreateInfoNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX", "appendices/extensions.html"},
    {"VUID-VkCuLaunchInfoNVX-function-parameter", "function must be a valid VkCuFunctionNVX handle", "appendices/extensions.html"},
    {"VUID-VkCuLaunchInfoNVX-pExtras-parameter", "If extraCount is not 0, pExtras must be a valid pointer to an array of extraCount bytes", "appendices/extensions.html"},
    {"VUID-VkCuLaunchInfoNVX-pNext-pNext", "pNext must be NULL", "appendices/extensions.html"},
    {"VUID-VkCuLaunchInfoNVX-pParams-parameter", "If paramCount is not 0, pParams must be a valid pointer to an array of paramCount bytes", "appendices/extensions.html"},
    {"VUID-VkCuLaunchInfoNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX", "appendices/extensions.html"},
    {"VUID-VkCuModuleCreateInfoNVX-pData-parameter", "If dataSize is not 0, pData must be a valid pointer to an array of dataSize bytes", "appendices/extensions.html"},
    {"VUID-VkCuModuleCreateInfoNVX-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkCuModuleTexturingModeCreateInfoNVX", "appendices/extensions.html"},
    {"VUID-VkCuModuleCreateInfoNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX", "appendices/extensions.html"},
    {"VUID-VkCuModuleCreateInfoNVX-sType-unique", "The sType value of each structure in the pNext chain must be unique", "appendices/extensions.html"},
    {"VUID-VkCuModuleTexturingModeCreateInfoNVX-sType-sType", "sType must be VK_STRUCTURE_TYPE_CU_MODULE_TEXTURING_MODE_CREATE_INFO_NVX", "appendices/extensions.html"},
    {"VUID-VkCudaFunctionCreateInfoNV-module-parameter", "module must be a valid VkCudaModuleNV handle", "chapters/shaders.html"},
    {"VUID-VkCudaFunctionCreateInfoNV-pName-parameter", "pName must be a null-terminated UTF-8 string", "chapters/shaders.html"},
    {"VUID-VkCudaFunctionCreateInfoNV-pNext-pNext", "pNext must be NULL", "chapters/shaders.html"},
    {"VUID-VkCudaFunctionCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CUDA_FUNCTION_CREATE_INFO_NV", "chapters/shaders.html"},
    {"VUID-VkCudaLaunchInfoNV-extraCount-09411", "extraCount must be 0", "chapters/dispatch.html"},
    {"VUID-VkCudaLaunchInfoNV-function-parameter", "function must be a valid VkCudaFunctionNV handle", "chapters/dispatch.html"},
    {"VUID-VkCudaLaunchInfoNV-gridDimX-09406", "gridDimX must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[0]", "chapters/dispatch.html"},
    {"VUID-VkCudaLaunchInfoNV-gridDimY-09407", "gridDimY must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[1]", "chapters/dispatch.html"},
    {"VUID-VkCudaLaunchInfoNV-gridDimZ-09408", "gridDimZ must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[2]", "chapters/dispatch.html"},
    {"VUID-VkCudaLaunchInfoNV-pExtras-09412", "pExtras must be NULL", "chapters/dispatch.html"},
    {"VUID-VkCudaLaunchInfoNV-pNext-pNext", "pNext must be NULL", "chapters/dispatch.html"},
    {"VUID-VkCudaLaunchInfoNV-pParams-09410", "pParams must be a pointer to a table of paramCount parameters, corresponding to the arguments of function", "chapters/dispatch.html"},
    {"VUID-VkCudaLaunchInfoNV-paramCount-09409", "paramCount must be the total amount of parameters listed in the pParams table", "chapters/dispatch.html"},
    {"VUID-VkCudaLaunchInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CUDA_LAUNCH_INFO_NV", "chapters/dispatch.html"},
    {"VUID-VkCudaModuleCreateInfoNV-dataSize-09413", "dataSize must be the total size in bytes of the PTX files or binary cache passed to pData", "chapters/shaders.html"},
    {"VUID-VkCudaModuleCreateInfoNV-dataSize-arraylength", "dataSize must be greater than 0", "chapters/shaders.html"},
    {"VUID-VkCudaModuleCreateInfoNV-pData-parameter", "pData must be a valid pointer to an array of dataSize bytes", "chapters/shaders.html"},
    {"VUID-VkCudaModuleCreateInfoNV-pNext-pNext", "pNext must be NULL", "chapters/shaders.html"},
    {"VUID-VkCudaModuleCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_CUDA_MODULE_CREATE_INFO_NV", "chapters/shaders.html"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-pSignalSemaphoreValues-parameter", "If signalSemaphoreValuesCount is not 0, and pSignalSemaphoreValues is not NULL, pSignalSemaphoreValues must be a valid pointer to an array of signalSemaphoreValuesCount uint64_t values", "chapters/cmdbuffers.html"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-pWaitSemaphoreValues-parameter", "If waitSemaphoreValuesCount is not 0, and pWaitSemaphoreValues is not NULL, pWaitSemaphoreValues must be a valid pointer to an array of waitSemaphoreValuesCount uint64_t values", "chapters/cmdbuffers.html"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR", "chapters/cmdbuffers.html"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-signalSemaphoreValuesCount-00080", "signalSemaphoreValuesCount must be the same value as VkSubmitInfo::signalSemaphoreCount, where this structure is in the pNext chain of a VkSubmitInfo structure", "chapters/cmdbuffers.html"},
    {"VUID-VkD3D12FenceSubmitInfoKHR-waitSemaphoreValuesCount-00079", "waitSemaphoreValuesCount must be the same value as VkSubmitInfo::waitSemaphoreCount, where this structure is in the pNext chain of a VkSubmitInfo structure", "chapters/cmdbuffers.html"},
    {"VUID-VkDataGraphPipelineCompilerControlCreateInfoARM-pVendorOptions-parameter", "pVendorOptions must be a null-terminated UTF-8 string", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCompilerControlCreateInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_COMPILER_CONTROL_CREATE_INFO_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineConstantARM-id-09850", "If id corresponds to a graph constant of tensor type, then a VkTensorDescriptionARM structure whose usage member contains VK_TENSOR_USAGE_DATA_GRAPH_BIT_ARM must be included in the pNext chain", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineConstantARM-pConstantData-parameter", "pConstantData must be a pointer value", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineConstantARM-pNext-09775", "If the pNext chain of this structure includes one or more VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM structures then it must also include a VkTensorDescriptionARM structure", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineConstantARM-pNext-09776", "If the pNext chain of this structure includes one or more VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM structures then, for each structure, VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM::dimension must be less than VkTensorDescriptionARM::dimensionCount", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineConstantARM-pNext-09777", "If the pNext chain of this structure includes a VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM structure then, for each structure, VkTensorDescriptionARM::pDimensions[VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM::dimension] must be a multiple of VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM::groupSize", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineConstantARM-pNext-09870", "If the pNext chain of this structure includes multiple VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM structures then no two structures may have their VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM::dimension member set to the same value", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineConstantARM-pNext-09917", "If the pNext chain of this structure includes a VkTensorDescriptionARM structure, then its tiling member must be VK_TENSOR_TILING_LINEAR_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineConstantARM-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM or VkTensorDescriptionARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineConstantARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CONSTANT_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineConstantARM-sType-unique", "The sType value of each structure in the pNext chain must be unique, with the exception of structures of type VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineConstantTensorSemiStructuredSparsityInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CONSTANT_TENSOR_SEMI_STRUCTURED_SPARSITY_INFO_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-dataGraphDescriptorBuffer-09885", "If the dataGraphDescriptorBuffer feature is not enabled, flags must not contain VK_PIPELINE_CREATE_2_DESCRIPTOR_BUFFER_BIT_EXT", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-dataGraphShaderModule-09886", "If the dataGraphShaderModule feature is not enabled, a VkDataGraphPipelineShaderModuleCreateInfoARM structure must not be included in the pNext chain", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-dataGraphUpdateAfterBind-09768", "If the dataGraphUpdateAfterBind feature is not enabled, layout must not use any VkDescriptorSetLayout object created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-flags-09764", "flags may only contain VK_PIPELINE_CREATE_2_NO_PROTECTED_ACCESS_BIT_EXT, VK_PIPELINE_CREATE_2_PROTECTED_ACCESS_ONLY_BIT_EXT, VK_PIPELINE_CREATE_2_DISABLE_OPTIMIZATION_BIT, VK_PIPELINE_CREATE_2_DESCRIPTOR_BUFFER_BIT_EXT, VK_PIPELINE_CREATE_2_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_KHR or VK_PIPELINE_CREATE_2_EARLY_RETURN_ON_FAILURE_BIT_KHR", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-flags-09773", "flags must not include both VK_PIPELINE_CREATE_2_NO_PROTECTED_ACCESS_BIT_EXT and VK_PIPELINE_CREATE_2_PROTECTED_ACCESS_ONLY_BIT_EXT", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-flags-parameter", "flags must be a valid combination of VkPipelineCreateFlagBits2KHR values", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-layout-09767", "layout must have been created with pushConstantRangeCount equal to 0 and pPushConstantRanges equal to NULL", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-layout-parameter", "layout must be a valid VkPipelineLayout handle", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-module-09769", "If a resource variable is declared in VkDataGraphPipelineShaderModuleCreateInfoARM::module, a descriptor slot in layout must match the descriptor type", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-module-09934", "If a resource variable is declared in module as an array, a descriptor slot in layout must match the descriptor count", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-pNext-09763", "One and only one of the following structures must be included in the pNext chain: VkDataGraphPipelineShaderModuleCreateInfoARM VkDataGraphPipelineIdentifierCreateInfoARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-pNext-09804", "If the pNext chain includes an VkPipelineCreationFeedbackCreateInfo structure, then its pipelineStageCreationFeedbackCount must be 0", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-pNext-09875", "If a VkDataGraphPipelineIdentifierCreateInfoARM structure is included in the pNext chain, then flags must contain VK_PIPELINE_CREATE_2_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-pNext-09876", "If a VkDataGraphPipelineIdentifierCreateInfoARM structure is included in the pNext chain, then a VkDataGraphPipelineShaderModuleCreateInfoARM structure must not be included in the pNext chain", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-pNext-09882", "If a VkDataGraphPipelineIdentifierCreateInfoARM structure is included in the pNext chain, then resourceInfoCount must be 0 and pResourceInfos must be NULL", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDataGraphPipelineCompilerControlCreateInfoARM, VkDataGraphPipelineIdentifierCreateInfoARM, VkDataGraphPipelineShaderModuleCreateInfoARM, VkDataGraphProcessingEngineCreateInfoARM, or VkPipelineCreationFeedbackCreateInfo", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-pResourceInfos-09771", "For each of the structures in pResourceInfos, VkDataGraphPipelineResourceInfoARM::descriptorSet and VkDataGraphPipelineResourceInfoARM::binding must correspond to a resource variable declared in module", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-pResourceInfos-parameter", "pResourceInfos must be a valid pointer to an array of resourceInfoCount valid VkDataGraphPipelineResourceInfoARM structures", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-pSetLayouts-09770", "The descriptor set layouts in VkPipelineLayoutCreateInfo::pSetLayouts used to create layout must not include any VkDescriptorSetLayoutBinding whose descriptor type is VK_DESCRIPTOR_TYPE_MUTABLE_EXT", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-pipelineCreationCacheControl-09871", "If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CREATE_2_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_KHR or VK_PIPELINE_CREATE_2_EARLY_RETURN_ON_FAILURE_BIT_KHR", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-pipelineProtectedAccess-09772", "If the pipelineProtectedAccess feature is not enabled, flags must not include VK_PIPELINE_CREATE_2_NO_PROTECTED_ACCESS_BIT_EXT or VK_PIPELINE_CREATE_2_PROTECTED_ACCESS_ONLY_BIT_EXT", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-resourceInfoCount-arraylength", "resourceInfoCount must be greater than 0", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_CREATE_INFO_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineCreateInfoARM-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineDispatchInfoARM-flags-zerobitmask", "flags must be 0", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineDispatchInfoARM-pNext-pNext", "pNext must be NULL", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineDispatchInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_DISPATCH_INFO_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineIdentifierCreateInfoARM-identifierSize-arraylength", "identifierSize must be greater than 0", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineIdentifierCreateInfoARM-pIdentifer-09877", "The data provided via pIdentifer must have been obtained by calling vkGetDataGraphPipelinePropertiesARM to query the value of the VK_DATA_GRAPH_PIPELINE_PROPERTY_IDENTIFIER_ARM property", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineIdentifierCreateInfoARM-pIdentifier-parameter", "pIdentifier must be a valid pointer to an array of identifierSize uint8_t values", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineIdentifierCreateInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_IDENTIFIER_CREATE_INFO_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineInfoARM-dataGraphPipeline-09803", "dataGraphPipeline must have been created with vkCreateDataGraphPipelinesARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineInfoARM-dataGraphPipeline-parameter", "dataGraphPipeline must be a valid VkPipeline handle", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineInfoARM-pNext-pNext", "pNext must be NULL", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_INFO_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelinePropertyQueryResultARM-pData-parameter", "If dataSize is not 0, and pData is not NULL, pData must be a valid pointer to an array of dataSize bytes", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelinePropertyQueryResultARM-pNext-pNext", "pNext must be NULL", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelinePropertyQueryResultARM-property-parameter", "property must be a valid VkDataGraphPipelinePropertyARM value", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelinePropertyQueryResultARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_PROPERTY_QUERY_RESULT_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineResourceInfoARM-arrayElement-09779", "arrayElement must be 0", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineResourceInfoARM-descriptorSet-09851", "If descriptorSet and binding identify a tensor resource or an array of tensor resources, then a VkTensorDescriptionARM structure whose usage contains VK_TENSOR_USAGE_DATA_GRAPH_BIT_ARM must be included in the pNext chain", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineResourceInfoARM-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkTensorDescriptionARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineResourceInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_RESOURCE_INFO_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineResourceInfoARM-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionBindPointRequirementARM-bindPoint-parameter", "bindPoint must be a valid VkDataGraphPipelineSessionBindPointARM value", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionBindPointRequirementARM-bindPointType-parameter", "bindPointType must be a valid VkDataGraphPipelineSessionBindPointTypeARM value", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionBindPointRequirementARM-pNext-pNext", "pNext must be NULL", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionBindPointRequirementARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_REQUIREMENT_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionBindPointRequirementsInfoARM-pNext-pNext", "pNext must be NULL", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionBindPointRequirementsInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_BIND_POINT_REQUIREMENTS_INFO_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionBindPointRequirementsInfoARM-session-parameter", "session must be a valid VkDataGraphPipelineSessionARM handle", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionCreateInfoARM-dataGraphPipeline-09781", "dataGraphPipeline must have been obtained via a call to vkCreateDataGraphPipelinesARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionCreateInfoARM-dataGraphPipeline-parameter", "dataGraphPipeline must be a valid VkPipeline handle", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionCreateInfoARM-flags-parameter", "flags must be a valid combination of VkDataGraphPipelineSessionCreateFlagBitsARM values", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionCreateInfoARM-pNext-pNext", "pNext must be NULL", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionCreateInfoARM-protectedMemory-09782", "If the protectedMemory feature is not enabled, flags must not contain VK_DATA_GRAPH_PIPELINE_SESSION_CREATE_PROTECTED_BIT_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionCreateInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_CREATE_INFO_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionMemoryRequirementsInfoARM-bindPoint-parameter", "bindPoint must be a valid VkDataGraphPipelineSessionBindPointARM value", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionMemoryRequirementsInfoARM-objectIndex-09855", "objectIndex must be less than the number of objects returned by vkGetDataGraphPipelineSessionBindPointRequirementsARM via VkDataGraphPipelineSessionBindPointRequirementARM::numObjects with VkDataGraphPipelineSessionMemoryRequirementsInfoARM::bindPoint equal to bindPoint", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionMemoryRequirementsInfoARM-pNext-pNext", "pNext must be NULL", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionMemoryRequirementsInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SESSION_MEMORY_REQUIREMENTS_INFO_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineSessionMemoryRequirementsInfoARM-session-parameter", "session must be a valid VkDataGraphPipelineSessionARM handle", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-dataGraphSpecializationConstants-09849", "If the dataGraphSpecializationConstants feature is not enabled then pSpecializationInfo must be NULL and module must not contain any OpSpec* instructions", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-id-09774", "The id member of all structures in pConstants must be a valid GraphConstantID used by a OpGraphConstantARM instruction in module", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-module-parameter", "If module is not VK_NULL_HANDLE, module must be a valid VkShaderModule handle", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-pConstants-parameter", "If constantCount is not 0, and pConstants is not NULL, pConstants must be a valid pointer to an array of constantCount valid VkDataGraphPipelineConstantARM structures", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-pName-09872", "pName must be the name of an OpGraphEntryPointARM in module", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-pName-parameter", "pName must be a null-terminated UTF-8 string", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-pNext-09873", "If the pNext chain includes a VkShaderModuleCreateInfo structure, then module must be VK_NULL_HANDLE", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-pNext-09874", "If the pNext chain does not include a VkShaderModuleCreateInfo structure, then module must be a valid VkShaderModule", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-pSpecializationInfo-parameter", "If pSpecializationInfo is not NULL, pSpecializationInfo must be a valid pointer to a valid VkSpecializationInfo structure", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphPipelineShaderModuleCreateInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PIPELINE_SHADER_MODULE_CREATE_INFO_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphProcessingEngineCreateInfoARM-pProcessingEngines-09918", "pProcessingEngines must not contain identical VkPhysicalDeviceDataGraphProcessingEngineARM structures", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphProcessingEngineCreateInfoARM-pProcessingEngines-parameter", "pProcessingEngines must be a valid pointer to an array of processingEngineCount VkPhysicalDeviceDataGraphProcessingEngineARM structures", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphProcessingEngineCreateInfoARM-processingEngineCount-arraylength", "processingEngineCount must be greater than 0", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDataGraphProcessingEngineCreateInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DATA_GRAPH_PROCESSING_ENGINE_CREATE_INFO_ARM", "chapters/VK_ARM_data_graph/graphs.html"},
    {"VUID-VkDebugMarkerMarkerInfoEXT-pMarkerName-parameter", "pMarkerName must be a null-terminated UTF-8 string", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerMarkerInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerMarkerInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-object-01491", "object must not be VK_NULL_HANDLE", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-object-01492", "object must be a Vulkan object of the type associated with objectType as defined in VkDebugReportObjectTypeEXT and Vulkan Handle Relationship", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-objectType-01490", "objectType must not be VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-objectType-parameter", "objectType must be a valid VkDebugReportObjectTypeEXT value", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-pObjectName-parameter", "pObjectName must be a null-terminated UTF-8 string", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectNameInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-object-01494", "object must not be VK_NULL_HANDLE", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-object-01495", "object must be a Vulkan object of the type associated with objectType as defined in VkDebugReportObjectTypeEXT and Vulkan Handle Relationship", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-objectType-01493", "objectType must not be VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-objectType-parameter", "objectType must be a valid VkDebugReportObjectTypeEXT value", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-pTag-parameter", "pTag must be a valid pointer to an array of tagSize bytes", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT", "chapters/debugging.html"},
    {"VUID-VkDebugMarkerObjectTagInfoEXT-tagSize-arraylength", "tagSize must be greater than 0", "chapters/debugging.html"},
    {"VUID-VkDebugReportCallbackCreateInfoEXT-flags-parameter", "flags must be a valid combination of VkDebugReportFlagBitsEXT values", "chapters/debugging.html"},
    {"VUID-VkDebugReportCallbackCreateInfoEXT-pfnCallback-parameter", "pfnCallback must be a valid PFN_vkDebugReportCallbackEXT value", "chapters/debugging.html"},
    {"VUID-VkDebugReportCallbackCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsLabelEXT-pLabelName-parameter", "pLabelName must be a null-terminated UTF-8 string", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsLabelEXT-pNext-pNext", "pNext must be NULL", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsLabelEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-flags-zerobitmask", "flags must be 0", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pCmdBufLabels-parameter", "If cmdBufLabelCount is not 0, pCmdBufLabels must be a valid pointer to an array of cmdBufLabelCount valid VkDebugUtilsLabelEXT structures", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pMessage-parameter", "If pMessage is not NULL, pMessage must be a null-terminated UTF-8 string", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pMessageIdName-parameter", "If pMessageIdName is not NULL, pMessageIdName must be a null-terminated UTF-8 string", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDeviceAddressBindingCallbackDataEXT", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pObjects-parameter", "If objectCount is not 0, pObjects must be a valid pointer to an array of objectCount valid VkDebugUtilsObjectNameInfoEXT structures", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-pQueueLabels-parameter", "If queueLabelCount is not 0, pQueueLabels must be a valid pointer to an array of queueLabelCount valid VkDebugUtilsLabelEXT structures", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCallbackDataEXT-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-flags-zerobitmask", "flags must be 0", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-parameter", "messageSeverity must be a valid combination of VkDebugUtilsMessageSeverityFlagBitsEXT values", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageSeverity-requiredbitmask", "messageSeverity must not be 0", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-parameter", "messageType must be a valid combination of VkDebugUtilsMessageTypeFlagBitsEXT values", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-messageType-requiredbitmask", "messageType must not be 0", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-pfnUserCallback-parameter", "pfnUserCallback must be a valid PFN_vkDebugUtilsMessengerCallbackEXT value", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsMessengerCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-02589", "If objectType is VK_OBJECT_TYPE_UNKNOWN, objectHandle must not be VK_NULL_HANDLE", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-02590", "If objectType is not VK_OBJECT_TYPE_UNKNOWN, objectHandle must be VK_NULL_HANDLE or a valid Vulkan handle of the type associated with objectType as defined in the VkObjectType and Vulkan Handle Relationship table", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-objectType-parameter", "objectType must be a valid VkObjectType value", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-pObjectName-parameter", "If pObjectName is not NULL, pObjectName must be a null-terminated UTF-8 string", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsObjectNameInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-objectHandle-01910", "objectHandle must be a valid Vulkan handle of the type associated with objectType as defined in the VkObjectType and Vulkan Handle Relationship table", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-objectType-01908", "objectType must not be VK_OBJECT_TYPE_UNKNOWN", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-objectType-parameter", "objectType must be a valid VkObjectType value", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-pTag-parameter", "pTag must be a valid pointer to an array of tagSize bytes", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT", "chapters/debugging.html"},
    {"VUID-VkDebugUtilsObjectTagInfoEXT-tagSize-arraylength", "tagSize must be greater than 0", "chapters/debugging.html"},
    {"VUID-VkDecompressMemoryRegionNV-decompressedSize-07689", "The decompressedSize must be large enough to hold the decompressed data based on the decompressionMethod", "chapters/VK_NV_memory_decompression.html"},
    {"VUID-VkDecompressMemoryRegionNV-decompressionMethod-07690", "The decompressionMethod must have a single bit set", "chapters/VK_NV_memory_decompression.html"},
    {"VUID-VkDecompressMemoryRegionNV-decompressionMethod-09395", "If decompressionMethod is VK_MEMORY_DECOMPRESSION_METHOD_GDEFLATE_1_0_BIT_NV, then decompressedSize must be less than or equal to 65536 bytes", "chapters/VK_NV_memory_decompression.html"},
    {"VUID-VkDecompressMemoryRegionNV-decompressionMethod-parameter", "decompressionMethod must be a valid combination of VkMemoryDecompressionMethodFlagBitsNV values", "chapters/VK_NV_memory_decompression.html"},
    {"VUID-VkDecompressMemoryRegionNV-decompressionMethod-requiredbitmask", "decompressionMethod must not be 0", "chapters/VK_NV_memory_decompression.html"},
    {"VUID-VkDecompressMemoryRegionNV-dstAddress-07687", "The dstAddress must be 4 byte aligned", "chapters/VK_NV_memory_decompression.html"},
    {"VUID-VkDecompressMemoryRegionNV-dstAddress-07688", "The memory in range dstAddress and dstAddress + decompressedSize must be valid and bound to a VkDeviceMemory object", "chapters/VK_NV_memory_decompression.html"},
    {"VUID-VkDecompressMemoryRegionNV-srcAddress-07685", "The srcAddress must be 4 byte aligned", "chapters/VK_NV_memory_decompression.html"},
    {"VUID-VkDecompressMemoryRegionNV-srcAddress-07686", "The memory in range srcAddress and srcAddress + compressedSize must be valid and bound to a VkDeviceMemory object", "chapters/VK_NV_memory_decompression.html"},
    {"VUID-VkDecompressMemoryRegionNV-srcAddress-07691", "The srcAddress to srcAddress + compressedSize region must not overlap with the dstAddress and dstAddress + decompressedSize region", "chapters/VK_NV_memory_decompression.html"},
    {"VUID-VkDedicatedAllocationBufferCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV", "chapters/resources.html"},
    {"VUID-VkDedicatedAllocationImageCreateInfoNV-dedicatedAllocation-00994", "If dedicatedAllocation is VK_TRUE, VkImageCreateInfo::flags must not include VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT", "chapters/resources.html"},
    {"VUID-VkDedicatedAllocationImageCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV", "chapters/resources.html"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00651", "If buffer is not VK_NULL_HANDLE, the buffer must have been created with VkDedicatedAllocationBufferCreateInfoNV::dedicatedAllocation equal to VK_TRUE", "chapters/memory.html"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00653", "If buffer is not VK_NULL_HANDLE, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the buffer", "chapters/memory.html"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-00655", "If buffer is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation, the memory being imported must also be a dedicated buffer allocation and buffer must be identical to the buffer associated with the imported memory", "chapters/memory.html"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-buffer-parameter", "If buffer is not VK_NULL_HANDLE, buffer must be a valid VkBuffer handle", "chapters/memory.html"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-commonparent", "Both of buffer, and image that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/memory.html"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00649", "At least one of image and buffer must be VK_NULL_HANDLE", "chapters/memory.html"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00650", "If image is not VK_NULL_HANDLE, the image must have been created with VkDedicatedAllocationImageCreateInfoNV::dedicatedAllocation equal to VK_TRUE", "chapters/memory.html"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00652", "If image is not VK_NULL_HANDLE, VkMemoryAllocateInfo::allocationSize must equal the VkMemoryRequirements::size of the image", "chapters/memory.html"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-00654", "If image is not VK_NULL_HANDLE and VkMemoryAllocateInfo defines a memory import operation, the memory being imported must also be a dedicated image allocation and image must be identical to the image associated with the imported memory", "chapters/memory.html"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-image-parameter", "If image is not VK_NULL_HANDLE, image must be a valid VkImage handle", "chapters/memory.html"},
    {"VUID-VkDedicatedAllocationMemoryAllocateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV", "chapters/memory.html"},
    {"VUID-VkDependencyInfo-dependencyFlags-parameter", "dependencyFlags must be a valid combination of VkDependencyFlagBits values", "chapters/synchronization.html"},
    {"VUID-VkDependencyInfo-pBufferMemoryBarriers-parameter", "If bufferMemoryBarrierCount is not 0, pBufferMemoryBarriers must be a valid pointer to an array of bufferMemoryBarrierCount valid VkBufferMemoryBarrier2 structures", "chapters/synchronization.html"},
    {"VUID-VkDependencyInfo-pImageMemoryBarriers-parameter", "If imageMemoryBarrierCount is not 0, pImageMemoryBarriers must be a valid pointer to an array of imageMemoryBarrierCount valid VkImageMemoryBarrier2 structures", "chapters/synchronization.html"},
    {"VUID-VkDependencyInfo-pMemoryBarriers-10605", "For each element of pMemoryBarriers, the sType value of each structure in the pNext chain must be unique", "chapters/synchronization.html"},
    {"VUID-VkDependencyInfo-pMemoryBarriers-10606", "For each element of pMemoryBarriers, pNext must be either NULL or a pointer to a valid instance of VkMemoryBarrierAccessFlags3KHR", "chapters/synchronization.html"},
    {"VUID-VkDependencyInfo-pMemoryBarriers-parameter", "If memoryBarrierCount is not 0, pMemoryBarriers must be a valid pointer to an array of memoryBarrierCount valid VkMemoryBarrier2 structures", "chapters/synchronization.html"},
    {"VUID-VkDependencyInfo-pNext-09754", "If a VkTensorDependencyInfoARM structure is included in the pNext chain, a VkTensorMemoryBarrierARM structure must not be included in the pNext chain", "chapters/synchronization.html"},
    {"VUID-VkDependencyInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkTensorDependencyInfoARM or VkTensorMemoryBarrierARM", "chapters/synchronization.html"},
    {"VUID-VkDependencyInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEPENDENCY_INFO", "chapters/synchronization.html"},
    {"VUID-VkDependencyInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/synchronization.html"},
    {"VUID-VkDepthBiasInfoEXT-depthBiasClamp-08950", "If the depthBiasClamp feature is not enabled, depthBiasClamp must be 0.0", "chapters/primsrast.html"},
    {"VUID-VkDepthBiasInfoEXT-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDepthBiasRepresentationInfoEXT", "chapters/primsrast.html"},
    {"VUID-VkDepthBiasInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEPTH_BIAS_INFO_EXT", "chapters/primsrast.html"},
    {"VUID-VkDepthBiasInfoEXT-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/primsrast.html"},
    {"VUID-VkDepthBiasRepresentationInfoEXT-depthBiasExact-08949", "If the depthBiasExact feature is not enabled, depthBiasExact must be VK_FALSE", "chapters/primsrast.html"},
    {"VUID-VkDepthBiasRepresentationInfoEXT-depthBiasRepresentation-parameter", "depthBiasRepresentation must be a valid VkDepthBiasRepresentationEXT value", "chapters/primsrast.html"},
    {"VUID-VkDepthBiasRepresentationInfoEXT-floatRepresentation-08948", "If the floatRepresentation feature is not enabled, depthBiasRepresentation must not be VK_DEPTH_BIAS_REPRESENTATION_FLOAT_EXT", "chapters/primsrast.html"},
    {"VUID-VkDepthBiasRepresentationInfoEXT-leastRepresentableValueForceUnormRepresentation-08947", "If the leastRepresentableValueForceUnormRepresentation feature is not enabled, depthBiasRepresentation must not be VK_DEPTH_BIAS_REPRESENTATION_LEAST_REPRESENTABLE_VALUE_FORCE_UNORM_EXT", "chapters/primsrast.html"},
    {"VUID-VkDepthBiasRepresentationInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEPTH_BIAS_REPRESENTATION_INFO_EXT", "chapters/primsrast.html"},
    {"VUID-VkDepthClampRangeEXT-pDepthClampRange-00999", "minDepthClamp must be less than or equal to maxDepthClamp", "chapters/fragops.html"},
    {"VUID-VkDepthClampRangeEXT-pDepthClampRange-09648", "If the VK_EXT_depth_range_unrestricted extension is not enabled, minDepthClamp must be greater than or equal to 0.0", "chapters/fragops.html"},
    {"VUID-VkDepthClampRangeEXT-pDepthClampRange-09649", "If the VK_EXT_depth_range_unrestricted extension is not enabled, maxDepthClamp must be less than or equal to 1.0", "chapters/fragops.html"},
    {"VUID-VkDescriptorAddressInfoEXT-None-08044", "If address is not zero, address must be a valid device address at an offset within a VkBuffer", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorAddressInfoEXT-None-09508", "If address is not zero, and the descriptor is of type VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER or VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, then format must not be VK_FORMAT_UNDEFINED", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorAddressInfoEXT-address-08043", "If the nullDescriptor feature is not enabled, address must not be zero", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorAddressInfoEXT-format-parameter", "format must be a valid VkFormat value", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorAddressInfoEXT-nullDescriptor-08938", "If address is zero, range must be VK_WHOLE_SIZE", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorAddressInfoEXT-nullDescriptor-08939", "If address is not zero, range must not be VK_WHOLE_SIZE", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorAddressInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorAddressInfoEXT-range-08045", "range must be less than or equal to the size of the buffer containing address minus the offset of address from the base address of the buffer", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorAddressInfoEXT-range-08940", "range must not be zero", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorAddressInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_ADDRESS_INFO_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-None-09499", "If the pNext chain does not include a VkBufferUsageFlags2CreateInfo structure, usage must be a valid combination of VkBufferUsageFlagBits values", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-None-09500", "If the pNext chain does not include a VkBufferUsageFlags2CreateInfo structure, usage must not be 0", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-address-08057", "address must be aligned to VkPhysicalDeviceDescriptorBufferPropertiesEXT::descriptorBufferOffsetAlignment", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-bufferlessPushDescriptors-08056", "If VkPhysicalDeviceDescriptorBufferPropertiesEXT::bufferlessPushDescriptors is VK_FALSE, and usage contains VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT, then the pNext chain must include a VkDescriptorBufferBindingPushDescriptorBufferHandleEXT structure", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkBufferUsageFlags2CreateInfo or VkDescriptorBufferBindingPushDescriptorBufferHandleEXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_INFO_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-usage-08122", "If usage includes VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT, address must be an address within a valid buffer that was created with VK_BUFFER_USAGE_SAMPLER_DESCRIPTOR_BUFFER_BIT_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-usage-08123", "If usage includes VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT, address must be an address within a valid buffer that was created with VK_BUFFER_USAGE_RESOURCE_DESCRIPTOR_BUFFER_BIT_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferBindingInfoEXT-usage-08124", "If usage includes VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT, address must be an address within a valid buffer that was created with VK_BUFFER_USAGE_PUSH_DESCRIPTORS_DESCRIPTOR_BUFFER_BIT_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferBindingPushDescriptorBufferHandleEXT-buffer-parameter", "buffer must be a valid VkBuffer handle", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferBindingPushDescriptorBufferHandleEXT-bufferlessPushDescriptors-08059", "VkPhysicalDeviceDescriptorBufferPropertiesEXT::bufferlessPushDescriptors must be VK_FALSE", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferBindingPushDescriptorBufferHandleEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_PUSH_DESCRIPTOR_BUFFER_HANDLE_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferInfo-buffer-02998", "If the nullDescriptor feature is not enabled, buffer must not be VK_NULL_HANDLE", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferInfo-buffer-02999", "If buffer is VK_NULL_HANDLE, offset must be zero and range must be VK_WHOLE_SIZE", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferInfo-buffer-parameter", "If buffer is not VK_NULL_HANDLE, buffer must be a valid VkBuffer handle", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferInfo-offset-00340", "offset must be less than the size of buffer", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferInfo-range-00341", "If range is not equal to VK_WHOLE_SIZE, range must be greater than 0", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorBufferInfo-range-00342", "If range is not equal to VK_WHOLE_SIZE, range must be less than or equal to the size of buffer minus offset", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorDataEXT-type-08030", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, and pUniformBuffer->address is the address of a non-sparse buffer, then that buffer must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorDataEXT-type-08031", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, and pStorageBuffer->address is the address of a non-sparse buffer, then that buffer must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorDataEXT-type-08032", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, and pUniformTexelBuffer->address is the address of a non-sparse buffer, then that buffer must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorDataEXT-type-08033", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, and pStorageTexelBuffer->address is the address of a non-sparse buffer, then that buffer must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorDataEXT-type-08034", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and the nullDescriptor feature is not enabled, pCombinedImageSampler->imageView must not be VK_NULL_HANDLE", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorDataEXT-type-08035", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and the nullDescriptor feature is not enabled, pSampledImage must not be NULL and pSampledImage->imageView must not be VK_NULL_HANDLE", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorDataEXT-type-08036", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and the nullDescriptor feature is not enabled, pStorageImage must not be NULL and pStorageImage->imageView must not be VK_NULL_HANDLE", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorDataEXT-type-08037", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, and the nullDescriptor feature is not enabled, pUniformTexelBuffer must not be NULL", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorDataEXT-type-08038", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, and the nullDescriptor feature is not enabled, pStorageTexelBuffer must not be NULL", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorDataEXT-type-08039", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, and the nullDescriptor feature is not enabled, pUniformBuffer must not be NULL", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorDataEXT-type-08040", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, and the nullDescriptor feature is not enabled, pStorageBuffer must not be NULL", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorDataEXT-type-08041", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR, and the nullDescriptor feature is not enabled, accelerationStructure must not be 0", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorDataEXT-type-08042", "If VkDescriptorGetInfoEXT:type is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV, and the nullDescriptor feature is not enabled, accelerationStructure must not be 0", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-pCombinedImageSampler-parameter", "If type is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the pCombinedImageSampler member of data must be a valid pointer to a valid VkDescriptorImageInfo structure", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-pInputAttachmentImage-parameter", "If type is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the pInputAttachmentImage member of data must be a valid pointer to a valid VkDescriptorImageInfo structure", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDescriptorGetTensorInfoARM", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-pSampledImage-parameter", "If type is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and if pSampledImage is not NULL, the pSampledImage member of data must be a valid pointer to a valid VkDescriptorImageInfo structure", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-pSampler-parameter", "If type is VK_DESCRIPTOR_TYPE_SAMPLER, the pSampler member of data must be a valid pointer to a valid VkSampler handle", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-pStorageBuffer-parameter", "If type is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, and if pStorageBuffer is not NULL, the pStorageBuffer member of data must be a valid pointer to a valid VkDescriptorAddressInfoEXT structure", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-pStorageImage-parameter", "If type is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and if pStorageImage is not NULL, the pStorageImage member of data must be a valid pointer to a valid VkDescriptorImageInfo structure", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-pStorageTexelBuffer-parameter", "If type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, and if pStorageTexelBuffer is not NULL, the pStorageTexelBuffer member of data must be a valid pointer to a valid VkDescriptorAddressInfoEXT structure", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-pUniformBuffer-parameter", "If type is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, and if pUniformBuffer is not NULL, the pUniformBuffer member of data must be a valid pointer to a valid VkDescriptorAddressInfoEXT structure", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-pUniformTexelBuffer-parameter", "If type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, and if pUniformTexelBuffer is not NULL, the pUniformTexelBuffer member of data must be a valid pointer to a valid VkDescriptorAddressInfoEXT structure", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_GET_INFO_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-08018", "type must not be VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-08019", "If type is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the pCombinedImageSampler->sampler member of data must be a VkSampler created on device", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-08020", "If type is VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, the pCombinedImageSampler->imageView member of data must be a VkImageView created on device, or VK_NULL_HANDLE", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-08021", "If type is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, the pInputAttachmentImage->imageView member of data must be a VkImageView created on device", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-08022", "If type is VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, and if pSampledImage is not NULL, the pSampledImage->imageView member of data must be a VkImageView created on device, or VK_NULL_HANDLE", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-08023", "If type is VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, and if pStorageImage is not NULL, the pStorageImage->imageView member of data must be a VkImageView created on device, or VK_NULL_HANDLE", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-08024", "If type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, pUniformTexelBuffer is not NULL and pUniformTexelBuffer->address is not zero, pUniformTexelBuffer->address must be an address within a VkBuffer created on device", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-08025", "If type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, pStorageTexelBuffer is not NULL and pStorageTexelBuffer->address is not zero, pStorageTexelBuffer->address must be an address within a VkBuffer created on device", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-08026", "If type is VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER, pUniformBuffer is not NULL and pUniformBuffer->address is not zero, pUniformBuffer->address must be an address within a VkBuffer created on device", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-08027", "If type is VK_DESCRIPTOR_TYPE_STORAGE_BUFFER, pStorageBuffer is not NULL and pStorageBuffer->address is not zero, pStorageBuffer->address must be an address within a VkBuffer created on device", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-08028", "If type is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR and accelerationStructure is not 0, accelerationStructure must contain the address of a VkAccelerationStructureKHR created on device", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-08029", "If type is VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV and accelerationStructure is not 0, accelerationStructure must contain the handle of a VkAccelerationStructureNV created on device, returned by vkGetAccelerationStructureHandleNV", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-09427", "If type is VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER, pUniformBuffer is not NULL , the number of texel buffer elements given by (floor(pUniformBuffer->range / (texel block size)) x (texels per block)) where texel block size and texels per block are as defined in the Compatible Formats table for pUniformBuffer->format, must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-09428", "If type is VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER, pStorageBuffer is not NULL , the number of texel buffer elements given by (floor(pStorageBuffer->range / (texel block size)) x (texels per block)) where texel block size and texels per block are as defined in the Compatible Formats table for pStorageBuffer->format, must be less than or equal to VkPhysicalDeviceLimits::maxTexelBufferElements", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-09701", "If type is VK_DESCRIPTOR_TYPE_TENSOR_ARM, a VkDescriptorGetTensorInfoARM structure must be included in the pNext chain and data is ignored", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetInfoEXT-type-parameter", "type must be a valid VkDescriptorType value", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetTensorInfoARM-nullDescriptor-09899", "If the nullDescriptor feature is not enabled, tensorView must not be VK_NULL_HANDLE", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetTensorInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_GET_TENSOR_INFO_ARM", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorGetTensorInfoARM-tensorView-parameter", "tensorView must be a valid VkTensorViewARM handle", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorImageInfo-commonparent", "Both of imageView, and sampler that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorImageInfo-descriptorType-06713", "If the image2DViewOf3D feature is not enabled or descriptorType is not VK_DESCRIPTOR_TYPE_STORAGE_IMAGE then imageView must not be a 2D view created from a 3D image", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorImageInfo-descriptorType-06714", "If the sampler2DViewOf3D feature is not enabled or descriptorType is not VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER then imageView must not be a 2D view created from a 3D image", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorImageInfo-imageLayout-00344", "imageLayout must match the actual VkImageLayout of each subresource accessible from imageView at the time this descriptor is accessed as defined by the image layout matching rules", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorImageInfo-imageLayout-09425", "If imageLayout is VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL, then the aspectMask used to create imageView must not include either VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorImageInfo-imageLayout-09426", "If imageLayout is VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL, VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL, VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL, then the aspectMask used to create imageView must not include VK_IMAGE_ASPECT_COLOR_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorImageInfo-imageView-01976", "If imageView is created from a depth/stencil image, the aspectMask used to create the imageView must include either VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT but not both", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorImageInfo-imageView-06712", "imageView must not be a 2D array image view created from a 3D image", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorImageInfo-imageView-07795", "If imageView is a 2D view created from a 3D image, then descriptorType must be VK_DESCRIPTOR_TYPE_STORAGE_IMAGE, VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE, or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorImageInfo-imageView-07796", "If imageView is a 2D view created from a 3D image, then the image must have been created with VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT set", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorImageInfo-mutableComparisonSamplers-04450", "If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::mutableComparisonSamplers is VK_FALSE, then sampler must have been created with VkSamplerCreateInfo::compareEnable set to VK_FALSE", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorImageInfo-sampler-01564", "If sampler is used and the VkFormat of the image is a multi-planar format, the image must have been created with VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT, and the aspectMask of the imageView must be a valid multi-planar aspect mask bit", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolCreateInfo-descriptorPoolOverallocation-09227", "If the descriptorPoolOverallocation feature is not enabled, or flags does not have VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_SETS_BIT_NV set, maxSets must be greater than 0", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolCreateInfo-flags-04607", "If flags has the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT bit set, then the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT bit must not be set", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolCreateInfo-flags-04609", "If flags has the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT bit set, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT::mutableDescriptorType must be enabled", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolCreateInfo-flags-09228", "If flags has the VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_SETS_BIT_NV or VK_DESCRIPTOR_POOL_CREATE_ALLOW_OVERALLOCATION_POOLS_BIT_NV bits set, then descriptorPoolOverallocation must be enabled", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolCreateInfo-flags-parameter", "flags must be a valid combination of VkDescriptorPoolCreateFlagBits values", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolCreateInfo-mutableDescriptorType-04608", "If VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT::mutableDescriptorType is not enabled, pPoolSizes must not contain a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDataGraphProcessingEngineCreateInfoARM, VkDescriptorPoolInlineUniformBlockCreateInfo, or VkMutableDescriptorTypeCreateInfoEXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolCreateInfo-pPoolSizes-04787", "If pPoolSizes contains a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT, any other VK_DESCRIPTOR_TYPE_MUTABLE_EXT element in pPoolSizes must not have sets of supported descriptor types which partially overlap", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolCreateInfo-pPoolSizes-09424", "If pPoolSizes contains a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, the pNext chain must include a VkDescriptorPoolInlineUniformBlockCreateInfo structure whose maxInlineUniformBlockBindings member is not zero", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolCreateInfo-pPoolSizes-parameter", "If poolSizeCount is not 0, pPoolSizes must be a valid pointer to an array of poolSizeCount valid VkDescriptorPoolSize structures", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolCreateInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolInlineUniformBlockCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolSize-descriptorCount-00302", "descriptorCount must be greater than 0", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolSize-type-02218", "If type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK then descriptorCount must be a multiple of 4", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorPoolSize-type-parameter", "type must be a valid VkDescriptorType value", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetAllocateInfo-apiVersion-07895", "If the VK_KHR_maintenance1 extension is not enabled and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, descriptorSetCount must not be greater than the number of sets that are currently available for allocation in descriptorPool", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetAllocateInfo-apiVersion-07896", "If the VK_KHR_maintenance1 extension is not enabled and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, descriptorPool must have enough free descriptor capacity remaining to allocate the descriptor sets of the specified layouts", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetAllocateInfo-commonparent", "Both of descriptorPool, and the elements of pSetLayouts must have been created, allocated, or retrieved from the same VkDevice", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetAllocateInfo-descriptorPool-parameter", "descriptorPool must be a valid VkDescriptorPool handle", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetAllocateInfo-descriptorSetCount-arraylength", "descriptorSetCount must be greater than 0", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetAllocateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDescriptorSetVariableDescriptorCountAllocateInfo", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-00308", "Each element of pSetLayouts must not have been created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT set", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-03044", "If any element of pSetLayouts was created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT bit set, descriptorPool must have been created with the VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT flag set", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-04610", "If any element of pSetLayouts was created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT bit set, descriptorPool must have been created with the VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_EXT flag set", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-08009", "Each element of pSetLayouts must not have been created with the VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT bit set", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-09380", "If pSetLayouts[i] was created with an element of pBindingFlags that includes VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, and VkDescriptorSetVariableDescriptorCountAllocateInfo is included in the pNext chain, and VkDescriptorSetVariableDescriptorCountAllocateInfo::descriptorSetCount is not zero, then VkDescriptorSetVariableDescriptorCountAllocateInfo::pDescriptorCounts[i] must be less than or equal to VkDescriptorSetLayoutBinding::descriptorCount for the corresponding binding used to create pSetLayouts[i]", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetAllocateInfo-pSetLayouts-parameter", "pSetLayouts must be a valid pointer to an array of descriptorSetCount valid VkDescriptorSetLayout handles", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetAllocateInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetBindingReferenceVALVE-descriptorSetLayout-parameter", "descriptorSetLayout must be a valid VkDescriptorSetLayout handle", "appendices/extensions.html"},
    {"VUID-VkDescriptorSetBindingReferenceVALVE-pNext-pNext", "pNext must be NULL", "appendices/extensions.html"},
    {"VUID-VkDescriptorSetBindingReferenceVALVE-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_BINDING_REFERENCE_VALVE", "appendices/extensions.html"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorCount-09465", "If descriptorCount is not 0, stageFlags must be VK_SHADER_STAGE_ALL or a valid combination of other VkShaderStageFlagBits values", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-00282", "If descriptorType is VK_DESCRIPTOR_TYPE_SAMPLER or VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, and descriptorCount is not 0 and pImmutableSamplers is not NULL, pImmutableSamplers must be a valid pointer to an array of descriptorCount valid VkSampler handles", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-01510", "If descriptorType is VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT and descriptorCount is not 0, then stageFlags must be 0 or VK_SHADER_STAGE_FRAGMENT_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-02209", "If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK then descriptorCount must be a multiple of 4", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-04604", "If the inlineUniformBlock feature is not enabled, descriptorType must not be VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-04605", "If descriptorType is VK_DESCRIPTOR_TYPE_MUTABLE_EXT, then pImmutableSamplers must be NULL", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-08004", "If descriptorType is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK and VkDescriptorSetLayoutCreateInfo::flags does not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT then descriptorCount must be less than or equal to VkPhysicalDeviceInlineUniformBlockProperties::maxInlineUniformBlockSize", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBinding-descriptorType-parameter", "descriptorType must be a valid VkDescriptorType value", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBinding-flags-08005", "If VkDescriptorSetLayoutCreateInfo::flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, descriptorType must be VK_DESCRIPTOR_TYPE_SAMPLER", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBinding-flags-08006", "If VkDescriptorSetLayoutCreateInfo::flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, descriptorCount must less than or equal to 1", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBinding-flags-08007", "If VkDescriptorSetLayoutCreateInfo::flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, and descriptorCount is equal to 1, pImmutableSamplers must not be NULL", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBinding-flags-09466", "If VkDescriptorSetLayoutCreateInfo::flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, and descriptorCount is not 0, then stageFlags must be a valid combination of VK_SHADER_STAGE_VERTEX_BIT, VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT, VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT, VK_SHADER_STAGE_GEOMETRY_BIT, VK_SHADER_STAGE_FRAGMENT_BIT and VK_SHADER_STAGE_COMPUTE_BIT values", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBinding-pImmutableSamplers-04009", "The sampler objects indicated by pImmutableSamplers must not have a borderColor with one of the values VK_BORDER_COLOR_FLOAT_CUSTOM_EXT or VK_BORDER_COLOR_INT_CUSTOM_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-None-03011", "All bindings with descriptor type VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT, VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC, or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-bindingCount-03002", "If bindingCount is not zero, bindingCount must equal VkDescriptorSetLayoutCreateInfo::bindingCount", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingAccelerationStructureUpdateAfterBind-03570", "If VkPhysicalDeviceAccelerationStructureFeaturesKHR::descriptorBindingAccelerationStructureUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR or VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingInlineUniformBlockUpdateAfterBind-02211", "If VkPhysicalDeviceInlineUniformBlockFeatures::descriptorBindingInlineUniformBlockUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingPartiallyBound-03013", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingPartiallyBound is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingSampledImageUpdateAfterBind-03006", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingSampledImageUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_SAMPLER, VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER, or VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageBufferUpdateAfterBind-03008", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageImageUpdateAfterBind-03007", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageImageUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_IMAGE must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageTensorUpdateAfterBind-09697", "If VkPhysicalDeviceTensorFeaturesARM::descriptorBindingStorageTensorUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_TENSOR_ARM must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingStorageTexelBufferUpdateAfterBind-03010", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingStorageTexelBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUniformBufferUpdateAfterBind-03005", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUniformBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUniformTexelBufferUpdateAfterBind-03009", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUniformTexelBufferUpdateAfterBind is not enabled, all bindings with descriptor type VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER must not use VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingUpdateUnusedWhilePending-03012", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingUpdateUnusedWhilePending is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-descriptorBindingVariableDescriptorCount-03014", "If VkPhysicalDeviceDescriptorIndexingFeatures::descriptorBindingVariableDescriptorCount is not enabled, all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-flags-03003", "If VkDescriptorSetLayoutCreateInfo::flags includes VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, then all elements of pBindingFlags must not include VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT, VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT, or VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-03004", "If an element of pBindingFlags includes VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, then it must be the element with the highest binding number", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-03015", "If an element of pBindingFlags includes VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT, that element's descriptorType must not be VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-pBindingFlags-parameter", "If bindingCount is not 0, pBindingFlags must be a valid pointer to an array of bindingCount valid combinations of VkDescriptorBindingFlagBits values", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutBindingFlagsCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-binding-00279", "If the perStageDescriptorSet feature is not enabled, or flags does not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, then the VkDescriptorSetLayoutBinding::binding members of the elements of the pBindings array must each have different values", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-descriptorType-03001", "If any binding has the VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT bit set, then all bindings must not have descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-descriptorType-04594", "If a binding has a descriptorType value of VK_DESCRIPTOR_TYPE_MUTABLE_EXT, then pImmutableSamplers must be NULL", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-00280", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, then all elements of pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-00281", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, then the total number of elements of all bindings must be less than or equal to VkPhysicalDevicePushDescriptorProperties::maxPushDescriptors", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-02208", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, then all elements of pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-03000", "If any binding has the VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT bit set, flags must include VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04590", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, flags must not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04591", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04592", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT, flags must not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-04596", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_EXT, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT::mutableDescriptorType must be enabled", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-08000", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT, then all elements of pBindings must not have a descriptorType of VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC or VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-08001", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_EMBEDDED_IMMUTABLE_SAMPLERS_BIT_EXT, flags must also contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-08002", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT, then flags must not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-08003", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_DESCRIPTOR_BUFFER_BIT_EXT, then flags must not contain VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-09463", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, then perStageDescriptorSet must be enabled", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-09464", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PER_STAGE_BIT_NV, then there must not be any two elements of the pBindings array with the same VkDescriptorSetLayoutBinding::binding value and their VkDescriptorSetLayoutBinding::stageFlags containing the same bit", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-10354", "If flags contains VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT, and the VK_KHR_push_descriptor extension is not enabled, pushDescriptor must be enabled", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-flags-parameter", "flags must be a valid combination of VkDescriptorSetLayoutCreateFlagBits values", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-mutableDescriptorType-04595", "If VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT::mutableDescriptorType is not enabled, pBindings must not contain a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-pBindings-07303", "If any element pBindings[i] has a descriptorType of VK_DESCRIPTOR_TYPE_MUTABLE_EXT, then the pNext chain must include a VkMutableDescriptorTypeCreateInfoEXT structure, and mutableDescriptorTypeListCount must be greater than i", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-pBindings-parameter", "If bindingCount is not 0, pBindings must be a valid pointer to an array of bindingCount valid VkDescriptorSetLayoutBinding structures", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDescriptorSetLayoutBindingFlagsCreateInfo or VkMutableDescriptorTypeCreateInfoEXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutCreateInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutHostMappingInfoVALVE-pNext-pNext", "pNext must be NULL", "appendices/extensions.html"},
    {"VUID-VkDescriptorSetLayoutHostMappingInfoVALVE-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_HOST_MAPPING_INFO_VALVE", "appendices/extensions.html"},
    {"VUID-VkDescriptorSetLayoutSupport-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDescriptorSetVariableDescriptorCountLayoutSupport", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutSupport-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetLayoutSupport-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-descriptorSetCount-03045", "If descriptorSetCount is not zero, descriptorSetCount must equal VkDescriptorSetAllocateInfo::descriptorSetCount", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-pDescriptorCounts-parameter", "If descriptorSetCount is not 0, pDescriptorCounts must be a valid pointer to an array of descriptorSetCount uint32_t values", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetVariableDescriptorCountAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorSetVariableDescriptorCountLayoutSupport-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-commonparent", "Both of descriptorSetLayout, and pipelineLayout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-descriptorUpdateEntryCount-arraylength", "descriptorUpdateEntryCount must be greater than 0", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-flags-zerobitmask", "flags must be 0", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-pDescriptorUpdateEntries-parameter", "pDescriptorUpdateEntries must be a valid pointer to an array of descriptorUpdateEntryCount valid VkDescriptorUpdateTemplateEntry structures", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-pNext-pNext", "pNext must be NULL", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00350", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET, descriptorSetLayout must be a valid VkDescriptorSetLayout handle", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00351", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS, pipelineBindPoint must be a valid VkPipelineBindPoint value", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00352", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS, pipelineLayout must be a valid VkPipelineLayout handle", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-00353", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS, set must be the unique set number in the pipeline layout that uses a descriptor set layout that was created with VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-04615", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET, descriptorSetLayout must not contain a binding with type VK_DESCRIPTOR_TYPE_MUTABLE_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-10355", "If templateType is VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS, and the VK_KHR_push_descriptor extension is not enabled, pushDescriptor must be enabled", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateCreateInfo-templateType-parameter", "templateType must be a valid VkDescriptorUpdateTemplateType value", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateEntry-descriptor-02226", "If descriptor type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, dstArrayElement must be an integer multiple of 4", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateEntry-descriptor-02227", "If descriptor type is VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK, descriptorCount must be an integer multiple of 4", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateEntry-descriptorType-parameter", "descriptorType must be a valid VkDescriptorType value", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateEntry-dstArrayElement-00355", "dstArrayElement and descriptorCount must be less than or equal to the number of array elements in the descriptor set binding implicitly specified when using a descriptor update template to update descriptors, and all applicable consecutive bindings", "chapters/descriptorsets.html"},
    {"VUID-VkDescriptorUpdateTemplateEntry-dstBinding-00354", "dstBinding must be a valid binding in the descriptor set layout implicitly specified when using a descriptor update template to update descriptors", "chapters/descriptorsets.html"},
    {"VUID-VkDeviceAddressBindingCallbackDataEXT-bindingType-parameter", "bindingType must be a valid VkDeviceAddressBindingTypeEXT value", "chapters/debugging.html"},
    {"VUID-VkDeviceAddressBindingCallbackDataEXT-flags-parameter", "flags must be a valid combination of VkDeviceAddressBindingFlagBitsEXT values", "chapters/debugging.html"},
    {"VUID-VkDeviceAddressBindingCallbackDataEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_ADDRESS_BINDING_CALLBACK_DATA_EXT", "chapters/debugging.html"},
    {"VUID-VkDeviceBufferMemoryRequirements-pCreateInfo-parameter", "pCreateInfo must be a valid pointer to a valid VkBufferCreateInfo structure", "chapters/resources.html"},
    {"VUID-VkDeviceBufferMemoryRequirements-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkDeviceBufferMemoryRequirements-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS", "chapters/resources.html"},
    {"VUID-VkDeviceCreateInfo-None-04896", "If the sparseImageInt64Atomics feature is enabled, shaderImageInt64Atomics must be enabled", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-None-04897", "If the sparseImageFloat32Atomics feature is enabled, shaderImageFloat32Atomics must be enabled", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-None-04898", "If the sparseImageFloat32AtomicAdd feature is enabled, shaderImageFloat32AtomicAdd must be enabled", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-None-08095", "If the descriptorBuffer feature is enabled, ppEnabledExtensionNames must not contain VK_AMD_shader_fragment_mask", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-None-10778", "If the maintenance9 feature is not supported, queueCreateInfoCount must be greater than 0", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-flags-zerobitmask", "flags must be 0", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-fragmentDensityMap-04481", "If the fragmentDensityMap feature is enabled, the pipelineFragmentShadingRate feature must not be enabled", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-fragmentDensityMap-04482", "If the fragmentDensityMap feature is enabled, the primitiveFragmentShadingRate feature must not be enabled", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-fragmentDensityMap-04483", "If the fragmentDensityMap feature is enabled, the attachmentFragmentShadingRate feature must not be enabled", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-pEnabledFeatures-parameter", "If pEnabledFeatures is not NULL, pEnabledFeatures must be a valid pointer to a valid VkPhysicalDeviceFeatures structure", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-pNext-00373", "If the pNext chain includes a VkPhysicalDeviceFeatures2 structure, then pEnabledFeatures must be NULL", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-pNext-02829", "If the pNext chain includes a VkPhysicalDeviceVulkan11Features structure, then it must not include a VkPhysicalDevice16BitStorageFeatures, VkPhysicalDeviceMultiviewFeatures, VkPhysicalDeviceVariablePointersFeatures, VkPhysicalDeviceProtectedMemoryFeatures, VkPhysicalDeviceSamplerYcbcrConversionFeatures, or VkPhysicalDeviceShaderDrawParametersFeatures structure", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-pNext-02830", "If the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then it must not include a VkPhysicalDevice8BitStorageFeatures, VkPhysicalDeviceShaderAtomicInt64Features, VkPhysicalDeviceShaderFloat16Int8Features, VkPhysicalDeviceDescriptorIndexingFeatures, VkPhysicalDeviceScalarBlockLayoutFeatures, VkPhysicalDeviceImagelessFramebufferFeatures, VkPhysicalDeviceUniformBufferStandardLayoutFeatures, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures, VkPhysicalDeviceHostQueryResetFeatures, VkPhysicalDeviceTimelineSemaphoreFeatures, VkPhysicalDeviceBufferDeviceAddressFeatures, or VkPhysicalDeviceVulkanMemoryModelFeatures structure", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-pNext-04748", "If the pNext chain includes a VkPhysicalDeviceVulkan12Features structure and VkPhysicalDeviceVulkan12Features::bufferDeviceAddress is VK_TRUE, ppEnabledExtensionNames must not contain VK_EXT_buffer_device_address", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-pNext-06532", "If the pNext chain includes a VkPhysicalDeviceVulkan13Features structure, then it must not include a VkPhysicalDeviceDynamicRenderingFeatures, VkPhysicalDeviceImageRobustnessFeatures, VkPhysicalDeviceInlineUniformBlockFeatures, VkPhysicalDeviceMaintenance4Features, VkPhysicalDevicePipelineCreationCacheControlFeatures, VkPhysicalDevicePrivateDataFeatures, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures, VkPhysicalDeviceShaderIntegerDotProductFeatures, VkPhysicalDeviceShaderTerminateInvocationFeatures, VkPhysicalDeviceSubgroupSizeControlFeatures, VkPhysicalDeviceSynchronization2Features, VkPhysicalDeviceTextureCompressionASTCHDRFeatures, or VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures structure", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-pNext-09396", "If the pNext chain includes a VkDeviceQueueShaderCoreControlCreateInfoARM structure, then it must not be included in the pNext chain of any of the VkDeviceQueueCreateInfo structures in pQueueCreateInfos", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-pNext-09397", "If the pNext chain includes a VkDeviceQueueShaderCoreControlCreateInfoARM structure then VkPhysicalDeviceSchedulingControlsPropertiesARM::schedulingControlsFlags must contain VK_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_SHADER_CORE_COUNT_ARM", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-pNext-10360", "If the pNext chain includes a VkPhysicalDeviceVulkan14Features structure, then it must not include a VkPhysicalDeviceGlobalPriorityQueryFeatures, VkPhysicalDeviceShaderSubgroupRotateFeatures, VkPhysicalDeviceShaderFloatControls2Features, VkPhysicalDeviceShaderExpectAssumeFeatures, VkPhysicalDeviceLineRasterizationFeatures, VkPhysicalDeviceVertexAttributeDivisorFeatures, VkPhysicalDeviceIndexTypeUint8Features, VkPhysicalDeviceDynamicRenderingLocalReadFeatures, VkPhysicalDeviceMaintenance5Features, VkPhysicalDeviceMaintenance6Features, VkPhysicalDevicePipelineProtectedAccessFeatures, VkPhysicalDevicePipelineRobustnessFeatures, or VkPhysicalDeviceHostImageCopyFeatures structure", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid struct for extending VkDeviceCreateInfo", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-pProperties-04451", "If the VK_KHR_portability_subset extension is included in pProperties of vkEnumerateDeviceExtensionProperties, ppEnabledExtensionNames must include \"VK_KHR_portability_subset\"", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-pQueueCreateInfos-06654", "If multiple elements of pQueueCreateInfos share the same queueFamilyIndex, then all of such elements must have the same global priority level, which can be specified explicitly by the including a VkDeviceQueueGlobalPriorityCreateInfo structure in the pNext chain, or by the implicit default value", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-pQueueCreateInfos-06755", "If multiple elements of pQueueCreateInfos share the same queueFamilyIndex, the sum of their queueCount members must be less than or equal to the queueCount member of the VkQueueFamilyProperties structure, as returned by vkGetPhysicalDeviceQueueFamilyProperties in the pQueueFamilyProperties[queueFamilyIndex]", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-pQueueCreateInfos-parameter", "If queueCreateInfoCount is not 0, pQueueCreateInfos must be a valid pointer to an array of queueCreateInfoCount valid VkDeviceQueueCreateInfo structures", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-00374", "ppEnabledExtensionNames must not contain both VK_KHR_maintenance1 and VK_AMD_negative_viewport_height", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-01840", "If VkPhysicalDeviceProperties::apiVersion advertises Vulkan 1.1 or later, ppEnabledExtensionNames must not contain VK_AMD_negative_viewport_height", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02831", "If ppEnabledExtensionNames contains \"VK_KHR_draw_indirect_count\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::drawIndirectCount must be VK_TRUE", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02832", "If ppEnabledExtensionNames contains \"VK_KHR_sampler_mirror_clamp_to_edge\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::samplerMirrorClampToEdge must be VK_TRUE", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02833", "If ppEnabledExtensionNames contains \"VK_EXT_descriptor_indexing\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::descriptorIndexing must be VK_TRUE", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02834", "If ppEnabledExtensionNames contains \"VK_EXT_sampler_filter_minmax\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::samplerFilterMinmax must be VK_TRUE", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-02835", "If ppEnabledExtensionNames contains \"VK_EXT_shader_viewport_index_layer\" and the pNext chain includes a VkPhysicalDeviceVulkan12Features structure, then VkPhysicalDeviceVulkan12Features::shaderOutputViewportIndex and VkPhysicalDeviceVulkan12Features::shaderOutputLayer must both be VK_TRUE", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-03328", "ppEnabledExtensionNames must not contain both VK_KHR_buffer_device_address and VK_EXT_buffer_device_address", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-04476", "If ppEnabledExtensionNames contains \"VK_KHR_shader_draw_parameters\" and the pNext chain includes a VkPhysicalDeviceVulkan11Features structure, then VkPhysicalDeviceVulkan11Features::shaderDrawParameters must be VK_TRUE", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-ppEnabledExtensionNames-parameter", "If enabledExtensionCount is not 0, ppEnabledExtensionNames must be a valid pointer to an array of enabledExtensionCount null-terminated UTF-8 strings", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-ppEnabledLayerNames-parameter", "If enabledLayerCount is not 0, ppEnabledLayerNames must be a valid pointer to an array of enabledLayerCount null-terminated UTF-8 strings", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-queueFamilyIndex-02802", "The queueFamilyIndex member of each element of pQueueCreateInfos must be unique within pQueueCreateInfos , except that two members can share the same queueFamilyIndex if one describes protected-capable queues and one describes queues that are not protected-capable", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-robustBufferAccess-10247", "If the robustBufferAccess feature is enabled, and robustBufferAccessUpdateAfterBind is VK_FALSE, then descriptorBindingUniformBufferUpdateAfterBind, descriptorBindingStorageBufferUpdateAfterBind, descriptorBindingUniformTexelBufferUpdateAfterBind, and descriptorBindingStorageTexelBufferUpdateAfterBind must not be enabled", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique, with the exception of structures of type VkDeviceDeviceMemoryReportCreateInfoEXT or VkDevicePrivateDataCreateInfo", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-shadingRateImage-04478", "If the shadingRateImage feature is enabled, the pipelineFragmentShadingRate feature must not be enabled", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-shadingRateImage-04479", "If the shadingRateImage feature is enabled, the primitiveFragmentShadingRate feature must not be enabled", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-shadingRateImage-04480", "If the shadingRateImage feature is enabled, the attachmentFragmentShadingRate feature must not be enabled", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceCreateInfo-sparseImageFloat32AtomicMinMax-04975", "If the sparseImageFloat32AtomicMinMax feature is enabled, shaderImageFloat32AtomicMinMax must be enabled", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-flags-zerobitmask", "flags must be 0", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-pUserData-parameter", "pUserData must be a pointer value", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-pfnUserCallback-parameter", "pfnUserCallback must be a valid PFN_vkDeviceMemoryReportCallbackEXT value", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceDeviceMemoryReportCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceDiagnosticsConfigCreateInfoNV-flags-parameter", "flags must be a valid combination of VkDeviceDiagnosticsConfigFlagBitsNV values", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceDiagnosticsConfigCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceEventInfoEXT-deviceEvent-parameter", "deviceEvent must be a valid VkDeviceEventTypeEXT value", "chapters/synchronization.html"},
    {"VUID-VkDeviceEventInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/synchronization.html"},
    {"VUID-VkDeviceEventInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT", "chapters/synchronization.html"},
    {"VUID-VkDeviceFaultAddressInfoEXT-addressType-parameter", "addressType must be a valid VkDeviceFaultAddressTypeEXT value", "chapters/debugging.html"},
    {"VUID-VkDeviceFaultCountsEXT-pNext-pNext", "pNext must be NULL", "chapters/debugging.html"},
    {"VUID-VkDeviceFaultCountsEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_FAULT_COUNTS_EXT", "chapters/debugging.html"},
    {"VUID-VkDeviceFaultInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/debugging.html"},
    {"VUID-VkDeviceFaultInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_FAULT_INFO_EXT", "chapters/debugging.html"},
    {"VUID-VkDeviceFaultVendorBinaryHeaderVersionOneEXT-headerSize-07340", "headerSize must be 56", "chapters/debugging.html"},
    {"VUID-VkDeviceFaultVendorBinaryHeaderVersionOneEXT-headerVersion-07341", "headerVersion must be VK_DEVICE_FAULT_VENDOR_BINARY_HEADER_VERSION_ONE_EXT", "chapters/debugging.html"},
    {"VUID-VkDeviceFaultVendorBinaryHeaderVersionOneEXT-headerVersion-parameter", "headerVersion must be a valid VkDeviceFaultVendorBinaryHeaderVersionEXT value", "chapters/debugging.html"},
    {"VUID-VkDeviceGroupBindSparseInfo-memoryDeviceIndex-01119", "Each memory allocation bound in this batch must have allocated an instance for memoryDeviceIndex", "chapters/sparsemem.html"},
    {"VUID-VkDeviceGroupBindSparseInfo-resourceDeviceIndex-01118", "resourceDeviceIndex and memoryDeviceIndex must both be valid device indices", "chapters/sparsemem.html"},
    {"VUID-VkDeviceGroupBindSparseInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO", "chapters/sparsemem.html"},
    {"VUID-VkDeviceGroupCommandBufferBeginInfo-deviceMask-00106", "deviceMask must be a valid device mask value", "chapters/cmdbuffers.html"},
    {"VUID-VkDeviceGroupCommandBufferBeginInfo-deviceMask-00107", "deviceMask must not be zero", "chapters/cmdbuffers.html"},
    {"VUID-VkDeviceGroupCommandBufferBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO", "chapters/cmdbuffers.html"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-00375", "Each element of pPhysicalDevices must be unique", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-00376", "All elements of pPhysicalDevices must be in the same device group as enumerated by vkEnumeratePhysicalDeviceGroups", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-pPhysicalDevices-parameter", "If physicalDeviceCount is not 0, pPhysicalDevices must be a valid pointer to an array of physicalDeviceCount valid VkPhysicalDevice handles", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-physicalDeviceCount-00377", "If physicalDeviceCount is not 0, the physicalDevice parameter of vkCreateDevice must be an element of pPhysicalDevices", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceGroupDeviceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceGroupPresentCapabilitiesKHR-pNext-pNext", "pNext must be NULL", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceGroupPresentCapabilitiesKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01298", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR, then each element of pDeviceMasks must have exactly one bit set, and the corresponding element of VkDeviceGroupPresentCapabilitiesKHR::presentMask must be non-zero", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01299", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR, then each element of pDeviceMasks must have exactly one bit set, and some physical device in the logical device must include that bit in its VkDeviceGroupPresentCapabilitiesKHR::presentMask", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01300", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR, then each element of pDeviceMasks must have a value for which all set bits are set in one of the elements of VkDeviceGroupPresentCapabilitiesKHR::presentMask", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01301", "If mode is VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR, then for each bit set in each element of pDeviceMasks, the corresponding element of VkDeviceGroupPresentCapabilitiesKHR::presentMask must be non-zero", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-01303", "mode must have exactly one bit set, and that bit must have been included in VkDeviceGroupSwapchainCreateInfoKHR::modes", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceGroupPresentInfoKHR-mode-parameter", "mode must be a valid VkDeviceGroupPresentModeFlagBitsKHR value", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceGroupPresentInfoKHR-pDeviceMasks-01302", "The value of each element of pDeviceMasks must be equal to the device mask passed in VkAcquireNextImageInfoKHR::deviceMask when the image index was last acquired", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceGroupPresentInfoKHR-pDeviceMasks-parameter", "If swapchainCount is not 0, pDeviceMasks must be a valid pointer to an array of swapchainCount uint32_t values", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceGroupPresentInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceGroupPresentInfoKHR-swapchainCount-01297", "swapchainCount must equal 0 or VkPresentInfoKHR::swapchainCount", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00905", "deviceMask must be a valid device mask value", "chapters/renderpass.html"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00906", "deviceMask must not be zero", "chapters/renderpass.html"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceMask-00907", "deviceMask must be a subset of the command buffer's initial device mask", "chapters/renderpass.html"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-deviceRenderAreaCount-00908", "deviceRenderAreaCount must either be zero or equal to the number of physical devices in the logical device", "chapters/renderpass.html"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-extent-08998", "The extent.width member of any element of pDeviceRenderAreas must be greater than 0", "chapters/renderpass.html"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-extent-08999", "The extent.height member of any element of pDeviceRenderAreas must be greater than 0", "chapters/renderpass.html"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-offset-06166", "The offset.x member of any element of pDeviceRenderAreas must be greater than or equal to 0", "chapters/renderpass.html"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-offset-06167", "The offset.y member of any element of pDeviceRenderAreas must be greater than or equal to 0", "chapters/renderpass.html"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-offset-06168", "The sum of the offset.x and extent.width members of any element of pDeviceRenderAreas must be less than or equal to maxFramebufferWidth", "chapters/renderpass.html"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-offset-06169", "The sum of the offset.y and extent.height members of any element of pDeviceRenderAreas must be less than or equal to maxFramebufferHeight", "chapters/renderpass.html"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-pDeviceRenderAreas-parameter", "If deviceRenderAreaCount is not 0, pDeviceRenderAreas must be a valid pointer to an array of deviceRenderAreaCount VkRect2D structures", "chapters/renderpass.html"},
    {"VUID-VkDeviceGroupRenderPassBeginInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO", "chapters/renderpass.html"},
    {"VUID-VkDeviceGroupSubmitInfo-commandBufferCount-00083", "commandBufferCount must equal VkSubmitInfo::commandBufferCount", "chapters/cmdbuffers.html"},
    {"VUID-VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks-00086", "All elements of pCommandBufferDeviceMasks must be valid device masks", "chapters/cmdbuffers.html"},
    {"VUID-VkDeviceGroupSubmitInfo-pCommandBufferDeviceMasks-parameter", "If commandBufferCount is not 0, pCommandBufferDeviceMasks must be a valid pointer to an array of commandBufferCount uint32_t values", "chapters/cmdbuffers.html"},
    {"VUID-VkDeviceGroupSubmitInfo-pSignalSemaphoreDeviceIndices-parameter", "If signalSemaphoreCount is not 0, pSignalSemaphoreDeviceIndices must be a valid pointer to an array of signalSemaphoreCount uint32_t values", "chapters/cmdbuffers.html"},
    {"VUID-VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices-00085", "All elements of pWaitSemaphoreDeviceIndices and pSignalSemaphoreDeviceIndices must be valid device indices", "chapters/cmdbuffers.html"},
    {"VUID-VkDeviceGroupSubmitInfo-pWaitSemaphoreDeviceIndices-parameter", "If waitSemaphoreCount is not 0, pWaitSemaphoreDeviceIndices must be a valid pointer to an array of waitSemaphoreCount uint32_t values", "chapters/cmdbuffers.html"},
    {"VUID-VkDeviceGroupSubmitInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO", "chapters/cmdbuffers.html"},
    {"VUID-VkDeviceGroupSubmitInfo-signalSemaphoreCount-00084", "signalSemaphoreCount must equal VkSubmitInfo::signalSemaphoreCount", "chapters/cmdbuffers.html"},
    {"VUID-VkDeviceGroupSubmitInfo-waitSemaphoreCount-00082", "waitSemaphoreCount must equal VkSubmitInfo::waitSemaphoreCount", "chapters/cmdbuffers.html"},
    {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-parameter", "modes must be a valid combination of VkDeviceGroupPresentModeFlagBitsKHR values", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-modes-requiredbitmask", "modes must not be 0", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceGroupSwapchainCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06416", "The pCreateInfo->pNext chain must not contain a VkImageSwapchainCreateInfoKHR structure", "chapters/resources.html"},
    {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06417", "If pCreateInfo->format specifies a multi-planar format and pCreateInfo->flags has VK_IMAGE_CREATE_DISJOINT_BIT set then planeAspect must not be VK_IMAGE_ASPECT_NONE_KHR", "chapters/resources.html"},
    {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06419", "If pCreateInfo->flags has VK_IMAGE_CREATE_DISJOINT_BIT set and if the pCreateInfo->tiling is VK_IMAGE_TILING_LINEAR or VK_IMAGE_TILING_OPTIMAL, then planeAspect must be a single valid multi-planar aspect mask bit", "chapters/resources.html"},
    {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06420", "If pCreateInfo->tiling is VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT, then planeAspect must be a single valid memory plane for the image (that is, aspectMask must specify a plane index that is less than the VkDrmFormatModifierPropertiesEXT::drmFormatModifierPlaneCount associated with the image's format and VkImageDrmFormatModifierPropertiesEXT::drmFormatModifier)", "chapters/resources.html"},
    {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-06776", "The pCreateInfo->pNext chain must not contain a VkImageDrmFormatModifierExplicitCreateInfoEXT structure", "chapters/resources.html"},
    {"VUID-VkDeviceImageMemoryRequirements-pCreateInfo-parameter", "pCreateInfo must be a valid pointer to a valid VkImageCreateInfo structure", "chapters/resources.html"},
    {"VUID-VkDeviceImageMemoryRequirements-pNext-06996", "Applications also must not call vkGetDeviceImageMemoryRequirements with a VkImageCreateInfo whose pNext chain includes a VkExternalFormatANDROID structure with non-zero externalFormat", "chapters/resources.html"},
    {"VUID-VkDeviceImageMemoryRequirements-pNext-08962", "Applications also must not call vkGetDeviceImageMemoryRequirements with a VkImageCreateInfo whose pNext chain includes a VkExternalFormatQNX structure with non-zero externalFormat", "chapters/resources.html"},
    {"VUID-VkDeviceImageMemoryRequirements-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkDeviceImageMemoryRequirements-planeAspect-parameter", "If planeAspect is not 0, planeAspect must be a valid VkImageAspectFlagBits value", "chapters/resources.html"},
    {"VUID-VkDeviceImageMemoryRequirements-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS", "chapters/resources.html"},
    {"VUID-VkDeviceImageSubresourceInfo-arrayLayer-01717", "The arrayLayer member of pSubresource must be less than the arrayLayers specified in pCreateInfo", "chapters/resources.html"},
    {"VUID-VkDeviceImageSubresourceInfo-aspectMask-00997", "The aspectMask member of pSubresource must only have a single bit set", "chapters/resources.html"},
    {"VUID-VkDeviceImageSubresourceInfo-format-04462", "If format of the pCreateInfo has a depth component, the aspectMask member of pSubresource must contain VK_IMAGE_ASPECT_DEPTH_BIT", "chapters/resources.html"},
    {"VUID-VkDeviceImageSubresourceInfo-format-04463", "If format of the pCreateInfo has a stencil component, the aspectMask member of pSubresource must contain VK_IMAGE_ASPECT_STENCIL_BIT", "chapters/resources.html"},
    {"VUID-VkDeviceImageSubresourceInfo-format-04464", "If format of the pCreateInfo does not contain a stencil or depth component, the aspectMask member of pSubresource must not contain VK_IMAGE_ASPECT_DEPTH_BIT or VK_IMAGE_ASPECT_STENCIL_BIT", "chapters/resources.html"},
    {"VUID-VkDeviceImageSubresourceInfo-format-08886", "If format of the image is a color format that is not a multi-planar format, and tiling of the pCreateInfo is VK_IMAGE_TILING_LINEAR or VK_IMAGE_TILING_OPTIMAL, the aspectMask member of pSubresource must be VK_IMAGE_ASPECT_COLOR_BIT", "chapters/resources.html"},
    {"VUID-VkDeviceImageSubresourceInfo-mipLevel-01716", "The mipLevel member of pSubresource must be less than the mipLevels specified in pCreateInfo", "chapters/resources.html"},
    {"VUID-VkDeviceImageSubresourceInfo-pCreateInfo-parameter", "pCreateInfo must be a valid pointer to a valid VkImageCreateInfo structure", "chapters/resources.html"},
    {"VUID-VkDeviceImageSubresourceInfo-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkDeviceImageSubresourceInfo-pSubresource-parameter", "pSubresource must be a valid pointer to a valid VkImageSubresource2 structure", "chapters/resources.html"},
    {"VUID-VkDeviceImageSubresourceInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO", "chapters/resources.html"},
    {"VUID-VkDeviceImageSubresourceInfo-tiling-08717", "If the tiling of the pCreateInfo is VK_IMAGE_TILING_LINEAR and has a multi-planar format, then the aspectMask member of pSubresource must be a single valid multi-planar aspect mask bit", "chapters/resources.html"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-memory-03336", "memory must have been allocated with VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT", "chapters/memory.html"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-memory-parameter", "memory must be a valid VkDeviceMemory handle", "chapters/memory.html"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-pNext-pNext", "pNext must be NULL", "chapters/memory.html"},
    {"VUID-VkDeviceMemoryOpaqueCaptureAddressInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO", "chapters/memory.html"},
    {"VUID-VkDeviceMemoryOverallocationCreateInfoAMD-overallocationBehavior-parameter", "overallocationBehavior must be a valid VkMemoryOverallocationBehaviorAMD value", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceMemoryOverallocationCreateInfoAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceMemoryReportCallbackDataEXT-pNext-pNext", "pNext must be NULL", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceMemoryReportCallbackDataEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT", "chapters/devsandqueues.html"},
    {"VUID-VkDevicePipelineBinaryInternalCacheControlKHR-disableInternalCache-09602", "If VkPhysicalDevicePipelineBinaryPropertiesKHR::pipelineBinaryInternalCacheControl is VK_FALSE, disableInternalCache must be VK_FALSE", "chapters/devsandqueues.html"},
    {"VUID-VkDevicePipelineBinaryInternalCacheControlKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_PIPELINE_BINARY_INTERNAL_CACHE_CONTROL_KHR", "chapters/devsandqueues.html"},
    {"VUID-VkDevicePrivateDataCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueCreateInfo-flags-02861", "If the protectedMemory feature is not enabled, the VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT bit of flags must not be set", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueCreateInfo-flags-06449", "If flags includes VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT, queueFamilyIndex must be the index of a queue family that includes the VK_QUEUE_PROTECTED_BIT capability", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueCreateInfo-flags-parameter", "flags must be a valid combination of VkDeviceQueueCreateFlagBits values", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueCreateInfo-pNext-09398", "If the pNext chain includes a VkDeviceQueueShaderCoreControlCreateInfoARM structure then VkPhysicalDeviceSchedulingControlsPropertiesARM::schedulingControlsFlags must contain VK_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_SHADER_CORE_COUNT_ARM", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDeviceQueueGlobalPriorityCreateInfo or VkDeviceQueueShaderCoreControlCreateInfoARM", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueCreateInfo-pQueuePriorities-00383", "Each element of pQueuePriorities must be between 0.0 and 1.0 inclusive", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueCreateInfo-pQueuePriorities-parameter", "pQueuePriorities must be a valid pointer to an array of queueCount float values", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueCreateInfo-queueCount-00382", "queueCount must be less than or equal to the queueCount member of the VkQueueFamilyProperties structure, as returned by vkGetPhysicalDeviceQueueFamilyProperties in the pQueueFamilyProperties[queueFamilyIndex]", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueCreateInfo-queueCount-arraylength", "queueCount must be greater than 0", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueCreateInfo-queueFamilyIndex-00381", "queueFamilyIndex must be less than pQueueFamilyPropertyCount returned by vkGetPhysicalDeviceQueueFamilyProperties", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueCreateInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueGlobalPriorityCreateInfo-globalPriority-parameter", "globalPriority must be a valid VkQueueGlobalPriority value", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueGlobalPriorityCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueInfo2-flags-06225", "flags must be equal to VkDeviceQueueCreateInfo::flags for a VkDeviceQueueCreateInfo structure for the queue family indicated by queueFamilyIndex when device was created", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueInfo2-flags-parameter", "flags must be a valid combination of VkDeviceQueueCreateFlagBits values", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueInfo2-pNext-pNext", "pNext must be NULL", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueInfo2-queueFamilyIndex-01842", "queueFamilyIndex must be one of the queue family indices specified when device was created, via the VkDeviceQueueCreateInfo structure", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueInfo2-queueIndex-01843", "queueIndex must be less than VkDeviceQueueCreateInfo::queueCount for the corresponding queue family and flags indicated by queueFamilyIndex and flags when device was created", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueInfo2-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueShaderCoreControlCreateInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_QUEUE_SHADER_CORE_CONTROL_CREATE_INFO_ARM", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceQueueShaderCoreControlCreateInfoARM-shaderCoreCount-09399", "shaderCoreCount must be greater than 0 and less than or equal to the total number of shader cores as reported via VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM::shaderCoreCount", "chapters/devsandqueues.html"},
    {"VUID-VkDeviceTensorMemoryRequirementsARM-pCreateInfo-parameter", "pCreateInfo must be a valid pointer to a valid VkTensorCreateInfoARM structure", "chapters/resources.html"},
    {"VUID-VkDeviceTensorMemoryRequirementsARM-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkDeviceTensorMemoryRequirementsARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DEVICE_TENSOR_MEMORY_REQUIREMENTS_ARM", "chapters/resources.html"},
    {"VUID-VkDirectDriverLoadingInfoLUNARG-flags-zerobitmask", "flags must be 0", "chapters/initialization.html"},
    {"VUID-VkDirectDriverLoadingInfoLUNARG-sType-sType", "sType must be VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG", "chapters/initialization.html"},
    {"VUID-VkDirectDriverLoadingListLUNARG-driverCount-arraylength", "driverCount must be greater than 0", "chapters/initialization.html"},
    {"VUID-VkDirectDriverLoadingListLUNARG-mode-parameter", "mode must be a valid VkDirectDriverLoadingModeLUNARG value", "chapters/initialization.html"},
    {"VUID-VkDirectDriverLoadingListLUNARG-pDrivers-parameter", "pDrivers must be a valid pointer to an array of driverCount valid VkDirectDriverLoadingInfoLUNARG structures", "chapters/initialization.html"},
    {"VUID-VkDirectDriverLoadingListLUNARG-sType-sType", "sType must be VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG", "chapters/initialization.html"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-dfb-04117", "dfb must point to a valid DirectFB IDirectFB", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-flags-zerobitmask", "flags must be 0", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDirectFBSurfaceCreateInfoEXT-surface-04118", "surface must point to a valid DirectFB IDirectFBSurface", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDispatchGraphInfoAMDX-payloadCount-09171", "payloadCount must be no greater than maxExecutionGraphShaderPayloadCount", "chapters/executiongraphs.html"},
    {"VUID-VkDispatchIndirectCommand-x-00417", "x must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[0]", "chapters/dispatch.html"},
    {"VUID-VkDispatchIndirectCommand-y-00418", "y must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[1]", "chapters/dispatch.html"},
    {"VUID-VkDispatchIndirectCommand-z-00419", "z must be less than or equal to VkPhysicalDeviceLimits::maxComputeWorkGroupCount[2]", "chapters/dispatch.html"},
    {"VUID-VkDispatchTileInfoQCOM-pNext-pNext", "pNext must be NULL", "chapters/dispatch.html"},
    {"VUID-VkDispatchTileInfoQCOM-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPATCH_TILE_INFO_QCOM", "chapters/dispatch.html"},
    {"VUID-VkDisplayEventInfoEXT-displayEvent-parameter", "displayEvent must be a valid VkDisplayEventTypeEXT value", "chapters/synchronization.html"},
    {"VUID-VkDisplayEventInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/synchronization.html"},
    {"VUID-VkDisplayEventInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT", "chapters/synchronization.html"},
    {"VUID-VkDisplayModeCreateInfoKHR-flags-zerobitmask", "flags must be 0", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayModeCreateInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayModeCreateInfoKHR-parameters-parameter", "parameters must be a valid VkDisplayModeParametersKHR structure", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayModeCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayModeParametersKHR-height-01991", "The height member of visibleRegion must be greater than 0", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayModeParametersKHR-refreshRate-01992", "refreshRate must be greater than 0", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayModeParametersKHR-width-01990", "The width member of visibleRegion must be greater than 0", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayModeProperties2KHR-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDisplayModeStereoPropertiesNV", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayModeProperties2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayModeProperties2KHR-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayModeStereoPropertiesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_MODE_STEREO_PROPERTIES_NV", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayNativeHdrSurfaceCapabilitiesAMD-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayPlaneCapabilities2KHR-pNext-pNext", "pNext must be NULL", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayPlaneCapabilities2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayPlaneInfo2KHR-mode-parameter", "mode must be a valid VkDisplayModeKHR handle", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayPlaneInfo2KHR-pNext-pNext", "pNext must be NULL", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayPlaneInfo2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayPlaneProperties2KHR-pNext-pNext", "pNext must be NULL", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayPlaneProperties2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayPowerInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayPowerInfoEXT-powerState-parameter", "powerState must be a valid VkDisplayPowerStateEXT value", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayPowerInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayPresentInfoKHR-dstRect-01258", "dstRect must specify a rectangular region that is a subset of the visibleRegion parameter of the display mode the swapchain being presented uses", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayPresentInfoKHR-persistentContent-01259", "If the persistentContent member of the VkDisplayPropertiesKHR structure returned by vkGetPhysicalDeviceDisplayPropertiesKHR for the display the present operation targets is VK_FALSE, then persistent must be VK_FALSE", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayPresentInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayPresentInfoKHR-srcRect-01257", "srcRect must specify a rectangular region that is a subset of the image being presented", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayProperties2KHR-pNext-pNext", "pNext must be NULL", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplayProperties2KHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-01254", "If alphaMode is VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR then globalAlpha must be between 0 and 1, inclusive", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-01255", "alphaMode must be one of the bits present in the supportedAlpha member of VkDisplayPlaneCapabilitiesKHR for the display plane corresponding to displayMode", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-alphaMode-parameter", "alphaMode must be a valid VkDisplayPlaneAlphaFlagBitsKHR value", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-displayMode-parameter", "displayMode must be a valid VkDisplayModeKHR handle", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-flags-zerobitmask", "flags must be 0", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-pNext-10284", "If the pNext chain includes a VkDisplaySurfaceStereoCreateInfoNV structure whose stereoType member is VK_DISPLAY_SURFACE_STEREO_TYPE_HDMI_3D_NV, then the hdmi3DSupported member of the VkDisplayModeStereoPropertiesNV structure in the pNext chain of the VkDisplayModeProperties2KHR structure returned by vkGetDisplayModeProperties2KHR for the display mode corresponding to displayMode must be VK_TRUE", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkDisplaySurfaceStereoCreateInfoNV", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-planeIndex-01252", "planeIndex must be less than the number of display planes supported by the device as determined by calling vkGetPhysicalDeviceDisplayPlanePropertiesKHR", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-planeReorderPossible-01253", "If the planeReorderPossible member of the VkDisplayPropertiesKHR structure returned by vkGetPhysicalDeviceDisplayPropertiesKHR for the display corresponding to displayMode is VK_TRUE then planeStackIndex must be less than the number of display planes supported by the device as determined by calling vkGetPhysicalDeviceDisplayPlanePropertiesKHR; otherwise planeStackIndex must equal the currentStackIndex member of VkDisplayPlanePropertiesKHR returned by vkGetPhysicalDeviceDisplayPlanePropertiesKHR for the display plane corresponding to displayMode", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-transform-06740", "transform must be one of the bits present in the supportedTransforms member of VkDisplayPropertiesKHR for the display corresponding to displayMode", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-transform-parameter", "transform must be a valid VkSurfaceTransformFlagBitsKHR value", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceCreateInfoKHR-width-01256", "The width and height members of imageExtent must be less than or equal to VkPhysicalDeviceLimits::maxImageDimension2D", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceStereoCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_DISPLAY_SURFACE_STEREO_CREATE_INFO_NV", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDisplaySurfaceStereoCreateInfoNV-stereoType-parameter", "stereoType must be a valid VkDisplaySurfaceStereoTypeNV value", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkDrawIndexedIndirectCommand-None-09462", "If shader objects are used for drawing or the bound graphics pipeline state was created with the VK_DYNAMIC_STATE_VERTEX_INPUT_EXT dynamic state enabled, any member of the pVertexBindingDescriptions parameter to the vkCmdSetVertexInputEXT call that sets this dynamic state has a value other than 1 in divisor, and VkPhysicalDeviceVertexAttributeDivisorProperties::supportsNonZeroFirstInstance is VK_FALSE, then firstInstance must be 0", "chapters/drawing.html"},
    {"VUID-VkDrawIndexedIndirectCommand-firstInstance-00554", "If the drawIndirectFirstInstance feature is not enabled, firstInstance must be 0", "chapters/drawing.html"},
    {"VUID-VkDrawIndexedIndirectCommand-pNext-09461", "If the bound graphics pipeline state was created with VkPipelineVertexInputDivisorStateCreateInfo in the pNext chain of VkGraphicsPipelineCreateInfo::pVertexInputState, any member of VkPipelineVertexInputDivisorStateCreateInfo::pVertexBindingDivisors has a value other than 1 in divisor, and VkPhysicalDeviceVertexAttributeDivisorProperties::supportsNonZeroFirstInstance is VK_FALSE, then firstInstance must be 0", "chapters/drawing.html"},
    {"VUID-VkDrawIndexedIndirectCommand-robustBufferAccess2-08798", "If the robustBufferAccess2 feature is not enabled, (indexSize x (firstIndex + indexCount) + offset) must be less than or equal to the size of the bound index buffer, with indexSize being based on the type specified by indexType, where the index buffer, indexType, and offset are specified via vkCmdBindIndexBuffer or vkCmdBindIndexBuffer2. If vkCmdBindIndexBuffer2 is used to bind the index buffer, the size of the bound index buffer is vkCmdBindIndexBuffer2::size", "chapters/drawing.html"},
    {"VUID-VkDrawIndirectCommand-None-09462", "If shader objects are used for drawing or the bound graphics pipeline state was created with the VK_DYNAMIC_STATE_VERTEX_INPUT_EXT dynamic state enabled, any member of the pVertexBindingDescriptions parameter to the vkCmdSetVertexInputEXT call that sets this dynamic state has a value other than 1 in divisor, and VkPhysicalDeviceVertexAttributeDivisorProperties::supportsNonZeroFirstInstance is VK_FALSE, then firstInstance must be 0", "chapters/drawing.html"},
    {"VUID-VkDrawIndirectCommand-firstInstance-00501", "If the drawIndirectFirstInstance feature is not enabled, firstInstance must be 0", "chapters/drawing.html"},
    {"VUID-VkDrawIndirectCommand-pNext-09461", "If the bound graphics pipeline state was created with VkPipelineVertexInputDivisorStateCreateInfo in the pNext chain of VkGraphicsPipelineCreateInfo::pVertexInputState, any member of VkPipelineVertexInputDivisorStateCreateInfo::pVertexBindingDivisors has a value other than 1 in divisor, and VkPhysicalDeviceVertexAttributeDivisorProperties::supportsNonZeroFirstInstance is VK_FALSE, then firstInstance must be 0", "chapters/drawing.html"},
    {"VUID-VkDrawIndirectCountIndirectCommandEXT-None-11122", "The buffer's usage flag from which the address was acquired must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkDrawIndirectCountIndirectCommandEXT-None-11123", "Each element of the buffer from which the address was acquired and that is non-sparse must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07322", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS contains a shader using the TaskEXT Execution Model, groupCountX must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupCount[0]", "chapters/drawing.html"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07323", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS contains a shader using the TaskEXT Execution Model, groupCountY must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupCount[1]", "chapters/drawing.html"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07324", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS contains a shader using the TaskEXT Execution Model, groupCountZ must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupCount[2]", "chapters/drawing.html"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07325", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS contains a shader using the TaskEXT Execution Model, The product of groupCountX, groupCountY and groupCountZ must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxTaskWorkGroupTotalCount", "chapters/drawing.html"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07326", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS does not contain a shader using the TaskEXT Execution Model, groupCountX must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[0]", "chapters/drawing.html"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07327", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS does not contain a shader using the TaskEXT Execution Model, groupCountY must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[1]", "chapters/drawing.html"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07328", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS does not contain a shader using the TaskEXT Execution Model, groupCountZ must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupCount[2]", "chapters/drawing.html"},
    {"VUID-VkDrawMeshTasksIndirectCommandEXT-TaskEXT-07329", "If the current pipeline bound to VK_PIPELINE_BIND_POINT_GRAPHICS does not contain a shader using the TaskEXT Execution Model, The product of groupCountX, groupCountY and groupCountZ must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesEXT::maxMeshWorkGroupTotalCount", "chapters/drawing.html"},
    {"VUID-VkDrawMeshTasksIndirectCommandNV-taskCount-02175", "taskCount must be less than or equal to VkPhysicalDeviceMeshShaderPropertiesNV::maxDrawMeshTasksCount", "chapters/drawing.html"},
    {"VUID-VkDrmFormatModifierPropertiesList2EXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT", "chapters/formats.html"},
    {"VUID-VkDrmFormatModifierPropertiesListEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT", "chapters/formats.html"},
    {"VUID-VkEventCreateInfo-flags-parameter", "flags must be a valid combination of VkEventCreateFlagBits values", "chapters/synchronization.html"},
    {"VUID-VkEventCreateInfo-pNext-06790", "If the pNext chain includes a VkExportMetalObjectCreateInfoEXT structure, its exportObjectType member must be VK_EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT", "chapters/synchronization.html"},
    {"VUID-VkEventCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExportMetalObjectCreateInfoEXT or VkImportMetalSharedEventInfoEXT", "chapters/synchronization.html"},
    {"VUID-VkEventCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EVENT_CREATE_INFO", "chapters/synchronization.html"},
    {"VUID-VkEventCreateInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique, with the exception of structures of type VkExportMetalObjectCreateInfoEXT", "chapters/synchronization.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-CoalescedInputCountAMDX-09137", "There must be no two nodes in the pipeline that share the same name where one includes CoalescedInputCountAMDX and the other does not", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-09134", "There must be no two nodes in the pipeline that share both the same shader name and index, as specified by VkPipelineShaderStageNodeCreateInfoAMDX", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-09135", "There must be no two nodes in the pipeline that share the same shader name and have input payload declarations with different sizes", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-09136", "There must be no two nodes in the pipeline that share the same name but have different execution models", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-09497", "If the pNext chain does not include a VkPipelineCreateFlags2CreateInfo structure, flags must be a valid combination of VkPipelineCreateFlagBits values", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-None-10391", "If a resource variables is declared in a shader as an array of descriptors, then the descriptor type of that variable must not be VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-PayloadNodeNameAMDX-09139", "If an output payload declared in any shader in the pipeline has a PayloadNodeNameAMDX decoration with a Node Name that matches the shader name of any other node in the graph, the size of the output payload must match the size of the input payload in the matching node", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-StaticNumWorkgroupsAMDX-09138", "There must be no two nodes in the pipeline that share the same name where one includes StaticNumWorkgroupsAMDX and the other does not", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-commonparent", "Both of basePipelineHandle, and layout that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03365", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03366", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03367", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03368", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03369", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03370", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-03576", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-04945", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-07984", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid execution graph VkPipeline handle", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-07985", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-07986", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, basePipelineIndex must be -1 or basePipelineHandle must be VK_NULL_HANDLE", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-09007", "If the VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV::deviceGeneratedComputePipelines feature is not enabled, flags must not include VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-09008", "If flags includes VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then the pNext chain must include a pointer to a valid instance of VkComputePipelineIndirectBufferInfoNV specifying the address where the pipeline's metadata will be saved", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-10184", "If flags does not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, and an output payload declared in any shader in the pipeline does not have a PayloadNodeSparseArrayAMDX decoration, there must be a node in the graph corresponding to every index from 0 to its PayloadNodeArraySizeAMDX decoration", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-flags-11007", "If flags includes VK_PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_EXT, then the VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT::deviceGeneratedCommands feature must be enabled", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-07987", "If a push constant block is declared in a shader, a push constant range in layout must match the shader stage", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-07988", "If a resource variable is declared in a shader, the corresponding descriptor set in layout must match the shader stage", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-07990", "If a resource variable is declared in a shader, and the descriptor type is not VK_DESCRIPTOR_TYPE_MUTABLE_EXT, the corresponding descriptor set in layout must match the descriptor type", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-07991", "If a resource variable is declared in a shader as an array, the corresponding descriptor set in layout must match the descriptor count", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-09130", "layout must be consistent with the layout of the shaders specified in pStages", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-09132", "The number of resources in layout accessible to each shader stage that is used by the pipeline must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-10069", "If a push constant block is declared in a shader, the block must be contained inside the push constant range in layout that matches the stage", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-layout-parameter", "layout must be a valid VkPipelineLayout handle", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pLibraryInfo-09131", "If pLibraryInfo is not NULL, each element of its pLibraries member must have been created with a layout that is compatible with the layout in this pipeline", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pLibraryInfo-09133", "If pLibraryInfo is not NULL, each element of pLibraryInfo->pLibraries must be either a compute pipeline, an execution graph pipeline, or a graphics pipeline", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pLibraryInfo-10181", "If pLibraryInfo is not NULL, each element of pLibraryInfo->pLibraries that is a compute pipeline or a graphics pipeline must have been created with VK_PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX set", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pLibraryInfo-10183", "Any element of pLibraryInfo->pLibraries identifying a graphics pipeline must have been created with all possible state subsets", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pLibraryInfo-parameter", "If pLibraryInfo is not NULL, pLibraryInfo must be a valid pointer to a valid VkPipelineLibraryCreateInfoKHR structure", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkPipelineCompilerControlCreateInfoAMD or VkPipelineCreationFeedbackCreateInfo", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pStages-09129", "The shader code for the entry point identified by each element of pStages and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pStages-parameter", "If stageCount is not 0, and pStages is not NULL, pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-pipelineCreationCacheControl-02875", "If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT or VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_CREATE_INFO_AMDX", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-shaderMeshEnqueue-10182", "If the shaderMeshEnqueue feature is not enabled, and pLibraryInfo->pLibraries is not NULL, pLibraryInfo->pLibraries must not contain any graphics pipelines", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineCreateInfoAMDX-stage-09128", "The stage member of any element of pStages must be VK_SHADER_STAGE_COMPUTE_BIT", "chapters/executiongraphs.html"},
    {"VUID-VkExecutionGraphPipelineScratchSizeAMDX-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXECUTION_GRAPH_PIPELINE_SCRATCH_SIZE_AMDX", "chapters/executiongraphs.html"},
    {"VUID-VkExportFenceCreateInfo-handleTypes-01446", "The bits in handleTypes must be supported and compatible, as reported by VkExternalFenceProperties", "chapters/synchronization.html"},
    {"VUID-VkExportFenceCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalFenceHandleTypeFlagBits values", "chapters/synchronization.html"},
    {"VUID-VkExportFenceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO", "chapters/synchronization.html"},
    {"VUID-VkExportFenceWin32HandleInfoKHR-handleTypes-01447", "If VkExportFenceCreateInfo::handleTypes does not include VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT, a VkExportFenceWin32HandleInfoKHR structure must not be included in the pNext chain of VkFenceCreateInfo", "chapters/synchronization.html"},
    {"VUID-VkExportFenceWin32HandleInfoKHR-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", "chapters/synchronization.html"},
    {"VUID-VkExportFenceWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR", "chapters/synchronization.html"},
    {"VUID-VkExportMemoryAllocateInfo-handleTypes-09860", "The bits in handleTypes must be supported and compatible, as reported by VkExternalTensorPropertiesARM, VkExternalImageFormatProperties, or VkExternalBufferProperties", "chapters/memory.html"},
    {"VUID-VkExportMemoryAllocateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values", "chapters/memory.html"},
    {"VUID-VkExportMemoryAllocateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO", "chapters/memory.html"},
    {"VUID-VkExportMemoryAllocateInfoNV-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBitsNV values", "chapters/memory.html"},
    {"VUID-VkExportMemoryAllocateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV", "chapters/memory.html"},
    {"VUID-VkExportMemoryWin32HandleInfoKHR-handleTypes-00657", "If VkExportMemoryAllocateInfo::handleTypes does not include VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT, a VkExportMemoryWin32HandleInfoKHR structure must not be included in the pNext chain of VkMemoryAllocateInfo", "chapters/memory.html"},
    {"VUID-VkExportMemoryWin32HandleInfoKHR-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", "chapters/memory.html"},
    {"VUID-VkExportMemoryWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR", "chapters/memory.html"},
    {"VUID-VkExportMemoryWin32HandleInfoNV-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", "chapters/memory.html"},
    {"VUID-VkExportMemoryWin32HandleInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV", "chapters/memory.html"},
    {"VUID-VkExportMetalBufferInfoEXT-memory-parameter", "memory must be a valid VkDeviceMemory handle", "chapters/memory.html"},
    {"VUID-VkExportMetalBufferInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_BUFFER_INFO_EXT", "chapters/memory.html"},
    {"VUID-VkExportMetalCommandQueueInfoEXT-queue-parameter", "queue must be a valid VkQueue handle", "chapters/memory.html"},
    {"VUID-VkExportMetalCommandQueueInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_COMMAND_QUEUE_INFO_EXT", "chapters/memory.html"},
    {"VUID-VkExportMetalDeviceInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_DEVICE_INFO_EXT", "chapters/memory.html"},
    {"VUID-VkExportMetalIOSurfaceInfoEXT-image-parameter", "image must be a valid VkImage handle", "chapters/memory.html"},
    {"VUID-VkExportMetalIOSurfaceInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_IO_SURFACE_INFO_EXT", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectCreateInfoEXT-exportObjectType-parameter", "If exportObjectType is not 0, exportObjectType must be a valid VkExportMetalObjectTypeFlagBitsEXT value", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECT_CREATE_INFO_EXT", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06791", "If the pNext chain includes a VkExportMetalDeviceInfoEXT structure, the VkInstance must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_DEVICE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkInstanceCreateInfo structure in the vkCreateInstance command", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06792", "If the pNext chain includes a VkExportMetalCommandQueueInfoEXT structure, the VkInstance must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_COMMAND_QUEUE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkInstanceCreateInfo structure in the vkCreateInstance command", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06793", "If the pNext chain includes a VkExportMetalBufferInfoEXT structure, the VkDeviceMemory in its memory member must have been allocated with VK_EXPORT_METAL_OBJECT_TYPE_METAL_BUFFER_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkMemoryAllocateInfo structure in the vkAllocateMemory command", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06794", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, exactly one of its image, imageView, or bufferView members must not be VK_NULL_HANDLE", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06795", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and its image member is not VK_NULL_HANDLE, the VkImage in its image member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkImageCreateInfo structure in the vkCreateImage command", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06796", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and its imageView member is not VK_NULL_HANDLE, the VkImageView in its imageView member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkImageViewCreateInfo structure in the vkCreateImageView command", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06797", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and its bufferView member is not VK_NULL_HANDLE, the VkBufferView in its bufferView member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_TEXTURE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkBufferViewCreateInfo structure in the vkCreateBufferView command", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06798", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if either its image or imageView member is not VK_NULL_HANDLE, then plane must be VK_IMAGE_ASPECT_PLANE_0_BIT, VK_IMAGE_ASPECT_PLANE_1_BIT, or VK_IMAGE_ASPECT_PLANE_2_BIT", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06799", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if the VkImage in its image member does not have a multi-planar format, then its plane member must be VK_IMAGE_ASPECT_PLANE_0_BIT", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06800", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if the VkImage in its image member has a multi-planar format with only two planes, then its plane member must not be VK_IMAGE_ASPECT_PLANE_2_BIT", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06801", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if the VkImageView in its imageView member does not have a multi-planar format, then its plane member must be VK_IMAGE_ASPECT_PLANE_0_BIT", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06802", "If the pNext chain includes a VkExportMetalTextureInfoEXT structure, and if the VkImageView in its imageView member has a multi-planar format with only two planes, then its plane member must not be VK_IMAGE_ASPECT_PLANE_2_BIT", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06803", "If the pNext chain includes a VkExportMetalIOSurfaceInfoEXT structure, the VkImage in its image member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_IOSURFACE_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkImageCreateInfo structure in the vkCreateImage command", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06804", "If the pNext chain includes a VkExportMetalSharedEventInfoEXT structure, exactly one of its semaphore or event members must not be VK_NULL_HANDLE", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06805", "If the pNext chain includes a VkExportMetalSharedEventInfoEXT structure, and its semaphore member is not VK_NULL_HANDLE, the VkSemaphore in its semaphore member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkSemaphoreCreateInfo structure in the vkCreateSemaphore command", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-06806", "If the pNext chain includes a VkExportMetalSharedEventInfoEXT structure, and its event member is not VK_NULL_HANDLE, the VkEvent in its event member must have been created with VK_EXPORT_METAL_OBJECT_TYPE_METAL_SHARED_EVENT_BIT_EXT in the exportObjectType member of a VkExportMetalObjectCreateInfoEXT structure in the pNext chain of the VkEventCreateInfo structure in the vkCreateEvent command", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExportMetalBufferInfoEXT, VkExportMetalCommandQueueInfoEXT, VkExportMetalDeviceInfoEXT, VkExportMetalIOSurfaceInfoEXT, VkExportMetalSharedEventInfoEXT, or VkExportMetalTextureInfoEXT", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_OBJECTS_INFO_EXT", "chapters/memory.html"},
    {"VUID-VkExportMetalObjectsInfoEXT-sType-unique", "The sType value of each structure in the pNext chain must be unique, with the exception of structures of type VkExportMetalBufferInfoEXT, VkExportMetalCommandQueueInfoEXT, VkExportMetalIOSurfaceInfoEXT, VkExportMetalSharedEventInfoEXT, or VkExportMetalTextureInfoEXT", "chapters/memory.html"},
    {"VUID-VkExportMetalSharedEventInfoEXT-commonparent", "Both of event, and semaphore that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/memory.html"},
    {"VUID-VkExportMetalSharedEventInfoEXT-event-parameter", "If event is not VK_NULL_HANDLE, event must be a valid VkEvent handle", "chapters/memory.html"},
    {"VUID-VkExportMetalSharedEventInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_SHARED_EVENT_INFO_EXT", "chapters/memory.html"},
    {"VUID-VkExportMetalSharedEventInfoEXT-semaphore-parameter", "If semaphore is not VK_NULL_HANDLE, semaphore must be a valid VkSemaphore handle", "chapters/memory.html"},
    {"VUID-VkExportMetalTextureInfoEXT-bufferView-parameter", "If bufferView is not VK_NULL_HANDLE, bufferView must be a valid VkBufferView handle", "chapters/memory.html"},
    {"VUID-VkExportMetalTextureInfoEXT-commonparent", "Each of bufferView, image, and imageView that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/memory.html"},
    {"VUID-VkExportMetalTextureInfoEXT-image-parameter", "If image is not VK_NULL_HANDLE, image must be a valid VkImage handle", "chapters/memory.html"},
    {"VUID-VkExportMetalTextureInfoEXT-imageView-parameter", "If imageView is not VK_NULL_HANDLE, imageView must be a valid VkImageView handle", "chapters/memory.html"},
    {"VUID-VkExportMetalTextureInfoEXT-plane-parameter", "plane must be a valid VkImageAspectFlagBits value", "chapters/memory.html"},
    {"VUID-VkExportMetalTextureInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_METAL_TEXTURE_INFO_EXT", "chapters/memory.html"},
    {"VUID-VkExportSemaphoreCreateInfo-handleTypes-01124", "The bits in handleTypes must be supported and compatible, as reported by VkExternalSemaphoreProperties", "chapters/synchronization.html"},
    {"VUID-VkExportSemaphoreCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalSemaphoreHandleTypeFlagBits values", "chapters/synchronization.html"},
    {"VUID-VkExportSemaphoreCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO", "chapters/synchronization.html"},
    {"VUID-VkExportSemaphoreWin32HandleInfoKHR-handleTypes-01125", "If VkExportSemaphoreCreateInfo::handleTypes does not include VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT or VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT, VkExportSemaphoreWin32HandleInfoKHR must not be included in the pNext chain of VkSemaphoreCreateInfo", "chapters/synchronization.html"},
    {"VUID-VkExportSemaphoreWin32HandleInfoKHR-pAttributes-parameter", "If pAttributes is not NULL, pAttributes must be a valid pointer to a valid SECURITY_ATTRIBUTES value", "chapters/synchronization.html"},
    {"VUID-VkExportSemaphoreWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR", "chapters/synchronization.html"},
    {"VUID-VkExternalBufferProperties-pNext-pNext", "pNext must be NULL", "chapters/capabilities.html"},
    {"VUID-VkExternalBufferProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES", "chapters/capabilities.html"},
    {"VUID-VkExternalComputeQueueCreateInfoNV-pNext-pNext", "pNext must be NULL", "chapters/VK_NV_external_compute_queue/VK_NV_external_compute_queue.html"},
    {"VUID-VkExternalComputeQueueCreateInfoNV-preferredQueue-parameter", "preferredQueue must be a valid VkQueue handle", "chapters/VK_NV_external_compute_queue/VK_NV_external_compute_queue.html"},
    {"VUID-VkExternalComputeQueueCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_CREATE_INFO_NV", "chapters/VK_NV_external_compute_queue/VK_NV_external_compute_queue.html"},
    {"VUID-VkExternalComputeQueueDataParamsNV-pNext-pNext", "pNext must be NULL", "chapters/VK_NV_external_compute_queue/VK_NV_external_compute_queue.html"},
    {"VUID-VkExternalComputeQueueDataParamsNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_DATA_PARAMS_NV", "chapters/VK_NV_external_compute_queue/VK_NV_external_compute_queue.html"},
    {"VUID-VkExternalComputeQueueDeviceCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_COMPUTE_QUEUE_DEVICE_CREATE_INFO_NV", "chapters/VK_NV_external_compute_queue/VK_NV_external_compute_queue.html"},
    {"VUID-VkExternalFenceProperties-pNext-pNext", "pNext must be NULL", "chapters/capabilities.html"},
    {"VUID-VkExternalFenceProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES", "chapters/capabilities.html"},
    {"VUID-VkExternalFormatANDROID-externalFormat-01894", "externalFormat must be 0 or a value returned in the externalFormat member of VkAndroidHardwareBufferFormatPropertiesANDROID by an earlier call to vkGetAndroidHardwareBufferPropertiesANDROID", "chapters/resources.html"},
    {"VUID-VkExternalFormatANDROID-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID", "chapters/resources.html"},
    {"VUID-VkExternalFormatQNX-externalFormat-08956", "externalFormat must be 0 or a value returned in the externalFormat member of VkScreenBufferFormatPropertiesQNX by an earlier call to vkGetScreenBufferPropertiesQNX", "chapters/resources.html"},
    {"VUID-VkExternalFormatQNX-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_QNX", "chapters/resources.html"},
    {"VUID-VkExternalImageFormatProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES", "chapters/capabilities.html"},
    {"VUID-VkExternalMemoryAcquireUnmodifiedEXT-acquireUnmodifiedMemory-08922", "If acquireUnmodifiedMemory is VK_TRUE, and the memory barrier's srcQueueFamilyIndex is a special queue family reserved for external memory ownership transfers (as described in Queue Family Ownership Transfer), then each range of VkDeviceMemory bound to the resource must have remained unmodified during all time since the resource's most recent release of ownership to the queue family", "chapters/synchronization.html"},
    {"VUID-VkExternalMemoryAcquireUnmodifiedEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT", "chapters/synchronization.html"},
    {"VUID-VkExternalMemoryBufferCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values", "chapters/resources.html"},
    {"VUID-VkExternalMemoryBufferCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO", "chapters/resources.html"},
    {"VUID-VkExternalMemoryImageCreateInfo-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values", "chapters/resources.html"},
    {"VUID-VkExternalMemoryImageCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO", "chapters/resources.html"},
    {"VUID-VkExternalMemoryImageCreateInfoNV-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBitsNV values", "chapters/resources.html"},
    {"VUID-VkExternalMemoryImageCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV", "chapters/resources.html"},
    {"VUID-VkExternalMemoryTensorCreateInfoARM-handleTypes-parameter", "handleTypes must be a valid combination of VkExternalMemoryHandleTypeFlagBits values", "chapters/resources.html"},
    {"VUID-VkExternalMemoryTensorCreateInfoARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_TENSOR_CREATE_INFO_ARM", "chapters/resources.html"},
    {"VUID-VkExternalSemaphoreProperties-pNext-pNext", "pNext must be NULL", "chapters/capabilities.html"},
    {"VUID-VkExternalSemaphoreProperties-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES", "chapters/capabilities.html"},
    {"VUID-VkExternalTensorPropertiesARM-externalMemoryProperties-parameter", "externalMemoryProperties must be a valid VkExternalMemoryProperties structure", "chapters/capabilities.html"},
    {"VUID-VkExternalTensorPropertiesARM-pNext-pNext", "pNext must be NULL", "chapters/capabilities.html"},
    {"VUID-VkExternalTensorPropertiesARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_EXTERNAL_TENSOR_PROPERTIES_ARM", "chapters/capabilities.html"},
    {"VUID-VkFenceCreateInfo-flags-parameter", "flags must be a valid combination of VkFenceCreateFlagBits values", "chapters/synchronization.html"},
    {"VUID-VkFenceCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkExportFenceCreateInfo or VkExportFenceWin32HandleInfoKHR", "chapters/synchronization.html"},
    {"VUID-VkFenceCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FENCE_CREATE_INFO", "chapters/synchronization.html"},
    {"VUID-VkFenceCreateInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/synchronization.html"},
    {"VUID-VkFenceGetFdInfoKHR-fence-01455", "fence must not currently have its payload replaced by an imported payload as described below in Importing Fence Payloads unless that imported payload's handle type was included in VkExternalFenceProperties::exportFromImportedHandleTypes for handleType", "chapters/synchronization.html"},
    {"VUID-VkFenceGetFdInfoKHR-fence-parameter", "fence must be a valid VkFence handle", "chapters/synchronization.html"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-01453", "handleType must have been included in VkExportFenceCreateInfo::handleTypes when fence's current payload was created", "chapters/synchronization.html"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-01454", "If handleType refers to a handle type with copy payload transference semantics, fence must be signaled, or have an associated fence signal operation pending execution", "chapters/synchronization.html"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-01456", "handleType must be defined as a POSIX file descriptor handle", "chapters/synchronization.html"},
    {"VUID-VkFenceGetFdInfoKHR-handleType-parameter", "handleType must be a valid VkExternalFenceHandleTypeFlagBits value", "chapters/synchronization.html"},
    {"VUID-VkFenceGetFdInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/synchronization.html"},
    {"VUID-VkFenceGetFdInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR", "chapters/synchronization.html"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-fence-01450", "fence must not currently have its payload replaced by an imported payload as described below in Importing Fence Payloads unless that imported payload's handle type was included in VkExternalFenceProperties::exportFromImportedHandleTypes for handleType", "chapters/synchronization.html"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-fence-parameter", "fence must be a valid VkFence handle", "chapters/synchronization.html"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01448", "handleType must have been included in VkExportFenceCreateInfo::handleTypes when the fence's current payload was created", "chapters/synchronization.html"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01449", "If handleType is defined as an NT handle, vkGetFenceWin32HandleKHR must be called no more than once for each valid unique combination of fence and handleType", "chapters/synchronization.html"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01451", "If handleType refers to a handle type with copy payload transference semantics, fence must be signaled, or have an associated fence signal operation pending execution", "chapters/synchronization.html"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-01452", "handleType must be defined as an NT handle or a global share handle", "chapters/synchronization.html"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-handleType-parameter", "handleType must be a valid VkExternalFenceHandleTypeFlagBits value", "chapters/synchronization.html"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-pNext-pNext", "pNext must be NULL", "chapters/synchronization.html"},
    {"VUID-VkFenceGetWin32HandleInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR", "chapters/synchronization.html"},
    {"VUID-VkFilterCubicImageViewImageFormatPropertiesEXT-pNext-02627", "If the pNext chain of the VkImageFormatProperties2 structure includes a VkFilterCubicImageViewImageFormatPropertiesEXT structure, the pNext chain of the VkPhysicalDeviceImageFormatInfo2 structure must include a VkPhysicalDeviceImageViewImageFormatInfoEXT structure with an imageViewType that is compatible with imageType", "chapters/capabilities.html"},
    {"VUID-VkFilterCubicImageViewImageFormatPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT", "chapters/capabilities.html"},
    {"VUID-VkFormatProperties2-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkDrmFormatModifierPropertiesList2EXT, VkDrmFormatModifierPropertiesListEXT, VkFormatProperties3, VkSubpassResolvePerformanceQueryEXT, or VkTensorFormatPropertiesARM", "chapters/formats.html"},
    {"VUID-VkFormatProperties2-sType-sType", "sType must be VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2", "chapters/formats.html"},
    {"VUID-VkFormatProperties2-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/formats.html"},
    {"VUID-VkFormatProperties3-sType-sType", "sType must be VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3", "chapters/formats.html"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04524", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, its layout member must be equal to VK_IMAGE_LAYOUT_GENERAL or VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR", "chapters/renderpass.html"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04525", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.width must be a power of two value", "chapters/renderpass.html"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04526", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.width must be less than or equal to maxFragmentShadingRateAttachmentTexelSize.width", "chapters/renderpass.html"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04527", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.width must be greater than or equal to minFragmentShadingRateAttachmentTexelSize.width", "chapters/renderpass.html"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04528", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.height must be a power of two value", "chapters/renderpass.html"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04529", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.height must be less than or equal to maxFragmentShadingRateAttachmentTexelSize.height", "chapters/renderpass.html"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04530", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, shadingRateAttachmentTexelSize.height must be greater than or equal to minFragmentShadingRateAttachmentTexelSize.height", "chapters/renderpass.html"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04531", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, the quotient of shadingRateAttachmentTexelSize.width and shadingRateAttachmentTexelSize.height must be less than or equal to maxFragmentShadingRateAttachmentTexelSizeAspectRatio", "chapters/renderpass.html"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-04532", "If pFragmentShadingRateAttachment is not NULL and its attachment member is not VK_ATTACHMENT_UNUSED, the quotient of shadingRateAttachmentTexelSize.height and shadingRateAttachmentTexelSize.width must be less than or equal to maxFragmentShadingRateAttachmentTexelSizeAspectRatio", "chapters/renderpass.html"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-pFragmentShadingRateAttachment-parameter", "If pFragmentShadingRateAttachment is not NULL, pFragmentShadingRateAttachment must be a valid pointer to a valid VkAttachmentReference2 structure", "chapters/renderpass.html"},
    {"VUID-VkFragmentShadingRateAttachmentInfoKHR-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR", "chapters/renderpass.html"},
    {"VUID-VkFrameBoundaryEXT-commonparent", "Both of the elements of pBuffers, and the elements of pImages that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/debugging.html"},
    {"VUID-VkFrameBoundaryEXT-flags-parameter", "flags must be a valid combination of VkFrameBoundaryFlagBitsEXT values", "chapters/debugging.html"},
    {"VUID-VkFrameBoundaryEXT-pBuffers-parameter", "If bufferCount is not 0, and pBuffers is not NULL, pBuffers must be a valid pointer to an array of bufferCount valid VkBuffer handles", "chapters/debugging.html"},
    {"VUID-VkFrameBoundaryEXT-pImages-parameter", "If imageCount is not 0, and pImages is not NULL, pImages must be a valid pointer to an array of imageCount valid VkImage handles", "chapters/debugging.html"},
    {"VUID-VkFrameBoundaryEXT-pTag-parameter", "If tagSize is not 0, and pTag is not NULL, pTag must be a valid pointer to an array of tagSize bytes", "chapters/debugging.html"},
    {"VUID-VkFrameBoundaryEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT", "chapters/debugging.html"},
    {"VUID-VkFrameBoundaryTensorsARM-pTensors-parameter", "pTensors must be a valid pointer to an array of tensorCount valid VkTensorARM handles", "chapters/debugging.html"},
    {"VUID-VkFrameBoundaryTensorsARM-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAME_BOUNDARY_TENSORS_ARM", "chapters/debugging.html"},
    {"VUID-VkFrameBoundaryTensorsARM-tensorCount-arraylength", "tensorCount must be greater than 0", "chapters/debugging.html"},
    {"VUID-VkFramebufferAttachmentImageInfo-flags-parameter", "flags must be a valid combination of VkImageCreateFlagBits values", "chapters/renderpass.html"},
    {"VUID-VkFramebufferAttachmentImageInfo-pNext-pNext", "pNext must be NULL", "chapters/renderpass.html"},
    {"VUID-VkFramebufferAttachmentImageInfo-pViewFormats-parameter", "If viewFormatCount is not 0, pViewFormats must be a valid pointer to an array of viewFormatCount valid VkFormat values", "chapters/renderpass.html"},
    {"VUID-VkFramebufferAttachmentImageInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO", "chapters/renderpass.html"},
    {"VUID-VkFramebufferAttachmentImageInfo-usage-parameter", "usage must be a valid combination of VkImageUsageFlagBits values", "chapters/renderpass.html"},
    {"VUID-VkFramebufferAttachmentImageInfo-usage-requiredbitmask", "usage must not be 0", "chapters/renderpass.html"},
    {"VUID-VkFramebufferAttachmentImageInfo-viewFormatCount-09536", "If viewFormatCount is not 0, and the render pass is not being used with an external format resolve attachment, each element of pViewFormats must not be VK_FORMAT_UNDEFINED", "chapters/renderpass.html"},
    {"VUID-VkFramebufferAttachmentsCreateInfo-pAttachmentImageInfos-parameter", "If attachmentImageInfoCount is not 0, pAttachmentImageInfos must be a valid pointer to an array of attachmentImageInfoCount valid VkFramebufferAttachmentImageInfo structures", "chapters/renderpass.html"},
    {"VUID-VkFramebufferAttachmentsCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-attachmentCount-00876", "attachmentCount must be equal to the attachment count specified in renderPass", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-commonparent", "Both of renderPass, and the elements of pAttachments that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-02778", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT and attachmentCount is not 0, pAttachments must be a valid pointer to an array of attachmentCount valid VkImageView handles", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-03189", "If the imagelessFramebuffer feature is not enabled, flags must not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-03190", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the pNext chain must include a VkFramebufferAttachmentsCreateInfo structure", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-03191", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the attachmentImageInfoCount member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain must be equal to either zero or attachmentCount", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-03196", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is referenced by VkRenderPassFragmentDensityMapCreateInfoEXT::fragmentDensityMapAttachment in renderPass must be greater than or equal to the ceiling of width/maxFragmentDensityTexelSize.width", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-03197", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that is referenced by VkRenderPassFragmentDensityMapCreateInfoEXT::fragmentDensityMapAttachment in renderPass must be greater than or equal to the ceiling of height/maxFragmentDensityTexelSize.height", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-03201", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a color attachment or resolve attachment by renderPass must include VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-03202", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a depth/stencil attachment by renderPass must include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-03203", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a depth/stencil resolve attachment by renderPass must include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-03204", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as an input attachment by renderPass must include VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-03205", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, at least one element of the pViewFormats member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain must be equal to the corresponding value of VkAttachmentDescription::format used to create renderPass", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04113", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with VkImageViewCreateInfo::viewType not equal to VK_IMAGE_VIEW_TYPE_3D", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04533", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have been created with a VkImageCreateInfo::extent.width greater than or equal to width", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04534", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have been created with a VkImageCreateInfo::extent.height greater than or equal to height", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04535", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have been created with a VkImageViewCreateInfo::subresourceRange.layerCount greater than or equal to layers", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04537", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, and renderPass was specified with non-zero view masks, each element of pAttachments that is used as a fragment shading rate attachment by renderPass must have a layerCount that is either 1, or greater than the index of the most significant bit set in any of those view masks", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04538", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, and renderPass was not specified with non-zero view masks, each element of pAttachments that is used as a fragment shading rate attachment by renderPass must have a layerCount that is either 1, or greater than layers", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04539", "If the maintenance7 feature is not enabled or the robustFragmentShadingRateAttachmentAccess limit is VK_FALSE or the imageView member of a VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with VkImageSubresourceRange::baseMipLevel greater than 0, flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is used as a fragment shading rate attachment must have a width at least as large as ceil(width / texelWidth), where texelWidth is the largest value of shadingRateAttachmentTexelSize.width in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04540", "If the maintenance7 feature is not enabled or the robustFragmentShadingRateAttachmentAccess limit is VK_FALSE or the imageView member of a VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with VkImageSubresourceRange::baseMipLevel greater than 0, flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is used as a fragment shading rate attachment must have a height at least as large as ceil(height / texelHeight), where texelHeight is the largest value of shadingRateAttachmentTexelSize.height in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04541", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as an input, color, resolve or depth/stencil attachment in renderPass must be greater than or equal to width", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04542", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as an input, color, resolve or depth/stencil attachment in renderPass must be greater than or equal to height", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04543", "If the maintenance7 feature is not enabled or the robustFragmentShadingRateAttachmentAccess limit is VK_FALSE or the imageView member of a VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with VkImageSubresourceRange::baseMipLevel greater than 0, and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the width member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as a fragment shading rate attachment must be greater than or equal to ceil(width / texelWidth), where texelWidth is the largest value of shadingRateAttachmentTexelSize.width in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04544", "If the maintenance7 feature is not enabled or the robustFragmentShadingRateAttachmentAccess limit is VK_FALSE or the imageView member of a VkRenderingFragmentShadingRateAttachmentInfoKHR structure was created with VkImageSubresourceRange::baseMipLevel greater than 0, and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the height member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as a fragment shading rate attachment must be greater than or equal to ceil(height / texelHeight), where texelHeight is the largest value of shadingRateAttachmentTexelSize.height in a VkFragmentShadingRateAttachmentInfoKHR which references that attachment", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04545", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as a fragment shading rate attachment must be either 1, or greater than or equal to layers", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04548", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a fragment shading rate attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04549", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the usage member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain that refers to an attachment used as a fragment shading rate attachment by renderPass must include VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-04587", "If flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT and renderPass was specified with non-zero view masks, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure in the pNext chain that is used as a fragment shading rate attachment must be either 1, or greater than the index of the most significant bit set in any of those view masks", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-flags-parameter", "flags must be a valid combination of VkFramebufferCreateFlagBits values", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-height-00887", "height must be greater than 0", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-height-00888", "height must be less than or equal to maxFramebufferHeight", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-layers-00889", "layers must be greater than 0", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-layers-00890", "layers must be less than or equal to maxFramebufferLayers", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-nullColorAttachmentWithExternalFormatResolve-09349", "If the nullColorAttachmentWithExternalFormatResolve is VK_FALSE, and flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the format of the color attachment for each subpass in renderPass that includes an external format image as a resolve attachment must have a format equal to the value of VkAndroidHardwareBufferFormatResolvePropertiesANDROID::colorAttachmentFormat as returned by a call to vkGetAndroidHardwareBufferPropertiesANDROID for the Android hardware buffer that was used to create the image view use as its resolve attachment", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00877", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a color attachment or resolve attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00879", "If renderpass is not VK_NULL_HANDLE, flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as an input attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00880", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with a VkFormat value that matches the VkFormat specified by the corresponding VkAttachmentDescription in renderPass", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00881", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with a samples value that matches the samples value specified by the corresponding VkAttachmentDescription in renderPass", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00883", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must only specify a single mip level", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00884", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments must have been created with the identity swizzle", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-00891", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is a 2D or 2D array image view taken from a 3D image must not be a depth/stencil format", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02552", "Each element of pAttachments that is used as a fragment density map attachment by renderPass must not have been created with a flags value including VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02555", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is referenced by fragmentDensityMapAttachment must have a width at least as large as the ceiling of width/maxFragmentDensityTexelSize.width", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02556", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, an element of pAttachments that is referenced by fragmentDensityMapAttachment must have a height at least as large as the ceiling of height/maxFragmentDensityTexelSize.height", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02633", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a depth/stencil attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-02634", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, each element of pAttachments that is used as a depth/stencil resolve attachment by renderPass must have been created with a usage value including VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-pAttachments-09350", "If flags does not include VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, then if an element of pAttachments has a format of VK_FORMAT_UNDEFINED, it must have been created with a VkExternalFormatANDROID::externalFormat value identical to that provided in the VkExternalFormatANDROID::externalFormat specified by the corresponding VkAttachmentDescription2 in renderPass", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkFramebufferAttachmentsCreateInfo", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02531", "If renderPass was specified with non-zero view masks, layers must be 1", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02553", "If renderPass has a fragment density map attachment and the fragmentDensityMapNonSubsampledImages feature is not enabled, each element of pAttachments must have been created with a flags value including VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT unless that element is the fragment density map attachment", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-renderPass-02746", "Each element of pAttachments that is referenced by fragmentDensityMapAttachment must have a layerCount equal to 1 or if renderPass was specified with non-zero view masks, greater than the index of the most significant bit set in any of those view masks", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-renderPass-03198", "If multiview is enabled for renderPass and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain used as an input, color, resolve, or depth/stencil attachment in renderPass must be greater than the maximum bit index set in the view mask in the subpasses in which it is used in renderPass", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-renderPass-04536", "If renderPass was specified with non-zero view masks, each element of pAttachments that is used as an input, color, resolve, or depth/stencil attachment by renderPass must have a layerCount greater than the index of the most significant bit set in any of those view masks", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-renderPass-04546", "If multiview is not enabled for renderPass and flags includes VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT, the layerCount member of any element of the pAttachmentImageInfos member of a VkFramebufferAttachmentsCreateInfo structure included in the pNext chain used as an input, color, resolve, or depth/stencil attachment in renderPass must be greater than or equal to layers", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-renderPass-10830", "If renderPass was created with VK_RENDER_PASS_CREATE_PER_LAYER_FRAGMENT_DENSITY_BIT_VALVE, then layers must be less than or equal to maxFragmentDensityMapLayers", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-renderPass-parameter", "renderPass must be a valid VkRenderPass handle", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-samples-06881", "If multisampled-render-to-single-sampled is enabled for any subpass, all color, depth/stencil and input attachments used in that subpass which have VkAttachmentDescription::samples or VkAttachmentDescription2::samples equal to VK_SAMPLE_COUNT_1_BIT must have been created with VK_IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT in their VkImageCreateInfo::flags", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-samples-07009", "If multisampled-render-to-single-sampled is enabled for any subpass, all color, depth/stencil and input attachments used in that subpass which have VkAttachmentDescription::samples or VkAttachmentDescription2::samples equal to VK_SAMPLE_COUNT_1_BIT must have a format that supports the sample count specified in VkMultisampledRenderToSingleSampledInfoEXT::rasterizationSamples", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-width-00885", "width must be greater than 0", "chapters/renderpass.html"},
    {"VUID-VkFramebufferCreateInfo-width-00886", "width must be less than or equal to maxFramebufferWidth", "chapters/renderpass.html"},
    {"VUID-VkFramebufferMixedSamplesCombinationNV-pNext-pNext", "pNext must be NULL", "chapters/fragops.html"},
    {"VUID-VkFramebufferMixedSamplesCombinationNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV", "chapters/fragops.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-commonparent", "Both of indirectCommandsLayout, and indirectExecutionSet that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-indirectAddress-11074", "indirectAddress must be aligned to 4", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-indirectAddress-11076", "indirectAddress must not be NULL", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-indirectAddressSize-11077", "indirectAddressSize must be greater than zero", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-indirectCommandsLayout-10241", "If the token sequence of the passed indirectCommandsLayout does not contains a VK_INDIRECT_COMMANDS_TOKEN_TYPE_EXECUTION_SET_EXT token, the indirectExecutionSet must be VK_NULL_HANDLE", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-indirectCommandsLayout-11002", "If indirectCommandsLayout was created with a token sequence that contained the VK_INDIRECT_COMMANDS_TOKEN_TYPE_EXECUTION_SET_EXT token, the shader stages used to create the initial shader state of indirectExecutionSet must equal the VkIndirectCommandsExecutionSetTokenEXT::shaderStages used to create indirectCommandsLayout", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-indirectCommandsLayout-11065", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_EXT, then the indirectExecutionSet's push constant layout must contain the updateRange specified in VkIndirectCommandsPushConstantTokenEXT", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-indirectCommandsLayout-11066", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_SEQUENCE_INDEX_EXT, then the indirectExecutionSet's push constant layout must contain the updateRange specified in VkIndirectCommandsPushConstantTokenEXT", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-indirectCommandsLayout-11079", "If indirectCommandsLayout was created using a VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_EXT token and shader objects are not bound then the bound graphics pipeline must have been created with VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE in pDynamicStates", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-indirectCommandsLayout-11083", "If the token sequence of the passed indirectCommandsLayout contains a VK_INDIRECT_COMMANDS_TOKEN_TYPE_EXECUTION_SET_EXT token, the indirectExecutionSet must not be VK_NULL_HANDLE", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-indirectCommandsLayout-11144", "If the indirectCommandsLayout contains a VK_INDIRECT_COMMANDS_TOKEN_TYPE_EXECUTION_SET_EXT token, then the descriptor and push constant layout info provided either by pipelineLayout or through a VkPipelineLayoutCreateInfo in pNext of the VkIndirectCommandsLayoutCreateInfoEXT used to create indirectCommandsLayout must be compatible with the descriptor and push constant layout info used by indirectExecutionSet", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-indirectCommandsLayout-parameter", "indirectCommandsLayout must be a valid VkIndirectCommandsLayoutEXT handle", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-indirectExecutionSet-11080", "If indirectExecutionSet is VK_NULL_HANDLE, a VkGeneratedCommandsPipelineInfoEXT or VkGeneratedCommandsShaderInfoEXT must be included in the pNext chain", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-indirectExecutionSet-parameter", "If indirectExecutionSet is not VK_NULL_HANDLE, indirectExecutionSet must be a valid VkIndirectExecutionSetEXT handle", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-maxDrawCount-11078", "When not ignored, maxDrawCount x maxSequenceCount must be less than 2^24", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-maxSequenceCount-10246", "maxSequenceCount must not be zero", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-maxSequenceCount-11067", "maxSequenceCount must be less or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesEXT::maxIndirectSequenceCount and VkGeneratedCommandsMemoryRequirementsInfoEXT::maxSequenceCount that was used to determine the preprocessSize", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-preprocessAddress-11063", "If vkGetGeneratedCommandsMemoryRequirementsEXT returns a non-zero size, preprocessAddress must not be NULL", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-preprocessAddress-11064", "VkDeviceMemory objects bound to the underlying buffer for preprocessAddress must have been allocated using one of the memory types allowed in the memoryTypeBits member of the VkMemoryRequirements structure returned by vkGetGeneratedCommandsMemoryRequirementsEXT", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-preprocessAddress-11069", "The underlying buffer for preprocessAddress must have the VK_BUFFER_USAGE_2_PREPROCESS_BUFFER_BIT_EXT bit set in its usage flag", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-preprocessAddress-11070", "If the underlying buffer for preprocessAddress is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-preprocessSize-11071", "preprocessSize must be greater than or equal to the memory requirement's size returned by vkGetGeneratedCommandsMemoryRequirementsEXT using the matching inputs (indirectCommandsLayout, ...) as within this structure", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_EXT", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-sequenceCountAddress-11068", "If sequenceCountAddress is not NULL, the value contained in the address must be less or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesEXT::maxIndirectSequenceCount and VkGeneratedCommandsMemoryRequirementsInfoEXT::maxSequenceCount that was used to determine the preprocessSize", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-sequenceCountAddress-11072", "The underlying buffer for sequenceCountAddress must have the VK_BUFFER_USAGE_2_INDIRECT_BUFFER_BIT_KHR bit set in its usage flag", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-sequenceCountAddress-11073", "If sequenceCountAddress is not NULL, sequenceCountAddress must be aligned to 4", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-sequenceCountAddress-11075", "If the underlying buffer for sequenceCountAddress is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-shaderStages-parameter", "shaderStages must be a valid combination of VkShaderStageFlagBits values", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoEXT-shaderStages-requiredbitmask", "shaderStages must not be 0", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-commonparent", "Each of indirectCommandsLayout, pipeline, preprocessBuffer, sequencesCountBuffer, and sequencesIndexBuffer that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-02913", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV, then the pipeline must have been created with multiple shader groups", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-02914", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV, then the pipeline must have been created with VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV set in VkGraphicsPipelineCreateInfo::flags", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-02915", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV, then the pipeline's VkPipelineLayout must match the VkIndirectCommandsLayoutTokenNV::pushconstantPipelineLayout", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-07078", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_TASKS_NV, then the pipeline must contain a shader stage using the MeshNV Execution Model", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-07079", "If the indirectCommandsLayout uses a token of VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_MESH_TASKS_NV, then the pipeline must contain a shader stage using the MeshEXT Execution Model", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-indirectCommandsLayout-parameter", "indirectCommandsLayout must be a valid VkIndirectCommandsLayoutNV handle", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-pNext-pNext", "pNext must be NULL", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-pStreams-parameter", "pStreams must be a valid pointer to an array of streamCount valid VkIndirectCommandsStreamNV structures", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-pipeline-02912", "The provided pipeline must match the pipeline bound at execution time", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-pipeline-parameter", "If pipeline is not VK_NULL_HANDLE, pipeline must be a valid VkPipeline handle", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-pipelineBindPoint-09084", "If pipelineBindPoint is of type VK_PIPELINE_BIND_POINT_COMPUTE, then the pipeline must have been created with the flag VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-pipelineBindPoint-09085", "If pipelineBindPoint is of type VK_PIPELINE_BIND_POINT_COMPUTE, then the pipeline must have been created with a VkComputePipelineIndirectBufferInfoNV structure specifying a valid address where its metadata will be saved", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-pipelineBindPoint-09086", "If pipelineBindPoint is of type VK_PIPELINE_BIND_POINT_COMPUTE, then vkCmdUpdatePipelineIndirectBufferNV must have been called on that pipeline to save its metadata to a device address", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-pipelineBindPoint-09087", "If pipelineBindPoint is of type VK_PIPELINE_BIND_POINT_COMPUTE, and if VK_INDIRECT_COMMANDS_TOKEN_TYPE_PIPELINE_NV is used, then pipeline must be VK_NULL_HANDLE", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessBuffer-02918", "preprocessBuffer must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set in its usage flag", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessBuffer-02971", "If preprocessBuffer is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessBuffer-parameter", "preprocessBuffer must be a valid VkBuffer handle", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessOffset-02919", "preprocessOffset must be aligned to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::minIndirectCommandsBufferOffsetAlignment", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-preprocessSize-02920", "preprocessSize must be at least equal to the memory requirement`s size returned by vkGetGeneratedCommandsMemoryRequirementsNV using the matching inputs (indirectCommandsLayout, ...) as within this structure", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCount-02917", "sequencesCount must be less or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxIndirectSequenceCount and VkGeneratedCommandsMemoryRequirementsInfoNV::maxSequencesCount that was used to determine the preprocessSize", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-02921", "sequencesCountBuffer can be set if the actual used count of sequences is sourced from the provided buffer. In that case the sequencesCount serves as upper bound", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-02922", "If sequencesCountBuffer is not VK_NULL_HANDLE, its usage flag must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-02923", "If sequencesCountBuffer is not VK_NULL_HANDLE, sequencesCountOffset must be aligned to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::minSequencesCountBufferOffsetAlignment", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-02972", "If sequencesCountBuffer is not VK_NULL_HANDLE and is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesCountBuffer-parameter", "If sequencesCountBuffer is not VK_NULL_HANDLE, sequencesCountBuffer must be a valid VkBuffer handle", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-02924", "If indirectCommandsLayout's VK_INDIRECT_COMMANDS_LAYOUT_USAGE_INDEXED_SEQUENCES_BIT_NV is set, sequencesIndexBuffer must be set otherwise it must be VK_NULL_HANDLE", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-02925", "If sequencesIndexBuffer is not VK_NULL_HANDLE, its usage flag must have the VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT bit set", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-02926", "If sequencesIndexBuffer is not VK_NULL_HANDLE, sequencesIndexOffset must be aligned to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::minSequencesIndexBufferOffsetAlignment", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-02973", "If sequencesIndexBuffer is not VK_NULL_HANDLE and is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-sequencesIndexBuffer-parameter", "If sequencesIndexBuffer is not VK_NULL_HANDLE, sequencesIndexBuffer must be a valid VkBuffer handle", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-streamCount-02916", "streamCount must match the indirectCommandsLayout's streamCount", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsInfoNV-streamCount-arraylength", "streamCount must be greater than 0", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoEXT-commonparent", "Both of indirectCommandsLayout, and indirectExecutionSet that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoEXT-indirectCommandsLayout-11010", "If indirectCommandsLayout was created with a token sequence that contained the VK_INDIRECT_COMMANDS_TOKEN_TYPE_EXECUTION_SET_EXT token, indirectExecutionSet must not be VK_NULL_HANDLE", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoEXT-indirectCommandsLayout-11011", "If indirectCommandsLayout was not created with a token sequence that contained the VK_INDIRECT_COMMANDS_TOKEN_TYPE_EXECUTION_SET_EXT token, indirectExecutionSet must be VK_NULL_HANDLE", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoEXT-indirectCommandsLayout-11151", "If indirectCommandsLayout was created with a token sequence that contained the VK_INDIRECT_COMMANDS_TOKEN_TYPE_EXECUTION_SET_EXT token, the shader stages used to create the initial shader state of indirectExecutionSet must equal the VkIndirectCommandsExecutionSetTokenEXT::shaderStages used to create indirectCommandsLayout", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoEXT-indirectCommandsLayout-parameter", "indirectCommandsLayout must be a valid VkIndirectCommandsLayoutEXT handle", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoEXT-indirectExecutionSet-11012", "If indirectExecutionSet is VK_NULL_HANDLE, either a VkGeneratedCommandsPipelineInfoEXT or a VkGeneratedCommandsShaderInfoEXT must be included in the pNext chain", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoEXT-indirectExecutionSet-parameter", "If indirectExecutionSet is not VK_NULL_HANDLE, indirectExecutionSet must be a valid VkIndirectExecutionSetEXT handle", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoEXT-maxDrawCount-11146", "When not ignored, maxDrawCount x maxSequenceCount must be less than 2^24", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoEXT-maxSequencesCount-11009", "maxSequencesCount must be less or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesEXT::maxIndirectSequenceCount", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoEXT-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkGeneratedCommandsPipelineInfoEXT or VkGeneratedCommandsShaderInfoEXT", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_EXT", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoEXT-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-commonparent", "Both of indirectCommandsLayout, and pipeline that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-indirectCommandsLayout-parameter", "indirectCommandsLayout must be a valid VkIndirectCommandsLayoutNV handle", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-maxSequencesCount-02907", "maxSequencesCount must be less or equal to VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxIndirectSequenceCount", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pNext-pNext", "pNext must be NULL", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pipeline-parameter", "If pipeline is not VK_NULL_HANDLE, pipeline must be a valid VkPipeline handle", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pipelineBindPoint-09075", "If pipelineBindPoint is of type VK_PIPELINE_BIND_POINT_GRAPHICS, then pipeline must be a valid VkPipeline handle", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pipelineBindPoint-09076", "If pipelineBindPoint is of type VK_PIPELINE_BIND_POINT_COMPUTE, and the indirectCommandsLayout was not created with a VK_INDIRECT_COMMANDS_TOKEN_TYPE_PIPELINE_NV token, then the pipeline must be a valid VkPipeline handle", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pipelineBindPoint-09077", "If pipelineBindPoint is of type VK_PIPELINE_BIND_POINT_COMPUTE, and the indirectCommandsLayout contains a VK_INDIRECT_COMMANDS_TOKEN_TYPE_PIPELINE_NV token, then the pipeline must be VK_NULL_HANDLE", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-pipelineBindPoint-parameter", "pipelineBindPoint must be a valid VkPipelineBindPoint value", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsMemoryRequirementsInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsPipelineInfoEXT-pipeline-parameter", "pipeline must be a valid VkPipeline handle", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsPipelineInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_GENERATED_COMMANDS_PIPELINE_INFO_EXT", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsShaderInfoEXT-pShaders-11127", "pShaders must not contain more than one shader object for a given VkShaderStageFlagBits stage", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsShaderInfoEXT-pShaders-parameter", "pShaders must be a valid pointer to an array of shaderCount valid VkShaderEXT handles", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsShaderInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_GENERATED_COMMANDS_SHADER_INFO_EXT", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeneratedCommandsShaderInfoEXT-shaderCount-arraylength", "shaderCount must be greater than 0", "chapters/device_generated_commands/generatedcommands.html"},
    {"VUID-VkGeometryAABBNV-aabbData-parameter", "If aabbData is not VK_NULL_HANDLE, aabbData must be a valid VkBuffer handle", "chapters/resources.html"},
    {"VUID-VkGeometryAABBNV-offset-02439", "offset must be less than the size of aabbData", "chapters/resources.html"},
    {"VUID-VkGeometryAABBNV-offset-02440", "offset must be a multiple of 8", "chapters/resources.html"},
    {"VUID-VkGeometryAABBNV-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkGeometryAABBNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV", "chapters/resources.html"},
    {"VUID-VkGeometryAABBNV-stride-02441", "stride must be a multiple of 8", "chapters/resources.html"},
    {"VUID-VkGeometryDataNV-aabbs-parameter", "aabbs must be a valid VkGeometryAABBNV structure", "chapters/resources.html"},
    {"VUID-VkGeometryDataNV-triangles-parameter", "triangles must be a valid VkGeometryTrianglesNV structure", "chapters/resources.html"},
    {"VUID-VkGeometryNV-flags-parameter", "flags must be a valid combination of VkGeometryFlagBitsKHR values", "chapters/resources.html"},
    {"VUID-VkGeometryNV-geometry-parameter", "geometry must be a valid VkGeometryDataNV structure", "chapters/resources.html"},
    {"VUID-VkGeometryNV-geometryType-03503", "geometryType must be VK_GEOMETRY_TYPE_TRIANGLES_NV or VK_GEOMETRY_TYPE_AABBS_NV", "chapters/resources.html"},
    {"VUID-VkGeometryNV-geometryType-parameter", "geometryType must be a valid VkGeometryTypeKHR value", "chapters/resources.html"},
    {"VUID-VkGeometryNV-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkGeometryNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GEOMETRY_NV", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-commonparent", "Each of indexData, transformData, and vertexData that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-indexCount-02436", "indexCount must be 0 if indexType is VK_INDEX_TYPE_NONE_NV", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-indexData-02434", "indexData must be VK_NULL_HANDLE if indexType is VK_INDEX_TYPE_NONE_NV", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-indexData-02435", "indexData must be a valid VkBuffer handle if indexType is not VK_INDEX_TYPE_NONE_NV", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-indexData-parameter", "If indexData is not VK_NULL_HANDLE, indexData must be a valid VkBuffer handle", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-indexOffset-02431", "indexOffset must be less than the size of indexData", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-indexOffset-02432", "indexOffset must be a multiple of the element size of indexType", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-indexType-02433", "indexType must be VK_INDEX_TYPE_UINT16, VK_INDEX_TYPE_UINT32, or VK_INDEX_TYPE_NONE_NV", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-indexType-parameter", "indexType must be a valid VkIndexType value", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-transformData-parameter", "If transformData is not VK_NULL_HANDLE, transformData must be a valid VkBuffer handle", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-transformOffset-02437", "transformOffset must be less than the size of transformData", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-transformOffset-02438", "transformOffset must be a multiple of 16", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-vertexData-parameter", "If vertexData is not VK_NULL_HANDLE, vertexData must be a valid VkBuffer handle", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-vertexFormat-02430", "vertexFormat must be one of VK_FORMAT_R32G32B32_SFLOAT, VK_FORMAT_R32G32_SFLOAT, VK_FORMAT_R16G16B16_SFLOAT, VK_FORMAT_R16G16_SFLOAT, VK_FORMAT_R16G16_SNORM, or VK_FORMAT_R16G16B16_SNORM", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-vertexFormat-parameter", "vertexFormat must be a valid VkFormat value", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-vertexOffset-02428", "vertexOffset must be less than the size of vertexData", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-vertexOffset-02429", "vertexOffset must be a multiple of the component size of vertexFormat", "chapters/resources.html"},
    {"VUID-VkGeometryTrianglesNV-vertexStride-03818", "vertexStride must be less than or equal to 232-1", "chapters/resources.html"},
    {"VUID-VkGetLatencyMarkerInfoNV-pTimings-parameter", "If timingCount is not 0, and pTimings is not NULL, pTimings must be a valid pointer to an array of timingCount VkLatencyTimingsFrameReportNV structures", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkGetLatencyMarkerInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GET_LATENCY_MARKER_INFO_NV", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-Geometry-07726", "If the pipeline is being created with a Geometry Execution Model, uses the OutputPoints Execution Mode, and the shaderTessellationAndGeometryPointSize feature is not enabled, a PointSize decorated variable must not be written to", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-Input-06632", "If the pipeline requires fragment shader state with a fragment shader that either enables sample shading or decorates any variable in the Input storage class with Sample, and the VK_EXT_extended_dynamic_state3 extension is not enabled or any of the VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT, VK_DYNAMIC_STATE_SAMPLE_MASK_EXT, or VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT dynamic states is not set, or the alphaToOne feature is enabled and VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT is not set, then pMultisampleState must be a valid pointer to a valid VkPipelineMultisampleStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-Input-07904", "If the vertexAttributeRobustness feature is not enabled, and the maintenance9 feature is not enabled, and the pipeline is being created with vertex input state and pVertexInputState is not dynamic, then all variables with the Input storage class decorated with Location in the Vertex Execution Model OpEntryPoint must contain a location in VkVertexInputAttributeDescription::location", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-Input-08733", "If the pipeline requires vertex input state and pVertexInputState is not dynamic, then the numeric type associated with all Input variables of the corresponding Location in the Vertex Execution Model OpEntryPoint must be the same as VkVertexInputAttributeDescription::format", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-02322", "If the pipeline requires pre-rasterization shader state, and there are any mesh shader stages in the pipeline there must not be any shader stage in the pipeline with a Xfb execution mode", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-04574", "If the pipeline requires fragment shader state, and the supersampleFragmentShadingRates feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRate must not be equal to VK_FRAGMENT_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV, VK_FRAGMENT_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV, VK_FRAGMENT_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV, or VK_FRAGMENT_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-04575", "If the pipeline requires fragment shader state, and the noInvocationFragmentShadingRates feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRate must not be equal to VK_FRAGMENT_SHADING_RATE_NO_INVOCATIONS_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-04889", "If the pipeline requires pre-rasterization shader state and fragment shader state, the fragment shader and last pre-rasterization shader stage and any relevant state must adhere to the pipeline linking rules described in the Shader Interfaces chapter", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-06569", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRateType must be a valid VkFragmentShadingRateTypeNV value", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-07826", "If the pipeline includes a complete set of state, and there are no libraries included in VkPipelineLibraryCreateInfoKHR::pLibraries, then VkPipelineLayout must be a valid pipeline layout", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-09043", "If pDynamicState->pDynamicStates does not include VK_DYNAMIC_STATE_COLOR_WRITE_MASK_EXT, and the format of any color attachment is VK_FORMAT_E5B9G9R9_UFLOAT_PACK32, the colorWriteMask member of the corresponding element of pColorBlendState->pAttachments must either include all of VK_COLOR_COMPONENT_R_BIT, VK_COLOR_COMPONENT_G_BIT, and VK_COLOR_COMPONENT_B_BIT, or none of them", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-09497", "If the pNext chain does not include a VkPipelineCreateFlags2CreateInfo structure, flags must be a valid combination of VkPipelineCreateFlagBits values", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-09526", "If the dynamicRenderingLocalRead feature is not enabled, the pipeline requires fragment output interface state, and the flags member of VkPipelineDepthStencilStateCreateInfo includes VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT or VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT, renderPass must not be VK_NULL_HANDLE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-None-10391", "If a resource variables is declared in a shader as an array of descriptors, then the descriptor type of that variable must not be VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-PrimitiveId-06264", "If the pipeline requires pre-rasterization shader state, it includes a mesh shader and the fragment shader code reads from an input variable that is decorated with PrimitiveId, then the mesh shader code must write to a matching output variable, decorated with PrimitiveId, in all execution paths", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-TaskNV-07063", "The shader stages for VK_SHADER_STAGE_TASK_BIT_EXT or VK_SHADER_STAGE_MESH_BIT_EXT must use either the TaskNV and MeshNV Execution Model or the TaskEXT and MeshEXT Execution Model, but must not use both", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-TessellationEvaluation-07723", "If the pipeline is being created with a TessellationEvaluation Execution Model, no Geometry Execution Model, uses the PointMode Execution Mode, and the shaderTessellationAndGeometryPointSize feature is enabled, a PointSize decorated variable must be written to if the maintenance5 feature is not enabled", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-TessellationEvaluation-07724", "If the pipeline is being created with a TessellationEvaluation Execution Model, no Geometry Execution Model, uses the PointMode Execution Mode, and the shaderTessellationAndGeometryPointSize feature is not enabled, a PointSize decorated variable must not be written to", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-alphaToCoverageEnable-08891", "If the pipeline is being created with fragment shader state, the VkPipelineMultisampleStateCreateInfo::alphaToCoverageEnable is not ignored and is VK_TRUE, then the Fragment Output Interface must contain a variable for the alpha Component word in Location 0 at Index 0", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-commonparent", "Each of basePipelineHandle, layout, and renderPass that are valid handles of non-ignored parameters must have been created, allocated, or retrieved from the same VkDevice", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-conservativePointAndLineRasterization-06760", "If conservativePointAndLineRasterization is not supported, the pipeline requires pre-rasterization shader state, and the pipeline includes a geometry shader with either the OutputPoints or OutputLineStrip execution modes, VkPipelineRasterizationConservativeStateCreateInfoEXT::conservativeRasterizationMode must be VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-conservativePointAndLineRasterization-06761", "If conservativePointAndLineRasterization is not supported, the pipeline requires pre-rasterization shader state, and the pipeline includes a mesh shader with either the OutputPoints or OutputLinesNV execution modes, VkPipelineRasterizationConservativeStateCreateInfoEXT::conservativeRasterizationMode must be VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-conservativePointAndLineRasterization-08892", "If conservativePointAndLineRasterization is not supported; the pipeline is being created with vertex input state and pre-rasterization shader state; the pipeline does not include a geometry shader; and the value of VkPipelineInputAssemblyStateCreateInfo::topology is VK_PRIMITIVE_TOPOLOGY_POINT_LIST, VK_PRIMITIVE_TOPOLOGY_LINE_LIST, or VK_PRIMITIVE_TOPOLOGY_LINE_STRIP, and either VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY dynamic state is not enabled or dynamicPrimitiveTopologyUnrestricted is VK_FALSE, then VkPipelineRasterizationConservativeStateCreateInfoEXT::conservativeRasterizationMode must be VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-coverageReductionMode-02722", "If the pipeline requires fragment output interface state, the coverageReductionMode feature is enabled, and rasterizationSamples is not dynamic, the coverage reduction mode specified by VkPipelineCoverageReductionStateCreateInfoNV::coverageReductionMode, the rasterizationSamples member of pMultisampleState and the sample counts for the color and depth/stencil attachments (if the subpass has them) must be a valid combination returned by vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-depthStencilAttachmentSamples-06593", "If the fragment output interface state and the depthStencilAttachmentSamples member of VkAttachmentSampleCountInfoAMD or VkAttachmentSampleCountInfoNV is not 0, it must be a valid VkSampleCountFlagBits value", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-dynamicPrimitiveTopologyUnrestricted-09031", "If the pipeline requires vertex input state, and related dynamic state is not set, pInputAssemblyState must be a valid pointer to a valid VkPipelineInputAssemblyStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-dynamicRendering-06576", "If the dynamicRendering feature is not enabled and the pipeline requires pre-rasterization shader state, fragment shader state, or fragment output interface state, renderPass must not be VK_NULL_HANDLE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3AlphaToCoverageEnable-07375", "If the extendedDynamicState3AlphaToCoverageEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3AlphaToOneEnable-07376", "If the extendedDynamicState3AlphaToOneEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ColorBlendAdvanced-07386", "If the extendedDynamicState3ColorBlendAdvanced feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COLOR_BLEND_ADVANCED_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ColorBlendEnable-07378", "If the extendedDynamicState3ColorBlendEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ColorBlendEquation-07379", "If the extendedDynamicState3ColorBlendEquation feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ColorWriteMask-07380", "If the extendedDynamicState3ColorWriteMask feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COLOR_WRITE_MASK_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ConservativeRasterizationMode-07382", "If the extendedDynamicState3ConservativeRasterizationMode feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_CONSERVATIVE_RASTERIZATION_MODE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3CoverageModulationMode-07395", "If the extendedDynamicState3CoverageModulationMode feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COVERAGE_MODULATION_MODE_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3CoverageModulationTable-07397", "If the extendedDynamicState3CoverageModulationTable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3CoverageModulationTableEnable-07396", "If the extendedDynamicState3CoverageModulationTableEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COVERAGE_MODULATION_TABLE_ENABLE_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3CoverageReductionMode-07398", "If the extendedDynamicState3CoverageReductionMode feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COVERAGE_REDUCTION_MODE_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3CoverageToColorEnable-07393", "If the extendedDynamicState3CoverageToColorEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_ENABLE_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3CoverageToColorLocation-07394", "If the extendedDynamicState3CoverageToColorLocation feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COVERAGE_TO_COLOR_LOCATION_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3DepthClampEnable-07371", "If the extendedDynamicState3DepthClampEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_DEPTH_CLAMP_ENABLE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3DepthClipEnable-07384", "If the extendedDynamicState3DepthClipEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_DEPTH_CLIP_ENABLE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3DepthClipNegativeOneToOne-07390", "If the extendedDynamicState3DepthClipNegativeOneToOne feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_DEPTH_CLIP_NEGATIVE_ONE_TO_ONE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ExtraPrimitiveOverestimationSize-07383", "If the extendedDynamicState3ExtraPrimitiveOverestimationSize feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_EXTRA_PRIMITIVE_OVERESTIMATION_SIZE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3LineRasterizationMode-07388", "If the extendedDynamicState3LineRasterizationMode feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_LINE_RASTERIZATION_MODE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3LineStippleEnable-07389", "If the extendedDynamicState3LineStippleEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_LINE_STIPPLE_ENABLE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3LogicOpEnable-07377", "If the extendedDynamicState3LogicOpEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3PolygonMode-07372", "If the extendedDynamicState3PolygonMode feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_POLYGON_MODE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ProvokingVertexMode-07387", "If the extendedDynamicState3ProvokingVertexMode feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_PROVOKING_VERTEX_MODE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3RasterizationSamples-07373", "If the extendedDynamicState3RasterizationSamples feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3RasterizationStream-07381", "If the extendedDynamicState3RasterizationStream feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_RASTERIZATION_STREAM_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3RepresentativeFragmentTestEnable-07399", "If the extendedDynamicState3RepresentativeFragmentTestEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_REPRESENTATIVE_FRAGMENT_TEST_ENABLE_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3SampleLocationsEnable-07385", "If the extendedDynamicState3SampleLocationsEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3SampleMask-07374", "If the extendedDynamicState3SampleMask feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_SAMPLE_MASK_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ShadingRateImageEnable-07400", "If the extendedDynamicState3ShadingRateImageEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_SHADING_RATE_IMAGE_ENABLE_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3TessellationDomainOrigin-07370", "If the extendedDynamicState3TessellationDomainOrigin feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_TESSELLATION_DOMAIN_ORIGIN_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ViewportSwizzle-07392", "If the extendedDynamicState3ViewportSwizzle feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_VIEWPORT_SWIZZLE_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-extendedDynamicState3ViewportWScalingEnable-07391", "If the extendedDynamicState3ViewportWScalingEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_ENABLE_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09301", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkExternalFormatANDROID::externalFormat is not 0, VkPipelineRenderingCreateInfo::viewMask must be 0", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09304", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, VkExternalFormatANDROID::externalFormat is not 0, and rasterizationSamples is not dynamic, VkPipelineMultisampleStateCreateInfo::rasterizationSamples must be 1", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09305", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkExternalFormatANDROID::externalFormat is not 0, and blendEnable is not dynamic, the blendEnable member of each element of pColorBlendState->pAttachments must be VK_FALSE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09306", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkExternalFormatANDROID::externalFormat is not 0, and pDynamicState->pDynamicStates does not include VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.width must be 1", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09307", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkExternalFormatANDROID::externalFormat is not 0, and pDynamicState->pDynamicStates does not include VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.height must be 1", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09308", "If the externalFormatResolve feature is enabled, the pipeline requires pre-rasterization shader state and fragment output interface state, renderPass is VK_NULL_HANDLE, and VkExternalFormatANDROID::externalFormat is not 0, the last pre-rasterization shader stage must not statically use a variable with the PrimitiveShadingRateKHR built-in", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09309", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkExternalFormatANDROID::externalFormat is not 0, VkPipelineRenderingCreateInfo::colorAttachmentCount must be 1", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09310", "If the externalFormatResolve feature is enabled, the pipeline requires fragment shader state and fragment output interface state, renderPass is VK_NULL_HANDLE, and VkExternalFormatANDROID::externalFormat is not 0, the fragment shader must not declare the DepthReplacing or StencilRefReplacingEXT execution modes", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09313", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is not VK_NULL_HANDLE, subpass includes an external format resolve attachment, and rasterizationSamples is not dynamic, VkPipelineMultisampleStateCreateInfo::rasterizationSamples must be VK_SAMPLE_COUNT_1_BIT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09314", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is not VK_NULL_HANDLE, subpass includes an external format resolve attachment, and blendEnable is not dynamic, the blendEnable member of each element of pColorBlendState->pAttachments must be VK_FALSE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09315", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is not VK_NULL_HANDLE, subpass includes an external format resolve attachment, and pDynamicState->pDynamicStates does not include VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.width must be 1", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09316", "If the externalFormatResolve feature is enabled, the pipeline requires fragment output interface state, renderPass is not VK_NULL_HANDLE, subpass includes an external format resolve attachment, and pDynamicState->pDynamicStates does not include VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.height must be 1", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-externalFormatResolve-09317", "If the externalFormatResolve feature is enabled, the pipeline requires pre-rasterization shader state and fragment output interface state, renderPass is not VK_NULL_HANDLE, and subpass includes an external format resolve attachment, the last pre-rasterization shader stage must not statically use a variable with the PrimitiveShadingRateKHR built-in", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-00764", "flags must not contain the VK_PIPELINE_CREATE_DISPATCH_BASE_BIT flag", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-02877", "If flags includes VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then the VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV::deviceGeneratedCommands feature must be enabled", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-02966", "If the pipeline requires pre-rasterization shader state and flags includes VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV, then all stages must not specify Xfb execution mode", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03372", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03373", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03374", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03375", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03376", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03377", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-03577", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-04947", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06482", "If the dynamicRenderingLocalRead feature is not enabled, the pipeline requires fragment output interface state, and the flags member of VkPipelineColorBlendStateCreateInfo includes VK_PIPELINE_COLOR_BLEND_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_BIT_EXT, renderPass must not be VK_NULL_HANDLE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06591", "If pStages includes a fragment shader stage, and the fragment shader declares the EarlyFragmentTests execution mode, the flags member of VkPipelineDepthStencilStateCreateInfo must not include VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT or VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06596", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other flag, the value of VkMultiviewPerViewAttributesInfoNVX::perViewAttributes specified in both this pipeline and the library must be equal", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06598", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other flag, the value of VkMultiviewPerViewAttributesInfoNVX::perViewAttributesPositionXOnly specified in both this pipeline and the library must be equal", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06608", "If the shaderMeshEnqueue feature is not enabled, and the pipeline is being created with all possible state subsets, flags must not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06609", "If flags includes VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT, pipeline libraries included via VkPipelineLibraryCreateInfoKHR must have been created with VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06610", "If flags includes VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT, pipeline libraries included via VkPipelineLibraryCreateInfoKHR must have been created with VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06612", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other flag, and layout was not created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then the layout used by this pipeline and the library must be identically defined", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06614", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other subset, and layout was created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then the layout used by the library must also have been created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06616", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other subset, and layout was created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, elements of the pSetLayouts array which layout was created with that are not VK_NULL_HANDLE must be identically defined to the element at the same index of pSetLayouts used to create the library's layout", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06618", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other flag, any descriptor set layout N specified by layout in both this pipeline and the library which include bindings accessed by shader stages in each must be identically defined", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06620", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other flag, push constants specified in layout in both this pipeline and the library which are available to shader stages in each must be identically defined", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06626", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes at least one of and no more than two of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes one of the other flags, and renderPass is VK_NULL_HANDLE, the value of VkPipelineRenderingCreateInfo::viewMask used by this pipeline and that specified by the library must be identical", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06633", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT with a pMultisampleState that was not NULL, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, pMultisampleState must be identically defined to that used to create the library", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06637", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, pMultisampleState->sampleShadingEnable is VK_TRUE, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, pMultisampleState must be identically defined to that used to create the library", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06638", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other flag, values specified in VkPipelineFragmentShadingRateStateCreateInfoKHR for both this pipeline and that library must be identical", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06640", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06642", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, layout must be a valid VkPipelineLayout handle", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06643", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and renderPass is not VK_NULL_HANDLE, renderPass must be a valid VkRenderPass handle", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06644", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, stageCount must be greater than 0", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06645", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags is non-zero, if flags includes VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR, any libraries must have also been created with VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06679", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other subset, any element of the pSetLayouts array when layout was created and the corresponding element of the pSetLayouts array used to create the library's layout must not both be VK_NULL_HANDLE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06682", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes both VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, layout must have been created with no elements of the pSetLayouts array set to VK_NULL_HANDLE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06683", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and pRasterizationState->rasterizerDiscardEnable is VK_TRUE, layout must have been created with no elements of the pSetLayouts array set to VK_NULL_HANDLE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06684", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes at least one of and no more than two of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes one of the other flags, the value of subpass must be equal to that used to create the library", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06729", "If flags includes VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT, the pipeline includes a complete set of state specified entirely by libraries, and each library was created with a VkPipelineLayout created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then layout must be compatible with the union of the libraries' pipeline layouts other than the inclusion/exclusion of VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06730", "If flags does not include VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT, the pipeline includes a complete set of state specified entirely by libraries, and each library was created with a VkPipelineLayout created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then layout must be compatible with the union of the libraries' pipeline layouts", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06756", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other subset, and any element of the pSetLayouts array which layout was created with was VK_NULL_HANDLE, then the corresponding element of the pSetLayouts array used to create the library's layout must not have shader bindings for shaders in the other subset", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-06757", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes only one of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes the other subset, and any element of the pSetLayouts array used to create the library's layout was VK_NULL_HANDLE, then the corresponding element of the pSetLayouts array used to create this pipeline's layout must not have shader bindings for shaders in the other subset", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-07369", "flags must not include both VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT and VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-07401", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_OPACITY_MICROMAP_BIT_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-07984", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineIndex is -1, basePipelineHandle must be a valid graphics VkPipeline handle", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-07985", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, and basePipelineHandle is VK_NULL_HANDLE, basePipelineIndex must be a valid index into the calling command's pCreateInfos parameter", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-07986", "If flags contains the VK_PIPELINE_CREATE_DERIVATIVE_BIT flag, basePipelineIndex must be -1 or basePipelineHandle must be VK_NULL_HANDLE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-07997", "flags must not include VK_PIPELINE_CREATE_RAY_TRACING_DISPLACEMENT_MICROMAP_BIT_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08897", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_VERTEX_INPUT_INTERFACE_BIT_EXT, pre-rasterization shader state is specified either in a library or by the inclusion of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and that state includes a vertex shader stage in pStages, the pipeline must define vertex input state", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08898", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_VERTEX_INPUT_INTERFACE_BIT_EXT, and pre-rasterization shader state is not specified, the pipeline must define vertex input state", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08899", "If flags does not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, pre-rasterization shader state is specified either in a library or by the inclusion of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and that state includes a vertex shader stage in pStages, the pipeline must either define vertex input state or include that state in a linked pipeline library", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08900", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT the pipeline must define pre-rasterization shader state", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08901", "If flags does not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, the pipeline must either define pre-rasterization shader state or include that state in a linked pipeline library", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08903", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, pre-rasterization shader state is specified either in a library or by the inclusion of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and that state either includes VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE or has pRasterizationState->rasterizerDiscardEnable set to VK_FALSE, the pipeline must define fragment shader state", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08904", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and pre-rasterization shader state is not specified, the pipeline must define fragment shader state", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08906", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, pre-rasterization shader state is specified either in a library or by the inclusion of VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and that state either includes VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE or has pRasterizationState->rasterizerDiscardEnable set to VK_FALSE, the pipeline must define fragment output interface state", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08907", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and pre-rasterization shader state is not specified, the pipeline must define fragment output interface state", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-08909", "If flags does not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, pre-rasterization shader state is specified either in a library or by the inclusion of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and that state either includes VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE or has pRasterizationState->rasterizerDiscardEnable set to VK_FALSE, the pipeline must define fragment output interface state and fragment shader state or include those states in linked pipeline libraries", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-09245", "If flags includes VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT, flags must also include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-10188", "If flags does not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR, shaders specified by pStages must not declare the ShaderEnqueueAMDX capability", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-10190", "If VK_PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX is included in flags, and the pipeline requires pre-rasterization shader state, there must not be a task or vertex shader specified in pStages", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-10191", "If VK_PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX is included in flags, all elements of VkPipelineLibraryCreateInfoKHR::pLibraries must have been created with VK_PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-11000", "If flags includes VK_PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_EXT, then the VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT::deviceGeneratedCommands feature must be enabled", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-flags-11001", "If the pipeline requires pre-rasterization shader state and flags includes VK_PIPELINE_CREATE_2_INDIRECT_BINDABLE_BIT_EXT, then all stages must not specify Xfb execution mode", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-fragmentShadingRateNonTrivialCombinerOps-04506", "If the pipeline requires pre-rasterization shader state or fragment shader state, the fragmentShadingRateNonTrivialCombinerOps limit is not supported, and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, elements of VkPipelineFragmentShadingRateStateCreateInfoKHR::combinerOps must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR or VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-fragmentShadingRateNonTrivialCombinerOps-04573", "If the pipeline requires fragment shader state, and the fragmentShadingRateNonTrivialCombinerOps limit is not supported and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, elements of VkPipelineFragmentShadingRateEnumStateCreateInfoNV::combinerOps must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR or VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-geometryStreams-02321", "If the pipeline requires pre-rasterization shader state, and the last pre-rasterization shader stage is a geometry shader, and that geometry shader uses the GeometryStreams capability, then VkPhysicalDeviceTransformFeedbackFeaturesEXT::geometryStreams feature must be enabled", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-graphicsPipelineLibrary-06606", "If the graphicsPipelineLibrary feature is not enabled, and if the shaderMeshEnqueue feature is not enabled, flags must not include VK_PIPELINE_CREATE_LIBRARY_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-01688", "The number of resources in layout accessible to each shader stage that is used by the pipeline must be less than or equal to VkPhysicalDeviceLimits::maxPerStageResources", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-06602", "If the pipeline requires fragment shader state or pre-rasterization shader state, layout must be a valid VkPipelineLayout handle", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-07827", "If the pipeline includes a complete set of state specified entirely by libraries, and each library was created with a VkPipelineLayout created without VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then layout must be compatible with the layouts in those libraries", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-07987", "If a push constant block is declared in a shader, a push constant range in layout must match the shader stage", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-07988", "If a resource variable is declared in a shader, the corresponding descriptor set in layout must match the shader stage", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-07990", "If a resource variable is declared in a shader, and the descriptor type is not VK_DESCRIPTOR_TYPE_MUTABLE_EXT, the corresponding descriptor set in layout must match the descriptor type", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-07991", "If a resource variable is declared in a shader as an array, the corresponding descriptor set in layout must match the descriptor count", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-layout-10069", "If a push constant block is declared in a shader, the block must be contained inside the push constant range in layout that matches the stage", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-libraryCount-06648", "If the pipeline is not created with a complete set of state, or VkPipelineLibraryCreateInfoKHR::libraryCount is not 0, VkGraphicsPipelineShaderGroupsCreateInfoNV::groupCount and VkGraphicsPipelineShaderGroupsCreateInfoNV::pipelineCount must be 0", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-libraryCount-06649", "If the pipeline is created with a complete set of state, and VkPipelineLibraryCreateInfoKHR::libraryCount is 0, and the pNext chain includes an instance of VkGraphicsPipelineShaderGroupsCreateInfoNV, VkGraphicsPipelineShaderGroupsCreateInfoNV::groupCount must be greater than 0", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-lineRasterizationMode-02766", "If the pipeline requires pre-rasterization shader state and at least one of fragment output interface state or fragment shader state, and pMultisampleState is not NULL, the lineRasterizationMode member of a VkPipelineRasterizationLineStateCreateInfo structure included in the pNext chain of pRasterizationState is VK_LINE_RASTERIZATION_MODE_BRESENHAM or VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH, then the alphaToCoverageEnable, alphaToOneEnable, and sampleShadingEnable members of pMultisampleState must all be VK_FALSE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-maintenance5-08775", "If the maintenance5 feature is enabled and a PointSize decorated variable is written to, all execution paths must write to a PointSize decorated variable", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-multisampledRenderToSingleSampled-06853", "If the pipeline requires fragment output interface state, and none of the VK_AMD_mixed_attachment_samples extension, the VK_NV_framebuffer_mixed_samples extension, or the multisampledRenderToSingleSampled feature are enabled, rasterizationSamples is not dynamic, and if subpass uses color and/or depth/stencil attachments, then the rasterizationSamples member of pMultisampleState must be the same as the sample count for those subpass attachments", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-multiview-06577", "If the multiview feature is not enabled, the pipeline requires pre-rasterization shader state, fragment shader state, or fragment output interface state, and renderPass is VK_NULL_HANDLE, VkPipelineRenderingCreateInfo::viewMask must be 0", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pColorAttachmentSamples-06592", "If the fragment output interface state, elements of the pColorAttachmentSamples member of VkAttachmentSampleCountInfoAMD or VkAttachmentSampleCountInfoNV must be valid VkSampleCountFlagBits values", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pColorBlendState-09038", "If pColorBlendState is not NULL it must be a valid pointer to a valid VkPipelineColorBlendStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDepthStencilState-09029", "If pDepthStencilState is not NULL it must be a valid pointer to a valid VkPipelineDepthStencilStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDepthStencilState-09034", "If pDepthStencilState is not NULL it must be a valid pointer to a valid VkPipelineDepthStencilStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDepthStencilState-09036", "If pDepthStencilState is not NULL it must be a valid pointer to a valid VkPipelineDepthStencilStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04494", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.width must be greater than or equal to 1", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04495", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.height must be greater than or equal to 1", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04496", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.width must be a power-of-two value", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04497", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.height must be a power-of-two value", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04498", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.width must be less than or equal to 4", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04499", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.height must be less than or equal to 4", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04500", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the pipelineFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.width and VkPipelineFragmentShadingRateStateCreateInfoKHR::fragmentSize.height must both be equal to 1", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04501", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the primitiveFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateStateCreateInfoKHR::combinerOps[0] must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04502", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the attachmentFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateStateCreateInfoKHR::combinerOps[1] must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04569", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the fragmentShadingRateEnums feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRateType must be equal to VK_FRAGMENT_SHADING_RATE_TYPE_FRAGMENT_SIZE_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04570", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the pipelineFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRate must be equal to VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04571", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the primitiveFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::combinerOps[0] must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-04572", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, and the attachmentFragmentShadingRate feature is not enabled, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::combinerOps[1] must be VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-06567", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::combinerOps[0] must be a valid VkFragmentShadingRateCombinerOpKHR value", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-06568", "If the pipeline requires pre-rasterization shader state or fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateStateCreateInfoKHR::combinerOps[1] must be a valid VkFragmentShadingRateCombinerOpKHR value", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-06570", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::shadingRate must be a valid VkFragmentShadingRateNV value", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-06571", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::combinerOps[0] must be a valid VkFragmentShadingRateCombinerOpKHR value", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-06572", "If the pipeline requires fragment shader state and VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR is not included in pDynamicState->pDynamicStates, VkPipelineFragmentShadingRateEnumStateCreateInfoNV::combinerOps[1] must be a valid VkFragmentShadingRateCombinerOpKHR value", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-09639", "If the pipeline requires pre-rasterization shader state, pDynamicState includes VK_DYNAMIC_STATE_CONSERVATIVE_RASTERIZATION_MODE_EXT, and pDynamicState does not include VK_DYNAMIC_STATE_EXTRA_PRIMITIVE_OVERESTIMATION_SIZE_EXT, pRasterizationState must include a VkPipelineRasterizationConservativeStateCreateInfoEXT in its pNext chain", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicState-parameter", "If pDynamicState is not NULL, pDynamicState must be a valid pointer to a valid VkPipelineDynamicStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00749", "If the pipeline requires pre-rasterization shader state, and the wideLines feature is not enabled, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_LINE_WIDTH, the lineWidth member of pRasterizationState must be 1.0", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-00754", "If the pipeline requires pre-rasterization shader state, the depthBiasClamp feature is not enabled, no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_DEPTH_BIAS, and the depthBiasEnable member of pRasterizationState is VK_TRUE, the depthBiasClamp member of pRasterizationState must be 0.0", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-01715", "If the pipeline requires pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV, and the viewportWScalingEnable member of a VkPipelineViewportWScalingStateCreateInfoNV structure, included in the pNext chain of pViewportState, is VK_TRUE, the pViewportWScalings member of the VkPipelineViewportWScalingStateCreateInfoNV must be a pointer to an array of VkPipelineViewportWScalingStateCreateInfoNV::viewportCount valid VkViewportWScalingNV structures", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-02510", "If the pipeline requires fragment shader state, the VK_EXT_depth_range_unrestricted extension is not enabled and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_DEPTH_BOUNDS, and the depthBoundsTestEnable member of pDepthStencilState is VK_TRUE, the minDepthBounds and maxDepthBounds members of pDepthStencilState must be between 0.0 and 1.0, inclusive", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-03378", "If the extendedDynamicState feature is not enabled, and the minimum value of VkApplicationInfo::apiVersion used to create the VkInstance and apiVersion supported by the physical device is less than Version 1.3 there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_CULL_MODE, VK_DYNAMIC_STATE_FRONT_FACE, VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY, VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT, VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT, VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE, VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE, VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE, VK_DYNAMIC_STATE_DEPTH_COMPARE_OP, VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE, VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE, or VK_DYNAMIC_STATE_STENCIL_OP", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-03379", "If the pipeline requires pre-rasterization shader state, and VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT is included in the pDynamicStates array then viewportCount must be zero", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-03380", "If the pipeline requires pre-rasterization shader state, and VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT is included in the pDynamicStates array then scissorCount must be zero", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-03578", "All elements of the pDynamicStates member of pDynamicState must not be VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04056", "If the pipeline requires pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV, and if pViewportState->pNext chain includes a VkPipelineViewportExclusiveScissorStateCreateInfoNV structure, and if its exclusiveScissorCount member is not 0, then its pExclusiveScissors member must be a valid pointer to an array of exclusiveScissorCount VkRect2D structures", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04057", "If the pipeline requires pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV, and if pViewportState->pNext chain includes a VkPipelineViewportShadingRateImageStateCreateInfoNV structure, then its pShadingRatePalettes member must be a valid pointer to an array of viewportCount valid VkShadingRatePaletteNV structures", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04058", "If the pipeline requires pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT, and if pNext chain includes a VkPipelineDiscardRectangleStateCreateInfoEXT structure, and if its discardRectangleCount member is not 0, then its pDiscardRectangles member must be a valid pointer to an array of discardRectangleCount VkRect2D structures", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04130", "If the pipeline requires pre-rasterization shader state, and pViewportState->pViewports is not dynamic, then pViewportState->pViewports must be a valid pointer to an array of pViewportState->viewportCount valid VkViewport structures", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04131", "If the pipeline requires pre-rasterization shader state, and pViewportState->pScissors is not dynamic, then pViewportState->pScissors must be a valid pointer to an array of pViewportState->scissorCount VkRect2D structures", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04132", "If the pipeline requires pre-rasterization shader state, and VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT is included in the pDynamicStates array then VK_DYNAMIC_STATE_VIEWPORT must not be present", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04133", "If the pipeline requires pre-rasterization shader state, and VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT is included in the pDynamicStates array then VK_DYNAMIC_STATE_SCISSOR must not be present", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04800", "If the colorWriteEnable feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04807", "If the pipeline requires pre-rasterization shader state and the vertexInputDynamicState feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_VERTEX_INPUT_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04868", "If the extendedDynamicState2 feature is not enabled, and the minimum value of VkApplicationInfo::apiVersion used to create the VkInstance and apiVersion supported by the physical device is less than Version 1.3 there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE, VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE, or VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04869", "If the extendedDynamicState2LogicOp feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_LOGIC_OP_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-04870", "If the extendedDynamicState2PatchControlPoints feature is not enabled, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07065", "If the pipeline requires pre-rasterization shader state, and includes a mesh shader, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY, or VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07066", "If the pipeline requires pre-rasterization shader state, and includes a mesh shader, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE, or VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07067", "If the pipeline requires pre-rasterization shader state, and includes a mesh shader, there must be no element of the pDynamicStates member of pDynamicState set to VK_DYNAMIC_STATE_VERTEX_INPUT_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07610", "If the pipeline requires fragment shader state or fragment output interface state, and rasterizationSamples and sampleLocationsInfo are not dynamic, and VkPipelineSampleLocationsStateCreateInfoEXT::sampleLocationsEnable included in the pNext chain of pMultisampleState is VK_TRUE, sampleLocationsInfo.sampleLocationGridSize.width must evenly divide VkMultisamplePropertiesEXT::maxSampleLocationGridSize.width as returned by vkGetPhysicalDeviceMultisamplePropertiesEXT with a samples parameter equaling rasterizationSamples", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07611", "If the pipeline requires fragment shader state or fragment output interface state, and rasterizationSamples and sampleLocationsInfo are not dynamic, and VkPipelineSampleLocationsStateCreateInfoEXT::sampleLocationsEnable the included in the pNext chain of pMultisampleState is VK_TRUE or VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT is used, sampleLocationsInfo.sampleLocationGridSize.height must evenly divide VkMultisamplePropertiesEXT::maxSampleLocationGridSize.height as returned by vkGetPhysicalDeviceMultisamplePropertiesEXT with a samples parameter equaling rasterizationSamples", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07612", "If the pipeline requires fragment shader state or fragment output interface state, and rasterizationSamples and sampleLocationsInfo are not dynamic, and VkPipelineSampleLocationsStateCreateInfoEXT::sampleLocationsEnable included in the pNext chain of pMultisampleState is VK_TRUE or VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_ENABLE_EXT is used, sampleLocationsInfo.sampleLocationsPerPixel must equal rasterizationSamples", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07730", "If the pipeline requires pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_VIEWPORT or VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT, and if the multiviewPerViewViewports feature is enabled, then the index of the most significant bit in each element of VkRenderPassMultiviewCreateInfo::pViewMasks must be less than pViewportState->viewportCount", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07731", "If the pipeline requires pre-rasterization shader state, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_SCISSOR or VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT, and if the multiviewPerViewViewports feature is enabled, then the index of the most significant bit in each element of VkRenderPassMultiviewCreateInfo::pViewMasks must be less than pViewportState->scissorCount", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07854", "If VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_ENABLE_NV is included in the pDynamicStates array then the implementation must support at least specVersion 2 of the VK_NV_scissor_exclusive extension", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07855", "If VK_DYNAMIC_STATE_DISCARD_RECTANGLE_ENABLE_EXT is included in the pDynamicStates array then the implementation must support at least specVersion 2 of the VK_EXT_discard_rectangles extension", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pDynamicStates-07856", "If VK_DYNAMIC_STATE_DISCARD_RECTANGLE_MODE_EXT is included in the pDynamicStates array then the implementation must support at least specVersion 2 of the VK_EXT_discard_rectangles extension", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pInputAssemblyState-09032", "If pInputAssemblyState is not NULL it must be a valid pointer to a valid VkPipelineInputAssemblyStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06597", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, the value of VkMultiviewPerViewAttributesInfoNVX::perViewAttributes specified in both libraries must be equal", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06599", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, the value of VkMultiviewPerViewAttributesInfoNVX::perViewAttributesPositionXOnly specified in both libraries must be equal", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06611", "Any pipeline libraries included via VkPipelineLibraryCreateInfoKHR::pLibraries must not include any state subset already defined by this structure or defined by any other pipeline library in VkPipelineLibraryCreateInfoKHR::pLibraries", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06613", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and the layout specified by either library was not created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then the layout used by each library must be identically defined", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06615", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and the layout specified by either library was created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, then the layout used by both libraries must have been created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06617", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and the layout specified by either library was created with VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT, elements of the pSetLayouts array which either layout was created with that are not VK_NULL_HANDLE must be identically defined to the element at the same index of pSetLayouts used to create the other library's layout", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06619", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, any descriptor set layout N specified by layout in both libraries which include bindings accessed by shader stages in each must be identically defined", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06621", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, push constants specified in layout in both this pipeline and the library which are available to shader stages in each must be identically defined", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06623", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes at least one of and no more than two of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and another element of VkPipelineLibraryCreateInfoKHR::pLibraries includes one of the other flags, the value of subpass used to create each library must be identical", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06627", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes at least one of and no more than two of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, another element of VkPipelineLibraryCreateInfoKHR::pLibraries includes one of the other flags, and renderPass was VK_NULL_HANDLE for both libraries, the value of VkPipelineRenderingCreateInfo::viewMask set by each library must be identical", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06628", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes at least one of and no more than two of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and another element of VkPipelineLibraryCreateInfoKHR::pLibraries includes one of the other flags, the renderPass objects used to create each library must be compatible or all equal to VK_NULL_HANDLE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06634", "If an element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT with a pMultisampleState that was not NULL, and if VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, pMultisampleState must be identically defined to that used to create the library", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06635", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT with a pMultisampleState that was not NULL, and if a different element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, the pMultisampleState used to create each library must be identically defined", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06636", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT and a value of pMultisampleState->sampleShadingEnable equal VK_TRUE, and if a different element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, the pMultisampleState used to create each library must be identically defined", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06639", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, values specified in VkPipelineFragmentShadingRateStateCreateInfoKHR for both this pipeline and that library must be identical", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06646", "If VkPipelineLibraryCreateInfoKHR::pLibraries includes more than one library, and any library was created with VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR, all libraries must have also been created with VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06647", "If VkPipelineLibraryCreateInfoKHR::pLibraries includes at least one library, VkGraphicsPipelineLibraryCreateInfoEXT::flags is non-zero, and any library was created with VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR, flags must include VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06681", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and any element of the pSetLayouts array used to create each library's layout was VK_NULL_HANDLE, then the corresponding element of the pSetLayouts array used to create the other library's layout must not be VK_NULL_HANDLE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-06758", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT and another element includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, and any element of the pSetLayouts array used to create each library's layout was VK_NULL_HANDLE, then the corresponding element of the pSetLayouts array used to create the other library's layout must not have shader bindings for shaders in the other subset", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pLibraries-09567", "If one element of VkPipelineLibraryCreateInfoKHR::pLibraries was created with VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT and a value of pMultisampleState->sampleShadingEnable equal VK_TRUE, and if VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, pMultisampleState must be identically defined to that used to create the library", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pMultisampleState-09026", "If the pipeline requires fragment output interface state, and the VK_EXT_extended_dynamic_state3 extension is not enabled or any of the VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT, VK_DYNAMIC_STATE_SAMPLE_MASK_EXT, or VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT dynamic states is not set, or the alphaToOne feature is enabled and VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT is not set, pMultisampleState must be a valid pointer to a valid VkPipelineMultisampleStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pMultisampleState-09027", "If pMultisampleState is not NULL it must be a valid pointer to a valid VkPipelineMultisampleStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pNext-pNext", "Each pNext member of any structure (including this one) in the pNext chain must be either NULL or a pointer to a valid instance of VkAttachmentSampleCountInfoAMD, VkExternalFormatANDROID, VkGraphicsPipelineLibraryCreateInfoEXT, VkGraphicsPipelineShaderGroupsCreateInfoNV, VkMultiviewPerViewAttributesInfoNVX, VkPipelineBinaryInfoKHR, VkPipelineCompilerControlCreateInfoAMD, VkPipelineCreateFlags2CreateInfo, VkPipelineCreationFeedbackCreateInfo, VkPipelineDiscardRectangleStateCreateInfoEXT, VkPipelineFragmentDensityMapLayeredCreateInfoVALVE, VkPipelineFragmentShadingRateEnumStateCreateInfoNV, VkPipelineFragmentShadingRateStateCreateInfoKHR, VkPipelineLibraryCreateInfoKHR, VkPipelineRenderingCreateInfo, VkPipelineRepresentativeFragmentTestStateCreateInfoNV, VkPipelineRobustnessCreateInfo, VkRenderingAttachmentLocationInfo, or VkRenderingInputAttachmentIndexInfo", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pRasterizationState-06601", "If the pipeline requires pre-rasterization shader state, and related dynamic state is not set, pRasterizationState must be a valid pointer to a valid VkPipelineRasterizationStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pRasterizationState-09039", "If VkGraphicsPipelineLibraryCreateInfoEXT::flags includes VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, and related dynamic state is not set, then pMultisampleState must be a valid pointer to a valid VkPipelineMultisampleStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pRasterizationState-09040", "If pRasterizationState is not NULL it must be a valid pointer to a valid VkPipelineRasterizationStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00729", "If the pipeline requires pre-rasterization shader state and pStages includes a tessellation control shader stage, it must include a tessellation evaluation shader stage", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00730", "If the pipeline requires pre-rasterization shader state and pStages includes a tessellation evaluation shader stage, it must include a tessellation control shader stage", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00732", "If the pipeline requires pre-rasterization shader state and pStages includes tessellation shader stages, the shader code of at least one stage must contain an OpExecutionMode instruction specifying the type of subdivision in the pipeline", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00733", "If the pipeline requires pre-rasterization shader state and pStages includes tessellation shader stages, and the shader code of both stages contain an OpExecutionMode instruction specifying the type of subdivision in the pipeline, they must both specify the same subdivision mode", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00734", "If the pipeline requires pre-rasterization shader state and pStages includes tessellation shader stages, the shader code of at least one stage must contain an OpExecutionMode instruction specifying the output patch size in the pipeline", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00735", "If the pipeline requires pre-rasterization shader state and pStages includes tessellation shader stages, and the shader code of both contain an OpExecutionMode instruction specifying the out patch size in the pipeline, they must both specify the same patch size", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00738", "If the pipeline requires pre-rasterization shader state and pStages includes a geometry shader stage, and does not include any tessellation shader stages, its shader code must contain an OpExecutionMode instruction specifying an input primitive type that is compatible with the primitive topology specified in pInputAssembly", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00739", "If the pipeline requires pre-rasterization shader state and pStages includes a geometry shader stage, and also includes tessellation shader stages, its shader code must contain an OpExecutionMode instruction specifying an input primitive type that is compatible with the primitive topology that is output by the tessellation stages", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00740", "If the pipeline requires pre-rasterization shader state and fragment shader state, it includes both a fragment shader and a geometry shader, and the fragment shader code reads from an input variable that is decorated with PrimitiveId, then the geometry shader code must write to a matching output variable, decorated with PrimitiveId, in all execution paths", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-00742", "If the pipeline requires pre-rasterization shader state and multiple pre-rasterization shader stages are included in pStages, the shader code for the entry points identified by those pStages and the rest of the state identified by this structure must adhere to the pipeline linking rules described in the Shader Interfaces chapter", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-01565", "If the pipeline requires fragment shader state and an input attachment was referenced by an aspectMask at renderPass creation time, the fragment shader must only read from the aspects that were specified for that input attachment", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02095", "If the pipeline requires pre-rasterization shader state the geometric shader stages provided in pStages must be either from the mesh shading pipeline (stage is VK_SHADER_STAGE_TASK_BIT_EXT or VK_SHADER_STAGE_MESH_BIT_EXT) or from the primitive shading pipeline (stage is VK_SHADER_STAGE_VERTEX_BIT, VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT, VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT, or VK_SHADER_STAGE_GEOMETRY_BIT)", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02097", "If the pipeline requires vertex input state, and pVertexInputState is not dynamic, then pVertexInputState must be a valid pointer to a valid VkPipelineVertexInputStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02317", "If the pipeline requires pre-rasterization shader state, the Xfb execution mode can be specified by no more than one shader stage in pStages", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-02318", "If the pipeline requires pre-rasterization shader state, and any shader stage in pStages specifies Xfb execution mode it must be the last pre-rasterization shader stage", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-06600", "If the pipeline requires pre-rasterization shader state or fragment shader state, pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-06894", "If the pipeline requires pre-rasterization shader state but not fragment shader state, elements of pStages must not have stage set to VK_SHADER_STAGE_FRAGMENT_BIT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-06895", "If the pipeline requires fragment shader state but not pre-rasterization shader state, elements of pStages must not have stage set to a shader stage which participates in pre-rasterization", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-06896", "If the pipeline requires pre-rasterization shader state, all elements of pStages must have a stage set to a shader stage which participates in fragment shader state or pre-rasterization shader state", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-08711", "If pStages includes a fragment shader stage, VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE is not set in VkPipelineDynamicStateCreateInfo::pDynamicStates, and the fragment shader declares the EarlyFragmentTests execution mode and uses OpDepthAttachmentReadEXT, the depthWriteEnable member of VkPipelineDepthStencilStateCreateInfo must be VK_FALSE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-08712", "If pStages includes a fragment shader stage, VK_DYNAMIC_STATE_STENCIL_WRITE_MASK is not set in VkPipelineDynamicStateCreateInfo::pDynamicStates, and the fragment shader declares the EarlyFragmentTests execution mode and uses OpStencilAttachmentReadEXT, the value of VkStencilOpState::writeMask for both front and back in VkPipelineDepthStencilStateCreateInfo must be 0", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-08888", "If the pipeline is being created with pre-rasterization shader state and vertex input state and pStages includes tessellation shader stages, and either VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY dynamic state is not enabled or dynamicPrimitiveTopologyUnrestricted is VK_FALSE, the topology member of pInputAssembly must be VK_PRIMITIVE_TOPOLOGY_PATCH_LIST", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-09022", "If the pipeline requires pre-rasterization shader state and pStages includes a tessellation control shader stage, and the VK_EXT_extended_dynamic_state3 extension is not enabled or the VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT dynamic state is not set, pTessellationState must be a valid pointer to a valid VkPipelineTessellationStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-09631", "If the pipeline requires pre-rasterization shader state and pStages contains both VK_SHADER_STAGE_TASK_BIT_EXT and VK_SHADER_STAGE_MESH_BIT_EXT, then the mesh shader's entry point must not declare a variable with a DrawIndex BuiltIn decoration", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pStages-10189", "If any shader stages in pStages declare the ShaderEnqueueAMDX capability, VK_PIPELINE_CREATE_2_EXECUTION_GRAPH_BIT_AMDX and VK_PIPELINE_CREATE_2_LIBRARY_BIT_KHR must be included in flags", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pTessellationState-09023", "If pTessellationState is not NULL it must be a pointer to a valid VkPipelineTessellationStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pVertexInputState-08929", "If the pipeline is being created with vertex input state and pVertexInputState is not dynamic, and VkVertexInputAttributeDescription::format has a 64-bit component, then the scalar width associated with all Input variables of the corresponding Location in the Vertex Execution Model OpEntryPoint must be 64-bit", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pVertexInputState-08930", "If the pipeline is being created with vertex input state and pVertexInputState is not dynamic, and the scalar width associated with a Location decorated Input variable in the Vertex Execution Model OpEntryPoint is 64-bit, then the corresponding VkVertexInputAttributeDescription::format must have a 64-bit component", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pVertexInputState-09198", "If the pipeline is being created with vertex input state and pVertexInputState is not dynamic, and VkVertexInputAttributeDescription::format has a 64-bit component, then all Input variables at the corresponding Location in the Vertex Execution Model OpEntryPoint must not use components that are not present in the format", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pViewportState-09025", "If pViewportState is not NULL it must be a valid pointer to a valid VkPipelineViewportStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pipelineCreationCacheControl-02878", "If the pipelineCreationCacheControl feature is not enabled, flags must not include VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT or VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pipelineProtectedAccess-07368", "If the pipelineProtectedAccess feature is not enabled, flags must not include VK_PIPELINE_CREATE_NO_PROTECTED_ACCESS_BIT or VK_PIPELINE_CREATE_PROTECTED_ACCESS_ONLY_BIT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-pipelineStageCreationFeedbackCount-06594", "If VkPipelineCreationFeedbackCreateInfo::pipelineStageCreationFeedbackCount is not 0, it must be equal to stageCount", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-primitiveFragmentShadingRateWithMultipleViewports-04503", "If the pipeline requires pre-rasterization shader state and the primitiveFragmentShadingRateWithMultipleViewports limit is not supported, VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT is not included in pDynamicState->pDynamicStates, and VkPipelineViewportStateCreateInfo::viewportCount is greater than 1, entry points specified in pStages must not write to the PrimitiveShadingRateKHR built-in", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-primitiveFragmentShadingRateWithMultipleViewports-04504", "If the pipeline requires pre-rasterization shader state and the primitiveFragmentShadingRateWithMultipleViewports limit is not supported, and entry points specified in pStages write to the ViewportIndex built-in, they must not also write to the PrimitiveShadingRateKHR built-in", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-primitiveFragmentShadingRateWithMultipleViewports-04505", "If the pipeline requires pre-rasterization shader state and the primitiveFragmentShadingRateWithMultipleViewports limit is not supported, and entry points specified in pStages write to the ViewportMaskNV built-in, they must not also write to the PrimitiveShadingRateKHR built-in", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizationSamples-04899", "If the pipeline requires fragment shader state, and the VK_QCOM_render_pass_shader_resolve extension is enabled, rasterizationSamples is not dynamic, and if subpass has any input attachments, and if the subpass description contains VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM, then the sample count of the input attachments must equal rasterizationSamples", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizationStream-02319", "If the pipeline requires pre-rasterization shader state, and a VkPipelineRasterizationStateStreamCreateInfoEXT::rasterizationStream value other than zero is specified, all variables in the output interface of the entry point being compiled decorated with Position, PointSize, ClipDistance, or CullDistance must be decorated with identical Stream values that match the rasterizationStream", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizationStream-02320", "If the pipeline requires pre-rasterization shader state, and VkPipelineRasterizationStateStreamCreateInfoEXT::rasterizationStream is zero, or not specified, all variables in the output interface of the entry point being compiled decorated with Position, PointSize, ClipDistance, or CullDistance must be decorated with a Stream value of zero, or must not specify the Stream decoration", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-rasterizerDiscardEnable-09024", "If the pipeline requires pre-rasterization shader state, and the VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE dynamic state is enabled or the rasterizerDiscardEnable member of pRasterizationState is VK_FALSE, and related dynamic state is not set, pViewportState must be a valid pointer to a valid VkPipelineViewportStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06038", "If renderPass is not VK_NULL_HANDLE and the pipeline is being created with fragment shader state the fragment shader must not read from any input attachment that is defined as VK_ATTACHMENT_UNUSED in subpass", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06041", "If renderPass is not VK_NULL_HANDLE, and the pipeline is being created with fragment output interface state, then for each color attachment in the subpass, if the potential format features of the format of the corresponding attachment description do not contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT, then the blendEnable member of the corresponding element of the pAttachments member of pColorBlendState must be VK_FALSE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06046", "If renderPass is not VK_NULL_HANDLE, subpass must be a valid subpass within renderPass", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06047", "If renderPass is not VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state, subpass viewMask is not 0, and multiviewTessellationShader is not enabled, then pStages must not include tessellation shaders", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06048", "If renderPass is not VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state, subpass viewMask is not 0, and multiviewGeometryShader is not enabled, then pStages must not include a geometry shader", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06050", "If renderPass is not VK_NULL_HANDLE and the pipeline is being created with pre-rasterization shader state, and subpass viewMask is not 0, then all of the shaders in the pipeline must not include variables decorated with the Layer built-in decoration in their interfaces", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06055", "If renderPass is VK_NULL_HANDLE, pColorBlendState is not dynamic, and the pipeline is being created with fragment output interface state, pColorBlendState->attachmentCount must be equal to VkPipelineRenderingCreateInfo::colorAttachmentCount", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06057", "If renderPass is VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state, VkPipelineRenderingCreateInfo::viewMask is not 0, and the multiviewTessellationShader feature is not enabled, then pStages must not include tessellation shaders", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06058", "If renderPass is VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state, VkPipelineRenderingCreateInfo::viewMask is not 0, and the multiviewGeometryShader feature is not enabled, then pStages must not include a geometry shader", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06059", "If renderPass is VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state, and VkPipelineRenderingCreateInfo::viewMask is not 0, all of the shaders in the pipeline must not include variables decorated with the Layer built-in decoration in their interfaces", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06061", "If the dynamicRenderingLocalRead feature is not enabled, the pipeline requires fragment shader state, and renderPass is VK_NULL_HANDLE, fragment shaders in pStages must not include the InputAttachment capability", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06062", "If the pipeline requires fragment output interface state and renderPass is VK_NULL_HANDLE, for each color attachment format defined by the pColorAttachmentFormats member of VkPipelineRenderingCreateInfo, if its potential format features do not contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT, then the blendEnable member of the corresponding element of the pAttachments member of pColorBlendState must be VK_FALSE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06063", "If the pipeline requires fragment output interface state and renderPass is VK_NULL_HANDLE, if the pNext chain includes VkAttachmentSampleCountInfoAMD or VkAttachmentSampleCountInfoNV, the colorAttachmentCount member of that structure must be equal to the value of VkPipelineRenderingCreateInfo::colorAttachmentCount", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06578", "If the pipeline requires pre-rasterization shader state, fragment shader state, or fragment output interface state, and renderPass is VK_NULL_HANDLE, the index of the most significant bit in VkPipelineRenderingCreateInfo::viewMask must be less than maxMultiviewViewCount", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06579", "If the pipeline requires fragment output interface state, and renderPass is VK_NULL_HANDLE, and VkPipelineRenderingCreateInfo::colorAttachmentCount is not 0, VkPipelineRenderingCreateInfo::pColorAttachmentFormats must be a valid pointer to an array of colorAttachmentCount valid VkFormat values", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06580", "If the pipeline requires fragment output interface state, and renderPass is VK_NULL_HANDLE, each element of VkPipelineRenderingCreateInfo::pColorAttachmentFormats must be a valid VkFormat value", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06582", "If the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and any element of VkPipelineRenderingCreateInfo::pColorAttachmentFormats is not VK_FORMAT_UNDEFINED, that format must be a format with potential format features that include VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or VK_FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06583", "If the pipeline requires fragment output interface state, and renderPass is VK_NULL_HANDLE, VkPipelineRenderingCreateInfo::depthAttachmentFormat must be a valid VkFormat value", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06584", "If the pipeline requires fragment output interface state, and renderPass is VK_NULL_HANDLE, VkPipelineRenderingCreateInfo::stencilAttachmentFormat must be a valid VkFormat value", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06585", "If the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkPipelineRenderingCreateInfo::depthAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06586", "If the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkPipelineRenderingCreateInfo::stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format with potential format features that include VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06587", "If the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkPipelineRenderingCreateInfo::depthAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format that includes a depth component", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06588", "If the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, and VkPipelineRenderingCreateInfo::stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, it must be a format that includes a stencil component", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06589", "If the pipeline requires fragment output interface state, renderPass is VK_NULL_HANDLE, VkPipelineRenderingCreateInfo::depthAttachmentFormat is not VK_FORMAT_UNDEFINED, and VkPipelineRenderingCreateInfo::stencilAttachmentFormat is not VK_FORMAT_UNDEFINED, depthAttachmentFormat must equal stencilAttachmentFormat", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06595", "If renderPass is VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state or fragment shader state, and VkMultiviewPerViewAttributesInfoNVX::perViewAttributesPositionXOnly is VK_TRUE then VkMultiviewPerViewAttributesInfoNVX::perViewAttributes must also be VK_TRUE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06603", "If the pipeline requires pre-rasterization shader state, fragment shader state, or fragment output state, and renderPass is not VK_NULL_HANDLE, renderPass must be a valid VkRenderPass handle", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-06854", "If renderPass is not VK_NULL_HANDLE, the VK_EXT_multisampled_render_to_single_sampled extension is enabled, rasterizationSamples is not dynamic, and subpass has a VkMultisampledRenderToSingleSampledInfoEXT structure included in the VkSubpassDescription2::pNext chain with multisampledRenderToSingleSampledEnable equal to VK_TRUE, then the rasterizationSamples member of pMultisampleState must be equal to VkMultisampledRenderToSingleSampledInfoEXT::rasterizationSamples", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-07064", "If renderPass is not VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state, subpass viewMask is not 0, and multiviewMeshShader is not enabled, then pStages must not include a mesh shader", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-07609", "If renderPass is not VK_NULL_HANDLE, the pipeline is being created with fragment output interface state, the pColorBlendState pointer is not NULL, the attachmentCount member of pColorBlendState is not ignored, and the subpass uses color attachments, the attachmentCount member of pColorBlendState must be equal to the colorAttachmentCount used to create subpass", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-07720", "If renderPass is VK_NULL_HANDLE, the pipeline is being created with pre-rasterization shader state, and VkPipelineRenderingCreateInfo::viewMask is not 0, and multiviewMeshShader is not enabled, then pStages must not include a mesh shader", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-08710", "If the pipeline requires fragment shader state and renderPass is not VK_NULL_HANDLE, fragment shaders in pStages must not include any of the TileImageColorReadAccessEXT, TileImageDepthReadAccessEXT, or TileImageStencilReadAccessEXT capabilities", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-08744", "If renderPass is VK_NULL_HANDLE, the pipeline requires fragment output state or fragment shader state, the pipeline enables sample shading, rasterizationSamples is not dynamic, and the pNext chain includes a VkPipelineRenderingCreateInfo structure, rasterizationSamples must be a valid VkSampleCountFlagBits value that is set in imageCreateSampleCounts (as defined in Image Creation Limits) for every element of depthAttachmentFormat, stencilAttachmentFormat and the pColorAttachmentFormats array which is not VK_FORMAT_UNDEFINED", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09028", "If renderPass is not VK_NULL_HANDLE, the pipeline is being created with fragment shader state, and subpass uses a depth/stencil attachment, and related dynamic state is not set, pDepthStencilState must be a valid pointer to a valid VkPipelineDepthStencilStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09030", "If renderPass is not VK_NULL_HANDLE, the pipeline is being created with fragment output interface state, and subpass uses color attachments, and related dynamic state is not set, pColorBlendState must be a valid pointer to a valid VkPipelineColorBlendStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09033", "If renderPass is VK_NULL_HANDLE, the pipeline is being created with fragment shader state and fragment output interface state, and either of VkPipelineRenderingCreateInfo::depthAttachmentFormat or VkPipelineRenderingCreateInfo::stencilAttachmentFormat are not VK_FORMAT_UNDEFINED, and the VK_EXT_extended_dynamic_state3 extension is not enabled or any of the VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE, VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE, VK_DYNAMIC_STATE_DEPTH_COMPARE_OP, VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE, VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE, VK_DYNAMIC_STATE_STENCIL_OP, or VK_DYNAMIC_STATE_DEPTH_BOUNDS dynamic states are not set, pDepthStencilState must be a valid pointer to a valid VkPipelineDepthStencilStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09035", "If renderPass is VK_NULL_HANDLE and the pipeline is being created with fragment shader state but not fragment output interface state, and the VK_EXT_extended_dynamic_state3 extension is not enabled, or any of the VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE, VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE, VK_DYNAMIC_STATE_DEPTH_COMPARE_OP, VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE, VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE, VK_DYNAMIC_STATE_STENCIL_OP, or VK_DYNAMIC_STATE_DEPTH_BOUNDS dynamic states are not set, pDepthStencilState must be a valid pointer to a valid VkPipelineDepthStencilStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09037", "If renderPass is VK_NULL_HANDLE, the pipeline is being created with fragment output interface state, and any element of VkPipelineRenderingCreateInfo::pColorAttachmentFormats is not VK_FORMAT_UNDEFINED, and the VK_EXT_extended_dynamic_state3 extension is not enabled, or any of the VK_DYNAMIC_STATE_LOGIC_OP_ENABLE_EXT, VK_DYNAMIC_STATE_LOGIC_OP_EXT, VK_DYNAMIC_STATE_COLOR_BLEND_ENABLE_EXT, VK_DYNAMIC_STATE_COLOR_BLEND_EQUATION_EXT, VK_DYNAMIC_STATE_COLOR_WRITE_MASK_EXT, or VK_DYNAMIC_STATE_BLEND_CONSTANTS dynamic states are not set, pColorBlendState must be a valid pointer to a valid VkPipelineColorBlendStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09527", "If the pipeline requires fragment output interface state, renderPass is not VK_NULL_HANDLE, and the flags member of VkPipelineColorBlendStateCreateInfo includes VK_PIPELINE_COLOR_BLEND_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_BIT_EXT subpass must have been created with VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_COLOR_ACCESS_BIT_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09528", "If the pipeline requires fragment shader state, renderPass is not VK_NULL_HANDLE, and the flags member of VkPipelineDepthStencilStateCreateInfo includes VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT, subpass must have been created with VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09529", "If the pipeline requires fragment shader state, renderPass is not VK_NULL_HANDLE, and the flags member of VkPipelineDepthStencilStateCreateInfo includes VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT, subpass must have been created with VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09531", "If the pipeline is being created with fragment shader state and fragment output state, the value of renderPass is VK_NULL_HANDLE, and VkRenderingInputAttachmentIndexInfo is included, VkRenderingInputAttachmentIndexInfo::colorAttachmentCount must be equal to VkPipelineRenderingCreateInfo::colorAttachmentCount", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09532", "If the pipeline is being created with fragment output state, and the value of renderPass is VK_NULL_HANDLE, VkRenderingAttachmentLocationInfo::colorAttachmentCount must be equal to VkPipelineRenderingCreateInfo::colorAttachmentCount", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderPass-09652", "If the pipeline is being created with fragment shader state and fragment output state, the value of renderPass is VK_NULL_HANDLE, and VkRenderingInputAttachmentIndexInfo is not included, the fragment shader must not contain any input attachments with a InputAttachmentIndex greater than or equal to VkPipelineRenderingCreateInfo::colorAttachmentCount", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderpass-06624", "If renderpass is not VK_NULL_HANDLE, VkGraphicsPipelineLibraryCreateInfoEXT::flags includes at least one of and no more than two of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes one of the other flags, renderPass must be compatible with that used to create the library", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderpass-06625", "If renderpass is VK_NULL_HANDLE, VkGraphicsPipelineLibraryCreateInfoEXT::flags includes at least one of and no more than two of VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT, VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT, or VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT, and an element of VkPipelineLibraryCreateInfoKHR::pLibraries includes one of the other flags, the value of renderPass used to create that library must also be VK_NULL_HANDLE", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-renderpass-06631", "If renderPass is not VK_NULL_HANDLE, the pipeline requires fragment shader state, and the VK_EXT_extended_dynamic_state3 extension is not enabled or any of the VK_DYNAMIC_STATE_RASTERIZATION_SAMPLES_EXT, VK_DYNAMIC_STATE_SAMPLE_MASK_EXT, or VK_DYNAMIC_STATE_ALPHA_TO_COVERAGE_ENABLE_EXT dynamic states is not set, or the alphaToOne feature is enabled and VK_DYNAMIC_STATE_ALPHA_TO_ONE_ENABLE_EXT is not set, then pMultisampleState must be a valid pointer to a valid VkPipelineMultisampleStateCreateInfo structure", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-sampleLocationsEnable-01524", "If the pipeline requires fragment shader state, and the sampleLocationsEnable member of a VkPipelineSampleLocationsStateCreateInfoEXT structure included in the pNext chain of pMultisampleState is VK_TRUE, the fragment shader code must not statically use the extended instruction InterpolateAtSample", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-sampleShadingEnable-04900", "If the pipeline requires fragment shader state, and the VK_QCOM_render_pass_shader_resolve extension is enabled, and if the subpass description contains VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM, then sampleShadingEnable must be false", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-shaderMeshEnqueue-10187", "If the shaderMeshEnqueue feature is not enabled, shaders specified by pStages must not declare the ShaderEnqueueAMDX capability", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-shaderTessellationAndGeometryPointSize-08776", "If the pipeline is being created with a Geometry Execution Model, uses the OutputPoints Execution Mode, and the shaderTessellationAndGeometryPointSize feature is enabled, a PointSize decorated variable must be written to for every vertex emitted if the maintenance5 feature is not enabled", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-stage-02096", "If the pipeline requires pre-rasterization shader state the stage member of one element of pStages must be VK_SHADER_STAGE_VERTEX_BIT or VK_SHADER_STAGE_MESH_BIT_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-stage-06897", "If the pipeline requires fragment shader state and/or pre-rasterization shader state, any value of stage must not be set in more than one element of pStages", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-stageCount-09530", "If the pipeline requires pre-rasterization shader state, stageCount must be greater than 0", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-stageCount-09587", "If the pipeline does not require pre-rasterization shader state or fragment shader state, stageCount must be zero", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-stippledLineEnable-02767", "If the pipeline requires pre-rasterization shader state, the stippledLineEnable member of VkPipelineRasterizationLineStateCreateInfo is VK_TRUE, and no element of the pDynamicStates member of pDynamicState is VK_DYNAMIC_STATE_LINE_STIPPLE, then the lineStippleFactor member of VkPipelineRasterizationLineStateCreateInfo must be in the range [1,256]", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-00758", "If the pipeline requires fragment output interface state, rasterizationSamples is not dynamic, and subpass does not use any color and/or depth/stencil attachments, then the rasterizationSamples member of pMultisampleState must follow the rules for a zero-attachment subpass", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-01411", "If the pipeline requires fragment output interface state, the VK_NV_framebuffer_mixed_samples extension is enabled, rasterizationSamples is not dynamic, and if subpass has a depth/stencil attachment and depth test, stencil test, or depth bounds test are enabled, then the rasterizationSamples member of pMultisampleState must be the same as the sample count of the depth/stencil attachment", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-01412", "If the pipeline requires fragment output interface state, the VK_NV_framebuffer_mixed_samples extension is enabled, rasterizationSamples is not dynamic, and if subpass has any color attachments, then the rasterizationSamples member of pMultisampleState must be greater than or equal to the sample count for those subpass attachments", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-subpass-01505", "If the pipeline requires fragment output interface state, and the VK_AMD_mixed_attachment_samples extension is enabled, rasterizationSamples is not dynamic, and if subpass uses color and/or depth/stencil attachments, then the rasterizationSamples member of pMultisampleState must equal the maximum of the sample counts of those subpass attachments", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-topology-08773", "If the pipeline is being created with a Vertex Execution Model and no TessellationEvaluation or Geometry Execution Model, and the topology member of pInputAssembly is VK_PRIMITIVE_TOPOLOGY_POINT_LIST, and either VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY dynamic state is not enabled or dynamicPrimitiveTopologyUnrestricted is VK_FALSE, a PointSize decorated variable must be written to if the maintenance5 feature is not enabled", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineCreateInfo-topology-08889", "If the pipeline is being created with pre-rasterization shader state and vertex input state and the topology member of pInputAssembly is VK_PRIMITIVE_TOPOLOGY_PATCH_LIST, and either VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY dynamic state is not enabled or dynamicPrimitiveTopologyUnrestricted is VK_FALSE, then pStages must include tessellation shader stages", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineLibraryCreateInfoEXT-flags-parameter", "flags must be a valid combination of VkGraphicsPipelineLibraryFlagBitsEXT values", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineLibraryCreateInfoEXT-flags-requiredbitmask", "flags must not be 0", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineLibraryCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-deviceGeneratedCommands-02887", "The VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV::deviceGeneratedCommands feature must be enabled", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-groupCount-02879", "groupCount must be at least 1 and as maximum VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxGraphicsShaderGroupCount", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-groupCount-02880", "The sum of groupCount including those groups added from referenced pPipelines must also be as maximum VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV::maxGraphicsShaderGroupCount", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-02881", "The state of the first element of pGroups must match its equivalent within the parent's VkGraphicsPipelineCreateInfo", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-02882", "Each element of pGroups must in combination with the rest of the pipeline state yield a valid state configuration", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-02884", "All elements of pGroups must use the same shader stage combinations unless any mesh shader stage is used, then either combination of task and mesh or just mesh shader is valid", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-02885", "Mesh and regular primitive shading stages cannot be mixed across pGroups", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pGroups-parameter", "If groupCount is not 0, pGroups must be a valid pointer to an array of groupCount valid VkGraphicsShaderGroupCreateInfoNV structures", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pPipelines-02886", "Each element of pPipelines must have been created with identical state to the pipeline currently created except the state that can be overridden by VkGraphicsShaderGroupCreateInfoNV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-pPipelines-parameter", "If pipelineCount is not 0, pPipelines must be a valid pointer to an array of pipelineCount valid VkPipeline handles", "chapters/pipelines.html"},
    {"VUID-VkGraphicsPipelineShaderGroupsCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pNext-pNext", "pNext must be NULL", "chapters/pipelines.html"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pStages-02889", "For pStages, the same restrictions as in VkGraphicsPipelineCreateInfo::pStages apply", "chapters/pipelines.html"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pStages-parameter", "pStages must be a valid pointer to an array of stageCount valid VkPipelineShaderStageCreateInfo structures", "chapters/pipelines.html"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pTessellationState-02891", "For pTessellationState, the same restrictions as in VkGraphicsPipelineCreateInfo::pTessellationState apply", "chapters/pipelines.html"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-pVertexInputState-02890", "For pVertexInputState, the same restrictions as in VkGraphicsPipelineCreateInfo::pVertexInputState apply", "chapters/pipelines.html"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-sType-sType", "sType must be VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV", "chapters/pipelines.html"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-stageCount-02888", "For stageCount, the same restrictions as in VkGraphicsPipelineCreateInfo::stageCount apply", "chapters/pipelines.html"},
    {"VUID-VkGraphicsShaderGroupCreateInfoNV-stageCount-arraylength", "stageCount must be greater than 0", "chapters/pipelines.html"},
    {"VUID-VkHdrMetadataEXT-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkHdrVividDynamicMetadataHUAWEI", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkHdrMetadataEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_HDR_METADATA_EXT", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkHdrMetadataEXT-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkHdrVividDynamicMetadataHUAWEI-dynamicMetadataSize-arraylength", "dynamicMetadataSize must be greater than 0", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkHdrVividDynamicMetadataHUAWEI-pDynamicMetadata-parameter", "pDynamicMetadata must be a valid pointer to an array of dynamicMetadataSize bytes", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkHdrVividDynamicMetadataHUAWEI-sType-sType", "sType must be VK_STRUCTURE_TYPE_HDR_VIVID_DYNAMIC_METADATA_HUAWEI", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkHeadlessSurfaceCreateInfoEXT-flags-zerobitmask", "flags must be 0", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkHeadlessSurfaceCreateInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkHeadlessSurfaceCreateInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkHostImageCopyDevicePerformanceQuery-sType-sType", "sType must be VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY", "chapters/capabilities.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-aspectMask-08702", "If the aspectMask member of subresourceRange includes VK_IMAGE_ASPECT_DEPTH_BIT, oldLayout and newLayout must not be one of VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-aspectMask-08703", "If the aspectMask member of subresourceRange includes VK_IMAGE_ASPECT_STENCIL_BIT, oldLayout and newLayout must not be one of VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL or VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-image-01672", "If image has a multi-planar format and the image is disjoint, then the aspectMask member of subresourceRange must include at least one multi-planar aspect mask bit or VK_IMAGE_ASPECT_COLOR_BIT", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-image-01932", "If image is non-sparse then it must be bound completely and contiguously to a single VkDeviceMemory object", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-image-03319", "If image has a depth/stencil format with both depth and stencil and the separateDepthStencilLayouts feature is enabled, then the aspectMask member of subresourceRange must include either or both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-image-03320", "If image has a depth/stencil format with both depth and stencil and the separateDepthStencilLayouts feature is not enabled, then the aspectMask member of subresourceRange must include both VK_IMAGE_ASPECT_DEPTH_BIT and VK_IMAGE_ASPECT_STENCIL_BIT", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-image-09055", "image must have been created with VK_IMAGE_USAGE_HOST_TRANSFER_BIT", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-image-09241", "If image has a color format that is single-plane, then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_COLOR_BIT", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-image-09242", "If image has a color format and is not disjoint, then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_COLOR_BIT", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-image-10749", "If image has a depth-only format then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_DEPTH_BIT", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-image-10750", "If image has a stencil-only format then the aspectMask member of subresourceRange must be VK_IMAGE_ASPECT_STENCIL_BIT", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-image-parameter", "image must be a valid VkImage handle", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-maintenance9-10798", "If the maintenance9 feature is enabled and image is a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, subresourceRange.baseArrayLayer must be less than the depth computed from baseMipLevel and extent.depth specified in VkImageCreateInfo when image was created, according to the formula defined in Image Mip Level Sizing", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-maintenance9-10799", "If the maintenance9 feature is enabled and image is a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set and either subresourceRange.baseArrayLayer is not equal to 0 or subresourceRange.layerCount is not equal to VK_REMAINING_ARRAY_LAYERS, subresourceRange.levelCount must be 1", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-maintenance9-10800", "If the maintenance9 feature is enabled, subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, and image is a 3D image created with VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the depth computed from baseMipLevel and extent.depth specified in VkImageCreateInfo when image was created, according to the formula defined in Image Mip Level Sizing", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-newLayout-09057", "newLayout must be one of the layouts in VkPhysicalDeviceHostImageCopyProperties::pCopyDstLayouts", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-newLayout-parameter", "newLayout must be a valid VkImageLayout value", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-oldLayout-09229", "oldLayout must be either VK_IMAGE_LAYOUT_UNDEFINED or the current layout of the image subresources as specified in subresourceRange", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-oldLayout-09230", "If oldLayout is not VK_IMAGE_LAYOUT_UNDEFINED, VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT, or VK_IMAGE_LAYOUT_PREINITIALIZED, it must be one of the layouts in VkPhysicalDeviceHostImageCopyProperties::pCopySrcLayouts", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-oldLayout-parameter", "oldLayout must be a valid VkImageLayout value", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-pNext-pNext", "pNext must be NULL", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-sType-sType", "sType must be VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-subresourceRange-01486", "subresourceRange.baseMipLevel must be less than the mipLevels specified in VkImageCreateInfo when image was created", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-subresourceRange-01488", "If image is not a 3D image or was created without VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, or the maintenance9 feature is not enabled, subresourceRange.baseArrayLayer must be less than the arrayLayers specified in VkImageCreateInfo when image was created", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-subresourceRange-01724", "If subresourceRange.levelCount is not VK_REMAINING_MIP_LEVELS, subresourceRange.baseMipLevel + subresourceRange.levelCount must be less than or equal to the mipLevels specified in VkImageCreateInfo when image was created", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-subresourceRange-01725", "If image is not a 3D image or was created without VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT set, or the maintenance9 feature is not enabled, and subresourceRange.layerCount is not VK_REMAINING_ARRAY_LAYERS, subresourceRange.baseArrayLayer + subresourceRange.layerCount must be less than or equal to the arrayLayers specified in VkImageCreateInfo when image was created", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-subresourceRange-09601", "subresourceRange.aspectMask must be valid for the format the image was created with", "chapters/synchronization.html"},
    {"VUID-VkHostImageLayoutTransitionInfo-subresourceRange-parameter", "subresourceRange must be a valid VkImageSubresourceRange structure", "chapters/synchronization.html"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-flags-zerobitmask", "flags must be 0", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-pNext-pNext", "pNext must be NULL", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-pView-01316", "If pView is a UIView object, it must be a valid UIView, must be backed by a CALayer object of type CAMetalLayer, and vkCreateIOSSurfaceMVK must be called on the main thread", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-pView-04143", "If pView is a CAMetalLayer object, it must be a valid CAMetalLayer", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkIOSSurfaceCreateInfoMVK-sType-sType", "sType must be VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK", "chapters/VK_KHR_surface/wsi.html"},
    {"VUID-VkImageAlignmentControlCreateInfoMESA-imageAlignmentControl-09657", "imageAlignmentControl must be enabled", "chapters/resources.html"},
    {"VUID-VkImageAlignmentControlCreateInfoMESA-maximumRequestedAlignment-09655", "If maximumRequestedAlignment is not 0, maximumRequestedAlignment must be a power of two", "chapters/resources.html"},
    {"VUID-VkImageAlignmentControlCreateInfoMESA-maximumRequestedAlignment-09656", "If maximumRequestedAlignment is not 0, the bitwise-and of maximumRequestedAlignment and supportedImageAlignmentMask must be non-zero", "chapters/resources.html"},
    {"VUID-VkImageAlignmentControlCreateInfoMESA-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_ALIGNMENT_CONTROL_CREATE_INFO_MESA", "chapters/resources.html"},
    {"VUID-VkImageBlit-aspectMask-00238", "The aspectMask member of srcSubresource and dstSubresource must match", "chapters/copies.html"},
    {"VUID-VkImageBlit-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "chapters/copies.html"},
    {"VUID-VkImageBlit-layerCount-08800", "If neither of the layerCount members of srcSubresource or dstSubresource are VK_REMAINING_ARRAY_LAYERS, the layerCount members of srcSubresource or dstSubresource must match", "chapters/copies.html"},
    {"VUID-VkImageBlit-layerCount-08801", "If one of the layerCount members of srcSubresource or dstSubresource is VK_REMAINING_ARRAY_LAYERS, the other member must be either VK_REMAINING_ARRAY_LAYERS or equal to the arrayLayers member of the VkImageCreateInfo used to create the image minus baseArrayLayer", "chapters/copies.html"},
    {"VUID-VkImageBlit-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "chapters/copies.html"},
    {"VUID-VkImageBlit2-aspectMask-00238", "The aspectMask member of srcSubresource and dstSubresource must match", "chapters/copies.html"},
    {"VUID-VkImageBlit2-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "chapters/copies.html"},
    {"VUID-VkImageBlit2-layerCount-08800", "If neither of the layerCount members of srcSubresource or dstSubresource are VK_REMAINING_ARRAY_LAYERS, the layerCount members of srcSubresource or dstSubresource must match", "chapters/copies.html"},
    {"VUID-VkImageBlit2-layerCount-08801", "If one of the layerCount members of srcSubresource or dstSubresource is VK_REMAINING_ARRAY_LAYERS, the other member must be either VK_REMAINING_ARRAY_LAYERS or equal to the arrayLayers member of the VkImageCreateInfo used to create the image minus baseArrayLayer", "chapters/copies.html"},
    {"VUID-VkImageBlit2-pNext-pNext", "pNext must be NULL or a pointer to a valid instance of VkCopyCommandTransformInfoQCOM", "chapters/copies.html"},
    {"VUID-VkImageBlit2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_BLIT_2", "chapters/copies.html"},
    {"VUID-VkImageBlit2-sType-unique", "The sType value of each structure in the pNext chain must be unique", "chapters/copies.html"},
    {"VUID-VkImageBlit2-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "chapters/copies.html"},
    {"VUID-VkImageCaptureDescriptorDataInfoEXT-image-08079", "image must have been created with VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT set in VkImageCreateInfo::flags", "chapters/descriptorsets.html"},
    {"VUID-VkImageCaptureDescriptorDataInfoEXT-image-parameter", "image must be a valid VkImage handle", "chapters/descriptorsets.html"},
    {"VUID-VkImageCaptureDescriptorDataInfoEXT-pNext-pNext", "pNext must be NULL", "chapters/descriptorsets.html"},
    {"VUID-VkImageCaptureDescriptorDataInfoEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT", "chapters/descriptorsets.html"},
    {"VUID-VkImageCompressionControlEXT-flags-06747", "flags must be one of VK_IMAGE_COMPRESSION_DEFAULT_EXT, VK_IMAGE_COMPRESSION_FIXED_RATE_DEFAULT_EXT, VK_IMAGE_COMPRESSION_FIXED_RATE_EXPLICIT_EXT, or VK_IMAGE_COMPRESSION_DISABLED_EXT", "chapters/resources.html"},
    {"VUID-VkImageCompressionControlEXT-flags-06748", "If flags includes VK_IMAGE_COMPRESSION_FIXED_RATE_EXPLICIT_EXT, pFixedRateFlags must not be NULL", "chapters/resources.html"},
    {"VUID-VkImageCompressionControlEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT", "chapters/resources.html"},
    {"VUID-VkImageCompressionPropertiesEXT-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT", "chapters/resources.html"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-attachmentFragmentShadingRate-06401", "If the attachmentFragmentShadingRate feature is enabled, and pFormatConstraints->imageCreateInfo->usage contains VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, then pFormatConstraints->requiredFormatFeatures must contain VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR", "chapters/resources.html"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-bufferCollectionConstraints-parameter", "bufferCollectionConstraints must be a valid VkBufferCollectionConstraintsInfoFUCHSIA structure", "chapters/resources.html"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-flags-parameter", "flags must be a valid combination of VkImageConstraintsInfoFlagBitsFUCHSIA values", "chapters/resources.html"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-formatConstraintsCount-arraylength", "formatConstraintsCount must be greater than 0", "chapters/resources.html"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pFormatConstraints-06395", "All elements of pFormatConstraints must have at least one bit set in its VkImageFormatConstraintsInfoFUCHSIA::requiredFormatFeatures", "chapters/resources.html"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pFormatConstraints-06396", "If pFormatConstraints->imageCreateInfo->usage contains VK_IMAGE_USAGE_SAMPLED_BIT, then pFormatConstraints->requiredFormatFeatures must contain VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT", "chapters/resources.html"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pFormatConstraints-06397", "If pFormatConstraints->imageCreateInfo->usage contains VK_IMAGE_USAGE_STORAGE_BIT, then pFormatConstraints->requiredFormatFeatures must contain VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT", "chapters/resources.html"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pFormatConstraints-06398", "If pFormatConstraints->imageCreateInfo->usage contains VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, then pFormatConstraints->requiredFormatFeatures must contain VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT", "chapters/resources.html"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pFormatConstraints-06399", "If pFormatConstraints->imageCreateInfo->usage contains VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, then pFormatConstraints->requiredFormatFeatures must contain VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "chapters/resources.html"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pFormatConstraints-06400", "If pFormatConstraints->imageCreateInfo->usage contains VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, then pFormatConstraints->requiredFormatFeatures must contain at least one of VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT or VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT", "chapters/resources.html"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pFormatConstraints-parameter", "pFormatConstraints must be a valid pointer to an array of formatConstraintsCount valid VkImageFormatConstraintsInfoFUCHSIA structures", "chapters/resources.html"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-pNext-pNext", "pNext must be NULL", "chapters/resources.html"},
    {"VUID-VkImageConstraintsInfoFUCHSIA-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_CONSTRAINTS_INFO_FUCHSIA", "chapters/resources.html"},
    {"VUID-VkImageCopy-apiVersion-07940", "If the VK_KHR_sampler_ycbcr_conversion extension is not enabled, and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, the aspectMask member of srcSubresource and dstSubresource must match", "chapters/copies.html"},
    {"VUID-VkImageCopy-apiVersion-07941", "If the VK_KHR_maintenance1 extension is not enabled, and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, the layerCount member of srcSubresource and dstSubresource must match", "chapters/copies.html"},
    {"VUID-VkImageCopy-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "chapters/copies.html"},
    {"VUID-VkImageCopy-extent-06668", "extent.width must not be 0", "chapters/copies.html"},
    {"VUID-VkImageCopy-extent-06669", "extent.height must not be 0", "chapters/copies.html"},
    {"VUID-VkImageCopy-extent-06670", "extent.depth must not be 0", "chapters/copies.html"},
    {"VUID-VkImageCopy-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "chapters/copies.html"},
    {"VUID-VkImageCopy2-apiVersion-07940", "If the VK_KHR_sampler_ycbcr_conversion extension is not enabled, and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, the aspectMask member of srcSubresource and dstSubresource must match", "chapters/copies.html"},
    {"VUID-VkImageCopy2-apiVersion-07941", "If the VK_KHR_maintenance1 extension is not enabled, and VkPhysicalDeviceProperties::apiVersion is less than Vulkan 1.1, the layerCount member of srcSubresource and dstSubresource must match", "chapters/copies.html"},
    {"VUID-VkImageCopy2-dstSubresource-parameter", "dstSubresource must be a valid VkImageSubresourceLayers structure", "chapters/copies.html"},
    {"VUID-VkImageCopy2-extent-06668", "extent.width must not be 0", "chapters/copies.html"},
    {"VUID-VkImageCopy2-extent-06669", "extent.height must not be 0", "chapters/copies.html"},
    {"VUID-VkImageCopy2-extent-06670", "extent.depth must not be 0", "chapters/copies.html"},
    {"VUID-VkImageCopy2-pNext-pNext", "pNext must be NULL", "chapters/copies.html"},
    {"VUID-VkImageCopy2-sType-sType", "sType must be VK_STRUCTURE_TYPE_IMAGE_COPY_2", "chapters/copies.html"},
    {"VUID-VkImageCopy2-srcSubresource-parameter", "srcSubresource must be a valid VkImageSubresourceLayers structure", "chapters/copies.html"},
    {"VUID-VkImageCreateInfo-Format-02536", "If Format is a depth-stencil format and the pNext chain includes a VkImageStencilUsageCreateInfo structure with its stencilUsage member including VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, extent.width must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferWidth", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-None-01891", "If any of the bits VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT are set, VK_IMAGE_CREATE_PROTECTED_BIT must not also be set", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-None-01925", "If any of the bits VK_IMAGE_CREATE_SPARSE_BINDING_BIT, VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT, or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT are set, VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT must not also be set", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-arrayLayers-00948", "arrayLayers must be greater than 0", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-arrayLayers-02256", "arrayLayers must be less than or equal to imageCreateMaxArrayLayers (as defined in Image Creation Limits)", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-extent-00944", "extent.width must be greater than 0", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-extent-00945", "extent.height must be greater than 0", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-extent-00946", "extent.depth must be greater than 0", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-extent-02252", "extent.width must be less than or equal to imageCreateMaxExtent.width (as defined in Image Creation Limits)", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-extent-02253", "extent.height must be less than or equal to imageCreateMaxExtent.height (as defined in Image Creation Limits)", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-extent-02254", "extent.depth must be less than or equal to imageCreateMaxExtent.depth (as defined in Image Creation Limits)", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-00949", "If flags contains VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, imageType must be VK_IMAGE_TYPE_2D", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-00950", "If flags contains VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT, imageType must be VK_IMAGE_TYPE_3D", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-00969", "If the sparseBinding feature is not enabled, flags must not contain VK_IMAGE_CREATE_SPARSE_BINDING_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-00987", "If flags contains VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT or VK_IMAGE_CREATE_SPARSE_ALIASED_BIT, it must also contain VK_IMAGE_CREATE_SPARSE_BINDING_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-01533", "If flags contains VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT format must be a depth or depth/stencil format", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-01572", "If flags contains VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT, then format must be a compressed image format", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-01573", "If flags contains VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT, then flags must also contain VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-01890", "If the protectedMemory feature is not enabled, flags must not contain VK_IMAGE_CREATE_PROTECTED_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-01924", "If the sparseResidencyAliased feature is not enabled, flags must not contain VK_IMAGE_CREATE_SPARSE_ALIASED_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-02050", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV, imageType must be VK_IMAGE_TYPE_2D or VK_IMAGE_TYPE_3D", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-02051", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV, it must not contain VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT and the format must not be a depth/stencil format", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-02052", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV and imageType is VK_IMAGE_TYPE_2D, extent.width and extent.height must be greater than 1", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-02053", "If flags contains VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV and imageType is VK_IMAGE_TYPE_3D, extent.width, extent.height, and extent.depth must be greater than 1", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-02259", "If flags contains VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT, then mipLevels must be one, arrayLayers must be one, imageType must be VK_IMAGE_TYPE_2D. and imageCreateMaybeLinear (as defined in Image Creation Limits) must be VK_FALSE", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-02557", "If flags contains VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, imageType must be VK_IMAGE_TYPE_2D", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-02565", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, tiling must be VK_IMAGE_TILING_OPTIMAL", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-02566", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, imageType must be VK_IMAGE_TYPE_2D", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-02567", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, flags must not contain VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-02568", "If flags contains VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT, mipLevels must be 1", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-04738", "If flags does not contain VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT and the pNext chain includes a VkImageFormatListCreateInfo structure, then VkImageFormatListCreateInfo::viewFormatCount must be 0 or 1", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-06883", "If flags contains VK_IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT, samples must be VK_SAMPLE_COUNT_1_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-07755", "If flags contains VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT, imageType must be VK_IMAGE_TYPE_3D", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-08104", "If flags includes VK_IMAGE_CREATE_DESCRIPTOR_BUFFER_CAPTURE_REPLAY_BIT_EXT, the descriptorBufferCaptureReplay feature must be enabled", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-08328", "If flags includes VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then videoMaintenance1 must be enabled", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-08329", "If flags includes VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR and usage does not include VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR, then usage must not include VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-08331", "If flags includes VK_IMAGE_CREATE_VIDEO_PROFILE_INDEPENDENT_BIT_KHR, then usage must not include VK_IMAGE_USAGE_VIDEO_ENCODE_QUANTIZATION_DELTA_MAP_BIT_KHR, VK_IMAGE_USAGE_VIDEO_ENCODE_EMPHASIS_MAP_BIT_KHR, or VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-08865", "If flags contains VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, extent.width and extent.height must be equal", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-08866", "If flags contains VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT, arrayLayers must be greater than or equal to 6", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-09403", "If flags contains VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT, flags must not include VK_IMAGE_CREATE_SPARSE_ALIASED_BIT, VK_IMAGE_CREATE_SPARSE_BINDING_BIT, or VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-flags-parameter", "flags must be a valid combination of VkImageCreateFlagBits values", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-01577", "If format is not a multi-planar format, and flags does not include VK_IMAGE_CREATE_ALIAS_BIT, flags must not contain VK_IMAGE_CREATE_DISJOINT_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-02537", "If format is a depth-stencil format and the pNext chain includes a VkImageStencilUsageCreateInfo structure with its stencilUsage member including VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, extent.height must be less than or equal to VkPhysicalDeviceLimits::maxFramebufferHeight", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-02538", "If the shaderStorageImageMultisample feature is not enabled, format is a depth-stencil format and the pNext chain includes a VkImageStencilUsageCreateInfo structure with its stencilUsage including VK_IMAGE_USAGE_STORAGE_BIT, samples must be VK_SAMPLE_COUNT_1_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-02795", "If format is a depth-stencil format, usage includes VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-02796", "If format is a depth-stencil format, usage does not include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also not include VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-02797", "If format is a depth-stencil format, usage includes VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also include VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-02798", "If format is a depth-stencil format, usage does not include VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT, and the pNext chain includes a VkImageStencilUsageCreateInfo structure, then its VkImageStencilUsageCreateInfo::stencilUsage member must also not include VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-04712", "If format has a _422 or _420 suffix, extent.width must be a multiple of 2", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-04713", "If format has a _420 suffix, extent.height must be a multiple of 2", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-06410", "If the image format is one of the formats that require a sampler Y'CBCR conversion, mipLevels must be 1", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-06411", "If the image format is one of the formats that require a sampler Y'CBCR conversion, samples must be VK_SAMPLE_COUNT_1_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-06412", "If the image format is one of the formats that require a sampler Y'CBCR conversion, imageType must be VK_IMAGE_TYPE_2D", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-09583", "If format is one of the VK_FORMAT_PVTRC1_*_IMG formats, extent.width must be a power of 2", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-09584", "If format is one of the VK_FORMAT_PVTRC1_*_IMG formats, extent.height must be a power of 2", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-format-parameter", "format must be a valid VkFormat value", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-fragmentDensityMapOffset-06514", "If the fragmentDensityMapOffset feature is not enabled and usage includes VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, extent.width must be less than or equal to the ceiling of maxFramebufferWidth/minFragmentDensityTexelSize.width", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-fragmentDensityMapOffset-06515", "If the fragmentDensityMapOffset feature is not enabled and usage includes VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT, extent.height must be less than or equal to the ceiling of maxFramebufferHeight/minFragmentDensityTexelSize.height", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageCreateFormatFeatures-02260", "If format is a multi-planar format, and if imageCreateFormatFeatures (as defined in Image Creation Limits) does not contain VK_FORMAT_FEATURE_DISJOINT_BIT, then flags must not contain VK_IMAGE_CREATE_DISJOINT_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageCreateFormatFeatures-09048", "If imageCreateFormatFeatures (as defined in Image Creation Limits) does not contain VK_FORMAT_FEATURE_2_HOST_IMAGE_TRANSFER_BIT, then usage must not contain VK_IMAGE_USAGE_HOST_TRANSFER_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageCreateMaxMipLevels-02251", "Each of the following values (as described in Image Creation Limits) must not be undefined : imageCreateMaxMipLevels, imageCreateMaxArrayLayers, imageCreateMaxExtent, and imageCreateSampleCounts", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageType-00956", "If imageType is VK_IMAGE_TYPE_1D, both extent.height and extent.depth must be 1", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageType-00957", "If imageType is VK_IMAGE_TYPE_2D, extent.depth must be 1", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageType-00961", "If imageType is VK_IMAGE_TYPE_3D, arrayLayers must be 1", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageType-00970", "If imageType is VK_IMAGE_TYPE_1D, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageType-00971", "If the sparseResidencyImage2D feature is not enabled, and imageType is VK_IMAGE_TYPE_2D, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageType-00972", "If the sparseResidencyImage3D feature is not enabled, and imageType is VK_IMAGE_TYPE_3D, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageType-00973", "If the sparseResidency2Samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_2_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageType-00974", "If the sparseResidency4Samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_4_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageType-00975", "If the sparseResidency8Samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_8_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageType-00976", "If the sparseResidency16Samples feature is not enabled, imageType is VK_IMAGE_TYPE_2D, and samples is VK_SAMPLE_COUNT_16_BIT, flags must not contain VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageType-02082", "If usage includes VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR, imageType must be VK_IMAGE_TYPE_2D", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageType-10197", "If flags contains VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT and either the maintenance9 feature is not enabled on the device or image2DViewOf3DSparse is VK_FALSE , flags must not include VK_IMAGE_CREATE_SPARSE_ALIASED_BIT, VK_IMAGE_CREATE_SPARSE_BINDING_BIT, or VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageType-parameter", "imageType must be a valid VkImageType value", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-imageView2DOn3DImage-04459", "If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::imageView2DOn3DImage is VK_FALSE, flags must not contain VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-initialLayout-00993", "initialLayout must be VK_IMAGE_LAYOUT_UNDEFINED or VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT or VK_IMAGE_LAYOUT_PREINITIALIZED", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-initialLayout-10765", "If the zeroInitializeDeviceMemory feature is not enabled, initialLayout must not be VK_IMAGE_LAYOUT_ZERO_INITIALIZED_EXT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-initialLayout-parameter", "initialLayout must be a valid VkImageLayout value", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-mipLevels-00947", "mipLevels must be greater than 0", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-mipLevels-00958", "mipLevels must be less than or equal to the number of levels in the complete mipmap chain based on extent.width, extent.height, and extent.depth", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-mipLevels-02255", "mipLevels must be less than or equal to imageCreateMaxMipLevels (as defined in Image Creation Limits)", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-multisampleArrayImage-04460", "If the VK_KHR_portability_subset extension is enabled, and VkPhysicalDevicePortabilitySubsetFeaturesKHR::multisampleArrayImage is VK_FALSE, and samples is not VK_SAMPLE_COUNT_1_BIT, then arrayLayers must be 1", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-multisampledRenderToSingleSampled-06882", "If the multisampledRenderToSingleSampled feature is not enabled, flags must not contain VK_IMAGE_CREATE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_BIT_EXT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-00988", "If the pNext chain includes a VkExternalMemoryImageCreateInfoNV structure, it must not contain a VkExternalMemoryImageCreateInfo structure", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-00990", "If the pNext chain includes a VkExternalMemoryImageCreateInfo structure, its handleTypes member must only contain bits that are also in VkExternalImageFormatProperties::externalMemoryProperties.compatibleHandleTypes, as returned by vkGetPhysicalDeviceImageFormatProperties2 with format, imageType, tiling, usage, and flags equal to those in this structure, and with a VkPhysicalDeviceExternalImageFormatInfo structure included in the pNext chain, with a handleType equal to any one of the handle types specified in VkExternalMemoryImageCreateInfo::handleTypes", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-00991", "If the pNext chain includes a VkExternalMemoryImageCreateInfoNV structure, its handleTypes member must only contain bits that are also in VkExternalImageFormatPropertiesNV::externalMemoryFeatures.compatibleHandleTypes, as returned by vkGetPhysicalDeviceExternalImageFormatPropertiesNV with format, imageType, tiling, usage, and flags equal to those in this structure, and with externalHandleType equal to any one of the handle types specified in VkExternalMemoryImageCreateInfoNV::handleTypes", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-01443", "If the pNext chain includes a VkExternalMemoryImageCreateInfo or VkExternalMemoryImageCreateInfoNV structure whose handleTypes member is not 0, initialLayout must be VK_IMAGE_LAYOUT_UNDEFINED", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-01974", "If the pNext chain includes a VkExternalFormatANDROID structure, and its externalFormat member is non-zero the format must be VK_FORMAT_UNDEFINED", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-01975", "If the pNext chain does not include a VkExternalFormatANDROID structure, or does and its externalFormat member is 0, the format must not be VK_FORMAT_UNDEFINED", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-02262", "If the pNext chain includes a VkImageDrmFormatModifierListCreateInfoEXT or VkImageDrmFormatModifierExplicitCreateInfoEXT structure, then tiling must be VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-02393", "If the pNext chain includes a VkExternalMemoryImageCreateInfo structure whose handleTypes member includes VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, imageType must be VK_IMAGE_TYPE_2D", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-02394", "If the pNext chain includes a VkExternalMemoryImageCreateInfo structure whose handleTypes member includes VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID, mipLevels must either be 1 or equal to the number of levels in the complete mipmap chain based on extent.width, extent.height, and extent.depth", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-02396", "If the pNext chain includes a VkExternalFormatANDROID structure whose externalFormat member is not 0, flags must not include VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-02397", "If the pNext chain includes a VkExternalFormatANDROID structure whose externalFormat member is not 0, usage must not include any usages except VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT, VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT, or VK_IMAGE_USAGE_SAMPLED_BIT", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-02398", "If the pNext chain includes a VkExternalFormatANDROID structure whose externalFormat member is not 0, tiling must be VK_IMAGE_TILING_OPTIMAL", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-06390", "If the VkImage is to be used to import memory from a VkBufferCollectionFUCHSIA, a VkBufferCollectionImageCreateInfoFUCHSIA structure must be chained to pNext", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-06722", "If a VkImageFormatListCreateInfo structure was included in the pNext chain and format is not a multi-planar format and VkImageFormatListCreateInfo::viewFormatCount is not zero, then each format in VkImageFormatListCreateInfo::pViewFormats must either be compatible with the format as described in the compatibility table or, if flags contains VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT, be an uncompressed format that is size-compatible with format", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-06743", "If the pNext chain includes a VkImageCompressionControlEXT structure, format is a multi-planar format, and VkImageCompressionControlEXT::flags includes VK_IMAGE_COMPRESSION_FIXED_RATE_EXPLICIT_EXT, then VkImageCompressionControlEXT::compressionControlPlaneCount must be equal to the number of planes in format", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-06744", "If the pNext chain includes a VkImageCompressionControlEXT structure, format is not a multi-planar format, and VkImageCompressionControlEXT::flags includes VK_IMAGE_COMPRESSION_FIXED_RATE_EXPLICIT_EXT, then VkImageCompressionControlEXT::compressionControlPlaneCount must be 1", "chapters/resources.html"},
    {"VUID-VkImageCreateInfo-pNext-06746", "If the pNext chain includes a VkImageCompressionControlEXT structure, it must not contain a VkImageDrmFormatModif