// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(add)                       \
  M(addw)                      \
  M(sub)                       \
  M(subw)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anomymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_T32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  int32_t immediate;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] =
    {{{al, r12, r7, 1536}, false, al, "al r12 r7 1536", "al_r12_r7_1536"},
     {{al, r7, r10, 1991}, false, al, "al r7 r10 1991", "al_r7_r10_1991"},
     {{al, r13, r10, 3585}, false, al, "al r13 r10 3585", "al_r13_r10_3585"},
     {{al, r8, r12, 3384}, false, al, "al r8 r12 3384", "al_r8_r12_3384"},
     {{al, r14, r4, 3899}, false, al, "al r14 r4 3899", "al_r14_r4_3899"},
     {{al, r10, r1, 3397}, false, al, "al r10 r1 3397", "al_r10_r1_3397"},
     {{al, r2, r10, 3063}, false, al, "al r2 r10 3063", "al_r2_r10_3063"},
     {{al, r6, r9, 3696}, false, al, "al r6 r9 3696", "al_r6_r9_3696"},
     {{al, r13, r7, 606}, false, al, "al r13 r7 606", "al_r13_r7_606"},
     {{al, r6, r1, 2016}, false, al, "al r6 r1 2016", "al_r6_r1_2016"},
     {{al, r13, r14, 2047}, false, al, "al r13 r14 2047", "al_r13_r14_2047"},
     {{al, r10, r9, 2025}, false, al, "al r10 r9 2025", "al_r10_r9_2025"},
     {{al, r11, r14, 2323}, false, al, "al r11 r14 2323", "al_r11_r14_2323"},
     {{al, r13, r7, 3071}, false, al, "al r13 r7 3071", "al_r13_r7_3071"},
     {{al, r7, r0, 4092}, false, al, "al r7 r0 4092", "al_r7_r0_4092"},
     {{al, r2, r3, 3287}, false, al, "al r2 r3 3287", "al_r2_r3_3287"},
     {{al, r3, r14, 4079}, false, al, "al r3 r14 4079", "al_r3_r14_4079"},
     {{al, r1, r3, 4037}, false, al, "al r1 r3 4037", "al_r1_r3_4037"},
     {{al, r2, r11, 2701}, false, al, "al r2 r11 2701", "al_r2_r11_2701"},
     {{al, r5, r11, 2892}, false, al, "al r5 r11 2892", "al_r5_r11_2892"},
     {{al, r0, r0, 969}, false, al, "al r0 r0 969", "al_r0_r0_969"},
     {{al, r0, r12, 1924}, false, al, "al r0 r12 1924", "al_r0_r12_1924"},
     {{al, r10, r3, 4046}, false, al, "al r10 r3 4046", "al_r10_r3_4046"},
     {{al, r12, r13, 3787}, false, al, "al r12 r13 3787", "al_r12_r13_3787"},
     {{al, r13, r4, 3548}, false, al, "al r13 r4 3548", "al_r13_r4_3548"},
     {{al, r8, r6, 2}, false, al, "al r8 r6 2", "al_r8_r6_2"},
     {{al, r4, r14, 1027}, false, al, "al r4 r14 1027", "al_r4_r14_1027"},
     {{al, r10, r2, 3136}, false, al, "al r10 r2 3136", "al_r10_r2_3136"},
     {{al, r9, r13, 2978}, false, al, "al r9 r13 2978", "al_r9_r13_2978"},
     {{al, r4, r4, 2046}, false, al, "al r4 r4 2046", "al_r4_r4_2046"},
     {{al, r12, r14, 1323}, false, al, "al r12 r14 1323", "al_r12_r14_1323"},
     {{al, r4, r8, 2721}, false, al, "al r4 r8 2721", "al_r4_r8_2721"},
     {{al, r10, r3, 811}, false, al, "al r10 r3 811", "al_r10_r3_811"},
     {{al, r7, r12, 188}, false, al, "al r7 r12 188", "al_r7_r12_188"},
     {{al, r5, r1, 997}, false, al, "al r5 r1 997", "al_r5_r1_997"},
     {{al, r13, r7, 98}, false, al, "al r13 r7 98", "al_r13_r7_98"},
     {{al, r11, r1, 2046}, false, al, "al r11 r1 2046", "al_r11_r1_2046"},
     {{al, r13, r13, 4095}, false, al, "al r13 r13 4095", "al_r13_r13_4095"},
     {{al, r12, r14, 47}, false, al, "al r12 r14 47", "al_r12_r14_47"},
     {{al, r11, r0, 3566}, false, al, "al r11 r0 3566", "al_r11_r0_3566"},
     {{al, r2, r3, 2901}, false, al, "al r2 r3 2901", "al_r2_r3_2901"},
     {{al, r14, r14, 774}, false, al, "al r14 r14 774", "al_r14_r14_774"},
     {{al, r12, r11, 1823}, false, al, "al r12 r11 1823", "al_r12_r11_1823"},
     {{al, r7, r6, 3397}, false, al, "al r7 r6 3397", "al_r7_r6_3397"},
     {{al, r14, r6, 3921}, false, al, "al r14 r6 3921", "al_r14_r6_3921"},
     {{al, r11, r12, 3063}, false, al, "al r11 r12 3063", "al_r11_r12_3063"},
     {{al, r14, r12, 1009}, false, al, "al r14 r12 1009", "al_r14_r12_1009"},
     {{al, r9, r10, 4093}, false, al, "al r9 r10 4093", "al_r9_r10_4093"},
     {{al, r10, r10, 1198}, false, al, "al r10 r10 1198", "al_r10_r10_1198"},
     {{al, r14, r3, 3481}, false, al, "al r14 r3 3481", "al_r14_r3_3481"},
     {{al, r8, r0, 1266}, false, al, "al r8 r0 1266", "al_r8_r0_1266"},
     {{al, r8, r1, 958}, false, al, "al r8 r1 958", "al_r8_r1_958"},
     {{al, r1, r11, 1171}, false, al, "al r1 r11 1171", "al_r1_r11_1171"},
     {{al, r5, r6, 282}, false, al, "al r5 r6 282", "al_r5_r6_282"},
     {{al, r11, r13, 1506}, false, al, "al r11 r13 1506", "al_r11_r13_1506"},
     {{al, r3, r3, 3583}, false, al, "al r3 r3 3583", "al_r3_r3_3583"},
     {{al, r1, r14, 3685}, false, al, "al r1 r14 3685", "al_r1_r14_3685"},
     {{al, r1, r1, 3583}, false, al, "al r1 r1 3583", "al_r1_r1_3583"},
     {{al, r1, r5, 595}, false, al, "al r1 r5 595", "al_r1_r5_595"},
     {{al, r11, r2, 3802}, false, al, "al r11 r2 3802", "al_r11_r2_3802"},
     {{al, r13, r4, 3325}, false, al, "al r13 r4 3325", "al_r13_r4_3325"},
     {{al, r1, r1, 1266}, false, al, "al r1 r1 1266", "al_r1_r1_1266"},
     {{al, r10, r0, 1231}, false, al, "al r10 r0 1231", "al_r10_r0_1231"},
     {{al, r3, r0, 3752}, false, al, "al r3 r0 3752", "al_r3_r0_3752"},
     {{al, r13, r10, 3994}, false, al, "al r13 r10 3994", "al_r13_r10_3994"},
     {{al, r14, r8, 210}, false, al, "al r14 r8 210", "al_r14_r8_210"},
     {{al, r3, r13, 3787}, false, al, "al r3 r13 3787", "al_r3_r13_3787"},
     {{al, r4, r3, 3472}, false, al, "al r4 r3 3472", "al_r4_r3_3472"},
     {{al, r13, r3, 264}, false, al, "al r13 r3 264", "al_r13_r3_264"},
     {{al, r3, r4, 3871}, false, al, "al r3 r4 3871", "al_r3_r4_3871"},
     {{al, r1, r3, 3343}, false, al, "al r1 r3 3343", "al_r1_r3_3343"},
     {{al, r12, r8, 3063}, false, al, "al r12 r8 3063", "al_r12_r8_3063"},
     {{al, r4, r13, 988}, false, al, "al r4 r13 988", "al_r4_r13_988"},
     {{al, r12, r7, 997}, false, al, "al r12 r7 997", "al_r12_r7_997"},
     {{al, r14, r8, 3391}, false, al, "al r14 r8 3391", "al_r14_r8_3391"},
     {{al, r7, r12, 2984}, false, al, "al r7 r12 2984", "al_r7_r12_2984"},
     {{al, r8, r1, 2590}, false, al, "al r8 r1 2590", "al_r8_r1_2590"},
     {{al, r13, r12, 83}, false, al, "al r13 r12 83", "al_r13_r12_83"},
     {{al, r2, r0, 4082}, false, al, "al r2 r0 4082", "al_r2_r0_4082"},
     {{al, r4, r13, 4092}, false, al, "al r4 r13 4092", "al_r4_r13_4092"},
     {{al, r7, r5, 2454}, false, al, "al r7 r5 2454", "al_r7_r5_2454"},
     {{al, r0, r1, 4076}, false, al, "al r0 r1 4076", "al_r0_r1_4076"},
     {{al, r0, r1, 3449}, false, al, "al r0 r1 3449", "al_r0_r1_3449"},
     {{al, r10, r12, 132}, false, al, "al r10 r12 132", "al_r10_r12_132"},
     {{al, r11, r9, 3772}, false, al, "al r11 r9 3772", "al_r11_r9_3772"},
     {{al, r4, r8, 964}, false, al, "al r4 r8 964", "al_r4_r8_964"},
     {{al, r1, r4, 1017}, false, al, "al r1 r4 1017", "al_r1_r4_1017"},
     {{al, r1, r10, 136}, false, al, "al r1 r10 136", "al_r1_r10_136"},
     {{al, r3, r3, 3142}, false, al, "al r3 r3 3142", "al_r3_r3_3142"},
     {{al, r3, r5, 2627}, false, al, "al r3 r5 2627", "al_r3_r5_2627"},
     {{al, r8, r2, 1660}, false, al, "al r8 r2 1660", "al_r8_r2_1660"},
     {{al, r11, r3, 98}, false, al, "al r11 r3 98", "al_r11_r3_98"},
     {{al, r10, r10, 3774}, false, al, "al r10 r10 3774", "al_r10_r10_3774"},
     {{al, r0, r14, 2690}, false, al, "al r0 r14 2690", "al_r0_r14_2690"},
     {{al, r6, r12, 1394}, false, al, "al r6 r12 1394", "al_r6_r12_1394"},
     {{al, r12, r7, 1438}, false, al, "al r12 r7 1438", "al_r12_r7_1438"},
     {{al, r1, r11, 1556}, false, al, "al r1 r11 1556", "al_r1_r11_1556"},
     {{al, r7, r7, 2982}, false, al, "al r7 r7 2982", "al_r7_r7_2982"},
     {{al, r1, r4, 3007}, false, al, "al r1 r4 3007", "al_r1_r4_3007"},
     {{al, r2, r13, 1537}, false, al, "al r2 r13 1537", "al_r2_r13_1537"},
     {{al, r1, r12, 1527}, false, al, "al r1 r12 1527", "al_r1_r12_1527"},
     {{al, r12, r0, 3907}, false, al, "al r12 r0 3907", "al_r12_r0_3907"},
     {{al, r14, r3, 1916}, false, al, "al r14 r3 1916", "al_r14_r3_1916"},
     {{al, r14, r12, 3610}, false, al, "al r14 r12 3610", "al_r14_r12_3610"},
     {{al, r7, r7, 915}, false, al, "al r7 r7 915", "al_r7_r7_915"},
     {{al, r14, r3, 2025}, false, al, "al r14 r3 2025", "al_r14_r3_2025"},
     {{al, r13, r5, 362}, false, al, "al r13 r5 362", "al_r13_r5_362"},
     {{al, r6, r1, 3057}, false, al, "al r6 r1 3057", "al_r6_r1_3057"},
     {{al, r10, r7, 282}, false, al, "al r10 r7 282", "al_r10_r7_282"},
     {{al, r4, r13, 662}, false, al, "al r4 r13 662", "al_r4_r13_662"},
     {{al, r6, r13, 2038}, false, al, "al r6 r13 2038", "al_r6_r13_2038"},
     {{al, r12, r7, 2810}, false, al, "al r12 r7 2810", "al_r12_r7_2810"},
     {{al, r11, r6, 3391}, false, al, "al r11 r6 3391", "al_r11_r6_3391"},
     {{al, r8, r2, 2365}, false, al, "al r8 r2 2365", "al_r8_r2_2365"},
     {{al, r6, r7, 3636}, false, al, "al r6 r7 3636", "al_r6_r7_3636"},
     {{al, r1, r10, 1485}, false, al, "al r1 r10 1485", "al_r1_r10_1485"},
     {{al, r8, r14, 3907}, false, al, "al r8 r14 3907", "al_r8_r14_3907"},
     {{al, r5, r5, 1458}, false, al, "al r5 r5 1458", "al_r5_r5_1458"},
     {{al, r1, r0, 3003}, false, al, "al r1 r0 3003", "al_r1_r0_3003"},
     {{al, r14, r14, 3072}, false, al, "al r14 r14 3072", "al_r14_r14_3072"},
     {{al, r2, r6, 1823}, false, al, "al r2 r6 1823", "al_r2_r6_1823"},
     {{al, r1, r2, 3765}, false, al, "al r1 r2 3765", "al_r1_r2_3765"},
     {{al, r1, r0, 2021}, false, al, "al r1 r0 2021", "al_r1_r0_2021"},
     {{al, r14, r8, 2665}, false, al, "al r14 r8 2665", "al_r14_r8_2665"},
     {{al, r8, r8, 342}, false, al, "al r8 r8 342", "al_r8_r8_342"},
     {{al, r14, r10, 3266}, false, al, "al r14 r10 3266", "al_r14_r10_3266"},
     {{al, r5, r7, 4058}, false, al, "al r5 r7 4058", "al_r5_r7_4058"},
     {{al, r12, r8, 2475}, false, al, "al r12 r8 2475", "al_r12_r8_2475"},
     {{al, r10, r7, 797}, false, al, "al r10 r7 797", "al_r10_r7_797"},
     {{al, r12, r9, 2038}, false, al, "al r12 r9 2038", "al_r12_r9_2038"},
     {{al, r13, r6, 1498}, false, al, "al r13 r6 1498", "al_r13_r6_1498"},
     {{al, r5, r5, 2628}, false, al, "al r5 r5 2628", "al_r5_r5_2628"},
     {{al, r11, r12, 47}, false, al, "al r11 r12 47", "al_r11_r12_47"},
     {{al, r1, r3, 689}, false, al, "al r1 r3 689", "al_r1_r3_689"},
     {{al, r0, r12, 964}, false, al, "al r0 r12 964", "al_r0_r12_964"},
     {{al, r9, r10, 999}, false, al, "al r9 r10 999", "al_r9_r10_999"},
     {{al, r6, r2, 1472}, false, al, "al r6 r2 1472", "al_r6_r2_1472"},
     {{al, r10, r12, 3548}, false, al, "al r10 r12 3548", "al_r10_r12_3548"},
     {{al, r5, r0, 618}, false, al, "al r5 r0 618", "al_r5_r0_618"},
     {{al, r10, r8, 1652}, false, al, "al r10 r8 1652", "al_r10_r8_1652"},
     {{al, r9, r4, 3287}, false, al, "al r9 r4 3287", "al_r9_r4_3287"},
     {{al, r9, r6, 1808}, false, al, "al r9 r6 1808", "al_r9_r6_1808"},
     {{al, r14, r3, 2023}, false, al, "al r14 r3 2023", "al_r14_r3_2023"},
     {{al, r7, r4, 2202}, false, al, "al r7 r4 2202", "al_r7_r4_2202"},
     {{al, r7, r4, 2047}, false, al, "al r7 r4 2047", "al_r7_r4_2047"},
     {{al, r1, r0, 4065}, false, al, "al r1 r0 4065", "al_r1_r0_4065"},
     {{al, r2, r2, 2721}, false, al, "al r2 r2 2721", "al_r2_r2_2721"},
     {{al, r2, r14, 778}, false, al, "al r2 r14 778", "al_r2_r14_778"},
     {{al, r4, r3, 3821}, false, al, "al r4 r3 3821", "al_r4_r3_3821"},
     {{al, r14, r5, 1097}, false, al, "al r14 r5 1097", "al_r14_r5_1097"},
     {{al, r9, r12, 672}, false, al, "al r9 r12 672", "al_r9_r12_672"},
     {{al, r6, r3, 719}, false, al, "al r6 r3 719", "al_r6_r3_719"},
     {{al, r10, r0, 1916}, false, al, "al r10 r0 1916", "al_r10_r0_1916"},
     {{al, r12, r13, 2999}, false, al, "al r12 r13 2999", "al_r12_r13_2999"},
     {{al, r5, r8, 674}, false, al, "al r5 r8 674", "al_r5_r8_674"},
     {{al, r12, r1, 3907}, false, al, "al r12 r1 3907", "al_r12_r1_3907"},
     {{al, r12, r12, 342}, false, al, "al r12 r12 342", "al_r12_r12_342"},
     {{al, r2, r14, 3522}, false, al, "al r2 r14 3522", "al_r2_r14_3522"},
     {{al, r4, r12, 2929}, false, al, "al r4 r12 2929", "al_r4_r12_2929"},
     {{al, r9, r0, 3239}, false, al, "al r9 r0 3239", "al_r9_r0_3239"},
     {{al, r7, r2, 2703}, false, al, "al r7 r2 2703", "al_r7_r2_2703"},
     {{al, r9, r0, 2180}, false, al, "al r9 r0 2180", "al_r9_r0_2180"},
     {{al, r12, r2, 4046}, false, al, "al r12 r2 4046", "al_r12_r2_4046"},
     {{al, r9, r13, 3821}, false, al, "al r9 r13 3821", "al_r9_r13_3821"},
     {{al, r5, r1, 1159}, false, al, "al r5 r1 1159", "al_r5_r1_1159"},
     {{al, r2, r10, 1660}, false, al, "al r2 r10 1660", "al_r2_r10_1660"},
     {{al, r8, r14, 3608}, false, al, "al r8 r14 3608", "al_r8_r14_3608"},
     {{al, r10, r2, 998}, false, al, "al r10 r2 998", "al_r10_r2_998"},
     {{al, r11, r13, 3069}, false, al, "al r11 r13 3069", "al_r11_r13_3069"},
     {{al, r14, r8, 3221}, false, al, "al r14 r8 3221", "al_r14_r8_3221"},
     {{al, r5, r7, 1455}, false, al, "al r5 r7 1455", "al_r5_r7_1455"},
     {{al, r12, r6, 997}, false, al, "al r12 r6 997", "al_r12_r6_997"},
     {{al, r5, r5, 606}, false, al, "al r5 r5 606", "al_r5_r5_606"},
     {{al, r8, r0, 358}, false, al, "al r8 r0 358", "al_r8_r0_358"},
     {{al, r4, r11, 1870}, false, al, "al r4 r11 1870", "al_r4_r11_1870"},
     {{al, r0, r8, 216}, false, al, "al r0 r8 216", "al_r0_r8_216"},
     {{al, r2, r8, 685}, false, al, "al r2 r8 685", "al_r2_r8_685"},
     {{al, r6, r9, 3743}, false, al, "al r6 r9 3743", "al_r6_r9_3743"},
     {{al, r12, r7, 72}, false, al, "al r12 r7 72", "al_r12_r7_72"},
     {{al, r0, r11, 2044}, false, al, "al r0 r11 2044", "al_r0_r11_2044"},
     {{al, r0, r14, 679}, false, al, "al r0 r14 679", "al_r0_r14_679"},
     {{al, r11, r14, 136}, false, al, "al r11 r14 136", "al_r11_r14_136"},
     {{al, r6, r7, 3057}, false, al, "al r6 r7 3057", "al_r6_r7_3057"},
     {{al, r5, r9, 1922}, false, al, "al r5 r9 1922", "al_r5_r9_1922"},
     {{al, r3, r12, 3772}, false, al, "al r3 r12 3772", "al_r3_r12_3772"},
     {{al, r12, r3, 678}, false, al, "al r12 r3 678", "al_r12_r3_678"},
     {{al, r11, r8, 2086}, false, al, "al r11 r8 2086", "al_r11_r8_2086"},
     {{al, r4, r14, 2689}, false, al, "al r4 r14 2689", "al_r4_r14_2689"},
     {{al, r11, r0, 2011}, false, al, "al r11 r0 2011", "al_r11_r0_2011"},
     {{al, r7, r10, 1389}, false, al, "al r7 r10 1389", "al_r7_r10_1389"},
     {{al, r3, r1, 478}, false, al, "al r3 r1 478", "al_r3_r1_478"},
     {{al, r1, r0, 2721}, false, al, "al r1 r0 2721", "al_r1_r0_2721"},
     {{al, r6, r5, 4076}, false, al, "al r6 r5 4076", "al_r6_r5_4076"},
     {{al, r2, r2, 188}, false, al, "al r2 r2 188", "al_r2_r2_188"},
     {{al, r9, r4, 3481}, false, al, "al r9 r4 3481", "al_r9_r4_3481"},
     {{al, r10, r13, 47}, false, al, "al r10 r13 47", "al_r10_r13_47"},
     {{al, r4, r4, 2796}, false, al, "al r4 r4 2796", "al_r4_r4_2796"},
     {{al, r10, r7, 2690}, false, al, "al r10 r7 2690", "al_r10_r7_2690"},
     {{al, r14, r7, 3921}, false, al, "al r14 r7 3921", "al_r14_r7_3921"},
     {{al, r13, r9, 3003}, false, al, "al r13 r9 3003", "al_r13_r9_3003"},
     {{al, r7, r11, 2038}, false, al, "al r7 r11 2038", "al_r7_r11_2038"},
     {{al, r10, r0, 57}, false, al, "al r10 r0 57", "al_r10_r0_57"},
     {{al, r7, r5, 2545}, false, al, "al r7 r5 2545", "al_r7_r5_2545"},
     {{al, r9, r7, 3625}, false, al, "al r9 r7 3625", "al_r9_r7_3625"},
     {{al, r10, r7, 2866}, false, al, "al r10 r7 2866", "al_r10_r7_2866"},
     {{al, r9, r4, 1892}, false, al, "al r9 r4 1892", "al_r9_r4_1892"},
     {{al, r4, r6, 955}, false, al, "al r4 r6 955", "al_r4_r6_955"},
     {{al, r4, r12, 3517}, false, al, "al r4 r12 3517", "al_r4_r12_3517"},
     {{al, r1, r0, 2541}, false, al, "al r1 r0 2541", "al_r1_r0_2541"},
     {{al, r11, r1, 915}, false, al, "al r11 r1 915", "al_r11_r1_915"},
     {{al, r8, r7, 1824}, false, al, "al r8 r7 1824", "al_r8_r7_1824"},
     {{al, r7, r12, 2864}, false, al, "al r7 r12 2864", "al_r7_r12_2864"},
     {{al, r11, r14, 1666}, false, al, "al r11 r14 1666", "al_r11_r14_1666"},
     {{al, r6, r4, 2072}, false, al, "al r6 r4 2072", "al_r6_r4_2072"},
     {{al, r0, r1, 4082}, false, al, "al r0 r1 4082", "al_r0_r1_4082"},
     {{al, r0, r13, 1099}, false, al, "al r0 r13 1099", "al_r0_r13_1099"},
     {{al, r4, r1, 2800}, false, al, "al r4 r1 2800", "al_r4_r1_2800"},
     {{al, r6, r5, 1323}, false, al, "al r6 r5 1323", "al_r6_r5_1323"},
     {{al, r3, r0, 3867}, false, al, "al r3 r0 3867", "al_r3_r0_3867"},
     {{al, r3, r6, 2984}, false, al, "al r3 r6 2984", "al_r3_r6_2984"},
     {{al, r9, r0, 57}, false, al, "al r9 r0 57", "al_r9_r0_57"},
     {{al, r6, r7, 712}, false, al, "al r6 r7 712", "al_r6_r7_712"},
     {{al, r5, r4, 1035}, false, al, "al r5 r4 1035", "al_r5_r4_1035"},
     {{al, r12, r5, 4076}, false, al, "al r12 r5 4076", "al_r12_r5_4076"},
     {{al, r2, r12, 2669}, false, al, "al r2 r12 2669", "al_r2_r12_2669"},
     {{al, r9, r5, 2098}, false, al, "al r9 r5 2098", "al_r9_r5_2098"},
     {{al, r14, r1, 1323}, false, al, "al r14 r1 1323", "al_r14_r1_1323"},
     {{al, r6, r1, 322}, false, al, "al r6 r1 322", "al_r6_r1_322"},
     {{al, r1, r14, 783}, false, al, "al r1 r14 783", "al_r1_r14_783"},
     {{al, r13, r8, 192}, false, al, "al r13 r8 192", "al_r13_r8_192"},
     {{al, r1, r14, 3585}, false, al, "al r1 r14 3585", "al_r1_r14_3585"},
     {{al, r13, r7, 263}, false, al, "al r13 r7 263", "al_r13_r7_263"},
     {{al, r8, r13, 783}, false, al, "al r8 r13 783", "al_r8_r13_783"},
     {{al, r10, r7, 618}, false, al, "al r10 r7 618", "al_r10_r7_618"},
     {{al, r14, r2, 1740}, false, al, "al r14 r2 1740", "al_r14_r2_1740"},
     {{al, r11, r1, 3313}, false, al, "al r11 r1 3313", "al_r11_r1_3313"},
     {{al, r14, r3, 2072}, false, al, "al r14 r3 2072", "al_r14_r3_2072"},
     {{al, r10, r14, 2403}, false, al, "al r10 r14 2403", "al_r10_r14_2403"},
     {{al, r9, r12, 977}, false, al, "al r9 r12 977", "al_r9_r12_977"},
     {{al, r5, r8, 1934}, false, al, "al r5 r8 1934", "al_r5_r8_1934"},
     {{al, r4, r11, 2345}, false, al, "al r4 r11 2345", "al_r4_r11_2345"},
     {{al, r10, r7, 3636}, false, al, "al r10 r7 3636", "al_r10_r7_3636"},
     {{al, r10, r7, 517}, false, al, "al r10 r7 517", "al_r10_r7_517"},
     {{al, r2, r13, 3871}, false, al, "al r2 r13 3871", "al_r2_r13_3871"},
     {{al, r12, r3, 2775}, false, al, "al r12 r3 2775", "al_r12_r3_2775"},
     {{al, r12, r12, 421}, false, al, "al r12 r12 421", "al_r12_r12_421"},
     {{al, r4, r0, 3041}, false, al, "al r4 r0 3041", "al_r4_r0_3041"},
     {{al, r2, r2, 1736}, false, al, "al r2 r2 1736", "al_r2_r2_1736"},
     {{al, r14, r0, 4092}, false, al, "al r14 r0 4092", "al_r14_r0_4092"},
     {{al, r4, r12, 1687}, false, al, "al r4 r12 1687", "al_r4_r12_1687"},
     {{al, r8, r14, 3170}, false, al, "al r8 r14 3170", "al_r8_r14_3170"},
     {{al, r3, r5, 3449}, false, al, "al r3 r5 3449", "al_r3_r5_3449"},
     {{al, r3, r1, 2582}, false, al, "al r3 r1 2582", "al_r3_r1_2582"},
     {{al, r13, r9, 3057}, false, al, "al r13 r9 3057", "al_r13_r9_3057"},
     {{al, r10, r12, 1556}, false, al, "al r10 r12 1556", "al_r10_r12_1556"},
     {{al, r7, r10, 19}, false, al, "al r7 r10 19", "al_r7_r10_19"},
     {{al, r13, r11, 674}, false, al, "al r13 r11 674", "al_r13_r11_674"},
     {{al, r10, r1, 3099}, false, al, "al r10 r1 3099", "al_r10_r1_3099"},
     {{al, r0, r10, 1804}, false, al, "al r0 r10 1804", "al_r0_r10_1804"},
     {{al, r0, r12, 2021}, false, al, "al r0 r12 2021", "al_r0_r12_2021"},
     {{al, r14, r6, 2359}, false, al, "al r14 r6 2359", "al_r14_r6_2359"},
     {{al, r9, r11, 1542}, false, al, "al r9 r11 1542", "al_r9_r11_1542"},
     {{al, r4, r1, 3566}, false, al, "al r4 r1 3566", "al_r4_r1_3566"},
     {{al, r0, r6, 2662}, false, al, "al r0 r6 2662", "al_r0_r6_2662"},
     {{al, r13, r6, 2217}, false, al, "al r13 r6 2217", "al_r13_r6_2217"},
     {{al, r7, r9, 3287}, false, al, "al r7 r9 3287", "al_r7_r9_3287"},
     {{al, r12, r14, 2365}, false, al, "al r12 r14 2365", "al_r12_r14_2365"},
     {{al, r5, r10, 1168}, false, al, "al r5 r10 1168", "al_r5_r10_1168"},
     {{al, r7, r2, 1848}, false, al, "al r7 r2 1848", "al_r7_r2_1848"},
     {{al, r10, r6, 55}, false, al, "al r10 r6 55", "al_r10_r6_55"},
     {{al, r12, r6, 1246}, false, al, "al r12 r6 1246", "al_r12_r6_1246"},
     {{al, r10, r3, 2366}, false, al, "al r10 r3 2366", "al_r10_r3_2366"},
     {{al, r9, r7, 2012}, false, al, "al r9 r7 2012", "al_r9_r7_2012"},
     {{al, r6, r10, 3821}, false, al, "al r6 r10 3821", "al_r6_r10_3821"},
     {{al, r6, r1, 1241}, false, al, "al r6 r1 1241", "al_r6_r1_1241"},
     {{al, r0, r10, 2945}, false, al, "al r0 r10 2945", "al_r0_r10_2945"},
     {{al, r0, r5, 210}, false, al, "al r0 r5 210", "al_r0_r5_210"},
     {{al, r7, r13, 688}, false, al, "al r7 r13 688", "al_r7_r13_688"},
     {{al, r12, r0, 3072}, false, al, "al r12 r0 3072", "al_r12_r0_3072"},
     {{al, r10, r7, 1234}, false, al, "al r10 r7 1234", "al_r10_r7_1234"},
     {{al, r0, r5, 2545}, false, al, "al r0 r5 2545", "al_r0_r5_2545"},
     {{al, r13, r9, 663}, false, al, "al r13 r9 663", "al_r13_r9_663"},
     {{al, r6, r7, 3491}, false, al, "al r6 r7 3491", "al_r6_r7_3491"},
     {{al, r12, r5, 3008}, false, al, "al r12 r5 3008", "al_r12_r5_3008"},
     {{al, r12, r1, 1899}, false, al, "al r12 r1 1899", "al_r12_r1_1899"},
     {{al, r3, r3, 1437}, false, al, "al r3 r3 1437", "al_r3_r3_1437"},
     {{al, r5, r13, 1536}, false, al, "al r5 r13 1536", "al_r5_r13_1536"},
     {{al, r6, r9, 1035}, false, al, "al r6 r9 1035", "al_r6_r9_1035"},
     {{al, r9, r4, 3425}, false, al, "al r9 r4 3425", "al_r9_r4_3425"},
     {{al, r11, r10, 1274}, false, al, "al r11 r10 1274", "al_r11_r10_1274"},
     {{al, r7, r7, 3728}, false, al, "al r7 r7 3728", "al_r7_r7_3728"},
     {{al, r7, r1, 1186}, false, al, "al r7 r1 1186", "al_r7_r1_1186"},
     {{al, r11, r0, 3256}, false, al, "al r11 r0 3256", "al_r11_r0_3256"},
     {{al, r1, r8, 459}, false, al, "al r1 r8 459", "al_r1_r8_459"},
     {{al, r11, r3, 53}, false, al, "al r11 r3 53", "al_r11_r3_53"},
     {{al, r3, r14, 662}, false, al, "al r3 r14 662", "al_r3_r14_662"},
     {{al, r7, r0, 1498}, false, al, "al r7 r0 1498", "al_r7_r0_1498"},
     {{al, r14, r0, 3752}, false, al, "al r14 r0 3752", "al_r14_r0_3752"},
     {{al, r11, r5, 2535}, false, al, "al r11 r5 2535", "al_r11_r5_2535"},
     {{al, r12, r0, 3597}, false, al, "al r12 r0 3597", "al_r12_r0_3597"},
     {{al, r1, r11, 580}, false, al, "al r1 r11 580", "al_r1_r11_580"},
     {{al, r3, r5, 1348}, false, al, "al r3 r5 1348", "al_r3_r5_1348"},
     {{al, r10, r5, 3871}, false, al, "al r10 r5 3871", "al_r10_r5_3871"},
     {{al, r7, r8, 3989}, false, al, "al r7 r8 3989", "al_r7_r8_3989"},
     {{al, r8, r10, 3449}, false, al, "al r8 r10 3449", "al_r8_r10_3449"},
     {{al, r6, r8, 3907}, false, al, "al r6 r8 3907", "al_r6_r8_3907"},
     {{al, r14, r10, 1175}, false, al, "al r14 r10 1175", "al_r14_r10_1175"},
     {{al, r1, r5, 612}, false, al, "al r1 r5 612", "al_r1_r5_612"},
     {{al, r6, r5, 2545}, false, al, "al r6 r5 2545", "al_r6_r5_2545"},
     {{al, r4, r8, 582}, false, al, "al r4 r8 582", "al_r4_r8_582"},
     {{al, r10, r3, 1677}, false, al, "al r10 r3 1677", "al_r10_r3_1677"},
     {{al, r4, r13, 2821}, false, al, "al r4 r13 2821", "al_r4_r13_2821"},
     {{al, r8, r14, 2025}, false, al, "al r8 r14 2025", "al_r8_r14_2025"},
     {{al, r4, r3, 794}, false, al, "al r4 r3 794", "al_r4_r3_794"},
     {{al, r14, r7, 1870}, false, al, "al r14 r7 1870", "al_r14_r7_1870"},
     {{al, r8, r1, 1665}, false, al, "al r8 r1 1665", "al_r8_r1_1665"},
     {{al, r0, r14, 1666}, false, al, "al r0 r14 1666", "al_r0_r14_1666"},
     {{al, r0, r3, 932}, false, al, "al r0 r3 932", "al_r0_r3_932"},
     {{al, r9, r5, 1660}, false, al, "al r9 r5 1660", "al_r9_r5_1660"},
     {{al, r1, r12, 1687}, false, al, "al r1 r12 1687", "al_r1_r12_1687"},
     {{al, r2, r6, 3659}, false, al, "al r2 r6 3659", "al_r2_r6_3659"},
     {{al, r4, r13, 1892}, false, al, "al r4 r13 1892", "al_r4_r13_1892"},
     {{al, r10, r9, 3811}, false, al, "al r10 r9 3811", "al_r10_r9_3811"},
     {{al, r11, r3, 1732}, false, al, "al r11 r3 1732", "al_r11_r3_1732"},
     {{al, r8, r4, 2810}, false, al, "al r8 r4 2810", "al_r8_r4_2810"},
     {{al, r10, r9, 2462}, false, al, "al r10 r9 2462", "al_r10_r9_2462"},
     {{al, r4, r4, 2098}, false, al, "al r4 r4 2098", "al_r4_r4_2098"},
     {{al, r9, r1, 2314}, false, al, "al r9 r1 2314", "al_r9_r1_2314"},
     {{al, r6, r6, 2642}, false, al, "al r6 r6 2642", "al_r6_r6_2642"},
     {{al, r5, r8, 3638}, false, al, "al r5 r8 3638", "al_r5_r8_3638"},
     {{al, r12, r0, 3660}, false, al, "al r12 r0 3660", "al_r12_r0_3660"},
     {{al, r9, r9, 778}, false, al, "al r9 r9 778", "al_r9_r9_778"},
     {{al, r7, r4, 3003}, false, al, "al r7 r4 3003", "al_r7_r4_3003"},
     {{al, r5, r9, 3450}, false, al, "al r5 r9 3450", "al_r5_r9_3450"},
     {{al, r10, r0, 1666}, false, al, "al r10 r0 1666", "al_r10_r0_1666"},
     {{al, r10, r1, 2046}, false, al, "al r10 r1 2046", "al_r10_r1_2046"},
     {{al, r10, r12, 3239}, false, al, "al r10 r12 3239", "al_r10_r12_3239"},
     {{al, r0, r13, 3082}, false, al, "al r0 r13 3082", "al_r0_r13_3082"},
     {{al, r6, r0, 2617}, false, al, "al r6 r0 2617", "al_r6_r0_2617"},
     {{al, r5, r14, 2945}, false, al, "al r5 r14 2945", "al_r5_r14_2945"},
     {{al, r7, r0, 2359}, false, al, "al r7 r0 2359", "al_r7_r0_2359"},
     {{al, r1, r4, 958}, false, al, "al r1 r4 958", "al_r1_r4_958"},
     {{al, r6, r6, 1859}, false, al, "al r6 r6 1859", "al_r6_r6_1859"},
     {{al, r2, r4, 210}, false, al, "al r2 r4 210", "al_r2_r4_210"},
     {{al, r13, r11, 1261}, false, al, "al r13 r11 1261", "al_r13_r11_1261"},
     {{al, r8, r14, 964}, false, al, "al r8 r14 964", "al_r8_r14_964"},
     {{al, r8, r4, 3607}, false, al, "al r8 r4 3607", "al_r8_r4_3607"},
     {{al, r4, r5, 1934}, false, al, "al r4 r5 1934", "al_r4_r5_1934"},
     {{al, r6, r0, 678}, false, al, "al r6 r0 678", "al_r6_r0_678"},
     {{al, r0, r7, 2946}, false, al, "al r0 r7 2946", "al_r0_r7_2946"},
     {{al, r10, r5, 955}, false, al, "al r10 r5 955", "al_r10_r5_955"},
     {{al, r12, r7, 704}, false, al, "al r12 r7 704", "al_r12_r7_704"},
     {{al, r13, r6, 2619}, false, al, "al r13 r6 2619", "al_r13_r6_2619"},
     {{al, r10, r1, 3774}, false, al, "al r10 r1 3774", "al_r10_r1_3774"},
     {{al, r6, r8, 4065}, false, al, "al r6 r8 4065", "al_r6_r8_4065"},
     {{al, r9, r14, 2023}, false, al, "al r9 r14 2023", "al_r9_r14_2023"},
     {{al, r0, r11, 1459}, false, al, "al r0 r11 1459", "al_r0_r11_1459"},
     {{al, r3, r8, 3952}, false, al, "al r3 r8 3952", "al_r3_r8_3952"},
     {{al, r7, r3, 618}, false, al, "al r7 r3 618", "al_r7_r3_618"},
     {{al, r3, r10, 2948}, false, al, "al r3 r10 2948", "al_r3_r10_2948"},
     {{al, r9, r14, 3239}, false, al, "al r9 r14 3239", "al_r9_r14_3239"},
     {{al, r11, r10, 970}, false, al, "al r11 r10 970", "al_r11_r10_970"},
     {{al, r0, r3, 358}, false, al, "al r0 r3 358", "al_r0_r3_358"},
     {{al, r6, r13, 871}, false, al, "al r6 r13 871", "al_r6_r13_871"},
     {{al, r0, r5, 1266}, false, al, "al r0 r5 1266", "al_r0_r5_1266"},
     {{al, r7, r3, 2864}, false, al, "al r7 r3 2864", "al_r7_r3_2864"},
     {{al, r3, r8, 2689}, false, al, "al r3 r8 2689", "al_r3_r8_2689"},
     {{al, r0, r4, 719}, false, al, "al r0 r4 719", "al_r0_r4_719"},
     {{al, r7, r0, 3989}, false, al, "al r7 r0 3989", "al_r7_r0_3989"},
     {{al, r9, r2, 1666}, false, al, "al r9 r2 1666", "al_r9_r2_1666"},
     {{al, r9, r10, 2326}, false, al, "al r9 r10 2326", "al_r9_r10_2326"},
     {{al, r6, r6, 1551}, false, al, "al r6 r6 1551", "al_r6_r6_1551"},
     {{al, r6, r5, 3867}, false, al, "al r6 r5 3867", "al_r6_r5_3867"},
     {{al, r10, r0, 478}, false, al, "al r10 r0 478", "al_r10_r0_478"},
     {{al, r7, r13, 997}, false, al, "al r7 r13 997", "al_r7_r13_997"},
     {{al, r10, r1, 3717}, false, al, "al r10 r1 3717", "al_r10_r1_3717"},
     {{al, r3, r13, 3529}, false, al, "al r3 r13 3529", "al_r3_r13_3529"},
     {{al, r3, r0, 3802}, false, al, "al r3 r0 3802", "al_r3_r0_3802"},
     {{al, r3, r9, 3491}, false, al, "al r3 r9 3491", "al_r3_r9_3491"},
     {{al, r3, r0, 2945}, false, al, "al r3 r0 2945", "al_r3_r0_2945"},
     {{al, r7, r11, 3633}, false, al, "al r7 r11 3633", "al_r7_r11_3633"},
     {{al, r13, r4, 2224}, false, al, "al r13 r4 2224", "al_r13_r4_2224"},
     {{al, r9, r11, 3517}, false, al, "al r9 r11 3517", "al_r9_r11_3517"},
     {{al, r12, r13, 1916}, false, al, "al r12 r13 1916", "al_r12_r13_1916"},
     {{al, r10, r7, 4091}, false, al, "al r10 r7 4091", "al_r10_r7_4091"},
     {{al, r5, r0, 2040}, false, al, "al r5 r0 2040", "al_r5_r0_2040"},
     {{al, r10, r1, 83}, false, al, "al r10 r1 83", "al_r10_r1_83"},
     {{al, r12, r0, 98}, false, al, "al r12 r0 98", "al_r12_r0_98"},
     {{al, r7, r4, 3109}, false, al, "al r7 r4 3109", "al_r7_r4_3109"},
     {{al, r9, r13, 1536}, false, al, "al r9 r13 1536", "al_r9_r13_1536"},
     {{al, r12, r14, 1687}, false, al, "al r12 r14 1687", "al_r12_r14_1687"},
     {{al, r10, r13, 1567}, false, al, "al r10 r13 1567", "al_r10_r13_1567"},
     {{al, r3, r1, 872}, false, al, "al r3 r1 872", "al_r3_r1_872"},
     {{al, r0, r4, 2710}, false, al, "al r0 r4 2710", "al_r0_r4_2710"},
     {{al, r5, r14, 233}, false, al, "al r5 r14 233", "al_r5_r14_233"},
     {{al, r4, r0, 1437}, false, al, "al r4 r0 1437", "al_r4_r0_1437"},
     {{al, r5, r4, 1610}, false, al, "al r5 r4 1610", "al_r5_r4_1610"},
     {{al, r8, r13, 1660}, false, al, "al r8 r13 1660", "al_r8_r13_1660"},
     {{al, r2, r8, 1536}, false, al, "al r2 r8 1536", "al_r2_r8_1536"},
     {{al, r11, r7, 612}, false, al, "al r11 r7 612", "al_r11_r7_612"},
     {{al, r8, r6, 1198}, false, al, "al r8 r6 1198", "al_r8_r6_1198"},
     {{al, r2, r8, 1896}, false, al, "al r2 r8 1896", "al_r2_r8_1896"},
     {{al, r5, r9, 3039}, false, al, "al r5 r9 3039", "al_r5_r9_3039"},
     {{al, r2, r7, 1999}, false, al, "al r2 r7 1999", "al_r2_r7_1999"},
     {{al, r1, r3, 3564}, false, al, "al r1 r3 3564", "al_r1_r3_3564"},
     {{al, r0, r3, 55}, false, al, "al r0 r3 55", "al_r0_r3_55"},
     {{al, r12, r2, 198}, false, al, "al r12 r2 198", "al_r12_r2_198"},
     {{al, r12, r9, 797}, false, al, "al r12 r9 797", "al_r12_r9_797"},
     {{al, r2, r0, 3136}, false, al, "al r2 r0 3136", "al_r2_r0_3136"},
     {{al, r2, r14, 342}, false, al, "al r2 r14 342", "al_r2_r14_342"},
     {{al, r8, r14, 932}, false, al, "al r8 r14 932", "al_r8_r14_932"},
     {{al, r11, r9, 3544}, false, al, "al r11 r9 3544", "al_r11_r9_3544"},
     {{al, r4, r7, 1231}, false, al, "al r4 r7 1231", "al_r4_r7_1231"},
     {{al, r8, r11, 2933}, false, al, "al r8 r11 2933", "al_r8_r11_2933"},
     {{al, r11, r5, 0}, false, al, "al r11 r5 0", "al_r11_r5_0"},
     {{al, r12, r5, 1171}, false, al, "al r12 r5 1171", "al_r12_r5_1171"},
     {{al, r4, r6, 2541}, false, al, "al r4 r6 2541", "al_r4_r6_2541"},
     {{al, r5, r12, 2642}, false, al, "al r5 r12 2642", "al_r5_r12_2642"},
     {{al, r13, r4, 3397}, false, al, "al r13 r4 3397", "al_r13_r4_3397"},
     {{al, r14, r1, 3626}, false, al, "al r14 r1 3626", "al_r14_r1_3626"},
     {{al, r9, r4, 322}, false, al, "al r9 r4 322", "al_r9_r4_322"},
     {{al, r6, r11, 2026}, false, al, "al r6 r11 2026", "al_r6_r11_2026"},
     {{al, r10, r8, 1948}, false, al, "al r10 r8 1948", "al_r10_r8_1948"},
     {{al, r1, r1, 484}, false, al, "al r1 r1 484", "al_r1_r1_484"},
     {{al, r1, r1, 2690}, false, al, "al r1 r1 2690", "al_r1_r1_2690"},
     {{al, r2, r8, 662}, false, al, "al r2 r8 662", "al_r2_r8_662"},
     {{al, r10, r13, 2403}, false, al, "al r10 r13 2403", "al_r10_r13_2403"},
     {{al, r7, r6, 2374}, false, al, "al r7 r6 2374", "al_r7_r6_2374"},
     {{al, r3, r0, 4079}, false, al, "al r3 r0 4079", "al_r3_r0_4079"},
     {{al, r4, r7, 2728}, false, al, "al r4 r7 2728", "al_r4_r7_2728"},
     {{al, r12, r11, 679}, false, al, "al r12 r11 679", "al_r12_r11_679"},
     {{al, r10, r1, 3811}, false, al, "al r10 r1 3811", "al_r10_r1_3811"},
     {{al, r10, r11, 3921}, false, al, "al r10 r11 3921", "al_r10_r11_3921"},
     {{al, r12, r11, 1655}, false, al, "al r12 r11 1655", "al_r12_r11_1655"},
     {{al, r6, r5, 3811}, false, al, "al r6 r5 3811", "al_r6_r5_3811"},
     {{al, r14, r2, 3504}, false, al, "al r14 r2 3504", "al_r14_r2_3504"},
     {{al, r9, r10, 3209}, false, al, "al r9 r10 3209", "al_r9_r10_3209"},
     {{al, r0, r12, 2403}, false, al, "al r0 r12 2403", "al_r0_r12_2403"},
     {{al, r12, r8, 3439}, false, al, "al r12 r8 3439", "al_r12_r8_3439"},
     {{al, r1, r8, 850}, false, al, "al r1 r8 850", "al_r1_r8_850"},
     {{al, r9, r10, 2710}, false, al, "al r9 r10 2710", "al_r9_r10_2710"},
     {{al, r13, r3, 893}, false, al, "al r13 r3 893", "al_r13_r3_893"},
     {{al, r1, r8, 2821}, false, al, "al r1 r8 2821", "al_r1_r8_2821"},
     {{al, r0, r13, 2359}, false, al, "al r0 r13 2359", "al_r0_r13_2359"},
     {{al, r0, r11, 3076}, false, al, "al r0 r11 3076", "al_r0_r11_3076"},
     {{al, r13, r10, 2541}, false, al, "al r13 r10 2541", "al_r13_r10_2541"},
     {{al, r12, r10, 2662}, false, al, "al r12 r10 2662", "al_r12_r10_2662"},
     {{al, r1, r4, 2669}, false, al, "al r1 r4 2669", "al_r1_r4_2669"},
     {{al, r11, r7, 3254}, false, al, "al r11 r7 3254", "al_r11_r7_3254"},
     {{al, r10, r7, 1097}, false, al, "al r10 r7 1097", "al_r10_r7_1097"},
     {{al, r2, r1, 582}, false, al, "al r2 r1 582", "al_r2_r1_582"},
     {{al, r2, r2, 2532}, false, al, "al r2 r2 2532", "al_r2_r2_2532"},
     {{al, r5, r0, 806}, false, al, "al r5 r0 806", "al_r5_r0_806"},
     {{al, r1, r3, 794}, false, al, "al r1 r3 794", "al_r1_r3_794"},
     {{al, r8, r9, 19}, false, al, "al r8 r9 19", "al_r8_r9_19"},
     {{al, r7, r8, 875}, false, al, "al r7 r8 875", "al_r7_r8_875"},
     {{al, r1, r3, 1017}, false, al, "al r1 r3 1017", "al_r1_r3_1017"},
     {{al, r11, r3, 4090}, false, al, "al r11 r3 4090", "al_r11_r3_4090"},
     {{al, r3, r3, 1660}, false, al, "al r3 r3 1660", "al_r3_r3_1660"},
     {{al, r8, r3, 1848}, false, al, "al r8 r3 1848", "al_r8_r3_1848"},
     {{al, r14, r13, 689}, false, al, "al r14 r13 689", "al_r14_r13_689"},
     {{al, r11, r3, 1485}, false, al, "al r11 r3 1485", "al_r11_r3_1485"},
     {{al, r12, r6, 1348}, false, al, "al r12 r6 1348", "al_r12_r6_1348"},
     {{al, r8, r5, 2072}, false, al, "al r8 r5 2072", "al_r8_r5_2072"},
     {{al, r6, r2, 4037}, false, al, "al r6 r2 4037", "al_r6_r2_4037"},
     {{al, r4, r13, 3638}, false, al, "al r4 r13 3638", "al_r4_r13_3638"},
     {{al, r1, r0, 915}, false, al, "al r1 r0 915", "al_r1_r0_915"},
     {{al, r5, r6, 3771}, false, al, "al r5 r6 3771", "al_r5_r6_3771"},
     {{al, r0, r4, 2535}, false, al, "al r0 r4 2535", "al_r0_r4_2535"},
     {{al, r2, r7, 580}, false, al, "al r2 r7 580", "al_r2_r7_580"},
     {{al, r12, r14, 1009}, false, al, "al r12 r14 1009", "al_r12_r14_1009"},
     {{al, r4, r14, 1374}, false, al, "al r4 r14 1374", "al_r4_r14_1374"},
     {{al, r0, r11, 2381}, false, al, "al r0 r11 2381", "al_r0_r11_2381"},
     {{al, r9, r2, 1027}, false, al, "al r9 r2 1027", "al_r9_r2_1027"},
     {{al, r6, r8, 2245}, false, al, "al r6 r8 2245", "al_r6_r8_2245"},
     {{al, r5, r5, 2427}, false, al, "al r5 r5 2427", "al_r5_r5_2427"},
     {{al, r11, r1, 2025}, false, al, "al r11 r1 2025", "al_r11_r1_2025"},
     {{al, r1, r9, 3765}, false, al, "al r1 r9 3765", "al_r1_r9_3765"},
     {{al, r8, r7, 2359}, false, al, "al r8 r7 2359", "al_r8_r7_2359"},
     {{al, r7, r5, 2247}, false, al, "al r7 r5 2247", "al_r7_r5_2247"},
     {{al, r9, r14, 2665}, false, al, "al r9 r14 2665", "al_r9_r14_2665"},
     {{al, r1, r14, 3063}, false, al, "al r1 r14 3063", "al_r1_r14_3063"},
     {{al, r2, r13, 3696}, false, al, "al r2 r13 3696", "al_r2_r13_3696"},
     {{al, r5, r4, 3239}, false, al, "al r5 r4 3239", "al_r5_r4_3239"},
     {{al, r9, r8, 3739}, false, al, "al r9 r8 3739", "al_r9_r8_3739"},
     {{al, r12, r8, 513}, false, al, "al r12 r8 513", "al_r12_r8_513"},
     {{al, r0, r1, 1043}, false, al, "al r0 r1 1043", "al_r0_r1_1043"},
     {{al, r2, r4, 2999}, false, al, "al r2 r4 2999", "al_r2_r4_2999"},
     {{al, r5, r6, 1660}, false, al, "al r5 r6 1660", "al_r5_r6_1660"},
     {{al, r12, r11, 2976}, false, al, "al r12 r11 2976", "al_r12_r11_2976"},
     {{al, r5, r2, 1652}, false, al, "al r5 r2 1652", "al_r5_r2_1652"},
     {{al, r9, r2, 3660}, false, al, "al r9 r2 3660", "al_r9_r2_3660"},
     {{al, r0, r8, 2929}, false, al, "al r0 r8 2929", "al_r0_r8_2929"},
     {{al, r14, r13, 2012}, false, al, "al r14 r13 2012", "al_r14_r13_2012"},
     {{al, r6, r1, 1651}, false, al, "al r6 r1 1651", "al_r6_r1_1651"},
     {{al, r5, r9, 2796}, false, al, "al r5 r9 2796", "al_r5_r9_2796"},
     {{al, r6, r0, 1459}, false, al, "al r6 r0 1459", "al_r6_r0_1459"},
     {{al, r9, r12, 1655}, false, al, "al r9 r12 1655", "al_r9_r12_1655"},
     {{al, r9, r7, 524}, false, al, "al r9 r7 524", "al_r9_r7_524"},
     {{al, r0, r8, 2044}, false, al, "al r0 r8 2044", "al_r0_r8_2044"},
     {{al, r0, r14, 1475}, false, al, "al r0 r14 1475", "al_r0_r14_1475"},
     {{al, r13, r14, 282}, false, al, "al r13 r14 282", "al_r13_r14_282"},
     {{al, r6, r14, 3266}, false, al, "al r6 r14 3266", "al_r6_r14_3266"},
     {{al, r6, r7, 806}, false, al, "al r6 r7 806", "al_r6_r7_806"},
     {{al, r3, r6, 811}, false, al, "al r3 r6 811", "al_r3_r6_811"},
     {{al, r7, r3, 2590}, false, al, "al r7 r3 2590", "al_r7_r3_2590"},
     {{al, r10, r6, 3399}, false, al, "al r10 r6 3399", "al_r10_r6_3399"},
     {{al, r10, r4, 398}, false, al, "al r10 r4 398", "al_r10_r4_398"},
     {{al, r10, r2, 2651}, false, al, "al r10 r2 2651", "al_r10_r2_2651"},
     {{al, r3, r8, 1687}, false, al, "al r3 r8 1687", "al_r3_r8_1687"},
     {{al, r6, r12, 2069}, false, al, "al r6 r12 2069", "al_r6_r12_2069"},
     {{al, r1, r14, 3487}, false, al, "al r1 r14 3487", "al_r1_r14_3487"},
     {{al, r5, r11, 322}, false, al, "al r5 r11 322", "al_r5_r11_322"},
     {{al, r4, r13, 3662}, false, al, "al r4 r13 3662", "al_r4_r13_3662"},
     {{al, r6, r11, 2119}, false, al, "al r6 r11 2119", "al_r6_r11_2119"},
     {{al, r1, r9, 3659}, false, al, "al r1 r9 3659", "al_r1_r9_3659"},
     {{al, r9, r14, 2999}, false, al, "al r9 r14 2999", "al_r9_r14_2999"},
     {{al, r5, r0, 4076}, false, al, "al r5 r0 4076", "al_r5_r0_4076"},
     {{al, r0, r10, 1635}, false, al, "al r0 r10 1635", "al_r0_r10_1635"},
     {{al, r0, r9, 3583}, false, al, "al r0 r9 3583", "al_r0_r9_3583"},
     {{al, r12, r12, 2381}, false, al, "al r12 r12 2381", "al_r12_r12_2381"},
     {{al, r11, r11, 811}, false, al, "al r11 r11 811", "al_r11_r11_811"},
     {{al, r4, r13, 2175}, false, al, "al r4 r13 2175", "al_r4_r13_2175"},
     {{al, r14, r6, 2202}, false, al, "al r14 r6 2202", "al_r14_r6_2202"},
     {{al, r7, r7, 778}, false, al, "al r7 r7 778", "al_r7_r7_778"},
     {{al, r0, r7, 1485}, false, al, "al r0 r7 1485", "al_r0_r7_1485"},
     {{al, r7, r3, 3472}, false, al, "al r7 r3 3472", "al_r7_r3_3472"},
     {{al, r2, r0, 2545}, false, al, "al r2 r0 2545", "al_r2_r0_2545"},
     {{al, r13, r3, 2098}, false, al, "al r13 r3 2098", "al_r13_r3_2098"},
     {{al, r7, r3, 3002}, false, al, "al r7 r3 3002", "al_r7_r3_3002"},
     {{al, r6, r9, 3195}, false, al, "al r6 r9 3195", "al_r6_r9_3195"},
     {{al, r14, r13, 1642}, false, al, "al r14 r13 1642", "al_r14_r13_1642"},
     {{al, r11, r0, 47}, false, al, "al r11 r0 47", "al_r11_r0_47"},
     {{al, r6, r0, 3117}, false, al, "al r6 r0 3117", "al_r6_r0_3117"},
     {{al, r3, r7, 1892}, false, al, "al r3 r7 1892", "al_r3_r7_1892"},
     {{al, r10, r7, 719}, false, al, "al r10 r7 719", "al_r10_r7_719"},
     {{al, r11, r14, 263}, false, al, "al r11 r14 263", "al_r11_r14_263"},
     {{al, r8, r7, 4095}, false, al, "al r8 r7 4095", "al_r8_r7_4095"},
     {{al, r6, r3, 2245}, false, al, "al r6 r3 2245", "al_r6_r3_2245"},
     {{al, r10, r3, 19}, false, al, "al r10 r3 19", "al_r10_r3_19"},
     {{al, r5, r5, 3949}, false, al, "al r5 r5 3949", "al_r5_r5_3949"},
     {{al, r4, r12, 70}, false, al, "al r4 r12 70", "al_r4_r12_70"},
     {{al, r6, r13, 3504}, false, al, "al r6 r13 3504", "al_r6_r13_3504"},
     {{al, r3, r8, 2016}, false, al, "al r3 r8 2016", "al_r3_r8_2016"},
     {{al, r2, r1, 2403}, false, al, "al r2 r1 2403", "al_r2_r1_2403"},
     {{al, r13, r14, 797}, false, al, "al r13 r14 797", "al_r13_r14_797"},
     {{al, r13, r0, 2792}, false, al, "al r13 r0 2792", "al_r13_r0_2792"},
     {{al, r11, r9, 1526}, false, al, "al r11 r9 1526", "al_r11_r9_1526"},
     {{al, r5, r6, 1872}, false, al, "al r5 r6 1872", "al_r5_r6_1872"},
     {{al, r10, r3, 1896}, false, al, "al r10 r3 1896", "al_r10_r3_1896"},
     {{al, r1, r3, 1099}, false, al, "al r1 r3 1099", "al_r1_r3_1099"},
     {{al, r3, r7, 3610}, false, al, "al r3 r7 3610", "al_r3_r7_3610"},
     {{al, r7, r8, 3963}, false, al, "al r7 r8 3963", "al_r7_r8_3963"},
     {{al, r8, r5, 1458}, false, al, "al r8 r5 1458", "al_r8_r5_1458"},
     {{al, r9, r1, 1732}, false, al, "al r9 r1 1732", "al_r9_r1_1732"},
     {{al, r9, r11, 2036}, false, al, "al r9 r11 2036", "al_r9_r11_2036"},
     {{al, r6, r9, 3625}, false, al, "al r6 r9 3625", "al_r6_r9_3625"},
     {{al, r8, r2, 2892}, false, al, "al r8 r2 2892", "al_r8_r2_2892"},
     {{al, r1, r5, 1458}, false, al, "al r1 r5 1458", "al_r1_r5_1458"},
     {{al, r6, r6, 490}, false, al, "al r6 r6 490", "al_r6_r6_490"},
     {{al, r14, r7, 2546}, false, al, "al r14 r7 2546", "al_r14_r7_2546"},
     {{al, r11, r8, 3771}, false, al, "al r11 r8 3771", "al_r11_r8_3771"},
     {{al, r5, r9, 1642}, false, al, "al r5 r9 1642", "al_r5_r9_1642"},
     {{al, r7, r14, 3438}, false, al, "al r7 r14 3438", "al_r7_r14_3438"},
     {{al, r7, r11, 663}, false, al, "al r7 r11 663", "al_r7_r11_663"},
     {{al, r0, r10, 3865}, false, al, "al r0 r10 3865", "al_r0_r10_3865"},
     {{al, r3, r4, 3008}, false, al, "al r3 r4 3008", "al_r3_r4_3008"},
     {{al, r2, r7, 2701}, false, al, "al r2 r7 2701", "al_r2_r7_2701"},
     {{al, r7, r7, 3660}, false, al, "al r7 r7 3660", "al_r7_r7_3660"},
     {{al, r11, r12, 1186}, false, al, "al r11 r12 1186", "al_r11_r12_1186"},
     {{al, r3, r3, 1567}, false, al, "al r3 r3 1567", "al_r3_r3_1567"},
     {{al, r1, r3, 3636}, false, al, "al r1 r3 3636", "al_r1_r3_3636"},
     {{al, r0, r5, 1750}, false, al, "al r0 r5 1750", "al_r0_r5_1750"},
     {{al, r4, r9, 4082}, false, al, "al r4 r9 4082", "al_r4_r9_4082"},
     {{al, r12, r9, 3660}, false, al, "al r12 r9 3660", "al_r12_r9_3660"},
     {{al, r14, r7, 3136}, false, al, "al r14 r7 3136", "al_r14_r7_3136"},
     {{al, r13, r9, 3914}, false, al, "al r13 r9 3914", "al_r13_r9_3914"},
     {{al, r12, r13, 3899}, false, al, "al r12 r13 3899", "al_r12_r13_3899"},
     {{al, r9, r2, 2451}, false, al, "al r9 r2 2451", "al_r9_r2_2451"},
     {{al, r4, r5, 3728}, false, al, "al r4 r5 3728", "al_r4_r5_3728"},
     {{al, r5, r3, 2208}, false, al, "al r5 r3 2208", "al_r5_r3_2208"},
     {{al, r0, r12, 915}, false, al, "al r0 r12 915", "al_r0_r12_915"},
     {{al, r3, r2, 2069}, false, al, "al r3 r2 2069", "al_r3_r2_2069"},
     {{al, r3, r7, 2464}, false, al, "al r3 r7 2464", "al_r3_r7_2464"},
     {{al, r10, r2, 2906}, false, al, "al r10 r2 2906", "al_r10_r2_2906"},
     {{al, r13, r9, 48}, false, al, "al r13 r9 48", "al_r13_r9_48"},
     {{al, r14, r8, 1948}, false, al, "al r14 r8 1948", "al_r14_r8_1948"},
     {{al, r9, r11, 3405}, false, al, "al r9 r11 3405", "al_r9_r11_3405"},
     {{al, r2, r0, 1099}, false, al, "al r2 r0 1099", "al_r2_r0_1099"},
     {{al, r4, r6, 55}, false, al, "al r4 r6 55", "al_r4_r6_55"},
     {{al, r3, r11, 3439}, false, al, "al r3 r11 3439", "al_r3_r11_3439"},
     {{al, r13, r4, 2240}, false, al, "al r13 r4 2240", "al_r13_r4_2240"},
     {{al, r8, r7, 2290}, false, al, "al r8 r7 2290", "al_r8_r7_2290"},
     {{al, r12, r6, 1687}, false, al, "al r12 r6 1687", "al_r12_r6_1687"},
     {{al, r4, r9, 3856}, false, al, "al r4 r9 3856", "al_r4_r9_3856"},
     {{al, r7, r1, 2359}, false, al, "al r7 r1 2359", "al_r7_r1_2359"},
     {{al, r5, r3, 3994}, false, al, "al r5 r3 3994", "al_r5_r3_3994"},
     {{al, r3, r10, 3633}, false, al, "al r3 r10 3633", "al_r3_r10_3633"},
     {{al, r11, r13, 2864}, false, al, "al r11 r13 2864", "al_r11_r13_2864"},
     {{al, r12, r12, 2451}, false, al, "al r12 r12 2451", "al_r12_r12_2451"},
     {{al, r7, r13, 3717}, false, al, "al r7 r13 3717", "al_r7_r13_3717"},
     {{al, r2, r6, 1899}, false, al, "al r2 r6 1899", "al_r2_r6_1899"},
     {{al, r10, r11, 525}, false, al, "al r10 r11 525", "al_r10_r11_525"},
     {{al, r3, r7, 2427}, false, al, "al r3 r7 2427", "al_r3_r7_2427"},
     {{al, r1, r2, 3003}, false, al, "al r1 r2 3003", "al_r1_r2_3003"},
     {{al, r2, r10, 871}, false, al, "al r2 r10 871", "al_r2_r10_871"},
     {{al, r10, r0, 2866}, false, al, "al r10 r0 2866", "al_r10_r0_2866"},
     {{al, r1, r7, 2710}, false, al, "al r1 r7 2710", "al_r1_r7_2710"},
     {{al, r5, r1, 704}, false, al, "al r5 r1 704", "al_r5_r1_704"},
     {{al, r3, r7, 3076}, false, al, "al r3 r7 3076", "al_r3_r7_3076"},
     {{al, r0, r6, 2311}, false, al, "al r0 r6 2311", "al_r0_r6_2311"},
     {{al, r12, r13, 2665}, false, al, "al r12 r13 2665", "al_r12_r13_2665"},
     {{al, r2, r13, 2464}, false, al, "al r2 r13 2464", "al_r2_r13_2464"},
     {{al, r11, r9, 496}, false, al, "al r11 r9 496", "al_r11_r9_496"},
     {{al, r10, r10, 2023}, false, al, "al r10 r10 2023", "al_r10_r10_2023"},
     {{al, r0, r0, 3787}, false, al, "al r0 r0 3787", "al_r0_r0_3787"},
     {{al, r2, r10, 2183}, false, al, "al r2 r10 2183", "al_r2_r10_2183"},
     {{al, r10, r12, 3162}, false, al, "al r10 r12 3162", "al_r10_r12_3162"},
     {{al, r0, r2, 2290}, false, al, "al r0 r2 2290", "al_r0_r2_2290"},
     {{al, r9, r10, 4090}, false, al, "al r9 r10 4090", "al_r9_r10_4090"},
     {{al, r1, r13, 2374}, false, al, "al r1 r13 2374", "al_r1_r13_2374"},
     {{al, r1, r8, 3610}, false, al, "al r1 r8 3610", "al_r1_r8_3610"},
     {{al, r6, r2, 1948}, false, al, "al r6 r2 1948", "al_r6_r2_1948"},
     {{al, r9, r0, 3963}, false, al, "al r9 r0 3963", "al_r9_r0_3963"},
     {{al, r6, r10, 3544}, false, al, "al r6 r10 3544", "al_r6_r10_3544"},
     {{al, r3, r1, 429}, false, al, "al r3 r1 429", "al_r3_r1_429"},
     {{al, r7, r8, 3449}, false, al, "al r7 r8 3449", "al_r7_r8_3449"},
     {{al, r12, r2, 766}, false, al, "al r12 r2 766", "al_r12_r2_766"},
     {{al, r0, r13, 264}, false, al, "al r0 r13 264", "al_r0_r13_264"},
     {{al, r12, r5, 2098}, false, al, "al r12 r5 2098", "al_r12_r5_2098"},
     {{al, r7, r5, 964}, false, al, "al r7 r5 964", "al_r7_r5_964"},
     {{al, r3, r14, 251}, false, al, "al r3 r14 251", "al_r3_r14_251"},
     {{al, r7, r10, 3002}, false, al, "al r7 r10 3002", "al_r7_r10_3002"},
     {{al, r4, r12, 1699}, false, al, "al r4 r12 1699", "al_r4_r12_1699"},
     {{al, r10, r10, 1135}, false, al, "al r10 r10 1135", "al_r10_r10_1135"},
     {{al, r0, r1, 3063}, false, al, "al r0 r1 3063", "al_r0_r1_3063"},
     {{al, r14, r4, 1295}, false, al, "al r14 r4 1295", "al_r14_r4_1295"},
     {{al, r11, r12, 770}, false, al, "al r11 r12 770", "al_r11_r12_770"},
     {{al, r14, r9, 523}, false, al, "al r14 r9 523", "al_r14_r9_523"},
     {{al, r2, r9, 47}, false, al, "al r2 r9 47", "al_r2_r9_47"},
     {{al, r11, r6, 704}, false, al, "al r11 r6 704", "al_r11_r6_704"},
     {{al, r4, r12, 1536}, false, al, "al r4 r12 1536", "al_r4_r12_1536"},
     {{al, r4, r13, 582}, false, al, "al r4 r13 582", "al_r4_r13_582"},
     {{al, r14, r2, 1394}, false, al, "al r14 r2 1394", "al_r14_r2_1394"},
     {{al, r3, r6, 3583}, false, al, "al r3 r6 3583", "al_r3_r6_3583"},
     {{al, r7, r5, 3157}, false, al, "al r7 r5 3157", "al_r7_r5_3157"},
     {{al, r14, r3, 3142}, false, al, "al r14 r3 3142", "al_r14_r3_3142"},
     {{al, r7, r9, 1666}, false, al, "al r7 r9 1666", "al_r7_r9_1666"},
     {{al, r9, r9, 180}, false, al, "al r9 r9 180", "al_r9_r9_180"},
     {{al, r7, r9, 4037}, false, al, "al r7 r9 4037", "al_r7_r9_4037"},
     {{al, r4, r1, 1445}, false, al, "al r4 r1 1445", "al_r4_r1_1445"},
     {{al, r7, r9, 2202}, false, al, "al r7 r9 2202", "al_r7_r9_2202"},
     {{al, r12, r7, 547}, false, al, "al r12 r7 547", "al_r12_r7_547"},
     {{al, r1, r11, 2799}, false, al, "al r1 r11 2799", "al_r1_r11_2799"},
     {{al, r4, r7, 679}, false, al, "al r4 r7 679", "al_r4_r7_679"},
     {{al, r0, r9, 1135}, false, al, "al r0 r9 1135", "al_r0_r9_1135"},
     {{al, r10, r2, 3139}, false, al, "al r10 r2 3139", "al_r10_r2_3139"},
     {{al, r8, r11, 601}, false, al, "al r8 r11 601", "al_r8_r11_601"},
     {{al, r8, r2, 3034}, false, al, "al r8 r2 3034", "al_r8_r2_3034"},
     {{al, r10, r12, 4}, false, al, "al r10 r12 4", "al_r10_r12_4"},
     {{al, r14, r2, 2119}, false, al, "al r14 r2 2119", "al_r14_r2_2119"},
     {{al, r7, r10, 3597}, false, al, "al r7 r10 3597", "al_r7_r10_3597"},
     {{al, r3, r11, 1567}, false, al, "al r3 r11 1567", "al_r3_r11_1567"},
     {{al, r7, r0, 3397}, false, al, "al r7 r0 3397", "al_r7_r0_3397"},
     {{al, r2, r6, 3491}, false, al, "al r2 r6 3491", "al_r2_r6_3491"},
     {{al, r6, r13, 1266}, false, al, "al r6 r13 1266", "al_r6_r13_1266"},
     {{al, r7, r2, 580}, false, al, "al r7 r2 580", "al_r7_r2_580"},
     {{al, r1, r4, 2044}, false, al, "al r1 r4 2044", "al_r1_r4_2044"},
     {{al, r14, r11, 3544}, false, al, "al r14 r11 3544", "al_r14_r11_3544"},
     {{al, r11, r11, 2044}, false, al, "al r11 r11 2044", "al_r11_r11_2044"},
     {{al, r3, r5, 180}, false, al, "al r3 r5 180", "al_r3_r5_180"},
     {{al, r11, r1, 3491}, false, al, "al r11 r1 3491", "al_r11_r1_3491"},
     {{al, r3, r11, 2792}, false, al, "al r3 r11 2792", "al_r3_r11_2792"},
     {{al, r12, r1, 523}, false, al, "al r12 r1 523", "al_r12_r1_523"},
     {{al, r2, r8, 72}, false, al, "al r2 r8 72", "al_r2_r8_72"},
     {{al, r14, r7, 2619}, false, al, "al r14 r7 2619", "al_r14_r7_2619"},
     {{al, r9, r14, 662}, false, al, "al r9 r14 662", "al_r9_r14_662"},
     {{al, r12, r12, 932}, false, al, "al r12 r12 932", "al_r12_r12_932"},
     {{al, r13, r11, 1750}, false, al, "al r13 r11 1750", "al_r13_r11_1750"},
     {{al, r7, r2, 2451}, false, al, "al r7 r2 2451", "al_r7_r2_2451"},
     {{al, r4, r0, 2710}, false, al, "al r4 r0 2710", "al_r4_r0_2710"},
     {{al, r14, r14, 429}, false, al, "al r14 r14 429", "al_r14_r14_429"},
     {{al, r9, r12, 2523}, false, al, "al r9 r12 2523", "al_r9_r12_2523"},
     {{al, r3, r10, 362}, false, al, "al r3 r10 362", "al_r3_r10_362"},
     {{al, r11, r7, 2588}, false, al, "al r11 r7 2588", "al_r11_r7_2588"},
     {{al, r6, r13, 791}, false, al, "al r6 r13 791", "al_r6_r13_791"},
     {{al, r12, r5, 1924}, false, al, "al r12 r5 1924", "al_r12_r5_1924"},
     {{al, r9, r0, 2813}, false, al, "al r9 r0 2813", "al_r9_r0_2813"},
     {{al, r0, r11, 2016}, false, al, "al r0 r11 2016", "al_r0_r11_2016"},
     {{al, r9, r11, 2086}, false, al, "al r9 r11 2086", "al_r9_r11_2086"},
     {{al, r1, r0, 3663}, false, al, "al r1 r0 3663", "al_r1_r0_3663"},
     {{al, r6, r13, 3541}, false, al, "al r6 r13 3541", "al_r6_r13_3541"},
     {{al, r3, r3, 774}, false, al, "al r3 r3 774", "al_r3_r3_774"},
     {{al, r14, r2, 2072}, false, al, "al r14 r2 2072", "al_r14_r2_2072"},
     {{al, r10, r3, 2718}, false, al, "al r10 r3 2718", "al_r10_r3_2718"},
     {{al, r13, r2, 2224}, false, al, "al r13 r2 2224", "al_r13_r2_2224"},
     {{al, r14, r0, 2026}, false, al, "al r14 r0 2026", "al_r14_r0_2026"},
     {{al, r0, r8, 2978}, false, al, "al r0 r8 2978", "al_r0_r8_2978"},
     {{al, r3, r12, 3870}, false, al, "al r3 r12 3870", "al_r3_r12_3870"},
     {{al, r10, r12, 4092}, false, al, "al r10 r12 4092", "al_r10_r12_4092"},
     {{al, r10, r3, 1261}, false, al, "al r10 r3 1261", "al_r10_r3_1261"},
     {{al, r11, r14, 3652}, false, al, "al r11 r14 3652", "al_r11_r14_3652"},
     {{al, r10, r7, 960}, false, al, "al r10 r7 960", "al_r10_r7_960"},
     {{al, r11, r1, 4065}, false, al, "al r11 r1 4065", "al_r11_r1_4065"},
     {{al, r5, r0, 2403}, false, al, "al r5 r0 2403", "al_r5_r0_2403"},
     {{al, r5, r1, 479}, false, al, "al r5 r1 479", "al_r5_r1_479"},
     {{al, r1, r8, 2710}, false, al, "al r1 r8 2710", "al_r1_r8_2710"},
     {{al, r14, r6, 1981}, false, al, "al r14 r6 1981", "al_r14_r6_1981"},
     {{al, r8, r1, 1027}, false, al, "al r8 r1 1027", "al_r8_r1_1027"},
     {{al, r5, r5, 3138}, false, al, "al r5 r5 3138", "al_r5_r5_3138"},
     {{al, r3, r14, 3541}, false, al, "al r3 r14 3541", "al_r3_r14_3541"},
     {{al, r3, r9, 674}, false, al, "al r3 r9 674", "al_r3_r9_674"},
     {{al, r3, r7, 997}, false, al, "al r3 r7 997", "al_r3_r7_997"},
     {{al, r13, r13, 57}, false, al, "al r13 r13 57", "al_r13_r13_57"},
     {{al, r3, r7, 662}, false, al, "al r3 r7 662", "al_r3_r7_662"},
     {{al, r13, r2, 3918}, false, al, "al r13 r2 3918", "al_r13_r2_3918"},
     {{al, r9, r9, 3517}, false, al, "al r9 r9 3517", "al_r9_r9_3517"},
     {{al, r10, r1, 932}, false, al, "al r10 r1 932", "al_r10_r1_932"},
     {{al, r9, r7, 251}, false, al, "al r9 r7 251", "al_r9_r7_251"},
     {{al, r0, r11, 2507}, false, al, "al r0 r11 2507", "al_r0_r11_2507"},
     {{al, r0, r3, 732}, false, al, "al r0 r3 732", "al_r0_r3_732"},
     {{al, r3, r6, 997}, false, al, "al r3 r6 997", "al_r3_r6_997"},
     {{al, r6, r5, 3529}, false, al, "al r6 r5 3529", "al_r6_r5_3529"},
     {{al, r4, r1, 612}, false, al, "al r4 r1 612", "al_r4_r1_612"},
     {{al, r1, r0, 4090}, false, al, "al r1 r0 4090", "al_r1_r0_4090"},
     {{al, r13, r12, 3865}, false, al, "al r13 r12 3865", "al_r13_r12_3865"},
     {{al, r9, r7, 1116}, false, al, "al r9 r7 1116", "al_r9_r7_1116"},
     {{al, r6, r11, 1459}, false, al, "al r6 r11 1459", "al_r6_r11_1459"},
     {{al, r8, r13, 1458}, false, al, "al r8 r13 1458", "al_r8_r13_1458"},
     {{al, r11, r6, 1848}, false, al, "al r11 r6 1848", "al_r11_r6_1848"},
     {{al, r6, r7, 3811}, false, al, "al r6 r7 3811", "al_r6_r7_3811"},
     {{al, r12, r10, 3688}, false, al, "al r12 r10 3688", "al_r12_r10_3688"},
     {{al, r1, r12, 2454}, false, al, "al r1 r12 2454", "al_r1_r12_2454"},
     {{al, r10, r0, 2366}, false, al, "al r10 r0 2366", "al_r10_r0_2366"},
     {{al, r14, r7, 3765}, false, al, "al r14 r7 3765", "al_r14_r7_3765"},
     {{al, r5, r4, 3660}, false, al, "al r5 r4 3660", "al_r5_r4_3660"},
     {{al, r2, r9, 3157}, false, al, "al r2 r9 3157", "al_r2_r9_3157"},
     {{al, r3, r7, 1459}, false, al, "al r3 r7 1459", "al_r3_r7_1459"},
     {{al, r3, r7, 4092}, false, al, "al r3 r7 4092", "al_r3_r7_4092"},
     {{al, r8, r13, 1916}, false, al, "al r8 r13 1916", "al_r8_r13_1916"},
     {{al, r3, r11, 672}, false, al, "al r3 r11 672", "al_r3_r11_672"},
     {{al, r14, r12, 3343}, false, al, "al r14 r12 3343", "al_r14_r12_3343"},
     {{al, r5, r0, 3880}, false, al, "al r5 r0 3880", "al_r5_r0_3880"},
     {{al, r2, r3, 2839}, false, al, "al r2 r3 2839", "al_r2_r3_2839"},
     {{al, r13, r13, 3413}, false, al, "al r13 r13 3413", "al_r13_r13_3413"},
     {{al, r5, r6, 459}, false, al, "al r5 r6 459", "al_r5_r6_459"},
     {{al, r9, r12, 1677}, false, al, "al r9 r12 1677", "al_r9_r12_1677"},
     {{al, r13, r3, 3139}, false, al, "al r13 r3 3139", "al_r13_r3_3139"},
     {{al, r5, r8, 365}, false, al, "al r5 r8 365", "al_r5_r8_365"},
     {{al, r9, r1, 3003}, false, al, "al r9 r1 3003", "al_r9_r1_3003"},
     {{al, r2, r4, 2701}, false, al, "al r2 r4 2701", "al_r2_r4_2701"},
     {{al, r6, r3, 513}, false, al, "al r6 r3 513", "al_r6_r3_513"},
     {{al, r0, r3, 2069}, false, al, "al r0 r3 2069", "al_r0_r3_2069"},
     {{al, r14, r5, 342}, false, al, "al r14 r5 342", "al_r14_r5_342"},
     {{al, r14, r6, 490}, false, al, "al r14 r6 490", "al_r14_r6_490"},
     {{al, r2, r12, 3907}, false, al, "al r2 r12 3907", "al_r2_r12_3907"},
     {{al, r5, r11, 2338}, false, al, "al r5 r11 2338", "al_r5_r11_2338"},
     {{al, r6, r12, 2072}, false, al, "al r6 r12 2072", "al_r6_r12_2072"},
     {{al, r4, r13, 2290}, false, al, "al r4 r13 2290", "al_r4_r13_2290"},
     {{al, r12, r3, 459}, false, al, "al r12 r3 459", "al_r12_r3_459"},
     {{al, r2, r3, 2427}, false, al, "al r2 r3 2427", "al_r2_r3_2427"},
     {{al, r2, r14, 4058}, false, al, "al r2 r14 4058", "al_r2_r14_4058"},
     {{al, r7, r0, 342}, false, al, "al r7 r0 342", "al_r7_r0_342"},
     {{al, r12, r8, 4065}, false, al, "al r12 r8 4065", "al_r12_r8_4065"},
     {{al, r5, r13, 688}, false, al, "al r5 r13 688", "al_r5_r13_688"},
     {{al, r12, r2, 3344}, false, al, "al r12 r2 3344", "al_r12_r2_3344"},
     {{al, r8, r14, 106}, false, al, "al r8 r14 106", "al_r8_r14_106"},
     {{al, r8, r12, 791}, false, al, "al r8 r12 791", "al_r8_r12_791"},
     {{al, r12, r1, 429}, false, al, "al r12 r1 429", "al_r12_r1_429"},
     {{al, r12, r5, 3717}, false, al, "al r12 r5 3717", "al_r12_r5_3717"},
     {{al, r11, r2, 3743}, false, al, "al r11 r2 3743", "al_r11_r2_3743"},
     {{al, r5, r0, 1808}, false, al, "al r5 r0 1808", "al_r5_r0_1808"},
     {{al, r7, r3, 2402}, false, al, "al r7 r3 2402", "al_r7_r3_2402"},
     {{al, r0, r2, 1437}, false, al, "al r0 r2 1437", "al_r0_r2_1437"},
     {{al, r3, r7, 3425}, false, al, "al r3 r7 3425", "al_r3_r7_3425"},
     {{al, r12, r4, 3221}, false, al, "al r12 r4 3221", "al_r12_r4_3221"},
     {{al, r12, r5, 3585}, false, al, "al r12 r5 3585", "al_r12_r5_3585"},
     {{al, r11, r6, 3003}, false, al, "al r11 r6 3003", "al_r11_r6_3003"},
     {{al, r4, r13, 3028}, false, al, "al r4 r13 3028", "al_r4_r13_3028"},
     {{al, r1, r1, 4018}, false, al, "al r1 r1 4018", "al_r1_r1_4018"},
     {{al, r6, r0, 3109}, false, al, "al r6 r0 3109", "al_r6_r0_3109"},
     {{al, r11, r8, 3194}, false, al, "al r11 r8 3194", "al_r11_r8_3194"},
     {{al, r14, r0, 2866}, false, al, "al r14 r0 2866", "al_r14_r0_2866"},
     {{al, r5, r0, 1860}, false, al, "al r5 r0 1860", "al_r5_r0_1860"},
     {{al, r14, r13, 1266}, false, al, "al r14 r13 1266", "al_r14_r13_1266"},
     {{al, r0, r12, 2662}, false, al, "al r0 r12 2662", "al_r0_r12_2662"},
     {{al, r12, r6, 3856}, false, al, "al r12 r6 3856", "al_r12_r6_3856"},
     {{al, r14, r5, 251}, false, al, "al r14 r5 251", "al_r14_r5_251"},
     {{al, r12, r7, 2427}, false, al, "al r12 r7 2427", "al_r12_r7_2427"},
     {{al, r4, r9, 1934}, false, al, "al r4 r9 1934", "al_r4_r9_1934"},
     {{al, r7, r4, 1458}, false, al, "al r7 r4 1458", "al_r7_r4_1458"},
     {{al, r3, r13, 3633}, false, al, "al r3 r13 3633", "al_r3_r13_3633"},
     {{al, r5, r3, 72}, false, al, "al r5 r3 72", "al_r5_r3_72"},
     {{al, r2, r13, 783}, false, al, "al r2 r13 783", "al_r2_r13_783"},
     {{al, r6, r2, 704}, false, al, "al r6 r2 704", "al_r6_r2_704"},
     {{al, r4, r9, 22}, false, al, "al r4 r9 22", "al_r4_r9_22"},
     {{al, r6, r8, 2047}, false, al, "al r6 r8 2047", "al_r6_r8_2047"},
     {{al, r1, r0, 1407}, false, al, "al r1 r0 1407", "al_r1_r0_1407"},
     {{al, r14, r10, 4095}, false, al, "al r14 r10 4095", "al_r14_r10_4095"},
     {{al, r3, r11, 3313}, false, al, "al r3 r11 3313", "al_r3_r11_3313"},
     {{al, r13, r1, 3449}, false, al, "al r13 r1 3449", "al_r13_r1_3449"},
     {{al, r10, r11, 98}, false, al, "al r10 r11 98", "al_r10_r11_98"},
     {{al, r5, r3, 1967}, false, al, "al r5 r3 1967", "al_r5_r3_1967"},
     {{al, r13, r13, 2963}, false, al, "al r13 r13 2963", "al_r13_r13_2963"},
     {{al, r10, r14, 2507}, false, al, "al r10 r14 2507", "al_r10_r14_2507"},
     {{al, r0, r9, 542}, false, al, "al r0 r9 542", "al_r0_r9_542"},
     {{al, r3, r1, 672}, false, al, "al r3 r1 672", "al_r3_r1_672"},
     {{al, r2, r0, 669}, false, al, "al r2 r0 669", "al_r2_r0_669"},
     {{al, r8, r13, 3439}, false, al, "al r8 r13 3439", "al_r8_r13_3439"},
     {{al, r12, r5, 2901}, false, al, "al r12 r5 2901", "al_r12_r5_2901"},
     {{al, r11, r4, 3921}, false, al, "al r11 r4 3921", "al_r11_r4_3921"},
     {{al, r3, r4, 1804}, false, al, "al r3 r4 1804", "al_r3_r4_1804"},
     {{al, r6, r2, 2963}, false, al, "al r6 r2 2963", "al_r6_r2_2963"},
     {{al, r14, r14, 1872}, false, al, "al r14 r14 1872", "al_r14_r14_1872"},
     {{al, r0, r3, 1999}, false, al, "al r0 r3 1999", "al_r0_r3_1999"},
     {{al, r12, r12, 3870}, false, al, "al r12 r12 3870", "al_r12_r12_3870"},
     {{al, r8, r6, 3209}, false, al, "al r8 r6 3209", "al_r8_r6_3209"},
     {{al, r13, r10, 2247}, false, al, "al r13 r10 2247", "al_r13_r10_2247"},
     {{al, r2, r7, 55}, false, al, "al r2 r7 55", "al_r2_r7_55"},
     {{al, r14, r0, 198}, false, al, "al r14 r0 198", "al_r14_r0_198"},
     {{al, r14, r12, 2546}, false, al, "al r14 r12 2546", "al_r14_r12_2546"},
     {{al, r0, r12, 1459}, false, al, "al r0 r12 1459", "al_r0_r12_1459"},
     {{al, r13, r9, 2541}, false, al, "al r13 r9 2541", "al_r13_r9_2541"},
     {{al, r10, r11, 3450}, false, al, "al r10 r11 3450", "al_r10_r11_3450"},
     {{al, r3, r5, 2591}, false, al, "al r3 r5 2591", "al_r3_r5_2591"},
     {{al, r11, r13, 1687}, false, al, "al r11 r13 1687", "al_r11_r13_1687"},
     {{al, r8, r5, 1899}, false, al, "al r8 r5 1899", "al_r8_r5_1899"},
     {{al, r12, r4, 2046}, false, al, "al r12 r4 2046", "al_r12_r4_2046"},
     {{al, r14, r7, 3541}, false, al, "al r14 r7 3541", "al_r14_r7_3541"},
     {{al, r11, r1, 3685}, false, al, "al r11 r1 3685", "al_r11_r1_3685"},
     {{al, r3, r10, 3921}, false, al, "al r3 r10 3921", "al_r3_r10_3921"},
     {{al, r6, r5, 2208}, false, al, "al r6 r5 2208", "al_r6_r5_2208"},
     {{al, r5, r9, 1372}, false, al, "al r5 r9 1372", "al_r5_r9_1372"},
     {{al, r1, r3, 1542}, false, al, "al r1 r3 1542", "al_r1_r3_1542"},
     {{al, r6, r3, 263}, false, al, "al r6 r3 263", "al_r6_r3_263"},
     {{al, r13, r5, 3079}, false, al, "al r13 r5 3079", "al_r13_r5_3079"},
     {{al, r14, r11, 3282}, false, al, "al r14 r11 3282", "al_r14_r11_3282"},
     {{al, r8, r10, 1274}, false, al, "al r8 r10 1274", "al_r8_r10_1274"},
     {{al, r10, r13, 2617}, false, al, "al r10 r13 2617", "al_r10_r13_2617"},
     {{al, r4, r5, 2821}, false, al, "al r4 r5 2821", "al_r4_r5_2821"},
     {{al, r8, r0, 2359}, false, al, "al r8 r0 2359", "al_r8_r0_2359"},
     {{al, r1, r7, 2929}, false, al, "al r1 r7 2929", "al_r1_r7_2929"},
     {{al, r0, r14, 481}, false, al, "al r0 r14 481", "al_r0_r14_481"},
     {{al, r0, r13, 1135}, false, al, "al r0 r13 1135", "al_r0_r13_1135"},
     {{al, r13, r10, 270}, false, al, "al r13 r10 270", "al_r13_r10_270"},
     {{al, r3, r1, 958}, false, al, "al r3 r1 958", "al_r3_r1_958"},
     {{al, r7, r10, 2402}, false, al, "al r7 r10 2402", "al_r7_r10_2402"},
     {{al, r0, r1, 1428}, false, al, "al r0 r1 1428", "al_r0_r1_1428"},
     {{al, r14, r9, 2710}, false, al, "al r14 r9 2710", "al_r14_r9_2710"},
     {{al, r6, r4, 188}, false, al, "al r6 r4 188", "al_r6_r4_188"},
     {{al, r7, r1, 3774}, false, al, "al r7 r1 3774", "al_r7_r1_3774"},
     {{al, r13, r5, 386}, false, al, "al r13 r5 386", "al_r13_r5_386"},
     {{al, r9, r5, 1377}, false, al, "al r9 r5 1377", "al_r9_r5_1377"},
     {{al, r13, r14, 3079}, false, al, "al r13 r14 3079", "al_r13_r14_3079"},
     {{al, r11, r4, 2119}, false, al, "al r11 r4 2119", "al_r11_r4_2119"},
     {{al, r12, r0, 3566}, false, al, "al r12 r0 3566", "al_r12_r0_3566"},
     {{al, r11, r13, 670}, false, al, "al r11 r13 670", "al_r11_r13_670"},
     {{al, r14, r14, 1246}, false, al, "al r14 r14 1246", "al_r14_r14_1246"},
     {{al, r5, r3, 3136}, false, al, "al r5 r3 3136", "al_r5_r3_3136"},
     {{al, r9, r13, 421}, false, al, "al r9 r13 421", "al_r9_r13_421"},
     {{al, r8, r11, 1359}, false, al, "al r8 r11 1359", "al_r8_r11_1359"},
     {{al, r8, r12, 3989}, false, al, "al r8 r12 3989", "al_r8_r12_3989"},
     {{al, r4, r5, 4091}, false, al, "al r4 r5 4091", "al_r4_r5_4091"},
     {{al, r14, r1, 3867}, false, al, "al r14 r1 3867", "al_r14_r1_3867"},
     {{al, r11, r14, 2451}, false, al, "al r11 r14 2451", "al_r11_r14_2451"},
     {{al, r12, r4, 2069}, false, al, "al r12 r4 2069", "al_r12_r4_2069"},
     {{al, r7, r11, 2617}, false, al, "al r7 r11 2617", "al_r7_r11_2617"},
     {{al, r3, r13, 1377}, false, al, "al r3 r13 1377", "al_r3_r13_1377"},
     {{al, r7, r10, 1472}, false, al, "al r7 r10 1472", "al_r7_r10_1472"},
     {{al, r13, r1, 2813}, false, al, "al r13 r1 2813", "al_r13_r1_2813"},
     {{al, r14, r11, 192}, false, al, "al r14 r11 192", "al_r14_r11_192"},
     {{al, r9, r0, 1407}, false, al, "al r9 r0 1407", "al_r9_r0_1407"},
     {{al, r0, r8, 3685}, false, al, "al r0 r8 3685", "al_r0_r8_3685"},
     {{al, r5, r14, 1505}, false, al, "al r5 r14 1505", "al_r5_r14_1505"},
     {{al, r11, r2, 672}, false, al, "al r11 r2 672", "al_r11_r2_672"},
     {{al, r2, r11, 1740}, false, al, "al r2 r11 1740", "al_r2_r11_1740"},
     {{al, r6, r8, 1323}, false, al, "al r6 r8 1323", "al_r6_r8_1323"},
     {{al, r6, r2, 837}, false, al, "al r6 r2 837", "al_r6_r2_837"},
     {{al, r7, r10, 1934}, false, al, "al r7 r10 1934", "al_r7_r10_1934"},
     {{al, r4, r13, 618}, false, al, "al r4 r13 618", "al_r4_r13_618"},
     {{al, r8, r8, 3063}, false, al, "al r8 r8 3063", "al_r8_r8_3063"},
     {{al, r10, r0, 988}, false, al, "al r10 r0 988", "al_r10_r0_988"},
     {{al, r2, r8, 2044}, false, al, "al r2 r8 2044", "al_r2_r8_2044"},
     {{al, r5, r7, 850}, false, al, "al r5 r7 850", "al_r5_r7_850"},
     {{al, r6, r6, 3015}, false, al, "al r6 r6 3015", "al_r6_r6_3015"},
     {{al, r0, r2, 2768}, false, al, "al r0 r2 2768", "al_r0_r2_2768"},
     {{al, r6, r8, 1498}, false, al, "al r6 r8 1498", "al_r6_r8_1498"},
     {{al, r9, r4, 1097}, false, al, "al r9 r4 1097", "al_r9_r4_1097"},
     {{al, r2, r5, 525}, false, al, "al r2 r5 525", "al_r2_r5_525"},
     {{al, r6, r3, 470}, false, al, "al r6 r3 470", "al_r6_r3_470"},
     {{al, r2, r9, 1655}, false, al, "al r2 r9 1655", "al_r2_r9_1655"},
     {{al, r0, r5, 2026}, false, al, "al r0 r5 2026", "al_r0_r5_2026"},
     {{al, r7, r8, 348}, false, al, "al r7 r8 348", "al_r7_r8_348"},
     {{al, r12, r5, 342}, false, al, "al r12 r5 342", "al_r12_r5_342"},
     {{al, r1, r8, 1860}, false, al, "al r1 r8 1860", "al_r1_r8_1860"},
     {{al, r0, r6, 2314}, false, al, "al r0 r6 2314", "al_r0_r6_2314"},
     {{al, r3, r13, 2726}, false, al, "al r3 r13 2726", "al_r3_r13_2726"},
     {{al, r4, r8, 2098}, false, al, "al r4 r8 2098", "al_r4_r8_2098"},
     {{al, r1, r10, 3239}, false, al, "al r1 r10 3239", "al_r1_r10_3239"},
     {{al, r8, r10, 3585}, false, al, "al r8 r10 3585", "al_r8_r10_3585"},
     {{al, r3, r5, 1642}, false, al, "al r3 r5 1642", "al_r3_r5_1642"},
     {{al, r9, r11, 138}, false, al, "al r9 r11 138", "al_r9_r11_138"},
     {{al, r0, r8, 4076}, false, al, "al r0 r8 4076", "al_r0_r8_4076"},
     {{al, r0, r12, 3994}, false, al, "al r0 r12 3994", "al_r0_r12_3994"},
     {{al, r11, r3, 3041}, false, al, "al r11 r3 3041", "al_r11_r3_3041"},
     {{al, r8, r1, 1732}, false, al, "al r8 r1 1732", "al_r8_r1_1732"},
     {{al, r10, r9, 2091}, false, al, "al r10 r9 2091", "al_r10_r9_2091"},
     {{al, r2, r2, 3072}, false, al, "al r2 r2 3072", "al_r2_r2_3072"},
     {{al, r10, r12, 3391}, false, al, "al r10 r12 3391", "al_r10_r12_3391"},
     {{al, r8, r6, 774}, false, al, "al r8 r6 774", "al_r8_r6_774"},
     {{al, r8, r13, 136}, false, al, "al r8 r13 136", "al_r8_r13_136"},
     {{al, r4, r7, 1712}, false, al, "al r4 r7 1712", "al_r4_r7_1712"},
     {{al, r4, r14, 3254}, false, al, "al r4 r14 3254", "al_r4_r14_3254"},
     {{al, r7, r7, 496}, false, al, "al r7 r7 496", "al_r7_r7_496"},
     {{al, r0, r14, 1458}, false, al, "al r0 r14 1458", "al_r0_r14_1458"},
     {{al, r10, r13, 669}, false, al, "al r10 r13 669", "al_r10_r13_669"},
     {{al, r9, r7, 2374}, false, al, "al r9 r7 2374", "al_r9_r7_2374"},
     {{al, r12, r5, 2628}, false, al, "al r12 r5 2628", "al_r12_r5_2628"},
     {{al, r5, r8, 188}, false, al, "al r5 r8 188", "al_r5_r8_188"},
     {{al, r11, r4, 0}, false, al, "al r11 r4 0", "al_r11_r4_0"},
     {{al, r13, r1, 3504}, false, al, "al r13 r1 3504", "al_r13_r1_3504"},
     {{al, r8, r6, 2617}, false, al, "al r8 r6 2617", "al_r8_r6_2617"},
     {{al, r6, r6, 3652}, false, al, "al r6 r6 3652", "al_r6_r6_3652"},
     {{al, r8, r14, 1526}, false, al, "al r8 r14 1526", "al_r8_r14_1526"},
     {{al, r6, r0, 2662}, false, al, "al r6 r0 2662", "al_r6_r0_2662"},
     {{al, r12, r9, 3015}, false, al, "al r12 r9 3015", "al_r12_r9_3015"},
     {{al, r1, r2, 2718}, false, al, "al r1 r2 2718", "al_r1_r2_2718"},
     {{al, r10, r0, 4056}, false, al, "al r10 r0 4056", "al_r10_r0_4056"},
     {{al, r14, r11, 3522}, false, al, "al r14 r11 3522", "al_r14_r11_3522"},
     {{al, r10, r9, 3774}, false, al, "al r10 r9 3774", "al_r10_r9_3774"},
     {{al, r2, r3, 263}, false, al, "al r2 r3 263", "al_r2_r3_263"},
     {{al, r9, r11, 1459}, false, al, "al r9 r11 1459", "al_r9_r11_1459"},
     {{al, r0, r9, 3449}, false, al, "al r0 r9 3449", "al_r0_r9_3449"},
     {{al, r14, r12, 3702}, false, al, "al r14 r12 3702", "al_r14_r12_3702"},
     {{al, r2, r14, 2695}, false, al, "al r2 r14 2695", "al_r2_r14_2695"},
     {{al, r13, r1, 470}, false, al, "al r13 r1 470", "al_r13_r1_470"},
     {{al, r11, r1, 977}, false, al, "al r11 r1 977", "al_r11_r1_977"},
     {{al, r12, r4, 2799}, false, al, "al r12 r4 2799", "al_r12_r4_2799"},
     {{al, r14, r2, 2794}, false, al, "al r14 r2 2794", "al_r14_r2_2794"},
     {{al, r14, r5, 794}, false, al, "al r14 r5 794", "al_r14_r5_794"},
     {{al, r4, r6, 831}, false, al, "al r4 r6 831", "al_r4_r6_831"},
     {{al, r6, r10, 3517}, false, al, "al r6 r10 3517", "al_r6_r10_3517"},
     {{al, r1, r10, 1556}, false, al, "al r1 r10 1556", "al_r1_r10_1556"},
     {{al, r9, r9, 2374}, false, al, "al r9 r9 2374", "al_r9_r9_2374"},
     {{al, r13, r6, 1261}, false, al, "al r13 r6 1261", "al_r13_r6_1261"},
     {{al, r6, r10, 2976}, false, al, "al r6 r10 2976", "al_r6_r10_2976"},
     {{al, r0, r7, 1536}, false, al, "al r0 r7 1536", "al_r0_r7_1536"},
     {{al, r6, r6, 1043}, false, al, "al r6 r6 1043", "al_r6_r6_1043"},
     {{al, r13, r1, 3344}, false, al, "al r13 r1 3344", "al_r13_r1_3344"},
     {{al, r11, r9, 4090}, false, al, "al r11 r9 4090", "al_r11_r9_4090"},
     {{al, r6, r14, 2247}, false, al, "al r6 r14 2247", "al_r6_r14_2247"},
     {{al, r14, r2, 3918}, false, al, "al r14 r2 3918", "al_r14_r2_3918"},
     {{al, r0, r14, 3487}, false, al, "al r0 r14 3487", "al_r0_r14_3487"},
     {{al, r5, r8, 796}, false, al, "al r5 r8 796", "al_r5_r8_796"},
     {{al, r2, r5, 2662}, false, al, "al r2 r5 2662", "al_r2_r5_2662"},
     {{al, r8, r2, 1967}, false, al, "al r8 r2 1967", "al_r8_r2_1967"},
     {{al, r9, r1, 3344}, false, al, "al r9 r1 3344", "al_r9_r1_3344"},
     {{al, r6, r3, 2945}, false, al, "al r6 r3 2945", "al_r6_r3_2945"},
     {{al, r3, r5, 2453}, false, al, "al r3 r5 2453", "al_r3_r5_2453"},
     {{al, r6, r14, 3975}, false, al, "al r6 r14 3975", "al_r6_r14_3975"},
     {{al, r2, r8, 2976}, false, al, "al r2 r8 2976", "al_r2_r8_2976"},
     {{al, r7, r5, 1097}, false, al, "al r7 r5 1097", "al_r7_r5_1097"},
     {{al, r14, r14, 3564}, false, al, "al r14 r14 3564", "al_r14_r14_3564"},
     {{al, r0, r8, 2183}, false, al, "al r0 r8 2183", "al_r0_r8_2183"},
     {{al, r11, r11, 612}, false, al, "al r11 r11 612", "al_r11_r11_612"},
     {{al, r0, r8, 48}, false, al, "al r0 r8 48", "al_r0_r8_48"},
     {{al, r1, r1, 1168}, false, al, "al r1 r1 1168", "al_r1_r1_1168"},
     {{al, r11, r4, 1526}, false, al, "al r11 r4 1526", "al_r11_r4_1526"},
     {{al, r13, r6, 3157}, false, al, "al r13 r6 3157", "al_r13_r6_3157"},
     {{al, r1, r9, 3195}, false, al, "al r1 r9 3195", "al_r1_r9_3195"},
     {{al, r10, r11, 850}, false, al, "al r10 r11 850", "al_r10_r11_850"},
     {{al, r9, r9, 1374}, false, al, "al r9 r9 1374", "al_r9_r9_1374"},
     {{al, r4, r0, 2651}, false, al, "al r4 r0 2651", "al_r4_r0_2651"},
     {{al, r6, r14, 490}, false, al, "al r6 r14 490", "al_r6_r14_490"},
     {{al, r1, r2, 3702}, false, al, "al r1 r2 3702", "al_r1_r2_3702"},
     {{al, r2, r1, 2098}, false, al, "al r2 r1 2098", "al_r2_r1_2098"},
     {{al, r4, r3, 3256}, false, al, "al r4 r3 3256", "al_r4_r3_3256"},
     {{al, r0, r10, 132}, false, al, "al r0 r10 132", "al_r0_r10_132"},
     {{al, r3, r6, 2703}, false, al, "al r3 r6 2703", "al_r3_r6_2703"},
     {{al, r3, r10, 844}, false, al, "al r3 r10 844", "al_r3_r10_844"},
     {{al, r10, r9, 513}, false, al, "al r10 r9 513", "al_r10_r9_513"},
     {{al, r6, r7, 3308}, false, al, "al r6 r7 3308", "al_r6_r7_3308"},
     {{al, r12, r10, 3978}, false, al, "al r12 r10 3978", "al_r12_r10_3978"},
     {{al, r10, r3, 1407}, false, al, "al r10 r3 1407", "al_r10_r3_1407"},
     {{al, r5, r1, 2358}, false, al, "al r5 r1 2358", "al_r5_r1_2358"},
     {{al, r13, r13, 322}, false, al, "al r13 r13 322", "al_r13_r13_322"},
     {{al, r7, r10, 2403}, false, al, "al r7 r10 2403", "al_r7_r10_2403"},
     {{al, r14, r4, 198}, false, al, "al r14 r4 198", "al_r14_r4_198"},
     {{al, r3, r2, 3774}, false, al, "al r3 r2 3774", "al_r3_r2_3774"},
     {{al, r4, r5, 1899}, false, al, "al r4 r5 1899", "al_r4_r5_1899"},
     {{al, r14, r14, 2183}, false, al, "al r14 r14 2183", "al_r14_r14_2183"},
     {{al, r3, r9, 3636}, false, al, "al r3 r9 3636", "al_r3_r9_3636"},
     {{al, r6, r13, 774}, false, al, "al r6 r13 774", "al_r6_r13_774"},
     {{al, r3, r7, 791}, false, al, "al r3 r7 791", "al_r3_r7_791"},
     {{al, r1, r13, 2202}, false, al, "al r1 r13 2202", "al_r1_r13_2202"},
     {{al, r0, r0, 580}, false, al, "al r0 r0 580", "al_r0_r0_580"},
     {{al, r4, r0, 1848}, false, al, "al r4 r0 1848", "al_r4_r0_1848"},
     {{al, r4, r6, 2464}, false, al, "al r4 r6 2464", "al_r4_r6_2464"},
     {{al, r9, r0, 997}, false, al, "al r9 r0 997", "al_r9_r0_997"},
     {{al, r0, r4, 2866}, false, al, "al r0 r4 2866", "al_r0_r4_2866"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rd-rn-operand-imm12-add-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-imm12-addw-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-imm12-sub-t32.h"
#include "aarch32/traces/assembler-cond-rd-rn-operand-imm12-subw-t32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   Register rn,
                                   const Operand& op);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseT32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    int32_t immediate = kTests[i].operands.immediate;
    Operand op(immediate);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, rn, op);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                         \
  void Test_##mnemonic() {                                                     \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic);    \
  }                                                                            \
  Test test_##mnemonic("AARCH32_ASSEMBLER_COND_RD_RN_OPERAND_IMM12_" #mnemonic \
                       "_T32",                                                 \
                       &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
