import { Spec } from 'vega';

export const spec: Spec = {
  $schema: 'https://vega.github.io/schema/vega/v5.json',
  width: 0,
  height: 0,
  padding: 5,
  autosize: { type: 'pad', resize: true },

  config: {
    legend: {
      offset: 10,
      strokeColor: '#ccc',
      cornerRadius: 4,
      symbolOffset: 2,
      symbolStrokeWidth: 2,
      symbolStrokeColor: '#000',
      clipHeight: 12,
      rowPadding: 2,
      titleOrient: { signal: 'titleOrient' },
      titleAnchor: { signal: 'titleAnchor' }
    }
  },

  signals: [
    {
      name: 'colPadding',
      value: 0,
      bind: { input: 'range', min: 0, max: 20, step: 1 }
    },
    {
      name: 'rowPadding',
      value: 0,
      bind: { input: 'range', min: 0, max: 20, step: 1 }
    },
    {
      name: 'legendPadding',
      value: 5,
      bind: { input: 'range', min: 0, max: 20, step: 1 }
    },
    {
      name: 'titleOrient',
      value: 'top',
      bind: { input: 'select', options: ['top', 'left', 'bottom', 'right'] }
    },
    {
      name: 'titleAnchor',
      value: null,
      bind: { input: 'select', options: ['start', 'middle', 'end', null] }
    }
  ],

  scales: [
    {
      name: 'size',
      type: 'linear',
      range: [400, 2500],
      domain: [-100, 100],
      nice: false,
      zero: false
    },
    {
      name: 'fill',
      type: 'linear',
      range: ['#bef', '#28f'],
      domain: [-100, 100],
      nice: false,
      zero: false
    }
  ],

  legends: [
    {
      title: 'Vertical',
      type: 'symbol',
      size: 'size',
      fill: 'fill',
      orient: 'left',
      direction: 'vertical',
      offset: 0,
      clipHeight: 0,
      padding: { signal: 'legendPadding' },
      encode: {
        entries: {
          interactive: true,
          update: { fill: { value: 'transparent' } },
          hover: { fill: { value: '#fcc' } }
        },
        symbols: {
          interactive: true,
          update: { size: { scale: 'size', field: 'value' } },
          hover: { size: { value: 10000 } }
        }
      }
    },
    {
      title: 'Clipped',
      type: 'symbol',
      size: 'size',
      fill: 'fill',
      orient: 'left',
      direction: 'vertical',
      offset: 0,
      padding: { signal: 'legendPadding' },
      encode: {
        entries: {
          interactive: true,
          update: { fill: { value: 'transparent' } },
          hover: { fill: { value: '#fcc' } }
        }
      }
    },
    {
      title: 'Clipped - Columns',
      type: 'symbol',
      size: 'size',
      fill: 'fill',
      orient: 'right',
      direction: 'vertical',
      columns: 2,
      columnPadding: { signal: 'colPadding' },
      rowPadding: { signal: 'rowPadding' },
      padding: { signal: 'legendPadding' },
      encode: {
        entries: {
          interactive: true,
          update: { fill: { value: 'transparent' } },
          hover: { fill: { value: '#fcc' } }
        },
        symbols: {
          interactive: true,
          update: { size: { scale: 'size', field: 'value' } },
          hover: { size: { value: 10000 } }
        },
        title: {
          interactive: true,
          update: { fontSize: { value: 11 } },
          hover: { fontSize: { value: 20 } }
        }
      }
    },
    {
      title: 'Clipped - Columns + Padding',
      type: 'symbol',
      size: 'size',
      fill: 'fill',
      orient: 'right',
      direction: 'vertical',
      columns: 2,
      columnPadding: 15,
      rowPadding: 2,
      padding: { signal: 'legendPadding' },
      encode: {
        entries: {
          interactive: true,
          update: { fill: { value: 'transparent' } },
          hover: { fill: { value: '#fcc' } }
        }
      }
    },
    {
      title: 'Horizontal',
      type: 'symbol',
      size: 'size',
      fill: 'fill',
      orient: 'right',
      direction: 'horizontal',
      clipHeight: 0,
      padding: { signal: 'legendPadding' },
      encode: {
        entries: {
          interactive: true,
          update: { fill: { value: 'transparent' } },
          hover: { fill: { value: '#fcc' } }
        }
      }
    },
    {
      title: 'Horizontal - Clipped',
      type: 'symbol',
      size: 'size',
      fill: 'fill',
      orient: 'right',
      direction: 'horizontal',
      padding: { signal: 'legendPadding' },
      encode: {
        entries: {
          interactive: true,
          update: { fill: { value: 'transparent' } },
          hover: { fill: { value: '#fcc' } }
        }
      }
    },
    {
      title: 'Horizontal - Columns',
      type: 'symbol',
      size: 'size',
      fill: 'fill',
      orient: 'right',
      direction: 'horizontal',
      columns: 3,
      rowPadding: 6,
      padding: { signal: 'legendPadding' },
      encode: {
        entries: {
          interactive: true,
          update: { fill: { value: 'transparent' } },
          hover: { fill: { value: '#fcc' } }
        }
      }
    }
  ]
};
