/*
 * Copyright (c) 2001, Swedish Institute of Computer Science.
 * Copyright (c) 2011, Renzo Davoli
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Author: Adam Dunkels <adam@sics.se>
 * VDE Author: Renzo Davoli <renzo@cs.unibo.it>
 *
 */

#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/socket.h>

#include <libvdeplug.h>
#include "contiki-net.h"
#include "vdedev.h"

#define DROP 0

#if DROP
static int drop = 0;
#endif

static struct vdeconn *conn;

#define BUF ((struct uip_eth_hdr *)&uip_buf[0])

/*---------------------------------------------------------------------------*/
static void
remove_route(void)
{
  char buf[1024];
  snprintf(buf, sizeof(buf), "route delete -net 172.16.0.0");
  system(buf);
  printf("%s\n", buf);

}
/*---------------------------------------------------------------------------*/
void
vdedev_init(void)
{
	conn = vde_open(NULL,"contiki",NULL);
}
/*---------------------------------------------------------------------------*/
u16_t
vdedev_poll(void)
{
  fd_set fdset;
  struct timeval tv;
  int ret;
	int fd;
  
	if (conn == NULL)
		return -1;
	fd = vde_datafd(conn);

  tv.tv_sec = 0;
  tv.tv_usec = 0;
  
  FD_ZERO(&fdset);
	FD_SET(fd, &fdset);

  ret = select(fd + 1, &fdset, NULL, NULL, &tv);

  if(ret == 0) {
    return 0;
  }
  ret = vde_recv(conn, uip_buf, UIP_BUFSIZE, 0);

  if(ret == -1) {
    perror("vdedev_poll: read");
  }
  return ret;
}
/*---------------------------------------------------------------------------*/
void
vdedev_send(void)
{
  int ret;

  if(conn == NULL) {
    return;
  }
 
  /*  printf("vdedev_send: sending %d bytes\n", size);*/
  /*  check_checksum(uip_buf, size);*/

#if DROP
  drop++;
  if(drop % 8 == 7) {
    printf("Dropped an output packet!\n");
    return;
  }
#endif /* DROP */

  ret = vde_send(conn, uip_buf, uip_len, 0);

  if(ret == -1) {
    perror("vde_dev: vdedev_send: writev");
    exit(1);
  }
}
/*---------------------------------------------------------------------------*/
void
vdedev_exit(void)
{
}
/*---------------------------------------------------------------------------*/
