/***************************************************************************
         dcfilebrowseritems.h  -  Items used by DCFileBrowser
                             -------------------
    begin                : Thu Jul 3 2008
    copyright            : (C) 2002-2004 by Mathias Küster
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCFILEBROWSERITEMS_H
#define DCFILEBROWSERITEMS_H

/**
 * @author Mathias Küster, Edward Sheldrake
 *
 * These are just some things used by DCFileBrowser until it gets
 * ported to QT4 properly. They have been moved out of dcfilebrowser.h
 * because other classes do not need to know about them.
 */

#include <QString>
#include <Q3ListView>
#include <QList>

// ulonglong
#include <dclib/dcos.h>

#include "dcwidget.h"

class DCFileItem {
public:
	/** construtor */
	DCFileItem() {};
	/** destructor */
	~DCFileItem() {};

	/** */
	QString m_sName;
	/** */
	ulonglong m_nSize;
	/** */
	QString m_sHash;
	/** */
	bool m_bIsDir;
};

/**
 * All the items in the Q3ListView must be DCFileBrowserListItem
 * because compare() does not check the type and just casts
 * the pointer. This is how the class is used in valknut.
 */
class DCFileBrowserListItem : public Q3ListViewItem {
public:
	/** construtor */
	DCFileBrowserListItem( Q3ListView * parent ) : Q3ListViewItem(parent) {
		m_pFileItem = 0;
	};
	/** construtor */
	DCFileBrowserListItem( Q3ListViewItem * parent ) : Q3ListViewItem(parent) {
		m_pFileItem = 0;
	};

	/** destructor */
	virtual ~DCFileBrowserListItem() {};

	/** the faster way to make numeric sort work */
	virtual int compare( Q3ListViewItem * other, int col, bool ascending ) const;

	/** the slower way to make numeric sort work */	
	virtual QString key( int column, bool ascending ) const;

	/** */
	QList<DCFileItem*> m_pFileList;
	/** */
	QString m_sName;
	/** Size in bytes of directory contents */
	ulonglong m_nBytes;
	/** Pointer to the DCFileItem that represents this folder */
	DCFileItem * m_pFileItem;
};

/**
 * This is because ListView_DIRECTORY->currentItem() is not reliable.
 * And for sort top. All the items in the Q3ListView must be instances of
 * DC_FBListViewItem because compare() does not check the type, it just
 * casts the pointer. This is how the class is used in valknut.
 */
class DC_FBListViewItem : public DC_QListViewItem {
public:
	/** Constructor with view parent */
	DC_FBListViewItem( Q3ListView * parent ) : DC_QListViewItem( parent ) { pDirItem = 0; };
	/** Constructor with item parent */
	DC_FBListViewItem( Q3ListViewItem * parent ) : DC_QListViewItem ( parent ) { pDirItem = 0; };
	
	/** Destructor */
	virtual ~DC_FBListViewItem() {};
	
	/** re-implemented to use sort top */
	virtual int compare( Q3ListViewItem * i, int col, bool ascending ) const;
	
	/**
	 * If true, this item will be above all items for which m_bSortTop
	 * is false.
	 */
	bool m_bSortTop;
	
	/** The left pane item for this right pane item */
	DCFileBrowserListItem * pDirItem;
};

#endif // DCFILEBROWSERITEMS_H
