/* valagirparser.c generated by valac, the Vala compiler
 * generated from valagirparser.vala, do not modify */

/* valagirparser.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 * Copyright (C) 2011-2014  Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Luca Bruno <lucabru@src.gnome.org>
 */

#include "vala.h"
#include <glib-object.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>
#include <errno.h>

#define VALA_GIR_PARSER_GIR_VERSION "1.2"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define VALA_GIR_PARSER_TYPE_NODE (vala_gir_parser_node_get_type ())
#define VALA_GIR_PARSER_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNode))
#define VALA_GIR_PARSER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNodeClass))
#define VALA_GIR_PARSER_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_NODE))
#define VALA_GIR_PARSER_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_NODE))
#define VALA_GIR_PARSER_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNodeClass))

typedef struct _ValaGirParserNode ValaGirParserNode;
typedef struct _ValaGirParserNodeClass ValaGirParserNodeClass;

#define VALA_GIR_PARSER_TYPE_METADATA (vala_gir_parser_metadata_get_type ())
#define VALA_GIR_PARSER_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadata))
#define VALA_GIR_PARSER_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadataClass))
#define VALA_GIR_PARSER_IS_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA))
#define VALA_GIR_PARSER_IS_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA))
#define VALA_GIR_PARSER_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadataClass))

typedef struct _ValaGirParserMetadata ValaGirParserMetadata;
typedef struct _ValaGirParserMetadataClass ValaGirParserMetadataClass;
typedef enum  {
	VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP,
	VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NEW,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_OUT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_REF,
	VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_COMPACT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SEALED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS,
	VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_GET_FUNCTION,
	VALA_GIR_PARSER_ARGUMENT_TYPE_COPY_FUNCTION,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FREE_FUNCTION,
	VALA_GIR_PARSER_ARGUMENT_TYPE_REF_FUNCTION,
	VALA_GIR_PARSER_ARGUMENT_TYPE_REF_SINK_FUNCTION,
	VALA_GIR_PARSER_ARGUMENT_TYPE_UNREF_FUNCTION,
	VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID,
	VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY_NOTIFY_CNAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NO_WRAPPER,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE
} ValaGirParserArgumentType;

#define VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE (vala_gir_parser_argument_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _vala_markup_reader_unref0(var) ((var == NULL) ? NULL : (var = (vala_markup_reader_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_gir_parser_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_gir_parser_metadata_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_metadata_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
typedef struct _ValaGirParserNodePrivate ValaGirParserNodePrivate;

#define VALA_GIR_PARSER_TYPE_PARAMETER_INFO (vala_gir_parser_parameter_info_get_type ())
#define VALA_GIR_PARSER_PARAMETER_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfo))
#define VALA_GIR_PARSER_PARAMETER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfoClass))
#define VALA_GIR_PARSER_IS_PARAMETER_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO))
#define VALA_GIR_PARSER_IS_PARAMETER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_PARAMETER_INFO))
#define VALA_GIR_PARSER_PARAMETER_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfoClass))

typedef struct _ValaGirParserParameterInfo ValaGirParserParameterInfo;
typedef struct _ValaGirParserParameterInfoClass ValaGirParserParameterInfoClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _ValaGirParserParameterInfoPrivate ValaGirParserParameterInfoPrivate;

#define VALA_GIR_PARSER_TYPE_METADATA_PARSER (vala_gir_parser_metadata_parser_get_type ())
#define VALA_GIR_PARSER_METADATA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParser))
#define VALA_GIR_PARSER_METADATA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParserClass))
#define VALA_GIR_PARSER_IS_METADATA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER))
#define VALA_GIR_PARSER_IS_METADATA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA_PARSER))
#define VALA_GIR_PARSER_METADATA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParserClass))

typedef struct _ValaGirParserMetadataParser ValaGirParserMetadataParser;
typedef struct _ValaGirParserMetadataParserClass ValaGirParserMetadataParserClass;
#define _vala_gir_parser_metadata_parser_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_metadata_parser_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_gir_parser_parameter_info_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_parameter_info_unref (var), NULL)))
typedef struct _ValaGirParserMetadataPrivate ValaGirParserMetadataPrivate;

#define VALA_GIR_PARSER_TYPE_ARGUMENT (vala_gir_parser_argument_get_type ())
#define VALA_GIR_PARSER_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgument))
#define VALA_GIR_PARSER_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgumentClass))
#define VALA_GIR_PARSER_IS_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT))
#define VALA_GIR_PARSER_IS_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_ARGUMENT))
#define VALA_GIR_PARSER_ARGUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgumentClass))

typedef struct _ValaGirParserArgument ValaGirParserArgument;
typedef struct _ValaGirParserArgumentClass ValaGirParserArgumentClass;
typedef struct _ValaGirParserArgumentPrivate ValaGirParserArgumentPrivate;
#define _vala_gir_parser_argument_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_argument_unref (var), NULL)))
#define _vala_map_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_iterator_unref (var), NULL)))
typedef struct _ValaGirParserParamSpecArgument ValaGirParserParamSpecArgument;

#define VALA_GIR_PARSER_TYPE_METADATA_SET (vala_gir_parser_metadata_set_get_type ())
#define VALA_GIR_PARSER_METADATA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSet))
#define VALA_GIR_PARSER_METADATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSetClass))
#define VALA_GIR_PARSER_IS_METADATA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET))
#define VALA_GIR_PARSER_IS_METADATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA_SET))
#define VALA_GIR_PARSER_METADATA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSetClass))

typedef struct _ValaGirParserMetadataSet ValaGirParserMetadataSet;
typedef struct _ValaGirParserMetadataSetClass ValaGirParserMetadataSetClass;
typedef struct _ValaGirParserMetadataSetPrivate ValaGirParserMetadataSetPrivate;
#define _g_pattern_spec_free0(var) ((var == NULL) ? NULL : (var = (g_pattern_spec_free (var), NULL)))
typedef struct _ValaGirParserParamSpecMetadata ValaGirParserParamSpecMetadata;
typedef struct _ValaGirParserMetadataParserPrivate ValaGirParserMetadataParserPrivate;
#define _vala_scanner_unref0(var) ((var == NULL) ? NULL : (var = (vala_scanner_unref (var), NULL)))
typedef struct _ValaGirParserParamSpecMetadataParser ValaGirParserParamSpecMetadataParser;
typedef struct _ValaGirParserParamSpecNode ValaGirParserParamSpecNode;
typedef struct _ValaGirParserParamSpecParameterInfo ValaGirParserParamSpecParameterInfo;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGirParserPrivate {
	ValaMarkupReader* reader;
	ValaCodeContext* context;
	ValaSourceFile* current_source_file;
	ValaGirParserNode* root;
	ValaArrayList* metadata_roots;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaMarkupTokenType current_token;
	gchar** cheader_filenames;
	gint cheader_filenames_length1;
	gint _cheader_filenames_size_;
	ValaArrayList* metadata_stack;
	ValaGirParserMetadata* metadata;
	ValaArrayList* tree_stack;
	ValaGirParserNode* current;
	ValaGirParserNode* old_current;
	ValaSet* provided_namespaces;
	ValaHashMap* unresolved_symbols_map;
	ValaArrayList* unresolved_gir_symbols;
	ValaHashMap* unresolved_type_arguments;
	ValaArrayList* ifaces_needing_object_prereq;
};

struct _ValaGirParserNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserNode* parent;
	gchar* element_type;
	gchar* name;
	ValaMap* girdata;
	ValaGirParserMetadata* metadata;
	ValaSourceReference* source_reference;
	ValaArrayList* members;
	ValaHashMap* scope;
	ValaGirComment* comment;
	ValaSymbol* symbol;
	gboolean new_symbol;
	gboolean merged;
	gboolean processed;
	gint return_array_length_idx;
	ValaList* parameters;
	ValaArrayList* array_length_parameters;
	ValaArrayList* closure_parameters;
	ValaArrayList* destroy_parameters;
	ValaUnresolvedSymbol* gtype_struct_for;
	ValaUnresolvedSymbol* type_struct;
	ValaDataType* base_type;
	gint array_length_idx;
	gboolean deprecated;
	guint64 deprecated_version;
	gchar* deprecated_since;
	gchar* deprecated_replacement;
	ValaGirParserNodePrivate * priv;
};

struct _ValaGirParserNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserNode *self);
};

struct _ValaGirParserParameterInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaParameter* param;
	gfloat vala_idx;
	gint array_length_idx;
	gint closure_idx;
	gint destroy_idx;
	gboolean keep;
	gboolean is_async;
	gboolean is_async_result;
	gboolean is_error;
	gboolean caller_allocates;
	ValaGirParserParameterInfoPrivate * priv;
};

struct _ValaGirParserParameterInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserParameterInfo *self);
};

struct _ValaGirParserMetadata {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GPatternSpec* pattern_spec;
	gchar* selector;
	ValaSourceReference* source_reference;
	gboolean used;
	ValaMap* args;
	ValaArrayList* children;
	ValaGirParserMetadataPrivate * priv;
};

struct _ValaGirParserMetadataClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserMetadata *self);
};

struct _ValaGirParserArgument {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaExpression* expression;
	ValaSourceReference* source_reference;
	gboolean used;
	ValaGirParserArgumentPrivate * priv;
};

struct _ValaGirParserArgumentClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserArgument *self);
};

struct _ValaGirParserParamSpecArgument {
	GParamSpec parent_instance;
};

struct _ValaGirParserMetadataSet {
	ValaGirParserMetadata parent_instance;
	ValaGirParserMetadataSetPrivate * priv;
};

struct _ValaGirParserMetadataSetClass {
	ValaGirParserMetadataClass parent_class;
};

struct _ValaGirParserParamSpecMetadata {
	GParamSpec parent_instance;
};

struct _ValaGirParserMetadataParser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserMetadataParserPrivate * priv;
};

struct _ValaGirParserMetadataParserClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserMetadataParser *self);
};

struct _ValaGirParserMetadataParserPrivate {
	ValaGirParserMetadata* tree;
	ValaScanner* scanner;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaSourceLocation old_end;
	ValaTokenType current;
	ValaGirParserMetadata* parent_metadata;
};

struct _ValaGirParserParamSpecMetadataParser {
	GParamSpec parent_instance;
};

struct _ValaGirParserParamSpecNode {
	GParamSpec parent_instance;
};

struct _ValaGirParserParamSpecParameterInfo {
	GParamSpec parent_instance;
};

static gint ValaGirParser_private_offset;
static gpointer vala_gir_parser_parent_class = NULL;
static GRegex* vala_gir_parser_type_from_string_regex;
static GRegex* vala_gir_parser_type_from_string_regex = NULL;
static ValaArrayList* vala_gir_parser_node_new_namespaces;
static gpointer vala_gir_parser_argument_parent_class = NULL;
static gpointer vala_gir_parser_metadata_set_parent_class = NULL;
static gpointer vala_gir_parser_metadata_parent_class = NULL;
static ValaGirParserMetadata* vala_gir_parser_metadata__empty;
static ValaGirParserMetadata* vala_gir_parser_metadata__empty = NULL;
static gint ValaGirParserMetadataParser_private_offset;
static gpointer vala_gir_parser_metadata_parser_parent_class = NULL;
static gpointer vala_gir_parser_node_parent_class = NULL;
static ValaArrayList* vala_gir_parser_node_new_namespaces = NULL;
static gpointer vala_gir_parser_parameter_info_parent_class = NULL;

static gpointer vala_gir_parser_node_ref (gpointer instance);
static void vala_gir_parser_node_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_node (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags) G_GNUC_UNUSED ;
static void vala_gir_parser_value_set_node (GValue* value,
                                     gpointer v_object) G_GNUC_UNUSED ;
static void vala_gir_parser_value_take_node (GValue* value,
                                      gpointer v_object) G_GNUC_UNUSED ;
static gpointer vala_gir_parser_value_get_node (const GValue* value) G_GNUC_UNUSED ;
static GType vala_gir_parser_node_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gpointer vala_gir_parser_metadata_ref (gpointer instance);
static void vala_gir_parser_metadata_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_metadata (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags) G_GNUC_UNUSED ;
static void vala_gir_parser_value_set_metadata (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED ;
static void vala_gir_parser_value_take_metadata (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED ;
static gpointer vala_gir_parser_value_get_metadata (const GValue* value) G_GNUC_UNUSED ;
static GType vala_gir_parser_metadata_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType vala_gir_parser_argument_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ValaGirParserArgumentType* vala_gir_parser_argument_type_from_string (const gchar* name);
static ValaGirParserArgumentType* _vala_gir_parser_argument_type_dup (ValaGirParserArgumentType* self);
static guint vala_gir_parser_unresolved_symbol_hash (ValaUnresolvedSymbol* sym);
static guint _vala_gir_parser_unresolved_symbol_hash_ghash_func (gconstpointer key);
static gboolean vala_gir_parser_unresolved_symbol_equal (ValaUnresolvedSymbol* sym1,
                                                  ValaUnresolvedSymbol* sym2);
static gboolean _vala_gir_parser_unresolved_symbol_equal_gequal_func (gconstpointer a,
                                                               gconstpointer b);
static ValaGirParserNode* vala_gir_parser_node_new (const gchar* name);
static ValaGirParserNode* vala_gir_parser_node_construct (GType object_type,
                                                   const gchar* name);
static gpointer vala_gir_parser_parameter_info_ref (gpointer instance);
static void vala_gir_parser_parameter_info_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_parameter_info (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED ;
static void vala_gir_parser_value_set_parameter_info (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED ;
static void vala_gir_parser_value_take_parameter_info (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED ;
static gpointer vala_gir_parser_value_get_parameter_info (const GValue* value) G_GNUC_UNUSED ;
static GType vala_gir_parser_parameter_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void vala_gir_parser_map_vala_to_gir (ValaGirParser* self);
static void vala_gir_parser_resolve_gir_symbols (ValaGirParser* self);
static void vala_gir_parser_create_new_namespaces (ValaGirParser* self);
static void vala_gir_parser_resolve_type_arguments (ValaGirParser* self);
static void vala_gir_parser_node_process (ValaGirParserNode* self,
                                   ValaGirParser* parser);
static void vala_gir_parser_report_unused_metadata (ValaGirParser* self,
                                             ValaGirParserMetadata* metadata);
static void vala_gir_parser_set_symbol_mapping (ValaGirParser* self,
                                         ValaUnresolvedSymbol* map_from,
                                         ValaSymbol* map_to);
static void vala_gir_parser_real_visit_source_file (ValaCodeVisitor* base,
                                             ValaSourceFile* source_file);
static ValaGirParserMetadata* vala_gir_parser_metadata_get_empty (void);
static void vala_gir_parser_next (ValaGirParser* self);
static ValaSourceReference* vala_gir_parser_get_current_src (ValaGirParser* self);
static void vala_gir_parser_parse_repository (ValaGirParser* self);
static void vala_gir_parser_start_element (ValaGirParser* self,
                                    const gchar* name);
static void vala_gir_parser_end_element (ValaGirParser* self,
                                  const gchar* name);
static void vala_gir_parser_skip_element (ValaGirParser* self);
static ValaSourceReference* vala_gir_parser_get_src (ValaGirParser* self,
                                              ValaSourceLocation* begin,
                                              ValaSourceLocation* end);
static void vala_gir_parser_add_symbol_to_container (ValaSymbol* container,
                                              ValaSymbol* sym);
static gboolean vala_gir_parser_is_container (ValaSymbol* sym);
static ValaNamespace* vala_gir_parser_get_parent_namespace (ValaGirParserNode* node);
static ValaUnresolvedSymbol* vala_gir_parser_parse_symbol_from_string (ValaGirParser* self,
                                                                const gchar* symbol_string,
                                                                ValaSourceReference* source_reference);
static void vala_gir_parser_assume_parameter_names (ValaGirParser* self,
                                             ValaSignal* sig,
                                             ValaSymbol* sym,
                                             gboolean skip_first);
static ValaGirParserNode* vala_gir_parser_find_invoker (ValaGirParser* self,
                                                 ValaGirParserNode* node);
static ValaGirParserMetadata* vala_gir_parser_get_current_metadata (ValaGirParser* self);
static ValaGirParserMetadata* vala_gir_parser_metadata_match_child (ValaGirParserMetadata* self,
                                                             const gchar* name,
                                                             const gchar* selector);
static gboolean vala_gir_parser_push_metadata (ValaGirParser* self);
static gboolean vala_gir_parser_metadata_has_argument (ValaGirParserMetadata* self,
                                                ValaGirParserArgumentType key);
static gboolean vala_gir_parser_metadata_get_bool (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType arg,
                                            gboolean default_value);
static void vala_gir_parser_pop_metadata (ValaGirParser* self);
static gboolean vala_gir_parser_parse_type_arguments_from_string (ValaGirParser* self,
                                                           ValaDataType* parent_type,
                                                           const gchar* type_arguments,
                                                           ValaSourceReference* source_reference);
static ValaDataType* vala_gir_parser_parse_type_from_string (ValaGirParser* self,
                                                      const gchar* type_string,
                                                      gboolean owned_by_default,
                                                      ValaSourceReference* source_reference);
static gchar* vala_gir_parser_element_get_string (ValaGirParser* self,
                                           const gchar* attribute_name,
                                           ValaGirParserArgumentType arg_type);
static gchar* vala_gir_parser_metadata_get_string (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_element_get_type (ValaGirParser* self,
                                                ValaDataType* orig_type,
                                                gboolean owned_by_default,
                                                gboolean* no_array_length,
                                                gboolean* array_null_terminated,
                                                gboolean* changed);
static ValaSourceReference* vala_gir_parser_metadata_get_source_reference (ValaGirParserMetadata* self,
                                                                    ValaGirParserArgumentType arg);
static gchar* vala_gir_parser_element_get_name (ValaGirParser* self,
                                         const gchar* gir_name);
static gchar* vala_gir_parser_element_get_type_id (ValaGirParser* self);
static void vala_gir_parser_set_array_ccode (ValaGirParser* self,
                                      ValaSymbol* sym,
                                      ValaGirParserParameterInfo* info);
static ValaGirParserNode* vala_gir_parser_node_lookup (ValaGirParserNode* self,
                                                const gchar* name,
                                                gboolean create_namespace,
                                                ValaSourceReference* source_reference);
static gchar* vala_gir_parser_node_get_cname (ValaGirParserNode* self);
static void vala_gir_parser_set_type_id_ccode (ValaGirParser* self,
                                        ValaSymbol* sym);
static void vala_gir_parser_parse_namespace (ValaGirParser* self);
static void vala_gir_parser_parse_include (ValaGirParser* self);
static gchar* vala_gir_parser_parse_package (ValaGirParser* self);
static void vala_gir_parser_parse_c_include (ValaGirParser* self);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static ValaGirParserNode* vala_gir_parser_resolve_node (ValaGirParser* self,
                                                 ValaGirParserNode* parent_scope,
                                                 ValaUnresolvedSymbol* unresolved_sym,
                                                 gboolean create_namespace);
static ValaSymbol* vala_gir_parser_resolve_symbol (ValaGirParser* self,
                                            ValaGirParserNode* parent_scope,
                                            ValaUnresolvedSymbol* unresolved_sym);
static void vala_gir_parser_push_node (ValaGirParser* self,
                                const gchar* name,
                                gboolean merge);
static void vala_gir_parser_node_add_member (ValaGirParserNode* self,
                                      ValaGirParserNode* node);
static gchar* vala_gir_parser_node_get_gir_name (ValaGirParserNode* self);
static ValaUnresolvedSymbol* vala_gir_parser_node_get_unresolved_symbol (ValaGirParserNode* self);
static void vala_gir_parser_pop_node (ValaGirParser* self);
static gpointer vala_gir_parser_metadata_parser_ref (gpointer instance);
static void vala_gir_parser_metadata_parser_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_metadata_parser (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags) G_GNUC_UNUSED ;
static void vala_gir_parser_value_set_metadata_parser (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED ;
static void vala_gir_parser_value_take_metadata_parser (GValue* value,
                                                 gpointer v_object) G_GNUC_UNUSED ;
static gpointer vala_gir_parser_value_get_metadata_parser (const GValue* value) G_GNUC_UNUSED ;
static GType vala_gir_parser_metadata_parser_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ValaGirParserMetadataParser* vala_gir_parser_metadata_parser_new (void);
static ValaGirParserMetadataParser* vala_gir_parser_metadata_parser_construct (GType object_type);
static ValaGirParserMetadata* vala_gir_parser_metadata_parser_parse_metadata (ValaGirParserMetadataParser* self,
                                                                       ValaSourceFile* metadata_file);
static void _vala_code_node_unref0_ (gpointer var);
static inline void _g_list_free__vala_code_node_unref0_ (GList* self);
static void vala_gir_parser_parse_alias (ValaGirParser* self);
static void vala_gir_parser_parse_error_domain (ValaGirParser* self);
static void vala_gir_parser_parse_enumeration (ValaGirParser* self,
                                        const gchar* element_name,
                                        gboolean error_domain);
static void vala_gir_parser_parse_bitfield (ValaGirParser* self);
static void vala_gir_parser_parse_method (ValaGirParser* self,
                                   const gchar* element_name);
static void vala_gir_parser_parse_callback (ValaGirParser* self);
static void vala_gir_parser_parse_record (ValaGirParser* self);
static void vala_gir_parser_parse_boxed (ValaGirParser* self,
                                  const gchar* element_name);
static void vala_gir_parser_parse_class (ValaGirParser* self);
static void vala_gir_parser_parse_interface (ValaGirParser* self);
static void vala_gir_parser_parse_union (ValaGirParser* self);
static void vala_gir_parser_parse_constant (ValaGirParser* self);
static ValaGirComment* vala_gir_parser_parse_symbol_doc (ValaGirParser* self);
static ValaDataType* vala_gir_parser_parse_type (ValaGirParser* self,
                                          gchar** ctype,
                                          gint* array_length_idx,
                                          gboolean transfer_elements,
                                          gboolean* no_array_length,
                                          gboolean* array_null_terminated);
static void vala_gir_parser_calculate_common_prefix (ValaGirParser* self,
                                              gchar** common_prefix,
                                              const gchar* cname);
static ValaComment* vala_gir_parser_parse_doc (ValaGirParser* self);
static void vala_gir_parser_parse_error_member (ValaGirParser* self);
static void vala_gir_parser_parse_enumeration_member (ValaGirParser* self);
static ValaExpression* vala_gir_parser_metadata_get_expression (ValaGirParserMetadata* self,
                                                         ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_parse_return_value (ValaGirParser* self,
                                                  gchar** ctype,
                                                  gint* array_length_idx,
                                                  gboolean* no_array_length,
                                                  gboolean* array_null_terminated,
                                                  ValaComment** comment);
static ValaParameter* vala_gir_parser_parse_parameter (ValaGirParser* self,
                                                gboolean* caller_allocates,
                                                gint* array_length_idx,
                                                gint* closure_idx,
                                                gint* destroy_idx,
                                                gchar** scope,
                                                ValaComment** comment,
                                                const gchar* default_name);
static gint vala_gir_parser_metadata_get_integer (ValaGirParserMetadata* self,
                                           ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_parse_type_from_gir_name (ValaGirParser* self,
                                                        const gchar* type_name,
                                                        gboolean* no_array_length,
                                                        gboolean* array_null_terminated,
                                                        const gchar* ctype);
static void vala_gir_parser_parse_field (ValaGirParser* self);
static void vala_gir_parser_parse_constructor (ValaGirParser* self);
static ValaProperty* vala_gir_parser_parse_property (ValaGirParser* self);
static void vala_gir_parser_parse_signal (ValaGirParser* self);
static void vala_gir_parser_parse_function (ValaGirParser* self,
                                     const gchar* element_name);
 G_GNUC_INTERNAL void vala_gir_comment_add_content_for_parameter (ValaGirComment* self,
                                                 const gchar* name,
                                                 ValaComment* comment);
static ValaGirParserParameterInfo* vala_gir_parser_parameter_info_new (ValaParameter* param,
                                                                gint array_length_idx,
                                                                gint closure_idx,
                                                                gint destroy_idx,
                                                                gboolean is_async);
static ValaGirParserParameterInfo* vala_gir_parser_parameter_info_construct (GType object_type,
                                                                      ValaParameter* param,
                                                                      gint array_length_idx,
                                                                      gint closure_idx,
                                                                      gint destroy_idx,
                                                                      gboolean is_async);
static gpointer vala_gir_parser_argument_ref (gpointer instance);
static void vala_gir_parser_argument_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_argument (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags) G_GNUC_UNUSED ;
static void vala_gir_parser_value_set_argument (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED ;
static void vala_gir_parser_value_take_argument (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED ;
static gpointer vala_gir_parser_value_get_argument (const GValue* value) G_GNUC_UNUSED ;
static GType vala_gir_parser_argument_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void vala_gir_parser_process_interface (ValaGirParser* self,
                                        ValaGirParserNode* iface_node);
static void vala_gir_parser_process_alias (ValaGirParser* self,
                                    ValaGirParserNode* alias);
static gchar* vala_gir_parser_node_get_full_name (ValaGirParserNode* self);
static void vala_gir_parser_process_callable (ValaGirParser* self,
                                       ValaGirParserNode* node);
static void vala_gir_parser_find_parent (ValaGirParser* self,
                                  const gchar* cname,
                                  ValaGirParserNode* current,
                                  ValaGirParserNode** best,
                                  gint* match);
static gchar* vala_gir_parser_node_get_lower_case_cprefix (ValaGirParserNode* self);
static gboolean vala_gir_parser_same_gir (ValaGirParser* self,
                                   ValaSymbol* gir_component,
                                   ValaSymbol* sym);
static void vala_gir_parser_process_namespace_method (ValaGirParser* self,
                                               ValaGirParserNode* ns,
                                               ValaGirParserNode* node);
static void vala_gir_parser_node_remove_member (ValaGirParserNode* self,
                                         ValaGirParserNode* node);
static void vala_gir_parser_process_virtual_method_field (ValaGirParser* self,
                                                   ValaGirParserNode* node,
                                                   ValaDelegate* d,
                                                   ValaUnresolvedSymbol* gtype_struct_for);
static gchar* vala_gir_parser_node_to_string (ValaGirParserNode* self);
static ValaArrayList* vala_gir_parser_node_lookup_all (ValaGirParserNode* self,
                                                const gchar* name);
static void vala_gir_parser_process_async_method (ValaGirParser* self,
                                           ValaGirParserNode* node);
static gchar* vala_gir_parser_node_get_finish_cname (ValaGirParserNode* self);
static ValaGirParserNode* vala_gir_parser_base_interface_property (ValaGirParser* self,
                                                            ValaGirParserNode* prop_node);
static ValaGirParserArgument* vala_gir_parser_argument_new (ValaExpression* expression,
                                                     ValaSourceReference* source_reference);
static ValaGirParserArgument* vala_gir_parser_argument_construct (GType object_type,
                                                           ValaExpression* expression,
                                                           ValaSourceReference* source_reference);
static void vala_gir_parser_argument_finalize (ValaGirParserArgument * obj);
static GType vala_gir_parser_argument_get_type_once (void);
static GType vala_gir_parser_metadata_set_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ValaGirParserMetadataSet* vala_gir_parser_metadata_set_new (const gchar* selector);
static ValaGirParserMetadataSet* vala_gir_parser_metadata_set_construct (GType object_type,
                                                                  const gchar* selector);
static ValaGirParserMetadata* vala_gir_parser_metadata_new (const gchar* pattern,
                                                     const gchar* selector,
                                                     ValaSourceReference* source_reference);
static ValaGirParserMetadata* vala_gir_parser_metadata_construct (GType object_type,
                                                           const gchar* pattern,
                                                           const gchar* selector,
                                                           ValaSourceReference* source_reference);
static void vala_gir_parser_metadata_set_add_sibling (ValaGirParserMetadataSet* self,
                                               ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_add_child (ValaGirParserMetadata* self,
                                         ValaGirParserMetadata* metadata);
static GType vala_gir_parser_metadata_set_get_type_once (void);
static void vala_gir_parser_metadata_add_argument (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType key,
                                            ValaGirParserArgument* value);
static void vala_gir_parser_metadata_finalize (ValaGirParserMetadata * obj);
static GType vala_gir_parser_metadata_get_type_once (void);
static ValaSourceReference* vala_gir_parser_metadata_parser_get_current_src (ValaGirParserMetadataParser* self);
static ValaSourceReference* vala_gir_parser_metadata_parser_get_src (ValaGirParserMetadataParser* self,
                                                              ValaSourceLocation* begin,
                                                              ValaSourceLocation* end);
static ValaTokenType vala_gir_parser_metadata_parser_next (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_parse_rule (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_has_space (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_has_newline (ValaGirParserMetadataParser* self);
static gchar* vala_gir_parser_metadata_parser_get_string (ValaGirParserMetadataParser* self,
                                                   ValaSourceLocation* begin,
                                                   ValaSourceLocation* end);
static gchar* vala_gir_parser_metadata_parser_parse_identifier (ValaGirParserMetadataParser* self,
                                                         gboolean is_glob);
static gchar* vala_gir_parser_metadata_parser_parse_selector (ValaGirParserMetadataParser* self);
static ValaGirParserMetadata* vala_gir_parser_metadata_parser_parse_pattern (ValaGirParserMetadataParser* self);
static ValaExpression* vala_gir_parser_metadata_parser_parse_expression (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_parse_args (ValaGirParserMetadataParser* self,
                                                     ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_parser_finalize (ValaGirParserMetadataParser * obj);
static GType vala_gir_parser_metadata_parser_get_type_once (void);
static gchar* vala_gir_parser_node_get_default_gir_name (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_lower_case_cprefix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_lower_case_csuffix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_lower_case_csuffix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_cprefix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_cname (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_cheader_filename (ValaGirParserNode* self);
static guint64 vala_gir_parser_node_parse_version_string (const gchar* version);
static void vala_gir_parser_node_move_class_methods (ValaGirParserNode* target,
                                              ValaGirParserNode* source);
static void vala_gir_parser_node_finalize (ValaGirParserNode * obj);
static GType vala_gir_parser_node_get_type_once (void);
static void vala_gir_parser_parameter_info_finalize (ValaGirParserParameterInfo * obj);
static GType vala_gir_parser_parameter_info_get_type_once (void);
static void vala_gir_parser_finalize (ValaCodeVisitor * obj);
static GType vala_gir_parser_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
vala_gir_parser_get_instance_private (ValaGirParser* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGirParser_private_offset);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static ValaGirParserArgumentType*
_vala_gir_parser_argument_type_dup (ValaGirParserArgumentType* self)
{
	ValaGirParserArgumentType* dup;
	dup = g_new0 (ValaGirParserArgumentType, 1);
	memcpy (dup, self, sizeof (ValaGirParserArgumentType));
	return dup;
}

static gpointer
__vala_gir_parser_argument_type_dup0 (gpointer self)
{
	return self ? _vala_gir_parser_argument_type_dup (self) : NULL;
}

static ValaGirParserArgumentType*
vala_gir_parser_argument_type_from_string (const gchar* name)
{
	GEnumClass* enum_class = NULL;
	GTypeClass* _tmp0_;
	gchar* nick = NULL;
	gchar* _tmp1_;
	GEnumValue* enum_value = NULL;
	GEnumClass* _tmp2_;
	const gchar* _tmp3_;
	GEnumValue* _tmp4_;
	ValaGirParserArgumentType* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_type_class_ref (VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE);
	enum_class = (GEnumClass*) _tmp0_;
	_tmp1_ = string_replace (name, "_", "-");
	nick = _tmp1_;
	_tmp2_ = enum_class;
	_tmp3_ = nick;
	enum_value = g_enum_get_value_by_nick (_tmp2_, _tmp3_);
	_tmp4_ = enum_value;
	if (_tmp4_ != NULL) {
		ValaGirParserArgumentType value = 0;
		GEnumValue* _tmp5_;
		ValaGirParserArgumentType* _tmp6_;
		_tmp5_ = enum_value;
		value = (ValaGirParserArgumentType) (*_tmp5_).value;
		_tmp6_ = __vala_gir_parser_argument_type_dup0 (&value);
		result = _tmp6_;
		_g_free0 (nick);
		_g_type_class_unref0 (enum_class);
		return result;
	}
	result = NULL;
	_g_free0 (nick);
	_g_type_class_unref0 (enum_class);
	return result;
}

static GType
vala_gir_parser_argument_type_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP, "VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP", "skip"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN, "VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN", "hidden"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NEW, "VALA_GIR_PARSER_ARGUMENT_TYPE_NEW", "new"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE", "type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS", "type-arguments"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME", "cheader-filename"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_NAME", "name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED, "VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED", "owned"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED, "VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED", "unowned"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT, "VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT", "parent"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE, "VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE", "nullable"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED", "deprecated"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT, "VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT", "replacement"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE", "deprecated-since"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE", "since"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY", "array"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX", "array-length-idx"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED", "array-null-terminated"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT", "default"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_OUT, "VALA_GIR_PARSER_ARGUMENT_TYPE_OUT", "out"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_REF, "VALA_GIR_PARSER_ARGUMENT_TYPE_REF", "ref"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME", "vfunc-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL, "VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL", "virtual"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, "VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT", "abstract"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_COMPACT, "VALA_GIR_PARSER_ARGUMENT_TYPE_COMPACT", "compact"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SEALED, "VALA_GIR_PARSER_ARGUMENT_TYPE_SEALED", "sealed"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE", "scope"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, "VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT", "struct"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS, "VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS", "throws"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT, "VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT", "printf-format"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD", "array-length-field"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL, "VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL", "sentinel"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE, "VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE", "closure"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY, "VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY", "destroy"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX", "cprefix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX", "lower-case-cprefix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX", "lower-case-csuffix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN, "VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN", "errordomain"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE", "destroys-instance"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE", "base-type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME", "finish-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE", "finish-instance"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE", "symbol-type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX, "VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX", "instance-idx"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL, "VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL", "experimental"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO, "VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO", "feature-test-macro"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING, "VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING", "floating"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID", "type-id"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_GET_FUNCTION, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_GET_FUNCTION", "type-get-function"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_COPY_FUNCTION, "VALA_GIR_PARSER_ARGUMENT_TYPE_COPY_FUNCTION", "copy-function"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FREE_FUNCTION, "VALA_GIR_PARSER_ARGUMENT_TYPE_FREE_FUNCTION", "free-function"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_REF_FUNCTION, "VALA_GIR_PARSER_ARGUMENT_TYPE_REF_FUNCTION", "ref-function"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_REF_SINK_FUNCTION, "VALA_GIR_PARSER_ARGUMENT_TYPE_REF_SINK_FUNCTION", "ref-sink-function"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_UNREF_FUNCTION, "VALA_GIR_PARSER_ARGUMENT_TYPE_UNREF_FUNCTION", "unref-function"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID, "VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID", "return-void"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER, "VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER", "returns-modified-pointer"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME", "delegate-target-cname"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY_NOTIFY_CNAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY_NOTIFY_CNAME", "destroy-notify-cname"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME", "finish-vfunc-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD, "VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD", "no-accessor-method"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NO_WRAPPER, "VALA_GIR_PARSER_ARGUMENT_TYPE_NO_WRAPPER", "no-wrapper"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME", "cname"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET, "VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET", "delegate-target"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE", "ctype"}, {0, NULL, NULL}};
	GType vala_gir_parser_argument_type_type_id;
	vala_gir_parser_argument_type_type_id = g_enum_register_static ("ValaGirParserArgumentType", values);
	return vala_gir_parser_argument_type_type_id;
}

static GType
vala_gir_parser_argument_type_get_type (void)
{
	static volatile gsize vala_gir_parser_argument_type_type_id__once = 0;
	if (g_once_init_enter (&vala_gir_parser_argument_type_type_id__once)) {
		GType vala_gir_parser_argument_type_type_id;
		vala_gir_parser_argument_type_type_id = vala_gir_parser_argument_type_get_type_once ();
		g_once_init_leave (&vala_gir_parser_argument_type_type_id__once, vala_gir_parser_argument_type_type_id);
	}
	return vala_gir_parser_argument_type_type_id__once;
}

static guint
_vala_gir_parser_unresolved_symbol_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = vala_gir_parser_unresolved_symbol_hash ((ValaUnresolvedSymbol*) key);
	return result;
}

static gboolean
_vala_gir_parser_unresolved_symbol_equal_gequal_func (gconstpointer a,
                                                      gconstpointer b)
{
	gboolean result;
	result = vala_gir_parser_unresolved_symbol_equal ((ValaUnresolvedSymbol*) a, (ValaUnresolvedSymbol*) b);
	return result;
}

/**
 * Parses all .gir source files in the specified code
 * context and builds a code tree.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_gir_parser_node_ref0 (gpointer self)
{
	return self ? vala_gir_parser_node_ref (self) : NULL;
}

void
vala_gir_parser_parse (ValaGirParser* self,
                       ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaGirParserNode* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaSymbol* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	ValaGirParserNode* _tmp8_;
	ValaGirParserNode* _tmp9_;
	ValaGirParserNode* _tmp10_;
	ValaNamespace* glib_ns = NULL;
	ValaNamespace* _tmp11_;
	ValaNamespace* _tmp12_;
	ValaScope* _tmp13_;
	ValaScope* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaNamespace* _tmp16_;
	ValaNamespace* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = vala_gir_parser_node_new (NULL);
	_vala_gir_parser_node_unref0 (self->priv->root);
	self->priv->root = _tmp1_;
	_tmp2_ = self->priv->root;
	_tmp3_ = vala_code_context_get_root (context);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp4_);
	_vala_code_node_unref0 (_tmp2_->symbol);
	_tmp2_->symbol = _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp6_);
	_vala_iterable_unref0 (self->priv->tree_stack);
	self->priv->tree_stack = _tmp7_;
	_tmp8_ = self->priv->root;
	_tmp9_ = _vala_gir_parser_node_ref0 (_tmp8_);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = _tmp9_;
	vala_gir_parser_map_vala_to_gir (self);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	vala_gir_parser_resolve_gir_symbols (self);
	vala_gir_parser_create_new_namespaces (self);
	vala_gir_parser_resolve_type_arguments (self);
	_tmp10_ = self->priv->root;
	vala_gir_parser_node_process (_tmp10_, self);
	_tmp11_ = vala_code_context_get_root (context);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_scope_lookup (_tmp14_, "GLib");
	_tmp16_ = VALA_IS_NAMESPACE (_tmp15_) ? ((ValaNamespace*) _tmp15_) : NULL;
	if (_tmp16_ == NULL) {
		_vala_code_node_unref0 (_tmp15_);
	}
	glib_ns = _tmp16_;
	_tmp17_ = glib_ns;
	if (_tmp17_ != NULL) {
		ValaClass* object_type = NULL;
		ValaNamespace* _tmp18_;
		ValaScope* _tmp19_;
		ValaScope* _tmp20_;
		ValaSymbol* _tmp21_;
		_tmp18_ = glib_ns;
		_tmp19_ = vala_symbol_get_scope ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_scope_lookup (_tmp20_, "Object");
		object_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CLASS, ValaClass);
		{
			ValaArrayList* _iface_list = NULL;
			ValaArrayList* _tmp22_;
			gint _iface_size = 0;
			ValaArrayList* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _iface_index = 0;
			_tmp22_ = self->priv->ifaces_needing_object_prereq;
			_iface_list = _tmp22_;
			_tmp23_ = _iface_list;
			_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
			_tmp25_ = _tmp24_;
			_iface_size = _tmp25_;
			_iface_index = -1;
			while (TRUE) {
				gint _tmp26_;
				gint _tmp27_;
				ValaInterface* iface = NULL;
				ValaArrayList* _tmp28_;
				gpointer _tmp29_;
				ValaInterface* _tmp30_;
				ValaClass* _tmp31_;
				ValaObjectType* _tmp32_;
				ValaObjectType* _tmp33_;
				_iface_index = _iface_index + 1;
				_tmp26_ = _iface_index;
				_tmp27_ = _iface_size;
				if (!(_tmp26_ < _tmp27_)) {
					break;
				}
				_tmp28_ = _iface_list;
				_tmp29_ = vala_list_get ((ValaList*) _tmp28_, _iface_index);
				iface = (ValaInterface*) _tmp29_;
				_tmp30_ = iface;
				_tmp31_ = object_type;
				_tmp32_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp31_, NULL);
				_tmp33_ = _tmp32_;
				vala_interface_add_prerequisite (_tmp30_, (ValaDataType*) _tmp33_);
				_vala_code_node_unref0 (_tmp33_);
				_vala_code_node_unref0 (iface);
			}
		}
		_vala_code_node_unref0 (object_type);
	}
	{
		ValaArrayList* _metadata_list = NULL;
		ValaArrayList* _tmp34_;
		gint _metadata_size = 0;
		ValaArrayList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _metadata_index = 0;
		_tmp34_ = self->priv->metadata_roots;
		_metadata_list = _tmp34_;
		_tmp35_ = _metadata_list;
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_metadata_size = _tmp37_;
		_metadata_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			ValaGirParserMetadata* metadata = NULL;
			ValaArrayList* _tmp40_;
			gpointer _tmp41_;
			ValaGirParserMetadata* _tmp42_;
			_metadata_index = _metadata_index + 1;
			_tmp38_ = _metadata_index;
			_tmp39_ = _metadata_size;
			if (!(_tmp38_ < _tmp39_)) {
				break;
			}
			_tmp40_ = _metadata_list;
			_tmp41_ = vala_list_get ((ValaList*) _tmp40_, _metadata_index);
			metadata = (ValaGirParserMetadata*) _tmp41_;
			_tmp42_ = metadata;
			vala_gir_parser_report_unused_metadata (self, _tmp42_);
			_vala_gir_parser_metadata_unref0 (metadata);
		}
	}
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
	_vala_code_node_unref0 (glib_ns);
}

static void
vala_gir_parser_map_vala_to_gir (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaList* _source_file_list = NULL;
		ValaCodeContext* _tmp0_;
		ValaList* _tmp1_;
		gint _source_file_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _source_file_index = 0;
		_tmp0_ = self->priv->context;
		_tmp1_ = vala_code_context_get_source_files (_tmp0_);
		_source_file_list = _tmp1_;
		_tmp2_ = _source_file_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_source_file_size = _tmp4_;
		_source_file_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaSourceFile* source_file = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			gchar* gir_namespace = NULL;
			ValaSourceFile* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* gir_version = NULL;
			ValaSourceFile* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			ValaNamespace* ns = NULL;
			const gchar* _tmp17_;
			const gchar* _tmp35_;
			ValaSet* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			ValaUnresolvedSymbol* gir_symbol = NULL;
			const gchar* _tmp41_;
			ValaUnresolvedSymbol* _tmp42_;
			const gchar* _tmp43_;
			ValaNamespace* _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			_source_file_index = _source_file_index + 1;
			_tmp5_ = _source_file_index;
			_tmp6_ = _source_file_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _source_file_list;
			_tmp8_ = vala_list_get (_tmp7_, _source_file_index);
			source_file = (ValaSourceFile*) _tmp8_;
			_tmp9_ = source_file;
			_tmp10_ = vala_source_file_get_gir_namespace (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strdup (_tmp11_);
			gir_namespace = _tmp12_;
			_tmp13_ = source_file;
			_tmp14_ = vala_source_file_get_gir_version (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strdup (_tmp15_);
			gir_version = _tmp16_;
			ns = NULL;
			_tmp17_ = gir_namespace;
			if (_tmp17_ == NULL) {
				{
					ValaList* _node_list = NULL;
					ValaSourceFile* _tmp18_;
					ValaList* _tmp19_;
					gint _node_size = 0;
					ValaList* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					gint _node_index = 0;
					_tmp18_ = source_file;
					_tmp19_ = vala_source_file_get_nodes (_tmp18_);
					_node_list = _tmp19_;
					_tmp20_ = _node_list;
					_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
					_tmp22_ = _tmp21_;
					_node_size = _tmp22_;
					_node_index = -1;
					while (TRUE) {
						gint _tmp23_;
						gint _tmp24_;
						ValaCodeNode* node = NULL;
						ValaList* _tmp25_;
						gpointer _tmp26_;
						ValaCodeNode* _tmp27_;
						_node_index = _node_index + 1;
						_tmp23_ = _node_index;
						_tmp24_ = _node_size;
						if (!(_tmp23_ < _tmp24_)) {
							break;
						}
						_tmp25_ = _node_list;
						_tmp26_ = vala_list_get (_tmp25_, _node_index);
						node = (ValaCodeNode*) _tmp26_;
						_tmp27_ = node;
						if (VALA_IS_NAMESPACE (_tmp27_)) {
							ValaCodeNode* _tmp28_;
							ValaNamespace* _tmp29_;
							ValaNamespace* _tmp30_;
							gchar* _tmp31_;
							const gchar* _tmp32_;
							_tmp28_ = node;
							_tmp29_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_NAMESPACE, ValaNamespace));
							_vala_code_node_unref0 (ns);
							ns = _tmp29_;
							_tmp30_ = ns;
							_tmp31_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp30_, "CCode", "gir_namespace", NULL);
							_g_free0 (gir_namespace);
							gir_namespace = _tmp31_;
							_tmp32_ = gir_namespace;
							if (_tmp32_ != NULL) {
								ValaNamespace* _tmp33_;
								gchar* _tmp34_;
								_tmp33_ = ns;
								_tmp34_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp33_, "CCode", "gir_version", NULL);
								_g_free0 (gir_version);
								gir_version = _tmp34_;
								_vala_code_node_unref0 (node);
								break;
							}
						}
						_vala_code_node_unref0 (node);
					}
				}
			}
			_tmp35_ = gir_namespace;
			if (_tmp35_ == NULL) {
				_vala_code_node_unref0 (ns);
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
				_vala_source_file_unref0 (source_file);
				continue;
			}
			_tmp36_ = self->priv->provided_namespaces;
			_tmp37_ = gir_namespace;
			_tmp38_ = gir_version;
			_tmp39_ = g_strdup_printf ("%s-%s", _tmp37_, _tmp38_);
			_tmp40_ = _tmp39_;
			vala_collection_add ((ValaCollection*) _tmp36_, _tmp40_);
			_g_free0 (_tmp40_);
			_tmp41_ = gir_namespace;
			_tmp42_ = vala_unresolved_symbol_new (NULL, _tmp41_, NULL);
			gir_symbol = _tmp42_;
			_tmp43_ = gir_namespace;
			_tmp44_ = ns;
			_tmp45_ = vala_symbol_get_name ((ValaSymbol*) _tmp44_);
			_tmp46_ = _tmp45_;
			if (g_strcmp0 (_tmp43_, _tmp46_) != 0) {
				ValaUnresolvedSymbol* _tmp47_;
				ValaNamespace* _tmp48_;
				_tmp47_ = gir_symbol;
				_tmp48_ = ns;
				vala_gir_parser_set_symbol_mapping (self, _tmp47_, (ValaSymbol*) _tmp48_);
			}
			{
				ValaList* _node_list = NULL;
				ValaSourceFile* _tmp49_;
				ValaList* _tmp50_;
				gint _node_size = 0;
				ValaList* _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				gint _node_index = 0;
				_tmp49_ = source_file;
				_tmp50_ = vala_source_file_get_nodes (_tmp49_);
				_node_list = _tmp50_;
				_tmp51_ = _node_list;
				_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
				_tmp53_ = _tmp52_;
				_node_size = _tmp53_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp54_;
					gint _tmp55_;
					ValaCodeNode* node = NULL;
					ValaList* _tmp56_;
					gpointer _tmp57_;
					ValaCodeNode* _tmp58_;
					_node_index = _node_index + 1;
					_tmp54_ = _node_index;
					_tmp55_ = _node_size;
					if (!(_tmp54_ < _tmp55_)) {
						break;
					}
					_tmp56_ = _node_list;
					_tmp57_ = vala_list_get (_tmp56_, _node_index);
					node = (ValaCodeNode*) _tmp57_;
					_tmp58_ = node;
					if (vala_code_node_has_attribute_argument (_tmp58_, "GIR", "name")) {
						ValaUnresolvedSymbol* map_from = NULL;
						ValaUnresolvedSymbol* _tmp59_;
						ValaCodeNode* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						ValaUnresolvedSymbol* _tmp63_;
						ValaUnresolvedSymbol* _tmp64_;
						ValaUnresolvedSymbol* _tmp65_;
						ValaCodeNode* _tmp66_;
						_tmp59_ = gir_symbol;
						_tmp60_ = node;
						_tmp61_ = vala_code_node_get_attribute_string (_tmp60_, "GIR", "name", NULL);
						_tmp62_ = _tmp61_;
						_tmp63_ = vala_unresolved_symbol_new (_tmp59_, _tmp62_, NULL);
						_tmp64_ = _tmp63_;
						_g_free0 (_tmp62_);
						map_from = _tmp64_;
						_tmp65_ = map_from;
						_tmp66_ = node;
						vala_gir_parser_set_symbol_mapping (self, _tmp65_, G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, VALA_TYPE_SYMBOL, ValaSymbol));
						_vala_code_node_unref0 (map_from);
					}
					_vala_code_node_unref0 (node);
				}
			}
			_vala_code_node_unref0 (gir_symbol);
			_vala_code_node_unref0 (ns);
			_g_free0 (gir_version);
			_g_free0 (gir_namespace);
			_vala_source_file_unref0 (source_file);
		}
	}
}

static void
vala_gir_parser_real_visit_source_file (ValaCodeVisitor* base,
                                        ValaSourceFile* source_file)
{
	ValaGirParser * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValaGirParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = _tmp0_;
	if (g_str_has_suffix (_tmp1_, ".gir")) {
		vala_gir_parser_parse_file (self, source_file);
	}
}

static gpointer
_vala_gir_parser_metadata_ref0 (gpointer self)
{
	return self ? vala_gir_parser_metadata_ref (self) : NULL;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

void
vala_gir_parser_parse_file (ValaGirParser* self,
                            ValaSourceFile* source_file)
{
	gboolean has_global_context = FALSE;
	ValaCodeContext* _tmp0_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	ValaGirParserMetadata* _tmp6_;
	ValaGirParserMetadata* _tmp7_;
	ValaGirParserMetadata* _tmp8_;
	ValaSourceFile* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValaMarkupReader* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = self->priv->context;
	has_global_context = _tmp0_ != NULL;
	if (!has_global_context) {
		ValaCodeContext* _tmp1_;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		_tmp1_ = vala_source_file_get_context (source_file);
		_tmp2_ = _tmp1_;
		_tmp3_ = _vala_code_context_ref0 (_tmp2_);
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = _tmp3_;
	}
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp4_);
	_vala_iterable_unref0 (self->priv->metadata_stack);
	self->priv->metadata_stack = _tmp5_;
	_tmp6_ = vala_gir_parser_metadata_get_empty ();
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_gir_parser_metadata_ref0 (_tmp7_);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp8_;
	self->priv->cheader_filenames = (_vala_array_free (self->priv->cheader_filenames, self->priv->cheader_filenames_length1, (GDestroyNotify) g_free), NULL);
	self->priv->cheader_filenames = NULL;
	self->priv->cheader_filenames_length1 = 0;
	self->priv->_cheader_filenames_size_ = self->priv->cheader_filenames_length1;
	_tmp9_ = _vala_source_file_ref0 (source_file);
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = _tmp9_;
	_tmp10_ = vala_source_file_get_filename (source_file);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_markup_reader_new (_tmp11_);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = _tmp12_;
	{
		gboolean _tmp13_ = FALSE;
		_tmp13_ = TRUE;
		while (TRUE) {
			if (!_tmp13_) {
				gboolean _tmp14_ = FALSE;
				if (self->priv->current_token != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
					ValaMarkupReader* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					_tmp15_ = self->priv->reader;
					_tmp16_ = vala_markup_reader_get_name (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp14_ = g_strcmp0 (_tmp17_, "repository") != 0;
				} else {
					_tmp14_ = FALSE;
				}
				if (!_tmp14_) {
					break;
				}
			}
			_tmp13_ = FALSE;
			vala_gir_parser_next (self);
			if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_EOF) {
				ValaSourceReference* _tmp18_;
				ValaSourceReference* _tmp19_;
				_tmp18_ = vala_gir_parser_get_current_src (self);
				_tmp19_ = _tmp18_;
				vala_report_error (_tmp19_, "unexpected end of file");
				_vala_source_reference_unref0 (_tmp19_);
				return;
			}
		}
	}
	vala_gir_parser_parse_repository (self);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = NULL;
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = NULL;
	if (!has_global_context) {
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = NULL;
	}
}

static void
vala_gir_parser_next (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	ValaSourceLocation _tmp2_ = {0};
	ValaMarkupTokenType _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_read_token (_tmp0_, &_tmp1_, &_tmp2_);
	self->priv->begin = _tmp1_;
	self->priv->end = _tmp2_;
	self->priv->current_token = _tmp3_;
}

static void
vala_gir_parser_start_element (ValaGirParser* self,
                               const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	if (self->priv->current_token != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaMarkupReader* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = self->priv->reader;
		_tmp2_ = vala_markup_reader_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = g_strcmp0 (_tmp3_, name) != 0;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		_tmp4_ = vala_gir_parser_get_current_src (self);
		_tmp5_ = _tmp4_;
		vala_report_error (_tmp5_, "expected start element of `%s'", name);
		_vala_source_reference_unref0 (_tmp5_);
	}
}

static void
vala_gir_parser_end_element (ValaGirParser* self,
                             const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		if (self->priv->current_token != VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
			_tmp0_ = TRUE;
		} else {
			ValaMarkupReader* _tmp1_;
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			_tmp1_ = self->priv->reader;
			_tmp2_ = vala_markup_reader_get_name (_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp0_ = g_strcmp0 (_tmp3_, name) != 0;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp4_ = vala_gir_parser_get_current_src (self);
		_tmp5_ = _tmp4_;
		vala_report_warning (_tmp5_, "expected end element of `%s'", name);
		_vala_source_reference_unref0 (_tmp5_);
		vala_gir_parser_skip_element (self);
	}
	vala_gir_parser_next (self);
}

static ValaSourceReference*
vala_gir_parser_get_current_src (ValaGirParser* self)
{
	ValaSourceFile* _tmp0_;
	ValaSourceLocation _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaSourceReference* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_source_file;
	_tmp1_ = self->priv->begin;
	_tmp2_ = self->priv->end;
	_tmp3_ = vala_source_reference_new (_tmp0_, &_tmp1_, &_tmp2_);
	result = _tmp3_;
	return result;
}

static ValaSourceReference*
vala_gir_parser_get_src (ValaGirParser* self,
                         ValaSourceLocation* begin,
                         ValaSourceLocation* end)
{
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceFile* _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	_tmp0_ = self->priv->end;
	e = _tmp0_;
	if (end != NULL) {
		e = *end;
	}
	_tmp1_ = self->priv->current_source_file;
	_tmp2_ = *begin;
	_tmp3_ = e;
	_tmp4_ = vala_source_reference_new (_tmp1_, &_tmp2_, &_tmp3_);
	result = _tmp4_;
	return result;
}

static void
vala_gir_parser_add_symbol_to_container (ValaSymbol* container,
                                         ValaSymbol* sym)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (container != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_symbol_get_name (sym);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
		_tmp3_ = _tmp2_;
		vala_report_warning (_tmp3_, "node with empty name");
		return;
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = vala_symbol_get_name (sym);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			ValaSymbol* old_sym = NULL;
			ValaScope* _tmp6_;
			ValaScope* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSymbol* _tmp11_;
			_tmp6_ = vala_symbol_get_scope (container);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_symbol_get_name (sym);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_scope_lookup (_tmp7_, _tmp9_);
			old_sym = _tmp10_;
			_tmp11_ = old_sym;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				ValaSymbol* _tmp18_;
				ValaSourceReference* _tmp19_;
				ValaSourceReference* _tmp20_;
				ValaSymbol* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
				_tmp13_ = _tmp12_;
				_tmp14_ = vala_symbol_get_name (container);
				_tmp15_ = _tmp14_;
				_tmp16_ = vala_symbol_get_name (sym);
				_tmp17_ = _tmp16_;
				vala_report_warning (_tmp13_, "`%s' already contains a definition for `%s'", _tmp15_, _tmp17_);
				_tmp18_ = old_sym;
				_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = old_sym;
				_tmp22_ = vala_symbol_get_name (_tmp21_);
				_tmp23_ = _tmp22_;
				vala_report_notice (_tmp20_, "previous definition of `%s' was here", _tmp23_);
				_vala_code_node_unref0 (old_sym);
				return;
			}
			_vala_code_node_unref0 (old_sym);
		}
	}
	if (VALA_IS_CLASS (container)) {
		ValaClass* cl = NULL;
		cl = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_CLASS, ValaClass);
		if (VALA_IS_CLASS (sym)) {
			ValaClass* _tmp24_;
			_tmp24_ = cl;
			vala_symbol_add_class ((ValaSymbol*) _tmp24_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
		} else {
			if (VALA_IS_CONSTANT (sym)) {
				ValaClass* _tmp25_;
				_tmp25_ = cl;
				vala_symbol_add_constant ((ValaSymbol*) _tmp25_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
			} else {
				if (VALA_IS_ENUM (sym)) {
					ValaClass* _tmp26_;
					_tmp26_ = cl;
					vala_symbol_add_enum ((ValaSymbol*) _tmp26_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
				} else {
					if (VALA_IS_FIELD (sym)) {
						ValaClass* _tmp27_;
						_tmp27_ = cl;
						vala_symbol_add_field ((ValaSymbol*) _tmp27_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
					} else {
						if (VALA_IS_METHOD (sym)) {
							ValaClass* _tmp28_;
							_tmp28_ = cl;
							vala_symbol_add_method ((ValaSymbol*) _tmp28_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
						} else {
							if (VALA_IS_PROPERTY (sym)) {
								ValaClass* _tmp29_;
								_tmp29_ = cl;
								vala_symbol_add_property ((ValaSymbol*) _tmp29_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
							} else {
								if (VALA_IS_SIGNAL (sym)) {
									ValaClass* _tmp30_;
									_tmp30_ = cl;
									vala_symbol_add_signal ((ValaSymbol*) _tmp30_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
								} else {
									if (VALA_IS_STRUCT (sym)) {
										ValaClass* _tmp31_;
										_tmp31_ = cl;
										vala_symbol_add_struct ((ValaSymbol*) _tmp31_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		if (VALA_IS_ENUM (container)) {
			ValaEnum* en = NULL;
			en = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_ENUM, ValaEnum);
			if (VALA_IS_ENUM_VALUE (sym)) {
				ValaEnum* _tmp32_;
				_tmp32_ = en;
				vala_enum_add_value (_tmp32_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM_VALUE, ValaEnumValue));
			} else {
				if (VALA_IS_CONSTANT (sym)) {
					ValaEnum* _tmp33_;
					_tmp33_ = en;
					vala_symbol_add_constant ((ValaSymbol*) _tmp33_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
				} else {
					if (VALA_IS_METHOD (sym)) {
						ValaEnum* _tmp34_;
						_tmp34_ = en;
						vala_symbol_add_method ((ValaSymbol*) _tmp34_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
					}
				}
			}
		} else {
			if (VALA_IS_INTERFACE (container)) {
				ValaInterface* iface = NULL;
				iface = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_INTERFACE, ValaInterface);
				if (VALA_IS_CLASS (sym)) {
					ValaInterface* _tmp35_;
					_tmp35_ = iface;
					vala_symbol_add_class ((ValaSymbol*) _tmp35_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
				} else {
					if (VALA_IS_CONSTANT (sym)) {
						ValaInterface* _tmp36_;
						_tmp36_ = iface;
						vala_symbol_add_constant ((ValaSymbol*) _tmp36_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
					} else {
						if (VALA_IS_ENUM (sym)) {
							ValaInterface* _tmp37_;
							_tmp37_ = iface;
							vala_symbol_add_enum ((ValaSymbol*) _tmp37_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
						} else {
							if (VALA_IS_FIELD (sym)) {
								ValaInterface* _tmp38_;
								_tmp38_ = iface;
								vala_symbol_add_field ((ValaSymbol*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (VALA_IS_METHOD (sym)) {
									ValaInterface* _tmp39_;
									_tmp39_ = iface;
									vala_symbol_add_method ((ValaSymbol*) _tmp39_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										ValaInterface* _tmp40_;
										_tmp40_ = iface;
										vala_symbol_add_property ((ValaSymbol*) _tmp40_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									} else {
										if (VALA_IS_SIGNAL (sym)) {
											ValaInterface* _tmp41_;
											_tmp41_ = iface;
											vala_symbol_add_signal ((ValaSymbol*) _tmp41_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
										} else {
											if (VALA_IS_STRUCT (sym)) {
												ValaInterface* _tmp42_;
												_tmp42_ = iface;
												vala_symbol_add_struct ((ValaSymbol*) _tmp42_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
											}
										}
									}
								}
							}
						}
					}
				}
			} else {
				if (VALA_IS_NAMESPACE (container)) {
					ValaNamespace* ns = NULL;
					ns = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_NAMESPACE, ValaNamespace);
					if (VALA_IS_NAMESPACE (sym)) {
						ValaNamespace* _tmp43_;
						_tmp43_ = ns;
						vala_symbol_add_namespace ((ValaSymbol*) _tmp43_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_NAMESPACE, ValaNamespace));
					} else {
						if (VALA_IS_CLASS (sym)) {
							ValaNamespace* _tmp44_;
							_tmp44_ = ns;
							vala_symbol_add_class ((ValaSymbol*) _tmp44_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
						} else {
							if (VALA_IS_CONSTANT (sym)) {
								ValaNamespace* _tmp45_;
								_tmp45_ = ns;
								vala_symbol_add_constant ((ValaSymbol*) _tmp45_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
							} else {
								if (VALA_IS_DELEGATE (sym)) {
									ValaNamespace* _tmp46_;
									_tmp46_ = ns;
									vala_symbol_add_delegate ((ValaSymbol*) _tmp46_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_DELEGATE, ValaDelegate));
								} else {
									if (VALA_IS_ENUM (sym)) {
										ValaNamespace* _tmp47_;
										_tmp47_ = ns;
										vala_symbol_add_enum ((ValaSymbol*) _tmp47_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
									} else {
										if (VALA_IS_ERROR_DOMAIN (sym)) {
											ValaNamespace* _tmp48_;
											_tmp48_ = ns;
											vala_symbol_add_error_domain ((ValaSymbol*) _tmp48_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain));
										} else {
											if (VALA_IS_FIELD (sym)) {
												ValaField* field = NULL;
												ValaField* _tmp49_;
												ValaMemberBinding _tmp50_;
												ValaMemberBinding _tmp51_;
												ValaNamespace* _tmp53_;
												ValaField* _tmp54_;
												field = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField);
												_tmp49_ = field;
												_tmp50_ = vala_field_get_binding (_tmp49_);
												_tmp51_ = _tmp50_;
												if (_tmp51_ == VALA_MEMBER_BINDING_INSTANCE) {
													ValaField* _tmp52_;
													_tmp52_ = field;
													vala_field_set_binding (_tmp52_, VALA_MEMBER_BINDING_STATIC);
												}
												_tmp53_ = ns;
												_tmp54_ = field;
												vala_symbol_add_field ((ValaSymbol*) _tmp53_, _tmp54_);
											} else {
												if (VALA_IS_INTERFACE (sym)) {
													ValaNamespace* _tmp55_;
													_tmp55_ = ns;
													vala_symbol_add_interface ((ValaSymbol*) _tmp55_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_INTERFACE, ValaInterface));
												} else {
													if (VALA_IS_METHOD (sym)) {
														ValaMethod* method = NULL;
														ValaMethod* _tmp56_;
														ValaMemberBinding _tmp57_;
														ValaMemberBinding _tmp58_;
														ValaNamespace* _tmp60_;
														ValaMethod* _tmp61_;
														method = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod);
														_tmp56_ = method;
														_tmp57_ = vala_method_get_binding (_tmp56_);
														_tmp58_ = _tmp57_;
														if (_tmp58_ == VALA_MEMBER_BINDING_INSTANCE) {
															ValaMethod* _tmp59_;
															_tmp59_ = method;
															vala_method_set_binding (_tmp59_, VALA_MEMBER_BINDING_STATIC);
														}
														_tmp60_ = ns;
														_tmp61_ = method;
														vala_symbol_add_method ((ValaSymbol*) _tmp60_, _tmp61_);
													} else {
														if (VALA_IS_STRUCT (sym)) {
															ValaNamespace* _tmp62_;
															_tmp62_ = ns;
															vala_symbol_add_struct ((ValaSymbol*) _tmp62_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					if (VALA_IS_STRUCT (container)) {
						ValaStruct* st = NULL;
						st = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_STRUCT, ValaStruct);
						if (VALA_IS_CONSTANT (sym)) {
							ValaStruct* _tmp63_;
							_tmp63_ = st;
							vala_symbol_add_constant ((ValaSymbol*) _tmp63_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
						} else {
							if (VALA_IS_FIELD (sym)) {
								ValaStruct* _tmp64_;
								_tmp64_ = st;
								vala_symbol_add_field ((ValaSymbol*) _tmp64_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (VALA_IS_METHOD (sym)) {
									ValaStruct* _tmp65_;
									_tmp65_ = st;
									vala_symbol_add_method ((ValaSymbol*) _tmp65_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										ValaStruct* _tmp66_;
										_tmp66_ = st;
										vala_symbol_add_property ((ValaSymbol*) _tmp66_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									}
								}
							}
						}
					} else {
						if (VALA_IS_ERROR_DOMAIN (container)) {
							ValaErrorDomain* ed = NULL;
							ed = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain);
							if (VALA_IS_ERROR_CODE (sym)) {
								ValaErrorDomain* _tmp67_;
								_tmp67_ = ed;
								vala_error_domain_add_code (_tmp67_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_CODE, ValaErrorCode));
							} else {
								if (VALA_IS_METHOD (sym)) {
									ValaErrorDomain* _tmp68_;
									_tmp68_ = ed;
									vala_symbol_add_method ((ValaSymbol*) _tmp68_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								}
							}
						} else {
							ValaSourceReference* _tmp69_;
							ValaSourceReference* _tmp70_;
							const gchar* _tmp71_;
							const gchar* _tmp72_;
							const gchar* _tmp73_;
							const gchar* _tmp74_;
							_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
							_tmp70_ = _tmp69_;
							_tmp71_ = vala_symbol_get_name (sym);
							_tmp72_ = _tmp71_;
							_tmp73_ = vala_symbol_get_name (container);
							_tmp74_ = _tmp73_;
							vala_report_error (_tmp70_, "impossible to add `%s' to container `%s'", _tmp72_, _tmp74_);
						}
					}
				}
			}
		}
	}
}

static gboolean
vala_gir_parser_is_container (ValaSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	g_return_val_if_fail (sym != NULL, FALSE);
	if (VALA_IS_OBJECT_TYPE_SYMBOL (sym)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = VALA_IS_STRUCT (sym);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = VALA_IS_NAMESPACE (sym);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = VALA_IS_ERROR_DOMAIN (sym);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_ENUM (sym);
	}
	result = _tmp0_;
	return result;
}

static ValaNamespace*
vala_gir_parser_get_parent_namespace (ValaGirParserNode* node)
{
	ValaGirParserNode* n = NULL;
	ValaGirParserNode* _tmp0_;
	ValaNamespace* result;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node->parent;
	n = _tmp0_;
	while (TRUE) {
		ValaGirParserNode* _tmp1_;
		ValaGirParserNode* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaGirParserNode* _tmp6_;
		ValaGirParserNode* _tmp7_;
		_tmp1_ = n;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = n;
		_tmp3_ = _tmp2_->symbol;
		if (VALA_IS_NAMESPACE (_tmp3_)) {
			ValaGirParserNode* _tmp4_;
			ValaSymbol* _tmp5_;
			_tmp4_ = n;
			_tmp5_ = _tmp4_->symbol;
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_NAMESPACE, ValaNamespace);
			return result;
		}
		_tmp6_ = n;
		_tmp7_ = _tmp6_->parent;
		n = _tmp7_;
	}
	g_assert_not_reached ();
}

static ValaUnresolvedSymbol*
vala_gir_parser_parse_symbol_from_string (ValaGirParser* self,
                                          const gchar* symbol_string,
                                          ValaSourceReference* source_reference)
{
	ValaUnresolvedSymbol* sym = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	ValaUnresolvedSymbol* _tmp5_;
	ValaUnresolvedSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_string != NULL, NULL);
	sym = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (symbol_string, ".", 0);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp1_;
		s_collection_length1 = _vala_array_length (_tmp0_);
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				ValaUnresolvedSymbol* _tmp2_;
				const gchar* _tmp3_;
				ValaUnresolvedSymbol* _tmp4_;
				_tmp2_ = sym;
				_tmp3_ = s;
				_tmp4_ = vala_unresolved_symbol_new (_tmp2_, _tmp3_, source_reference);
				_vala_code_node_unref0 (sym);
				sym = _tmp4_;
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = sym;
	if (_tmp5_ == NULL) {
		vala_report_error (source_reference, "a symbol must be specified");
	}
	result = sym;
	return result;
}

static void
vala_gir_parser_set_symbol_mapping (ValaGirParser* self,
                                    ValaUnresolvedSymbol* map_from,
                                    ValaSymbol* map_to)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (map_from != NULL);
	g_return_if_fail (map_to != NULL);
	if (VALA_IS_UNRESOLVED_SYMBOL (map_from)) {
		ValaHashMap* _tmp0_;
		_tmp0_ = self->priv->unresolved_symbols_map;
		vala_map_set ((ValaMap*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (map_from, VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol), map_to);
	}
}

static void
vala_gir_parser_assume_parameter_names (ValaGirParser* self,
                                        ValaSignal* sig,
                                        ValaSymbol* sym,
                                        gboolean skip_first)
{
	ValaIterator* iter = NULL;
	ValaList* _tmp0_;
	ValaIterator* _tmp1_;
	gboolean first = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_callable_get_parameters (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CALLABLE, ValaCallable));
	_tmp1_ = vala_iterable_iterator ((ValaIterable*) _tmp0_);
	iter = _tmp1_;
	first = TRUE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp2_;
		gint _param_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _param_index = 0;
		_tmp2_ = vala_callable_get_parameters ((ValaCallable*) sig);
		_param_list = _tmp2_;
		_tmp3_ = _param_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_param_size = _tmp5_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaIterator* _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaParameter* _tmp13_;
			ValaIterator* _tmp14_;
			gpointer _tmp15_;
			ValaParameter* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_param_index = _param_index + 1;
			_tmp6_ = _param_index;
			_tmp7_ = _param_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = vala_list_get (_tmp8_, _param_index);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = iter;
			if (!vala_iterator_next (_tmp10_)) {
				_vala_code_node_unref0 (param);
				break;
			}
			if (skip_first) {
				_tmp11_ = first;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				ValaIterator* _tmp12_;
				_tmp12_ = iter;
				if (!vala_iterator_next (_tmp12_)) {
					_vala_code_node_unref0 (param);
					break;
				}
				first = FALSE;
			}
			_tmp13_ = param;
			_tmp14_ = iter;
			_tmp15_ = vala_iterator_get (_tmp14_);
			_tmp16_ = (ValaParameter*) _tmp15_;
			_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
			_tmp18_ = _tmp17_;
			vala_symbol_set_name ((ValaSymbol*) _tmp13_, _tmp18_);
			_vala_code_node_unref0 (_tmp16_);
			_vala_code_node_unref0 (param);
		}
	}
	_vala_iterator_unref0 (iter);
}

static ValaGirParserNode*
vala_gir_parser_find_invoker (ValaGirParser* self,
                              ValaGirParserNode* node)
{
	ValaMethod* m = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	gchar* prefix = NULL;
	ValaMethod* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	ValaGirParserNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp1_;
	_tmp2_ = m;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_", _tmp4_);
	prefix = _tmp5_;
	{
		ValaArrayList* _n_list = NULL;
		ValaGirParserNode* _tmp6_;
		ValaArrayList* _tmp7_;
		gint _n_size = 0;
		ValaArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _n_index = 0;
		_tmp6_ = node->parent;
		_tmp7_ = _tmp6_->members;
		_n_list = _tmp7_;
		_tmp8_ = _n_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_n_size = _tmp10_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp13_;
			gpointer _tmp14_;
			ValaGirParserNode* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			ValaMethod* invoker = NULL;
			ValaGirParserNode* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaMethod* _tmp20_;
			gboolean _tmp21_ = FALSE;
			ValaMethod* _tmp22_;
			ValaIterator* iter = NULL;
			ValaMethod* _tmp31_;
			ValaList* _tmp32_;
			ValaIterator* _tmp33_;
			ValaMethod* _tmp53_;
			_n_index = _n_index + 1;
			_tmp11_ = _n_index;
			_tmp12_ = _n_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _n_list;
			_tmp14_ = vala_list_get ((ValaList*) _tmp13_, _n_index);
			n = (ValaGirParserNode*) _tmp14_;
			_tmp15_ = n;
			_tmp16_ = _tmp15_->name;
			_tmp17_ = prefix;
			if (!g_str_has_prefix (_tmp16_, _tmp17_)) {
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp18_ = n;
			_tmp19_ = _tmp18_->symbol;
			_tmp20_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp19_) ? ((ValaMethod*) _tmp19_) : NULL);
			invoker = _tmp20_;
			_tmp22_ = invoker;
			if (_tmp22_ == NULL) {
				_tmp21_ = TRUE;
			} else {
				ValaMethod* _tmp23_;
				ValaList* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				ValaMethod* _tmp27_;
				ValaList* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				_tmp23_ = m;
				_tmp24_ = vala_callable_get_parameters ((ValaCallable*) _tmp23_);
				_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = invoker;
				_tmp28_ = vala_callable_get_parameters ((ValaCallable*) _tmp27_);
				_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp21_ = _tmp26_ != _tmp30_;
			}
			if (_tmp21_) {
				_vala_code_node_unref0 (invoker);
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp31_ = invoker;
			_tmp32_ = vala_callable_get_parameters ((ValaCallable*) _tmp31_);
			_tmp33_ = vala_iterable_iterator ((ValaIterable*) _tmp32_);
			iter = _tmp33_;
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp34_;
				ValaList* _tmp35_;
				gint _param_size = 0;
				ValaList* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				gint _param_index = 0;
				_tmp34_ = m;
				_tmp35_ = vala_callable_get_parameters ((ValaCallable*) _tmp34_);
				_param_list = _tmp35_;
				_tmp36_ = _param_list;
				_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
				_tmp38_ = _tmp37_;
				_param_size = _tmp38_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp39_;
					gint _tmp40_;
					ValaParameter* param = NULL;
					ValaList* _tmp41_;
					gpointer _tmp42_;
					ValaIterator* _tmp43_;
					ValaParameter* _tmp44_;
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					ValaIterator* _tmp47_;
					gpointer _tmp48_;
					ValaParameter* _tmp49_;
					const gchar* _tmp50_;
					const gchar* _tmp51_;
					gboolean _tmp52_;
					_param_index = _param_index + 1;
					_tmp39_ = _param_index;
					_tmp40_ = _param_size;
					if (!(_tmp39_ < _tmp40_)) {
						break;
					}
					_tmp41_ = _param_list;
					_tmp42_ = vala_list_get (_tmp41_, _param_index);
					param = (ValaParameter*) _tmp42_;
					_tmp43_ = iter;
					_vala_assert (vala_iterator_next (_tmp43_), "iter.next ()");
					_tmp44_ = param;
					_tmp45_ = vala_symbol_get_name ((ValaSymbol*) _tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = iter;
					_tmp48_ = vala_iterator_get (_tmp47_);
					_tmp49_ = (ValaParameter*) _tmp48_;
					_tmp50_ = vala_symbol_get_name ((ValaSymbol*) _tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = g_strcmp0 (_tmp46_, _tmp51_) != 0;
					_vala_code_node_unref0 (_tmp49_);
					if (_tmp52_) {
						_vala_code_node_unref0 (invoker);
						invoker = NULL;
						_vala_code_node_unref0 (param);
						break;
					}
					_vala_code_node_unref0 (param);
				}
			}
			_tmp53_ = invoker;
			if (_tmp53_ != NULL) {
				result = n;
				_vala_iterator_unref0 (iter);
				_vala_code_node_unref0 (invoker);
				_g_free0 (prefix);
				_vala_code_node_unref0 (m);
				return result;
			}
			_vala_iterator_unref0 (iter);
			_vala_code_node_unref0 (invoker);
			_vala_gir_parser_node_unref0 (n);
		}
	}
	result = NULL;
	_g_free0 (prefix);
	_vala_code_node_unref0 (m);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_get_current_metadata (ValaGirParser* self)
{
	gchar* selector = NULL;
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* child_name = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	const gchar* _tmp13_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	ValaGirParserMetadata* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ValaGirParserMetadata* _tmp29_;
	ValaGirParserMetadata* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	selector = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "name");
	child_name = _tmp5_;
	_tmp6_ = child_name;
	if (_tmp6_ == NULL) {
		ValaMarkupReader* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = self->priv->reader;
		_tmp8_ = vala_markup_reader_get_attribute (_tmp7_, "glib:name");
		_g_free0 (child_name);
		child_name = _tmp8_;
	}
	_tmp10_ = selector;
	if (g_strcmp0 (_tmp10_, "union") == 0) {
		const gchar* _tmp11_;
		_tmp11_ = child_name;
		_tmp9_ = _tmp11_ == NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("union");
		_g_free0 (child_name);
		child_name = _tmp12_;
	}
	_tmp13_ = child_name;
	if (_tmp13_ == NULL) {
		ValaGirParserMetadata* _tmp14_;
		ValaGirParserMetadata* _tmp15_;
		ValaGirParserMetadata* _tmp16_;
		_tmp14_ = vala_gir_parser_metadata_get_empty ();
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_gir_parser_metadata_ref0 (_tmp15_);
		result = _tmp16_;
		_g_free0 (child_name);
		_g_free0 (selector);
		return result;
	}
	_tmp17_ = selector;
	_tmp18_ = string_replace (_tmp17_, "-", "_");
	_g_free0 (selector);
	selector = _tmp18_;
	_tmp19_ = child_name;
	_tmp20_ = string_replace (_tmp19_, "-", "_");
	_g_free0 (child_name);
	child_name = _tmp20_;
	_tmp21_ = selector;
	if (g_str_has_prefix (_tmp21_, "glib:")) {
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_;
		_tmp22_ = selector;
		_tmp23_ = strlen ("glib:");
		_tmp24_ = _tmp23_;
		_tmp25_ = string_substring (_tmp22_, (glong) _tmp24_, (glong) -1);
		_g_free0 (selector);
		selector = _tmp25_;
	}
	_tmp26_ = self->priv->metadata;
	_tmp27_ = child_name;
	_tmp28_ = selector;
	_tmp29_ = vala_gir_parser_metadata_match_child (_tmp26_, _tmp27_, _tmp28_);
	result = _tmp29_;
	_g_free0 (child_name);
	_g_free0 (selector);
	return result;
}

static gboolean
vala_gir_parser_push_metadata (ValaGirParser* self)
{
	ValaGirParserMetadata* new_metadata = NULL;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaArrayList* _tmp11_;
	ValaGirParserMetadata* _tmp12_;
	ValaGirParserMetadata* _tmp13_;
	ValaGirParserMetadata* _tmp14_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_gir_parser_get_current_metadata (self);
	new_metadata = _tmp0_;
	_tmp1_ = new_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP)) {
		ValaGirParserMetadata* _tmp2_;
		_tmp2_ = new_metadata;
		if (vala_gir_parser_metadata_get_bool (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP, FALSE)) {
			result = FALSE;
			_vala_gir_parser_metadata_unref0 (new_metadata);
			return result;
		}
	} else {
		gboolean _tmp3_ = FALSE;
		ValaMarkupReader* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = self->priv->reader;
		_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "introspectable");
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "0") == 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			_tmp3_ = TRUE;
		} else {
			ValaMarkupReader* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = self->priv->reader;
			_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "private");
			_tmp10_ = _tmp9_;
			_tmp3_ = g_strcmp0 (_tmp10_, "1") == 0;
			_g_free0 (_tmp10_);
		}
		if (_tmp3_) {
			result = FALSE;
			_vala_gir_parser_metadata_unref0 (new_metadata);
			return result;
		}
	}
	_tmp11_ = self->priv->metadata_stack;
	_tmp12_ = self->priv->metadata;
	vala_collection_add ((ValaCollection*) _tmp11_, _tmp12_);
	_tmp13_ = new_metadata;
	_tmp14_ = _vala_gir_parser_metadata_ref0 (_tmp13_);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp14_;
	result = TRUE;
	_vala_gir_parser_metadata_unref0 (new_metadata);
	return result;
}

static void
vala_gir_parser_pop_metadata (ValaGirParser* self)
{
	ValaArrayList* _tmp0_;
	ValaArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->metadata_stack;
	_tmp1_ = self->priv->metadata_stack;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_list_remove_at ((ValaList*) _tmp0_, _tmp3_ - 1);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = (ValaGirParserMetadata*) _tmp4_;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
vala_gir_parser_parse_type_arguments_from_string (ValaGirParser* self,
                                                  ValaDataType* parent_type,
                                                  const gchar* type_arguments,
                                                  ValaSourceReference* source_reference)
{
	gint type_arguments_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	GString* current = NULL;
	GString* _tmp2_;
	gint depth = 0;
	ValaDataType* dt = NULL;
	GString* _tmp19_;
	const gchar* _tmp20_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parent_type != NULL, FALSE);
	g_return_val_if_fail (type_arguments != NULL, FALSE);
	_tmp0_ = strlen (type_arguments);
	_tmp1_ = _tmp0_;
	type_arguments_length = (gint) _tmp1_;
	_tmp2_ = g_string_sized_new ((gsize) type_arguments_length);
	current = _tmp2_;
	depth = 0;
	{
		gint c = 0;
		c = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = c;
					c = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(c < type_arguments_length)) {
					break;
				}
				if (string_get (type_arguments, (glong) c) == '<') {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = string_get (type_arguments, (glong) c) == '[';
				}
				if (_tmp5_) {
					gint _tmp6_;
					GString* _tmp7_;
					_tmp6_ = depth;
					depth = _tmp6_ + 1;
					_tmp7_ = current;
					g_string_append_unichar (_tmp7_, (gunichar) string_get (type_arguments, (glong) c));
				} else {
					gboolean _tmp8_ = FALSE;
					if (string_get (type_arguments, (glong) c) == '>') {
						_tmp8_ = TRUE;
					} else {
						_tmp8_ = string_get (type_arguments, (glong) c) == ']';
					}
					if (_tmp8_) {
						gint _tmp9_;
						GString* _tmp10_;
						_tmp9_ = depth;
						depth = _tmp9_ - 1;
						_tmp10_ = current;
						g_string_append_unichar (_tmp10_, (gunichar) string_get (type_arguments, (glong) c));
					} else {
						if (string_get (type_arguments, (glong) c) == ',') {
							if (depth == 0) {
								ValaDataType* dt = NULL;
								GString* _tmp11_;
								const gchar* _tmp12_;
								ValaDataType* _tmp13_;
								ValaDataType* _tmp14_;
								ValaDataType* _tmp15_;
								GString* _tmp16_;
								_tmp11_ = current;
								_tmp12_ = _tmp11_->str;
								_tmp13_ = vala_gir_parser_parse_type_from_string (self, _tmp12_, TRUE, source_reference);
								dt = _tmp13_;
								_tmp14_ = dt;
								if (_tmp14_ == NULL) {
									result = FALSE;
									_vala_code_node_unref0 (dt);
									_g_string_free0 (current);
									return result;
								}
								_tmp15_ = dt;
								vala_data_type_add_type_argument (parent_type, _tmp15_);
								_tmp16_ = current;
								g_string_truncate (_tmp16_, (gsize) 0);
								_vala_code_node_unref0 (dt);
							} else {
								GString* _tmp17_;
								_tmp17_ = current;
								g_string_append_unichar (_tmp17_, (gunichar) string_get (type_arguments, (glong) c));
							}
						} else {
							GString* _tmp18_;
							_tmp18_ = current;
							g_string_append_unichar (_tmp18_, (gunichar) string_get (type_arguments, (glong) c));
						}
					}
				}
			}
		}
	}
	_tmp19_ = current;
	_tmp20_ = _tmp19_->str;
	_tmp21_ = vala_gir_parser_parse_type_from_string (self, _tmp20_, TRUE, source_reference);
	dt = _tmp21_;
	_tmp22_ = dt;
	if (_tmp22_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (dt);
		_g_string_free0 (current);
		return result;
	}
	_tmp23_ = dt;
	vala_data_type_add_type_argument (parent_type, _tmp23_);
	result = TRUE;
	_vala_code_node_unref0 (dt);
	_g_string_free0 (current);
	return result;
}

static ValaDataType*
vala_gir_parser_parse_type_from_string (ValaGirParser* self,
                                        const gchar* type_string,
                                        gboolean owned_by_default,
                                        ValaSourceReference* source_reference)
{
	GRegex* _tmp0_;
	GMatchInfo* match = NULL;
	GRegex* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	ValaDataType* type = NULL;
	gchar* ownership_data = NULL;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_;
	gchar* type_name = NULL;
	GMatchInfo* _tmp10_;
	gchar* _tmp11_;
	gchar* type_arguments_data = NULL;
	GMatchInfo* _tmp12_;
	gchar* _tmp13_;
	gchar* pointers_data = NULL;
	GMatchInfo* _tmp14_;
	gchar* _tmp15_;
	gchar* array_data = NULL;
	GMatchInfo* _tmp16_;
	gchar* _tmp17_;
	gchar* nullable_data = NULL;
	GMatchInfo* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	gboolean nullable = FALSE;
	gboolean _tmp25_ = FALSE;
	const gchar* _tmp26_;
	gboolean value_owned = FALSE;
	const gchar* _tmp39_;
	ValaUnresolvedSymbol* sym = NULL;
	const gchar* _tmp41_;
	ValaUnresolvedSymbol* _tmp42_;
	ValaUnresolvedSymbol* _tmp43_;
	ValaUnresolvedSymbol* _tmp44_;
	ValaUnresolvedType* _tmp45_;
	gboolean _tmp46_ = FALSE;
	const gchar* _tmp47_;
	const gchar* _tmp53_;
	gboolean _tmp61_ = FALSE;
	const gchar* _tmp62_;
	ValaDataType* _tmp72_;
	ValaDataType* _tmp73_;
	GError* _inner_error0_ = NULL;
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_string != NULL, NULL);
	_tmp0_ = vala_gir_parser_type_from_string_regex;
	if (_tmp0_ == NULL) {
		{
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp3_;
			_tmp2_ = g_regex_new ("^(?:(owned|unowned|weak) +)?([0-9a-zA-Z_\\.]+)(?:<(.+)>)?(\\*+)?(\\[,*" \
"\\])?(\\?)?$", (G_REGEX_ANCHORED | G_REGEX_DOLLAR_ENDONLY) | G_REGEX_OPTIMIZE, 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (vala_gir_parser_type_from_string_regex);
			vala_gir_parser_type_from_string_regex = _tmp3_;
			_g_regex_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			GError* e = NULL;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e->message;
			g_error ("valagirparser.vala:1826: Unable to compile regex: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = vala_gir_parser_type_from_string_regex;
	_tmp7_ = g_regex_match (_tmp5_, type_string, 0, &_tmp6_);
	_g_match_info_unref0 (match);
	match = _tmp6_;
	if (!_tmp7_) {
		vala_report_error (source_reference, "unable to parse type");
		result = NULL;
		_g_match_info_unref0 (match);
		return result;
	}
	type = NULL;
	_tmp8_ = match;
	_tmp9_ = g_match_info_fetch (_tmp8_, 1);
	ownership_data = _tmp9_;
	_tmp10_ = match;
	_tmp11_ = g_match_info_fetch (_tmp10_, 2);
	type_name = _tmp11_;
	_tmp12_ = match;
	_tmp13_ = g_match_info_fetch (_tmp12_, 3);
	type_arguments_data = _tmp13_;
	_tmp14_ = match;
	_tmp15_ = g_match_info_fetch (_tmp14_, 4);
	pointers_data = _tmp15_;
	_tmp16_ = match;
	_tmp17_ = g_match_info_fetch (_tmp16_, 5);
	array_data = _tmp17_;
	_tmp18_ = match;
	_tmp19_ = g_match_info_fetch (_tmp18_, 6);
	nullable_data = _tmp19_;
	_tmp21_ = nullable_data;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		_tmp22_ = nullable_data;
		_tmp23_ = strlen (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp20_ = _tmp24_ > 0;
	} else {
		_tmp20_ = FALSE;
	}
	nullable = _tmp20_;
	_tmp26_ = ownership_data;
	if (_tmp26_ == NULL) {
		const gchar* _tmp27_;
		_tmp27_ = type_name;
		_tmp25_ = g_strcmp0 (_tmp27_, "void") == 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_;
		_tmp29_ = array_data;
		if (_tmp29_ == NULL) {
			_tmp28_ = !nullable;
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaVoidType* _tmp30_;
			const gchar* _tmp31_;
			_tmp30_ = vala_void_type_new (source_reference);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp30_;
			_tmp31_ = pointers_data;
			if (_tmp31_ != NULL) {
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp32_ = FALSE;
						_tmp32_ = TRUE;
						while (TRUE) {
							const gchar* _tmp34_;
							gint _tmp35_;
							gint _tmp36_;
							ValaDataType* _tmp37_;
							ValaPointerType* _tmp38_;
							if (!_tmp32_) {
								gint _tmp33_;
								_tmp33_ = i;
								i = _tmp33_ + 1;
							}
							_tmp32_ = FALSE;
							_tmp34_ = pointers_data;
							_tmp35_ = strlen (_tmp34_);
							_tmp36_ = _tmp35_;
							if (!(i < _tmp36_)) {
								break;
							}
							_tmp37_ = type;
							_tmp38_ = vala_pointer_type_new (_tmp37_, NULL);
							_vala_code_node_unref0 (type);
							type = (ValaDataType*) _tmp38_;
						}
					}
				}
			}
			result = type;
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_g_match_info_unref0 (match);
			return result;
		} else {
			vala_report_error (source_reference, "invalid void type");
			result = NULL;
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	value_owned = owned_by_default;
	_tmp39_ = ownership_data;
	if (g_strcmp0 (_tmp39_, "owned") == 0) {
		if (owned_by_default) {
			vala_report_error (source_reference, "unexpected `owned' keyword");
		} else {
			value_owned = TRUE;
		}
	} else {
		const gchar* _tmp40_;
		_tmp40_ = ownership_data;
		if (g_strcmp0 (_tmp40_, "unowned") == 0) {
			if (owned_by_default) {
				value_owned = FALSE;
			} else {
				vala_report_error (source_reference, "unexpected `unowned' keyword");
				result = NULL;
				_g_free0 (nullable_data);
				_g_free0 (array_data);
				_g_free0 (pointers_data);
				_g_free0 (type_arguments_data);
				_g_free0 (type_name);
				_g_free0 (ownership_data);
				_vala_code_node_unref0 (type);
				_g_match_info_unref0 (match);
				return result;
			}
		}
	}
	_tmp41_ = type_name;
	_tmp42_ = vala_gir_parser_parse_symbol_from_string (self, _tmp41_, source_reference);
	sym = _tmp42_;
	_tmp43_ = sym;
	if (_tmp43_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (sym);
		_g_free0 (nullable_data);
		_g_free0 (array_data);
		_g_free0 (pointers_data);
		_g_free0 (type_arguments_data);
		_g_free0 (type_name);
		_g_free0 (ownership_data);
		_vala_code_node_unref0 (type);
		_g_match_info_unref0 (match);
		return result;
	}
	_tmp44_ = sym;
	_tmp45_ = vala_unresolved_type_new_from_symbol (_tmp44_, source_reference);
	_vala_code_node_unref0 (type);
	type = (ValaDataType*) _tmp45_;
	_tmp47_ = type_arguments_data;
	if (_tmp47_ != NULL) {
		const gchar* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		_tmp48_ = type_arguments_data;
		_tmp49_ = strlen (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp46_ = _tmp50_ > 0;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		ValaDataType* _tmp51_;
		const gchar* _tmp52_;
		_tmp51_ = type;
		_tmp52_ = type_arguments_data;
		if (!vala_gir_parser_parse_type_arguments_from_string (self, _tmp51_, _tmp52_, source_reference)) {
			result = NULL;
			_vala_code_node_unref0 (sym);
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	_tmp53_ = pointers_data;
	if (_tmp53_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp54_ = FALSE;
				_tmp54_ = TRUE;
				while (TRUE) {
					const gchar* _tmp56_;
					gint _tmp57_;
					gint _tmp58_;
					ValaDataType* _tmp59_;
					ValaPointerType* _tmp60_;
					if (!_tmp54_) {
						gint _tmp55_;
						_tmp55_ = i;
						i = _tmp55_ + 1;
					}
					_tmp54_ = FALSE;
					_tmp56_ = pointers_data;
					_tmp57_ = strlen (_tmp56_);
					_tmp58_ = _tmp57_;
					if (!(i < _tmp58_)) {
						break;
					}
					_tmp59_ = type;
					_tmp60_ = vala_pointer_type_new (_tmp59_, NULL);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp60_;
				}
			}
		}
	}
	_tmp62_ = array_data;
	if (_tmp62_ != NULL) {
		const gchar* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		_tmp63_ = array_data;
		_tmp64_ = strlen (_tmp63_);
		_tmp65_ = _tmp64_;
		_tmp61_ = _tmp65_ != 0;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		const gchar* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		ValaArrayType* _tmp71_;
		_tmp66_ = type;
		vala_data_type_set_value_owned (_tmp66_, TRUE);
		_tmp67_ = type;
		_tmp68_ = array_data;
		_tmp69_ = strlen (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_array_type_new (_tmp67_, ((gint) _tmp70_) - 1, source_reference);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp71_;
	}
	_tmp72_ = type;
	vala_data_type_set_nullable (_tmp72_, nullable);
	_tmp73_ = type;
	vala_data_type_set_value_owned (_tmp73_, value_owned);
	result = type;
	_vala_code_node_unref0 (sym);
	_g_free0 (nullable_data);
	_g_free0 (array_data);
	_g_free0 (pointers_data);
	_g_free0 (type_arguments_data);
	_g_free0 (type_name);
	_g_free0 (ownership_data);
	_g_match_info_unref0 (match);
	return result;
}

static gchar*
vala_gir_parser_element_get_string (ValaGirParser* self,
                                    const gchar* attribute_name,
                                    ValaGirParserArgumentType arg_type)
{
	ValaGirParserMetadata* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attribute_name != NULL, NULL);
	_tmp0_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp0_, arg_type)) {
		ValaGirParserMetadata* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->metadata;
		_tmp2_ = vala_gir_parser_metadata_get_string (_tmp1_, arg_type);
		result = _tmp2_;
		return result;
	} else {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, attribute_name);
		result = _tmp4_;
		return result;
	}
}

static ValaDataType*
vala_gir_parser_element_get_type (ValaGirParser* self,
                                  ValaDataType* orig_type,
                                  gboolean owned_by_default,
                                  gboolean* no_array_length,
                                  gboolean* array_null_terminated,
                                  gboolean* changed)
{
	gboolean _vala_changed = FALSE;
	ValaDataType* type = NULL;
	ValaDataType* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaDataType* _tmp43_;
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (orig_type != NULL, NULL);
	_vala_changed = FALSE;
	_tmp0_ = _vala_code_node_ref0 (orig_type);
	type = _tmp0_;
	_tmp1_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE)) {
		ValaGirParserMetadata* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ValaGirParserMetadata* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp2_ = self->priv->metadata;
		_tmp3_ = vala_gir_parser_metadata_get_string (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->metadata;
		_tmp6_ = vala_gir_parser_metadata_get_source_reference (_tmp5_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_gir_parser_parse_type_from_string (self, _tmp4_, owned_by_default, _tmp7_);
		_vala_code_node_unref0 (type);
		type = _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_g_free0 (_tmp4_);
		_vala_changed = TRUE;
	} else {
		ValaDataType* _tmp9_;
		_tmp9_ = type;
		if (!VALA_IS_VOID_TYPE (_tmp9_)) {
			ValaGirParserMetadata* _tmp10_;
			gboolean _tmp19_ = FALSE;
			ValaDataType* _tmp20_;
			ValaDataType* _tmp38_;
			ValaGirParserMetadata* _tmp39_;
			ValaDataType* _tmp40_;
			gboolean _tmp41_;
			gboolean _tmp42_;
			_tmp10_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp10_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS)) {
				ValaDataType* _tmp11_;
				ValaDataType* _tmp12_;
				ValaGirParserMetadata* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				ValaGirParserMetadata* _tmp16_;
				ValaSourceReference* _tmp17_;
				ValaSourceReference* _tmp18_;
				_tmp11_ = type;
				vala_data_type_remove_all_type_arguments (_tmp11_);
				_tmp12_ = type;
				_tmp13_ = self->priv->metadata;
				_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS);
				_tmp15_ = _tmp14_;
				_tmp16_ = self->priv->metadata;
				_tmp17_ = vala_gir_parser_metadata_get_source_reference (_tmp16_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS);
				_tmp18_ = _tmp17_;
				vala_gir_parser_parse_type_arguments_from_string (self, _tmp12_, _tmp15_, _tmp18_);
				_vala_source_reference_unref0 (_tmp18_);
				_g_free0 (_tmp15_);
			}
			_tmp20_ = type;
			if (!VALA_IS_ARRAY_TYPE (_tmp20_)) {
				ValaGirParserMetadata* _tmp21_;
				_tmp21_ = self->priv->metadata;
				_tmp19_ = vala_gir_parser_metadata_get_bool (_tmp21_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY, FALSE);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				ValaDataType* _tmp22_;
				ValaDataType* _tmp23_;
				ValaDataType* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				ValaArrayType* _tmp27_;
				_tmp22_ = type;
				vala_data_type_set_value_owned (_tmp22_, TRUE);
				_tmp23_ = type;
				_tmp24_ = type;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_array_type_new (_tmp23_, 1, _tmp26_);
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp27_;
				_vala_changed = TRUE;
			}
			if (owned_by_default) {
				ValaDataType* _tmp28_;
				ValaGirParserMetadata* _tmp29_;
				ValaDataType* _tmp30_;
				gboolean _tmp31_;
				gboolean _tmp32_;
				_tmp28_ = type;
				_tmp29_ = self->priv->metadata;
				_tmp30_ = type;
				_tmp31_ = vala_data_type_get_value_owned (_tmp30_);
				_tmp32_ = _tmp31_;
				vala_data_type_set_value_owned (_tmp28_, !vala_gir_parser_metadata_get_bool (_tmp29_, VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED, !_tmp32_));
			} else {
				ValaDataType* _tmp33_;
				ValaGirParserMetadata* _tmp34_;
				ValaDataType* _tmp35_;
				gboolean _tmp36_;
				gboolean _tmp37_;
				_tmp33_ = type;
				_tmp34_ = self->priv->metadata;
				_tmp35_ = type;
				_tmp36_ = vala_data_type_get_value_owned (_tmp35_);
				_tmp37_ = _tmp36_;
				vala_data_type_set_value_owned (_tmp33_, vala_gir_parser_metadata_get_bool (_tmp34_, VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED, _tmp37_));
			}
			_tmp38_ = type;
			_tmp39_ = self->priv->metadata;
			_tmp40_ = type;
			_tmp41_ = vala_data_type_get_nullable (_tmp40_);
			_tmp42_ = _tmp41_;
			vala_data_type_set_nullable (_tmp38_, vala_gir_parser_metadata_get_bool (_tmp39_, VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE, _tmp42_));
		}
	}
	_tmp43_ = type;
	if (VALA_IS_ARRAY_TYPE (_tmp43_)) {
		ValaGirParserMetadata* _tmp44_;
		if (!VALA_IS_ARRAY_TYPE (orig_type)) {
			*no_array_length = TRUE;
		}
		_tmp44_ = self->priv->metadata;
		*array_null_terminated = vala_gir_parser_metadata_get_bool (_tmp44_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED, *array_null_terminated);
	}
	result = type;
	if (changed) {
		*changed = _vala_changed;
	}
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
vala_gir_parser_element_get_name (ValaGirParser* self,
                                  const gchar* gir_name)
{
	const gchar* tag = NULL;
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* name = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* pattern = NULL;
	ValaGirParserMetadata* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	tag = _tmp2_;
	_tmp3_ = g_strdup (gir_name);
	name = _tmp3_;
	_tmp4_ = name;
	if (_tmp4_ == NULL) {
		ValaMarkupReader* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->priv->reader;
		_tmp6_ = vala_markup_reader_get_attribute (_tmp5_, "name");
		_g_free0 (name);
		name = _tmp6_;
	}
	_tmp7_ = self->priv->metadata;
	_tmp8_ = vala_gir_parser_metadata_get_string (_tmp7_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	pattern = _tmp8_;
	_tmp9_ = pattern;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		_tmp10_ = pattern;
		if (string_index_of_char (_tmp10_, (gunichar) '(', 0) < 0) {
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = pattern;
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (name);
			name = _tmp12_;
		} else {
			{
				gchar* replacement = NULL;
				gchar* _tmp13_;
				gchar** split = NULL;
				const gchar* _tmp14_;
				gchar** _tmp15_;
				gchar** _tmp16_;
				gint split_length1;
				gint _split_size_;
				gchar** _tmp17_;
				gint _tmp17__length1;
				GRegex* regex = NULL;
				const gchar* _tmp24_;
				GRegex* _tmp25_;
				gchar* _tmp26_ = NULL;
				GRegex* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp13_ = g_strdup ("\\1");
				replacement = _tmp13_;
				_tmp14_ = pattern;
				_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "/", 0);
				split = _tmp16_;
				split_length1 = _vala_array_length (_tmp15_);
				_split_size_ = split_length1;
				_tmp17_ = split;
				_tmp17__length1 = split_length1;
				if (_tmp17__length1 > 1) {
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp18_ = split;
					_tmp18__length1 = split_length1;
					_tmp19_ = _tmp18_[0];
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (pattern);
					pattern = _tmp20_;
					_tmp21_ = split;
					_tmp21__length1 = split_length1;
					_tmp22_ = _tmp21_[1];
					_tmp23_ = g_strdup (_tmp22_);
					_g_free0 (replacement);
					replacement = _tmp23_;
				}
				_tmp24_ = pattern;
				_tmp25_ = g_regex_new (_tmp24_, G_REGEX_ANCHORED, G_REGEX_MATCH_ANCHORED, &_inner_error0_);
				regex = _tmp25_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (replacement);
					goto __catch0_g_error;
				}
				_tmp27_ = regex;
				_tmp28_ = name;
				_tmp29_ = replacement;
				_tmp30_ = g_regex_replace (_tmp27_, _tmp28_, (gssize) -1, 0, _tmp29_, 0, &_inner_error0_);
				_tmp26_ = _tmp30_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_regex_unref0 (regex);
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (replacement);
					goto __catch0_g_error;
				}
				_tmp31_ = _tmp26_;
				_tmp26_ = NULL;
				_g_free0 (name);
				name = _tmp31_;
				_g_free0 (_tmp26_);
				_g_regex_unref0 (regex);
				split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (replacement);
			}
			goto __finally0;
			__catch0_g_error:
			{
				const gchar* _tmp32_;
				gchar* _tmp33_;
				g_clear_error (&_inner_error0_);
				_tmp32_ = pattern;
				_tmp33_ = g_strdup (_tmp32_);
				_g_free0 (name);
				name = _tmp33_;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (pattern);
				_g_free0 (name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		const gchar* _tmp34_;
		_tmp34_ = tag;
		if (g_strcmp0 (_tmp34_, "enumeration") == 0) {
			gboolean _tmp35_ = FALSE;
			const gchar* _tmp36_;
			_tmp36_ = name;
			if (_tmp36_ != NULL) {
				const gchar* _tmp37_;
				_tmp37_ = name;
				_tmp35_ = g_str_has_suffix (_tmp37_, "Enum");
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				gchar* _tmp44_;
				_tmp38_ = name;
				_tmp39_ = name;
				_tmp40_ = strlen (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = strlen ("Enum");
				_tmp43_ = _tmp42_;
				_tmp44_ = string_substring (_tmp38_, (glong) 0, (glong) (_tmp41_ - _tmp43_));
				_g_free0 (name);
				name = _tmp44_;
			}
		}
	}
	result = name;
	_g_free0 (pattern);
	return result;
}

static gchar*
vala_gir_parser_element_get_type_id (ValaGirParser* self)
{
	gchar* type_id = NULL;
	ValaGirParserMetadata* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaMarkupReader* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->metadata;
	_tmp1_ = vala_gir_parser_metadata_get_string (_tmp0_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID);
	type_id = _tmp1_;
	_tmp2_ = type_id;
	if (_tmp2_ != NULL) {
		result = type_id;
		return result;
	}
	_tmp3_ = self->priv->reader;
	_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:get-type");
	_g_free0 (type_id);
	type_id = _tmp4_;
	_tmp5_ = type_id;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = type_id;
		_tmp7_ = g_strconcat (_tmp6_, " ()", NULL);
		_g_free0 (type_id);
		type_id = _tmp7_;
	}
	result = type_id;
	return result;
}

static void
vala_gir_parser_set_array_ccode (ValaGirParser* self,
                                 ValaSymbol* sym,
                                 ValaGirParserParameterInfo* info)
{
	gchar* type_name = NULL;
	ValaParameter* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (info != NULL);
	vala_code_node_set_attribute_double ((ValaCodeNode*) sym, "CCode", "array_length_pos", (gdouble) info->vala_idx, NULL);
	if (VALA_IS_PARAMETER (sym)) {
		ValaParameter* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = info->param;
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) _tmp0_);
		_tmp2_ = _tmp1_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "array_length_cname", _tmp2_, NULL);
	}
	_tmp3_ = info->param;
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_data_type_to_qualified_string (_tmp5_, NULL);
	type_name = _tmp6_;
	_tmp7_ = type_name;
	if (g_strcmp0 (_tmp7_, "int") != 0) {
		ValaGirParserNode* st = NULL;
		ValaGirParserNode* _tmp8_;
		const gchar* _tmp9_;
		ValaGirParserNode* _tmp10_;
		ValaGirParserNode* _tmp11_;
		_tmp8_ = self->priv->root;
		_tmp9_ = type_name;
		_tmp10_ = vala_gir_parser_node_lookup (_tmp8_, _tmp9_, FALSE, NULL);
		st = _tmp10_;
		_tmp11_ = st;
		if (_tmp11_ != NULL) {
			gboolean _tmp12_ = FALSE;
			if (VALA_IS_CALLABLE (sym)) {
				_tmp12_ = TRUE;
			} else {
				_tmp12_ = VALA_IS_PARAMETER (sym);
			}
			if (_tmp12_) {
				ValaGirParserNode* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = st;
				_tmp14_ = vala_gir_parser_node_get_cname (_tmp13_);
				_tmp15_ = _tmp14_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "array_length_type", _tmp15_, NULL);
				_g_free0 (_tmp15_);
			}
		}
		_vala_gir_parser_node_unref0 (st);
	}
	_g_free0 (type_name);
}

static void
vala_gir_parser_set_type_id_ccode (ValaGirParser* self,
                                   ValaSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	gchar* type_id = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) sym, "CCode", "has_type_id")) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) sym, "CCode", "type_id");
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_parser_element_get_type_id (self);
	type_id = _tmp1_;
	_tmp2_ = type_id;
	if (_tmp2_ == NULL) {
		vala_code_node_set_attribute_bool ((ValaCodeNode*) sym, "CCode", "has_type_id", FALSE, NULL);
	} else {
		const gchar* _tmp3_;
		_tmp3_ = type_id;
		vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "type_id", _tmp3_, NULL);
	}
	_g_free0 (type_id);
}

static void
vala_gir_parser_parse_repository (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "repository");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "version");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, VALA_GIR_PARSER_GIR_VERSION) != 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMarkupReader* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp4_ = vala_gir_parser_get_current_src (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->reader;
		_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "version");
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp5_, "unsupported GIR version %s (supported: %s)", _tmp8_, VALA_GIR_PARSER_GIR_VERSION);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp5_);
		return;
	}
	vala_gir_parser_next (self);
	while (TRUE) {
		ValaMarkupReader* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp9_ = self->priv->reader;
		_tmp10_ = vala_markup_reader_get_name (_tmp9_);
		_tmp11_ = _tmp10_;
		if (g_strcmp0 (_tmp11_, "namespace") == 0) {
			vala_gir_parser_parse_namespace (self);
		} else {
			ValaMarkupReader* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = self->priv->reader;
			_tmp13_ = vala_markup_reader_get_name (_tmp12_);
			_tmp14_ = _tmp13_;
			if (g_strcmp0 (_tmp14_, "include") == 0) {
				vala_gir_parser_parse_include (self);
			} else {
				ValaMarkupReader* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = self->priv->reader;
				_tmp16_ = vala_markup_reader_get_name (_tmp15_);
				_tmp17_ = _tmp16_;
				if (g_strcmp0 (_tmp17_, "package") == 0) {
					gchar* pkg = NULL;
					gchar* _tmp18_;
					ValaSourceFile* _tmp19_;
					const gchar* _tmp20_;
					ValaCodeContext* _tmp21_;
					const gchar* _tmp22_;
					_tmp18_ = vala_gir_parser_parse_package (self);
					pkg = _tmp18_;
					_tmp19_ = self->priv->current_source_file;
					_tmp20_ = pkg;
					vala_source_file_set_package_name (_tmp19_, _tmp20_);
					_tmp21_ = self->priv->context;
					_tmp22_ = pkg;
					if (vala_code_context_has_package (_tmp21_, _tmp22_)) {
						ValaSourceFile* _tmp23_;
						gboolean _tmp24_;
						gboolean _tmp25_;
						_tmp23_ = self->priv->current_source_file;
						_tmp24_ = vala_source_file_get_from_commandline (_tmp23_);
						_tmp25_ = _tmp24_;
						if (!_tmp25_) {
							_g_free0 (pkg);
							return;
						}
					} else {
						ValaCodeContext* _tmp26_;
						const gchar* _tmp27_;
						_tmp26_ = self->priv->context;
						_tmp27_ = pkg;
						vala_code_context_add_package (_tmp26_, _tmp27_);
					}
					_g_free0 (pkg);
				} else {
					ValaMarkupReader* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					_tmp28_ = self->priv->reader;
					_tmp29_ = vala_markup_reader_get_name (_tmp28_);
					_tmp30_ = _tmp29_;
					if (g_strcmp0 (_tmp30_, "c:include") == 0) {
						vala_gir_parser_parse_c_include (self);
					} else {
						ValaSourceReference* _tmp31_;
						ValaSourceReference* _tmp32_;
						ValaMarkupReader* _tmp33_;
						const gchar* _tmp34_;
						const gchar* _tmp35_;
						_tmp31_ = vala_gir_parser_get_current_src (self);
						_tmp32_ = _tmp31_;
						_tmp33_ = self->priv->reader;
						_tmp34_ = vala_markup_reader_get_name (_tmp33_);
						_tmp35_ = _tmp34_;
						vala_report_error (_tmp32_, "unknown child element `%s' in `repository'", _tmp35_);
						_vala_source_reference_unref0 (_tmp32_);
						vala_gir_parser_skip_element (self);
					}
				}
			}
		}
	}
	vala_gir_parser_end_element (self, "repository");
}

static void
vala_gir_parser_parse_include (ValaGirParser* self)
{
	gchar* pkg = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* version = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCodeContext* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "include");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	pkg = _tmp1_;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "version");
	version = _tmp3_;
	_tmp4_ = version;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = pkg;
		_tmp6_ = version;
		_tmp7_ = g_strdup_printf ("%s-%s", _tmp5_, _tmp6_);
		_g_free0 (pkg);
		pkg = _tmp7_;
	}
	_tmp8_ = self->priv->context;
	_tmp9_ = pkg;
	vala_code_context_add_external_package (_tmp8_, _tmp9_);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "include");
	_g_free0 (version);
	_g_free0 (pkg);
}

static gchar*
vala_gir_parser_parse_package (ValaGirParser* self)
{
	gchar* pkg = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "package");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	pkg = _tmp1_;
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "package");
	result = pkg;
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
vala_gir_parser_parse_c_include (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "c:include");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	_vala_array_add2 (&self->priv->cheader_filenames, &self->priv->cheader_filenames_length1, &self->priv->_cheader_filenames_size_, _tmp1_);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "c:include");
}

static void
vala_gir_parser_skip_element (ValaGirParser* self)
{
	gint level = 0;
	g_return_if_fail (self != NULL);
	vala_gir_parser_next (self);
	level = 1;
	while (TRUE) {
		if (!(level > 0)) {
			break;
		}
		if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
			gint _tmp0_;
			_tmp0_ = level;
			level = _tmp0_ + 1;
		} else {
			if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
				gint _tmp1_;
				_tmp1_ = level;
				level = _tmp1_ - 1;
			} else {
				if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_EOF) {
					ValaSourceReference* _tmp2_;
					ValaSourceReference* _tmp3_;
					_tmp2_ = vala_gir_parser_get_current_src (self);
					_tmp3_ = _tmp2_;
					vala_report_error (_tmp3_, "unexpected end of file");
					_vala_source_reference_unref0 (_tmp3_);
					break;
				}
			}
		}
		vala_gir_parser_next (self);
	}
}

static ValaGirParserNode*
vala_gir_parser_resolve_node (ValaGirParser* self,
                              ValaGirParserNode* parent_scope,
                              ValaUnresolvedSymbol* unresolved_sym,
                              gboolean create_namespace)
{
	ValaUnresolvedSymbol* _tmp0_;
	ValaUnresolvedSymbol* _tmp1_;
	ValaGirParserNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent_scope != NULL, NULL);
	g_return_val_if_fail (unresolved_sym != NULL, NULL);
	_tmp0_ = vala_unresolved_symbol_get_inner (unresolved_sym);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValaGirParserNode* scope = NULL;
		ValaGirParserNode* _tmp2_;
		_tmp2_ = _vala_gir_parser_node_ref0 (parent_scope);
		scope = _tmp2_;
		while (TRUE) {
			ValaGirParserNode* _tmp3_;
			ValaGirParserNode* node = NULL;
			ValaGirParserNode* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaGirParserNode* _tmp9_;
			ValaGirParserNode* _tmp10_;
			ValaGirParserNode* _tmp11_;
			ValaGirParserNode* _tmp12_;
			ValaGirParserNode* _tmp13_;
			_tmp3_ = scope;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = scope;
			_tmp5_ = vala_symbol_get_name ((ValaSymbol*) unresolved_sym);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_sym);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_gir_parser_node_lookup (_tmp4_, _tmp6_, create_namespace, _tmp8_);
			node = _tmp9_;
			_tmp10_ = node;
			if (_tmp10_ != NULL) {
				result = node;
				_vala_gir_parser_node_unref0 (scope);
				return result;
			}
			_tmp11_ = scope;
			_tmp12_ = _tmp11_->parent;
			_tmp13_ = _vala_gir_parser_node_ref0 (_tmp12_);
			_vala_gir_parser_node_unref0 (scope);
			scope = _tmp13_;
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_gir_parser_node_unref0 (scope);
	} else {
		ValaGirParserNode* inner = NULL;
		ValaUnresolvedSymbol* _tmp14_;
		ValaUnresolvedSymbol* _tmp15_;
		ValaGirParserNode* _tmp16_;
		ValaGirParserNode* _tmp17_;
		_tmp14_ = vala_unresolved_symbol_get_inner (unresolved_sym);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_gir_parser_resolve_node (self, parent_scope, _tmp15_, create_namespace);
		inner = _tmp16_;
		_tmp17_ = inner;
		if (_tmp17_ != NULL) {
			ValaGirParserNode* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			ValaGirParserNode* _tmp23_;
			_tmp18_ = inner;
			_tmp19_ = vala_symbol_get_name ((ValaSymbol*) unresolved_sym);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_sym);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_gir_parser_node_lookup (_tmp18_, _tmp20_, create_namespace, _tmp22_);
			result = _tmp23_;
			_vala_gir_parser_node_unref0 (inner);
			return result;
		}
		_vala_gir_parser_node_unref0 (inner);
	}
	result = NULL;
	return result;
}

static ValaSymbol*
vala_gir_parser_resolve_symbol (ValaGirParser* self,
                                ValaGirParserNode* parent_scope,
                                ValaUnresolvedSymbol* unresolved_sym)
{
	ValaGirParserNode* node = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent_scope != NULL, NULL);
	g_return_val_if_fail (unresolved_sym != NULL, NULL);
	_tmp0_ = vala_gir_parser_resolve_node (self, parent_scope, unresolved_sym, FALSE);
	node = _tmp0_;
	_tmp1_ = node;
	if (_tmp1_ != NULL) {
		ValaGirParserNode* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp2_ = node;
		_tmp3_ = _tmp2_->symbol;
		_tmp4_ = _vala_code_node_ref0 (_tmp3_);
		result = _tmp4_;
		_vala_gir_parser_node_unref0 (node);
		return result;
	}
	result = NULL;
	_vala_gir_parser_node_unref0 (node);
	return result;
}

static void
vala_gir_parser_push_node (ValaGirParser* self,
                           const gchar* name,
                           gboolean merge)
{
	ValaGirParserNode* parent = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	ValaGirParserNode* node = NULL;
	ValaGirParserNode* _tmp14_;
	ValaGirParserNode* _tmp15_;
	gboolean _tmp16_ = FALSE;
	ValaGirParserNode* _tmp17_;
	ValaGirParserNode* _tmp27_;
	ValaMarkupReader* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	ValaGirParserNode* _tmp32_;
	ValaMarkupReader* _tmp33_;
	ValaMap* _tmp34_;
	ValaGirParserNode* _tmp35_;
	ValaGirParserMetadata* _tmp36_;
	ValaGirParserMetadata* _tmp37_;
	ValaGirParserNode* _tmp38_;
	ValaSourceReference* _tmp39_;
	gchar* gir_name = NULL;
	ValaGirParserNode* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_ = FALSE;
	ValaGirParserNode* _tmp43_;
	ValaGirParserNode* _tmp44_;
	ValaArrayList* _tmp52_;
	ValaGirParserNode* _tmp53_;
	ValaGirParserNode* _tmp54_;
	ValaGirParserNode* _tmp55_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _vala_gir_parser_node_ref0 (_tmp0_);
	parent = _tmp1_;
	_tmp2_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT)) {
		ValaUnresolvedSymbol* target = NULL;
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		ValaGirParserMetadata* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp10_;
		ValaGirParserNode* _tmp11_;
		ValaUnresolvedSymbol* _tmp12_;
		ValaGirParserNode* _tmp13_;
		_tmp3_ = self->priv->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->metadata;
		_tmp7_ = vala_gir_parser_metadata_get_source_reference (_tmp6_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_gir_parser_parse_symbol_from_string (self, _tmp5_, _tmp8_);
		_tmp10_ = _tmp9_;
		_vala_source_reference_unref0 (_tmp8_);
		_g_free0 (_tmp5_);
		target = _tmp10_;
		_tmp11_ = self->priv->root;
		_tmp12_ = target;
		_tmp13_ = vala_gir_parser_resolve_node (self, _tmp11_, _tmp12_, TRUE);
		_vala_gir_parser_node_unref0 (parent);
		parent = _tmp13_;
		_vala_code_node_unref0 (target);
	}
	_tmp14_ = parent;
	_tmp15_ = vala_gir_parser_node_lookup (_tmp14_, name, FALSE, NULL);
	node = _tmp15_;
	_tmp17_ = node;
	if (_tmp17_ == NULL) {
		_tmp16_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		ValaGirParserNode* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp19_ = node;
		_tmp20_ = _tmp19_->symbol;
		if (_tmp20_ != NULL) {
			_tmp18_ = !merge;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp16_ = _tmp18_;
	}
	if (_tmp16_) {
		ValaGirParserNode* _tmp21_;
		ValaGirParserNode* _tmp22_;
		ValaGirParserNode* _tmp23_;
		ValaGirParserNode* _tmp24_;
		_tmp21_ = vala_gir_parser_node_new (name);
		_vala_gir_parser_node_unref0 (node);
		node = _tmp21_;
		_tmp22_ = node;
		_tmp22_->new_symbol = TRUE;
		_tmp23_ = parent;
		_tmp24_ = node;
		vala_gir_parser_node_add_member (_tmp23_, _tmp24_);
	} else {
		ValaArrayList* _tmp25_;
		ValaGirParserNode* _tmp26_;
		_tmp25_ = vala_gir_parser_node_new_namespaces;
		_tmp26_ = node;
		vala_collection_remove ((ValaCollection*) _tmp25_, _tmp26_);
	}
	_tmp27_ = node;
	_tmp28_ = self->priv->reader;
	_tmp29_ = vala_markup_reader_get_name (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strdup (_tmp30_);
	_g_free0 (_tmp27_->element_type);
	_tmp27_->element_type = _tmp31_;
	_tmp32_ = node;
	_tmp33_ = self->priv->reader;
	_tmp34_ = vala_markup_reader_get_attributes (_tmp33_);
	_vala_map_unref0 (_tmp32_->girdata);
	_tmp32_->girdata = _tmp34_;
	_tmp35_ = node;
	_tmp36_ = self->priv->metadata;
	_tmp37_ = _vala_gir_parser_metadata_ref0 (_tmp36_);
	_vala_gir_parser_metadata_unref0 (_tmp35_->metadata);
	_tmp35_->metadata = _tmp37_;
	_tmp38_ = node;
	_tmp39_ = vala_gir_parser_get_current_src (self);
	_vala_source_reference_unref0 (_tmp38_->source_reference);
	_tmp38_->source_reference = _tmp39_;
	_tmp40_ = node;
	_tmp41_ = vala_gir_parser_node_get_gir_name (_tmp40_);
	gir_name = _tmp41_;
	_tmp43_ = parent;
	_tmp44_ = self->priv->current;
	if (_tmp43_ != _tmp44_) {
		_tmp42_ = TRUE;
	} else {
		const gchar* _tmp45_;
		_tmp45_ = gir_name;
		_tmp42_ = g_strcmp0 (_tmp45_, name) != 0;
	}
	if (_tmp42_) {
		const gchar* _tmp46_;
		ValaUnresolvedSymbol* _tmp47_;
		ValaUnresolvedSymbol* _tmp48_;
		ValaGirParserNode* _tmp49_;
		ValaUnresolvedSymbol* _tmp50_;
		ValaUnresolvedSymbol* _tmp51_;
		_tmp46_ = gir_name;
		_tmp47_ = vala_unresolved_symbol_new (NULL, _tmp46_, NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = node;
		_tmp50_ = vala_gir_parser_node_get_unresolved_symbol (_tmp49_);
		_tmp51_ = _tmp50_;
		vala_gir_parser_set_symbol_mapping (self, _tmp48_, (ValaSymbol*) _tmp51_);
		_vala_code_node_unref0 (_tmp51_);
		_vala_code_node_unref0 (_tmp48_);
	}
	_tmp52_ = self->priv->tree_stack;
	_tmp53_ = self->priv->current;
	vala_collection_add ((ValaCollection*) _tmp52_, _tmp53_);
	_tmp54_ = node;
	_tmp55_ = _vala_gir_parser_node_ref0 (_tmp54_);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = _tmp55_;
	_g_free0 (gir_name);
	_vala_gir_parser_node_unref0 (node);
	_vala_gir_parser_node_unref0 (parent);
}

static void
vala_gir_parser_pop_node (ValaGirParser* self)
{
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaArrayList* _tmp2_;
	ValaArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gpointer _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _vala_gir_parser_node_ref0 (_tmp0_);
	_vala_gir_parser_node_unref0 (self->priv->old_current);
	self->priv->old_current = _tmp1_;
	_tmp2_ = self->priv->tree_stack;
	_tmp3_ = self->priv->tree_stack;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_list_remove_at ((ValaList*) _tmp2_, _tmp5_ - 1);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = (ValaGirParserNode*) _tmp6_;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
_vala_code_node_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}

static inline void
_g_list_free__vala_code_node_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _vala_code_node_unref0_);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
vala_gir_parser_parse_namespace (ValaGirParser* self)
{
	gchar* cprefix = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* lower_case_cprefix = NULL;
	ValaMarkupReader* _tmp6_;
	gchar* _tmp7_;
	gchar* vala_namespace = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* gir_namespace = NULL;
	ValaMarkupReader* _tmp10_;
	gchar* _tmp11_;
	gchar* gir_version = NULL;
	ValaMarkupReader* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	ValaSet* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_;
	gchar* metadata_filename = NULL;
	ValaCodeContext* _tmp24_;
	ValaSourceFile* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_;
	ValaGirParserMetadata* ns_metadata = NULL;
	ValaGirParserMetadata* _tmp46_;
	const gchar* _tmp47_;
	ValaGirParserMetadata* _tmp48_;
	ValaGirParserMetadata* _tmp49_;
	const gchar* _tmp52_;
	ValaSourceFile* _tmp55_;
	const gchar* _tmp56_;
	ValaSourceFile* _tmp57_;
	const gchar* _tmp58_;
	ValaNamespace* ns = NULL;
	const gchar* _tmp59_;
	ValaGirParserNode* _tmp60_;
	ValaGirParserNode* _tmp75_;
	ValaGirParserMetadata* _tmp76_;
	ValaGirParserMetadata* _tmp77_;
	ValaGirParserMetadata* _tmp78_;
	ValaGirParserMetadata* _tmp81_;
	ValaNamespace* _tmp87_;
	const gchar* _tmp88_;
	ValaNamespace* _tmp89_;
	const gchar* _tmp90_;
	const gchar* _tmp91_;
	const gchar* _tmp101_;
	gchar** _tmp104_;
	gint _tmp104__length1;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "namespace");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:identifier-prefixes");
	cprefix = _tmp1_;
	_tmp2_ = cprefix;
	if (_tmp2_ != NULL) {
		gint idx = 0;
		const gchar* _tmp3_;
		_tmp3_ = cprefix;
		idx = string_index_of (_tmp3_, ",", 0);
		if (idx != -1) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = cprefix;
			_tmp5_ = string_substring (_tmp4_, (glong) 0, (glong) idx);
			_g_free0 (cprefix);
			cprefix = _tmp5_;
		}
	}
	_tmp6_ = self->priv->reader;
	_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "c:symbol-prefixes");
	lower_case_cprefix = _tmp7_;
	_tmp8_ = cprefix;
	_tmp9_ = g_strdup (_tmp8_);
	vala_namespace = _tmp9_;
	_tmp10_ = self->priv->reader;
	_tmp11_ = vala_markup_reader_get_attribute (_tmp10_, "name");
	gir_namespace = _tmp11_;
	_tmp12_ = self->priv->reader;
	_tmp13_ = vala_markup_reader_get_attribute (_tmp12_, "version");
	gir_version = _tmp13_;
	_tmp14_ = lower_case_cprefix;
	if (_tmp14_ != NULL) {
		gint idx = 0;
		const gchar* _tmp15_;
		_tmp15_ = lower_case_cprefix;
		idx = string_index_of (_tmp15_, ",", 0);
		if (idx != -1) {
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = lower_case_cprefix;
			_tmp17_ = string_substring (_tmp16_, (glong) 0, (glong) idx);
			_g_free0 (lower_case_cprefix);
			lower_case_cprefix = _tmp17_;
		}
	}
	_tmp18_ = self->priv->provided_namespaces;
	_tmp19_ = gir_namespace;
	_tmp20_ = gir_version;
	_tmp21_ = g_strdup_printf ("%s-%s", _tmp19_, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_collection_contains ((ValaCollection*) _tmp18_, _tmp22_);
	_g_free0 (_tmp22_);
	if (_tmp23_) {
		vala_gir_parser_skip_element (self);
		_g_free0 (gir_version);
		_g_free0 (gir_namespace);
		_g_free0 (vala_namespace);
		_g_free0 (lower_case_cprefix);
		_g_free0 (cprefix);
		return;
	}
	_tmp24_ = self->priv->context;
	_tmp25_ = self->priv->current_source_file;
	_tmp26_ = vala_source_file_get_filename (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_code_context_get_metadata_path (_tmp24_, _tmp27_);
	metadata_filename = _tmp28_;
	_tmp30_ = metadata_filename;
	if (_tmp30_ != NULL) {
		const gchar* _tmp31_;
		_tmp31_ = metadata_filename;
		_tmp29_ = g_file_test (_tmp31_, G_FILE_TEST_EXISTS);
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		ValaGirParserMetadataParser* metadata_parser = NULL;
		ValaGirParserMetadataParser* _tmp32_;
		ValaSourceFile* metadata_file = NULL;
		ValaCodeContext* _tmp33_;
		ValaSourceFile* _tmp34_;
		ValaSourceFileType _tmp35_;
		ValaSourceFileType _tmp36_;
		const gchar* _tmp37_;
		ValaSourceFile* _tmp38_;
		ValaCodeContext* _tmp39_;
		ValaSourceFile* _tmp40_;
		ValaGirParserMetadataParser* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaGirParserMetadata* _tmp43_;
		ValaArrayList* _tmp44_;
		ValaGirParserMetadata* _tmp45_;
		_tmp32_ = vala_gir_parser_metadata_parser_new ();
		metadata_parser = _tmp32_;
		_tmp33_ = self->priv->context;
		_tmp34_ = self->priv->current_source_file;
		_tmp35_ = vala_source_file_get_file_type (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = metadata_filename;
		_tmp38_ = vala_source_file_new (_tmp33_, _tmp36_, _tmp37_, NULL, FALSE);
		metadata_file = _tmp38_;
		_tmp39_ = self->priv->context;
		_tmp40_ = metadata_file;
		vala_code_context_add_source_file (_tmp39_, _tmp40_);
		_tmp41_ = metadata_parser;
		_tmp42_ = metadata_file;
		_tmp43_ = vala_gir_parser_metadata_parser_parse_metadata (_tmp41_, _tmp42_);
		_vala_gir_parser_metadata_unref0 (self->priv->metadata);
		self->priv->metadata = _tmp43_;
		_tmp44_ = self->priv->metadata_roots;
		_tmp45_ = self->priv->metadata;
		vala_collection_add ((ValaCollection*) _tmp44_, _tmp45_);
		_vala_source_file_unref0 (metadata_file);
		_vala_gir_parser_metadata_parser_unref0 (metadata_parser);
	}
	_tmp46_ = self->priv->metadata;
	_tmp47_ = gir_namespace;
	_tmp48_ = vala_gir_parser_metadata_match_child (_tmp46_, _tmp47_, NULL);
	ns_metadata = _tmp48_;
	_tmp49_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp49_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME)) {
		ValaGirParserMetadata* _tmp50_;
		gchar* _tmp51_;
		_tmp50_ = ns_metadata;
		_tmp51_ = vala_gir_parser_metadata_get_string (_tmp50_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
		_g_free0 (vala_namespace);
		vala_namespace = _tmp51_;
	}
	_tmp52_ = vala_namespace;
	if (_tmp52_ == NULL) {
		const gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp53_ = gir_namespace;
		_tmp54_ = g_strdup (_tmp53_);
		_g_free0 (vala_namespace);
		vala_namespace = _tmp54_;
	}
	_tmp55_ = self->priv->current_source_file;
	_tmp56_ = gir_namespace;
	vala_source_file_set_gir_namespace (_tmp55_, _tmp56_);
	_tmp57_ = self->priv->current_source_file;
	_tmp58_ = gir_version;
	vala_source_file_set_gir_version (_tmp57_, _tmp58_);
	_tmp59_ = vala_namespace;
	vala_gir_parser_push_node (self, _tmp59_, TRUE);
	_tmp60_ = self->priv->current;
	if (_tmp60_->new_symbol) {
		const gchar* _tmp61_;
		ValaGirParserNode* _tmp62_;
		ValaSourceReference* _tmp63_;
		ValaNamespace* _tmp64_;
		ValaGirParserNode* _tmp65_;
		ValaNamespace* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp61_ = vala_namespace;
		_tmp62_ = self->priv->current;
		_tmp63_ = _tmp62_->source_reference;
		_tmp64_ = vala_namespace_new (_tmp61_, _tmp63_);
		_vala_code_node_unref0 (ns);
		ns = _tmp64_;
		_tmp65_ = self->priv->current;
		_tmp66_ = ns;
		_tmp67_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp66_);
		_vala_code_node_unref0 (_tmp65_->symbol);
		_tmp65_->symbol = _tmp67_;
	} else {
		ValaGirParserNode* _tmp68_;
		ValaSymbol* _tmp69_;
		ValaNamespace* _tmp70_;
		ValaNamespace* _tmp71_;
		ValaNamespace* _tmp72_;
		ValaGirParserNode* _tmp73_;
		ValaSourceReference* _tmp74_;
		_tmp68_ = self->priv->current;
		_tmp69_ = _tmp68_->symbol;
		_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_NAMESPACE, ValaNamespace));
		_vala_code_node_unref0 (ns);
		ns = _tmp70_;
		_tmp71_ = ns;
		(((ValaCodeNode*) _tmp71_)->attributes == NULL) ? NULL : (((ValaCodeNode*) _tmp71_)->attributes = (_g_list_free__vala_code_node_unref0_ (((ValaCodeNode*) _tmp71_)->attributes), NULL));
		((ValaCodeNode*) _tmp71_)->attributes = NULL;
		_tmp72_ = ns;
		_tmp73_ = self->priv->current;
		_tmp74_ = _tmp73_->source_reference;
		vala_code_node_set_source_reference ((ValaCodeNode*) _tmp72_, _tmp74_);
	}
	_tmp75_ = self->priv->current;
	_tmp76_ = ns_metadata;
	_tmp77_ = _vala_gir_parser_metadata_ref0 (_tmp76_);
	_vala_gir_parser_metadata_unref0 (_tmp75_->metadata);
	_tmp75_->metadata = _tmp77_;
	_tmp78_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp78_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaGirParserMetadata* _tmp79_;
		gchar* _tmp80_;
		_tmp79_ = ns_metadata;
		_tmp80_ = vala_gir_parser_metadata_get_string (_tmp79_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_g_free0 (cprefix);
		cprefix = _tmp80_;
	}
	_tmp81_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp81_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX)) {
		ValaGirParserMetadata* _tmp82_;
		gchar* _tmp83_;
		_tmp82_ = ns_metadata;
		_tmp83_ = vala_gir_parser_metadata_get_string (_tmp82_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX);
		_g_free0 (lower_case_cprefix);
		lower_case_cprefix = _tmp83_;
	} else {
		const gchar* _tmp84_;
		_tmp84_ = lower_case_cprefix;
		if (_tmp84_ != NULL) {
			const gchar* _tmp85_;
			gchar* _tmp86_;
			_tmp85_ = lower_case_cprefix;
			_tmp86_ = g_strconcat (_tmp85_, "_", NULL);
			_g_free0 (lower_case_cprefix);
			lower_case_cprefix = _tmp86_;
		}
	}
	_tmp87_ = ns;
	_tmp88_ = gir_namespace;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp87_, "CCode", "gir_namespace", _tmp88_, NULL);
	_tmp89_ = ns;
	_tmp90_ = gir_version;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp89_, "CCode", "gir_version", _tmp90_, NULL);
	_tmp91_ = cprefix;
	if (_tmp91_ != NULL) {
		ValaNamespace* _tmp92_;
		const gchar* _tmp93_;
		const gchar* _tmp94_;
		_tmp92_ = ns;
		_tmp93_ = cprefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp92_, "CCode", "cprefix", _tmp93_, NULL);
		_tmp94_ = lower_case_cprefix;
		if (_tmp94_ == NULL) {
			ValaNamespace* _tmp95_;
			const gchar* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			_tmp95_ = ns;
			_tmp96_ = cprefix;
			_tmp97_ = vala_symbol_camel_case_to_lower_case (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = g_strconcat (_tmp98_, "_", NULL);
			_tmp100_ = _tmp99_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp95_, "CCode", "lower_case_cprefix", _tmp100_, NULL);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp98_);
		}
	}
	_tmp101_ = lower_case_cprefix;
	if (_tmp101_ != NULL) {
		ValaNamespace* _tmp102_;
		const gchar* _tmp103_;
		_tmp102_ = ns;
		_tmp103_ = lower_case_cprefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp102_, "CCode", "lower_case_cprefix", _tmp103_, NULL);
	}
	_tmp104_ = self->priv->cheader_filenames;
	_tmp104__length1 = self->priv->cheader_filenames_length1;
	if (_tmp104_ != NULL) {
		ValaNamespace* _tmp105_;
		gchar** _tmp106_;
		gint _tmp106__length1;
		gchar* _tmp107_;
		gchar* _tmp108_;
		_tmp105_ = ns;
		_tmp106_ = self->priv->cheader_filenames;
		_tmp106__length1 = self->priv->cheader_filenames_length1;
		_tmp107_ = _vala_g_strjoinv (",", _tmp106_, (gint) _tmp106__length1);
		_tmp108_ = _tmp107_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp105_, "CCode", "cheader_filename", _tmp108_, NULL);
		_g_free0 (_tmp108_);
	}
	vala_gir_parser_next (self);
	while (TRUE) {
		ValaMarkupReader* _tmp109_;
		const gchar* _tmp110_;
		const gchar* _tmp111_;
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp109_ = self->priv->reader;
		_tmp110_ = vala_markup_reader_get_name (_tmp109_);
		_tmp111_ = _tmp110_;
		if (g_strcmp0 (_tmp111_, "alias") == 0) {
			vala_gir_parser_parse_alias (self);
		} else {
			ValaMarkupReader* _tmp112_;
			const gchar* _tmp113_;
			const gchar* _tmp114_;
			_tmp112_ = self->priv->reader;
			_tmp113_ = vala_markup_reader_get_name (_tmp112_);
			_tmp114_ = _tmp113_;
			if (g_strcmp0 (_tmp114_, "enumeration") == 0) {
				ValaGirParserMetadata* _tmp115_;
				_tmp115_ = self->priv->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp115_, VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN)) {
					ValaGirParserMetadata* _tmp116_;
					_tmp116_ = self->priv->metadata;
					if (vala_gir_parser_metadata_get_bool (_tmp116_, VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN, FALSE)) {
						vala_gir_parser_parse_error_domain (self);
					} else {
						vala_gir_parser_parse_enumeration (self, "enumeration", FALSE);
					}
				} else {
					gboolean _tmp117_ = FALSE;
					ValaMarkupReader* _tmp118_;
					_tmp118_ = self->priv->reader;
					if (vala_markup_reader_has_attribute (_tmp118_, "glib:error-quark")) {
						_tmp117_ = TRUE;
					} else {
						ValaMarkupReader* _tmp119_;
						_tmp119_ = self->priv->reader;
						_tmp117_ = vala_markup_reader_has_attribute (_tmp119_, "glib:error-domain");
					}
					if (_tmp117_) {
						vala_gir_parser_parse_error_domain (self);
					} else {
						vala_gir_parser_parse_enumeration (self, "enumeration", FALSE);
					}
				}
			} else {
				ValaMarkupReader* _tmp120_;
				const gchar* _tmp121_;
				const gchar* _tmp122_;
				_tmp120_ = self->priv->reader;
				_tmp121_ = vala_markup_reader_get_name (_tmp120_);
				_tmp122_ = _tmp121_;
				if (g_strcmp0 (_tmp122_, "bitfield") == 0) {
					vala_gir_parser_parse_bitfield (self);
				} else {
					ValaMarkupReader* _tmp123_;
					const gchar* _tmp124_;
					const gchar* _tmp125_;
					_tmp123_ = self->priv->reader;
					_tmp124_ = vala_markup_reader_get_name (_tmp123_);
					_tmp125_ = _tmp124_;
					if (g_strcmp0 (_tmp125_, "function") == 0) {
						vala_gir_parser_parse_method (self, "function");
					} else {
						ValaMarkupReader* _tmp126_;
						const gchar* _tmp127_;
						const gchar* _tmp128_;
						_tmp126_ = self->priv->reader;
						_tmp127_ = vala_markup_reader_get_name (_tmp126_);
						_tmp128_ = _tmp127_;
						if (g_strcmp0 (_tmp128_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp129_;
							const gchar* _tmp130_;
							const gchar* _tmp131_;
							_tmp129_ = self->priv->reader;
							_tmp130_ = vala_markup_reader_get_name (_tmp129_);
							_tmp131_ = _tmp130_;
							if (g_strcmp0 (_tmp131_, "callback") == 0) {
								vala_gir_parser_parse_callback (self);
							} else {
								ValaMarkupReader* _tmp132_;
								const gchar* _tmp133_;
								const gchar* _tmp134_;
								_tmp132_ = self->priv->reader;
								_tmp133_ = vala_markup_reader_get_name (_tmp132_);
								_tmp134_ = _tmp133_;
								if (g_strcmp0 (_tmp134_, "record") == 0) {
									ValaGirParserMetadata* _tmp135_;
									_tmp135_ = self->priv->metadata;
									if (vala_gir_parser_metadata_has_argument (_tmp135_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT)) {
										ValaGirParserMetadata* _tmp136_;
										_tmp136_ = self->priv->metadata;
										if (vala_gir_parser_metadata_get_bool (_tmp136_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, FALSE)) {
											vala_gir_parser_parse_record (self);
										} else {
											vala_gir_parser_parse_boxed (self, "record");
										}
									} else {
										gchar* _tmp137_;
										gchar* _tmp138_;
										gboolean _tmp139_;
										_tmp137_ = vala_gir_parser_element_get_type_id (self);
										_tmp138_ = _tmp137_;
										_tmp139_ = _tmp138_ != NULL;
										_g_free0 (_tmp138_);
										if (_tmp139_) {
											vala_gir_parser_parse_boxed (self, "record");
										} else {
											ValaMarkupReader* _tmp140_;
											gchar* _tmp141_;
											gchar* _tmp142_;
											gboolean _tmp143_;
											_tmp140_ = self->priv->reader;
											_tmp141_ = vala_markup_reader_get_attribute (_tmp140_, "name");
											_tmp142_ = _tmp141_;
											_tmp143_ = !g_str_has_suffix (_tmp142_, "Private");
											_g_free0 (_tmp142_);
											if (_tmp143_) {
												gboolean _tmp144_ = FALSE;
												ValaMarkupReader* _tmp145_;
												_tmp145_ = self->priv->reader;
												if (!vala_markup_reader_has_attribute (_tmp145_, "glib:is-gtype-struct-for")) {
													ValaMarkupReader* _tmp146_;
													gchar* _tmp147_;
													gchar* _tmp148_;
													_tmp146_ = self->priv->reader;
													_tmp147_ = vala_markup_reader_get_attribute (_tmp146_, "disguised");
													_tmp148_ = _tmp147_;
													_tmp144_ = g_strcmp0 (_tmp148_, "1") == 0;
													_g_free0 (_tmp148_);
												} else {
													_tmp144_ = FALSE;
												}
												if (_tmp144_) {
													vala_gir_parser_parse_boxed (self, "record");
												} else {
													vala_gir_parser_parse_record (self);
												}
											} else {
												vala_gir_parser_skip_element (self);
											}
										}
									}
								} else {
									ValaMarkupReader* _tmp149_;
									const gchar* _tmp150_;
									const gchar* _tmp151_;
									_tmp149_ = self->priv->reader;
									_tmp150_ = vala_markup_reader_get_name (_tmp149_);
									_tmp151_ = _tmp150_;
									if (g_strcmp0 (_tmp151_, "class") == 0) {
										vala_gir_parser_parse_class (self);
									} else {
										ValaMarkupReader* _tmp152_;
										const gchar* _tmp153_;
										const gchar* _tmp154_;
										_tmp152_ = self->priv->reader;
										_tmp153_ = vala_markup_reader_get_name (_tmp152_);
										_tmp154_ = _tmp153_;
										if (g_strcmp0 (_tmp154_, "interface") == 0) {
											vala_gir_parser_parse_interface (self);
										} else {
											ValaMarkupReader* _tmp155_;
											const gchar* _tmp156_;
											const gchar* _tmp157_;
											_tmp155_ = self->priv->reader;
											_tmp156_ = vala_markup_reader_get_name (_tmp155_);
											_tmp157_ = _tmp156_;
											if (g_strcmp0 (_tmp157_, "glib:boxed") == 0) {
												vala_gir_parser_parse_boxed (self, "glib:boxed");
											} else {
												ValaMarkupReader* _tmp158_;
												const gchar* _tmp159_;
												const gchar* _tmp160_;
												_tmp158_ = self->priv->reader;
												_tmp159_ = vala_markup_reader_get_name (_tmp158_);
												_tmp160_ = _tmp159_;
												if (g_strcmp0 (_tmp160_, "union") == 0) {
													gboolean _tmp161_ = FALSE;
													gchar* _tmp162_;
													gchar* _tmp163_;
													gboolean _tmp164_;
													_tmp162_ = vala_gir_parser_element_get_type_id (self);
													_tmp163_ = _tmp162_;
													_tmp164_ = _tmp163_ != NULL;
													_g_free0 (_tmp163_);
													if (_tmp164_) {
														ValaGirParserMetadata* _tmp165_;
														_tmp165_ = self->priv->metadata;
														_tmp161_ = !vala_gir_parser_metadata_get_bool (_tmp165_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, FALSE);
													} else {
														_tmp161_ = FALSE;
													}
													if (_tmp161_) {
														vala_gir_parser_parse_boxed (self, "union");
													} else {
														vala_gir_parser_parse_union (self);
													}
												} else {
													ValaMarkupReader* _tmp166_;
													const gchar* _tmp167_;
													const gchar* _tmp168_;
													_tmp166_ = self->priv->reader;
													_tmp167_ = vala_markup_reader_get_name (_tmp166_);
													_tmp168_ = _tmp167_;
													if (g_strcmp0 (_tmp168_, "constant") == 0) {
														vala_gir_parser_parse_constant (self);
													} else {
														ValaMarkupReader* _tmp169_;
														const gchar* _tmp170_;
														const gchar* _tmp171_;
														_tmp169_ = self->priv->reader;
														_tmp170_ = vala_markup_reader_get_name (_tmp169_);
														_tmp171_ = _tmp170_;
														if (g_strcmp0 (_tmp171_, "docsection") == 0) {
															vala_gir_parser_skip_element (self);
														} else {
															ValaSourceReference* _tmp172_;
															ValaSourceReference* _tmp173_;
															ValaMarkupReader* _tmp174_;
															const gchar* _tmp175_;
															const gchar* _tmp176_;
															_tmp172_ = vala_gir_parser_get_current_src (self);
															_tmp173_ = _tmp172_;
															_tmp174_ = self->priv->reader;
															_tmp175_ = vala_markup_reader_get_name (_tmp174_);
															_tmp176_ = _tmp175_;
															vala_report_error (_tmp173_, "unknown child element `%s' in `namespace'", _tmp176_);
															_vala_source_reference_unref0 (_tmp173_);
															vala_gir_parser_skip_element (self);
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "namespace");
	_vala_code_node_unref0 (ns);
	_vala_gir_parser_metadata_unref0 (ns_metadata);
	_g_free0 (metadata_filename);
	_g_free0 (gir_version);
	_g_free0 (gir_namespace);
	_g_free0 (vala_namespace);
	_g_free0 (lower_case_cprefix);
	_g_free0 (cprefix);
}

static void
vala_gir_parser_parse_alias (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaGirParserNode* _tmp2_;
	ValaGirComment* _tmp3_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	ValaGirParserNode* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaGirParserMetadata* _tmp12_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "alias");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	vala_gir_parser_next (self);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->comment;
	if (_tmp3_ == NULL) {
		ValaGirParserNode* _tmp4_;
		ValaGirComment* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = vala_gir_parser_parse_symbol_doc (self);
		_vala_comment_unref0 (_tmp4_->comment);
		_tmp4_->comment = _tmp5_;
	} else {
		ValaGirComment* _tmp6_;
		ValaGirComment* _tmp7_;
		_tmp6_ = vala_gir_parser_parse_symbol_doc (self);
		_tmp7_ = _tmp6_;
		_vala_comment_unref0 (_tmp7_);
	}
	no_array_length = FALSE;
	array_null_terminated = FALSE;
	_tmp8_ = self->priv->current;
	_tmp9_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_gir_parser_element_get_type (self, _tmp10_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (_tmp8_->base_type);
	_tmp8_->base_type = _tmp11_;
	_vala_code_node_unref0 (_tmp10_);
	_tmp12_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE)) {
		ValaGirParserNode* _tmp13_;
		ValaGirParserMetadata* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		ValaGirParserMetadata* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaDataType* _tmp20_;
		_tmp13_ = self->priv->current;
		_tmp14_ = self->priv->metadata;
		_tmp15_ = vala_gir_parser_metadata_get_string (_tmp14_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->metadata;
		_tmp18_ = vala_gir_parser_metadata_get_source_reference (_tmp17_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_gir_parser_parse_type_from_string (self, _tmp16_, TRUE, _tmp19_);
		_vala_code_node_unref0 (_tmp13_->base_type);
		_tmp13_->base_type = _tmp20_;
		_vala_source_reference_unref0 (_tmp19_);
		_g_free0 (_tmp16_);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "alias");
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static void
vala_gir_parser_calculate_common_prefix (ValaGirParser* self,
                                         gchar** common_prefix,
                                         const gchar* cname)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	if ((*common_prefix) == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (cname);
		_g_free0 (*common_prefix);
		*common_prefix = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gchar* _tmp6_;
			_tmp2_ = strlen (*common_prefix);
			_tmp3_ = _tmp2_;
			if (_tmp3_ > 0) {
				_tmp1_ = !g_str_has_suffix (*common_prefix, "_");
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			_tmp4_ = strlen (*common_prefix);
			_tmp5_ = _tmp4_;
			_tmp6_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp5_ - 1));
			_g_free0 (*common_prefix);
			*common_prefix = _tmp6_;
		}
	} else {
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gchar* _tmp9_;
			if (!(!g_str_has_prefix (cname, *common_prefix))) {
				break;
			}
			_tmp7_ = strlen (*common_prefix);
			_tmp8_ = _tmp7_;
			_tmp9_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp8_ - 1));
			_g_free0 (*common_prefix);
			*common_prefix = _tmp9_;
		}
	}
	while (TRUE) {
		gboolean _tmp10_ = FALSE;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		_tmp11_ = strlen (*common_prefix);
		_tmp12_ = _tmp11_;
		if (_tmp12_ > 0) {
			gboolean _tmp13_ = FALSE;
			if (!g_str_has_suffix (*common_prefix, "_")) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp14_ = FALSE;
				gint _tmp15_;
				gint _tmp16_;
				_tmp15_ = strlen (*common_prefix);
				_tmp16_ = _tmp15_;
				if (g_unichar_isdigit (string_get_char (cname, (glong) _tmp16_))) {
					gint _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					_tmp17_ = strlen (cname);
					_tmp18_ = _tmp17_;
					_tmp19_ = strlen (*common_prefix);
					_tmp20_ = _tmp19_;
					_tmp14_ = (_tmp18_ - _tmp20_) <= 1;
				} else {
					_tmp14_ = FALSE;
				}
				_tmp13_ = _tmp14_;
			}
			_tmp10_ = _tmp13_;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			break;
		}
		_tmp21_ = strlen (*common_prefix);
		_tmp22_ = _tmp21_;
		_tmp23_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp22_ - 1));
		_g_free0 (*common_prefix);
		*common_prefix = _tmp23_;
	}
}

static ValaGirComment*
vala_gir_parser_parse_symbol_doc (ValaGirParser* self)
{
	ValaGirComment* comment = NULL;
	ValaGirComment* result;
	g_return_val_if_fail (self != NULL, NULL);
	comment = NULL;
	while (TRUE) {
		const gchar* reader_name = NULL;
		ValaMarkupReader* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp0_ = self->priv->reader;
		_tmp1_ = vala_markup_reader_get_name (_tmp0_);
		_tmp2_ = _tmp1_;
		reader_name = _tmp2_;
		_tmp3_ = reader_name;
		if (g_strcmp0 (_tmp3_, "doc") == 0) {
			vala_gir_parser_start_element (self, "doc");
			vala_gir_parser_next (self);
			if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_TEXT) {
				ValaMarkupReader* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				ValaGirParserNode* _tmp7_;
				ValaSourceReference* _tmp8_;
				ValaGirComment* _tmp9_;
				_tmp4_ = self->priv->reader;
				_tmp5_ = vala_markup_reader_get_content (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = self->priv->current;
				_tmp8_ = _tmp7_->source_reference;
				_tmp9_ = vala_gir_comment_new (_tmp6_, _tmp8_);
				_vala_comment_unref0 (comment);
				comment = _tmp9_;
				vala_gir_parser_next (self);
			}
			vala_gir_parser_end_element (self, "doc");
		} else {
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			const gchar* _tmp12_;
			_tmp12_ = reader_name;
			if (g_strcmp0 (_tmp12_, "doc-version") == 0) {
				_tmp11_ = TRUE;
			} else {
				const gchar* _tmp13_;
				_tmp13_ = reader_name;
				_tmp11_ = g_strcmp0 (_tmp13_, "doc-deprecated") == 0;
			}
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				const gchar* _tmp14_;
				_tmp14_ = reader_name;
				_tmp10_ = g_strcmp0 (_tmp14_, "doc-stability") == 0;
			}
			if (_tmp10_) {
				vala_gir_parser_skip_element (self);
			} else {
				const gchar* _tmp15_;
				_tmp15_ = reader_name;
				if (g_strcmp0 (_tmp15_, "source-position") == 0) {
					vala_gir_parser_skip_element (self);
				} else {
					const gchar* _tmp16_;
					_tmp16_ = reader_name;
					if (g_strcmp0 (_tmp16_, "attribute") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						break;
					}
				}
			}
		}
	}
	result = comment;
	return result;
}

static ValaComment*
vala_gir_parser_parse_doc (ValaGirParser* self)
{
	ValaComment* comment = NULL;
	ValaComment* result;
	g_return_val_if_fail (self != NULL, NULL);
	comment = NULL;
	while (TRUE) {
		const gchar* reader_name = NULL;
		ValaMarkupReader* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp0_ = self->priv->reader;
		_tmp1_ = vala_markup_reader_get_name (_tmp0_);
		_tmp2_ = _tmp1_;
		reader_name = _tmp2_;
		_tmp3_ = reader_name;
		if (g_strcmp0 (_tmp3_, "doc") == 0) {
			vala_gir_parser_start_element (self, "doc");
			vala_gir_parser_next (self);
			if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_TEXT) {
				ValaMarkupReader* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				ValaGirParserNode* _tmp7_;
				ValaSourceReference* _tmp8_;
				ValaComment* _tmp9_;
				_tmp4_ = self->priv->reader;
				_tmp5_ = vala_markup_reader_get_content (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = self->priv->current;
				_tmp8_ = _tmp7_->source_reference;
				_tmp9_ = vala_comment_new (_tmp6_, _tmp8_);
				_vala_comment_unref0 (comment);
				comment = _tmp9_;
				vala_gir_parser_next (self);
			}
			vala_gir_parser_end_element (self, "doc");
		} else {
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			const gchar* _tmp12_;
			_tmp12_ = reader_name;
			if (g_strcmp0 (_tmp12_, "doc-version") == 0) {
				_tmp11_ = TRUE;
			} else {
				const gchar* _tmp13_;
				_tmp13_ = reader_name;
				_tmp11_ = g_strcmp0 (_tmp13_, "doc-deprecated") == 0;
			}
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				const gchar* _tmp14_;
				_tmp14_ = reader_name;
				_tmp10_ = g_strcmp0 (_tmp14_, "doc-stability") == 0;
			}
			if (_tmp10_) {
				vala_gir_parser_skip_element (self);
			} else {
				const gchar* _tmp15_;
				_tmp15_ = reader_name;
				if (g_strcmp0 (_tmp15_, "source-position") == 0) {
					vala_gir_parser_skip_element (self);
				} else {
					const gchar* _tmp16_;
					_tmp16_ = reader_name;
					if (g_strcmp0 (_tmp16_, "attribute") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						break;
					}
				}
			}
		}
	}
	result = comment;
	return result;
}

static void
vala_gir_parser_parse_enumeration (ValaGirParser* self,
                                   const gchar* element_name,
                                   gboolean error_domain)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaSymbol* sym = NULL;
	ValaGirParserNode* _tmp2_;
	ValaSymbol* _tmp22_;
	ValaSymbol* _tmp23_;
	gchar* common_prefix = NULL;
	gboolean explicit_prefix = FALSE;
	ValaGirParserMetadata* _tmp24_;
	gboolean has_member = FALSE;
	ValaSymbol* _tmp29_;
	ValaGirComment* _tmp30_;
	ValaGirComment* _tmp31_;
	const gchar* _tmp53_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->current;
	if (_tmp2_->new_symbol) {
		ValaGirParserNode* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		if (error_domain) {
			ValaGirParserNode* _tmp3_;
			const gchar* _tmp4_;
			ValaGirParserNode* _tmp5_;
			ValaSourceReference* _tmp6_;
			ValaErrorDomain* _tmp7_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_->name;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_->source_reference;
			_tmp7_ = vala_error_domain_new (_tmp4_, _tmp6_, NULL);
			_vala_code_node_unref0 (sym);
			sym = (ValaSymbol*) _tmp7_;
		} else {
			ValaEnum* en = NULL;
			ValaGirParserNode* _tmp8_;
			const gchar* _tmp9_;
			ValaGirParserNode* _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaEnum* _tmp12_;
			ValaEnum* _tmp14_;
			ValaSymbol* _tmp15_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_->name;
			_tmp10_ = self->priv->current;
			_tmp11_ = _tmp10_->source_reference;
			_tmp12_ = vala_enum_new (_tmp9_, _tmp11_, NULL);
			en = _tmp12_;
			if (g_strcmp0 (element_name, "bitfield") == 0) {
				ValaEnum* _tmp13_;
				_tmp13_ = en;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp13_, "Flags", TRUE, NULL);
			}
			_tmp14_ = en;
			_tmp15_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp14_);
			_vala_code_node_unref0 (sym);
			sym = _tmp15_;
			_vala_code_node_unref0 (en);
		}
		_tmp16_ = self->priv->current;
		_tmp17_ = sym;
		_tmp18_ = _vala_code_node_ref0 (_tmp17_);
		_vala_code_node_unref0 (_tmp16_->symbol);
		_tmp16_->symbol = _tmp18_;
	} else {
		ValaGirParserNode* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_->symbol;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (sym);
		sym = _tmp21_;
	}
	_tmp22_ = sym;
	vala_gir_parser_set_type_id_ccode (self, _tmp22_);
	_tmp23_ = sym;
	vala_symbol_set_access (_tmp23_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	common_prefix = NULL;
	explicit_prefix = FALSE;
	_tmp24_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp24_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaSymbol* _tmp25_;
		ValaGirParserMetadata* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp25_ = sym;
		_tmp26_ = self->priv->metadata;
		_tmp27_ = vala_gir_parser_metadata_get_string (_tmp26_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_tmp28_ = _tmp27_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp25_, "CCode", "cprefix", _tmp28_, NULL);
		_g_free0 (_tmp28_);
		explicit_prefix = TRUE;
	}
	has_member = FALSE;
	vala_gir_parser_next (self);
	_tmp29_ = sym;
	_tmp30_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp31_ = _tmp30_;
	vala_symbol_set_comment (_tmp29_, (ValaComment*) _tmp31_);
	_vala_comment_unref0 (_tmp31_);
	while (TRUE) {
		ValaMarkupReader* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp32_ = self->priv->reader;
		_tmp33_ = vala_markup_reader_get_name (_tmp32_);
		_tmp34_ = _tmp33_;
		if (g_strcmp0 (_tmp34_, "member") == 0) {
			has_member = TRUE;
			if (error_domain) {
				vala_gir_parser_parse_error_member (self);
			} else {
				vala_gir_parser_parse_enumeration_member (self);
			}
			if (!explicit_prefix) {
				ValaGirParserNode* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				_tmp35_ = self->priv->old_current;
				_tmp36_ = vala_gir_parser_node_get_cname (_tmp35_);
				_tmp37_ = _tmp36_;
				vala_gir_parser_calculate_common_prefix (self, &common_prefix, _tmp37_);
				_g_free0 (_tmp37_);
			}
		} else {
			ValaMarkupReader* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			_tmp38_ = self->priv->reader;
			_tmp39_ = vala_markup_reader_get_name (_tmp38_);
			_tmp40_ = _tmp39_;
			if (g_strcmp0 (_tmp40_, "function") == 0) {
				vala_gir_parser_parse_method (self, "function");
			} else {
				ValaMarkupReader* _tmp41_;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				_tmp41_ = self->priv->reader;
				_tmp42_ = vala_markup_reader_get_name (_tmp41_);
				_tmp43_ = _tmp42_;
				if (g_strcmp0 (_tmp43_, "function-macro") == 0) {
					vala_gir_parser_skip_element (self);
				} else {
					ValaSourceReference* _tmp44_;
					ValaSourceReference* _tmp45_;
					ValaMarkupReader* _tmp46_;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					_tmp44_ = vala_gir_parser_get_current_src (self);
					_tmp45_ = _tmp44_;
					_tmp46_ = self->priv->reader;
					_tmp47_ = vala_markup_reader_get_name (_tmp46_);
					_tmp48_ = _tmp47_;
					vala_report_error (_tmp45_, "unknown child element `%s' in `%s'", _tmp48_, element_name);
					_vala_source_reference_unref0 (_tmp45_);
					vala_gir_parser_skip_element (self);
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	if (!has_member) {
		ValaSourceReference* _tmp49_;
		ValaSourceReference* _tmp50_;
		ValaGirParserNode* _tmp51_;
		const gchar* _tmp52_;
		_tmp49_ = vala_gir_parser_get_current_src (self);
		_tmp50_ = _tmp49_;
		_tmp51_ = self->priv->current;
		_tmp52_ = _tmp51_->name;
		vala_report_error (_tmp50_, "%s `%s' has no members", element_name, _tmp52_);
		_vala_source_reference_unref0 (_tmp50_);
	}
	_tmp53_ = common_prefix;
	if (_tmp53_ != NULL) {
		ValaSymbol* _tmp54_;
		const gchar* _tmp55_;
		_tmp54_ = sym;
		_tmp55_ = common_prefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp54_, "CCode", "cprefix", _tmp55_, NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_g_free0 (common_prefix);
	_vala_code_node_unref0 (sym);
}

static void
vala_gir_parser_parse_error_domain (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_enumeration (self, "enumeration", TRUE);
}

static void
vala_gir_parser_parse_bitfield (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_enumeration (self, "bitfield", FALSE);
}

static void
vala_gir_parser_parse_enumeration_member (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaEnumValue* ev = NULL;
	ValaGirParserNode* _tmp6_;
	const gchar* _tmp7_;
	ValaGirParserMetadata* _tmp8_;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaGirParserNode* _tmp11_;
	ValaSourceReference* _tmp12_;
	ValaEnumValue* _tmp13_;
	ValaEnumValue* _tmp14_;
	ValaGirParserNode* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaGirComment* _tmp17_;
	ValaGirComment* _tmp18_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "member");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "-", "_");
	_tmp5_ = _tmp4_;
	vala_gir_parser_push_node (self, _tmp5_, FALSE);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->name;
	_tmp8_ = self->priv->metadata;
	_tmp9_ = vala_gir_parser_metadata_get_expression (_tmp8_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->current;
	_tmp12_ = _tmp11_->source_reference;
	_tmp13_ = vala_enum_value_new (_tmp7_, _tmp10_, _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_vala_code_node_unref0 (_tmp10_);
	ev = _tmp14_;
	_tmp15_ = self->priv->current;
	_tmp16_ = _vala_code_node_ref0 ((ValaSymbol*) ev);
	_vala_code_node_unref0 (_tmp15_->symbol);
	_tmp15_->symbol = _tmp16_;
	vala_gir_parser_next (self);
	_tmp17_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp18_ = _tmp17_;
	vala_symbol_set_comment ((ValaSymbol*) ev, (ValaComment*) _tmp18_);
	_vala_comment_unref0 (_tmp18_);
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "member");
	_vala_code_node_unref0 (ev);
}

static void
vala_gir_parser_parse_error_member (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaErrorCode* ec = NULL;
	gchar* value = NULL;
	ValaMarkupReader* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaGirParserNode* _tmp18_;
	ValaErrorCode* _tmp19_;
	ValaSymbol* _tmp20_;
	ValaErrorCode* _tmp21_;
	ValaGirComment* _tmp22_;
	ValaGirComment* _tmp23_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "member");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "-", "_");
	_tmp5_ = _tmp4_;
	vala_gir_parser_push_node (self, _tmp5_, FALSE);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = self->priv->reader;
	_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "value");
	value = _tmp7_;
	_tmp8_ = value;
	if (_tmp8_ != NULL) {
		ValaGirParserNode* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ValaIntegerLiteral* _tmp12_;
		ValaIntegerLiteral* _tmp13_;
		ValaErrorCode* _tmp14_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->name;
		_tmp11_ = value;
		_tmp12_ = vala_integer_literal_new (_tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_error_code_new_with_value (_tmp10_, (ValaExpression*) _tmp13_, NULL);
		_vala_code_node_unref0 (ec);
		ec = _tmp14_;
		_vala_code_node_unref0 (_tmp13_);
	} else {
		ValaGirParserNode* _tmp15_;
		const gchar* _tmp16_;
		ValaErrorCode* _tmp17_;
		_tmp15_ = self->priv->current;
		_tmp16_ = _tmp15_->name;
		_tmp17_ = vala_error_code_new (_tmp16_, NULL, NULL);
		_vala_code_node_unref0 (ec);
		ec = _tmp17_;
	}
	_tmp18_ = self->priv->current;
	_tmp19_ = ec;
	_tmp20_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp19_);
	_vala_code_node_unref0 (_tmp18_->symbol);
	_tmp18_->symbol = _tmp20_;
	vala_gir_parser_next (self);
	_tmp21_ = ec;
	_tmp22_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp23_ = _tmp22_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp21_, (ValaComment*) _tmp23_);
	_vala_comment_unref0 (_tmp23_);
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "member");
	_g_free0 (value);
	_vala_code_node_unref0 (ec);
}

static ValaDataType*
vala_gir_parser_parse_return_value (ValaGirParser* self,
                                    gchar** ctype,
                                    gint* array_length_idx,
                                    gboolean* no_array_length,
                                    gboolean* array_null_terminated,
                                    ValaComment** comment)
{
	gchar* _vala_ctype = NULL;
	gint _vala_array_length_idx = 0;
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaComment* _vala_comment = NULL;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	ValaComment* _tmp6_;
	gboolean transfer_elements = FALSE;
	const gchar* _tmp7_;
	ValaDataType* type = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaDataType* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "return-value");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "transfer-ownership");
	transfer = _tmp1_;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "nullable");
	nullable = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "allow-none");
	allow_none = _tmp5_;
	vala_gir_parser_next (self);
	_tmp6_ = vala_gir_parser_parse_doc (self);
	_vala_comment_unref0 (_vala_comment);
	_vala_comment = _tmp6_;
	_tmp7_ = transfer;
	transfer_elements = g_strcmp0 (_tmp7_, "container") != 0;
	_tmp12_ = vala_gir_parser_parse_type (self, &_tmp8_, &_tmp9_, transfer_elements, &_tmp10_, &_tmp11_);
	_g_free0 (_vala_ctype);
	_vala_ctype = _tmp8_;
	_vala_array_length_idx = _tmp9_;
	_vala_no_array_length = _tmp10_;
	_vala_array_null_terminated = _tmp11_;
	type = _tmp12_;
	_tmp14_ = transfer;
	if (g_strcmp0 (_tmp14_, "full") == 0) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp15_;
		_tmp15_ = transfer;
		_tmp13_ = g_strcmp0 (_tmp15_, "container") == 0;
	}
	if (_tmp13_) {
		ValaDataType* _tmp16_;
		_tmp16_ = type;
		vala_data_type_set_value_owned (_tmp16_, TRUE);
	}
	_tmp18_ = nullable;
	if (g_strcmp0 (_tmp18_, "1") == 0) {
		_tmp17_ = TRUE;
	} else {
		const gchar* _tmp19_;
		_tmp19_ = allow_none;
		_tmp17_ = g_strcmp0 (_tmp19_, "1") == 0;
	}
	if (_tmp17_) {
		ValaDataType* _tmp20_;
		_tmp20_ = type;
		vala_data_type_set_nullable (_tmp20_, TRUE);
	}
	_tmp21_ = type;
	_tmp22_ = vala_gir_parser_element_get_type (self, _tmp21_, TRUE, &_vala_no_array_length, &_vala_array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp22_;
	vala_gir_parser_end_element (self, "return-value");
	result = type;
	_g_free0 (allow_none);
	_g_free0 (nullable);
	_g_free0 (transfer);
	if (ctype) {
		*ctype = _vala_ctype;
	} else {
		_g_free0 (_vala_ctype);
	}
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	if (comment) {
		*comment = _vala_comment;
	} else {
		_vala_comment_unref0 (_vala_comment);
	}
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static ValaParameter*
vala_gir_parser_parse_parameter (ValaGirParser* self,
                                 gboolean* caller_allocates,
                                 gint* array_length_idx,
                                 gint* closure_idx,
                                 gint* destroy_idx,
                                 gchar** scope,
                                 ValaComment** comment,
                                 const gchar* default_name)
{
	gboolean _vala_caller_allocates = FALSE;
	gint _vala_array_length_idx = 0;
	gint _vala_closure_idx = 0;
	gint _vala_destroy_idx = 0;
	gchar* _vala_scope = NULL;
	ValaComment* _vala_comment = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	ValaParameter* param = NULL;
	gchar* element_type = NULL;
	ValaMarkupReader* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp11_;
	gchar* name = NULL;
	ValaGirParserMetadata* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp17_;
	gchar* direction = NULL;
	ValaGirParserMetadata* _tmp24_;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp32_;
	gchar* _tmp33_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp34_;
	gchar* _tmp35_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp36_;
	gchar* _tmp37_;
	ValaMarkupReader* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* closure = NULL;
	ValaMarkupReader* _tmp42_;
	gchar* _tmp43_;
	gchar* destroy = NULL;
	ValaMarkupReader* _tmp44_;
	gchar* _tmp45_;
	gboolean _tmp46_ = FALSE;
	const gchar* _tmp47_;
	gboolean _tmp49_ = FALSE;
	const gchar* _tmp50_;
	ValaGirParserMetadata* _tmp52_;
	ValaGirParserMetadata* _tmp54_;
	ValaComment* _tmp56_;
	ValaMarkupReader* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp123_;
	ValaParameter* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_vala_array_length_idx = -1;
	_vala_closure_idx = -1;
	_vala_destroy_idx = -1;
	_tmp1_ = self->priv->reader;
	_tmp2_ = vala_markup_reader_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	element_type = _tmp4_;
	if (self->priv->current_token != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp7_ = element_type;
		if (g_strcmp0 (_tmp7_, "parameter") != 0) {
			const gchar* _tmp8_;
			_tmp8_ = element_type;
			_tmp6_ = g_strcmp0 (_tmp8_, "instance-parameter") != 0;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp5_ = _tmp6_;
	}
	if (_tmp5_) {
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		_tmp9_ = vala_gir_parser_get_current_src (self);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp10_, "expected start element of `parameter' or `instance-parameter'");
		_vala_source_reference_unref0 (_tmp10_);
	}
	_tmp11_ = element_type;
	vala_gir_parser_start_element (self, _tmp11_);
	_tmp12_ = self->priv->metadata;
	_tmp13_ = vala_gir_parser_metadata_get_string (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	name = _tmp13_;
	_tmp14_ = name;
	if (_tmp14_ == NULL) {
		ValaMarkupReader* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = self->priv->reader;
		_tmp16_ = vala_markup_reader_get_attribute (_tmp15_, "name");
		_g_free0 (name);
		name = _tmp16_;
	}
	_tmp17_ = name;
	if (_tmp17_ == NULL) {
		gchar* _tmp18_;
		_tmp18_ = g_strdup (default_name);
		_g_free0 (name);
		name = _tmp18_;
	} else {
		const gchar* _tmp19_;
		_tmp19_ = name;
		if (string_contains (_tmp19_, "-")) {
			ValaSourceReference* _tmp20_;
			ValaSourceReference* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp20_ = vala_gir_parser_get_current_src (self);
			_tmp21_ = _tmp20_;
			vala_report_warning (_tmp21_, "parameter name contains hyphen");
			_vala_source_reference_unref0 (_tmp21_);
			_tmp22_ = name;
			_tmp23_ = string_replace (_tmp22_, "-", "_");
			_g_free0 (name);
			name = _tmp23_;
		}
	}
	direction = NULL;
	_tmp24_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp24_, VALA_GIR_PARSER_ARGUMENT_TYPE_OUT)) {
		ValaGirParserMetadata* _tmp25_;
		_tmp25_ = self->priv->metadata;
		if (vala_gir_parser_metadata_get_bool (_tmp25_, VALA_GIR_PARSER_ARGUMENT_TYPE_OUT, FALSE)) {
			gchar* _tmp26_;
			_tmp26_ = g_strdup ("out");
			_g_free0 (direction);
			direction = _tmp26_;
		}
	} else {
		ValaGirParserMetadata* _tmp27_;
		_tmp27_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp27_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF)) {
			ValaGirParserMetadata* _tmp28_;
			_tmp28_ = self->priv->metadata;
			if (vala_gir_parser_metadata_get_bool (_tmp28_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF, FALSE)) {
				gchar* _tmp29_;
				_tmp29_ = g_strdup ("inout");
				_g_free0 (direction);
				direction = _tmp29_;
			}
		} else {
			ValaMarkupReader* _tmp30_;
			gchar* _tmp31_;
			_tmp30_ = self->priv->reader;
			_tmp31_ = vala_markup_reader_get_attribute (_tmp30_, "direction");
			_g_free0 (direction);
			direction = _tmp31_;
		}
	}
	_tmp32_ = self->priv->reader;
	_tmp33_ = vala_markup_reader_get_attribute (_tmp32_, "transfer-ownership");
	transfer = _tmp33_;
	_tmp34_ = self->priv->reader;
	_tmp35_ = vala_markup_reader_get_attribute (_tmp34_, "nullable");
	nullable = _tmp35_;
	_tmp36_ = self->priv->reader;
	_tmp37_ = vala_markup_reader_get_attribute (_tmp36_, "allow-none");
	allow_none = _tmp37_;
	_tmp38_ = self->priv->reader;
	_tmp39_ = vala_markup_reader_get_attribute (_tmp38_, "caller-allocates");
	_tmp40_ = _tmp39_;
	_vala_caller_allocates = g_strcmp0 (_tmp40_, "1") == 0;
	_g_free0 (_tmp40_);
	_tmp41_ = vala_gir_parser_element_get_string (self, "scope", VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE);
	_g_free0 (_vala_scope);
	_vala_scope = _tmp41_;
	_tmp42_ = self->priv->reader;
	_tmp43_ = vala_markup_reader_get_attribute (_tmp42_, "closure");
	closure = _tmp43_;
	_tmp44_ = self->priv->reader;
	_tmp45_ = vala_markup_reader_get_attribute (_tmp44_, "destroy");
	destroy = _tmp45_;
	_tmp47_ = closure;
	if (_tmp47_ != NULL) {
		_tmp46_ = (&_vala_closure_idx) != NULL;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		const gchar* _tmp48_;
		_tmp48_ = closure;
		_vala_closure_idx = atoi (_tmp48_);
	}
	_tmp50_ = destroy;
	if (_tmp50_ != NULL) {
		_tmp49_ = (&_vala_destroy_idx) != NULL;
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		const gchar* _tmp51_;
		_tmp51_ = destroy;
		_vala_destroy_idx = atoi (_tmp51_);
	}
	_tmp52_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp52_, VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE)) {
		ValaGirParserMetadata* _tmp53_;
		_tmp53_ = self->priv->metadata;
		_vala_closure_idx = vala_gir_parser_metadata_get_integer (_tmp53_, VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE);
	}
	_tmp54_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp54_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY)) {
		ValaGirParserMetadata* _tmp55_;
		_tmp55_ = self->priv->metadata;
		_vala_destroy_idx = vala_gir_parser_metadata_get_integer (_tmp55_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY);
	}
	vala_gir_parser_next (self);
	_tmp56_ = vala_gir_parser_parse_doc (self);
	_vala_comment_unref0 (_vala_comment);
	_vala_comment = _tmp56_;
	_tmp57_ = self->priv->reader;
	_tmp58_ = vala_markup_reader_get_name (_tmp57_);
	_tmp59_ = _tmp58_;
	if (g_strcmp0 (_tmp59_, "varargs") == 0) {
		ValaSourceLocation _tmp60_;
		ValaSourceReference* _tmp61_;
		ValaSourceReference* _tmp62_;
		ValaParameter* _tmp63_;
		vala_gir_parser_start_element (self, "varargs");
		vala_gir_parser_next (self);
		_tmp60_ = begin;
		_tmp61_ = vala_gir_parser_get_src (self, &_tmp60_, NULL);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_parameter_new_with_ellipsis (_tmp62_);
		_vala_code_node_unref0 (param);
		param = _tmp63_;
		_vala_source_reference_unref0 (_tmp62_);
		vala_gir_parser_end_element (self, "varargs");
	} else {
		gchar* ctype = NULL;
		gboolean no_array_length = FALSE;
		gboolean array_null_terminated = FALSE;
		ValaDataType* type = NULL;
		const gchar* _tmp64_;
		gchar* _tmp65_ = NULL;
		gint _tmp66_ = 0;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_ = FALSE;
		ValaDataType* _tmp69_;
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		const gchar* _tmp72_;
		gboolean _tmp76_ = FALSE;
		const gchar* _tmp77_;
		gboolean changed = FALSE;
		gboolean _tmp82_ = FALSE;
		const gchar* _tmp83_;
		ValaDataType* _tmp85_;
		gboolean _tmp86_ = FALSE;
		ValaDataType* _tmp87_;
		const gchar* _tmp91_;
		ValaDataType* _tmp92_;
		ValaSourceLocation _tmp93_;
		ValaSourceReference* _tmp94_;
		ValaSourceReference* _tmp95_;
		ValaParameter* _tmp96_;
		const gchar* _tmp97_;
		const gchar* _tmp100_;
		gboolean _tmp104_ = FALSE;
		ValaDataType* _tmp105_;
		ValaDataType* _tmp109_;
		ValaParameter* _tmp115_;
		ValaGirParserMetadata* _tmp116_;
		ValaExpression* _tmp117_;
		ValaExpression* _tmp118_;
		ValaParameter* _tmp119_;
		ValaExpression* _tmp120_;
		ValaExpression* _tmp121_;
		_tmp64_ = transfer;
		_tmp69_ = vala_gir_parser_parse_type (self, &_tmp65_, &_tmp66_, g_strcmp0 (_tmp64_, "container") != 0, &_tmp67_, &_tmp68_);
		_g_free0 (ctype);
		ctype = _tmp65_;
		_vala_array_length_idx = _tmp66_;
		no_array_length = _tmp67_;
		array_null_terminated = _tmp68_;
		type = _tmp69_;
		_tmp72_ = transfer;
		if (g_strcmp0 (_tmp72_, "full") == 0) {
			_tmp71_ = TRUE;
		} else {
			const gchar* _tmp73_;
			_tmp73_ = transfer;
			_tmp71_ = g_strcmp0 (_tmp73_, "container") == 0;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			const gchar* _tmp74_;
			_tmp74_ = destroy;
			_tmp70_ = _tmp74_ != NULL;
		}
		if (_tmp70_) {
			ValaDataType* _tmp75_;
			_tmp75_ = type;
			vala_data_type_set_value_owned (_tmp75_, TRUE);
		}
		_tmp77_ = nullable;
		if (g_strcmp0 (_tmp77_, "1") == 0) {
			_tmp76_ = TRUE;
		} else {
			gboolean _tmp78_ = FALSE;
			const gchar* _tmp79_;
			_tmp79_ = allow_none;
			if (g_strcmp0 (_tmp79_, "1") == 0) {
				const gchar* _tmp80_;
				_tmp80_ = direction;
				_tmp78_ = g_strcmp0 (_tmp80_, "out") != 0;
			} else {
				_tmp78_ = FALSE;
			}
			_tmp76_ = _tmp78_;
		}
		if (_tmp76_) {
			ValaDataType* _tmp81_;
			_tmp81_ = type;
			vala_data_type_set_nullable (_tmp81_, TRUE);
		}
		_tmp83_ = direction;
		if (g_strcmp0 (_tmp83_, "out") == 0) {
			_tmp82_ = TRUE;
		} else {
			const gchar* _tmp84_;
			_tmp84_ = direction;
			_tmp82_ = g_strcmp0 (_tmp84_, "inout") == 0;
		}
		_tmp85_ = type;
		_tmp87_ = vala_gir_parser_element_get_type (self, _tmp85_, _tmp82_, &no_array_length, &array_null_terminated, &_tmp86_);
		changed = _tmp86_;
		_vala_code_node_unref0 (type);
		type = _tmp87_;
		if (!changed) {
			ValaGirParserMetadata* _tmp88_;
			_tmp88_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp88_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE)) {
				ValaGirParserMetadata* _tmp89_;
				gchar* _tmp90_;
				_tmp89_ = self->priv->metadata;
				_tmp90_ = vala_gir_parser_metadata_get_string (_tmp89_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE);
				_g_free0 (ctype);
				ctype = _tmp90_;
			} else {
				_g_free0 (ctype);
				ctype = NULL;
			}
		}
		_tmp91_ = name;
		_tmp92_ = type;
		_tmp93_ = begin;
		_tmp94_ = vala_gir_parser_get_src (self, &_tmp93_, NULL);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_parameter_new (_tmp91_, _tmp92_, _tmp95_);
		_vala_code_node_unref0 (param);
		param = _tmp96_;
		_vala_source_reference_unref0 (_tmp95_);
		_tmp97_ = ctype;
		if (_tmp97_ != NULL) {
			ValaParameter* _tmp98_;
			const gchar* _tmp99_;
			_tmp98_ = param;
			_tmp99_ = ctype;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp98_, "CCode", "type", _tmp99_, NULL);
		}
		_tmp100_ = direction;
		if (g_strcmp0 (_tmp100_, "out") == 0) {
			ValaParameter* _tmp101_;
			_tmp101_ = param;
			vala_parameter_set_direction (_tmp101_, VALA_PARAMETER_DIRECTION_OUT);
		} else {
			const gchar* _tmp102_;
			_tmp102_ = direction;
			if (g_strcmp0 (_tmp102_, "inout") == 0) {
				ValaParameter* _tmp103_;
				_tmp103_ = param;
				vala_parameter_set_direction (_tmp103_, VALA_PARAMETER_DIRECTION_REF);
			}
		}
		_tmp105_ = type;
		if (VALA_IS_DELEGATE_TYPE (_tmp105_)) {
			ValaGirParserMetadata* _tmp106_;
			_tmp106_ = self->priv->metadata;
			_tmp104_ = vala_gir_parser_metadata_has_argument (_tmp106_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET);
		} else {
			_tmp104_ = FALSE;
		}
		if (_tmp104_) {
			ValaParameter* _tmp107_;
			ValaGirParserMetadata* _tmp108_;
			_tmp107_ = param;
			_tmp108_ = self->priv->metadata;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp107_, "CCode", "delegate_target", vala_gir_parser_metadata_get_bool (_tmp108_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET, FALSE), NULL);
		}
		_tmp109_ = type;
		if (VALA_IS_ARRAY_TYPE (_tmp109_)) {
			ValaGirParserMetadata* _tmp110_;
			_tmp110_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp110_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX)) {
				ValaGirParserMetadata* _tmp111_;
				_tmp111_ = self->priv->metadata;
				_vala_array_length_idx = vala_gir_parser_metadata_get_integer (_tmp111_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
			} else {
				gboolean _tmp112_ = FALSE;
				if (no_array_length) {
					_tmp112_ = TRUE;
				} else {
					_tmp112_ = array_null_terminated;
				}
				if (_tmp112_) {
					ValaParameter* _tmp113_;
					_tmp113_ = param;
					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp113_, "CCode", "array_length", !no_array_length, NULL);
				}
				if (array_null_terminated) {
					ValaParameter* _tmp114_;
					_tmp114_ = param;
					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp114_, "CCode", "array_null_terminated", array_null_terminated, NULL);
				}
			}
		}
		_tmp115_ = param;
		_tmp116_ = self->priv->metadata;
		_tmp117_ = vala_gir_parser_metadata_get_expression (_tmp116_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT);
		_tmp118_ = _tmp117_;
		vala_variable_set_initializer ((ValaVariable*) _tmp115_, _tmp118_);
		_vala_code_node_unref0 (_tmp118_);
		_tmp119_ = param;
		_tmp120_ = vala_variable_get_initializer ((ValaVariable*) _tmp119_);
		_tmp121_ = _tmp120_;
		if (VALA_IS_TUPLE (_tmp121_)) {
			ValaParameter* _tmp122_;
			_tmp122_ = param;
			vala_variable_set_initializer ((ValaVariable*) _tmp122_, NULL);
		}
		_vala_code_node_unref0 (type);
		_g_free0 (ctype);
	}
	_tmp123_ = element_type;
	vala_gir_parser_end_element (self, _tmp123_);
	result = param;
	_g_free0 (destroy);
	_g_free0 (closure);
	_g_free0 (allow_none);
	_g_free0 (nullable);
	_g_free0 (transfer);
	_g_free0 (direction);
	_g_free0 (name);
	_g_free0 (element_type);
	if (caller_allocates) {
		*caller_allocates = _vala_caller_allocates;
	}
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (closure_idx) {
		*closure_idx = _vala_closure_idx;
	}
	if (destroy_idx) {
		*destroy_idx = _vala_destroy_idx;
	}
	if (scope) {
		*scope = _vala_scope;
	} else {
		_g_free0 (_vala_scope);
	}
	if (comment) {
		*comment = _vala_comment;
	} else {
		_vala_comment_unref0 (_vala_comment);
	}
	return result;
}

static ValaDataType*
vala_gir_parser_parse_type (ValaGirParser* self,
                            gchar** ctype,
                            gint* array_length_idx,
                            gboolean transfer_elements,
                            gboolean* no_array_length,
                            gboolean* array_null_terminated)
{
	gchar* _vala_ctype = NULL;
	gint _vala_array_length_idx = 0;
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	gboolean is_array = FALSE;
	gchar* type_name = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gint fixed_length = 0;
	ValaMarkupReader* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaGirParserMetadata* _tmp40_;
	const gchar* _tmp45_;
	ValaDataType* type = NULL;
	const gchar* _tmp48_;
	const gchar* _tmp82_ = NULL;
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	is_array = FALSE;
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	type_name = _tmp1_;
	_g_free0 (_vala_ctype);
	_vala_ctype = NULL;
	fixed_length = -1;
	_vala_array_length_idx = -1;
	_vala_no_array_length = TRUE;
	_vala_array_null_terminated = TRUE;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "array") == 0) {
		ValaSourceReference* src = NULL;
		ValaSourceReference* _tmp5_;
		const gchar* _tmp6_;
		is_array = TRUE;
		vala_gir_parser_start_element (self, "array");
		_tmp5_ = vala_gir_parser_get_current_src (self);
		src = _tmp5_;
		_tmp6_ = type_name;
		if (_tmp6_ == NULL) {
			ValaMarkupReader* _tmp7_;
			ValaMarkupReader* _tmp11_;
			ValaMarkupReader* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gboolean _tmp18_;
			ValaMarkupReader* _tmp19_;
			ValaDataType* element_type = NULL;
			ValaDataType* _tmp23_;
			ValaDataType* _tmp24_;
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp25_;
			ValaSourceReference* _tmp26_;
			ValaArrayType* _tmp27_;
			_tmp7_ = self->priv->reader;
			if (vala_markup_reader_has_attribute (_tmp7_, "length")) {
				ValaMarkupReader* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp8_ = self->priv->reader;
				_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "length");
				_tmp10_ = _tmp9_;
				_vala_array_length_idx = atoi (_tmp10_);
				_g_free0 (_tmp10_);
				_vala_no_array_length = FALSE;
				_vala_array_null_terminated = FALSE;
			}
			_tmp11_ = self->priv->reader;
			if (vala_markup_reader_has_attribute (_tmp11_, "fixed-size")) {
				ValaMarkupReader* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = self->priv->reader;
				_tmp13_ = vala_markup_reader_get_attribute (_tmp12_, "fixed-size");
				_tmp14_ = _tmp13_;
				fixed_length = atoi (_tmp14_);
				_g_free0 (_tmp14_);
				_vala_array_null_terminated = FALSE;
			}
			_tmp15_ = self->priv->reader;
			_tmp16_ = vala_markup_reader_get_attribute (_tmp15_, "c:type");
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strcmp0 (_tmp17_, "GStrv") == 0;
			_g_free0 (_tmp17_);
			if (_tmp18_) {
				_vala_no_array_length = TRUE;
				_vala_array_null_terminated = TRUE;
			}
			_tmp19_ = self->priv->reader;
			if (vala_markup_reader_has_attribute (_tmp19_, "zero-terminated")) {
				ValaMarkupReader* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp20_ = self->priv->reader;
				_tmp21_ = vala_markup_reader_get_attribute (_tmp20_, "zero-terminated");
				_tmp22_ = _tmp21_;
				_vala_array_null_terminated = atoi (_tmp22_) != 0;
				_g_free0 (_tmp22_);
			}
			vala_gir_parser_next (self);
			_tmp23_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
			element_type = _tmp23_;
			_tmp24_ = element_type;
			vala_data_type_set_value_owned (_tmp24_, transfer_elements);
			vala_gir_parser_end_element (self, "array");
			_tmp25_ = element_type;
			_tmp26_ = src;
			_tmp27_ = vala_array_type_new (_tmp25_, 1, _tmp26_);
			array_type = _tmp27_;
			if (fixed_length > 0) {
				ValaArrayType* _tmp28_;
				ValaArrayType* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				ValaIntegerLiteral* _tmp32_;
				ValaIntegerLiteral* _tmp33_;
				_tmp28_ = array_type;
				vala_array_type_set_fixed_length (_tmp28_, TRUE);
				_tmp29_ = array_type;
				_tmp30_ = g_strdup_printf ("%i", fixed_length);
				_tmp31_ = _tmp30_;
				_tmp32_ = vala_integer_literal_new (_tmp31_, NULL);
				_tmp33_ = _tmp32_;
				vala_array_type_set_length (_tmp29_, (ValaExpression*) _tmp33_);
				_vala_code_node_unref0 (_tmp33_);
				_g_free0 (_tmp31_);
			}
			result = (ValaDataType*) array_type;
			_vala_code_node_unref0 (element_type);
			_vala_source_reference_unref0 (src);
			_g_free0 (type_name);
			if (ctype) {
				*ctype = _vala_ctype;
			} else {
				_g_free0 (_vala_ctype);
			}
			if (array_length_idx) {
				*array_length_idx = _vala_array_length_idx;
			}
			if (no_array_length) {
				*no_array_length = _vala_no_array_length;
			}
			if (array_null_terminated) {
				*array_null_terminated = _vala_array_null_terminated;
			}
			return result;
		}
		_vala_source_reference_unref0 (src);
	} else {
		ValaMarkupReader* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp34_ = self->priv->reader;
		_tmp35_ = vala_markup_reader_get_name (_tmp34_);
		_tmp36_ = _tmp35_;
		if (g_strcmp0 (_tmp36_, "callback") == 0) {
			ValaGirParserNode* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaDelegateType* _tmp39_;
			vala_gir_parser_parse_callback (self);
			_tmp37_ = self->priv->old_current;
			_tmp38_ = _tmp37_->symbol;
			_tmp39_ = vala_delegate_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_DELEGATE, ValaDelegate), NULL);
			result = (ValaDataType*) _tmp39_;
			_g_free0 (type_name);
			if (ctype) {
				*ctype = _vala_ctype;
			} else {
				_g_free0 (_vala_ctype);
			}
			if (array_length_idx) {
				*array_length_idx = _vala_array_length_idx;
			}
			if (no_array_length) {
				*no_array_length = _vala_no_array_length;
			}
			if (array_null_terminated) {
				*array_null_terminated = _vala_array_null_terminated;
			}
			return result;
		} else {
			vala_gir_parser_start_element (self, "type");
		}
	}
	_tmp40_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp40_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE)) {
		ValaGirParserMetadata* _tmp41_;
		gchar* _tmp42_;
		_tmp41_ = self->priv->metadata;
		_tmp42_ = vala_gir_parser_metadata_get_string (_tmp41_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE);
		_g_free0 (_vala_ctype);
		_vala_ctype = _tmp42_;
	} else {
		ValaMarkupReader* _tmp43_;
		gchar* _tmp44_;
		_tmp43_ = self->priv->reader;
		_tmp44_ = vala_markup_reader_get_attribute (_tmp43_, "c:type");
		_g_free0 (_vala_ctype);
		_vala_ctype = _tmp44_;
	}
	vala_gir_parser_next (self);
	_tmp45_ = type_name;
	if (_tmp45_ == NULL) {
		const gchar* _tmp46_;
		gchar* _tmp47_;
		_tmp46_ = _vala_ctype;
		_tmp47_ = g_strdup (_tmp46_);
		_g_free0 (type_name);
		type_name = _tmp47_;
	}
	_tmp48_ = type_name;
	if (_tmp48_ != NULL) {
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		gboolean _tmp51_ = FALSE;
		gboolean _tmp52_ = FALSE;
		ValaDataType* _tmp53_;
		_tmp49_ = type_name;
		_tmp50_ = _vala_ctype;
		_tmp53_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp49_, &_tmp51_, &_tmp52_, _tmp50_);
		_vala_no_array_length = _tmp51_;
		_vala_array_null_terminated = _tmp52_;
		_vala_code_node_unref0 (type);
		type = _tmp53_;
	} else {
		ValaInvalidType* _tmp54_;
		ValaSourceReference* _tmp55_;
		ValaSourceReference* _tmp56_;
		_vala_no_array_length = FALSE;
		_vala_array_null_terminated = FALSE;
		_tmp54_ = vala_invalid_type_new ();
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp54_;
		_tmp55_ = vala_gir_parser_get_current_src (self);
		_tmp56_ = _tmp55_;
		vala_report_error (_tmp56_, "empty type element");
		_vala_source_reference_unref0 (_tmp56_);
	}
	while (TRUE) {
		const gchar* _tmp57_;
		ValaDataType* element_type = NULL;
		ValaDataType* _tmp58_;
		ValaDataType* _tmp59_;
		ValaDataType* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp57_ = type_name;
		if (g_strcmp0 (_tmp57_, "GLib.ByteArray") == 0) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp58_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
		element_type = _tmp58_;
		_tmp59_ = element_type;
		vala_data_type_set_value_owned (_tmp59_, transfer_elements);
		_tmp60_ = type;
		_tmp61_ = element_type;
		vala_data_type_add_type_argument (_tmp60_, _tmp61_);
		_tmp62_ = element_type;
		if (VALA_IS_UNRESOLVED_TYPE (_tmp62_)) {
			ValaGirParserNode* _tmp63_ = NULL;
			ValaGirParserNode* _tmp64_;
			ValaGirParserNode* parent = NULL;
			ValaGirParserNode* _tmp66_;
			ValaHashMap* _tmp79_;
			ValaDataType* _tmp80_;
			ValaGirParserNode* _tmp81_;
			_tmp64_ = self->priv->current;
			_tmp63_ = _tmp64_;
			if (_tmp63_ == NULL) {
				ValaGirParserNode* _tmp65_;
				_tmp65_ = self->priv->root;
				_tmp63_ = _tmp65_;
			}
			_tmp66_ = _vala_gir_parser_node_ref0 (_tmp63_);
			parent = _tmp66_;
			while (TRUE) {
				gboolean _tmp67_ = FALSE;
				gboolean _tmp68_ = FALSE;
				ValaGirParserNode* _tmp69_;
				ValaGirParserNode* _tmp70_;
				ValaGirParserNode* _tmp76_;
				ValaGirParserNode* _tmp77_;
				ValaGirParserNode* _tmp78_;
				_tmp69_ = parent;
				_tmp70_ = self->priv->root;
				if (_tmp69_ != _tmp70_) {
					ValaGirParserNode* _tmp71_;
					ValaGirParserNode* _tmp72_;
					_tmp71_ = parent;
					_tmp72_ = _tmp71_->parent;
					_tmp68_ = _tmp72_ != NULL;
				} else {
					_tmp68_ = FALSE;
				}
				if (_tmp68_) {
					ValaGirParserNode* _tmp73_;
					ValaGirParserNode* _tmp74_;
					ValaGirParserNode* _tmp75_;
					_tmp73_ = parent;
					_tmp74_ = _tmp73_->parent;
					_tmp75_ = self->priv->root;
					_tmp67_ = _tmp74_ != _tmp75_;
				} else {
					_tmp67_ = FALSE;
				}
				if (!_tmp67_) {
					break;
				}
				_tmp76_ = parent;
				_tmp77_ = _tmp76_->parent;
				_tmp78_ = _vala_gir_parser_node_ref0 (_tmp77_);
				_vala_gir_parser_node_unref0 (parent);
				parent = _tmp78_;
			}
			_tmp79_ = self->priv->unresolved_type_arguments;
			_tmp80_ = element_type;
			_tmp81_ = parent;
			vala_map_set ((ValaMap*) _tmp79_, G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType), _tmp81_);
			_vala_gir_parser_node_unref0 (parent);
		}
		_vala_code_node_unref0 (element_type);
	}
	if (is_array) {
		_tmp82_ = "array";
	} else {
		_tmp82_ = "type";
	}
	vala_gir_parser_end_element (self, _tmp82_);
	result = type;
	_g_free0 (type_name);
	if (ctype) {
		*ctype = _vala_ctype;
	} else {
		_g_free0 (_vala_ctype);
	}
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	return result;
}

static ValaDataType*
vala_gir_parser_parse_type_from_gir_name (ValaGirParser* self,
                                          const gchar* type_name,
                                          gboolean* no_array_length,
                                          gboolean* array_null_terminated,
                                          const gchar* ctype)
{
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaDataType* type = NULL;
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	_vala_no_array_length = FALSE;
	_vala_array_null_terminated = FALSE;
	type = NULL;
	if (g_strcmp0 (type_name, "none") == 0) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		ValaVoidType* _tmp2_;
		_tmp0_ = vala_gir_parser_get_current_src (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_void_type_new (_tmp1_);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp2_;
		_vala_source_reference_unref0 (_tmp1_);
	} else {
		if (g_strcmp0 (type_name, "gpointer") == 0) {
			ValaSourceReference* _tmp3_;
			ValaSourceReference* _tmp4_;
			ValaVoidType* _tmp5_;
			ValaVoidType* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaPointerType* _tmp9_;
			_tmp3_ = vala_gir_parser_get_current_src (self);
			_tmp4_ = _tmp3_;
			_tmp5_ = vala_void_type_new (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_gir_parser_get_current_src (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_pointer_type_new ((ValaDataType*) _tmp6_, _tmp8_);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp9_;
			_vala_source_reference_unref0 (_tmp8_);
			_vala_code_node_unref0 (_tmp6_);
			_vala_source_reference_unref0 (_tmp4_);
		} else {
			if (g_strcmp0 (type_name, "GObject.Strv") == 0) {
				ValaUnresolvedType* element_type = NULL;
				ValaUnresolvedSymbol* _tmp10_;
				ValaUnresolvedSymbol* _tmp11_;
				ValaUnresolvedType* _tmp12_;
				ValaUnresolvedType* _tmp13_;
				ValaUnresolvedType* _tmp14_;
				ValaUnresolvedType* _tmp15_;
				ValaSourceReference* _tmp16_;
				ValaSourceReference* _tmp17_;
				ValaArrayType* _tmp18_;
				_tmp10_ = vala_unresolved_symbol_new (NULL, "string", NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_unresolved_type_new_from_symbol (_tmp11_, NULL);
				_tmp13_ = _tmp12_;
				_vala_code_node_unref0 (_tmp11_);
				element_type = _tmp13_;
				_tmp14_ = element_type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp14_, TRUE);
				_tmp15_ = element_type;
				_tmp16_ = vala_gir_parser_get_current_src (self);
				_tmp17_ = _tmp16_;
				_tmp18_ = vala_array_type_new ((ValaDataType*) _tmp15_, 1, _tmp17_);
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp18_;
				_vala_source_reference_unref0 (_tmp17_);
				_vala_no_array_length = TRUE;
				_vala_array_null_terminated = TRUE;
				_vala_code_node_unref0 (element_type);
			} else {
				gboolean known_type = FALSE;
				ValaDataType* _tmp36_;
				known_type = TRUE;
				if (g_strcmp0 (type_name, "utf8") == 0) {
					gboolean _tmp19_ = FALSE;
					gboolean _tmp20_ = FALSE;
					gboolean _tmp21_ = FALSE;
					if (ctype == NULL) {
						_tmp21_ = TRUE;
					} else {
						_tmp21_ = g_str_has_suffix (ctype, "*");
					}
					if (_tmp21_) {
						_tmp20_ = TRUE;
					} else {
						_tmp20_ = g_strcmp0 (ctype, "gpointer") == 0;
					}
					if (_tmp20_) {
						_tmp19_ = TRUE;
					} else {
						_tmp19_ = g_strcmp0 (ctype, "gconstpointer") == 0;
					}
					if (_tmp19_) {
						type_name = "string";
					} else {
						type_name = "char";
					}
				} else {
					if (g_strcmp0 (type_name, "gboolean") == 0) {
						ValaCodeContext* _tmp22_;
						ValaNamespace* _tmp23_;
						ValaNamespace* _tmp24_;
						ValaScope* _tmp25_;
						ValaScope* _tmp26_;
						ValaSymbol* _tmp27_;
						ValaStruct* _tmp28_;
						ValaBooleanType* _tmp29_;
						_tmp22_ = self->priv->context;
						_tmp23_ = vala_code_context_get_root (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = vala_symbol_get_scope ((ValaSymbol*) _tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = vala_scope_lookup (_tmp26_, "bool");
						_tmp28_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_STRUCT, ValaStruct);
						_tmp29_ = vala_boolean_type_new (_tmp28_, NULL);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp29_;
						_vala_code_node_unref0 (_tmp28_);
					} else {
						if (g_strcmp0 (type_name, "gchar") == 0) {
							type_name = "char";
						} else {
							if (g_strcmp0 (type_name, "gshort") == 0) {
								type_name = "short";
							} else {
								if (g_strcmp0 (type_name, "gushort") == 0) {
									type_name = "ushort";
								} else {
									if (g_strcmp0 (type_name, "gint") == 0) {
										type_name = "int";
									} else {
										if (g_strcmp0 (type_name, "guint") == 0) {
											type_name = "uint";
										} else {
											if (g_strcmp0 (type_name, "glong") == 0) {
												gboolean _tmp30_ = FALSE;
												if (ctype != NULL) {
													_tmp30_ = g_str_has_prefix (ctype, "gssize");
												} else {
													_tmp30_ = FALSE;
												}
												if (_tmp30_) {
													type_name = "ssize_t";
												} else {
													gboolean _tmp31_ = FALSE;
													if (ctype != NULL) {
														_tmp31_ = g_str_has_prefix (ctype, "gintptr");
													} else {
														_tmp31_ = FALSE;
													}
													if (_tmp31_) {
														type_name = "intptr";
													} else {
														gboolean _tmp32_ = FALSE;
														if (ctype != NULL) {
															_tmp32_ = g_str_has_prefix (ctype, "time_t");
														} else {
															_tmp32_ = FALSE;
														}
														if (_tmp32_) {
															type_name = "time_t";
														} else {
															type_name = "long";
														}
													}
												}
											} else {
												if (g_strcmp0 (type_name, "gulong") == 0) {
													gboolean _tmp33_ = FALSE;
													if (ctype != NULL) {
														_tmp33_ = g_str_has_prefix (ctype, "gsize");
													} else {
														_tmp33_ = FALSE;
													}
													if (_tmp33_) {
														type_name = "size_t";
													} else {
														gboolean _tmp34_ = FALSE;
														if (ctype != NULL) {
															_tmp34_ = g_str_has_prefix (ctype, "guintptr");
														} else {
															_tmp34_ = FALSE;
														}
														if (_tmp34_) {
															type_name = "uintptr";
														} else {
															type_name = "ulong";
														}
													}
												} else {
													if (g_strcmp0 (type_name, "gint8") == 0) {
														type_name = "int8";
													} else {
														if (g_strcmp0 (type_name, "guint8") == 0) {
															type_name = "uint8";
														} else {
															if (g_strcmp0 (type_name, "gint16") == 0) {
																type_name = "int16";
															} else {
																if (g_strcmp0 (type_name, "guint16") == 0) {
																	type_name = "uint16";
																} else {
																	if (g_strcmp0 (type_name, "gint32") == 0) {
																		type_name = "int32";
																	} else {
																		if (g_strcmp0 (type_name, "guint32") == 0) {
																			type_name = "uint32";
																		} else {
																			if (g_strcmp0 (type_name, "gint64") == 0) {
																				type_name = "int64";
																			} else {
																				if (g_strcmp0 (type_name, "guint64") == 0) {
																					type_name = "uint64";
																				} else {
																					if (g_strcmp0 (type_name, "gfloat") == 0) {
																						type_name = "float";
																					} else {
																						if (g_strcmp0 (type_name, "gdouble") == 0) {
																							type_name = "double";
																						} else {
																							if (g_strcmp0 (type_name, "filename") == 0) {
																								type_name = "string";
																							} else {
																								if (g_strcmp0 (type_name, "GLib.offset") == 0) {
																									type_name = "int64";
																								} else {
																									if (g_strcmp0 (type_name, "gsize") == 0) {
																										gboolean _tmp35_ = FALSE;
																										if (ctype != NULL) {
																											_tmp35_ = g_str_has_prefix (ctype, "off_t");
																										} else {
																											_tmp35_ = FALSE;
																										}
																										if (_tmp35_) {
																											type_name = "off_t";
																										} else {
																											type_name = "size_t";
																										}
																									} else {
																										if (g_strcmp0 (type_name, "gssize") == 0) {
																											type_name = "ssize_t";
																										} else {
																											if (g_strcmp0 (type_name, "guintptr") == 0) {
																												type_name = "uintptr";
																											} else {
																												if (g_strcmp0 (type_name, "gintptr") == 0) {
																													type_name = "intptr";
																												} else {
																													if (g_strcmp0 (type_name, "GType") == 0) {
																														type_name = "GLib.Type";
																													} else {
																														if (g_strcmp0 (type_name, "GObject.Class") == 0) {
																															type_name = "GLib.ObjectClass";
																														} else {
																															if (g_strcmp0 (type_name, "gunichar") == 0) {
																																type_name = "unichar";
																															} else {
																																if (g_strcmp0 (type_name, "Atk.ImplementorIface") == 0) {
																																	type_name = "Atk.Implementor";
																																} else {
																																	known_type = FALSE;
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				_tmp36_ = type;
				if (_tmp36_ == NULL) {
					ValaUnresolvedSymbol* sym = NULL;
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaUnresolvedSymbol* _tmp39_;
					ValaUnresolvedSymbol* _tmp40_;
					ValaUnresolvedSymbol* _tmp41_;
					ValaSourceReference* _tmp42_;
					ValaSourceReference* _tmp43_;
					ValaUnresolvedType* _tmp44_;
					_tmp37_ = vala_gir_parser_get_current_src (self);
					_tmp38_ = _tmp37_;
					_tmp39_ = vala_gir_parser_parse_symbol_from_string (self, type_name, _tmp38_);
					_tmp40_ = _tmp39_;
					_vala_source_reference_unref0 (_tmp38_);
					sym = _tmp40_;
					_tmp41_ = sym;
					_tmp42_ = vala_gir_parser_get_current_src (self);
					_tmp43_ = _tmp42_;
					_tmp44_ = vala_unresolved_type_new_from_symbol (_tmp41_, _tmp43_);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp44_;
					_vala_source_reference_unref0 (_tmp43_);
					if (!known_type) {
						ValaArrayList* _tmp45_;
						ValaUnresolvedSymbol* _tmp46_;
						_tmp45_ = self->priv->unresolved_gir_symbols;
						_tmp46_ = sym;
						vala_collection_add ((ValaCollection*) _tmp45_, _tmp46_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	result = type;
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	return result;
}

static void
vala_gir_parser_parse_record (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaStruct* st = NULL;
	gboolean require_copy_free = FALSE;
	ValaGirParserNode* _tmp2_;
	ValaStruct* _tmp14_;
	ValaStruct* _tmp15_;
	ValaStruct* _tmp16_;
	gchar* gtype_struct_for = NULL;
	ValaMarkupReader* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gboolean first_field = FALSE;
	ValaStruct* _tmp28_;
	ValaGirComment* _tmp29_;
	ValaGirComment* _tmp30_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "record");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	require_copy_free = FALSE;
	_tmp2_ = self->priv->current;
	if (_tmp2_->new_symbol) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		ValaGirParserNode* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaStruct* _tmp7_;
		ValaGirParserNode* _tmp8_;
		ValaStruct* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp3_ = vala_gir_parser_element_get_name (self, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->source_reference;
		_tmp7_ = vala_struct_new (_tmp4_, _tmp6_, NULL);
		_vala_code_node_unref0 (st);
		st = _tmp7_;
		_g_free0 (_tmp4_);
		_tmp8_ = self->priv->current;
		_tmp9_ = st;
		_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp9_);
		_vala_code_node_unref0 (_tmp8_->symbol);
		_tmp8_->symbol = _tmp10_;
	} else {
		ValaGirParserNode* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaStruct* _tmp13_;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_->symbol;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_STRUCT, ValaStruct));
		_vala_code_node_unref0 (st);
		st = _tmp13_;
	}
	_tmp14_ = st;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp14_);
	_tmp15_ = st;
	require_copy_free = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp15_, "CCode", "type_id");
	_tmp16_ = st;
	vala_symbol_set_access ((ValaSymbol*) _tmp16_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp17_ = self->priv->reader;
	_tmp18_ = vala_markup_reader_get_attribute (_tmp17_, "glib:is-gtype-struct-for");
	gtype_struct_for = _tmp18_;
	_tmp19_ = gtype_struct_for;
	if (_tmp19_ != NULL) {
		ValaGirParserNode* _tmp20_;
		const gchar* _tmp21_;
		ValaGirParserNode* _tmp22_;
		ValaSourceReference* _tmp23_;
		ValaUnresolvedSymbol* _tmp24_;
		ValaArrayList* _tmp25_;
		ValaGirParserNode* _tmp26_;
		ValaUnresolvedSymbol* _tmp27_;
		_tmp20_ = self->priv->current;
		_tmp21_ = gtype_struct_for;
		_tmp22_ = self->priv->current;
		_tmp23_ = _tmp22_->source_reference;
		_tmp24_ = vala_gir_parser_parse_symbol_from_string (self, _tmp21_, _tmp23_);
		_vala_code_node_unref0 (_tmp20_->gtype_struct_for);
		_tmp20_->gtype_struct_for = _tmp24_;
		_tmp25_ = self->priv->unresolved_gir_symbols;
		_tmp26_ = self->priv->current;
		_tmp27_ = _tmp26_->gtype_struct_for;
		vala_collection_add ((ValaCollection*) _tmp25_, _tmp27_);
	}
	first_field = TRUE;
	vala_gir_parser_next (self);
	_tmp28_ = st;
	_tmp29_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp30_ = _tmp29_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp28_, (ValaComment*) _tmp30_);
	_vala_comment_unref0 (_tmp30_);
	while (TRUE) {
		ValaMarkupReader* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			gboolean _tmp31_ = FALSE;
			if (first_field) {
				ValaMarkupReader* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				_tmp32_ = self->priv->reader;
				_tmp33_ = vala_markup_reader_get_name (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp31_ = g_strcmp0 (_tmp34_, "field") == 0;
			} else {
				_tmp31_ = FALSE;
			}
			if (_tmp31_) {
				first_field = FALSE;
			}
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp35_ = self->priv->reader;
		_tmp36_ = vala_markup_reader_get_name (_tmp35_);
		_tmp37_ = _tmp36_;
		if (g_strcmp0 (_tmp37_, "field") == 0) {
			gboolean _tmp38_ = FALSE;
			ValaMarkupReader* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gboolean _tmp42_;
			_tmp39_ = self->priv->reader;
			_tmp40_ = vala_markup_reader_get_attribute (_tmp39_, "name");
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strcmp0 (_tmp41_, "priv") != 0;
			_g_free0 (_tmp41_);
			if (_tmp42_) {
				gboolean _tmp43_ = FALSE;
				if (first_field) {
					const gchar* _tmp44_;
					_tmp44_ = gtype_struct_for;
					_tmp43_ = _tmp44_ != NULL;
				} else {
					_tmp43_ = FALSE;
				}
				_tmp38_ = !_tmp43_;
			} else {
				_tmp38_ = FALSE;
			}
			if (_tmp38_) {
				vala_gir_parser_parse_field (self);
			} else {
				vala_gir_parser_skip_element (self);
			}
			first_field = FALSE;
		} else {
			ValaMarkupReader* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			_tmp45_ = self->priv->reader;
			_tmp46_ = vala_markup_reader_get_name (_tmp45_);
			_tmp47_ = _tmp46_;
			if (g_strcmp0 (_tmp47_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				_tmp48_ = self->priv->reader;
				_tmp49_ = vala_markup_reader_get_name (_tmp48_);
				_tmp50_ = _tmp49_;
				if (g_strcmp0 (_tmp50_, "method") == 0) {
					vala_gir_parser_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp53_;
					_tmp51_ = self->priv->reader;
					_tmp52_ = vala_markup_reader_get_name (_tmp51_);
					_tmp53_ = _tmp52_;
					if (g_strcmp0 (_tmp53_, "function") == 0) {
						vala_gir_parser_parse_method (self, "function");
					} else {
						ValaMarkupReader* _tmp54_;
						const gchar* _tmp55_;
						const gchar* _tmp56_;
						_tmp54_ = self->priv->reader;
						_tmp55_ = vala_markup_reader_get_name (_tmp54_);
						_tmp56_ = _tmp55_;
						if (g_strcmp0 (_tmp56_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp57_;
							const gchar* _tmp58_;
							const gchar* _tmp59_;
							_tmp57_ = self->priv->reader;
							_tmp58_ = vala_markup_reader_get_name (_tmp57_);
							_tmp59_ = _tmp58_;
							if (g_strcmp0 (_tmp59_, "union") == 0) {
								vala_gir_parser_parse_union (self);
							} else {
								ValaSourceReference* _tmp60_;
								ValaSourceReference* _tmp61_;
								ValaMarkupReader* _tmp62_;
								const gchar* _tmp63_;
								const gchar* _tmp64_;
								_tmp60_ = vala_gir_parser_get_current_src (self);
								_tmp61_ = _tmp60_;
								_tmp62_ = self->priv->reader;
								_tmp63_ = vala_markup_reader_get_name (_tmp62_);
								_tmp64_ = _tmp63_;
								vala_report_error (_tmp61_, "unknown child element `%s' in `record'", _tmp64_);
								_vala_source_reference_unref0 (_tmp61_);
								vala_gir_parser_skip_element (self);
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	if (require_copy_free) {
		ValaStruct* _tmp65_;
		ValaStruct* _tmp66_;
		_tmp65_ = st;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp65_, "CCode", "copy_function", "g_boxed_copy", NULL);
		_tmp66_ = st;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp66_, "CCode", "free_function", "g_boxed_free", NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "record");
	_g_free0 (gtype_struct_for);
	_vala_code_node_unref0 (st);
}

static void
vala_gir_parser_parse_class (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaClass* cl = NULL;
	gchar* parent = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	ValaGirParserNode* _tmp4_;
	ValaClass* _tmp47_;
	ValaClass* _tmp48_;
	ValaGirParserMetadata* _tmp49_;
	ValaGirParserMetadata* _tmp59_;
	ValaGirParserMetadata* _tmp64_;
	ValaClass* _tmp74_;
	ValaGirComment* _tmp75_;
	ValaGirComment* _tmp76_;
	gboolean first_field = FALSE;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "class");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "parent");
	parent = _tmp3_;
	_tmp4_ = self->priv->current;
	if (_tmp4_->new_symbol) {
		ValaGirParserNode* _tmp5_;
		const gchar* _tmp6_;
		ValaGirParserNode* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaClass* _tmp9_;
		ValaClass* _tmp10_;
		ValaGirParserMetadata* _tmp11_;
		ValaMarkupReader* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		ValaClass* _tmp15_;
		ValaGirParserMetadata* _tmp16_;
		ValaMarkupReader* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		ValaGirParserMetadata* _tmp20_;
		const gchar* _tmp25_;
		gchar* type_struct = NULL;
		ValaMarkupReader* _tmp30_;
		gchar* _tmp31_;
		const gchar* _tmp32_;
		ValaGirParserNode* _tmp41_;
		ValaClass* _tmp42_;
		ValaSymbol* _tmp43_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->name;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->source_reference;
		_tmp9_ = vala_class_new (_tmp6_, _tmp8_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp9_;
		_tmp10_ = cl;
		_tmp11_ = self->priv->metadata;
		_tmp12_ = self->priv->reader;
		_tmp13_ = vala_markup_reader_get_attribute (_tmp12_, "abstract");
		_tmp14_ = _tmp13_;
		vala_class_set_is_abstract (_tmp10_, vala_gir_parser_metadata_get_bool (_tmp11_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, g_strcmp0 (_tmp14_, "1") == 0));
		_g_free0 (_tmp14_);
		_tmp15_ = cl;
		_tmp16_ = self->priv->metadata;
		_tmp17_ = self->priv->reader;
		_tmp18_ = vala_markup_reader_get_attribute (_tmp17_, "final");
		_tmp19_ = _tmp18_;
		vala_class_set_is_sealed (_tmp15_, vala_gir_parser_metadata_get_bool (_tmp16_, VALA_GIR_PARSER_ARGUMENT_TYPE_SEALED, g_strcmp0 (_tmp19_, "1") == 0));
		_g_free0 (_tmp19_);
		_tmp20_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp20_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_GET_FUNCTION)) {
			ValaClass* _tmp21_;
			ValaGirParserMetadata* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp21_ = cl;
			_tmp22_ = self->priv->metadata;
			_tmp23_ = vala_gir_parser_metadata_get_string (_tmp22_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_GET_FUNCTION);
			_tmp24_ = _tmp23_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp21_, "CCode", "type_get_function", _tmp24_, NULL);
			_g_free0 (_tmp24_);
		}
		_tmp25_ = parent;
		if (_tmp25_ != NULL) {
			ValaClass* _tmp26_;
			const gchar* _tmp27_;
			ValaDataType* _tmp28_;
			ValaDataType* _tmp29_;
			_tmp26_ = cl;
			_tmp27_ = parent;
			_tmp28_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp27_, NULL, NULL, NULL);
			_tmp29_ = _tmp28_;
			vala_class_add_base_type (_tmp26_, _tmp29_);
			_vala_code_node_unref0 (_tmp29_);
		}
		_tmp30_ = self->priv->reader;
		_tmp31_ = vala_markup_reader_get_attribute (_tmp30_, "glib:type-struct");
		type_struct = _tmp31_;
		_tmp32_ = type_struct;
		if (_tmp32_ != NULL) {
			ValaGirParserNode* _tmp33_;
			const gchar* _tmp34_;
			ValaGirParserNode* _tmp35_;
			ValaSourceReference* _tmp36_;
			ValaUnresolvedSymbol* _tmp37_;
			ValaArrayList* _tmp38_;
			ValaGirParserNode* _tmp39_;
			ValaUnresolvedSymbol* _tmp40_;
			_tmp33_ = self->priv->current;
			_tmp34_ = type_struct;
			_tmp35_ = self->priv->current;
			_tmp36_ = _tmp35_->source_reference;
			_tmp37_ = vala_gir_parser_parse_symbol_from_string (self, _tmp34_, _tmp36_);
			_vala_code_node_unref0 (_tmp33_->type_struct);
			_tmp33_->type_struct = _tmp37_;
			_tmp38_ = self->priv->unresolved_gir_symbols;
			_tmp39_ = self->priv->current;
			_tmp40_ = _tmp39_->type_struct;
			vala_collection_add ((ValaCollection*) _tmp38_, _tmp40_);
		}
		_tmp41_ = self->priv->current;
		_tmp42_ = cl;
		_tmp43_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp42_);
		_vala_code_node_unref0 (_tmp41_->symbol);
		_tmp41_->symbol = _tmp43_;
		_g_free0 (type_struct);
	} else {
		ValaGirParserNode* _tmp44_;
		ValaSymbol* _tmp45_;
		ValaClass* _tmp46_;
		_tmp44_ = self->priv->current;
		_tmp45_ = _tmp44_->symbol;
		_tmp46_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_CLASS, ValaClass));
		_vala_code_node_unref0 (cl);
		cl = _tmp46_;
	}
	_tmp47_ = cl;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp47_);
	_tmp48_ = cl;
	vala_symbol_set_access ((ValaSymbol*) _tmp48_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp49_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp49_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF_FUNCTION)) {
		ValaClass* _tmp50_;
		ValaGirParserMetadata* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		_tmp50_ = cl;
		_tmp51_ = self->priv->metadata;
		_tmp52_ = vala_gir_parser_metadata_get_string (_tmp51_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF_FUNCTION);
		_tmp53_ = _tmp52_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp50_, "CCode", "ref_function", _tmp53_, NULL);
		_g_free0 (_tmp53_);
	} else {
		ValaMarkupReader* _tmp54_;
		_tmp54_ = self->priv->reader;
		if (vala_markup_reader_has_attribute (_tmp54_, "glib:ref-func")) {
			ValaClass* _tmp55_;
			ValaMarkupReader* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			_tmp55_ = cl;
			_tmp56_ = self->priv->reader;
			_tmp57_ = vala_markup_reader_get_attribute (_tmp56_, "glib:ref-func");
			_tmp58_ = _tmp57_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp55_, "CCode", "ref_function", _tmp58_, NULL);
			_g_free0 (_tmp58_);
		}
	}
	_tmp59_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp59_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF_SINK_FUNCTION)) {
		ValaClass* _tmp60_;
		ValaGirParserMetadata* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		_tmp60_ = cl;
		_tmp61_ = self->priv->metadata;
		_tmp62_ = vala_gir_parser_metadata_get_string (_tmp61_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF_SINK_FUNCTION);
		_tmp63_ = _tmp62_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp60_, "CCode", "ref_sink_function", _tmp63_, NULL);
		_g_free0 (_tmp63_);
	}
	_tmp64_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp64_, VALA_GIR_PARSER_ARGUMENT_TYPE_UNREF_FUNCTION)) {
		ValaClass* _tmp65_;
		ValaGirParserMetadata* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		_tmp65_ = cl;
		_tmp66_ = self->priv->metadata;
		_tmp67_ = vala_gir_parser_metadata_get_string (_tmp66_, VALA_GIR_PARSER_ARGUMENT_TYPE_UNREF_FUNCTION);
		_tmp68_ = _tmp67_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp65_, "CCode", "unref_function", _tmp68_, NULL);
		_g_free0 (_tmp68_);
	} else {
		ValaMarkupReader* _tmp69_;
		_tmp69_ = self->priv->reader;
		if (vala_markup_reader_has_attribute (_tmp69_, "glib:unref-func")) {
			ValaClass* _tmp70_;
			ValaMarkupReader* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			_tmp70_ = cl;
			_tmp71_ = self->priv->reader;
			_tmp72_ = vala_markup_reader_get_attribute (_tmp71_, "glib:unref-func");
			_tmp73_ = _tmp72_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp70_, "CCode", "unref_function", _tmp73_, NULL);
			_g_free0 (_tmp73_);
		}
	}
	vala_gir_parser_next (self);
	_tmp74_ = cl;
	_tmp75_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp76_ = _tmp75_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp74_, (ValaComment*) _tmp76_);
	_vala_comment_unref0 (_tmp76_);
	first_field = TRUE;
	while (TRUE) {
		ValaMarkupReader* _tmp81_;
		const gchar* _tmp82_;
		const gchar* _tmp83_;
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			gboolean _tmp77_ = FALSE;
			if (first_field) {
				ValaMarkupReader* _tmp78_;
				const gchar* _tmp79_;
				const gchar* _tmp80_;
				_tmp78_ = self->priv->reader;
				_tmp79_ = vala_markup_reader_get_name (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp77_ = g_strcmp0 (_tmp80_, "field") == 0;
			} else {
				_tmp77_ = FALSE;
			}
			if (_tmp77_) {
				first_field = FALSE;
			}
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp81_ = self->priv->reader;
		_tmp82_ = vala_markup_reader_get_name (_tmp81_);
		_tmp83_ = _tmp82_;
		if (g_strcmp0 (_tmp83_, "implements") == 0) {
			ValaClass* _tmp84_;
			ValaMarkupReader* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			ValaDataType* _tmp88_;
			ValaDataType* _tmp89_;
			vala_gir_parser_start_element (self, "implements");
			_tmp84_ = cl;
			_tmp85_ = self->priv->reader;
			_tmp86_ = vala_markup_reader_get_attribute (_tmp85_, "name");
			_tmp87_ = _tmp86_;
			_tmp88_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp87_, NULL, NULL, NULL);
			_tmp89_ = _tmp88_;
			vala_class_add_base_type (_tmp84_, _tmp89_);
			_vala_code_node_unref0 (_tmp89_);
			_g_free0 (_tmp87_);
			vala_gir_parser_next (self);
			vala_gir_parser_end_element (self, "implements");
		} else {
			ValaMarkupReader* _tmp90_;
			const gchar* _tmp91_;
			const gchar* _tmp92_;
			_tmp90_ = self->priv->reader;
			_tmp91_ = vala_markup_reader_get_name (_tmp90_);
			_tmp92_ = _tmp91_;
			if (g_strcmp0 (_tmp92_, "constant") == 0) {
				vala_gir_parser_parse_constant (self);
			} else {
				ValaMarkupReader* _tmp93_;
				const gchar* _tmp94_;
				const gchar* _tmp95_;
				_tmp93_ = self->priv->reader;
				_tmp94_ = vala_markup_reader_get_name (_tmp93_);
				_tmp95_ = _tmp94_;
				if (g_strcmp0 (_tmp95_, "field") == 0) {
					gboolean _tmp96_ = FALSE;
					if (first_field) {
						const gchar* _tmp97_;
						_tmp97_ = parent;
						_tmp96_ = _tmp97_ != NULL;
					} else {
						_tmp96_ = FALSE;
					}
					if (_tmp96_) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp98_;
						gchar* _tmp99_;
						gchar* _tmp100_;
						gboolean _tmp101_;
						_tmp98_ = self->priv->reader;
						_tmp99_ = vala_markup_reader_get_attribute (_tmp98_, "name");
						_tmp100_ = _tmp99_;
						_tmp101_ = g_strcmp0 (_tmp100_, "priv") != 0;
						_g_free0 (_tmp100_);
						if (_tmp101_) {
							vala_gir_parser_parse_field (self);
						} else {
							vala_gir_parser_skip_element (self);
						}
					}
					first_field = FALSE;
				} else {
					ValaMarkupReader* _tmp102_;
					const gchar* _tmp103_;
					const gchar* _tmp104_;
					_tmp102_ = self->priv->reader;
					_tmp103_ = vala_markup_reader_get_name (_tmp102_);
					_tmp104_ = _tmp103_;
					if (g_strcmp0 (_tmp104_, "property") == 0) {
						ValaProperty* _tmp105_;
						ValaProperty* _tmp106_;
						_tmp105_ = vala_gir_parser_parse_property (self);
						_tmp106_ = _tmp105_;
						_vala_code_node_unref0 (_tmp106_);
					} else {
						ValaMarkupReader* _tmp107_;
						const gchar* _tmp108_;
						const gchar* _tmp109_;
						_tmp107_ = self->priv->reader;
						_tmp108_ = vala_markup_reader_get_name (_tmp107_);
						_tmp109_ = _tmp108_;
						if (g_strcmp0 (_tmp109_, "constructor") == 0) {
							vala_gir_parser_parse_constructor (self);
						} else {
							ValaMarkupReader* _tmp110_;
							const gchar* _tmp111_;
							const gchar* _tmp112_;
							_tmp110_ = self->priv->reader;
							_tmp111_ = vala_markup_reader_get_name (_tmp110_);
							_tmp112_ = _tmp111_;
							if (g_strcmp0 (_tmp112_, "function") == 0) {
								vala_gir_parser_parse_method (self, "function");
							} else {
								ValaMarkupReader* _tmp113_;
								const gchar* _tmp114_;
								const gchar* _tmp115_;
								_tmp113_ = self->priv->reader;
								_tmp114_ = vala_markup_reader_get_name (_tmp113_);
								_tmp115_ = _tmp114_;
								if (g_strcmp0 (_tmp115_, "function-macro") == 0) {
									vala_gir_parser_skip_element (self);
								} else {
									ValaMarkupReader* _tmp116_;
									const gchar* _tmp117_;
									const gchar* _tmp118_;
									_tmp116_ = self->priv->reader;
									_tmp117_ = vala_markup_reader_get_name (_tmp116_);
									_tmp118_ = _tmp117_;
									if (g_strcmp0 (_tmp118_, "method") == 0) {
										vala_gir_parser_parse_method (self, "method");
									} else {
										ValaMarkupReader* _tmp119_;
										const gchar* _tmp120_;
										const gchar* _tmp121_;
										_tmp119_ = self->priv->reader;
										_tmp120_ = vala_markup_reader_get_name (_tmp119_);
										_tmp121_ = _tmp120_;
										if (g_strcmp0 (_tmp121_, "virtual-method") == 0) {
											vala_gir_parser_parse_method (self, "virtual-method");
										} else {
											ValaMarkupReader* _tmp122_;
											const gchar* _tmp123_;
											const gchar* _tmp124_;
											_tmp122_ = self->priv->reader;
											_tmp123_ = vala_markup_reader_get_name (_tmp122_);
											_tmp124_ = _tmp123_;
											if (g_strcmp0 (_tmp124_, "union") == 0) {
												vala_gir_parser_parse_union (self);
											} else {
												ValaMarkupReader* _tmp125_;
												const gchar* _tmp126_;
												const gchar* _tmp127_;
												_tmp125_ = self->priv->reader;
												_tmp126_ = vala_markup_reader_get_name (_tmp125_);
												_tmp127_ = _tmp126_;
												if (g_strcmp0 (_tmp127_, "glib:signal") == 0) {
													vala_gir_parser_parse_signal (self);
												} else {
													ValaSourceReference* _tmp128_;
													ValaSourceReference* _tmp129_;
													ValaMarkupReader* _tmp130_;
													const gchar* _tmp131_;
													const gchar* _tmp132_;
													_tmp128_ = vala_gir_parser_get_current_src (self);
													_tmp129_ = _tmp128_;
													_tmp130_ = self->priv->reader;
													_tmp131_ = vala_markup_reader_get_name (_tmp130_);
													_tmp132_ = _tmp131_;
													vala_report_error (_tmp129_, "unknown child element `%s' in `class'", _tmp132_);
													_vala_source_reference_unref0 (_tmp129_);
													vala_gir_parser_skip_element (self);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "class");
	_g_free0 (parent);
	_vala_code_node_unref0 (cl);
}

static void
vala_gir_parser_parse_interface (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaInterface* iface = NULL;
	ValaGirParserNode* _tmp2_;
	ValaInterface* _tmp19_;
	ValaInterface* _tmp20_;
	ValaInterface* _tmp21_;
	ValaGirComment* _tmp22_;
	ValaGirComment* _tmp23_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "interface");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->current;
	if (_tmp2_->new_symbol) {
		ValaGirParserNode* _tmp3_;
		const gchar* _tmp4_;
		ValaGirParserNode* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaInterface* _tmp7_;
		ValaGirParserMetadata* _tmp8_;
		ValaGirParserNode* _tmp13_;
		ValaInterface* _tmp14_;
		ValaSymbol* _tmp15_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_->name;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->source_reference;
		_tmp7_ = vala_interface_new (_tmp4_, _tmp6_, NULL);
		_vala_code_node_unref0 (iface);
		iface = _tmp7_;
		_tmp8_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp8_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_GET_FUNCTION)) {
			ValaInterface* _tmp9_;
			ValaGirParserMetadata* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp9_ = iface;
			_tmp10_ = self->priv->metadata;
			_tmp11_ = vala_gir_parser_metadata_get_string (_tmp10_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_GET_FUNCTION);
			_tmp12_ = _tmp11_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp9_, "CCode", "type_get_function", _tmp12_, NULL);
			_g_free0 (_tmp12_);
		}
		_tmp13_ = self->priv->current;
		_tmp14_ = iface;
		_tmp15_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp14_);
		_vala_code_node_unref0 (_tmp13_->symbol);
		_tmp13_->symbol = _tmp15_;
	} else {
		ValaGirParserNode* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaInterface* _tmp18_;
		_tmp16_ = self->priv->current;
		_tmp17_ = _tmp16_->symbol;
		_tmp18_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_INTERFACE, ValaInterface));
		_vala_code_node_unref0 (iface);
		iface = _tmp18_;
	}
	_tmp19_ = iface;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp19_);
	_tmp20_ = iface;
	vala_symbol_set_access ((ValaSymbol*) _tmp20_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_gir_parser_next (self);
	_tmp21_ = iface;
	_tmp22_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp23_ = _tmp22_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp21_, (ValaComment*) _tmp23_);
	_vala_comment_unref0 (_tmp23_);
	while (TRUE) {
		ValaMarkupReader* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp24_ = self->priv->reader;
		_tmp25_ = vala_markup_reader_get_name (_tmp24_);
		_tmp26_ = _tmp25_;
		if (g_strcmp0 (_tmp26_, "prerequisite") == 0) {
			ValaInterface* _tmp27_;
			ValaMarkupReader* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaDataType* _tmp31_;
			ValaDataType* _tmp32_;
			vala_gir_parser_start_element (self, "prerequisite");
			_tmp27_ = iface;
			_tmp28_ = self->priv->reader;
			_tmp29_ = vala_markup_reader_get_attribute (_tmp28_, "name");
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp30_, NULL, NULL, NULL);
			_tmp32_ = _tmp31_;
			vala_interface_add_prerequisite (_tmp27_, _tmp32_);
			_vala_code_node_unref0 (_tmp32_);
			_g_free0 (_tmp30_);
			vala_gir_parser_next (self);
			vala_gir_parser_end_element (self, "prerequisite");
		} else {
			ValaMarkupReader* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			_tmp33_ = self->priv->reader;
			_tmp34_ = vala_markup_reader_get_name (_tmp33_);
			_tmp35_ = _tmp34_;
			if (g_strcmp0 (_tmp35_, "field") == 0) {
				vala_gir_parser_parse_field (self);
			} else {
				ValaMarkupReader* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				_tmp36_ = self->priv->reader;
				_tmp37_ = vala_markup_reader_get_name (_tmp36_);
				_tmp38_ = _tmp37_;
				if (g_strcmp0 (_tmp38_, "property") == 0) {
					ValaProperty* _tmp39_;
					ValaProperty* _tmp40_;
					_tmp39_ = vala_gir_parser_parse_property (self);
					_tmp40_ = _tmp39_;
					_vala_code_node_unref0 (_tmp40_);
				} else {
					ValaMarkupReader* _tmp41_;
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					_tmp41_ = self->priv->reader;
					_tmp42_ = vala_markup_reader_get_name (_tmp41_);
					_tmp43_ = _tmp42_;
					if (g_strcmp0 (_tmp43_, "virtual-method") == 0) {
						vala_gir_parser_parse_method (self, "virtual-method");
					} else {
						ValaMarkupReader* _tmp44_;
						const gchar* _tmp45_;
						const gchar* _tmp46_;
						_tmp44_ = self->priv->reader;
						_tmp45_ = vala_markup_reader_get_name (_tmp44_);
						_tmp46_ = _tmp45_;
						if (g_strcmp0 (_tmp46_, "function") == 0) {
							vala_gir_parser_parse_method (self, "function");
						} else {
							ValaMarkupReader* _tmp47_;
							const gchar* _tmp48_;
							const gchar* _tmp49_;
							_tmp47_ = self->priv->reader;
							_tmp48_ = vala_markup_reader_get_name (_tmp47_);
							_tmp49_ = _tmp48_;
							if (g_strcmp0 (_tmp49_, "function-macro") == 0) {
								vala_gir_parser_skip_element (self);
							} else {
								ValaMarkupReader* _tmp50_;
								const gchar* _tmp51_;
								const gchar* _tmp52_;
								_tmp50_ = self->priv->reader;
								_tmp51_ = vala_markup_reader_get_name (_tmp50_);
								_tmp52_ = _tmp51_;
								if (g_strcmp0 (_tmp52_, "method") == 0) {
									vala_gir_parser_parse_method (self, "method");
								} else {
									ValaMarkupReader* _tmp53_;
									const gchar* _tmp54_;
									const gchar* _tmp55_;
									_tmp53_ = self->priv->reader;
									_tmp54_ = vala_markup_reader_get_name (_tmp53_);
									_tmp55_ = _tmp54_;
									if (g_strcmp0 (_tmp55_, "glib:signal") == 0) {
										vala_gir_parser_parse_signal (self);
									} else {
										ValaSourceReference* _tmp56_;
										ValaSourceReference* _tmp57_;
										ValaMarkupReader* _tmp58_;
										const gchar* _tmp59_;
										const gchar* _tmp60_;
										_tmp56_ = vala_gir_parser_get_current_src (self);
										_tmp57_ = _tmp56_;
										_tmp58_ = self->priv->reader;
										_tmp59_ = vala_markup_reader_get_name (_tmp58_);
										_tmp60_ = _tmp59_;
										vala_report_error (_tmp57_, "unknown child element `%s' in `interface'", _tmp60_);
										_vala_source_reference_unref0 (_tmp57_);
										vala_gir_parser_skip_element (self);
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "interface");
	_vala_code_node_unref0 (iface);
}

static void
vala_gir_parser_parse_field (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp6_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	gint array_length_idx = 0;
	ValaDataType* type = NULL;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	gchar* name = NULL;
	ValaGirParserNode* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* cname = NULL;
	ValaGirParserNode* _tmp16_;
	ValaMap* _tmp17_;
	gpointer _tmp18_;
	ValaField* field = NULL;
	const gchar* _tmp19_;
	ValaDataType* _tmp20_;
	ValaGirParserNode* _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaField* _tmp23_;
	ValaField* _tmp24_;
	ValaField* _tmp25_;
	ValaGirComment* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ValaDataType* _tmp31_;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_;
	ValaGirParserNode* _tmp41_;
	ValaField* _tmp42_;
	ValaSymbol* _tmp43_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "field");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, FALSE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "nullable");
	nullable = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "allow-none");
	allow_none = _tmp5_;
	vala_gir_parser_next (self);
	_tmp6_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp6_;
	_tmp10_ = vala_gir_parser_parse_type (self, NULL, &_tmp7_, TRUE, &_tmp8_, &_tmp9_);
	array_length_idx = _tmp7_;
	no_array_length = _tmp8_;
	array_null_terminated = _tmp9_;
	type = _tmp10_;
	_tmp11_ = type;
	_tmp12_ = vala_gir_parser_element_get_type (self, _tmp11_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp12_;
	_tmp13_ = self->priv->current;
	_tmp14_ = _tmp13_->name;
	_tmp15_ = g_strdup (_tmp14_);
	name = _tmp15_;
	_tmp16_ = self->priv->current;
	_tmp17_ = _tmp16_->girdata;
	_tmp18_ = vala_map_get (_tmp17_, "name");
	cname = (gchar*) _tmp18_;
	_tmp19_ = name;
	_tmp20_ = type;
	_tmp21_ = self->priv->current;
	_tmp22_ = _tmp21_->source_reference;
	_tmp23_ = vala_field_new (_tmp19_, _tmp20_, NULL, _tmp22_, NULL);
	field = _tmp23_;
	_tmp24_ = field;
	vala_symbol_set_access ((ValaSymbol*) _tmp24_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp25_ = field;
	_tmp26_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp25_, (ValaComment*) _tmp26_);
	_tmp27_ = name;
	_tmp28_ = cname;
	if (g_strcmp0 (_tmp27_, _tmp28_) != 0) {
		ValaField* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = field;
		_tmp30_ = cname;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp29_, "CCode", "cname", _tmp30_, NULL);
	}
	_tmp31_ = type;
	if (VALA_IS_ARRAY_TYPE (_tmp31_)) {
		gboolean _tmp32_ = FALSE;
		gboolean _tmp34_ = FALSE;
		if (!no_array_length) {
			_tmp32_ = array_length_idx > -1;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaGirParserNode* _tmp33_;
			_tmp33_ = self->priv->current;
			_tmp33_->array_length_idx = array_length_idx;
		}
		if (no_array_length) {
			_tmp34_ = TRUE;
		} else {
			_tmp34_ = array_null_terminated;
		}
		if (_tmp34_) {
			ValaField* _tmp35_;
			_tmp35_ = field;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp35_, "CCode", "array_length", !no_array_length, NULL);
		}
		if (array_null_terminated) {
			ValaField* _tmp36_;
			_tmp36_ = field;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp36_, "CCode", "array_null_terminated", TRUE, NULL);
		}
	}
	_tmp38_ = nullable;
	if (g_strcmp0 (_tmp38_, "1") == 0) {
		_tmp37_ = TRUE;
	} else {
		const gchar* _tmp39_;
		_tmp39_ = allow_none;
		_tmp37_ = g_strcmp0 (_tmp39_, "1") == 0;
	}
	if (_tmp37_) {
		ValaDataType* _tmp40_;
		_tmp40_ = type;
		vala_data_type_set_nullable (_tmp40_, TRUE);
	}
	_tmp41_ = self->priv->current;
	_tmp42_ = field;
	_tmp43_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp42_);
	_vala_code_node_unref0 (_tmp41_->symbol);
	_tmp41_->symbol = _tmp43_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "field");
	_vala_code_node_unref0 (field);
	_g_free0 (cname);
	_g_free0 (name);
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
	_g_free0 (allow_none);
	_g_free0 (nullable);
}

static ValaProperty*
vala_gir_parser_parse_property (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean is_abstract = FALSE;
	ValaGirParserMetadata* _tmp4_;
	ValaGirParserNode* _tmp5_;
	ValaGirParserNode* _tmp6_;
	ValaSymbol* _tmp7_;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp8_;
	gchar* _tmp9_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp10_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	ValaDataType* type = NULL;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaProperty* prop = NULL;
	ValaGirParserNode* _tmp17_;
	const gchar* _tmp18_;
	ValaDataType* _tmp19_;
	ValaGirParserNode* _tmp20_;
	ValaSourceReference* _tmp21_;
	ValaProperty* _tmp22_;
	ValaProperty* _tmp23_;
	ValaGirComment* _tmp24_;
	ValaProperty* _tmp25_;
	ValaProperty* _tmp26_;
	gboolean _tmp27_ = FALSE;
	ValaGirParserNode* _tmp30_;
	ValaProperty* _tmp31_;
	ValaSymbol* _tmp32_;
	ValaProperty* result;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "property");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "-", "_");
	_tmp3_ = _tmp2_;
	vala_gir_parser_push_node (self, _tmp3_, FALSE);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = self->priv->metadata;
	_tmp5_ = self->priv->current;
	_tmp6_ = _tmp5_->parent;
	_tmp7_ = _tmp6_->symbol;
	is_abstract = vala_gir_parser_metadata_get_bool (_tmp4_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, VALA_IS_INTERFACE (_tmp7_));
	_tmp8_ = self->priv->reader;
	_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "transfer-ownership");
	transfer = _tmp9_;
	vala_gir_parser_next (self);
	_tmp10_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp10_;
	_tmp11_ = transfer;
	_tmp14_ = vala_gir_parser_parse_type (self, NULL, NULL, g_strcmp0 (_tmp11_, "container") != 0, &_tmp12_, &_tmp13_);
	no_array_length = _tmp12_;
	array_null_terminated = _tmp13_;
	type = _tmp14_;
	_tmp15_ = type;
	_tmp16_ = vala_gir_parser_element_get_type (self, _tmp15_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp16_;
	_tmp17_ = self->priv->current;
	_tmp18_ = _tmp17_->name;
	_tmp19_ = type;
	_tmp20_ = self->priv->current;
	_tmp21_ = _tmp20_->source_reference;
	_tmp22_ = vala_property_new (_tmp18_, _tmp19_, NULL, NULL, _tmp21_, NULL);
	prop = _tmp22_;
	_tmp23_ = prop;
	_tmp24_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp23_, (ValaComment*) _tmp24_);
	_tmp25_ = prop;
	vala_symbol_set_access ((ValaSymbol*) _tmp25_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp26_ = prop;
	vala_property_set_is_abstract (_tmp26_, is_abstract);
	if (no_array_length) {
		_tmp27_ = TRUE;
	} else {
		_tmp27_ = array_null_terminated;
	}
	if (_tmp27_) {
		ValaProperty* _tmp28_;
		_tmp28_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp28_, "CCode", "array_length", !no_array_length, NULL);
	}
	if (array_null_terminated) {
		ValaProperty* _tmp29_;
		_tmp29_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp29_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	_tmp30_ = self->priv->current;
	_tmp31_ = prop;
	_tmp32_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp31_);
	_vala_code_node_unref0 (_tmp30_->symbol);
	_tmp30_->symbol = _tmp32_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "property");
	result = prop;
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
	_g_free0 (transfer);
	return result;
}

static void
vala_gir_parser_parse_callback (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "callback");
}

static void
vala_gir_parser_parse_constructor (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "constructor");
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_gir_parser_parse_function (ValaGirParser* self,
                                const gchar* element_name)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* symbol_type = NULL;
	ValaGirParserMetadata* _tmp7_;
	gchar* ctype = NULL;
	ValaGirParserMetadata* _tmp11_;
	gchar* name = NULL;
	ValaGirParserNode* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* throws_string = NULL;
	ValaMarkupReader* _tmp17_;
	gchar* _tmp18_;
	gchar* invoker = NULL;
	ValaMarkupReader* _tmp19_;
	gchar* _tmp20_;
	ValaGirParserNode* _tmp21_;
	ValaMarkupReader* _tmp22_;
	gchar* _tmp23_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp24_;
	ValaDataType* return_type = NULL;
	gchar* return_ctype = NULL;
	gint return_array_length_idx = 0;
	gboolean return_no_array_length = FALSE;
	gboolean return_array_null_terminated = FALSE;
	gboolean _tmp25_ = FALSE;
	ValaSymbol* s = NULL;
	const gchar* _tmp43_;
	ValaSymbol* _tmp100_;
	ValaSymbol* _tmp101_;
	ValaGirComment* _tmp102_;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp103_;
	ValaArrayType* _tmp104_;
	gboolean _tmp105_ = FALSE;
	ValaArrayType* _tmp106_;
	ValaSymbol* _tmp118_;
	ValaSymbol* _tmp132_;
	gboolean _tmp178_ = FALSE;
	ValaSymbol* _tmp179_;
	ValaGirParserMetadata* _tmp203_;
	ValaExpression* _tmp204_;
	ValaExpression* _tmp205_;
	gboolean _tmp206_;
	ValaSymbol* _tmp235_;
	gboolean _tmp245_ = FALSE;
	ValaDataType* _tmp246_;
	ValaGirParserNode* _tmp252_;
	const gchar* _tmp253_;
	ValaGirParserNode* _tmp256_;
	ValaSymbol* _tmp257_;
	ValaSymbol* _tmp258_;
	ValaGirParserMetadata* _tmp259_;
	ValaGirParserMetadata* _tmp264_;
	gint instance_idx = 0;
	gboolean _tmp267_ = FALSE;
	ValaArrayList* parameters = NULL;
	GEqualFunc _tmp278_;
	ValaArrayList* _tmp279_;
	ValaGirParserNode* _tmp280_;
	GEqualFunc _tmp281_;
	ValaArrayList* _tmp282_;
	ValaGirParserNode* _tmp283_;
	GEqualFunc _tmp284_;
	ValaArrayList* _tmp285_;
	ValaGirParserNode* _tmp286_;
	GEqualFunc _tmp287_;
	ValaArrayList* _tmp288_;
	gboolean _tmp289_ = FALSE;
	ValaGirParserNode* _tmp414_;
	ValaArrayList* _tmp415_;
	ValaList* _tmp416_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "invoker");
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_parser_element_get_name (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp4_, "-", "_");
	_tmp6_ = _tmp5_;
	vala_gir_parser_push_node (self, _tmp6_, FALSE);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp7_, VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE)) {
		ValaGirParserMetadata* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->metadata;
		_tmp9_ = vala_gir_parser_metadata_get_string (_tmp8_, VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE);
		_g_free0 (symbol_type);
		symbol_type = _tmp9_;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (element_name);
		_g_free0 (symbol_type);
		symbol_type = _tmp10_;
	}
	ctype = NULL;
	_tmp11_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp11_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE)) {
		ValaGirParserMetadata* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = self->priv->metadata;
		_tmp13_ = vala_gir_parser_metadata_get_string (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE);
		_g_free0 (ctype);
		ctype = _tmp13_;
	}
	_tmp14_ = self->priv->current;
	_tmp15_ = _tmp14_->name;
	_tmp16_ = g_strdup (_tmp15_);
	name = _tmp16_;
	_tmp17_ = self->priv->reader;
	_tmp18_ = vala_markup_reader_get_attribute (_tmp17_, "throws");
	throws_string = _tmp18_;
	_tmp19_ = self->priv->reader;
	_tmp20_ = vala_markup_reader_get_attribute (_tmp19_, "invoker");
	invoker = _tmp20_;
	_tmp21_ = self->priv->current;
	_tmp22_ = self->priv->reader;
	_tmp23_ = vala_markup_reader_get_attribute (_tmp22_, "moved-to");
	_g_free0 (_tmp21_->deprecated_replacement);
	_tmp21_->deprecated_replacement = _tmp23_;
	vala_gir_parser_next (self);
	_tmp24_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp24_;
	return_ctype = NULL;
	return_array_length_idx = -1;
	return_no_array_length = FALSE;
	return_array_null_terminated = FALSE;
	if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		_tmp26_ = self->priv->reader;
		_tmp27_ = vala_markup_reader_get_name (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp25_ = g_strcmp0 (_tmp28_, "return-value") == 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		ValaComment* return_comment = NULL;
		gchar* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		ValaComment* _tmp33_ = NULL;
		ValaDataType* _tmp34_;
		ValaComment* _tmp35_;
		_tmp34_ = vala_gir_parser_parse_return_value (self, &_tmp29_, &_tmp30_, &_tmp31_, &_tmp32_, &_tmp33_);
		_g_free0 (return_ctype);
		return_ctype = _tmp29_;
		return_array_length_idx = _tmp30_;
		return_no_array_length = _tmp31_;
		return_array_null_terminated = _tmp32_;
		_vala_comment_unref0 (return_comment);
		return_comment = _tmp33_;
		_vala_code_node_unref0 (return_type);
		return_type = _tmp34_;
		_tmp35_ = return_comment;
		if (_tmp35_ != NULL) {
			ValaGirComment* _tmp36_;
			ValaGirComment* _tmp40_;
			ValaComment* _tmp41_;
			_tmp36_ = comment;
			if (_tmp36_ == NULL) {
				ValaGirParserNode* _tmp37_;
				ValaSourceReference* _tmp38_;
				ValaGirComment* _tmp39_;
				_tmp37_ = self->priv->current;
				_tmp38_ = _tmp37_->source_reference;
				_tmp39_ = vala_gir_comment_new (NULL, _tmp38_);
				_vala_comment_unref0 (comment);
				comment = _tmp39_;
			}
			_tmp40_ = comment;
			_tmp41_ = return_comment;
			vala_gir_comment_set_return_content (_tmp40_, _tmp41_);
		}
		_vala_comment_unref0 (return_comment);
	} else {
		ValaVoidType* _tmp42_;
		_tmp42_ = vala_void_type_new (NULL);
		_vala_code_node_unref0 (return_type);
		return_type = (ValaDataType*) _tmp42_;
	}
	_tmp43_ = symbol_type;
	if (g_strcmp0 (_tmp43_, "callback") == 0) {
		const gchar* _tmp44_;
		ValaDataType* _tmp45_;
		ValaGirParserNode* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaDelegate* _tmp48_;
		ValaSymbol* _tmp49_;
		_tmp44_ = name;
		_tmp45_ = return_type;
		_tmp46_ = self->priv->current;
		_tmp47_ = _tmp46_->source_reference;
		_tmp48_ = vala_delegate_new (_tmp44_, _tmp45_, _tmp47_, NULL);
		_vala_code_node_unref0 (s);
		s = (ValaSymbol*) _tmp48_;
		_tmp49_ = s;
		vala_delegate_set_has_target (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_DELEGATE, ValaDelegate), FALSE);
	} else {
		const gchar* _tmp50_;
		_tmp50_ = symbol_type;
		if (g_strcmp0 (_tmp50_, "constructor") == 0) {
			const gchar* _tmp51_;
			ValaCreationMethod* m = NULL;
			const gchar* _tmp57_;
			ValaGirParserNode* _tmp58_;
			ValaSourceReference* _tmp59_;
			ValaCreationMethod* _tmp60_;
			ValaCreationMethod* _tmp61_;
			gboolean _tmp62_ = FALSE;
			const gchar* _tmp63_;
			gchar* parent_ctype = NULL;
			ValaGirParserNode* _tmp71_;
			ValaGirParserNode* _tmp72_;
			ValaSymbol* _tmp73_;
			gboolean _tmp77_ = FALSE;
			const gchar* _tmp78_;
			ValaCreationMethod* _tmp87_;
			ValaSymbol* _tmp88_;
			_tmp51_ = name;
			if (g_strcmp0 (_tmp51_, "new") == 0) {
				_g_free0 (name);
				name = NULL;
			} else {
				const gchar* _tmp52_;
				_tmp52_ = name;
				if (g_str_has_prefix (_tmp52_, "new_")) {
					const gchar* _tmp53_;
					gint _tmp54_;
					gint _tmp55_;
					gchar* _tmp56_;
					_tmp53_ = name;
					_tmp54_ = strlen ("new_");
					_tmp55_ = _tmp54_;
					_tmp56_ = string_substring (_tmp53_, (glong) _tmp55_, (glong) -1);
					_g_free0 (name);
					name = _tmp56_;
				}
			}
			_tmp57_ = name;
			_tmp58_ = self->priv->current;
			_tmp59_ = _tmp58_->source_reference;
			_tmp60_ = vala_creation_method_new (NULL, _tmp57_, _tmp59_, NULL);
			m = _tmp60_;
			_tmp61_ = m;
			vala_method_set_has_construct_function ((ValaMethod*) _tmp61_, FALSE);
			_tmp63_ = name;
			if (_tmp63_ != NULL) {
				ValaGirParserNode* _tmp64_;
				const gchar* _tmp65_;
				_tmp64_ = self->priv->current;
				_tmp65_ = _tmp64_->name;
				_tmp62_ = !g_str_has_prefix (_tmp65_, "new_");
			} else {
				_tmp62_ = FALSE;
			}
			if (_tmp62_) {
				ValaCreationMethod* _tmp66_;
				ValaGirParserNode* _tmp67_;
				ValaMap* _tmp68_;
				gpointer _tmp69_;
				gchar* _tmp70_;
				_tmp66_ = m;
				_tmp67_ = self->priv->current;
				_tmp68_ = _tmp67_->girdata;
				_tmp69_ = vala_map_get (_tmp68_, "c:identifier");
				_tmp70_ = (gchar*) _tmp69_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp66_, "CCode", "cname", _tmp70_, NULL);
				_g_free0 (_tmp70_);
			}
			parent_ctype = NULL;
			_tmp71_ = self->priv->current;
			_tmp72_ = _tmp71_->parent;
			_tmp73_ = _tmp72_->symbol;
			if (VALA_IS_CLASS (_tmp73_)) {
				ValaGirParserNode* _tmp74_;
				ValaGirParserNode* _tmp75_;
				gchar* _tmp76_;
				_tmp74_ = self->priv->current;
				_tmp75_ = _tmp74_->parent;
				_tmp76_ = vala_gir_parser_node_get_cname (_tmp75_);
				_g_free0 (parent_ctype);
				parent_ctype = _tmp76_;
			}
			_tmp78_ = return_ctype;
			if (_tmp78_ != NULL) {
				gboolean _tmp79_ = FALSE;
				const gchar* _tmp80_;
				_tmp80_ = parent_ctype;
				if (_tmp80_ == NULL) {
					_tmp79_ = TRUE;
				} else {
					const gchar* _tmp81_;
					const gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					_tmp81_ = return_ctype;
					_tmp82_ = parent_ctype;
					_tmp83_ = g_strconcat (_tmp82_, "*", NULL);
					_tmp84_ = _tmp83_;
					_tmp79_ = g_strcmp0 (_tmp81_, _tmp84_) != 0;
					_g_free0 (_tmp84_);
				}
				_tmp77_ = _tmp79_;
			} else {
				_tmp77_ = FALSE;
			}
			if (_tmp77_) {
				ValaCreationMethod* _tmp85_;
				const gchar* _tmp86_;
				_tmp85_ = m;
				_tmp86_ = return_ctype;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp85_, "CCode", "type", _tmp86_, NULL);
			}
			_tmp87_ = m;
			_tmp88_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp87_);
			_vala_code_node_unref0 (s);
			s = _tmp88_;
			_g_free0 (parent_ctype);
			_vala_code_node_unref0 (m);
		} else {
			const gchar* _tmp89_;
			_tmp89_ = symbol_type;
			if (g_strcmp0 (_tmp89_, "glib:signal") == 0) {
				const gchar* _tmp90_;
				ValaDataType* _tmp91_;
				ValaGirParserNode* _tmp92_;
				ValaSourceReference* _tmp93_;
				ValaSignal* _tmp94_;
				_tmp90_ = name;
				_tmp91_ = return_type;
				_tmp92_ = self->priv->current;
				_tmp93_ = _tmp92_->source_reference;
				_tmp94_ = vala_signal_new (_tmp90_, _tmp91_, _tmp93_, NULL);
				_vala_code_node_unref0 (s);
				s = (ValaSymbol*) _tmp94_;
			} else {
				const gchar* _tmp95_;
				ValaDataType* _tmp96_;
				ValaGirParserNode* _tmp97_;
				ValaSourceReference* _tmp98_;
				ValaMethod* _tmp99_;
				_tmp95_ = name;
				_tmp96_ = return_type;
				_tmp97_ = self->priv->current;
				_tmp98_ = _tmp97_->source_reference;
				_tmp99_ = vala_method_new (_tmp95_, _tmp96_, _tmp98_, NULL);
				_vala_code_node_unref0 (s);
				s = (ValaSymbol*) _tmp99_;
			}
		}
	}
	_tmp100_ = s;
	vala_symbol_set_access (_tmp100_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp101_ = s;
	_tmp102_ = comment;
	vala_symbol_set_comment (_tmp101_, (ValaComment*) _tmp102_);
	_tmp103_ = return_type;
	_tmp104_ = _vala_code_node_ref0 (VALA_IS_ARRAY_TYPE (_tmp103_) ? ((ValaArrayType*) _tmp103_) : NULL);
	array_type = _tmp104_;
	_tmp106_ = array_type;
	if (_tmp106_ != NULL) {
		ValaArrayType* _tmp107_;
		gboolean _tmp108_;
		gboolean _tmp109_;
		_tmp107_ = array_type;
		_tmp108_ = vala_array_type_get_fixed_length (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp105_ = _tmp109_;
	} else {
		_tmp105_ = FALSE;
	}
	if (_tmp105_) {
		ValaSymbol* _tmp110_;
		ValaArrayType* _tmp111_;
		ValaExpression* _tmp112_;
		ValaExpression* _tmp113_;
		const gchar* _tmp114_;
		const gchar* _tmp115_;
		ValaArrayType* _tmp116_;
		ValaArrayType* _tmp117_;
		_tmp110_ = s;
		_tmp111_ = array_type;
		_tmp112_ = vala_array_type_get_length (_tmp111_);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp113_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
		_tmp115_ = _tmp114_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp110_, "CCode", "array_length_cexpr", _tmp115_, NULL);
		_tmp116_ = array_type;
		vala_array_type_set_fixed_length (_tmp116_, FALSE);
		_tmp117_ = array_type;
		vala_array_type_set_length (_tmp117_, NULL);
	}
	_tmp118_ = s;
	if (VALA_IS_SIGNAL (_tmp118_)) {
		ValaGirParserNode* _tmp119_;
		ValaMap* _tmp120_;
		gpointer _tmp121_;
		gchar* _tmp122_;
		const gchar* _tmp123_;
		gchar* _tmp124_;
		gchar* _tmp125_;
		gboolean _tmp126_;
		_tmp119_ = self->priv->current;
		_tmp120_ = _tmp119_->girdata;
		_tmp121_ = vala_map_get (_tmp120_, "name");
		_tmp122_ = (gchar*) _tmp121_;
		_tmp123_ = name;
		_tmp124_ = string_replace (_tmp123_, "_", "-");
		_tmp125_ = _tmp124_;
		_tmp126_ = g_strcmp0 (_tmp122_, _tmp125_) != 0;
		_g_free0 (_tmp125_);
		_g_free0 (_tmp122_);
		if (_tmp126_) {
			ValaSymbol* _tmp127_;
			ValaGirParserNode* _tmp128_;
			ValaMap* _tmp129_;
			gpointer _tmp130_;
			gchar* _tmp131_;
			_tmp127_ = s;
			_tmp128_ = self->priv->current;
			_tmp129_ = _tmp128_->girdata;
			_tmp130_ = vala_map_get (_tmp129_, "name");
			_tmp131_ = (gchar*) _tmp130_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp127_, "CCode", "cname", _tmp131_, NULL);
			_g_free0 (_tmp131_);
		}
	}
	_tmp132_ = s;
	if (VALA_IS_METHOD (_tmp132_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp133_;
		ValaMethod* _tmp134_;
		gboolean _tmp135_ = FALSE;
		const gchar* _tmp136_;
		ValaGirParserMetadata* _tmp169_;
		ValaGirParserMetadata* _tmp175_;
		_tmp133_ = s;
		_tmp134_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp134_;
		_tmp136_ = symbol_type;
		if (g_strcmp0 (_tmp136_, "virtual-method") == 0) {
			_tmp135_ = TRUE;
		} else {
			const gchar* _tmp137_;
			_tmp137_ = symbol_type;
			_tmp135_ = g_strcmp0 (_tmp137_, "callback") == 0;
		}
		if (_tmp135_) {
			ValaGirParserNode* _tmp138_;
			ValaGirParserNode* _tmp139_;
			ValaSymbol* _tmp140_;
			ValaGirParserMetadata* _tmp143_;
			ValaGirParserNode* _tmp156_;
			ValaMap* _tmp157_;
			gpointer _tmp158_;
			gchar* _tmp159_;
			const gchar* _tmp160_;
			gboolean _tmp161_;
			_tmp138_ = self->priv->current;
			_tmp139_ = _tmp138_->parent;
			_tmp140_ = _tmp139_->symbol;
			if (VALA_IS_INTERFACE (_tmp140_)) {
				ValaMethod* _tmp141_;
				_tmp141_ = m;
				vala_method_set_is_abstract (_tmp141_, TRUE);
			} else {
				ValaMethod* _tmp142_;
				_tmp142_ = m;
				vala_method_set_is_virtual (_tmp142_, TRUE);
			}
			_tmp143_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp143_, VALA_GIR_PARSER_ARGUMENT_TYPE_NO_WRAPPER)) {
				ValaSymbol* _tmp144_;
				ValaGirParserMetadata* _tmp145_;
				ValaSymbol* _tmp146_;
				ValaSourceReference* _tmp147_;
				ValaSourceReference* _tmp148_;
				_tmp144_ = s;
				_tmp145_ = self->priv->metadata;
				_tmp146_ = s;
				_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp146_);
				_tmp148_ = _tmp147_;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp144_, "NoWrapper", vala_gir_parser_metadata_get_bool (_tmp145_, VALA_GIR_PARSER_ARGUMENT_TYPE_NO_WRAPPER, FALSE), _tmp148_);
			} else {
				gboolean _tmp149_ = FALSE;
				const gchar* _tmp150_;
				_tmp150_ = invoker;
				if (_tmp150_ == NULL) {
					ValaGirParserMetadata* _tmp151_;
					_tmp151_ = self->priv->metadata;
					_tmp149_ = !vala_gir_parser_metadata_has_argument (_tmp151_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
				} else {
					_tmp149_ = FALSE;
				}
				if (_tmp149_) {
					ValaSymbol* _tmp152_;
					ValaSymbol* _tmp153_;
					ValaSourceReference* _tmp154_;
					ValaSourceReference* _tmp155_;
					_tmp152_ = s;
					_tmp153_ = s;
					_tmp154_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp153_);
					_tmp155_ = _tmp154_;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp152_, "NoWrapper", TRUE, _tmp155_);
				}
			}
			_tmp156_ = self->priv->current;
			_tmp157_ = _tmp156_->girdata;
			_tmp158_ = vala_map_get (_tmp157_, "name");
			_tmp159_ = (gchar*) _tmp158_;
			_tmp160_ = name;
			_tmp161_ = g_strcmp0 (_tmp159_, _tmp160_) != 0;
			_g_free0 (_tmp159_);
			if (_tmp161_) {
				ValaMethod* _tmp162_;
				ValaGirParserNode* _tmp163_;
				ValaMap* _tmp164_;
				gpointer _tmp165_;
				gchar* _tmp166_;
				_tmp162_ = m;
				_tmp163_ = self->priv->current;
				_tmp164_ = _tmp163_->girdata;
				_tmp165_ = vala_map_get (_tmp164_, "name");
				_tmp166_ = (gchar*) _tmp165_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp162_, "CCode", "vfunc_name", _tmp166_, NULL);
				_g_free0 (_tmp166_);
			}
		} else {
			const gchar* _tmp167_;
			_tmp167_ = symbol_type;
			if (g_strcmp0 (_tmp167_, "function") == 0) {
				ValaMethod* _tmp168_;
				_tmp168_ = m;
				vala_method_set_binding (_tmp168_, VALA_MEMBER_BINDING_STATIC);
			}
		}
		_tmp169_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp169_, VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING)) {
			ValaMethod* _tmp170_;
			ValaGirParserMetadata* _tmp171_;
			ValaMethod* _tmp172_;
			ValaDataType* _tmp173_;
			ValaDataType* _tmp174_;
			_tmp170_ = m;
			_tmp171_ = self->priv->metadata;
			vala_method_set_returns_floating_reference (_tmp170_, vala_gir_parser_metadata_get_bool (_tmp171_, VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING, FALSE));
			_tmp172_ = m;
			_tmp173_ = vala_callable_get_return_type ((ValaCallable*) _tmp172_);
			_tmp174_ = _tmp173_;
			vala_data_type_set_value_owned (_tmp174_, TRUE);
		}
		_tmp175_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp175_, VALA_GIR_PARSER_ARGUMENT_TYPE_NEW)) {
			ValaMethod* _tmp176_;
			ValaGirParserMetadata* _tmp177_;
			_tmp176_ = m;
			_tmp177_ = self->priv->metadata;
			vala_symbol_set_hides ((ValaSymbol*) _tmp176_, vala_gir_parser_metadata_get_bool (_tmp177_, VALA_GIR_PARSER_ARGUMENT_TYPE_NEW, FALSE));
		}
		_vala_code_node_unref0 (m);
	}
	_tmp179_ = s;
	if (VALA_IS_METHOD (_tmp179_)) {
		ValaSymbol* _tmp180_;
		_tmp180_ = s;
		_tmp178_ = !VALA_IS_CREATION_METHOD (_tmp180_);
	} else {
		_tmp178_ = FALSE;
	}
	if (_tmp178_) {
		ValaMethod* method = NULL;
		ValaSymbol* _tmp181_;
		ValaMethod* _tmp182_;
		ValaGirParserMetadata* _tmp183_;
		ValaGirParserMetadata* _tmp191_;
		ValaGirParserMetadata* _tmp197_;
		_tmp181_ = s;
		_tmp182_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp181_, VALA_TYPE_METHOD, ValaMethod));
		method = _tmp182_;
		_tmp183_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp183_, VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL)) {
			ValaMethod* _tmp184_;
			ValaGirParserMetadata* _tmp185_;
			ValaMethod* _tmp186_;
			_tmp184_ = method;
			_tmp185_ = self->priv->metadata;
			vala_method_set_is_virtual (_tmp184_, vala_gir_parser_metadata_get_bool (_tmp185_, VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL, FALSE));
			_tmp186_ = method;
			vala_method_set_is_abstract (_tmp186_, FALSE);
		} else {
			ValaGirParserMetadata* _tmp187_;
			_tmp187_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp187_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT)) {
				ValaMethod* _tmp188_;
				ValaGirParserMetadata* _tmp189_;
				ValaMethod* _tmp190_;
				_tmp188_ = method;
				_tmp189_ = self->priv->metadata;
				vala_method_set_is_abstract (_tmp188_, vala_gir_parser_metadata_get_bool (_tmp189_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, FALSE));
				_tmp190_ = method;
				vala_method_set_is_virtual (_tmp190_, FALSE);
			}
		}
		_tmp191_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp191_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME)) {
			ValaMethod* _tmp192_;
			ValaGirParserMetadata* _tmp193_;
			gchar* _tmp194_;
			gchar* _tmp195_;
			ValaMethod* _tmp196_;
			_tmp192_ = method;
			_tmp193_ = self->priv->metadata;
			_tmp194_ = vala_gir_parser_metadata_get_string (_tmp193_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
			_tmp195_ = _tmp194_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp192_, "CCode", "vfunc_name", _tmp195_, NULL);
			_g_free0 (_tmp195_);
			_tmp196_ = method;
			vala_method_set_is_virtual (_tmp196_, TRUE);
		}
		_tmp197_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp197_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME)) {
			ValaMethod* _tmp198_;
			ValaGirParserMetadata* _tmp199_;
			gchar* _tmp200_;
			gchar* _tmp201_;
			ValaMethod* _tmp202_;
			_tmp198_ = method;
			_tmp199_ = self->priv->metadata;
			_tmp200_ = vala_gir_parser_metadata_get_string (_tmp199_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME);
			_tmp201_ = _tmp200_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp198_, "CCode", "finish_vfunc_name", _tmp201_, NULL);
			_g_free0 (_tmp201_);
			_tmp202_ = method;
			vala_method_set_is_virtual (_tmp202_, TRUE);
		}
		_vala_code_node_unref0 (method);
	}
	_tmp203_ = self->priv->metadata;
	_tmp204_ = vala_gir_parser_metadata_get_expression (_tmp203_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
	_tmp205_ = _tmp204_;
	_tmp206_ = !VALA_IS_NULL_LITERAL (_tmp205_);
	_vala_code_node_unref0 (_tmp205_);
	if (_tmp206_) {
		ValaGirParserMetadata* _tmp207_;
		_tmp207_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp207_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS)) {
			gchar** error_types = NULL;
			ValaGirParserMetadata* _tmp208_;
			gchar* _tmp209_;
			gchar* _tmp210_;
			gchar** _tmp211_;
			gchar** _tmp212_;
			gchar** _tmp213_;
			gint _tmp213__length1;
			gint error_types_length1;
			gint _error_types_size_;
			gchar** _tmp214_;
			gint _tmp214__length1;
			_tmp208_ = self->priv->metadata;
			_tmp209_ = vala_gir_parser_metadata_get_string (_tmp208_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
			_tmp210_ = _tmp209_;
			_tmp212_ = _tmp211_ = g_strsplit (_tmp210_, ",", 0);
			_tmp213_ = _tmp212_;
			_tmp213__length1 = _vala_array_length (_tmp211_);
			_g_free0 (_tmp210_);
			error_types = _tmp213_;
			error_types_length1 = _tmp213__length1;
			_error_types_size_ = error_types_length1;
			_tmp214_ = error_types;
			_tmp214__length1 = error_types_length1;
			{
				gchar** error_type_name_collection = NULL;
				gint error_type_name_collection_length1 = 0;
				gint _error_type_name_collection_size_ = 0;
				gint error_type_name_it = 0;
				error_type_name_collection = _tmp214_;
				error_type_name_collection_length1 = _tmp214__length1;
				for (error_type_name_it = 0; error_type_name_it < error_type_name_collection_length1; error_type_name_it = error_type_name_it + 1) {
					gchar* _tmp215_;
					gchar* error_type_name = NULL;
					_tmp215_ = g_strdup (error_type_name_collection[error_type_name_it]);
					error_type_name = _tmp215_;
					{
						ValaDataType* error_type = NULL;
						const gchar* _tmp216_;
						ValaGirParserMetadata* _tmp217_;
						ValaSourceReference* _tmp218_;
						ValaSourceReference* _tmp219_;
						ValaDataType* _tmp220_;
						ValaDataType* _tmp221_;
						ValaSymbol* _tmp222_;
						_tmp216_ = error_type_name;
						_tmp217_ = self->priv->metadata;
						_tmp218_ = vala_gir_parser_metadata_get_source_reference (_tmp217_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
						_tmp219_ = _tmp218_;
						_tmp220_ = vala_gir_parser_parse_type_from_string (self, _tmp216_, TRUE, _tmp219_);
						_tmp221_ = _tmp220_;
						_vala_source_reference_unref0 (_tmp219_);
						error_type = _tmp221_;
						_tmp222_ = s;
						if (VALA_IS_METHOD (_tmp222_)) {
							ValaSymbol* _tmp223_;
							ValaDataType* _tmp224_;
							_tmp223_ = s;
							_tmp224_ = error_type;
							vala_method_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp223_, VALA_TYPE_METHOD, ValaMethod), _tmp224_);
						} else {
							ValaSymbol* _tmp225_;
							ValaDataType* _tmp226_;
							_tmp225_ = s;
							_tmp226_ = error_type;
							vala_delegate_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp225_, VALA_TYPE_DELEGATE, ValaDelegate), _tmp226_);
						}
						_vala_code_node_unref0 (error_type);
						_g_free0 (error_type_name);
					}
				}
			}
			error_types = (_vala_array_free (error_types, error_types_length1, (GDestroyNotify) g_free), NULL);
		} else {
			const gchar* _tmp227_;
			_tmp227_ = throws_string;
			if (g_strcmp0 (_tmp227_, "1") == 0) {
				ValaSymbol* _tmp228_;
				_tmp228_ = s;
				if (VALA_IS_METHOD (_tmp228_)) {
					ValaSymbol* _tmp229_;
					ValaErrorType* _tmp230_;
					ValaErrorType* _tmp231_;
					_tmp229_ = s;
					_tmp230_ = vala_error_type_new (NULL, NULL, NULL);
					_tmp231_ = _tmp230_;
					vala_method_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp229_, VALA_TYPE_METHOD, ValaMethod), (ValaDataType*) _tmp231_);
					_vala_code_node_unref0 (_tmp231_);
				} else {
					ValaSymbol* _tmp232_;
					ValaErrorType* _tmp233_;
					ValaErrorType* _tmp234_;
					_tmp232_ = s;
					_tmp233_ = vala_error_type_new (NULL, NULL, NULL);
					_tmp234_ = _tmp233_;
					vala_delegate_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp232_, VALA_TYPE_DELEGATE, ValaDelegate), (ValaDataType*) _tmp234_);
					_vala_code_node_unref0 (_tmp234_);
				}
			}
		}
	}
	_tmp235_ = s;
	if (VALA_IS_METHOD (_tmp235_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp236_;
		ValaMethod* _tmp237_;
		ValaMethod* _tmp238_;
		ValaGirParserMetadata* _tmp239_;
		ValaGirParserMetadata* _tmp240_;
		_tmp236_ = s;
		_tmp237_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp236_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp237_;
		_tmp238_ = m;
		_tmp239_ = self->priv->metadata;
		vala_code_node_set_attribute ((ValaCodeNode*) _tmp238_, "PrintfFormat", vala_gir_parser_metadata_get_bool (_tmp239_, VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT, FALSE), NULL);
		_tmp240_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp240_, VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL)) {
			ValaMethod* _tmp241_;
			ValaGirParserMetadata* _tmp242_;
			gchar* _tmp243_;
			gchar* _tmp244_;
			_tmp241_ = m;
			_tmp242_ = self->priv->metadata;
			_tmp243_ = vala_gir_parser_metadata_get_string (_tmp242_, VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL);
			_tmp244_ = _tmp243_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp241_, "CCode", "sentinel", _tmp244_, NULL);
			_g_free0 (_tmp244_);
		}
		_vala_code_node_unref0 (m);
	}
	_tmp246_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp246_)) {
		ValaGirParserMetadata* _tmp247_;
		_tmp247_ = self->priv->metadata;
		_tmp245_ = vala_gir_parser_metadata_has_argument (_tmp247_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
	} else {
		_tmp245_ = FALSE;
	}
	if (_tmp245_) {
		ValaGirParserMetadata* _tmp248_;
		_tmp248_ = self->priv->metadata;
		return_array_length_idx = vala_gir_parser_metadata_get_integer (_tmp248_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
	} else {
		gboolean _tmp249_ = FALSE;
		if (return_no_array_length) {
			_tmp249_ = TRUE;
		} else {
			_tmp249_ = return_array_null_terminated;
		}
		if (_tmp249_) {
			ValaSymbol* _tmp250_;
			_tmp250_ = s;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp250_, "CCode", "array_length", !return_no_array_length, NULL);
		}
		if (return_array_null_terminated) {
			ValaSymbol* _tmp251_;
			_tmp251_ = s;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp251_, "CCode", "array_null_terminated", TRUE, NULL);
		}
	}
	_tmp252_ = self->priv->current;
	_tmp252_->return_array_length_idx = return_array_length_idx;
	_tmp253_ = ctype;
	if (_tmp253_ != NULL) {
		ValaSymbol* _tmp254_;
		const gchar* _tmp255_;
		_tmp254_ = s;
		_tmp255_ = ctype;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp254_, "CCode", "type", _tmp255_, NULL);
	}
	_tmp256_ = self->priv->current;
	_tmp257_ = s;
	_tmp258_ = _vala_code_node_ref0 (_tmp257_);
	_vala_code_node_unref0 (_tmp256_->symbol);
	_tmp256_->symbol = _tmp258_;
	_tmp259_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp259_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME)) {
		ValaSymbol* _tmp260_;
		ValaGirParserMetadata* _tmp261_;
		gchar* _tmp262_;
		gchar* _tmp263_;
		_tmp260_ = s;
		_tmp261_ = self->priv->metadata;
		_tmp262_ = vala_gir_parser_metadata_get_string (_tmp261_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME);
		_tmp263_ = _tmp262_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp260_, "CCode", "finish_name", _tmp263_, NULL);
		_g_free0 (_tmp263_);
	}
	_tmp264_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp264_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE)) {
		ValaSymbol* _tmp265_;
		ValaGirParserMetadata* _tmp266_;
		_tmp265_ = s;
		_tmp266_ = self->priv->metadata;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp265_, "CCode", "finish_instance", vala_gir_parser_metadata_get_bool (_tmp266_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE, FALSE), NULL);
	}
	instance_idx = -2;
	if (g_strcmp0 (element_name, "function") == 0) {
		const gchar* _tmp268_;
		_tmp268_ = symbol_type;
		_tmp267_ = g_strcmp0 (_tmp268_, "method") == 0;
	} else {
		_tmp267_ = FALSE;
	}
	if (_tmp267_) {
		ValaGirParserMetadata* _tmp269_;
		_tmp269_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp269_, VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX)) {
			ValaGirParserMetadata* _tmp270_;
			_tmp270_ = self->priv->metadata;
			instance_idx = vala_gir_parser_metadata_get_integer (_tmp270_, VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX);
			if (instance_idx != 0) {
				ValaSymbol* _tmp271_;
				_tmp271_ = s;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp271_, "CCode", "instance_pos", instance_idx + 0.5, NULL);
			}
		} else {
			ValaSourceReference* _tmp272_;
			ValaSourceReference* _tmp273_;
			_tmp272_ = vala_gir_parser_get_current_src (self);
			_tmp273_ = _tmp272_;
			vala_report_error (_tmp273_, "instance_idx required when converting function to method");
			_vala_source_reference_unref0 (_tmp273_);
		}
	}
	if (g_strcmp0 (element_name, "callback") == 0) {
		ValaGirParserMetadata* _tmp274_;
		_tmp274_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp274_, VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX)) {
			ValaGirParserMetadata* _tmp275_;
			ValaSymbol* _tmp276_;
			ValaSymbol* _tmp277_;
			_tmp275_ = self->priv->metadata;
			instance_idx = vala_gir_parser_metadata_get_integer (_tmp275_, VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX);
			_tmp276_ = s;
			vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp276_, "CCode", "instance_pos", instance_idx + 0.9, NULL);
			_tmp277_ = s;
			vala_delegate_set_has_target (G_TYPE_CHECK_INSTANCE_CAST (_tmp277_, VALA_TYPE_DELEGATE, ValaDelegate), TRUE);
		}
	}
	_tmp278_ = g_direct_equal;
	_tmp279_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_PARAMETER_INFO, (GBoxedCopyFunc) vala_gir_parser_parameter_info_ref, (GDestroyNotify) vala_gir_parser_parameter_info_unref, _tmp278_);
	parameters = _tmp279_;
	_tmp280_ = self->priv->current;
	_tmp281_ = g_direct_equal;
	_tmp282_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp281_);
	_vala_iterable_unref0 (_tmp280_->array_length_parameters);
	_tmp280_->array_length_parameters = _tmp282_;
	_tmp283_ = self->priv->current;
	_tmp284_ = g_direct_equal;
	_tmp285_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp284_);
	_vala_iterable_unref0 (_tmp283_->closure_parameters);
	_tmp283_->closure_parameters = _tmp285_;
	_tmp286_ = self->priv->current;
	_tmp287_ = g_direct_equal;
	_tmp288_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp287_);
	_vala_iterable_unref0 (_tmp286_->destroy_parameters);
	_tmp286_->destroy_parameters = _tmp288_;
	if (self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp290_;
		const gchar* _tmp291_;
		const gchar* _tmp292_;
		_tmp290_ = self->priv->reader;
		_tmp291_ = vala_markup_reader_get_name (_tmp290_);
		_tmp292_ = _tmp291_;
		_tmp289_ = g_strcmp0 (_tmp292_, "parameters") == 0;
	} else {
		_tmp289_ = FALSE;
	}
	if (_tmp289_) {
		gint current_parameter_idx = 0;
		vala_gir_parser_start_element (self, "parameters");
		vala_gir_parser_next (self);
		current_parameter_idx = -1;
		while (TRUE) {
			gboolean _tmp293_ = FALSE;
			ValaMarkupReader* _tmp294_;
			const gchar* _tmp295_;
			const gchar* _tmp296_;
			gboolean is_instance_parameter = FALSE;
			gboolean _tmp301_ = FALSE;
			gboolean caller_allocates = FALSE;
			gint array_length_idx = 0;
			gint closure_idx = 0;
			gint destroy_idx = 0;
			gchar* scope = NULL;
			gchar* default_param_name = NULL;
			ValaComment* param_comment = NULL;
			ValaArrayList* _tmp302_;
			gint _tmp303_;
			gint _tmp304_;
			gchar* _tmp305_;
			ValaParameter* param = NULL;
			const gchar* _tmp306_;
			gboolean _tmp307_ = FALSE;
			gint _tmp308_ = 0;
			gint _tmp309_ = 0;
			gint _tmp310_ = 0;
			gchar* _tmp311_ = NULL;
			ValaComment* _tmp312_ = NULL;
			ValaParameter* _tmp313_;
			ValaComment* _tmp391_;
			ValaGirParserParameterInfo* info = NULL;
			ValaParameter* _tmp408_;
			const gchar* _tmp409_;
			ValaGirParserParameterInfo* _tmp410_;
			ValaGirParserParameterInfo* _tmp411_;
			ValaArrayList* _tmp412_;
			ValaGirParserParameterInfo* _tmp413_;
			if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			_tmp294_ = self->priv->reader;
			_tmp295_ = vala_markup_reader_get_name (_tmp294_);
			_tmp296_ = _tmp295_;
			if (g_strcmp0 (_tmp296_, "instance-parameter") == 0) {
				gboolean _tmp297_ = FALSE;
				const gchar* _tmp298_;
				_tmp298_ = symbol_type;
				if (g_strcmp0 (_tmp298_, "function") == 0) {
					_tmp297_ = TRUE;
				} else {
					const gchar* _tmp299_;
					_tmp299_ = symbol_type;
					_tmp297_ = g_strcmp0 (_tmp299_, "constructor") == 0;
				}
				_tmp293_ = !_tmp297_;
			} else {
				_tmp293_ = FALSE;
			}
			is_instance_parameter = _tmp293_;
			if (!is_instance_parameter) {
				gint _tmp300_;
				_tmp300_ = current_parameter_idx;
				current_parameter_idx = _tmp300_ + 1;
			}
			if (instance_idx > -2) {
				_tmp301_ = instance_idx == current_parameter_idx;
			} else {
				_tmp301_ = FALSE;
			}
			if (_tmp301_) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			if (!vala_gir_parser_push_metadata (self)) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			default_param_name = NULL;
			_tmp302_ = parameters;
			_tmp303_ = vala_collection_get_size ((ValaCollection*) _tmp302_);
			_tmp304_ = _tmp303_;
			_tmp305_ = g_strdup_printf ("arg%d", _tmp304_);
			_g_free0 (default_param_name);
			default_param_name = _tmp305_;
			_tmp306_ = default_param_name;
			_tmp313_ = vala_gir_parser_parse_parameter (self, &_tmp307_, &_tmp308_, &_tmp309_, &_tmp310_, &_tmp311_, &_tmp312_, _tmp306_);
			caller_allocates = _tmp307_;
			array_length_idx = _tmp308_;
			closure_idx = _tmp309_;
			destroy_idx = _tmp310_;
			_g_free0 (scope);
			scope = _tmp311_;
			_vala_comment_unref0 (param_comment);
			param_comment = _tmp312_;
			param = _tmp313_;
			if (is_instance_parameter) {
				ValaMethod* m = NULL;
				ValaSymbol* _tmp314_;
				ValaMethod* _tmp315_;
				_tmp314_ = s;
				m = VALA_IS_METHOD (_tmp314_) ? ((ValaMethod*) _tmp314_) : NULL;
				_tmp315_ = m;
				if (_tmp315_ != NULL) {
					ValaParameter* _tmp316_;
					ValaParameterDirection _tmp317_;
					ValaParameterDirection _tmp318_;
					ValaMethod* _tmp374_;
					_tmp316_ = param;
					_tmp317_ = vala_parameter_get_direction (_tmp316_);
					_tmp318_ = _tmp317_;
					if (_tmp318_ == VALA_PARAMETER_DIRECTION_IN) {
						ValaParameter* _tmp319_;
						ValaDataType* _tmp320_;
						ValaDataType* _tmp321_;
						gboolean _tmp322_;
						gboolean _tmp323_;
						_tmp319_ = param;
						_tmp320_ = vala_variable_get_variable_type ((ValaVariable*) _tmp319_);
						_tmp321_ = _tmp320_;
						_tmp322_ = vala_data_type_get_value_owned (_tmp321_);
						_tmp323_ = _tmp322_;
						if (_tmp323_) {
							ValaMethod* _tmp324_;
							_tmp324_ = m;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp324_, "DestroysInstance", TRUE, NULL);
						}
						vala_gir_parser_pop_metadata (self);
						_vala_code_node_unref0 (param);
						_vala_comment_unref0 (param_comment);
						_g_free0 (default_param_name);
						_g_free0 (scope);
						continue;
					} else {
						gboolean _tmp325_ = FALSE;
						gboolean _tmp326_ = FALSE;
						ValaGirParserNode* _tmp327_;
						ValaGirParserNode* _tmp328_;
						ValaSymbol* _tmp329_;
						_tmp327_ = self->priv->current;
						_tmp328_ = _tmp327_->parent;
						_tmp329_ = _tmp328_->symbol;
						if (VALA_IS_STRUCT (_tmp329_)) {
							_tmp326_ = caller_allocates;
						} else {
							_tmp326_ = FALSE;
						}
						if (_tmp326_) {
							ValaParameter* _tmp330_;
							ValaParameterDirection _tmp331_;
							ValaParameterDirection _tmp332_;
							_tmp330_ = param;
							_tmp331_ = vala_parameter_get_direction (_tmp330_);
							_tmp332_ = _tmp331_;
							_tmp325_ = _tmp332_ == VALA_PARAMETER_DIRECTION_OUT;
						} else {
							_tmp325_ = FALSE;
						}
						if (_tmp325_) {
							gchar* cm_name = NULL;
							ValaMethod* _tmp333_;
							const gchar* _tmp334_;
							const gchar* _tmp335_;
							gchar* _tmp336_;
							gboolean _tmp337_ = FALSE;
							const gchar* _tmp338_;
							_tmp333_ = m;
							_tmp334_ = vala_symbol_get_name ((ValaSymbol*) _tmp333_);
							_tmp335_ = _tmp334_;
							_tmp336_ = g_strdup (_tmp335_);
							cm_name = _tmp336_;
							_tmp338_ = cm_name;
							if (_tmp338_ != NULL) {
								gboolean _tmp339_ = FALSE;
								const gchar* _tmp340_;
								_tmp340_ = cm_name;
								if (g_strcmp0 (_tmp340_, "init") == 0) {
									_tmp339_ = TRUE;
								} else {
									const gchar* _tmp341_;
									_tmp341_ = cm_name;
									_tmp339_ = g_str_has_prefix (_tmp341_, "init_");
								}
								_tmp337_ = _tmp339_;
							} else {
								_tmp337_ = FALSE;
							}
							if (_tmp337_) {
								const gchar* _tmp342_;
								const gchar* _tmp348_;
								ValaMethod* _tmp349_;
								ValaSourceReference* _tmp350_;
								ValaSourceReference* _tmp351_;
								ValaMethod* _tmp352_;
								ValaComment* _tmp353_;
								ValaComment* _tmp354_;
								ValaCreationMethod* _tmp355_;
								ValaSymbol* _tmp356_;
								ValaGirParserNode* _tmp357_;
								ValaSymbol* _tmp358_;
								ValaSymbol* _tmp359_;
								_tmp342_ = cm_name;
								if (g_strcmp0 (_tmp342_, "init") == 0) {
									_g_free0 (cm_name);
									cm_name = NULL;
								} else {
									const gchar* _tmp343_;
									_tmp343_ = cm_name;
									if (g_str_has_prefix (_tmp343_, "init_")) {
										const gchar* _tmp344_;
										gint _tmp345_;
										gint _tmp346_;
										gchar* _tmp347_;
										_tmp344_ = cm_name;
										_tmp345_ = strlen ("init_");
										_tmp346_ = _tmp345_;
										_tmp347_ = string_substring (_tmp344_, (glong) _tmp346_, (glong) -1);
										_g_free0 (cm_name);
										cm_name = _tmp347_;
									}
								}
								_tmp348_ = cm_name;
								_tmp349_ = m;
								_tmp350_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp349_);
								_tmp351_ = _tmp350_;
								_tmp352_ = m;
								_tmp353_ = vala_symbol_get_comment ((ValaSymbol*) _tmp352_);
								_tmp354_ = _tmp353_;
								_tmp355_ = vala_creation_method_new (NULL, _tmp348_, _tmp351_, _tmp354_);
								_vala_code_node_unref0 (s);
								s = (ValaSymbol*) _tmp355_;
								_tmp356_ = s;
								vala_symbol_set_access (_tmp356_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp357_ = self->priv->current;
								_tmp358_ = s;
								_tmp359_ = _vala_code_node_ref0 (_tmp358_);
								_vala_code_node_unref0 (_tmp357_->symbol);
								_tmp357_->symbol = _tmp359_;
								vala_gir_parser_pop_metadata (self);
								_g_free0 (cm_name);
								_vala_code_node_unref0 (param);
								_vala_comment_unref0 (param_comment);
								_g_free0 (default_param_name);
								_g_free0 (scope);
								continue;
							}
							_g_free0 (cm_name);
						} else {
							gboolean _tmp360_ = FALSE;
							gboolean _tmp361_ = FALSE;
							gboolean _tmp362_ = FALSE;
							ValaGirParserNode* _tmp363_;
							ValaGirParserNode* _tmp364_;
							ValaSymbol* _tmp365_;
							_tmp363_ = self->priv->current;
							_tmp364_ = _tmp363_->parent;
							_tmp365_ = _tmp364_->symbol;
							if (VALA_IS_CLASS (_tmp365_)) {
								ValaGirParserNode* _tmp366_;
								ValaGirParserNode* _tmp367_;
								ValaSymbol* _tmp368_;
								gboolean _tmp369_;
								gboolean _tmp370_;
								_tmp366_ = self->priv->current;
								_tmp367_ = _tmp366_->parent;
								_tmp368_ = _tmp367_->symbol;
								_tmp369_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp368_, VALA_TYPE_CLASS, ValaClass));
								_tmp370_ = _tmp369_;
								_tmp362_ = _tmp370_;
							} else {
								_tmp362_ = FALSE;
							}
							if (_tmp362_) {
								_tmp361_ = caller_allocates;
							} else {
								_tmp361_ = FALSE;
							}
							if (_tmp361_) {
								ValaParameter* _tmp371_;
								ValaParameterDirection _tmp372_;
								ValaParameterDirection _tmp373_;
								_tmp371_ = param;
								_tmp372_ = vala_parameter_get_direction (_tmp371_);
								_tmp373_ = _tmp372_;
								_tmp360_ = _tmp373_ == VALA_PARAMETER_DIRECTION_OUT;
							} else {
								_tmp360_ = FALSE;
							}
							if (_tmp360_) {
								vala_gir_parser_pop_metadata (self);
								_vala_code_node_unref0 (param);
								_vala_comment_unref0 (param_comment);
								_g_free0 (default_param_name);
								_g_free0 (scope);
								continue;
							}
						}
					}
					_tmp374_ = m;
					vala_method_set_binding (_tmp374_, VALA_MEMBER_BINDING_STATIC);
				}
			}
			if (array_length_idx != -1) {
				gboolean _tmp375_ = FALSE;
				ValaGirParserNode* _tmp377_;
				ValaArrayList* _tmp378_;
				if (instance_idx > -2) {
					_tmp375_ = instance_idx < array_length_idx;
				} else {
					_tmp375_ = FALSE;
				}
				if (_tmp375_) {
					gint _tmp376_;
					_tmp376_ = array_length_idx;
					array_length_idx = _tmp376_ - 1;
				}
				_tmp377_ = self->priv->current;
				_tmp378_ = _tmp377_->array_length_parameters;
				vala_collection_add ((ValaCollection*) _tmp378_, (gpointer) ((gintptr) array_length_idx));
			}
			if (closure_idx != -1) {
				gboolean _tmp379_ = FALSE;
				ValaGirParserNode* _tmp381_;
				ValaArrayList* _tmp382_;
				if (instance_idx > -2) {
					_tmp379_ = instance_idx < closure_idx;
				} else {
					_tmp379_ = FALSE;
				}
				if (_tmp379_) {
					gint _tmp380_;
					_tmp380_ = closure_idx;
					closure_idx = _tmp380_ - 1;
				}
				_tmp381_ = self->priv->current;
				_tmp382_ = _tmp381_->closure_parameters;
				if (vala_list_index_of ((ValaList*) _tmp382_, (gpointer) ((gintptr) current_parameter_idx)) < 0) {
					ValaGirParserNode* _tmp383_;
					ValaArrayList* _tmp384_;
					_tmp383_ = self->priv->current;
					_tmp384_ = _tmp383_->closure_parameters;
					vala_collection_add ((ValaCollection*) _tmp384_, (gpointer) ((gintptr) closure_idx));
				}
			}
			if (destroy_idx != -1) {
				gboolean _tmp385_ = FALSE;
				ValaGirParserNode* _tmp387_;
				ValaArrayList* _tmp388_;
				if (instance_idx > -2) {
					_tmp385_ = instance_idx < destroy_idx;
				} else {
					_tmp385_ = FALSE;
				}
				if (_tmp385_) {
					gint _tmp386_;
					_tmp386_ = destroy_idx;
					destroy_idx = _tmp386_ - 1;
				}
				_tmp387_ = self->priv->current;
				_tmp388_ = _tmp387_->destroy_parameters;
				if (vala_list_index_of ((ValaList*) _tmp388_, (gpointer) ((gintptr) current_parameter_idx)) < 0) {
					ValaGirParserNode* _tmp389_;
					ValaArrayList* _tmp390_;
					_tmp389_ = self->priv->current;
					_tmp390_ = _tmp389_->destroy_parameters;
					vala_collection_add ((ValaCollection*) _tmp390_, (gpointer) ((gintptr) destroy_idx));
				}
			}
			_tmp391_ = param_comment;
			if (_tmp391_ != NULL) {
				ValaGirComment* _tmp392_;
				const gchar* _tmp399_ = NULL;
				ValaParameter* _tmp400_;
				gboolean _tmp401_;
				gboolean _tmp402_;
				ValaGirComment* _tmp406_;
				ValaComment* _tmp407_;
				_tmp392_ = comment;
				if (_tmp392_ == NULL) {
					ValaSymbol* _tmp393_;
					ValaSourceReference* _tmp394_;
					ValaSourceReference* _tmp395_;
					ValaGirComment* _tmp396_;
					ValaSymbol* _tmp397_;
					ValaGirComment* _tmp398_;
					_tmp393_ = s;
					_tmp394_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp393_);
					_tmp395_ = _tmp394_;
					_tmp396_ = vala_gir_comment_new (NULL, _tmp395_);
					_vala_comment_unref0 (comment);
					comment = _tmp396_;
					_tmp397_ = s;
					_tmp398_ = comment;
					vala_symbol_set_comment (_tmp397_, (ValaComment*) _tmp398_);
				}
				_tmp400_ = param;
				_tmp401_ = vala_parameter_get_ellipsis (_tmp400_);
				_tmp402_ = _tmp401_;
				if (_tmp402_) {
					_tmp399_ = "...";
				} else {
					ValaParameter* _tmp403_;
					const gchar* _tmp404_;
					const gchar* _tmp405_;
					_tmp403_ = param;
					_tmp404_ = vala_symbol_get_name ((ValaSymbol*) _tmp403_);
					_tmp405_ = _tmp404_;
					_tmp399_ = _tmp405_;
				}
				_tmp406_ = comment;
				_tmp407_ = param_comment;
				vala_gir_comment_add_content_for_parameter (_tmp406_, _tmp399_, _tmp407_);
			}
			_tmp408_ = param;
			_tmp409_ = scope;
			_tmp410_ = vala_gir_parser_parameter_info_new (_tmp408_, array_length_idx, closure_idx, destroy_idx, g_strcmp0 (_tmp409_, "async") == 0);
			info = _tmp410_;
			_tmp411_ = info;
			_tmp411_->caller_allocates = caller_allocates;
			_tmp412_ = parameters;
			_tmp413_ = info;
			vala_collection_add ((ValaCollection*) _tmp412_, _tmp413_);
			vala_gir_parser_pop_metadata (self);
			_vala_gir_parser_parameter_info_unref0 (info);
			_vala_code_node_unref0 (param);
			_vala_comment_unref0 (param_comment);
			_g_free0 (default_param_name);
			_g_free0 (scope);
		}
		vala_gir_parser_end_element (self, "parameters");
	}
	_tmp414_ = self->priv->current;
	_tmp415_ = parameters;
	_tmp416_ = _vala_iterable_ref0 ((ValaList*) _tmp415_);
	_vala_iterable_unref0 (_tmp414_->parameters);
	_tmp414_->parameters = _tmp416_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_vala_iterable_unref0 (parameters);
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (s);
	_g_free0 (return_ctype);
	_vala_code_node_unref0 (return_type);
	_vala_comment_unref0 (comment);
	_g_free0 (invoker);
	_g_free0 (throws_string);
	_g_free0 (name);
	_g_free0 (ctype);
	_g_free0 (symbol_type);
}

static void
vala_gir_parser_parse_method (ValaGirParser* self,
                              const gchar* element_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_parse_function (self, element_name);
}

static void
vala_gir_parser_parse_signal (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "glib:signal");
}

static void
vala_gir_parser_parse_boxed (ValaGirParser* self,
                             const gchar* element_name)
{
	gchar* name = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaClass* cl = NULL;
	gboolean require_copy_free = FALSE;
	ValaGirParserNode* _tmp8_;
	ValaClass* _tmp32_;
	ValaClass* _tmp33_;
	ValaClass* _tmp34_;
	ValaGirParserMetadata* _tmp35_;
	ValaGirParserMetadata* _tmp45_;
	ValaGirParserMetadata* _tmp55_;
	ValaGirParserMetadata* _tmp65_;
	ValaGirParserMetadata* _tmp75_;
	ValaGirParserMetadata* _tmp80_;
	ValaClass* _tmp90_;
	ValaGirComment* _tmp91_;
	ValaGirComment* _tmp92_;
	ValaGirParserNode* ref_method = NULL;
	ValaGirParserNode* unref_method = NULL;
	gboolean _tmp134_ = FALSE;
	gboolean _tmp135_ = FALSE;
	gboolean _tmp136_ = FALSE;
	ValaClass* _tmp137_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	name = _tmp1_;
	_tmp2_ = name;
	if (_tmp2_ == NULL) {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:name");
		_g_free0 (name);
		name = _tmp4_;
	}
	_tmp5_ = name;
	_tmp6_ = vala_gir_parser_element_get_name (self, _tmp5_);
	_tmp7_ = _tmp6_;
	vala_gir_parser_push_node (self, _tmp7_, TRUE);
	_g_free0 (_tmp7_);
	require_copy_free = FALSE;
	_tmp8_ = self->priv->current;
	if (_tmp8_->new_symbol) {
		ValaGirParserNode* _tmp9_;
		const gchar* _tmp10_;
		ValaGirParserNode* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaClass* _tmp13_;
		ValaGirParserMetadata* _tmp14_;
		gboolean _tmp18_ = FALSE;
		ValaGirParserMetadata* _tmp19_;
		ValaGirParserNode* _tmp26_;
		ValaClass* _tmp27_;
		ValaSymbol* _tmp28_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->name;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_->source_reference;
		_tmp13_ = vala_class_new (_tmp10_, _tmp12_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp13_;
		_tmp14_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp14_, VALA_GIR_PARSER_ARGUMENT_TYPE_COMPACT)) {
			ValaClass* _tmp15_;
			ValaGirParserMetadata* _tmp16_;
			_tmp15_ = cl;
			_tmp16_ = self->priv->metadata;
			vala_code_node_set_attribute ((ValaCodeNode*) _tmp15_, "Compact", vala_gir_parser_metadata_get_bool (_tmp16_, VALA_GIR_PARSER_ARGUMENT_TYPE_COMPACT, FALSE), NULL);
		} else {
			ValaClass* _tmp17_;
			_tmp17_ = cl;
			vala_code_node_set_attribute ((ValaCodeNode*) _tmp17_, "Compact", TRUE, NULL);
		}
		_tmp19_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp19_, VALA_GIR_PARSER_ARGUMENT_TYPE_SEALED)) {
			ValaGirParserMetadata* _tmp20_;
			_tmp20_ = self->priv->metadata;
			_tmp18_ = vala_gir_parser_metadata_get_bool (_tmp20_, VALA_GIR_PARSER_ARGUMENT_TYPE_SEALED, FALSE);
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaClass* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_;
			_tmp21_ = cl;
			_tmp22_ = vala_class_get_is_compact (_tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_) {
				ValaClass* _tmp24_;
				_tmp24_ = cl;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp24_, "Compact", "opaque", TRUE, NULL);
			} else {
				ValaClass* _tmp25_;
				_tmp25_ = cl;
				vala_class_set_is_sealed (_tmp25_, TRUE);
			}
		}
		_tmp26_ = self->priv->current;
		_tmp27_ = cl;
		_tmp28_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp27_);
		_vala_code_node_unref0 (_tmp26_->symbol);
		_tmp26_->symbol = _tmp28_;
	} else {
		ValaGirParserNode* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaClass* _tmp31_;
		_tmp29_ = self->priv->current;
		_tmp30_ = _tmp29_->symbol;
		_tmp31_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_CLASS, ValaClass));
		_vala_code_node_unref0 (cl);
		cl = _tmp31_;
	}
	_tmp32_ = cl;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp32_);
	_tmp33_ = cl;
	require_copy_free = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp33_, "CCode", "type_id");
	_tmp34_ = cl;
	vala_symbol_set_access ((ValaSymbol*) _tmp34_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp35_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp35_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE)) {
		ValaClass* _tmp36_;
		ValaGirParserMetadata* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		ValaGirParserMetadata* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaDataType* _tmp43_;
		ValaDataType* _tmp44_;
		_tmp36_ = cl;
		_tmp37_ = self->priv->metadata;
		_tmp38_ = vala_gir_parser_metadata_get_string (_tmp37_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp39_ = _tmp38_;
		_tmp40_ = self->priv->metadata;
		_tmp41_ = vala_gir_parser_metadata_get_source_reference (_tmp40_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_gir_parser_parse_type_from_string (self, _tmp39_, TRUE, _tmp42_);
		_tmp44_ = _tmp43_;
		vala_class_add_base_type (_tmp36_, _tmp44_);
		_vala_code_node_unref0 (_tmp44_);
		_vala_source_reference_unref0 (_tmp42_);
		_g_free0 (_tmp39_);
	}
	_tmp45_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp45_, VALA_GIR_PARSER_ARGUMENT_TYPE_COPY_FUNCTION)) {
		ValaClass* _tmp46_;
		ValaGirParserMetadata* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		_tmp46_ = cl;
		_tmp47_ = self->priv->metadata;
		_tmp48_ = vala_gir_parser_metadata_get_string (_tmp47_, VALA_GIR_PARSER_ARGUMENT_TYPE_COPY_FUNCTION);
		_tmp49_ = _tmp48_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp46_, "CCode", "copy_function", _tmp49_, NULL);
		_g_free0 (_tmp49_);
	} else {
		ValaMarkupReader* _tmp50_;
		_tmp50_ = self->priv->reader;
		if (vala_markup_reader_has_attribute (_tmp50_, "copy-function")) {
			ValaClass* _tmp51_;
			ValaMarkupReader* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			_tmp51_ = cl;
			_tmp52_ = self->priv->reader;
			_tmp53_ = vala_markup_reader_get_attribute (_tmp52_, "copy-function");
			_tmp54_ = _tmp53_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp51_, "CCode", "copy_function", _tmp54_, NULL);
			_g_free0 (_tmp54_);
		}
	}
	_tmp55_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp55_, VALA_GIR_PARSER_ARGUMENT_TYPE_FREE_FUNCTION)) {
		ValaClass* _tmp56_;
		ValaGirParserMetadata* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		_tmp56_ = cl;
		_tmp57_ = self->priv->metadata;
		_tmp58_ = vala_gir_parser_metadata_get_string (_tmp57_, VALA_GIR_PARSER_ARGUMENT_TYPE_FREE_FUNCTION);
		_tmp59_ = _tmp58_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp56_, "CCode", "free_function", _tmp59_, NULL);
		_g_free0 (_tmp59_);
	} else {
		ValaMarkupReader* _tmp60_;
		_tmp60_ = self->priv->reader;
		if (vala_markup_reader_has_attribute (_tmp60_, "free-function")) {
			ValaClass* _tmp61_;
			ValaMarkupReader* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			_tmp61_ = cl;
			_tmp62_ = self->priv->reader;
			_tmp63_ = vala_markup_reader_get_attribute (_tmp62_, "free-function");
			_tmp64_ = _tmp63_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp61_, "CCode", "free_function", _tmp64_, NULL);
			_g_free0 (_tmp64_);
		}
	}
	_tmp65_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp65_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF_FUNCTION)) {
		ValaClass* _tmp66_;
		ValaGirParserMetadata* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		_tmp66_ = cl;
		_tmp67_ = self->priv->metadata;
		_tmp68_ = vala_gir_parser_metadata_get_string (_tmp67_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF_FUNCTION);
		_tmp69_ = _tmp68_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp66_, "CCode", "ref_function", _tmp69_, NULL);
		_g_free0 (_tmp69_);
	} else {
		ValaMarkupReader* _tmp70_;
		_tmp70_ = self->priv->reader;
		if (vala_markup_reader_has_attribute (_tmp70_, "glib:ref-func")) {
			ValaClass* _tmp71_;
			ValaMarkupReader* _tmp72_;
			gchar* _tmp73_;
			gchar* _tmp74_;
			_tmp71_ = cl;
			_tmp72_ = self->priv->reader;
			_tmp73_ = vala_markup_reader_get_attribute (_tmp72_, "glib:ref-func");
			_tmp74_ = _tmp73_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp71_, "CCode", "ref_function", _tmp74_, NULL);
			_g_free0 (_tmp74_);
		}
	}
	_tmp75_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp75_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF_SINK_FUNCTION)) {
		ValaClass* _tmp76_;
		ValaGirParserMetadata* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		_tmp76_ = cl;
		_tmp77_ = self->priv->metadata;
		_tmp78_ = vala_gir_parser_metadata_get_string (_tmp77_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF_SINK_FUNCTION);
		_tmp79_ = _tmp78_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp76_, "CCode", "ref_sink_function", _tmp79_, NULL);
		_g_free0 (_tmp79_);
	}
	_tmp80_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp80_, VALA_GIR_PARSER_ARGUMENT_TYPE_UNREF_FUNCTION)) {
		ValaClass* _tmp81_;
		ValaGirParserMetadata* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
		_tmp81_ = cl;
		_tmp82_ = self->priv->metadata;
		_tmp83_ = vala_gir_parser_metadata_get_string (_tmp82_, VALA_GIR_PARSER_ARGUMENT_TYPE_UNREF_FUNCTION);
		_tmp84_ = _tmp83_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp81_, "CCode", "unref_function", _tmp84_, NULL);
		_g_free0 (_tmp84_);
	} else {
		ValaMarkupReader* _tmp85_;
		_tmp85_ = self->priv->reader;
		if (vala_markup_reader_has_attribute (_tmp85_, "glib:unref-func")) {
			ValaClass* _tmp86_;
			ValaMarkupReader* _tmp87_;
			gchar* _tmp88_;
			gchar* _tmp89_;
			_tmp86_ = cl;
			_tmp87_ = self->priv->reader;
			_tmp88_ = vala_markup_reader_get_attribute (_tmp87_, "glib:unref-func");
			_tmp89_ = _tmp88_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp86_, "CCode", "unref_function", _tmp89_, NULL);
			_g_free0 (_tmp89_);
		}
	}
	vala_gir_parser_next (self);
	_tmp90_ = cl;
	_tmp91_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp92_ = _tmp91_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp90_, (ValaComment*) _tmp92_);
	_vala_comment_unref0 (_tmp92_);
	ref_method = NULL;
	unref_method = NULL;
	while (TRUE) {
		ValaMarkupReader* _tmp93_;
		const gchar* _tmp94_;
		const gchar* _tmp95_;
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp93_ = self->priv->reader;
		_tmp94_ = vala_markup_reader_get_name (_tmp93_);
		_tmp95_ = _tmp94_;
		if (g_strcmp0 (_tmp95_, "field") == 0) {
			vala_gir_parser_parse_field (self);
		} else {
			ValaMarkupReader* _tmp96_;
			const gchar* _tmp97_;
			const gchar* _tmp98_;
			_tmp96_ = self->priv->reader;
			_tmp97_ = vala_markup_reader_get_name (_tmp96_);
			_tmp98_ = _tmp97_;
			if (g_strcmp0 (_tmp98_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp99_;
				const gchar* _tmp100_;
				const gchar* _tmp101_;
				_tmp99_ = self->priv->reader;
				_tmp100_ = vala_markup_reader_get_name (_tmp99_);
				_tmp101_ = _tmp100_;
				if (g_strcmp0 (_tmp101_, "method") == 0) {
					gchar* cname = NULL;
					ValaGirParserNode* _tmp102_;
					gchar* _tmp103_;
					gboolean _tmp104_ = FALSE;
					const gchar* _tmp105_;
					vala_gir_parser_parse_method (self, "method");
					_tmp102_ = self->priv->old_current;
					_tmp103_ = vala_gir_parser_node_get_cname (_tmp102_);
					cname = _tmp103_;
					_tmp105_ = cname;
					if (g_str_has_suffix (_tmp105_, "_ref")) {
						gboolean _tmp106_ = FALSE;
						ValaGirParserNode* _tmp107_;
						_tmp107_ = ref_method;
						if (_tmp107_ == NULL) {
							_tmp106_ = TRUE;
						} else {
							ValaGirParserNode* _tmp108_;
							const gchar* _tmp109_;
							_tmp108_ = self->priv->old_current;
							_tmp109_ = _tmp108_->name;
							_tmp106_ = g_strcmp0 (_tmp109_, "ref") == 0;
						}
						_tmp104_ = _tmp106_;
					} else {
						_tmp104_ = FALSE;
					}
					if (_tmp104_) {
						ValaGirParserNode* _tmp110_;
						ValaGirParserNode* _tmp111_;
						_tmp110_ = self->priv->old_current;
						_tmp111_ = _vala_gir_parser_node_ref0 (_tmp110_);
						_vala_gir_parser_node_unref0 (ref_method);
						ref_method = _tmp111_;
					} else {
						gboolean _tmp112_ = FALSE;
						const gchar* _tmp113_;
						_tmp113_ = cname;
						if (g_str_has_suffix (_tmp113_, "_unref")) {
							gboolean _tmp114_ = FALSE;
							ValaGirParserNode* _tmp115_;
							_tmp115_ = unref_method;
							if (_tmp115_ == NULL) {
								_tmp114_ = TRUE;
							} else {
								ValaGirParserNode* _tmp116_;
								const gchar* _tmp117_;
								_tmp116_ = self->priv->old_current;
								_tmp117_ = _tmp116_->name;
								_tmp114_ = g_strcmp0 (_tmp117_, "unref") == 0;
							}
							_tmp112_ = _tmp114_;
						} else {
							_tmp112_ = FALSE;
						}
						if (_tmp112_) {
							ValaGirParserNode* _tmp118_;
							ValaGirParserNode* _tmp119_;
							_tmp118_ = self->priv->old_current;
							_tmp119_ = _vala_gir_parser_node_ref0 (_tmp118_);
							_vala_gir_parser_node_unref0 (unref_method);
							unref_method = _tmp119_;
						}
					}
					_g_free0 (cname);
				} else {
					ValaMarkupReader* _tmp120_;
					const gchar* _tmp121_;
					const gchar* _tmp122_;
					_tmp120_ = self->priv->reader;
					_tmp121_ = vala_markup_reader_get_name (_tmp120_);
					_tmp122_ = _tmp121_;
					if (g_strcmp0 (_tmp122_, "function") == 0) {
						vala_gir_parser_parse_method (self, "function");
					} else {
						ValaMarkupReader* _tmp123_;
						const gchar* _tmp124_;
						const gchar* _tmp125_;
						_tmp123_ = self->priv->reader;
						_tmp124_ = vala_markup_reader_get_name (_tmp123_);
						_tmp125_ = _tmp124_;
						if (g_strcmp0 (_tmp125_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp126_;
							const gchar* _tmp127_;
							const gchar* _tmp128_;
							_tmp126_ = self->priv->reader;
							_tmp127_ = vala_markup_reader_get_name (_tmp126_);
							_tmp128_ = _tmp127_;
							if (g_strcmp0 (_tmp128_, "union") == 0) {
								vala_gir_parser_parse_union (self);
							} else {
								ValaSourceReference* _tmp129_;
								ValaSourceReference* _tmp130_;
								ValaMarkupReader* _tmp131_;
								const gchar* _tmp132_;
								const gchar* _tmp133_;
								_tmp129_ = vala_gir_parser_get_current_src (self);
								_tmp130_ = _tmp129_;
								_tmp131_ = self->priv->reader;
								_tmp132_ = vala_markup_reader_get_name (_tmp131_);
								_tmp133_ = _tmp132_;
								vala_report_error (_tmp130_, "unknown child element `%s' in `class'", _tmp133_);
								_vala_source_reference_unref0 (_tmp130_);
								vala_gir_parser_skip_element (self);
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	_tmp137_ = cl;
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp137_, "CCode", "ref_function")) {
		_tmp136_ = TRUE;
	} else {
		ValaClass* _tmp138_;
		_tmp138_ = cl;
		_tmp136_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp138_, "CCode", "unref_function");
	}
	if (_tmp136_) {
		_tmp135_ = TRUE;
	} else {
		ValaClass* _tmp139_;
		_tmp139_ = cl;
		_tmp135_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp139_, "CCode", "copy_function");
	}
	if (_tmp135_) {
		_tmp134_ = TRUE;
	} else {
		ValaClass* _tmp140_;
		_tmp140_ = cl;
		_tmp134_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp140_, "CCode", "free_function");
	}
	if (_tmp134_) {
	} else {
		gboolean _tmp141_ = FALSE;
		ValaGirParserNode* _tmp142_;
		_tmp142_ = ref_method;
		if (_tmp142_ != NULL) {
			ValaGirParserNode* _tmp143_;
			_tmp143_ = unref_method;
			_tmp141_ = _tmp143_ != NULL;
		} else {
			_tmp141_ = FALSE;
		}
		if (_tmp141_) {
			ValaClass* _tmp144_;
			ValaGirParserNode* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			ValaClass* _tmp148_;
			ValaGirParserNode* _tmp149_;
			gchar* _tmp150_;
			gchar* _tmp151_;
			_tmp144_ = cl;
			_tmp145_ = ref_method;
			_tmp146_ = vala_gir_parser_node_get_cname (_tmp145_);
			_tmp147_ = _tmp146_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp144_, "CCode", "ref_function", _tmp147_, NULL);
			_g_free0 (_tmp147_);
			_tmp148_ = cl;
			_tmp149_ = unref_method;
			_tmp150_ = vala_gir_parser_node_get_cname (_tmp149_);
			_tmp151_ = _tmp150_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp148_, "CCode", "unref_function", _tmp151_, NULL);
			_g_free0 (_tmp151_);
		} else {
			if (require_copy_free) {
				ValaClass* _tmp152_;
				ValaClass* _tmp153_;
				_tmp152_ = cl;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp152_, "CCode", "copy_function", "g_boxed_copy", NULL);
				_tmp153_ = cl;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp153_, "CCode", "free_function", "g_boxed_free", NULL);
			}
		}
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_vala_gir_parser_node_unref0 (unref_method);
	_vala_gir_parser_node_unref0 (ref_method);
	_vala_code_node_unref0 (cl);
	_g_free0 (name);
}

static void
vala_gir_parser_parse_union (ValaGirParser* self)
{
	gchar* element_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp20_;
	ValaStruct* st = NULL;
	ValaGirParserNode* _tmp21_;
	ValaStruct* _tmp34_;
	ValaStruct* _tmp35_;
	ValaGirComment* _tmp36_;
	ValaGirComment* _tmp37_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "union");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	element_name = _tmp0_;
	_tmp1_ = element_name;
	if (_tmp1_ == NULL) {
		ValaGirComment* _tmp2_;
		ValaGirComment* _tmp3_;
		vala_gir_parser_next (self);
		_tmp2_ = vala_gir_parser_parse_symbol_doc (self);
		_tmp3_ = _tmp2_;
		_vala_comment_unref0 (_tmp3_);
		while (TRUE) {
			ValaMarkupReader* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			if (!vala_gir_parser_push_metadata (self)) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			_tmp4_ = self->priv->reader;
			_tmp5_ = vala_markup_reader_get_name (_tmp4_);
			_tmp6_ = _tmp5_;
			if (g_strcmp0 (_tmp6_, "field") == 0) {
				vala_gir_parser_parse_field (self);
			} else {
				ValaMarkupReader* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				_tmp7_ = self->priv->reader;
				_tmp8_ = vala_markup_reader_get_name (_tmp7_);
				_tmp9_ = _tmp8_;
				if (g_strcmp0 (_tmp9_, "record") == 0) {
					ValaSourceReference* _tmp10_;
					ValaSourceReference* _tmp11_;
					ValaMarkupReader* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					_tmp10_ = vala_gir_parser_get_current_src (self);
					_tmp11_ = _tmp10_;
					_tmp12_ = self->priv->reader;
					_tmp13_ = vala_markup_reader_get_name (_tmp12_);
					_tmp14_ = _tmp13_;
					vala_report_warning (_tmp11_, "unhandled child element `%s' in `transparent union'", _tmp14_);
					_vala_source_reference_unref0 (_tmp11_);
					vala_gir_parser_skip_element (self);
				} else {
					ValaSourceReference* _tmp15_;
					ValaSourceReference* _tmp16_;
					ValaMarkupReader* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					_tmp15_ = vala_gir_parser_get_current_src (self);
					_tmp16_ = _tmp15_;
					_tmp17_ = self->priv->reader;
					_tmp18_ = vala_markup_reader_get_name (_tmp17_);
					_tmp19_ = _tmp18_;
					vala_report_error (_tmp16_, "unknown child element `%s' in `transparent union'", _tmp19_);
					_vala_source_reference_unref0 (_tmp16_);
					vala_gir_parser_skip_element (self);
				}
			}
			vala_gir_parser_pop_metadata (self);
		}
		vala_gir_parser_end_element (self, "union");
		_g_free0 (element_name);
		return;
	}
	_tmp20_ = element_name;
	vala_gir_parser_push_node (self, _tmp20_, TRUE);
	_tmp21_ = self->priv->current;
	if (_tmp21_->new_symbol) {
		ValaMarkupReader* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		ValaGirParserNode* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaStruct* _tmp27_;
		ValaGirParserNode* _tmp28_;
		ValaStruct* _tmp29_;
		ValaSymbol* _tmp30_;
		_tmp22_ = self->priv->reader;
		_tmp23_ = vala_markup_reader_get_attribute (_tmp22_, "name");
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->current;
		_tmp26_ = _tmp25_->source_reference;
		_tmp27_ = vala_struct_new (_tmp24_, _tmp26_, NULL);
		_vala_code_node_unref0 (st);
		st = _tmp27_;
		_g_free0 (_tmp24_);
		_tmp28_ = self->priv->current;
		_tmp29_ = st;
		_tmp30_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp29_);
		_vala_code_node_unref0 (_tmp28_->symbol);
		_tmp28_->symbol = _tmp30_;
	} else {
		ValaGirParserNode* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaStruct* _tmp33_;
		_tmp31_ = self->priv->current;
		_tmp32_ = _tmp31_->symbol;
		_tmp33_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_STRUCT, ValaStruct));
		_vala_code_node_unref0 (st);
		st = _tmp33_;
	}
	_tmp34_ = st;
	vala_symbol_set_access ((ValaSymbol*) _tmp34_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_gir_parser_next (self);
	_tmp35_ = st;
	_tmp36_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp37_ = _tmp36_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp35_, (ValaComment*) _tmp37_);
	_vala_comment_unref0 (_tmp37_);
	while (TRUE) {
		ValaMarkupReader* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		if (!(self->priv->current_token == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp38_ = self->priv->reader;
		_tmp39_ = vala_markup_reader_get_name (_tmp38_);
		_tmp40_ = _tmp39_;
		if (g_strcmp0 (_tmp40_, "field") == 0) {
			vala_gir_parser_parse_field (self);
		} else {
			ValaMarkupReader* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			_tmp41_ = self->priv->reader;
			_tmp42_ = vala_markup_reader_get_name (_tmp41_);
			_tmp43_ = _tmp42_;
			if (g_strcmp0 (_tmp43_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				_tmp44_ = self->priv->reader;
				_tmp45_ = vala_markup_reader_get_name (_tmp44_);
				_tmp46_ = _tmp45_;
				if (g_strcmp0 (_tmp46_, "method") == 0) {
					vala_gir_parser_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp47_;
					const gchar* _tmp48_;
					const gchar* _tmp49_;
					_tmp47_ = self->priv->reader;
					_tmp48_ = vala_markup_reader_get_name (_tmp47_);
					_tmp49_ = _tmp48_;
					if (g_strcmp0 (_tmp49_, "function") == 0) {
						vala_gir_parser_parse_method (self, "function");
					} else {
						ValaMarkupReader* _tmp50_;
						const gchar* _tmp51_;
						const gchar* _tmp52_;
						_tmp50_ = self->priv->reader;
						_tmp51_ = vala_markup_reader_get_name (_tmp50_);
						_tmp52_ = _tmp51_;
						if (g_strcmp0 (_tmp52_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp53_;
							const gchar* _tmp54_;
							const gchar* _tmp55_;
							_tmp53_ = self->priv->reader;
							_tmp54_ = vala_markup_reader_get_name (_tmp53_);
							_tmp55_ = _tmp54_;
							if (g_strcmp0 (_tmp55_, "record") == 0) {
								vala_gir_parser_parse_record (self);
							} else {
								ValaSourceReference* _tmp56_;
								ValaSourceReference* _tmp57_;
								ValaMarkupReader* _tmp58_;
								const gchar* _tmp59_;
								const gchar* _tmp60_;
								_tmp56_ = vala_gir_parser_get_current_src (self);
								_tmp57_ = _tmp56_;
								_tmp58_ = self->priv->reader;
								_tmp59_ = vala_markup_reader_get_name (_tmp58_);
								_tmp60_ = _tmp59_;
								vala_report_error (_tmp57_, "unknown child element `%s' in `union'", _tmp60_);
								_vala_source_reference_unref0 (_tmp57_);
								vala_gir_parser_skip_element (self);
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "union");
	_vala_code_node_unref0 (st);
	_g_free0 (element_name);
}

static void
vala_gir_parser_parse_constant (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp2_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	gint array_length_idx = 0;
	ValaDataType* type = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaConstant* c = NULL;
	ValaGirParserNode* _tmp9_;
	const gchar* _tmp10_;
	ValaDataType* _tmp11_;
	ValaGirParserNode* _tmp12_;
	ValaSourceReference* _tmp13_;
	ValaConstant* _tmp14_;
	ValaGirParserNode* _tmp15_;
	ValaConstant* _tmp16_;
	ValaSymbol* _tmp17_;
	ValaConstant* _tmp18_;
	ValaConstant* _tmp19_;
	ValaGirComment* _tmp20_;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "constant");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, FALSE);
	_g_free0 (_tmp1_);
	vala_gir_parser_next (self);
	_tmp2_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp2_;
	_tmp6_ = vala_gir_parser_parse_type (self, NULL, &_tmp3_, TRUE, &_tmp4_, &_tmp5_);
	array_length_idx = _tmp3_;
	no_array_length = _tmp4_;
	array_null_terminated = _tmp5_;
	type = _tmp6_;
	_tmp7_ = type;
	_tmp8_ = vala_gir_parser_element_get_type (self, _tmp7_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp8_;
	_tmp9_ = self->priv->current;
	_tmp10_ = _tmp9_->name;
	_tmp11_ = type;
	_tmp12_ = self->priv->current;
	_tmp13_ = _tmp12_->source_reference;
	_tmp14_ = vala_constant_new (_tmp10_, _tmp11_, NULL, _tmp13_, NULL);
	c = _tmp14_;
	_tmp15_ = self->priv->current;
	_tmp16_ = c;
	_tmp17_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp16_);
	_vala_code_node_unref0 (_tmp15_->symbol);
	_tmp15_->symbol = _tmp17_;
	_tmp18_ = c;
	vala_symbol_set_access ((ValaSymbol*) _tmp18_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp19_ = c;
	_tmp20_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp19_, (ValaComment*) _tmp20_);
	if (no_array_length) {
		_tmp21_ = TRUE;
	} else {
		_tmp21_ = array_null_terminated;
	}
	if (_tmp21_) {
		ValaConstant* _tmp22_;
		_tmp22_ = c;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp22_, "CCode", "array_length", !no_array_length, NULL);
	}
	if (array_null_terminated) {
		ValaConstant* _tmp23_;
		_tmp23_ = c;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp23_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "constant");
	_vala_code_node_unref0 (c);
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
}

static void
vala_gir_parser_report_unused_metadata (ValaGirParser* self,
                                        ValaGirParserMetadata* metadata)
{
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaMap* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	if (metadata == _tmp1_) {
		return;
	}
	_tmp3_ = metadata->args;
	_tmp4_ = vala_map_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		ValaArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = metadata->children;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaSourceReference* _tmp9_;
		_tmp9_ = metadata->source_reference;
		vala_report_warning (_tmp9_, "empty metadata");
		return;
	}
	{
		ValaIterator* _arg_type_it = NULL;
		ValaMap* _tmp10_;
		ValaSet* _tmp11_;
		ValaSet* _tmp12_;
		ValaIterator* _tmp13_;
		ValaIterator* _tmp14_;
		_tmp10_ = metadata->args;
		_tmp11_ = vala_map_get_keys (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_iterable_iterator ((ValaIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_vala_iterable_unref0 (_tmp12_);
		_arg_type_it = _tmp14_;
		while (TRUE) {
			ValaIterator* _tmp15_;
			ValaGirParserArgumentType arg_type = 0;
			ValaIterator* _tmp16_;
			gpointer _tmp17_;
			ValaGirParserArgument* arg = NULL;
			ValaMap* _tmp18_;
			gpointer _tmp19_;
			ValaGirParserArgument* _tmp20_;
			_tmp15_ = _arg_type_it;
			if (!vala_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _arg_type_it;
			_tmp17_ = vala_iterator_get (_tmp16_);
			arg_type = (ValaGirParserArgumentType) ((gintptr) _tmp17_);
			_tmp18_ = metadata->args;
			_tmp19_ = vala_map_get (_tmp18_, (gpointer) ((gintptr) arg_type));
			arg = (ValaGirParserArgument*) _tmp19_;
			_tmp20_ = arg;
			if (!_tmp20_->used) {
				ValaGirParserArgument* _tmp21_;
				ValaSourceReference* _tmp22_;
				_tmp21_ = arg;
				_tmp22_ = _tmp21_->source_reference;
				vala_report_warning (_tmp22_, "argument never used");
			}
			_vala_gir_parser_argument_unref0 (arg);
		}
		_vala_iterator_unref0 (_arg_type_it);
	}
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp23_;
		gint _child_size = 0;
		ValaArrayList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _child_index = 0;
		_tmp23_ = metadata->children;
		_child_list = _tmp23_;
		_tmp24_ = _child_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_child_size = _tmp26_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			ValaGirParserMetadata* child = NULL;
			ValaArrayList* _tmp29_;
			gpointer _tmp30_;
			ValaGirParserMetadata* _tmp31_;
			_child_index = _child_index + 1;
			_tmp27_ = _child_index;
			_tmp28_ = _child_size;
			if (!(_tmp27_ < _tmp28_)) {
				break;
			}
			_tmp29_ = _child_list;
			_tmp30_ = vala_list_get ((ValaList*) _tmp29_, _child_index);
			child = (ValaGirParserMetadata*) _tmp30_;
			_tmp31_ = child;
			if (!_tmp31_->used) {
				ValaGirParserMetadata* _tmp32_;
				ValaSourceReference* _tmp33_;
				_tmp32_ = child;
				_tmp33_ = _tmp32_->source_reference;
				vala_report_warning (_tmp33_, "metadata never used");
			} else {
				ValaGirParserMetadata* _tmp34_;
				_tmp34_ = child;
				vala_gir_parser_report_unused_metadata (self, _tmp34_);
			}
			_vala_gir_parser_metadata_unref0 (child);
		}
	}
}

static void
vala_gir_parser_resolve_gir_symbols (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _map_from_list = NULL;
		ValaArrayList* _tmp0_;
		gint _map_from_size = 0;
		ValaArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _map_from_index = 0;
		_tmp0_ = self->priv->unresolved_gir_symbols;
		_map_from_list = _tmp0_;
		_tmp1_ = _map_from_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_map_from_size = _tmp3_;
		_map_from_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaUnresolvedSymbol* map_from = NULL;
			ValaArrayList* _tmp6_;
			gpointer _tmp7_;
			_map_from_index = _map_from_index + 1;
			_tmp4_ = _map_from_index;
			_tmp5_ = _map_from_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _map_from_list;
			_tmp7_ = vala_list_get ((ValaList*) _tmp6_, _map_from_index);
			map_from = (ValaUnresolvedSymbol*) _tmp7_;
			while (TRUE) {
				ValaUnresolvedSymbol* _tmp8_;
				ValaSymbol* map_to = NULL;
				ValaHashMap* _tmp9_;
				ValaUnresolvedSymbol* _tmp10_;
				gpointer _tmp11_;
				ValaSymbol* _tmp12_;
				ValaUnresolvedSymbol* _tmp62_;
				ValaUnresolvedSymbol* _tmp63_;
				ValaUnresolvedSymbol* _tmp64_;
				ValaUnresolvedSymbol* _tmp65_;
				_tmp8_ = map_from;
				if (!(_tmp8_ != NULL)) {
					break;
				}
				_tmp9_ = self->priv->unresolved_symbols_map;
				_tmp10_ = map_from;
				_tmp11_ = vala_map_get ((ValaMap*) _tmp9_, _tmp10_);
				map_to = (ValaSymbol*) _tmp11_;
				_tmp12_ = map_to;
				if (_tmp12_ != NULL) {
					ValaUnresolvedSymbol* _tmp13_;
					ValaUnresolvedSymbol* _tmp14_;
					ValaSymbol* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					ValaSymbol* _tmp18_;
					_tmp13_ = map_from;
					vala_unresolved_symbol_set_inner (_tmp13_, NULL);
					_tmp14_ = map_from;
					_tmp15_ = map_to;
					_tmp16_ = vala_symbol_get_name (_tmp15_);
					_tmp17_ = _tmp16_;
					vala_symbol_set_name ((ValaSymbol*) _tmp14_, _tmp17_);
					_tmp18_ = map_to;
					if (VALA_IS_UNRESOLVED_SYMBOL (_tmp18_)) {
						ValaUnresolvedSymbol* umap_to = NULL;
						ValaSymbol* _tmp19_;
						ValaUnresolvedSymbol* _tmp20_;
						_tmp19_ = map_to;
						_tmp20_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol));
						umap_to = _tmp20_;
						while (TRUE) {
							ValaUnresolvedSymbol* _tmp21_;
							ValaUnresolvedSymbol* _tmp22_;
							ValaUnresolvedSymbol* _tmp23_;
							ValaUnresolvedSymbol* _tmp24_;
							ValaUnresolvedSymbol* _tmp25_;
							ValaUnresolvedSymbol* _tmp26_;
							ValaUnresolvedSymbol* _tmp27_;
							ValaUnresolvedSymbol* _tmp28_;
							ValaUnresolvedSymbol* _tmp29_;
							const gchar* _tmp30_;
							const gchar* _tmp31_;
							ValaUnresolvedSymbol* _tmp32_;
							ValaUnresolvedSymbol* _tmp33_;
							ValaUnresolvedSymbol* _tmp34_;
							ValaUnresolvedSymbol* _tmp35_;
							ValaUnresolvedSymbol* _tmp36_;
							ValaUnresolvedSymbol* _tmp37_;
							_tmp21_ = umap_to;
							_tmp22_ = vala_unresolved_symbol_get_inner (_tmp21_);
							_tmp23_ = _tmp22_;
							if (!(_tmp23_ != NULL)) {
								break;
							}
							_tmp24_ = umap_to;
							_tmp25_ = vala_unresolved_symbol_get_inner (_tmp24_);
							_tmp26_ = _tmp25_;
							_tmp27_ = _vala_code_node_ref0 (_tmp26_);
							_vala_code_node_unref0 (umap_to);
							umap_to = _tmp27_;
							_tmp28_ = map_from;
							_tmp29_ = umap_to;
							_tmp30_ = vala_symbol_get_name ((ValaSymbol*) _tmp29_);
							_tmp31_ = _tmp30_;
							_tmp32_ = vala_unresolved_symbol_new (NULL, _tmp31_, NULL);
							_tmp33_ = _tmp32_;
							vala_unresolved_symbol_set_inner (_tmp28_, _tmp33_);
							_vala_code_node_unref0 (_tmp33_);
							_tmp34_ = map_from;
							_tmp35_ = vala_unresolved_symbol_get_inner (_tmp34_);
							_tmp36_ = _tmp35_;
							_tmp37_ = _vala_code_node_ref0 (_tmp36_);
							_vala_code_node_unref0 (map_from);
							map_from = _tmp37_;
						}
						_vala_code_node_unref0 (umap_to);
					} else {
						while (TRUE) {
							gboolean _tmp38_ = FALSE;
							ValaSymbol* _tmp39_;
							ValaSymbol* _tmp40_;
							ValaSymbol* _tmp41_;
							ValaSymbol* _tmp48_;
							ValaSymbol* _tmp49_;
							ValaSymbol* _tmp50_;
							ValaSymbol* _tmp51_;
							ValaUnresolvedSymbol* _tmp52_;
							ValaSymbol* _tmp53_;
							const gchar* _tmp54_;
							const gchar* _tmp55_;
							ValaUnresolvedSymbol* _tmp56_;
							ValaUnresolvedSymbol* _tmp57_;
							ValaUnresolvedSymbol* _tmp58_;
							ValaUnresolvedSymbol* _tmp59_;
							ValaUnresolvedSymbol* _tmp60_;
							ValaUnresolvedSymbol* _tmp61_;
							_tmp39_ = map_to;
							_tmp40_ = vala_symbol_get_parent_symbol (_tmp39_);
							_tmp41_ = _tmp40_;
							if (_tmp41_ != NULL) {
								ValaSymbol* _tmp42_;
								ValaSymbol* _tmp43_;
								ValaSymbol* _tmp44_;
								ValaCodeContext* _tmp45_;
								ValaNamespace* _tmp46_;
								ValaNamespace* _tmp47_;
								_tmp42_ = map_to;
								_tmp43_ = vala_symbol_get_parent_symbol (_tmp42_);
								_tmp44_ = _tmp43_;
								_tmp45_ = self->priv->context;
								_tmp46_ = vala_code_context_get_root (_tmp45_);
								_tmp47_ = _tmp46_;
								_tmp38_ = _tmp44_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_SYMBOL, ValaSymbol);
							} else {
								_tmp38_ = FALSE;
							}
							if (!_tmp38_) {
								break;
							}
							_tmp48_ = map_to;
							_tmp49_ = vala_symbol_get_parent_symbol (_tmp48_);
							_tmp50_ = _tmp49_;
							_tmp51_ = _vala_code_node_ref0 (_tmp50_);
							_vala_code_node_unref0 (map_to);
							map_to = _tmp51_;
							_tmp52_ = map_from;
							_tmp53_ = map_to;
							_tmp54_ = vala_symbol_get_name (_tmp53_);
							_tmp55_ = _tmp54_;
							_tmp56_ = vala_unresolved_symbol_new (NULL, _tmp55_, NULL);
							_tmp57_ = _tmp56_;
							vala_unresolved_symbol_set_inner (_tmp52_, _tmp57_);
							_vala_code_node_unref0 (_tmp57_);
							_tmp58_ = map_from;
							_tmp59_ = vala_unresolved_symbol_get_inner (_tmp58_);
							_tmp60_ = _tmp59_;
							_tmp61_ = _vala_code_node_ref0 (_tmp60_);
							_vala_code_node_unref0 (map_from);
							map_from = _tmp61_;
						}
					}
					_vala_code_node_unref0 (map_to);
					break;
				}
				_tmp62_ = map_from;
				_tmp63_ = vala_unresolved_symbol_get_inner (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = _vala_code_node_ref0 (_tmp64_);
				_vala_code_node_unref0 (map_from);
				map_from = _tmp65_;
				_vala_code_node_unref0 (map_to);
			}
			_vala_code_node_unref0 (map_from);
		}
	}
}

static void
vala_gir_parser_create_new_namespaces (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp0_;
		gint _node_size = 0;
		ValaArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _node_index = 0;
		_tmp0_ = vala_gir_parser_node_new_namespaces;
		_node_list = _tmp0_;
		_tmp1_ = _node_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_node_size = _tmp3_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaGirParserNode* node = NULL;
			ValaArrayList* _tmp6_;
			gpointer _tmp7_;
			ValaGirParserNode* _tmp8_;
			ValaSymbol* _tmp9_;
			_node_index = _node_index + 1;
			_tmp4_ = _node_index;
			_tmp5_ = _node_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _node_list;
			_tmp7_ = vala_list_get ((ValaList*) _tmp6_, _node_index);
			node = (ValaGirParserNode*) _tmp7_;
			_tmp8_ = node;
			_tmp9_ = _tmp8_->symbol;
			if (_tmp9_ == NULL) {
				ValaGirParserNode* _tmp10_;
				ValaGirParserNode* _tmp11_;
				const gchar* _tmp12_;
				ValaGirParserNode* _tmp13_;
				ValaSourceReference* _tmp14_;
				ValaNamespace* _tmp15_;
				_tmp10_ = node;
				_tmp11_ = node;
				_tmp12_ = _tmp11_->name;
				_tmp13_ = node;
				_tmp14_ = _tmp13_->source_reference;
				_tmp15_ = vala_namespace_new (_tmp12_, _tmp14_);
				_vala_code_node_unref0 (_tmp10_->symbol);
				_tmp10_->symbol = (ValaSymbol*) _tmp15_;
			}
			_vala_gir_parser_node_unref0 (node);
		}
	}
}

static void
vala_gir_parser_resolve_type_arguments (ValaGirParser* self)
{
	ValaMapIterator* it = NULL;
	ValaHashMap* _tmp0_;
	ValaMapIterator* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->unresolved_type_arguments;
	_tmp1_ = vala_map_map_iterator ((ValaMap*) _tmp0_);
	it = _tmp1_;
	while (TRUE) {
		ValaMapIterator* _tmp2_;
		ValaUnresolvedType* element_type = NULL;
		ValaMapIterator* _tmp3_;
		gpointer _tmp4_;
		ValaGirParserNode* parent = NULL;
		ValaMapIterator* _tmp5_;
		gpointer _tmp6_;
		ValaTypeSymbol* sym = NULL;
		ValaGirParserNode* _tmp7_;
		ValaUnresolvedType* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaStruct* st = NULL;
		ValaTypeSymbol* _tmp12_;
		ValaStruct* _tmp13_;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		ValaStruct* _tmp16_;
		_tmp2_ = it;
		if (!vala_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = it;
		_tmp4_ = vala_map_iterator_get_key (_tmp3_);
		element_type = (ValaUnresolvedType*) _tmp4_;
		_tmp5_ = it;
		_tmp6_ = vala_map_iterator_get_value (_tmp5_);
		parent = (ValaGirParserNode*) _tmp6_;
		_tmp7_ = parent;
		_tmp8_ = element_type;
		_tmp9_ = vala_unresolved_type_get_unresolved_symbol (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_gir_parser_resolve_symbol (self, _tmp7_, _tmp10_);
		sym = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		_tmp12_ = sym;
		_tmp13_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp12_) ? ((ValaStruct*) _tmp12_) : NULL);
		st = _tmp13_;
		_tmp16_ = st;
		if (_tmp16_ != NULL) {
			ValaStruct* _tmp17_;
			_tmp17_ = st;
			_tmp15_ = !vala_struct_is_integer_type (_tmp17_);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			ValaStruct* _tmp18_;
			_tmp18_ = st;
			_tmp14_ = !vala_struct_is_floating_type (_tmp18_);
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaUnresolvedType* _tmp19_;
			_tmp19_ = element_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp19_, TRUE);
		}
		_vala_code_node_unref0 (st);
		_vala_code_node_unref0 (sym);
		_vala_gir_parser_node_unref0 (parent);
		_vala_code_node_unref0 (element_type);
	}
	_vala_map_iterator_unref0 (it);
}

static void
vala_gir_parser_process_interface (ValaGirParser* self,
                                   ValaGirParserNode* iface_node)
{
	ValaInterface* iface = NULL;
	ValaSymbol* _tmp0_;
	ValaInterface* _tmp1_;
	gboolean has_instantiable_prereq = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface_node != NULL);
	_tmp0_ = iface_node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_INTERFACE, ValaInterface));
	iface = _tmp1_;
	has_instantiable_prereq = FALSE;
	{
		ValaList* _prereq_list = NULL;
		ValaInterface* _tmp2_;
		ValaList* _tmp3_;
		gint _prereq_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _prereq_index = 0;
		_tmp2_ = iface;
		_tmp3_ = vala_interface_get_prerequisites (_tmp2_);
		_prereq_list = _tmp3_;
		_tmp4_ = _prereq_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_prereq_size = _tmp6_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaSymbol* sym = NULL;
			ValaDataType* _tmp11_;
			ValaSymbol* _tmp23_;
			_prereq_index = _prereq_index + 1;
			_tmp7_ = _prereq_index;
			_tmp8_ = _prereq_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _prereq_list;
			_tmp10_ = vala_list_get (_tmp9_, _prereq_index);
			prereq = (ValaDataType*) _tmp10_;
			sym = NULL;
			_tmp11_ = prereq;
			if (VALA_IS_UNRESOLVED_TYPE (_tmp11_)) {
				ValaUnresolvedSymbol* unresolved_symbol = NULL;
				ValaDataType* _tmp12_;
				ValaUnresolvedSymbol* _tmp13_;
				ValaUnresolvedSymbol* _tmp14_;
				ValaUnresolvedSymbol* _tmp15_;
				ValaGirParserNode* _tmp16_;
				ValaUnresolvedSymbol* _tmp17_;
				ValaSymbol* _tmp18_;
				_tmp12_ = prereq;
				_tmp13_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
				_tmp14_ = _tmp13_;
				_tmp15_ = _vala_code_node_ref0 (_tmp14_);
				unresolved_symbol = _tmp15_;
				_tmp16_ = iface_node->parent;
				_tmp17_ = unresolved_symbol;
				_tmp18_ = vala_gir_parser_resolve_symbol (self, _tmp16_, _tmp17_);
				_vala_code_node_unref0 (sym);
				sym = _tmp18_;
				_vala_code_node_unref0 (unresolved_symbol);
			} else {
				ValaDataType* _tmp19_;
				ValaTypeSymbol* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				ValaSymbol* _tmp22_;
				_tmp19_ = prereq;
				_tmp20_ = vala_data_type_get_type_symbol (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp21_);
				_vala_code_node_unref0 (sym);
				sym = _tmp22_;
			}
			_tmp23_ = sym;
			if (VALA_IS_CLASS (_tmp23_)) {
				has_instantiable_prereq = TRUE;
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (prereq);
				break;
			}
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (prereq);
		}
	}
	if (!has_instantiable_prereq) {
		ValaArrayList* _tmp24_;
		ValaInterface* _tmp25_;
		_tmp24_ = self->priv->ifaces_needing_object_prereq;
		_tmp25_ = iface;
		vala_collection_add ((ValaCollection*) _tmp24_, _tmp25_);
	}
	_vala_code_node_unref0 (iface);
}

static void
vala_gir_parser_process_alias (ValaGirParser* self,
                               ValaGirParserNode* alias)
{
	ValaDataType* base_type = NULL;
	ValaSymbol* type_sym = NULL;
	ValaGirParserNode* base_node = NULL;
	gboolean simple_type = FALSE;
	ValaDataType* _tmp0_;
	gboolean _tmp32_ = FALSE;
	ValaSymbol* _tmp33_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	ValaDataType* _tmp37_;
	gboolean _tmp147_ = FALSE;
	ValaSymbol* _tmp148_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alias != NULL);
	base_type = NULL;
	type_sym = NULL;
	base_node = NULL;
	simple_type = FALSE;
	_tmp0_ = alias->base_type;
	if (VALA_IS_UNRESOLVED_TYPE (_tmp0_)) {
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		ValaGirParserNode* _tmp3_;
		ValaDataType* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		ValaGirParserNode* _tmp7_;
		ValaGirParserNode* _tmp8_;
		_tmp1_ = alias->base_type;
		_tmp2_ = _vala_code_node_ref0 (_tmp1_);
		_vala_code_node_unref0 (base_type);
		base_type = _tmp2_;
		_tmp3_ = alias->parent;
		_tmp4_ = base_type;
		_tmp5_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_gir_parser_resolve_node (self, _tmp3_, _tmp6_, FALSE);
		_vala_gir_parser_node_unref0 (base_node);
		base_node = _tmp7_;
		_tmp8_ = base_node;
		if (_tmp8_ != NULL) {
			ValaGirParserNode* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSymbol* _tmp11_;
			_tmp9_ = base_node;
			_tmp10_ = _tmp9_->symbol;
			_tmp11_ = _vala_code_node_ref0 (_tmp10_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp11_;
		}
	} else {
		gboolean _tmp12_ = FALSE;
		ValaDataType* _tmp13_;
		_tmp13_ = alias->base_type;
		if (VALA_IS_POINTER_TYPE (_tmp13_)) {
			ValaDataType* _tmp14_;
			ValaDataType* _tmp15_;
			ValaDataType* _tmp16_;
			_tmp14_ = alias->base_type;
			_tmp15_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
			_tmp16_ = _tmp15_;
			_tmp12_ = VALA_IS_VOID_TYPE (_tmp16_);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			simple_type = TRUE;
		} else {
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			ValaTypeSymbol* _tmp20_;
			ValaTypeSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaSymbol* _tmp23_;
			_tmp17_ = alias->base_type;
			_tmp18_ = _vala_code_node_ref0 (_tmp17_);
			_vala_code_node_unref0 (base_type);
			base_type = _tmp18_;
			_tmp19_ = base_type;
			_tmp20_ = vala_data_type_get_type_symbol (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp21_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp22_;
			_tmp23_ = type_sym;
			if (_tmp23_ != NULL) {
				ValaGirParserNode* _tmp24_;
				ValaSymbol* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				ValaSourceReference* _tmp28_;
				ValaUnresolvedSymbol* _tmp29_;
				ValaUnresolvedSymbol* _tmp30_;
				ValaGirParserNode* _tmp31_;
				_tmp24_ = alias->parent;
				_tmp25_ = type_sym;
				_tmp26_ = vala_symbol_get_full_name (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = alias->source_reference;
				_tmp29_ = vala_gir_parser_parse_symbol_from_string (self, _tmp27_, _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = vala_gir_parser_resolve_node (self, _tmp24_, _tmp30_, FALSE);
				_vala_gir_parser_node_unref0 (base_node);
				base_node = _tmp31_;
				_vala_code_node_unref0 (_tmp30_);
				_g_free0 (_tmp27_);
			}
		}
	}
	_tmp33_ = type_sym;
	if (VALA_IS_STRUCT (_tmp33_)) {
		ValaSymbol* _tmp34_;
		_tmp34_ = type_sym;
		_tmp32_ = vala_struct_is_simple_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALA_TYPE_STRUCT, ValaStruct));
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		simple_type = TRUE;
	}
	_tmp37_ = base_type;
	if (_tmp37_ == NULL) {
		_tmp36_ = TRUE;
	} else {
		ValaSymbol* _tmp38_;
		_tmp38_ = type_sym;
		_tmp36_ = _tmp38_ == NULL;
	}
	if (_tmp36_) {
		_tmp35_ = TRUE;
	} else {
		ValaSymbol* _tmp39_;
		_tmp39_ = type_sym;
		_tmp35_ = VALA_IS_STRUCT (_tmp39_);
	}
	if (_tmp35_) {
		ValaStruct* st = NULL;
		const gchar* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaStruct* _tmp42_;
		ValaStruct* _tmp43_;
		ValaDataType* _tmp44_;
		ValaStruct* _tmp47_;
		ValaGirComment* _tmp48_;
		ValaStruct* _tmp49_;
		ValaStruct* _tmp50_;
		ValaSymbol* _tmp51_;
		_tmp40_ = alias->name;
		_tmp41_ = alias->source_reference;
		_tmp42_ = vala_struct_new (_tmp40_, _tmp41_, NULL);
		st = _tmp42_;
		_tmp43_ = st;
		vala_symbol_set_access ((ValaSymbol*) _tmp43_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp44_ = base_type;
		if (_tmp44_ != NULL) {
			ValaStruct* _tmp45_;
			ValaDataType* _tmp46_;
			_tmp45_ = st;
			_tmp46_ = base_type;
			vala_struct_set_base_type (_tmp45_, _tmp46_);
		}
		_tmp47_ = st;
		_tmp48_ = alias->comment;
		vala_symbol_set_comment ((ValaSymbol*) _tmp47_, (ValaComment*) _tmp48_);
		_tmp49_ = st;
		vala_struct_set_simple_type (_tmp49_, simple_type);
		_tmp50_ = st;
		_tmp51_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp50_);
		_vala_code_node_unref0 (alias->symbol);
		alias->symbol = _tmp51_;
		_vala_code_node_unref0 (st);
	} else {
		ValaSymbol* _tmp52_;
		_tmp52_ = type_sym;
		if (VALA_IS_CLASS (_tmp52_)) {
			ValaClass* cl = NULL;
			const gchar* _tmp53_;
			ValaSourceReference* _tmp54_;
			ValaClass* _tmp55_;
			ValaClass* _tmp56_;
			ValaDataType* _tmp57_;
			ValaClass* _tmp60_;
			ValaGirComment* _tmp61_;
			ValaClass* _tmp62_;
			ValaSymbol* _tmp63_;
			gboolean _tmp64_;
			gboolean _tmp65_;
			ValaClass* _tmp66_;
			ValaSymbol* _tmp67_;
			_tmp53_ = alias->name;
			_tmp54_ = alias->source_reference;
			_tmp55_ = vala_class_new (_tmp53_, _tmp54_, NULL);
			cl = _tmp55_;
			_tmp56_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp56_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp57_ = base_type;
			if (_tmp57_ != NULL) {
				ValaClass* _tmp58_;
				ValaDataType* _tmp59_;
				_tmp58_ = cl;
				_tmp59_ = base_type;
				vala_class_add_base_type (_tmp58_, _tmp59_);
			}
			_tmp60_ = cl;
			_tmp61_ = alias->comment;
			vala_symbol_set_comment ((ValaSymbol*) _tmp60_, (ValaComment*) _tmp61_);
			_tmp62_ = cl;
			_tmp63_ = type_sym;
			_tmp64_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_CLASS, ValaClass));
			_tmp65_ = _tmp64_;
			vala_code_node_set_attribute ((ValaCodeNode*) _tmp62_, "Compact", _tmp65_, NULL);
			_tmp66_ = cl;
			_tmp67_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp66_);
			_vala_code_node_unref0 (alias->symbol);
			alias->symbol = _tmp67_;
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp68_;
			_tmp68_ = type_sym;
			if (VALA_IS_INTERFACE (_tmp68_)) {
				ValaInterface* iface = NULL;
				const gchar* _tmp69_;
				ValaSourceReference* _tmp70_;
				ValaInterface* _tmp71_;
				ValaInterface* _tmp72_;
				ValaDataType* _tmp73_;
				ValaInterface* _tmp76_;
				ValaGirComment* _tmp77_;
				ValaInterface* _tmp78_;
				ValaSymbol* _tmp79_;
				_tmp69_ = alias->name;
				_tmp70_ = alias->source_reference;
				_tmp71_ = vala_interface_new (_tmp69_, _tmp70_, NULL);
				iface = _tmp71_;
				_tmp72_ = iface;
				vala_symbol_set_access ((ValaSymbol*) _tmp72_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
				_tmp73_ = base_type;
				if (_tmp73_ != NULL) {
					ValaInterface* _tmp74_;
					ValaDataType* _tmp75_;
					_tmp74_ = iface;
					_tmp75_ = base_type;
					vala_interface_add_prerequisite (_tmp74_, _tmp75_);
				}
				_tmp76_ = iface;
				_tmp77_ = alias->comment;
				vala_symbol_set_comment ((ValaSymbol*) _tmp76_, (ValaComment*) _tmp77_);
				_tmp78_ = iface;
				_tmp79_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp78_);
				_vala_code_node_unref0 (alias->symbol);
				alias->symbol = _tmp79_;
				_vala_code_node_unref0 (iface);
			} else {
				ValaSymbol* _tmp80_;
				_tmp80_ = type_sym;
				if (VALA_IS_DELEGATE (_tmp80_)) {
					ValaDelegate* orig = NULL;
					ValaSymbol* _tmp81_;
					ValaDelegate* _tmp82_;
					ValaGirParserNode* _tmp83_;
					ValaDelegate* deleg = NULL;
					const gchar* _tmp88_;
					ValaDelegate* _tmp89_;
					ValaDataType* _tmp90_;
					ValaDataType* _tmp91_;
					ValaDataType* _tmp92_;
					ValaDataType* _tmp93_;
					ValaSourceReference* _tmp94_;
					ValaDelegate* _tmp95_;
					ValaDelegate* _tmp96_;
					ValaDelegate* _tmp97_;
					ValaDelegate* _tmp98_;
					ValaSymbolAccessibility _tmp99_;
					ValaSymbolAccessibility _tmp100_;
					ValaArrayList* error_types = NULL;
					GEqualFunc _tmp114_;
					ValaArrayList* _tmp115_;
					ValaDelegate* _tmp116_;
					ValaArrayList* _tmp117_;
					ValaSourceReference* _tmp118_;
					ValaDelegate* _tmp131_;
					GList* _tmp132_;
					ValaDelegate* _tmp136_;
					ValaSymbol* _tmp137_;
					_tmp81_ = type_sym;
					_tmp82_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, VALA_TYPE_DELEGATE, ValaDelegate));
					orig = _tmp82_;
					_tmp83_ = base_node;
					if (_tmp83_ != NULL) {
						ValaGirParserNode* _tmp84_;
						ValaGirParserNode* _tmp85_;
						ValaSymbol* _tmp86_;
						ValaDelegate* _tmp87_;
						_tmp84_ = base_node;
						vala_gir_parser_node_process (_tmp84_, self);
						_tmp85_ = base_node;
						_tmp86_ = _tmp85_->symbol;
						_tmp87_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_DELEGATE, ValaDelegate));
						_vala_code_node_unref0 (orig);
						orig = _tmp87_;
					}
					_tmp88_ = alias->name;
					_tmp89_ = orig;
					_tmp90_ = vala_callable_get_return_type ((ValaCallable*) _tmp89_);
					_tmp91_ = _tmp90_;
					_tmp92_ = vala_data_type_copy (_tmp91_);
					_tmp93_ = _tmp92_;
					_tmp94_ = alias->source_reference;
					_tmp95_ = vala_delegate_new (_tmp88_, _tmp93_, _tmp94_, NULL);
					_tmp96_ = _tmp95_;
					_vala_code_node_unref0 (_tmp93_);
					deleg = _tmp96_;
					_tmp97_ = deleg;
					_tmp98_ = orig;
					_tmp99_ = vala_symbol_get_access ((ValaSymbol*) _tmp98_);
					_tmp100_ = _tmp99_;
					vala_symbol_set_access ((ValaSymbol*) _tmp97_, _tmp100_);
					{
						ValaList* _param_list = NULL;
						ValaDelegate* _tmp101_;
						ValaList* _tmp102_;
						gint _param_size = 0;
						ValaList* _tmp103_;
						gint _tmp104_;
						gint _tmp105_;
						gint _param_index = 0;
						_tmp101_ = orig;
						_tmp102_ = vala_callable_get_parameters ((ValaCallable*) _tmp101_);
						_param_list = _tmp102_;
						_tmp103_ = _param_list;
						_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
						_tmp105_ = _tmp104_;
						_param_size = _tmp105_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp106_;
							gint _tmp107_;
							ValaParameter* param = NULL;
							ValaList* _tmp108_;
							gpointer _tmp109_;
							ValaDelegate* _tmp110_;
							ValaParameter* _tmp111_;
							ValaParameter* _tmp112_;
							ValaParameter* _tmp113_;
							_param_index = _param_index + 1;
							_tmp106_ = _param_index;
							_tmp107_ = _param_size;
							if (!(_tmp106_ < _tmp107_)) {
								break;
							}
							_tmp108_ = _param_list;
							_tmp109_ = vala_list_get (_tmp108_, _param_index);
							param = (ValaParameter*) _tmp109_;
							_tmp110_ = deleg;
							_tmp111_ = param;
							_tmp112_ = vala_parameter_copy (_tmp111_);
							_tmp113_ = _tmp112_;
							vala_callable_add_parameter ((ValaCallable*) _tmp110_, _tmp113_);
							_vala_code_node_unref0 (_tmp113_);
							_vala_code_node_unref0 (param);
						}
					}
					_tmp114_ = g_direct_equal;
					_tmp115_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp114_);
					error_types = _tmp115_;
					_tmp116_ = orig;
					_tmp117_ = error_types;
					_tmp118_ = alias->source_reference;
					vala_code_node_get_error_types ((ValaCodeNode*) _tmp116_, (ValaCollection*) _tmp117_, _tmp118_);
					{
						ValaArrayList* _error_type_list = NULL;
						ValaArrayList* _tmp119_;
						gint _error_type_size = 0;
						ValaArrayList* _tmp120_;
						gint _tmp121_;
						gint _tmp122_;
						gint _error_type_index = 0;
						_tmp119_ = error_types;
						_error_type_list = _tmp119_;
						_tmp120_ = _error_type_list;
						_tmp121_ = vala_collection_get_size ((ValaCollection*) _tmp120_);
						_tmp122_ = _tmp121_;
						_error_type_size = _tmp122_;
						_error_type_index = -1;
						while (TRUE) {
							gint _tmp123_;
							gint _tmp124_;
							ValaDataType* error_type = NULL;
							ValaArrayList* _tmp125_;
							gpointer _tmp126_;
							ValaDelegate* _tmp127_;
							ValaDataType* _tmp128_;
							ValaDataType* _tmp129_;
							ValaDataType* _tmp130_;
							_error_type_index = _error_type_index + 1;
							_tmp123_ = _error_type_index;
							_tmp124_ = _error_type_size;
							if (!(_tmp123_ < _tmp124_)) {
								break;
							}
							_tmp125_ = _error_type_list;
							_tmp126_ = vala_list_get ((ValaList*) _tmp125_, _error_type_index);
							error_type = (ValaDataType*) _tmp126_;
							_tmp127_ = deleg;
							_tmp128_ = error_type;
							_tmp129_ = vala_data_type_copy (_tmp128_);
							_tmp130_ = _tmp129_;
							vala_delegate_add_error_type (_tmp127_, _tmp130_);
							_vala_code_node_unref0 (_tmp130_);
							_vala_code_node_unref0 (error_type);
						}
					}
					_tmp131_ = orig;
					_tmp132_ = ((ValaCodeNode*) _tmp131_)->attributes;
					{
						GList* attribute_collection = NULL;
						GList* attribute_it = NULL;
						attribute_collection = _tmp132_;
						for (attribute_it = attribute_collection; attribute_it != NULL; attribute_it = attribute_it->next) {
							ValaAttribute* _tmp133_;
							ValaAttribute* attribute = NULL;
							_tmp133_ = _vala_code_node_ref0 ((ValaAttribute*) attribute_it->data);
							attribute = _tmp133_;
							{
								ValaDelegate* _tmp134_;
								ValaAttribute* _tmp135_;
								_tmp134_ = deleg;
								_tmp135_ = attribute;
								vala_code_node_add_attribute ((ValaCodeNode*) _tmp134_, _tmp135_);
								_vala_code_node_unref0 (attribute);
							}
						}
					}
					_tmp136_ = deleg;
					_tmp137_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp136_);
					_vala_code_node_unref0 (alias->symbol);
					alias->symbol = _tmp137_;
					_vala_iterable_unref0 (error_types);
					_vala_code_node_unref0 (deleg);
					_vala_code_node_unref0 (orig);
				} else {
					ValaSymbol* _tmp138_;
					_tmp138_ = type_sym;
					if (_tmp138_ != NULL) {
						ValaSourceReference* _tmp139_;
						gchar* _tmp140_;
						gchar* _tmp141_;
						ValaSymbol* _tmp142_;
						gchar* _tmp143_;
						gchar* _tmp144_;
						ValaSymbol* _tmp145_;
						ValaSymbol* _tmp146_;
						_tmp139_ = alias->source_reference;
						_tmp140_ = vala_gir_parser_node_get_full_name (alias);
						_tmp141_ = _tmp140_;
						_tmp142_ = type_sym;
						_tmp143_ = vala_symbol_get_full_name (_tmp142_);
						_tmp144_ = _tmp143_;
						vala_report_warning (_tmp139_, "alias `%s' for `%s' is not supported", _tmp141_, _tmp144_);
						_g_free0 (_tmp144_);
						_g_free0 (_tmp141_);
						_tmp145_ = type_sym;
						_tmp146_ = _vala_code_node_ref0 (_tmp145_);
						_vala_code_node_unref0 (alias->symbol);
						alias->symbol = _tmp146_;
						alias->merged = TRUE;
					}
				}
			}
		}
	}
	_tmp148_ = type_sym;
	if (VALA_IS_CLASS (_tmp148_)) {
		_tmp147_ = TRUE;
	} else {
		gboolean _tmp149_ = FALSE;
		ValaSymbol* _tmp150_;
		_tmp150_ = type_sym;
		if (VALA_IS_STRUCT (_tmp150_)) {
			_tmp149_ = !simple_type;
		} else {
			_tmp149_ = FALSE;
		}
		_tmp147_ = _tmp149_;
	}
	if (_tmp147_) {
		ValaSymbol* _tmp151_;
		_tmp151_ = type_sym;
		if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp151_, "CCode", "has_type_id")) {
			ValaSymbol* _tmp152_;
			ValaSymbol* _tmp153_;
			_tmp152_ = alias->symbol;
			_tmp153_ = type_sym;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp152_, "CCode", "has_type_id", vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp153_, "CCode", "has_type_id", FALSE), NULL);
		} else {
			ValaSymbol* _tmp154_;
			_tmp154_ = type_sym;
			if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp154_, "CCode", "type_id")) {
				ValaSymbol* _tmp155_;
				ValaSymbol* _tmp156_;
				gchar* _tmp157_;
				gchar* _tmp158_;
				_tmp155_ = alias->symbol;
				_tmp156_ = type_sym;
				_tmp157_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp156_, "CCode", "type_id", NULL);
				_tmp158_ = _tmp157_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp155_, "CCode", "type_id", _tmp158_, NULL);
				_g_free0 (_tmp158_);
			}
		}
	}
	_vala_gir_parser_node_unref0 (base_node);
	_vala_code_node_unref0 (type_sym);
	_vala_code_node_unref0 (base_type);
}

static void
vala_gir_parser_process_callable (ValaGirParser* self,
                                  ValaGirParserNode* node)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	ValaSymbol* s = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* parameters = NULL;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValaDataType* return_type = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp12_ = FALSE;
	ValaDataType* _tmp13_;
	gboolean first_param = FALSE;
	ValaList* _tmp289_;
	gint _tmp290_;
	gint _tmp291_;
	gint i = 0;
	gint j = 0;
	gint first_out = 0;
	gint last = 0;
	gboolean _tmp496_ = FALSE;
	ValaDataType* _tmp497_;
	ValaSymbol* _tmp502_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp1_ = node->element_type;
	if (g_strcmp0 (_tmp1_, "alias") == 0) {
		ValaSymbol* _tmp2_;
		_tmp2_ = node->symbol;
		_tmp0_ = VALA_IS_DELEGATE (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = node->symbol;
	_tmp4_ = _vala_code_node_ref0 (_tmp3_);
	s = _tmp4_;
	_tmp5_ = node->parameters;
	_tmp6_ = _vala_iterable_ref0 (_tmp5_);
	parameters = _tmp6_;
	return_type = NULL;
	_tmp7_ = s;
	if (VALA_IS_CALLABLE (_tmp7_)) {
		ValaSymbol* _tmp8_;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp8_ = s;
		_tmp9_ = vala_callable_get_return_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_CALLABLE, ValaCallable));
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		_vala_code_node_unref0 (return_type);
		return_type = _tmp11_;
	}
	_tmp13_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp13_)) {
		_tmp12_ = node->return_array_length_idx >= 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp14_ = parameters;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		if (node->return_array_length_idx >= _tmp16_) {
			ValaDataType* _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaSourceReference* _tmp19_;
			_tmp17_ = return_type;
			_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp17_);
			_tmp19_ = _tmp18_;
			vala_report_error (_tmp19_, "invalid array length index");
		} else {
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaGirParserParameterInfo* _tmp22_;
			ValaArrayList* _tmp23_;
			_tmp20_ = parameters;
			_tmp21_ = vala_list_get (_tmp20_, node->return_array_length_idx);
			_tmp22_ = (ValaGirParserParameterInfo*) _tmp21_;
			_tmp22_->keep = FALSE;
			_vala_gir_parser_parameter_info_unref0 (_tmp22_);
			_tmp23_ = node->array_length_parameters;
			vala_collection_add ((ValaCollection*) _tmp23_, (gpointer) ((gintptr) node->return_array_length_idx));
		}
	} else {
		gboolean _tmp24_ = FALSE;
		ValaDataType* _tmp25_;
		_tmp25_ = return_type;
		if (VALA_IS_VOID_TYPE (_tmp25_)) {
			ValaList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			_tmp26_ = parameters;
			_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp24_ = _tmp28_ > 0;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			gint n_out_parameters = 0;
			n_out_parameters = 0;
			{
				ValaList* _info_list = NULL;
				ValaList* _tmp29_;
				gint _info_size = 0;
				ValaList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _info_index = 0;
				_tmp29_ = parameters;
				_info_list = _tmp29_;
				_tmp30_ = _info_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_info_size = _tmp32_;
				_info_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaGirParserParameterInfo* info = NULL;
					ValaList* _tmp35_;
					gpointer _tmp36_;
					ValaGirParserParameterInfo* _tmp37_;
					ValaParameter* _tmp38_;
					ValaParameterDirection _tmp39_;
					ValaParameterDirection _tmp40_;
					_info_index = _info_index + 1;
					_tmp33_ = _info_index;
					_tmp34_ = _info_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _info_list;
					_tmp36_ = vala_list_get (_tmp35_, _info_index);
					info = (ValaGirParserParameterInfo*) _tmp36_;
					_tmp37_ = info;
					_tmp38_ = _tmp37_->param;
					_tmp39_ = vala_parameter_get_direction (_tmp38_);
					_tmp40_ = _tmp39_;
					if (_tmp40_ == VALA_PARAMETER_DIRECTION_OUT) {
						gint _tmp41_;
						_tmp41_ = n_out_parameters;
						n_out_parameters = _tmp41_ + 1;
					}
					_vala_gir_parser_parameter_info_unref0 (info);
				}
			}
			if (n_out_parameters == 1) {
				ValaGirParserParameterInfo* last_param = NULL;
				ValaList* _tmp42_;
				ValaList* _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				gpointer _tmp46_;
				ValaGirParserParameterInfo* _tmp47_;
				ValaParameter* _tmp48_;
				ValaParameterDirection _tmp49_;
				ValaParameterDirection _tmp50_;
				_tmp42_ = parameters;
				_tmp43_ = parameters;
				_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = vala_list_get (_tmp42_, _tmp45_ - 1);
				last_param = (ValaGirParserParameterInfo*) _tmp46_;
				_tmp47_ = last_param;
				_tmp48_ = _tmp47_->param;
				_tmp49_ = vala_parameter_get_direction (_tmp48_);
				_tmp50_ = _tmp49_;
				if (_tmp50_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaGirParserParameterInfo* _tmp51_;
					ValaParameter* _tmp52_;
					ValaDataType* _tmp53_;
					ValaDataType* _tmp54_;
					_tmp51_ = last_param;
					_tmp52_ = _tmp51_->param;
					_tmp53_ = vala_variable_get_variable_type ((ValaVariable*) _tmp52_);
					_tmp54_ = _tmp53_;
					if (VALA_IS_UNRESOLVED_TYPE (_tmp54_)) {
						ValaStruct* st = NULL;
						ValaGirParserNode* _tmp55_;
						ValaGirParserParameterInfo* _tmp56_;
						ValaParameter* _tmp57_;
						ValaDataType* _tmp58_;
						ValaDataType* _tmp59_;
						ValaUnresolvedSymbol* _tmp60_;
						ValaUnresolvedSymbol* _tmp61_;
						ValaSymbol* _tmp62_;
						ValaStruct* _tmp63_;
						gboolean _tmp64_ = FALSE;
						gboolean _tmp65_ = FALSE;
						ValaStruct* _tmp66_;
						_tmp55_ = node->parent;
						_tmp56_ = last_param;
						_tmp57_ = _tmp56_->param;
						_tmp58_ = vala_variable_get_variable_type ((ValaVariable*) _tmp57_);
						_tmp59_ = _tmp58_;
						_tmp60_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
						_tmp61_ = _tmp60_;
						_tmp62_ = vala_gir_parser_resolve_symbol (self, _tmp55_, _tmp61_);
						_tmp63_ = VALA_IS_STRUCT (_tmp62_) ? ((ValaStruct*) _tmp62_) : NULL;
						if (_tmp63_ == NULL) {
							_vala_code_node_unref0 (_tmp62_);
						}
						st = _tmp63_;
						_tmp66_ = st;
						if (_tmp66_ != NULL) {
							ValaStruct* _tmp67_;
							_tmp67_ = st;
							_tmp65_ = !vala_struct_is_simple_type (_tmp67_);
						} else {
							_tmp65_ = FALSE;
						}
						if (_tmp65_) {
							ValaGirParserParameterInfo* _tmp68_;
							ValaParameter* _tmp69_;
							ValaDataType* _tmp70_;
							ValaDataType* _tmp71_;
							gboolean _tmp72_;
							gboolean _tmp73_;
							_tmp68_ = last_param;
							_tmp69_ = _tmp68_->param;
							_tmp70_ = vala_variable_get_variable_type ((ValaVariable*) _tmp69_);
							_tmp71_ = _tmp70_;
							_tmp72_ = vala_data_type_get_nullable (_tmp71_);
							_tmp73_ = _tmp72_;
							_tmp64_ = !_tmp73_;
						} else {
							_tmp64_ = FALSE;
						}
						if (_tmp64_) {
							ValaGirParserMetadata* _tmp74_;
							_tmp74_ = node->metadata;
							if (!vala_gir_parser_metadata_get_bool (_tmp74_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID, FALSE)) {
								ValaGirParserParameterInfo* _tmp75_;
								ValaGirParserParameterInfo* _tmp76_;
								ValaParameter* _tmp77_;
								ValaDataType* _tmp78_;
								ValaDataType* _tmp79_;
								ValaDataType* _tmp80_;
								_tmp75_ = last_param;
								_tmp75_->keep = FALSE;
								_tmp76_ = last_param;
								_tmp77_ = _tmp76_->param;
								_tmp78_ = vala_variable_get_variable_type ((ValaVariable*) _tmp77_);
								_tmp79_ = _tmp78_;
								_tmp80_ = vala_data_type_copy (_tmp79_);
								_vala_code_node_unref0 (return_type);
								return_type = _tmp80_;
							}
						}
						_vala_code_node_unref0 (st);
					}
				}
				_vala_gir_parser_parameter_info_unref0 (last_param);
			}
		} else {
			gboolean _tmp81_ = FALSE;
			ValaDataType* _tmp82_;
			_tmp82_ = return_type;
			if (VALA_IS_UNRESOLVED_TYPE (_tmp82_)) {
				ValaDataType* _tmp83_;
				gboolean _tmp84_;
				gboolean _tmp85_;
				_tmp83_ = return_type;
				_tmp84_ = vala_data_type_get_nullable (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp81_ = !_tmp85_;
			} else {
				_tmp81_ = FALSE;
			}
			if (_tmp81_) {
				ValaStruct* st = NULL;
				ValaGirParserNode* _tmp86_;
				ValaDataType* _tmp87_;
				ValaUnresolvedSymbol* _tmp88_;
				ValaUnresolvedSymbol* _tmp89_;
				ValaSymbol* _tmp90_;
				ValaStruct* _tmp91_;
				ValaStruct* _tmp92_;
				_tmp86_ = node->parent;
				_tmp87_ = return_type;
				_tmp88_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
				_tmp89_ = _tmp88_;
				_tmp90_ = vala_gir_parser_resolve_symbol (self, _tmp86_, _tmp89_);
				_tmp91_ = VALA_IS_STRUCT (_tmp90_) ? ((ValaStruct*) _tmp90_) : NULL;
				if (_tmp91_ == NULL) {
					_vala_code_node_unref0 (_tmp90_);
				}
				st = _tmp91_;
				_tmp92_ = st;
				if (_tmp92_ != NULL) {
					gboolean is_simple_type = FALSE;
					ValaStruct* base_st = NULL;
					ValaStruct* _tmp93_;
					ValaStruct* _tmp94_;
					is_simple_type = FALSE;
					_tmp93_ = st;
					_tmp94_ = _vala_code_node_ref0 (_tmp93_);
					base_st = _tmp94_;
					while (TRUE) {
						ValaStruct* _tmp95_;
						ValaStruct* _tmp96_;
						ValaStruct* _tmp97_;
						ValaDataType* _tmp98_;
						ValaDataType* _tmp99_;
						_tmp95_ = base_st;
						if (!(_tmp95_ != NULL)) {
							break;
						}
						_tmp96_ = base_st;
						if (vala_struct_is_simple_type (_tmp96_)) {
							is_simple_type = TRUE;
							break;
						}
						_tmp97_ = base_st;
						_tmp98_ = vala_struct_get_base_type (_tmp97_);
						_tmp99_ = _tmp98_;
						if (VALA_IS_UNRESOLVED_TYPE (_tmp99_)) {
							ValaGirParserNode* _tmp100_;
							ValaStruct* _tmp101_;
							ValaDataType* _tmp102_;
							ValaDataType* _tmp103_;
							ValaUnresolvedSymbol* _tmp104_;
							ValaUnresolvedSymbol* _tmp105_;
							ValaSymbol* _tmp106_;
							ValaStruct* _tmp107_;
							_tmp100_ = node->parent;
							_tmp101_ = base_st;
							_tmp102_ = vala_struct_get_base_type (_tmp101_);
							_tmp103_ = _tmp102_;
							_tmp104_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
							_tmp105_ = _tmp104_;
							_tmp106_ = vala_gir_parser_resolve_symbol (self, _tmp100_, _tmp105_);
							_tmp107_ = VALA_IS_STRUCT (_tmp106_) ? ((ValaStruct*) _tmp106_) : NULL;
							if (_tmp107_ == NULL) {
								_vala_code_node_unref0 (_tmp106_);
							}
							_vala_code_node_unref0 (base_st);
							base_st = _tmp107_;
						} else {
							ValaStruct* _tmp108_;
							ValaStruct* _tmp109_;
							ValaStruct* _tmp110_;
							ValaStruct* _tmp111_;
							_tmp108_ = base_st;
							_tmp109_ = vala_struct_get_base_struct (_tmp108_);
							_tmp110_ = _tmp109_;
							_tmp111_ = _vala_code_node_ref0 (_tmp110_);
							_vala_code_node_unref0 (base_st);
							base_st = _tmp111_;
						}
					}
					if (!is_simple_type) {
						ValaDataType* _tmp112_;
						_tmp112_ = return_type;
						vala_data_type_set_nullable (_tmp112_, TRUE);
					}
					_vala_code_node_unref0 (base_st);
				}
				_vala_code_node_unref0 (st);
			}
		}
	}
	first_param = TRUE;
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp113_;
		gint _info_size = 0;
		ValaList* _tmp114_;
		gint _tmp115_;
		gint _tmp116_;
		gint _info_index = 0;
		_tmp113_ = parameters;
		_info_list = _tmp113_;
		_tmp114_ = _info_list;
		_tmp115_ = vala_collection_get_size ((ValaCollection*) _tmp114_);
		_tmp116_ = _tmp115_;
		_info_size = _tmp116_;
		_info_index = -1;
		while (TRUE) {
			gint _tmp117_;
			gint _tmp118_;
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp119_;
			gpointer _tmp120_;
			ValaDataType* type = NULL;
			ValaGirParserParameterInfo* _tmp121_;
			ValaParameter* _tmp122_;
			ValaDataType* _tmp123_;
			ValaDataType* _tmp124_;
			gboolean _tmp125_ = FALSE;
			ValaGirParserParameterInfo* _tmp126_;
			ValaParameter* _tmp127_;
			ValaParameterDirection _tmp128_;
			ValaParameterDirection _tmp129_;
			ValaSymbol* _tmp149_;
			gboolean _tmp187_ = FALSE;
			gboolean _tmp188_ = FALSE;
			ValaGirParserParameterInfo* _tmp189_;
			ValaParameter* _tmp190_;
			ValaParameterDirection _tmp191_;
			ValaParameterDirection _tmp192_;
			gboolean _tmp210_ = FALSE;
			gboolean _tmp211_ = FALSE;
			gboolean _tmp212_ = FALSE;
			gboolean _tmp213_ = FALSE;
			_info_index = _info_index + 1;
			_tmp117_ = _info_index;
			_tmp118_ = _info_size;
			if (!(_tmp117_ < _tmp118_)) {
				break;
			}
			_tmp119_ = _info_list;
			_tmp120_ = vala_list_get (_tmp119_, _info_index);
			info = (ValaGirParserParameterInfo*) _tmp120_;
			_tmp121_ = info;
			_tmp122_ = _tmp121_->param;
			_tmp123_ = vala_variable_get_variable_type ((ValaVariable*) _tmp122_);
			_tmp124_ = _tmp123_;
			type = _tmp124_;
			_tmp126_ = info;
			_tmp127_ = _tmp126_->param;
			_tmp128_ = vala_parameter_get_direction (_tmp127_);
			_tmp129_ = _tmp128_;
			if (_tmp129_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaDataType* _tmp130_;
				gboolean _tmp131_;
				gboolean _tmp132_;
				_tmp130_ = type;
				_tmp131_ = vala_data_type_get_nullable (_tmp130_);
				_tmp132_ = _tmp131_;
				_tmp125_ = _tmp132_;
			} else {
				_tmp125_ = FALSE;
			}
			if (_tmp125_) {
				ValaStruct* st = NULL;
				ValaDataType* _tmp133_;
				gboolean _tmp145_ = FALSE;
				ValaStruct* _tmp146_;
				st = NULL;
				_tmp133_ = type;
				if (VALA_IS_UNRESOLVED_TYPE (_tmp133_)) {
					ValaGirParserNode* _tmp134_;
					ValaDataType* _tmp135_;
					ValaUnresolvedSymbol* _tmp136_;
					ValaUnresolvedSymbol* _tmp137_;
					ValaSymbol* _tmp138_;
					ValaStruct* _tmp139_;
					_tmp134_ = node->parent;
					_tmp135_ = type;
					_tmp136_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp135_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
					_tmp137_ = _tmp136_;
					_tmp138_ = vala_gir_parser_resolve_symbol (self, _tmp134_, _tmp137_);
					_tmp139_ = VALA_IS_STRUCT (_tmp138_) ? ((ValaStruct*) _tmp138_) : NULL;
					if (_tmp139_ == NULL) {
						_vala_code_node_unref0 (_tmp138_);
					}
					_vala_code_node_unref0 (st);
					st = _tmp139_;
				} else {
					ValaDataType* _tmp140_;
					_tmp140_ = type;
					if (VALA_IS_VALUE_TYPE (_tmp140_)) {
						ValaDataType* _tmp141_;
						ValaTypeSymbol* _tmp142_;
						ValaTypeSymbol* _tmp143_;
						ValaStruct* _tmp144_;
						_tmp141_ = type;
						_tmp142_ = vala_data_type_get_type_symbol (_tmp141_);
						_tmp143_ = _tmp142_;
						_tmp144_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp143_) ? ((ValaStruct*) _tmp143_) : NULL);
						_vala_code_node_unref0 (st);
						st = _tmp144_;
					}
				}
				_tmp146_ = st;
				if (_tmp146_ != NULL) {
					ValaStruct* _tmp147_;
					_tmp147_ = st;
					_tmp145_ = vala_struct_is_simple_type (_tmp147_);
				} else {
					_tmp145_ = FALSE;
				}
				if (_tmp145_) {
					ValaDataType* _tmp148_;
					_tmp148_ = type;
					vala_data_type_set_nullable (_tmp148_, FALSE);
				}
				_vala_code_node_unref0 (st);
			}
			_tmp149_ = s;
			if (VALA_IS_METHOD (_tmp149_)) {
				gchar* type_name = NULL;
				ValaUnresolvedType* unresolved_type = NULL;
				ValaDataType* _tmp150_;
				ValaUnresolvedType* _tmp151_;
				ValaGirParserParameterInfo* _tmp161_;
				gboolean _tmp175_ = FALSE;
				gboolean _tmp176_ = FALSE;
				gboolean _tmp177_ = FALSE;
				gboolean _tmp178_ = FALSE;
				gboolean _tmp179_ = FALSE;
				ValaUnresolvedType* _tmp180_;
				type_name = NULL;
				_tmp150_ = type;
				unresolved_type = VALA_IS_UNRESOLVED_TYPE (_tmp150_) ? ((ValaUnresolvedType*) _tmp150_) : NULL;
				_tmp151_ = unresolved_type;
				if (_tmp151_ != NULL) {
					ValaUnresolvedType* _tmp152_;
					ValaUnresolvedSymbol* _tmp153_;
					ValaUnresolvedSymbol* _tmp154_;
					const gchar* _tmp155_;
					const gchar* _tmp156_;
					gchar* _tmp157_;
					_tmp152_ = unresolved_type;
					_tmp153_ = vala_unresolved_type_get_unresolved_symbol (_tmp152_);
					_tmp154_ = _tmp153_;
					_tmp155_ = vala_symbol_get_name ((ValaSymbol*) _tmp154_);
					_tmp156_ = _tmp155_;
					_tmp157_ = g_strdup (_tmp156_);
					_g_free0 (type_name);
					type_name = _tmp157_;
				} else {
					ValaDataType* _tmp158_;
					_tmp158_ = type;
					if (_tmp158_ != NULL) {
						ValaDataType* _tmp159_;
						gchar* _tmp160_;
						_tmp159_ = type;
						_tmp160_ = vala_code_node_to_string ((ValaCodeNode*) _tmp159_);
						_g_free0 (type_name);
						type_name = _tmp160_;
					}
				}
				_tmp161_ = info;
				if (_tmp161_->is_async) {
					gboolean _tmp162_ = FALSE;
					gboolean _tmp163_ = FALSE;
					gboolean _tmp164_ = FALSE;
					gboolean _tmp165_ = FALSE;
					gboolean _tmp166_ = FALSE;
					ValaUnresolvedType* _tmp167_;
					_tmp167_ = unresolved_type;
					if (_tmp167_ != NULL) {
						const gchar* _tmp168_;
						_tmp168_ = type_name;
						_tmp166_ = g_strcmp0 (_tmp168_, "AsyncReadyCallback") == 0;
					} else {
						_tmp166_ = FALSE;
					}
					if (_tmp166_) {
						_tmp165_ = TRUE;
					} else {
						const gchar* _tmp169_;
						_tmp169_ = type_name;
						_tmp165_ = g_strcmp0 (_tmp169_, "GLib.AsyncReadyCallback") == 0;
					}
					if (_tmp165_) {
						_tmp164_ = TRUE;
					} else {
						const gchar* _tmp170_;
						_tmp170_ = type_name;
						_tmp164_ = g_strcmp0 (_tmp170_, "Gio.AsyncReadyCallback") == 0;
					}
					if (_tmp164_) {
						_tmp163_ = TRUE;
					} else {
						const gchar* _tmp171_;
						_tmp171_ = type_name;
						_tmp163_ = g_strcmp0 (_tmp171_, "GLib.AsyncReadyCallback?") == 0;
					}
					if (_tmp163_) {
						_tmp162_ = TRUE;
					} else {
						const gchar* _tmp172_;
						_tmp172_ = type_name;
						_tmp162_ = g_strcmp0 (_tmp172_, "Gio.AsyncReadyCallback?") == 0;
					}
					if (_tmp162_) {
						ValaSymbol* _tmp173_;
						ValaGirParserParameterInfo* _tmp174_;
						_tmp173_ = s;
						vala_method_set_coroutine (G_TYPE_CHECK_INSTANCE_CAST (_tmp173_, VALA_TYPE_METHOD, ValaMethod), TRUE);
						_tmp174_ = info;
						_tmp174_->keep = FALSE;
					}
				}
				_tmp180_ = unresolved_type;
				if (_tmp180_ != NULL) {
					const gchar* _tmp181_;
					_tmp181_ = type_name;
					_tmp179_ = g_strcmp0 (_tmp181_, "AsyncResult") == 0;
				} else {
					_tmp179_ = FALSE;
				}
				if (_tmp179_) {
					_tmp178_ = TRUE;
				} else {
					const gchar* _tmp182_;
					_tmp182_ = type_name;
					_tmp178_ = g_strcmp0 (_tmp182_, "GLib.AsyncResult") == 0;
				}
				if (_tmp178_) {
					_tmp177_ = TRUE;
				} else {
					const gchar* _tmp183_;
					_tmp183_ = type_name;
					_tmp177_ = g_strcmp0 (_tmp183_, "Gio.AsyncResult") == 0;
				}
				if (_tmp177_) {
					_tmp176_ = TRUE;
				} else {
					const gchar* _tmp184_;
					_tmp184_ = type_name;
					_tmp176_ = g_strcmp0 (_tmp184_, "GLib.AsyncResult?") == 0;
				}
				if (_tmp176_) {
					_tmp175_ = TRUE;
				} else {
					const gchar* _tmp185_;
					_tmp185_ = type_name;
					_tmp175_ = g_strcmp0 (_tmp185_, "Gio.AsyncResult?") == 0;
				}
				if (_tmp175_) {
					ValaGirParserParameterInfo* _tmp186_;
					_tmp186_ = info;
					_tmp186_->is_async_result = TRUE;
				}
				_g_free0 (type_name);
			}
			_tmp189_ = info;
			_tmp190_ = _tmp189_->param;
			_tmp191_ = vala_parameter_get_direction (_tmp190_);
			_tmp192_ = _tmp191_;
			if (_tmp192_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaSymbol* _tmp193_;
				_tmp193_ = s;
				_tmp188_ = VALA_IS_DELEGATE (_tmp193_);
			} else {
				_tmp188_ = FALSE;
			}
			if (_tmp188_) {
				ValaSymbol* _tmp194_;
				gboolean _tmp195_;
				gboolean _tmp196_;
				_tmp194_ = s;
				_tmp195_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp194_);
				_tmp196_ = _tmp195_;
				_tmp187_ = !_tmp196_;
			} else {
				_tmp187_ = FALSE;
			}
			if (_tmp187_) {
				ValaUnresolvedType* unresolved_type = NULL;
				ValaDataType* _tmp197_;
				gboolean _tmp198_ = FALSE;
				ValaUnresolvedType* _tmp199_;
				_tmp197_ = type;
				unresolved_type = VALA_IS_UNRESOLVED_TYPE (_tmp197_) ? ((ValaUnresolvedType*) _tmp197_) : NULL;
				_tmp199_ = unresolved_type;
				if (_tmp199_ != NULL) {
					ValaUnresolvedType* _tmp200_;
					ValaUnresolvedSymbol* _tmp201_;
					ValaUnresolvedSymbol* _tmp202_;
					gchar* _tmp203_;
					gchar* _tmp204_;
					_tmp200_ = unresolved_type;
					_tmp201_ = vala_unresolved_type_get_unresolved_symbol (_tmp200_);
					_tmp202_ = _tmp201_;
					_tmp203_ = vala_code_node_to_string ((ValaCodeNode*) _tmp202_);
					_tmp204_ = _tmp203_;
					_tmp198_ = g_strcmp0 (_tmp204_, "GLib.Error") == 0;
					_g_free0 (_tmp204_);
				} else {
					_tmp198_ = FALSE;
				}
				if (_tmp198_) {
					ValaSymbol* _tmp205_;
					ValaErrorType* _tmp206_;
					ValaErrorType* _tmp207_;
					ValaGirParserParameterInfo* _tmp208_;
					ValaGirParserParameterInfo* _tmp209_;
					_tmp205_ = s;
					_tmp206_ = vala_error_type_new (NULL, NULL, NULL);
					_tmp207_ = _tmp206_;
					vala_delegate_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp205_, VALA_TYPE_DELEGATE, ValaDelegate), (ValaDataType*) _tmp207_);
					_vala_code_node_unref0 (_tmp207_);
					_tmp208_ = info;
					_tmp208_->is_error = TRUE;
					_tmp209_ = info;
					_tmp209_->keep = FALSE;
				}
			}
			if (first_param) {
				ValaGirParserParameterInfo* _tmp214_;
				_tmp214_ = info;
				_tmp213_ = _tmp214_->keep;
			} else {
				_tmp213_ = FALSE;
			}
			if (_tmp213_) {
				ValaDataType* _tmp215_;
				_tmp215_ = type;
				_tmp212_ = _tmp215_ != NULL;
			} else {
				_tmp212_ = FALSE;
			}
			if (_tmp212_) {
				ValaSymbol* _tmp216_;
				_tmp216_ = s;
				_tmp211_ = VALA_IS_METHOD (_tmp216_);
			} else {
				_tmp211_ = FALSE;
			}
			if (_tmp211_) {
				ValaSymbol* _tmp217_;
				ValaMemberBinding _tmp218_;
				ValaMemberBinding _tmp219_;
				_tmp217_ = s;
				_tmp218_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp217_, VALA_TYPE_METHOD, ValaMethod));
				_tmp219_ = _tmp218_;
				_tmp210_ = _tmp219_ == VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp210_ = FALSE;
			}
			if (_tmp210_) {
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp220_;
				gboolean _tmp230_ = FALSE;
				gboolean _tmp231_ = FALSE;
				ValaSymbol* _tmp232_;
				ValaGirParserNode* _tmp233_;
				ValaSymbol* _tmp234_;
				_tmp220_ = type;
				if (VALA_IS_UNRESOLVED_TYPE (_tmp220_)) {
					ValaGirParserNode* _tmp221_;
					ValaDataType* _tmp222_;
					ValaUnresolvedSymbol* _tmp223_;
					ValaUnresolvedSymbol* _tmp224_;
					ValaSymbol* _tmp225_;
					_tmp221_ = node->parent;
					_tmp222_ = type;
					_tmp223_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
					_tmp224_ = _tmp223_;
					_tmp225_ = vala_gir_parser_resolve_symbol (self, _tmp221_, _tmp224_);
					_vala_code_node_unref0 (sym);
					sym = _tmp225_;
				} else {
					ValaDataType* _tmp226_;
					ValaTypeSymbol* _tmp227_;
					ValaTypeSymbol* _tmp228_;
					ValaSymbol* _tmp229_;
					_tmp226_ = type;
					_tmp227_ = vala_data_type_get_type_symbol (_tmp226_);
					_tmp228_ = _tmp227_;
					_tmp229_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp228_);
					_vala_code_node_unref0 (sym);
					sym = _tmp229_;
				}
				_tmp232_ = sym;
				_tmp233_ = node->parent;
				_tmp234_ = _tmp233_->symbol;
				if (_tmp232_ == _tmp234_) {
					ValaDataType* _tmp235_;
					gboolean _tmp236_;
					gboolean _tmp237_;
					_tmp235_ = type;
					_tmp236_ = vala_data_type_get_nullable (_tmp235_);
					_tmp237_ = _tmp236_;
					_tmp231_ = !_tmp237_;
				} else {
					_tmp231_ = FALSE;
				}
				if (_tmp231_) {
					gboolean _tmp238_ = FALSE;
					gboolean _tmp239_ = FALSE;
					ValaSymbol* _tmp240_;
					_tmp240_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp240_)) {
						ValaGirParserParameterInfo* _tmp241_;
						ValaParameter* _tmp242_;
						ValaParameterDirection _tmp243_;
						ValaParameterDirection _tmp244_;
						_tmp241_ = info;
						_tmp242_ = _tmp241_->param;
						_tmp243_ = vala_parameter_get_direction (_tmp242_);
						_tmp244_ = _tmp243_;
						_tmp239_ = _tmp244_ == VALA_PARAMETER_DIRECTION_IN;
					} else {
						_tmp239_ = FALSE;
					}
					if (_tmp239_) {
						_tmp238_ = TRUE;
					} else {
						gboolean _tmp245_ = FALSE;
						gboolean _tmp246_ = FALSE;
						ValaGirParserParameterInfo* _tmp247_;
						_tmp247_ = info;
						if (_tmp247_->caller_allocates) {
							ValaGirParserParameterInfo* _tmp248_;
							ValaParameter* _tmp249_;
							ValaParameterDirection _tmp250_;
							ValaParameterDirection _tmp251_;
							_tmp248_ = info;
							_tmp249_ = _tmp248_->param;
							_tmp250_ = vala_parameter_get_direction (_tmp249_);
							_tmp251_ = _tmp250_;
							_tmp246_ = _tmp251_ == VALA_PARAMETER_DIRECTION_OUT;
						} else {
							_tmp246_ = FALSE;
						}
						if (_tmp246_) {
							gboolean _tmp252_ = FALSE;
							ValaSymbol* _tmp253_;
							_tmp253_ = sym;
							if (VALA_IS_STRUCT (_tmp253_)) {
								_tmp252_ = TRUE;
							} else {
								gboolean _tmp254_ = FALSE;
								ValaSymbol* _tmp255_;
								_tmp255_ = sym;
								if (VALA_IS_CLASS (_tmp255_)) {
									ValaSymbol* _tmp256_;
									gboolean _tmp257_;
									gboolean _tmp258_;
									_tmp256_ = sym;
									_tmp257_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp256_, VALA_TYPE_CLASS, ValaClass));
									_tmp258_ = _tmp257_;
									_tmp254_ = _tmp258_;
								} else {
									_tmp254_ = FALSE;
								}
								_tmp252_ = _tmp254_;
							}
							_tmp245_ = _tmp252_;
						} else {
							_tmp245_ = FALSE;
						}
						_tmp238_ = _tmp245_;
					}
					_tmp230_ = _tmp238_;
				} else {
					_tmp230_ = FALSE;
				}
				if (_tmp230_) {
					ValaSymbol* _tmp259_;
					ValaGirParserParameterInfo* _tmp260_;
					_tmp259_ = s;
					vala_method_set_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp259_, VALA_TYPE_METHOD, ValaMethod), VALA_MEMBER_BINDING_INSTANCE);
					_tmp260_ = info;
					_tmp260_->keep = FALSE;
				}
				_vala_code_node_unref0 (sym);
			}
			first_param = FALSE;
			_vala_gir_parser_parameter_info_unref0 (info);
		}
	}
	{
		gint param_n = 0;
		ValaList* _tmp261_;
		gint _tmp262_;
		gint _tmp263_;
		_tmp261_ = parameters;
		_tmp262_ = vala_collection_get_size ((ValaCollection*) _tmp261_);
		_tmp263_ = _tmp262_;
		param_n = _tmp263_ - 1;
		{
			gboolean _tmp264_ = FALSE;
			_tmp264_ = TRUE;
			while (TRUE) {
				ValaGirParserParameterInfo* info = NULL;
				ValaList* _tmp266_;
				gpointer _tmp267_;
				gboolean _tmp268_ = FALSE;
				ValaGirParserParameterInfo* _tmp269_;
				ValaParameter* _tmp270_;
				gboolean _tmp271_;
				gboolean _tmp272_;
				if (!_tmp264_) {
					gint _tmp265_;
					_tmp265_ = param_n;
					param_n = _tmp265_ - 1;
				}
				_tmp264_ = FALSE;
				if (!(param_n >= 0)) {
					break;
				}
				_tmp266_ = parameters;
				_tmp267_ = vala_list_get (_tmp266_, param_n);
				info = (ValaGirParserParameterInfo*) _tmp267_;
				_tmp269_ = info;
				_tmp270_ = _tmp269_->param;
				_tmp271_ = vala_parameter_get_ellipsis (_tmp270_);
				_tmp272_ = _tmp271_;
				if (!_tmp272_) {
					ValaGirParserParameterInfo* _tmp273_;
					ValaParameter* _tmp274_;
					ValaExpression* _tmp275_;
					ValaExpression* _tmp276_;
					_tmp273_ = info;
					_tmp274_ = _tmp273_->param;
					_tmp275_ = vala_variable_get_initializer ((ValaVariable*) _tmp274_);
					_tmp276_ = _tmp275_;
					_tmp268_ = _tmp276_ == NULL;
				} else {
					_tmp268_ = FALSE;
				}
				if (_tmp268_) {
					gchar* type_string = NULL;
					ValaGirParserParameterInfo* _tmp277_;
					ValaParameter* _tmp278_;
					ValaDataType* _tmp279_;
					ValaDataType* _tmp280_;
					gchar* _tmp281_;
					gboolean _tmp282_ = FALSE;
					const gchar* _tmp283_;
					_tmp277_ = info;
					_tmp278_ = _tmp277_->param;
					_tmp279_ = vala_variable_get_variable_type ((ValaVariable*) _tmp278_);
					_tmp280_ = _tmp279_;
					_tmp281_ = vala_code_node_to_string ((ValaCodeNode*) _tmp280_);
					type_string = _tmp281_;
					_tmp283_ = type_string;
					if (g_strcmp0 (_tmp283_, "GLib.Cancellable?") == 0) {
						_tmp282_ = TRUE;
					} else {
						const gchar* _tmp284_;
						_tmp284_ = type_string;
						_tmp282_ = g_strcmp0 (_tmp284_, "Gio.Cancellable?") == 0;
					}
					if (_tmp282_) {
						ValaGirParserParameterInfo* _tmp285_;
						ValaParameter* _tmp286_;
						ValaNullLiteral* _tmp287_;
						ValaNullLiteral* _tmp288_;
						_tmp285_ = info;
						_tmp286_ = _tmp285_->param;
						_tmp287_ = vala_null_literal_new (NULL);
						_tmp288_ = _tmp287_;
						vala_variable_set_initializer ((ValaVariable*) _tmp286_, (ValaExpression*) _tmp288_);
						_vala_code_node_unref0 (_tmp288_);
					} else {
						_g_free0 (type_string);
						_vala_gir_parser_parameter_info_unref0 (info);
						break;
					}
					_g_free0 (type_string);
				}
				_vala_gir_parser_parameter_info_unref0 (info);
			}
		}
	}
	_tmp289_ = parameters;
	_tmp290_ = vala_collection_get_size ((ValaCollection*) _tmp289_);
	_tmp291_ = _tmp290_;
	if (_tmp291_ > 1) {
		ValaGirParserParameterInfo* last_param = NULL;
		ValaList* _tmp292_;
		ValaList* _tmp293_;
		gint _tmp294_;
		gint _tmp295_;
		gpointer _tmp296_;
		ValaGirParserParameterInfo* _tmp297_;
		ValaParameter* _tmp298_;
		gboolean _tmp299_;
		gboolean _tmp300_;
		_tmp292_ = parameters;
		_tmp293_ = parameters;
		_tmp294_ = vala_collection_get_size ((ValaCollection*) _tmp293_);
		_tmp295_ = _tmp294_;
		_tmp296_ = vala_list_get (_tmp292_, _tmp295_ - 1);
		last_param = (ValaGirParserParameterInfo*) _tmp296_;
		_tmp297_ = last_param;
		_tmp298_ = _tmp297_->param;
		_tmp299_ = vala_parameter_get_ellipsis (_tmp298_);
		_tmp300_ = _tmp299_;
		if (_tmp300_) {
			ValaGirParserParameterInfo* first_vararg_param = NULL;
			ValaList* _tmp301_;
			ValaList* _tmp302_;
			gint _tmp303_;
			gint _tmp304_;
			gpointer _tmp305_;
			ValaGirParserParameterInfo* _tmp306_;
			ValaParameter* _tmp307_;
			const gchar* _tmp308_;
			const gchar* _tmp309_;
			_tmp301_ = parameters;
			_tmp302_ = parameters;
			_tmp303_ = vala_collection_get_size ((ValaCollection*) _tmp302_);
			_tmp304_ = _tmp303_;
			_tmp305_ = vala_list_get (_tmp301_, _tmp304_ - 2);
			first_vararg_param = (ValaGirParserParameterInfo*) _tmp305_;
			_tmp306_ = first_vararg_param;
			_tmp307_ = _tmp306_->param;
			_tmp308_ = vala_symbol_get_name ((ValaSymbol*) _tmp307_);
			_tmp309_ = _tmp308_;
			if (g_str_has_prefix (_tmp309_, "first_")) {
				ValaGirParserParameterInfo* _tmp310_;
				_tmp310_ = first_vararg_param;
				_tmp310_->keep = FALSE;
			}
			_vala_gir_parser_parameter_info_unref0 (first_vararg_param);
		}
		_vala_gir_parser_parameter_info_unref0 (last_param);
	}
	i = 0;
	j = 1;
	first_out = -1;
	last = -1;
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp311_;
		gint _info_size = 0;
		ValaList* _tmp312_;
		gint _tmp313_;
		gint _tmp314_;
		gint _info_index = 0;
		_tmp311_ = parameters;
		_info_list = _tmp311_;
		_tmp312_ = _info_list;
		_tmp313_ = vala_collection_get_size ((ValaCollection*) _tmp312_);
		_tmp314_ = _tmp313_;
		_info_size = _tmp314_;
		_info_index = -1;
		while (TRUE) {
			gint _tmp315_;
			gint _tmp316_;
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp317_;
			gpointer _tmp318_;
			gboolean _tmp319_ = FALSE;
			ValaSymbol* _tmp320_;
			gboolean _tmp347_ = FALSE;
			gboolean _tmp352_ = FALSE;
			gboolean _tmp353_ = FALSE;
			gboolean _tmp361_ = FALSE;
			ValaSymbol* _tmp362_;
			gint _tmp366_;
			_info_index = _info_index + 1;
			_tmp315_ = _info_index;
			_tmp316_ = _info_size;
			if (!(_tmp315_ < _tmp316_)) {
				break;
			}
			_tmp317_ = _info_list;
			_tmp318_ = vala_list_get (_tmp317_, _info_index);
			info = (ValaGirParserParameterInfo*) _tmp318_;
			_tmp320_ = s;
			if (VALA_IS_DELEGATE (_tmp320_)) {
				ValaGirParserParameterInfo* _tmp321_;
				_tmp321_ = info;
				_tmp319_ = _tmp321_->closure_idx == i;
			} else {
				_tmp319_ = FALSE;
			}
			if (_tmp319_) {
				ValaDelegate* d = NULL;
				ValaSymbol* _tmp322_;
				ValaDelegate* _tmp323_;
				ValaDelegate* _tmp324_;
				ValaDelegate* _tmp325_;
				ValaGirParserParameterInfo* _tmp326_;
				_tmp322_ = s;
				_tmp323_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp322_, VALA_TYPE_DELEGATE, ValaDelegate));
				d = _tmp323_;
				_tmp324_ = d;
				vala_delegate_set_has_target (_tmp324_, TRUE);
				_tmp325_ = d;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp325_, "CCode", "instance_pos", j - 0.1, NULL);
				_tmp326_ = info;
				_tmp326_->keep = FALSE;
				_vala_code_node_unref0 (d);
			} else {
				gboolean _tmp327_ = FALSE;
				gboolean _tmp328_ = FALSE;
				gboolean _tmp329_ = FALSE;
				ValaGirParserParameterInfo* _tmp330_;
				_tmp330_ = info;
				if (_tmp330_->keep) {
					ValaArrayList* _tmp331_;
					_tmp331_ = node->array_length_parameters;
					_tmp329_ = !vala_collection_contains ((ValaCollection*) _tmp331_, (gpointer) ((gintptr) i));
				} else {
					_tmp329_ = FALSE;
				}
				if (_tmp329_) {
					ValaArrayList* _tmp332_;
					_tmp332_ = node->closure_parameters;
					_tmp328_ = !vala_collection_contains ((ValaCollection*) _tmp332_, (gpointer) ((gintptr) i));
				} else {
					_tmp328_ = FALSE;
				}
				if (_tmp328_) {
					ValaArrayList* _tmp333_;
					_tmp333_ = node->destroy_parameters;
					_tmp327_ = !vala_collection_contains ((ValaCollection*) _tmp333_, (gpointer) ((gintptr) i));
				} else {
					_tmp327_ = FALSE;
				}
				if (_tmp327_) {
					ValaGirParserParameterInfo* _tmp334_;
					ValaGirParserParameterInfo* _tmp335_;
					gfloat last_idx = 0.0F;
					gint _tmp344_;
					_tmp334_ = info;
					_tmp334_->vala_idx = (gfloat) j;
					_tmp335_ = info;
					_tmp335_->keep = TRUE;
					last_idx = 0.0F;
					if (last != -1) {
						ValaList* _tmp336_;
						gpointer _tmp337_;
						ValaGirParserParameterInfo* _tmp338_;
						_tmp336_ = parameters;
						_tmp337_ = vala_list_get (_tmp336_, last);
						_tmp338_ = (ValaGirParserParameterInfo*) _tmp337_;
						last_idx = _tmp338_->vala_idx;
						_vala_gir_parser_parameter_info_unref0 (_tmp338_);
					}
					{
						gint k = 0;
						k = last + 1;
						{
							gboolean _tmp339_ = FALSE;
							_tmp339_ = TRUE;
							while (TRUE) {
								ValaList* _tmp341_;
								gpointer _tmp342_;
								ValaGirParserParameterInfo* _tmp343_;
								if (!_tmp339_) {
									gint _tmp340_;
									_tmp340_ = k;
									k = _tmp340_ + 1;
								}
								_tmp339_ = FALSE;
								if (!(k < i)) {
									break;
								}
								_tmp341_ = parameters;
								_tmp342_ = vala_list_get (_tmp341_, k);
								_tmp343_ = (ValaGirParserParameterInfo*) _tmp342_;
								_tmp343_->vala_idx = last_idx + (((j - last_idx) / (i - last)) * (k - last));
								_vala_gir_parser_parameter_info_unref0 (_tmp343_);
							}
						}
					}
					last = i;
					_tmp344_ = j;
					j = _tmp344_ + 1;
				} else {
					ValaGirParserParameterInfo* _tmp345_;
					ValaGirParserParameterInfo* _tmp346_;
					_tmp345_ = info;
					_tmp345_->keep = FALSE;
					_tmp346_ = info;
					_tmp346_->vala_idx = (j - 1) + ((i - last) * 0.1F);
				}
			}
			if (first_out < 0) {
				ValaGirParserParameterInfo* _tmp348_;
				ValaParameter* _tmp349_;
				ValaParameterDirection _tmp350_;
				ValaParameterDirection _tmp351_;
				_tmp348_ = info;
				_tmp349_ = _tmp348_->param;
				_tmp350_ = vala_parameter_get_direction (_tmp349_);
				_tmp351_ = _tmp350_;
				_tmp347_ = _tmp351_ == VALA_PARAMETER_DIRECTION_OUT;
			} else {
				_tmp347_ = FALSE;
			}
			if (_tmp347_) {
				first_out = i;
			}
			if (first_out >= 0) {
				ValaGirParserParameterInfo* _tmp354_;
				_tmp354_ = info;
				_tmp353_ = _tmp354_->is_async_result;
			} else {
				_tmp353_ = FALSE;
			}
			if (_tmp353_) {
				ValaSymbol* _tmp355_;
				_tmp355_ = s;
				_tmp352_ = VALA_IS_METHOD (_tmp355_);
			} else {
				_tmp352_ = FALSE;
			}
			if (_tmp352_) {
				gdouble _tmp356_ = 0.0;
				ValaSymbol* _tmp357_;
				ValaMemberBinding _tmp358_;
				ValaMemberBinding _tmp359_;
				gdouble shift = 0.0;
				ValaSymbol* _tmp360_;
				_tmp357_ = s;
				_tmp358_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp357_, VALA_TYPE_METHOD, ValaMethod));
				_tmp359_ = _tmp358_;
				if (_tmp359_ == VALA_MEMBER_BINDING_INSTANCE) {
					_tmp356_ = 1.1;
				} else {
					_tmp356_ = 0.1;
				}
				shift = _tmp356_;
				_tmp360_ = s;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp360_, "CCode", "async_result_pos", i + shift, NULL);
			}
			_tmp362_ = s;
			if (VALA_IS_DELEGATE (_tmp362_)) {
				ValaGirParserParameterInfo* _tmp363_;
				_tmp363_ = info;
				_tmp361_ = _tmp363_->is_error;
			} else {
				_tmp361_ = FALSE;
			}
			if (_tmp361_) {
				ValaSymbol* _tmp364_;
				_tmp364_ = s;
				if (!vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp364_, "CCode", "instance_pos")) {
					ValaSymbol* _tmp365_;
					_tmp365_ = s;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp365_, "CCode", "error_pos", j - 0.2, NULL);
				}
			}
			_tmp366_ = i;
			i = _tmp366_ + 1;
			_vala_gir_parser_parameter_info_unref0 (info);
		}
	}
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp367_;
		gint _info_size = 0;
		ValaList* _tmp368_;
		gint _tmp369_;
		gint _tmp370_;
		gint _info_index = 0;
		_tmp367_ = parameters;
		_info_list = _tmp367_;
		_tmp368_ = _info_list;
		_tmp369_ = vala_collection_get_size ((ValaCollection*) _tmp368_);
		_tmp370_ = _tmp369_;
		_info_size = _tmp370_;
		_info_index = -1;
		while (TRUE) {
			gint _tmp371_;
			gint _tmp372_;
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp373_;
			gpointer _tmp374_;
			ValaGirParserParameterInfo* _tmp375_;
			ValaSymbol* _tmp376_;
			ValaGirParserParameterInfo* _tmp380_;
			ValaGirParserParameterInfo* _tmp395_;
			ValaGirParserParameterInfo* _tmp420_;
			ValaGirParserParameterInfo* _tmp445_;
			_info_index = _info_index + 1;
			_tmp371_ = _info_index;
			_tmp372_ = _info_size;
			if (!(_tmp371_ < _tmp372_)) {
				break;
			}
			_tmp373_ = _info_list;
			_tmp374_ = vala_list_get (_tmp373_, _info_index);
			info = (ValaGirParserParameterInfo*) _tmp374_;
			_tmp375_ = info;
			if (!_tmp375_->keep) {
				_vala_gir_parser_parameter_info_unref0 (info);
				continue;
			}
			_tmp376_ = s;
			if (VALA_IS_CALLABLE (_tmp376_)) {
				ValaSymbol* _tmp377_;
				ValaGirParserParameterInfo* _tmp378_;
				ValaParameter* _tmp379_;
				_tmp377_ = s;
				_tmp378_ = info;
				_tmp379_ = _tmp378_->param;
				vala_callable_add_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp377_, VALA_TYPE_CALLABLE, ValaCallable), _tmp379_);
			}
			_tmp380_ = info;
			if (_tmp380_->array_length_idx != -1) {
				ValaGirParserParameterInfo* _tmp381_;
				ValaList* _tmp382_;
				gint _tmp383_;
				gint _tmp384_;
				ValaGirParserParameterInfo* _tmp389_;
				ValaParameter* _tmp390_;
				ValaList* _tmp391_;
				ValaGirParserParameterInfo* _tmp392_;
				gpointer _tmp393_;
				ValaGirParserParameterInfo* _tmp394_;
				_tmp381_ = info;
				_tmp382_ = parameters;
				_tmp383_ = vala_collection_get_size ((ValaCollection*) _tmp382_);
				_tmp384_ = _tmp383_;
				if (_tmp381_->array_length_idx >= _tmp384_) {
					ValaGirParserParameterInfo* _tmp385_;
					ValaParameter* _tmp386_;
					ValaSourceReference* _tmp387_;
					ValaSourceReference* _tmp388_;
					_tmp385_ = info;
					_tmp386_ = _tmp385_->param;
					_tmp387_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp386_);
					_tmp388_ = _tmp387_;
					vala_report_error (_tmp388_, "invalid array_length index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp389_ = info;
				_tmp390_ = _tmp389_->param;
				_tmp391_ = parameters;
				_tmp392_ = info;
				_tmp393_ = vala_list_get (_tmp391_, _tmp392_->array_length_idx);
				_tmp394_ = (ValaGirParserParameterInfo*) _tmp393_;
				vala_gir_parser_set_array_ccode (self, (ValaSymbol*) _tmp390_, _tmp394_);
				_vala_gir_parser_parameter_info_unref0 (_tmp394_);
			}
			_tmp395_ = info;
			if (_tmp395_->closure_idx != -1) {
				ValaGirParserParameterInfo* _tmp396_;
				ValaList* _tmp397_;
				gint _tmp398_;
				gint _tmp399_;
				ValaList* _tmp404_;
				ValaGirParserParameterInfo* _tmp405_;
				gpointer _tmp406_;
				ValaGirParserParameterInfo* _tmp407_;
				gchar* _tmp408_;
				gchar* _tmp409_;
				ValaGirParserParameterInfo* _tmp410_;
				gchar* _tmp411_;
				gchar* _tmp412_;
				gboolean _tmp413_;
				_tmp396_ = info;
				_tmp397_ = parameters;
				_tmp398_ = vala_collection_get_size ((ValaCollection*) _tmp397_);
				_tmp399_ = _tmp398_;
				if (_tmp396_->closure_idx >= _tmp399_) {
					ValaGirParserParameterInfo* _tmp400_;
					ValaParameter* _tmp401_;
					ValaSourceReference* _tmp402_;
					ValaSourceReference* _tmp403_;
					_tmp400_ = info;
					_tmp401_ = _tmp400_->param;
					_tmp402_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp401_);
					_tmp403_ = _tmp402_;
					vala_report_error (_tmp403_, "invalid closure index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp404_ = parameters;
				_tmp405_ = info;
				_tmp406_ = vala_list_get (_tmp404_, _tmp405_->closure_idx);
				_tmp407_ = (ValaGirParserParameterInfo*) _tmp406_;
				_tmp408_ = g_strdup_printf ("%g", (gdouble) _tmp407_->vala_idx);
				_tmp409_ = _tmp408_;
				_tmp410_ = info;
				_tmp411_ = g_strdup_printf ("%g", _tmp410_->vala_idx + 0.1);
				_tmp412_ = _tmp411_;
				_tmp413_ = g_strcmp0 (_tmp409_, _tmp412_) != 0;
				_g_free0 (_tmp412_);
				_g_free0 (_tmp409_);
				_vala_gir_parser_parameter_info_unref0 (_tmp407_);
				if (_tmp413_) {
					ValaGirParserParameterInfo* _tmp414_;
					ValaParameter* _tmp415_;
					ValaList* _tmp416_;
					ValaGirParserParameterInfo* _tmp417_;
					gpointer _tmp418_;
					ValaGirParserParameterInfo* _tmp419_;
					_tmp414_ = info;
					_tmp415_ = _tmp414_->param;
					_tmp416_ = parameters;
					_tmp417_ = info;
					_tmp418_ = vala_list_get (_tmp416_, _tmp417_->closure_idx);
					_tmp419_ = (ValaGirParserParameterInfo*) _tmp418_;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp415_, "CCode", "delegate_target_pos", (gdouble) _tmp419_->vala_idx, NULL);
					_vala_gir_parser_parameter_info_unref0 (_tmp419_);
				}
			}
			_tmp420_ = info;
			if (_tmp420_->destroy_idx != -1) {
				ValaGirParserParameterInfo* _tmp421_;
				ValaList* _tmp422_;
				gint _tmp423_;
				gint _tmp424_;
				ValaList* _tmp429_;
				ValaGirParserParameterInfo* _tmp430_;
				gpointer _tmp431_;
				ValaGirParserParameterInfo* _tmp432_;
				gchar* _tmp433_;
				gchar* _tmp434_;
				ValaGirParserParameterInfo* _tmp435_;
				gchar* _tmp436_;
				gchar* _tmp437_;
				gboolean _tmp438_;
				_tmp421_ = info;
				_tmp422_ = parameters;
				_tmp423_ = vala_collection_get_size ((ValaCollection*) _tmp422_);
				_tmp424_ = _tmp423_;
				if (_tmp421_->destroy_idx >= _tmp424_) {
					ValaGirParserParameterInfo* _tmp425_;
					ValaParameter* _tmp426_;
					ValaSourceReference* _tmp427_;
					ValaSourceReference* _tmp428_;
					_tmp425_ = info;
					_tmp426_ = _tmp425_->param;
					_tmp427_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp426_);
					_tmp428_ = _tmp427_;
					vala_report_error (_tmp428_, "invalid destroy index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp429_ = parameters;
				_tmp430_ = info;
				_tmp431_ = vala_list_get (_tmp429_, _tmp430_->destroy_idx);
				_tmp432_ = (ValaGirParserParameterInfo*) _tmp431_;
				_tmp433_ = g_strdup_printf ("%g", (gdouble) _tmp432_->vala_idx);
				_tmp434_ = _tmp433_;
				_tmp435_ = info;
				_tmp436_ = g_strdup_printf ("%g", _tmp435_->vala_idx + 0.2);
				_tmp437_ = _tmp436_;
				_tmp438_ = g_strcmp0 (_tmp434_, _tmp437_) != 0;
				_g_free0 (_tmp437_);
				_g_free0 (_tmp434_);
				_vala_gir_parser_parameter_info_unref0 (_tmp432_);
				if (_tmp438_) {
					ValaGirParserParameterInfo* _tmp439_;
					ValaParameter* _tmp440_;
					ValaList* _tmp441_;
					ValaGirParserParameterInfo* _tmp442_;
					gpointer _tmp443_;
					ValaGirParserParameterInfo* _tmp444_;
					_tmp439_ = info;
					_tmp440_ = _tmp439_->param;
					_tmp441_ = parameters;
					_tmp442_ = info;
					_tmp443_ = vala_list_get (_tmp441_, _tmp442_->destroy_idx);
					_tmp444_ = (ValaGirParserParameterInfo*) _tmp443_;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp440_, "CCode", "destroy_notify_pos", (gdouble) _tmp444_->vala_idx, NULL);
					_vala_gir_parser_parameter_info_unref0 (_tmp444_);
				}
			}
			_tmp445_ = info;
			if (_tmp445_->is_async) {
				ValaDataType* resolved_type = NULL;
				ValaGirParserParameterInfo* _tmp446_;
				ValaParameter* _tmp447_;
				ValaDataType* _tmp448_;
				ValaDataType* _tmp449_;
				ValaDataType* _tmp450_;
				ValaDataType* _tmp451_;
				ValaDataType* _tmp460_;
				_tmp446_ = info;
				_tmp447_ = _tmp446_->param;
				_tmp448_ = vala_variable_get_variable_type ((ValaVariable*) _tmp447_);
				_tmp449_ = _tmp448_;
				_tmp450_ = _vala_code_node_ref0 (_tmp449_);
				resolved_type = _tmp450_;
				_tmp451_ = resolved_type;
				if (VALA_IS_UNRESOLVED_TYPE (_tmp451_)) {
					ValaSymbol* resolved_symbol = NULL;
					ValaGirParserNode* _tmp452_;
					ValaDataType* _tmp453_;
					ValaUnresolvedSymbol* _tmp454_;
					ValaUnresolvedSymbol* _tmp455_;
					ValaSymbol* _tmp456_;
					ValaSymbol* _tmp457_;
					_tmp452_ = node->parent;
					_tmp453_ = resolved_type;
					_tmp454_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp453_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
					_tmp455_ = _tmp454_;
					_tmp456_ = vala_gir_parser_resolve_symbol (self, _tmp452_, _tmp455_);
					resolved_symbol = _tmp456_;
					_tmp457_ = resolved_symbol;
					if (VALA_IS_DELEGATE (_tmp457_)) {
						ValaSymbol* _tmp458_;
						ValaDelegateType* _tmp459_;
						_tmp458_ = resolved_symbol;
						_tmp459_ = vala_delegate_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp458_, VALA_TYPE_DELEGATE, ValaDelegate), NULL);
						_vala_code_node_unref0 (resolved_type);
						resolved_type = (ValaDataType*) _tmp459_;
					}
					_vala_code_node_unref0 (resolved_symbol);
				}
				_tmp460_ = resolved_type;
				if (VALA_IS_DELEGATE_TYPE (_tmp460_)) {
					ValaDelegate* d = NULL;
					ValaDataType* _tmp461_;
					ValaDelegate* _tmp462_;
					ValaDelegate* _tmp463_;
					ValaDelegate* _tmp464_;
					gboolean _tmp465_ = FALSE;
					ValaDelegate* _tmp466_;
					const gchar* _tmp467_;
					const gchar* _tmp468_;
					_tmp461_ = resolved_type;
					_tmp462_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp461_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp463_ = _tmp462_;
					_tmp464_ = _vala_code_node_ref0 (_tmp463_);
					d = _tmp464_;
					_tmp466_ = d;
					_tmp467_ = vala_symbol_get_name ((ValaSymbol*) _tmp466_);
					_tmp468_ = _tmp467_;
					if (g_strcmp0 (_tmp468_, "DestroyNotify") == 0) {
						ValaDelegate* _tmp469_;
						ValaSymbol* _tmp470_;
						ValaSymbol* _tmp471_;
						const gchar* _tmp472_;
						const gchar* _tmp473_;
						_tmp469_ = d;
						_tmp470_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp469_);
						_tmp471_ = _tmp470_;
						_tmp472_ = vala_symbol_get_name (_tmp471_);
						_tmp473_ = _tmp472_;
						_tmp465_ = g_strcmp0 (_tmp473_, "GLib") == 0;
					} else {
						_tmp465_ = FALSE;
					}
					if (!_tmp465_) {
						ValaGirParserParameterInfo* _tmp474_;
						ValaParameter* _tmp475_;
						gboolean _tmp476_ = FALSE;
						ValaGirParserParameterInfo* _tmp477_;
						ValaGirParserParameterInfo* _tmp479_;
						ValaParameter* _tmp480_;
						ValaDataType* _tmp481_;
						ValaDataType* _tmp482_;
						_tmp474_ = info;
						_tmp475_ = _tmp474_->param;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp475_, "CCode", "scope", "async", NULL);
						_tmp477_ = info;
						if (_tmp477_->closure_idx != -1) {
							ValaGirParserParameterInfo* _tmp478_;
							_tmp478_ = info;
							_tmp476_ = _tmp478_->destroy_idx != -1;
						} else {
							_tmp476_ = FALSE;
						}
						_tmp479_ = info;
						_tmp480_ = _tmp479_->param;
						_tmp481_ = vala_variable_get_variable_type ((ValaVariable*) _tmp480_);
						_tmp482_ = _tmp481_;
						vala_data_type_set_value_owned (_tmp482_, _tmp476_);
					}
					_vala_code_node_unref0 (d);
				}
				_vala_code_node_unref0 (resolved_type);
			} else {
				ValaDataType* resolved_type = NULL;
				ValaGirParserParameterInfo* _tmp483_;
				ValaParameter* _tmp484_;
				ValaDataType* _tmp485_;
				ValaDataType* _tmp486_;
				ValaDataType* _tmp487_;
				ValaDataType* _tmp488_;
				_tmp483_ = info;
				_tmp484_ = _tmp483_->param;
				_tmp485_ = vala_variable_get_variable_type ((ValaVariable*) _tmp484_);
				_tmp486_ = _tmp485_;
				_tmp487_ = _vala_code_node_ref0 (_tmp486_);
				resolved_type = _tmp487_;
				_tmp488_ = resolved_type;
				if (VALA_IS_DELEGATE_TYPE (_tmp488_)) {
					gboolean _tmp489_ = FALSE;
					ValaGirParserParameterInfo* _tmp490_;
					ValaGirParserParameterInfo* _tmp492_;
					ValaParameter* _tmp493_;
					ValaDataType* _tmp494_;
					ValaDataType* _tmp495_;
					_tmp490_ = info;
					if (_tmp490_->closure_idx != -1) {
						ValaGirParserParameterInfo* _tmp491_;
						_tmp491_ = info;
						_tmp489_ = _tmp491_->destroy_idx != -1;
					} else {
						_tmp489_ = FALSE;
					}
					_tmp492_ = info;
					_tmp493_ = _tmp492_->param;
					_tmp494_ = vala_variable_get_variable_type ((ValaVariable*) _tmp493_);
					_tmp495_ = _tmp494_;
					vala_data_type_set_value_owned (_tmp495_, _tmp489_);
				}
				_vala_code_node_unref0 (resolved_type);
			}
			_vala_gir_parser_parameter_info_unref0 (info);
		}
	}
	_tmp497_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp497_)) {
		_tmp496_ = node->return_array_length_idx >= 0;
	} else {
		_tmp496_ = FALSE;
	}
	if (_tmp496_) {
		ValaSymbol* _tmp498_;
		ValaList* _tmp499_;
		gpointer _tmp500_;
		ValaGirParserParameterInfo* _tmp501_;
		_tmp498_ = s;
		_tmp499_ = parameters;
		_tmp500_ = vala_list_get (_tmp499_, node->return_array_length_idx);
		_tmp501_ = (ValaGirParserParameterInfo*) _tmp500_;
		vala_gir_parser_set_array_ccode (self, _tmp498_, _tmp501_);
		_vala_gir_parser_parameter_info_unref0 (_tmp501_);
	}
	_tmp502_ = s;
	if (VALA_IS_CALLABLE (_tmp502_)) {
		ValaSymbol* _tmp503_;
		ValaDataType* _tmp504_;
		_tmp503_ = s;
		_tmp504_ = return_type;
		vala_callable_set_return_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp503_, VALA_TYPE_CALLABLE, ValaCallable), _tmp504_);
	}
	_vala_code_node_unref0 (return_type);
	_vala_iterable_unref0 (parameters);
	_vala_code_node_unref0 (s);
}

static void
vala_gir_parser_find_parent (ValaGirParser* self,
                             const gchar* cname,
                             ValaGirParserNode* current,
                             ValaGirParserNode** best,
                             gint* match)
{
	ValaGirParserNode* old_best = NULL;
	ValaGirParserNode* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaGirParserNode* _tmp20_;
	gint current_match = 0;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	g_return_if_fail (current != NULL);
	g_return_if_fail (*best != NULL);
	_tmp0_ = _vala_gir_parser_node_ref0 (*best);
	old_best = _tmp0_;
	_tmp1_ = current->symbol;
	if (VALA_IS_NAMESPACE (_tmp1_)) {
		{
			ValaArrayList* _child_list = NULL;
			ValaArrayList* _tmp2_;
			gint _child_size = 0;
			ValaArrayList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _child_index = 0;
			_tmp2_ = current->members;
			_child_list = _tmp2_;
			_tmp3_ = _child_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_child_size = _tmp5_;
			_child_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				ValaGirParserNode* child = NULL;
				ValaArrayList* _tmp8_;
				gpointer _tmp9_;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				ValaGirParserNode* _tmp12_;
				ValaSymbol* _tmp13_;
				_child_index = _child_index + 1;
				_tmp6_ = _child_index;
				_tmp7_ = _child_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _child_list;
				_tmp9_ = vala_list_get ((ValaList*) _tmp8_, _child_index);
				child = (ValaGirParserNode*) _tmp9_;
				_tmp12_ = child;
				_tmp13_ = _tmp12_->symbol;
				if (_tmp13_ == NULL) {
					_tmp11_ = TRUE;
				} else {
					ValaGirParserNode* _tmp14_;
					ValaSymbol* _tmp15_;
					_tmp14_ = child;
					_tmp15_ = _tmp14_->symbol;
					_tmp11_ = vala_gir_parser_is_container (_tmp15_);
				}
				if (_tmp11_) {
					ValaGirParserNode* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp16_ = child;
					_tmp17_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp10_ = g_str_has_prefix (cname, _tmp18_);
					_g_free0 (_tmp18_);
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					ValaGirParserNode* _tmp19_;
					_tmp19_ = child;
					vala_gir_parser_find_parent (self, cname, _tmp19_, best, match);
				}
				_vala_gir_parser_node_unref0 (child);
			}
		}
	}
	_tmp20_ = old_best;
	if ((*best) != _tmp20_) {
		_vala_gir_parser_node_unref0 (old_best);
		return;
	}
	_tmp21_ = vala_gir_parser_node_get_lower_case_cprefix (current);
	_tmp22_ = _tmp21_;
	_tmp23_ = strlen (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp22_);
	current_match = _tmp25_;
	if (current_match > (*match)) {
		ValaGirParserNode* _tmp26_;
		*match = current_match;
		_tmp26_ = _vala_gir_parser_node_ref0 (current);
		_vala_gir_parser_node_unref0 (*best);
		*best = _tmp26_;
	}
	_vala_gir_parser_node_unref0 (old_best);
}

static gboolean
vala_gir_parser_same_gir (ValaGirParser* self,
                          ValaSymbol* gir_component,
                          ValaSymbol* sym)
{
	gchar* gir_name = NULL;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceFile* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* gir_version = NULL;
	ValaSourceReference* _tmp7_;
	ValaSourceReference* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSourceFile* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSourceFile* _tmp16_;
	ValaSourceFile* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (gir_component != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) gir_component);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_source_reference_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_source_file_get_gir_namespace (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	gir_name = _tmp6_;
	_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) gir_component);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_source_reference_get_file (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_source_file_get_gir_version (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup (_tmp12_);
	gir_version = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_source_reference_get_file (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_source_file_get_filename (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%s-%s", gir_name, gir_version);
	_tmp21_ = _tmp20_;
	_tmp22_ = string_contains (_tmp19_, _tmp21_);
	_g_free0 (_tmp21_);
	result = _tmp22_;
	_g_free0 (gir_version);
	_g_free0 (gir_name);
	return result;
}

static void
vala_gir_parser_process_namespace_method (ValaGirParser* self,
                                          ValaGirParserNode* ns,
                                          ValaGirParserNode* node)
{
	gchar* ns_cprefix = NULL;
	gchar* _tmp0_;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	gchar* cname = NULL;
	gchar* _tmp3_;
	ValaParameter* first_param = NULL;
	ValaList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaParameter* _tmp14_;
	gint match = 0;
	ValaGirParserNode* parent = NULL;
	ValaGirParserNode* _tmp73_;
	const gchar* _tmp74_;
	gchar* new_name = NULL;
	ValaMethod* _tmp75_;
	const gchar* _tmp76_;
	const gchar* _tmp77_;
	ValaGirParserNode* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	const gchar* _tmp83_;
	gint _tmp84_;
	gint _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gboolean _tmp88_ = FALSE;
	ValaMethod* _tmp89_;
	ValaGirParserNode* _tmp90_;
	ValaSymbol* _tmp91_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = vala_gir_parser_node_get_lower_case_cprefix (ns);
	ns_cprefix = _tmp0_;
	_tmp1_ = node->symbol;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_METHOD, ValaMethod));
	method = _tmp2_;
	_tmp3_ = vala_gir_parser_node_get_cname (node);
	cname = _tmp3_;
	first_param = NULL;
	_tmp4_ = node->parameters;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		ValaList* _tmp7_;
		gpointer _tmp8_;
		ValaGirParserParameterInfo* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		_tmp7_ = node->parameters;
		_tmp8_ = vala_list_get (_tmp7_, 0);
		_tmp9_ = (ValaGirParserParameterInfo*) _tmp8_;
		_tmp10_ = _tmp9_->param;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		_vala_code_node_unref0 (first_param);
		first_param = _tmp11_;
		_vala_gir_parser_parameter_info_unref0 (_tmp9_);
	}
	_tmp14_ = first_param;
	if (_tmp14_ != NULL) {
		ValaParameter* _tmp15_;
		ValaParameterDirection _tmp16_;
		ValaParameterDirection _tmp17_;
		_tmp15_ = first_param;
		_tmp16_ = vala_parameter_get_direction (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_ == VALA_PARAMETER_DIRECTION_IN;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		ValaParameter* _tmp18_;
		ValaDataType* _tmp19_;
		ValaDataType* _tmp20_;
		_tmp18_ = first_param;
		_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp12_ = VALA_IS_UNRESOLVED_TYPE (_tmp20_);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaUnresolvedSymbol* sym = NULL;
		ValaParameter* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		ValaUnresolvedSymbol* _tmp24_;
		ValaUnresolvedSymbol* _tmp25_;
		ValaUnresolvedSymbol* _tmp26_;
		ValaGirParserNode* parent = NULL;
		ValaUnresolvedSymbol* _tmp27_;
		ValaGirParserNode* _tmp28_;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		ValaGirParserNode* _tmp33_;
		_tmp21_ = first_param;
		_tmp22_ = vala_variable_get_variable_type ((ValaVariable*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
		_tmp25_ = _tmp24_;
		_tmp26_ = _vala_code_node_ref0 (_tmp25_);
		sym = _tmp26_;
		_tmp27_ = sym;
		_tmp28_ = vala_gir_parser_resolve_node (self, ns, _tmp27_, FALSE);
		parent = _tmp28_;
		_tmp33_ = parent;
		if (_tmp33_ != NULL) {
			ValaMethod* _tmp34_;
			ValaGirParserNode* _tmp35_;
			ValaSymbol* _tmp36_;
			_tmp34_ = method;
			_tmp35_ = parent;
			_tmp36_ = _tmp35_->symbol;
			_tmp32_ = vala_gir_parser_same_gir (self, (ValaSymbol*) _tmp34_, _tmp36_);
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaGirParserNode* _tmp37_;
			ValaGirParserNode* _tmp38_;
			_tmp37_ = parent;
			_tmp38_ = _tmp37_->parent;
			_tmp31_ = _tmp38_ == ns;
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			ValaGirParserNode* _tmp39_;
			ValaSymbol* _tmp40_;
			_tmp39_ = parent;
			_tmp40_ = _tmp39_->symbol;
			_tmp30_ = vala_gir_parser_is_container (_tmp40_);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			const gchar* _tmp41_;
			ValaGirParserNode* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp41_ = cname;
			_tmp42_ = parent;
			_tmp43_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp29_ = g_str_has_prefix (_tmp41_, _tmp44_);
			_g_free0 (_tmp44_);
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			gchar* new_name = NULL;
			ValaMethod* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			ValaGirParserNode* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			const gchar* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			ValaGirParserNode* _tmp58_;
			const gchar* _tmp59_;
			ValaGirParserNode* _tmp60_;
			ValaGirParserNode* _tmp61_;
			gboolean _tmp62_;
			_tmp45_ = method;
			_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = parent;
			_tmp49_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = strlen (_tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = ns_cprefix;
			_tmp54_ = strlen (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = string_substring (_tmp47_, (glong) (_tmp52_ - _tmp55_), (glong) -1);
			_tmp57_ = _tmp56_;
			_g_free0 (_tmp50_);
			new_name = _tmp57_;
			_tmp58_ = parent;
			_tmp59_ = new_name;
			_tmp60_ = vala_gir_parser_node_lookup (_tmp58_, _tmp59_, FALSE, NULL);
			_tmp61_ = _tmp60_;
			_tmp62_ = _tmp61_ == NULL;
			_vala_gir_parser_node_unref0 (_tmp61_);
			if (_tmp62_) {
				const gchar* _tmp63_;
				gchar* _tmp64_;
				ValaList* _tmp65_;
				gpointer _tmp66_;
				ValaGirParserParameterInfo* _tmp67_;
				gint _tmp68_;
				ValaMethod* _tmp69_;
				const gchar* _tmp70_;
				ValaMethod* _tmp71_;
				ValaGirParserNode* _tmp72_;
				vala_gir_parser_node_remove_member (ns, node);
				_tmp63_ = new_name;
				_tmp64_ = g_strdup (_tmp63_);
				_g_free0 (node->name);
				node->name = _tmp64_;
				_tmp65_ = node->parameters;
				_tmp66_ = vala_list_remove_at (_tmp65_, 0);
				_tmp67_ = (ValaGirParserParameterInfo*) _tmp66_;
				_vala_gir_parser_parameter_info_unref0 (_tmp67_);
				_tmp68_ = node->return_array_length_idx;
				node->return_array_length_idx = _tmp68_ - 1;
				_tmp69_ = method;
				_tmp70_ = new_name;
				vala_symbol_set_name ((ValaSymbol*) _tmp69_, _tmp70_);
				_tmp71_ = method;
				vala_method_set_binding (_tmp71_, VALA_MEMBER_BINDING_INSTANCE);
				_tmp72_ = parent;
				vala_gir_parser_node_add_member (_tmp72_, node);
			}
			_g_free0 (new_name);
			_vala_gir_parser_node_unref0 (parent);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (first_param);
			_g_free0 (cname);
			_vala_code_node_unref0 (method);
			_g_free0 (ns_cprefix);
			return;
		}
		_vala_gir_parser_node_unref0 (parent);
		_vala_code_node_unref0 (sym);
	}
	match = 0;
	_tmp73_ = _vala_gir_parser_node_ref0 (ns);
	parent = _tmp73_;
	_tmp74_ = cname;
	vala_gir_parser_find_parent (self, _tmp74_, ns, &parent, &match);
	_tmp75_ = method;
	_tmp76_ = vala_symbol_get_name ((ValaSymbol*) _tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = parent;
	_tmp79_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp78_);
	_tmp80_ = _tmp79_;
	_tmp81_ = strlen (_tmp80_);
	_tmp82_ = _tmp81_;
	_tmp83_ = ns_cprefix;
	_tmp84_ = strlen (_tmp83_);
	_tmp85_ = _tmp84_;
	_tmp86_ = string_substring (_tmp77_, (glong) (_tmp82_ - _tmp85_), (glong) -1);
	_tmp87_ = _tmp86_;
	_g_free0 (_tmp80_);
	new_name = _tmp87_;
	_tmp89_ = method;
	_tmp90_ = parent;
	_tmp91_ = _tmp90_->symbol;
	if (vala_gir_parser_same_gir (self, (ValaSymbol*) _tmp89_, _tmp91_)) {
		ValaGirParserNode* _tmp92_;
		const gchar* _tmp93_;
		ValaGirParserNode* _tmp94_;
		ValaGirParserNode* _tmp95_;
		_tmp92_ = parent;
		_tmp93_ = new_name;
		_tmp94_ = vala_gir_parser_node_lookup (_tmp92_, _tmp93_, FALSE, NULL);
		_tmp95_ = _tmp94_;
		_tmp88_ = _tmp95_ == NULL;
		_vala_gir_parser_node_unref0 (_tmp95_);
	} else {
		_tmp88_ = FALSE;
	}
	if (_tmp88_) {
		const gchar* _tmp96_;
		gchar* _tmp97_;
		ValaMethod* _tmp98_;
		const gchar* _tmp99_;
		ValaGirParserNode* _tmp100_;
		vala_gir_parser_node_remove_member (ns, node);
		_tmp96_ = new_name;
		_tmp97_ = g_strdup (_tmp96_);
		_g_free0 (node->name);
		node->name = _tmp97_;
		_tmp98_ = method;
		_tmp99_ = new_name;
		vala_symbol_set_name ((ValaSymbol*) _tmp98_, _tmp99_);
		_tmp100_ = parent;
		vala_gir_parser_node_add_member (_tmp100_, node);
	}
	_g_free0 (new_name);
	_vala_gir_parser_node_unref0 (parent);
	_vala_code_node_unref0 (first_param);
	_g_free0 (cname);
	_vala_code_node_unref0 (method);
	_g_free0 (ns_cprefix);
}

static void
vala_gir_parser_process_virtual_method_field (ValaGirParser* self,
                                              ValaGirParserNode* node,
                                              ValaDelegate* d,
                                              ValaUnresolvedSymbol* gtype_struct_for)
{
	ValaGirParserNode* gtype_node = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaGirParserNode* _tmp3_;
	ValaArrayList* nodes = NULL;
	ValaGirParserNode* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	ValaArrayList* _tmp15_;
	ValaArrayList* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (d != NULL);
	g_return_if_fail (gtype_struct_for != NULL);
	_tmp0_ = node->parent;
	_tmp1_ = vala_gir_parser_resolve_node (self, _tmp0_, gtype_struct_for, FALSE);
	gtype_node = _tmp1_;
	_tmp3_ = gtype_node;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		ValaGirParserNode* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp4_ = gtype_node;
		_tmp5_ = _tmp4_->symbol;
		_tmp2_ = !VALA_IS_OBJECT_TYPE_SYMBOL (_tmp5_);
	}
	if (_tmp2_) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) gtype_struct_for);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_node_to_string ((ValaCodeNode*) gtype_struct_for);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_gir_parser_node_to_string (node);
		_tmp11_ = _tmp10_;
		vala_report_error (_tmp7_, "Unknown symbol `%s' for virtual method field `%s'", _tmp9_, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
	_tmp12_ = gtype_node;
	_tmp13_ = vala_symbol_get_name ((ValaSymbol*) d);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_gir_parser_node_lookup_all (_tmp12_, _tmp14_);
	nodes = _tmp15_;
	_tmp16_ = nodes;
	if (_tmp16_ == NULL) {
		_vala_iterable_unref0 (nodes);
		_vala_gir_parser_node_unref0 (gtype_node);
		return;
	}
	{
		ValaArrayList* _n_list = NULL;
		ValaArrayList* _tmp17_;
		gint _n_size = 0;
		ValaArrayList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _n_index = 0;
		_tmp17_ = nodes;
		_n_list = _tmp17_;
		_tmp18_ = _n_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_n_size = _tmp20_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp23_;
			gpointer _tmp24_;
			ValaGirParserNode* _tmp25_;
			_n_index = _n_index + 1;
			_tmp21_ = _n_index;
			_tmp22_ = _n_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _n_list;
			_tmp24_ = vala_list_get ((ValaList*) _tmp23_, _n_index);
			n = (ValaGirParserNode*) _tmp24_;
			_tmp25_ = n;
			if (node != _tmp25_) {
				ValaGirParserNode* _tmp26_;
				_tmp26_ = n;
				vala_gir_parser_node_process (_tmp26_, self);
			}
			_vala_gir_parser_node_unref0 (n);
		}
	}
	{
		ValaArrayList* _n_list = NULL;
		ValaArrayList* _tmp27_;
		gint _n_size = 0;
		ValaArrayList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _n_index = 0;
		_tmp27_ = nodes;
		_n_list = _tmp27_;
		_tmp28_ = _n_list;
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_n_size = _tmp30_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp31_;
			gint _tmp32_;
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp33_;
			gpointer _tmp34_;
			ValaGirParserNode* _tmp35_;
			ValaSymbol* sym = NULL;
			ValaGirParserNode* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			_n_index = _n_index + 1;
			_tmp31_ = _n_index;
			_tmp32_ = _n_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _n_list;
			_tmp34_ = vala_list_get ((ValaList*) _tmp33_, _n_index);
			n = (ValaGirParserNode*) _tmp34_;
			_tmp35_ = n;
			if (_tmp35_->merged) {
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp36_ = n;
			_tmp37_ = _tmp36_->symbol;
			_tmp38_ = _vala_code_node_ref0 (_tmp37_);
			sym = _tmp38_;
			_tmp39_ = sym;
			if (VALA_IS_SIGNAL (_tmp39_)) {
				ValaSignal* sig = NULL;
				ValaSymbol* _tmp40_;
				ValaSignal* _tmp41_;
				ValaSignal* _tmp42_;
				ValaSignal* _tmp43_;
				_tmp40_ = sym;
				_tmp41_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, VALA_TYPE_SIGNAL, ValaSignal));
				sig = _tmp41_;
				_tmp42_ = sig;
				vala_signal_set_is_virtual (_tmp42_, TRUE);
				_tmp43_ = sig;
				vala_gir_parser_assume_parameter_names (self, _tmp43_, (ValaSymbol*) d, TRUE);
				_vala_code_node_unref0 (sig);
			} else {
				ValaSymbol* _tmp44_;
				_tmp44_ = sym;
				if (VALA_IS_PROPERTY (_tmp44_)) {
					ValaProperty* prop = NULL;
					ValaSymbol* _tmp45_;
					ValaProperty* _tmp46_;
					ValaProperty* _tmp47_;
					_tmp45_ = sym;
					_tmp46_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_PROPERTY, ValaProperty));
					prop = _tmp46_;
					_tmp47_ = prop;
					vala_property_set_is_virtual (_tmp47_, TRUE);
					_vala_code_node_unref0 (prop);
				}
			}
			_vala_code_node_unref0 (sym);
			_vala_gir_parser_node_unref0 (n);
		}
	}
	_vala_iterable_unref0 (nodes);
	_vala_gir_parser_node_unref0 (gtype_node);
}

static void
vala_gir_parser_process_async_method (ValaGirParser* self,
                                      ValaGirParserNode* node)
{
	ValaMethod* m = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	gboolean requires_pointer = FALSE;
	gchar* finish_method_base = NULL;
	ValaMethod* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	ValaGirParserNode* finish_method_node = NULL;
	ValaGirParserNode* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	ValaGirParserNode* _tmp54_;
	ValaGirParserNode* _tmp55_;
	ValaGirParserNode* _tmp56_;
	ValaMethod* method = NULL;
	ValaMethod* _tmp76_;
	ValaMethod* _tmp77_;
	gboolean _tmp78_ = FALSE;
	ValaGirParserNode* _tmp79_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp1_;
	requires_pointer = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaMethod* _tmp2_;
		ValaList* _tmp3_;
		gint _param_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _param_index = 0;
		_tmp2_ = m;
		_tmp3_ = vala_callable_get_parameters ((ValaCallable*) _tmp2_);
		_param_list = _tmp3_;
		_tmp4_ = _param_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_param_size = _tmp6_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaParameter* param = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaParameter* _tmp11_;
			ValaParameterDirection _tmp12_;
			ValaParameterDirection _tmp13_;
			_param_index = _param_index + 1;
			_tmp7_ = _param_index;
			_tmp8_ = _param_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _param_list;
			_tmp10_ = vala_list_get (_tmp9_, _param_index);
			param = (ValaParameter*) _tmp10_;
			_tmp11_ = param;
			_tmp12_ = vala_parameter_get_direction (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ == VALA_PARAMETER_DIRECTION_IN) {
				requires_pointer = TRUE;
			} else {
				if (requires_pointer) {
					ValaParameter* _tmp14_;
					ValaParameter* _tmp15_;
					ValaDataType* _tmp16_;
					ValaDataType* _tmp17_;
					ValaParameter* _tmp18_;
					ValaParameter* _tmp19_;
					ValaDataType* _tmp20_;
					ValaDataType* _tmp21_;
					ValaPointerType* _tmp22_;
					ValaPointerType* _tmp23_;
					ValaParameter* _tmp24_;
					ValaSourceReference* _tmp25_;
					ValaSourceReference* _tmp26_;
					_tmp14_ = param;
					vala_parameter_set_direction (_tmp14_, VALA_PARAMETER_DIRECTION_IN);
					_tmp15_ = param;
					_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) _tmp15_);
					_tmp17_ = _tmp16_;
					vala_data_type_set_nullable (_tmp17_, FALSE);
					_tmp18_ = param;
					_tmp19_ = param;
					_tmp20_ = vala_variable_get_variable_type ((ValaVariable*) _tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = vala_pointer_type_new (_tmp21_, NULL);
					_tmp23_ = _tmp22_;
					vala_variable_set_variable_type ((ValaVariable*) _tmp18_, (ValaDataType*) _tmp23_);
					_vala_code_node_unref0 (_tmp23_);
					_tmp24_ = param;
					_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp24_);
					_tmp26_ = _tmp25_;
					vala_report_warning (_tmp26_, "Synchronous out-parameters are not supported in async methods");
				}
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp27_ = m;
	_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ == NULL) {
		ValaMethod* _tmp30_;
		gchar* _tmp31_;
		_tmp30_ = m;
		_vala_assert (VALA_IS_CREATION_METHOD (_tmp30_), "m is CreationMethod");
		_tmp31_ = g_strdup ("new");
		_g_free0 (finish_method_base);
		finish_method_base = _tmp31_;
	} else {
		ValaMethod* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		_tmp32_ = m;
		_tmp33_ = vala_symbol_get_name ((ValaSymbol*) _tmp32_);
		_tmp34_ = _tmp33_;
		if (g_str_has_suffix (_tmp34_, "_async")) {
			ValaMethod* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			ValaMethod* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			gchar* _tmp45_;
			_tmp35_ = m;
			_tmp36_ = vala_symbol_get_name ((ValaSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = m;
			_tmp39_ = vala_symbol_get_name ((ValaSymbol*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = strlen (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = strlen ("_async");
			_tmp44_ = _tmp43_;
			_tmp45_ = string_substring (_tmp37_, (glong) 0, (glong) (_tmp42_ - _tmp44_));
			_g_free0 (finish_method_base);
			finish_method_base = _tmp45_;
		} else {
			ValaMethod* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			gchar* _tmp49_;
			_tmp46_ = m;
			_tmp47_ = vala_symbol_get_name ((ValaSymbol*) _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_strdup (_tmp48_);
			_g_free0 (finish_method_base);
			finish_method_base = _tmp49_;
		}
	}
	_tmp50_ = node->parent;
	_tmp51_ = finish_method_base;
	_tmp52_ = g_strconcat (_tmp51_, "_finish", NULL);
	_tmp53_ = _tmp52_;
	_tmp54_ = vala_gir_parser_node_lookup (_tmp50_, _tmp53_, FALSE, NULL);
	_tmp55_ = _tmp54_;
	_g_free0 (_tmp53_);
	finish_method_node = _tmp55_;
	_tmp56_ = finish_method_node;
	if (_tmp56_ == NULL) {
		gchar* method_cname = NULL;
		gchar* _tmp57_;
		_tmp57_ = vala_gir_parser_node_get_finish_cname (node);
		method_cname = _tmp57_;
		{
			ValaArrayList* _n_list = NULL;
			ValaGirParserNode* _tmp58_;
			ValaArrayList* _tmp59_;
			gint _n_size = 0;
			ValaArrayList* _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			gint _n_index = 0;
			_tmp58_ = node->parent;
			_tmp59_ = _tmp58_->members;
			_n_list = _tmp59_;
			_tmp60_ = _n_list;
			_tmp61_ = vala_collection_get_size ((ValaCollection*) _tmp60_);
			_tmp62_ = _tmp61_;
			_n_size = _tmp62_;
			_n_index = -1;
			while (TRUE) {
				gint _tmp63_;
				gint _tmp64_;
				ValaGirParserNode* n = NULL;
				ValaArrayList* _tmp65_;
				gpointer _tmp66_;
				gboolean _tmp67_ = FALSE;
				ValaGirParserNode* _tmp68_;
				ValaSymbol* _tmp69_;
				_n_index = _n_index + 1;
				_tmp63_ = _n_index;
				_tmp64_ = _n_size;
				if (!(_tmp63_ < _tmp64_)) {
					break;
				}
				_tmp65_ = _n_list;
				_tmp66_ = vala_list_get ((ValaList*) _tmp65_, _n_index);
				n = (ValaGirParserNode*) _tmp66_;
				_tmp68_ = n;
				_tmp69_ = _tmp68_->symbol;
				if (VALA_IS_METHOD (_tmp69_)) {
					ValaGirParserNode* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					const gchar* _tmp73_;
					_tmp70_ = n;
					_tmp71_ = vala_gir_parser_node_get_cname (_tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = method_cname;
					_tmp67_ = g_strcmp0 (_tmp72_, _tmp73_) == 0;
					_g_free0 (_tmp72_);
				} else {
					_tmp67_ = FALSE;
				}
				if (_tmp67_) {
					ValaGirParserNode* _tmp74_;
					ValaGirParserNode* _tmp75_;
					_tmp74_ = n;
					_tmp75_ = _vala_gir_parser_node_ref0 (_tmp74_);
					_vala_gir_parser_node_unref0 (finish_method_node);
					finish_method_node = _tmp75_;
					_vala_gir_parser_node_unref0 (n);
					break;
				}
				_vala_gir_parser_node_unref0 (n);
			}
		}
		_g_free0 (method_cname);
	}
	_tmp76_ = m;
	_tmp77_ = _vala_code_node_ref0 (_tmp76_);
	method = _tmp77_;
	_tmp79_ = finish_method_node;
	if (_tmp79_ != NULL) {
		ValaGirParserNode* _tmp80_;
		ValaSymbol* _tmp81_;
		_tmp80_ = finish_method_node;
		_tmp81_ = _tmp80_->symbol;
		_tmp78_ = VALA_IS_METHOD (_tmp81_);
	} else {
		_tmp78_ = FALSE;
	}
	if (_tmp78_) {
		ValaGirParserNode* _tmp82_;
		ValaMethod* finish_method = NULL;
		ValaGirParserNode* _tmp83_;
		ValaSymbol* _tmp84_;
		ValaMethod* _tmp85_;
		ValaMethod* _tmp86_;
		ValaMethod* _tmp154_;
		ValaMethod* _tmp155_;
		ValaArrayList* error_types = NULL;
		GEqualFunc _tmp187_;
		ValaArrayList* _tmp188_;
		ValaMethod* _tmp189_;
		ValaArrayList* _tmp190_;
		ValaMethod* _tmp191_;
		ValaSourceReference* _tmp192_;
		ValaSourceReference* _tmp193_;
		ValaGirParserNode* _tmp204_;
		ValaGirParserNode* _tmp205_;
		_tmp82_ = finish_method_node;
		vala_gir_parser_node_process (_tmp82_, self);
		_tmp83_ = finish_method_node;
		_tmp84_ = _tmp83_->symbol;
		_tmp85_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, VALA_TYPE_METHOD, ValaMethod));
		finish_method = _tmp85_;
		_tmp86_ = finish_method;
		if (VALA_IS_CREATION_METHOD (_tmp86_)) {
			ValaMethod* _tmp87_;
			const gchar* _tmp88_;
			const gchar* _tmp89_;
			ValaMethod* _tmp90_;
			ValaSourceReference* _tmp91_;
			ValaSourceReference* _tmp92_;
			ValaCreationMethod* _tmp93_;
			ValaMethod* _tmp94_;
			ValaMethod* _tmp95_;
			ValaSymbolAccessibility _tmp96_;
			ValaSymbolAccessibility _tmp97_;
			ValaMethod* _tmp98_;
			ValaMethod* _tmp99_;
			ValaMethod* _tmp100_;
			gboolean _tmp101_;
			gboolean _tmp102_;
			ValaMethod* _tmp103_;
			GList* _tmp104_;
			ValaMethod* _tmp108_;
			gchar* _tmp109_;
			gchar* _tmp110_;
			const gchar* _tmp111_;
			ValaMethod* _tmp133_;
			ValaSymbol* _tmp134_;
			_tmp87_ = finish_method;
			_tmp88_ = vala_creation_method_get_class_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			_tmp89_ = _tmp88_;
			_tmp90_ = m;
			_tmp91_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = vala_creation_method_new (_tmp89_, NULL, _tmp92_, NULL);
			_vala_code_node_unref0 (method);
			method = (ValaMethod*) _tmp93_;
			_tmp94_ = method;
			_tmp95_ = m;
			_tmp96_ = vala_symbol_get_access ((ValaSymbol*) _tmp95_);
			_tmp97_ = _tmp96_;
			vala_symbol_set_access ((ValaSymbol*) _tmp94_, _tmp97_);
			_tmp98_ = method;
			vala_method_set_coroutine (_tmp98_, TRUE);
			_tmp99_ = method;
			_tmp100_ = finish_method;
			_tmp101_ = vala_method_get_has_construct_function (_tmp100_);
			_tmp102_ = _tmp101_;
			vala_method_set_has_construct_function (_tmp99_, _tmp102_);
			_tmp103_ = m;
			_tmp104_ = ((ValaCodeNode*) _tmp103_)->attributes;
			{
				GList* a_collection = NULL;
				GList* a_it = NULL;
				a_collection = _tmp104_;
				for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
					ValaAttribute* _tmp105_;
					ValaAttribute* a = NULL;
					_tmp105_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
					a = _tmp105_;
					{
						ValaMethod* _tmp106_;
						ValaAttribute* _tmp107_;
						_tmp106_ = method;
						_tmp107_ = a;
						vala_code_node_add_attribute ((ValaCodeNode*) _tmp106_, _tmp107_);
						_vala_code_node_unref0 (a);
					}
				}
			}
			_tmp108_ = method;
			_tmp109_ = vala_gir_parser_node_get_cname (node);
			_tmp110_ = _tmp109_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp108_, "CCode", "cname", _tmp110_, NULL);
			_g_free0 (_tmp110_);
			_tmp111_ = finish_method_base;
			if (g_strcmp0 (_tmp111_, "new") == 0) {
				ValaMethod* _tmp112_;
				_tmp112_ = method;
				vala_symbol_set_name ((ValaSymbol*) _tmp112_, NULL);
			} else {
				const gchar* _tmp113_;
				_tmp113_ = finish_method_base;
				if (g_str_has_prefix (_tmp113_, "new_")) {
					ValaMethod* _tmp114_;
					ValaMethod* _tmp115_;
					const gchar* _tmp116_;
					const gchar* _tmp117_;
					gint _tmp118_;
					gint _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					_tmp114_ = method;
					_tmp115_ = m;
					_tmp116_ = vala_symbol_get_name ((ValaSymbol*) _tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = strlen ("new_");
					_tmp119_ = _tmp118_;
					_tmp120_ = string_substring (_tmp117_, (glong) _tmp119_, (glong) -1);
					_tmp121_ = _tmp120_;
					vala_symbol_set_name ((ValaSymbol*) _tmp114_, _tmp121_);
					_g_free0 (_tmp121_);
				}
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp122_;
				ValaList* _tmp123_;
				gint _param_size = 0;
				ValaList* _tmp124_;
				gint _tmp125_;
				gint _tmp126_;
				gint _param_index = 0;
				_tmp122_ = m;
				_tmp123_ = vala_callable_get_parameters ((ValaCallable*) _tmp122_);
				_param_list = _tmp123_;
				_tmp124_ = _param_list;
				_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
				_tmp126_ = _tmp125_;
				_param_size = _tmp126_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp127_;
					gint _tmp128_;
					ValaParameter* param = NULL;
					ValaList* _tmp129_;
					gpointer _tmp130_;
					ValaMethod* _tmp131_;
					ValaParameter* _tmp132_;
					_param_index = _param_index + 1;
					_tmp127_ = _param_index;
					_tmp128_ = _param_size;
					if (!(_tmp127_ < _tmp128_)) {
						break;
					}
					_tmp129_ = _param_list;
					_tmp130_ = vala_list_get (_tmp129_, _param_index);
					param = (ValaParameter*) _tmp130_;
					_tmp131_ = method;
					_tmp132_ = param;
					vala_callable_add_parameter ((ValaCallable*) _tmp131_, _tmp132_);
					_vala_code_node_unref0 (param);
				}
			}
			_tmp133_ = method;
			_tmp134_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp133_);
			_vala_code_node_unref0 (node->symbol);
			node->symbol = _tmp134_;
		} else {
			ValaMethod* _tmp135_;
			ValaMethod* _tmp136_;
			ValaDataType* _tmp137_;
			ValaDataType* _tmp138_;
			ValaDataType* _tmp139_;
			ValaDataType* _tmp140_;
			ValaAttribute* a = NULL;
			ValaMethod* _tmp141_;
			ValaAttribute* _tmp142_;
			ValaAttribute* _tmp143_;
			gboolean _tmp144_ = FALSE;
			ValaAttribute* _tmp145_;
			gboolean _tmp149_ = FALSE;
			ValaAttribute* _tmp150_;
			_tmp135_ = method;
			_tmp136_ = finish_method;
			_tmp137_ = vala_callable_get_return_type ((ValaCallable*) _tmp136_);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_data_type_copy (_tmp138_);
			_tmp140_ = _tmp139_;
			vala_callable_set_return_type ((ValaCallable*) _tmp135_, _tmp140_);
			_vala_code_node_unref0 (_tmp140_);
			_tmp141_ = finish_method;
			_tmp142_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp141_, "CCode");
			_tmp143_ = _vala_code_node_ref0 (_tmp142_);
			a = _tmp143_;
			_tmp145_ = a;
			if (_tmp145_ != NULL) {
				ValaAttribute* _tmp146_;
				_tmp146_ = a;
				_tmp144_ = vala_attribute_has_argument (_tmp146_, "array_length");
			} else {
				_tmp144_ = FALSE;
			}
			if (_tmp144_) {
				ValaMethod* _tmp147_;
				ValaAttribute* _tmp148_;
				_tmp147_ = method;
				_tmp148_ = a;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp147_, "CCode", "array_length", vala_attribute_get_bool (_tmp148_, "array_length", FALSE), NULL);
			}
			_tmp150_ = a;
			if (_tmp150_ != NULL) {
				ValaAttribute* _tmp151_;
				_tmp151_ = a;
				_tmp149_ = vala_attribute_has_argument (_tmp151_, "array_null_terminated");
			} else {
				_tmp149_ = FALSE;
			}
			if (_tmp149_) {
				ValaMethod* _tmp152_;
				ValaAttribute* _tmp153_;
				_tmp152_ = method;
				_tmp153_ = a;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp152_, "CCode", "array_null_terminated", vala_attribute_get_bool (_tmp153_, "array_null_terminated", FALSE), NULL);
			}
			_vala_code_node_unref0 (a);
		}
		_tmp154_ = method;
		_tmp155_ = finish_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp154_, (ValaCodeNode*) _tmp155_, "CCode", "async_result_pos");
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp156_;
			ValaList* _tmp157_;
			gint _param_size = 0;
			ValaList* _tmp158_;
			gint _tmp159_;
			gint _tmp160_;
			gint _param_index = 0;
			_tmp156_ = finish_method;
			_tmp157_ = vala_callable_get_parameters ((ValaCallable*) _tmp156_);
			_param_list = _tmp157_;
			_tmp158_ = _param_list;
			_tmp159_ = vala_collection_get_size ((ValaCollection*) _tmp158_);
			_tmp160_ = _tmp159_;
			_param_size = _tmp160_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp161_;
				gint _tmp162_;
				ValaParameter* param = NULL;
				ValaList* _tmp163_;
				gpointer _tmp164_;
				ValaParameter* _tmp165_;
				ValaParameterDirection _tmp166_;
				ValaParameterDirection _tmp167_;
				_param_index = _param_index + 1;
				_tmp161_ = _param_index;
				_tmp162_ = _param_size;
				if (!(_tmp161_ < _tmp162_)) {
					break;
				}
				_tmp163_ = _param_list;
				_tmp164_ = vala_list_get (_tmp163_, _param_index);
				param = (ValaParameter*) _tmp164_;
				_tmp165_ = param;
				_tmp166_ = vala_parameter_get_direction (_tmp165_);
				_tmp167_ = _tmp166_;
				if (_tmp167_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaParameter* async_param = NULL;
					ValaParameter* _tmp168_;
					ValaParameter* _tmp169_;
					ValaMethod* _tmp170_;
					ValaScope* _tmp171_;
					ValaScope* _tmp172_;
					ValaParameter* _tmp173_;
					const gchar* _tmp174_;
					const gchar* _tmp175_;
					ValaSymbol* _tmp176_;
					ValaSymbol* _tmp177_;
					gboolean _tmp178_;
					ValaMethod* _tmp185_;
					ValaParameter* _tmp186_;
					_tmp168_ = param;
					_tmp169_ = vala_parameter_copy (_tmp168_);
					async_param = _tmp169_;
					_tmp170_ = method;
					_tmp171_ = vala_symbol_get_scope ((ValaSymbol*) _tmp170_);
					_tmp172_ = _tmp171_;
					_tmp173_ = param;
					_tmp174_ = vala_symbol_get_name ((ValaSymbol*) _tmp173_);
					_tmp175_ = _tmp174_;
					_tmp176_ = vala_scope_lookup (_tmp172_, _tmp175_);
					_tmp177_ = _tmp176_;
					_tmp178_ = _tmp177_ != NULL;
					_vala_code_node_unref0 (_tmp177_);
					if (_tmp178_) {
						ValaParameter* _tmp179_;
						ValaParameter* _tmp180_;
						const gchar* _tmp181_;
						const gchar* _tmp182_;
						gchar* _tmp183_;
						gchar* _tmp184_;
						_tmp179_ = async_param;
						_tmp180_ = async_param;
						_tmp181_ = vala_symbol_get_name ((ValaSymbol*) _tmp180_);
						_tmp182_ = _tmp181_;
						_tmp183_ = g_strconcat (_tmp182_, "_out", NULL);
						_tmp184_ = _tmp183_;
						vala_symbol_set_name ((ValaSymbol*) _tmp180_, _tmp184_);
						_g_free0 (_tmp184_);
					}
					_tmp185_ = method;
					_tmp186_ = async_param;
					vala_callable_add_parameter ((ValaCallable*) _tmp185_, _tmp186_);
					_vala_code_node_unref0 (async_param);
				}
				_vala_code_node_unref0 (param);
			}
		}
		_tmp187_ = g_direct_equal;
		_tmp188_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp187_);
		error_types = _tmp188_;
		_tmp189_ = finish_method;
		_tmp190_ = error_types;
		_tmp191_ = method;
		_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp191_);
		_tmp193_ = _tmp192_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp189_, (ValaCollection*) _tmp190_, _tmp193_);
		{
			ValaArrayList* _error_type_list = NULL;
			ValaArrayList* _tmp194_;
			gint _error_type_size = 0;
			ValaArrayList* _tmp195_;
			gint _tmp196_;
			gint _tmp197_;
			gint _error_type_index = 0;
			_tmp194_ = error_types;
			_error_type_list = _tmp194_;
			_tmp195_ = _error_type_list;
			_tmp196_ = vala_collection_get_size ((ValaCollection*) _tmp195_);
			_tmp197_ = _tmp196_;
			_error_type_size = _tmp197_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp198_;
				gint _tmp199_;
				ValaDataType* error_type = NULL;
				ValaArrayList* _tmp200_;
				gpointer _tmp201_;
				ValaMethod* _tmp202_;
				ValaDataType* _tmp203_;
				_error_type_index = _error_type_index + 1;
				_tmp198_ = _error_type_index;
				_tmp199_ = _error_type_size;
				if (!(_tmp198_ < _tmp199_)) {
					break;
				}
				_tmp200_ = _error_type_list;
				_tmp201_ = vala_list_get ((ValaList*) _tmp200_, _error_type_index);
				error_type = (ValaDataType*) _tmp201_;
				_tmp202_ = method;
				_tmp203_ = error_type;
				vala_method_add_error_type (_tmp202_, _tmp203_);
				_vala_code_node_unref0 (error_type);
			}
		}
		_tmp204_ = finish_method_node;
		_tmp204_->processed = TRUE;
		_tmp205_ = finish_method_node;
		_tmp205_->merged = TRUE;
		_vala_iterable_unref0 (error_types);
		_vala_code_node_unref0 (finish_method);
	}
	_vala_code_node_unref0 (method);
	_vala_gir_parser_node_unref0 (finish_method_node);
	_g_free0 (finish_method_base);
	_vala_code_node_unref0 (m);
}

static guint
vala_gir_parser_unresolved_symbol_hash (ValaUnresolvedSymbol* sym)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp6_;
	const gchar* _tmp7_;
	guint result;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	while (TRUE) {
		GString* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		ValaUnresolvedSymbol* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		if (!(sym != NULL)) {
			break;
		}
		_tmp1_ = builder;
		_tmp2_ = vala_symbol_get_name ((ValaSymbol*) sym);
		_tmp3_ = _tmp2_;
		g_string_append (_tmp1_, _tmp3_);
		_tmp4_ = vala_unresolved_symbol_get_inner (sym);
		_tmp5_ = _tmp4_;
		sym = _tmp5_;
	}
	_tmp6_ = builder;
	_tmp7_ = _tmp6_->str;
	result = g_str_hash (_tmp7_);
	_g_string_free0 (builder);
	return result;
}

static gboolean
vala_gir_parser_unresolved_symbol_equal (ValaUnresolvedSymbol* sym1,
                                         ValaUnresolvedSymbol* sym2)
{
	gboolean result;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		ValaUnresolvedSymbol* _tmp7_;
		ValaUnresolvedSymbol* _tmp8_;
		if (!(sym1 != sym2)) {
			break;
		}
		if (sym1 == NULL) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = sym2 == NULL;
		}
		if (_tmp0_) {
			result = FALSE;
			return result;
		}
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) sym1);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) sym2);
		_tmp4_ = _tmp3_;
		if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
			result = FALSE;
			return result;
		}
		_tmp5_ = vala_unresolved_symbol_get_inner (sym1);
		_tmp6_ = _tmp5_;
		sym1 = _tmp6_;
		_tmp7_ = vala_unresolved_symbol_get_inner (sym2);
		_tmp8_ = _tmp7_;
		sym2 = _tmp8_;
	}
	result = TRUE;
	return result;
}

static ValaGirParserNode*
vala_gir_parser_base_interface_property (ValaGirParser* self,
                                         ValaGirParserNode* prop_node)
{
	ValaClass* cl = NULL;
	ValaGirParserNode* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaClass* _tmp2_;
	ValaClass* _tmp3_;
	ValaGirParserNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	_tmp0_ = prop_node->parent;
	_tmp1_ = _tmp0_->symbol;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1_) ? ((ValaClass*) _tmp1_) : NULL);
	cl = _tmp2_;
	_tmp3_ = cl;
	if (_tmp3_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (cl);
		return result;
	}
	{
		ValaList* _type_list = NULL;
		ValaClass* _tmp4_;
		ValaList* _tmp5_;
		gint _type_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_index = 0;
		_tmp4_ = cl;
		_tmp5_ = vala_class_get_base_types (_tmp4_);
		_type_list = _tmp5_;
		_tmp6_ = _type_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_size = _tmp8_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaDataType* type = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaDataType* _tmp13_;
			ValaGirParserNode* base_node = NULL;
			ValaGirParserNode* _tmp14_;
			ValaDataType* _tmp15_;
			ValaUnresolvedSymbol* _tmp16_;
			ValaUnresolvedSymbol* _tmp17_;
			ValaGirParserNode* _tmp18_;
			gboolean _tmp19_ = FALSE;
			ValaGirParserNode* _tmp20_;
			_type_index = _type_index + 1;
			_tmp9_ = _type_index;
			_tmp10_ = _type_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _type_list;
			_tmp12_ = vala_list_get (_tmp11_, _type_index);
			type = (ValaDataType*) _tmp12_;
			_tmp13_ = type;
			if (!VALA_IS_UNRESOLVED_TYPE (_tmp13_)) {
				_vala_code_node_unref0 (type);
				continue;
			}
			_tmp14_ = prop_node->parent;
			_tmp15_ = type;
			_tmp16_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_gir_parser_resolve_node (self, _tmp14_, _tmp17_, FALSE);
			base_node = _tmp18_;
			_tmp20_ = base_node;
			if (_tmp20_ != NULL) {
				ValaGirParserNode* _tmp21_;
				ValaSymbol* _tmp22_;
				_tmp21_ = base_node;
				_tmp22_ = _tmp21_->symbol;
				_tmp19_ = VALA_IS_INTERFACE (_tmp22_);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				ValaGirParserNode* base_prop_node = NULL;
				ValaGirParserNode* _tmp23_;
				const gchar* _tmp24_;
				ValaGirParserNode* _tmp25_;
				gboolean _tmp26_ = FALSE;
				ValaGirParserNode* _tmp27_;
				_tmp23_ = base_node;
				_tmp24_ = prop_node->name;
				_tmp25_ = vala_gir_parser_node_lookup (_tmp23_, _tmp24_, FALSE, NULL);
				base_prop_node = _tmp25_;
				_tmp27_ = base_prop_node;
				if (_tmp27_ != NULL) {
					ValaGirParserNode* _tmp28_;
					ValaSymbol* _tmp29_;
					_tmp28_ = base_prop_node;
					_tmp29_ = _tmp28_->symbol;
					_tmp26_ = VALA_IS_PROPERTY (_tmp29_);
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					ValaProperty* base_property = NULL;
					ValaGirParserNode* _tmp30_;
					ValaSymbol* _tmp31_;
					ValaProperty* _tmp32_;
					gboolean _tmp33_ = FALSE;
					ValaProperty* _tmp34_;
					gboolean _tmp35_;
					gboolean _tmp36_;
					_tmp30_ = base_prop_node;
					_tmp31_ = _tmp30_->symbol;
					_tmp32_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_PROPERTY, ValaProperty));
					base_property = _tmp32_;
					_tmp34_ = base_property;
					_tmp35_ = vala_property_get_is_abstract (_tmp34_);
					_tmp36_ = _tmp35_;
					if (_tmp36_) {
						_tmp33_ = TRUE;
					} else {
						ValaProperty* _tmp37_;
						gboolean _tmp38_;
						gboolean _tmp39_;
						_tmp37_ = base_property;
						_tmp38_ = vala_property_get_is_virtual (_tmp37_);
						_tmp39_ = _tmp38_;
						_tmp33_ = _tmp39_;
					}
					if (_tmp33_) {
						result = base_prop_node;
						_vala_code_node_unref0 (base_property);
						_vala_gir_parser_node_unref0 (base_node);
						_vala_code_node_unref0 (type);
						_vala_code_node_unref0 (cl);
						return result;
					}
					_vala_code_node_unref0 (base_property);
				}
				_vala_gir_parser_node_unref0 (base_prop_node);
			}
			_vala_gir_parser_node_unref0 (base_node);
			_vala_code_node_unref0 (type);
		}
	}
	result = NULL;
	_vala_code_node_unref0 (cl);
	return result;
}

ValaGirParser*
vala_gir_parser_construct (GType object_type)
{
	ValaGirParser* self = NULL;
	self = (ValaGirParser*) vala_code_visitor_construct (object_type);
	return self;
}

ValaGirParser*
vala_gir_parser_new (void)
{
	return vala_gir_parser_construct (VALA_TYPE_GIR_PARSER);
}

static gpointer
_vala_source_reference_ref0 (gpointer self)
{
	return self ? vala_source_reference_ref (self) : NULL;
}

static ValaGirParserArgument*
vala_gir_parser_argument_construct (GType object_type,
                                    ValaExpression* expression,
                                    ValaSourceReference* source_reference)
{
	ValaGirParserArgument* self = NULL;
	ValaExpression* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (expression != NULL, NULL);
	self = (ValaGirParserArgument*) g_type_create_instance (object_type);
	_tmp0_ = _vala_code_node_ref0 (expression);
	_vala_code_node_unref0 (self->expression);
	self->expression = _tmp0_;
	_tmp1_ = _vala_source_reference_ref0 (source_reference);
	_vala_source_reference_unref0 (self->source_reference);
	self->source_reference = _tmp1_;
	return self;
}

static ValaGirParserArgument*
vala_gir_parser_argument_new (ValaExpression* expression,
                              ValaSourceReference* source_reference)
{
	return vala_gir_parser_argument_construct (VALA_GIR_PARSER_TYPE_ARGUMENT, expression, source_reference);
}

static void
vala_gir_parser_value_argument_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_argument_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_argument_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_argument_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_argument_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_argument_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_argument_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserArgument * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_argument_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_argument_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	ValaGirParserArgument ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_argument_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_argument (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	ValaGirParserParamSpecArgument* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_ARGUMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_argument (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_argument (GValue* value,
                                    gpointer v_object)
{
	ValaGirParserArgument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_argument_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_argument_unref (old);
	}
}

static void
vala_gir_parser_value_take_argument (GValue* value,
                                     gpointer v_object)
{
	ValaGirParserArgument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_argument_unref (old);
	}
}

static void
vala_gir_parser_argument_class_init (ValaGirParserArgumentClass * klass,
                                     gpointer klass_data)
{
	vala_gir_parser_argument_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserArgumentClass *) klass)->finalize = vala_gir_parser_argument_finalize;
}

static void
vala_gir_parser_argument_instance_init (ValaGirParserArgument * self,
                                        gpointer klass)
{
	self->used = FALSE;
	self->ref_count = 1;
}

static void
vala_gir_parser_argument_finalize (ValaGirParserArgument * obj)
{
	ValaGirParserArgument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgument);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->expression);
	_vala_source_reference_unref0 (self->source_reference);
}

static GType
vala_gir_parser_argument_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_argument_init, vala_gir_parser_value_argument_free_value, vala_gir_parser_value_argument_copy_value, vala_gir_parser_value_argument_peek_pointer, "p", vala_gir_parser_value_argument_collect_value, "p", vala_gir_parser_value_argument_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserArgumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_argument_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserArgument), 0, (GInstanceInitFunc) vala_gir_parser_argument_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_argument_type_id;
	vala_gir_parser_argument_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserArgument", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vala_gir_parser_argument_type_id;
}

static GType
vala_gir_parser_argument_get_type (void)
{
	static volatile gsize vala_gir_parser_argument_type_id__once = 0;
	if (g_once_init_enter (&vala_gir_parser_argument_type_id__once)) {
		GType vala_gir_parser_argument_type_id;
		vala_gir_parser_argument_type_id = vala_gir_parser_argument_get_type_once ();
		g_once_init_leave (&vala_gir_parser_argument_type_id__once, vala_gir_parser_argument_type_id);
	}
	return vala_gir_parser_argument_type_id__once;
}

static gpointer
vala_gir_parser_argument_ref (gpointer instance)
{
	ValaGirParserArgument * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_argument_unref (gpointer instance)
{
	ValaGirParserArgument * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_ARGUMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static ValaGirParserMetadataSet*
vala_gir_parser_metadata_set_construct (GType object_type,
                                        const gchar* selector)
{
	ValaGirParserMetadataSet* self = NULL;
	self = (ValaGirParserMetadataSet*) vala_gir_parser_metadata_construct (object_type, "", selector, NULL);
	return self;
}

static ValaGirParserMetadataSet*
vala_gir_parser_metadata_set_new (const gchar* selector)
{
	return vala_gir_parser_metadata_set_construct (VALA_GIR_PARSER_TYPE_METADATA_SET, selector);
}

static void
vala_gir_parser_metadata_set_add_sibling (ValaGirParserMetadataSet* self,
                                          ValaGirParserMetadata* metadata)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp0_;
		gint _child_size = 0;
		ValaArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _child_index = 0;
		_tmp0_ = metadata->children;
		_child_list = _tmp0_;
		_tmp1_ = _child_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_child_size = _tmp3_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaGirParserMetadata* child = NULL;
			ValaArrayList* _tmp6_;
			gpointer _tmp7_;
			ValaGirParserMetadata* _tmp8_;
			_child_index = _child_index + 1;
			_tmp4_ = _child_index;
			_tmp5_ = _child_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _child_list;
			_tmp7_ = vala_list_get ((ValaList*) _tmp6_, _child_index);
			child = (ValaGirParserMetadata*) _tmp7_;
			_tmp8_ = child;
			vala_gir_parser_metadata_add_child ((ValaGirParserMetadata*) self, _tmp8_);
			_vala_gir_parser_metadata_unref0 (child);
		}
	}
	{
		ValaIterator* _key_it = NULL;
		ValaMap* _tmp9_;
		ValaSet* _tmp10_;
		ValaSet* _tmp11_;
		ValaIterator* _tmp12_;
		ValaIterator* _tmp13_;
		_tmp9_ = metadata->args;
		_tmp10_ = vala_map_get_keys (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_iterable_iterator ((ValaIterable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_vala_iterable_unref0 (_tmp11_);
		_key_it = _tmp13_;
		while (TRUE) {
			ValaIterator* _tmp14_;
			ValaGirParserArgumentType key = 0;
			ValaIterator* _tmp15_;
			gpointer _tmp16_;
			ValaMap* _tmp17_;
			ValaMap* _tmp18_;
			gpointer _tmp19_;
			ValaGirParserArgument* _tmp20_;
			_tmp14_ = _key_it;
			if (!vala_iterator_next (_tmp14_)) {
				break;
			}
			_tmp15_ = _key_it;
			_tmp16_ = vala_iterator_get (_tmp15_);
			key = (ValaGirParserArgumentType) ((gintptr) _tmp16_);
			_tmp17_ = ((ValaGirParserMetadata*) self)->args;
			_tmp18_ = metadata->args;
			_tmp19_ = vala_map_get (_tmp18_, (gpointer) ((gintptr) key));
			_tmp20_ = (ValaGirParserArgument*) _tmp19_;
			vala_map_set (_tmp17_, (gpointer) ((gintptr) key), _tmp20_);
			_vala_gir_parser_argument_unref0 (_tmp20_);
		}
		_vala_iterator_unref0 (_key_it);
	}
}

static void
vala_gir_parser_metadata_set_class_init (ValaGirParserMetadataSetClass * klass,
                                         gpointer klass_data)
{
	vala_gir_parser_metadata_set_parent_class = g_type_class_peek_parent (klass);
}

static void
vala_gir_parser_metadata_set_instance_init (ValaGirParserMetadataSet * self,
                                            gpointer klass)
{
}

static GType
vala_gir_parser_metadata_set_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadataSet), 0, (GInstanceInitFunc) vala_gir_parser_metadata_set_instance_init, NULL };
	GType vala_gir_parser_metadata_set_type_id;
	vala_gir_parser_metadata_set_type_id = g_type_register_static (VALA_GIR_PARSER_TYPE_METADATA, "ValaGirParserMetadataSet", &g_define_type_info, 0);
	return vala_gir_parser_metadata_set_type_id;
}

static GType
vala_gir_parser_metadata_set_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_set_type_id__once = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_set_type_id__once)) {
		GType vala_gir_parser_metadata_set_type_id;
		vala_gir_parser_metadata_set_type_id = vala_gir_parser_metadata_set_get_type_once ();
		g_once_init_leave (&vala_gir_parser_metadata_set_type_id__once, vala_gir_parser_metadata_set_type_id);
	}
	return vala_gir_parser_metadata_set_type_id__once;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_get_empty (void)
{
	ValaGirParserMetadata* result;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp2_;
	_tmp0_ = vala_gir_parser_metadata__empty;
	if (_tmp0_ == NULL) {
		ValaGirParserMetadata* _tmp1_;
		_tmp1_ = vala_gir_parser_metadata_new ("", NULL, NULL);
		_vala_gir_parser_metadata_unref0 (vala_gir_parser_metadata__empty);
		vala_gir_parser_metadata__empty = _tmp1_;
	}
	_tmp2_ = vala_gir_parser_metadata__empty;
	result = _tmp2_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_construct (GType object_type,
                                    const gchar* pattern,
                                    const gchar* selector,
                                    ValaSourceReference* source_reference)
{
	ValaGirParserMetadata* self = NULL;
	GPatternSpec* _tmp0_;
	gchar* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_val_if_fail (pattern != NULL, NULL);
	self = (ValaGirParserMetadata*) g_type_create_instance (object_type);
	_tmp0_ = g_pattern_spec_new (pattern);
	_g_pattern_spec_free0 (self->pattern_spec);
	self->pattern_spec = _tmp0_;
	_tmp1_ = g_strdup (selector);
	_g_free0 (self->selector);
	self->selector = _tmp1_;
	_tmp2_ = _vala_source_reference_ref0 (source_reference);
	_vala_source_reference_unref0 (self->source_reference);
	self->source_reference = _tmp2_;
	return self;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_new (const gchar* pattern,
                              const gchar* selector,
                              ValaSourceReference* source_reference)
{
	return vala_gir_parser_metadata_construct (VALA_GIR_PARSER_TYPE_METADATA, pattern, selector, source_reference);
}

static void
vala_gir_parser_metadata_add_child (ValaGirParserMetadata* self,
                                    ValaGirParserMetadata* metadata)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = self->children;
	vala_collection_add ((ValaCollection*) _tmp0_, metadata);
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_match_child (ValaGirParserMetadata* self,
                                      const gchar* name,
                                      const gchar* selector)
{
	ValaGirParserMetadata* _result_ = NULL;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	ValaGirParserMetadata* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_gir_parser_metadata_ref0 (_tmp1_);
	_result_ = _tmp2_;
	{
		ValaArrayList* _metadata_list = NULL;
		ValaArrayList* _tmp3_;
		gint _metadata_size = 0;
		ValaArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _metadata_index = 0;
		_tmp3_ = self->children;
		_metadata_list = _tmp3_;
		_tmp4_ = _metadata_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_metadata_size = _tmp6_;
		_metadata_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaGirParserMetadata* metadata = NULL;
			ValaArrayList* _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			_metadata_index = _metadata_index + 1;
			_tmp7_ = _metadata_index;
			_tmp8_ = _metadata_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _metadata_list;
			_tmp10_ = vala_list_get ((ValaList*) _tmp9_, _metadata_index);
			metadata = (ValaGirParserMetadata*) _tmp10_;
			if (selector == NULL) {
				_tmp13_ = TRUE;
			} else {
				ValaGirParserMetadata* _tmp14_;
				const gchar* _tmp15_;
				_tmp14_ = metadata;
				_tmp15_ = _tmp14_->selector;
				_tmp13_ = _tmp15_ == NULL;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				ValaGirParserMetadata* _tmp16_;
				const gchar* _tmp17_;
				_tmp16_ = metadata;
				_tmp17_ = _tmp16_->selector;
				_tmp12_ = g_strcmp0 (_tmp17_, selector) == 0;
			}
			if (_tmp12_) {
				ValaGirParserMetadata* _tmp18_;
				GPatternSpec* _tmp19_;
				_tmp18_ = metadata;
				_tmp19_ = _tmp18_->pattern_spec;
				_tmp11_ = g_pattern_match_string (_tmp19_, name);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				ValaGirParserMetadata* _tmp20_;
				ValaGirParserMetadata* _tmp21_;
				ValaGirParserMetadata* _tmp22_;
				ValaGirParserMetadata* _tmp23_;
				_tmp20_ = metadata;
				_tmp20_->used = TRUE;
				_tmp21_ = _result_;
				_tmp22_ = vala_gir_parser_metadata_get_empty ();
				_tmp23_ = _tmp22_;
				if (_tmp21_ == _tmp23_) {
					ValaGirParserMetadata* _tmp24_;
					ValaGirParserMetadata* _tmp25_;
					_tmp24_ = metadata;
					_tmp25_ = _vala_gir_parser_metadata_ref0 (_tmp24_);
					_vala_gir_parser_metadata_unref0 (_result_);
					_result_ = _tmp25_;
				} else {
					ValaGirParserMetadataSet* ms = NULL;
					ValaGirParserMetadata* _tmp26_;
					ValaGirParserMetadataSet* _tmp27_;
					ValaGirParserMetadataSet* _tmp28_;
					ValaGirParserMetadataSet* _tmp32_;
					ValaGirParserMetadata* _tmp33_;
					ValaGirParserMetadataSet* _tmp34_;
					ValaGirParserMetadata* _tmp35_;
					_tmp26_ = _result_;
					_tmp27_ = _vala_gir_parser_metadata_ref0 (VALA_GIR_PARSER_IS_METADATA_SET (_tmp26_) ? ((ValaGirParserMetadataSet*) _tmp26_) : NULL);
					ms = _tmp27_;
					_tmp28_ = ms;
					if (_tmp28_ == NULL) {
						ValaGirParserMetadataSet* _tmp29_;
						ValaGirParserMetadataSet* _tmp30_;
						ValaGirParserMetadata* _tmp31_;
						_tmp29_ = vala_gir_parser_metadata_set_new (selector);
						_vala_gir_parser_metadata_unref0 (ms);
						ms = _tmp29_;
						_tmp30_ = ms;
						_tmp31_ = _result_;
						vala_gir_parser_metadata_set_add_sibling (_tmp30_, _tmp31_);
					}
					_tmp32_ = ms;
					_tmp33_ = metadata;
					vala_gir_parser_metadata_set_add_sibling (_tmp32_, _tmp33_);
					_tmp34_ = ms;
					_tmp35_ = _vala_gir_parser_metadata_ref0 ((ValaGirParserMetadata*) _tmp34_);
					_vala_gir_parser_metadata_unref0 (_result_);
					_result_ = _tmp35_;
					_vala_gir_parser_metadata_unref0 (ms);
				}
			}
			_vala_gir_parser_metadata_unref0 (metadata);
		}
	}
	result = _result_;
	return result;
}

static void
vala_gir_parser_metadata_add_argument (ValaGirParserMetadata* self,
                                       ValaGirParserArgumentType key,
                                       ValaGirParserArgument* value)
{
	ValaMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->args;
	vala_map_set (_tmp0_, (gpointer) ((gintptr) key), value);
}

static gboolean
vala_gir_parser_metadata_has_argument (ValaGirParserMetadata* self,
                                       ValaGirParserArgumentType key)
{
	ValaMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->args;
	result = vala_map_contains (_tmp0_, (gpointer) ((gintptr) key));
	return result;
}

static ValaExpression*
vala_gir_parser_metadata_get_expression (ValaGirParserMetadata* self,
                                         ValaGirParserArgumentType arg)
{
	ValaGirParserArgument* val = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserArgument* _tmp2_;
	ValaExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->args;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) arg));
	val = (ValaGirParserArgument*) _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		ValaGirParserArgument* _tmp3_;
		ValaGirParserArgument* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp3_ = val;
		_tmp3_->used = TRUE;
		_tmp4_ = val;
		_tmp5_ = _tmp4_->expression;
		_tmp6_ = _vala_code_node_ref0 (_tmp5_);
		result = _tmp6_;
		_vala_gir_parser_argument_unref0 (val);
		return result;
	}
	result = NULL;
	_vala_gir_parser_argument_unref0 (val);
	return result;
}

static gchar*
vala_gir_parser_metadata_get_string (ValaGirParserMetadata* self,
                                     ValaGirParserArgumentType arg)
{
	ValaStringLiteral* lit = NULL;
	ValaExpression* _tmp0_;
	ValaStringLiteral* _tmp1_;
	ValaStringLiteral* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = VALA_IS_STRING_LITERAL (_tmp0_) ? ((ValaStringLiteral*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	lit = _tmp1_;
	_tmp2_ = lit;
	if (_tmp2_ != NULL) {
		ValaStringLiteral* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = lit;
		_tmp4_ = vala_string_literal_eval (_tmp3_);
		result = _tmp4_;
		_vala_code_node_unref0 (lit);
		return result;
	}
	result = NULL;
	_vala_code_node_unref0 (lit);
	return result;
}

static gint
vala_gir_parser_metadata_get_integer (ValaGirParserMetadata* self,
                                      ValaGirParserArgumentType arg)
{
	ValaUnaryExpression* unary = NULL;
	ValaExpression* _tmp0_;
	ValaUnaryExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaUnaryExpression* _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = VALA_IS_UNARY_EXPRESSION (_tmp0_) ? ((ValaUnaryExpression*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	unary = _tmp1_;
	_tmp3_ = unary;
	if (_tmp3_ != NULL) {
		ValaUnaryExpression* _tmp4_;
		ValaUnaryOperator _tmp5_;
		ValaUnaryOperator _tmp6_;
		_tmp4_ = unary;
		_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == VALA_UNARY_OPERATOR_MINUS;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaIntegerLiteral* lit = NULL;
		ValaUnaryExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		ValaIntegerLiteral* _tmp10_;
		ValaIntegerLiteral* _tmp11_;
		_tmp7_ = unary;
		_tmp8_ = vala_unary_expression_get_inner (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (VALA_IS_INTEGER_LITERAL (_tmp9_) ? ((ValaIntegerLiteral*) _tmp9_) : NULL);
		lit = _tmp10_;
		_tmp11_ = lit;
		if (_tmp11_ != NULL) {
			ValaIntegerLiteral* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = lit;
			_tmp13_ = vala_integer_literal_get_value (_tmp12_);
			_tmp14_ = _tmp13_;
			result = -atoi (_tmp14_);
			_vala_code_node_unref0 (lit);
			_vala_code_node_unref0 (unary);
			return result;
		}
		_vala_code_node_unref0 (lit);
	} else {
		ValaIntegerLiteral* lit = NULL;
		ValaExpression* _tmp15_;
		ValaIntegerLiteral* _tmp16_;
		ValaIntegerLiteral* _tmp17_;
		_tmp15_ = vala_gir_parser_metadata_get_expression (self, arg);
		_tmp16_ = VALA_IS_INTEGER_LITERAL (_tmp15_) ? ((ValaIntegerLiteral*) _tmp15_) : NULL;
		if (_tmp16_ == NULL) {
			_vala_code_node_unref0 (_tmp15_);
		}
		lit = _tmp16_;
		_tmp17_ = lit;
		if (_tmp17_ != NULL) {
			ValaIntegerLiteral* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = lit;
			_tmp19_ = vala_integer_literal_get_value (_tmp18_);
			_tmp20_ = _tmp19_;
			result = atoi (_tmp20_);
			_vala_code_node_unref0 (lit);
			_vala_code_node_unref0 (unary);
			return result;
		}
		_vala_code_node_unref0 (lit);
	}
	result = 0;
	_vala_code_node_unref0 (unary);
	return result;
}

static gboolean
vala_gir_parser_metadata_get_bool (ValaGirParserMetadata* self,
                                   ValaGirParserArgumentType arg,
                                   gboolean default_value)
{
	ValaBooleanLiteral* lit = NULL;
	ValaExpression* _tmp0_;
	ValaBooleanLiteral* _tmp1_;
	ValaBooleanLiteral* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = VALA_IS_BOOLEAN_LITERAL (_tmp0_) ? ((ValaBooleanLiteral*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	lit = _tmp1_;
	_tmp2_ = lit;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = lit;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		result = _tmp5_;
		_vala_code_node_unref0 (lit);
		return result;
	}
	result = default_value;
	_vala_code_node_unref0 (lit);
	return result;
}

static ValaSourceReference*
vala_gir_parser_metadata_get_source_reference (ValaGirParserMetadata* self,
                                               ValaGirParserArgumentType arg)
{
	ValaGirParserArgument* val = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserArgument* _tmp2_;
	ValaSourceReference* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->args;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) arg));
	val = (ValaGirParserArgument*) _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		ValaGirParserArgument* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		_tmp3_ = val;
		_tmp4_ = _tmp3_->source_reference;
		_tmp5_ = _vala_source_reference_ref0 (_tmp4_);
		result = _tmp5_;
		_vala_gir_parser_argument_unref0 (val);
		return result;
	}
	result = NULL;
	_vala_gir_parser_argument_unref0 (val);
	return result;
}

static void
vala_gir_parser_value_metadata_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_metadata_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_metadata_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_metadata_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_metadata_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_metadata_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_metadata_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserMetadata * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_metadata_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_metadata_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	ValaGirParserMetadata ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_metadata_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_metadata (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	ValaGirParserParamSpecMetadata* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_METADATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_metadata (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_metadata (GValue* value,
                                    gpointer v_object)
{
	ValaGirParserMetadata * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_metadata_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_unref (old);
	}
}

static void
vala_gir_parser_value_take_metadata (GValue* value,
                                     gpointer v_object)
{
	ValaGirParserMetadata * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_unref (old);
	}
}

static void
vala_gir_parser_metadata_class_init (ValaGirParserMetadataClass * klass,
                                     gpointer klass_data)
{
	vala_gir_parser_metadata_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserMetadataClass *) klass)->finalize = vala_gir_parser_metadata_finalize;
}

static void
vala_gir_parser_metadata_instance_init (ValaGirParserMetadata * self,
                                        gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	self->used = FALSE;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE, NULL, NULL, VALA_GIR_PARSER_TYPE_ARGUMENT, (GBoxedCopyFunc) vala_gir_parser_argument_ref, (GDestroyNotify) vala_gir_parser_argument_unref, _tmp0_, _tmp1_, _tmp2_);
	self->args = (ValaMap*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp4_);
	self->children = _tmp5_;
	self->ref_count = 1;
}

static void
vala_gir_parser_metadata_finalize (ValaGirParserMetadata * obj)
{
	ValaGirParserMetadata * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadata);
	g_signal_handlers_destroy (self);
	_g_pattern_spec_free0 (self->pattern_spec);
	_g_free0 (self->selector);
	_vala_source_reference_unref0 (self->source_reference);
	_vala_map_unref0 (self->args);
	_vala_iterable_unref0 (self->children);
}

static GType
vala_gir_parser_metadata_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_metadata_init, vala_gir_parser_value_metadata_free_value, vala_gir_parser_value_metadata_copy_value, vala_gir_parser_value_metadata_peek_pointer, "p", vala_gir_parser_value_metadata_collect_value, "p", vala_gir_parser_value_metadata_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadata), 0, (GInstanceInitFunc) vala_gir_parser_metadata_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_metadata_type_id;
	vala_gir_parser_metadata_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserMetadata", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vala_gir_parser_metadata_type_id;
}

static GType
vala_gir_parser_metadata_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_type_id__once = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_type_id__once)) {
		GType vala_gir_parser_metadata_type_id;
		vala_gir_parser_metadata_type_id = vala_gir_parser_metadata_get_type_once ();
		g_once_init_leave (&vala_gir_parser_metadata_type_id__once, vala_gir_parser_metadata_type_id);
	}
	return vala_gir_parser_metadata_type_id__once;
}

static gpointer
vala_gir_parser_metadata_ref (gpointer instance)
{
	ValaGirParserMetadata * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_metadata_unref (gpointer instance)
{
	ValaGirParserMetadata * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_METADATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
vala_gir_parser_metadata_parser_get_instance_private (ValaGirParserMetadataParser* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGirParserMetadataParser_private_offset);
}

static ValaGirParserMetadataParser*
vala_gir_parser_metadata_parser_construct (GType object_type)
{
	ValaGirParserMetadataParser* self = NULL;
	ValaGirParserMetadata* _tmp0_;
	self = (ValaGirParserMetadataParser*) g_type_create_instance (object_type);
	_tmp0_ = self->priv->tree;
	_tmp0_->used = TRUE;
	return self;
}

static ValaGirParserMetadataParser*
vala_gir_parser_metadata_parser_new (void)
{
	return vala_gir_parser_metadata_parser_construct (VALA_GIR_PARSER_TYPE_METADATA_PARSER);
}

static ValaSourceReference*
vala_gir_parser_metadata_parser_get_current_src (ValaGirParserMetadataParser* self)
{
	ValaScanner* _tmp0_;
	ValaSourceFile* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSourceReference* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = vala_scanner_get_source_file (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->begin;
	_tmp4_ = self->priv->end;
	_tmp5_ = vala_source_reference_new (_tmp2_, &_tmp3_, &_tmp4_);
	result = _tmp5_;
	return result;
}

static ValaSourceReference*
vala_gir_parser_metadata_parser_get_src (ValaGirParserMetadataParser* self,
                                         ValaSourceLocation* begin,
                                         ValaSourceLocation* end)
{
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp0_;
	ValaScanner* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceFile* _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	_tmp0_ = self->priv->end;
	e = _tmp0_;
	if (end != NULL) {
		e = *end;
	}
	_tmp1_ = self->priv->scanner;
	_tmp2_ = vala_scanner_get_source_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = *begin;
	_tmp5_ = e;
	_tmp6_ = vala_source_reference_new (_tmp3_, &_tmp4_, &_tmp5_);
	result = _tmp6_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_parser_parse_metadata (ValaGirParserMetadataParser* self,
                                                ValaSourceFile* metadata_file)
{
	ValaScanner* _tmp0_;
	ValaGirParserMetadata* _tmp4_;
	ValaGirParserMetadata* _tmp5_;
	ValaGirParserMetadata* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (metadata_file != NULL, NULL);
	_tmp0_ = vala_scanner_new (metadata_file);
	_vala_scanner_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp0_;
	vala_gir_parser_metadata_parser_next (self);
	while (TRUE) {
		if (!(self->priv->current != VALA_TOKEN_TYPE_EOF)) {
			break;
		}
		if (!vala_gir_parser_metadata_parser_parse_rule (self)) {
			ValaGirParserMetadata* _tmp1_;
			ValaGirParserMetadata* _tmp2_;
			ValaGirParserMetadata* _tmp3_;
			_tmp1_ = vala_gir_parser_metadata_get_empty ();
			_tmp2_ = _tmp1_;
			_tmp3_ = _vala_gir_parser_metadata_ref0 (_tmp2_);
			result = _tmp3_;
			return result;
		}
	}
	_tmp4_ = self->priv->tree;
	_tmp5_ = _vala_gir_parser_metadata_ref0 (_tmp4_);
	result = _tmp5_;
	return result;
}

static ValaTokenType
vala_gir_parser_metadata_parser_next (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation _tmp0_;
	ValaScanner* _tmp1_;
	ValaSourceLocation _tmp2_ = {0};
	ValaSourceLocation _tmp3_ = {0};
	ValaTokenType _tmp4_;
	ValaTokenType result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->end;
	self->priv->old_end = _tmp0_;
	_tmp1_ = self->priv->scanner;
	_tmp4_ = vala_scanner_read_token (_tmp1_, &_tmp2_, &_tmp3_);
	self->priv->begin = _tmp2_;
	self->priv->end = _tmp3_;
	self->priv->current = _tmp4_;
	result = self->priv->current;
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_has_space (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->old_end;
	_tmp1_ = _tmp0_.pos;
	_tmp2_ = self->priv->begin;
	_tmp3_ = _tmp2_.pos;
	result = _tmp1_ != _tmp3_;
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_has_newline (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation _tmp0_;
	ValaSourceLocation _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->old_end;
	_tmp1_ = self->priv->begin;
	result = _tmp0_.line != _tmp1_.line;
	return result;
}

static gchar*
vala_gir_parser_metadata_parser_get_string (ValaGirParserMetadataParser* self,
                                            ValaSourceLocation* begin,
                                            ValaSourceLocation* end)
{
	ValaSourceLocation b = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceLocation _tmp2_;
	gchar* _tmp3_;
	ValaSourceLocation _tmp4_;
	gchar* _tmp5_;
	ValaSourceLocation _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	b = _tmp0_;
	_tmp1_ = self->priv->end;
	e = _tmp1_;
	if (begin != NULL) {
		b = *begin;
	}
	if (end != NULL) {
		e = *end;
	}
	_tmp2_ = b;
	_tmp3_ = _tmp2_.pos;
	_tmp4_ = e;
	_tmp5_ = _tmp4_.pos;
	_tmp6_ = b;
	_tmp7_ = _tmp6_.pos;
	_tmp8_ = string_substring ((const gchar*) _tmp3_, (glong) 0, (glong) ((gint) (_tmp5_ - _tmp7_)));
	result = _tmp8_;
	return result;
}

static gchar*
vala_gir_parser_metadata_parser_parse_identifier (ValaGirParserMetadataParser* self,
                                                  gboolean is_glob)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaSourceLocation _tmp10_;
	ValaSourceLocation _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	if (self->priv->current == VALA_TOKEN_TYPE_DOT) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->current == VALA_TOKEN_TYPE_HASH;
	}
	if (_tmp1_) {
		if (is_glob) {
			ValaSourceLocation _tmp2_;
			ValaSourceReference* _tmp3_;
			ValaSourceReference* _tmp4_;
			_tmp2_ = begin;
			_tmp3_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp2_, NULL);
			_tmp4_ = _tmp3_;
			vala_report_error (_tmp4_, "expected glob-style pattern");
			_vala_source_reference_unref0 (_tmp4_);
		} else {
			ValaSourceLocation _tmp5_;
			ValaSourceReference* _tmp6_;
			ValaSourceReference* _tmp7_;
			_tmp5_ = begin;
			_tmp6_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp5_, NULL);
			_tmp7_ = _tmp6_;
			vala_report_error (_tmp7_, "expected identifier");
			_vala_source_reference_unref0 (_tmp7_);
		}
		result = NULL;
		return result;
	}
	if (is_glob) {
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			if (self->priv->current != VALA_TOKEN_TYPE_EOF) {
				_tmp9_ = self->priv->current != VALA_TOKEN_TYPE_DOT;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				_tmp8_ = self->priv->current != VALA_TOKEN_TYPE_HASH;
			} else {
				_tmp8_ = FALSE;
			}
			if (!_tmp8_) {
				break;
			}
			vala_gir_parser_metadata_parser_next (self);
			if (vala_gir_parser_metadata_parser_has_space (self)) {
				break;
			}
		}
	} else {
		vala_gir_parser_metadata_parser_next (self);
	}
	_tmp10_ = begin;
	_tmp11_ = self->priv->old_end;
	_tmp12_ = vala_gir_parser_metadata_parser_get_string (self, &_tmp10_, &_tmp11_);
	result = _tmp12_;
	return result;
}

static gchar*
vala_gir_parser_metadata_parser_parse_selector (ValaGirParserMetadataParser* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->current != VALA_TOKEN_TYPE_HASH) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_gir_parser_metadata_parser_has_space (self);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	vala_gir_parser_metadata_parser_next (self);
	_tmp1_ = vala_gir_parser_metadata_parser_parse_identifier (self, FALSE);
	result = _tmp1_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_parser_parse_pattern (ValaGirParserMetadataParser* self)
{
	ValaGirParserMetadata* metadata = NULL;
	gboolean is_relative = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaGirParserMetadata* _tmp6_;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp9_;
	gchar* pattern = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaSourceLocation _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	ValaGirParserMetadata* _tmp18_;
	ValaGirParserMetadata* _tmp19_;
	ValaGirParserMetadata* _tmp20_;
	ValaGirParserMetadata* result;
	g_return_val_if_fail (self != NULL, NULL);
	is_relative = FALSE;
	if (self->priv->current == VALA_TOKEN_TYPE_IDENTIFIER) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->current == VALA_TOKEN_TYPE_STAR;
	}
	if (_tmp0_) {
		ValaGirParserMetadata* _tmp1_;
		ValaGirParserMetadata* _tmp2_;
		_tmp1_ = self->priv->tree;
		_tmp2_ = _vala_gir_parser_metadata_ref0 (_tmp1_);
		_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
		self->priv->parent_metadata = _tmp2_;
	} else {
		if (self->priv->current != VALA_TOKEN_TYPE_DOT) {
			ValaSourceReference* _tmp3_;
			ValaSourceReference* _tmp4_;
			const gchar* _tmp5_;
			_tmp3_ = vala_gir_parser_metadata_parser_get_current_src (self);
			_tmp4_ = _tmp3_;
			_tmp5_ = vala_token_type_to_string (self->priv->current);
			vala_report_error (_tmp4_, "expected pattern or `.', got `%s'", _tmp5_);
			_vala_source_reference_unref0 (_tmp4_);
			result = NULL;
			_vala_gir_parser_metadata_unref0 (metadata);
			return result;
		}
		vala_gir_parser_metadata_parser_next (self);
		is_relative = TRUE;
	}
	_tmp6_ = self->priv->parent_metadata;
	if (_tmp6_ == NULL) {
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		_tmp7_ = vala_gir_parser_metadata_parser_get_current_src (self);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp8_, "cannot determinate parent metadata");
		_vala_source_reference_unref0 (_tmp8_);
		result = NULL;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp9_ = self->priv->begin;
	begin = _tmp9_;
	_tmp10_ = vala_gir_parser_metadata_parser_parse_identifier (self, TRUE);
	pattern = _tmp10_;
	_tmp11_ = pattern;
	if (_tmp11_ == NULL) {
		result = NULL;
		_g_free0 (pattern);
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp12_ = pattern;
	_tmp13_ = vala_gir_parser_metadata_parser_parse_selector (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = begin;
	_tmp16_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_gir_parser_metadata_new (_tmp12_, _tmp14_, _tmp17_);
	_vala_gir_parser_metadata_unref0 (metadata);
	metadata = _tmp18_;
	_vala_source_reference_unref0 (_tmp17_);
	_g_free0 (_tmp14_);
	_tmp19_ = self->priv->parent_metadata;
	_tmp20_ = metadata;
	vala_gir_parser_metadata_add_child (_tmp19_, _tmp20_);
	while (TRUE) {
		gboolean _tmp21_ = FALSE;
		ValaSourceLocation _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		ValaGirParserMetadata* child = NULL;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		ValaSourceLocation _tmp31_;
		ValaSourceLocation _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaSourceReference* _tmp34_;
		ValaGirParserMetadata* _tmp35_;
		ValaGirParserMetadata* _tmp36_;
		ValaGirParserMetadata* _tmp37_;
		ValaGirParserMetadata* _tmp38_;
		ValaGirParserMetadata* _tmp39_;
		ValaGirParserMetadata* _tmp40_;
		if (self->priv->current != VALA_TOKEN_TYPE_EOF) {
			_tmp21_ = !vala_gir_parser_metadata_parser_has_space (self);
		} else {
			_tmp21_ = FALSE;
		}
		if (!_tmp21_) {
			break;
		}
		if (self->priv->current != VALA_TOKEN_TYPE_DOT) {
			ValaSourceReference* _tmp22_;
			ValaSourceReference* _tmp23_;
			const gchar* _tmp24_;
			_tmp22_ = vala_gir_parser_metadata_parser_get_current_src (self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_token_type_to_string (self->priv->current);
			vala_report_error (_tmp23_, "expected `.' got `%s'", _tmp24_);
			_vala_source_reference_unref0 (_tmp23_);
			break;
		}
		vala_gir_parser_metadata_parser_next (self);
		_tmp25_ = self->priv->begin;
		begin = _tmp25_;
		_tmp26_ = vala_gir_parser_metadata_parser_parse_identifier (self, TRUE);
		_g_free0 (pattern);
		pattern = _tmp26_;
		_tmp27_ = pattern;
		if (_tmp27_ == NULL) {
			result = NULL;
			_g_free0 (pattern);
			_vala_gir_parser_metadata_unref0 (metadata);
			return result;
		}
		_tmp28_ = pattern;
		_tmp29_ = vala_gir_parser_metadata_parser_parse_selector (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = begin;
		_tmp32_ = self->priv->old_end;
		_tmp33_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp31_, &_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_gir_parser_metadata_new (_tmp28_, _tmp30_, _tmp34_);
		_tmp36_ = _tmp35_;
		_vala_source_reference_unref0 (_tmp34_);
		_g_free0 (_tmp30_);
		child = _tmp36_;
		_tmp37_ = metadata;
		_tmp38_ = child;
		vala_gir_parser_metadata_add_child (_tmp37_, _tmp38_);
		_tmp39_ = child;
		_tmp40_ = _vala_gir_parser_metadata_ref0 (_tmp39_);
		_vala_gir_parser_metadata_unref0 (metadata);
		metadata = _tmp40_;
		_vala_gir_parser_metadata_unref0 (child);
	}
	if (!is_relative) {
		ValaGirParserMetadata* _tmp41_;
		ValaGirParserMetadata* _tmp42_;
		_tmp41_ = metadata;
		_tmp42_ = _vala_gir_parser_metadata_ref0 (_tmp41_);
		_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
		self->priv->parent_metadata = _tmp42_;
	}
	result = metadata;
	_g_free0 (pattern);
	return result;
}

static ValaExpression*
vala_gir_parser_metadata_parser_parse_expression (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceReference* src = NULL;
	ValaSourceReference* _tmp1_;
	ValaExpression* expr = NULL;
	ValaExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_tmp1_ = vala_gir_parser_metadata_parser_get_current_src (self);
	src = _tmp1_;
	expr = NULL;
	switch (self->priv->current) {
		case VALA_TOKEN_TYPE_NULL:
		{
			ValaSourceReference* _tmp2_;
			ValaNullLiteral* _tmp3_;
			_tmp2_ = src;
			_tmp3_ = vala_null_literal_new (_tmp2_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp3_;
			break;
		}
		case VALA_TOKEN_TYPE_TRUE:
		{
			ValaSourceReference* _tmp4_;
			ValaBooleanLiteral* _tmp5_;
			_tmp4_ = src;
			_tmp5_ = vala_boolean_literal_new (TRUE, _tmp4_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp5_;
			break;
		}
		case VALA_TOKEN_TYPE_FALSE:
		{
			ValaSourceReference* _tmp6_;
			ValaBooleanLiteral* _tmp7_;
			_tmp6_ = src;
			_tmp7_ = vala_boolean_literal_new (FALSE, _tmp6_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp7_;
			break;
		}
		case VALA_TOKEN_TYPE_MINUS:
		{
			ValaExpression* inner = NULL;
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			vala_gir_parser_metadata_parser_next (self);
			_tmp8_ = vala_gir_parser_metadata_parser_parse_expression (self);
			inner = _tmp8_;
			_tmp9_ = inner;
			if (_tmp9_ == NULL) {
				ValaSourceReference* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = src;
				_tmp11_ = vala_token_type_to_string (self->priv->current);
				vala_report_error (_tmp10_, "expected expression after `-', got `%s'", _tmp11_);
			} else {
				ValaExpression* _tmp12_;
				ValaSourceLocation _tmp13_;
				ValaSourceReference* _tmp14_;
				ValaSourceReference* _tmp15_;
				ValaUnaryExpression* _tmp16_;
				_tmp12_ = inner;
				_tmp13_ = begin;
				_tmp14_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp13_, NULL);
				_tmp15_ = _tmp14_;
				_tmp16_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_MINUS, _tmp12_, _tmp15_);
				_vala_code_node_unref0 (expr);
				expr = (ValaExpression*) _tmp16_;
				_vala_source_reference_unref0 (_tmp15_);
			}
			result = expr;
			_vala_code_node_unref0 (inner);
			_vala_source_reference_unref0 (src);
			return result;
		}
		case VALA_TOKEN_TYPE_INTEGER_LITERAL:
		{
			gchar* _tmp17_;
			gchar* _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaIntegerLiteral* _tmp20_;
			_tmp17_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp18_ = _tmp17_;
			_tmp19_ = src;
			_tmp20_ = vala_integer_literal_new (_tmp18_, _tmp19_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp20_;
			_g_free0 (_tmp18_);
			break;
		}
		case VALA_TOKEN_TYPE_REAL_LITERAL:
		{
			gchar* _tmp21_;
			gchar* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaRealLiteral* _tmp24_;
			_tmp21_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = src;
			_tmp24_ = vala_real_literal_new (_tmp22_, _tmp23_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp24_;
			_g_free0 (_tmp22_);
			break;
		}
		case VALA_TOKEN_TYPE_STRING_LITERAL:
		{
			gchar* _tmp25_;
			gchar* _tmp26_;
			ValaSourceReference* _tmp27_;
			ValaStringLiteral* _tmp28_;
			_tmp25_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = src;
			_tmp28_ = vala_string_literal_new (_tmp26_, _tmp27_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp28_;
			_g_free0 (_tmp26_);
			break;
		}
		case VALA_TOKEN_TYPE_IDENTIFIER:
		{
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaSourceReference* _tmp31_;
			ValaMemberAccess* _tmp32_;
			_tmp29_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp30_ = _tmp29_;
			_tmp31_ = src;
			_tmp32_ = vala_member_access_new (NULL, _tmp30_, _tmp31_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp32_;
			_g_free0 (_tmp30_);
			while (TRUE) {
				ValaExpression* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				ValaSourceReference* _tmp39_;
				ValaSourceReference* _tmp40_;
				ValaMemberAccess* _tmp41_;
				if (!(vala_gir_parser_metadata_parser_next (self) == VALA_TOKEN_TYPE_DOT)) {
					break;
				}
				if (vala_gir_parser_metadata_parser_next (self) != VALA_TOKEN_TYPE_IDENTIFIER) {
					ValaSourceReference* _tmp33_;
					ValaSourceReference* _tmp34_;
					const gchar* _tmp35_;
					_tmp33_ = vala_gir_parser_metadata_parser_get_current_src (self);
					_tmp34_ = _tmp33_;
					_tmp35_ = vala_token_type_to_string (self->priv->current);
					vala_report_error (_tmp34_, "expected identifier got `%s'", _tmp35_);
					_vala_source_reference_unref0 (_tmp34_);
					break;
				}
				_tmp36_ = expr;
				_tmp37_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_gir_parser_metadata_parser_get_current_src (self);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_member_access_new (_tmp36_, _tmp38_, _tmp40_);
				_vala_code_node_unref0 (expr);
				expr = (ValaExpression*) _tmp41_;
				_vala_source_reference_unref0 (_tmp40_);
				_g_free0 (_tmp38_);
			}
			result = expr;
			_vala_source_reference_unref0 (src);
			return result;
		}
		case VALA_TOKEN_TYPE_OPEN_PARENS:
		{
			ValaSourceReference* _tmp45_;
			ValaTuple* _tmp46_;
			if (vala_gir_parser_metadata_parser_next (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				const gchar* _tmp44_;
				_tmp42_ = vala_gir_parser_metadata_parser_get_current_src (self);
				_tmp43_ = _tmp42_;
				_tmp44_ = vala_token_type_to_string (self->priv->current);
				vala_report_error (_tmp43_, "expected `)', got `%s'", _tmp44_);
				_vala_source_reference_unref0 (_tmp43_);
				break;
			}
			_tmp45_ = src;
			_tmp46_ = vala_tuple_new (_tmp45_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp46_;
			break;
		}
		default:
		{
			ValaSourceReference* _tmp47_;
			const gchar* _tmp48_;
			_tmp47_ = src;
			_tmp48_ = vala_token_type_to_string (self->priv->current);
			vala_report_error (_tmp47_, "expected literal or symbol got %s", _tmp48_);
			break;
		}
	}
	vala_gir_parser_metadata_parser_next (self);
	result = expr;
	_vala_source_reference_unref0 (src);
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_parse_args (ValaGirParserMetadataParser* self,
                                            ValaGirParserMetadata* metadata)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (metadata != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		ValaSourceLocation begin = {0};
		ValaSourceLocation _tmp2_;
		gchar* id = NULL;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		ValaGirParserArgumentType* arg_type = NULL;
		const gchar* _tmp5_;
		ValaGirParserArgumentType* _tmp6_;
		ValaGirParserArgumentType* _tmp7_;
		ValaExpression* expr = NULL;
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		ValaGirParserArgumentType* _tmp26_;
		ValaExpression* _tmp27_;
		ValaSourceLocation _tmp28_;
		ValaSourceReference* _tmp29_;
		ValaSourceReference* _tmp30_;
		ValaGirParserArgument* _tmp31_;
		ValaGirParserArgument* _tmp32_;
		if (self->priv->current != VALA_TOKEN_TYPE_EOF) {
			_tmp1_ = vala_gir_parser_metadata_parser_has_space (self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = !vala_gir_parser_metadata_parser_has_newline (self);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp2_ = self->priv->begin;
		begin = _tmp2_;
		_tmp3_ = vala_gir_parser_metadata_parser_parse_identifier (self, FALSE);
		id = _tmp3_;
		_tmp4_ = id;
		if (_tmp4_ == NULL) {
			result = FALSE;
			_g_free0 (id);
			return result;
		}
		_tmp5_ = id;
		_tmp6_ = vala_gir_parser_argument_type_from_string (_tmp5_);
		arg_type = _tmp6_;
		_tmp7_ = arg_type;
		if (_tmp7_ == NULL) {
			ValaSourceLocation _tmp8_;
			ValaSourceLocation _tmp9_;
			ValaSourceReference* _tmp10_;
			ValaSourceReference* _tmp11_;
			const gchar* _tmp12_;
			_tmp8_ = begin;
			_tmp9_ = self->priv->old_end;
			_tmp10_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp8_, &_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = id;
			vala_report_warning (_tmp11_, "unknown argument `%s'", _tmp12_);
			_vala_source_reference_unref0 (_tmp11_);
			_g_free0 (arg_type);
			_g_free0 (id);
			continue;
		}
		if (self->priv->current != VALA_TOKEN_TYPE_ASSIGN) {
			ValaGirParserArgumentType* _tmp13_;
			ValaSourceLocation _tmp14_;
			ValaSourceReference* _tmp15_;
			ValaSourceReference* _tmp16_;
			ValaBooleanLiteral* _tmp17_;
			ValaBooleanLiteral* _tmp18_;
			ValaSourceLocation _tmp19_;
			ValaSourceReference* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaGirParserArgument* _tmp22_;
			ValaGirParserArgument* _tmp23_;
			_tmp13_ = arg_type;
			_tmp14_ = begin;
			_tmp15_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp14_, NULL);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_boolean_literal_new (TRUE, _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = begin;
			_tmp20_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp19_, NULL);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_gir_parser_argument_new ((ValaExpression*) _tmp18_, _tmp21_);
			_tmp23_ = _tmp22_;
			vala_gir_parser_metadata_add_argument (metadata, *_tmp13_, _tmp23_);
			_vala_gir_parser_argument_unref0 (_tmp23_);
			_vala_source_reference_unref0 (_tmp21_);
			_vala_code_node_unref0 (_tmp18_);
			_vala_source_reference_unref0 (_tmp16_);
			_g_free0 (arg_type);
			_g_free0 (id);
			continue;
		}
		vala_gir_parser_metadata_parser_next (self);
		_tmp24_ = vala_gir_parser_metadata_parser_parse_expression (self);
		expr = _tmp24_;
		_tmp25_ = expr;
		if (_tmp25_ == NULL) {
			result = FALSE;
			_vala_code_node_unref0 (expr);
			_g_free0 (arg_type);
			_g_free0 (id);
			return result;
		}
		_tmp26_ = arg_type;
		_tmp27_ = expr;
		_tmp28_ = begin;
		_tmp29_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp28_, NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_gir_parser_argument_new (_tmp27_, _tmp30_);
		_tmp32_ = _tmp31_;
		vala_gir_parser_metadata_add_argument (metadata, *_tmp26_, _tmp32_);
		_vala_gir_parser_argument_unref0 (_tmp32_);
		_vala_source_reference_unref0 (_tmp30_);
		_vala_code_node_unref0 (expr);
		_g_free0 (arg_type);
		_g_free0 (id);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_parse_rule (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation old_end = {0};
	ValaSourceLocation _tmp0_;
	ValaGirParserMetadata* metadata = NULL;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaGirParserMetadata* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->end;
	old_end = _tmp0_;
	_tmp1_ = vala_gir_parser_metadata_parser_parse_pattern (self);
	metadata = _tmp1_;
	_tmp2_ = metadata;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	if (self->priv->current == VALA_TOKEN_TYPE_EOF) {
		_tmp3_ = TRUE;
	} else {
		ValaSourceLocation _tmp4_;
		ValaSourceLocation _tmp5_;
		_tmp4_ = old_end;
		_tmp5_ = self->priv->end;
		_tmp3_ = _tmp4_.line != _tmp5_.line;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp6_ = metadata;
	result = vala_gir_parser_metadata_parser_parse_args (self, _tmp6_);
	_vala_gir_parser_metadata_unref0 (metadata);
	return result;
}

static void
vala_gir_parser_value_metadata_parser_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_metadata_parser_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_metadata_parser_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_metadata_parser_copy_value (const GValue* src_value,
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_metadata_parser_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_metadata_parser_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_metadata_parser_collect_value (GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserMetadataParser * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_metadata_parser_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_metadata_parser_lcopy_value (const GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	ValaGirParserMetadataParser ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_metadata_parser_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_metadata_parser (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags)
{
	ValaGirParserParamSpecMetadataParser* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_METADATA_PARSER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_metadata_parser (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_metadata_parser (GValue* value,
                                           gpointer v_object)
{
	ValaGirParserMetadataParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_metadata_parser_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_parser_unref (old);
	}
}

static void
vala_gir_parser_value_take_metadata_parser (GValue* value,
                                            gpointer v_object)
{
	ValaGirParserMetadataParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_parser_unref (old);
	}
}

static void
vala_gir_parser_metadata_parser_class_init (ValaGirParserMetadataParserClass * klass,
                                            gpointer klass_data)
{
	vala_gir_parser_metadata_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserMetadataParserClass *) klass)->finalize = vala_gir_parser_metadata_parser_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGirParserMetadataParser_private_offset);
}

static void
vala_gir_parser_metadata_parser_instance_init (ValaGirParserMetadataParser * self,
                                               gpointer klass)
{
	ValaGirParserMetadata* _tmp0_;
	self->priv = vala_gir_parser_metadata_parser_get_instance_private (self);
	_tmp0_ = vala_gir_parser_metadata_new ("", NULL, NULL);
	self->priv->tree = _tmp0_;
	self->ref_count = 1;
}

static void
vala_gir_parser_metadata_parser_finalize (ValaGirParserMetadataParser * obj)
{
	ValaGirParserMetadataParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParser);
	g_signal_handlers_destroy (self);
	_vala_gir_parser_metadata_unref0 (self->priv->tree);
	_vala_scanner_unref0 (self->priv->scanner);
	_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
}

static GType
vala_gir_parser_metadata_parser_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_metadata_parser_init, vala_gir_parser_value_metadata_parser_free_value, vala_gir_parser_value_metadata_parser_copy_value, vala_gir_parser_value_metadata_parser_peek_pointer, "p", vala_gir_parser_value_metadata_parser_collect_value, "p", vala_gir_parser_value_metadata_parser_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadataParser), 0, (GInstanceInitFunc) vala_gir_parser_metadata_parser_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_metadata_parser_type_id;
	vala_gir_parser_metadata_parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserMetadataParser", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaGirParserMetadataParser_private_offset = g_type_add_instance_private (vala_gir_parser_metadata_parser_type_id, sizeof (ValaGirParserMetadataParserPrivate));
	return vala_gir_parser_metadata_parser_type_id;
}

static GType
vala_gir_parser_metadata_parser_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_parser_type_id__once = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_parser_type_id__once)) {
		GType vala_gir_parser_metadata_parser_type_id;
		vala_gir_parser_metadata_parser_type_id = vala_gir_parser_metadata_parser_get_type_once ();
		g_once_init_leave (&vala_gir_parser_metadata_parser_type_id__once, vala_gir_parser_metadata_parser_type_id);
	}
	return vala_gir_parser_metadata_parser_type_id__once;
}

static gpointer
vala_gir_parser_metadata_parser_ref (gpointer instance)
{
	ValaGirParserMetadataParser * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_metadata_parser_unref (gpointer instance)
{
	ValaGirParserMetadataParser * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_METADATA_PARSER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static ValaGirParserNode*
vala_gir_parser_node_construct (GType object_type,
                                const gchar* name)
{
	ValaGirParserNode* self = NULL;
	gchar* _tmp0_;
	self = (ValaGirParserNode*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	return self;
}

static ValaGirParserNode*
vala_gir_parser_node_new (const gchar* name)
{
	return vala_gir_parser_node_construct (VALA_GIR_PARSER_TYPE_NODE, name);
}

static void
vala_gir_parser_node_add_member (ValaGirParserNode* self,
                                 ValaGirParserNode* node)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp9_;
	ValaArrayList* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->scope;
	_tmp1_ = node->name;
	_tmp2_ = vala_map_get ((ValaMap*) _tmp0_, _tmp1_);
	nodes = (ValaArrayList*) _tmp2_;
	_tmp3_ = nodes;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		ValaHashMap* _tmp6_;
		const gchar* _tmp7_;
		ValaArrayList* _tmp8_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp4_);
		_vala_iterable_unref0 (nodes);
		nodes = _tmp5_;
		_tmp6_ = self->scope;
		_tmp7_ = node->name;
		_tmp8_ = nodes;
		vala_map_set ((ValaMap*) _tmp6_, _tmp7_, _tmp8_);
	}
	_tmp9_ = nodes;
	vala_collection_add ((ValaCollection*) _tmp9_, node);
	_tmp10_ = self->members;
	vala_collection_add ((ValaCollection*) _tmp10_, node);
	node->parent = self;
	_vala_iterable_unref0 (nodes);
}

static void
vala_gir_parser_node_remove_member (ValaGirParserNode* self,
                                    ValaGirParserNode* node)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ValaArrayList* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->scope;
	_tmp1_ = node->name;
	_tmp2_ = vala_map_get ((ValaMap*) _tmp0_, _tmp1_);
	nodes = (ValaArrayList*) _tmp2_;
	_tmp3_ = nodes;
	vala_collection_remove ((ValaCollection*) _tmp3_, node);
	_tmp4_ = nodes;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 0) {
		ValaHashMap* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->scope;
		_tmp8_ = node->name;
		vala_map_remove ((ValaMap*) _tmp7_, _tmp8_);
	}
	_tmp9_ = self->members;
	vala_collection_remove ((ValaCollection*) _tmp9_, node);
	node->parent = NULL;
	_vala_iterable_unref0 (nodes);
}

static ValaGirParserNode*
vala_gir_parser_node_lookup (ValaGirParserNode* self,
                             const gchar* name,
                             gboolean create_namespace,
                             ValaSourceReference* source_reference)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserNode* node = NULL;
	ValaArrayList* _tmp2_;
	ValaGirParserNode* _tmp5_;
	ValaGirParserNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->scope;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, name);
	nodes = (ValaArrayList*) _tmp1_;
	node = NULL;
	_tmp2_ = nodes;
	if (_tmp2_ != NULL) {
		ValaArrayList* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = nodes;
		_tmp4_ = vala_list_get ((ValaList*) _tmp3_, 0);
		_vala_gir_parser_node_unref0 (node);
		node = (ValaGirParserNode*) _tmp4_;
	}
	_tmp5_ = node;
	if (_tmp5_ == NULL) {
		ValaSymbol* sym = NULL;
		ValaSymbol* _tmp6_;
		gboolean _tmp11_ = FALSE;
		ValaSymbol* _tmp12_;
		sym = NULL;
		_tmp6_ = self->symbol;
		if (_tmp6_ != NULL) {
			ValaSymbol* _tmp7_;
			ValaScope* _tmp8_;
			ValaScope* _tmp9_;
			ValaSymbol* _tmp10_;
			_tmp7_ = self->symbol;
			_tmp8_ = vala_symbol_get_scope (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_scope_lookup (_tmp9_, name);
			_vala_code_node_unref0 (sym);
			sym = _tmp10_;
		}
		_tmp12_ = sym;
		if (_tmp12_ != NULL) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = create_namespace;
		}
		if (_tmp11_) {
			ValaGirParserNode* _tmp13_;
			ValaGirParserNode* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaGirParserNode* _tmp17_;
			ValaGirParserNode* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaGirParserNode* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaGirParserNode* _tmp22_;
			ValaSymbol* _tmp23_;
			_tmp13_ = vala_gir_parser_node_new (name);
			_vala_gir_parser_node_unref0 (node);
			node = _tmp13_;
			_tmp14_ = node;
			_tmp15_ = sym;
			_tmp16_ = _vala_code_node_ref0 (_tmp15_);
			_vala_code_node_unref0 (_tmp14_->symbol);
			_tmp14_->symbol = _tmp16_;
			_tmp17_ = node;
			_tmp18_ = node;
			_tmp19_ = _tmp18_->symbol;
			_tmp17_->new_symbol = _tmp19_ == NULL;
			_tmp20_ = node;
			_tmp21_ = _vala_source_reference_ref0 (source_reference);
			_vala_source_reference_unref0 (_tmp20_->source_reference);
			_tmp20_->source_reference = _tmp21_;
			_tmp22_ = node;
			vala_gir_parser_node_add_member (self, _tmp22_);
			_tmp23_ = sym;
			if (_tmp23_ == NULL) {
				ValaArrayList* _tmp24_;
				ValaGirParserNode* _tmp25_;
				_tmp24_ = vala_gir_parser_node_new_namespaces;
				_tmp25_ = node;
				vala_collection_add ((ValaCollection*) _tmp24_, _tmp25_);
			}
		}
		_vala_code_node_unref0 (sym);
	}
	result = node;
	_vala_iterable_unref0 (nodes);
	return result;
}

static ValaArrayList*
vala_gir_parser_node_lookup_all (ValaGirParserNode* self,
                                 const gchar* name)
{
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	ValaArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->scope;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, name);
	result = (ValaArrayList*) _tmp1_;
	return result;
}

static ValaUnresolvedSymbol*
vala_gir_parser_node_get_unresolved_symbol (ValaGirParserNode* self)
{
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp1_;
	ValaUnresolvedSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = _tmp0_->name;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		ValaUnresolvedSymbol* _tmp3_;
		_tmp2_ = self->name;
		_tmp3_ = vala_unresolved_symbol_new (NULL, _tmp2_, NULL);
		result = _tmp3_;
		return result;
	} else {
		ValaGirParserNode* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		const gchar* _tmp7_;
		ValaUnresolvedSymbol* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_get_unresolved_symbol (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = vala_unresolved_symbol_new (_tmp6_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_vala_code_node_unref0 (_tmp6_);
		result = _tmp9_;
		return result;
	}
}

static gchar*
vala_gir_parser_node_get_full_name (ValaGirParserNode* self)
{
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp3_;
	ValaGirParserNode* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	ValaGirParserNode* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->name;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->name;
	if (_tmp3_ == NULL) {
		ValaGirParserNode* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_get_full_name (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = self->parent;
	_tmp7_ = vala_gir_parser_node_get_full_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ == NULL;
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = self->name;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	}
	_tmp12_ = self->parent;
	_tmp13_ = vala_gir_parser_node_get_full_name (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->name;
	_tmp16_ = g_strdup_printf ("%s.%s", _tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp14_);
	result = _tmp17_;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_gir_name (ValaGirParserNode* self)
{
	GString* default_name = NULL;
	GString* _tmp0_;
	GString* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	default_name = _tmp0_;
	{
		ValaGirParserNode* node = NULL;
		node = self;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ValaGirParserNode* _tmp4_;
				ValaGirParserNode* _tmp5_;
				ValaSymbol* _tmp6_;
				GString* _tmp9_;
				ValaGirParserNode* _tmp10_;
				const gchar* _tmp11_;
				if (!_tmp1_) {
					ValaGirParserNode* _tmp2_;
					ValaGirParserNode* _tmp3_;
					_tmp2_ = node;
					_tmp3_ = _tmp2_->parent;
					node = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = node;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = node;
				_tmp6_ = _tmp5_->symbol;
				if (VALA_IS_NAMESPACE (_tmp6_)) {
					ValaGirParserNode* _tmp7_;
					ValaSymbol* _tmp8_;
					_tmp7_ = node;
					_tmp8_ = _tmp7_->symbol;
					if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp8_, "CCode", "gir_namespace")) {
						break;
					}
				}
				_tmp9_ = default_name;
				_tmp10_ = node;
				_tmp11_ = _tmp10_->name;
				g_string_prepend (_tmp9_, _tmp11_);
			}
		}
	}
	_tmp12_ = default_name;
	_tmp13_ = _tmp12_->str;
	_tmp14_ = g_strdup (_tmp13_);
	result = _tmp14_;
	_g_string_free0 (default_name);
	return result;
}

static gchar*
vala_gir_parser_node_get_gir_name (ValaGirParserNode* self)
{
	gchar* gir_name = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->girdata;
	_tmp1_ = vala_map_get (_tmp0_, "name");
	gir_name = (gchar*) _tmp1_;
	_tmp2_ = gir_name;
	if (_tmp2_ == NULL) {
		ValaMap* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = self->girdata;
		_tmp4_ = vala_map_get (_tmp3_, "glib:name");
		_g_free0 (gir_name);
		gir_name = (gchar*) _tmp4_;
	}
	result = gir_name;
	return result;
}

static gchar*
vala_gir_parser_node_get_lower_case_cprefix (ValaGirParserNode* self)
{
	const gchar* _tmp0_;
	gchar* prefix = NULL;
	ValaSymbol* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	const gchar* _tmp46_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->symbol;
	_tmp3_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp2_, "CCode", "lower_case_cprefix", NULL);
	prefix = _tmp3_;
	_tmp5_ = prefix;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		_tmp7_ = self->symbol;
		if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp7_)) {
			_tmp6_ = TRUE;
		} else {
			ValaSymbol* _tmp8_;
			_tmp8_ = self->symbol;
			_tmp6_ = VALA_IS_STRUCT (_tmp8_);
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaGirParserMetadata* _tmp9_;
		_tmp9_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp9_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX)) {
			ValaGirParserMetadata* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = self->metadata;
			_tmp11_ = vala_gir_parser_metadata_get_string (_tmp10_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX);
			_g_free0 (prefix);
			prefix = _tmp11_;
		} else {
			ValaGirParserMetadata* _tmp12_;
			_tmp12_ = self->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
				ValaGirParserMetadata* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = self->metadata;
				_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
				_g_free0 (prefix);
				prefix = _tmp14_;
			} else {
				ValaSymbol* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = self->symbol;
				_tmp16_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp15_, "CCode", "cprefix", NULL);
				_g_free0 (prefix);
				prefix = _tmp16_;
			}
		}
	}
	_tmp19_ = prefix;
	if (_tmp19_ == NULL) {
		ValaMap* _tmp20_;
		_tmp20_ = self->girdata;
		_tmp18_ = _tmp20_ != NULL;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gboolean _tmp21_ = FALSE;
		ValaMap* _tmp22_;
		_tmp22_ = self->girdata;
		if (vala_map_contains (_tmp22_, "c:symbol-prefix")) {
			_tmp21_ = TRUE;
		} else {
			ValaMap* _tmp23_;
			_tmp23_ = self->girdata;
			_tmp21_ = vala_map_contains (_tmp23_, "c:symbol-prefixes");
		}
		_tmp17_ = _tmp21_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		ValaGirParserNode* cur = NULL;
		cur = self;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				ValaGirParserNode* _tmp26_;
				ValaMap* _tmp27_;
				ValaGirParserNode* _tmp44_;
				ValaGirParserNode* _tmp45_;
				if (!_tmp24_) {
					ValaGirParserNode* _tmp25_;
					_tmp25_ = cur;
					if (!(_tmp25_ != NULL)) {
						break;
					}
				}
				_tmp24_ = FALSE;
				_tmp26_ = cur;
				_tmp27_ = _tmp26_->girdata;
				if (_tmp27_ != NULL) {
					gchar* p = NULL;
					ValaGirParserNode* _tmp28_;
					ValaMap* _tmp29_;
					gpointer _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp39_;
					_tmp28_ = cur;
					_tmp29_ = _tmp28_->girdata;
					_tmp30_ = vala_map_get (_tmp29_, "c:symbol-prefix");
					p = (gchar*) _tmp30_;
					_tmp31_ = p;
					if (_tmp31_ == NULL) {
						ValaGirParserNode* _tmp32_;
						ValaMap* _tmp33_;
						gpointer _tmp34_;
						const gchar* _tmp35_;
						_tmp32_ = cur;
						_tmp33_ = _tmp32_->girdata;
						_tmp34_ = vala_map_get (_tmp33_, "c:symbol-prefixes");
						_g_free0 (p);
						p = (gchar*) _tmp34_;
						_tmp35_ = p;
						if (_tmp35_ != NULL) {
							gint idx = 0;
							const gchar* _tmp36_;
							_tmp36_ = p;
							idx = string_index_of (_tmp36_, ",", 0);
							if (idx >= 0) {
								const gchar* _tmp37_;
								gchar* _tmp38_;
								_tmp37_ = p;
								_tmp38_ = string_substring (_tmp37_, (glong) 0, (glong) idx);
								_g_free0 (p);
								p = _tmp38_;
							}
						}
					}
					_tmp39_ = p;
					if (_tmp39_ != NULL) {
						const gchar* _tmp40_ = NULL;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
						gchar* _tmp43_;
						_tmp41_ = prefix;
						_tmp40_ = _tmp41_;
						if (_tmp40_ == NULL) {
							_tmp40_ = "";
						}
						_tmp42_ = p;
						_tmp43_ = g_strdup_printf ("%s_%s", _tmp42_, _tmp40_);
						_g_free0 (prefix);
						prefix = _tmp43_;
					}
					_g_free0 (p);
				}
				_tmp44_ = cur;
				_tmp45_ = _tmp44_->parent;
				cur = _tmp45_;
			}
		}
	}
	_tmp46_ = prefix;
	if (_tmp46_ == NULL) {
		gchar* _tmp47_;
		_tmp47_ = vala_gir_parser_node_get_default_lower_case_cprefix (self);
		_g_free0 (prefix);
		prefix = _tmp47_;
	}
	result = prefix;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_lower_case_cprefix (ValaGirParserNode* self)
{
	ValaGirParserNode* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_parser_node_get_lower_case_csuffix (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s%s_", _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

static gchar*
vala_gir_parser_node_get_lower_case_csuffix (ValaGirParserNode* self)
{
	gchar* suffix = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp16_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "lower_case_csuffix", NULL);
	suffix = _tmp1_;
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX);
		_g_free0 (suffix);
		suffix = _tmp4_;
	}
	_tmp8_ = suffix;
	if (_tmp8_ == NULL) {
		ValaMap* _tmp9_;
		_tmp9_ = self->girdata;
		_tmp7_ = _tmp9_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaMap* _tmp10_;
		gpointer _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = self->girdata;
		_tmp11_ = vala_map_get (_tmp10_, "c:symbol-prefix");
		_tmp12_ = (gchar*) _tmp11_;
		_tmp6_ = _tmp12_ != NULL;
		_g_free0 (_tmp12_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaGirParserMetadata* _tmp13_;
		_tmp13_ = self->metadata;
		_tmp5_ = !vala_gir_parser_metadata_has_argument (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaMap* _tmp14_;
		gpointer _tmp15_;
		_tmp14_ = self->girdata;
		_tmp15_ = vala_map_get (_tmp14_, "c:symbol-prefix");
		_g_free0 (suffix);
		suffix = (gchar*) _tmp15_;
	}
	_tmp16_ = suffix;
	if (_tmp16_ == NULL) {
		gchar* _tmp17_;
		_tmp17_ = vala_gir_parser_node_get_default_lower_case_csuffix (self);
		_g_free0 (suffix);
		suffix = _tmp17_;
	}
	result = suffix;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_lower_case_csuffix (ValaGirParserNode* self)
{
	gchar* csuffix = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp16_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = vala_symbol_camel_case_to_lower_case (_tmp0_);
	csuffix = _tmp1_;
	_tmp2_ = csuffix;
	if (g_str_has_prefix (_tmp2_, "type_")) {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = csuffix;
		_tmp4_ = strlen ("type_");
		_tmp5_ = _tmp4_;
		_tmp6_ = string_substring (_tmp3_, (glong) _tmp5_, (glong) -1);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("type", _tmp7_, NULL);
		_g_free0 (csuffix);
		csuffix = _tmp8_;
		_g_free0 (_tmp7_);
	} else {
		const gchar* _tmp9_;
		_tmp9_ = csuffix;
		if (g_str_has_prefix (_tmp9_, "is_")) {
			const gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp10_ = csuffix;
			_tmp11_ = strlen ("is_");
			_tmp12_ = _tmp11_;
			_tmp13_ = string_substring (_tmp10_, (glong) _tmp12_, (glong) -1);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat ("is", _tmp14_, NULL);
			_g_free0 (csuffix);
			csuffix = _tmp15_;
			_g_free0 (_tmp14_);
		}
	}
	_tmp16_ = csuffix;
	if (g_str_has_suffix (_tmp16_, "_class")) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp17_ = csuffix;
		_tmp18_ = csuffix;
		_tmp19_ = strlen (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = strlen ("_class");
		_tmp22_ = _tmp21_;
		_tmp23_ = string_substring (_tmp17_, (glong) 0, (glong) (_tmp20_ - _tmp22_));
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp24_, "class", NULL);
		_g_free0 (csuffix);
		csuffix = _tmp25_;
		_g_free0 (_tmp24_);
	}
	result = csuffix;
	return result;
}

static gchar*
vala_gir_parser_node_get_cprefix (ValaGirParserNode* self)
{
	const gchar* _tmp0_;
	gchar* prefix = NULL;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp19_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_g_free0 (prefix);
		prefix = _tmp4_;
	} else {
		ValaSymbol* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->symbol;
		_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp5_, "CCode", "cprefix", NULL);
		_g_free0 (prefix);
		prefix = _tmp6_;
	}
	_tmp9_ = prefix;
	if (_tmp9_ == NULL) {
		ValaMap* _tmp10_;
		_tmp10_ = self->girdata;
		_tmp8_ = _tmp10_ != NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaMap* _tmp11_;
		gpointer _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = self->girdata;
		_tmp12_ = vala_map_get (_tmp11_, "c:identifier-prefixes");
		_tmp13_ = (gchar*) _tmp12_;
		_tmp7_ = _tmp13_ != NULL;
		_g_free0 (_tmp13_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaMap* _tmp14_;
		gpointer _tmp15_;
		gint idx = 0;
		const gchar* _tmp16_;
		_tmp14_ = self->girdata;
		_tmp15_ = vala_map_get (_tmp14_, "c:identifier-prefixes");
		_g_free0 (prefix);
		prefix = (gchar*) _tmp15_;
		_tmp16_ = prefix;
		idx = string_index_of (_tmp16_, ",", 0);
		if (idx != -1) {
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = prefix;
			_tmp18_ = string_substring (_tmp17_, (glong) 0, (glong) idx);
			_g_free0 (prefix);
			prefix = _tmp18_;
		}
	}
	_tmp19_ = prefix;
	if (_tmp19_ == NULL) {
		gboolean _tmp20_ = FALSE;
		ValaSymbol* _tmp21_;
		_tmp21_ = self->symbol;
		if (VALA_IS_ENUM (_tmp21_)) {
			_tmp20_ = TRUE;
		} else {
			ValaSymbol* _tmp22_;
			_tmp22_ = self->symbol;
			_tmp20_ = VALA_IS_ERROR_DOMAIN (_tmp22_);
		}
		if (_tmp20_) {
			ValaGirParserNode* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp23_ = self->parent;
			_tmp24_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_ascii_strup (_tmp25_, (gssize) -1);
			_tmp27_ = _tmp26_;
			_tmp28_ = self->name;
			_tmp29_ = g_strdup_printf ("%s%s", _tmp27_, _tmp28_);
			_g_free0 (prefix);
			prefix = _tmp29_;
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
		} else {
			gchar* _tmp30_;
			_tmp30_ = vala_gir_parser_node_get_cname (self);
			_g_free0 (prefix);
			prefix = _tmp30_;
		}
	}
	result = prefix;
	return result;
}

static gchar*
vala_gir_parser_node_get_cname (ValaGirParserNode* self)
{
	const gchar* _tmp0_;
	gchar* cname = NULL;
	ValaGirParserMetadata* _tmp2_;
	ValaMap* _tmp7_;
	const gchar* _tmp17_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME);
		_g_free0 (cname);
		cname = _tmp4_;
	} else {
		ValaSymbol* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->symbol;
		_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp5_, "CCode", "cname", NULL);
		_g_free0 (cname);
		cname = _tmp6_;
	}
	_tmp7_ = self->girdata;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		const gchar* _tmp11_;
		const gchar* _tmp14_;
		_tmp8_ = cname;
		if (_tmp8_ == NULL) {
			ValaMap* _tmp9_;
			gpointer _tmp10_;
			_tmp9_ = self->girdata;
			_tmp10_ = vala_map_get (_tmp9_, "c:identifier");
			_g_free0 (cname);
			cname = (gchar*) _tmp10_;
		}
		_tmp11_ = cname;
		if (_tmp11_ == NULL) {
			ValaMap* _tmp12_;
			gpointer _tmp13_;
			_tmp12_ = self->girdata;
			_tmp13_ = vala_map_get (_tmp12_, "c:type");
			_g_free0 (cname);
			cname = (gchar*) _tmp13_;
		}
		_tmp14_ = cname;
		if (_tmp14_ == NULL) {
			ValaMap* _tmp15_;
			gpointer _tmp16_;
			_tmp15_ = self->girdata;
			_tmp16_ = vala_map_get (_tmp15_, "glib:type-name");
			_g_free0 (cname);
			cname = (gchar*) _tmp16_;
		}
	}
	_tmp17_ = cname;
	if (_tmp17_ == NULL) {
		gchar* _tmp18_;
		_tmp18_ = vala_gir_parser_node_get_default_cname (self);
		_g_free0 (cname);
		cname = _tmp18_;
	}
	result = cname;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_cname (ValaGirParserNode* self)
{
	const gchar* _tmp0_;
	ValaSymbol* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->symbol;
	if (VALA_IS_FIELD (_tmp2_)) {
		ValaSymbol* _tmp3_;
		ValaMemberBinding _tmp4_;
		ValaMemberBinding _tmp5_;
		_tmp3_ = self->symbol;
		_tmp4_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_FIELD, ValaField));
		_tmp5_ = _tmp4_;
		if (_tmp5_ == VALA_MEMBER_BINDING_STATIC) {
			ValaGirParserNode* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp6_ = self->parent;
			_tmp7_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->name;
			_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp8_);
			result = _tmp11_;
			return result;
		} else {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = self->name;
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			return result;
		}
	} else {
		ValaSymbol* _tmp14_;
		_tmp14_ = self->symbol;
		if (VALA_IS_METHOD (_tmp14_)) {
			ValaGirParserNode* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp15_ = self->parent;
			_tmp16_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->name;
			_tmp19_ = g_strdup_printf ("%s%s", _tmp17_, _tmp18_);
			_tmp20_ = _tmp19_;
			_g_free0 (_tmp17_);
			result = _tmp20_;
			return result;
		} else {
			ValaGirParserNode* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp21_ = self->parent;
			_tmp22_ = vala_gir_parser_node_get_cprefix (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = self->name;
			_tmp25_ = g_strdup_printf ("%s%s", _tmp23_, _tmp24_);
			_tmp26_ = _tmp25_;
			_g_free0 (_tmp23_);
			result = _tmp26_;
			return result;
		}
	}
}

static gchar*
vala_gir_parser_node_get_finish_cname (ValaGirParserNode* self)
{
	gchar* finish_cname = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "finish_name", NULL);
	finish_cname = _tmp1_;
	_tmp2_ = finish_cname;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp3_ = vala_gir_parser_node_get_cname (self);
		_g_free0 (finish_cname);
		finish_cname = _tmp3_;
		_tmp4_ = finish_cname;
		if (g_str_has_suffix (_tmp4_, "_async")) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gchar* _tmp11_;
			_tmp5_ = finish_cname;
			_tmp6_ = finish_cname;
			_tmp7_ = strlen (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = strlen ("_async");
			_tmp10_ = _tmp9_;
			_tmp11_ = string_substring (_tmp5_, (glong) 0, (glong) (_tmp8_ - _tmp10_));
			_g_free0 (finish_cname);
			finish_cname = _tmp11_;
		}
		_tmp12_ = finish_cname;
		_tmp13_ = g_strdup_printf ("%s_finish", _tmp12_);
		_g_free0 (finish_cname);
		finish_cname = _tmp13_;
	}
	result = finish_cname;
	return result;
}

static gchar*
vala_gir_parser_node_get_cheader_filename (ValaGirParserNode* self)
{
	ValaGirParserMetadata* _tmp0_;
	gchar* cheader_filename = NULL;
	ValaSymbol* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	ValaGirParserNode* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp19_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp0_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME)) {
		ValaGirParserMetadata* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->metadata;
		_tmp2_ = vala_gir_parser_metadata_get_string (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->symbol;
	_tmp4_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp3_, "CCode", "cheader_filename", NULL);
	cheader_filename = _tmp4_;
	_tmp5_ = cheader_filename;
	if (_tmp5_ != NULL) {
		result = cheader_filename;
		return result;
	}
	_tmp6_ = self->parent;
	_tmp7_ = _tmp6_->name;
	if (_tmp7_ != NULL) {
		ValaGirParserNode* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->parent;
		_tmp9_ = vala_gir_parser_node_get_cheader_filename (_tmp8_);
		result = _tmp9_;
		_g_free0 (cheader_filename);
		return result;
	} else {
		ValaSymbol* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		_tmp10_ = self->symbol;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			ValaSymbol* _tmp13_;
			ValaSourceReference* _tmp14_;
			ValaSourceReference* _tmp15_;
			ValaSourceFile* _tmp16_;
			ValaSourceFile* _tmp17_;
			gchar* _tmp18_;
			_tmp13_ = self->symbol;
			_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_source_reference_get_file (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_source_file_get_cinclude_filename (_tmp17_);
			result = _tmp18_;
			_g_free0 (cheader_filename);
			return result;
		}
	}
	_tmp19_ = g_strdup ("");
	result = _tmp19_;
	_g_free0 (cheader_filename);
	return result;
}

static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar** unparsed,
                 guint _base)
{
	gint64 _vala__result_ = 0LL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static guint64
vala_gir_parser_node_parse_version_string (const gchar* version)
{
	gint64 res = 0LL;
	gint shift = 0;
	gchar** tokens = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	guint64 result;
	g_return_val_if_fail (version != NULL, 0ULL);
	res = (gint64) 0;
	shift = 16;
	_tmp1_ = _tmp0_ = g_strsplit (version, ".", 3);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = tokens_length1;
	_tmp2_ = tokens;
	_tmp2__length1 = tokens_length1;
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp2_;
		token_collection_length1 = _tmp2__length1;
		for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
			const gchar* token = NULL;
			token = token_collection[token_it];
			{
				gint64 t = 0LL;
				const gchar* _tmp3_;
				gint64 _tmp4_ = 0LL;
				gboolean _tmp5_;
				_tmp3_ = token;
				_tmp5_ = int64_try_parse (_tmp3_, &_tmp4_, NULL, (guint) 0);
				t = _tmp4_;
				if (!_tmp5_) {
					result = (guint64) 0;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				if (t > ((gint64) 0xffff)) {
					result = (guint64) 0;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				res |= t << shift;
				shift -= 8;
			}
		}
	}
	result = (guint64) res;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
vala_gir_parser_node_move_class_methods (ValaGirParserNode* target,
                                         ValaGirParserNode* source)
{
	gint i = 0;
	g_return_if_fail (target != NULL);
	if (source == NULL) {
		return;
	}
	i = 0;
	while (TRUE) {
		ValaArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		ValaGirParserNode* node = NULL;
		ValaArrayList* _tmp3_;
		gpointer _tmp4_;
		ValaGirParserNode* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp0_ = source->members;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		if (!(i < _tmp2_)) {
			break;
		}
		_tmp3_ = source->members;
		_tmp4_ = vala_list_get ((ValaList*) _tmp3_, i);
		node = (ValaGirParserNode*) _tmp4_;
		_tmp5_ = node;
		_tmp6_ = _tmp5_->symbol;
		if (VALA_IS_METHOD (_tmp6_)) {
			ValaGirParserNode* _tmp7_;
			ValaGirParserNode* _tmp8_;
			ValaGirParserNode* _tmp9_;
			ValaSymbol* _tmp10_;
			_tmp7_ = node;
			vala_gir_parser_node_remove_member (source, _tmp7_);
			_tmp8_ = node;
			vala_gir_parser_node_add_member (target, _tmp8_);
			_tmp9_ = node;
			_tmp10_ = _tmp9_->symbol;
			vala_method_set_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_METHOD, ValaMethod), VALA_MEMBER_BINDING_CLASS);
		} else {
			gint _tmp11_;
			_tmp11_ = i;
			i = _tmp11_ + 1;
		}
		_vala_gir_parser_node_unref0 (node);
	}
}

static void
vala_gir_parser_node_process (ValaGirParserNode* self,
                              ValaGirParser* parser)
{
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	gboolean _tmp36_ = FALSE;
	ValaSymbol* _tmp37_;
	ValaMap* _tmp63_;
	gboolean _tmp833_ = FALSE;
	gboolean _tmp834_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parser != NULL);
	if (self->processed) {
		return;
	}
	_tmp1_ = self->symbol;
	if (VALA_IS_NAMESPACE (_tmp1_)) {
		ValaGirParserNode* _tmp2_;
		ValaGirParserNode* _tmp3_;
		_tmp2_ = self->parent;
		_tmp3_ = parser->priv->root;
		_tmp0_ = _tmp2_ == _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			ValaArrayList* _node_list = NULL;
			ValaArrayList* _tmp4_;
			gint _node_size = 0;
			ValaArrayList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _node_index = 0;
			_tmp4_ = self->members;
			_node_list = _tmp4_;
			_tmp5_ = _node_list;
			_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_node_size = _tmp7_;
			_node_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				ValaGirParserNode* node = NULL;
				ValaArrayList* _tmp10_;
				gpointer _tmp11_;
				ValaGirParserNode* _tmp12_;
				const gchar* _tmp13_;
				_node_index = _node_index + 1;
				_tmp8_ = _node_index;
				_tmp9_ = _node_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _node_list;
				_tmp11_ = vala_list_get ((ValaList*) _tmp10_, _node_index);
				node = (ValaGirParserNode*) _tmp11_;
				_tmp12_ = node;
				_tmp13_ = _tmp12_->element_type;
				if (g_strcmp0 (_tmp13_, "alias") == 0) {
					ValaGirParserNode* _tmp14_;
					_tmp14_ = node;
					vala_gir_parser_process_alias (parser, _tmp14_);
				}
				_vala_gir_parser_node_unref0 (node);
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp15_ = FALSE;
				_tmp15_ = TRUE;
				while (TRUE) {
					ValaArrayList* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					ValaGirParserNode* node = NULL;
					ValaArrayList* _tmp20_;
					gpointer _tmp21_;
					gboolean _tmp22_ = FALSE;
					ValaGirParserNode* _tmp23_;
					ValaSymbol* _tmp24_;
					if (!_tmp15_) {
						gint _tmp16_;
						_tmp16_ = i;
						i = _tmp16_ + 1;
					}
					_tmp15_ = FALSE;
					_tmp17_ = self->members;
					_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
					_tmp19_ = _tmp18_;
					if (!(i < _tmp19_)) {
						break;
					}
					_tmp20_ = self->members;
					_tmp21_ = vala_list_get ((ValaList*) _tmp20_, i);
					node = (ValaGirParserNode*) _tmp21_;
					_tmp23_ = node;
					_tmp24_ = _tmp23_->symbol;
					if (VALA_IS_METHOD (_tmp24_)) {
						ValaGirParserNode* _tmp25_;
						_tmp25_ = node;
						_tmp22_ = _tmp25_->new_symbol;
					} else {
						_tmp22_ = FALSE;
					}
					if (_tmp22_) {
						ValaGirParserNode* _tmp26_;
						gboolean _tmp27_ = FALSE;
						ValaArrayList* _tmp28_;
						gint _tmp29_;
						gint _tmp30_;
						_tmp26_ = node;
						vala_gir_parser_process_namespace_method (parser, self, _tmp26_);
						_tmp28_ = self->members;
						_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
						_tmp30_ = _tmp29_;
						if (i < _tmp30_) {
							ValaArrayList* _tmp31_;
							gpointer _tmp32_;
							ValaGirParserNode* _tmp33_;
							ValaGirParserNode* _tmp34_;
							_tmp31_ = self->members;
							_tmp32_ = vala_list_get ((ValaList*) _tmp31_, i);
							_tmp33_ = (ValaGirParserNode*) _tmp32_;
							_tmp34_ = node;
							_tmp27_ = _tmp33_ != _tmp34_;
							_vala_gir_parser_node_unref0 (_tmp33_);
						} else {
							_tmp27_ = FALSE;
						}
						if (_tmp27_) {
							gint _tmp35_;
							_tmp35_ = i;
							i = _tmp35_ - 1;
						}
					}
					_vala_gir_parser_node_unref0 (node);
				}
			}
		}
	}
	_tmp37_ = self->symbol;
	if (VALA_IS_CLASS (_tmp37_)) {
		ValaMap* _tmp38_;
		_tmp38_ = self->girdata;
		_tmp36_ = _tmp38_ != NULL;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		ValaUnresolvedSymbol* _tmp39_;
		gchar* class_struct = NULL;
		ValaMap* _tmp44_;
		gpointer _tmp45_;
		const gchar* _tmp46_;
		_tmp39_ = self->type_struct;
		if (_tmp39_ != NULL) {
			ValaGirParserNode* _tmp40_;
			ValaUnresolvedSymbol* _tmp41_;
			ValaGirParserNode* _tmp42_;
			ValaGirParserNode* _tmp43_;
			_tmp40_ = self->parent;
			_tmp41_ = self->type_struct;
			_tmp42_ = vala_gir_parser_resolve_node (parser, _tmp40_, _tmp41_, FALSE);
			_tmp43_ = _tmp42_;
			vala_gir_parser_node_move_class_methods (self, _tmp43_);
			_vala_gir_parser_node_unref0 (_tmp43_);
		}
		_tmp44_ = self->girdata;
		_tmp45_ = vala_map_get (_tmp44_, "glib:type-struct");
		class_struct = (gchar*) _tmp45_;
		_tmp46_ = class_struct;
		if (_tmp46_ != NULL) {
			ValaGirParserNode* _tmp47_;
			const gchar* _tmp48_;
			ValaSourceReference* _tmp49_;
			ValaUnresolvedSymbol* _tmp50_;
			ValaUnresolvedSymbol* _tmp51_;
			ValaGirParserNode* _tmp52_;
			ValaGirParserNode* _tmp53_;
			_tmp47_ = self->parent;
			_tmp48_ = class_struct;
			_tmp49_ = self->source_reference;
			_tmp50_ = vala_gir_parser_parse_symbol_from_string (parser, _tmp48_, _tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_gir_parser_resolve_node (parser, _tmp47_, _tmp51_, FALSE);
			_tmp53_ = _tmp52_;
			vala_gir_parser_node_move_class_methods (self, _tmp53_);
			_vala_gir_parser_node_unref0 (_tmp53_);
			_vala_code_node_unref0 (_tmp51_);
		}
		_g_free0 (class_struct);
	}
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp54_;
		gint _node_size = 0;
		ValaArrayList* _tmp55_;
		gint _tmp56_;
		gint _tmp57_;
		gint _node_index = 0;
		_tmp54_ = self->members;
		_node_list = _tmp54_;
		_tmp55_ = _node_list;
		_tmp56_ = vala_collection_get_size ((ValaCollection*) _tmp55_);
		_tmp57_ = _tmp56_;
		_node_size = _tmp57_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp58_;
			gint _tmp59_;
			ValaGirParserNode* node = NULL;
			ValaArrayList* _tmp60_;
			gpointer _tmp61_;
			ValaGirParserNode* _tmp62_;
			_node_index = _node_index + 1;
			_tmp58_ = _node_index;
			_tmp59_ = _node_size;
			if (!(_tmp58_ < _tmp59_)) {
				break;
			}
			_tmp60_ = _node_list;
			_tmp61_ = vala_list_get ((ValaList*) _tmp60_, _node_index);
			node = (ValaGirParserNode*) _tmp61_;
			_tmp62_ = node;
			vala_gir_parser_node_process (_tmp62_, parser);
			_vala_gir_parser_node_unref0 (node);
		}
	}
	_tmp63_ = self->girdata;
	if (_tmp63_ != NULL) {
		ValaSymbol* _tmp64_;
		ValaGirParserMetadata* _tmp740_;
		ValaGirParserMetadata* _tmp743_;
		ValaGirParserMetadata* _tmp752_;
		const gchar* _tmp758_;
		ValaGirParserMetadata* _tmp760_;
		ValaGirParserMetadata* _tmp763_;
		ValaGirParserNode* _tmp781_;
		ValaSymbol* _tmp782_;
		gchar* _tmp791_;
		gchar* _tmp792_;
		gchar* _tmp793_;
		gchar* _tmp794_;
		gboolean _tmp795_;
		ValaGirParserMetadata* _tmp799_;
		gchar* _tmp804_;
		gchar* _tmp805_;
		gchar* _tmp806_;
		gchar* _tmp807_;
		gboolean _tmp808_;
		gchar* _tmp812_;
		gchar* _tmp813_;
		gchar* _tmp814_;
		gchar* _tmp815_;
		gboolean _tmp816_;
		gchar* gir_name = NULL;
		gchar* _tmp820_;
		gchar* default_gir_name = NULL;
		gchar* _tmp821_;
		gboolean _tmp822_ = FALSE;
		gboolean _tmp823_ = FALSE;
		ValaSymbol* _tmp824_;
		_tmp64_ = self->symbol;
		if (VALA_IS_METHOD (_tmp64_)) {
			ValaMethod* m = NULL;
			ValaSymbol* _tmp65_;
			ValaMethod* _tmp66_;
			ValaArrayList* colliding = NULL;
			ValaGirParserNode* _tmp67_;
			const gchar* _tmp68_;
			ValaArrayList* _tmp69_;
			ValaMethod* _tmp165_;
			ValaGirParserMetadata* _tmp184_;
			ValaMethod* _tmp187_;
			gboolean _tmp188_;
			gboolean _tmp189_;
			_tmp65_ = self->symbol;
			_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_METHOD, ValaMethod));
			m = _tmp66_;
			vala_gir_parser_process_callable (parser, self);
			_tmp67_ = self->parent;
			_tmp68_ = self->name;
			_tmp69_ = vala_gir_parser_node_lookup_all (_tmp67_, _tmp68_);
			colliding = _tmp69_;
			{
				ValaArrayList* _node_list = NULL;
				ValaArrayList* _tmp70_;
				gint _node_size = 0;
				ValaArrayList* _tmp71_;
				gint _tmp72_;
				gint _tmp73_;
				gint _node_index = 0;
				_tmp70_ = colliding;
				_node_list = _tmp70_;
				_tmp71_ = _node_list;
				_tmp72_ = vala_collection_get_size ((ValaCollection*) _tmp71_);
				_tmp73_ = _tmp72_;
				_node_size = _tmp73_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp74_;
					gint _tmp75_;
					ValaGirParserNode* node = NULL;
					ValaArrayList* _tmp76_;
					gpointer _tmp77_;
					ValaSymbol* sym = NULL;
					ValaGirParserNode* _tmp78_;
					ValaSymbol* _tmp79_;
					ValaSymbol* _tmp80_;
					ValaSymbol* _tmp81_;
					_node_index = _node_index + 1;
					_tmp74_ = _node_index;
					_tmp75_ = _node_size;
					if (!(_tmp74_ < _tmp75_)) {
						break;
					}
					_tmp76_ = _node_list;
					_tmp77_ = vala_list_get ((ValaList*) _tmp76_, _node_index);
					node = (ValaGirParserNode*) _tmp77_;
					_tmp78_ = node;
					_tmp79_ = _tmp78_->symbol;
					_tmp80_ = _vala_code_node_ref0 (_tmp79_);
					sym = _tmp80_;
					_tmp81_ = sym;
					if (VALA_IS_FIELD (_tmp81_)) {
						gboolean _tmp82_ = FALSE;
						ValaMethod* _tmp83_;
						ValaDataType* _tmp84_;
						ValaDataType* _tmp85_;
						ValaSymbol* _tmp86_;
						ValaDataType* _tmp87_;
						ValaDataType* _tmp88_;
						_tmp83_ = m;
						_tmp84_ = vala_callable_get_return_type ((ValaCallable*) _tmp83_);
						_tmp85_ = _tmp84_;
						_tmp86_ = sym;
						_tmp87_ = vala_variable_get_variable_type ((ValaVariable*) G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_FIELD, ValaField));
						_tmp88_ = _tmp87_;
						if (vala_data_type_compatible (_tmp85_, _tmp88_)) {
							ValaMethod* _tmp89_;
							ValaList* _tmp90_;
							gint _tmp91_;
							gint _tmp92_;
							_tmp89_ = m;
							_tmp90_ = vala_callable_get_parameters ((ValaCallable*) _tmp89_);
							_tmp91_ = vala_collection_get_size ((ValaCollection*) _tmp90_);
							_tmp92_ = _tmp91_;
							_tmp82_ = _tmp92_ == 0;
						} else {
							_tmp82_ = FALSE;
						}
						if (_tmp82_) {
							self->merged = TRUE;
						} else {
							ValaSymbol* _tmp93_;
							ValaSourceReference* _tmp94_;
							ValaSourceReference* _tmp95_;
							gchar* _tmp96_;
							gchar* _tmp97_;
							_tmp93_ = self->symbol;
							_tmp94_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp93_);
							_tmp95_ = _tmp94_;
							_tmp96_ = vala_gir_parser_node_get_full_name (self);
							_tmp97_ = _tmp96_;
							vala_report_warning (_tmp95_, "Field `%s' conflicts with method of the same name", _tmp97_);
							_g_free0 (_tmp97_);
						}
					} else {
						ValaSymbol* _tmp98_;
						_tmp98_ = sym;
						if (VALA_IS_SIGNAL (_tmp98_)) {
							ValaGirParserNode* _tmp99_;
							ValaSignal* sig = NULL;
							ValaSymbol* _tmp100_;
							ValaSignal* _tmp101_;
							gboolean _tmp102_ = FALSE;
							ValaMethod* _tmp103_;
							gboolean _tmp104_;
							gboolean _tmp105_;
							ValaSignal* _tmp111_;
							ValaMethod* _tmp112_;
							ValaMethod* _tmp113_;
							ValaList* _tmp114_;
							gint _tmp115_;
							gint _tmp116_;
							ValaSignal* _tmp117_;
							ValaList* _tmp118_;
							gint _tmp119_;
							gint _tmp120_;
							_tmp99_ = node;
							vala_gir_parser_node_process (_tmp99_, parser);
							_tmp100_ = sym;
							_tmp101_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_SIGNAL, ValaSignal));
							sig = _tmp101_;
							_tmp103_ = m;
							_tmp104_ = vala_method_get_is_virtual (_tmp103_);
							_tmp105_ = _tmp104_;
							if (_tmp105_) {
								_tmp102_ = TRUE;
							} else {
								ValaMethod* _tmp106_;
								gboolean _tmp107_;
								gboolean _tmp108_;
								_tmp106_ = m;
								_tmp107_ = vala_method_get_is_abstract (_tmp106_);
								_tmp108_ = _tmp107_;
								_tmp102_ = _tmp108_;
							}
							if (_tmp102_) {
								ValaSignal* _tmp109_;
								_tmp109_ = sig;
								vala_signal_set_is_virtual (_tmp109_, TRUE);
							} else {
								ValaSignal* _tmp110_;
								_tmp110_ = sig;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp110_, "HasEmitter", TRUE, NULL);
							}
							_tmp111_ = sig;
							_tmp112_ = m;
							vala_gir_parser_assume_parameter_names (parser, _tmp111_, (ValaSymbol*) _tmp112_, FALSE);
							_tmp113_ = m;
							_tmp114_ = vala_callable_get_parameters ((ValaCallable*) _tmp113_);
							_tmp115_ = vala_collection_get_size ((ValaCollection*) _tmp114_);
							_tmp116_ = _tmp115_;
							_tmp117_ = sig;
							_tmp118_ = vala_callable_get_parameters ((ValaCallable*) _tmp117_);
							_tmp119_ = vala_collection_get_size ((ValaCollection*) _tmp118_);
							_tmp120_ = _tmp119_;
							if (_tmp116_ != _tmp120_) {
								ValaSymbol* _tmp121_;
								ValaSourceReference* _tmp122_;
								ValaSourceReference* _tmp123_;
								gchar* _tmp124_;
								gchar* _tmp125_;
								_tmp121_ = self->symbol;
								_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp121_);
								_tmp123_ = _tmp122_;
								_tmp124_ = vala_gir_parser_node_get_full_name (self);
								_tmp125_ = _tmp124_;
								vala_report_warning (_tmp123_, "Signal `%s' conflicts with method of the same name", _tmp125_);
								_g_free0 (_tmp125_);
							}
							self->merged = TRUE;
							_vala_code_node_unref0 (sig);
						} else {
							gboolean _tmp126_ = FALSE;
							gboolean _tmp127_ = FALSE;
							ValaSymbol* _tmp128_;
							_tmp128_ = sym;
							if (VALA_IS_METHOD (_tmp128_)) {
								ValaSymbol* _tmp129_;
								_tmp129_ = sym;
								_tmp127_ = !VALA_IS_CREATION_METHOD (_tmp129_);
							} else {
								_tmp127_ = FALSE;
							}
							if (_tmp127_) {
								ValaGirParserNode* _tmp130_;
								_tmp130_ = node;
								_tmp126_ = _tmp130_ != self;
							} else {
								_tmp126_ = FALSE;
							}
							if (_tmp126_) {
								gboolean _tmp131_ = FALSE;
								ValaMethod* _tmp132_;
								gboolean _tmp133_;
								gboolean _tmp134_;
								_tmp132_ = m;
								_tmp133_ = vala_method_get_is_virtual (_tmp132_);
								_tmp134_ = _tmp133_;
								if (_tmp134_) {
									_tmp131_ = TRUE;
								} else {
									ValaMethod* _tmp135_;
									gboolean _tmp136_;
									gboolean _tmp137_;
									_tmp135_ = m;
									_tmp136_ = vala_method_get_is_abstract (_tmp135_);
									_tmp137_ = _tmp136_;
									_tmp131_ = _tmp137_;
								}
								if (_tmp131_) {
									gboolean different_invoker = FALSE;
									gboolean no_wrapper = FALSE;
									ValaMethod* _tmp138_;
									different_invoker = FALSE;
									_tmp138_ = m;
									no_wrapper = vala_code_node_has_attribute ((ValaCodeNode*) _tmp138_, "NoWrapper");
									if (no_wrapper) {
										ValaGirParserNode* invoker = NULL;
										ValaGirParserNode* _tmp139_;
										ValaGirParserNode* _tmp140_;
										_tmp139_ = vala_gir_parser_find_invoker (parser, self);
										invoker = _tmp139_;
										_tmp140_ = invoker;
										if (_tmp140_ != NULL) {
											ValaMethod* _tmp141_;
											ValaMethod* _tmp142_;
											const gchar* _tmp143_;
											const gchar* _tmp144_;
											ValaMethod* _tmp145_;
											ValaGirParserNode* _tmp146_;
											ValaSymbol* _tmp147_;
											const gchar* _tmp148_;
											const gchar* _tmp149_;
											ValaMethod* _tmp150_;
											ValaGirParserNode* _tmp151_;
											_tmp141_ = m;
											_tmp142_ = m;
											_tmp143_ = vala_symbol_get_name ((ValaSymbol*) _tmp142_);
											_tmp144_ = _tmp143_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp141_, "CCode", "vfunc_name", _tmp144_, NULL);
											_tmp145_ = m;
											_tmp146_ = invoker;
											_tmp147_ = _tmp146_->symbol;
											_tmp148_ = vala_symbol_get_name (_tmp147_);
											_tmp149_ = _tmp148_;
											vala_symbol_set_name ((ValaSymbol*) _tmp145_, _tmp149_);
											_tmp150_ = m;
											vala_code_node_set_attribute ((ValaCodeNode*) _tmp150_, "NoWrapper", FALSE, NULL);
											_tmp151_ = invoker;
											_tmp151_->merged = TRUE;
											different_invoker = TRUE;
										}
										_vala_gir_parser_node_unref0 (invoker);
									}
									if (!different_invoker) {
										ValaGirParserNode* _tmp157_;
										if (no_wrapper) {
											ValaSymbol* _tmp152_;
											ValaSourceReference* _tmp153_;
											ValaSourceReference* _tmp154_;
											gchar* _tmp155_;
											gchar* _tmp156_;
											_tmp152_ = self->symbol;
											_tmp153_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp152_);
											_tmp154_ = _tmp153_;
											_tmp155_ = vala_gir_parser_node_get_full_name (self);
											_tmp156_ = _tmp155_;
											vala_report_warning (_tmp154_, "Virtual method `%s' conflicts with method of the same name", _tmp156_);
											_g_free0 (_tmp156_);
										}
										_tmp157_ = node;
										_tmp157_->merged = TRUE;
									}
								} else {
									ValaMethod* _tmp158_;
									_tmp158_ = m;
									if (vala_symbol_is_class_member ((ValaSymbol*) _tmp158_)) {
										ValaSymbol* _tmp159_;
										ValaSourceReference* _tmp160_;
										ValaSourceReference* _tmp161_;
										gchar* _tmp162_;
										gchar* _tmp163_;
										ValaGirParserNode* _tmp164_;
										_tmp159_ = self->symbol;
										_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp159_);
										_tmp161_ = _tmp160_;
										_tmp162_ = vala_gir_parser_node_get_full_name (self);
										_tmp163_ = _tmp162_;
										vala_report_warning (_tmp161_, "Class method `%s' conflicts with method of the same name", _tmp163_);
										_g_free0 (_tmp163_);
										_tmp164_ = node;
										_tmp164_->merged = TRUE;
									}
								}
							}
						}
					}
					_vala_code_node_unref0 (sym);
					_vala_gir_parser_node_unref0 (node);
				}
			}
			_tmp165_ = m;
			if (!VALA_IS_CREATION_METHOD (_tmp165_)) {
				ValaGirParserMetadata* _tmp166_;
				ValaGirParserMetadata* _tmp169_;
				ValaGirParserMetadata* _tmp172_;
				_tmp166_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp166_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE)) {
					ValaMethod* _tmp167_;
					ValaGirParserMetadata* _tmp168_;
					_tmp167_ = m;
					_tmp168_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp167_, "DestroysInstance", vala_gir_parser_metadata_get_bool (_tmp168_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE, FALSE), NULL);
				}
				_tmp169_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp169_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER)) {
					ValaMethod* _tmp170_;
					ValaGirParserMetadata* _tmp171_;
					_tmp170_ = m;
					_tmp171_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp170_, "ReturnsModifiedPointer", vala_gir_parser_metadata_get_bool (_tmp171_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER, FALSE), NULL);
				}
				_tmp172_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp172_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME)) {
					ValaGirParserNode* vfunc = NULL;
					ValaGirParserNode* _tmp173_;
					ValaGirParserMetadata* _tmp174_;
					gchar* _tmp175_;
					gchar* _tmp176_;
					ValaGirParserNode* _tmp177_;
					ValaGirParserNode* _tmp178_;
					gboolean _tmp179_ = FALSE;
					ValaGirParserNode* _tmp180_;
					_tmp173_ = self->parent;
					_tmp174_ = self->metadata;
					_tmp175_ = vala_gir_parser_metadata_get_string (_tmp174_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
					_tmp176_ = _tmp175_;
					_tmp177_ = vala_gir_parser_node_lookup (_tmp173_, _tmp176_, FALSE, NULL);
					_tmp178_ = _tmp177_;
					_g_free0 (_tmp176_);
					vfunc = _tmp178_;
					_tmp180_ = vfunc;
					if (_tmp180_ != NULL) {
						ValaGirParserNode* _tmp181_;
						_tmp181_ = vfunc;
						_tmp179_ = _tmp181_ != self;
					} else {
						_tmp179_ = FALSE;
					}
					if (_tmp179_) {
						ValaGirParserNode* _tmp182_;
						ValaGirParserNode* _tmp183_;
						_tmp182_ = vfunc;
						_tmp182_->processed = TRUE;
						_tmp183_ = vfunc;
						_tmp183_->merged = TRUE;
					}
					_vala_gir_parser_node_unref0 (vfunc);
				}
			}
			_tmp184_ = self->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp184_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET)) {
				ValaMethod* _tmp185_;
				ValaGirParserMetadata* _tmp186_;
				_tmp185_ = m;
				_tmp186_ = self->metadata;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp185_, "CCode", "delegate_target", vala_gir_parser_metadata_get_bool (_tmp186_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET, FALSE), NULL);
			}
			_tmp187_ = m;
			_tmp188_ = vala_method_get_coroutine (_tmp187_);
			_tmp189_ = _tmp188_;
			if (_tmp189_) {
				vala_gir_parser_process_async_method (parser, self);
			}
			_vala_iterable_unref0 (colliding);
			_vala_code_node_unref0 (m);
		} else {
			ValaSymbol* _tmp190_;
			_tmp190_ = self->symbol;
			if (VALA_IS_PROPERTY (_tmp190_)) {
				ValaArrayList* colliding = NULL;
				ValaGirParserNode* _tmp191_;
				const gchar* _tmp192_;
				ValaArrayList* _tmp193_;
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp214_;
				ValaProperty* _tmp215_;
				gchar* readable = NULL;
				ValaMap* _tmp216_;
				gpointer _tmp217_;
				gchar* writable = NULL;
				ValaMap* _tmp218_;
				gpointer _tmp219_;
				gchar* construct_ = NULL;
				ValaMap* _tmp220_;
				gpointer _tmp221_;
				gchar* construct_only = NULL;
				ValaMap* _tmp222_;
				gpointer _tmp223_;
				const gchar* _tmp224_;
				gboolean _tmp233_ = FALSE;
				const gchar* _tmp234_;
				ValaProperty* _tmp250_;
				ValaDataType* _tmp251_;
				ValaDataType* _tmp252_;
				ValaGirParserNode* getter = NULL;
				ValaArrayList* getters = NULL;
				ValaGirParserNode* _tmp253_;
				const gchar* _tmp254_;
				gchar* _tmp255_;
				gchar* _tmp256_;
				ValaArrayList* _tmp257_;
				ValaArrayList* _tmp258_;
				ValaArrayList* _tmp259_;
				ValaGirParserNode* setter = NULL;
				ValaArrayList* setters = NULL;
				ValaGirParserNode* _tmp283_;
				const gchar* _tmp284_;
				gchar* _tmp285_;
				gchar* _tmp286_;
				ValaArrayList* _tmp287_;
				ValaArrayList* _tmp288_;
				ValaArrayList* _tmp289_;
				gboolean _tmp313_ = FALSE;
				const gchar* _tmp314_;
				ValaProperty* _tmp316_;
				ValaProperty* _tmp317_;
				ValaPropertyAccessor* _tmp318_;
				ValaPropertyAccessor* _tmp319_;
				gboolean _tmp377_ = FALSE;
				gboolean _tmp378_ = FALSE;
				ValaProperty* _tmp379_;
				ValaProperty* _tmp443_;
				ValaGirParserMetadata* _tmp488_;
				ValaProperty* _tmp491_;
				_tmp191_ = self->parent;
				_tmp192_ = self->name;
				_tmp193_ = vala_gir_parser_node_lookup_all (_tmp191_, _tmp192_);
				colliding = _tmp193_;
				{
					ValaArrayList* _node_list = NULL;
					ValaArrayList* _tmp194_;
					gint _node_size = 0;
					ValaArrayList* _tmp195_;
					gint _tmp196_;
					gint _tmp197_;
					gint _node_index = 0;
					_tmp194_ = colliding;
					_node_list = _tmp194_;
					_tmp195_ = _node_list;
					_tmp196_ = vala_collection_get_size ((ValaCollection*) _tmp195_);
					_tmp197_ = _tmp196_;
					_node_size = _tmp197_;
					_node_index = -1;
					while (TRUE) {
						gint _tmp198_;
						gint _tmp199_;
						ValaGirParserNode* node = NULL;
						ValaArrayList* _tmp200_;
						gpointer _tmp201_;
						ValaGirParserNode* _tmp202_;
						ValaSymbol* _tmp203_;
						_node_index = _node_index + 1;
						_tmp198_ = _node_index;
						_tmp199_ = _node_size;
						if (!(_tmp198_ < _tmp199_)) {
							break;
						}
						_tmp200_ = _node_list;
						_tmp201_ = vala_list_get ((ValaList*) _tmp200_, _node_index);
						node = (ValaGirParserNode*) _tmp201_;
						_tmp202_ = node;
						_tmp203_ = _tmp202_->symbol;
						if (VALA_IS_SIGNAL (_tmp203_)) {
							ValaGirParserNode* _tmp204_;
							ValaGirParserNode* _tmp205_;
							ValaSymbol* _tmp206_;
							ValaSourceReference* _tmp207_;
							ValaSourceReference* _tmp208_;
							gchar* _tmp209_;
							gchar* _tmp210_;
							_tmp204_ = node;
							_tmp204_->processed = TRUE;
							_tmp205_ = node;
							_tmp205_->merged = TRUE;
							_tmp206_ = self->symbol;
							_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp206_);
							_tmp208_ = _tmp207_;
							_tmp209_ = vala_gir_parser_node_get_full_name (self);
							_tmp210_ = _tmp209_;
							vala_report_warning (_tmp208_, "Signal `%s' conflicts with property of the same name", _tmp210_);
							_g_free0 (_tmp210_);
						} else {
							ValaGirParserNode* _tmp211_;
							ValaSymbol* _tmp212_;
							_tmp211_ = node;
							_tmp212_ = _tmp211_->symbol;
							if (VALA_IS_METHOD (_tmp212_)) {
								ValaGirParserNode* _tmp213_;
								_tmp213_ = node;
								_tmp213_->merged = TRUE;
							}
						}
						_vala_gir_parser_node_unref0 (node);
					}
				}
				_tmp214_ = self->symbol;
				_tmp215_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp214_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp215_;
				_tmp216_ = self->girdata;
				_tmp217_ = vala_map_get (_tmp216_, "readable");
				readable = (gchar*) _tmp217_;
				_tmp218_ = self->girdata;
				_tmp219_ = vala_map_get (_tmp218_, "writable");
				writable = (gchar*) _tmp219_;
				_tmp220_ = self->girdata;
				_tmp221_ = vala_map_get (_tmp220_, "construct");
				construct_ = (gchar*) _tmp221_;
				_tmp222_ = self->girdata;
				_tmp223_ = vala_map_get (_tmp222_, "construct-only");
				construct_only = (gchar*) _tmp223_;
				_tmp224_ = readable;
				if (g_strcmp0 (_tmp224_, "0") != 0) {
					ValaProperty* _tmp225_;
					ValaProperty* _tmp226_;
					ValaDataType* _tmp227_;
					ValaDataType* _tmp228_;
					ValaDataType* _tmp229_;
					ValaDataType* _tmp230_;
					ValaPropertyAccessor* _tmp231_;
					ValaPropertyAccessor* _tmp232_;
					_tmp225_ = prop;
					_tmp226_ = prop;
					_tmp227_ = vala_property_get_property_type (_tmp226_);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_data_type_copy (_tmp228_);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp230_, NULL, NULL, NULL);
					_tmp232_ = _tmp231_;
					vala_property_set_get_accessor (_tmp225_, _tmp232_);
					_vala_code_node_unref0 (_tmp232_);
					_vala_code_node_unref0 (_tmp230_);
				}
				_tmp234_ = writable;
				if (g_strcmp0 (_tmp234_, "1") == 0) {
					_tmp233_ = TRUE;
				} else {
					const gchar* _tmp235_;
					_tmp235_ = construct_only;
					_tmp233_ = g_strcmp0 (_tmp235_, "1") == 0;
				}
				if (_tmp233_) {
					gboolean _tmp236_ = FALSE;
					const gchar* _tmp237_;
					gboolean _tmp239_ = FALSE;
					const gchar* _tmp240_;
					ValaProperty* _tmp242_;
					ValaProperty* _tmp243_;
					ValaDataType* _tmp244_;
					ValaDataType* _tmp245_;
					ValaDataType* _tmp246_;
					ValaDataType* _tmp247_;
					ValaPropertyAccessor* _tmp248_;
					ValaPropertyAccessor* _tmp249_;
					_tmp237_ = construct_only;
					if (g_strcmp0 (_tmp237_, "1") != 0) {
						const gchar* _tmp238_;
						_tmp238_ = writable;
						_tmp236_ = g_strcmp0 (_tmp238_, "1") == 0;
					} else {
						_tmp236_ = FALSE;
					}
					_tmp240_ = construct_only;
					if (g_strcmp0 (_tmp240_, "1") == 0) {
						_tmp239_ = TRUE;
					} else {
						const gchar* _tmp241_;
						_tmp241_ = construct_;
						_tmp239_ = g_strcmp0 (_tmp241_, "1") == 0;
					}
					_tmp242_ = prop;
					_tmp243_ = prop;
					_tmp244_ = vala_property_get_property_type (_tmp243_);
					_tmp245_ = _tmp244_;
					_tmp246_ = vala_data_type_copy (_tmp245_);
					_tmp247_ = _tmp246_;
					_tmp248_ = vala_property_accessor_new (FALSE, _tmp236_, _tmp239_, _tmp247_, NULL, NULL, NULL);
					_tmp249_ = _tmp248_;
					vala_property_set_set_accessor (_tmp242_, _tmp249_);
					_vala_code_node_unref0 (_tmp249_);
					_vala_code_node_unref0 (_tmp247_);
				}
				_tmp250_ = prop;
				_tmp251_ = vala_property_get_property_type (_tmp250_);
				_tmp252_ = _tmp251_;
				vala_data_type_set_value_owned (_tmp252_, TRUE);
				getter = NULL;
				_tmp253_ = self->parent;
				_tmp254_ = self->name;
				_tmp255_ = g_strdup_printf ("get_%s", _tmp254_);
				_tmp256_ = _tmp255_;
				_tmp257_ = vala_gir_parser_node_lookup_all (_tmp253_, _tmp256_);
				_tmp258_ = _tmp257_;
				_g_free0 (_tmp256_);
				getters = _tmp258_;
				_tmp259_ = getters;
				if (_tmp259_ != NULL) {
					{
						ValaArrayList* _g_list = NULL;
						ValaArrayList* _tmp260_;
						gint _g_size = 0;
						ValaArrayList* _tmp261_;
						gint _tmp262_;
						gint _tmp263_;
						gint _g_index = 0;
						_tmp260_ = getters;
						_g_list = _tmp260_;
						_tmp261_ = _g_list;
						_tmp262_ = vala_collection_get_size ((ValaCollection*) _tmp261_);
						_tmp263_ = _tmp262_;
						_g_size = _tmp263_;
						_g_index = -1;
						while (TRUE) {
							gint _tmp264_;
							gint _tmp265_;
							ValaGirParserNode* g = NULL;
							ValaArrayList* _tmp266_;
							gpointer _tmp267_;
							gboolean _tmp268_ = FALSE;
							gboolean _tmp269_ = FALSE;
							ValaGirParserNode* _tmp270_;
							_g_index = _g_index + 1;
							_tmp264_ = _g_index;
							_tmp265_ = _g_size;
							if (!(_tmp264_ < _tmp265_)) {
								break;
							}
							_tmp266_ = _g_list;
							_tmp267_ = vala_list_get ((ValaList*) _tmp266_, _g_index);
							g = (ValaGirParserNode*) _tmp267_;
							_tmp270_ = getter;
							if (_tmp270_ == NULL) {
								_tmp269_ = TRUE;
							} else {
								ValaGirParserNode* _tmp271_;
								_tmp271_ = g;
								_tmp269_ = !_tmp271_->merged;
							}
							if (_tmp269_) {
								ValaGirParserNode* _tmp272_;
								gchar* _tmp273_;
								gchar* _tmp274_;
								ValaGirParserNode* _tmp275_;
								gchar* _tmp276_;
								gchar* _tmp277_;
								const gchar* _tmp278_;
								gchar* _tmp279_;
								gchar* _tmp280_;
								_tmp272_ = g;
								_tmp273_ = vala_gir_parser_node_get_cname (_tmp272_);
								_tmp274_ = _tmp273_;
								_tmp275_ = self->parent;
								_tmp276_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp275_);
								_tmp277_ = _tmp276_;
								_tmp278_ = self->name;
								_tmp279_ = g_strdup_printf ("%sget_%s", _tmp277_, _tmp278_);
								_tmp280_ = _tmp279_;
								_tmp268_ = g_strcmp0 (_tmp274_, _tmp280_) == 0;
								_g_free0 (_tmp280_);
								_g_free0 (_tmp277_);
								_g_free0 (_tmp274_);
							} else {
								_tmp268_ = FALSE;
							}
							if (_tmp268_) {
								ValaGirParserNode* _tmp281_;
								ValaGirParserNode* _tmp282_;
								_tmp281_ = g;
								_tmp282_ = _vala_gir_parser_node_ref0 (_tmp281_);
								_vala_gir_parser_node_unref0 (getter);
								getter = _tmp282_;
							}
							_vala_gir_parser_node_unref0 (g);
						}
					}
				}
				setter = NULL;
				_tmp283_ = self->parent;
				_tmp284_ = self->name;
				_tmp285_ = g_strdup_printf ("set_%s", _tmp284_);
				_tmp286_ = _tmp285_;
				_tmp287_ = vala_gir_parser_node_lookup_all (_tmp283_, _tmp286_);
				_tmp288_ = _tmp287_;
				_g_free0 (_tmp286_);
				setters = _tmp288_;
				_tmp289_ = setters;
				if (_tmp289_ != NULL) {
					{
						ValaArrayList* _s_list = NULL;
						ValaArrayList* _tmp290_;
						gint _s_size = 0;
						ValaArrayList* _tmp291_;
						gint _tmp292_;
						gint _tmp293_;
						gint _s_index = 0;
						_tmp290_ = setters;
						_s_list = _tmp290_;
						_tmp291_ = _s_list;
						_tmp292_ = vala_collection_get_size ((ValaCollection*) _tmp291_);
						_tmp293_ = _tmp292_;
						_s_size = _tmp293_;
						_s_index = -1;
						while (TRUE) {
							gint _tmp294_;
							gint _tmp295_;
							ValaGirParserNode* s = NULL;
							ValaArrayList* _tmp296_;
							gpointer _tmp297_;
							gboolean _tmp298_ = FALSE;
							gboolean _tmp299_ = FALSE;
							ValaGirParserNode* _tmp300_;
							_s_index = _s_index + 1;
							_tmp294_ = _s_index;
							_tmp295_ = _s_size;
							if (!(_tmp294_ < _tmp295_)) {
								break;
							}
							_tmp296_ = _s_list;
							_tmp297_ = vala_list_get ((ValaList*) _tmp296_, _s_index);
							s = (ValaGirParserNode*) _tmp297_;
							_tmp300_ = setter;
							if (_tmp300_ == NULL) {
								_tmp299_ = TRUE;
							} else {
								ValaGirParserNode* _tmp301_;
								_tmp301_ = s;
								_tmp299_ = !_tmp301_->merged;
							}
							if (_tmp299_) {
								ValaGirParserNode* _tmp302_;
								gchar* _tmp303_;
								gchar* _tmp304_;
								ValaGirParserNode* _tmp305_;
								gchar* _tmp306_;
								gchar* _tmp307_;
								const gchar* _tmp308_;
								gchar* _tmp309_;
								gchar* _tmp310_;
								_tmp302_ = s;
								_tmp303_ = vala_gir_parser_node_get_cname (_tmp302_);
								_tmp304_ = _tmp303_;
								_tmp305_ = self->parent;
								_tmp306_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp305_);
								_tmp307_ = _tmp306_;
								_tmp308_ = self->name;
								_tmp309_ = g_strdup_printf ("%sset_%s", _tmp307_, _tmp308_);
								_tmp310_ = _tmp309_;
								_tmp298_ = g_strcmp0 (_tmp304_, _tmp310_) == 0;
								_g_free0 (_tmp310_);
								_g_free0 (_tmp307_);
								_g_free0 (_tmp304_);
							} else {
								_tmp298_ = FALSE;
							}
							if (_tmp298_) {
								ValaGirParserNode* _tmp311_;
								ValaGirParserNode* _tmp312_;
								_tmp311_ = s;
								_tmp312_ = _vala_gir_parser_node_ref0 (_tmp311_);
								_vala_gir_parser_node_unref0 (setter);
								setter = _tmp312_;
							}
							_vala_gir_parser_node_unref0 (s);
						}
					}
				}
				_tmp314_ = readable;
				if (g_strcmp0 (_tmp314_, "0") == 0) {
					const gchar* _tmp315_;
					_tmp315_ = construct_only;
					_tmp313_ = g_strcmp0 (_tmp315_, "1") == 0;
				} else {
					_tmp313_ = FALSE;
				}
				_tmp316_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp316_, "NoAccessorMethod", _tmp313_, NULL);
				_tmp317_ = prop;
				_tmp318_ = vala_property_get_get_accessor (_tmp317_);
				_tmp319_ = _tmp318_;
				if (_tmp319_ != NULL) {
					ValaMethod* _tmp320_ = NULL;
					ValaGirParserNode* _tmp321_;
					ValaMethod* m = NULL;
					ValaMethod* _tmp324_;
					ValaMethod* _tmp325_;
					_tmp321_ = getter;
					if (_tmp321_ != NULL) {
						ValaGirParserNode* _tmp322_;
						ValaSymbol* _tmp323_;
						_tmp322_ = getter;
						_tmp323_ = _tmp322_->symbol;
						_tmp320_ = VALA_IS_METHOD (_tmp323_) ? ((ValaMethod*) _tmp323_) : NULL;
					} else {
						_tmp320_ = NULL;
					}
					_tmp324_ = _vala_code_node_ref0 (_tmp320_);
					m = _tmp324_;
					_tmp325_ = m;
					if (_tmp325_ != NULL) {
						ValaGirParserNode* _tmp326_;
						gboolean _tmp327_ = FALSE;
						gboolean _tmp328_ = FALSE;
						ValaMethod* _tmp329_;
						ValaDataType* _tmp330_;
						ValaDataType* _tmp331_;
						_tmp326_ = getter;
						vala_gir_parser_node_process (_tmp326_, parser);
						_tmp329_ = m;
						_tmp330_ = vala_callable_get_return_type ((ValaCallable*) _tmp329_);
						_tmp331_ = _tmp330_;
						if (VALA_IS_VOID_TYPE (_tmp331_)) {
							_tmp328_ = TRUE;
						} else {
							ValaMethod* _tmp332_;
							ValaList* _tmp333_;
							gint _tmp334_;
							gint _tmp335_;
							_tmp332_ = m;
							_tmp333_ = vala_callable_get_parameters ((ValaCallable*) _tmp332_);
							_tmp334_ = vala_collection_get_size ((ValaCollection*) _tmp333_);
							_tmp335_ = _tmp334_;
							_tmp328_ = _tmp335_ != 0;
						}
						if (_tmp328_) {
							_tmp327_ = TRUE;
						} else {
							ValaMethod* _tmp336_;
							gboolean _tmp337_;
							gboolean _tmp338_;
							_tmp336_ = m;
							_tmp337_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp336_);
							_tmp338_ = _tmp337_;
							_tmp327_ = _tmp338_;
						}
						if (_tmp327_) {
							ValaProperty* _tmp339_;
							_tmp339_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp339_, "NoAccessorMethod", TRUE, NULL);
						} else {
							ValaGirParserNode* _tmp340_;
							const gchar* _tmp341_;
							const gchar* _tmp342_;
							ValaProperty* _tmp354_;
							ValaPropertyAccessor* _tmp355_;
							ValaPropertyAccessor* _tmp356_;
							ValaDataType* _tmp357_;
							ValaDataType* _tmp358_;
							ValaMethod* _tmp359_;
							ValaDataType* _tmp360_;
							ValaDataType* _tmp361_;
							gboolean _tmp362_;
							gboolean _tmp363_;
							gboolean _tmp364_ = FALSE;
							gboolean _tmp365_ = FALSE;
							ValaMethod* _tmp366_;
							gboolean _tmp367_;
							gboolean _tmp368_;
							_tmp340_ = getter;
							_tmp341_ = _tmp340_->name;
							_tmp342_ = self->name;
							if (g_strcmp0 (_tmp341_, _tmp342_) == 0) {
								{
									ValaArrayList* _node_list = NULL;
									ValaArrayList* _tmp343_;
									gint _node_size = 0;
									ValaArrayList* _tmp344_;
									gint _tmp345_;
									gint _tmp346_;
									gint _node_index = 0;
									_tmp343_ = colliding;
									_node_list = _tmp343_;
									_tmp344_ = _node_list;
									_tmp345_ = vala_collection_get_size ((ValaCollection*) _tmp344_);
									_tmp346_ = _tmp345_;
									_node_size = _tmp346_;
									_node_index = -1;
									while (TRUE) {
										gint _tmp347_;
										gint _tmp348_;
										ValaGirParserNode* node = NULL;
										ValaArrayList* _tmp349_;
										gpointer _tmp350_;
										ValaGirParserNode* _tmp351_;
										ValaSymbol* _tmp352_;
										_node_index = _node_index + 1;
										_tmp347_ = _node_index;
										_tmp348_ = _node_size;
										if (!(_tmp347_ < _tmp348_)) {
											break;
										}
										_tmp349_ = _node_list;
										_tmp350_ = vala_list_get ((ValaList*) _tmp349_, _node_index);
										node = (ValaGirParserNode*) _tmp350_;
										_tmp351_ = node;
										_tmp352_ = _tmp351_->symbol;
										if (VALA_IS_METHOD (_tmp352_)) {
											ValaGirParserNode* _tmp353_;
											_tmp353_ = node;
											_tmp353_->merged = TRUE;
										}
										_vala_gir_parser_node_unref0 (node);
									}
								}
							}
							_tmp354_ = prop;
							_tmp355_ = vala_property_get_get_accessor (_tmp354_);
							_tmp356_ = _tmp355_;
							_tmp357_ = vala_property_accessor_get_value_type (_tmp356_);
							_tmp358_ = _tmp357_;
							_tmp359_ = m;
							_tmp360_ = vala_callable_get_return_type ((ValaCallable*) _tmp359_);
							_tmp361_ = _tmp360_;
							_tmp362_ = vala_data_type_get_value_owned (_tmp361_);
							_tmp363_ = _tmp362_;
							vala_data_type_set_value_owned (_tmp358_, _tmp363_);
							_tmp366_ = m;
							_tmp367_ = vala_method_get_is_abstract (_tmp366_);
							_tmp368_ = _tmp367_;
							if (!_tmp368_) {
								ValaMethod* _tmp369_;
								gboolean _tmp370_;
								gboolean _tmp371_;
								_tmp369_ = m;
								_tmp370_ = vala_method_get_is_virtual (_tmp369_);
								_tmp371_ = _tmp370_;
								_tmp365_ = !_tmp371_;
							} else {
								_tmp365_ = FALSE;
							}
							if (_tmp365_) {
								ValaProperty* _tmp372_;
								gboolean _tmp373_;
								gboolean _tmp374_;
								_tmp372_ = prop;
								_tmp373_ = vala_property_get_is_abstract (_tmp372_);
								_tmp374_ = _tmp373_;
								_tmp364_ = _tmp374_;
							} else {
								_tmp364_ = FALSE;
							}
							if (_tmp364_) {
								ValaProperty* _tmp375_;
								_tmp375_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp375_, "ConcreteAccessor", TRUE, NULL);
							}
						}
					} else {
						ValaProperty* _tmp376_;
						_tmp376_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp376_, "NoAccessorMethod", TRUE, NULL);
					}
					_vala_code_node_unref0 (m);
				}
				_tmp379_ = prop;
				if (!vala_code_node_has_attribute ((ValaCodeNode*) _tmp379_, "NoAccessorMethod")) {
					ValaProperty* _tmp380_;
					ValaPropertyAccessor* _tmp381_;
					ValaPropertyAccessor* _tmp382_;
					_tmp380_ = prop;
					_tmp381_ = vala_property_get_set_accessor (_tmp380_);
					_tmp382_ = _tmp381_;
					_tmp378_ = _tmp382_ != NULL;
				} else {
					_tmp378_ = FALSE;
				}
				if (_tmp378_) {
					ValaProperty* _tmp383_;
					ValaPropertyAccessor* _tmp384_;
					ValaPropertyAccessor* _tmp385_;
					gboolean _tmp386_;
					gboolean _tmp387_;
					_tmp383_ = prop;
					_tmp384_ = vala_property_get_set_accessor (_tmp383_);
					_tmp385_ = _tmp384_;
					_tmp386_ = vala_property_accessor_get_writable (_tmp385_);
					_tmp387_ = _tmp386_;
					_tmp377_ = _tmp387_;
				} else {
					_tmp377_ = FALSE;
				}
				if (_tmp377_) {
					ValaMethod* _tmp388_ = NULL;
					ValaGirParserNode* _tmp389_;
					ValaMethod* m = NULL;
					ValaMethod* _tmp392_;
					ValaMethod* _tmp393_;
					_tmp389_ = setter;
					if (_tmp389_ != NULL) {
						ValaGirParserNode* _tmp390_;
						ValaSymbol* _tmp391_;
						_tmp390_ = setter;
						_tmp391_ = _tmp390_->symbol;
						_tmp388_ = VALA_IS_METHOD (_tmp391_) ? ((ValaMethod*) _tmp391_) : NULL;
					} else {
						_tmp388_ = NULL;
					}
					_tmp392_ = _vala_code_node_ref0 (_tmp388_);
					m = _tmp392_;
					_tmp393_ = m;
					if (_tmp393_ != NULL) {
						ValaGirParserNode* _tmp394_;
						gboolean _tmp395_ = FALSE;
						gboolean _tmp396_ = FALSE;
						gboolean _tmp397_ = FALSE;
						ValaMethod* _tmp398_;
						ValaDataType* _tmp399_;
						ValaDataType* _tmp400_;
						_tmp394_ = setter;
						vala_gir_parser_node_process (_tmp394_, parser);
						_tmp398_ = m;
						_tmp399_ = vala_callable_get_return_type ((ValaCallable*) _tmp398_);
						_tmp400_ = _tmp399_;
						if (VALA_IS_VOID_TYPE (_tmp400_)) {
							_tmp397_ = TRUE;
						} else {
							ValaMethod* _tmp401_;
							ValaDataType* _tmp402_;
							ValaDataType* _tmp403_;
							_tmp401_ = m;
							_tmp402_ = vala_callable_get_return_type ((ValaCallable*) _tmp401_);
							_tmp403_ = _tmp402_;
							_tmp397_ = VALA_IS_BOOLEAN_TYPE (_tmp403_);
						}
						if (!_tmp397_) {
							_tmp396_ = TRUE;
						} else {
							ValaMethod* _tmp404_;
							ValaList* _tmp405_;
							gint _tmp406_;
							gint _tmp407_;
							_tmp404_ = m;
							_tmp405_ = vala_callable_get_parameters ((ValaCallable*) _tmp404_);
							_tmp406_ = vala_collection_get_size ((ValaCollection*) _tmp405_);
							_tmp407_ = _tmp406_;
							_tmp396_ = _tmp407_ != 1;
						}
						if (_tmp396_) {
							_tmp395_ = TRUE;
						} else {
							ValaMethod* _tmp408_;
							gboolean _tmp409_;
							gboolean _tmp410_;
							_tmp408_ = m;
							_tmp409_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp408_);
							_tmp410_ = _tmp409_;
							_tmp395_ = _tmp410_;
						}
						if (_tmp395_) {
							ValaProperty* _tmp411_;
							ValaProperty* _tmp412_;
							_tmp411_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp411_, "NoAccessorMethod", TRUE, NULL);
							_tmp412_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp412_, "ConcreteAccessor", FALSE, NULL);
						} else {
							ValaProperty* _tmp413_;
							ValaPropertyAccessor* _tmp414_;
							ValaPropertyAccessor* _tmp415_;
							ValaDataType* _tmp416_;
							ValaDataType* _tmp417_;
							ValaMethod* _tmp418_;
							ValaList* _tmp419_;
							gpointer _tmp420_;
							ValaParameter* _tmp421_;
							ValaDataType* _tmp422_;
							ValaDataType* _tmp423_;
							gboolean _tmp424_;
							gboolean _tmp425_;
							gboolean _tmp426_ = FALSE;
							gboolean _tmp427_ = FALSE;
							gboolean _tmp428_ = FALSE;
							ValaProperty* _tmp429_;
							_tmp413_ = prop;
							_tmp414_ = vala_property_get_set_accessor (_tmp413_);
							_tmp415_ = _tmp414_;
							_tmp416_ = vala_property_accessor_get_value_type (_tmp415_);
							_tmp417_ = _tmp416_;
							_tmp418_ = m;
							_tmp419_ = vala_callable_get_parameters ((ValaCallable*) _tmp418_);
							_tmp420_ = vala_list_get (_tmp419_, 0);
							_tmp421_ = (ValaParameter*) _tmp420_;
							_tmp422_ = vala_variable_get_variable_type ((ValaVariable*) _tmp421_);
							_tmp423_ = _tmp422_;
							_tmp424_ = vala_data_type_get_value_owned (_tmp423_);
							_tmp425_ = _tmp424_;
							vala_data_type_set_value_owned (_tmp417_, _tmp425_);
							_vala_code_node_unref0 (_tmp421_);
							_tmp429_ = prop;
							if (vala_code_node_has_attribute ((ValaCodeNode*) _tmp429_, "ConcreteAccessor")) {
								ValaMethod* _tmp430_;
								gboolean _tmp431_;
								gboolean _tmp432_;
								_tmp430_ = m;
								_tmp431_ = vala_method_get_is_abstract (_tmp430_);
								_tmp432_ = _tmp431_;
								_tmp428_ = !_tmp432_;
							} else {
								_tmp428_ = FALSE;
							}
							if (_tmp428_) {
								ValaMethod* _tmp433_;
								gboolean _tmp434_;
								gboolean _tmp435_;
								_tmp433_ = m;
								_tmp434_ = vala_method_get_is_virtual (_tmp433_);
								_tmp435_ = _tmp434_;
								_tmp427_ = !_tmp435_;
							} else {
								_tmp427_ = FALSE;
							}
							if (_tmp427_) {
								ValaProperty* _tmp436_;
								gboolean _tmp437_;
								gboolean _tmp438_;
								_tmp436_ = prop;
								_tmp437_ = vala_property_get_is_abstract (_tmp436_);
								_tmp438_ = _tmp437_;
								_tmp426_ = _tmp438_;
							} else {
								_tmp426_ = FALSE;
							}
							if (_tmp426_) {
								ValaProperty* _tmp439_;
								ValaProperty* _tmp440_;
								_tmp439_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp439_, "ConcreteAccessor", TRUE, NULL);
								_tmp440_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp440_, "NoAccessorMethod", FALSE, NULL);
							}
						}
					} else {
						ValaProperty* _tmp441_;
						ValaProperty* _tmp442_;
						_tmp441_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp441_, "NoAccessorMethod", TRUE, NULL);
						_tmp442_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp442_, "ConcreteAccessor", FALSE, NULL);
					}
					_vala_code_node_unref0 (m);
				}
				_tmp443_ = prop;
				if (vala_code_node_has_attribute ((ValaCodeNode*) _tmp443_, "NoAccessorMethod")) {
					gboolean _tmp444_ = FALSE;
					ValaProperty* _tmp445_;
					gboolean _tmp446_;
					gboolean _tmp447_;
					_tmp445_ = prop;
					_tmp446_ = vala_property_get_overrides (_tmp445_);
					_tmp447_ = _tmp446_;
					if (!_tmp447_) {
						ValaGirParserNode* _tmp448_;
						ValaSymbol* _tmp449_;
						_tmp448_ = self->parent;
						_tmp449_ = _tmp448_->symbol;
						_tmp444_ = VALA_IS_CLASS (_tmp449_);
					} else {
						_tmp444_ = FALSE;
					}
					if (_tmp444_) {
						ValaGirParserNode* base_prop_node = NULL;
						ValaGirParserNode* _tmp450_;
						ValaGirParserNode* _tmp451_;
						_tmp450_ = vala_gir_parser_base_interface_property (parser, self);
						base_prop_node = _tmp450_;
						_tmp451_ = base_prop_node;
						if (_tmp451_ != NULL) {
							ValaGirParserNode* _tmp452_;
							ValaProperty* base_property = NULL;
							ValaGirParserNode* _tmp453_;
							ValaSymbol* _tmp454_;
							ValaProperty* _tmp455_;
							ValaProperty* _tmp456_;
							_tmp452_ = base_prop_node;
							vala_gir_parser_node_process (_tmp452_, parser);
							_tmp453_ = base_prop_node;
							_tmp454_ = _tmp453_->symbol;
							_tmp455_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp454_, VALA_TYPE_PROPERTY, ValaProperty));
							base_property = _tmp455_;
							_tmp456_ = base_property;
							if (vala_code_node_has_attribute ((ValaCodeNode*) _tmp456_, "ConcreteAccessor")) {
								ValaProperty* _tmp457_;
								ValaProperty* _tmp458_;
								ValaPropertyAccessor* _tmp459_;
								ValaPropertyAccessor* _tmp460_;
								ValaProperty* _tmp473_;
								ValaPropertyAccessor* _tmp474_;
								ValaPropertyAccessor* _tmp475_;
								_tmp457_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp457_, "NoAccessorMethod", FALSE, NULL);
								_tmp458_ = prop;
								_tmp459_ = vala_property_get_get_accessor (_tmp458_);
								_tmp460_ = _tmp459_;
								if (_tmp460_ != NULL) {
									ValaProperty* _tmp461_;
									ValaPropertyAccessor* _tmp462_;
									ValaPropertyAccessor* _tmp463_;
									ValaDataType* _tmp464_;
									ValaDataType* _tmp465_;
									ValaProperty* _tmp466_;
									ValaPropertyAccessor* _tmp467_;
									ValaPropertyAccessor* _tmp468_;
									ValaDataType* _tmp469_;
									ValaDataType* _tmp470_;
									gboolean _tmp471_;
									gboolean _tmp472_;
									_tmp461_ = prop;
									_tmp462_ = vala_property_get_get_accessor (_tmp461_);
									_tmp463_ = _tmp462_;
									_tmp464_ = vala_property_accessor_get_value_type (_tmp463_);
									_tmp465_ = _tmp464_;
									_tmp466_ = base_property;
									_tmp467_ = vala_property_get_get_accessor (_tmp466_);
									_tmp468_ = _tmp467_;
									_tmp469_ = vala_property_accessor_get_value_type (_tmp468_);
									_tmp470_ = _tmp469_;
									_tmp471_ = vala_data_type_get_value_owned (_tmp470_);
									_tmp472_ = _tmp471_;
									vala_data_type_set_value_owned (_tmp465_, _tmp472_);
								}
								_tmp473_ = prop;
								_tmp474_ = vala_property_get_set_accessor (_tmp473_);
								_tmp475_ = _tmp474_;
								if (_tmp475_ != NULL) {
									ValaProperty* _tmp476_;
									ValaPropertyAccessor* _tmp477_;
									ValaPropertyAccessor* _tmp478_;
									ValaDataType* _tmp479_;
									ValaDataType* _tmp480_;
									ValaProperty* _tmp481_;
									ValaPropertyAccessor* _tmp482_;
									ValaPropertyAccessor* _tmp483_;
									ValaDataType* _tmp484_;
									ValaDataType* _tmp485_;
									gboolean _tmp486_;
									gboolean _tmp487_;
									_tmp476_ = prop;
									_tmp477_ = vala_property_get_set_accessor (_tmp476_);
									_tmp478_ = _tmp477_;
									_tmp479_ = vala_property_accessor_get_value_type (_tmp478_);
									_tmp480_ = _tmp479_;
									_tmp481_ = base_property;
									_tmp482_ = vala_property_get_set_accessor (_tmp481_);
									_tmp483_ = _tmp482_;
									_tmp484_ = vala_property_accessor_get_value_type (_tmp483_);
									_tmp485_ = _tmp484_;
									_tmp486_ = vala_data_type_get_value_owned (_tmp485_);
									_tmp487_ = _tmp486_;
									vala_data_type_set_value_owned (_tmp480_, _tmp487_);
								}
							}
							_vala_code_node_unref0 (base_property);
						}
						_vala_gir_parser_node_unref0 (base_prop_node);
					}
				}
				_tmp488_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp488_, VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD)) {
					ValaProperty* _tmp489_;
					ValaGirParserMetadata* _tmp490_;
					_tmp489_ = prop;
					_tmp490_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp489_, "NoAccessorMethod", vala_gir_parser_metadata_get_bool (_tmp490_, VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD, FALSE), NULL);
				}
				_tmp491_ = prop;
				if (vala_code_node_has_attribute ((ValaCodeNode*) _tmp491_, "NoAccessorMethod")) {
					ValaProperty* _tmp492_;
					ValaPropertyAccessor* _tmp493_;
					ValaPropertyAccessor* _tmp494_;
					ValaProperty* _tmp500_;
					ValaPropertyAccessor* _tmp501_;
					ValaPropertyAccessor* _tmp502_;
					_tmp492_ = prop;
					_tmp493_ = vala_property_get_get_accessor (_tmp492_);
					_tmp494_ = _tmp493_;
					if (_tmp494_ != NULL) {
						ValaProperty* _tmp495_;
						ValaPropertyAccessor* _tmp496_;
						ValaPropertyAccessor* _tmp497_;
						ValaDataType* _tmp498_;
						ValaDataType* _tmp499_;
						_tmp495_ = prop;
						_tmp496_ = vala_property_get_get_accessor (_tmp495_);
						_tmp497_ = _tmp496_;
						_tmp498_ = vala_property_accessor_get_value_type (_tmp497_);
						_tmp499_ = _tmp498_;
						vala_data_type_set_value_owned (_tmp499_, TRUE);
					}
					_tmp500_ = prop;
					_tmp501_ = vala_property_get_set_accessor (_tmp500_);
					_tmp502_ = _tmp501_;
					if (_tmp502_ != NULL) {
						ValaProperty* _tmp503_;
						ValaPropertyAccessor* _tmp504_;
						ValaPropertyAccessor* _tmp505_;
						ValaDataType* _tmp506_;
						ValaDataType* _tmp507_;
						_tmp503_ = prop;
						_tmp504_ = vala_property_get_set_accessor (_tmp503_);
						_tmp505_ = _tmp504_;
						_tmp506_ = vala_property_accessor_get_value_type (_tmp505_);
						_tmp507_ = _tmp506_;
						vala_data_type_set_value_owned (_tmp507_, FALSE);
					}
				}
				_vala_iterable_unref0 (setters);
				_vala_gir_parser_node_unref0 (setter);
				_vala_iterable_unref0 (getters);
				_vala_gir_parser_node_unref0 (getter);
				_g_free0 (construct_only);
				_g_free0 (construct_);
				_g_free0 (writable);
				_g_free0 (readable);
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (colliding);
			} else {
				ValaSymbol* _tmp508_;
				_tmp508_ = self->symbol;
				if (VALA_IS_FIELD (_tmp508_)) {
					ValaField* field = NULL;
					ValaSymbol* _tmp509_;
					ValaField* _tmp510_;
					ValaArrayList* colliding = NULL;
					ValaGirParserNode* _tmp511_;
					const gchar* _tmp512_;
					ValaArrayList* _tmp513_;
					ValaArrayList* _tmp514_;
					gint _tmp515_;
					gint _tmp516_;
					ValaGirParserMetadata* _tmp517_;
					ValaGirParserMetadata* _tmp520_;
					ValaGirParserMetadata* _tmp525_;
					gboolean _tmp530_ = FALSE;
					ValaField* _tmp531_;
					ValaDataType* _tmp532_;
					ValaDataType* _tmp533_;
					_tmp509_ = self->symbol;
					_tmp510_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp509_, VALA_TYPE_FIELD, ValaField));
					field = _tmp510_;
					_tmp511_ = self->parent;
					_tmp512_ = self->name;
					_tmp513_ = vala_gir_parser_node_lookup_all (_tmp511_, _tmp512_);
					colliding = _tmp513_;
					_tmp514_ = colliding;
					_tmp515_ = vala_collection_get_size ((ValaCollection*) _tmp514_);
					_tmp516_ = _tmp515_;
					if (_tmp516_ > 1) {
						self->merged = TRUE;
					}
					_tmp517_ = self->metadata;
					if (vala_gir_parser_metadata_has_argument (_tmp517_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET)) {
						ValaField* _tmp518_;
						ValaGirParserMetadata* _tmp519_;
						_tmp518_ = field;
						_tmp519_ = self->metadata;
						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp518_, "CCode", "delegate_target", vala_gir_parser_metadata_get_bool (_tmp519_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET, FALSE), NULL);
					}
					_tmp520_ = self->metadata;
					if (vala_gir_parser_metadata_has_argument (_tmp520_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME)) {
						ValaField* _tmp521_;
						ValaGirParserMetadata* _tmp522_;
						gchar* _tmp523_;
						gchar* _tmp524_;
						_tmp521_ = field;
						_tmp522_ = self->metadata;
						_tmp523_ = vala_gir_parser_metadata_get_string (_tmp522_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME);
						_tmp524_ = _tmp523_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp521_, "CCode", "delegate_target_cname", _tmp524_, NULL);
						_g_free0 (_tmp524_);
					}
					_tmp525_ = self->metadata;
					if (vala_gir_parser_metadata_has_argument (_tmp525_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY_NOTIFY_CNAME)) {
						ValaField* _tmp526_;
						ValaGirParserMetadata* _tmp527_;
						gchar* _tmp528_;
						gchar* _tmp529_;
						_tmp526_ = field;
						_tmp527_ = self->metadata;
						_tmp528_ = vala_gir_parser_metadata_get_string (_tmp527_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY_NOTIFY_CNAME);
						_tmp529_ = _tmp528_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp526_, "CCode", "destroy_notify_cname", _tmp529_, NULL);
						_g_free0 (_tmp529_);
					}
					_tmp531_ = field;
					_tmp532_ = vala_variable_get_variable_type ((ValaVariable*) _tmp531_);
					_tmp533_ = _tmp532_;
					if (VALA_IS_DELEGATE_TYPE (_tmp533_)) {
						ValaGirParserNode* _tmp534_;
						ValaUnresolvedSymbol* _tmp535_;
						_tmp534_ = self->parent;
						_tmp535_ = _tmp534_->gtype_struct_for;
						_tmp530_ = _tmp535_ != NULL;
					} else {
						_tmp530_ = FALSE;
					}
					if (_tmp530_) {
						ValaDelegate* d = NULL;
						ValaField* _tmp536_;
						ValaDataType* _tmp537_;
						ValaDataType* _tmp538_;
						ValaDelegate* _tmp539_;
						ValaDelegate* _tmp540_;
						ValaDelegate* _tmp541_;
						ValaDelegate* _tmp542_;
						ValaGirParserNode* _tmp543_;
						ValaUnresolvedSymbol* _tmp544_;
						_tmp536_ = field;
						_tmp537_ = vala_variable_get_variable_type ((ValaVariable*) _tmp536_);
						_tmp538_ = _tmp537_;
						_tmp539_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp538_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp540_ = _tmp539_;
						_tmp541_ = _vala_code_node_ref0 (_tmp540_);
						d = _tmp541_;
						_tmp542_ = d;
						_tmp543_ = self->parent;
						_tmp544_ = _tmp543_->gtype_struct_for;
						vala_gir_parser_process_virtual_method_field (parser, self, _tmp542_, _tmp544_);
						self->merged = TRUE;
						_vala_code_node_unref0 (d);
					} else {
						ValaField* _tmp545_;
						ValaDataType* _tmp546_;
						ValaDataType* _tmp547_;
						_tmp545_ = field;
						_tmp546_ = vala_variable_get_variable_type ((ValaVariable*) _tmp545_);
						_tmp547_ = _tmp546_;
						if (VALA_IS_DELEGATE_TYPE (_tmp547_)) {
							ValaDelegate* d = NULL;
							ValaField* _tmp548_;
							ValaDataType* _tmp549_;
							ValaDataType* _tmp550_;
							ValaDelegate* _tmp551_;
							ValaDelegate* _tmp552_;
							ValaDelegate* _tmp553_;
							ValaDelegate* _tmp554_;
							const gchar* _tmp555_;
							const gchar* _tmp556_;
							ValaGirParserNode* _tmp557_;
							ValaGirParserNode* _tmp558_;
							ValaGirParserNode* _tmp559_;
							gboolean _tmp560_;
							_tmp548_ = field;
							_tmp549_ = vala_variable_get_variable_type ((ValaVariable*) _tmp548_);
							_tmp550_ = _tmp549_;
							_tmp551_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp550_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							_tmp552_ = _tmp551_;
							_tmp553_ = _vala_code_node_ref0 (_tmp552_);
							d = _tmp553_;
							_tmp554_ = d;
							_tmp555_ = vala_symbol_get_name ((ValaSymbol*) _tmp554_);
							_tmp556_ = _tmp555_;
							_tmp557_ = vala_gir_parser_node_lookup (self, _tmp556_, FALSE, NULL);
							_tmp558_ = _tmp557_;
							_tmp559_ = _tmp558_->parent;
							_tmp560_ = _tmp559_ == self;
							_vala_gir_parser_node_unref0 (_tmp558_);
							if (_tmp560_) {
								ValaDelegate* _tmp561_;
								gboolean _tmp562_ = FALSE;
								ValaDelegate* _tmp563_;
								gboolean _tmp564_;
								gboolean _tmp565_;
								ValaDelegate* _tmp568_;
								ValaGirParserNode* _tmp569_;
								ValaSymbol* _tmp570_;
								const gchar* _tmp571_;
								const gchar* _tmp572_;
								ValaDelegate* _tmp573_;
								const gchar* _tmp574_;
								const gchar* _tmp575_;
								gchar* _tmp576_;
								gchar* _tmp577_;
								gchar* _tmp578_;
								gchar* _tmp579_;
								ValaNamespace* _tmp580_;
								ValaDelegate* _tmp581_;
								_tmp561_ = d;
								vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp561_, "CCode", "has_typedef", FALSE, NULL);
								_tmp563_ = d;
								_tmp564_ = vala_delegate_get_has_target (_tmp563_);
								_tmp565_ = _tmp564_;
								if (_tmp565_) {
									ValaGirParserMetadata* _tmp566_;
									_tmp566_ = self->metadata;
									_tmp562_ = !vala_gir_parser_metadata_has_argument (_tmp566_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET);
								} else {
									_tmp562_ = FALSE;
								}
								if (_tmp562_) {
									ValaField* _tmp567_;
									_tmp567_ = field;
									vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp567_, "CCode", "delegate_target", FALSE, NULL);
								}
								_tmp568_ = d;
								_tmp569_ = self->parent;
								_tmp570_ = _tmp569_->symbol;
								_tmp571_ = vala_symbol_get_name (_tmp570_);
								_tmp572_ = _tmp571_;
								_tmp573_ = d;
								_tmp574_ = vala_symbol_get_name ((ValaSymbol*) _tmp573_);
								_tmp575_ = _tmp574_;
								_tmp576_ = vala_symbol_lower_case_to_camel_case (_tmp575_);
								_tmp577_ = _tmp576_;
								_tmp578_ = g_strdup_printf ("%s%sFunc", _tmp572_, _tmp577_);
								_tmp579_ = _tmp578_;
								vala_symbol_set_name ((ValaSymbol*) _tmp568_, _tmp579_);
								_g_free0 (_tmp579_);
								_g_free0 (_tmp577_);
								_tmp580_ = vala_gir_parser_get_parent_namespace (self);
								_tmp581_ = d;
								vala_symbol_add_delegate ((ValaSymbol*) _tmp580_, _tmp581_);
							}
							_vala_code_node_unref0 (d);
						} else {
							ValaField* _tmp582_;
							ValaDataType* _tmp583_;
							ValaDataType* _tmp584_;
							_tmp582_ = field;
							_tmp583_ = vala_variable_get_variable_type ((ValaVariable*) _tmp582_);
							_tmp584_ = _tmp583_;
							if (VALA_IS_ARRAY_TYPE (_tmp584_)) {
								ValaGirParserNode* array_length = NULL;
								ValaGirParserMetadata* _tmp585_;
								gboolean _tmp630_ = FALSE;
								ValaGirParserNode* _tmp631_;
								_tmp585_ = self->metadata;
								if (vala_gir_parser_metadata_has_argument (_tmp585_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD)) {
									ValaGirParserNode* _tmp586_;
									ValaGirParserMetadata* _tmp587_;
									gchar* _tmp588_;
									gchar* _tmp589_;
									ValaGirParserNode* _tmp590_;
									_tmp586_ = self->parent;
									_tmp587_ = self->metadata;
									_tmp588_ = vala_gir_parser_metadata_get_string (_tmp587_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD);
									_tmp589_ = _tmp588_;
									_tmp590_ = vala_gir_parser_node_lookup (_tmp586_, _tmp589_, FALSE, NULL);
									_vala_gir_parser_node_unref0 (array_length);
									array_length = _tmp590_;
									_g_free0 (_tmp589_);
								} else {
									gboolean _tmp591_ = FALSE;
									if (self->array_length_idx > -1) {
										ValaGirParserNode* _tmp592_;
										ValaArrayList* _tmp593_;
										gint _tmp594_;
										gint _tmp595_;
										_tmp592_ = self->parent;
										_tmp593_ = _tmp592_->members;
										_tmp594_ = vala_collection_get_size ((ValaCollection*) _tmp593_);
										_tmp595_ = _tmp594_;
										_tmp591_ = _tmp595_ > self->array_length_idx;
									} else {
										_tmp591_ = FALSE;
									}
									if (_tmp591_) {
										ValaGirParserNode* _tmp596_;
										ValaArrayList* _tmp597_;
										gpointer _tmp598_;
										_tmp596_ = self->parent;
										_tmp597_ = _tmp596_->members;
										_tmp598_ = vala_list_get ((ValaList*) _tmp597_, self->array_length_idx);
										_vala_gir_parser_node_unref0 (array_length);
										array_length = (ValaGirParserNode*) _tmp598_;
									} else {
										ValaGirParserNode* _tmp599_;
										ValaField* _tmp600_;
										const gchar* _tmp601_;
										const gchar* _tmp602_;
										gchar* _tmp603_;
										gchar* _tmp604_;
										ValaGirParserNode* _tmp605_;
										ValaGirParserNode* _tmp606_;
										_tmp599_ = self->parent;
										_tmp600_ = field;
										_tmp601_ = vala_symbol_get_name ((ValaSymbol*) _tmp600_);
										_tmp602_ = _tmp601_;
										_tmp603_ = g_strdup_printf ("n_%s", _tmp602_);
										_tmp604_ = _tmp603_;
										_tmp605_ = vala_gir_parser_node_lookup (_tmp599_, _tmp604_, FALSE, NULL);
										_vala_gir_parser_node_unref0 (array_length);
										array_length = _tmp605_;
										_g_free0 (_tmp604_);
										_tmp606_ = array_length;
										if (_tmp606_ == NULL) {
											ValaGirParserNode* _tmp607_;
											ValaField* _tmp608_;
											const gchar* _tmp609_;
											const gchar* _tmp610_;
											gchar* _tmp611_;
											gchar* _tmp612_;
											ValaGirParserNode* _tmp613_;
											ValaGirParserNode* _tmp614_;
											_tmp607_ = self->parent;
											_tmp608_ = field;
											_tmp609_ = vala_symbol_get_name ((ValaSymbol*) _tmp608_);
											_tmp610_ = _tmp609_;
											_tmp611_ = g_strdup_printf ("num_%s", _tmp610_);
											_tmp612_ = _tmp611_;
											_tmp613_ = vala_gir_parser_node_lookup (_tmp607_, _tmp612_, FALSE, NULL);
											_vala_gir_parser_node_unref0 (array_length);
											array_length = _tmp613_;
											_g_free0 (_tmp612_);
											_tmp614_ = array_length;
											if (_tmp614_ == NULL) {
												ValaGirParserNode* _tmp615_;
												ValaField* _tmp616_;
												const gchar* _tmp617_;
												const gchar* _tmp618_;
												gchar* _tmp619_;
												gchar* _tmp620_;
												ValaGirParserNode* _tmp621_;
												ValaGirParserNode* _tmp622_;
												_tmp615_ = self->parent;
												_tmp616_ = field;
												_tmp617_ = vala_symbol_get_name ((ValaSymbol*) _tmp616_);
												_tmp618_ = _tmp617_;
												_tmp619_ = g_strdup_printf ("%s_length", _tmp618_);
												_tmp620_ = _tmp619_;
												_tmp621_ = vala_gir_parser_node_lookup (_tmp615_, _tmp620_, FALSE, NULL);
												_vala_gir_parser_node_unref0 (array_length);
												array_length = _tmp621_;
												_g_free0 (_tmp620_);
												_tmp622_ = array_length;
												if (_tmp622_ == NULL) {
													ValaGirParserNode* _tmp623_;
													ValaField* _tmp624_;
													const gchar* _tmp625_;
													const gchar* _tmp626_;
													gchar* _tmp627_;
													gchar* _tmp628_;
													ValaGirParserNode* _tmp629_;
													_tmp623_ = self->parent;
													_tmp624_ = field;
													_tmp625_ = vala_symbol_get_name ((ValaSymbol*) _tmp624_);
													_tmp626_ = _tmp625_;
													_tmp627_ = g_strdup_printf ("%s_length1", _tmp626_);
													_tmp628_ = _tmp627_;
													_tmp629_ = vala_gir_parser_node_lookup (_tmp623_, _tmp628_, FALSE, NULL);
													_vala_gir_parser_node_unref0 (array_length);
													array_length = _tmp629_;
													_g_free0 (_tmp628_);
												}
											}
										}
									}
								}
								_tmp631_ = array_length;
								if (_tmp631_ != NULL) {
									ValaGirParserNode* _tmp632_;
									ValaSymbol* _tmp633_;
									_tmp632_ = array_length;
									_tmp633_ = _tmp632_->symbol;
									_tmp630_ = VALA_IS_FIELD (_tmp633_);
								} else {
									_tmp630_ = FALSE;
								}
								if (_tmp630_) {
									ValaField* length_field = NULL;
									ValaGirParserNode* _tmp634_;
									ValaSymbol* _tmp635_;
									ValaField* _tmp636_;
									ValaField* _tmp637_;
									ValaField* _tmp638_;
									const gchar* _tmp639_;
									const gchar* _tmp640_;
									gchar* length_type = NULL;
									ValaField* _tmp641_;
									ValaDataType* _tmp642_;
									ValaDataType* _tmp643_;
									gchar* _tmp644_;
									const gchar* _tmp645_;
									ValaField* _tmp654_;
									ValaField* _tmp655_;
									_tmp634_ = array_length;
									_tmp635_ = _tmp634_->symbol;
									_tmp636_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp635_, VALA_TYPE_FIELD, ValaField));
									length_field = _tmp636_;
									_tmp637_ = field;
									_tmp638_ = length_field;
									_tmp639_ = vala_symbol_get_name ((ValaSymbol*) _tmp638_);
									_tmp640_ = _tmp639_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp637_, "CCode", "array_length_cname", _tmp640_, NULL);
									_tmp641_ = length_field;
									_tmp642_ = vala_variable_get_variable_type ((ValaVariable*) _tmp641_);
									_tmp643_ = _tmp642_;
									_tmp644_ = vala_data_type_to_qualified_string (_tmp643_, NULL);
									length_type = _tmp644_;
									_tmp645_ = length_type;
									if (g_strcmp0 (_tmp645_, "int") != 0) {
										ValaGirParserNode* st = NULL;
										ValaGirParserNode* _tmp646_;
										const gchar* _tmp647_;
										ValaGirParserNode* _tmp648_;
										ValaGirParserNode* _tmp649_;
										_tmp646_ = parser->priv->root;
										_tmp647_ = length_type;
										_tmp648_ = vala_gir_parser_node_lookup (_tmp646_, _tmp647_, FALSE, NULL);
										st = _tmp648_;
										_tmp649_ = st;
										if (_tmp649_ != NULL) {
											ValaField* _tmp650_;
											ValaGirParserNode* _tmp651_;
											gchar* _tmp652_;
											gchar* _tmp653_;
											_tmp650_ = field;
											_tmp651_ = st;
											_tmp652_ = vala_gir_parser_node_get_cname (_tmp651_);
											_tmp653_ = _tmp652_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp650_, "CCode", "array_length_type", _tmp653_, NULL);
											_g_free0 (_tmp653_);
										}
										_vala_gir_parser_node_unref0 (st);
									}
									_tmp654_ = field;
									vala_code_node_remove_attribute_argument ((ValaCodeNode*) _tmp654_, "CCode", "array_length");
									_tmp655_ = field;
									vala_code_node_remove_attribute_argument ((ValaCodeNode*) _tmp655_, "CCode", "array_null_terminated");
									_g_free0 (length_type);
									_vala_code_node_unref0 (length_field);
								}
								_vala_gir_parser_node_unref0 (array_length);
							}
						}
					}
					_vala_iterable_unref0 (colliding);
					_vala_code_node_unref0 (field);
				} else {
					gboolean _tmp656_ = FALSE;
					ValaSymbol* _tmp657_;
					_tmp657_ = self->symbol;
					if (VALA_IS_SIGNAL (_tmp657_)) {
						_tmp656_ = TRUE;
					} else {
						ValaSymbol* _tmp658_;
						_tmp658_ = self->symbol;
						_tmp656_ = VALA_IS_DELEGATE (_tmp658_);
					}
					if (_tmp656_) {
						vala_gir_parser_process_callable (parser, self);
					} else {
						ValaSymbol* _tmp659_;
						_tmp659_ = self->symbol;
						if (VALA_IS_INTERFACE (_tmp659_)) {
							vala_gir_parser_process_interface (parser, self);
						} else {
							ValaSymbol* _tmp660_;
							_tmp660_ = self->symbol;
							if (VALA_IS_STRUCT (_tmp660_)) {
								gboolean _tmp661_ = FALSE;
								ValaGirParserNode* _tmp662_;
								ValaSymbol* _tmp663_;
								_tmp662_ = self->parent;
								_tmp663_ = _tmp662_->symbol;
								if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp663_)) {
									_tmp661_ = TRUE;
								} else {
									ValaGirParserNode* _tmp664_;
									ValaSymbol* _tmp665_;
									_tmp664_ = self->parent;
									_tmp665_ = _tmp664_->symbol;
									_tmp661_ = VALA_IS_STRUCT (_tmp665_);
								}
								if (_tmp661_) {
									{
										ValaArrayList* _fn_list = NULL;
										ValaArrayList* _tmp666_;
										gint _fn_size = 0;
										ValaArrayList* _tmp667_;
										gint _tmp668_;
										gint _tmp669_;
										gint _fn_index = 0;
										_tmp666_ = self->members;
										_fn_list = _tmp666_;
										_tmp667_ = _fn_list;
										_tmp668_ = vala_collection_get_size ((ValaCollection*) _tmp667_);
										_tmp669_ = _tmp668_;
										_fn_size = _tmp669_;
										_fn_index = -1;
										while (TRUE) {
											gint _tmp670_;
											gint _tmp671_;
											ValaGirParserNode* fn = NULL;
											ValaArrayList* _tmp672_;
											gpointer _tmp673_;
											ValaField* f = NULL;
											ValaGirParserNode* _tmp674_;
											ValaSymbol* _tmp675_;
											ValaField* _tmp676_;
											ValaField* _tmp677_;
											_fn_index = _fn_index + 1;
											_tmp670_ = _fn_index;
											_tmp671_ = _fn_size;
											if (!(_tmp670_ < _tmp671_)) {
												break;
											}
											_tmp672_ = _fn_list;
											_tmp673_ = vala_list_get ((ValaList*) _tmp672_, _fn_index);
											fn = (ValaGirParserNode*) _tmp673_;
											_tmp674_ = fn;
											_tmp675_ = _tmp674_->symbol;
											_tmp676_ = _vala_code_node_ref0 (VALA_IS_FIELD (_tmp675_) ? ((ValaField*) _tmp675_) : NULL);
											f = _tmp676_;
											_tmp677_ = f;
											if (_tmp677_ != NULL) {
												ValaField* _tmp678_;
												ValaMemberBinding _tmp679_;
												ValaMemberBinding _tmp680_;
												ValaField* _tmp688_;
												ValaSymbol* _tmp689_;
												const gchar* _tmp690_;
												const gchar* _tmp691_;
												ValaField* _tmp692_;
												const gchar* _tmp693_;
												const gchar* _tmp694_;
												gchar* _tmp695_;
												gchar* _tmp696_;
												ValaGirParserNode* _tmp697_;
												ValaField* _tmp698_;
												const gchar* _tmp699_;
												const gchar* _tmp700_;
												gchar* _tmp701_;
												ValaGirParserNode* _tmp702_;
												ValaGirParserNode* _tmp703_;
												_tmp678_ = f;
												_tmp679_ = vala_field_get_binding (_tmp678_);
												_tmp680_ = _tmp679_;
												if (_tmp680_ == VALA_MEMBER_BINDING_INSTANCE) {
													ValaField* _tmp681_;
													const gchar* _tmp682_;
													ValaGirParserNode* _tmp683_;
													gchar* _tmp684_;
													gchar* _tmp685_;
													gchar* _tmp686_;
													gchar* _tmp687_;
													_tmp681_ = f;
													_tmp682_ = self->name;
													_tmp683_ = fn;
													_tmp684_ = vala_gir_parser_node_get_cname (_tmp683_);
													_tmp685_ = _tmp684_;
													_tmp686_ = g_strdup_printf ("%s.%s", _tmp682_, _tmp685_);
													_tmp687_ = _tmp686_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp681_, "CCode", "cname", _tmp687_, NULL);
													_g_free0 (_tmp687_);
													_g_free0 (_tmp685_);
												}
												_tmp688_ = f;
												_tmp689_ = self->symbol;
												_tmp690_ = vala_symbol_get_name (_tmp689_);
												_tmp691_ = _tmp690_;
												_tmp692_ = f;
												_tmp693_ = vala_symbol_get_name ((ValaSymbol*) _tmp692_);
												_tmp694_ = _tmp693_;
												_tmp695_ = g_strdup_printf ("%s_%s", _tmp691_, _tmp694_);
												_tmp696_ = _tmp695_;
												vala_symbol_set_name ((ValaSymbol*) _tmp688_, _tmp696_);
												_g_free0 (_tmp696_);
												_tmp697_ = fn;
												_tmp698_ = f;
												_tmp699_ = vala_symbol_get_name ((ValaSymbol*) _tmp698_);
												_tmp700_ = _tmp699_;
												_tmp701_ = g_strdup (_tmp700_);
												_g_free0 (_tmp697_->name);
												_tmp697_->name = _tmp701_;
												_tmp702_ = self->parent;
												_tmp703_ = fn;
												vala_gir_parser_node_add_member (_tmp702_, _tmp703_);
											}
											_vala_code_node_unref0 (f);
											_vala_gir_parser_node_unref0 (fn);
										}
									}
									self->merged = TRUE;
								} else {
									ValaUnresolvedSymbol* _tmp704_;
									_tmp704_ = self->gtype_struct_for;
									if (_tmp704_ != NULL) {
										ValaGirParserNode* obj = NULL;
										ValaGirParserNode* _tmp705_;
										ValaUnresolvedSymbol* _tmp706_;
										ValaGirParserNode* _tmp707_;
										gboolean _tmp708_ = FALSE;
										gboolean _tmp709_ = FALSE;
										ValaGirParserNode* _tmp710_;
										_tmp705_ = self->parent;
										_tmp706_ = self->gtype_struct_for;
										_tmp707_ = vala_gir_parser_resolve_node (parser, _tmp705_, _tmp706_, FALSE);
										obj = _tmp707_;
										_tmp710_ = obj;
										if (_tmp710_ != NULL) {
											ValaGirParserNode* _tmp711_;
											ValaSymbol* _tmp712_;
											_tmp711_ = obj;
											_tmp712_ = _tmp711_->symbol;
											_tmp709_ = VALA_IS_INTERFACE (_tmp712_);
										} else {
											_tmp709_ = FALSE;
										}
										if (_tmp709_) {
											ValaGirParserNode* _tmp713_;
											gchar* _tmp714_;
											gchar* _tmp715_;
											gchar* _tmp716_;
											gchar* _tmp717_;
											gchar* _tmp718_;
											gchar* _tmp719_;
											_tmp713_ = obj;
											_tmp714_ = vala_gir_parser_node_get_cname (_tmp713_);
											_tmp715_ = _tmp714_;
											_tmp716_ = g_strdup_printf ("%sIface", _tmp715_);
											_tmp717_ = _tmp716_;
											_tmp718_ = vala_gir_parser_node_get_cname (self);
											_tmp719_ = _tmp718_;
											_tmp708_ = g_strcmp0 (_tmp717_, _tmp719_) != 0;
											_g_free0 (_tmp719_);
											_g_free0 (_tmp717_);
											_g_free0 (_tmp715_);
										} else {
											_tmp708_ = FALSE;
										}
										if (_tmp708_) {
											ValaGirParserNode* _tmp720_;
											ValaSymbol* _tmp721_;
											gchar* _tmp722_;
											gchar* _tmp723_;
											_tmp720_ = obj;
											_tmp721_ = _tmp720_->symbol;
											_tmp722_ = vala_gir_parser_node_get_cname (self);
											_tmp723_ = _tmp722_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp721_, "CCode", "type_cname", _tmp723_, NULL);
											_g_free0 (_tmp723_);
										} else {
											gboolean _tmp724_ = FALSE;
											gboolean _tmp725_ = FALSE;
											ValaGirParserNode* _tmp726_;
											_tmp726_ = obj;
											if (_tmp726_ != NULL) {
												ValaGirParserNode* _tmp727_;
												ValaSymbol* _tmp728_;
												_tmp727_ = obj;
												_tmp728_ = _tmp727_->symbol;
												_tmp725_ = VALA_IS_CLASS (_tmp728_);
											} else {
												_tmp725_ = FALSE;
											}
											if (_tmp725_) {
												ValaGirParserNode* _tmp729_;
												gchar* _tmp730_;
												gchar* _tmp731_;
												gchar* _tmp732_;
												gchar* _tmp733_;
												gchar* _tmp734_;
												gchar* _tmp735_;
												_tmp729_ = obj;
												_tmp730_ = vala_gir_parser_node_get_cname (_tmp729_);
												_tmp731_ = _tmp730_;
												_tmp732_ = g_strdup_printf ("%sClass", _tmp731_);
												_tmp733_ = _tmp732_;
												_tmp734_ = vala_gir_parser_node_get_cname (self);
												_tmp735_ = _tmp734_;
												_tmp724_ = g_strcmp0 (_tmp733_, _tmp735_) != 0;
												_g_free0 (_tmp735_);
												_g_free0 (_tmp733_);
												_g_free0 (_tmp731_);
											} else {
												_tmp724_ = FALSE;
											}
											if (_tmp724_) {
												ValaGirParserNode* _tmp736_;
												ValaSymbol* _tmp737_;
												gchar* _tmp738_;
												gchar* _tmp739_;
												_tmp736_ = obj;
												_tmp737_ = _tmp736_->symbol;
												_tmp738_ = vala_gir_parser_node_get_cname (self);
												_tmp739_ = _tmp738_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp737_, "CCode", "type_cname", _tmp739_, NULL);
												_g_free0 (_tmp739_);
											}
										}
										self->merged = TRUE;
										_vala_gir_parser_node_unref0 (obj);
									}
								}
							}
						}
					}
				}
			}
		}
		_tmp740_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp740_, VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT)) {
			ValaGirParserMetadata* _tmp741_;
			gchar* _tmp742_;
			self->deprecated = TRUE;
			_tmp741_ = self->metadata;
			_tmp742_ = vala_gir_parser_metadata_get_string (_tmp741_, VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT);
			_g_free0 (self->deprecated_replacement);
			self->deprecated_replacement = _tmp742_;
		}
		_tmp743_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp743_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE)) {
			ValaGirParserMetadata* _tmp744_;
			gchar* _tmp745_;
			self->deprecated = TRUE;
			_tmp744_ = self->metadata;
			_tmp745_ = vala_gir_parser_metadata_get_string (_tmp744_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE);
			_g_free0 (self->deprecated_since);
			self->deprecated_since = _tmp745_;
		} else {
			ValaMap* _tmp746_;
			gpointer _tmp747_;
			gchar* _tmp748_;
			gboolean _tmp749_;
			_tmp746_ = self->girdata;
			_tmp747_ = vala_map_get (_tmp746_, "deprecated-version");
			_tmp748_ = (gchar*) _tmp747_;
			_tmp749_ = _tmp748_ != NULL;
			_g_free0 (_tmp748_);
			if (_tmp749_) {
				ValaMap* _tmp750_;
				gpointer _tmp751_;
				self->deprecated = TRUE;
				_tmp750_ = self->girdata;
				_tmp751_ = vala_map_get (_tmp750_, "deprecated-version");
				_g_free0 (self->deprecated_since);
				self->deprecated_since = (gchar*) _tmp751_;
			}
		}
		_tmp752_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp752_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED)) {
			ValaGirParserMetadata* _tmp753_;
			_tmp753_ = self->metadata;
			self->deprecated = vala_gir_parser_metadata_get_bool (_tmp753_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED, TRUE);
			if (!self->deprecated) {
				_g_free0 (self->deprecated_since);
				self->deprecated_since = NULL;
				_g_free0 (self->deprecated_replacement);
				self->deprecated_replacement = NULL;
			}
		} else {
			ValaMap* _tmp754_;
			gpointer _tmp755_;
			gchar* _tmp756_;
			gboolean _tmp757_;
			_tmp754_ = self->girdata;
			_tmp755_ = vala_map_get (_tmp754_, "deprecated");
			_tmp756_ = (gchar*) _tmp755_;
			_tmp757_ = _tmp756_ != NULL;
			_g_free0 (_tmp756_);
			if (_tmp757_) {
				self->deprecated = TRUE;
			}
		}
		_tmp758_ = self->deprecated_since;
		if (_tmp758_ != NULL) {
			const gchar* _tmp759_;
			_tmp759_ = self->deprecated_since;
			self->deprecated_version = vala_gir_parser_node_parse_version_string (_tmp759_);
		}
		_tmp760_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp760_, VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL)) {
			ValaSymbol* _tmp761_;
			ValaGirParserMetadata* _tmp762_;
			_tmp761_ = self->symbol;
			_tmp762_ = self->metadata;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp761_, "Version", "experimental", vala_gir_parser_metadata_get_bool (_tmp762_, VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL, FALSE), NULL);
		}
		_tmp763_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp763_, VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE)) {
			ValaSymbol* _tmp764_;
			ValaVersionAttribute* _tmp765_;
			ValaVersionAttribute* _tmp766_;
			ValaGirParserMetadata* _tmp767_;
			gchar* _tmp768_;
			gchar* _tmp769_;
			_tmp764_ = self->symbol;
			_tmp765_ = vala_symbol_get_version (_tmp764_);
			_tmp766_ = _tmp765_;
			_tmp767_ = self->metadata;
			_tmp768_ = vala_gir_parser_metadata_get_string (_tmp767_, VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE);
			_tmp769_ = _tmp768_;
			vala_version_attribute_set_since (_tmp766_, _tmp769_);
			_g_free0 (_tmp769_);
		} else {
			gboolean _tmp770_ = FALSE;
			ValaSymbol* _tmp771_;
			_tmp771_ = self->symbol;
			if (VALA_IS_NAMESPACE (_tmp771_) == FALSE) {
				ValaMap* _tmp772_;
				gpointer _tmp773_;
				gchar* _tmp774_;
				_tmp772_ = self->girdata;
				_tmp773_ = vala_map_get (_tmp772_, "version");
				_tmp774_ = (gchar*) _tmp773_;
				_tmp770_ = _tmp774_ != NULL;
				_g_free0 (_tmp774_);
			} else {
				_tmp770_ = FALSE;
			}
			if (_tmp770_) {
				ValaSymbol* _tmp775_;
				ValaVersionAttribute* _tmp776_;
				ValaVersionAttribute* _tmp777_;
				ValaMap* _tmp778_;
				gpointer _tmp779_;
				gchar* _tmp780_;
				_tmp775_ = self->symbol;
				_tmp776_ = vala_symbol_get_version (_tmp775_);
				_tmp777_ = _tmp776_;
				_tmp778_ = self->girdata;
				_tmp779_ = vala_map_get (_tmp778_, "version");
				_tmp780_ = (gchar*) _tmp779_;
				vala_version_attribute_set_since (_tmp777_, _tmp780_);
				_g_free0 (_tmp780_);
			}
		}
		_tmp781_ = self->parent;
		_tmp782_ = _tmp781_->symbol;
		if (VALA_IS_NAMESPACE (_tmp782_)) {
			ValaSymbol* _tmp783_;
			gchar* _tmp784_;
			gchar* _tmp785_;
			_tmp783_ = self->symbol;
			_tmp784_ = vala_gir_parser_node_get_cheader_filename (self);
			_tmp785_ = _tmp784_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp783_, "CCode", "cheader_filename", _tmp785_, NULL);
			_g_free0 (_tmp785_);
		} else {
			ValaGirParserMetadata* _tmp786_;
			_tmp786_ = self->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp786_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME)) {
				ValaSymbol* _tmp787_;
				ValaGirParserMetadata* _tmp788_;
				gchar* _tmp789_;
				gchar* _tmp790_;
				_tmp787_ = self->symbol;
				_tmp788_ = self->metadata;
				_tmp789_ = vala_gir_parser_metadata_get_string (_tmp788_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME);
				_tmp790_ = _tmp789_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp787_, "CCode", "cheader_filename", _tmp790_, NULL);
				_g_free0 (_tmp790_);
			}
		}
		_tmp791_ = vala_gir_parser_node_get_cname (self);
		_tmp792_ = _tmp791_;
		_tmp793_ = vala_gir_parser_node_get_default_cname (self);
		_tmp794_ = _tmp793_;
		_tmp795_ = g_strcmp0 (_tmp792_, _tmp794_) != 0;
		_g_free0 (_tmp794_);
		_g_free0 (_tmp792_);
		if (_tmp795_) {
			ValaSymbol* _tmp796_;
			gchar* _tmp797_;
			gchar* _tmp798_;
			_tmp796_ = self->symbol;
			_tmp797_ = vala_gir_parser_node_get_cname (self);
			_tmp798_ = _tmp797_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp796_, "CCode", "cname", _tmp798_, NULL);
			_g_free0 (_tmp798_);
		}
		_tmp799_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp799_, VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO)) {
			ValaSymbol* _tmp800_;
			ValaGirParserMetadata* _tmp801_;
			gchar* _tmp802_;
			gchar* _tmp803_;
			_tmp800_ = self->symbol;
			_tmp801_ = self->metadata;
			_tmp802_ = vala_gir_parser_metadata_get_string (_tmp801_, VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO);
			_tmp803_ = _tmp802_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp800_, "CCode", "feature_test_macro", _tmp803_, NULL);
			_g_free0 (_tmp803_);
		}
		_tmp804_ = vala_gir_parser_node_get_lower_case_cprefix (self);
		_tmp805_ = _tmp804_;
		_tmp806_ = vala_gir_parser_node_get_default_lower_case_cprefix (self);
		_tmp807_ = _tmp806_;
		_tmp808_ = g_strcmp0 (_tmp805_, _tmp807_) != 0;
		_g_free0 (_tmp807_);
		_g_free0 (_tmp805_);
		if (_tmp808_) {
			ValaSymbol* _tmp809_;
			gchar* _tmp810_;
			gchar* _tmp811_;
			_tmp809_ = self->symbol;
			_tmp810_ = vala_gir_parser_node_get_lower_case_cprefix (self);
			_tmp811_ = _tmp810_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp809_, "CCode", "lower_case_cprefix", _tmp811_, NULL);
			_g_free0 (_tmp811_);
		}
		_tmp812_ = vala_gir_parser_node_get_lower_case_csuffix (self);
		_tmp813_ = _tmp812_;
		_tmp814_ = vala_gir_parser_node_get_default_lower_case_csuffix (self);
		_tmp815_ = _tmp814_;
		_tmp816_ = g_strcmp0 (_tmp813_, _tmp815_) != 0;
		_g_free0 (_tmp815_);
		_g_free0 (_tmp813_);
		if (_tmp816_) {
			ValaSymbol* _tmp817_;
			gchar* _tmp818_;
			gchar* _tmp819_;
			_tmp817_ = self->symbol;
			_tmp818_ = vala_gir_parser_node_get_lower_case_csuffix (self);
			_tmp819_ = _tmp818_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp817_, "CCode", "lower_case_csuffix", _tmp819_, NULL);
			_g_free0 (_tmp819_);
		}
		_tmp820_ = vala_gir_parser_node_get_gir_name (self);
		gir_name = _tmp820_;
		_tmp821_ = vala_gir_parser_node_get_default_gir_name (self);
		default_gir_name = _tmp821_;
		_tmp824_ = self->symbol;
		if (vala_gir_parser_is_container (_tmp824_)) {
			ValaSymbol* _tmp825_;
			_tmp825_ = self->symbol;
			_tmp823_ = !VALA_IS_NAMESPACE (_tmp825_);
		} else {
			_tmp823_ = FALSE;
		}
		if (_tmp823_) {
			gboolean _tmp826_ = FALSE;
			const gchar* _tmp827_;
			const gchar* _tmp828_;
			_tmp827_ = self->name;
			_tmp828_ = gir_name;
			if (g_strcmp0 (_tmp827_, _tmp828_) != 0) {
				_tmp826_ = TRUE;
			} else {
				const gchar* _tmp829_;
				const gchar* _tmp830_;
				_tmp829_ = gir_name;
				_tmp830_ = default_gir_name;
				_tmp826_ = g_strcmp0 (_tmp829_, _tmp830_) != 0;
			}
			_tmp822_ = _tmp826_;
		} else {
			_tmp822_ = FALSE;
		}
		if (_tmp822_) {
			ValaSymbol* _tmp831_;
			const gchar* _tmp832_;
			_tmp831_ = self->symbol;
			_tmp832_ = gir_name;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp831_, "GIR", "name", _tmp832_, NULL);
		}
		_g_free0 (default_gir_name);
		_g_free0 (gir_name);
	}
	if (self->new_symbol) {
		_tmp834_ = self->merged;
	} else {
		_tmp834_ = FALSE;
	}
	if (!_tmp834_) {
		ValaSymbol* _tmp835_;
		_tmp835_ = self->symbol;
		_tmp833_ = vala_gir_parser_is_container (_tmp835_);
	} else {
		_tmp833_ = FALSE;
	}
	if (_tmp833_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp889_;
		ValaClass* _tmp890_;
		gboolean _tmp891_ = FALSE;
		gboolean _tmp892_ = FALSE;
		ValaClass* _tmp893_;
		{
			ValaArrayList* _node_list = NULL;
			ValaArrayList* _tmp836_;
			gint _node_size = 0;
			ValaArrayList* _tmp837_;
			gint _tmp838_;
			gint _tmp839_;
			gint _node_index = 0;
			_tmp836_ = self->members;
			_node_list = _tmp836_;
			_tmp837_ = _node_list;
			_tmp838_ = vala_collection_get_size ((ValaCollection*) _tmp837_);
			_tmp839_ = _tmp838_;
			_node_size = _tmp839_;
			_node_index = -1;
			while (TRUE) {
				gint _tmp840_;
				gint _tmp841_;
				ValaGirParserNode* node = NULL;
				ValaArrayList* _tmp842_;
				gpointer _tmp843_;
				gboolean _tmp844_ = FALSE;
				ValaGirParserNode* _tmp850_;
				ValaGirParserNode* _tmp855_;
				const gchar* _tmp856_;
				ValaGirParserNode* _tmp863_;
				const gchar* _tmp864_;
				gboolean _tmp871_ = FALSE;
				gboolean _tmp872_ = FALSE;
				ValaGirParserNode* _tmp873_;
				_node_index = _node_index + 1;
				_tmp840_ = _node_index;
				_tmp841_ = _node_size;
				if (!(_tmp840_ < _tmp841_)) {
					break;
				}
				_tmp842_ = _node_list;
				_tmp843_ = vala_list_get ((ValaList*) _tmp842_, _node_index);
				node = (ValaGirParserNode*) _tmp843_;
				if (self->deprecated_version > ((guint64) 0)) {
					ValaGirParserNode* _tmp845_;
					_tmp845_ = node;
					_tmp844_ = _tmp845_->deprecated_version > ((guint64) 0);
				} else {
					_tmp844_ = FALSE;
				}
				if (_tmp844_) {
					ValaGirParserNode* _tmp846_;
					_tmp846_ = node;
					if (self->deprecated_version <= _tmp846_->deprecated_version) {
						ValaGirParserNode* _tmp847_;
						ValaGirParserNode* _tmp848_;
						ValaGirParserNode* _tmp849_;
						_tmp847_ = node;
						_tmp847_->deprecated = FALSE;
						_tmp848_ = node;
						_g_free0 (_tmp848_->deprecated_since);
						_tmp848_->deprecated_since = NULL;
						_tmp849_ = node;
						_g_free0 (_tmp849_->deprecated_replacement);
						_tmp849_->deprecated_replacement = NULL;
					}
				}
				_tmp850_ = node;
				if (_tmp850_->deprecated) {
					ValaGirParserNode* _tmp851_;
					ValaSymbol* _tmp852_;
					ValaVersionAttribute* _tmp853_;
					ValaVersionAttribute* _tmp854_;
					_tmp851_ = node;
					_tmp852_ = _tmp851_->symbol;
					_tmp853_ = vala_symbol_get_version (_tmp852_);
					_tmp854_ = _tmp853_;
					vala_version_attribute_set_deprecated (_tmp854_, TRUE);
				}
				_tmp855_ = node;
				_tmp856_ = _tmp855_->deprecated_since;
				if (_tmp856_ != NULL) {
					ValaGirParserNode* _tmp857_;
					ValaSymbol* _tmp858_;
					ValaVersionAttribute* _tmp859_;
					ValaVersionAttribute* _tmp860_;
					ValaGirParserNode* _tmp861_;
					const gchar* _tmp862_;
					_tmp857_ = node;
					_tmp858_ = _tmp857_->symbol;
					_tmp859_ = vala_symbol_get_version (_tmp858_);
					_tmp860_ = _tmp859_;
					_tmp861_ = node;
					_tmp862_ = _tmp861_->deprecated_since;
					vala_version_attribute_set_deprecated_since (_tmp860_, _tmp862_);
				}
				_tmp863_ = node;
				_tmp864_ = _tmp863_->deprecated_replacement;
				if (_tmp864_ != NULL) {
					ValaGirParserNode* _tmp865_;
					ValaSymbol* _tmp866_;
					ValaVersionAttribute* _tmp867_;
					ValaVersionAttribute* _tmp868_;
					ValaGirParserNode* _tmp869_;
					const gchar* _tmp870_;
					_tmp865_ = node;
					_tmp866_ = _tmp865_->symbol;
					_tmp867_ = vala_symbol_get_version (_tmp866_);
					_tmp868_ = _tmp867_;
					_tmp869_ = node;
					_tmp870_ = _tmp869_->deprecated_replacement;
					vala_version_attribute_set_replacement (_tmp868_, _tmp870_);
				}
				_tmp873_ = node;
				if (_tmp873_->new_symbol) {
					ValaGirParserNode* _tmp874_;
					_tmp874_ = node;
					_tmp872_ = !_tmp874_->merged;
				} else {
					_tmp872_ = FALSE;
				}
				if (_tmp872_) {
					ValaGirParserMetadata* _tmp875_;
					_tmp875_ = self->metadata;
					_tmp871_ = !vala_gir_parser_metadata_get_bool (_tmp875_, VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN, FALSE);
				} else {
					_tmp871_ = FALSE;
				}
				if (_tmp871_) {
					gboolean _tmp876_ = FALSE;
					ValaSymbol* _tmp877_;
					const gchar* _tmp878_;
					const gchar* _tmp879_;
					_tmp877_ = self->symbol;
					_tmp878_ = vala_symbol_get_name (_tmp877_);
					_tmp879_ = _tmp878_;
					if (_tmp879_ == NULL) {
						_tmp876_ = TRUE;
					} else {
						ValaGirParserNode* _tmp880_;
						ValaSymbol* _tmp881_;
						const gchar* _tmp882_;
						const gchar* _tmp883_;
						ValaGirParserNode* _tmp884_;
						ValaGirParserNode* _tmp885_;
						_tmp880_ = node;
						_tmp881_ = self->symbol;
						_tmp882_ = vala_symbol_get_name (_tmp881_);
						_tmp883_ = _tmp882_;
						_tmp884_ = vala_gir_parser_node_lookup (_tmp880_, _tmp883_, FALSE, NULL);
						_tmp885_ = _tmp884_;
						_tmp876_ = _tmp885_ == NULL;
						_vala_gir_parser_node_unref0 (_tmp885_);
					}
					if (_tmp876_) {
						ValaSymbol* _tmp886_;
						ValaGirParserNode* _tmp887_;
						ValaSymbol* _tmp888_;
						_tmp886_ = self->symbol;
						_tmp887_ = node;
						_tmp888_ = _tmp887_->symbol;
						vala_gir_parser_add_symbol_to_container (_tmp886_, _tmp888_);
					}
				}
				_vala_gir_parser_node_unref0 (node);
			}
		}
		_tmp889_ = self->symbol;
		_tmp890_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp889_) ? ((ValaClass*) _tmp889_) : NULL);
		cl = _tmp890_;
		_tmp893_ = cl;
		if (_tmp893_ != NULL) {
			ValaClass* _tmp894_;
			gboolean _tmp895_;
			gboolean _tmp896_;
			_tmp894_ = cl;
			_tmp895_ = vala_class_get_is_compact (_tmp894_);
			_tmp896_ = _tmp895_;
			_tmp892_ = !_tmp896_;
		} else {
			_tmp892_ = FALSE;
		}
		if (_tmp892_) {
			ValaClass* _tmp897_;
			ValaCreationMethod* _tmp898_;
			ValaCreationMethod* _tmp899_;
			_tmp897_ = cl;
			_tmp898_ = vala_class_get_default_construction_method (_tmp897_);
			_tmp899_ = _tmp898_;
			_tmp891_ = _tmp899_ == NULL;
		} else {
			_tmp891_ = FALSE;
		}
		if (_tmp891_) {
			ValaCreationMethod* cm = NULL;
			ValaClass* _tmp900_;
			ValaSourceReference* _tmp901_;
			ValaSourceReference* _tmp902_;
			ValaCreationMethod* _tmp903_;
			ValaCreationMethod* _tmp904_;
			ValaCreationMethod* _tmp905_;
			ValaClass* _tmp906_;
			ValaCreationMethod* _tmp907_;
			_tmp900_ = cl;
			_tmp901_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp900_);
			_tmp902_ = _tmp901_;
			_tmp903_ = vala_creation_method_new (NULL, NULL, _tmp902_, NULL);
			cm = _tmp903_;
			_tmp904_ = cm;
			vala_method_set_has_construct_function ((ValaMethod*) _tmp904_, FALSE);
			_tmp905_ = cm;
			vala_symbol_set_access ((ValaSymbol*) _tmp905_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
			_tmp906_ = cl;
			_tmp907_ = cm;
			vala_symbol_add_method ((ValaSymbol*) _tmp906_, (ValaMethod*) _tmp907_);
			_vala_code_node_unref0 (cm);
		}
		_vala_code_node_unref0 (cl);
	}
	self->processed = TRUE;
}

static gchar*
vala_gir_parser_node_to_string (ValaGirParserNode* self)
{
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = _tmp0_->name;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->name;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	} else {
		ValaGirParserNode* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_to_string (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = g_strdup_printf ("%s.%s", _tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp6_);
		result = _tmp9_;
		return result;
	}
}

static void
vala_gir_parser_value_node_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_node_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_node_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_node_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_node_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_node_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserNode * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_node_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	ValaGirParserNode ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_node (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	ValaGirParserParamSpecNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_node (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_node (GValue* value,
                                gpointer v_object)
{
	ValaGirParserNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_node_unref (old);
	}
}

static void
vala_gir_parser_value_take_node (GValue* value,
                                 gpointer v_object)
{
	ValaGirParserNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_node_unref (old);
	}
}

static void
vala_gir_parser_node_class_init (ValaGirParserNodeClass * klass,
                                 gpointer klass_data)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	vala_gir_parser_node_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserNodeClass *) klass)->finalize = vala_gir_parser_node_finalize;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp0_);
	vala_gir_parser_node_new_namespaces = _tmp1_;
}

static void
vala_gir_parser_node_instance_init (ValaGirParserNode * self,
                                    gpointer klass)
{
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GEqualFunc _tmp7_;
	ValaHashMap* _tmp8_;
	self->girdata = NULL;
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_gir_parser_metadata_ref0 (_tmp1_);
	self->metadata = _tmp2_;
	self->source_reference = NULL;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp3_);
	self->members = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_ARRAY_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp5_, _tmp6_, _tmp7_);
	self->scope = _tmp8_;
	self->return_array_length_idx = -1;
	self->array_length_idx = -1;
	self->deprecated = FALSE;
	self->deprecated_version = (guint64) 0;
	self->deprecated_since = NULL;
	self->deprecated_replacement = NULL;
	self->ref_count = 1;
}

static void
vala_gir_parser_node_finalize (ValaGirParserNode * obj)
{
	ValaGirParserNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNode);
	g_signal_handlers_destroy (self);
	_g_free0 (self->element_type);
	_g_free0 (self->name);
	_vala_map_unref0 (self->girdata);
	_vala_gir_parser_metadata_unref0 (self->metadata);
	_vala_source_reference_unref0 (self->source_reference);
	_vala_iterable_unref0 (self->members);
	_vala_map_unref0 (self->scope);
	_vala_comment_unref0 (self->comment);
	_vala_code_node_unref0 (self->symbol);
	_vala_iterable_unref0 (self->parameters);
	_vala_iterable_unref0 (self->array_length_parameters);
	_vala_iterable_unref0 (self->closure_parameters);
	_vala_iterable_unref0 (self->destroy_parameters);
	_vala_code_node_unref0 (self->gtype_struct_for);
	_vala_code_node_unref0 (self->type_struct);
	_vala_code_node_unref0 (self->base_type);
	_g_free0 (self->deprecated_since);
	_g_free0 (self->deprecated_replacement);
}

static GType
vala_gir_parser_node_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_node_init, vala_gir_parser_value_node_free_value, vala_gir_parser_value_node_copy_value, vala_gir_parser_value_node_peek_pointer, "p", vala_gir_parser_value_node_collect_value, "p", vala_gir_parser_value_node_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserNode), 0, (GInstanceInitFunc) vala_gir_parser_node_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_node_type_id;
	vala_gir_parser_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vala_gir_parser_node_type_id;
}

static GType
vala_gir_parser_node_get_type (void)
{
	static volatile gsize vala_gir_parser_node_type_id__once = 0;
	if (g_once_init_enter (&vala_gir_parser_node_type_id__once)) {
		GType vala_gir_parser_node_type_id;
		vala_gir_parser_node_type_id = vala_gir_parser_node_get_type_once ();
		g_once_init_leave (&vala_gir_parser_node_type_id__once, vala_gir_parser_node_type_id);
	}
	return vala_gir_parser_node_type_id__once;
}

static gpointer
vala_gir_parser_node_ref (gpointer instance)
{
	ValaGirParserNode * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_node_unref (gpointer instance)
{
	ValaGirParserNode * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static ValaGirParserParameterInfo*
vala_gir_parser_parameter_info_construct (GType object_type,
                                          ValaParameter* param,
                                          gint array_length_idx,
                                          gint closure_idx,
                                          gint destroy_idx,
                                          gboolean is_async)
{
	ValaGirParserParameterInfo* self = NULL;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (param != NULL, NULL);
	self = (ValaGirParserParameterInfo*) g_type_create_instance (object_type);
	_tmp0_ = _vala_code_node_ref0 (param);
	_vala_code_node_unref0 (self->param);
	self->param = _tmp0_;
	self->array_length_idx = array_length_idx;
	self->closure_idx = closure_idx;
	self->destroy_idx = destroy_idx;
	self->vala_idx = 0.0F;
	self->keep = TRUE;
	self->is_async = is_async;
	return self;
}

static ValaGirParserParameterInfo*
vala_gir_parser_parameter_info_new (ValaParameter* param,
                                    gint array_length_idx,
                                    gint closure_idx,
                                    gint destroy_idx,
                                    gboolean is_async)
{
	return vala_gir_parser_parameter_info_construct (VALA_GIR_PARSER_TYPE_PARAMETER_INFO, param, array_length_idx, closure_idx, destroy_idx, is_async);
}

static void
vala_gir_parser_value_parameter_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_parameter_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_parameter_info_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_parameter_info_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_parameter_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_parameter_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_parameter_info_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserParameterInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_parameter_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_parameter_info_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	ValaGirParserParameterInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_parameter_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_parameter_info (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	ValaGirParserParamSpecParameterInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_PARAMETER_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_parameter_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_parameter_info (GValue* value,
                                          gpointer v_object)
{
	ValaGirParserParameterInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_parameter_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_parameter_info_unref (old);
	}
}

static void
vala_gir_parser_value_take_parameter_info (GValue* value,
                                           gpointer v_object)
{
	ValaGirParserParameterInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_parameter_info_unref (old);
	}
}

static void
vala_gir_parser_parameter_info_class_init (ValaGirParserParameterInfoClass * klass,
                                           gpointer klass_data)
{
	vala_gir_parser_parameter_info_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserParameterInfoClass *) klass)->finalize = vala_gir_parser_parameter_info_finalize;
}

static void
vala_gir_parser_parameter_info_instance_init (ValaGirParserParameterInfo * self,
                                              gpointer klass)
{
	self->ref_count = 1;
}

static void
vala_gir_parser_parameter_info_finalize (ValaGirParserParameterInfo * obj)
{
	ValaGirParserParameterInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfo);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->param);
}

static GType
vala_gir_parser_parameter_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_parameter_info_init, vala_gir_parser_value_parameter_info_free_value, vala_gir_parser_value_parameter_info_copy_value, vala_gir_parser_value_parameter_info_peek_pointer, "p", vala_gir_parser_value_parameter_info_collect_value, "p", vala_gir_parser_value_parameter_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserParameterInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_parameter_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserParameterInfo), 0, (GInstanceInitFunc) vala_gir_parser_parameter_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_parameter_info_type_id;
	vala_gir_parser_parameter_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserParameterInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vala_gir_parser_parameter_info_type_id;
}

static GType
vala_gir_parser_parameter_info_get_type (void)
{
	static volatile gsize vala_gir_parser_parameter_info_type_id__once = 0;
	if (g_once_init_enter (&vala_gir_parser_parameter_info_type_id__once)) {
		GType vala_gir_parser_parameter_info_type_id;
		vala_gir_parser_parameter_info_type_id = vala_gir_parser_parameter_info_get_type_once ();
		g_once_init_leave (&vala_gir_parser_parameter_info_type_id__once, vala_gir_parser_parameter_info_type_id);
	}
	return vala_gir_parser_parameter_info_type_id__once;
}

static gpointer
vala_gir_parser_parameter_info_ref (gpointer instance)
{
	ValaGirParserParameterInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_parameter_info_unref (gpointer instance)
{
	ValaGirParserParameterInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_PARAMETER_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
vala_gir_parser_class_init (ValaGirParserClass * klass,
                            gpointer klass_data)
{
	vala_gir_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gir_parser_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGirParser_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_gir_parser_real_visit_source_file;
}

static void
vala_gir_parser_instance_init (ValaGirParser * self,
                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashSet* _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashMap* _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GEqualFunc _tmp11_;
	ValaHashMap* _tmp12_;
	GEqualFunc _tmp13_;
	ValaArrayList* _tmp14_;
	self->priv = vala_gir_parser_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp0_);
	self->priv->metadata_roots = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp2_, _tmp3_);
	self->priv->provided_namespaces = (ValaSet*) _tmp4_;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_map_new (VALA_TYPE_UNRESOLVED_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _vala_gir_parser_unresolved_symbol_hash_ghash_func, _vala_gir_parser_unresolved_symbol_equal_gequal_func, _tmp5_);
	self->priv->unresolved_symbols_map = _tmp6_;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_UNRESOLVED_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp7_);
	self->priv->unresolved_gir_symbols = _tmp8_;
	_tmp9_ = g_direct_hash;
	_tmp10_ = g_direct_equal;
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_hash_map_new (VALA_TYPE_UNRESOLVED_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp9_, _tmp10_, _tmp11_);
	self->priv->unresolved_type_arguments = _tmp12_;
	_tmp13_ = g_direct_equal;
	_tmp14_ = vala_array_list_new (VALA_TYPE_INTERFACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp13_);
	self->priv->ifaces_needing_object_prereq = _tmp14_;
}

static void
vala_gir_parser_finalize (ValaCodeVisitor * obj)
{
	ValaGirParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIR_PARSER, ValaGirParser);
	_vala_markup_reader_unref0 (self->priv->reader);
	_vala_code_context_unref0 (self->priv->context);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_gir_parser_node_unref0 (self->priv->root);
	_vala_iterable_unref0 (self->priv->metadata_roots);
	self->priv->cheader_filenames = (_vala_array_free (self->priv->cheader_filenames, self->priv->cheader_filenames_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->priv->metadata_stack);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	_vala_iterable_unref0 (self->priv->tree_stack);
	_vala_gir_parser_node_unref0 (self->priv->current);
	_vala_gir_parser_node_unref0 (self->priv->old_current);
	_vala_iterable_unref0 (self->priv->provided_namespaces);
	_vala_map_unref0 (self->priv->unresolved_symbols_map);
	_vala_iterable_unref0 (self->priv->unresolved_gir_symbols);
	_vala_map_unref0 (self->priv->unresolved_type_arguments);
	_vala_iterable_unref0 (self->priv->ifaces_needing_object_prereq);
	VALA_CODE_VISITOR_CLASS (vala_gir_parser_parent_class)->finalize (obj);
}

/**
 * Code visitor parsing all GIR source files.
 *
 * Pipeline:
 * 1) Parse metadata
 * 2) Parse GIR with metadata, track unresolved GIR symbols, create Vala symbols
 * 3) Reconciliate the tree by mapping tracked symbols
 * 4) Process the tree
 */
static GType
vala_gir_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParser), 0, (GInstanceInitFunc) vala_gir_parser_instance_init, NULL };
	GType vala_gir_parser_type_id;
	vala_gir_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGirParser", &g_define_type_info, 0);
	ValaGirParser_private_offset = g_type_add_instance_private (vala_gir_parser_type_id, sizeof (ValaGirParserPrivate));
	return vala_gir_parser_type_id;
}

GType
vala_gir_parser_get_type (void)
{
	static volatile gsize vala_gir_parser_type_id__once = 0;
	if (g_once_init_enter (&vala_gir_parser_type_id__once)) {
		GType vala_gir_parser_type_id;
		vala_gir_parser_type_id = vala_gir_parser_get_type_once ();
		g_once_init_leave (&vala_gir_parser_type_id__once, vala_gir_parser_type_id);
	}
	return vala_gir_parser_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

