/*****************************************************************************

	unsort - reorder files semi-randomly
	Copyright (C) 2006, 2007  Wessel Dankers <wsl@fruit.je>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

	$Id: error.h 1332 2008-06-10 20:01:01Z wsl $
	$URL: http://rot.zo.oi/svn/wsl/src/unsort/error.h $

*****************************************************************************/

#ifndef FRUIT_ERROR_H
#define FRUIT_ERROR_H

#include <stdarg.h>
#include <sys/types.h>

typedef enum {
	ERROR_NONE,
	ERROR_USER,
	ERROR_CONFIG,
	ERROR_SYSTEM,
	ERROR_INTERNAL
} error_code;

extern void exit_error(error_code, const char *, ...);
extern void warn_error(const char *, ...);
extern void exit_perror(error_code, const char *, ...);
extern void warn_perror(const char *, ...);
extern void *xalloc(size_t);

#endif
