/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#ifndef __CIM_REMOTEPORT_H
#define __CIM_REMOTEPORT_H
#include "CIM_RemoteServiceAccessPoint.h"
namespace CimClassNamespace
{

	// Class CIM_RemotePort:
	// RemotePort adds port information to the access data (such as IP Address), specified in and inherited from RemoteServiceAccessPoint. For example, using the additional properties in this class, one could indicate that UDP Port 123 is accessed at IP Address xyz. The IP Address would be specified in the inherited AccessInfo property, while the UDP Port number would be specified in this class' property, PortInfo.
	class CIM_RemotePort  : public CIM_RemoteServiceAccessPoint
	{
	public:
		// type definitions
		typedef CimClassContainer<CIM_RemotePort> CIM_RemotePortContainer;

		// static const declarations
		static const string CLASS_NAME;
		static const string CLASS_URI;
		static const string CLASS_NS;
		static const string CLASS_NS_PREFIX;

		// class fields
		// Port information that may further specify the remote access information.
		string PortInfo;

		// This field determines whether the PortInfo field is valid.
		bool PortInfoSpecified;

		// An enumerated integer describing the protocol of the port addressed by PortInformation.
		// Legal values:
		// Other: 1
		// TCP: 2
		// UDP: 3
		// Vendor Specific: 32768..65535
		unsigned short PortProtocol;

		// This field determines whether the PortProtocol field is valid.
		bool PortProtocolSpecified;

		// Describes the protocol when the property PortProtocol is set to 1 ("Other").
		string OtherProtocolDescription;

		// This field determines whether the OtherProtocolDescription field is valid.
		bool OtherProtocolDescriptionSpecified;

		// Class Constructor
		CIM_RemotePort(
			const string& objName = CIM_RemotePort::CLASS_NAME,
			const string& uri = CIM_RemotePort::CLASS_URI,
			const string& ns = CIM_RemotePort::CLASS_NS,
			const string& nsPrefix = CIM_RemotePort::CLASS_NS_PREFIX);

		// Class Destructor
		virtual ~CIM_RemotePort(){}

		// This function appends a serialization of this instance to the given node.
		virtual void SerializeMembers(XMLElement& node) const;

		// This function returns the selector set of this instance.
		virtual NameValuePairs GetSelectorsList() const;

		// This function sets a field value according to the given node.
		virtual void SetValue(const XMLElement& node);

	};
}
#endif
