//
// Copyright 2025 Ettus Research, A National Instruments Company
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: gpio_atr_regmap_utils.vh
// Description:
// The constants in this file are autogenerated by XmlParse.

//===============================================================================
// A numerically ordered list of registers and their HDL source files
//===============================================================================

  // ATR_STATE            : 0x0 (x4xx_gpio_atr.v)
  // CLASSIC_ATR_CONFIG   : 0x40 (x4xx_gpio_atr.v)
  // ATR_OPTION_REGISTRER : 0x44 (x4xx_gpio_atr.v)
  // GPIO_DIR             : 0x48 (x4xx_gpio_atr.v)
  // GPIO_DISABLED        : 0x4C (x4xx_gpio_atr.v)
  // GPIO_IN              : 0x50 (x4xx_gpio_atr.v)

//===============================================================================
// RegTypes
//===============================================================================

  // GPIO_ATR_STATE Type (from x4xx_gpio_atr.v)
  localparam GPIO_ATR_STATE_SIZE = 32;
  localparam GPIO_ATR_STATE_MASK = 32'hFFF0FFF;
  localparam GPIO_STATE_A_SIZE = 12;  //GPIO_ATR_STATE:GPIO_STATE_A
  localparam GPIO_STATE_A_MSB  = 11;  //GPIO_ATR_STATE:GPIO_STATE_A
  localparam GPIO_STATE_A      =  0;  //GPIO_ATR_STATE:GPIO_STATE_A
  localparam GPIO_STATE_B_SIZE = 12;  //GPIO_ATR_STATE:GPIO_STATE_B
  localparam GPIO_STATE_B_MSB  = 27;  //GPIO_ATR_STATE:GPIO_STATE_B
  localparam GPIO_STATE_B      = 16;  //GPIO_ATR_STATE:GPIO_STATE_B

//===============================================================================
// Register Group GPIO_ATR_REGS
//===============================================================================

  // ATR_STATE Register (from x4xx_gpio_atr.v)
  localparam ATR_STATE_COUNT = 16; // Number of elements in array

  // CLASSIC_ATR_CONFIG Register (from x4xx_gpio_atr.v)
  localparam CLASSIC_ATR_CONFIG = 'h40; // Register Offset
  localparam CLASSIC_ATR_CONFIG_SIZE = 32;  // register width in bits
  localparam CLASSIC_ATR_CONFIG_MASK = 32'hFFF0FFF;
  localparam RF_SELECT_A_SIZE = 12;  //CLASSIC_ATR_CONFIG:RF_SELECT_A
  localparam RF_SELECT_A_MSB  = 11;  //CLASSIC_ATR_CONFIG:RF_SELECT_A
  localparam RF_SELECT_A      =  0;  //CLASSIC_ATR_CONFIG:RF_SELECT_A
  localparam RF_SELECT_B_SIZE = 12;  //CLASSIC_ATR_CONFIG:RF_SELECT_B
  localparam RF_SELECT_B_MSB  = 27;  //CLASSIC_ATR_CONFIG:RF_SELECT_B
  localparam RF_SELECT_B      = 16;  //CLASSIC_ATR_CONFIG:RF_SELECT_B

  // ATR_OPTION_REGISTRER Register (from x4xx_gpio_atr.v)
  localparam ATR_OPTION_REGISTRER = 'h44; // Register Offset
  localparam ATR_OPTION_REGISTRER_SIZE = 32;  // register width in bits
  localparam ATR_OPTION_REGISTRER_MASK = 32'h1;
  localparam ATR_OPTION_SIZE = 1;  //ATR_OPTION_REGISTRER:ATR_OPTION
  localparam ATR_OPTION_MSB  = 0;  //ATR_OPTION_REGISTRER:ATR_OPTION
  localparam ATR_OPTION      = 0;  //ATR_OPTION_REGISTRER:ATR_OPTION

  // GPIO_DIR Register (from x4xx_gpio_atr.v)
  localparam GPIO_DIR = 'h48; // Register Offset
  localparam GPIO_DIR_SIZE = 32;  // register width in bits
  localparam GPIO_DIR_MASK = 32'hFFF0FFF;
  localparam GPIO_DIR_A_SIZE = 12;  //GPIO_DIR:GPIO_DIR_A
  localparam GPIO_DIR_A_MSB  = 11;  //GPIO_DIR:GPIO_DIR_A
  localparam GPIO_DIR_A      =  0;  //GPIO_DIR:GPIO_DIR_A
  localparam GPIO_DIR_B_SIZE = 12;  //GPIO_DIR:GPIO_DIR_B
  localparam GPIO_DIR_B_MSB  = 27;  //GPIO_DIR:GPIO_DIR_B
  localparam GPIO_DIR_B      = 16;  //GPIO_DIR:GPIO_DIR_B

  // GPIO_DISABLED Register (from x4xx_gpio_atr.v)
  localparam GPIO_DISABLED = 'h4C; // Register Offset
  localparam GPIO_DISABLED_SIZE = 32;  // register width in bits
  localparam GPIO_DISABLED_MASK = 32'hFFF0FFF;
  localparam GPIO_DISABLED_A_SIZE = 12;  //GPIO_DISABLED:GPIO_DISABLED_A
  localparam GPIO_DISABLED_A_MSB  = 11;  //GPIO_DISABLED:GPIO_DISABLED_A
  localparam GPIO_DISABLED_A      =  0;  //GPIO_DISABLED:GPIO_DISABLED_A
  localparam GPIO_DISABLED_B_SIZE = 12;  //GPIO_DISABLED:GPIO_DISABLED_B
  localparam GPIO_DISABLED_B_MSB  = 27;  //GPIO_DISABLED:GPIO_DISABLED_B
  localparam GPIO_DISABLED_B      = 16;  //GPIO_DISABLED:GPIO_DISABLED_B

  // GPIO_IN Register (from x4xx_gpio_atr.v)
  localparam GPIO_IN = 'h50; // Register Offset
  localparam GPIO_IN_SIZE = 32;  // register width in bits
  localparam GPIO_IN_MASK = 32'hFFF0FFF;
  localparam GPIO_IN_A_SIZE = 12;  //GPIO_IN:GPIO_IN_A
  localparam GPIO_IN_A_MSB  = 11;  //GPIO_IN:GPIO_IN_A
  localparam GPIO_IN_A      =  0;  //GPIO_IN:GPIO_IN_A
  localparam GPIO_IN_B_SIZE = 12;  //GPIO_IN:GPIO_IN_B
  localparam GPIO_IN_B_MSB  = 27;  //GPIO_IN:GPIO_IN_B
  localparam GPIO_IN_B      = 16;  //GPIO_IN:GPIO_IN_B

  // Return the offset of an element of register array ATR_STATE
  function automatic integer ATR_STATE (input integer i);
  begin
    ATR_STATE = (i * 'h4) + 'h0;
  end
  endfunction
