#==============================================================================
# Contains procedures that create various bitmap images.
#
# Copyright (c) 2021-2022  Csaba Nemethi (E-mail: csaba.nemethi@t-online.de)
#==============================================================================

package require Tk 8.4

#------------------------------------------------------------------------------
# scrollutil::getForegroundColors
#
# Gets the normal and disabled foreground colors.
#------------------------------------------------------------------------------
proc scrollutil::getForegroundColors {normalFgName disabledFgName} {
    upvar $normalFgName normalFg  $disabledFgName disabledFg

    if {[set normalFg [ttk::style lookup . -foreground]] eq ""} {
	set normalFg black
    }

    array set arr [ttk::style map . -foreground]
    if {[info exists arr(disabled)]} {
	set disabledFg $arr(disabled)
    } else {
	set disabledFg $normalFg
    }
}

#------------------------------------------------------------------------------
# scrollutil::createCloseImages
#
# Creates the images scrollutil_close*Img.
#------------------------------------------------------------------------------
proc scrollutil::createCloseImages {} {
    variable scalingpct
    switch $scalingpct {
	100 {
	    set closeData "
#define close100_width 16
#define close100_height 15
static unsigned char close100_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0c, 0x60, 0x06,
   0xc0, 0x03, 0x80, 0x01, 0xc0, 0x03, 0x60, 0x06, 0x30, 0x0c, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
"
	}

	125 {
	    set closeData "
#define close125_width 20
#define close125_height 19
static unsigned char close125_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x60, 0x60, 0x00, 0xc0, 0x30, 0x00, 0x80, 0x19, 0x00,
   0x00, 0x0f, 0x00, 0x00, 0x06, 0x00, 0x00, 0x0f, 0x00, 0x80, 0x19, 0x00,
   0xc0, 0x30, 0x00, 0x60, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
"
	}

	150 {
	    set closeData "
#define close150_width 24
#define close150_height 23
static unsigned char close150_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x03, 0x80, 0x81, 0x01,
   0x00, 0xc3, 0x00, 0x00, 0x66, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x18, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x66, 0x00, 0x00, 0xc3, 0x00, 0x80, 0x81, 0x01,
   0xc0, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
"
	}

	175 {
	    set closeData "
#define close175_width 28
#define close175_height 28
static unsigned char close175_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x18, 0x00, 0x80, 0x03, 0x1c, 0x00,
   0x00, 0x07, 0x0e, 0x00, 0x00, 0x0e, 0x07, 0x00, 0x00, 0x9c, 0x03, 0x00,
   0x00, 0xf8, 0x01, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00,
   0x00, 0xf8, 0x01, 0x00, 0x00, 0x9c, 0x03, 0x00, 0x00, 0x0e, 0x07, 0x00,
   0x00, 0x07, 0x0e, 0x00, 0x80, 0x03, 0x1c, 0x00, 0x80, 0x01, 0x18, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00};
"
	}

	200 {
	    set closeData "
#define close200_width 32
#define close200_height 32
static unsigned char close200_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x00,
   0x00, 0x07, 0xe0, 0x00, 0x00, 0x0e, 0x70, 0x00, 0x00, 0x1c, 0x38, 0x00,
   0x00, 0x38, 0x1c, 0x00, 0x00, 0x70, 0x0e, 0x00, 0x00, 0xe0, 0x07, 0x00,
   0x00, 0xc0, 0x03, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0xe0, 0x07, 0x00,
   0x00, 0x70, 0x0e, 0x00, 0x00, 0x38, 0x1c, 0x00, 0x00, 0x1c, 0x38, 0x00,
   0x00, 0x0e, 0x70, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x03, 0xc0, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
"
	}
    }

    getForegroundColors normalFg disabledFg

    image create bitmap scrollutil_closeImg -data $closeData \
	-foreground $normalFg
    image create bitmap scrollutil_closeDisabledImg -data $closeData \
	-foreground $disabledFg
    image create bitmap scrollutil_closeHoverImg -data $closeData \
	-foreground #ffffff -background #ff6666
    image create bitmap scrollutil_closePressedImg -data $closeData \
	-foreground #ffffff -background #e60000
}

#------------------------------------------------------------------------------
# scrollutil::createLeftArrowImage
#
# Creates the image scrollutil_leftArrowImg.
#------------------------------------------------------------------------------
proc scrollutil::createLeftArrowImage {} {
    variable scalingpct
    switch $scalingpct {
	100 {
	    set leftArrowData "
#define leftArrow100_width 8
#define leftArrow100_height 15
static unsigned char leftArrow100_bits[] = {
   0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0xff, 0xfe, 0xfc, 0xf8, 0xf0,
   0xe0, 0xc0, 0x80};
"
	}

	125 {
	    set leftArrowData "
#define leftArrow125_width 10
#define leftArrow125_height 19
static unsigned char leftArrow125_bits[] = {
   0x00, 0x02, 0x00, 0x03, 0x80, 0x03, 0xc0, 0x03, 0xe0, 0x03, 0xf0, 0x03,
   0xf8, 0x03, 0xfc, 0x03, 0xfe, 0x03, 0xff, 0x03, 0xfe, 0x03, 0xfc, 0x03,
   0xf8, 0x03, 0xf0, 0x03, 0xe0, 0x03, 0xc0, 0x03, 0x80, 0x03, 0x00, 0x03,
   0x00, 0x02};
"
	}

	150 {
	    set leftArrowData "
#define leftArrow150_width 12
#define leftArrow150_height 23
static unsigned char leftArrow150_bits[] = {
   0x00, 0x08, 0x00, 0x0c, 0x00, 0x0e, 0x00, 0x0f, 0x80, 0x0f, 0xc0, 0x0f,
   0xe0, 0x0f, 0xf0, 0x0f, 0xf8, 0x0f, 0xfc, 0x0f, 0xfe, 0x0f, 0xff, 0x0f,
   0xfe, 0x0f, 0xfc, 0x0f, 0xf8, 0x0f, 0xf0, 0x0f, 0xe0, 0x0f, 0xc0, 0x0f,
   0x80, 0x0f, 0x00, 0x0f, 0x00, 0x0e, 0x00, 0x0c, 0x00, 0x08};
"
	}

	175 {
	    set leftArrowData "
#define leftArrow175_width 14
#define leftArrow175_height 27
static unsigned char leftArrow175_bits[] = {
   0x00, 0x20, 0x00, 0x30, 0x00, 0x38, 0x00, 0x3c, 0x00, 0x3e, 0x00, 0x3f,
   0x80, 0x3f, 0xc0, 0x3f, 0xe0, 0x3f, 0xf0, 0x3f, 0xf8, 0x3f, 0xfc, 0x3f,
   0xfe, 0x3f, 0xff, 0x3f, 0xfe, 0x3f, 0xfc, 0x3f, 0xf8, 0x3f, 0xf0, 0x3f,
   0xe0, 0x3f, 0xc0, 0x3f, 0x80, 0x3f, 0x00, 0x3f, 0x00, 0x3e, 0x00, 0x3c,
   0x00, 0x38, 0x00, 0x30, 0x00, 0x20};
"
	}

	200 {
	    set leftArrowData "
#define leftArrow200_width 16
#define leftArrow200_height 31
static unsigned char leftArrow200_bits[] = {
   0x00, 0x80, 0x00, 0xc0, 0x00, 0xe0, 0x00, 0xf0, 0x00, 0xf8, 0x00, 0xfc,
   0x00, 0xfe, 0x00, 0xff, 0x80, 0xff, 0xc0, 0xff, 0xe0, 0xff, 0xf0, 0xff,
   0xf8, 0xff, 0xfc, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfc, 0xff,
   0xf8, 0xff, 0xf0, 0xff, 0xe0, 0xff, 0xc0, 0xff, 0x80, 0xff, 0x00, 0xff,
   0x00, 0xfe, 0x00, 0xfc, 0x00, 0xf8, 0x00, 0xf0, 0x00, 0xe0, 0x00, 0xc0,
   0x00, 0x80};
"
	}
    }

    getForegroundColors normalFg disabledFg

    image create bitmap scrollutil_leftArrowImg -data $leftArrowData \
	-foreground $normalFg
}

#------------------------------------------------------------------------------
# scrollutil::createRightArrowImage
#
# Creates the image scrollutil_rightArrowImg.
#------------------------------------------------------------------------------
proc scrollutil::createRightArrowImage {} {
    variable scalingpct
    switch $scalingpct {
	100 {
	    set rightArrowData "
#define rightArrow100_width 8
#define rightArrow100_height 15
static unsigned char rightArrow100_bits[] = {
   0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff, 0x7f, 0x3f, 0x1f, 0x0f,
   0x07, 0x03, 0x01};
"
	}

	125 {
	    set rightArrowData "
#define rightArrow125_width 10
#define rightArrow125_height 19
static unsigned char rightArrow125_bits[] = {
   0x01, 0x00, 0x03, 0x00, 0x07, 0x00, 0x0f, 0x00, 0x1f, 0x00, 0x3f, 0x00,
   0x7f, 0x00, 0xff, 0x00, 0xff, 0x01, 0xff, 0x03, 0xff, 0x01, 0xff, 0x00,
   0x7f, 0x00, 0x3f, 0x00, 0x1f, 0x00, 0x0f, 0x00, 0x07, 0x00, 0x03, 0x00,
   0x01, 0x00};
"
	}

	150 {
	    set rightArrowData "
#define rightArrow150_width 12
#define rightArrow150_height 23
static unsigned char rightArrow150_bits[] = {
   0x01, 0x00, 0x03, 0x00, 0x07, 0x00, 0x0f, 0x00, 0x1f, 0x00, 0x3f, 0x00,
   0x7f, 0x00, 0xff, 0x00, 0xff, 0x01, 0xff, 0x03, 0xff, 0x07, 0xff, 0x0f,
   0xff, 0x07, 0xff, 0x03, 0xff, 0x01, 0xff, 0x00, 0x7f, 0x00, 0x3f, 0x00,
   0x1f, 0x00, 0x0f, 0x00, 0x07, 0x00, 0x03, 0x00, 0x01, 0x00};
"
	}

	175 {
	    set rightArrowData "
#define rightArrow175_width 14
#define rightArrow175_height 27
static unsigned char rightArrow175_bits[] = {
   0x01, 0x00, 0x03, 0x00, 0x07, 0x00, 0x0f, 0x00, 0x1f, 0x00, 0x3f, 0x00,
   0x7f, 0x00, 0xff, 0x00, 0xff, 0x01, 0xff, 0x03, 0xff, 0x07, 0xff, 0x0f,
   0xff, 0x1f, 0xff, 0x3f, 0xff, 0x1f, 0xff, 0x0f, 0xff, 0x07, 0xff, 0x03,
   0xff, 0x01, 0xff, 0x00, 0x7f, 0x00, 0x3f, 0x00, 0x1f, 0x00, 0x0f, 0x00,
   0x07, 0x00, 0x03, 0x00, 0x01, 0x00};
"
	}

	200 {
	    set rightArrowData "
#define rightArrow200_width 16
#define rightArrow200_height 31
static unsigned char rightArrow200_bits[] = {
   0x01, 0x00, 0x03, 0x00, 0x07, 0x00, 0x0f, 0x00, 0x1f, 0x00, 0x3f, 0x00,
   0x7f, 0x00, 0xff, 0x00, 0xff, 0x01, 0xff, 0x03, 0xff, 0x07, 0xff, 0x0f,
   0xff, 0x1f, 0xff, 0x3f, 0xff, 0x7f, 0xff, 0xff, 0xff, 0x7f, 0xff, 0x3f,
   0xff, 0x1f, 0xff, 0x0f, 0xff, 0x07, 0xff, 0x03, 0xff, 0x01, 0xff, 0x00,
   0x7f, 0x00, 0x3f, 0x00, 0x1f, 0x00, 0x0f, 0x00, 0x07, 0x00, 0x03, 0x00,
   0x01, 0x00};
"
	}
    }

    getForegroundColors normalFg disabledFg

    image create bitmap scrollutil_rightArrowImg -data $rightArrowData \
	-foreground $normalFg
}

#------------------------------------------------------------------------------
# scrollutil::createDescendImages
#
# Creates the images scrollutil_descend*Img.
#------------------------------------------------------------------------------
proc scrollutil::createDescendImages {} {
    variable scalingpct
    switch $scalingpct {
	100 {
	    set descendData "
#define descend100_width 7
#define descend100_height 11
static unsigned char descend100_bits[] = {
   0x03, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x03};
    "
	}

	125 {
	    set descendData "
#define descend125_width 9
#define descend125_height 15
static unsigned char descend125_bits[] = {
   0x03, 0x00, 0x06, 0x00, 0x0c, 0x00, 0x18, 0x00, 0x30, 0x00, 0x60, 0x00,
   0xc0, 0x00, 0x80, 0x01, 0xc0, 0x00, 0x60, 0x00, 0x30, 0x00, 0x18, 0x00,
   0x0c, 0x00, 0x06, 0x00, 0x03, 0x00};
"
	}

	150 {
	    set descendData "
#define descend150_width 10
#define descend150_height 17
static unsigned char descend150_bits[] = {
   0x03, 0x00, 0x06, 0x00, 0x0c, 0x00, 0x18, 0x00, 0x30, 0x00, 0x60, 0x00,
   0xc0, 0x00, 0x80, 0x01, 0x00, 0x03, 0x80, 0x01, 0xc0, 0x00, 0x60, 0x00,
   0x30, 0x00, 0x18, 0x00, 0x0c, 0x00, 0x06, 0x00, 0x03, 0x00};
"
	}

	175 {
	    set descendData "
#define descend175_width 12
#define descend175_height 22
static unsigned char descend175_bits[] = {
   0x03, 0x00, 0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00,
   0xe0, 0x00, 0xc0, 0x01, 0x80, 0x03, 0x00, 0x07, 0x00, 0x0e, 0x00, 0x0e,
   0x00, 0x07, 0x80, 0x03, 0xc0, 0x01, 0xe0, 0x00, 0x70, 0x00, 0x38, 0x00,
   0x1c, 0x00, 0x0e, 0x00, 0x07, 0x00, 0x03, 0x00};
"
	}

	200 {
	    set descendData "
#define descend200_width 13
#define descend200_height 24
static unsigned char descend200_bits[] = {
   0x03, 0x00, 0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00,
   0xe0, 0x00, 0xc0, 0x01, 0x80, 0x03, 0x00, 0x07, 0x00, 0x0e, 0x00, 0x1c,
   0x00, 0x1c, 0x00, 0x0e, 0x00, 0x07, 0x80, 0x03, 0xc0, 0x01, 0xe0, 0x00,
   0x70, 0x00, 0x38, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x07, 0x00, 0x03, 0x00};
"
	}
    }

    getForegroundColors normalFg disabledFg

    image create bitmap scrollutil_descendImg -data $descendData \
	-foreground $normalFg
    image create bitmap scrollutil_descendDisabledImg -data $descendData \
	-foreground $disabledFg
}

#------------------------------------------------------------------------------
# scrollutil::createAscendImage
#
# Creates the image scrollutil_ascendImg.
#------------------------------------------------------------------------------
proc scrollutil::createAscendImage {} {
    variable scalingpct
    switch $scalingpct {
	100 {
	    set ascendData "
#define ascend100_width 16
#define ascend100_height 16
static unsigned char ascend100_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x07, 0x80, 0x03, 0xc0, 0x01,
   0xe0, 0x00, 0x70, 0x00, 0x70, 0x00, 0xe0, 0x00, 0xc0, 0x01, 0x80, 0x03,
   0x00, 0x07, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00};
"
	}

	125 {
	    set ascendData "
#define ascend125_width 20
#define ascend125_height 20
static unsigned char ascend125_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00,
   0x00, 0x38, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x07, 0x00,
   0x80, 0x03, 0x00, 0xc0, 0x01, 0x00, 0xc0, 0x01, 0x00, 0x80, 0x03, 0x00,
   0x00, 0x07, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x38, 0x00,
   0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
"
	}

	150 {
	    set ascendData "
#define ascend150_width 24
#define ascend150_height 24
static unsigned char ascend150_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01,
   0x00, 0xc0, 0x01, 0x00, 0xe0, 0x00, 0x00, 0x70, 0x00, 0x00, 0x38, 0x00,
   0x00, 0x1c, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x07, 0x00, 0x80, 0x03, 0x00,
   0x80, 0x03, 0x00, 0x00, 0x07, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x1c, 0x00,
   0x00, 0x38, 0x00, 0x00, 0x70, 0x00, 0x00, 0xe0, 0x00, 0x00, 0xc0, 0x01,
   0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
"
	}

	175 {
	    set ascendData "
#define ascend175_width 28
#define ascend175_height 28
static unsigned char ascend175_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x0f, 0x00,
   0x00, 0x80, 0x07, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0xe0, 0x01, 0x00,
   0x00, 0xf0, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x1e, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00,
   0x00, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x78, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0xe0, 0x01, 0x00,
   0x00, 0xc0, 0x03, 0x00, 0x00, 0x80, 0x07, 0x00, 0x00, 0x00, 0x0f, 0x00,
   0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00};
"
	}

	200 {
	    set ascendData "
#define ascend200_width 32
#define ascend200_height 32
static unsigned char ascend200_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00,
   0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x0f, 0x00,
   0x00, 0x80, 0x07, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0xe0, 0x01, 0x00,
   0x00, 0xf0, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00,
   0x00, 0x1e, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00,
   0x00, 0x3c, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00,
   0x00, 0xe0, 0x01, 0x00, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x80, 0x07, 0x00,
   0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x3c, 0x00,
   0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
"
	}
    }

    getForegroundColors normalFg disabledFg

    image create bitmap scrollutil_ascendImg -data $ascendData \
	-foreground $normalFg
}
