---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, espace, espaces, 
              réduction de l'espace, cadratin
---

# Comment gérer les espaces en mode mathématique ?

Le tableau suivant donne les différentes commandes d'espacement mathématique :

| Commande | Effet d'espacement               | Commentaire                                           |
|----------|----------------------------------|-------------------------------------------------------|
| `\!`     | $\blacksquare\!\blacksquare$     | Réduction de l'espace                                 |
| *rien*   | $\blacksquare\blacksquare$       | Affichage en l'absence de commande                    |
| `\,`     | $\blacksquare\,\blacksquare$     | Espace fine                                           |
| `\;`     | $\blacksquare\;\blacksquare$     | Espace moyenne                                        |
| `\ `     | $\blacksquare\ \blacksquare$     | Espace normale (la contre-oblique suivie d'un espace) |
| `\quad`  | $\blacksquare\quad\blacksquare$  | Espace cadratin                                       |
| `\qquad` | $\blacksquare\qquad\blacksquare$ | Espace double cadratin                                |

Voici un exemple d'utilisation de ces commandes :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{amssymb}        % Caractères des ensembles

\begin{document}
\[
  \forall \lambda \in \mathbb{R}
  \quad
  \int _{a}^{b}\lambda \, f(x)
  \, \mathrm{d} x
  =
  \lambda \, \int _{a}^{b}f(x)
  \, \mathrm{d} x
\]
\end{document}
```