---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, légendes, retour à la ligne,
              saut de ligne dans une légende
---

# Comment forcer un saut de ligne dans une légende ?

Si votre légende tient sur une seule ligne, elle sera centrée par LaTeX, 
et les commandes `\\` ou `\newline` n'auront pas d'effet pour insérer 
manuellement un saut de ligne. En revanche, si elle est plus longue 
qu'une ligne (sans saut de ligne manuel), elle sera composée 
comme un paragraphe et vous pouvez utilise `\\` à votre guise.

S'il est vraiment nécessaire d'introduire des sauts de lignes manuels 
dans une légende courte, l'extension <ctanpkg:ccaption> permet d'utiliser 
la commande `\\` dans l'argument de `\caption`.

Notez que la la commande `\\` est 
[fragile](/2_programmation/syntaxe/c_est_quoi_la_protection).  
Si vous l'utilisez dans du texte qui pourrait se retrouver 
dans une "Table des figures" ou "Liste des tableaux", vous devez la protéger.
L'exemple suivant vous donne différentes possibilités.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{ccaption} 

\begin{document}
Illustrons notre propos en trois figures exemplaires !

\begin{figure}[h!]
  \centering\framebox{\Huge Un exemple}
  \caption{Titre avec un saut\protect\\ de ligne à la fois dans le corps 
    du texte et dans la table}
\end{figure}

\begin{figure}[h!]
\centering\framebox{\Huge Un autre exemple}
\caption[Titre sans saut de ligne pour la table]{Titre avec\\ un saut 
  de ligne dans le corps}
\end{figure}

\begin{figure}[h!]
\centering\framebox{\Huge Un dernier exemple}
\caption[Titre avec un saut\protect\\ de ligne]{Titre comme vous voulez}
\end{figure}

\listoffigures
\end{document}
``` 

Il reste en général conseillé de laisser LaTeX faire la mise en page, 
quitte à redéfinir la largeur que doit utiliser la légende (voir la question 
"[](/3_composition/flottants/legendes/modifier_l_apparence_des_legendes)" 
à ce sujet).


:::{sources}
- [`\newline` (or equivalent) inside a `\caption`](https://latex.org/forum/viewtopic.php?t=3110),
- [How to add line break to caption without using caption package](https://tex.stackexchange.com/q/101595),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::