from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_avoid_classes = _Mock()

_avoid_elements = _Mock()

_avoid_hosts = _Mock()

_avoid_word_break_classes = _Mock()

_avoid_word_break_elements = _Mock()

_break_prefer_re = _Mock()

_break_text = _Mock()

_conditional_comment_re = _Mock()

_css_import_re = _Mock()

_css_javascript_re = _Mock()

_find_external_links = _Mock()

_find_styled_elements = _Mock()

_insert_break = _Mock()

_is_javascript_scheme = _Mock()

_link_regexes = _Mock()

_link_text = _Mock()

_substitute_whitespace = _Mock()

_transform_result = _Mock()

autolink = _Mock()

autolink_html = _Mock()

clean = _Mock()

clean_html = _Mock()

copy = _Mock()

defs = _Mock()

etree = _Mock()

fromstring = _Mock()

re = _Mock()

tostring = _Mock()

urlsplit = _Mock()

word_break = _Mock()

word_break_html = _Mock()

xhtml_to_html = _Mock()

XHTML_NAMESPACE = 'http://www.w3.org/1999/xhtml'

class Cleaner(_Mock):
  pass
  add_nofollow = False
  annoying_tags = True
  comments = True
  embedded = True
  forms = True
  frames = True
  javascript = True
  links = True
  meta = True
  page_structure = True
  processing_instructions = True
  remove_unknown_tags = True
  safe_attrs_only = True
  scripts = True
  style = False

