from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


arg_split = _Mock()

builtin_mod = _Mock()

compress_user = _Mock()

dir2 = _Mock()

expand_user = _Mock()

generics = _Mock()

get__all__entries = _Mock()

glob = _Mock()

has_open_quotes = _Mock()

inspect = _Mock()

io = _Mock()

itertools = _Mock()

keyword = _Mock()

os = _Mock()

penalize_magics_key = _Mock()

protect_filename = _Mock()

re = _Mock()

string_types = _Mock()

sys = _Mock()

DELIMS = ' \t\n`!@#$^&*()=+[{]}\\|;:\'",<>?'

ESC_MAGIC = '%'

GREEDY_DELIMS = ' =\r\n'

PROTECTABLES = ' ()[]{}?=\\|;:\'#*"^&'

class Bunch(_Mock):
  pass


class CBool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class Completer(_Mock):
  pass


class CompletionSplitter(_Mock):
  pass
  _delims = ' \t\n`!@#$^&*()=+[{]}\\|;:\'",<>?'

class Configurable(_Mock):
  pass


class Enum(_Mock):
  pass
  info_text = 'any value'

class IPCompleter(_Mock):
  pass


class TryNext(_Mock):
  pass


