from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_byteorderconv = _Mock()

_typestr = _Mock()

absolute_import = _Mock()

array = _Mock()

division = _Mock()

find_duplicate = _Mock()

fromarrays = _Mock()

fromfile = _Mock()

fromrecords = _Mock()

fromstring = _Mock()

get_remaining_size = _Mock()

isfileobj = _Mock()

nt = _Mock()

numfmt = _Mock()

os = _Mock()

print_function = _Mock()

sb = _Mock()

sys = _Mock()



class bytes(_Mock):
  pass


class chararray(_Mock):
  pass


class format_parser(_Mock):
  pass


class long(_Mock):
  pass


class ndarray(_Mock):
  pass


class recarray(_Mock):
  pass


class record(_Mock):
  pass


