from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_etree = _Mock()

_stylesheet_param_dict = _Mock()

extract_rng = _Mock()

extract_xsd = _Mock()

iso_abstract_expand = _Mock()

iso_dsdl_include = _Mock()

iso_svrl_for_xslt1 = _Mock()

os = _Mock()

schematron_schema_valid = _Mock()

stylesheet_params = _Mock()

svrl_validation_errors = _Mock()

sys = _Mock()

RELAXNG_NS = 'http://relaxng.org/ns/structure/1.0'

SCHEMATRON_NS = 'http://purl.oclc.org/dsdl/schematron'

SVRL_NS = 'http://purl.oclc.org/dsdl/svrl'

XML_SCHEMA_NS = 'http://www.w3.org/2001/XMLSchema'

_resources_dir = '/usr/lib/python2.7/dist-packages/lxml/isoschematron/resources'

_schematron_root = '{http://purl.oclc.org/dsdl/schematron}schema'

_xml_schema_root = '{http://www.w3.org/2001/XMLSchema}schema'

class Schematron(_Mock):
  pass
  _domain = 28
  _error_type = 4000
  _level = 2

