from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_jsonschema = _Mock()

collections = _Mock()

division = _Mock()

iteritems = _Mock()

itertools = _Mock()

operator = _Mock()

re = _Mock()

resolve_json_pointer = _Mock()

sys = _Mock()

unicode_literals = _Mock()

unquote = _Mock()

validate = _Mock()

warnings = _Mock()

FLOAT_TOLERANCE = 1e-15

PY3 = _Mock()

class Draft3Validator(_Mock):
  pass


class ErrorTree(_Mock):
  pass


class InvalidRef(_Mock):
  pass


class SchemaError(_Mock):
  pass


class UnknownType(_Mock):
  pass


class ValidationError(_Mock):
  pass


class Validator(_Mock):
  pass


class zip(_Mock):
  pass


