C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
                         SUBROUTINE SYRBAN           
C                        *****************             
C                                                         
     * ( I )                                              
C                                                                       
C                                                                       
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            BANNIERES DE DEBUT ET DE FIN DE SYRTHES                   *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !    I      !  E ! D  ! I= 1 => banniere de debut de programme       !
C !           !    !    ! I=-1 => banniere de fin de programme         !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    !    !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ----
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : TERMIC
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C
#include "nlofes.h"
C
C***********************************************************************
C.. Variables externes           
      INTEGER I
C
C.. Variables internes           
C
C***********************************************************************
C
C     ECRITURE DE LA BANNIERE
C     -----------------------
C
      IF (I.EQ.1) THEN
C
        WRITE(NFECRA,*)
        WRITE(NFECRA,1000)
        WRITE(NFECRA,1010)
        WRITE(NFECRA,1100)
        WRITE(NFECRA,1200)
C
      ELSE
C
        WRITE(NFECRA,2000)
        WRITE(NFECRA,*)
C
      ENDIF
C   
C--------
C FORMATS
C--------                                                                    
 1000 FORMAT (/,4X,64('*'),/,
     &    4X,'*',62X,'*',/,
     &    4X,'*   SSSSS  YY    YY  RRRRRR  TTTTTTTT ',
     &        'HH   HH  EEEEEE   SSSSS  *',/,
     &    4X,'*  SS       YY  YY   RR   RR    TT    ',
     &        'HH   HH  EE      SS      *',/,
     &    4X,'*  SS        YYYY    RR   RR    TT    ',
     &        'HH   HH  EE      SS      *',/,
     &    4X,'*   SSSS      YY     RRRRRR     TT    ',
     &        'HHHHHHH  EEEE     SSSS   *',/,    
     &    4X,'*      SS     YY     RR  RR     TT    ',
     &        'HH   HH  EE          SS  *',/,
     &    4X,'*      SS     YY     RR   RR    TT    ',
     &        'HH   HH  EE          SS  *',/,
     &    4X,'*  SSSSS      YY     RR   RR    TT    ',
     &        'HH   HH  EEEEEE  SSSSS   *',/,
     &    4X,'*',62X,'*',/,
     &    4X,64('*'),/) 

 1100 FORMAT( 'This file is part of the SYRTHES Kernel, element of the',/,
     &'thermal code SYRTHES.',/,
     &'Copyright (C) 1988-2008 EDF S.A., France',//,
     &'contact: syrthes-support@edf.fr',//,
     &'The SYRTHES Kernel is free software; you can redistribute it',/,
     &'and/or modify it under the terms of the GNU General ',
     &'Public License',/,
     &'as published by the Free Software Foundation; either version 2 ',
     &/,'of the License, or (at your option) any later version.')
 1200 FORMAT('The SYRTHES Kernel is distributed in the hope',
     &' that it will be',/,
     &'useful, but WITHOUT ANY WARRANTY; without even the implied ',
     &'warranty',/,
     &'of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  ',
     &'See the',/,
     &'GNU General Public License for more details.',//,
     &'You should have received a copy of the GNU General Public ',
     &'License',/,
     &'along with the Code_Saturne Kernel; if not, write to the',/,
     &'Free Software Foundation, Inc.,',/,
     &'51 Franklin St, Fifth Floor,',/,
     &'Boston, MA  02110-1301  USA',/)


 1010 FORMAT(30X,'VERSION 3.4.2',//)
 2000 FORMAT (///,80('*'),/,
     &        '*',21X,'- SYRTHES - FIN NORMALE DU PROGRAMME',21X,'*',/,
     &         80('*'),/)
C                                                                       
      RETURN                                                  
      END                                                               
