#include <SyFi.h>
#include <fstream>


using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() {

    initSyFi(3); 

    archive ar; 

    ex p0 = lst(0.0,0.0,0.0);
    ex p1 = lst(1.0,0.0,0.0);
    ex p2 = lst(0.0,1.0,0.0);
    ex p3 = lst(0.0,0.0,1.0);

    Tetrahedron tetrahedron(p0,p1,p2,p3);

    ex repr = tetrahedron.repr();
    cout <<"t.repr "<<repr<<endl; 
    ar.archive_ex(repr, "repr"); 

    ex f = x*y*z;
    ex intf = tetrahedron.integrate(f); 
    cout <<"intf "<<intf<<endl; 
    ar.archive_ex(intf, "intf"); 

    ofstream vfile("tetrahedron_ex1.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("tetrahedron_ex1.gar.v", "tetrahedron_ex1.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }

    return 0; 
}

