#include <SyFi.h>
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() {

    initSyFi(2); 

    ex f = x*y;
    ReferenceRectangle rectangle; 

    ex repr = rectangle.repr();
    cout <<"s.repr "<<repr<<endl; 

    ex intf = rectangle.integrate(f); 
    cout <<"intf "<<intf<<endl; 



    ex p0 = lst(0.0,0.0);
    ex p1 = lst(1.0,1.0);

    Rectangle rectangle2(p0,p1);

    ex repr2 = rectangle2.repr();
    cout <<"s2.repr "<<repr<<endl; 

    ex intf2 = rectangle2.integrate(f); 
    cout <<"intf2 "<<intf2<<endl; 

    initSyFi(3); 
    ex f3 = (x+1)*y*z;
    p0 = lst(0.0,0.0,1.0);
    p1 = lst(0.0,1.0,0.0);

    Rectangle rectangle3(p0,p1);

    ex repr3 = rectangle3.repr();
    cout <<"s3.repr "<<repr3<<endl; 

    ex intf3 = rectangle3.integrate(f3); 
    cout <<"intf3 "<<intf3<<endl; 


    // regression test
    archive ar; 
    ar.archive_ex(intf, "intf"); 
    ar.archive_ex(repr, "repr"); 
    ar.archive_ex(intf2, "intf2"); 
    ar.archive_ex(repr2, "repr2"); 
    ar.archive_ex(intf3, "intf3"); 
    ar.archive_ex(repr3, "repr3"); 

    ofstream vfile("rectangle_ex1.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("rectangle_ex1.gar.v", "rectangle_ex1.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }



    return 0; 
}

