# SwiftPM 5.6 Release Notes

### Package Plugins

[SE-0303](https://github.com/apple/swift-evolution/blob/main/proposals/0303-swiftpm-extensible-build-tools.md) Introduces the ability to define build tool plugins in SwiftPM, allowing custom tools to be automatically invoked during a build. Build tool plugins are focused on code generation during the build of a package, for such purposes as generating Swift source files from .proto files or from other inputs, in order to allow build tools to be incorporated into the build graph and to run automatically in a safe manner.

[SE-0332](https://github.com/apple/swift-evolution/blob/main/proposals/0332-swiftpm-command-plugins.md) Extends SwiftPM plugin support first introduced with SE-0303 to allow the definition of custom command plugins — plugins that users can invoke directly from the SwiftPM CLI, or from an IDE that supports Swift Packages, in order to perform custom actions on their packages. A command plugin specifies the semantic intent of the command — this might be one of the predefined intents such “documentation generation” or “source code formatting”, or it might be a custom intent with a specialized verb that can be passed to the swift package command.

### Manifest API Improvements

Semantic version dependencies can now be resolved against Git tag names that contain only major and minor version identifiers. A tag with the form `X.Y` will be treated as `X.Y.0`. This improves compatibility with existing repositories.

Both parsing and comparison of semantic versions now strictly follow the Semantic Versioning 2.0.0 specification (https://semver.org/).
The parsing logic now treats the first "-" in a version string as the delimiter between the version core and the pre-release identifiers, only if there is no preceding "+". Otherwise, it's treated as part of a build metadata identifier.
The comparison logic now ignores build metadata identifiers, and treats 2 semantic versions as equal if and only if they're equal in their major, minor, patch versions and pre-release identifiers.

`.package(name:, url:)` dependency syntax is deprecated in favor of `.package(url:)`, given that an explicit name attribute is no longer needed for target dependencies lookup.

Adding a dependency requirement can now be done with the convenience initializer .package(url: String, exact: Version).

Dependency requirement enum calling convention is deprecated in favour of labeled argument:

* `.package(url: String, .branch(String)) -> .package(url: String, branch: String)`
* `.package(url: String, .revision(String)) -> .package(url: String, revision: String)`
* `.package(url: String, .exact(Version)) -> .package(url: String, exact: Version)`

### Other Improvements

Location of configuration files (including mirror file) have changed to accomodate new features that require more robust configuration directories structure, such as SE-0292:

* `<project>/.swiftpm/config` (mirrors file) was moved to `<project>/.swiftpm/configuration/mirrors.json`. SwiftPM 5.6 will automatically copy the file from the old location to the new one and emit a warning to prompt the user to delete the file from the old location.
* `~/.swiftpm/config/collections.json` (collections file) was moved to `~/.swiftpm/configuration/collections.json`. SwiftPM 5.6 will automatically copy the file from the old location to the new one and emit a warning to prompt the user to delete the file from the old location.

To increase the security of packages, SwiftPM performs trust on first use (TOFU) validation. The fingerprint of a package is now being recorded when the package is first downloaded from a Git repository or package registry. Subsequent downloads must have fingerpints matching previous recorded values, otherwise it would result in build warnings or failures depending on settings.

Introduce a second version of `Package.resolved` file format which more accurately captures package identity.
