/*
 * Decompiled with CFR 0.152.
 */
package adql.parser.grammar;

import adql.parser.ADQLParser;
import adql.parser.grammar.Token;
import adql.parser.grammar.TokenMgrError;
import adql.query.TextPosition;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected static String EOL = System.getProperty("line.separator", "\n");
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected TextPosition position = null;

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super(ParseException.initialise(currentTokenVal, expectedTokenSequencesVal, tokenImageVal));
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
        this.position = new TextPosition(this.currentToken.next);
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    public ParseException(String message, TextPosition errorPosition) {
        this(message);
        this.position = errorPosition;
    }

    public ParseException(TokenMgrError err) {
        this(ParseException.buildExpandedMessage(err), new TextPosition(err.getErrorLine(), err.getErrorColumn()));
    }

    private static final String buildExpandedMessage(TokenMgrError err) {
        if (err.getMessage().indexOf("<EOF>") > 0) {
            return err.getMessage() + "!" + EOL + "Possible cause: a string between single or double quotes which is never closed (solution: well...just close it!).";
        }
        return err.getMessage() + "!" + EOL + "Possible cause: a non-ASCI/UTF-8 character (solution: remove/replace it).";
    }

    public final TextPosition getPosition() {
        return this.position;
    }

    private static String initialise(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
        int maxSize = 0;
        StringBuilder expected = new StringBuilder();
        for (int i = 0; i < expectedTokenSequences.length; ++i) {
            if (maxSize < expectedTokenSequences[i].length) {
                maxSize = expectedTokenSequences[i].length;
            }
            for (int j = 0; j < expectedTokenSequences[i].length; ++j) {
                expected.append(tokenImage[expectedTokenSequences[i][j]]);
            }
            expected.append(" ");
        }
        StringBuilder msg = new StringBuilder();
        msg.append(" Encountered \"");
        Token tok = currentToken.next;
        StringBuilder tokenName = new StringBuilder();
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                tokenName.append(' ');
            }
            if (tok.kind == 0) {
                tokenName.append(tokenImage[0]);
                break;
            }
            tokenName.append(ParseException.add_escapes(tok.image));
            tok = tok.next;
        }
        msg.append(tokenName.toString()).append("\".");
        if (expectedTokenSequences.length != 0) {
            if (expectedTokenSequences.length == 1) {
                msg.append(" Was expecting: ");
            } else {
                msg.append(" Was expecting one of: ");
            }
            msg.append((CharSequence)expected);
        }
        if (maxSize == 1) {
            tok = currentToken.next;
            if (tok.adqlReserved) {
                msg.append(EOL).append("(HINT: \"").append(tok.image).append("\" is a reserved ADQL word in " + (Object)((Object)currentToken.next.adqlVersion) + ". To use it as a column/table/schema name/alias, write it between double quotes.)");
            } else if (tok.sqlReserved) {
                msg.append(EOL).append("(HINT: \"").append(tok.image).append("\" is not supported in ADQL " + (Object)((Object)currentToken.next.adqlVersion) + ", but is however a reserved word. To use it as a column/table/schema name/alias, write it between double quotes.)");
            } else if (tok.adqlVersion == ADQLParser.ADQLVersion.V2_0 && tok.image.matches("[~^|&]")) {
                msg.append(EOL).append("(HINT: \"").append(tok.image).append("\" bitwise operations are not supported in ADQL-2.0. You should migrate your ADQL parser to support at least ADQL-2.1.)");
            }
        }
        return msg.toString();
    }

    static String add_escapes(String str) {
        StringBuilder retval = new StringBuilder();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

