/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.AngularDistanceComputer;
import cds.healpix.CompassPoint;
import cds.healpix.HashComputer;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.HealpixNestedFixedRadiusConeComputer;
import cds.healpix.NeighbourList;
import cds.healpix.NeighbourSelector;
import cds.healpix.VerticesAndPathComputer;
import cds.healpix.common.math.Math;
import java.util.EnumSet;

final class NestedLargeCellApproxedMethod
implements HealpixNestedFixedRadiusConeComputer {
    private static final EnumSet<CompassPoint.Cardinal> ALL_CARDINALS = EnumSet.allOf(CompassPoint.Cardinal.class);
    private final int startingDepth;
    private final int hashDepth;
    private final HealpixNested hn;
    private final HashComputer hc;
    private final NeighbourSelector neiSelect;
    private final VerticesAndPathComputer vpc;
    private final int twiceDeltaOrder;
    private final double coneRadiusRad;
    private final AngularDistanceComputer angDistComputer;
    private final long[] result = new long[9];
    private final double[] cellCenter = new double[2];
    private final NeighbourList neigList;

    public NestedLargeCellApproxedMethod(int startingDepth, int outputDepth, double radiusRad) {
        this.startingDepth = startingDepth;
        this.hashDepth = outputDepth;
        if (startingDepth < this.hashDepth) {
            throw new IllegalArgumentException("Choosen radius too large for the wanted depth!");
        }
        this.hn = Healpix.getNested(startingDepth);
        this.hc = this.hn.newHashComputer();
        this.vpc = this.hn.newVerticesAndPathComputer();
        this.neiSelect = this.hn.newNeighbourSelector();
        this.twiceDeltaOrder = startingDepth - this.hashDepth << 1;
        this.coneRadiusRad = radiusRad;
        this.angDistComputer = AngularDistanceComputer.getComputer(this.coneRadiusRad);
        this.neigList = new NeighbourList(-1);
    }

    @Override
    public double getRadius() {
        return this.coneRadiusRad;
    }

    @Override
    public HealpixNestedFixedRadiusConeComputer newComputer() {
        return new NestedLargeCellApproxedMethod(this.startingDepth, this.hashDepth, this.coneRadiusRad);
    }

    @Override
    public HealpixNestedBMOC overlappingCells(double coneCenterLonRad, double coneCenterLatRad, HealpixNestedFixedRadiusConeComputer.ReturnedCells returnedCells) {
        switch (returnedCells) {
            case FULLY_IN: {
                return this.overlappingFullyIn(coneCenterLonRad, coneCenterLatRad);
            }
            case OVERLAPPING: {
                return this.overlappingCells(coneCenterLonRad, coneCenterLatRad);
            }
            case CENTER_IN: {
                return this.overlappingCenters(coneCenterLonRad, coneCenterLatRad);
            }
        }
        throw new Error("Type " + (Object)((Object)returnedCells) + " not implemented!");
    }

    private HealpixNestedBMOC overlappingFullyIn(double coneCenterLonRad, double coneCenterLatRad) {
        double cosConeCenterLat = Math.cos(coneCenterLatRad);
        long centerHash = this.hc.hash(coneCenterLonRad, coneCenterLatRad);
        this.neiSelect.neighbours(centerHash, this.neigList);
        this.neigList.put(centerHash, CompassPoint.MainWind.C);
        int ir = 0;
        double[] center = new double[2];
        for (int i = 0; i < this.neigList.size(); ++i) {
            long h = this.neigList.get(i);
            if (!this.allVerticesOk(h, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat)) continue;
            this.result[ir++] = h;
        }
        return HealpixNestedBMOC.createPacking(this.hashDepth, this.result, ir);
    }

    private boolean allVerticesOk(long hash, double coneCenterLon, double coneCenterLat, double cosCenterLat) {
        for (double[] vertex : this.vpc.vertices(hash, ALL_CARDINALS).values()) {
            double vLat;
            double vLon = vertex[0];
            double dConeCell = this.angDistComputer.haversineDistInRad(vLon - coneCenterLon, (vLat = vertex[1]) - coneCenterLat, cosCenterLat, Math.cos(vLat));
            if (!(dConeCell > this.coneRadiusRad)) continue;
            return false;
        }
        return true;
    }

    @Override
    public HealpixNestedBMOC overlappingCells(double coneCenterLon, double coneCenterLat) {
        long ch4moc;
        double cosConeCenterLat = Math.cos(coneCenterLat);
        long centerHash = this.hc.hash(coneCenterLon, coneCenterLat);
        this.neiSelect.neighbours(centerHash, this.neigList);
        long ch = centerHash >>> this.twiceDeltaOrder;
        this.result[0] = ch4moc = HealpixNestedBMOC.buildValue(this.hashDepth, ch, false, this.hashDepth);
        int ir = 1;
        for (int i = 0; i < this.neigList.size(); ++i) {
            long h = this.neigList.get(i);
            long hmm = h >>> this.twiceDeltaOrder;
            long h4moc = HealpixNestedBMOC.buildValue(this.hashDepth, hmm, false, this.hashDepth);
            if (h4moc == ch4moc || !NestedLargeCellApproxedMethod.isNotIn(h4moc, this.result, ir)) continue;
            this.vpc.center(h, this.cellCenter);
            double cellCenterLon = this.cellCenter[0];
            double cellCenterLat = this.cellCenter[1];
            double rCircumCircle = Healpix.getLargestCenterToCellVertexDistance(cellCenterLon, cellCenterLat, this.startingDepth);
            double dConeCell = this.angDistComputer.haversineDistInRad(cellCenterLon - coneCenterLon, cellCenterLat - coneCenterLat, cosConeCenterLat, Math.cos(cellCenterLat));
            if (!NestedLargeCellApproxedMethod.isCellOverlapingCone(this.coneRadiusRad, rCircumCircle, dConeCell)) continue;
            this.result[ir++] = h4moc;
        }
        return HealpixNestedBMOC.createPacking(this.hashDepth, this.result, ir);
    }

    @Override
    public HealpixNestedBMOC overlappingCenters(double coneCenterLon, double coneCenterLat) {
        long ch4moc;
        double cosConeCenterLat = Math.cos(coneCenterLat);
        long centerHash = this.hc.hash(coneCenterLon, coneCenterLat);
        this.neiSelect.neighbours(centerHash, this.neigList);
        long ch = centerHash >>> this.twiceDeltaOrder;
        this.result[0] = ch4moc = HealpixNestedBMOC.buildValue(this.hashDepth, ch, false, this.hashDepth);
        int ir = 1;
        for (int i = 0; i < this.neigList.size(); ++i) {
            long h = this.neigList.get(i);
            long hmm = h >>> this.twiceDeltaOrder;
            long h4moc = HealpixNestedBMOC.buildValue(this.hashDepth, hmm, false, this.hashDepth);
            if (h4moc == ch4moc || !NestedLargeCellApproxedMethod.isNotIn(h4moc, this.result, ir)) continue;
            this.vpc.center(h, this.cellCenter);
            double cellCenterLon = this.cellCenter[0];
            double cellCenterLat = this.cellCenter[1];
            double dConeCell = this.angDistComputer.haversineDistInRad(cellCenterLon - coneCenterLon, cellCenterLat - coneCenterLat, cosConeCenterLat, Math.cos(cellCenterLat));
            if (!(dConeCell <= this.coneRadiusRad)) continue;
            this.result[ir++] = h4moc;
        }
        return HealpixNestedBMOC.createPacking(this.hashDepth, this.result, ir);
    }

    private static final boolean isNotIn(long h, long[] ah, long alength) {
        int i = 1;
        while ((long)i < alength) {
            if (h == ah[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final boolean isCellOverlapingCone(double coneRadius, double cellCircumCircleRadius, double coneCenterToCellCenterDistance) {
        return coneCenterToCellCenterDistance < coneRadius + cellCircumCircleRadius;
    }
}

