#ifndef _h_ktst_unit_test_
#define _h_ktst_unit_test_

#include <ktst/test_tools.hpp>
#include <ktst/unit_test_suite.hpp>

#include <iostream> // cout
#include <sstream> // ostringstream
#include <vector>
#include <cassert>
#include <csignal> /* sigaction */

////////////////////////////////////////////////////////////////////////////////

#define FIXTURE_TEST_CASE(test_name, F) \
namespace ncbi { namespace NK { \
class C##test_name : public TestCase { \
public: \
    C##test_name(void* globalFixtute, F* fixture) : TestCase(#test_name) \
        , _globalFixture \
            (static_cast<AUTO_TEST_CASE_FIXTURE*>(globalFixtute)) \
        , _fixture(fixture) {} \
    void test_method(); \
private: \
    AUTO_TEST_CASE_FIXTURE* GET_GLOBAL_FIXTURE(void) const \
    { return _globalFixture; } \
    F* GET_FIXTURE(void) const { return _fixture; } \
    AUTO_TEST_CASE_FIXTURE* _globalFixture; \
    F* _fixture; \
}; \
class C##test_name##Invoker : TestInvoker { \
public: C##test_name##Invoker(void) : TestInvoker(#test_name) \
{ GetTestSuite()->Add(this); } \
private: virtual void Run(void* globalFixtute) { \
        F fixture; \
        C##test_name t(globalFixtute, &fixture); \
        try { \
            t.test_method(); \
            SetErrorCounter(t.GetErrorCounter()); \
        } catch (...) { \
            SetErrorCounter(t.GetErrorCounter()); \
            throw; \
        } \
    } \
}; \
static C##test_name##Invoker* _##test_name##instance \
    = new C##test_name##Invoker; \
} } /* ncbi::NK */ \
void ncbi::NK::C##test_name::test_method()

#define TEST_CASE(test_name) FIXTURE_TEST_CASE(test_name, ncbi::NK::Empty)

#define FIXTURE_TEST_SUITE( suite_name, F ) \
typedef F AUTO_TEST_CASE_FIXTURE; \
int main(int argc, char* argv[]) { \
    ncbi::NK::TestEnv args(argc, argv); \
    if (args.catch_system_errors) { \
        args.set_handlers(); \
    } \
    ncbi::NK::counter_t ec = \
        ncbi::NK::Main<AUTO_TEST_CASE_FIXTURE>(argc, argv, #suite_name); \
    return ec == 0 ? EXIT_SUCCESS : EXIT_FAILURE; \
} \
std::string ncbi::NK::TestEnv::lastLocation; \
ncbi::NK::LogLevel::E ncbi::NK::TestEnv::verbosity = LogLevel::e_error;

#define TEST_SUITE( suite_name ) \
FIXTURE_TEST_SUITE(suite_name, ncbi::NK::Empty)

#endif// _h_ktst_unit_test_
