/*
  htmlchk -- checks if page has directives to explicit disable caching
  Copyright (C) 2003  Pedro Zorzenon Neto <pzn@autsens.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _HTMLCHK_H
#define _HTMLCHK_H

struct htmlchk {
  char * tmpfile;
};

typedef struct htmlchk htmlchk_t;

/* returns a pointer to htmlchk_t */
htmlchk_t * htmlchk_init (void);

/* destroy htmlchk struct */
void htmlchk_destroy (htmlchk_t * self);

/* retrieves page from cache and checks if it contains patterns
 * asking not to be cached
 *
 * returns:
 *  -1 = error occoured
 *   0 = page is not in cache, or could not be retrieved
 *   1 = page is in cache and does not need to be removed
 *   2 = page is in cache and asks to be removed
 */
int htmlchk_pagestate (htmlchk_t * self, char * url);

#endif /* _HTMLCHK_H */
