-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure CheckSuspendsListAccountedFor (Proc_Or_Task : in Dictionary.Symbol;
                                         Node_Pos     : in LexTokenManager.Token_Position) is
   It           : Dictionary.Iterator;
   The_PO_Or_SO : Dictionary.Symbol;
begin
   if not Dictionary.BodyIsHidden (Proc_Or_Task) then
      It := Dictionary.FirstSuspendsListItem (Proc_Or_Task);
      while not Dictionary.IsNullIterator (It) loop
         The_PO_Or_SO := Dictionary.CurrentSymbol (It);
         if not Dictionary.SuspendsListItemIsAccountedFor (TheTaskOrProc => Proc_Or_Task,
                                                           ThePOorSO     => The_PO_Or_SO) then
            ErrorHandler.Semantic_Error
              (Err_Num   => 914,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Pos,
               Id_Str    => Dictionary.GetSimpleName (The_PO_Or_SO));
         end if;
         It := Dictionary.NextSymbol (It);
      end loop;
   end if;
end CheckSuspendsListAccountedFor;
