-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem)
procedure Check_Package_Prefix
  (Node_Pos : in     LexTokenManager.Token_Position;
   Pack_Sym : in     Dictionary.Symbol;
   Scope    : in     Dictionary.Scopes;
   OK       :    out Boolean)
is
begin
   if Dictionary.PrefixAllowed (Pack_Sym, Scope) then
      OK := True;
   else
      OK := False;
      ErrorHandler.Semantic_Error
        (Err_Num   => 337,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Pos,
         Id_Str    => Dictionary.GetSimpleName (Pack_Sym));
   end if;
end Check_Package_Prefix;
