9.2 Żywe Pętle (Live Loops)

# Żywe Pętle (Live Loops)

Dobrze, ten rozdział to prawdziwa perełka w tym samouczku. Jeśli 
masz przeczytać tylko jeden rozdział w tym tutorialu, powinien to 
być właśnie ten rozdział. Jeśli przeczytałeś poprzedni rozdział 
o Podstawach Kodowania Na Żywo, to `live_loop` jest prostszą metodą 
dokonania dokładnie tego samego, ale bez konieczności pisania 
tak dużej ilości kodu. 

Jeśli nie przeczytałeś poprzedniego rozdziału, funkcja `live_loop` 
jest najlepszym sposobem na jam'owanie z Sonic Pi.

Zabawmy się. Wpiszmy następujący kod do nowego bufora: 

```
live_loop :foo do
  play 60
  sleep 1
end
```

Naciśnij przycisk Run. Słyszysz podstawowy bip przy każdym uderzeniu. 
Nic szczególnego. Powstrzymaj się jednak i nie naciskaj jeszcze przycisku 
Stop. Zmień wartość `60` na `65` i naciśnij przycisk Run jeszcze raz. 

Now press the Run button. You hear a basic beep every beat. Nothing
fun there. However, don't press Stop just yet. Change the `60` to `65`
and press Run again.

Łał! Brzmienie zmieniło się *automatycznie* bez utraty żadnego uderzenia. 

Czemu więc nie spróbować zmienić ten kawałek aby brzmiał trochę bardziej jak linia 
basowa? Wystarczy, że zmienisz kod gdy ten wciąż jest uruchomiony: 

```
live_loop :foo do
  use_synth :prophet
  play :e1, release: 8
  sleep 8
end
```

I naciśniesz przycisk Run.

Spróbujmy sprawić, aby pojawiła się odrobina odcięcia (cutoff):

```
live_loop :foo do
  use_synth :prophet
  play :e1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

Ponownie naciśnij przycisk Run.

Dodajmy trochę bębnów: 

```
live_loop :foo do
  sample :loop_garzul
  use_synth :prophet
  play :e1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

Zmień nutę `e1` na `c1`:

```
live_loop :foo do
  sample :loop_garzul
  use_synth :prophet
  play :c1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

A teraz przestań słuchać moich propozycji i zacznij bawić się 
samodzielnie! Miłej zabawy!
