2.3 Changement de synthés

# Changement de synthés

Jusqu'à maintenant, nous nous sommes bien amusés à faire des beeps.
Cependant, vous commencez probablement à être ennuyé par le bruit
basique du beep. Sonic Pi n'a-t-il que cela à offir en tout et pour
tout ? Il y a certainement plus dans le codage en "live" que de jouer
seulement des beeps. Oui, et dans cette section nous allons
explorer l'étendue des sons que Sonic Pi a à offrir.

## Synthés

Sonic Pi dispose d'un lot d'instruments qu'il appelle synths *raccourci
pour synthétiseurs*. Tandis que les échantillons (samples) représentent
des sons pré-enregistrés, les synthés (synths) sont capables de générer
des nouveaux sons en fonction de la façon dont vous les contrôlez (ce
que nous explorerons plus tard dans ce tutoriel). Les synthés de Sonic Pi
sont très puissants et expressifs, et vous aurez grand plaisir à les
explorer et à jouer avec. En premier lieu, apprenons à sélectionner le
synthé en cours à utiliser.

## Dents de scie vibrantes et prophets

Un son sympathique est l'*onde en dent de scie (saw)* - essayons-le :

```
use_synth :saw
play 38
sleep 0.25
play 50
sleep 0.25
play 62
sleep 0.25
```

Essayons un autre son - le *prophet* :

```
use_synth :prophet
play 38
sleep 0.25
play 50
sleep 0.25
play 62
sleep 0.25
```

Comment combiner deux sons. D'abord l'un après l'autre :

```
use_synth :saw
play 38
sleep 0.25
play 50
sleep 0.25
use_synth :prophet
play 57
sleep 0.25

```

Maintenant en même temps :

```
use_synth :tb303
play 38
sleep 0.25
use_synth :dsaw
play 50
sleep 0.25
use_synth :prophet
play 57
sleep 0.25
```

Notez que la commande `use_synth` n'agit que sur les appels suivants à
`play`. Pensez à elle comme un *gros commutateur* - les nouveaux appels
à `play` vont jouer tout synthé qui est désigné "en cours". Vous pouvez
enclencher le commutateur sur un nouveau synthé avec `use_synth`.

## Découverte des synthés

Pour voir quels synthés Sonic Pi met à votre disposition pour jouer,
jetez un œil sur les options de Synths dans le menu horizontal tout à
fait en bas (à gauche de Fx). Il y en a 33 au choix. Voici mes préférés :

* `:prophet`
* `:dsaw`
* `:fm`
* `:tb303`
* `:pulse`

Maintenant jouez en *commutant les synthés au cours de votre jeu*.
Prenez plaisir à combiner des synthés pour faire de nouveaux sons et
aussi en untilisant différents synthés selon les sections de votre
musique.
