6.2 FX en Pratique

# FX en pratique

Bien qu'ils paraissent trompeusement simples extérieurement, les FX sont 
réellement des bêtes plutôt complexes à l'intérieur. Leur 
simplicité incite souvent les gens à en abuser dans leurs morceaux. Ce 
peut être sympathique si vous avez une machine puissante, mais si - 
comme moi - vous utilisez un Raspberry Pi pour improviser, vous devez 
prendre garde à la somme de travail que vous lui demandez de faire si 
vous voulez vous assurer que la cadence reste fluide.

Considérez ce code :

```
loop do
  with_fx :reverb do
    play 60, release: 0.1
    sleep 0.125
  end
end
```

Dans ce code, nous jouons la note 60 avec une durée d'extinction très 
courte, c'est donc une note courte. Nous voulons aussi de la 
réverbération, alors nous l'avons imbriqué dans un bloc de 
réverbération. Jusqu'à maintenant, tout est bon. Sauf que...

Regardons ce que fait le code. En premier lieu, nous avons une boucle 
(`loop`), ce qui signifie que tout ce qui est à l'intérieur est 
répété sans fin. Ensuite, nous avons un bloc `with_fx`. Ceci veut dire
que nous allons créer un nouvel FX de réverbération *chaque fois que 
nous bouclons*. C'est comme si nous disposions d'une pédale de 
réverbération distincte à chaque fois que nous pincions une corde sur 
une guitare. C'est super de pouvoir faire ça, mais ce n'est pas 
toujours ce que vous voulez. Par exemple, ce code va avoir du mal à 
s'exécuter comme il faut sur un Raspberry Pi. Tout le travail de création 
de la réverbération puis d'attente jusqu'à ce qu'elle doive être 
stoppée et enlevée est complètement pris en charge par `with_fx` pour 
vous, mais ceci prend de la puissance du microprocesseur (CPU) qui peut 
être précieuse.

Comment le faire d'une manière plus proche d'une installation 
traditionnelle où notre guitariste n'a *qu'une* pédale de 
réverbération dans laquelle passent tous les sons ? Simple :

```
with_fx :reverb do
  loop do
    play 60, release: 0.1
    sleep 0.125
  end
end
```

Nous mettons notre boucle *à l'intérieur* du bloc `with_fx`. De cette 
façon, nous créons seulement une unique réverbération pour toutes les 
notes jouées dans notre boucle. Ce code est beaucoup plus efficace et 
fonctionnerait bien sur un Raspberry Pi.

Un compromis est d'utiliser `with_fx` sur une itération à l'intérieur 
d'une boucle :

```
loop do
  with_fx :reverb do
    16.times do
      play 60, release: 0.1
      sleep 0.125
    end
  end
end
```

De cette façon, nous avons remonté le `with_fx` en dehors de la partie 
la plus intérieure de la boucle, et nous créons maintenant une 
nouvelle réverbération toutes les 16 notes.

C'est quelque chose que l'on fait si souvent que `with_fx` supporte
une option pour faire exactement cela sans devoir écrire le bloc
`16.times` :

```
loop do
  with_fx :reverb, reps: 16 do
    play 60, release: 0.1
    sleep 0.125
  end
end
```

Les deux exemples `reps: 16` et `16.times do` se comporteront de la
même manière. L'exemple avec `reps: 16` répète en fait le code dans le
bloc `do/end` seize fois donc vous pouvez choisir l'un ou l'autre en
fonction de vos préférences.

Rappelez-vous, il n'y a pas de fautes, juste des possibilités. 
Toutefois, certaines de ces approches donneront un son différent et
auront des caractéristiques de performance différentes. Donc, jouez et
utilisez l'approche qui sonne le mieux pour vous tout en restant dans 
les contraintes de performance de votre plateforme.
