/* -------------------------------------------------------------------- */
/* SMS Client, send messages to mobile phones and pagers		*/
/*									*/
/* gs_io.c								*/
/*									*/
/*  Copyright (C) 1997,1998 Angelo Masci				*/
/*									*/
/*  This library is free software; you can redistribute it and/or	*/
/*  modify it under the terms of the GNU Library General Public		*/
/*  License as published by the Free Software Foundation; either	*/
/*  version 2 of the License, or (at your option) any later version.	*/
/*									*/
/*  This library is distributed in the hope that it will be useful,	*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of	*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU	*/
/*  Library General Public License for more details.			*/
/*									*/
/*  You should have received a copy of the GNU Library General Public	*/
/*  License along with this library; if not, write to the Free		*/
/*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	*/
/*									*/
/*  You can contact the author at this e-mail address:			*/
/*									*/
/*  angelo@styx.demon.co.uk						*/
/*									*/
/* -------------------------------------------------------------------- */
/* $Id$
   -------------------------------------------------------------------- */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include "common/common.h"
#include "gs_io.h"

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */

#if 0	/* The Linux REDHAT distribution doesn't	*/
	/* like this. Anyone using REDHAT like to 	*/
	/* spill the beans and tell me why?		*/

static FILE *parser_fp = stdin;
#else
static FILE *parser_fp = NULL;
#endif

/* -------------------------------------------------------------------- */

#define MAX_CHARACTER_STACK 512

static char character_stack[MAX_CHARACTER_STACK];
static int  character_stack_top = -1;
static int  linenumber = 1;

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
int gs_open(char *file)
{
	parser_fp = fopen(file, "r");
	if (parser_fp == NULL)
	{	return -1;
	}

	return 0;
}


/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
int gs_close(void)
{
	if (fileno(stdin) == fileno(parser_fp))
	{	return 0;
	}

	return fclose(parser_fp);
}


/* -------------------------------------------------------------------- */
/* If we have pushed back a character then return it, else		*/
/* return the next character.						*/
/* -------------------------------------------------------------------- */
int get_next_character(void)
{
	int 	character;


	character = pop_character();
	if (character != -1)
	{
		return character;
	}

	character = fgetc(parser_fp);

	if (character == '#')
	{	character = fgetc(parser_fp);
		while (character != '\n')
		{	character = fgetc(parser_fp);
		}
	}

	if (character == '\n')
	{	linenumber++;
	}

	return character;
}

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
void init_linenumber(void)
{
	linenumber = 1;
}

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
int get_linenumber(void)
{
	return linenumber;
}

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
int push_character(int character)
{
	if (character_stack_top +1 >= MAX_CHARACTER_STACK)
	{
		return -1;
	}

	character_stack_top++;
	character_stack[character_stack_top] = character;

	if (character == '\n')
	{	linenumber--;
	}

	return 0;
}


/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
int pop_character(void)
{
	int character;


	if (character_stack_top == -1)
	{	return -1;
	}

	character = character_stack[character_stack_top];
	character_stack_top--;

	if (character == '\n')
	{	linenumber++;
	}

	return character;
}


/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
int escape_char(void)
{
	int 	character, 
		escaped_character;

	character = get_next_character();

	if (character == 'a')
	{	escaped_character = '\f';
	}
	else
	if (character == 'b')
	{	escaped_character = '\b';
	}
	else
	if (character == 'f')
	{	escaped_character = '\f';
	}
	else
	if (character == 'n')
	{	escaped_character = '\n';
	}
	else
	if (character == 'r')
	{	escaped_character = '\r';
	}
	else
	if (character == 't')
	{	escaped_character = '\t';
	}
	else
	if (character == 'v')
	{	escaped_character = '\v';
	}
	else
	if (character == 'x')
	{
		int	low_nibble,
			high_nibble,
			high_character,
			low_character;

		character = get_next_character();
		high_character = character;

		if (isxdigit(character))
		{
			if ((character >= '0') && (character <= '9'))
			{
				high_nibble = (character - '0') << 4;
			}
			else
			if ((character >= 'a') && (character <= 'f'))
			{	
				high_nibble = (10 + (character - 'a')) << 4;
			}
			else
			{	high_nibble = (10 + (character - 'A')) << 4;
			}

			character = get_next_character();
			low_character = character;


			if (isxdigit(character))
			{
				if ((character >= '0') && (character <= '9'))
				{
					low_nibble = (character - '0');
				}
				else
				if ((character >= 'a') && (character <= 'f'))
				{	
					low_nibble = (10 + (character - 'a'));
				}
				else
				{	low_nibble = (10 + (character - 'A'));
				}

				escaped_character = high_nibble + low_nibble;
			}		
			else
			{
				/* Error */

				push_character('x');
				push_character(high_character);
				push_character(low_character);

				escaped_character = '\\';
			}
		}
		else
		{	
			/* Error */

			push_character('x');
			push_character(high_character);

			escaped_character = '\\';
		}
	}
	else
	if (character == '\\')
	{	escaped_character = '\\';
	}
	else
	if (character == '\"')
	{	escaped_character = '\"';
	}
	else
	if (character == '\'')
	{	escaped_character = '\'';
	}
	else
	{
		/* Error */

		push_character(character);
		escaped_character = '\\';
	}

	return escaped_character;
}


