;;
;; Windows SMC NSIS installer language macros
;; modified from the Pidgin installer version

!macro SMC_MACRO_DEFAULT_STRING LABEL VALUE
  !ifndef "${LABEL}"
    !define "${LABEL}" "${VALUE}"
    !ifdef INSERT_DEFAULT
      !warning "${LANG} lang file missing ${LABEL}, using default..."
    !endif
  !endif
!macroend

!macro SMC_MACRO_LANGSTRING_INSERT LABEL LANG
  LangString "${LABEL}" "${LANG_${LANG}}" "${${LABEL}}"
  !undef "${LABEL}"
!macroend

!macro SMC_MACRO_LANGUAGEFILE_BEGIN LANG
  !define CUR_LANG "${LANG}"
!macroend

!macro SMC_MACRO_LANGUAGEFILE_END
  !define INSERT_DEFAULT
  !include "${SMC_DEFAULT_LANGFILE}"
  !undef INSERT_DEFAULT

  ; SMC Language file Version 1
  ; String labels should match those from the default language file.

  ; Startup checks
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_INSTALLER_IS_RUNNING		${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_ALREADY_INSTALLED		${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_IS_RUNNING				${CUR_LANG}

  ; Components Page
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_CORE_SECTION_TITLE				${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_CORE_SECTION_DESCRIPTION			${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_SOURCE_CODE_SECTION_TITLE		${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_SOURCE_CODE_SECTION_DESCRIPTION	${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_STARTMENU_SHORTCUT_SECTION_TITLE	${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_STARTMENU_SHORTCUT_DESC			${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_DESKTOP_SHORTCUT_SECTION_TITLE	${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_DESKTOP_SHORTCUT_DESC			${CUR_LANG}

  ; Installer Finish Page
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_FINISH_WEB_PAGE_INFO			${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_FINISH_VEW_CONTROLS			${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_FINISH_VEW_CONTROLS_INFO		${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_FINISH_DONATE_INFO			${CUR_LANG}

  ; Shortcuts
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_SHORTCUT_WEB_PAGE	${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_SHORTCUT_CONTROLS	${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_SHORTCUT_DONATE		${CUR_LANG}
  !insertmacro SMC_MACRO_LANGSTRING_INSERT SMC_SHORTCUT_UNINSTALL	${CUR_LANG}

  ; Uninstall Section Prompts
  !insertmacro SMC_MACRO_LANGSTRING_INSERT un.SMC_KEEP_USER_DATA	${CUR_LANG}

  !undef CUR_LANG
!macroend

!macro SMC_MACRO_INCLUDE_LANGFILE LANG FILE
  !insertmacro SMC_MACRO_LANGUAGEFILE_BEGIN "${LANG}"
  !include "${FILE}"
  !insertmacro SMC_MACRO_LANGUAGEFILE_END
!macroend
