/*
 	hash.c
 
 	Hashing high-level functions of 'sks' project
 	
	Copyright (C) 2004-2007  Manuel Pancorbo Castro

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Manuel Pancorbo Castro <mpancorbo@gmail.com>
 
*/

/*#include <stdio.h>*/
#include <unistd.h>
#include "mycrypt.h"
#include "sks.h"

/** First 2048 bits of PI/4. To be the salt of passwords **/
unsigned char salt[PASSWD_SIZE] = {
0xc9, 0x0f, 0xda, 0xa2, 0x21, 0x68, 0xc2, 0x34, 0xc4, 0xc6, 0x62, 0x8b, 0x80, 0xdc, 0x1c, 0xd1, 
0x29, 0x02, 0x4e, 0x08, 0x8a, 0x67, 0xcc, 0x74, 0x02, 0x0b, 0xbe, 0xa6, 0x3b, 0x13, 0x9b, 0x22, 
0x51, 0x4a, 0x08, 0x79, 0x8e, 0x34, 0x04, 0xdd, 0xef, 0x95, 0x19, 0xb3, 0xcd, 0x3a, 0x43, 0x1b, 
0x30, 0x2b, 0x0a, 0x6d, 0xf2, 0x5f, 0x14, 0x37, 0x4f, 0xe1, 0x35, 0x6d, 0x6d, 0x51, 0xc2, 0x45, 
0xe4, 0x85, 0xb5, 0x76, 0x62, 0x5e, 0x7e, 0xc6, 0xf4, 0x4c, 0x42, 0xe9, 0xa6, 0x37, 0xed, 0x6b, 
0x0b, 0xff, 0x5c, 0xb6, 0xf4, 0x06, 0xb7, 0xed, 0xee, 0x38, 0x6b, 0xfb, 0x5a, 0x89, 0x9f, 0xa5, 
0xae, 0x9f, 0x24, 0x11, 0x7c, 0x4b, 0x1f, 0xe6, 0x49, 0x28, 0x66, 0x51, 0xec, 0xe4, 0x5b, 0x3d, 
0xc2, 0x00, 0x7c, 0xb8, 0xa1, 0x63, 0xbf, 0x05, 0x98, 0xda, 0x48, 0x36, 0x1c, 0x55, 0xd3, 0x9a, 
0x69, 0x16, 0x3f, 0xa8, 0xfd, 0x24, 0xcf, 0x5f, 0x83, 0x65, 0x5d, 0x23, 0xdc, 0xa3, 0xad, 0x96, 
0x1c, 0x62, 0xf3, 0x56, 0x20, 0x85, 0x52, 0xbb, 0x9e, 0xd5, 0x29, 0x07, 0x70, 0x96, 0x96, 0x6d, 
0x67, 0x0c, 0x35, 0x4e, 0x4a, 0xbc, 0x98, 0x04, 0xf1, 0x74, 0x6c, 0x08, 0xca, 0x18, 0x21, 0x7c, 
0x32, 0x90, 0x5e, 0x46, 0x2e, 0x36, 0xce, 0x3b, 0xe3, 0x9e, 0x77, 0x2c, 0x18, 0x0e, 0x86, 0x03, 
0x9b, 0x27, 0x83, 0xa2, 0xec, 0x07, 0xa2, 0x8f, 0xb5, 0xc5, 0x5d, 0xf0, 0x6f, 0x4c, 0x52, 0xc9, 
0xde, 0x2b, 0xcb, 0xf6, 0x95, 0x58, 0x17, 0x18, 0x39, 0x95, 0x49, 0x7c, 0xea, 0x95, 0x6a, 0xe5, 
0x15, 0xd2, 0x26, 0x18, 0x98, 0xfa, 0x05, 0x10, 0x15, 0x72, 0x8e, 0x5a, 0x8a, 0xaa, 0xc4, 0x2d, 
0xad, 0x33, 0x17, 0x0d, 0x04, 0x50, 0x7a, 0x33, 0xa8, 0x55, 0x21, 0xab, 0xdf, 0x1c, 0xba, 0x64, 
};

const char end_common [] = "###-------------------------SKS";

/*******************
 ** Hashing functions
 **/
 
ERROR hash_password(char *frase, PrivKey p)
{
	unsigned char pass[PASSWD_SIZE];	
	
	memcpy(pass, salt, PASSWD_SIZE);
	memcpy(pass, frase, strlen(frase));
	return hash_binary(p, pass, PASSWD_SIZE);
}

ERROR hash_binary(byte *buf, byte *bin, size_t len)
{
	hash_state md;
	ERROR err;

	tiger_init(&md);
	if((err = tiger_process(&md, bin, len))) return err;
	if((err = tiger_done(&md, buf))) return err;
	return 0;
}

static hash_state md_file;

ERROR hash_binary_file(FILE *inp)
{
	
	byte *buffer;
	int fd, i = 1;
	unsigned long int len, max_size = MAX_ALLOC_SIZE;
	ERROR err;

	while((buffer = malloc(max_size)) == NULL){
		max_size /= ++i;	
	}
	tiger_init(&md_file);

	fd = fileno(inp);
	while(/*!(feof(inp))*/ 1){
		if(!(len = read(fd, buffer, max_size))) break;
		if((err = tiger_process(&md_file, buffer, len))) return err;
	}

	/*if((err = tiger_done(&md, out))) return err;*/
	zeromem(buffer, max_size);
	free(buffer);
	return 0;
}


ERROR hash_ascii_text(FILE * f_inp, FILE * f_out, int write)
{
	unsigned n;
	byte buffer[MEDIUM_BUF];
	/*hash_state md;*/
	ERROR err = 0;

	tiger_init(&md_file);
	while (!feof(f_inp)){
		fgets((char *)buffer, MEDIUM_BUF, f_inp);  /* EOL -> \n */
		n = strlen((char *)buffer);
		if(!n) break;
		if((buffer[n-1] == '\n') || (buffer[n-1] == '\r')) buffer[n-1] = 0;
		if((buffer[n-2] == '\n') || (buffer[n-2] == '\r')) buffer[n-2] = 0;
		n = strlen((char*)buffer);

    	if(!write && !strncmp((char *)buffer, end_common, sizeof(end_common) - 1)) break;
		/* must be end of packet */

		fputs( (char*)buffer, f_out);
		fputs("\n", f_out);

		if((err = tiger_process(&md_file, buffer, n))) return err;
		memset(buffer, 0, n);
	}

	/*err = tiger_done(&md, c);*/

	zeromem( buffer, sizeof(buffer));
	burn_stack(MEDIUM_BUF + 100);
	return err;
}

ERROR hash_time(vlPoint c, time_t  t)
{
	if(t != 0L){
		unsigned char tmp[4];
		int i;
		for(i = 0; i < 4; ++i){
			tmp[i] = t & 0xff;
			t >>= 8;
		}
		tiger_process(&md_file, tmp, 4);
	}
	return tiger_done(&md_file, c);
}
	

