/* Public domain. */

#ifndef TAI_H
#define TAI_H

#include <sys/time.h>
#include "gccattributes.h"
#include "uint64.h"

struct tai
{
  uint64 x ;
} ;

#define TAI_ZERO { 0 }
#define TAI_MAGIC ((uint64)4611686018427387914ULL)

#define tai_sec(t) ((t)->x)
#define tai_u64(t, u) ((void)((t)->x = (u)))
#define tai_unix(t, u) tai_u64(t, (TAI_MAGIC + (u)))
#define tai_uint(t, u) tai_u64(t, (uint64)(u))

extern int tai_relative_from_timeval (struct tai *, struct timeval const *) ;
extern int tai_from_timeval (struct tai *, struct timeval const *) ;
extern int timeval_from_tai_relative (struct timeval *, struct tai const *) ;
extern int timeval_from_tai (struct timeval *, struct tai const *) ;

extern void tai_now (struct tai *) ;

#define tai_approx(t) ((double)(tai_sec(t)))

extern void tai_add (struct tai *, struct tai const *, struct tai const *) ;
extern void tai_sub (struct tai *, struct tai const *, struct tai const *) ;
#define tai_less(t,u) (tai_sec(t) < tai_sec(u))

#define TAI_PACK 8
extern void tai_pack (char *, struct tai const *) ;
extern void tai_unpack (char const *, struct tai *) ;
extern void tai_pack_little (char *, struct tai const *) ;
extern void tai_unpack_little (char const *, struct tai *) ;

struct taia
{
  struct tai sec ;
  unsigned long nano ; /* 0...999999999 */
  unsigned long atto ; /* 0...999999999 */
} ;

#define TAIA_ZERO { TAI_ZERO, 0, 0 }

extern void taia_tai (struct taia const *, struct tai *) ;

#define taia_sec(a) ((a)->sec)
#define taia_secp(a) (&(a)->sec)
#define taia_nano(a) ((a)->nano)
#define taia_atto(a) ((a)->atto)

extern int taia_relative_from_timeval (struct taia *, struct timeval const *) ;
extern int taia_from_timeval (struct taia *, struct timeval const *) ;
extern int timeval_from_taia_relative (struct timeval *, struct taia const *) ;
extern int timeval_from_taia (struct timeval *, struct taia const *) ;

extern void taia_now (struct taia *) ;

extern double taia_approx (struct taia const *) gccattr_pure ;
extern double taia_frac (struct taia const *) gccattr_pure ;

extern void taia_add (struct taia *, struct taia const *, struct taia const *) ;
extern void taia_addsec (struct taia *, struct taia const *, int) ;
extern void taia_sub (struct taia *, struct taia const *, struct taia const *) ;
extern void taia_half (struct taia *, struct taia const *) ;
extern int taia_less (struct taia const *, struct taia const *) gccattr_pure ;

#define TAIA_PACK 16
extern void taia_pack (char *, struct taia const *) ;
extern void taia_unpack (char const *, struct taia *) ;
extern void taia_pack_little (char *, struct taia const *) ;
extern void taia_unpack_little (char const *, struct taia *) ;
extern unsigned int taia_fmt (char *, struct taia const *) ;
extern unsigned int taia_scan (char const *, struct taia *) ;

#define TAIN_PACK 12
extern void tain_pack (char *, struct taia const *) ;
extern void tain_unpack (char const *, struct taia *) ;
extern void tain_pack_little (char *, struct taia const *) ;
extern void tain_unpack_little (char const *, struct taia *) ;
extern unsigned int tain_fmt (char *, struct taia const *) ;
extern unsigned int tain_scan (char const *, struct taia *) ;

#define TAIA_FMTFRAC 19
extern unsigned int taia_fmtfrac (char *, struct taia const *) ;

extern void taia_uint (struct taia *, unsigned int) ;
extern void taia_ulong (struct taia *, unsigned long) ;

#define TIMESTAMP (1 + (TAIN_PACK << 1))
extern unsigned int timestamp_fmt (char *, struct taia const *) ;
extern unsigned int timestamp_scan (char const *, struct taia *) ;
extern void timestamp (char *) ;

#endif
