[![Build Status](https://travis-ci.org/smirarab/sepp.svg?branch=master)](https://travis-ci.org/smirarab/sepp) [![Coverage Status](https://coveralls.io/repos/github/smirarab/sepp/badge.svg?branch=master)](https://coveralls.io/github/smirarab/sepp?branch=master)
------------------------------------
Summary
------------------------------------
This repository includes code for SEPP, TIPP, UPP, HIPPI.  The three methods use ensembles of Hidden Markov Models (HMMs) in different ways, each focusing on a different problem.

Each of these related tools has its own README file.

[README.SEPP.md](README.SEPP.md)
* **SEPP** stands for "SATe-enabled Phylogenetic Placement", and addresses the problem of phylogenetic placement of short reads into reference alignments and trees.

[README.UPP.md](README.UPP.md)
* **UPP** stands for "Ultra-large alignments using Phylogeny-aware Profiles", and addresses the problem of alignment of very large datasets, potentially containing fragmentary data. UPP can align datasets with up to 1,000,000 sequences.

[README.HIPPI.md](README.HIPPI.md)
* **HIPPI** stands for "Highly Accurate Protein Family Classification with Ensembles of HMMs", and addresses the problem of classifying query sequences to protein families.

[README.TIPP.md](https://github.com/TeraTrees/TIPP/)
* **TIPP** stands for "Taxonomic Identification and Phylogenetic Profiling", and addresses the problem of taxonomic identification and abundance profiling of metagenomic data. We have moved TIPP as a separate package from SEPP. TIPP package can be accessed [here](https://github.com/TeraTrees/TIPP/).

---------------------------------------------
Bugs and Errors
---------------------------------------------
SEPP, TIPP, UPP, HIPPI are under active research development at UIUC by the Warnow Lab and former student Siavash Mirarab (now at UCSD). Please report any errors to Siavash Mirarab (smirarab@ucsd.edu).
