/*
 * Sentinella
 * http://sentinella.sourceforge.net/
 * Copyright (c) 2009-2011 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef ABSTRACTLOOPCONDITION_H_
#define ABSTRACTLOOPCONDITION_H_

#include "AbstractCondition.h"
#include "../common.h"

class AbstractLoopCondition : public AbstractCondition {

public:
	AbstractLoopCondition(const qint64 msecsLimit, const qint64 interval);
	void timerEvent(QTimerEvent *event) _HOT;

protected:
	virtual bool evaluate() = 0;
	qint64 interval;

private:
	qint64 msecsElapsed;
	qint64 msecsLimit;
};

#endif /* ABSTRACTLOOPCONDITION_H_ */
