static const byte kEoB1ChargenStartLevelsDOS[60] = {
	0x03, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x01,
	0x03, 0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x01,
	0x03, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x01,
	0x02, 0x02, 0x00, 0x02, 0x02, 0x03, 0x00, 0x02,
	0x02, 0x02, 0x00, 0x02, 0x01, 0x01, 0x02, 0x03,
	0x03, 0x02, 0x00, 0x02, 0x02, 0x03, 0x00, 0x02,
	0x01, 0x02, 0x01, 0x03, 0x02, 0x02, 0x00, 0x02,
	0x02, 0x02, 0x00, 0x02
};

static const ByteProvider kEoB1ChargenStartLevelsDOSProvider = { ARRAYSIZE(kEoB1ChargenStartLevelsDOS), kEoB1ChargenStartLevelsDOS };

static const byte kEoB1ChargenClassMinStatsDOS[90] = {
	0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00,
	0x0E, 0x0D, 0x0E, 0x00, 0x0C, 0x00, 0x0D, 0x00,
	0x09, 0x11, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x09, 0x00, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x00, 0x00, 0x09, 0x00, 0x00, 0x09, 0x00, 0x00,
	0x09, 0x09, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09,
	0x00, 0x09, 0x00, 0x00, 0x00, 0x09, 0x00, 0x09,
	0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x00, 0x00,
	0x09, 0x09, 0x09, 0x00, 0x00, 0x00, 0x0D, 0x00,
	0x0E, 0x0D, 0x0E, 0x00, 0x00, 0x09, 0x09, 0x00,
	0x00, 0x00
};

static const ByteProvider kEoB1ChargenClassMinStatsDOSProvider = { ARRAYSIZE(kEoB1ChargenClassMinStatsDOS), kEoB1ChargenClassMinStatsDOS };

static const byte kEoB1ChargenRaceMinStatsDOS[36] = {
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08,
	0x03, 0x07, 0x06, 0x08, 0x03, 0x04, 0x03, 0x06,
	0x06, 0x03, 0x08, 0x03, 0x03, 0x03, 0x0C, 0x02,
	0x06, 0x07, 0x02, 0x03, 0x08, 0x03, 0x07, 0x06,
	0x03, 0x08, 0x0A, 0x06
};

static const ByteProvider kEoB1ChargenRaceMinStatsDOSProvider = { ARRAYSIZE(kEoB1ChargenRaceMinStatsDOS), kEoB1ChargenRaceMinStatsDOS };

static const uint16 kEoB1ChargenRaceMaxStatsDOS[36] = {
	0x6412, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x6412, 0x0012,
	0x0012, 0x0013, 0x0011, 0x0012, 0x6412, 0x0012, 0x0012, 0x0012,
	0x0012, 0x0012, 0x6412, 0x0012, 0x0012, 0x0011, 0x0013, 0x0010,
	0x6412, 0x0013, 0x0011, 0x0012, 0x0012, 0x0012, 0x0011, 0x0012,
	0x0011, 0x0013, 0x0012, 0x0012
};

static const Uint16Provider kEoB1ChargenRaceMaxStatsDOSProvider = { ARRAYSIZE(kEoB1ChargenRaceMaxStatsDOS), kEoB1ChargenRaceMaxStatsDOS };

static const byte kEoB1SaveThrowTable1DOS[50] = {
	0x10, 0x0E, 0x0D, 0x0B, 0x0A, 0x08, 0x07, 0x05,
	0x04, 0x03, 0x12, 0x10, 0x0F, 0x0D, 0x0C, 0x0A,
	0x09, 0x07, 0x06, 0x05, 0x11, 0x0F, 0x0E, 0x0C,
	0x0B, 0x09, 0x08, 0x06, 0x05, 0x04, 0x14, 0x11,
	0x10, 0x0D, 0x0C, 0x09, 0x08, 0x05, 0x04, 0x04,
	0x13, 0x11, 0x10, 0x0E, 0x0D, 0x0B, 0x0A, 0x08,
	0x07, 0x06
};

static const ByteProvider kEoB1SaveThrowTable1DOSProvider = { ARRAYSIZE(kEoB1SaveThrowTable1DOS), kEoB1SaveThrowTable1DOS };

static const byte kEoB1SaveThrowTable2DOS[25] = {
	0x0E, 0x0D, 0x0B, 0x0A, 0x08, 0x0B, 0x09, 0x07,
	0x05, 0x03, 0x0D, 0x0B, 0x09, 0x07, 0x05, 0x0F,
	0x0D, 0x0B, 0x09, 0x07, 0x0C, 0x0A, 0x08, 0x06,
	0x04
};

static const ByteProvider kEoB1SaveThrowTable2DOSProvider = { ARRAYSIZE(kEoB1SaveThrowTable2DOS), kEoB1SaveThrowTable2DOS };

static const byte kEoB1SaveThrowTable3DOS[35] = {
	0x0A, 0x09, 0x07, 0x06, 0x05, 0x04, 0x02, 0x0E,
	0x0D, 0x0B, 0x0A, 0x09, 0x08, 0x06, 0x0D, 0x0C,
	0x0A, 0x09, 0x08, 0x07, 0x05, 0x10, 0x0F, 0x0D,
	0x0C, 0x0B, 0x0A, 0x08, 0x0F, 0x0E, 0x0C, 0x0B,
	0x0A, 0x09, 0x07
};

static const ByteProvider kEoB1SaveThrowTable3DOSProvider = { ARRAYSIZE(kEoB1SaveThrowTable3DOS), kEoB1SaveThrowTable3DOS };

static const byte kEoB1SaveThrowTable4DOS[30] = {
	0x0D, 0x0C, 0x0B, 0x0A, 0x09, 0x08, 0x0E, 0x0C,
	0x0A, 0x08, 0x06, 0x07, 0x0C, 0x0B, 0x0A, 0x09,
	0x08, 0x04, 0x10, 0x0F, 0x0E, 0x0D, 0x0C, 0x0B,
	0x0F, 0x0D, 0x0B, 0x09, 0x07, 0x05
};

static const ByteProvider kEoB1SaveThrowTable4DOSProvider = { ARRAYSIZE(kEoB1SaveThrowTable4DOS), kEoB1SaveThrowTable4DOS };

static const byte kEoB1SaveThrwLvlIndexDOS[6] = {
	0x11, 0x15, 0x13, 0x15, 0x11, 0x11
};

static const ByteProvider kEoB1SaveThrwLvlIndexDOSProvider = { ARRAYSIZE(kEoB1SaveThrwLvlIndexDOS), kEoB1SaveThrwLvlIndexDOS };

static const byte kEoB1SaveThrwModDivDOS[6] = {
	0x02, 0x05, 0x03, 0x04, 0x02, 0x02
};

static const ByteProvider kEoB1SaveThrwModDivDOSProvider = { ARRAYSIZE(kEoB1SaveThrwModDivDOS), kEoB1SaveThrwModDivDOS };

static const byte kEoB1SaveThrwModExtDOS[6] = {
	0x0A, 0x05, 0x07, 0x06, 0x0A, 0x0A
};

static const ByteProvider kEoB1SaveThrwModExtDOSProvider = { ARRAYSIZE(kEoB1SaveThrwModExtDOS), kEoB1SaveThrwModExtDOS };

static const char *const kEoB1IntroFilesOpeningDOS[6] = {
	"AND.CMP",
	"SSI.CMP",
	"PRESENT.CMP",
	"DAND.CMP",
	"WESTWOOD.CMP",
	"WESTWOOD.COL"
};

static const StringListProvider kEoB1IntroFilesOpeningDOSProvider = { ARRAYSIZE(kEoB1IntroFilesOpeningDOS), kEoB1IntroFilesOpeningDOS };

static const char *const kEoB1IntroFilesTowerDOS[2] = {
	"TOWRMAGE.COL",
	"TOWRMAGE.CMP"
};

static const StringListProvider kEoB1IntroFilesTowerDOSProvider = { ARRAYSIZE(kEoB1IntroFilesTowerDOS), kEoB1IntroFilesTowerDOS };

static const char *const kEoB1IntroFilesOrbDOS[2] = {
	"ORB.CMP",
	"TOWRMAGE.CMP"
};

static const StringListProvider kEoB1IntroFilesOrbDOSProvider = { ARRAYSIZE(kEoB1IntroFilesOrbDOS), kEoB1IntroFilesOrbDOS };

static const char *const kEoB1IntroFilesWdEntryDOS[4] = {
	"WTRDP2.COL",
	"WTRDP1.CMP",
	"WTRDP2.CMP",
	"WTRDP3.CMP"
};

static const StringListProvider kEoB1IntroFilesWdEntryDOSProvider = { ARRAYSIZE(kEoB1IntroFilesWdEntryDOS), kEoB1IntroFilesWdEntryDOS };

static const char *const kEoB1IntroFilesKingDOS[2] = {
	"KING.CMP",
	"ADVENTUR.CMP"
};

static const StringListProvider kEoB1IntroFilesKingDOSProvider = { ARRAYSIZE(kEoB1IntroFilesKingDOS), kEoB1IntroFilesKingDOS };

static const char *const kEoB1IntroFilesHandsDOS[1] = {
	"HANDS.CMP"
};

static const StringListProvider kEoB1IntroFilesHandsDOSProvider = { ARRAYSIZE(kEoB1IntroFilesHandsDOS), kEoB1IntroFilesHandsDOS };

static const char *const kEoB1IntroFilesWdExitDOS[5] = {
	"WTRDP3.CMP",
	"ORB.COL",
	"ORB.CMP",
	"TUNNEL.CMP",
	"ZOOMTUNL.COL"
};

static const StringListProvider kEoB1IntroFilesWdExitDOSProvider = { ARRAYSIZE(kEoB1IntroFilesWdExitDOS), kEoB1IntroFilesWdExitDOS };

static const char *const kEoB1IntroFilesTunnelDOS[2] = {
	"AVALANCH.CMP",
	"ZOOMTUNL.CMP"
};

static const StringListProvider kEoB1IntroFilesTunnelDOSProvider = { ARRAYSIZE(kEoB1IntroFilesTunnelDOS), kEoB1IntroFilesTunnelDOS };

static const byte kEoB1IntroOpeningFrmDelayDOS[5] = {
	0x8C, 0x32, 0x64, 0x32, 0x8C
};

static const ByteProvider kEoB1IntroOpeningFrmDelayDOSProvider = { ARRAYSIZE(kEoB1IntroOpeningFrmDelayDOS), kEoB1IntroOpeningFrmDelayDOS };

static const byte kEoB1IntroWdEncodeXDOS[31] = {
	0x00, 0x18, 0x02, 0x04, 0x1A, 0x05, 0x10, 0x06,
	0x10, 0x07, 0x11, 0x04, 0x13, 0x05, 0x06, 0x13,
	0x09, 0x14, 0x0B, 0x0D, 0x16, 0x0D, 0x16, 0x0E,
	0x1A, 0x0E, 0x17, 0x0F, 0x1B, 0x0F, 0x17
};

static const ByteProvider kEoB1IntroWdEncodeXDOSProvider = { ARRAYSIZE(kEoB1IntroWdEncodeXDOS), kEoB1IntroWdEncodeXDOS };

static const byte kEoB1IntroWdEncodeYDOS[31] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x01
};

static const ByteProvider kEoB1IntroWdEncodeYDOSProvider = { ARRAYSIZE(kEoB1IntroWdEncodeYDOS), kEoB1IntroWdEncodeYDOS };

static const byte kEoB1IntroWdEncodeWHDOS[31] = {
	0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x02, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01
};

static const ByteProvider kEoB1IntroWdEncodeWHDOSProvider = { ARRAYSIZE(kEoB1IntroWdEncodeWHDOS), kEoB1IntroWdEncodeWHDOS };

static const uint16 kEoB1IntroWdDsXDOS[31] = {
	0x0120, 0x0120, 0x0120, 0x0130, 0x0130, 0x00B2, 0x00B2, 0x00BC,
	0x00BC, 0x00AE, 0x00AE, 0x0125, 0x0125, 0x0125, 0x0101, 0x0101,
	0x00E9, 0x00E9, 0x00E9, 0x00AB, 0x00AB, 0x00CC, 0x00CC, 0x00F0,
	0x00F0, 0x010C, 0x010C, 0x00E0, 0x00E0, 0x00BA, 0x00BA
};

static const Uint16Provider kEoB1IntroWdDsXDOSProvider = { ARRAYSIZE(kEoB1IntroWdDsXDOS), kEoB1IntroWdDsXDOS };

static const byte kEoB1IntroWdDsYDOS[31] = {
	0x28, 0x28, 0x28, 0x38, 0x38, 0x26, 0x26, 0x1D,
	0x1D, 0x34, 0x34, 0x50, 0x50, 0x50, 0x50, 0x50,
	0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x2A, 0x2A, 0x66,
	0x66, 0x67, 0x67, 0x1C, 0x1C, 0x44, 0x44
};

static const ByteProvider kEoB1IntroWdDsYDOSProvider = { ARRAYSIZE(kEoB1IntroWdDsYDOS), kEoB1IntroWdDsYDOS };

static const byte kEoB1IntroTvlX1DOS[6] = {
	0x00, 0x08, 0x10, 0x00, 0x0F, 0x00
};

static const ByteProvider kEoB1IntroTvlX1DOSProvider = { ARRAYSIZE(kEoB1IntroTvlX1DOS), kEoB1IntroTvlX1DOS };

static const byte kEoB1IntroTvlY1DOS[6] = {
	0x00, 0x00, 0x00, 0x30, 0x36, 0x86
};

static const ByteProvider kEoB1IntroTvlY1DOSProvider = { ARRAYSIZE(kEoB1IntroTvlY1DOS), kEoB1IntroTvlY1DOS };

static const byte kEoB1IntroTvlX2DOS[6] = {
	0x10, 0x10, 0x0F, 0x0C, 0x0B, 0x0B
};

static const ByteProvider kEoB1IntroTvlX2DOSProvider = { ARRAYSIZE(kEoB1IntroTvlX2DOS), kEoB1IntroTvlX2DOS };

static const byte kEoB1IntroTvlY2DOS[6] = {
	0x35, 0x35, 0x35, 0x35, 0x35, 0x61
};

static const ByteProvider kEoB1IntroTvlY2DOSProvider = { ARRAYSIZE(kEoB1IntroTvlY2DOS), kEoB1IntroTvlY2DOS };

static const byte kEoB1IntroTvlWDOS[6] = {
	0x08, 0x08, 0x0B, 0x0F, 0x12, 0x12
};

static const ByteProvider kEoB1IntroTvlWDOSProvider = { ARRAYSIZE(kEoB1IntroTvlWDOS), kEoB1IntroTvlWDOS };

static const byte kEoB1IntroTvlHDOS[6] = {
	0x1A, 0x30, 0x36, 0x45, 0x50, 0x28
};

static const ByteProvider kEoB1IntroTvlHDOSProvider = { ARRAYSIZE(kEoB1IntroTvlHDOS), kEoB1IntroTvlHDOS };

static const byte kEoB1DoorShapeDefsDOS[96] = {
	0x00, 0x00, 0x0A, 0x48, 0x11, 0x98, 0x07, 0x2F,
	0x19, 0x48, 0x04, 0x1D, 0x0A, 0x00, 0x0A, 0x48,
	0x1D, 0x48, 0x07, 0x2F, 0x19, 0x68, 0x04, 0x1D,
	0x14, 0x00, 0x06, 0x48, 0x24, 0x48, 0x04, 0x2F,
	0x1E, 0x78, 0x03, 0x1D, 0x1A, 0x00, 0x0C, 0x48,
	0x00, 0x90, 0x07, 0x29, 0x21, 0x78, 0x04, 0x1B,
	0x00, 0xBC, 0x0A, 0x0C, 0x0A, 0xBC, 0x06, 0x08,
	0x0A, 0xC4, 0x04, 0x02, 0x07, 0x4A, 0x09, 0x37,
	0x00, 0x4A, 0x07, 0x25, 0x07, 0xA0, 0x05, 0x17,
	0x07, 0x82, 0x09, 0x1C, 0x00, 0x70, 0x07, 0x13,
	0x0C, 0xA0, 0x05, 0x0B, 0x10, 0x48, 0x09, 0x4B,
	0x18, 0x98, 0x07, 0x2E, 0x1F, 0x98, 0x04, 0x1D
};

static const ByteProvider kEoB1DoorShapeDefsDOSProvider = { ARRAYSIZE(kEoB1DoorShapeDefsDOS), kEoB1DoorShapeDefsDOS };

static const byte kEoB1DoorSwitchShapeDefsDOS[96] = {
	0x25, 0x78, 0x01, 0x07, 0x25, 0x88, 0x01, 0x03,
	0x25, 0x90, 0x01, 0x01, 0x25, 0x78, 0x01, 0x07,
	0x25, 0x88, 0x01, 0x03, 0x25, 0x90, 0x01, 0x01,
	0x26, 0x78, 0x01, 0x0B, 0x26, 0x88, 0x01, 0x06,
	0x26, 0x90, 0x01, 0x04, 0x27, 0x78, 0x01, 0x0E,
	0x27, 0x88, 0x01, 0x08, 0x25, 0x90, 0x01, 0x01,
	0x25, 0x78, 0x01, 0x07, 0x25, 0x88, 0x01, 0x03,
	0x25, 0x90, 0x01, 0x01, 0x25, 0x98, 0x01, 0x0B,
	0x25, 0xA8, 0x01, 0x06, 0x25, 0xB0, 0x01, 0x04,
	0x25, 0x98, 0x01, 0x0B, 0x25, 0xA8, 0x01, 0x05,
	0x25, 0xB0, 0x01, 0x04, 0x26, 0x98, 0x01, 0x0A,
	0x26, 0xA8, 0x01, 0x04, 0x25, 0x90, 0x01, 0x01
};

static const ByteProvider kEoB1DoorSwitchShapeDefsDOSProvider = { ARRAYSIZE(kEoB1DoorSwitchShapeDefsDOS), kEoB1DoorSwitchShapeDefsDOS };

static const byte kEoB1DoorSwitchCoordsDOS[48] = {
	0x82, 0x24, 0x74, 0x27, 0x00, 0x00, 0x82, 0x24,
	0x74, 0x27, 0x00, 0x00, 0x5B, 0x36, 0x5A, 0x33,
	0x5A, 0x2D, 0x88, 0x26, 0x74, 0x29, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x24,
	0x73, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x80, 0x2B, 0x74, 0x2B, 0x00, 0x00
};

static const ByteProvider kEoB1DoorSwitchCoordsDOSProvider = { ARRAYSIZE(kEoB1DoorSwitchCoordsDOS), kEoB1DoorSwitchCoordsDOS };

static const byte kEoB1MonsterPropertiesDOS[594] = {
	0x07, 0x12, 0xFF, 0x01, 0x01, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x02, 0x4B,
	0x02, 0xFF, 0x00, 0x07, 0x11, 0x02, 0x01, 0x01,
	0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0x78, 0x00,
	0x01, 0x38, 0x39, 0x00, 0xFF, 0x00, 0x05, 0x11,
	0x01, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x0C, 0x04, 0x00, 0x00,
	0x00, 0x41, 0x00, 0x00, 0x42, 0x43, 0x00, 0x02,
	0x00, 0x08, 0x0F, 0x02, 0x01, 0x01, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x49,
	0x4A, 0x00, 0x03, 0x00, 0x04, 0x10, 0x02, 0x02,
	0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0xAF,
	0x00, 0x02, 0x36, 0x37, 0x04, 0xFF, 0x14, 0x05,
	0x11, 0x03, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x03, 0x00,
	0x00, 0x00, 0x41, 0x00, 0x00, 0x2F, 0x30, 0x00,
	0xFF, 0x00, 0x06, 0x13, 0x02, 0x01, 0x01, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x12, 0x02, 0x00, 0x00, 0x00, 0x8A, 0x02, 0x02,
	0x31, 0x26, 0x00, 0xFF, 0x00, 0x03, 0x0C, 0x07,
	0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
	0xDA, 0x02, 0x00, 0x2D, 0x2E, 0x00, 0xFF, 0x00,
	0x05, 0x07, 0x0A, 0x01, 0x01, 0x08, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x04,
	0x00, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x40, 0x41,
	0x00, 0x07, 0x00, 0x04, 0x0F, 0x06, 0x02, 0x01,
	0x08, 0x00, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x03, 0x00, 0x00, 0x00, 0xCF, 0x03,
	0x01, 0x27, 0x28, 0x00, 0xFF, 0x00, 0x05, 0x0D,
	0x06, 0x03, 0x01, 0x08, 0x00, 0x01, 0x04, 0x00,
	0x01, 0x04, 0x00, 0x00, 0x28, 0x03, 0x00, 0x00,
	0x00, 0x78, 0x05, 0x02, 0x25, 0x24, 0x00, 0xFF,
	0x00, 0x04, 0x0D, 0x05, 0x02, 0x01, 0x04, 0x00,
	0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0xE2, 0x04, 0x00, 0x3E,
	0x3F, 0x00, 0xFF, 0x00, 0x04, 0x0F, 0x04, 0x01,
	0x01, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x8A,
	0x02, 0x00, 0x2B, 0x2C, 0x00, 0xFF, 0x3C, 0xFF,
	0x07, 0x0A, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00,
	0x00, 0x00, 0x10, 0x27, 0x02, 0x44, 0x45, 0x00,
	0xFF, 0x64, 0xFF, 0x07, 0x09, 0x01, 0x03, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x42, 0x03, 0x00, 0x00, 0x00, 0xD0, 0x07, 0x00,
	0x1F, 0xFF, 0x08, 0xFF, 0x00, 0x03, 0x0D, 0x07,
	0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x40, 0x02, 0x00, 0x00, 0x00,
	0x88, 0x13, 0x02, 0x29, 0x2A, 0x02, 0xFF, 0x3C,
	0x05, 0x0D, 0x07, 0x01, 0x01, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x02,
	0x00, 0x00, 0x00, 0x88, 0x13, 0x00, 0x34, 0x35,
	0x02, 0xFF, 0x00, 0x05, 0x0B, 0x08, 0x01, 0x05,
	0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x40, 0x1F,
	0x00, 0x3A, 0x3B, 0xFF, 0xFF, 0x5A, 0x02, 0x0F,
	0x05, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x82, 0x02, 0x00, 0x00,
	0x00, 0x0E, 0x01, 0x02, 0x3C, 0x3D, 0x00, 0xFF,
	0x00, 0xFE, 0x0D, 0x08, 0x01, 0x06, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x02, 0x00, 0x00, 0x00, 0xA0, 0x0F, 0x02, 0x48,
	0x47, 0x00, 0xFF, 0x32, 0x04, 0x0D, 0x07, 0x01,
	0x01, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x00, 0xCF,
	0x03, 0x01, 0x33, 0x32, 0x00, 0xFF, 0x28, 0x00,
	0x05, 0x23, 0x01, 0x01, 0x64, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00,
	0x00, 0x00, 0xB0, 0x36, 0x02, 0xFF, 0xFF, 0xFF,
	0xFF, 0x64
};

static const ByteProvider kEoB1MonsterPropertiesDOSProvider = { ARRAYSIZE(kEoB1MonsterPropertiesDOS), kEoB1MonsterPropertiesDOS };

static const byte kEoB1EnemyMageSpellListDOS[10] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x05,
	0x06, 0x00
};

static const ByteProvider kEoB1EnemyMageSpellListDOSProvider = { ARRAYSIZE(kEoB1EnemyMageSpellListDOS), kEoB1EnemyMageSpellListDOS };

static const byte kEoB1EnemyMageSfxDOS[10] = {
	0x00, 0x55, 0x55, 0x55, 0x55, 0x62, 0x62, 0x1F,
	0x62, 0x02
};

static const ByteProvider kEoB1EnemyMageSfxDOSProvider = { ARRAYSIZE(kEoB1EnemyMageSfxDOS), kEoB1EnemyMageSfxDOS };

static const byte kEoB1BeholderSpellListDOS[4] = {
	0x02, 0x0A, 0x0B, 0x62
};

static const ByteProvider kEoB1BeholderSpellListDOSProvider = { ARRAYSIZE(kEoB1BeholderSpellListDOS), kEoB1BeholderSpellListDOS };

static const byte kEoB1BeholderSfxDOS[4] = {
	0x62, 0x53, 0x40, 0x00
};

static const ByteProvider kEoB1BeholderSfxDOSProvider = { ARRAYSIZE(kEoB1BeholderSfxDOS), kEoB1BeholderSfxDOS };

static const byte kEoB1CgaMappingDefaultDOS[32] = {
	0x00, 0x02, 0x02, 0x01, 0x01, 0x00, 0x01, 0x02,
	0x03, 0x01, 0x01, 0x01, 0x00, 0x02, 0x02, 0x03,
	0x00, 0x02, 0x02, 0x01, 0x01, 0x00, 0x01, 0x02,
	0x03, 0x03, 0x01, 0x01, 0x00, 0x00, 0x02, 0x03
};

static const ByteProvider kEoB1CgaMappingDefaultDOSProvider = { ARRAYSIZE(kEoB1CgaMappingDefaultDOS), kEoB1CgaMappingDefaultDOS };

static const byte kEoB1CgaMappingAltDOS[32] = {
	0x00, 0x02, 0x03, 0x01, 0x01, 0x03, 0x02, 0x03,
	0x02, 0x01, 0x02, 0x00, 0x00, 0x02, 0x01, 0x03,
	0x00, 0x02, 0x01, 0x00, 0x01, 0x03, 0x02, 0x02,
	0x00, 0x03, 0x02, 0x00, 0x00, 0x02, 0x01, 0x03
};

static const ByteProvider kEoB1CgaMappingAltDOSProvider = { ARRAYSIZE(kEoB1CgaMappingAltDOS), kEoB1CgaMappingAltDOS };

static const byte kEoB1CgaMappingInvDOS[32] = {
	0x00, 0x02, 0x02, 0x01, 0x01, 0x00, 0x01, 0x02,
	0x03, 0x03, 0x01, 0x01, 0x00, 0x01, 0x02, 0x03,
	0x00, 0x02, 0x02, 0x01, 0x01, 0x00, 0x01, 0x02,
	0x03, 0x03, 0x01, 0x01, 0x00, 0x01, 0x02, 0x03
};

static const ByteProvider kEoB1CgaMappingInvDOSProvider = { ARRAYSIZE(kEoB1CgaMappingInvDOS), kEoB1CgaMappingInvDOS };

static const byte kEoB1CgaMappingItemsLDOS[32] = {
	0x00, 0x02, 0x02, 0x01, 0x01, 0x00, 0x01, 0x02,
	0x02, 0x01, 0x02, 0x01, 0x00, 0x02, 0x02, 0x03,
	0x00, 0x02, 0x02, 0x01, 0x01, 0x00, 0x01, 0x02,
	0x00, 0x03, 0x02, 0x01, 0x00, 0x00, 0x02, 0x03
};

static const ByteProvider kEoB1CgaMappingItemsLDOSProvider = { ARRAYSIZE(kEoB1CgaMappingItemsLDOS), kEoB1CgaMappingItemsLDOS };

static const byte kEoB1CgaMappingItemsSDOS[32] = {
	0x00, 0x02, 0x02, 0x01, 0x01, 0x03, 0x03, 0x02,
	0x03, 0x01, 0x01, 0x01, 0x00, 0x02, 0x01, 0x03,
	0x00, 0x02, 0x02, 0x01, 0x01, 0x03, 0x03, 0x02,
	0x03, 0x03, 0x01, 0x01, 0x00, 0x02, 0x01, 0x03
};

static const ByteProvider kEoB1CgaMappingItemsSDOSProvider = { ARRAYSIZE(kEoB1CgaMappingItemsSDOS), kEoB1CgaMappingItemsSDOS };

static const byte kEoB1CgaMappingThrownDOS[32] = {
	0x00, 0x02, 0x02, 0x01, 0x01, 0x03, 0x01, 0x02,
	0x02, 0x01, 0x01, 0x01, 0x00, 0x02, 0x02, 0x03,
	0x00, 0x02, 0x02, 0x01, 0x01, 0x03, 0x01, 0x02,
	0x02, 0x03, 0x01, 0x01, 0x00, 0x00, 0x02, 0x03
};

static const ByteProvider kEoB1CgaMappingThrownDOSProvider = { ARRAYSIZE(kEoB1CgaMappingThrownDOS), kEoB1CgaMappingThrownDOS };

static const byte kEoB1CgaMappingIconsDOS[32] = {
	0x00, 0x02, 0x02, 0x01, 0x03, 0x02, 0x03, 0x01,
	0x03, 0x01, 0x01, 0x01, 0x00, 0x02, 0x02, 0x03,
	0x00, 0x02, 0x02, 0x01, 0x03, 0x02, 0x03, 0x01,
	0x03, 0x03, 0x01, 0x01, 0x00, 0x02, 0x03, 0x03
};

static const ByteProvider kEoB1CgaMappingIconsDOSProvider = { ARRAYSIZE(kEoB1CgaMappingIconsDOS), kEoB1CgaMappingIconsDOS };

static const byte kEoB1CgaMappingDecoDOS[32] = {
	0x00, 0x00, 0x02, 0x00, 0x01, 0x03, 0x01, 0x02,
	0x02, 0x03, 0x02, 0x02, 0x00, 0x01, 0x03, 0x03,
	0x00, 0x01, 0x02, 0x03, 0x00, 0x03, 0x02, 0x02,
	0x00, 0x03, 0x02, 0x03, 0x00, 0x01, 0x03, 0x03
};

static const ByteProvider kEoB1CgaMappingDecoDOSProvider = { ARRAYSIZE(kEoB1CgaMappingDecoDOS), kEoB1CgaMappingDecoDOS };

static const byte kEoB1CgaLevelMappingIndexDOS[12] = {
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02,
	0x02, 0x03, 0x03, 0x04
};

static const ByteProvider kEoB1CgaLevelMappingIndexDOSProvider = { ARRAYSIZE(kEoB1CgaLevelMappingIndexDOS), kEoB1CgaLevelMappingIndexDOS };

static const byte kEoB1CgaMappingLevel0DOS[32] = {
	0x00, 0x00, 0x01, 0x01, 0x02, 0x00, 0x03, 0x03,
	0x02, 0x03, 0x02, 0x02, 0x00, 0x03, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x03, 0x03,
	0x02, 0x03, 0x02, 0x03, 0x00, 0x01, 0x02, 0x03
};

static const ByteProvider kEoB1CgaMappingLevel0DOSProvider = { ARRAYSIZE(kEoB1CgaMappingLevel0DOS), kEoB1CgaMappingLevel0DOS };

static const byte kEoB1CgaMappingLevel1DOS[32] = {
	0x00, 0x00, 0x01, 0x00, 0x01, 0x03, 0x01, 0x02,
	0x03, 0x01, 0x02, 0x00, 0x00, 0x02, 0x03, 0x03,
	0x00, 0x01, 0x01, 0x03, 0x00, 0x03, 0x01, 0x02,
	0x03, 0x01, 0x02, 0x01, 0x00, 0x02, 0x03, 0x03
};

static const ByteProvider kEoB1CgaMappingLevel1DOSProvider = { ARRAYSIZE(kEoB1CgaMappingLevel1DOS), kEoB1CgaMappingLevel1DOS };

static const byte kEoB1CgaMappingLevel2DOS[32] = {
	0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x00, 0x02, 0x03, 0x03,
	0x00, 0x01, 0x02, 0x03, 0x00, 0x01, 0x03, 0x02,
	0x02, 0x01, 0x02, 0x03, 0x00, 0x00, 0x02, 0x03
};

static const ByteProvider kEoB1CgaMappingLevel2DOSProvider = { ARRAYSIZE(kEoB1CgaMappingLevel2DOS), kEoB1CgaMappingLevel2DOS };

static const byte kEoB1CgaMappingLevel3DOS[32] = {
	0x00, 0x00, 0x01, 0x03, 0x03, 0x01, 0x01, 0x01,
	0x02, 0x03, 0x01, 0x01, 0x00, 0x02, 0x02, 0x03,
	0x00, 0x01, 0x01, 0x01, 0x03, 0x01, 0x02, 0x03,
	0x00, 0x03, 0x01, 0x01, 0x00, 0x02, 0x02, 0x03
};

static const ByteProvider kEoB1CgaMappingLevel3DOSProvider = { ARRAYSIZE(kEoB1CgaMappingLevel3DOS), kEoB1CgaMappingLevel3DOS };

static const byte kEoB1CgaMappingLevel4DOS[32] = {
	0x00, 0x02, 0x00, 0x00, 0x01, 0x01, 0x01, 0x03,
	0x02, 0x02, 0x02, 0x02, 0x00, 0x02, 0x01, 0x03,
	0x00, 0x02, 0x02, 0x03, 0x00, 0x01, 0x02, 0x03,
	0x02, 0x01, 0x02, 0x03, 0x00, 0x02, 0x01, 0x03
};

static const ByteProvider kEoB1CgaMappingLevel4DOSProvider = { ARRAYSIZE(kEoB1CgaMappingLevel4DOS), kEoB1CgaMappingLevel4DOS };

static const byte kEoB1NpcShpDataDOS[76] = {
	0x00, 0x00, 0x06, 0x40, 0x06, 0x00, 0x07, 0x48,
	0x0D, 0x00, 0x06, 0x30, 0x13, 0x00, 0x05, 0x38,
	0x18, 0x00, 0x05, 0x38, 0x1D, 0x00, 0x05, 0x38,
	0x22, 0x00, 0x06, 0x48, 0x00, 0x48, 0x06, 0x56,
	0x06, 0x48, 0x05, 0x40, 0x0B, 0x48, 0x05, 0x40,
	0x10, 0x48, 0x05, 0x30, 0x06, 0x88, 0x03, 0x18,
	0x09, 0x88, 0x03, 0x18, 0x0C, 0x88, 0x03, 0x18,
	0x0F, 0x88, 0x03, 0x18, 0x12, 0x88, 0x03, 0x18,
	0x15, 0x88, 0x03, 0x18, 0x18, 0x48, 0x06, 0x58,
	0x1E, 0x48, 0x0A, 0x48
};

static const ByteProvider kEoB1NpcShpDataDOSProvider = { ARRAYSIZE(kEoB1NpcShpDataDOS), kEoB1NpcShpDataDOS };

static const byte kEoB1NpcSubShpIndex1DOS[6] = {
	0x09, 0x08, 0x08, 0x09, 0x09, 0x0A
};

static const ByteProvider kEoB1NpcSubShpIndex1DOSProvider = { ARRAYSIZE(kEoB1NpcSubShpIndex1DOS), kEoB1NpcSubShpIndex1DOS };

static const byte kEoB1NpcSubShpIndex2DOS[6] = {
	0x0D, 0x0B, 0x0C, 0x0E, 0x0F, 0x10
};

static const ByteProvider kEoB1NpcSubShpIndex2DOSProvider = { ARRAYSIZE(kEoB1NpcSubShpIndex2DOS), kEoB1NpcSubShpIndex2DOS };

static const byte kEoB1NpcSubShpYDOS[6] = {
	0x34, 0x31, 0x31, 0x34, 0x34, 0x45
};

static const ByteProvider kEoB1NpcSubShpYDOSProvider = { ARRAYSIZE(kEoB1NpcSubShpYDOS), kEoB1NpcSubShpYDOS };

static const char *const kEoB1EnchantedStringDOS[1] = {
	"%s +%d"
};

static const StringListProvider kEoB1EnchantedStringDOSProvider = { ARRAYSIZE(kEoB1EnchantedStringDOS), kEoB1EnchantedStringDOS };

static const byte kEoB1SpellLevelsMageDOS[26] = {
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02,
	0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x05, 0x05,
	0x05, 0x00
};

static const ByteProvider kEoB1SpellLevelsMageDOSProvider = { ARRAYSIZE(kEoB1SpellLevelsMageDOS), kEoB1SpellLevelsMageDOS };

static const byte kEoB1SpellLevelsClericDOS[25] = {
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02,
	0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x01,
	0x00
};

static const ByteProvider kEoB1SpellLevelsClericDOSProvider = { ARRAYSIZE(kEoB1SpellLevelsClericDOS), kEoB1SpellLevelsClericDOS };

static const byte kEoB1NumSpellsClericDOS[50] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x03,
	0x02, 0x00, 0x00, 0x00, 0x03, 0x03, 0x01, 0x00,
	0x00, 0x03, 0x03, 0x02, 0x00, 0x00, 0x03, 0x03,
	0x02, 0x01, 0x00, 0x03, 0x03, 0x03, 0x02, 0x00,
	0x04, 0x04, 0x03, 0x02, 0x01, 0x04, 0x04, 0x03,
	0x03, 0x02
};

static const ByteProvider kEoB1NumSpellsClericDOSProvider = { ARRAYSIZE(kEoB1NumSpellsClericDOS), kEoB1NumSpellsClericDOS };

static const byte kEoB1NumSpellsWisAdjDOS[40] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x01, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00,
	0x00, 0x02, 0x02, 0x01, 0x00, 0x00, 0x02, 0x02,
	0x01, 0x01, 0x00, 0x03, 0x02, 0x01, 0x02, 0x00
};

static const ByteProvider kEoB1NumSpellsWisAdjDOSProvider = { ARRAYSIZE(kEoB1NumSpellsWisAdjDOS), kEoB1NumSpellsWisAdjDOS };

static const byte kEoB1NumSpellsPalDOS[60] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x02,
	0x02, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB1NumSpellsPalDOSProvider = { ARRAYSIZE(kEoB1NumSpellsPalDOS), kEoB1NumSpellsPalDOS };

static const byte kEoB1NumSpellsMageDOS[55] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x03,
	0x02, 0x00, 0x00, 0x00, 0x04, 0x02, 0x01, 0x00,
	0x00, 0x04, 0x02, 0x02, 0x00, 0x00, 0x04, 0x03,
	0x02, 0x01, 0x00, 0x04, 0x03, 0x03, 0x02, 0x00,
	0x04, 0x03, 0x03, 0x02, 0x01, 0x04, 0x04, 0x03,
	0x02, 0x02, 0x04, 0x04, 0x04, 0x03, 0x03
};

static const ByteProvider kEoB1NumSpellsMageDOSProvider = { ARRAYSIZE(kEoB1NumSpellsMageDOS), kEoB1NumSpellsMageDOS };

static const uint32 kEoB1ExperienceTable0DOS[12] = {
	0x00000000, 0x000007D0, 0x00000FA0, 0x00001F40, 0x00003E80, 0x00007D00, 0x0000FA00, 0x0001E848,
	0x0003D090, 0x0007A120, 0x000B71B0, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable0DOSProvider = { ARRAYSIZE(kEoB1ExperienceTable0DOS), kEoB1ExperienceTable0DOS };

static const uint32 kEoB1ExperienceTable1DOS[12] = {
	0x00000000, 0x000009C4, 0x00001388, 0x00002710, 0x00004E20, 0x00009C40, 0x0000EA60, 0x00015F90,
	0x00020F58, 0x0003D090, 0x0005B8D8, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable1DOSProvider = { ARRAYSIZE(kEoB1ExperienceTable1DOS), kEoB1ExperienceTable1DOS };

static const uint32 kEoB1ExperienceTable2DOS[11] = {
	0x00000000, 0x000005DC, 0x00000BB8, 0x00001770, 0x000032C8, 0x00006B6C, 0x0000D6D8, 0x0001ADB0,
	0x00036EE8, 0x0006DDD0, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable2DOSProvider = { ARRAYSIZE(kEoB1ExperienceTable2DOS), kEoB1ExperienceTable2DOS };

static const uint32 kEoB1ExperienceTable3DOS[12] = {
	0x00000000, 0x000004E2, 0x000009C4, 0x00001388, 0x00002710, 0x00004E20, 0x00009C40, 0x00011170,
	0x0001ADB0, 0x00027100, 0x00035B60, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable3DOSProvider = { ARRAYSIZE(kEoB1ExperienceTable3DOS), kEoB1ExperienceTable3DOS };

static const uint32 kEoB1ExperienceTable4DOS[12] = {
	0x00000000, 0x000008CA, 0x00001194, 0x00002328, 0x00004650, 0x00008CA0, 0x000124F8, 0x000249F0,
	0x000493E0, 0x000927C0, 0x000DBBA0, 0xFFFFFFFF
};

static const Uint32Provider kEoB1ExperienceTable4DOSProvider = { ARRAYSIZE(kEoB1ExperienceTable4DOS), kEoB1ExperienceTable4DOS };

static const byte kEoB1ExpObjectTblIndexDOS[9] = {
	0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x01,
	0x00
};

static const ByteProvider kEoB1ExpObjectTblIndexDOSProvider = { ARRAYSIZE(kEoB1ExpObjectTblIndexDOS), kEoB1ExpObjectTblIndexDOS };

static const byte kEoB1ExpObjectShpStartDOS[4] = {
	0x07, 0x0C, 0x0F, 0x12
};

static const ByteProvider kEoB1ExpObjectShpStartDOSProvider = { ARRAYSIZE(kEoB1ExpObjectShpStartDOS), kEoB1ExpObjectShpStartDOS };

static const byte kEoB1ExpObjectTbl1DOS[13] = {
	0x0F, 0x05, 0x0F, 0x05, 0x06, 0x05, 0x06, 0x08,
	0x06, 0x08, 0x06, 0x08, 0x00
};

static const ByteProvider kEoB1ExpObjectTbl1DOSProvider = { ARRAYSIZE(kEoB1ExpObjectTbl1DOS), kEoB1ExpObjectTbl1DOS };

static const byte kEoB1ExpObjectTbl2DOS[10] = {
	0x0F, 0x09, 0x0F, 0x09, 0x02, 0x0A, 0x0B, 0x0A,
	0x0B, 0x00
};

static const ByteProvider kEoB1ExpObjectTbl2DOSProvider = { ARRAYSIZE(kEoB1ExpObjectTbl2DOS), kEoB1ExpObjectTbl2DOS };

static const byte kEoB1ExpObjectTbl3DOS[11] = {
	0x05, 0x03, 0x05, 0x03, 0x03, 0x03, 0x03, 0x0B,
	0x03, 0x0B, 0x00
};

static const ByteProvider kEoB1ExpObjectTbl3DOSProvider = { ARRAYSIZE(kEoB1ExpObjectTbl3DOS), kEoB1ExpObjectTbl3DOS };

static const byte kEoB1ExpObjectYDOS[4] = {
	0x77, 0x67, 0x4F, 0x3F
};

static const ByteProvider kEoB1ExpObjectYDOSProvider = { ARRAYSIZE(kEoB1ExpObjectYDOS), kEoB1ExpObjectYDOS };

static const byte kEoB1SparkDefStepsDOS[8] = {
	0x40, 0x90, 0xE4, 0xB9, 0x6E, 0x1B, 0x06, 0x01
};

static const ByteProvider kEoB1SparkDefStepsDOSProvider = { ARRAYSIZE(kEoB1SparkDefStepsDOS), kEoB1SparkDefStepsDOS };

static const byte kEoB1SparkDefSubStepsDOS[4] = {
	0xC0, 0x30, 0x0C, 0x03
};

static const ByteProvider kEoB1SparkDefSubStepsDOSProvider = { ARRAYSIZE(kEoB1SparkDefSubStepsDOS), kEoB1SparkDefSubStepsDOS };

static const byte kEoB1SparkDefShiftDOS[4] = {
	0x06, 0x04, 0x02, 0x00
};

static const ByteProvider kEoB1SparkDefShiftDOSProvider = { ARRAYSIZE(kEoB1SparkDefShiftDOS), kEoB1SparkDefShiftDOS };

static const byte kEoB1SparkDefAddDOS[8] = {
	0x08, 0x06, 0x1C, 0x14, 0x0D, 0x18, 0x0D, 0x0F
};

static const ByteProvider kEoB1SparkDefAddDOSProvider = { ARRAYSIZE(kEoB1SparkDefAddDOS), kEoB1SparkDefAddDOS };

static const byte kEoB1SparkDefXDOS[6] = {
	0x17, 0x20, 0x17, 0x20, 0x17, 0x20
};

static const ByteProvider kEoB1SparkDefXDOSProvider = { ARRAYSIZE(kEoB1SparkDefXDOS), kEoB1SparkDefXDOS };

static const byte kEoB1SparkDefYDOS[6] = {
	0x02, 0x02, 0x34, 0x34, 0x66, 0x66
};

static const ByteProvider kEoB1SparkDefYDOSProvider = { ARRAYSIZE(kEoB1SparkDefYDOS), kEoB1SparkDefYDOS };

static const uint32 kEoB1SparkOfFlags1DOS[11] = {
	0x40000000, 0x95000000, 0xEA550000, 0xBFAA5400, 0x6AFFA954, 0x15AAFEA9, 0x0055ABFE, 0x000056AB,
	0x00000156, 0x00000001, 0x00000000
};

static const Uint32Provider kEoB1SparkOfFlags1DOSProvider = { ARRAYSIZE(kEoB1SparkOfFlags1DOS), kEoB1SparkOfFlags1DOS };

static const uint32 kEoB1SparkOfFlags2DOS[16] = {
	0xC0000000, 0x30000000, 0x0C000000, 0x03000000, 0x00C00000, 0x00300000, 0x000C0000, 0x00030000,
	0x0000C000, 0x00003000, 0x00000C00, 0x00000300, 0x000000C0, 0x00000030, 0x0000000C, 0x00000003
};

static const Uint32Provider kEoB1SparkOfFlags2DOSProvider = { ARRAYSIZE(kEoB1SparkOfFlags2DOS), kEoB1SparkOfFlags2DOS };

static const byte kEoB1SparkOfShiftDOS[16] = {
	0x1E, 0x1C, 0x1A, 0x18, 0x16, 0x14, 0x12, 0x10,
	0x0E, 0x0C, 0x0A, 0x08, 0x06, 0x04, 0x02, 0x00
};

static const ByteProvider kEoB1SparkOfShiftDOSProvider = { ARRAYSIZE(kEoB1SparkOfShiftDOS), kEoB1SparkOfShiftDOS };

static const byte kEoB1SparkOfXDOS[16] = {
	0x50, 0x70, 0x30, 0x68, 0x20, 0x60, 0x38, 0x78,
	0x80, 0x48, 0x58, 0x28, 0x60, 0x40, 0x70, 0x48
};

static const ByteProvider kEoB1SparkOfXDOSProvider = { ARRAYSIZE(kEoB1SparkOfXDOS), kEoB1SparkOfXDOS };

static const byte kEoB1SparkOfYDOS[16] = {
	0x31, 0x2B, 0x48, 0x17, 0x16, 0x48, 0x35, 0x1B,
	0x43, 0x2E, 0x24, 0x28, 0x38, 0x1C, 0x16, 0x44
};

static const ByteProvider kEoB1SparkOfYDOSProvider = { ARRAYSIZE(kEoB1SparkOfYDOS), kEoB1SparkOfYDOS };

static const byte kEoB1SpellPropertiesDOS[1007] = {
	0x4D, 0x2C, 0x2E, 0x21, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x4E, 0x2C, 0x2E, 0x21, 0x01,
	0x0B, 0x0F, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00,
	0x86, 0x0F, 0xF3, 0x0E, 0x5C, 0x00, 0x54, 0x2C,
	0x2E, 0x21, 0x00, 0x99, 0x0F, 0xF3, 0x0E, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57,
	0x01, 0x62, 0x2C, 0x2E, 0x21, 0x08, 0x69, 0x10,
	0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0xAE, 0x10,
	0xF3, 0x0E, 0x5F, 0x00, 0x6F, 0x2C, 0x2E, 0x21,
	0x00, 0xD2, 0x10, 0xF3, 0x0E, 0xF2, 0x10, 0xF3,
	0x0E, 0x00, 0x00, 0x00, 0x00, 0x55, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7D, 0x2C, 0x2E, 0x21, 0x04, 0x22,
	0x11, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x76,
	0x11, 0xF3, 0x0E, 0x5C, 0x00, 0x84, 0x2C, 0x2E,
	0x21, 0x02, 0x97, 0x11, 0xF3, 0x0E, 0x00, 0x00,
	0x00, 0x00, 0x33, 0x12, 0xF3, 0x0E, 0x58, 0x00,
	0x93, 0x2C, 0x2E, 0x21, 0x01, 0x7F, 0x12, 0xF3,
	0x0E, 0x00, 0x00, 0x00, 0x00, 0xA1, 0x12, 0xF3,
	0x0E, 0x5E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0x2C,
	0x2E, 0x21, 0x00, 0xC2, 0x12, 0xF3, 0x0E, 0xE3,
	0x12, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x60,
	0x01, 0xB2, 0x2C, 0x2E, 0x21, 0x00, 0x15, 0x13,
	0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0xC1, 0x2C, 0x2E, 0x21,
	0x01, 0x1A, 0x13, 0xF3, 0x0E, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x00, 0xCE,
	0x2C, 0x2E, 0x21, 0x00, 0xFD, 0x13, 0xF3, 0x0E,
	0x1E, 0x14, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00,
	0x62, 0x01, 0xD7, 0x2C, 0x2E, 0x21, 0x00, 0x4A,
	0x14, 0xF3, 0x0E, 0x6B, 0x14, 0xF3, 0x0E, 0x00,
	0x00, 0x00, 0x00, 0x63, 0x01, 0xE3, 0x2C, 0x2E,
	0x21, 0x08, 0x97, 0x14, 0xF3, 0x0E, 0x00, 0x00,
	0x00, 0x00, 0xF9, 0x14, 0xF3, 0x0E, 0x64, 0x00,
	0xE9, 0x2C, 0x2E, 0x21, 0x00, 0x0F, 0x15, 0xF3,
	0x0E, 0x30, 0x15, 0xF3, 0x0E, 0x00, 0x00, 0x00,
	0x00, 0x65, 0x01, 0xF5, 0x2C, 0x2E, 0x21, 0x08,
	0xD0, 0x15, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00,
	0xA1, 0x12, 0xF3, 0x0E, 0x5E, 0x00, 0x0D, 0x2D,
	0x2E, 0x21, 0x00, 0x09, 0x16, 0xF3, 0x0E, 0x2A,
	0x16, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x1F,
	0x01, 0x1C, 0x2D, 0x2E, 0x21, 0x02, 0x56, 0x16,
	0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0xDC, 0x16,
	0xF3, 0x0E, 0x66, 0x00, 0x2B, 0x2D, 0x2E, 0x21,
	0x00, 0x02, 0x17, 0xF3, 0x0E, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0x01, 0x30,
	0x2D, 0x2E, 0x21, 0x00, 0xB7, 0x17, 0xF3, 0x0E,
	0xD8, 0x17, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00,
	0x59, 0x01, 0x3A, 0x2D, 0x2E, 0x21, 0x01, 0x65,
	0x18, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x5D, 0x00, 0x44, 0x2D, 0x2E,
	0x21, 0x00, 0xD3, 0x18, 0xF3, 0x0E, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x4E, 0x2D, 0x2E, 0x21, 0x00, 0xD8, 0x18, 0xF3,
	0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x76, 0x01, 0x5B, 0x2D, 0x2E, 0x21, 0x00,
	0x0F, 0x1A, 0xF3, 0x0E, 0x30, 0x1A, 0xF3, 0x0E,
	0x00, 0x00, 0x00, 0x00, 0x65, 0x01, 0x68, 0x2D,
	0x2E, 0x21, 0x08, 0xD0, 0x1A, 0xF3, 0x0E, 0x00,
	0x00, 0x00, 0x00, 0x13, 0x1B, 0xF3, 0x0E, 0x5B,
	0x00, 0x6E, 0x2D, 0x2E, 0x21, 0x01, 0x20, 0x1B,
	0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x68, 0x00, 0x80, 0x2D, 0x2E, 0x21,
	0x00, 0x43, 0x1B, 0xF3, 0x0E, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x6B, 0x01, 0x93,
	0x2D, 0x2E, 0x21, 0x08, 0x69, 0x10, 0xF3, 0x0E,
	0x00, 0x00, 0x00, 0x00, 0xAE, 0x10, 0xF3, 0x0E,
	0x5F, 0x00, 0xA0, 0x2D, 0x2E, 0x21, 0x01, 0x5A,
	0x1B, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x8D,
	0x1B, 0xF3, 0x0E, 0x6E, 0x00, 0xB5, 0x2D, 0x2E,
	0x21, 0x01, 0xA3, 0x1B, 0xF3, 0x0E, 0x00, 0x00,
	0x00, 0x00, 0x45, 0x1C, 0xF3, 0x0E, 0x5B, 0x00,
	0xB9, 0x2D, 0x2E, 0x21, 0x02, 0x38, 0x1D, 0xF3,
	0x0E, 0x00, 0x00, 0x00, 0x00, 0x33, 0x12, 0xF3,
	0x0E, 0x63, 0x00, 0xC5, 0x2D, 0x2E, 0x21, 0x00,
	0x0F, 0x15, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x65, 0x01, 0xD1, 0x2D,
	0x2E, 0x21, 0x01, 0x75, 0x1C, 0xF3, 0x0E, 0x00,
	0x00, 0x00, 0x00, 0xD2, 0x1C, 0xF3, 0x0E, 0x6F,
	0x00, 0xDD, 0x2D, 0x2E, 0x21, 0x08, 0xC0, 0x1D,
	0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x70, 0x00, 0xE9, 0x2D, 0x2E, 0x21,
	0x01, 0x1A, 0x13, 0xF3, 0x0E, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x00, 0xF6,
	0x2D, 0x2E, 0x21, 0x04, 0xDF, 0x1D, 0xF3, 0x0E,
	0x00, 0x00, 0x00, 0x00, 0x1D, 0x1E, 0xF3, 0x0E,
	0x71, 0x00, 0x07, 0x2E, 0x2E, 0x21, 0x08, 0x3E,
	0x1E, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x6C,
	0x1E, 0xF3, 0x0E, 0x5B, 0x00, 0x0E, 0x2E, 0x2E,
	0x21, 0x08, 0x7E, 0x1E, 0xF3, 0x0E, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x72, 0x00,
	0x1F, 0x2E, 0x2E, 0x21, 0x01, 0xCC, 0x1E, 0xF3,
	0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x69, 0x00, 0x33, 0x2E, 0x2E, 0x21, 0x00,
	0xF3, 0x1E, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x6C, 0x01, 0x48, 0x2E,
	0x2E, 0x21, 0x01, 0x0B, 0x1F, 0xF3, 0x0E, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x73,
	0x00, 0x5A, 0x2E, 0x2E, 0x21, 0x08, 0x33, 0x1F,
	0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x8F, 0x1F,
	0xF3, 0x0E, 0x6E, 0x00, 0x7A, 0x2E, 0x2E, 0x21,
	0x04, 0xC8, 0x1F, 0xF3, 0x0E, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x94,
	0x2E, 0x2E, 0x21, 0x01, 0xD2, 0x1F, 0xF3, 0x0E,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6A, 0x00, 0xA9, 0x2E, 0x2E, 0x21, 0x00, 0xF9,
	0x1F, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x6C, 0x01, 0xBF, 0x2E, 0x2E,
	0x21, 0x00, 0x11, 0x20, 0xF3, 0x0E, 0x32, 0x20,
	0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x62, 0x01,
	0xCC, 0x2E, 0x2E, 0x21, 0x01, 0x50, 0x20, 0xF3,
	0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x75, 0x00, 0xD7, 0x2E, 0x2E, 0x21, 0x01,
	0xBC, 0x21, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0xE4, 0x2E,
	0x2E, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8A,
	0x20, 0xF3, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x75,
	0x00, 0xE5, 0x2E, 0x2E, 0x21, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xA8, 0x20, 0xF3, 0x0E, 0x00, 0x00,
	0x00, 0x00, 0x75, 0x00, 0xE6, 0x2E, 0x2E, 0x21,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x21, 0xF3,
	0x0E, 0x00, 0x00, 0x00, 0x00, 0x75, 0x00
};

static const ByteProvider kEoB1SpellPropertiesDOSProvider = { ARRAYSIZE(kEoB1SpellPropertiesDOS), kEoB1SpellPropertiesDOS };

static const byte kEoB1MagicFlightPropsDOS[96] = {
	0x04, 0xFF, 0x41, 0x09, 0x0A, 0xFF, 0x04, 0x05,
	0x0D, 0xFF, 0x7A, 0x06, 0x0E, 0xFF, 0x0C, 0x05,
	0x10, 0xFF, 0x4A, 0x0A, 0x12, 0x06, 0x38, 0x07,
	0x15, 0x06, 0x7A, 0x08, 0x19, 0xFF, 0x4A, 0x0A,
	0x2F, 0xFF, 0x4B, 0x06, 0x32, 0xFF, 0x09, 0x07,
	0x33, 0xFF, 0x09, 0x0A, 0x34, 0xFF, 0x09, 0x0A,
	0x01, 0x01, 0x00, 0x00, 0x03, 0xFD, 0x02, 0xFE,
	0x01, 0xFF, 0x00, 0x00, 0x98, 0x00, 0x18, 0x00,
	0x78, 0x00, 0x38, 0x00, 0x58, 0x00, 0x40, 0x40,
	0x38, 0x38, 0x38, 0x38, 0xE0, 0x20, 0x01, 0xFF,
	0x0F, 0x00, 0x09, 0x00, 0x0F, 0x00, 0x09, 0x00,
	0x02, 0x00, 0x0A, 0x00, 0x02, 0x00, 0x00, 0x00
};

static const ByteProvider kEoB1MagicFlightPropsDOSProvider = { ARRAYSIZE(kEoB1MagicFlightPropsDOS), kEoB1MagicFlightPropsDOS };

static const byte kEoB1TurnUndeadEffectDOS[140] = {
	0x0A, 0x07, 0x04, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0D, 0x0A,
	0x07, 0x04, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0x10, 0x0D, 0x0A, 0x07,
	0x04, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0x13, 0x10, 0x0D, 0x0A, 0x07, 0x04,
	0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x14, 0x13, 0x10, 0x0D, 0x0A, 0x07, 0x04, 0x00,
	0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x63, 0x14,
	0x13, 0x10, 0x0D, 0x0A, 0x07, 0x04, 0x00, 0x00,
	0x00, 0xFF, 0xFF, 0x00, 0x63, 0x63, 0x14, 0x13,
	0x10, 0x0D, 0x0A, 0x07, 0x04, 0x00, 0x00, 0x00,
	0x00, 0xFF, 0x63, 0x63, 0x63, 0x14, 0x13, 0x10,
	0x0D, 0x0A, 0x07, 0x04, 0x04, 0x00, 0x00, 0x00,
	0x63, 0x63, 0x63, 0x63, 0x14, 0x13, 0x10, 0x0D,
	0x0A, 0x07, 0x07, 0x04, 0x04, 0x00, 0x63, 0x63,
	0x63, 0x63, 0x63, 0x14, 0x13, 0x10, 0x0D, 0x0A,
	0x0A, 0x07, 0x07, 0x04
};

static const ByteProvider kEoB1TurnUndeadEffectDOSProvider = { ARRAYSIZE(kEoB1TurnUndeadEffectDOS), kEoB1TurnUndeadEffectDOS };

static const byte kEoB1BurningHandsDestDOS[8] = {
	0x02, 0x03, 0x00, 0x02, 0x00, 0x01, 0x01, 0x03
};

static const ByteProvider kEoB1BurningHandsDestDOSProvider = { ARRAYSIZE(kEoB1BurningHandsDestDOS), kEoB1BurningHandsDestDOS };

static const byte kEoB1ConeOfColdDest1DOS[7] = {
	0xE0, 0xC0, 0xC1, 0xBF, 0xA0, 0x9F, 0xA1
};

static const ByteProvider kEoB1ConeOfColdDest1DOSProvider = { ARRAYSIZE(kEoB1ConeOfColdDest1DOS), kEoB1ConeOfColdDest1DOS };

static const byte kEoB1ConeOfColdDest2DOS[7] = {
	0x01, 0x02, 0xE2, 0x22, 0x03, 0xE3, 0x23
};

static const ByteProvider kEoB1ConeOfColdDest2DOSProvider = { ARRAYSIZE(kEoB1ConeOfColdDest2DOS), kEoB1ConeOfColdDest2DOS };

static const byte kEoB1ConeOfColdDest3DOS[7] = {
	0x20, 0x40, 0x3F, 0x41, 0x60, 0x5F, 0x61
};

static const ByteProvider kEoB1ConeOfColdDest3DOSProvider = { ARRAYSIZE(kEoB1ConeOfColdDest3DOS), kEoB1ConeOfColdDest3DOS };

static const byte kEoB1ConeOfColdDest4DOS[7] = {
	0xFF, 0xFE, 0x1E, 0xDE, 0xFD, 0x1D, 0xDD
};

static const ByteProvider kEoB1ConeOfColdDest4DOSProvider = { ARRAYSIZE(kEoB1ConeOfColdDest4DOS), kEoB1ConeOfColdDest4DOS };

static const byte kEoB1ConeOfColdGfxTblDOS[8] = {
	0x0F, 0x09, 0x0F, 0x09, 0x02, 0x0A, 0x02, 0x00
};

static const ByteProvider kEoB1ConeOfColdGfxTblDOSProvider = { ARRAYSIZE(kEoB1ConeOfColdGfxTblDOS), kEoB1ConeOfColdGfxTblDOS };

static const byte kEoB1DscDoorShapeIndexDOS[32] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03
};

static const ByteProvider kEoB1DscDoorShapeIndexDOSProvider = { ARRAYSIZE(kEoB1DscDoorShapeIndexDOS), kEoB1DscDoorShapeIndexDOS };

static const byte kEoB1WllFlagPresetDOS[25] = {
	0x07, 0x00, 0x40, 0xA8, 0x88, 0x88, 0x88, 0x9F,
	0xA8, 0x88, 0x88, 0x88, 0x9F, 0xAA, 0x8A, 0x8A,
	0x8A, 0x9F, 0xAA, 0x8A, 0x8A, 0x8A, 0x9F, 0x03,
	0x03
};

static const ByteProvider kEoB1WllFlagPresetDOSProvider = { ARRAYSIZE(kEoB1WllFlagPresetDOS), kEoB1WllFlagPresetDOS };

static const uint16 kEoB1DscShapeCoordsDOS[180] = {
	0xFF91, 0xFFC1, 0xFFA1, 0xFFC1, 0xFF75, 0xFFC5, 0xFF8B, 0xFFC5,
	0xFF88, 0xFFC3, 0xFFB4, 0xFFC1, 0xFFC4, 0xFFC1, 0xFFA1, 0xFFC5,
	0xFFB6, 0xFFC5, 0xFFB0, 0xFFC3, 0xFFD5, 0xFFC1, 0xFFE5, 0xFFC1,
	0xFFCB, 0xFFC5, 0xFFE1, 0xFFC5, 0xFFD8, 0xFFC3, 0xFFF8, 0xFFC1,
	0x0008, 0xFFC1, 0xFFF6, 0xFFC5, 0x000A, 0xFFC5, 0x0000, 0xFFC3,
	0x001B, 0xFFC1, 0x002B, 0xFFC1, 0x001F, 0xFFC5, 0x0035, 0xFFC5,
	0x0028, 0xFFC3, 0x003C, 0xFFC1, 0x004C, 0xFFC1, 0x004A, 0xFFC5,
	0x005F, 0xFFC5, 0x0050, 0xFFC3, 0x005F, 0xFFC1, 0x006F, 0xFFC1,
	0x0075, 0xFFC5, 0x008B, 0xFFC5, 0x0078, 0xFFC3, 0xFF8A, 0xFFCB,
	0xFFA4, 0xFFCB, 0xFF68, 0xFFD3, 0xFF88, 0xFFD3, 0xFF8A, 0xFFCE,
	0xFFBE, 0xFFCB, 0xFFD8, 0xFFCB, 0xFFAC, 0xFFD3, 0xFFCD, 0xFFD3,
	0xFFC5, 0xFFCE, 0xFFF3, 0xFFCB, 0x000D, 0xFFCB, 0xFFF0, 0xFFD3,
	0x0010, 0xFFD3, 0x0000, 0xFFCE, 0x0028, 0xFFCB, 0x0042, 0xFFCB,
	0x0033, 0xFFD3, 0x0054, 0xFFD3, 0x003B, 0xFFCE, 0x005C, 0xFFCB,
	0x0076, 0xFFCB, 0x0078, 0xFFD3, 0x0098, 0xFFD3, 0x0076, 0xFFCE,
	0xFF92, 0xFFDD, 0xFFBD, 0xFFDD, 0xFF74, 0xFFEA, 0xFFAD, 0xFFEA,
	0xFF9E, 0xFFE2, 0xFFEA, 0xFFDD, 0x0016, 0xFFDD, 0xFFE5, 0xFFEA,
	0x001B, 0xFFEA, 0x0000, 0xFFE2, 0x0043, 0xFFDD, 0x006E, 0xFFDD,
	0x0053, 0xFFEA, 0x008C, 0xFFEA, 0x0062, 0xFFE2, 0xFF80, 0xFFFC,
	0x0080, 0xFFFC, 0xFF80, 0xFFBE, 0x0080, 0xFFBE, 0x0080, 0x0000,
	0xFFDA, 0xFFFC, 0x0026, 0xFFFC, 0xFFDA, 0xFFBE, 0x0026, 0xFFBE,
	0x0000, 0x0000, 0xFF80, 0xFFFC, 0x0080, 0xFFFC, 0xFF80, 0xFFBE,
	0x0080, 0xFFBE, 0x0080, 0x0000
};

static const Uint16Provider kEoB1DscShapeCoordsDOSProvider = { ARRAYSIZE(kEoB1DscShapeCoordsDOS), kEoB1DscShapeCoordsDOS };

static const byte kEoB1DscDoorScaleOffsDOS[32] = {
	0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x0D, 0x0D, 0x0D,
	0x0D, 0x0D, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x1F
};

static const ByteProvider kEoB1DscDoorScaleOffsDOSProvider = { ARRAYSIZE(kEoB1DscDoorScaleOffsDOS), kEoB1DscDoorScaleOffsDOS };

static const byte kEoB1DscDoorScaleMult1DOS[4] = {
	0x08, 0x0C, 0x12, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult1DOSProvider = { ARRAYSIZE(kEoB1DscDoorScaleMult1DOS), kEoB1DscDoorScaleMult1DOS };

static const byte kEoB1DscDoorScaleMult2DOS[4] = {
	0x00, 0x02, 0x04, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult2DOSProvider = { ARRAYSIZE(kEoB1DscDoorScaleMult2DOS), kEoB1DscDoorScaleMult2DOS };

static const byte kEoB1DscDoorScaleMult3DOS[4] = {
	0x04, 0x06, 0x09, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult3DOSProvider = { ARRAYSIZE(kEoB1DscDoorScaleMult3DOS), kEoB1DscDoorScaleMult3DOS };

static const byte kEoB1DscDoorScaleMult4DOS[4] = {
	0x00, 0x02, 0x04, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult4DOSProvider = { ARRAYSIZE(kEoB1DscDoorScaleMult4DOS), kEoB1DscDoorScaleMult4DOS };

static const byte kEoB1DscDoorScaleMult5DOS[4] = {
	0x07, 0x0B, 0x0E, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult5DOSProvider = { ARRAYSIZE(kEoB1DscDoorScaleMult5DOS), kEoB1DscDoorScaleMult5DOS };

static const byte kEoB1DscDoorScaleMult6DOS[4] = {
	0x00, 0x02, 0x04, 0x00
};

static const ByteProvider kEoB1DscDoorScaleMult6DOSProvider = { ARRAYSIZE(kEoB1DscDoorScaleMult6DOS), kEoB1DscDoorScaleMult6DOS };

static const byte kEoB1DscDoorXEDOS[32] = {
	0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x0D, 0x0D, 0x0D,
	0x0D, 0x0D, 0x12, 0x12, 0x12, 0x12, 0x12, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x1F
};

static const ByteProvider kEoB1DscDoorXEDOSProvider = { ARRAYSIZE(kEoB1DscDoorXEDOS), kEoB1DscDoorXEDOS };

static const byte kEoB1DscDoorY1DOS[4] = {
	0x3A, 0x47, 0x56, 0x00
};

static const ByteProvider kEoB1DscDoorY1DOSProvider = { ARRAYSIZE(kEoB1DscDoorY1DOS), kEoB1DscDoorY1DOS };

static const byte kEoB1DscDoorY3DOS[4] = {
	0x20, 0x20, 0x18, 0x00
};

static const ByteProvider kEoB1DscDoorY3DOSProvider = { ARRAYSIZE(kEoB1DscDoorY3DOS), kEoB1DscDoorY3DOS };

static const byte kEoB1DscDoorY4DOS[4] = {
	0x1E, 0x18, 0x10, 0x30
};

static const ByteProvider kEoB1DscDoorY4DOSProvider = { ARRAYSIZE(kEoB1DscDoorY4DOS), kEoB1DscDoorY4DOS };

static const byte kEoB1DscDoorY5DOS[4] = {
	0x30, 0x34, 0x3B, 0x3A
};

static const ByteProvider kEoB1DscDoorY5DOSProvider = { ARRAYSIZE(kEoB1DscDoorY5DOS), kEoB1DscDoorY5DOS };

static const byte kEoB1DscDoorY6DOS[4] = {
	0x3A, 0x45, 0x5A, 0x00
};

static const ByteProvider kEoB1DscDoorY6DOSProvider = { ARRAYSIZE(kEoB1DscDoorY6DOS), kEoB1DscDoorY6DOS };

static const byte kEoB1DscDoorY7DOS[4] = {
	0x3B, 0x47, 0x58, 0x00
};

static const ByteProvider kEoB1DscDoorY7DOSProvider = { ARRAYSIZE(kEoB1DscDoorY7DOS), kEoB1DscDoorY7DOS };

static const uint16 kEoB1DscDoorCoordsExtDOS[36] = {
	0x0000, 0x0000, 0xFFE8, 0x0010, 0x0020, 0x0040, 0x0048, 0x0068,
	0x0070, 0x0090, 0x00A0, 0x00C8, 0x0000, 0x0000, 0x0000, 0x0000,
	0xFFE8, 0x0030, 0x0038, 0x0078, 0x0080, 0x00C8, 0x0000, 0x0000,
	0xFFA8, 0x0020, 0x0028, 0x0088, 0x0090, 0x0108, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0000
};

static const Uint16Provider kEoB1DscDoorCoordsExtDOSProvider = { ARRAYSIZE(kEoB1DscDoorCoordsExtDOS), kEoB1DscDoorCoordsExtDOS };

static const byte kEoB1DscDoorFrameY1DOS[32] = {
	0x20, 0x18, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x20, 0x18, 0x00, 0x1E, 0x18, 0x10, 0x00,
	0x3A, 0x48, 0x60, 0x78, 0x3A, 0x46, 0x56, 0x00,
	0x78, 0x78, 0x78, 0x78, 0x1F, 0x18, 0x0F, 0x00
};

static const ByteProvider kEoB1DscDoorFrameY1DOSProvider = { ARRAYSIZE(kEoB1DscDoorFrameY1DOS), kEoB1DscDoorFrameY1DOS };

static const byte kEoB1DscDoorFrameY2DOS[32] = {
	0x20, 0x18, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x20, 0x18, 0x00, 0x1E, 0x18, 0x10, 0x00,
	0x3A, 0x48, 0x60, 0x78, 0x3A, 0x46, 0x56, 0x00,
	0x78, 0x78, 0x78, 0x78, 0x1F, 0x18, 0x0F, 0x00
};

static const ByteProvider kEoB1DscDoorFrameY2DOSProvider = { ARRAYSIZE(kEoB1DscDoorFrameY2DOS), kEoB1DscDoorFrameY2DOS };

static const byte kEoB1DscDoorFrameIndex1DOS[12] = {
	0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x08, 0x08,
	0x08, 0x0C, 0x0C, 0x1C
};

static const ByteProvider kEoB1DscDoorFrameIndex1DOSProvider = { ARRAYSIZE(kEoB1DscDoorFrameIndex1DOS), kEoB1DscDoorFrameIndex1DOS };

static const byte kEoB1DscDoorFrameIndex2DOS[12] = {
	0x10, 0x10, 0x10, 0x18, 0x18, 0x18, 0x10, 0x10,
	0x10, 0x14, 0x14, 0x18
};

static const ByteProvider kEoB1DscDoorFrameIndex2DOSProvider = { ARRAYSIZE(kEoB1DscDoorFrameIndex2DOS), kEoB1DscDoorFrameIndex2DOS };

static const byte kEoB1DscItemPosIndexDOS[16] = {
	0x00, 0x01, 0x02, 0x03, 0x02, 0x00, 0x03, 0x01,
	0x03, 0x02, 0x01, 0x00, 0x01, 0x03, 0x00, 0x02
};

static const ByteProvider kEoB1DscItemPosIndexDOSProvider = { ARRAYSIZE(kEoB1DscItemPosIndexDOS), kEoB1DscItemPosIndexDOS };

static const uint16 kEoB1DscItemShpXDOS[18] = {
	0xFFC8, 0xFFF8, 0x0028, 0x0058, 0x0088, 0x00B8, 0x00E8, 0xFFB8,
	0x0008, 0x0058, 0x00A8, 0x00F8, 0xFFD8, 0x0058, 0x00D8, 0xFFA8,
	0x0058, 0x0108
};

static const Uint16Provider kEoB1DscItemShpXDOSProvider = { ARRAYSIZE(kEoB1DscItemShpXDOS), kEoB1DscItemShpXDOS };

static const byte kEoB1DscItemScaleIndexDOS[18] = {
	0xFF, 0xFF, 0x03, 0x03, 0x02, 0x02, 0x02, 0x02,
	0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0xFF, 0xFF,
	0x25, 0x00
};

static const ByteProvider kEoB1DscItemScaleIndexDOSProvider = { ARRAYSIZE(kEoB1DscItemScaleIndexDOS), kEoB1DscItemScaleIndexDOS };

static const byte kEoB1DscItemTileIndexDOS[18] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0x09, 0xFF, 0x0B,
	0x0C, 0x0D
};

static const ByteProvider kEoB1DscItemTileIndexDOSProvider = { ARRAYSIZE(kEoB1DscItemTileIndexDOS), kEoB1DscItemTileIndexDOS };

static const byte kEoB1DscItemShapeMapDOS[90] = {
	0x00, 0x00, 0x00, 0x04, 0x01, 0x02, 0x03, 0x04,
	0x05, 0x06, 0x07, 0x07, 0x12, 0x06, 0x0F, 0x12,
	0x14, 0x17, 0x13, 0x11, 0x15, 0x0D, 0x09, 0x09,
	0x16, 0x1F, 0x0C, 0x23, 0x0C, 0x0C, 0x0C, 0x0B,
	0x0A, 0x1C, 0x1C, 0x1A, 0x1B, 0x21, 0x1D, 0x1D,
	0x22, 0x22, 0x22, 0x00, 0x08, 0x00, 0x25, 0x18,
	0x16, 0x17, 0x16, 0x17, 0x16, 0x17, 0x19, 0x23,
	0x10, 0x1E, 0x24, 0x18, 0x1C, 0x20, 0x12, 0x21,
	0x1E, 0x23, 0x1C, 0x00, 0x20, 0x11, 0x11, 0x0D,
	0x1F, 0x09, 0x09, 0x15, 0x15, 0x0F, 0x05, 0x0C,
	0x1E, 0x1E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1B,
	0x1B, 0x00
};

static const ByteProvider kEoB1DscItemShapeMapDOSProvider = { ARRAYSIZE(kEoB1DscItemShapeMapDOS), kEoB1DscItemShapeMapDOS };

static const byte kEoB1DscTelptrShpCoordsDOS[156] = {
	0x0C, 0x07, 0x1A, 0x01, 0x3E, 0x03, 0x0C, 0x1A,
	0x2A, 0x13, 0x40, 0x18, 0x02, 0x2D, 0x16, 0x25,
	0x28, 0x32, 0x36, 0x27, 0x0A, 0x3E, 0x16, 0x49,
	0x3E, 0x44, 0x06, 0x06, 0x2A, 0x04, 0x37, 0x0A,
	0x04, 0x1B, 0x1A, 0x16, 0x37, 0x1D, 0x0E, 0x2A,
	0x1B, 0x35, 0x2E, 0x28, 0x42, 0x30, 0x06, 0x47,
	0x06, 0x47, 0x2D, 0x4C, 0x0A, 0x04, 0x14, 0x00,
	0x2E, 0x01, 0x0C, 0x10, 0x1F, 0x10, 0x2F, 0x10,
	0x12, 0x18, 0x28, 0x1D, 0x01, 0x21, 0x08, 0x2A,
	0x11, 0x32, 0x2F, 0x2E, 0x1F, 0x25, 0x02, 0x02,
	0x01, 0x11, 0x01, 0x2F, 0x08, 0x1E, 0x11, 0x0E,
	0x11, 0x26, 0x1C, 0x01, 0x1E, 0x19, 0x1F, 0x33,
	0x24, 0x11, 0x26, 0x05, 0x28, 0x2B, 0x2F, 0x22,
	0x00, 0x13, 0x05, 0x01, 0x06, 0x08, 0x09, 0x0C,
	0x04, 0x1A, 0x08, 0x1F, 0x12, 0x05, 0x12, 0x15,
	0x16, 0x10, 0x1A, 0x08, 0x1A, 0x1D, 0x0A, 0x00,
	0x0A, 0x00, 0x00, 0x09, 0x00, 0x1E, 0x04, 0x11,
	0x08, 0x16, 0x08, 0x06, 0x10, 0x00, 0x11, 0x0D,
	0x12, 0x20, 0x15, 0x02, 0x14, 0x09, 0x16, 0x1B,
	0x1A, 0x14, 0x1A, 0x14
};

static const ByteProvider kEoB1DscTelptrShpCoordsDOSProvider = { ARRAYSIZE(kEoB1DscTelptrShpCoordsDOS), kEoB1DscTelptrShpCoordsDOS };

static const byte kEoB1PortalSeqDataDOS[126] = {
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,
	0x02, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00,
	0x04, 0x00, 0x03, 0x00, 0x02, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x04,
	0x00, 0x01, 0x01, 0x00, 0x02, 0x01, 0x03, 0x02,
	0x02, 0x03, 0x01, 0x04, 0x00, 0x02, 0x01, 0x03,
	0x02, 0x04, 0x03, 0x02, 0x04, 0x03, 0x03, 0x04,
	0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x05, 0x04, 0x06, 0x03, 0x07,
	0x02, 0x08, 0x02, 0x08, 0x01, 0x09, 0x01, 0x09,
	0x01, 0x09, 0x00, 0x0A, 0xFF, 0xFF
};

static const ByteProvider kEoB1PortalSeqDataDOSProvider = { ARRAYSIZE(kEoB1PortalSeqDataDOS), kEoB1PortalSeqDataDOS };

static const byte kEoB1DscMonsterFrmOffsTbl1DOS[32] = {
	0x04, 0xFE, 0x01, 0x03, 0x03, 0x04, 0xFE, 0x01,
	0x01, 0x03, 0x04, 0xFE, 0xFE, 0x01, 0x03, 0x04,
	0xFC, 0xFD, 0xFF, 0x02, 0x02, 0xFC, 0xFD, 0xFF,
	0xFF, 0x02, 0xFC, 0xFD, 0xFD, 0xFF, 0x02, 0xFC
};

static const ByteProvider kEoB1DscMonsterFrmOffsTbl1DOSProvider = { ARRAYSIZE(kEoB1DscMonsterFrmOffsTbl1DOS), kEoB1DscMonsterFrmOffsTbl1DOS };

static const byte kEoB1DscMonsterFrmOffsTbl2DOS[32] = {
	0x04, 0xFE, 0x01, 0x03, 0x03, 0x04, 0xFE, 0x01,
	0x01, 0x03, 0x04, 0xFE, 0xFE, 0x01, 0x03, 0x04,
	0x04, 0xFD, 0x01, 0x02, 0x02, 0x04, 0xFD, 0x01,
	0x01, 0x02, 0x04, 0xFD, 0xFD, 0x01, 0x02, 0x04
};

static const ByteProvider kEoB1DscMonsterFrmOffsTbl2DOSProvider = { ARRAYSIZE(kEoB1DscMonsterFrmOffsTbl2DOS), kEoB1DscMonsterFrmOffsTbl2DOS };

static const uint16 kEoB1InvSlotXDOS[27] = {
	0x00E6, 0x0116, 0x00B5, 0x00C7, 0x00B5, 0x00C7, 0x00B5, 0x00C7,
	0x00B5, 0x00C7, 0x00B5, 0x00C7, 0x00B5, 0x00C7, 0x00B5, 0x00C7,
	0x00E1, 0x00E0, 0x00E1, 0x012A, 0x011F, 0x0115, 0x012C, 0x012C,
	0x012C, 0x00E4, 0x00F0
};

static const Uint16Provider kEoB1InvSlotXDOSProvider = { ARRAYSIZE(kEoB1InvSlotXDOS), kEoB1InvSlotXDOS };

static const byte kEoB1InvSlotYDOS[27] = {
	0x74, 0x74, 0x28, 0x28, 0x3A, 0x3A, 0x4C, 0x4C,
	0x5E, 0x5E, 0x70, 0x70, 0x82, 0x82, 0x94, 0x94,
	0x38, 0x4C, 0x60, 0x37, 0x4B, 0x89, 0x5E, 0x70,
	0x82, 0x88, 0x88
};

static const ByteProvider kEoB1InvSlotYDOSProvider = { ARRAYSIZE(kEoB1InvSlotYDOS), kEoB1InvSlotYDOS };

static const uint16 kEoB1SlotValidationFlagsDOS[27] = {
	0x0008, 0x0008, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
	0x0001, 0x0002, 0x0004, 0x0020, 0x0040, 0x0010, 0xFFFF, 0x0080,
	0x0080, 0x0100, 0x0100
};

static const Uint16Provider kEoB1SlotValidationFlagsDOSProvider = { ARRAYSIZE(kEoB1SlotValidationFlagsDOS), kEoB1SlotValidationFlagsDOS };

static const byte kEoB1ProjectileWeaponTypesDOS[8] = {
	0x10, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x12
};

static const ByteProvider kEoB1ProjectileWeaponTypesDOSProvider = { ARRAYSIZE(kEoB1ProjectileWeaponTypesDOS), kEoB1ProjectileWeaponTypesDOS };

static const byte kEoB1WandTypesDOS[7] = {
	0x00, 0x12, 0x18, 0x28, 0x0D, 0xFF, 0x04
};

static const ByteProvider kEoB1WandTypesDOSProvider = { ARRAYSIZE(kEoB1WandTypesDOS), kEoB1WandTypesDOS };

static const byte kEoB1DrawObjPosIndexDOS[20] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x02, 0x00, 0x03,
	0x01, 0x04, 0x02, 0x03, 0x00, 0x01, 0x04, 0x01,
	0x03, 0x00, 0x02, 0x04
};

static const ByteProvider kEoB1DrawObjPosIndexDOSProvider = { ARRAYSIZE(kEoB1DrawObjPosIndexDOS), kEoB1DrawObjPosIndexDOS };

static const byte kEoB1FlightObjFlipIndexDOS[16] = {
	0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00
};

static const ByteProvider kEoB1FlightObjFlipIndexDOSProvider = { ARRAYSIZE(kEoB1FlightObjFlipIndexDOS), kEoB1FlightObjFlipIndexDOS };

static const byte kEoB1FlightObjShpMapDOS[88] = {
	0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01,
	0xFF, 0xFF, 0x03, 0xFF, 0x05, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0x02, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

static const ByteProvider kEoB1FlightObjShpMapDOSProvider = { ARRAYSIZE(kEoB1FlightObjShpMapDOS), kEoB1FlightObjShpMapDOS };

static const byte kEoB1FlightObjSclIndexDOS[72] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03,
	0xFF, 0xFF, 0x03, 0x03, 0xFF, 0xFF, 0x03, 0x03,
	0xFF, 0xFF, 0x03, 0x03, 0xFF, 0xFF, 0x03, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0x01, 0xFF, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

static const ByteProvider kEoB1FlightObjSclIndexDOSProvider = { ARRAYSIZE(kEoB1FlightObjSclIndexDOS), kEoB1FlightObjSclIndexDOS };

static const byte kEoB1DscShapeIndexDOS[36] = {
	0x01, 0x01, 0x04, 0x0A, 0x04, 0x08, 0x04, 0x01,
	0x04, 0xF8, 0x04, 0xF6, 0x00, 0x00, 0x03, 0x09,
	0x03, 0x07, 0x03, 0x01, 0x03, 0xF9, 0x03, 0xF7,
	0x02, 0x06, 0x02, 0x01, 0x02, 0xFA, 0x01, 0x05,
	0x01, 0x01, 0x01, 0xFB
};

static const ByteProvider kEoB1DscShapeIndexDOSProvider = { ARRAYSIZE(kEoB1DscShapeIndexDOS), kEoB1DscShapeIndexDOS };

static const uint16 kEoB1DscXDOS[18] = {
	0xFF70, 0xFFA0, 0xFFD0, 0x0000, 0x0030, 0x0060, 0x0090, 0xFF60,
	0xFFB0, 0x0000, 0x0050, 0x00A0, 0xFF80, 0x0000, 0x0080, 0x0000,
	0x0000, 0x0000
};

static const Uint16Provider kEoB1DscXDOSProvider = { ARRAYSIZE(kEoB1DscXDOS), kEoB1DscXDOS };

static const byte kEoB1DscTileIndexDOS[18] = {
	0x00, 0x06, 0x01, 0x05, 0x02, 0x04, 0x03, 0x07,
	0x0B, 0x08, 0x0A, 0x09, 0x0C, 0x0E, 0x0D, 0x0F,
	0x11, 0x10
};

static const ByteProvider kEoB1DscTileIndexDOSProvider = { ARRAYSIZE(kEoB1DscTileIndexDOS), kEoB1DscTileIndexDOS };

static const byte kEoB1DscUnk2DOS[23] = {
	0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x0D, 0x0D, 0x0D,
	0x0D, 0x0D, 0x12, 0x12, 0x12, 0x12, 0x12
};

static const ByteProvider kEoB1DscUnk2DOSProvider = { ARRAYSIZE(kEoB1DscUnk2DOS), kEoB1DscUnk2DOS };

static const byte kEoB1DscDimData1DOS[324] = {
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD8, 0xD7, 0xD8, 0xD8, 0x02, 0xD8, 0xD8, 0xD8,
	0xD8, 0xFE, 0xD7, 0xD8, 0xD8, 0xD8, 0xD7, 0x03,
	0xD8, 0xFD, 0xD8, 0xD8, 0xD8, 0xFE, 0xD8, 0x08,
	0xD8, 0xD8, 0xD8, 0xFE, 0xD7, 0x06, 0xD8, 0xD8,
	0xFA, 0x03, 0xD8, 0xFD, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xFA, 0xD7,
	0x10, 0xD8, 0xFD, 0xD7, 0x13, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xF2, 0xD8, 0x14, 0xD8, 0xD8,
	0xD8, 0xF0, 0xD7, 0x14, 0xD8, 0xED, 0x10, 0xD8,
	0xD8, 0x13, 0xD8, 0xD8, 0xD8, 0xD8, 0xEC, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD7, 0x14, 0xD8, 0xED,
	0xD7, 0xD8, 0xD8, 0x13, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD8, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD8, 0xD7,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0x06, 0xD8, 0xD8, 0xFA, 0x03, 0xD8, 0xFD,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xFA, 0xD8, 0x10, 0xD8, 0xFD, 0xD7,
	0x13, 0xFD, 0xD8, 0x13, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xF0, 0xD8, 0xD8,
	0xD8, 0xED, 0x10, 0xD8, 0xD8, 0x13, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
	0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD8, 0xD7,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0x03, 0xD8, 0xFD,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xFD, 0xD8,
	0x13, 0xFD, 0xD8, 0x13, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xED, 0xD8, 0xD8, 0xD8, 0x13, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8, 0xD8,
	0xD8, 0xD8, 0xD8, 0xD8
};

static const ByteProvider kEoB1DscDimData1DOSProvider = { ARRAYSIZE(kEoB1DscDimData1DOS), kEoB1DscDimData1DOS };

static const byte kEoB1DscDimData2DOS[648] = {
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x00, 0x16, 0x16, 0x00, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x02, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x02, 0x16, 0x00, 0x04, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x16, 0x00, 0x00, 0x03,
	0x00, 0x16, 0x03, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x02, 0x16, 0x00, 0x16, 0x00, 0x08,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x02,
	0x16, 0x00, 0x00, 0x06, 0x00, 0x16, 0x00, 0x16,
	0x06, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x06, 0x16, 0x08, 0x0E,
	0x00, 0x10, 0x00, 0x16, 0x03, 0x16, 0x06, 0x10,
	0x00, 0x13, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x0E, 0x16,
	0x00, 0x16, 0x00, 0x14, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x10, 0x16, 0x16, 0x00, 0x00, 0x14,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x10, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x14, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x12, 0x16, 0x14, 0x16, 0x00, 0x16, 0x13, 0x16,
	0x16, 0x00, 0x00, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x00, 0x16, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x00, 0x16, 0x16, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x06, 0x00, 0x16, 0x00, 0x16,
	0x06, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x06, 0x16, 0x00, 0x16,
	0x00, 0x10, 0x00, 0x16, 0x03, 0x16, 0x07, 0x0F,
	0x00, 0x13, 0x03, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x10, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x10, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00,
	0x16, 0x00, 0x16, 0x00, 0x00, 0x16, 0x16, 0x00,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x03, 0x00, 0x16, 0x03, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x03, 0x16, 0x00, 0x16,
	0x00, 0x13, 0x03, 0x16, 0x00, 0x16, 0x00, 0x13,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x13, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x13, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16,
	0x00, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x16
};

static const ByteProvider kEoB1DscDimData2DOSProvider = { ARRAYSIZE(kEoB1DscDimData2DOS), kEoB1DscDimData2DOS };

static const byte kEoB1DscBlockMapDOS[12] = {
	0x02, 0x03, 0x00, 0x01, 0x01, 0x02, 0x03, 0x00,
	0x03, 0x00, 0x01, 0x02
};

static const ByteProvider kEoB1DscBlockMapDOSProvider = { ARRAYSIZE(kEoB1DscBlockMapDOS), kEoB1DscBlockMapDOS };

static const byte kEoB1DscDimMapDOS[18] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x03,
	0x03, 0x03
};

static const ByteProvider kEoB1DscDimMapDOSProvider = { ARRAYSIZE(kEoB1DscDimMapDOS), kEoB1DscDimMapDOS };

static const byte kEoB1DscBlockIndexDOS[72] = {
	0x9D, 0x9E, 0x9F, 0xA0, 0xA1, 0xA2, 0xA3, 0xBE,
	0xBF, 0xC0, 0xC1, 0xC2, 0xDF, 0xE0, 0xE1, 0xFF,
	0x00, 0x01, 0xA3, 0xC3, 0xE3, 0x03, 0x23, 0x43,
	0x63, 0xC2, 0xE2, 0x02, 0x22, 0x42, 0xE1, 0x01,
	0x21, 0xE0, 0x00, 0x20, 0x63, 0x62, 0x61, 0x60,
	0x5F, 0x5E, 0x5D, 0x42, 0x41, 0x40, 0x3F, 0x3E,
	0x21, 0x20, 0x1F, 0x01, 0x00, 0xFF, 0x5D, 0x3D,
	0x1D, 0xFD, 0xDD, 0xBD, 0x9D, 0x3E, 0x1E, 0xFE,
	0xDE, 0xBE, 0x1F, 0xFF, 0xDF, 0x20, 0x00, 0xE0
};

static const ByteProvider kEoB1DscBlockIndexDOSProvider = { ARRAYSIZE(kEoB1DscBlockIndexDOS), kEoB1DscBlockIndexDOS };

static const byte kEoB1ClassModifierFlagsDOS[15] = {
	0x01, 0x01, 0x05, 0x02, 0x04, 0x08, 0x05, 0x09,
	0x03, 0x0B, 0x0A, 0x0C, 0x07, 0x05, 0x06
};

static const ByteProvider kEoB1ClassModifierFlagsDOSProvider = { ARRAYSIZE(kEoB1ClassModifierFlagsDOS), kEoB1ClassModifierFlagsDOS };

static const byte kEoB1MonsterStepTable01DOS[4] = {
	0xE0, 0x01, 0x20, 0xFF
};

static const ByteProvider kEoB1MonsterStepTable01DOSProvider = { ARRAYSIZE(kEoB1MonsterStepTable01DOS), kEoB1MonsterStepTable01DOS };

static const byte kEoB1MonsterStepTable2DOS[8] = {
	0x07, 0xFA, 0x05, 0xFC, 0x03, 0xFE, 0x01, 0x00
};

static const ByteProvider kEoB1MonsterStepTable2DOSProvider = { ARRAYSIZE(kEoB1MonsterStepTable2DOS), kEoB1MonsterStepTable2DOS };

static const byte kEoB1MonsterStepTable3DOS[8] = {
	0xF9, 0x06, 0xFB, 0x04, 0xFD, 0x02, 0xFF, 0x00
};

static const ByteProvider kEoB1MonsterStepTable3DOSProvider = { ARRAYSIZE(kEoB1MonsterStepTable3DOS), kEoB1MonsterStepTable3DOS };

static const byte kEoB1MonsterCloseAttPosTable1DOS[4] = {
	0x00, 0x01, 0x03, 0x02
};

static const ByteProvider kEoB1MonsterCloseAttPosTable1DOSProvider = { ARRAYSIZE(kEoB1MonsterCloseAttPosTable1DOS), kEoB1MonsterCloseAttPosTable1DOS };

static const byte kEoB1MonsterCloseAttPosTable21DOS[8] = {
	0x00, 0x01, 0x02, 0x03, 0x00, 0x02, 0x01, 0x03
};

static const ByteProvider kEoB1MonsterCloseAttPosTable21DOSProvider = { ARRAYSIZE(kEoB1MonsterCloseAttPosTable21DOS), kEoB1MonsterCloseAttPosTable21DOS };

static const byte kEoB1MonsterCloseAttChkTable1DOS[16] = {
	0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00
};

static const ByteProvider kEoB1MonsterCloseAttChkTable1DOSProvider = { ARRAYSIZE(kEoB1MonsterCloseAttChkTable1DOS), kEoB1MonsterCloseAttChkTable1DOS };

static const byte kEoB1MonsterCloseAttChkTable2DOS[16] = {
	0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x01, 0x01,
	0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x00, 0x00
};

static const ByteProvider kEoB1MonsterCloseAttChkTable2DOSProvider = { ARRAYSIZE(kEoB1MonsterCloseAttChkTable2DOS), kEoB1MonsterCloseAttChkTable2DOS };

static const byte kEoB1MonsterCloseAttDstTable1DOS[16] = {
	0x02, 0x03, 0x00, 0x01, 0x01, 0x02, 0x03, 0x00,
	0x00, 0x01, 0x02, 0x03, 0x03, 0x00, 0x01, 0x02
};

static const ByteProvider kEoB1MonsterCloseAttDstTable1DOSProvider = { ARRAYSIZE(kEoB1MonsterCloseAttDstTable1DOS), kEoB1MonsterCloseAttDstTable1DOS };

static const byte kEoB1MonsterCloseAttDstTable2DOS[48] = {
	0x01, 0x00, 0x03, 0x02, 0x05, 0x04, 0x00, 0x01,
	0x02, 0x03, 0x04, 0x05, 0x05, 0x03, 0x01, 0x04,
	0x02, 0x00, 0x01, 0x03, 0x05, 0x00, 0x02, 0x04,
	0x04, 0x05, 0x02, 0x03, 0x00, 0x01, 0x05, 0x04,
	0x03, 0x02, 0x01, 0x00, 0x00, 0x02, 0x04, 0x01,
	0x03, 0x05, 0x04, 0x02, 0x00, 0x05, 0x03, 0x01
};

static const ByteProvider kEoB1MonsterCloseAttDstTable2DOSProvider = { ARRAYSIZE(kEoB1MonsterCloseAttDstTable2DOS), kEoB1MonsterCloseAttDstTable2DOS };

static const byte kEoB1MonsterProximityTableDOS[32] = {
	0x02, 0x03, 0x00, 0x01, 0x03, 0x02, 0x01, 0x00,
	0x00, 0x02, 0x01, 0x03, 0x02, 0x00, 0x03, 0x01,
	0x01, 0x00, 0x03, 0x02, 0x00, 0x01, 0x02, 0x03,
	0x03, 0x01, 0x00, 0x02, 0x01, 0x03, 0x02, 0x00
};

static const ByteProvider kEoB1MonsterProximityTableDOSProvider = { ARRAYSIZE(kEoB1MonsterProximityTableDOS), kEoB1MonsterProximityTableDOS };

static const byte kEoB1FindBlockMonstersTableDOS[64] = {
	0x04, 0x02, 0x01, 0x03, 0x04, 0x03, 0x00, 0x02,
	0x04, 0x00, 0x03, 0x01, 0x04, 0x01, 0x02, 0x00,
	0x04, 0x01, 0x02, 0x03, 0x04, 0x00, 0x03, 0x02,
	0x04, 0x03, 0x00, 0x01, 0x04, 0x02, 0x01, 0x00,
	0x04, 0x02, 0x01, 0x03, 0x04, 0x03, 0x00, 0x02,
	0x04, 0x00, 0x03, 0x01, 0x04, 0x01, 0x02, 0x00,
	0x04, 0x01, 0x02, 0x03, 0x04, 0x00, 0x03, 0x02,
	0x04, 0x03, 0x00, 0x01, 0x04, 0x02, 0x01, 0x00
};

static const ByteProvider kEoB1FindBlockMonstersTableDOSProvider = { ARRAYSIZE(kEoB1FindBlockMonstersTableDOS), kEoB1FindBlockMonstersTableDOS };

static const byte kEoB1MonsterDirChangeTableDOS[48] = {
	0xFF, 0x06, 0x02, 0xFF, 0x04, 0x05, 0x03, 0xFF,
	0x00, 0x07, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xDF, 0xFF, 0xE0, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF,
	0x01, 0x00, 0x1F, 0x00, 0x20, 0x00, 0x21, 0x00,
	0xC0, 0xFF, 0xA0, 0xFF, 0x02, 0x00, 0x03, 0x00,
	0x40, 0x00, 0x60, 0x00, 0xFE, 0xFF, 0xFD, 0xFF
};

static const ByteProvider kEoB1MonsterDirChangeTableDOSProvider = { ARRAYSIZE(kEoB1MonsterDirChangeTableDOS), kEoB1MonsterDirChangeTableDOS };

static const uint16 kEoB1EncodeMonsterDefsDOS[168] = {
	0x0000, 0x0000, 0x0007, 0x0060, 0x0007, 0x0028, 0x000C, 0x0038,
	0x0013, 0x0028, 0x000C, 0x0038, 0x001F, 0x0000, 0x0007, 0x0060,
	0x0000, 0x0060, 0x0007, 0x0060, 0x0007, 0x0060, 0x0007, 0x0060,
	0x000E, 0x0060, 0x0005, 0x0038, 0x0007, 0x0000, 0x0007, 0x0028,
	0x000E, 0x0000, 0x0007, 0x0028, 0x0013, 0x0060, 0x0005, 0x0038,
	0x0018, 0x0060, 0x0005, 0x0038, 0x001D, 0x0060, 0x0005, 0x0038,
	0x000E, 0x0098, 0x0003, 0x0020, 0x0011, 0x00A0, 0x0004, 0x0018,
	0x0015, 0x00A0, 0x0004, 0x0018, 0x0019, 0x0098, 0x0003, 0x0020,
	0x001C, 0x0098, 0x0003, 0x0020, 0x001F, 0x0098, 0x0003, 0x0020,
	0x0000, 0x0000, 0x0007, 0x0060, 0x0007, 0x0000, 0x0007, 0x0060,
	0x000E, 0x0000, 0x0007, 0x0060, 0x0015, 0x0000, 0x0007, 0x0060,
	0x001C, 0x0000, 0x0007, 0x0060, 0x0000, 0x0060, 0x0007, 0x0060,
	0x0007, 0x0060, 0x0005, 0x0038, 0x000C, 0x0060, 0x0005, 0x0038,
	0x0011, 0x0060, 0x0005, 0x0038, 0x0016, 0x0060, 0x0005, 0x0038,
	0x001B, 0x0060, 0x0005, 0x0038, 0x0020, 0x0060, 0x0005, 0x0038,
	0x0007, 0x0098, 0x0003, 0x0020, 0x000A, 0x0098, 0x0003, 0x0020,
	0x000D, 0x0098, 0x0003, 0x0020, 0x0010, 0x0098, 0x0003, 0x0020,
	0x0013, 0x0098, 0x0003, 0x0020, 0x0016, 0x0098, 0x0003, 0x0020,
	0x0000, 0x0000, 0x000A, 0x0058, 0x000A, 0x0000, 0x000A, 0x0058,
	0x0014, 0x0000, 0x000A, 0x0058, 0x001E, 0x0000, 0x000A, 0x0058,
	0x0000, 0x0058, 0x000A, 0x0058, 0x000A, 0x0058, 0x000A, 0x0058
};

static const Uint16Provider kEoB1EncodeMonsterDefsDOSProvider = { ARRAYSIZE(kEoB1EncodeMonsterDefsDOS), kEoB1EncodeMonsterDefsDOS };

static const EoBCharacter kEoB1NpcPresetsDOS[9] = {
	{ 0x00, 0x01, "Anya",
	  18, 18, 59, 59,  5,  5, 11, 11, 14, 14, 16, 16,  9,  9,
	    45,   45, 10, 0, 1, 0, 2, -1, 100, { 4, 0, 0 },
	  { 0x00001F40, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01, "Beohram",
	  17, 17,  0,  0,  9,  9, 15, 15, 13, 13, 18, 18, 17, 17,
	    55,   55, 10, 0, 0, 0, 0, -2, 100, { 7, 0, 0 },
	  { 0x000130B0, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01, "Kirath",
	  11, 11,  0,  0, 17, 17, 13, 13, 18, 18,  8,  8, 12, 12,
	    20,   20, 10, 0, 4, 3, 4, -3, 100, { 7, 0, 0 },
	  { 0x00011170, 0x00000000, 0x00000000 }, 0x00B3126B,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01, "Ileria",
	  10, 10,  0,  0, 12, 12,  9,  9, 15, 15, 17, 17, 17, 17,
	    52,   52, 10, 0, 4, 4, 0, -4, 100, { 6, 0, 0 },
	  { 0x00004E20, 0x00000000, 0x00000000 }, 0xFFFFFFFF,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01, "Tyrra",
	  16, 16,  0,  0, 14, 14, 16, 16, 18, 18, 17, 17,  7,  7,
	    45,   45, 10, 0, 1, 1, 2, -5, 100, { 6, 0, 0 },
	  { 0x0000CF08, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01, "Tod Uphill",
	  17, 17,  0,  0, 11, 11, 14, 14, 19, 19, 18, 18, 16, 16,
	    32,   32, 10, 0, 10, 5, 5, -6, 100, { 5, 0, 0 },
	  { 0x00002D3F, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01, "Taghor",
	  17, 17,  0,  0, 11, 11, 15, 15, 15, 15, 19, 19,  9,  9,
	     3,   45,  3, 0, 6, 0, 1, -7, 25, { 5, 0, 0 },
	  { 0x00003F6A, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0024, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0029, 0x0000, 0x002B, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01, "Dohrum",
	  18, 18, 29, 29, 13, 13, 11, 11, 16, 16, 17, 17, 14, 14,
	    28,   28, 10, 0, 6, 0, 0, -8, 100, { 3, 0, 0 },
	  { 0x000013A0, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0024, 0x0000, 0x0030, 0x0037, 0x0037, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0029, 0x0000, 0x002B, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } },
	{ 0x00, 0x01, "Keirgar",
	  18, 18, 92, 92, 15, 15, 15, 15, 12, 12, 19, 19, 17, 17,
	     3,   45,  3, 0, 6, 0, 1, -9, 25, { 5, 0, 0 },
	  { 0x00001F40, 0x00000000, 0x00000000 }, 0x00000000,
	  { 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
	    0x0000, 0x0000, 0x0000 } }
};

static const EoBCharacterProvider kEoB1NpcPresetsDOSProvider = { ARRAYSIZE(kEoB1NpcPresetsDOS), kEoB1NpcPresetsDOS };

