/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.8:
 *   smidump -f scli DISMAN-SCRIPT-MIB
 *
 * Derived from DISMAN-SCRIPT-MIB:
 *   This MIB module defines a set of objects that allow to
 *   delegate management scripts to distributed managers.
 *
 * Revision 2001-08-21 00:00:
 *   Revised version, published as RFC 3165.
 *   
 *   This revision introduces several new objects: smScriptError,
 *   smScriptLastChange, smLaunchError, smLaunchLastChange,
 *   smLaunchRowExpireTime, smRunResultTime, and smRunErrorTime.
 *   
 *   The following existing objects were updated: the maximum
 *   value of smRunLifeTime now disables the timer, an
 *   autostart value was added to the smLaunchAdminStatus
 *   object, and a new expired state was added to the
 *   smLaunchOperStatus object.
 *   
 *   A new smScriptException notification has been added to
 *   support runtime error notifications.
 *   
 *   Created new conformance and compliance statements that
 *   take care of the new objects and notifications.
 *   
 *   Clarifications have been added in several places to remove
 *   ambiguities or contradictions that were discovered and
 *   reported by implementors.
 *
 * Revision 1999-02-22 18:00:
 *   Initial version, published as RFC 2592.
 *
 * $Id: disman-script-mib.c 3180 2009-07-29 22:36:13Z schoenw $
 */

#include "disman-script-mib.h"

GNetSnmpEnum const disman_script_mib_enums_smScriptAdminStatus[] = {
    { DISMAN_SCRIPT_MIB_SMSCRIPTADMINSTATUS_ENABLED,  "enabled" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTADMINSTATUS_DISABLED, "disabled" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTADMINSTATUS_EDITING,  "editing" },
    { 0, NULL }
};

GNetSnmpEnum const disman_script_mib_enums_smScriptOperStatus[] = {
    { DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS_ENABLED,           "enabled" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS_DISABLED,          "disabled" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS_EDITING,           "editing" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS_RETRIEVING,        "retrieving" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS_COMPILING,         "compiling" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS_NOSUCHSCRIPT,      "noSuchScript" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS_ACCESSDENIED,      "accessDenied" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS_WRONGLANGUAGE,     "wrongLanguage" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS_WRONGVERSION,      "wrongVersion" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS_COMPILATIONFAILED, "compilationFailed" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS_NORESOURCESLEFT,   "noResourcesLeft" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS_UNKNOWNPROTOCOL,   "unknownProtocol" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS_PROTOCOLFAILURE,   "protocolFailure" },
    { DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS_GENERICERROR,      "genericError" },
    { 0, NULL }
};

GNetSnmpEnum const disman_script_mib_enums_smLaunchControl[] = {
    { DISMAN_SCRIPT_MIB_SMLAUNCHCONTROL_ABORT,   "abort" },
    { DISMAN_SCRIPT_MIB_SMLAUNCHCONTROL_SUSPEND, "suspend" },
    { DISMAN_SCRIPT_MIB_SMLAUNCHCONTROL_RESUME,  "resume" },
    { DISMAN_SCRIPT_MIB_SMLAUNCHCONTROL_NOP,     "nop" },
    { 0, NULL }
};

GNetSnmpEnum const disman_script_mib_enums_smLaunchAdminStatus[] = {
    { DISMAN_SCRIPT_MIB_SMLAUNCHADMINSTATUS_ENABLED,   "enabled" },
    { DISMAN_SCRIPT_MIB_SMLAUNCHADMINSTATUS_DISABLED,  "disabled" },
    { DISMAN_SCRIPT_MIB_SMLAUNCHADMINSTATUS_AUTOSTART, "autostart" },
    { 0, NULL }
};

GNetSnmpEnum const disman_script_mib_enums_smLaunchOperStatus[] = {
    { DISMAN_SCRIPT_MIB_SMLAUNCHOPERSTATUS_ENABLED,  "enabled" },
    { DISMAN_SCRIPT_MIB_SMLAUNCHOPERSTATUS_DISABLED, "disabled" },
    { DISMAN_SCRIPT_MIB_SMLAUNCHOPERSTATUS_EXPIRED,  "expired" },
    { 0, NULL }
};

GNetSnmpEnum const disman_script_mib_enums_smRunExitCode[] = {
    { DISMAN_SCRIPT_MIB_SMRUNEXITCODE_NOERROR,           "noError" },
    { DISMAN_SCRIPT_MIB_SMRUNEXITCODE_HALTED,            "halted" },
    { DISMAN_SCRIPT_MIB_SMRUNEXITCODE_LIFETIMEEXCEEDED,  "lifeTimeExceeded" },
    { DISMAN_SCRIPT_MIB_SMRUNEXITCODE_NORESOURCESLEFT,   "noResourcesLeft" },
    { DISMAN_SCRIPT_MIB_SMRUNEXITCODE_LANGUAGEERROR,     "languageError" },
    { DISMAN_SCRIPT_MIB_SMRUNEXITCODE_RUNTIMEERROR,      "runtimeError" },
    { DISMAN_SCRIPT_MIB_SMRUNEXITCODE_INVALIDARGUMENT,   "invalidArgument" },
    { DISMAN_SCRIPT_MIB_SMRUNEXITCODE_SECURITYVIOLATION, "securityViolation" },
    { DISMAN_SCRIPT_MIB_SMRUNEXITCODE_GENERICERROR,      "genericError" },
    { 0, NULL }
};

GNetSnmpEnum const disman_script_mib_enums_smRunControl[] = {
    { DISMAN_SCRIPT_MIB_SMRUNCONTROL_ABORT,   "abort" },
    { DISMAN_SCRIPT_MIB_SMRUNCONTROL_SUSPEND, "suspend" },
    { DISMAN_SCRIPT_MIB_SMRUNCONTROL_RESUME,  "resume" },
    { DISMAN_SCRIPT_MIB_SMRUNCONTROL_NOP,     "nop" },
    { 0, NULL }
};

GNetSnmpEnum const disman_script_mib_enums_smRunState[] = {
    { DISMAN_SCRIPT_MIB_SMRUNSTATE_INITIALIZING, "initializing" },
    { DISMAN_SCRIPT_MIB_SMRUNSTATE_EXECUTING,    "executing" },
    { DISMAN_SCRIPT_MIB_SMRUNSTATE_SUSPENDING,   "suspending" },
    { DISMAN_SCRIPT_MIB_SMRUNSTATE_SUSPENDED,    "suspended" },
    { DISMAN_SCRIPT_MIB_SMRUNSTATE_RESUMING,     "resuming" },
    { DISMAN_SCRIPT_MIB_SMRUNSTATE_ABORTING,     "aborting" },
    { DISMAN_SCRIPT_MIB_SMRUNSTATE_TERMINATED,   "terminated" },
    { 0, NULL }
};


static guint32 const smScriptAbort[]
	= { DISMAN_SCRIPT_MIB_SMSCRIPTABORT };
static guint32 const smScriptResult[]
	= { DISMAN_SCRIPT_MIB_SMSCRIPTRESULT };
static guint32 const smScriptException[]
	= { DISMAN_SCRIPT_MIB_SMSCRIPTEXCEPTION };

GNetSnmpIdentity const disman_script_mib_notifications[] = {
    { smScriptAbort,
      G_N_ELEMENTS(smScriptAbort),
      "smScriptAbort" },
    { smScriptResult,
      G_N_ELEMENTS(smScriptResult),
      "smScriptResult" },
    { smScriptException,
      G_N_ELEMENTS(smScriptException),
      "smScriptException" },
    { 0, 0, NULL }
};


static guint16 smLangVersion_constraints[] = {0U, 32U, 0, 0};
static guint16 smLangRevision_constraints[] = {0U, 32U, 0, 0};
static guint16 smLangDescr_constraints[] = {0U, 255U, 0, 0};
static guint16 smExtsnVersion_constraints[] = {0U, 32U, 0, 0};
static guint16 smExtsnRevision_constraints[] = {0U, 32U, 0, 0};
static guint16 smExtsnDescr_constraints[] = {0U, 255U, 0, 0};
static guint16 smScriptDescr_constraints[] = {0U, 255U, 0, 0};
static gint32 smScriptLanguage_constraints[] = {0L, 2147483647L, 0, 0};
static guint16 smScriptSource_constraints[] = {0U, 255U, 0, 0};
static guint16 smScriptError_constraints[] = {0U, 255U, 0, 0};
static guint16 smScriptLastChange_constraints[] = {8U, 8U, 11, 11, 0, 0};
static guint16 smCodeText_constraints[] = {1U, 1024U, 0, 0};
static guint16 smLaunchScriptOwner_constraints[] = {0U, 32U, 0, 0};
static guint16 smLaunchScriptName_constraints[] = {0U, 32U, 0, 0};
static guint32 smLaunchMaxRunning_constraints[] = {1UL, 4294967295UL, 0, 0};
static guint32 smLaunchMaxCompleted_constraints[] = {1UL, 4294967295UL, 0, 0};
static gint32 smLaunchLifeTime_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 smLaunchExpireTime_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 smLaunchStart_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 smLaunchRunIndexNext_constraints[] = {1L, 2147483647L, 0, 0};
static guint16 smLaunchError_constraints[] = {0U, 255U, 0, 0};
static guint16 smLaunchLastChange_constraints[] = {8U, 8U, 11, 11, 0, 0};
static gint32 smLaunchRowExpireTime_constraints[] = {0L, 2147483647L, 0, 0};
static guint16 smRunStartTime_constraints[] = {8U, 8U, 11, 11, 0, 0};
static guint16 smRunEndTime_constraints[] = {8U, 8U, 11, 11, 0, 0};
static gint32 smRunLifeTime_constraints[] = {0L, 2147483647L, 0, 0};
static gint32 smRunExpireTime_constraints[] = {0L, 2147483647L, 0, 0};
static guint16 smRunError_constraints[] = {0U, 255U, 0, 0};
static guint16 smRunResultTime_constraints[] = {8U, 8U, 11, 11, 0, 0};
static guint16 smRunErrorTime_constraints[] = {8U, 8U, 11, 11, 0, 0};


static guint32 const smLangEntry_oid[] = {1, 3, 6, 1, 2, 1, 64, 1, 1, 1};

static GNetSnmpAttribute smLangEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      DISMAN_SCRIPT_MIB_SMLANGLANGUAGE, "smLangLanguage",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smLangEntry_t, smLangLanguage),
      G_STRUCT_OFFSET(disman_script_mib_smLangEntry_t, _smLangLanguageLength),
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMLANGVERSION, "smLangVersion",
       smLangVersion_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smLangEntry_t, smLangVersion),
      G_STRUCT_OFFSET(disman_script_mib_smLangEntry_t, _smLangVersionLength),
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      DISMAN_SCRIPT_MIB_SMLANGVENDOR, "smLangVendor",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smLangEntry_t, smLangVendor),
      G_STRUCT_OFFSET(disman_script_mib_smLangEntry_t, _smLangVendorLength),
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMLANGREVISION, "smLangRevision",
       smLangRevision_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smLangEntry_t, smLangRevision),
      G_STRUCT_OFFSET(disman_script_mib_smLangEntry_t, _smLangRevisionLength),
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMLANGDESCR, "smLangDescr",
       smLangDescr_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smLangEntry_t, smLangDescr),
      G_STRUCT_OFFSET(disman_script_mib_smLangEntry_t, _smLangDescrLength),
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const smExtsnEntry_oid[] = {1, 3, 6, 1, 2, 1, 64, 1, 2, 1};

static GNetSnmpAttribute smExtsnEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      DISMAN_SCRIPT_MIB_SMEXTSNEXTENSION, "smExtsnExtension",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smExtsnEntry_t, smExtsnExtension),
      G_STRUCT_OFFSET(disman_script_mib_smExtsnEntry_t, _smExtsnExtensionLength),
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMEXTSNVERSION, "smExtsnVersion",
       smExtsnVersion_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smExtsnEntry_t, smExtsnVersion),
      G_STRUCT_OFFSET(disman_script_mib_smExtsnEntry_t, _smExtsnVersionLength),
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_OBJECTID,
      DISMAN_SCRIPT_MIB_SMEXTSNVENDOR, "smExtsnVendor",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smExtsnEntry_t, smExtsnVendor),
      G_STRUCT_OFFSET(disman_script_mib_smExtsnEntry_t, _smExtsnVendorLength),
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMEXTSNREVISION, "smExtsnRevision",
       smExtsnRevision_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smExtsnEntry_t, smExtsnRevision),
      G_STRUCT_OFFSET(disman_script_mib_smExtsnEntry_t, _smExtsnRevisionLength),
      0 },
    { 6, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMEXTSNDESCR, "smExtsnDescr",
       smExtsnDescr_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smExtsnEntry_t, smExtsnDescr),
      G_STRUCT_OFFSET(disman_script_mib_smExtsnEntry_t, _smExtsnDescrLength),
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const smScriptEntry_oid[] = {1, 3, 6, 1, 2, 1, 64, 1, 3, 1, 1};

static GNetSnmpAttribute smScriptEntry_attr[] = {
    { 3, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMSCRIPTDESCR, "smScriptDescr",
       smScriptDescr_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smScriptEntry_t, smScriptDescr),
      G_STRUCT_OFFSET(disman_script_mib_smScriptEntry_t, _smScriptDescrLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 4, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMSCRIPTLANGUAGE, "smScriptLanguage",
       smScriptLanguage_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smScriptEntry_t, smScriptLanguage),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 5, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMSCRIPTSOURCE, "smScriptSource",
       smScriptSource_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smScriptEntry_t, smScriptSource),
      G_STRUCT_OFFSET(disman_script_mib_smScriptEntry_t, _smScriptSourceLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMSCRIPTADMINSTATUS, "smScriptAdminStatus",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smScriptEntry_t, smScriptAdminStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMSCRIPTOPERSTATUS, "smScriptOperStatus",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smScriptEntry_t, smScriptOperStatus),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMSCRIPTSTORAGETYPE, "smScriptStorageType",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smScriptEntry_t, smScriptStorageType),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMSCRIPTROWSTATUS, "smScriptRowStatus",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smScriptEntry_t, smScriptRowStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 10, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMSCRIPTERROR, "smScriptError",
       smScriptError_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smScriptEntry_t, smScriptError),
      G_STRUCT_OFFSET(disman_script_mib_smScriptEntry_t, _smScriptErrorLength),
      0 },
    { 11, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMSCRIPTLASTCHANGE, "smScriptLastChange",
       smScriptLastChange_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smScriptEntry_t, smScriptLastChange),
      G_STRUCT_OFFSET(disman_script_mib_smScriptEntry_t, _smScriptLastChangeLength),
      0 },
    { 0, 0, 0, NULL }
};

static guint32 const smCodeEntry_oid[] = {1, 3, 6, 1, 2, 1, 64, 1, 3, 2, 1};

static GNetSnmpAttribute smCodeEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMCODETEXT, "smCodeText",
       smCodeText_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smCodeEntry_t, smCodeText),
      G_STRUCT_OFFSET(disman_script_mib_smCodeEntry_t, _smCodeTextLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 3, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMCODEROWSTATUS, "smCodeRowStatus",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smCodeEntry_t, smCodeRowStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const smLaunchEntry_oid[] = {1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1};

static GNetSnmpAttribute smLaunchEntry_attr[] = {
    { 3, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMLAUNCHSCRIPTOWNER, "smLaunchScriptOwner",
       smLaunchScriptOwner_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchScriptOwner),
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, _smLaunchScriptOwnerLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 4, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMLAUNCHSCRIPTNAME, "smLaunchScriptName",
       smLaunchScriptName_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchScriptName),
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, _smLaunchScriptNameLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 5, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMLAUNCHARGUMENT, "smLaunchArgument",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchArgument),
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, _smLaunchArgumentLength),
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      DISMAN_SCRIPT_MIB_SMLAUNCHMAXRUNNING, "smLaunchMaxRunning",
       smLaunchMaxRunning_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchMaxRunning),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_UNSIGNED32,
      DISMAN_SCRIPT_MIB_SMLAUNCHMAXCOMPLETED, "smLaunchMaxCompleted",
       smLaunchMaxCompleted_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchMaxCompleted),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 8, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMLAUNCHLIFETIME, "smLaunchLifeTime",
       smLaunchLifeTime_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchLifeTime),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMLAUNCHEXPIRETIME, "smLaunchExpireTime",
       smLaunchExpireTime_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchExpireTime),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 10, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMLAUNCHSTART, "smLaunchStart",
       smLaunchStart_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchStart),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 11, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMLAUNCHCONTROL, "smLaunchControl",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchControl),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 12, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMLAUNCHADMINSTATUS, "smLaunchAdminStatus",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchAdminStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 13, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMLAUNCHOPERSTATUS, "smLaunchOperStatus",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchOperStatus),
      0,
      0 },
    { 14, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMLAUNCHRUNINDEXNEXT, "smLaunchRunIndexNext",
       smLaunchRunIndexNext_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchRunIndexNext),
      0,
      0 },
    { 15, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMLAUNCHSTORAGETYPE, "smLaunchStorageType",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchStorageType),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 16, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMLAUNCHROWSTATUS, "smLaunchRowStatus",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchRowStatus),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 17, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMLAUNCHERROR, "smLaunchError",
       smLaunchError_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchError),
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, _smLaunchErrorLength),
      0 },
    { 18, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMLAUNCHLASTCHANGE, "smLaunchLastChange",
       smLaunchLastChange_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchLastChange),
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, _smLaunchLastChangeLength),
      0 },
    { 19, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMLAUNCHROWEXPIRETIME, "smLaunchRowExpireTime",
       smLaunchRowExpireTime_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smLaunchEntry_t, smLaunchRowExpireTime),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 0, 0, 0, NULL }
};

static guint32 const smRunEntry_oid[] = {1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1};

static GNetSnmpAttribute smRunEntry_attr[] = {
    { 2, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMRUNARGUMENT, "smRunArgument",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, smRunArgument),
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, _smRunArgumentLength),
      0 },
    { 3, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMRUNSTARTTIME, "smRunStartTime",
       smRunStartTime_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, smRunStartTime),
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, _smRunStartTimeLength),
      0 },
    { 4, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMRUNENDTIME, "smRunEndTime",
       smRunEndTime_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, smRunEndTime),
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, _smRunEndTimeLength),
      0 },
    { 5, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMRUNLIFETIME, "smRunLifeTime",
       smRunLifeTime_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, smRunLifeTime),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 6, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMRUNEXPIRETIME, "smRunExpireTime",
       smRunExpireTime_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, smRunExpireTime),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 7, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMRUNEXITCODE, "smRunExitCode",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, smRunExitCode),
      0,
      0 },
    { 8, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMRUNRESULT, "smRunResult",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, smRunResult),
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, _smRunResultLength),
      0 },
    { 9, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMRUNCONTROL, "smRunControl",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, smRunControl),
      0,
      GSNMP_ATTR_FLAG_WRITABLE },
    { 10, GNET_SNMP_VARBIND_TYPE_INTEGER32,
      DISMAN_SCRIPT_MIB_SMRUNSTATE, "smRunState",
       NULL,
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, smRunState),
      0,
      0 },
    { 11, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMRUNERROR, "smRunError",
       smRunError_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, smRunError),
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, _smRunErrorLength),
      0 },
    { 12, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMRUNRESULTTIME, "smRunResultTime",
       smRunResultTime_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, smRunResultTime),
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, _smRunResultTimeLength),
      0 },
    { 13, GNET_SNMP_VARBIND_TYPE_OCTETSTRING,
      DISMAN_SCRIPT_MIB_SMRUNERRORTIME, "smRunErrorTime",
       smRunErrorTime_constraints,
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, smRunErrorTime),
      G_STRUCT_OFFSET(disman_script_mib_smRunEntry_t, _smRunErrorTimeLength),
      0 },
    { 0, 0, 0, NULL }
};


disman_script_mib_smLangEntry_t *
disman_script_mib_new_smLangEntry()
{
    disman_script_mib_smLangEntry_t *smLangEntry;

    smLangEntry = (disman_script_mib_smLangEntry_t *) g_malloc0(sizeof(disman_script_mib_smLangEntry_t) + sizeof(gpointer));
    return smLangEntry;
}

static inline int
unpack_smLangEntry(GNetSnmpVarBind *vb, disman_script_mib_smLangEntry_t *smLangEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    smLangEntry->smLangIndex = vb->oid[idx++];
    if ((smLangEntry->smLangIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_smLangEntry(guint32 *base, gint32 smLangIndex)
{
    guint8 idx = 11;

    base[idx++] = smLangIndex;
    return idx;
}

static inline disman_script_mib_smLangEntry_t *
assign_smLangEntry(GList *vbl)
{
    disman_script_mib_smLangEntry_t *smLangEntry;
    char *p;

    smLangEntry = disman_script_mib_new_smLangEntry();
    p = (char *) smLangEntry + sizeof(disman_script_mib_smLangEntry_t);
    * (GList **) p = vbl;

    if (unpack_smLangEntry((GNetSnmpVarBind *) vbl->data, smLangEntry) < 0) {
        g_warning("%s: invalid instance identifier", "smLangEntry");
        g_free(smLangEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, smLangEntry_oid, G_N_ELEMENTS(smLangEntry_oid),
                      smLangEntry_attr, smLangEntry);

    return smLangEntry;
}

void
disman_script_mib_get_smLangTable(GNetSnmp *s, disman_script_mib_smLangEntry_t ***smLangEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 64, 1, 1, 1, 0};
    guint32 base[128];

    *smLangEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, smLangEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *smLangEntry = (disman_script_mib_smLangEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(disman_script_mib_smLangEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*smLangEntry)[i] = assign_smLangEntry(row->data);
        }
    }
}

void
disman_script_mib_get_smLangEntry(GNetSnmp *s, disman_script_mib_smLangEntry_t **smLangEntry, gint32 smLangIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, smLangEntry_oid, sizeof(smLangEntry_oid));
    len = pack_smLangEntry(base, smLangIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "smLangEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *smLangEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, smLangEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *smLangEntry = assign_smLangEntry(out);
    }
}

void
disman_script_mib_free_smLangEntry(disman_script_mib_smLangEntry_t *smLangEntry)
{
    GList *vbl;
    char *p;

    if (smLangEntry) {
        p = (char *) smLangEntry + sizeof(disman_script_mib_smLangEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(smLangEntry);
    }
}

void
disman_script_mib_free_smLangTable(disman_script_mib_smLangEntry_t **smLangEntry)
{
    int i;

    if (smLangEntry) {
        for (i = 0; smLangEntry[i]; i++) {
            disman_script_mib_free_smLangEntry(smLangEntry[i]);
        }
        g_free(smLangEntry);
    }
}

disman_script_mib_smExtsnEntry_t *
disman_script_mib_new_smExtsnEntry()
{
    disman_script_mib_smExtsnEntry_t *smExtsnEntry;

    smExtsnEntry = (disman_script_mib_smExtsnEntry_t *) g_malloc0(sizeof(disman_script_mib_smExtsnEntry_t) + sizeof(gpointer));
    return smExtsnEntry;
}

static inline int
unpack_smExtsnEntry(GNetSnmpVarBind *vb, disman_script_mib_smExtsnEntry_t *smExtsnEntry)
{
    guint8 idx = 11;

    if (vb->oid_len < idx) return -1;
    smExtsnEntry->smLangIndex = vb->oid[idx++];
    if ((smExtsnEntry->smLangIndex < 1)) {
         return -1;
    }
    if (vb->oid_len < idx) return -1;
    smExtsnEntry->smExtsnIndex = vb->oid[idx++];
    if ((smExtsnEntry->smExtsnIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_smExtsnEntry(guint32 *base, gint32 smLangIndex, gint32 smExtsnIndex)
{
    guint8 idx = 11;

    base[idx++] = smLangIndex;
    base[idx++] = smExtsnIndex;
    return idx;
}

static inline disman_script_mib_smExtsnEntry_t *
assign_smExtsnEntry(GList *vbl)
{
    disman_script_mib_smExtsnEntry_t *smExtsnEntry;
    char *p;

    smExtsnEntry = disman_script_mib_new_smExtsnEntry();
    p = (char *) smExtsnEntry + sizeof(disman_script_mib_smExtsnEntry_t);
    * (GList **) p = vbl;

    if (unpack_smExtsnEntry((GNetSnmpVarBind *) vbl->data, smExtsnEntry) < 0) {
        g_warning("%s: invalid instance identifier", "smExtsnEntry");
        g_free(smExtsnEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, smExtsnEntry_oid, G_N_ELEMENTS(smExtsnEntry_oid),
                      smExtsnEntry_attr, smExtsnEntry);

    return smExtsnEntry;
}

void
disman_script_mib_get_smExtsnTable(GNetSnmp *s, disman_script_mib_smExtsnEntry_t ***smExtsnEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 64, 1, 2, 1, 0};
    guint32 base[128];

    *smExtsnEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 11, 10, smExtsnEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *smExtsnEntry = (disman_script_mib_smExtsnEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(disman_script_mib_smExtsnEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*smExtsnEntry)[i] = assign_smExtsnEntry(row->data);
        }
    }
}

void
disman_script_mib_get_smExtsnEntry(GNetSnmp *s, disman_script_mib_smExtsnEntry_t **smExtsnEntry, gint32 smLangIndex, gint32 smExtsnIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, smExtsnEntry_oid, sizeof(smExtsnEntry_oid));
    len = pack_smExtsnEntry(base, smLangIndex, smExtsnIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "smExtsnEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *smExtsnEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 10, smExtsnEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *smExtsnEntry = assign_smExtsnEntry(out);
    }
}

void
disman_script_mib_free_smExtsnEntry(disman_script_mib_smExtsnEntry_t *smExtsnEntry)
{
    GList *vbl;
    char *p;

    if (smExtsnEntry) {
        p = (char *) smExtsnEntry + sizeof(disman_script_mib_smExtsnEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(smExtsnEntry);
    }
}

void
disman_script_mib_free_smExtsnTable(disman_script_mib_smExtsnEntry_t **smExtsnEntry)
{
    int i;

    if (smExtsnEntry) {
        for (i = 0; smExtsnEntry[i]; i++) {
            disman_script_mib_free_smExtsnEntry(smExtsnEntry[i]);
        }
        g_free(smExtsnEntry);
    }
}

disman_script_mib_smScriptEntry_t *
disman_script_mib_new_smScriptEntry()
{
    disman_script_mib_smScriptEntry_t *smScriptEntry;

    smScriptEntry = (disman_script_mib_smScriptEntry_t *) g_malloc0(sizeof(disman_script_mib_smScriptEntry_t) + sizeof(gpointer));
    return smScriptEntry;
}

static inline int
unpack_smScriptEntry(GNetSnmpVarBind *vb, disman_script_mib_smScriptEntry_t *smScriptEntry)
{
    guint8 idx = 12;
    guint16 i, len;

    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len > 32) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        smScriptEntry->smScriptOwner[i] = vb->oid[idx++];
    }
    smScriptEntry->_smScriptOwnerLength = len;
    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len < 1 || len > 32) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        smScriptEntry->smScriptName[i] = vb->oid[idx++];
    }
    smScriptEntry->_smScriptNameLength = len;
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_smScriptEntry(guint32 *base, guchar *smScriptOwner, guint16 _smScriptOwnerLength, guchar *smScriptName, guint16 _smScriptNameLength)
{
    guint8 idx = 12;
    guint16 i, len;

    len = _smScriptOwnerLength;
    base[idx++] = len;
    if (len > 32) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = smScriptOwner[i];
        if (idx >= 128) return -1;
    }
    len = _smScriptNameLength;
    base[idx++] = len;
    if (len < 1 || len > 32) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = smScriptName[i];
        if (idx >= 128) return -1;
    }
    return idx;
}

static inline disman_script_mib_smScriptEntry_t *
assign_smScriptEntry(GList *vbl)
{
    disman_script_mib_smScriptEntry_t *smScriptEntry;
    char *p;

    smScriptEntry = disman_script_mib_new_smScriptEntry();
    p = (char *) smScriptEntry + sizeof(disman_script_mib_smScriptEntry_t);
    * (GList **) p = vbl;

    if (unpack_smScriptEntry((GNetSnmpVarBind *) vbl->data, smScriptEntry) < 0) {
        g_warning("%s: invalid instance identifier", "smScriptEntry");
        g_free(smScriptEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, smScriptEntry_oid, G_N_ELEMENTS(smScriptEntry_oid),
                      smScriptEntry_attr, smScriptEntry);

    return smScriptEntry;
}

void
disman_script_mib_get_smScriptTable(GNetSnmp *s, disman_script_mib_smScriptEntry_t ***smScriptEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 64, 1, 3, 1, 1, 0};
    guint32 base[128];

    *smScriptEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 12, 11, smScriptEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *smScriptEntry = (disman_script_mib_smScriptEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(disman_script_mib_smScriptEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*smScriptEntry)[i] = assign_smScriptEntry(row->data);
        }
    }
}

void
disman_script_mib_get_smScriptEntry(GNetSnmp *s, disman_script_mib_smScriptEntry_t **smScriptEntry, guchar *smScriptOwner, guint16 _smScriptOwnerLength, guchar *smScriptName, guint16 _smScriptNameLength, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, smScriptEntry_oid, sizeof(smScriptEntry_oid));
    len = pack_smScriptEntry(base, smScriptOwner, _smScriptOwnerLength, smScriptName, _smScriptNameLength);
    if (len < 0) {
        g_warning("%s: invalid index values", "smScriptEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *smScriptEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 11, smScriptEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *smScriptEntry = assign_smScriptEntry(out);
    }
}

void
disman_script_mib_set_smScriptEntry(GNetSnmp *s, disman_script_mib_smScriptEntry_t *smScriptEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, smScriptEntry_oid, sizeof(smScriptEntry_oid));
    len = pack_smScriptEntry(base, smScriptEntry->smScriptOwner, smScriptEntry->_smScriptOwnerLength, smScriptEntry->smScriptName, smScriptEntry->_smScriptNameLength);
    if (len < 0) {
        g_warning("%s: invalid index values", "smScriptEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 11, smScriptEntry_attr, mask, smScriptEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
disman_script_mib_free_smScriptEntry(disman_script_mib_smScriptEntry_t *smScriptEntry)
{
    GList *vbl;
    char *p;

    if (smScriptEntry) {
        p = (char *) smScriptEntry + sizeof(disman_script_mib_smScriptEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(smScriptEntry);
    }
}

void
disman_script_mib_free_smScriptTable(disman_script_mib_smScriptEntry_t **smScriptEntry)
{
    int i;

    if (smScriptEntry) {
        for (i = 0; smScriptEntry[i]; i++) {
            disman_script_mib_free_smScriptEntry(smScriptEntry[i]);
        }
        g_free(smScriptEntry);
    }
}

disman_script_mib_smCodeEntry_t *
disman_script_mib_new_smCodeEntry()
{
    disman_script_mib_smCodeEntry_t *smCodeEntry;

    smCodeEntry = (disman_script_mib_smCodeEntry_t *) g_malloc0(sizeof(disman_script_mib_smCodeEntry_t) + sizeof(gpointer));
    return smCodeEntry;
}

static inline int
unpack_smCodeEntry(GNetSnmpVarBind *vb, disman_script_mib_smCodeEntry_t *smCodeEntry)
{
    guint8 idx = 12;
    guint16 i, len;

    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len > 32) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        smCodeEntry->smScriptOwner[i] = vb->oid[idx++];
    }
    smCodeEntry->_smScriptOwnerLength = len;
    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len < 1 || len > 32) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        smCodeEntry->smScriptName[i] = vb->oid[idx++];
    }
    smCodeEntry->_smScriptNameLength = len;
    if (vb->oid_len < idx) return -1;
    smCodeEntry->smCodeIndex = vb->oid[idx++];
     if ((smCodeEntry->smCodeIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_smCodeEntry(guint32 *base, guchar *smScriptOwner, guint16 _smScriptOwnerLength, guchar *smScriptName, guint16 _smScriptNameLength, guint32 smCodeIndex)
{
    guint8 idx = 12;
    guint16 i, len;

    len = _smScriptOwnerLength;
    base[idx++] = len;
    if (len > 32) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = smScriptOwner[i];
        if (idx >= 128) return -1;
    }
    len = _smScriptNameLength;
    base[idx++] = len;
    if (len < 1 || len > 32) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = smScriptName[i];
        if (idx >= 128) return -1;
    }
    base[idx++] = smCodeIndex;
    return idx;
}

static inline disman_script_mib_smCodeEntry_t *
assign_smCodeEntry(GList *vbl)
{
    disman_script_mib_smCodeEntry_t *smCodeEntry;
    char *p;

    smCodeEntry = disman_script_mib_new_smCodeEntry();
    p = (char *) smCodeEntry + sizeof(disman_script_mib_smCodeEntry_t);
    * (GList **) p = vbl;

    if (unpack_smCodeEntry((GNetSnmpVarBind *) vbl->data, smCodeEntry) < 0) {
        g_warning("%s: invalid instance identifier", "smCodeEntry");
        g_free(smCodeEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, smCodeEntry_oid, G_N_ELEMENTS(smCodeEntry_oid),
                      smCodeEntry_attr, smCodeEntry);

    return smCodeEntry;
}

void
disman_script_mib_get_smCodeTable(GNetSnmp *s, disman_script_mib_smCodeEntry_t ***smCodeEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 64, 1, 3, 2, 1, 0};
    guint32 base[128];

    *smCodeEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 12, 11, smCodeEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *smCodeEntry = (disman_script_mib_smCodeEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(disman_script_mib_smCodeEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*smCodeEntry)[i] = assign_smCodeEntry(row->data);
        }
    }
}

void
disman_script_mib_get_smCodeEntry(GNetSnmp *s, disman_script_mib_smCodeEntry_t **smCodeEntry, guchar *smScriptOwner, guint16 _smScriptOwnerLength, guchar *smScriptName, guint16 _smScriptNameLength, guint32 smCodeIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, smCodeEntry_oid, sizeof(smCodeEntry_oid));
    len = pack_smCodeEntry(base, smScriptOwner, _smScriptOwnerLength, smScriptName, _smScriptNameLength, smCodeIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "smCodeEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *smCodeEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 11, smCodeEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *smCodeEntry = assign_smCodeEntry(out);
    }
}

void
disman_script_mib_set_smCodeEntry(GNetSnmp *s, disman_script_mib_smCodeEntry_t *smCodeEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, smCodeEntry_oid, sizeof(smCodeEntry_oid));
    len = pack_smCodeEntry(base, smCodeEntry->smScriptOwner, smCodeEntry->_smScriptOwnerLength, smCodeEntry->smScriptName, smCodeEntry->_smScriptNameLength, smCodeEntry->smCodeIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "smCodeEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 11, smCodeEntry_attr, mask, smCodeEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
disman_script_mib_free_smCodeEntry(disman_script_mib_smCodeEntry_t *smCodeEntry)
{
    GList *vbl;
    char *p;

    if (smCodeEntry) {
        p = (char *) smCodeEntry + sizeof(disman_script_mib_smCodeEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(smCodeEntry);
    }
}

void
disman_script_mib_free_smCodeTable(disman_script_mib_smCodeEntry_t **smCodeEntry)
{
    int i;

    if (smCodeEntry) {
        for (i = 0; smCodeEntry[i]; i++) {
            disman_script_mib_free_smCodeEntry(smCodeEntry[i]);
        }
        g_free(smCodeEntry);
    }
}

disman_script_mib_smLaunchEntry_t *
disman_script_mib_new_smLaunchEntry()
{
    disman_script_mib_smLaunchEntry_t *smLaunchEntry;

    smLaunchEntry = (disman_script_mib_smLaunchEntry_t *) g_malloc0(sizeof(disman_script_mib_smLaunchEntry_t) + sizeof(gpointer));
    return smLaunchEntry;
}

static inline int
unpack_smLaunchEntry(GNetSnmpVarBind *vb, disman_script_mib_smLaunchEntry_t *smLaunchEntry)
{
    guint8 idx = 12;
    guint16 i, len;

    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len > 32) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        smLaunchEntry->smLaunchOwner[i] = vb->oid[idx++];
    }
    smLaunchEntry->_smLaunchOwnerLength = len;
    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len < 1 || len > 32) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        smLaunchEntry->smLaunchName[i] = vb->oid[idx++];
    }
    smLaunchEntry->_smLaunchNameLength = len;
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_smLaunchEntry(guint32 *base, guchar *smLaunchOwner, guint16 _smLaunchOwnerLength, guchar *smLaunchName, guint16 _smLaunchNameLength)
{
    guint8 idx = 12;
    guint16 i, len;

    len = _smLaunchOwnerLength;
    base[idx++] = len;
    if (len > 32) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = smLaunchOwner[i];
        if (idx >= 128) return -1;
    }
    len = _smLaunchNameLength;
    base[idx++] = len;
    if (len < 1 || len > 32) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = smLaunchName[i];
        if (idx >= 128) return -1;
    }
    return idx;
}

static inline disman_script_mib_smLaunchEntry_t *
assign_smLaunchEntry(GList *vbl)
{
    disman_script_mib_smLaunchEntry_t *smLaunchEntry;
    char *p;

    smLaunchEntry = disman_script_mib_new_smLaunchEntry();
    p = (char *) smLaunchEntry + sizeof(disman_script_mib_smLaunchEntry_t);
    * (GList **) p = vbl;

    if (unpack_smLaunchEntry((GNetSnmpVarBind *) vbl->data, smLaunchEntry) < 0) {
        g_warning("%s: invalid instance identifier", "smLaunchEntry");
        g_free(smLaunchEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, smLaunchEntry_oid, G_N_ELEMENTS(smLaunchEntry_oid),
                      smLaunchEntry_attr, smLaunchEntry);

    return smLaunchEntry;
}

void
disman_script_mib_get_smLaunchTable(GNetSnmp *s, disman_script_mib_smLaunchEntry_t ***smLaunchEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 64, 1, 4, 1, 1, 0};
    guint32 base[128];

    *smLaunchEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 12, 11, smLaunchEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *smLaunchEntry = (disman_script_mib_smLaunchEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(disman_script_mib_smLaunchEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*smLaunchEntry)[i] = assign_smLaunchEntry(row->data);
        }
    }
}

void
disman_script_mib_get_smLaunchEntry(GNetSnmp *s, disman_script_mib_smLaunchEntry_t **smLaunchEntry, guchar *smLaunchOwner, guint16 _smLaunchOwnerLength, guchar *smLaunchName, guint16 _smLaunchNameLength, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, smLaunchEntry_oid, sizeof(smLaunchEntry_oid));
    len = pack_smLaunchEntry(base, smLaunchOwner, _smLaunchOwnerLength, smLaunchName, _smLaunchNameLength);
    if (len < 0) {
        g_warning("%s: invalid index values", "smLaunchEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *smLaunchEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 11, smLaunchEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *smLaunchEntry = assign_smLaunchEntry(out);
    }
}

void
disman_script_mib_set_smLaunchEntry(GNetSnmp *s, disman_script_mib_smLaunchEntry_t *smLaunchEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, smLaunchEntry_oid, sizeof(smLaunchEntry_oid));
    len = pack_smLaunchEntry(base, smLaunchEntry->smLaunchOwner, smLaunchEntry->_smLaunchOwnerLength, smLaunchEntry->smLaunchName, smLaunchEntry->_smLaunchNameLength);
    if (len < 0) {
        g_warning("%s: invalid index values", "smLaunchEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 11, smLaunchEntry_attr, mask, smLaunchEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
disman_script_mib_free_smLaunchEntry(disman_script_mib_smLaunchEntry_t *smLaunchEntry)
{
    GList *vbl;
    char *p;

    if (smLaunchEntry) {
        p = (char *) smLaunchEntry + sizeof(disman_script_mib_smLaunchEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(smLaunchEntry);
    }
}

void
disman_script_mib_free_smLaunchTable(disman_script_mib_smLaunchEntry_t **smLaunchEntry)
{
    int i;

    if (smLaunchEntry) {
        for (i = 0; smLaunchEntry[i]; i++) {
            disman_script_mib_free_smLaunchEntry(smLaunchEntry[i]);
        }
        g_free(smLaunchEntry);
    }
}

disman_script_mib_smRunEntry_t *
disman_script_mib_new_smRunEntry()
{
    disman_script_mib_smRunEntry_t *smRunEntry;

    smRunEntry = (disman_script_mib_smRunEntry_t *) g_malloc0(sizeof(disman_script_mib_smRunEntry_t) + sizeof(gpointer));
    return smRunEntry;
}

static inline int
unpack_smRunEntry(GNetSnmpVarBind *vb, disman_script_mib_smRunEntry_t *smRunEntry)
{
    guint8 idx = 12;
    guint16 i, len;

    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len > 32) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        smRunEntry->smLaunchOwner[i] = vb->oid[idx++];
    }
    smRunEntry->_smLaunchOwnerLength = len;
    if (vb->oid_len < idx) return -1;
    len = vb->oid[idx++];
    if (len < 1 || len > 32) return -1;
    if (vb->oid_len < idx + len) return -1;
    for (i = 0; i < len; i++) {
        smRunEntry->smLaunchName[i] = vb->oid[idx++];
    }
    smRunEntry->_smLaunchNameLength = len;
    if (vb->oid_len < idx) return -1;
    smRunEntry->smRunIndex = vb->oid[idx++];
    if ((smRunEntry->smRunIndex < 1)) {
         return -1;
    }
    if (vb->oid_len > idx) return -1;
    return 0;
}

static inline gint8
pack_smRunEntry(guint32 *base, guchar *smLaunchOwner, guint16 _smLaunchOwnerLength, guchar *smLaunchName, guint16 _smLaunchNameLength, gint32 smRunIndex)
{
    guint8 idx = 12;
    guint16 i, len;

    len = _smLaunchOwnerLength;
    base[idx++] = len;
    if (len > 32) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = smLaunchOwner[i];
        if (idx >= 128) return -1;
    }
    len = _smLaunchNameLength;
    base[idx++] = len;
    if (len < 1 || len > 32) return -1;
    for (i = 0; i < len; i++) {
        base[idx++] = smLaunchName[i];
        if (idx >= 128) return -1;
    }
    base[idx++] = smRunIndex;
    return idx;
}

static inline disman_script_mib_smRunEntry_t *
assign_smRunEntry(GList *vbl)
{
    disman_script_mib_smRunEntry_t *smRunEntry;
    char *p;

    smRunEntry = disman_script_mib_new_smRunEntry();
    p = (char *) smRunEntry + sizeof(disman_script_mib_smRunEntry_t);
    * (GList **) p = vbl;

    if (unpack_smRunEntry((GNetSnmpVarBind *) vbl->data, smRunEntry) < 0) {
        g_warning("%s: invalid instance identifier", "smRunEntry");
        g_free(smRunEntry);
        return NULL;
    }

    gnet_snmp_attr_assign(vbl, smRunEntry_oid, G_N_ELEMENTS(smRunEntry_oid),
                      smRunEntry_attr, smRunEntry);

    return smRunEntry;
}

void
disman_script_mib_get_smRunTable(GNetSnmp *s, disman_script_mib_smRunEntry_t ***smRunEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    GList *row;
    int i;
    static guint32 const _base[] = {1, 3, 6, 1, 2, 1, 64, 1, 4, 2, 1, 0};
    guint32 base[128];

    *smRunEntry = NULL;
    memcpy(base, _base, sizeof(_base));

    gnet_snmp_attr_get(s, &in, base, 12, 11, smRunEntry_attr, mask);

    out = gnet_snmp_sync_table(s, in, error);
    /* gnet_snmp_varbind_list_free(in); */

    if (out) {
        *smRunEntry = (disman_script_mib_smRunEntry_t **) g_malloc0((g_list_length(out) + 1) * sizeof(disman_script_mib_smRunEntry_t *));
        for (row = out, i = 0; row; row = g_list_next(row), i++) {
            (*smRunEntry)[i] = assign_smRunEntry(row->data);
        }
    }
}

void
disman_script_mib_get_smRunEntry(GNetSnmp *s, disman_script_mib_smRunEntry_t **smRunEntry, guchar *smLaunchOwner, guint16 _smLaunchOwnerLength, guchar *smLaunchName, guint16 _smLaunchNameLength, gint32 smRunIndex, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, smRunEntry_oid, sizeof(smRunEntry_oid));
    len = pack_smRunEntry(base, smLaunchOwner, _smLaunchOwnerLength, smLaunchName, _smLaunchNameLength, smRunIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "smRunEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    *smRunEntry = NULL;

    gnet_snmp_attr_get(s, &in, base, len, 11, smRunEntry_attr, mask);

    out = gnet_snmp_sync_get(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        if (s->error_status != GNET_SNMP_PDU_ERR_NOERROR) {
            g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
            g_list_free(out);
            return;
        }
        *smRunEntry = assign_smRunEntry(out);
    }
}

void
disman_script_mib_set_smRunEntry(GNetSnmp *s, disman_script_mib_smRunEntry_t *smRunEntry, gint64 mask, GError **error)
{
    GList *in = NULL, *out = NULL;
    guint32 base[128];
    gint8 len;

    memcpy(base, smRunEntry_oid, sizeof(smRunEntry_oid));
    len = pack_smRunEntry(base, smRunEntry->smLaunchOwner, smRunEntry->_smLaunchOwnerLength, smRunEntry->smLaunchName, smRunEntry->_smLaunchNameLength, smRunEntry->smRunIndex);
    if (len < 0) {
        g_warning("%s: invalid index values", "smRunEntry");
        s->error_status = GNET_SNMP_PDU_ERR_INTERNAL;
        return;
    }

    gnet_snmp_attr_set(s, &in, base, len, 11, smRunEntry_attr, mask, smRunEntry);

    out = gnet_snmp_sync_set(s, in, error);
    g_list_foreach(in, (GFunc) gnet_snmp_varbind_delete, NULL);
    g_list_free(in);
    if (out) {
        g_list_foreach(out, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(out);
    }
}

void
disman_script_mib_free_smRunEntry(disman_script_mib_smRunEntry_t *smRunEntry)
{
    GList *vbl;
    char *p;

    if (smRunEntry) {
        p = (char *) smRunEntry + sizeof(disman_script_mib_smRunEntry_t);
        vbl = * (GList **) p;
        g_list_foreach(vbl, (GFunc) gnet_snmp_varbind_delete, NULL);
        g_list_free(vbl);
        g_free(smRunEntry);
    }
}

void
disman_script_mib_free_smRunTable(disman_script_mib_smRunEntry_t **smRunEntry)
{
    int i;

    if (smRunEntry) {
        for (i = 0; smRunEntry[i]; i++) {
            disman_script_mib_free_smRunEntry(smRunEntry[i]);
        }
        g_free(smRunEntry);
    }
}


