/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : sagcad
 *    Description          : CAD/CAM
 *    Source               : sgy.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2002/09/10
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __SGY_H__
#define __SGY_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _SGY_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _SGY_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
int sgyFileSave(char *SaveFileName);
int tables_write(FILE *stream);
int trace_write(FILE *stream);
int trace_data_write(FILE *stream, CAD_LIST *p);
int dimension_write(FILE *stream);
int dimension_data_write(FILE *stream, DIMENSION_LIST *p);
int ellipse_write(FILE *stream);
int ellipse_data_write(FILE *stream, ELLIPSE_LIST *p);
int PolyLine_write(FILE *stream);
int PolyLine_data_write(FILE *stream, POLYLINE_LIST *p);
int eof_write(FILE *stream);


int sgyFileOpen(char *OpenFileName);
int sgyTableSectionRead(FILE *stream);
int sgyTraceSectionRead(FILE *stream, int Version);
int sgyDimensionSectionRead(FILE *stream, int Version);
int TraceLook(char *str, CAD *a, int Version);
long QBtoRGB(int QB_color);
int DimensionLook(char *str, DIMENSION *a, FILE *stream, int Version);
int FileCheck(char *FileName);
int DimensionVer1(char *str, DIMENSION *a);
int DimensionVer2(char *str, DIMENSION *a);
int DimensionVer3(char *str, DIMENSION *a);
int DimensionVer4(char *str, DIMENSION *a, FILE *stream);

int sgyEllipseSectionRead(FILE *stream, int Version);
int EllipseLook(char *str, ELLIPSE *a, int Version);

int sgyPolyLineSectionRead(FILE *stream, int Version);
int PolyLineLook(char *str, POLYLINE *a, FILE *stream, int Version);


/* クリップファイルに文字列をコピー */
int WriteClipFile(void);
/* クリップファイルから文字列の取得 */
int ReadClipFile(void);
/* 部品図読み込み File名 取得 */
int ReadPartsFileNameGet(char *OpenFileName, double x, double y);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __SGY_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : sagcad
 *    Source               : sgy.h
 * ====================================================================
 */
