#!/usr/bin/python
# -*-coding: UTF-8 -*-
# bbou@ac-toulouse.fr
# GPL license
# 2005-08-09 19:07:31 
# sharesparser.py

import string
import re

#######################################################################
#	GLOBALS
#######################################################################

sysSetting={
	'testparm':'testparm -vs 2> /dev/null',

	'exists':'sh -c \'if [ -e "%FSOBJECT%" ]; then echo true; else echo false; fi\'',
	'getOwnerGroup':"stat -c '%U:%G' \"%FSOBJECT%\"",
	'getDirMode':"ls -dl \"%FSOBJECT%\" | cut -f 1 -d ' '",
}

#######################################################################
#	SHARE
#######################################################################

class Share:

	def printShare(self):
		print '\t#name=%s' % self.name
		print '\t#exists=%s' % self.pathExists
		if hasattr(self,'fsOwnerGroup'):
			print '\t#fsowner=%s.%s' % (self.fsOwnerGroup[0],self.fsOwnerGroup[1])
		if hasattr(self,'fsPerms'):
			print '\t#fsperms=%s' % self.fsPerms
		for p in self.props:
			print '\t%s = %s' % (p,self.props[p])
	pass

#######################################################################
#	SHARES
#######################################################################

class SharesParser:
	
	def __init__(self,runner):
		self.runner=runner;
		self.shares={}
		return

	# helpers

	def addShare(self,shares,sharename,share):
		if 'homes'==sharename:
			#share.props['path']='/home/%U'
			share.props['path']='<home>'
		# fsobject
		share.pathExists=False
		fsobject=share.props['path']
		if self.exists(fsobject):
			share.pathExists=True
			share.fsOwnerGroup=self.getOwnerGroup(fsobject)
			share.fsPerms=self.getMode(fsobject)
		shares[sharename]=share
		return

	def parse(self,output):
		shares={}
		lines=output.splitlines()
		sharename=None
		share=None
		for line in lines:
			# garbage line
			if re.match('^$',line):
				continue
			# section header line
			if re.match('^\[.*\]$',line):
				# terminate current share
				if share!=None:
					self.addShare(shares,sharename,share)
				share=None
				sharename=None
				# discard global and printers section
				if re.match('^\[global\]$',line) or re.match('^\[printers\]$',line):
					continue
				# start share
				sharename=line.lstrip('[').rstrip(']')											
				share=Share()
				share.name=sharename
				share.props=dict()
				continue
			# property line
			if sharename!=None:
				prop=line.split('=')
				name=prop[0].strip()
				value=prop[1].strip()
				share.props[name]=value
		# close open section			
		if share!=None:
			self.addShare(shares,sharename,share)

        	return shares

	def clip(self,lines,share):
		begin,end=(-1,-1)
		i=0
		for line in lines:
			if re.match('^\['+share+'\]$',line):
				begin=i
			elif begin!=-1 and end==-1 and re.match('^\[.*\]$',line):
				end=i
			i=i+1
					
		if begin!=-1 and end==-1:
			end=i

		# do not include comments or empty lines
		if begin!=-1 and end!=-1:
			for i in range(end-1,begin,-1):
				if re.match('^$',lines[i]) or re.match('^#',lines[i]) or re.match('^;',lines[i]):
					end=i
				else:
					break					
		return begin,end

	# debug

	def printShares(self,shares):
		for k in shares.keys():
			shares[k].printShare()

	def printConf(self,lines):
		for line in lines:
			print line,
		return

	#######################################################################
	#	HELPERS
	#######################################################################
	
	def runToString(self,cl):
		status,output=self.runner.runToString(cl)
		return status,output

	def getConf(self):
		cl=sysSetting['testparm']
		status,output=self.runToString(cl)
		if status:
			return output
		return ''

	def exists(self,path):
		cl=sysSetting['exists']
		cl=cl.replace('%FSOBJECT%',path)
		status,output=self.runToString(cl)
		if not status:
			return False
		output=output.strip('\n\r ')
		return output=='true'

	def getOwnerGroup(self,fsobject):
		cl=sysSetting['getOwnerGroup']
		cl=cl.replace('%FSOBJECT%',fsobject)
		status,output=self.runToString(cl)
		if not status:
			return None,None
		output=output.strip('\n\r ')
		return output.split(":")
	
	def getMode(self,fsobject):
		cl=sysSetting['getDirMode']
		cl=cl.replace('%FSOBJECT%',fsobject)
		status,output=self.runToString(cl)
		if not status:
			return None
		return output[1:10]

#######################################################################
#	MAIN
#######################################################################

import sys
import os
import runner

if __name__ == "__main__":
	e=sys.argv[0]
	e=os.path.realpath(e)
	d=os.path.dirname(e)
	os.chdir(d)
	p=SharesParser(runner.BasicRunner())
	conf=p.getConf()
	shares=p.parse(conf)
	for s in shares.keys():
		print '[%s]' % s
		shares[s].printShare()

__author__='Bernard Bou <bou@ac-toulouse.fr>'
