/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.sablecc.sablecc.AcceptStates;
import org.sablecc.sablecc.ConstructNFA;
import org.sablecc.sablecc.DFA;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.NFA;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.Transitions;
import org.sablecc.sablecc.analysis.AnalysisAdapter;
import org.sablecc.sablecc.node.Node;
import org.sablecc.sablecc.node.Start;

public class GenLexer
extends AnalysisAdapter {
    private MacroExpander macros;
    private ResolveIds ids;
    private File pkgDir;
    private String pkgName;
    private AcceptStates[] acceptStatesArray;
    private Transitions transitions;

    public GenLexer(ResolveIds resolveIds) {
        this.ids = resolveIds;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("lexer.txt")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to open lexer.txt.");
        }
        this.pkgDir = new File(resolveIds.pkgDir, "lexer");
        String string = this.pkgName = resolveIds.pkgName.equals("") ? "lexer" : resolveIds.pkgName + ".lexer";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    public void caseStart(Start start) {
        int n = Math.max(1, this.ids.stateList.size());
        this.acceptStatesArray = new AcceptStates[n];
        String[] stringArray = new String[n];
        if (this.ids.stateList.size() == 0) {
            stringArray[0] = "INITIAL";
        } else {
            Iterator iterator = this.ids.stateList.iterator();
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)iterator.next();
            }
        }
        for (int i = 0; i < n; ++i) {
            System.out.println(" State: " + stringArray[i]);
            System.out.println(" - Constructing NFA.");
            ConstructNFA constructNFA = new ConstructNFA(this.ids, stringArray[i]);
            start.apply(constructNFA);
            System.out.println();
            NFA nFA = (NFA)constructNFA.getOut(start);
            constructNFA = null;
            System.out.println(" - Constructing DFA.");
            DFA dFA = new DFA(nFA);
            System.out.println();
            System.out.println(" - resolving ACCEPT states.");
            this.acceptStatesArray[i] = new AcceptStates(dFA, this.ids, stringArray[i]);
            start.apply(this.acceptStatesArray[i]);
        }
        this.transitions = new Transitions();
        start.apply(this.transitions);
        this.createLexerException();
        this.createLexer();
    }

    private void createLexerException() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "LexerException.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "LexerException.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "LexerException", new String[]{this.pkgName});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "LexerException.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createLexer() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Lexer.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Lexer.java").getAbsolutePath());
        }
        try {
            Object object;
            int n;
            Object object2;
            boolean bl;
            Cloneable cloneable;
            String string;
            String string2 = "INITIAL";
            if (this.ids.stateList.size() > 0) {
                string2 = (String)this.ids.stateList.getFirst();
            }
            this.macros.apply(bufferedWriter, "LexerHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : this.ids.pkgName + ".node", string2});
            Object object3 = this.ids.tokenList.listIterator();
            while (object3.hasNext()) {
                string = (String)object3.next();
                cloneable = (Node)this.ids.tokens.get(string);
                bl = (Boolean)this.ids.fixedTokens.get(cloneable);
                if (bl) {
                    this.macros.apply(bufferedWriter, "LexerFixedToken", new String[]{"" + object3.previousIndex(), string});
                } else {
                    this.macros.apply(bufferedWriter, "LexerVariableToken", new String[]{"" + object3.previousIndex(), string});
                }
                object2 = (Map)this.transitions.tokenStates.get(cloneable);
                if (object2.size() > 0) {
                    this.macros.apply(bufferedWriter, "TokenSwitchHeader", null);
                    for (Map.Entry enumeration : object2.entrySet()) {
                        this.macros.apply(bufferedWriter, "TokenCase", new String[]{this.ids.stateList.indexOf((String)enumeration.getKey()) + "", (String)enumeration.getValue()});
                    }
                    this.macros.apply(bufferedWriter, "TokenSwitchTail", null);
                }
                this.macros.apply(bufferedWriter, "LexerTokenTail", null);
            }
            this.macros.apply(bufferedWriter, "LexerBody1");
            object3 = this.ids.tokenList.listIterator();
            while (object3.hasNext()) {
                string = (String)object3.next();
                cloneable = (Node)this.ids.tokens.get(string);
                bl = (Boolean)this.ids.fixedTokens.get(cloneable);
                if (bl) {
                    this.macros.apply(bufferedWriter, "LexerNewFixedToken", new String[]{"" + object3.previousIndex(), string});
                    continue;
                }
                this.macros.apply(bufferedWriter, "LexerNewVariableToken", new String[]{"" + object3.previousIndex(), string});
            }
            this.macros.apply(bufferedWriter, "LexerBody2");
            object3 = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.pkgDir, "lexer.dat"))));
            ((DataOutputStream)object3).writeInt(this.acceptStatesArray.length);
            for (n = 0; n < this.acceptStatesArray.length; ++n) {
                cloneable = this.acceptStatesArray[n].dfa;
                bufferedWriter.write("        { // " + this.acceptStatesArray[n].stateName + System.getProperty("line.separator"));
                Vector<Object> vector = new Vector<Object>();
                for (int i = 0; i < ((DFA)((Object)cloneable)).states.size(); ++i) {
                    object = new Vector();
                    DFA.State n2 = (DFA.State)((DFA)((Object)cloneable)).states.elementAt(i);
                    bufferedWriter.write("            {");
                    for (int j = 0; j < n2.transitions.size(); ++j) {
                        DFA.Transition transition = (DFA.Transition)n2.transitions.elementAt(j);
                        bufferedWriter.write("{" + transition.interval().start + ", " + transition.interval().end + ", " + transition.destination + "}, ");
                        ((Vector)object).addElement(new int[]{transition.interval().start, transition.interval().end, transition.destination});
                    }
                    bufferedWriter.write("}," + System.getProperty("line.separator"));
                    vector.addElement(object);
                }
                bufferedWriter.write("        }" + System.getProperty("line.separator"));
                ((DataOutputStream)object3).writeInt(vector.size());
                object2 = vector.elements();
                while (object2.hasMoreElements()) {
                    object = (Vector)object2.nextElement();
                    ((DataOutputStream)object3).writeInt(((Vector)object).size());
                    Enumeration enumeration = ((Vector)object).elements();
                    while (enumeration.hasMoreElements()) {
                        int[] nArray = (int[])enumeration.nextElement();
                        for (int i = 0; i < 3; ++i) {
                            ((DataOutputStream)object3).writeInt(nArray[i]);
                        }
                    }
                }
            }
            this.macros.apply(bufferedWriter, "LexerAcceptHeader");
            n = this.acceptStatesArray.length;
            cloneable = new Vector<Object>();
            for (int i = 0; i < n; ++i) {
                object2 = this.acceptStatesArray[i].dfa;
                object = new Vector();
                bufferedWriter.write("        // " + this.acceptStatesArray[i].stateName + System.getProperty("line.separator"));
                bufferedWriter.write("        {");
                for (int j = 0; j < ((DFA)object2).states.size(); ++j) {
                    DFA.State state = (DFA.State)((DFA)object2).states.elementAt(j);
                    bufferedWriter.write(state.accept + ", ");
                    ((Vector)object).addElement(new Integer(state.accept));
                }
                bufferedWriter.write("}," + System.getProperty("line.separator"));
                cloneable.addElement(object);
            }
            ((DataOutputStream)object3).writeInt(cloneable.size());
            Object object4 = cloneable.elements();
            while (object4.hasMoreElements()) {
                object2 = (Vector)object4.nextElement();
                ((DataOutputStream)object3).writeInt(((Vector)object2).size());
                object = ((Vector)object2).elements();
                while (object.hasMoreElements()) {
                    Integer n2 = (Integer)object.nextElement();
                    ((DataOutputStream)object3).writeInt(n2);
                }
            }
            ((FilterOutputStream)object3).close();
            bufferedWriter.write(System.getProperty("line.separator"));
            this.macros.apply(bufferedWriter, "LexerAcceptTail");
            this.macros.apply(bufferedWriter, "LexerStateHeader");
            if (this.ids.stateList.size() > 0) {
                object4 = this.ids.stateList.listIterator();
                while (object4.hasNext()) {
                    object2 = (String)object4.next();
                    this.macros.apply(bufferedWriter, "LexerStateBody", new String[]{object2, "" + object4.previousIndex()});
                }
            } else {
                this.macros.apply(bufferedWriter, "LexerStateBody", new String[]{"INITIAL", "0"});
            }
            this.macros.apply(bufferedWriter, "LexerStateTail");
            this.macros.apply(bufferedWriter, "LexerTail");
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Lexer.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

