require 'active_record'
require 'active_support/ordered_hash'

class Joiner::Joins
  attr_reader :model

  def initialize(model)
    @model       = model
    @joins_cache = Set.new
  end

  def add_join_to(path)
    return if path.empty?

    joins_cache.add path_as_hash(path)
  end

  def alias_for(path)
    return model.table_name if path.empty?

    add_join_to path
    association_for(path).tables.first.name
  end

  def join_values
    if Joiner::JoinDependency.instance_method(:initialize).arity == 3
      # ActiveRecord 5.2.1+
      Joiner::JoinDependency.new model, table, joins_cache.to_a
    else
      # ActiveRecord 5.2.0
      Joiner::JoinDependency.new model, table, joins_cache.to_a, alias_tracker
    end
  end

  private

  attr_reader :joins_cache

  def alias_tracker
    ActiveRecord::Associations::AliasTracker.create(
      model.connection, table.name, []
    )
  end

  def association_for(path)
    if Joiner::JoinDependency.instance_method(:initialize).arity == 3
      # ActiveRecord 5.2.1+
      join_values.join_association_for path, alias_tracker
    else
      # ActiveRecord 5.2.0
      join_values.join_association_for path
    end
  end

  def path_as_hash(path)
    path[0..-2].reverse.inject(path.last) { |key, item| {item => key} }
  end

  def table
    @table ||= model.arel_table
  end
end
