---
layout: post
title: Polyglot 1.2.0
lang: en
---

A new version of Polyglot has been released! Give it a try!

{% highlight yaml %}
gem install jekyll-polyglot
{% endhighlight %}

and list `jekyll-polyglot` among your listed gems in your `_config.yml`

It involves mostly groundwork to prepare for new features and better multilingual content management. It does have a new feature:

## {% raw %} {% I18n_Headers %} {% endraw %}

Put this tag with the [url of your website](https://github.com/untra/polyglot/blob/site/_includes/head.html#L6) in your `head.html` includes file to get the maximum SEO provided by having a multilingual website. It's the same as the following liquid code:

{% highlight html %}{% raw %}
<meta http-equiv="Content-Language" content="{{site.active_lang}}">
<link rel="alternate"
      hreflang="{{site.default_lang}}"
      href="http://yoursite.com{{page.permalink}}" />
{% for lang in site.languages %}
{% if lang == site.default_lang %}
  {% continue %}
{% endif %}
<link rel="alternate"
    hreflang="{{lang}}"
    href="http://yoursite.com/{{lang}}{{page.permalink}}" />
{% endfor %}
{% endraw %}
{% endhighlight %}

In your header, but faster and cleaner! For more information, see [the SEO page](/seo)
